/*****************************************************************************\
  dj3320_cmap.cpp : Implimentation for the DJ3600 color maps

  Copyright (c) 1996 - 2003, Hewlett-Packard Co.
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. Neither the name of Hewlett-Packard nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
  NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
  TO, PATENT INFRINGEMENT; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  \***************************************************************************/


#ifdef APDK_DJ3600

#include "config.h"

#include "global_types.h"

APDK_BEGIN_NAMESPACE

// 600x600x1, KCMY - Plain Normal, MLC Both

uint32_t ulMapDJ3600_KCMY_6x6x1[ 9 * 9 * 9 ] =
{
3503343871UL, 2379407530UL, 1338176353UL,  698938928UL,  446166815UL,  311162901UL, 
 193132557UL,   91879429UL,    7403520UL, 3999964546UL, 2759781530UL, 1235874648UL, 
 631371308UL,  429258525UL,  294320148UL,  176289804UL,   74971140UL,    7141376UL, 
3996614467UL, 3695036491UL, 1732834647UL,  744355636UL,  376502042UL,  242546704UL, 
 141686793UL,   57407491UL,    6420480UL, 3961749547UL, 3945178158UL, 3173837109UL, 
1093532471UL,  505608740UL,  239335697UL,   71891205UL,   38531842UL,    4777472UL, 
3961028126UL, 3944322079UL, 3759852831UL, 2434527520UL,  706345758UL,  387447579UL, 
 152958987UL,   69723652UL,    2345472UL, 3960568341UL, 3960572437UL, 3893476373UL, 
3289377554UL, 1594816272UL,  420478481UL,  252706066UL,   67433989UL,      50176UL, 
3960173838UL, 3960242702UL, 3909856269UL, 3607616520UL, 2349264135UL, 1023866375UL, 
 269089547UL,  101120007UL,      50176UL, 3959844615UL, 3943070215UL, 3926236166UL, 
3775055107UL, 2785266179UL, 1493421316UL,  654560772UL,  168089349UL,      50944UL, 
3942676480UL, 3892345344UL, 3724574720UL, 3405809920UL, 2684391936UL, 1728092672UL, 
 989896448UL,  419472640UL,      41984UL, 3938409846UL, 1777809479UL,  719700274UL, 
 265413906UL,  113242887UL,   78312964UL,   26474241UL,   42465026UL,    7597568UL, 
4099756906UL, 3130956215UL, 1570223961UL,  428925723UL,  159509771UL,   41151746UL, 
   6743040UL,    6215936UL,    6018560UL, 4029963327UL, 3644760395UL, 1782421067UL, 
 575062561UL,  257082638UL,   89245445UL,    5162752UL,    5162752UL,    5624576UL, 
3995102759UL, 3894320676UL, 2652743204UL,  975619374UL,  370263572UL,  153272840UL, 
  36422146UL,    3260672UL,    4049664UL, 3977670940UL, 3859972117UL, 3188485391UL, 
1779476755UL,  638694420UL,  285979662UL,   84128516UL,     368128UL,    1485824UL, 
3960434963UL, 3825888268UL, 3305592585UL, 2315745034UL, 1242012169UL,  453550859UL, 
 201761544UL,   33657602UL,      38656UL, 3960106252UL, 3758447622UL, 3322169094UL, 
2718127620UL, 1711501317UL,  906197252UL,  302287366UL,  100897027UL,      38656UL, 
3959777286UL, 3657518081UL, 3355523073UL, 2734764801UL, 2013350401UL, 1258379777UL, 
 587291137UL,  167863553UL,      40704UL, 3825228288UL, 3556784896UL, 3439344384UL, 
3053467392UL, 2248162048UL, 1493191424UL,  855657984UL,  369118976UL,      17920UL, 
3921752382UL, 3102352688UL,  670965543UL,  149451274UL,  147700489UL,   96322565UL, 
  60541443UL,   42256898UL,    7258112UL, 3985386811UL, 3702734672UL, 1538472522UL, 
 330521618UL,   10190080UL,    8687360UL,    7445504UL,    6529536UL,    6075392UL, 
4231344960UL, 3157142584UL, 1545279776UL,  943204887UL,  205414664UL,   20805889UL, 
   3964160UL,    4032000UL,    3837696UL, 4045286692UL, 3894363174UL, 2467113488UL, 
 973409798UL,  369441287UL,  118703875UL,    1724672UL,    2450944UL,    3113472UL, 
4011019287UL, 3859893269UL, 3171563020UL, 1459887621UL,  537207045UL,  235091204UL, 
  67188481UL,      19968UL,    1077504UL, 3977074448UL, 3809102860UL, 3020168197UL, 
1560282369UL,  922816514UL,  335614466UL,  134288641UL,   33632769UL,      20736UL, 
3976747530UL, 3724821765UL, 2885750530UL, 1744830464UL, 1056964608UL,  587202560UL, 
 184549376UL,   83893249UL,      11520UL, 3959642372UL, 3590337024UL, 2684354560UL, 
1946157056UL, 1325400064UL,  822083584UL,  419430400UL,  117440512UL,      13312UL, 
3707780608UL, 3472891904UL, 2717908992UL, 2130706432UL, 1560281088UL, 1040187392UL, 
 603979776UL,  285213184UL,          0UL, 3921681442UL, 3638301978UL, 1207570452UL, 
 251399441UL,  165093385UL,  112809990UL,   77490948UL,   42365442UL,    7170048UL, 
3953203487UL, 3719895071UL, 1488459293UL,  331156752UL,   44895746UL,    9254656UL, 
   7818496UL,    6838016UL,    6250496UL, 4031061542UL, 3729530664UL, 2100235536UL, 
 925305099UL,  206570244UL,    5311232UL,    5186304UL,    4994816UL,    4737024UL, 
4246740775UL, 3626312750UL, 1946683146UL,  838860800UL,  587202560UL,   67502080UL, 
   1050624UL,    1448704UL,    1782784UL, 4078113303UL, 3826389270UL, 2986936587UL, 
1459617792UL,  654311424UL,  201326592UL,   33554432UL,       2304UL,     599296UL, 
4027262733UL, 3758691083UL, 2936275973UL, 1761607680UL,  989855744UL,  385875968UL, 
 100663296UL,   16777216UL,       3840UL, 4010227975UL, 3624146437UL, 2936078594UL, 
1845493760UL, 1174405120UL,  704643072UL,  218103808UL,   50331648UL,          0UL, 
3842191108UL, 3456174337UL, 2868903936UL, 2030043136UL, 1358954496UL,  973078528UL, 
 520093696UL,  117440512UL,          0UL, 3439331584UL, 3305111552UL, 2885681152UL, 
2231369728UL, 1610612736UL, 1241513984UL,  771751936UL,  335544320UL,          0UL, 
3921285141UL, 3755084815UL, 2230520075UL,  351997200UL,  166266890UL,  147064327UL, 
  94702084UL,   42409730UL,    7546624UL, 3936620050UL, 3652061708UL, 2125990413UL, 
 448465936UL,   44892418UL,    8847360UL,    7864320UL,    7081984UL,    6692352UL, 
3998551827UL, 3629387282UL, 2016741128UL,  791741960UL,  205259267UL,    4325376UL, 
   4718592UL,    4980736UL,    5051136UL, 4111667992UL, 3406893334UL, 2130903812UL, 
1056964608UL,  570425344UL,   67108864UL,     458752UL,    1638400UL,    2293760UL, 
3977581594UL, 3608351512UL, 2768700937UL, 1208091139UL,  603979776UL,  335544320UL, 
  33554432UL,   33554432UL,          0UL, 3993766927UL, 3658091020UL, 2835612420UL, 
1694564609UL,  922746880UL,  402653184UL,   83886080UL,          0UL,          0UL, 
3859220233UL, 3523544070UL, 2785083649UL, 1694498816UL, 1107296256UL,  654311424UL, 
 167772160UL,   33554432UL,          0UL, 3607298820UL, 3389063425UL, 2734686208UL, 
1895825408UL, 1207959552UL,  855638016UL,  486539264UL,   83886080UL,          0UL, 
3321888768UL, 3154116608UL, 2701131776UL, 2097152000UL, 1375731712UL, 1107296256UL, 
 754974720UL,  385875968UL,          0UL, 3921087246UL, 3838511114UL, 3052143621UL, 
 904922117UL,  198969611UL,  114099206UL,   94241540UL,   58786306UL,    7405568UL, 
3936356363UL, 3584165384UL, 2427192583UL,  917636102UL,   94962435UL,    9109504UL, 
   7208960UL,    6291456UL,    6029312UL, 3965519882UL, 3528590599UL, 1932591619UL, 
1094189829UL,  238158596UL,    3276800UL,    3342336UL,    3670016UL,    4325376UL, 
4028107276UL, 3339192074UL, 1929379841UL, 1040187392UL,  452984832UL,   83886080UL, 
         0UL,     458752UL,    1572864UL, 4111273232UL, 3591047949UL, 2600665861UL, 
1157627904UL,  704643072UL,  352321536UL,   67108864UL,          0UL,          0UL, 
3372878091UL, 3658091020UL, 3003253251UL, 1510015234UL,  855703809UL,  385875968UL, 
 184549376UL,          0UL,          0UL, 3439724039UL, 3372549125UL, 2701197570UL, 
1744830465UL, 1157627904UL,  654311424UL,  234881024UL,   33554432UL,          0UL, 
3254911491UL, 3221291266UL, 2617245696UL, 1828716544UL, 1207959552UL,  771751936UL, 
 503316480UL,   83886080UL,          0UL, 2986344448UL, 2835349504UL, 2415919104UL, 
1946157056UL, 1358954496UL,  872415232UL,  704643072UL,  419430400UL,          0UL, 
3920693001UL, 3888448518UL, 3285910019UL, 1658323715UL,  416481795UL,   63504899UL, 
  95748868UL,   58917122UL,    6619136UL, 3936158982UL, 3600548355UL, 2627404290UL, 
1352663297UL,  362349059UL,    8847360UL,    7274496UL,    5570560UL,    4980736UL, 
3966042884UL, 3579708164UL, 2403533058UL, 1346109698UL,  472973570UL,   19333120UL, 
   2293760UL,    2555904UL,    2883584UL, 3978888197UL, 3221422852UL, 1828716544UL, 
1107296256UL,  620756992UL,  100663296UL,          0UL,          0UL,     327680UL, 
3691448073UL, 3020096259UL, 2013331713UL, 1174405120UL,  788529152UL,  335544320UL, 
  50331648UL,          0UL,          0UL, 4010280970UL, 3506832647UL, 2466316546UL, 
1342177281UL,  939524096UL,  503316480UL,  201326592UL,   16777216UL,          0UL, 
3909617417UL, 3288465922UL, 2415919105UL, 1560281088UL, 1157627904UL,  671088640UL, 
 218103808UL,  134217728UL,          0UL, 3103850753UL, 2902458369UL, 2382364672UL, 
1744830464UL, 1241513984UL,  805306368UL,  385875968UL,  117440512UL,          0UL, 
2600468480UL, 2466250752UL, 2231369728UL, 1795162112UL, 1342177280UL,  855638016UL, 
 520093696UL,  385875968UL,          0UL, 3920298756UL, 3904766466UL, 3318284546UL, 
1992753410UL,  968557058UL,  313786626UL,  111018756UL,   43254017UL,    7143424UL, 
3935895810UL, 3566206976UL, 2726690816UL, 1636237312UL,  780402688UL,  125042945UL, 
   6488064UL,    5111808UL,    4194304UL, 3915972866UL, 3546218496UL, 2571501568UL, 
1681522689UL,  809172993UL,  170524673UL,    1966080UL,    1572864UL,    1703936UL, 
3693740546UL, 3458203906UL, 2047148032UL, 1258291200UL,  855638016UL,  301989888UL, 
  16777216UL,          0UL,          0UL, 3506635523UL, 2885746945UL, 2030043136UL, 
1207959552UL,  754974720UL,  536870912UL,   83886080UL,          0UL,          0UL, 
3674407683UL, 3154182402UL, 2046886145UL, 1308622848UL,  872415232UL,  486539264UL, 
 201326592UL,   16777216UL,          0UL, 3254845697UL, 2617311233UL, 2030043136UL, 
1392508928UL, 1023410176UL,  620756992UL,  234881024UL,  117440512UL,          0UL, 
3657498882UL, 2868903936UL, 2097152000UL, 1577058304UL, 1241513984UL,  822083584UL, 
 369098752UL,   83886080UL,          0UL, 2197815296UL, 2113929216UL, 1912602624UL, 
1644167168UL, 1325400064UL,  855638016UL,  486539264UL,  268435456UL,          0UL, 
3920625664UL, 3769696256UL, 3283353600UL, 2342846464UL, 1553530880UL,  831389696UL, 
 411566080UL,  159383552UL,    7995392UL, 3767205888UL, 3431137280UL, 2793144320UL, 
1920270336UL, 1198587904UL,  526843904UL,  173277184UL,    4587520UL,    3932160UL, 
3596156928UL, 3428253696UL, 2655453184UL, 2134769664UL, 1178075136UL,  590020608UL, 
 135921664UL,    1179648UL,     720896UL, 3374186496UL, 3290103808UL, 2299592704UL, 
1610612736UL, 1291845632UL,  587202560UL,  218103808UL,          0UL,          0UL, 
3238002688UL, 3204448256UL, 2516582400UL, 1677721600UL, 1342177280UL,  989855744UL, 
 402653184UL,   33554432UL,          0UL, 2734686208UL, 2734686208UL, 2130706432UL, 
1342177280UL,  838860800UL,  654311424UL,  486539264UL,  117440512UL,          0UL, 
2298478592UL, 2264924160UL, 2080374784UL, 1426063360UL,  989855744UL,  536870912UL, 
 335544320UL,  201326592UL,          0UL, 2046820352UL, 2030043136UL, 1996488704UL, 
1644167168UL, 1023410176UL,  654311424UL,  285212672UL,  167772160UL,          0UL, 
1912602624UL, 1879048192UL, 1677721600UL, 1442840576UL, 1124073472UL,  771751936UL, 
 452984832UL,  218103808UL,          0UL,
};

// 600x600x1UL, ClMlxx - Plain NormalUL, MLC Both

uint32_t ulMapDJ3600_ClMlxx_6x6x1[ 9 * 9 * 9 ] =
{
         0UL,     591872UL,     393216UL,    1441792UL,    2097152UL,    2424832UL, 
   2818048UL,    3211264UL,    3604480UL,       2816UL,          0UL,    1179648UL, 
   1638400UL,    2162688UL,    2490368UL,    2883584UL,    3276800UL,    3735552UL, 
     13568UL,    1188608UL,          0UL,    3801088UL,    3538944UL,    3407872UL, 
   3538944UL,    3801088UL,    4194304UL,      16128UL,      10752UL,      66560UL, 
         0UL,    6029312UL,    5177344UL,    5177344UL,    5376256UL,    6168064UL, 
     17664UL,      14336UL,     202240UL,          0UL,        768UL,    4587520UL, 
   6881792UL,    7675392UL,    9195264UL,      19200UL,      16640UL,       7936UL, 
         0UL,          0UL,          0UL,    2752512UL,    7210496UL,   10314240UL, 
     20480UL,      18432UL,      11520UL,       1792UL,       3072UL,       2816UL, 
      2560UL,    1773312UL,    6912000UL,      22016UL,      19968UL,      14592UL, 
      9472UL,     153344UL,     158720UL,     230144UL,     226048UL,    2658560UL, 
     20736UL,      22272UL,      26880UL,      36608UL,      42240UL,      45312UL, 
     48128UL,      49664UL,      51456UL,     720896UL,          0UL,       7936UL, 
      2560UL,     459776UL,    1376768UL,    2228736UL,    2687488UL,    4002048UL, 
   2752512UL,    9208064UL,    6579968UL,    3482112UL,    3412480UL,    3936512UL, 
   4989184UL,    5911552UL,    6174976UL,      18176UL,    2312448UL,   10067968UL, 
   8019200UL,    7362560UL,    7165184UL,    7165184UL,    7230720UL,    6569472UL, 
     19200UL,     210688UL,    3639296UL,    3637504UL,    9264896UL,    9266176UL, 
   8741376UL,    8480000UL,    7949824UL,      19712UL,     152320UL,    3193600UL, 
   2334208UL,    2732032UL,    6393600UL,    9730560UL,   10192128UL,    9598976UL, 
     20736UL,     223232UL,    1620992UL,    2014976UL,    1619968UL,    1884160UL, 
   3978496UL,    7055872UL,    9278464UL,      22016UL,     163840UL,     770816UL, 
   1230848UL,    1034240UL,    1035520UL,    1363200UL,    2344960UL,    4896000UL, 
     23040UL,     104704UL,     247296UL,     513024UL,     381440UL,     316416UL, 
    383744UL,     383744UL,    1295360UL,      30976UL,      45568UL,      49152UL, 
     52992UL,      54784UL,      55040UL,      56320UL,      57600UL,      59136UL, 
   1441792UL,     393472UL,          0UL,     348928UL,    1657856UL,    2773248UL, 
   3755264UL,    4738560UL,    5726976UL,    3407872UL,    3806976UL,    9464576UL, 
   4494592UL,    4361216UL,    4884224UL,    5603840UL,    6192640UL,    6516992UL, 
    851968UL,   11767296UL,   15654144UL,   12505088UL,    8434688UL,    7773952UL, 
   7773184UL,    7771648UL,    7900672UL,      28672UL,     487936UL,    9427200UL, 
  12972544UL,   11848192UL,   10011392UL,    9288448UL,    8826112UL,    8361984UL, 
     25600UL,     358656UL,    3001088UL,    5761280UL,    6680576UL,    8246784UL, 
   9358080UL,   10076160UL,    9676544UL,      24832UL,     229888UL,    1627904UL, 
   3011328UL,    3011328UL,    3536896UL,    4713472UL,    6870272UL,    9028352UL, 
     24832UL,     169216UL,     515328UL,    1305856UL,    1438720UL,    1440512UL, 
   1834496UL,    2682368UL,    4840704UL,      25600UL,      46080UL,     189696UL, 
    518400UL,     519424UL,     522240UL,     523264UL,     654848UL,    1108224UL, 
     40704UL,      50944UL,      58112UL,      60160UL,      60672UL,      62464UL, 
     64000UL,      64512UL,      64256UL,    1703936UL,     459008UL,          0UL, 
    334592UL,    2202624UL,    3708416UL,    4560128UL,    5150720UL,    5940224UL, 
   3145728UL,    3999744UL,    9643264UL,    7760640UL,    4701952UL,    5551360UL, 
   5943296UL,    6270720UL,    6466560UL,    6488064UL,    8720896UL,   14914560UL, 
  15054080UL,   10273792UL,    7392256UL,    7521792UL,    7389440UL,    7323136UL, 
      3072UL,    3224064UL,   13088000UL,   13809920UL,   13682944UL,   10147328UL, 
   8508928UL,    8834816UL,    9094912UL,      30720UL,     560128UL,    4637184UL, 
   8441600UL,   10471424UL,    8638208UL,    8639488UL,    8771584UL,    9751296UL, 
     32512UL,     372736UL,    2608384UL,    3329792UL,    3985152UL,    4773120UL, 
   5167616UL,    6151680UL,    7854592UL,      30464UL,     310016UL,    1101824UL, 
   1624320UL,    1887232UL,    1889280UL,    2676992UL,    3268096UL,    4709888UL, 
  16880640UL,     118528UL,     381184UL,     575744UL,     707328UL,     774144UL, 
    776192UL,    1104384UL,    1632000UL,      52992UL,      54272UL,      53760UL, 
     51968UL,      52736UL,      52736UL,      55296UL,      57344UL,      54784UL, 
   2162688UL,     852224UL,          0UL,     655616UL,    3155200UL,    5087744UL, 
   5161216UL,    6012928UL,    6537216UL,    3211264UL,    5440768UL,    8916992UL, 
  11606528UL,    9526528UL,    8104704UL,    6801152UL,    6735872UL,    6931712UL, 
   6356992UL,    9702656UL,   14500352UL,   15354880UL,   13921024UL,   11837696UL, 
   9879552UL,    7851264UL,    7522816UL,    6684672UL,   11412224UL,   14182144UL, 
  14452736UL,   14454272UL,   13734912UL,   12891648UL,   11126528UL,    8311808UL, 
    596224UL,    2305024UL,    6775040UL,    9731584UL,   10387456UL,    9603584UL, 
   9284096UL,   10469120UL,    9883136UL,     158464UL,     880896UL,    3115776UL, 
   4167424UL,    4691968UL,    6065664UL,    5677312UL,    6731008UL,    8505856UL, 
    171520UL,     566784UL,    1417984UL,    2006528UL,    2007040UL,    2269952UL, 
   3257088UL,    3455744UL,    5620992UL,     311040UL,     180224UL,     504064UL, 
    763392UL,     826880UL,     762368UL,     896768UL,    1358336UL,    2342144UL, 
     49920UL,      47616UL,      47104UL,      45312UL,      43008UL,      41472UL, 
     44544UL,      48128UL,      43776UL,    2490368UL,    1245184UL,     196608UL, 
   1769472UL,    6163968UL,    8071936UL,    9206016UL,    8432640UL,    8305920UL, 
   3473408UL,    6620416UL,    9504768UL,   11799040UL,   12328448UL,   12273152UL, 
  11044096UL,   10200832UL,    9549824UL,    6291456UL,   10881024UL,   14556416UL, 
  14886144UL,   15412224UL,   14240000UL,   13140224UL,   12165376UL,   10729472UL, 
   9109504UL,   13440512UL,   14957312UL,   14697472UL,   15157248UL,   14829568UL, 
  14119168UL,   13605120UL,   12238080UL,    3997952UL,    5705984UL,    9582336UL, 
  10702592UL,   11096576UL,   11294720UL,   10840576UL,   11766784UL,   11648512UL, 
   2634496UL,    1189632UL,    3555584UL,    5000960UL,    5852672UL,    5590016UL, 
   6642944UL,    6586112UL,    8170240UL,    1204992UL,    1073408UL,    1729024UL, 
   2188800UL,    2451456UL,    3168000UL,    3760896UL,    3898112UL,    5346048UL, 
    752896UL,     424960UL,     555008UL,     751360UL,     946944UL,    1010688UL, 
   1011712UL,    1669376UL,    2590976UL,      35840UL,      34560UL,      33792UL, 
     33536UL,      33024UL,      29696UL,      28928UL,      32768UL,      30464UL, 
   2818048UL,    1507328UL,    2293760UL,    4849920UL,    7995904UL,   10030592UL, 
  12000256UL,   12081664UL,   11567616UL,    3670016UL,    6750720UL,   10420992UL, 
  11928064UL,   13109248UL,   13311232UL,   13317888UL,   13001984UL,   12680448UL, 
   6094848UL,    9896448UL,   13765632UL,   14552832UL,   15405568UL,   15342592UL, 
  14891264UL,   14049792UL,   13465856UL,    8781824UL,   14224128UL,   15145216UL, 
  15409408UL,   15345152UL,   15671808UL,   14954240UL,   14766848UL,   14381568UL, 
   8587008UL,   10098944UL,   11216640UL,   11414784UL,   11349248UL,   12595712UL, 
  12267776UL,   12538624UL,   13073408UL,    1901312UL,    3281152UL,    5317632UL, 
   6172160UL,    6892544UL,    7024128UL,    8598272UL,    8276224UL,    8943360UL, 
    334336UL,    1648896UL,    2371584UL,    2699520UL,    2895616UL,    3091456UL, 
   2959616UL,    4669184UL,    5204480UL,     935936UL,     672768UL,     803584UL, 
    869120UL,     999936UL,    1064960UL,    1389824UL,    1785088UL,    2907648UL, 
     21248UL,      20992UL,      20736UL,      21248UL,      20992UL,      19968UL, 
     17152UL,      18688UL,      20224UL,    3145728UL,    1966080UL,    5177344UL, 
   7471360UL,   10682880UL,   12518400UL,   13174784UL,   13177600UL,   13253888UL, 
   3932160UL,    7733248UL,   11403264UL,   12648448UL,   13303808UL,   14091008UL, 
  14096128UL,   14361344UL,   14235904UL,    6291456UL,   10158080UL,   13566720UL, 
  14353408UL,   14877440UL,   15730432UL,   15603200UL,   15539968UL,   15152640UL, 
  11337984UL,   13107712UL,   15599872UL,   15601152UL,   15666688UL,   15928832UL, 
  15602176UL,   15342848UL,   15348224UL,   12059904UL,   11864576UL,   12062464UL, 
  11997952UL,   11801600UL,   12850688UL,   13375232UL,   13179904UL,   13646592UL, 
   5767936UL,    6228992UL,    6689792UL,    7083520UL,    7476736UL,    7410944UL, 
   9704960UL,    9443072UL,   10499840UL,    2232064UL,    2692864UL,    2955264UL, 
   3348992UL,    3479552UL,    3675648UL,    4396288UL,    5183744UL,    6829824UL, 
    201728UL,     661760UL,     989696UL,    1120512UL,    1185536UL,    1251072UL, 
   1315840UL,    1249536UL,    2766592UL,       9216UL,       9216UL,       9216UL, 
      9472UL,       9728UL,       9984UL,       9472UL,       8704UL,      12032UL, 
   2949120UL,    4259840UL,    7995392UL,   10223616UL,   11927552UL,   13041664UL, 
  13500416UL,   13828096UL,   14024704UL,    6160384UL,    9568256UL,   11927552UL, 
  12976128UL,   13500416UL,   14155776UL,   14745600UL,   15073792UL,   15400960UL, 
  10092544UL,   11665408UL,   13500416UL,   14024704UL,   14745600UL,   15400960UL, 
  16056320UL,   16189184UL,   16449536UL,   13434880UL,   13762560UL,   15073280UL, 
  15597568UL,   15597568UL,   15990784UL,   15925248UL,   15664896UL,   15597568UL, 
  13107200UL,   13172736UL,   13631488UL,   13697024UL,   12910592UL,   13238272UL, 
  13697024UL,   13631488UL,   13500416UL,    7995392UL,    7798784UL,    8912896UL, 
   7668480UL,    7799808UL,    8127232UL,    9699328UL,   10289152UL,   10354688UL, 
   3735552UL,    3145728UL,    3997696UL,    3737600UL,    3999744UL,    4130048UL, 
   4719360UL,    5767168UL,    6160384UL,    1376256UL,     851968UL,     786432UL, 
   1048576UL,    1312512UL,    1443584UL,    1573888UL,    2228224UL,    3473408UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,
};


// 600x600x2, KCMY - Photo Best, MLC Both

uint32_t ulMapDJ3600_KCMY_6x6x2[ 9 * 9 * 9 ] =
{
3317360895UL, 3587571711UL, 2630745874UL, 1166933778UL,  558432009UL,  202374912UL, 
     65280UL,      65280UL,      61952UL, 4286697175UL, 3867868899UL, 2478505755UL, 
1064697618UL,  456589062UL,  100925184UL,      65280UL,      65280UL,      61440UL, 
4281391953UL, 4281401169UL, 3306553118UL, 1259536131UL,  402718464UL,  151060224UL, 
  50393088UL,      55296UL,      53760UL, 4278248192UL, 4278253824UL, 3892379392UL, 
2164324864UL,  805371648UL,  352378880UL,  151031040UL,   50361600UL,      29952UL, 
4278247168UL, 4278251264UL, 4261474048UL, 3070286848UL, 1359007232UL,  553701632UL, 
 151021056UL,  100671744UL,       6912UL, 4278243072UL, 4278245632UL, 4278243840UL, 
3338707456UL, 1912639488UL,  755006976UL,  251682048UL,  100670208UL,          0UL, 
4278240000UL, 4278242304UL, 4278241792UL, 3456139520UL, 2516603136UL, 1308634368UL, 
 402660864UL,  151000320UL,          0UL, 4278234624UL, 4278237696UL, 4278239488UL, 
3842018560UL, 3170913792UL, 1962946560UL,  905976576UL,  150996480UL,          0UL, 
4278230784UL, 4278229248UL, 4278226944UL, 4009786112UL, 3288358144UL, 2617264128UL, 
1560292608UL,  704649216UL,        768UL, 4293301959UL, 4127165121UL, 1979703064UL, 
 618921734UL,  113377027UL,   58064640UL,   51576576UL,      64000UL,      58880UL, 
4289820069UL, 3583816940UL, 3234785331UL, 1067056917UL,  357105414UL,   51183360UL, 
     65280UL,      65280UL,      55296UL, 4281384273UL, 4281589076UL, 3290944563UL, 
1510796291UL,  553713152UL,  100727808UL,      59392UL,      55296UL,      50432UL, 
4278245120UL, 4278248960UL, 3674265856UL, 2113983488UL,  855693056UL,  251705856UL, 
     39936UL,      29184UL,      18432UL, 4278244352UL, 4278241792UL, 3842027008UL, 
2717948160UL, 1258328832UL,  503352576UL,  151008768UL,       3840UL,          0UL, 
4278239488UL, 4278224640UL, 4009778432UL, 3238022656UL, 1811953152UL,  754985472UL, 
 251666688UL,   50331648UL,          0UL, 4278223104UL, 4278204672UL, 4026538752UL, 
3355448576UL, 2365591296UL, 1258292736UL,  452984832UL,  100663296UL,          0UL, 
4278211584UL, 4278191616UL, 4026531840UL, 3523215360UL, 2919235584UL, 1761607680UL, 
 855638016UL,  251658240UL,          0UL, 4278201600UL, 4278190080UL, 4076863488UL, 
3674210304UL, 3271557120UL, 2365587456UL, 1409286144UL,  603979776UL,          0UL, 
4294257206UL, 4160689435UL, 2029977600UL,  318706944UL,  165107459UL,  109928451UL, 
  52914432UL,      33792UL,      36096UL, 4291571001UL, 4292429923UL, 3319802398UL, 
1070667779UL,  211758339UL,    5331456UL,    1410816UL,      38400UL,      39168UL, 
4283510076UL, 4148707162UL, 3023844942UL, 1764377103UL,  553671936UL,   50363904UL, 
     34560UL,      33024UL,      31488UL, 4278222336UL, 4278225408UL, 3472906752UL, 
2063611392UL,  855649536UL,  251665920UL,       7680UL,       8448UL,      13056UL, 
4278226176UL, 4278213888UL, 3707773184UL, 2516587776UL, 1207964160UL,  452987904UL, 
 100663296UL,          0UL,          0UL, 4278209280UL, 4278196224UL, 3707764736UL, 
3019898880UL, 1711276032UL,  754974720UL,  251658240UL,   50331648UL,          0UL, 
4278195456UL, 4278190080UL, 3808428032UL, 3271557120UL, 2164260864UL, 1258291200UL, 
 503316480UL,  100663296UL,          0UL, 4278192384UL, 4278190080UL, 3808428032UL, 
3388997632UL, 2667577344UL, 1660944384UL,  855638016UL,  251658240UL,          0UL, 
4278190080UL, 4278190080UL, 3791650816UL, 3472883712UL, 3070230528UL, 2063597568UL, 
1358954496UL,  553648128UL,          0UL, 4294705152UL, 4294901760UL, 1878982656UL, 
 620691456UL,  166264832UL,  161611776UL,   56033280UL,    3145728UL,    1376256UL, 
4291887104UL, 4292871689UL, 3186360320UL, 1172307968UL,  213975040UL,    7667712UL, 
   4325376UL,    1769472UL,        768UL, 4287628035UL, 4285857792UL, 3378118656UL, 
1968635904UL,  556793856UL,     983040UL,     196608UL,          0UL,          0UL, 
4279369728UL, 4278190080UL, 3305111552UL, 1862270976UL, 1207959552UL,  251658240UL, 
         0UL,          0UL,       1536UL, 4278193152UL, 4278190080UL, 3640655872UL, 
2516582400UL, 1358954496UL,  503316480UL,  100663296UL,          0UL,          0UL, 
4278190080UL, 4278190080UL, 3707764736UL, 3070230528UL, 1711276032UL,  754974720UL, 
 251658240UL,          0UL,          0UL, 4278190080UL, 4278190080UL, 3791650816UL, 
3254779904UL, 2113929216UL, 1258291200UL,  503316480UL,  100663296UL,          0UL, 
4278190080UL, 4278190080UL, 3808428032UL, 3321888768UL, 2466250752UL, 1660944384UL, 
 855638016UL,  251658240UL,          0UL, 4278190080UL, 4261412864UL, 3741319168UL, 
3355443200UL, 2768240640UL, 2063597568UL, 1409286144UL,  553648128UL,          0UL, 
4294705152UL, 4294901760UL, 2382299136UL,  620691456UL,   67043328UL,  113704960UL, 
  58982400UL,   56623104UL,    3735552UL, 4291166208UL, 4291559424UL, 3320381440UL, 
1122369536UL,  265551872UL,   10616832UL,    6094848UL,    2752512UL,    1376256UL, 
4285267968UL, 4284284928UL, 3528720384UL, 1818427392UL,  660013056UL,   53084160UL, 
   1179648UL,     196608UL,          0UL, 4278386688UL, 4261412864UL, 3456106496UL, 
2264924160UL, 1207959552UL,  301989888UL,          0UL,          0UL,          0UL, 
4278190080UL, 4278190080UL, 3640655872UL, 2466250752UL, 1358954496UL,  754974720UL, 
 100663296UL,          0UL,          0UL, 4278190080UL, 4278190080UL, 3791650816UL, 
3170893824UL, 1761607680UL,  905969664UL,  251658240UL,          0UL,          0UL, 
4278190080UL, 4278190080UL, 3808428032UL, 3254779904UL, 2063597568UL, 1157627904UL, 
 503316480UL,   50331648UL,          0UL, 4278190080UL, 4278190080UL, 3808428032UL, 
3305111552UL, 2164260864UL, 1560281088UL,  754974720UL,  251658240UL,          0UL, 
4278190080UL, 4278190080UL, 3758096384UL, 3338665984UL, 2415919104UL, 1862270976UL, 
1358954496UL,  553648128UL,          0UL, 4294377472UL, 4294901760UL, 2935947264UL, 
 822018048UL,   67043328UL,   16646144UL,   63242240UL,    9633792UL,    6684672UL, 
4291887104UL, 4289986560UL, 3386900480UL, 1525022720UL,  316211200UL,   12910592UL, 
   8060928UL,    4915200UL,    3145728UL, 4284481536UL, 4282712064UL, 3560308736UL, 
2670919680UL,  710737920UL,  105578496UL,    2359296UL,     983040UL,     196608UL, 
4278190080UL, 4076863488UL, 3422552064UL, 2516582400UL, 1107296256UL,  352321536UL, 
         0UL,          0UL,          0UL, 4278190080UL, 4278190080UL, 3489660928UL, 
2516582400UL, 1509949440UL,  855638016UL,  150994944UL,          0UL,          0UL, 
4278190080UL, 4278190080UL, 3758096384UL, 3120562176UL, 1761607680UL,  855638016UL, 
 452984832UL,          0UL,          0UL, 4278190080UL, 4278190080UL, 3909091328UL, 
3305111552UL, 2113929216UL, 1107296256UL,  553648128UL,   50331648UL,          0UL, 
4278190080UL, 4278190080UL, 3925868544UL, 3355443200UL, 2315255808UL, 1409286144UL, 
 805306368UL,  251658240UL,          0UL, 4278190080UL, 4278190080UL, 3892314112UL, 
3405774848UL, 2466250752UL, 1560281088UL, 1258291200UL,  553648128UL,          0UL, 
4293525504UL, 4294901760UL, 3456040960UL, 1526661120UL,  268369920UL,   16711680UL, 
  16187392UL,   63373312UL,    9830400UL, 4291624960UL, 4291690496UL, 3419865088UL, 
1977745408UL,  517341184UL,   13041664UL,   11403264UL,    7077888UL,    5308416UL, 
4284284928UL, 4284088320UL, 3525378048UL, 2270429184UL,  912457728UL,  156303360UL, 
   3932160UL,    2162688UL,    1376256UL, 4278190080UL, 3959422976UL, 3422552064UL, 
2617245696UL, 1207959552UL,  452984832UL,          0UL,          0UL,          0UL, 
4278190080UL, 3758096384UL, 3405774848UL, 2566914048UL, 1711276032UL,  704643072UL, 
 201326592UL,          0UL,          0UL, 4278190080UL, 4278190080UL, 3674210304UL, 
2566914048UL, 1660944384UL,  956301312UL,  553648128UL,   50331648UL,          0UL, 
4278190080UL, 4278190080UL, 3892314112UL, 3288334336UL, 2063597568UL, 1157627904UL, 
 503316480UL,  301989888UL,          0UL, 4278190080UL, 4278190080UL, 4110417920UL, 
3489660928UL, 2516582400UL, 1409286144UL,  654311424UL,  251658240UL,          0UL, 
4278190080UL, 4278190080UL, 4194304000UL, 3573547008UL, 2768240640UL, 1610612736UL, 
 956301312UL,  603979776UL,          0UL, 4293263360UL, 4294574080UL, 3607035904UL, 
2382299136UL,  771686400UL,  117374976UL,   16711680UL,   16318464UL,   13238272UL, 
4291297280UL, 4291166208UL, 3419013120UL, 2328952832UL, 1020329984UL,  164298752UL, 
  11993088UL,   10027008UL,    7864320UL, 4284088320UL, 4284284928UL, 3376742400UL, 
2270035968UL, 1364852736UL,  407764992UL,    4325376UL,    3735552UL,    2752512UL, 
4278190080UL, 4143972352UL, 3439329280UL, 2617245696UL, 1409286144UL,  704643072UL, 
 100663296UL,          0UL,          0UL, 4278190080UL, 3640655872UL, 3372220416UL, 
2566914048UL, 1711276032UL,  855638016UL,  352321536UL,          0UL,          0UL, 
4278190080UL, 4278190080UL, 3271557120UL, 2466250752UL, 1660944384UL,  956301312UL, 
 503316480UL,  100663296UL,          0UL, 4278190080UL, 4278190080UL, 3791650816UL, 
3170893824UL, 1560281088UL,  905969664UL,  503316480UL,  301989888UL,          0UL, 
4278190080UL, 4278190080UL, 3909091328UL, 3305111552UL, 2164260864UL, 1308622848UL, 
 704643072UL,  201326592UL,          0UL, 4278190080UL, 4278190080UL, 4278190080UL, 
3640655872UL, 2919235584UL, 1660944384UL,  855638016UL,  553648128UL,          0UL, 
4293525504UL, 4293853184UL, 3858366464UL, 3321823232UL, 2281635840UL, 1124007936UL, 
 519962624UL,  167641088UL,   16384000UL, 4291297280UL, 3936485376UL, 3350265856UL, 
2579824640UL, 1674117120UL,  667418624UL,  113573888UL,   12648448UL,   12648448UL, 
4284284928UL, 4031250432UL, 3240951808UL, 2268856320UL, 1715994624UL, 1011548160UL, 
 206045184UL,    4521984UL,    4718592UL, 4278190080UL, 3976200192UL, 3355443200UL, 
2264924160UL, 1610612736UL, 1207959552UL,  503316480UL,   50331648UL,          0UL, 
4278190080UL, 4278190080UL, 3456106496UL, 2667577344UL, 1761607680UL, 1207959552UL, 
 704643072UL,  150994944UL,          0UL, 4278190080UL, 4278190080UL, 3573547008UL, 
2516582400UL, 1761607680UL, 1056964608UL,  704643072UL,  301989888UL,          0UL, 
4278190080UL, 4278190080UL, 3758096384UL, 3120562176UL, 1610612736UL, 1056964608UL, 
 553648128UL,  301989888UL,          0UL, 4278190080UL, 4278190080UL, 3841982464UL, 
3271557120UL, 2113929216UL,  855638016UL,  603979776UL,  251658240UL,          0UL, 
4278190080UL, 4278190080UL, 3523215360UL, 2818572288UL, 1912602624UL, 1358954496UL, 
 905969664UL,  402653184UL,          0UL, 
};

// 600x600x2, ClMlxx - Photo Best, MLC Both

uint32_t ulMapDJ3600_ClMlxx_6x6x2[ 9 * 9 * 9 ] =
{
         0UL,     983040UL,    6291456UL,   13762560UL,   16711680UL,   16711680UL, 
  16719360UL,   16750080UL,   16768256UL,   12619776UL,   13383936UL,   11403264UL, 
  14614528UL,   16711680UL,   16711680UL,   16726272UL,   16761344UL,   16768768UL, 
  15098624UL,   15478016UL,   16728576UL,   16715520UL,   16714752UL,   16740096UL, 
  16769024UL,   16776192UL,   16776960UL,   15808768UL,   15803392UL,   16736256UL, 
  16758528UL,   16741632UL,   16772864UL,   16776960UL,   16776960UL,   16776960UL, 
  12807168UL,   12407808UL,   13156352UL,   14084608UL,   14417664UL,   14089984UL, 
  14352128UL,   14876416UL,   15662848UL,    5357824UL,    4174080UL,    4973568UL, 
   7732992UL,    8322816UL,    8912640UL,    9305856UL,   12779264UL,   13893376UL, 
   1824768UL,    1232384UL,    1436672UL,    2621184UL,    3800832UL,    3407616UL, 
   3604224UL,    6946560UL,   11075328UL,     846336UL,     648192UL,     652544UL, 
   1048320UL,    2227968UL,    2031360UL,    1834752UL,    1441536UL,    5766912UL, 
     62208UL,      64768UL,      65280UL,      65280UL,      65280UL,      65280UL, 
     65280UL,      65280UL,      65280UL,    2804224UL,      57344UL,      50176UL, 
   2378496UL,    9057024UL,   15160320UL,   16750080UL,   16765696UL,   16771328UL, 
  10475008UL,   13349888UL,   11640576UL,   14903552UL,   16726272UL,   16724736UL, 
  16738560UL,   16763904UL,   16776192UL,   15180288UL,   16017664UL,   16757760UL, 
  16760832UL,   16761856UL,   16765440UL,   16771840UL,   16776192UL,   16776960UL, 
  15879680UL,   15746304UL,   16763136UL,   16768768UL,   16772608UL,   16776960UL, 
  16776960UL,   16776960UL,   16776960UL,   12683776UL,   12764672UL,   13172224UL, 
  13827840UL,   13762304UL,   13827840UL,   14089984UL,   14417664UL,   14876416UL, 
   4576512UL,    5570304UL,    6553344UL,    7143168UL,    7732992UL,    7929600UL, 
   9109248UL,   11075328UL,   13172480UL,    1048320UL,    1048320UL,    2031360UL, 
   2424576UL,    3211008UL,    3211008UL,    3211008UL,    4980480UL,    9109248UL, 
    851712UL,      65280UL,      65280UL,      65280UL,     458496UL,     655104UL, 
    655104UL,     851712UL,    3800832UL,      65280UL,      65280UL,      65280UL, 
     65280UL,      65280UL,      65280UL,      65280UL,      65280UL,      65280UL, 
   2025984UL,     458496UL,      65280UL,    2031360UL,   11075328UL,   15859456UL, 
  16776960UL,   16776960UL,   16776960UL,    6942208UL,    8122112UL,   12254976UL, 
  13238016UL,   15400704UL,   16776960UL,   16776960UL,   16776960UL,   16776960UL, 
  14019840UL,   16380672UL,   16773376UL,   16776960UL,   16776960UL,   16776960UL, 
  16776960UL,   16776960UL,   16776960UL,   16297472UL,   16761856UL,   16775168UL, 
  16776960UL,   16776960UL,   16776960UL,   16776960UL,   16776960UL,   16776960UL, 
  13030400UL,   12975872UL,   13172480UL,   13631232UL,   13500160UL,   13696768UL, 
  13958912UL,   14417664UL,   14941952UL,    5570304UL,    5963520UL,    7339776UL, 
   7929600UL,    7929600UL,    7732992UL,    9109248UL,   11468544UL,   13106944UL, 
   1244928UL,    1638144UL,    2424576UL,    3014400UL,    3014400UL,    3211008UL, 
   3407616UL,    5766912UL,    9109248UL,     458496UL,      65280UL,      65280UL, 
    458496UL,     458496UL,     655104UL,     851712UL,    1048320UL,    3800832UL, 
     65280UL,      65280UL,      65280UL,      65280UL,      65280UL,      65280UL, 
     65280UL,      65280UL,      65280UL,    2024704UL,     844800UL,    1631232UL, 
   1633536UL,   13369088UL,   16776960UL,   16776960UL,   16776960UL,   16776960UL, 
   5372160UL,    3798528UL,   13434624UL,   14745344UL,   16645888UL,   16776960UL, 
  16776960UL,   16776960UL,   16776960UL,   10287616UL,   15138048UL,   16776960UL, 
  16776960UL,   16776960UL,   16776960UL,   16776960UL,   16776960UL,   16776960UL, 
  15266816UL,   16776960UL,   16776960UL,   16775680UL,   16776960UL,   16776960UL, 
  16776960UL,   16776960UL,   16580352UL,   13369088UL,   13434624UL,   13958912UL, 
  14024448UL,   14155008UL,   14024448UL,   14089984UL,   14745344UL,   15138560UL, 
   6946560UL,    7143168UL,    8322816UL,    8322816UL,    8912640UL,    8912640UL, 
   9895680UL,   12058368UL,   13238016UL,    1834752UL,    2621184UL,    3211008UL, 
   3604224UL,    3800832UL,    3800832UL,    4194048UL,    6553344UL,    9895680UL, 
    655104UL,      65280UL,     458496UL,     851712UL,    1048320UL,    1048320UL, 
   1244928UL,    1441536UL,    4587264UL,      65280UL,      65280UL,      65280UL, 
     65280UL,      65280UL,      65280UL,      65280UL,      65280UL,      63232UL, 
   3782400UL,    1219584UL,    2006784UL,    4963584UL,    8506624UL,   16774400UL, 
  16776960UL,   16776960UL,   16776960UL,   11651584UL,   12700160UL,   14796288UL, 
  15911424UL,   16766976UL,   16774912UL,   16776960UL,   16776960UL,   16776960UL, 
  15453952UL,   16764416UL,   16763904UL,   16765440UL,   16767488UL,   16772864UL, 
  16776960UL,   16776960UL,   16776960UL,   16765440UL,   16764160UL,   16764160UL, 
  16767232UL,   16765952UL,   16769536UL,   16775168UL,   16776960UL,   16776960UL, 
  14144256UL,   14145792UL,   14603520UL,   14734336UL,   14470912UL,   14408448UL, 
  14217728UL,   14810880UL,   14941952UL,    8319488UL,    9105920UL,   10087680UL, 
  10086144UL,    9888000UL,   10081536UL,   10676736UL,   12450304UL,   13565696UL, 
   2424576UL,    3407616UL,    4389376UL,    4779520UL,    4385536UL,    4972800UL, 
   4775936UL,    6746880UL,   10091264UL,     655104UL,     458496UL,     851712UL, 
   1438976UL,    1436928UL,    1435904UL,    1434112UL,    1630720UL,    5171712UL, 
     65280UL,      65280UL,      65280UL,      65024UL,      62720UL,      60416UL, 
     59136UL,      58368UL,      54784UL,    5923584UL,    2572032UL,    3949824UL, 
   7495680UL,   13534976UL,   14788608UL,   16767744UL,   16774656UL,   16776960UL, 
  12740864UL,   15236608UL,   16279808UL,   16675328UL,   16746240UL,   16760064UL, 
  16767744UL,   16773888UL,   16776960UL,   16742400UL,   16748544UL,   16746240UL, 
  16745472UL,   16747776UL,   16758528UL,   16766720UL,   16772864UL,   16776960UL, 
  16749312UL,   16749312UL,   16747776UL,   16747008UL,   16749312UL,   16755456UL, 
  16764160UL,   16770048UL,   16776960UL,   14592000UL,   15181824UL,   15501824UL, 
  15307520UL,   14656000UL,   15178752UL,   15582208UL,   15784448UL,   15988992UL, 
  10461696UL,   10665216UL,   10857984UL,   11248896UL,   10854144UL,   10062336UL, 
  11056896UL,   12047104UL,   13300480UL,    3592192UL,    4772864UL,    5558016UL, 
   5556992UL,    5359104UL,    5745408UL,    5545728UL,    6736640UL,    9691904UL, 
    649216UL,    1041408UL,    1629184UL,    1824000UL,    1822208UL,    1819648UL, 
   2013696UL,    2406912UL,    5164288UL,      64256UL,      63488UL,      60160UL, 
     56832UL,      54528UL,      51968UL,      49664UL,      48384UL,      43008UL, 
   9252096UL,    7671552UL,   10229760UL,    9054720UL,   12596736UL,   14838784UL, 
  15632896UL,   16763648UL,   16769024UL,   13707008UL,   15477248UL,   16720896UL, 
  16723200UL,   16726272UL,   16737024UL,   16750080UL,   16762880UL,   16767744UL, 
  16725504UL,   16727808UL,   16730880UL,   16728576UL,   16730112UL,   16733184UL, 
  16749312UL,   16762112UL,   16766208UL,   16731648UL,   16733184UL,   16732416UL, 
  16730880UL,   16730880UL,   16732416UL,   16742400UL,   16759296UL,   16765696UL, 
  15555840UL,   15815680UL,   15749376UL,   15618304UL,   15420160UL,   16275200UL, 
  16673792UL,   16754688UL,   16764672UL,   11627520UL,   12019968UL,   12606720UL, 
  12734720UL,   12211968UL,   11426304UL,   12212736UL,   13273600UL,   13682176UL, 
   5332224UL,    5928960UL,    6124032UL,    6120960UL,    5922048UL,    5724672UL, 
   5327616UL,    7307520UL,    8306688UL,    1024512UL,    1421568UL,    2009856UL, 
   2400000UL,    2397696UL,    2195712UL,    2778624UL,    2777856UL,    4958208UL, 
     52992UL,      52224UL,      50944UL,      49920UL,      46848UL,      39936UL, 
     30720UL,      31488UL,      27648UL,   11013888UL,   11012352UL,   13373184UL, 
  11802624UL,   10819584UL,   13840384UL,   15358464UL,   15886592UL,   16756992UL, 
  14484992UL,   16713216UL,   16712448UL,   16713984UL,   16715520UL,   16719360UL, 
  16732416UL,   16740096UL,   16751616UL,   16714752UL,   16716288UL,   16717056UL, 
  16716288UL,   16717056UL,   16718592UL,   16728576UL,   16737792UL,   16747008UL, 
  16718592UL,   16720128UL,   16719360UL,   16719360UL,   16718592UL,   16720128UL, 
  16720128UL,   16733184UL,   16745472UL,   16590592UL,   16000000UL,   15868928UL, 
  15737856UL,   15541248UL,   16720128UL,   16721664UL,   16727808UL,   16743168UL, 
  12924416UL,   13120256UL,   13050880UL,   12986880UL,   12790272UL,   12723968UL, 
  13313792UL,   13644544UL,   14643712UL,    6698496UL,    6699264UL,    7287552UL, 
   7679232UL,    7087872UL,    6892032UL,    6498816UL,    7680000UL,   10641408UL, 
   1779456UL,    2376192UL,    2571264UL,    2568960UL,    2567424UL,    2566656UL, 
   2566656UL,    2170368UL,    3952896UL,      29952UL,      29184UL,      25344UL, 
     23040UL,      21504UL,      18432UL,      16896UL,      15360UL,      15360UL, 
  10420224UL,   13434880UL,   14551296UL,   14619136UL,   14818816UL,   15410944UL, 
  15806464UL,   16070144UL,   16205056UL,   14614528UL,   16711680UL,   16711680UL, 
  16711680UL,   16711680UL,   16713984UL,   16715520UL,   16721664UL,   16723200UL, 
  16711680UL,   16711680UL,   16711680UL,   16711680UL,   16711680UL,   16711680UL, 
  16711680UL,   16719360UL,   16718592UL,   16711680UL,   16711680UL,   16711680UL, 
  16711680UL,   16711680UL,   16711680UL,   16711680UL,   16713984UL,   16716288UL, 
  16711680UL,   16711680UL,   16711680UL,   16711680UL,   15533568UL,   16711680UL, 
  16711680UL,   16711680UL,   16715520UL,   14024704UL,   13959168UL,   14221312UL, 
  13437184UL,   13175808UL,   12651520UL,   13631488UL,   14352384UL,   14485760UL, 
   7864320UL,    7274496UL,    8847360UL,   10027008UL,    8063232UL,    8064000UL, 
   7080960UL,    9633792UL,    9830400UL,    2555904UL,    2555904UL,    2949120UL, 
   3538944UL,    3932160UL,    3541248UL,    3345408UL,    3145728UL,    4915200UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL, 
};


// 300x300x1, KCMY - Plain Draft, MLC Both

uint32_t ulMapDJ3600_KCMY_3x3x1[ 9 * 9 * 9 ] =
{
4294967040UL, 4294967040UL, 4294967040UL, 4294967040UL, 2801794816UL, 1862270720UL, 
1157627648UL,  486080256UL,   16056064UL, 4294967040UL, 4294967040UL, 4294967040UL, 
4009754368UL, 2600468224UL, 1795161856UL, 1090518784UL,  418709248UL,   15531776UL, 
4294967040UL, 4294967040UL, 4294967040UL, 4294967040UL, 2264923904UL, 1291845376UL, 
 720699136UL,  249233152UL,   14483200UL, 4290576128UL, 4291624704UL, 4294967040UL, 
4294967040UL, 3841982208UL, 1591017216UL,  717029120UL,  346881792UL,   11468544UL, 
4286643968UL, 4287168256UL, 4287692544UL, 4288741120UL, 4206952192UL, 2931752704UL, 
1251278592UL,  444399360UL,    8716032UL, 4284022528UL, 4283891456UL, 4283629312UL, 
4282711808UL, 4284153600UL, 2557542144UL, 1920270080UL,  744292096UL,    6356736UL, 
4281925376UL, 4281532160UL, 4280745728UL, 4279566080UL, 4279959296UL, 2418474752UL, 
1345781504UL,  808779520UL,    3735296UL, 4279959296UL, 4279828224UL, 4279041792UL, 
4278648576UL, 4278779648UL, 2819292928UL, 1410268928UL,  638910208UL,    1376000UL, 
4278255360UL, 4278255360UL, 4278255360UL, 4278255360UL, 4278255360UL, 3288399616UL, 
1946222336UL,  838926080UL,      65280UL, 4294967040UL, 4294967040UL, 4294967040UL, 
1962934016UL, 1157627648UL,  687865600UL,  452984576UL,  150798080UL,   16776960UL, 
4294967040UL, 4294967040UL, 4294967040UL, 2399141632UL, 1124073216UL,  183303936UL, 
  13958912UL,   13041408UL,   12517120UL, 4294967040UL, 4294967040UL, 4294967040UL, 
1825636096UL,  717291264UL,  280690432UL,   11468544UL,   11337472UL,   11599616UL, 
4289920768UL, 4288347904UL, 4286906112UL, 3264413440UL, 1115488000UL,  444792576UL, 
  42139392UL,    9109248UL,    9633536UL, 4286643968UL, 4283760384UL, 4281794304UL, 
3963420416UL, 1749483264UL,  810483456UL,  240582400UL,    6487808UL,    7274240UL, 
4284022528UL, 4280876800UL, 4280090368UL, 4280090368UL, 2451635968UL, 1076297472UL, 
 539950848UL,  104529664UL,    5046016UL, 4281794304UL, 4279172864UL, 4279041792UL, 
4279041792UL, 3188522752UL, 1678704384UL,  672202496UL,  270073600UL,    2555648UL, 
4279959296UL, 4278253568UL, 4278384128UL, 4278386432UL, 3523411712UL, 2147680000UL, 
1074069248UL,  335871744UL,     458496UL, 4278255360UL, 4278250496UL, 4278251008UL, 
4278253568UL, 3791716096UL, 2617310976UL, 1543569152UL,  671153920UL,      65280UL, 
4294967040UL, 4294959616UL, 4294966784UL, 1627389696UL, 1023409920UL,  653721344UL, 
 284491520UL,  183828224UL,   16776960UL, 4294967040UL, 4294967040UL, 4294967040UL, 
1022689024UL,   49610496UL,   16056064UL,   15793920UL,   14483200UL,   13958912UL, 
4294967040UL, 4294967040UL, 3938373632UL, 2260790784UL,  447676160UL,   10944256UL, 
  10682112UL,   10682112UL,   10419968UL, 4289658624UL, 4288610048UL, 4284676096UL, 
2490687488UL,  846397184UL,  175570688UL,    8191744UL,    8978176UL,    9502464UL, 
4286381824UL, 4284546816UL, 4281270016UL, 3157589760UL, 1346174720UL,  507969280UL, 
  72548096UL,    6356736UL,    7405312UL, 4284022528UL, 4281007872UL, 4279559168UL, 
3625511936UL, 1981611776UL,  908001024UL,  338231040UL,    3735296UL,    5046016UL, 
4281794304UL, 4279169536UL, 4278508032UL, 3960002560UL, 2517167616UL, 1343028992UL, 
 537722624UL,  202964736UL,    2817792UL, 4279828224UL, 4278378496UL, 4278242816UL, 
4261466624UL, 3019955712UL, 1912664576UL,  973274880UL,  268631808UL,     851712UL, 
4278255360UL, 4278245888UL, 4278240768UL, 4278242816UL, 3321943552UL, 2315312640UL, 
1442902528UL,  570490624UL,      65280UL, 4294939136UL, 4294933504UL, 4294939648UL, 
3271535616UL, 1056957952UL,  586481408UL,  250937088UL,  116719360UL,   16776960UL, 
4294937600UL, 4294930432UL, 3909052928UL, 1190558208UL,  150255104UL,   16048640UL, 
  16056064UL,   16056064UL,   15007488UL, 4294943744UL, 4294940160UL, 4073224192UL, 
2296154624UL,  417374208UL,   14073856UL,   13163520UL,   12514304UL,   11992832UL, 
4289769984UL, 4290034688UL, 4286087680UL, 2289598976UL, 1316788224UL,   74629632UL, 
   7918592UL,    8185856UL,    8322816UL, 4286371328UL, 4285321216UL, 4281902080UL, 
3057426432UL, 1447858688UL,  373995008UL,    5555712UL,    6609920UL,    7271936UL, 
4283753984UL, 4281387008UL, 4280068608UL, 3658918912UL, 1880926720UL,  773897216UL, 
 137024512UL,    4118528UL,    5171712UL, 4281788928UL, 4279549952UL, 4278889472UL, 
3758662656UL, 2316085760UL, 1242348032UL,  437045248UL,  102553600UL,    3331584UL, 
4279820800UL, 4278501376UL, 4278234112UL, 3993019392UL, 2717951488UL, 1811984384UL, 
 906150912UL,  235063808UL,    1366528UL, 4278248960UL, 4278239232UL, 4278234624UL, 
4227900416UL, 3053496832UL, 2281744896UL, 1543548928UL,  637585408UL,      47616UL, 
4294924288UL, 4294918656UL, 4294918656UL, 2566875648UL, 1828680192UL,  754951168UL, 
 250922496UL,  116710400UL,   16773632UL, 4294919680UL, 4294189056UL, 4294191104UL, 
1324627968UL,  317999616UL,   16024064UL,   16034304UL,   16040448UL,   16045568UL, 
4294200832UL, 4292358656UL, 4074518016UL, 1861499904UL,  452218368UL,   15626752UL, 
  14455296UL,   14201856UL,   13814272UL, 4288965120UL, 4286071808UL, 4286071296UL, 
2256294912UL, 1384930304UL,  144075264UL,   10258432UL,   10396160UL,    9879552UL, 
4286480896UL, 4285562368UL, 4282405376UL, 2756466176UL, 1448237056UL,  710175232UL, 
   5801984UL,    6330368UL,    6600192UL, 4283735552UL, 4281893376UL, 4280315392UL, 
3894308864UL, 1948675584UL,  909142016UL,  103974400UL,    4496384UL,    5551616UL, 
4281510400UL, 4279536128UL, 4279008256UL, 3926685184UL, 2349627392UL, 1242593280UL, 
 437553152UL,    1875968UL,    3714048UL, 4279809024UL, 4278621696UL, 4278486528UL, 
4060249088UL, 2550298624UL, 1678014976UL,  939820544UL,  201625600UL,    1482240UL, 
4278237184UL, 4278231040UL, 4278226944UL, 4278224896UL, 2818605056UL, 2080406016UL, 
1476426752UL,  671126016UL,      36864UL, 4294915584UL, 4294912000UL, 4294908928UL, 
2566860288UL, 1358906368UL,  822036480UL,  452228608UL,  116690944UL,   16754688UL, 
4294914560UL, 4294186496UL, 4294184960UL, 1995707392UL,  452206080UL,   16003584UL, 
  16016384UL,   16023040UL,   16028160UL, 4294914560UL, 4291957248UL, 4007006720UL, 
2297698816UL,  687087616UL,   16004096UL,   15752192UL,   14972416UL,   14978048UL, 
4289084928UL, 4286324224UL, 4286717440UL, 2290755072UL, 1050946048UL,  145502720UL, 
  11162112UL,   11300864UL,   11308032UL, 4285682176UL, 4284365824UL, 4283313152UL, 
2656185344UL, 1381380096UL,  845167104UL,   74075648UL,    7629312UL,    8162304UL, 
4283718144UL, 4282010624UL, 4280694272UL, 3794286080UL, 1848653312UL,  842020352UL, 
 406209536UL,    4614656UL,    5540352UL, 4281363968UL, 4279653376UL, 4279127040UL, 
4161817600UL, 2450542592UL, 1209547776UL,  471353344UL,    2516992UL,    3833856UL, 
4279663104UL, 4278609920UL, 4278476800UL, 4261698560UL, 2651085824UL, 1543787008UL, 
 872698880UL,  168320512UL,    1733120UL, 4278224384UL, 4278220288UL, 4278218240UL, 
4278217216UL, 2885706752UL, 1744854016UL, 1342198784UL,  738223104UL,      25088UL, 
4294910464UL, 4294906880UL, 4294184448UL, 3539931648UL, 1358895616UL,  452926464UL, 
 419375616UL,  183782912UL,   16740352UL, 4294909952UL, 4294182912UL, 4294181376UL, 
2901672448UL,  854853632UL,   15995904UL,   16001024UL,   16009728UL,   16014848UL, 
4294908928UL, 4293790720UL, 4293526528UL, 2733900800UL, 1022625280UL,   83104256UL, 
  16001024UL,   16008704UL,   16013312UL, 4289602048UL, 4286580224UL, 4287235584UL, 
2694581248UL, 1387008000UL,  381556224UL,   12460544UL,   12206080UL,   12474368UL, 
4285672448UL, 4283307008UL, 4283568640UL, 2690126336UL, 1415451648UL,  711989760UL, 
 108535808UL,    8403968UL,    9067520UL, 4282922496UL, 4281870336UL, 4281211392UL, 
2754615808UL, 1681135616UL,  842668032UL,  541204480UL,    5126144UL,    6315008UL, 
4281481216UL, 4279642112UL, 4279508992UL, 4162068480UL, 2417500160UL, 1243225088UL, 
 437918720UL,  237383680UL,    3560448UL, 4279517696UL, 4278729216UL, 4278596608UL, 
4278596608UL, 2818979328UL, 1644573696UL,  738863104UL,  235678720UL,    1856000UL, 
4278211072UL, 4278209024UL, 4278207488UL, 4278207488UL, 2952806912UL, 1778401280UL, 
1006646784UL,  704657920UL,      15360UL, 4294906368UL, 4294312960UL, 4294182400UL, 
4176741888UL, 2197030912UL,  821955072UL,  218041856UL,   83103744UL,   16725504UL, 
4294839808UL, 4294180864UL, 4294180864UL, 3371433984UL, 1693712384UL,  351535104UL, 
  15994368UL,   15997440UL,   16002048UL, 4294839808UL, 4293918720UL, 4293394432UL, 
3069313024UL, 1827930112UL,  552861696UL,   15993856UL,   15997440UL,   16001024UL, 
4289990656UL, 4289070080UL, 4289200640UL, 2896560640UL, 1890976256UL,  918684672UL, 
 114296832UL,   13506048UL,   13772800UL, 4285797376UL, 4283695104UL, 4283826176UL, 
2724200448UL, 1449132032UL, 1047922688UL,  411437568UL,    9441792UL,   10233856UL, 
4282784256UL, 4281994752UL, 4164027904UL, 2822243840UL, 1648100864UL,  775947264UL, 
 542247424UL,   39325696UL,    6958080UL, 4280818688UL, 4279504896UL, 4229303808UL, 
2887388672UL, 1780222976UL, 1008601600UL,  438438400UL,  271323136UL,    4073472UL, 
4279507456UL, 4278719488UL, 4278587904UL, 4261810176UL, 2751991808UL, 1678381056UL, 
 738856448UL,  168430080UL,    1845248UL, 4278199808UL, 4278198272UL, 4278197248UL, 
4278197248UL, 3321896448UL, 2013274624UL, 1140859392UL,  469768704UL,       8704UL, 
4294901760UL, 4294901760UL, 4294901760UL, 4294901760UL, 3607035904UL, 1996423168UL, 
 956235776UL,  385810432UL,   16711680UL, 4294901760UL, 4294180864UL, 4294180864UL, 
3706978304UL, 2499018752UL, 1223950336UL,  485752832UL,   83099648UL,   15990784UL, 
4294901760UL, 4293787648UL, 4293394432UL, 3337486336UL, 2465464320UL, 1593049088UL, 
 552861696UL,   49545216UL,   15990784UL, 4291821568UL, 4289724416UL, 4289986560UL, 
3064725504UL, 2360868864UL, 1723858944UL,  852492288UL,  114950144UL,   14417920UL, 
4287234048UL, 4285923328UL, 4286054400UL, 3598581760UL, 1987969024UL, 1619263488UL, 
1049624576UL,  345899008UL,   10616832UL, 4283564032UL, 4282777600UL, 4283564032UL, 
3025010688UL, 1917452288UL, 1112145920UL,  978714624UL,  442892288UL,    7340032UL, 
4280942592UL, 4280025088UL, 4280811520UL, 2854354944UL, 1814167552UL, 1009123328UL, 
 640417792UL,  473825280UL,    4456448UL, 4279107584UL, 4278583296UL, 4278452224UL, 
4278976512UL, 1946944512UL, 1141637632UL,  672399360UL,  336986112UL,    2490368UL, 
4278190080UL, 4278190080UL, 4278190080UL, 3791650816UL, 2684354560UL, 1879048192UL, 
1140850688UL,  436207616UL,          0UL, 
};

// 300x300x1, ClMlxx - Plain Draft, MLC Both

uint32_t ulMapDJ3600_ClMlxx_3x3x1[ 9 * 9 * 9 ] =
{
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL,          0UL,          0UL,          0UL, 
         0UL,          0UL,          0UL, 
};
APDK_END_NAMESPACE

#endif
