#include "txt_rr.h"

namespace ADNS {


	TXT_RR::TXT_RR()
	{
		rr_type = RR_TYPE::TXT;
		strings = gcnew List<DNS_CHARSTRING^>(0);
	}

	Void TXT_RR::PushCharString(DNS_CHARSTRING^ cs)
	{
		strings->Add(cs);
		UpdateRdata();
		return;
	}

	DNS_CHARSTRING^ TXT_RR::PopCharString()
	{
		int pos;
		DNS_CHARSTRING^ output;

		pos = strings->Count - 1;
		output = strings[pos];
		strings->RemoveAt(pos);
		UpdateRdata();
		return output;
	}

	bool TXT_RR::SetCharString(DNS_CHARSTRING^ cs, int pos)
	{
		if (pos >= strings->Count)
			return false;
		if (pos < 0)
			return false;

		strings[pos] = cs;

		return true;
	}

	DNS_CHARSTRING^ TXT_RR::GetCharString(int pos)
	{
		if ((pos >= strings->Count) || (pos < 0))
		{
			return nullptr;
		}
	
		return strings[pos];
	}

	String^ TXT_RR::Print()
	{
		String^ output;
		int i = 0;

		output = PrintHeader();

		for (i = 0; i < strings->Count; ++i)
		{
			output += " ";
			output += strings[i]->Print();
		}

		return output;
	}
	
	Void TXT_RR::UpdateRdata()
	{
		int overall_len = 0;
		int i = 0;
		int pos = 0;

		for (i = 0; i < strings->Count; ++i)
		{
			overall_len += strings[i]->Size();
		}

		if (!rdata)
			rdata = gcnew array<Byte>(overall_len);
		else
			rdata->Resize(rdata,overall_len);

		for (i = 0; i < strings->Count; ++i)
		{
			strings[i]->GetCharacterString()->CopyTo(rdata,pos);
			pos += strings[i]->Size();
		}

		return;
	}

	TXT_RR^ TXT_RR::Clone()
	{
		int i = 0;
		TXT_RR^ newrr = gcnew TXT_RR();
		newrr->rr_type = rr_type;
		newrr->owner = owner->Clone();
		newrr->ttl = ttl;
		newrr->rr_class = rr_class;
		newrr->strings = gcnew List<DNS_CHARSTRING^>(0);
		for (i = 0; i < strings->Count; ++i)
		{
			newrr->strings->Add(strings[i]->Clone());
		}
		newrr->UpdateRdata();
		return newrr;
	}
	
	ResourceRecord^ TXT_RR::ParseResourceRecord(array<Byte>^ domainname, UInt16 rr_type, UInt16 rr_class, UInt32 ttl, UInt16 rdata_len, array<Byte>^ packet, int rdata_start)
	{
		TXT_RR^ txtout;
		array<Byte>^ tmparray;
		int pos;
		int len;
		DNS_CHARSTRING^ cs;

		txtout = gcnew TXT_RR();
		txtout->owner = gcnew DOMAIN_NAME(domainname);
		txtout->rr_class = (RR_CLASS) rr_class;
		txtout->ttl = ttl;
		
		tmparray = gcnew array<Byte>(1);

		pos = 0;
		while (pos < rdata_len)
		{
			len = packet[rdata_start + pos];
			pos++;
			tmparray->Resize(tmparray,len);
			packet->Copy(packet,pos,tmparray,0,len);
			cs = gcnew DNS_CHARSTRING();
			cs->SetCharacterString(tmparray);
			txtout->PushCharString(cs);
			pos += len;
		}

		return txtout;
	}

	String^ TXT_RR::PrintRR(ResourceRecord^ rec)
	{
		return safe_cast<TXT_RR^>(rec)->Print();
	}

	ResourceRecord^ TXT_RR::CloneRR(ResourceRecord^ rec)
	{
		return safe_cast<TXT_RR^>(rec)->Clone();
	}

}