; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=instsimplify -S < %s | FileCheck %s

@A = linkonce_odr hidden constant { i64, i64 } { i64 2, i64 3 }
@B = linkonce_odr hidden global { i64, i64 } { i64 2, i64 3 }

declare i8* @llvm.strip.invariant.group.p0i8(i8* %p)
declare i8* @llvm.launder.invariant.group.p0i8(i8* %p)

define i64 @f() {
; CHECK-LABEL: @f(
; CHECK-NEXT:    ret i64 3
;
  %p = bitcast { i64, i64 }* @A to i8*
  %a = call i8* @llvm.strip.invariant.group.p0i8(i8* %p)
  %b = getelementptr i8, i8* %a, i32 8
  %c = bitcast i8* %b to i64*
  %d = load i64, i64* %c
  ret i64 %d
}

define i64 @g() {
; CHECK-LABEL: @g(
; CHECK-NEXT:    ret i64 3
;
  %p = bitcast { i64, i64 }* @A to i8*
  %a = call i8* @llvm.launder.invariant.group.p0i8(i8* %p)
  %b = getelementptr i8, i8* %a, i32 8
  %c = bitcast i8* %b to i64*
  %d = load i64, i64* %c
  ret i64 %d
}

define i64 @notconstantglobal() {
; CHECK-LABEL: @notconstantglobal(
; CHECK-NEXT:    [[A:%.*]] = call i8* @llvm.launder.invariant.group.p0i8(i8* bitcast ({ i64, i64 }* @B to i8*))
; CHECK-NEXT:    [[B:%.*]] = getelementptr i8, i8* [[A]], i32 8
; CHECK-NEXT:    [[C:%.*]] = bitcast i8* [[B]] to i64*
; CHECK-NEXT:    [[D:%.*]] = load i64, i64* [[C]], align 4
; CHECK-NEXT:    ret i64 [[D]]
;
  %p = bitcast { i64, i64 }* @B to i8*
  %a = call i8* @llvm.launder.invariant.group.p0i8(i8* %p)
  %b = getelementptr i8, i8* %a, i32 8
  %c = bitcast i8* %b to i64*
  %d = load i64, i64* %c
  ret i64 %d
}

define i64 @notconstantgepindex(i32 %i) {
; CHECK-LABEL: @notconstantgepindex(
; CHECK-NEXT:    [[A:%.*]] = call i8* @llvm.launder.invariant.group.p0i8(i8* bitcast ({ i64, i64 }* @A to i8*))
; CHECK-NEXT:    [[B:%.*]] = getelementptr i8, i8* [[A]], i32 [[I:%.*]]
; CHECK-NEXT:    [[C:%.*]] = bitcast i8* [[B]] to i64*
; CHECK-NEXT:    [[D:%.*]] = load i64, i64* [[C]], align 4
; CHECK-NEXT:    ret i64 [[D]]
;
  %p = bitcast { i64, i64 }* @A to i8*
  %a = call i8* @llvm.launder.invariant.group.p0i8(i8* %p)
  %b = getelementptr i8, i8* %a, i32 %i
  %c = bitcast i8* %b to i64*
  %d = load i64, i64* %c
  ret i64 %d
}

define i64 @volatile() {
; CHECK-LABEL: @volatile(
; CHECK-NEXT:    [[A:%.*]] = call i8* @llvm.launder.invariant.group.p0i8(i8* bitcast ({ i64, i64 }* @A to i8*))
; CHECK-NEXT:    [[B:%.*]] = getelementptr i8, i8* [[A]], i32 8
; CHECK-NEXT:    [[C:%.*]] = bitcast i8* [[B]] to i64*
; CHECK-NEXT:    [[D:%.*]] = load volatile i64, i64* [[C]], align 4
; CHECK-NEXT:    ret i64 [[D]]
;
  %p = bitcast { i64, i64 }* @A to i8*
  %a = call i8* @llvm.launder.invariant.group.p0i8(i8* %p)
  %b = getelementptr i8, i8* %a, i32 8
  %c = bitcast i8* %b to i64*
  %d = load volatile i64, i64* %c
  ret i64 %d
}
