/*
 * Decompiled with CFR 0.152.
 */
package com.claritysys.jvm.classfile;

public final class Utils {
    public static int parseType(String vmSignature) {
        int vmType;
        char ch = vmSignature.charAt(0);
        try {
            vmType = Utils.parseType(ch);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Bad signature: '" + vmSignature + "'");
        }
        return vmType;
    }

    public static int getStackWords(String fieldType) {
        int type = Utils.parseType(fieldType);
        return Utils.getStackWords(type);
    }

    public static int getStackWords(int type) {
        switch (type) {
            case 7: 
            case 11: {
                return 2;
            }
        }
        return 1;
    }

    public static int parseType(char ch) {
        int vmType;
        switch (ch) {
            case 'B': {
                vmType = 8;
                break;
            }
            case 'C': {
                vmType = 5;
                break;
            }
            case 'D': {
                vmType = 7;
                break;
            }
            case 'F': {
                vmType = 6;
                break;
            }
            case 'I': {
                vmType = 10;
                break;
            }
            case 'J': {
                vmType = 11;
                break;
            }
            case 'S': {
                vmType = 9;
                break;
            }
            case 'Z': {
                vmType = 4;
                break;
            }
            case 'V': {
                vmType = 12;
                break;
            }
            case 'L': {
                vmType = 14;
                break;
            }
            case '[': {
                vmType = 13;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: '" + ch + "'");
            }
        }
        return vmType;
    }

    public static int getMethodReturnType(String vmSignature) {
        int rpIndex = vmSignature.lastIndexOf(41);
        if (rpIndex <= 0 || rpIndex == vmSignature.length() - 1) {
            throw new IllegalArgumentException("Invalid method signature: " + vmSignature);
        }
        return Utils.parseType(vmSignature.charAt(rpIndex + 1));
    }

    public static int getMethodStackWords(String vmMethodSig) {
        int size = 0;
        int sigLength = vmMethodSig.lastIndexOf(41);
        block6: for (int i = 1; i < sigLength; ++i) {
            char c = vmMethodSig.charAt(i);
            switch (c) {
                case 'D': 
                case 'J': {
                    size += 2;
                    continue block6;
                }
                case 'B': 
                case 'C': 
                case 'F': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    ++size;
                    continue block6;
                }
                case 'L': {
                    ++size;
                    i = vmMethodSig.indexOf(59, i + 1);
                    if (i != -1) continue block6;
                    throw new IllegalStateException("Malformed vmMethodSig: " + vmMethodSig);
                }
                case '[': {
                    ++size;
                    int j = i + 1;
                    while (true) {
                        char nextCh;
                        if ((nextCh = vmMethodSig.charAt(j)) == 'L') {
                            j = vmMethodSig.indexOf(59, j + 1);
                            break;
                        }
                        if (nextCh != '[') break;
                        ++j;
                    }
                    i = j;
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Bad signature: " + vmMethodSig);
                }
            }
        }
        return size;
    }

    public static String[] getParameters(String vmMethodSig) {
        int sigLength = vmMethodSig.lastIndexOf(41);
        int COUNT = Utils.getParameterCount(vmMethodSig);
        String[] params = new String[COUNT];
        int parameter = 0;
        for (int i = 1; i < sigLength; ++i) {
            char c = vmMethodSig.charAt(i);
            switch (c) {
                case 'L': {
                    int j = vmMethodSig.indexOf(59, i + 1);
                    params[parameter] = vmMethodSig.substring(i, j + 1);
                    i = j;
                    break;
                }
                case '[': {
                    int j = i + 1;
                    while (true) {
                        char nextCh;
                        if ((nextCh = vmMethodSig.charAt(j)) == 'L') {
                            j = vmMethodSig.indexOf(59, j + 1);
                            continue;
                        }
                        if (nextCh != '[') break;
                        ++j;
                    }
                    params[parameter] = vmMethodSig.substring(i, j + 1);
                    i = j;
                    break;
                }
                default: {
                    params[parameter] = vmMethodSig.substring(i, i + 1);
                }
            }
            ++parameter;
        }
        return params;
    }

    public static int getParameterCount(String vmMethodSig) {
        int parameters = 0;
        int sigLength = vmMethodSig.lastIndexOf(41);
        for (int i = 1; i < sigLength; ++i) {
            char c = vmMethodSig.charAt(i);
            switch (c) {
                case 'L': {
                    i = vmMethodSig.indexOf(59, i + 1);
                    break;
                }
                case '[': {
                    int j = i + 1;
                    while (true) {
                        char nextCh;
                        if ((nextCh = vmMethodSig.charAt(j)) == 'L') {
                            j = vmMethodSig.indexOf(59, j + 1);
                            continue;
                        }
                        if (nextCh != '[') break;
                        ++j;
                    }
                    i = j;
                    break;
                }
            }
            ++parameters;
        }
        return parameters;
    }
}

