/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.xpath.XPathException;

public final class ItemChecker
extends ComputedExpression
implements MappingFunction {
    private Expression sequence;
    private ItemType requiredItemType;
    private RoleLocator role;

    public ItemChecker(Expression expression, ItemType itemType, RoleLocator roleLocator) {
        this.sequence = expression;
        this.requiredItemType = itemType;
        this.role = roleLocator;
    }

    public Expression simplify() throws XPathException {
        this.sequence = this.sequence.simplify();
        if (this.requiredItemType instanceof AnyItemType) {
            return this.sequence;
        }
        return this;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.sequence = this.sequence.analyze(staticContext);
        if (Type.isSubType(this.sequence.getItemType(), this.requiredItemType)) {
            return this.sequence;
        }
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        this.sequence = this.sequence.promote(promotionOffer);
        return this;
    }

    public Expression[] getSubExpressions() {
        Expression[] expressionArray = new Expression[]{this.sequence};
        return expressionArray;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.sequence.iterate(xPathContext);
        return new MappingIterator(sequenceIterator, this, null, null);
    }

    public Object map(Item item, XPathContext xPathContext, Object object) throws XPathException {
        this.testConformance(item);
        return item;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item = this.sequence.evaluateItem(xPathContext);
        if (item == null) {
            return null;
        }
        this.testConformance(item);
        return item;
    }

    private void testConformance(Item item) throws XPathException {
        if (!this.requiredItemType.matchesItem(item)) {
            this.typeError("Required type of " + this.role.getMessage() + " is " + this.requiredItemType.toString() + "; supplied value is " + Type.displayTypeName(item));
        }
    }

    public ItemType getItemType() {
        return this.requiredItemType;
    }

    public int computeCardinality() {
        return this.sequence.getCardinality();
    }

    public int computeSpecialProperties() {
        return this.sequence.getSpecialProperties();
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "treat as " + this.requiredItemType.toString());
        this.sequence.display(n + 1, namePool);
    }
}

