/*
 * linux-kernel specific functions
 * $Id: ifp_os.h,v 1.9.2.3 2005/08/22 03:03:56 oakhamg Exp $
 *
 * Copyright (C) Geoff Oakham, 2004; <oakhamg@users.sourceforge.net>
 */

#ifndef IFP_OS_H
#define IFP_OS_H 1

#ifdef __KERNEL__
	#include <linux/autoconf.h>
//	#include <linux/byteorder/generic.h>
	#include <linux/string.h>
	#include <linux/kernel.h>
	#include <linux/types.h>
	#include <linux/nls.h>
	#include <linux/module.h>
#else
	#include <inttypes.h>
	#include <stdio.h>
	#include <sys/types.h>
	#include <wchar.h>
	#include <string.h>
	#include <errno.h>
#endif

struct ifp_device;

int ifp_os_control_send(struct ifp_device * dev, int command,
	int arg1, int arg2, int * r1, int * r2);

int ifp_os_push(struct ifp_device * dev, void * p, int n);
int ifp_os_pop(struct ifp_device * dev, void * p, int n);

int ifp_os_init(struct ifp_device * dev, void * osdev);
int ifp_os_finalize(struct ifp_device * dev);

//'ms' is time in milli-seconds (1/1000ths of a second)
int ifp_os_sleep(int ms);

#ifdef __KERNEL__

//#define ifp_os_err(fmt, arg...) printk(KERN_ERR fmt, ##arg)
#define ifp_os_wrn(fmt, arg...) printk(KERN_WARNING fmt, ##arg)
#define ifp_os_dbg(fmt, arg...) printk(KERN_DEBUG fmt, ##arg)
#define ifp_os_info(fmt, arg...) printk(fmt, ##arg)
#define ifp_os_print(fmt, arg...) printk(fmt, ##arg)

#define IFP_EXPORT(x) EXPORT_SYMBOL(x)
#define ifp_strnicmp(a,b,c) strnicmp(a,b,c)

#define IFP_BUG_ON BUG_ON

#else //not __KERNEL__

//#define ifp_os_err(fmt, arg...) fprintf(stderr, "err:  " fmt, ##arg)
#define ifp_os_wrn(fmt, arg...) fprintf(stderr, "wrn:  " fmt, ##arg)
#define ifp_os_dbg(fmt, arg...) fprintf(stderr, "dbg:  " fmt, ##arg)
#define ifp_os_info(fmt, arg...) fprintf(stderr, "info: " fmt, ##arg)
#define ifp_os_print(fmt, arg...) fprintf(stderr, fmt, ##arg)

#define IFP_EXPORT(x) //nothing
#define ifp_strnicmp(a,b,c) strncasecmp(a,b,c)

#define IFP_BUG_ON(b) \
	if (b) { ifp_os_print("bug assertion tripped in %s() at %s:%d", \
		__FUNCTION__ , __FILE__ , __LINE__ ); }

//stolen from linux/kernel.h
#ifndef   min
#  define min(x,y) ({ \
	typeof(x) _x = (x);     \
	typeof(y) _y = (y);     \
	(void) (&_x == &_y);    \
	_x < _y ? _x : _y; })
#endif
#ifndef   max
#  define max(x,y) ({ \
	typeof(x) _x = (x);     \
	typeof(y) _y = (y);     \
	(void) (&_x == &_y);    \
	_x > _y ? _x : _y; })
#endif

#endif //__KERNEL__

#if defined(CONFIG_IRIVER_FS_RENAME)
#define IFP_RENAME
#endif

#if defined(CONFIG_IRIVER_FS_DEBUG_VFS)
#define IFP_DEBUG_SYSCALL 1
#endif

#if defined(CONFIG_IRIVER_FS_DEBUG_USB)
#define IFP_DEBUG_USB_SNOOPING 1
	#if defined(CONFIG_IRIVER_FS_DEBUG_USB_RAW)
	#define IFP_DEBUG_USB_RAWDATA 1
	#endif
#endif

//automake config switches
#if defined(AMM_USBDBG)
#define IFP_DEBUG_USB_SNOOPING 1
#endif

#if defined(AMM_USBVERBOSE)
#define IFP_DEBUG_USB_RAWDATA 1
#if !defined(IFP_DEBUG_USB_SNOOPING)
#define IFP_DEBUG_USB_SNOOPING 1
#endif
#endif

//I would like this moved into ifp.h because it's so useful our callers
//might want to use it.

#define ifp_wrn(fmt, arg...) ifp_os_wrn("[%s] " fmt "\n", __FUNCTION__ , ##arg)
#define ifp_dbg(fmt, arg...) ifp_os_dbg("[%s] " fmt "\n", __FUNCTION__ , ##arg)
#define ifp_info(fmt, arg...) ifp_os_info(fmt "\n", ##arg)
#define ifp_print(fmt, arg...) ifp_os_print(fmt, ##arg)

#if 0
#define ifp_err(fmt, arg...) ifp_os_err("[%s] " fmt "\n", __FUNCTION__ , ##arg)
#define ifp_err_i(i, fmt, arg...) ifp_err("err=%d. " fmt, i, ##arg)
#define ifp_err_jump(i, label, fmt, arg...) \
	if (i) { ifp_err_i(i, fmt, ##arg); goto label; }
#define ifp_err_expect(i, e, label, fmt, arg...) \
	if (i) { if(!(e)){ifp_err_i(i, fmt, ##arg);} goto label; }
#endif

#define ifp_wrn_on(b, fmt, arg...) \
	if (b) { ifp_wrn("warning: " fmt, ##arg); }

int ifp_locale_to_utf16(char * o, int max_o, const char * i, int max_i);
int ifp_utf16_to_locale(char * o, int max_o, const char * i, int max_i);

/*  I truely wish this section didn't exist.. mostly because this is neither
 *  the first nor last time I've written something like it.  Ideally, someone
 *  like ANSI, ISO or even GCC would put their foot down and define standard
 *  macros for handling portable data.
 */

#if defined(__KERNEL__)

#define ifp_os_cpu_to_le32  cpu_to_le32
#define ifp_os_cpu_to_le16  cpu_to_le16
#if 0
	//I'll change this back when 2.6.9 stablizes
	#define ifp_os_le32_to_cpup le32_to_cpup
	#define ifp_os_le16_to_cpup le16_to_cpup
#else
	#define ifp_os_le32_to_cpup(x) (*(__force uint32_t*)(x))
	#define ifp_os_le16_to_cpup(x) (*(__force uint16_t*)(x))
#endif

#else //kernel

#ifndef WORDS_BIGENDIAN
	//Little endian
	#define ifp_os_cpu_to_le16(x) ((uint16_t)(x))
	#define ifp_os_cpu_to_le32(x) ((uint32_t)(x))
	#define ifp_os_le16_to_cpup(x) (*(uint16_t*)(x))
	#define ifp_os_le32_to_cpup(x) (*(uint32_t*)(x))
#else
	//Big endian
	#warning "Big endian support has not yet been tested.  Please report if this code works for you."
	#define ifp_os_swap16(x) ( \
			((uint16_t)x & 0x00ff) << 8 | \
			((uint16_t)x & 0xff00) >> 8   \
			)

	#define ifp_os_swap32(x) ( \
			((uint32_t)x & 0x000000ff) << 24 | \
			((uint32_t)x & 0x0000ff00) << 8  | \
			((uint32_t)x & 0x00ff0000) >> 8  | \
			((uint32_t)x & 0xff000000) >> 24   \
			)

	#define ifp_os_cpu_to_le16(x) (ifp_os_swap16(x))
	#define ifp_os_cpu_to_le32(x) (ifp_os_swap32(x))
	#define ifp_os_le16_to_cpup(x) (ifp_os_swap16(*(uint16_t*)(x)))
	#define ifp_os_le32_to_cpup(x) (ifp_os_swap32(*(uint32_t*)(x)))
#endif //endian
#endif //kernel

#endif // IFP_OS_H

