// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_POWER_SAVE_BLOCKER_POWER_SAVE_BLOCKER_SERVICE_H_
#define DEVICE_POWER_SAVE_BLOCKER_POWER_SAVE_BLOCKER_SERVICE_H_

#include <string>

#include "base/memory/ref_counted.h"
#include "device/power_save_blocker/power_save_blocker.h"

namespace device {

class PowerSaveBlockerService {
 public:
  virtual ~PowerSaveBlockerService() {}

  virtual int CreatePowerSaveBlocker(
      PowerSaveBlocker::PowerSaveBlockerType type,
      PowerSaveBlocker::Reason reason,
      const std::string& description) = 0;

  virtual void CancelPowerSaveBlocker(int id) = 0;
};

}; // namespace device

#endif // DEVICE_POWER_SAVE_BLOCKER_POWER_SAVE_BLOCKER_SERVICE_H_
