#ifndef INCLUDE_MODULE_OSSMIXER_H
#define INCLUDE_MODULE_OSSMIXER_H
/* ----------------------------------------------------------------------------
 * module_ossmixer.h
 * prototypes and definitions for the OSS mixer module.
 *
 * Copyright 2002-2005 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

#include <pbbtaglist.h>

#define DEFAULT_MIXER	"/dev/mixer"

#define VOLUME_MAX		100
#define VOLUME_MIN		0
#define VOLUME_FR		6     /* volume failure range defines */
                             /* how wide the hardware volume level */
							/* is allowed to jitter without adjustment */

struct modflags_ossmixer {
	unsigned int mixer_delayed:1;
	unsigned int init_complete:1;
	unsigned int mute:1;
	unsigned int open:1;  /* module open ? */
	unsigned int:0;
};

/* public prototypes */
int ossmixer_init ();
int ossmixer_open (struct tagitem *taglist);
int ossmixer_close ();
int ossmixer_exit ();

/* private prototypes */
int ossmixer_finish_init ();
void ossmixer_keyboard (struct tagitem *taglist);
void ossmixer_query (struct tagitem *taglist);
void ossmixer_configure (struct tagitem *taglist);
void ossmixer_handle_tags (int cfgure, struct tagitem *taglist);
int ossmixer_set_and_send (int increment);
int increment_master_volume(int increment);
void set_slaves_volume ();
int set_volume(int fd, int channel, int volume);
int get_volume(int fd, int channel);
int get_mixer_devmask(int fd);
void ossmixer_setuserdevmask (char *channels);
char* ossmixer_getuserdevmask (int devmask);

#endif    /* INCLUDE_MODULE_OSSMIXER_H */
