/* autosave-manager.c generated by valac 0.30.1, the Vala compiler
 * generated from autosave-manager.vala, do not modify */

/*
 * Copyright (C) 2011 Timo Kluck
 * Authors: Timo Kluck <tkluck@infty.nl>
 *          Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_AUTOSAVE_MANAGER (autosave_manager_get_type ())
#define AUTOSAVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AUTOSAVE_MANAGER, AutosaveManager))
#define AUTOSAVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AUTOSAVE_MANAGER, AutosaveManagerClass))
#define IS_AUTOSAVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AUTOSAVE_MANAGER))
#define IS_AUTOSAVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AUTOSAVE_MANAGER))
#define AUTOSAVE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AUTOSAVE_MANAGER, AutosaveManagerClass))

typedef struct _AutosaveManager AutosaveManager;
typedef struct _AutosaveManagerClass AutosaveManagerClass;
typedef struct _AutosaveManagerPrivate AutosaveManagerPrivate;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _book_unref0(var) ((var == NULL) ? NULL : (var = (book_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
typedef struct _ParamSpecAutosaveManager ParamSpecAutosaveManager;

struct _AutosaveManager {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AutosaveManagerPrivate * priv;
};

struct _AutosaveManagerClass {
	GTypeClass parent_class;
	void (*finalize) (AutosaveManager *self);
};

struct _AutosaveManagerPrivate {
	guint update_timeout;
	GHashTable* page_filenames;
	Book* book_;
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _ParamSpecAutosaveManager {
	GParamSpec parent_instance;
};


static gpointer autosave_manager_parent_class = NULL;
static gchar* autosave_manager_AUTOSAVE_DIR;
static gchar* autosave_manager_AUTOSAVE_DIR = NULL;
static gchar* autosave_manager_AUTOSAVE_FILENAME;
static gchar* autosave_manager_AUTOSAVE_FILENAME = NULL;
static gchar* autosave_manager_AUTOSAVE_PATH;
static gchar* autosave_manager_AUTOSAVE_PATH = NULL;

gpointer autosave_manager_ref (gpointer instance);
void autosave_manager_unref (gpointer instance);
GParamSpec* param_spec_autosave_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_autosave_manager (GValue* value, gpointer v_object);
void value_take_autosave_manager (GValue* value, gpointer v_object);
gpointer value_get_autosave_manager (const GValue* value);
GType autosave_manager_get_type (void) G_GNUC_CONST;
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
#define AUTOSAVE_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_AUTOSAVE_MANAGER, AutosaveManagerPrivate))
enum  {
	AUTOSAVE_MANAGER_DUMMY_PROPERTY
};
AutosaveManager* autosave_manager_new (void);
AutosaveManager* autosave_manager_construct (GType object_type);
static void _page_unref0_ (gpointer var);
static void _g_free0_ (gpointer var);
void autosave_manager_load (AutosaveManager* self);
Book* autosave_manager_get_book (AutosaveManager* self);
void book_clear (Book* self);
static gchar* autosave_manager_get_value (AutosaveManager* self, GKeyFile* file, const gchar* group_name, const gchar* key, const gchar* _default_);
static gint autosave_manager_get_integer (AutosaveManager* self, GKeyFile* file, const gchar* group_name, const gchar* key, gint _default_);
GType scan_direction_get_type (void) G_GNUC_CONST;
static gboolean autosave_manager_get_boolean (AutosaveManager* self, GKeyFile* file, const gchar* group_name, const gchar* key, gboolean _default_);
Page* page_new_from_data (gint scan_width, gint scan_height, gint rowstride, gint n_channels, gint depth, gint dpi, ScanDirection scan_direction, const gchar* color_profile, guchar* pixels, int pixels_length1, gboolean has_crop, const gchar* crop_name, gint crop_x, gint crop_y, gint crop_width, gint crop_height);
Page* page_construct_from_data (GType object_type, gint scan_width, gint scan_height, gint rowstride, gint n_channels, gint depth, gint dpi, ScanDirection scan_direction, const gchar* color_profile, guchar* pixels, int pixels_length1, gboolean has_crop, const gchar* crop_name, gint crop_x, gint crop_y, gint crop_width, gint crop_height);
void book_append_page (Book* self, Page* page);
void autosave_manager_cleanup (AutosaveManager* self);
void autosave_manager_on_page_added (AutosaveManager* self, Page* page);
void autosave_manager_on_scan_finished (AutosaveManager* self, Page* page);
static void _autosave_manager_on_scan_finished_page_scan_finished (Page* _sender, gpointer self);
void autosave_manager_on_changed (AutosaveManager* self);
static void _autosave_manager_on_changed_page_crop_changed (Page* _sender, gpointer self);
void autosave_manager_on_page_removed (AutosaveManager* self, Page* page);
static void autosave_manager_save_pixels (AutosaveManager* self, Page* page);
static void autosave_manager_save (AutosaveManager* self, gboolean do_timeout);
void autosave_manager_on_cleared (AutosaveManager* self);
static gboolean ___lambda4_ (AutosaveManager* self);
static void autosave_manager_real_save (AutosaveManager* self);
static gboolean ____lambda4__gsource_func (gpointer self);
guint book_get_n_pages (Book* self);
Page* book_get_page (Book* self, gint page_number);
gboolean page_get_has_data (Page* self);
gint page_get_scan_width (Page* self);
gint page_get_scan_height (Page* self);
gint page_get_rowstride (Page* self);
gint page_get_n_channels (Page* self);
gint page_get_depth (Page* self);
gint page_get_dpi (Page* self);
ScanDirection page_get_scan_direction (Page* self);
const gchar* page_get_color_profile (Page* self);
gboolean page_get_has_crop (Page* self);
const gchar* page_get_crop_name (Page* self);
gint page_get_crop_x (Page* self);
gint page_get_crop_y (Page* self);
gint page_get_crop_width (Page* self);
gint page_get_crop_height (Page* self);
guchar* page_get_pixels (Page* self, int* result_length1);
void autosave_manager_set_book (AutosaveManager* self, Book* value);
static void _autosave_manager_on_page_added_book_page_added (Book* _sender, Page* page, gpointer self);
static void _autosave_manager_on_page_removed_book_page_removed (Book* _sender, Page* page, gpointer self);
static void _autosave_manager_on_changed_book_reordered (Book* _sender, gpointer self);
static void _autosave_manager_on_cleared_book_cleared (Book* _sender, gpointer self);
static void autosave_manager_finalize (AutosaveManager* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _page_unref0_ (gpointer var) {
#line 59 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	(var == NULL) ? NULL : (var = (page_unref (var), NULL));
#line 189 "autosave-manager.c"
}


static void _g_free0_ (gpointer var) {
#line 59 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	var = (g_free (var), NULL);
#line 196 "autosave-manager.c"
}


AutosaveManager* autosave_manager_construct (GType object_type) {
	AutosaveManager* self = NULL;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
#line 57 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	self = (AutosaveManager*) g_type_create_instance (object_type);
#line 59 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp0_ = g_direct_hash;
#line 59 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp1_ = g_direct_equal;
#line 59 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _page_unref0_, _g_free0_);
#line 59 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_g_hash_table_unref0 (self->priv->page_filenames);
#line 59 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	self->priv->page_filenames = _tmp2_;
#line 57 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	return self;
#line 219 "autosave-manager.c"
}


AutosaveManager* autosave_manager_new (void) {
#line 57 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	return autosave_manager_construct (TYPE_AUTOSAVE_MANAGER);
#line 226 "autosave-manager.c"
}


static gpointer _page_ref0 (gpointer self) {
#line 151 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	return self ? page_ref (self) : NULL;
#line 233 "autosave-manager.c"
}


void autosave_manager_load (AutosaveManager* self) {
	Book* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	GKeyFile* file = NULL;
	GKeyFile* _tmp3_ = NULL;
	gchar* pages = NULL;
	GKeyFile* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar** _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
#line 62 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 64 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_debug ("autosave-manager.vala:64: Loading autosave information");
#line 66 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp0_ = autosave_manager_get_book (self);
#line 66 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp1_ = _tmp0_;
#line 66 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	book_clear (_tmp1_);
#line 67 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp2_ = self->priv->page_filenames;
#line 67 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_hash_table_remove_all (_tmp2_);
#line 69 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp3_ = g_key_file_new ();
#line 69 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	file = _tmp3_;
#line 268 "autosave-manager.c"
	{
		GKeyFile* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 72 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp4_ = file;
#line 72 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp5_ = autosave_manager_AUTOSAVE_PATH;
#line 72 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_key_file_load_from_file (_tmp4_, _tmp5_, G_KEY_FILE_NONE, &_inner_error_);
#line 72 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 280 "autosave-manager.c"
			goto __catch28_g_error;
		}
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError* e = NULL;
#line 70 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		e = _inner_error_;
#line 70 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_inner_error_ = NULL;
#line 76 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_warning ("autosave-manager.vala:76: Could not load autosave infomation; not rest" \
"oring any autosaves");
#line 77 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_g_error_free0 (e);
#line 77 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_g_key_file_unref0 (file);
#line 77 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		return;
#line 300 "autosave-manager.c"
	}
	__finally28:
#line 70 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 70 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_g_key_file_unref0 (file);
#line 70 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 70 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_clear_error (&_inner_error_);
#line 70 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		return;
#line 313 "autosave-manager.c"
	}
#line 79 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp6_ = file;
#line 79 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp7_ = autosave_manager_get_value (self, _tmp6_, "simple-scan", "pages", "");
#line 79 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	pages = _tmp7_;
#line 80 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp8_ = pages;
#line 80 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, " ", 0);
#line 325 "autosave-manager.c"
	{
		gchar** page_name_collection = NULL;
		gint page_name_collection_length1 = 0;
		gint _page_name_collection_size_ = 0;
		gint page_name_it = 0;
#line 80 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		page_name_collection = _tmp10_;
#line 80 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		page_name_collection_length1 = _vala_array_length (_tmp9_);
#line 80 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		for (page_name_it = 0; page_name_it < _vala_array_length (_tmp9_); page_name_it = page_name_it + 1) {
#line 337 "autosave-manager.c"
			gchar* _tmp11_ = NULL;
			gchar* page_name = NULL;
#line 80 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
			_tmp11_ = g_strdup (page_name_collection[page_name_it]);
#line 80 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
			page_name = _tmp11_;
#line 344 "autosave-manager.c"
			{
				const gchar* _tmp12_ = NULL;
				gint scan_width = 0;
				GKeyFile* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				gint _tmp15_ = 0;
				gint scan_height = 0;
				GKeyFile* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				gint rowstride = 0;
				GKeyFile* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				gint _tmp21_ = 0;
				gint n_channels = 0;
				GKeyFile* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				gint _tmp24_ = 0;
				gint depth = 0;
				GKeyFile* _tmp25_ = NULL;
				const gchar* _tmp26_ = NULL;
				gint _tmp27_ = 0;
				gint dpi = 0;
				GKeyFile* _tmp28_ = NULL;
				const gchar* _tmp29_ = NULL;
				gint _tmp30_ = 0;
				gchar* scan_direction_name = NULL;
				GKeyFile* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
				gchar* _tmp33_ = NULL;
				ScanDirection scan_direction = 0;
				const gchar* _tmp34_ = NULL;
				const gchar* _tmp35_ = NULL;
				GQuark _tmp37_ = 0U;
#line 92 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				static GQuark _tmp36_label0 = 0;
#line 92 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				static GQuark _tmp36_label1 = 0;
#line 92 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				static GQuark _tmp36_label2 = 0;
#line 92 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				static GQuark _tmp36_label3 = 0;
#line 387 "autosave-manager.c"
				gchar* color_profile = NULL;
				GKeyFile* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
				gchar* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				gchar* pixels_filename = NULL;
				GKeyFile* _tmp42_ = NULL;
				const gchar* _tmp43_ = NULL;
				gchar* _tmp44_ = NULL;
				gboolean has_crop = FALSE;
				GKeyFile* _tmp45_ = NULL;
				const gchar* _tmp46_ = NULL;
				gboolean _tmp47_ = FALSE;
				gchar* crop_name = NULL;
				GKeyFile* _tmp48_ = NULL;
				const gchar* _tmp49_ = NULL;
				gchar* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				gint crop_x = 0;
				GKeyFile* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				gint _tmp54_ = 0;
				gint crop_y = 0;
				GKeyFile* _tmp55_ = NULL;
				const gchar* _tmp56_ = NULL;
				gint _tmp57_ = 0;
				gint crop_width = 0;
				GKeyFile* _tmp58_ = NULL;
				const gchar* _tmp59_ = NULL;
				gint _tmp60_ = 0;
				gint crop_height = 0;
				GKeyFile* _tmp61_ = NULL;
				const gchar* _tmp62_ = NULL;
				gint _tmp63_ = 0;
				guchar* pixels = NULL;
				gint pixels_length1 = 0;
				gint _pixels_size_ = 0;
				const gchar* _tmp64_ = NULL;
				Page* page = NULL;
				gint _tmp73_ = 0;
				gint _tmp74_ = 0;
				gint _tmp75_ = 0;
				gint _tmp76_ = 0;
				gint _tmp77_ = 0;
				gint _tmp78_ = 0;
				ScanDirection _tmp79_ = 0;
				const gchar* _tmp80_ = NULL;
				guchar* _tmp81_ = NULL;
				gint _tmp81__length1 = 0;
				gboolean _tmp82_ = FALSE;
				const gchar* _tmp83_ = NULL;
				gint _tmp84_ = 0;
				gint _tmp85_ = 0;
				gint _tmp86_ = 0;
				gint _tmp87_ = 0;
				Page* _tmp88_ = NULL;
				GHashTable* _tmp89_ = NULL;
				Page* _tmp90_ = NULL;
				Page* _tmp91_ = NULL;
				const gchar* _tmp92_ = NULL;
				gchar* _tmp93_ = NULL;
				Book* _tmp94_ = NULL;
				Book* _tmp95_ = NULL;
				Page* _tmp96_ = NULL;
#line 82 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp12_ = page_name;
#line 82 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				g_debug ("autosave-manager.vala:82: Loading automatically saved page %s", _tmp12_);
#line 84 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp13_ = file;
#line 84 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp14_ = page_name;
#line 84 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp15_ = autosave_manager_get_integer (self, _tmp13_, _tmp14_, "scan-width", 0);
#line 84 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				scan_width = _tmp15_;
#line 85 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp16_ = file;
#line 85 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp17_ = page_name;
#line 85 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp18_ = autosave_manager_get_integer (self, _tmp16_, _tmp17_, "scan-height", 0);
#line 85 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				scan_height = _tmp18_;
#line 86 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp19_ = file;
#line 86 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp20_ = page_name;
#line 86 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp21_ = autosave_manager_get_integer (self, _tmp19_, _tmp20_, "rowstride", 0);
#line 86 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				rowstride = _tmp21_;
#line 87 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp22_ = file;
#line 87 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp23_ = page_name;
#line 87 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp24_ = autosave_manager_get_integer (self, _tmp22_, _tmp23_, "n-channels", 0);
#line 87 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				n_channels = _tmp24_;
#line 88 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp25_ = file;
#line 88 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp26_ = page_name;
#line 88 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp27_ = autosave_manager_get_integer (self, _tmp25_, _tmp26_, "depth", 0);
#line 88 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				depth = _tmp27_;
#line 89 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp28_ = file;
#line 89 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp29_ = page_name;
#line 89 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp30_ = autosave_manager_get_integer (self, _tmp28_, _tmp29_, "dpi", 0);
#line 89 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				dpi = _tmp30_;
#line 90 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp31_ = file;
#line 90 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp32_ = page_name;
#line 90 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp33_ = autosave_manager_get_value (self, _tmp31_, _tmp32_, "scan-direction", "");
#line 90 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				scan_direction_name = _tmp33_;
#line 91 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				scan_direction = SCAN_DIRECTION_TOP_TO_BOTTOM;
#line 92 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp34_ = scan_direction_name;
#line 92 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp35_ = _tmp34_;
#line 92 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp37_ = (NULL == _tmp35_) ? 0 : g_quark_from_string (_tmp35_);
#line 92 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				if (_tmp37_ == ((0 != _tmp36_label0) ? _tmp36_label0 : (_tmp36_label0 = g_quark_from_static_string ("TOP_TO_BOTTOM")))) {
#line 92 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					switch (0) {
#line 524 "autosave-manager.c"
						default:
						{
#line 95 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
							scan_direction = SCAN_DIRECTION_TOP_TO_BOTTOM;
#line 96 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
							break;
#line 531 "autosave-manager.c"
						}
					}
				} else if (_tmp37_ == ((0 != _tmp36_label1) ? _tmp36_label1 : (_tmp36_label1 = g_quark_from_static_string ("LEFT_TO_RIGHT")))) {
#line 92 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					switch (0) {
#line 537 "autosave-manager.c"
						default:
						{
#line 98 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
							scan_direction = SCAN_DIRECTION_LEFT_TO_RIGHT;
#line 99 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
							break;
#line 544 "autosave-manager.c"
						}
					}
				} else if (_tmp37_ == ((0 != _tmp36_label2) ? _tmp36_label2 : (_tmp36_label2 = g_quark_from_static_string ("BOTTOM_TO_TOP")))) {
#line 92 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					switch (0) {
#line 550 "autosave-manager.c"
						default:
						{
#line 101 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
							scan_direction = SCAN_DIRECTION_BOTTOM_TO_TOP;
#line 102 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
							break;
#line 557 "autosave-manager.c"
						}
					}
				} else if (_tmp37_ == ((0 != _tmp36_label3) ? _tmp36_label3 : (_tmp36_label3 = g_quark_from_static_string ("RIGHT_TO_LEFT")))) {
#line 92 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					switch (0) {
#line 563 "autosave-manager.c"
						default:
						{
#line 104 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
							scan_direction = SCAN_DIRECTION_RIGHT_TO_LEFT;
#line 105 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
							break;
#line 570 "autosave-manager.c"
						}
					}
				}
#line 107 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp38_ = file;
#line 107 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp39_ = page_name;
#line 107 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp40_ = autosave_manager_get_value (self, _tmp38_, _tmp39_, "color-profile", "");
#line 107 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				color_profile = _tmp40_;
#line 108 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp41_ = color_profile;
#line 108 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				if (g_strcmp0 (_tmp41_, "") == 0) {
#line 109 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					_g_free0 (color_profile);
#line 109 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					color_profile = NULL;
#line 590 "autosave-manager.c"
				}
#line 110 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp42_ = file;
#line 110 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp43_ = page_name;
#line 110 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp44_ = autosave_manager_get_value (self, _tmp42_, _tmp43_, "pixels-filename", "");
#line 110 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				pixels_filename = _tmp44_;
#line 111 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp45_ = file;
#line 111 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp46_ = page_name;
#line 111 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp47_ = autosave_manager_get_boolean (self, _tmp45_, _tmp46_, "has-crop", FALSE);
#line 111 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				has_crop = _tmp47_;
#line 112 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp48_ = file;
#line 112 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp49_ = page_name;
#line 112 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp50_ = autosave_manager_get_value (self, _tmp48_, _tmp49_, "crop-name", "");
#line 112 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				crop_name = _tmp50_;
#line 113 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp51_ = crop_name;
#line 113 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				if (g_strcmp0 (_tmp51_, "") == 0) {
#line 114 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					_g_free0 (crop_name);
#line 114 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					crop_name = NULL;
#line 624 "autosave-manager.c"
				}
#line 115 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp52_ = file;
#line 115 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp53_ = page_name;
#line 115 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp54_ = autosave_manager_get_integer (self, _tmp52_, _tmp53_, "crop-x", 0);
#line 115 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				crop_x = _tmp54_;
#line 116 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp55_ = file;
#line 116 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp56_ = page_name;
#line 116 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp57_ = autosave_manager_get_integer (self, _tmp55_, _tmp56_, "crop-y", 0);
#line 116 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				crop_y = _tmp57_;
#line 117 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp58_ = file;
#line 117 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp59_ = page_name;
#line 117 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp60_ = autosave_manager_get_integer (self, _tmp58_, _tmp59_, "crop-width", 0);
#line 117 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				crop_width = _tmp60_;
#line 118 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp61_ = file;
#line 118 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp62_ = page_name;
#line 118 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp63_ = autosave_manager_get_integer (self, _tmp61_, _tmp62_, "crop-height", 0);
#line 118 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				crop_height = _tmp63_;
#line 120 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				pixels = NULL;
#line 120 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				pixels_length1 = 0;
#line 120 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_pixels_size_ = pixels_length1;
#line 121 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp64_ = pixels_filename;
#line 121 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				if (g_strcmp0 (_tmp64_, "") != 0) {
#line 668 "autosave-manager.c"
					gchar* path = NULL;
					const gchar* _tmp65_ = NULL;
					const gchar* _tmp66_ = NULL;
					gchar* _tmp67_ = NULL;
					GFile* f = NULL;
					const gchar* _tmp68_ = NULL;
					GFile* _tmp69_ = NULL;
#line 123 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					_tmp65_ = autosave_manager_AUTOSAVE_DIR;
#line 123 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					_tmp66_ = pixels_filename;
#line 123 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					_tmp67_ = g_build_filename (_tmp65_, _tmp66_, NULL);
#line 123 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					path = _tmp67_;
#line 124 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					_tmp68_ = path;
#line 124 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					_tmp69_ = g_file_new_for_path (_tmp68_);
#line 124 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					f = _tmp69_;
#line 690 "autosave-manager.c"
					{
						GFile* _tmp70_ = NULL;
						guint8* _tmp71_ = NULL;
						gsize _tmp72_;
#line 127 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						_tmp70_ = f;
#line 127 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						g_file_load_contents (_tmp70_, NULL, &_tmp71_, &_tmp72_, NULL, &_inner_error_);
#line 127 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						pixels = (g_free (pixels), NULL);
#line 127 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						pixels = _tmp71_;
#line 127 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						pixels_length1 = _tmp72_;
#line 127 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						_pixels_size_ = pixels_length1;
#line 127 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 709 "autosave-manager.c"
							goto __catch29_g_error;
						}
					}
					goto __finally29;
					__catch29_g_error:
					{
						GError* e = NULL;
#line 125 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						e = _inner_error_;
#line 125 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						_inner_error_ = NULL;
#line 131 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						g_warning ("autosave-manager.vala:131: Failed to load pixel information");
#line 132 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						_g_error_free0 (e);
#line 132 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						_g_object_unref0 (f);
#line 132 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						_g_free0 (path);
#line 132 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						pixels = (g_free (pixels), NULL);
#line 132 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						_g_free0 (crop_name);
#line 132 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						_g_free0 (pixels_filename);
#line 132 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						_g_free0 (color_profile);
#line 132 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						_g_free0 (scan_direction_name);
#line 132 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						_g_free0 (page_name);
#line 132 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						continue;
#line 743 "autosave-manager.c"
					}
					__finally29:
#line 125 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 125 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						_g_object_unref0 (f);
#line 125 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						_g_free0 (path);
#line 125 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						pixels = (g_free (pixels), NULL);
#line 125 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						_g_free0 (crop_name);
#line 125 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						_g_free0 (pixels_filename);
#line 125 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						_g_free0 (color_profile);
#line 125 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						_g_free0 (scan_direction_name);
#line 125 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						_g_free0 (page_name);
#line 125 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						page_name_collection = (_vala_array_free (page_name_collection, page_name_collection_length1, (GDestroyNotify) g_free), NULL);
#line 125 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						_g_free0 (pages);
#line 125 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						_g_key_file_unref0 (file);
#line 125 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 125 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						g_clear_error (&_inner_error_);
#line 125 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						return;
#line 776 "autosave-manager.c"
					}
#line 121 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					_g_object_unref0 (f);
#line 121 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					_g_free0 (path);
#line 782 "autosave-manager.c"
				}
#line 136 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp73_ = scan_width;
#line 136 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp74_ = scan_height;
#line 136 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp75_ = rowstride;
#line 136 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp76_ = n_channels;
#line 136 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp77_ = depth;
#line 136 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp78_ = dpi;
#line 136 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp79_ = scan_direction;
#line 136 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp80_ = color_profile;
#line 136 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp81_ = pixels;
#line 136 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp81__length1 = pixels_length1;
#line 136 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp82_ = has_crop;
#line 136 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp83_ = crop_name;
#line 136 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp84_ = crop_x;
#line 136 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp85_ = crop_y;
#line 136 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp86_ = crop_width;
#line 136 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp87_ = crop_height;
#line 136 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp88_ = page_new_from_data (_tmp73_, _tmp74_, _tmp75_, _tmp76_, _tmp77_, _tmp78_, _tmp79_, _tmp80_, _tmp81_, _tmp81__length1, _tmp82_, _tmp83_, _tmp84_, _tmp85_, _tmp86_, _tmp87_);
#line 136 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				page = _tmp88_;
#line 151 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp89_ = self->priv->page_filenames;
#line 151 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp90_ = page;
#line 151 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp91_ = _page_ref0 (_tmp90_);
#line 151 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp92_ = pixels_filename;
#line 151 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp93_ = g_strdup (_tmp92_);
#line 151 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				g_hash_table_insert (_tmp89_, _tmp91_, _tmp93_);
#line 152 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp94_ = autosave_manager_get_book (self);
#line 152 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp95_ = _tmp94_;
#line 152 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp96_ = page;
#line 152 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				book_append_page (_tmp95_, _tmp96_);
#line 80 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_page_unref0 (page);
#line 80 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				pixels = (g_free (pixels), NULL);
#line 80 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_g_free0 (crop_name);
#line 80 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_g_free0 (pixels_filename);
#line 80 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_g_free0 (color_profile);
#line 80 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_g_free0 (scan_direction_name);
#line 80 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_g_free0 (page_name);
#line 854 "autosave-manager.c"
			}
		}
#line 80 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		page_name_collection = (_vala_array_free (page_name_collection, page_name_collection_length1, (GDestroyNotify) g_free), NULL);
#line 859 "autosave-manager.c"
	}
#line 62 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_g_free0 (pages);
#line 62 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_g_key_file_unref0 (file);
#line 865 "autosave-manager.c"
}


static gchar* autosave_manager_get_value (AutosaveManager* self, GKeyFile* file, const gchar* group_name, const gchar* key, const gchar* _default_) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 156 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 156 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 156 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_val_if_fail (group_name != NULL, NULL);
#line 156 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 156 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_val_if_fail (_default_ != NULL, NULL);
#line 882 "autosave-manager.c"
	{
		gchar* _tmp0_ = NULL;
		GKeyFile* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 160 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp1_ = file;
#line 160 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp2_ = group_name;
#line 160 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp3_ = key;
#line 160 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp4_ = g_key_file_get_value (_tmp1_, _tmp2_, _tmp3_, &_inner_error_);
#line 160 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp0_ = _tmp4_;
#line 160 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 902 "autosave-manager.c"
			goto __catch30_g_error;
		}
#line 160 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp5_ = _tmp0_;
#line 160 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp0_ = NULL;
#line 160 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		result = _tmp5_;
#line 160 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_g_free0 (_tmp0_);
#line 160 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		return result;
#line 915 "autosave-manager.c"
	}
	goto __finally30;
	__catch30_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 158 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		e = _inner_error_;
#line 158 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_inner_error_ = NULL;
#line 164 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp6_ = _default_;
#line 164 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp7_ = g_strdup (_tmp6_);
#line 164 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		result = _tmp7_;
#line 164 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_g_error_free0 (e);
#line 164 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		return result;
#line 937 "autosave-manager.c"
	}
	__finally30:
#line 158 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 158 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_clear_error (&_inner_error_);
#line 158 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	return NULL;
#line 946 "autosave-manager.c"
}


static gint autosave_manager_get_integer (AutosaveManager* self, GKeyFile* file, const gchar* group_name, const gchar* key, gint _default_) {
	gint result = 0;
	GError * _inner_error_ = NULL;
#line 168 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 168 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_val_if_fail (file != NULL, 0);
#line 168 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_val_if_fail (group_name != NULL, 0);
#line 168 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_val_if_fail (key != NULL, 0);
#line 961 "autosave-manager.c"
	{
		gint _tmp0_ = 0;
		GKeyFile* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
#line 172 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp1_ = file;
#line 172 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp2_ = group_name;
#line 172 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp3_ = key;
#line 172 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp4_ = g_key_file_get_integer (_tmp1_, _tmp2_, _tmp3_, &_inner_error_);
#line 172 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp0_ = _tmp4_;
#line 172 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 980 "autosave-manager.c"
			goto __catch31_g_error;
		}
#line 172 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		result = _tmp0_;
#line 172 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		return result;
#line 987 "autosave-manager.c"
	}
	goto __finally31;
	__catch31_g_error:
	{
		GError* e = NULL;
		gint _tmp5_ = 0;
#line 170 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		e = _inner_error_;
#line 170 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_inner_error_ = NULL;
#line 176 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp5_ = _default_;
#line 176 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		result = _tmp5_;
#line 176 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_g_error_free0 (e);
#line 176 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		return result;
#line 1006 "autosave-manager.c"
	}
	__finally31:
#line 170 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 170 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_clear_error (&_inner_error_);
#line 170 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	return 0;
#line 1015 "autosave-manager.c"
}


static gboolean autosave_manager_get_boolean (AutosaveManager* self, GKeyFile* file, const gchar* group_name, const gchar* key, gboolean _default_) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 180 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 180 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_val_if_fail (file != NULL, FALSE);
#line 180 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_val_if_fail (group_name != NULL, FALSE);
#line 180 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_val_if_fail (key != NULL, FALSE);
#line 1030 "autosave-manager.c"
	{
		gboolean _tmp0_ = FALSE;
		GKeyFile* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
#line 184 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp1_ = file;
#line 184 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp2_ = group_name;
#line 184 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp3_ = key;
#line 184 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp4_ = g_key_file_get_boolean (_tmp1_, _tmp2_, _tmp3_, &_inner_error_);
#line 184 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp0_ = _tmp4_;
#line 184 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1049 "autosave-manager.c"
			goto __catch32_g_error;
		}
#line 184 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		result = _tmp0_;
#line 184 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		return result;
#line 1056 "autosave-manager.c"
	}
	goto __finally32;
	__catch32_g_error:
	{
		GError* e = NULL;
		gboolean _tmp5_ = FALSE;
#line 182 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		e = _inner_error_;
#line 182 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_inner_error_ = NULL;
#line 188 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp5_ = _default_;
#line 188 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		result = _tmp5_;
#line 188 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_g_error_free0 (e);
#line 188 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		return result;
#line 1075 "autosave-manager.c"
	}
	__finally32:
#line 182 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 182 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_clear_error (&_inner_error_);
#line 182 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	return FALSE;
#line 1084 "autosave-manager.c"
}


void autosave_manager_cleanup (AutosaveManager* self) {
	guint _tmp0_ = 0U;
	GDir* dir = NULL;
	GError * _inner_error_ = NULL;
#line 192 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 194 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_debug ("autosave-manager.vala:194: Deleting autosave records");
#line 196 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp0_ = self->priv->update_timeout;
#line 196 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	if (_tmp0_ > ((guint) 0)) {
#line 1100 "autosave-manager.c"
		guint _tmp1_ = 0U;
#line 197 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp1_ = self->priv->update_timeout;
#line 197 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_source_remove (_tmp1_);
#line 1106 "autosave-manager.c"
	}
#line 198 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	self->priv->update_timeout = (guint) 0;
#line 1110 "autosave-manager.c"
	{
		GDir* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GDir* _tmp4_ = NULL;
		GDir* _tmp5_ = NULL;
#line 203 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp3_ = autosave_manager_AUTOSAVE_DIR;
#line 203 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp4_ = g_dir_open (_tmp3_, (guint) 0, &_inner_error_);
#line 203 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp2_ = _tmp4_;
#line 203 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1124 "autosave-manager.c"
			goto __catch33_g_error;
		}
#line 203 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp5_ = _tmp2_;
#line 203 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp2_ = NULL;
#line 203 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_g_dir_close0 (dir);
#line 203 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		dir = _tmp5_;
#line 201 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_g_dir_close0 (_tmp2_);
#line 1137 "autosave-manager.c"
	}
	goto __finally33;
	__catch33_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 201 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		e = _inner_error_;
#line 201 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_inner_error_ = NULL;
#line 207 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp6_ = e;
#line 207 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp7_ = _tmp6_->message;
#line 207 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_warning ("autosave-manager.vala:207: Failed to delete autosaves: %s", _tmp7_);
#line 208 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_g_error_free0 (e);
#line 208 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_g_dir_close0 (dir);
#line 208 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		return;
#line 1161 "autosave-manager.c"
	}
	__finally33:
#line 201 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 201 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_g_dir_close0 (dir);
#line 201 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 201 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_clear_error (&_inner_error_);
#line 201 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		return;
#line 1174 "autosave-manager.c"
	}
#line 211 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	while (TRUE) {
#line 1178 "autosave-manager.c"
		gchar* filename = NULL;
		GDir* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* path = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
#line 213 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp8_ = dir;
#line 213 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp9_ = g_dir_read_name (_tmp8_);
#line 213 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp10_ = g_strdup (_tmp9_);
#line 213 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		filename = _tmp10_;
#line 214 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp11_ = filename;
#line 214 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		if (_tmp11_ == NULL) {
#line 215 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
			_g_free0 (filename);
#line 215 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
			break;
#line 1205 "autosave-manager.c"
		}
#line 216 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp12_ = autosave_manager_AUTOSAVE_DIR;
#line 216 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp13_ = filename;
#line 216 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp14_ = g_build_filename (_tmp12_, _tmp13_, NULL);
#line 216 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		path = _tmp14_;
#line 217 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp15_ = path;
#line 217 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_unlink (_tmp15_);
#line 211 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_g_free0 (path);
#line 211 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_g_free0 (filename);
#line 1223 "autosave-manager.c"
	}
#line 192 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_g_dir_close0 (dir);
#line 1227 "autosave-manager.c"
}


static void _autosave_manager_on_scan_finished_page_scan_finished (Page* _sender, gpointer self) {
#line 223 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	autosave_manager_on_scan_finished ((AutosaveManager*) self, _sender);
#line 1234 "autosave-manager.c"
}


static void _autosave_manager_on_changed_page_crop_changed (Page* _sender, gpointer self) {
#line 224 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	autosave_manager_on_changed ((AutosaveManager*) self);
#line 1241 "autosave-manager.c"
}


void autosave_manager_on_page_added (AutosaveManager* self, Page* page) {
	Page* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
#line 221 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 221 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_if_fail (page != NULL);
#line 223 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp0_ = page;
#line 223 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_signal_connect (_tmp0_, "scan-finished", (GCallback) _autosave_manager_on_scan_finished_page_scan_finished, self);
#line 224 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp1_ = page;
#line 224 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_signal_connect (_tmp1_, "crop-changed", (GCallback) _autosave_manager_on_changed_page_crop_changed, self);
#line 1260 "autosave-manager.c"
}


void autosave_manager_on_page_removed (AutosaveManager* self, Page* page) {
	Page* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	Page* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	gchar* filename = NULL;
	GHashTable* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
	gconstpointer _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GHashTable* _tmp10_ = NULL;
	Page* _tmp11_ = NULL;
#line 227 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 227 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_if_fail (page != NULL);
#line 229 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp0_ = page;
#line 229 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_signal_parse_name ("scan-finished", TYPE_PAGE, &_tmp1_, NULL, FALSE);
#line 229 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _autosave_manager_on_scan_finished_page_scan_finished, self);
#line 230 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp2_ = page;
#line 230 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 230 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _autosave_manager_on_changed_page_crop_changed, self);
#line 232 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp4_ = self->priv->page_filenames;
#line 232 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp5_ = page;
#line 232 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp6_ = g_hash_table_lookup (_tmp4_, _tmp5_);
#line 232 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp7_ = g_strdup ((const gchar*) _tmp6_);
#line 232 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	filename = _tmp7_;
#line 233 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp8_ = filename;
#line 233 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	if (_tmp8_ != NULL) {
#line 1307 "autosave-manager.c"
		const gchar* _tmp9_ = NULL;
#line 234 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp9_ = filename;
#line 234 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_unlink (_tmp9_);
#line 1313 "autosave-manager.c"
	}
#line 235 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp10_ = self->priv->page_filenames;
#line 235 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp11_ = page;
#line 235 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_hash_table_remove (_tmp10_, _tmp11_);
#line 227 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_g_free0 (filename);
#line 1323 "autosave-manager.c"
}


void autosave_manager_on_scan_finished (AutosaveManager* self, Page* page) {
	Page* _tmp0_ = NULL;
#line 238 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 238 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_if_fail (page != NULL);
#line 240 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp0_ = page;
#line 240 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	autosave_manager_save_pixels (self, _tmp0_);
#line 241 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	autosave_manager_save (self, FALSE);
#line 1339 "autosave-manager.c"
}


void autosave_manager_on_changed (AutosaveManager* self) {
#line 244 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 246 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	autosave_manager_save (self, TRUE);
#line 1348 "autosave-manager.c"
}


void autosave_manager_on_cleared (AutosaveManager* self) {
	GHashTable* _tmp0_ = NULL;
#line 249 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 251 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp0_ = self->priv->page_filenames;
#line 251 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_hash_table_remove_all (_tmp0_);
#line 252 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	autosave_manager_save (self, TRUE);
#line 1362 "autosave-manager.c"
}


static gboolean ___lambda4_ (AutosaveManager* self) {
	gboolean result = FALSE;
#line 269 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	autosave_manager_real_save (self);
#line 270 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	self->priv->update_timeout = (guint) 0;
#line 271 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	result = FALSE;
#line 271 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	return result;
#line 1376 "autosave-manager.c"
}


static gboolean ____lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda4_ ((AutosaveManager*) self);
#line 267 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	return result;
#line 1385 "autosave-manager.c"
}


static void autosave_manager_save (AutosaveManager* self, gboolean do_timeout) {
	gboolean _tmp0_ = FALSE;
	guint _tmp1_ = 0U;
	guint _tmp3_ = 0U;
	gboolean _tmp5_ = FALSE;
#line 255 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 257 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp1_ = self->priv->update_timeout;
#line 257 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	if (_tmp1_ == ((guint) 0)) {
#line 1400 "autosave-manager.c"
		gboolean _tmp2_ = FALSE;
#line 257 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp2_ = do_timeout;
#line 257 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp0_ = _tmp2_;
#line 1406 "autosave-manager.c"
	} else {
#line 257 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp0_ = FALSE;
#line 1410 "autosave-manager.c"
	}
#line 257 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	if (_tmp0_) {
#line 258 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_debug ("autosave-manager.vala:258: Waiting to autosave...");
#line 1416 "autosave-manager.c"
	}
#line 261 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp3_ = self->priv->update_timeout;
#line 261 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	if (_tmp3_ > ((guint) 0)) {
#line 1422 "autosave-manager.c"
		guint _tmp4_ = 0U;
#line 262 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp4_ = self->priv->update_timeout;
#line 262 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_source_remove (_tmp4_);
#line 1428 "autosave-manager.c"
	}
#line 263 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	self->priv->update_timeout = (guint) 0;
#line 265 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp5_ = do_timeout;
#line 265 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	if (_tmp5_) {
#line 1436 "autosave-manager.c"
		guint _tmp6_ = 0U;
#line 267 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp6_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ____lambda4__gsource_func, autosave_manager_ref (self), autosave_manager_unref);
#line 267 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		self->priv->update_timeout = _tmp6_;
#line 1442 "autosave-manager.c"
	} else {
#line 275 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		autosave_manager_real_save (self);
#line 1446 "autosave-manager.c"
	}
}


static void autosave_manager_real_save (AutosaveManager* self) {
	GKeyFile* file = NULL;
	GKeyFile* _tmp0_ = NULL;
	gchar* page_names = NULL;
	gchar* _tmp1_ = NULL;
	GKeyFile* _tmp109_ = NULL;
	const gchar* _tmp110_ = NULL;
	GError * _inner_error_ = NULL;
#line 278 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 280 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_debug ("autosave-manager.vala:280: Autosaving book information");
#line 282 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp0_ = g_key_file_new ();
#line 282 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	file = _tmp0_;
#line 283 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp1_ = g_strdup ("");
#line 283 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	page_names = _tmp1_;
#line 1471 "autosave-manager.c"
	{
		gint i = 0;
#line 284 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		i = 0;
#line 1476 "autosave-manager.c"
		{
			gboolean _tmp2_ = FALSE;
#line 284 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
			_tmp2_ = TRUE;
#line 284 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
			while (TRUE) {
#line 1483 "autosave-manager.c"
				gint _tmp4_ = 0;
				Book* _tmp5_ = NULL;
				Book* _tmp6_ = NULL;
				guint _tmp7_ = 0U;
				guint _tmp8_ = 0U;
				Page* page = NULL;
				Book* _tmp9_ = NULL;
				Book* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				Page* _tmp12_ = NULL;
				Page* _tmp13_ = NULL;
				gboolean _tmp14_ = FALSE;
				gboolean _tmp15_ = FALSE;
				gchar* page_name = NULL;
				gint _tmp16_ = 0;
				gchar* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
				const gchar* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
				const gchar* _tmp24_ = NULL;
				GKeyFile* _tmp25_ = NULL;
				const gchar* _tmp26_ = NULL;
				Page* _tmp27_ = NULL;
				gint _tmp28_ = 0;
				gint _tmp29_ = 0;
				GKeyFile* _tmp30_ = NULL;
				const gchar* _tmp31_ = NULL;
				Page* _tmp32_ = NULL;
				gint _tmp33_ = 0;
				gint _tmp34_ = 0;
				GKeyFile* _tmp35_ = NULL;
				const gchar* _tmp36_ = NULL;
				Page* _tmp37_ = NULL;
				gint _tmp38_ = 0;
				gint _tmp39_ = 0;
				GKeyFile* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				Page* _tmp42_ = NULL;
				gint _tmp43_ = 0;
				gint _tmp44_ = 0;
				GKeyFile* _tmp45_ = NULL;
				const gchar* _tmp46_ = NULL;
				Page* _tmp47_ = NULL;
				gint _tmp48_ = 0;
				gint _tmp49_ = 0;
				GKeyFile* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				Page* _tmp52_ = NULL;
				gint _tmp53_ = 0;
				gint _tmp54_ = 0;
				Page* _tmp55_ = NULL;
				ScanDirection _tmp56_ = 0;
				ScanDirection _tmp57_ = 0;
				const gchar* _tmp66_ = NULL;
				Page* _tmp67_ = NULL;
				const gchar* _tmp68_ = NULL;
				const gchar* _tmp69_ = NULL;
				GKeyFile* _tmp70_ = NULL;
				const gchar* _tmp71_ = NULL;
				const gchar* _tmp72_ = NULL;
				GHashTable* _tmp73_ = NULL;
				Page* _tmp74_ = NULL;
				gconstpointer _tmp75_ = NULL;
				GKeyFile* _tmp76_ = NULL;
				const gchar* _tmp77_ = NULL;
				GKeyFile* _tmp78_ = NULL;
				const gchar* _tmp79_ = NULL;
				Page* _tmp80_ = NULL;
				gboolean _tmp81_ = FALSE;
				gboolean _tmp82_ = FALSE;
				const gchar* _tmp83_ = NULL;
				Page* _tmp84_ = NULL;
				const gchar* _tmp85_ = NULL;
				const gchar* _tmp86_ = NULL;
				GKeyFile* _tmp87_ = NULL;
				const gchar* _tmp88_ = NULL;
				GKeyFile* _tmp89_ = NULL;
				const gchar* _tmp90_ = NULL;
				Page* _tmp91_ = NULL;
				gint _tmp92_ = 0;
				gint _tmp93_ = 0;
				GKeyFile* _tmp94_ = NULL;
				const gchar* _tmp95_ = NULL;
				Page* _tmp96_ = NULL;
				gint _tmp97_ = 0;
				gint _tmp98_ = 0;
				GKeyFile* _tmp99_ = NULL;
				const gchar* _tmp100_ = NULL;
				Page* _tmp101_ = NULL;
				gint _tmp102_ = 0;
				gint _tmp103_ = 0;
				GKeyFile* _tmp104_ = NULL;
				const gchar* _tmp105_ = NULL;
				Page* _tmp106_ = NULL;
				gint _tmp107_ = 0;
				gint _tmp108_ = 0;
#line 284 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				if (!_tmp2_) {
#line 1583 "autosave-manager.c"
					gint _tmp3_ = 0;
#line 284 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					_tmp3_ = i;
#line 284 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					i = _tmp3_ + 1;
#line 1589 "autosave-manager.c"
				}
#line 284 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp2_ = FALSE;
#line 284 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp4_ = i;
#line 284 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp5_ = autosave_manager_get_book (self);
#line 284 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp6_ = _tmp5_;
#line 284 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp7_ = book_get_n_pages (_tmp6_);
#line 284 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp8_ = _tmp7_;
#line 284 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				if (!(((guint) _tmp4_) < _tmp8_)) {
#line 284 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					break;
#line 1607 "autosave-manager.c"
				}
#line 286 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp9_ = autosave_manager_get_book (self);
#line 286 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp10_ = _tmp9_;
#line 286 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp11_ = i;
#line 286 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp12_ = book_get_page (_tmp10_, _tmp11_);
#line 286 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				page = _tmp12_;
#line 289 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp13_ = page;
#line 289 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp14_ = page_get_has_data (_tmp13_);
#line 289 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp15_ = _tmp14_;
#line 289 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				if (!_tmp15_) {
#line 290 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					_page_unref0 (page);
#line 290 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					continue;
#line 1631 "autosave-manager.c"
				}
#line 292 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp16_ = i;
#line 292 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp17_ = g_strdup_printf ("page-%d", _tmp16_);
#line 292 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				page_name = _tmp17_;
#line 293 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp18_ = page_names;
#line 293 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				if (g_strcmp0 (_tmp18_, "") != 0) {
#line 1643 "autosave-manager.c"
					const gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
#line 294 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					_tmp19_ = page_names;
#line 294 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					_tmp20_ = g_strconcat (_tmp19_, " ", NULL);
#line 294 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					_g_free0 (page_names);
#line 294 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					page_names = _tmp20_;
#line 1654 "autosave-manager.c"
				}
#line 295 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp21_ = page_names;
#line 295 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp22_ = page_name;
#line 295 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp23_ = g_strconcat (_tmp21_, _tmp22_, NULL);
#line 295 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_g_free0 (page_names);
#line 295 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				page_names = _tmp23_;
#line 297 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp24_ = page_name;
#line 297 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				g_debug ("autosave-manager.vala:297: Autosaving page %s", _tmp24_);
#line 299 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp25_ = file;
#line 299 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp26_ = page_name;
#line 299 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp27_ = page;
#line 299 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp28_ = page_get_scan_width (_tmp27_);
#line 299 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp29_ = _tmp28_;
#line 299 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				g_key_file_set_integer (_tmp25_, _tmp26_, "scan-width", _tmp29_);
#line 300 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp30_ = file;
#line 300 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp31_ = page_name;
#line 300 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp32_ = page;
#line 300 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp33_ = page_get_scan_height (_tmp32_);
#line 300 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp34_ = _tmp33_;
#line 300 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				g_key_file_set_integer (_tmp30_, _tmp31_, "scan-height", _tmp34_);
#line 301 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp35_ = file;
#line 301 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp36_ = page_name;
#line 301 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp37_ = page;
#line 301 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp38_ = page_get_rowstride (_tmp37_);
#line 301 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp39_ = _tmp38_;
#line 301 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				g_key_file_set_integer (_tmp35_, _tmp36_, "rowstride", _tmp39_);
#line 302 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp40_ = file;
#line 302 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp41_ = page_name;
#line 302 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp42_ = page;
#line 302 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp43_ = page_get_n_channels (_tmp42_);
#line 302 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp44_ = _tmp43_;
#line 302 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				g_key_file_set_integer (_tmp40_, _tmp41_, "n-channels", _tmp44_);
#line 303 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp45_ = file;
#line 303 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp46_ = page_name;
#line 303 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp47_ = page;
#line 303 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp48_ = page_get_depth (_tmp47_);
#line 303 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp49_ = _tmp48_;
#line 303 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				g_key_file_set_integer (_tmp45_, _tmp46_, "depth", _tmp49_);
#line 304 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp50_ = file;
#line 304 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp51_ = page_name;
#line 304 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp52_ = page;
#line 304 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp53_ = page_get_dpi (_tmp52_);
#line 304 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp54_ = _tmp53_;
#line 304 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				g_key_file_set_integer (_tmp50_, _tmp51_, "dpi", _tmp54_);
#line 305 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp55_ = page;
#line 305 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp56_ = page_get_scan_direction (_tmp55_);
#line 305 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp57_ = _tmp56_;
#line 305 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				switch (_tmp57_) {
#line 305 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					case SCAN_DIRECTION_TOP_TO_BOTTOM:
#line 1752 "autosave-manager.c"
					{
						GKeyFile* _tmp58_ = NULL;
						const gchar* _tmp59_ = NULL;
#line 308 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						_tmp58_ = file;
#line 308 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						_tmp59_ = page_name;
#line 308 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						g_key_file_set_value (_tmp58_, _tmp59_, "scan-direction", "TOP_TO_BOTTOM");
#line 309 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						break;
#line 1764 "autosave-manager.c"
					}
#line 305 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					case SCAN_DIRECTION_LEFT_TO_RIGHT:
#line 1768 "autosave-manager.c"
					{
						GKeyFile* _tmp60_ = NULL;
						const gchar* _tmp61_ = NULL;
#line 311 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						_tmp60_ = file;
#line 311 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						_tmp61_ = page_name;
#line 311 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						g_key_file_set_value (_tmp60_, _tmp61_, "scan-direction", "LEFT_TO_RIGHT");
#line 312 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						break;
#line 1780 "autosave-manager.c"
					}
#line 305 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					case SCAN_DIRECTION_BOTTOM_TO_TOP:
#line 1784 "autosave-manager.c"
					{
						GKeyFile* _tmp62_ = NULL;
						const gchar* _tmp63_ = NULL;
#line 314 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						_tmp62_ = file;
#line 314 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						_tmp63_ = page_name;
#line 314 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						g_key_file_set_value (_tmp62_, _tmp63_, "scan-direction", "BOTTOM_TO_TOP");
#line 315 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						break;
#line 1796 "autosave-manager.c"
					}
#line 305 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					case SCAN_DIRECTION_RIGHT_TO_LEFT:
#line 1800 "autosave-manager.c"
					{
						GKeyFile* _tmp64_ = NULL;
						const gchar* _tmp65_ = NULL;
#line 317 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						_tmp64_ = file;
#line 317 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						_tmp65_ = page_name;
#line 317 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						g_key_file_set_value (_tmp64_, _tmp65_, "scan-direction", "RIGHT_TO_LEFT");
#line 318 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						break;
#line 1812 "autosave-manager.c"
					}
					default:
#line 305 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					break;
#line 1817 "autosave-manager.c"
				}
#line 320 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp67_ = page;
#line 320 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp68_ = page_get_color_profile (_tmp67_);
#line 320 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp69_ = _tmp68_;
#line 320 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp66_ = _tmp69_;
#line 320 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				if (_tmp66_ == NULL) {
#line 320 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					_tmp66_ = "";
#line 1831 "autosave-manager.c"
				}
#line 320 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp70_ = file;
#line 320 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp71_ = page_name;
#line 320 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				g_key_file_set_value (_tmp70_, _tmp71_, "color-profile", _tmp66_);
#line 321 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp73_ = self->priv->page_filenames;
#line 321 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp74_ = page;
#line 321 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp75_ = g_hash_table_lookup (_tmp73_, _tmp74_);
#line 321 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp72_ = (const gchar*) _tmp75_;
#line 321 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				if (_tmp72_ == NULL) {
#line 321 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					_tmp72_ = "";
#line 1851 "autosave-manager.c"
				}
#line 321 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp76_ = file;
#line 321 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp77_ = page_name;
#line 321 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				g_key_file_set_value (_tmp76_, _tmp77_, "pixels-filename", _tmp72_);
#line 322 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp78_ = file;
#line 322 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp79_ = page_name;
#line 322 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp80_ = page;
#line 322 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp81_ = page_get_has_crop (_tmp80_);
#line 322 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp82_ = _tmp81_;
#line 322 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				g_key_file_set_boolean (_tmp78_, _tmp79_, "has-crop", _tmp82_);
#line 323 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp84_ = page;
#line 323 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp85_ = page_get_crop_name (_tmp84_);
#line 323 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp86_ = _tmp85_;
#line 323 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp83_ = _tmp86_;
#line 323 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				if (_tmp83_ == NULL) {
#line 323 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					_tmp83_ = "";
#line 1883 "autosave-manager.c"
				}
#line 323 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp87_ = file;
#line 323 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp88_ = page_name;
#line 323 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				g_key_file_set_value (_tmp87_, _tmp88_, "crop-name", _tmp83_);
#line 324 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp89_ = file;
#line 324 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp90_ = page_name;
#line 324 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp91_ = page;
#line 324 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp92_ = page_get_crop_x (_tmp91_);
#line 324 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp93_ = _tmp92_;
#line 324 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				g_key_file_set_integer (_tmp89_, _tmp90_, "crop-x", _tmp93_);
#line 325 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp94_ = file;
#line 325 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp95_ = page_name;
#line 325 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp96_ = page;
#line 325 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp97_ = page_get_crop_y (_tmp96_);
#line 325 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp98_ = _tmp97_;
#line 325 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				g_key_file_set_integer (_tmp94_, _tmp95_, "crop-y", _tmp98_);
#line 326 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp99_ = file;
#line 326 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp100_ = page_name;
#line 326 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp101_ = page;
#line 326 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp102_ = page_get_crop_width (_tmp101_);
#line 326 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp103_ = _tmp102_;
#line 326 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				g_key_file_set_integer (_tmp99_, _tmp100_, "crop-width", _tmp103_);
#line 327 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp104_ = file;
#line 327 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp105_ = page_name;
#line 327 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp106_ = page;
#line 327 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp107_ = page_get_crop_height (_tmp106_);
#line 327 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp108_ = _tmp107_;
#line 327 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				g_key_file_set_integer (_tmp104_, _tmp105_, "crop-height", _tmp108_);
#line 284 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_g_free0 (page_name);
#line 284 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_page_unref0 (page);
#line 1943 "autosave-manager.c"
			}
		}
	}
#line 329 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp109_ = file;
#line 329 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp110_ = page_names;
#line 329 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_key_file_set_value (_tmp109_, "simple-scan", "pages", _tmp110_);
#line 1953 "autosave-manager.c"
	{
		const gchar* _tmp111_ = NULL;
		const gchar* _tmp112_ = NULL;
		GKeyFile* _tmp113_ = NULL;
		gchar* _tmp114_ = NULL;
		gchar* _tmp115_ = NULL;
#line 333 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp111_ = autosave_manager_AUTOSAVE_DIR;
#line 333 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_mkdir_with_parents (_tmp111_, 0777);
#line 334 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp112_ = autosave_manager_AUTOSAVE_PATH;
#line 334 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp113_ = file;
#line 334 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp114_ = g_key_file_to_data (_tmp113_, NULL, NULL);
#line 334 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp115_ = _tmp114_;
#line 334 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_file_set_contents (_tmp112_, _tmp115_, (gssize) -1, &_inner_error_);
#line 334 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_g_free0 (_tmp115_);
#line 334 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1978 "autosave-manager.c"
			goto __catch34_g_error;
		}
	}
	goto __finally34;
	__catch34_g_error:
	{
		GError* e = NULL;
		GError* _tmp116_ = NULL;
		const gchar* _tmp117_ = NULL;
#line 331 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		e = _inner_error_;
#line 331 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_inner_error_ = NULL;
#line 338 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp116_ = e;
#line 338 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp117_ = _tmp116_->message;
#line 338 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_warning ("autosave-manager.vala:338: Failed to write autosave: %s", _tmp117_);
#line 331 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_g_error_free0 (e);
#line 2000 "autosave-manager.c"
	}
	__finally34:
#line 331 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 331 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_g_free0 (page_names);
#line 331 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_g_key_file_unref0 (file);
#line 331 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 331 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_clear_error (&_inner_error_);
#line 331 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		return;
#line 2015 "autosave-manager.c"
	}
#line 278 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_g_free0 (page_names);
#line 278 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_g_key_file_unref0 (file);
#line 2021 "autosave-manager.c"
}


static void autosave_manager_save_pixels (AutosaveManager* self, Page* page) {
	gchar* filename = NULL;
	GHashFunc _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	gchar* _tmp3_ = NULL;
	gchar* path = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GHashTable* _tmp6_ = NULL;
	Page* _tmp7_ = NULL;
	Page* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	GFile* file = NULL;
	GFile* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
#line 342 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 342 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_if_fail (page != NULL);
#line 344 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp0_ = g_direct_hash;
#line 344 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp1_ = page;
#line 344 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp2_ = _tmp0_ (_tmp1_);
#line 344 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp3_ = g_strdup_printf ("%u.pixels", _tmp2_);
#line 344 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	filename = _tmp3_;
#line 345 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp4_ = autosave_manager_AUTOSAVE_DIR;
#line 345 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp5_ = g_build_filename (_tmp4_, filename, NULL);
#line 345 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	path = _tmp5_;
#line 346 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp6_ = self->priv->page_filenames;
#line 346 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp7_ = page;
#line 346 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp8_ = _page_ref0 (_tmp7_);
#line 346 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp9_ = g_strdup (filename);
#line 346 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_hash_table_insert (_tmp6_, _tmp8_, _tmp9_);
#line 348 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_debug ("autosave-manager.vala:348: Autosaving page pixels to %s", path);
#line 350 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp10_ = g_file_new_for_path (path);
#line 350 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	file = _tmp10_;
#line 2077 "autosave-manager.c"
	{
		Page* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		guchar* _tmp13_ = NULL;
#line 353 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp11_ = page;
#line 353 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp13_ = page_get_pixels (_tmp11_, &_tmp12_);
#line 353 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_file_replace_contents (file, _tmp13_, (gsize) _tmp12_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
#line 353 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2090 "autosave-manager.c"
			goto __catch35_g_error;
		}
	}
	goto __finally35;
	__catch35_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
#line 351 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		e = _inner_error_;
#line 351 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_inner_error_ = NULL;
#line 357 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp14_ = e;
#line 357 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp15_ = _tmp14_->message;
#line 357 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_warning ("autosave-manager.vala:357: Failed to autosave page contents: %s", _tmp15_);
#line 351 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_g_error_free0 (e);
#line 2112 "autosave-manager.c"
	}
	__finally35:
#line 351 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 351 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_g_object_unref0 (file);
#line 351 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_g_free0 (path);
#line 351 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_g_free0 (filename);
#line 351 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 351 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_clear_error (&_inner_error_);
#line 351 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		return;
#line 2129 "autosave-manager.c"
	}
#line 342 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_g_object_unref0 (file);
#line 342 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_g_free0 (path);
#line 342 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_g_free0 (filename);
#line 2137 "autosave-manager.c"
}


Book* autosave_manager_get_book (AutosaveManager* self) {
	Book* result;
	Book* _tmp0_ = NULL;
#line 26 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 28 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp0_ = self->priv->book_;
#line 28 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	result = _tmp0_;
#line 28 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	return result;
#line 2152 "autosave-manager.c"
}


static void _autosave_manager_on_page_added_book_page_added (Book* _sender, Page* page, gpointer self) {
#line 39 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	autosave_manager_on_page_added ((AutosaveManager*) self, page);
#line 2159 "autosave-manager.c"
}


static void _autosave_manager_on_page_removed_book_page_removed (Book* _sender, Page* page, gpointer self) {
#line 40 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	autosave_manager_on_page_removed ((AutosaveManager*) self, page);
#line 2166 "autosave-manager.c"
}


static void _autosave_manager_on_changed_book_reordered (Book* _sender, gpointer self) {
#line 41 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	autosave_manager_on_changed ((AutosaveManager*) self);
#line 2173 "autosave-manager.c"
}


static void _autosave_manager_on_cleared_book_cleared (Book* _sender, gpointer self) {
#line 42 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	autosave_manager_on_cleared ((AutosaveManager*) self);
#line 2180 "autosave-manager.c"
}


static gpointer _book_ref0 (gpointer self) {
#line 44 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	return self ? book_ref (self) : NULL;
#line 2187 "autosave-manager.c"
}


void autosave_manager_set_book (AutosaveManager* self, Book* value) {
	Book* _tmp0_ = NULL;
	Book* _tmp19_ = NULL;
	Book* _tmp20_ = NULL;
	Book* _tmp21_ = NULL;
	Book* _tmp22_ = NULL;
	Book* _tmp23_ = NULL;
	Book* _tmp24_ = NULL;
#line 30 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 32 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp0_ = self->priv->book_;
#line 32 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	if (_tmp0_ != NULL) {
#line 2205 "autosave-manager.c"
		Book* _tmp11_ = NULL;
		guint _tmp12_ = 0U;
		Book* _tmp13_ = NULL;
		guint _tmp14_ = 0U;
		Book* _tmp15_ = NULL;
		guint _tmp16_ = 0U;
		Book* _tmp17_ = NULL;
		guint _tmp18_ = 0U;
		{
			gint i = 0;
#line 34 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
			i = 0;
#line 2218 "autosave-manager.c"
			{
				gboolean _tmp1_ = FALSE;
#line 34 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp1_ = TRUE;
#line 34 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				while (TRUE) {
#line 2225 "autosave-manager.c"
					gint _tmp3_ = 0;
					Book* _tmp4_ = NULL;
					guint _tmp5_ = 0U;
					guint _tmp6_ = 0U;
					Page* page = NULL;
					Book* _tmp7_ = NULL;
					gint _tmp8_ = 0;
					Page* _tmp9_ = NULL;
					Page* _tmp10_ = NULL;
#line 34 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					if (!_tmp1_) {
#line 2237 "autosave-manager.c"
						gint _tmp2_ = 0;
#line 34 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						_tmp2_ = i;
#line 34 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						i = _tmp2_ + 1;
#line 2243 "autosave-manager.c"
					}
#line 34 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					_tmp1_ = FALSE;
#line 34 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					_tmp3_ = i;
#line 34 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					_tmp4_ = self->priv->book_;
#line 34 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					_tmp5_ = book_get_n_pages (_tmp4_);
#line 34 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					_tmp6_ = _tmp5_;
#line 34 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					if (!(((guint) _tmp3_) < _tmp6_)) {
#line 34 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
						break;
#line 2259 "autosave-manager.c"
					}
#line 36 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					_tmp7_ = self->priv->book_;
#line 36 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					_tmp8_ = i;
#line 36 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					_tmp9_ = book_get_page (_tmp7_, _tmp8_);
#line 36 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					page = _tmp9_;
#line 37 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					_tmp10_ = page;
#line 37 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					autosave_manager_on_page_removed (self, _tmp10_);
#line 34 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					_page_unref0 (page);
#line 2275 "autosave-manager.c"
				}
			}
		}
#line 39 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp11_ = self->priv->book_;
#line 39 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_signal_parse_name ("page-added", TYPE_BOOK, &_tmp12_, NULL, FALSE);
#line 39 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_signal_handlers_disconnect_matched (_tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) _autosave_manager_on_page_added_book_page_added, self);
#line 40 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp13_ = self->priv->book_;
#line 40 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_signal_parse_name ("page-removed", TYPE_BOOK, &_tmp14_, NULL, FALSE);
#line 40 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_signal_handlers_disconnect_matched (_tmp13_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, 0, NULL, (GCallback) _autosave_manager_on_page_removed_book_page_removed, self);
#line 41 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp15_ = self->priv->book_;
#line 41 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_signal_parse_name ("reordered", TYPE_BOOK, &_tmp16_, NULL, FALSE);
#line 41 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_signal_handlers_disconnect_matched (_tmp15_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp16_, 0, NULL, (GCallback) _autosave_manager_on_changed_book_reordered, self);
#line 42 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		_tmp17_ = self->priv->book_;
#line 42 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_signal_parse_name ("cleared", TYPE_BOOK, &_tmp18_, NULL, FALSE);
#line 42 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_signal_handlers_disconnect_matched (_tmp17_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp18_, 0, NULL, (GCallback) _autosave_manager_on_cleared_book_cleared, self);
#line 2303 "autosave-manager.c"
	}
#line 44 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp19_ = value;
#line 44 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp20_ = _book_ref0 (_tmp19_);
#line 44 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_book_unref0 (self->priv->book_);
#line 44 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	self->priv->book_ = _tmp20_;
#line 45 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp21_ = self->priv->book_;
#line 45 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_signal_connect (_tmp21_, "page-added", (GCallback) _autosave_manager_on_page_added_book_page_added, self);
#line 46 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp22_ = self->priv->book_;
#line 46 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_signal_connect (_tmp22_, "page-removed", (GCallback) _autosave_manager_on_page_removed_book_page_removed, self);
#line 47 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp23_ = self->priv->book_;
#line 47 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_signal_connect (_tmp23_, "reordered", (GCallback) _autosave_manager_on_changed_book_reordered, self);
#line 48 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp24_ = self->priv->book_;
#line 48 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_signal_connect (_tmp24_, "cleared", (GCallback) _autosave_manager_on_cleared_book_cleared, self);
#line 2329 "autosave-manager.c"
	{
		gint i = 0;
#line 49 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		i = 0;
#line 2334 "autosave-manager.c"
		{
			gboolean _tmp25_ = FALSE;
#line 49 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
			_tmp25_ = TRUE;
#line 49 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
			while (TRUE) {
#line 2341 "autosave-manager.c"
				gint _tmp27_ = 0;
				Book* _tmp28_ = NULL;
				guint _tmp29_ = 0U;
				guint _tmp30_ = 0U;
				Page* page = NULL;
				Book* _tmp31_ = NULL;
				gint _tmp32_ = 0;
				Page* _tmp33_ = NULL;
				Page* _tmp34_ = NULL;
#line 49 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				if (!_tmp25_) {
#line 2353 "autosave-manager.c"
					gint _tmp26_ = 0;
#line 49 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					_tmp26_ = i;
#line 49 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					i = _tmp26_ + 1;
#line 2359 "autosave-manager.c"
				}
#line 49 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp25_ = FALSE;
#line 49 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp27_ = i;
#line 49 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp28_ = self->priv->book_;
#line 49 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp29_ = book_get_n_pages (_tmp28_);
#line 49 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp30_ = _tmp29_;
#line 49 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				if (!(((guint) _tmp27_) < _tmp30_)) {
#line 49 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
					break;
#line 2375 "autosave-manager.c"
				}
#line 51 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp31_ = self->priv->book_;
#line 51 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp32_ = i;
#line 51 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp33_ = book_get_page (_tmp31_, _tmp32_);
#line 51 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				page = _tmp33_;
#line 52 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_tmp34_ = page;
#line 52 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				autosave_manager_on_page_added (self, _tmp34_);
#line 49 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
				_page_unref0 (page);
#line 2391 "autosave-manager.c"
			}
		}
	}
}


static void value_autosave_manager_init (GValue* value) {
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	value->data[0].v_pointer = NULL;
#line 2401 "autosave-manager.c"
}


static void value_autosave_manager_free_value (GValue* value) {
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	if (value->data[0].v_pointer) {
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		autosave_manager_unref (value->data[0].v_pointer);
#line 2410 "autosave-manager.c"
	}
}


static void value_autosave_manager_copy_value (const GValue* src_value, GValue* dest_value) {
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	if (src_value->data[0].v_pointer) {
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		dest_value->data[0].v_pointer = autosave_manager_ref (src_value->data[0].v_pointer);
#line 2420 "autosave-manager.c"
	} else {
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2424 "autosave-manager.c"
	}
}


static gpointer value_autosave_manager_peek_pointer (const GValue* value) {
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	return value->data[0].v_pointer;
#line 2432 "autosave-manager.c"
}


static gchar* value_autosave_manager_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	if (collect_values[0].v_pointer) {
#line 2439 "autosave-manager.c"
		AutosaveManager* object;
		object = collect_values[0].v_pointer;
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		if (object->parent_instance.g_class == NULL) {
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2446 "autosave-manager.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2450 "autosave-manager.c"
		}
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		value->data[0].v_pointer = autosave_manager_ref (object);
#line 2454 "autosave-manager.c"
	} else {
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		value->data[0].v_pointer = NULL;
#line 2458 "autosave-manager.c"
	}
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	return NULL;
#line 2462 "autosave-manager.c"
}


static gchar* value_autosave_manager_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	AutosaveManager** object_p;
	object_p = collect_values[0].v_pointer;
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	if (!object_p) {
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2473 "autosave-manager.c"
	}
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	if (!value->data[0].v_pointer) {
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		*object_p = NULL;
#line 2479 "autosave-manager.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		*object_p = value->data[0].v_pointer;
#line 2483 "autosave-manager.c"
	} else {
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		*object_p = autosave_manager_ref (value->data[0].v_pointer);
#line 2487 "autosave-manager.c"
	}
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	return NULL;
#line 2491 "autosave-manager.c"
}


GParamSpec* param_spec_autosave_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecAutosaveManager* spec;
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_AUTOSAVE_MANAGER), NULL);
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	return G_PARAM_SPEC (spec);
#line 2505 "autosave-manager.c"
}


gpointer value_get_autosave_manager (const GValue* value) {
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AUTOSAVE_MANAGER), NULL);
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	return value->data[0].v_pointer;
#line 2514 "autosave-manager.c"
}


void value_set_autosave_manager (GValue* value, gpointer v_object) {
	AutosaveManager* old;
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AUTOSAVE_MANAGER));
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	old = value->data[0].v_pointer;
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	if (v_object) {
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AUTOSAVE_MANAGER));
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		value->data[0].v_pointer = v_object;
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		autosave_manager_ref (value->data[0].v_pointer);
#line 2534 "autosave-manager.c"
	} else {
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		value->data[0].v_pointer = NULL;
#line 2538 "autosave-manager.c"
	}
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	if (old) {
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		autosave_manager_unref (old);
#line 2544 "autosave-manager.c"
	}
}


void value_take_autosave_manager (GValue* value, gpointer v_object) {
	AutosaveManager* old;
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AUTOSAVE_MANAGER));
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	old = value->data[0].v_pointer;
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	if (v_object) {
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AUTOSAVE_MANAGER));
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		value->data[0].v_pointer = v_object;
#line 2563 "autosave-manager.c"
	} else {
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		value->data[0].v_pointer = NULL;
#line 2567 "autosave-manager.c"
	}
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	if (old) {
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		autosave_manager_unref (old);
#line 2573 "autosave-manager.c"
	}
}


static void autosave_manager_class_init (AutosaveManagerClass * klass) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	autosave_manager_parent_class = g_type_class_peek_parent (klass);
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	((AutosaveManagerClass *) klass)->finalize = autosave_manager_finalize;
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_type_class_add_private (klass, sizeof (AutosaveManagerPrivate));
#line 15 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp0_ = g_get_user_cache_dir ();
#line 15 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp1_ = g_build_filename (_tmp0_, "simple-scan", "autosaves", NULL);
#line 15 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	autosave_manager_AUTOSAVE_DIR = _tmp1_;
#line 16 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp2_ = g_strdup ("autosave.book");
#line 16 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	autosave_manager_AUTOSAVE_FILENAME = _tmp2_;
#line 17 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp3_ = autosave_manager_AUTOSAVE_DIR;
#line 17 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp4_ = autosave_manager_AUTOSAVE_FILENAME;
#line 17 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_tmp5_ = g_build_filename (_tmp3_, _tmp4_, NULL);
#line 17 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	autosave_manager_AUTOSAVE_PATH = _tmp5_;
#line 2609 "autosave-manager.c"
}


static void autosave_manager_instance_init (AutosaveManager * self) {
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	self->priv = AUTOSAVE_MANAGER_GET_PRIVATE (self);
#line 19 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	self->priv->update_timeout = (guint) 0;
#line 23 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	self->priv->book_ = NULL;
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	self->ref_count = 1;
#line 2622 "autosave-manager.c"
}


static void autosave_manager_finalize (AutosaveManager* obj) {
	AutosaveManager * self;
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AUTOSAVE_MANAGER, AutosaveManager);
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_signal_handlers_destroy (self);
#line 21 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_g_hash_table_unref0 (self->priv->page_filenames);
#line 23 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	_book_unref0 (self->priv->book_);
#line 2636 "autosave-manager.c"
}


GType autosave_manager_get_type (void) {
	static volatile gsize autosave_manager_type_id__volatile = 0;
	if (g_once_init_enter (&autosave_manager_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_autosave_manager_init, value_autosave_manager_free_value, value_autosave_manager_copy_value, value_autosave_manager_peek_pointer, "p", value_autosave_manager_collect_value, "p", value_autosave_manager_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AutosaveManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) autosave_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AutosaveManager), 0, (GInstanceInitFunc) autosave_manager_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType autosave_manager_type_id;
		autosave_manager_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AutosaveManager", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&autosave_manager_type_id__volatile, autosave_manager_type_id);
	}
	return autosave_manager_type_id__volatile;
}


gpointer autosave_manager_ref (gpointer instance) {
	AutosaveManager* self;
	self = instance;
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	g_atomic_int_inc (&self->ref_count);
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	return instance;
#line 2661 "autosave-manager.c"
}


void autosave_manager_unref (gpointer instance) {
	AutosaveManager* self;
	self = instance;
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		AUTOSAVE_MANAGER_GET_CLASS (self)->finalize (self);
#line 13 "/home/bob/bzr/simple-scan/3.12/src/autosave-manager.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2674 "autosave-manager.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



