/* SPDX-License-Identifier: GPL-2.0+
 *
 * NEXELL USB HOST EHCI Controller
 *
 * (C) Copyright 2016 Nexell
 * Hyunseok, Jung <hsjung@nexell.co.kr>
 */

#ifndef __ASM_ARM_ARCH_EHCI_H__
#define __ASM_ARM_ARCH_EHCI_H__

/* Nexell USBHOST PHY registers */

/* USBHOST Configuration 0 Register */
#define NX_HOST_CON0				0x14
#define NX_HOST_CON0_SS_WORD_IF			BIT(26)
#define NX_HOST_CON0_SS_WORD_IF_ENB		BIT(25)
#define NX_HOST_CON0_SS_WORD_IF_16 ( \
	NX_HOST_CON0_SS_WORD_IF | \
	NX_HOST_CON0_SS_WORD_IF_ENB)

#define NX_HOST_CON0_HSIC_480M_FROM_OTG_PHY	BIT(24)
#define NX_HOST_CON0_HSIC_FREE_CLOCK_ENB	BIT(23)
#define NX_HOST_CON0_HSIC_CLK_MASK		(0x3 << 23)

#define NX_HOST_CON0_N_HOST_HSIC_RESET_SYNC	BIT(22)
#define NX_HOST_CON0_N_HOST_UTMI_RESET_SYNC	BIT(21)
#define NX_HOST_CON0_N_HOST_PHY_RESET_SYNC	BIT(20)
#define NX_HOST_CON0_UTMI_RESET_SYNC ( \
	NX_HOST_CON0_N_HOST_HSIC_RESET_SYNC | \
	NX_HOST_CON0_N_HOST_UTMI_RESET_SYNC | \
	NX_HOST_CON0_N_HOST_PHY_RESET_SYNC)

#define NX_HOST_CON0_N_AUXWELL_RESET_SYNC	BIT(19)
#define NX_HOST_CON0_N_OHCI_RESET_SYNC		BIT(18)
#define NX_HOST_CON0_N_RESET_SYNC		BIT(17)
#define NX_HOST_CON0_AHB_RESET_SYNC ( \
	NX_HOST_CON0_N_AUXWELL_RESET_SYNC | \
	NX_HOST_CON0_N_OHCI_RESET_SYNC | \
	NX_HOST_CON0_N_RESET_SYNC)

#define NX_HOST_CON0_HSIC_EN_PORT1		(0x2 << 14)
#define NX_HOST_CON0_HSIC_EN_MASK		(0x7 << 14)

/* USBHOST Configuration 1 Register */
#define NX_HOST_CON1				0x18

/* USBHOST Configuration 2 Register */
#define NX_HOST_CON2				0x1C
#define NX_HOST_CON2_SS_ENA_INCRX_ALIGN		(0x1 << 28)
#define NX_HOST_CON2_SS_ENA_INCR4		(0x1 << 27)
#define NX_HOST_CON2_SS_ENA_INCR8		(0x1 << 26)
#define NX_HOST_CON2_SS_ENA_INCR16		(0x1 << 25)
#define NX_HOST_CON2_SS_DMA_BURST_MASK  \
	(NX_HOST_CON2_SS_ENA_INCR16 | NX_HOST_CON2_SS_ENA_INCR8 | \
	 NX_HOST_CON2_SS_ENA_INCR4 | NX_HOST_CON2_SS_ENA_INCRX_ALIGN)

#define NX_HOST_CON2_EHCI_SS_ENABLE_DMA_BURST \
	(NX_HOST_CON2_SS_ENA_INCR16 | NX_HOST_CON2_SS_ENA_INCR8 | \
	 NX_HOST_CON2_SS_ENA_INCR4 | NX_HOST_CON2_SS_ENA_INCRX_ALIGN)

#define NX_HOST_CON2_OHCI_SS_ENABLE_DMA_BURST \
	(NX_HOST_CON2_SS_ENA_INCR4 | NX_HOST_CON2_SS_ENA_INCRX_ALIGN)

#define NX_HOST_CON2_SS_FLADJ_VAL_0_OFFSET	(21)
#define NX_HOST_CON2_SS_FLADJ_VAL_OFFSET	(3)
#define NX_HOST_CON2_SS_FLADJ_VAL_NUM		(6)
#define NX_HOST_CON2_SS_FLADJ_VAL_0_SEL		BIT(5)
#define NX_HOST_CON2_SS_FLADJ_VAL_MAX		0x7

/* USBHOST Configuration 3 Register */
#define NX_HOST_CON3				0x20
#define NX_HOST_CON3_POR			BIT(8)
#define NX_HOST_CON3_POR_ENB			BIT(7)
#define NX_HOST_CON3_POR_MASK			(0x3 << 7)

/* USBHOST Configuration 4 Register */
#define NX_HOST_CON4				0x24
#define NX_HOST_CON4_WORDINTERFACE		BIT(9)
#define NX_HOST_CON4_WORDINTERFACE_ENB		BIT(8)
#define NX_HOST_CON4_WORDINTERFACE_16 ( \
	NX_HOST_CON4_WORDINTERFACE | \
	NX_HOST_CON4_WORDINTERFACE_ENB)

/* USBHOST Configuration 5 Register */
#define NX_HOST_CON5				0x28
#define NX_HOST_CON5_HSIC_POR			BIT(19)
#define NX_HOST_CON5_HSIC_POR_ENB		BIT(18)
#define NX_HOST_CON5_HSIC_POR_MASK		(0x3 << 18)

/* USBHOST Configuration 6 Register */
#define NX_HOST_CON6				0x2C
#define NX_HOST_CON6_HSIC_WORDINTERFACE		BIT(13)
#define NX_HOST_CON6_HSIC_WORDINTERFACE_ENB	BIT(12)
#define NX_HOST_CON6_HSIC_WORDINTERFACE_16 ( \
	NX_HOST_CON6_HSIC_WORDINTERFACE | \
	NX_HOST_CON6_HSIC_WORDINTERFACE_ENB)

/* Register map for PHY control */
struct nx_usb_phy {
	unsigned int reserved;
	unsigned int others[4];
	unsigned int usbhost_con[7];
};

#endif /* __ASM_ARM_ARCH_EHCI_H__ */
