/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.event.shared;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.event.shared.LegacyHandlerWrapper;
import com.google.gwt.event.shared.UmbrellaException;
import com.google.web.bindery.event.shared.Event;
import com.google.web.bindery.event.shared.SimpleEventBus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerManager
implements HasHandlers {
    private final Bus eventBus;
    private final Object source;

    public HandlerManager(Object source) {
        this(source, false);
    }

    public HandlerManager(Object source, boolean fireInReverseOrder) {
        this.eventBus = new Bus(fireInReverseOrder);
        this.source = source;
    }

    public <H extends EventHandler> HandlerRegistration addHandler(GwtEvent.Type<H> type, H handler) {
        return new LegacyHandlerWrapper(this.eventBus.addHandler(type, handler));
    }

    @Override
    public void fireEvent(GwtEvent<?> event) {
        if (!event.isLive()) {
            event.revive();
        }
        Object oldSource = event.getSource();
        event.overrideSource(this.source);
        try {
            this.eventBus.fireEvent(event);
        }
        catch (com.google.web.bindery.event.shared.UmbrellaException e) {
            throw new UmbrellaException(e.getCauses());
        }
        finally {
            if (oldSource == null) {
                event.kill();
            } else {
                event.overrideSource(oldSource);
            }
        }
    }

    public <H extends EventHandler> H getHandler(GwtEvent.Type<H> type, int index) {
        return (H)((EventHandler)this.eventBus.getHandler(type, index));
    }

    public int getHandlerCount(GwtEvent.Type<?> type) {
        return this.eventBus.getHandlerCount(type);
    }

    public boolean isEventHandled(GwtEvent.Type<?> e) {
        return this.eventBus.isEventHandled(e);
    }

    public <H extends EventHandler> void removeHandler(GwtEvent.Type<H> type, H handler) {
        this.eventBus.doRemove(type, null, handler);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Bus
    extends SimpleEventBus {
        public Bus(boolean fireInReverseOrder) {
            super(fireInReverseOrder);
        }

        @Override
        protected <H> void doRemove(Event.Type<H> type, Object source, H handler) {
            super.doRemove(type, source, handler);
        }

        @Override
        protected <H> H getHandler(Event.Type<H> type, int index) {
            return super.getHandler(type, index);
        }

        @Override
        protected int getHandlerCount(Event.Type<?> eventKey) {
            return super.getHandlerCount(eventKey);
        }

        @Override
        protected boolean isEventHandled(Event.Type<?> eventKey) {
            return super.isEventHandled(eventKey);
        }
    }
}

