/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "eu" locale.
 */
public class LocalizedNamesImpl_eu extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AD",
        "AF",
        "CF",
        "AI",
        "AX",
        "AL",
        "DE",
        "DZ",
        "AS",
        "US",
        "AO",
        "AQ",
        "AG",
        "AE",
        "AR",
        "AM",
        "AU",
        "AT",
        "AW",
        "AZ",
        "BS",
        "BD",
        "BB",
        "BE",
        "BJ",
        "BH",
        "BT",
        "BY",
        "VI",
        "VG",
        "MM",
        "BL",
        "BM",
        "BN",
        "BO",
        "CI",
        "BA",
        "BW",
        "BV",
        "BR",
        "BG",
        "BF",
        "BI",
        "BZ",
        "CV",
        "CX",
        "CC",
        "CK",
        "CP",
        "CR",
        "DK",
        "DG",
        "DJ",
        "DM",
        "DO",
        "EA",
        "EG",
        "TL",
        "EC",
        "GQ",
        "ER",
        "GB",
        "RO",
        "RU",
        "SK",
        "SI",
        "ES",
        "UM",
        "EE",
        "ET",
        "EU",
        "FO",
        "PH",
        "FI",
        "FJ",
        "FR",
        "TF",
        "GA",
        "GM",
        "GD",
        "GE",
        "GH",
        "GI",
        "GN",
        "GW",
        "GP",
        "GR",
        "GL",
        "GT",
        "GU",
        "GG",
        "GF",
        "GY",
        "HT",
        "HM",
        "ZA",
        "GS",
        "KR",
        "NL",
        "HK",
        "AN",
        "HN",
        "HU",
        "IC",
        "IN",
        "IO",
        "ID",
        "KP",
        "MP",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IL",
        "IT",
        "JM",
        "JP",
        "JE",
        "JO",
        "KY",
        "NC",
        "CM",
        "CA",
        "KH",
        "QA",
        "KZ",
        "KE",
        "KG",
        "KI",
        "CO",
        "KM",
        "CG",
        "CD",
        "HR",
        "CU",
        "KW",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MG",
        "MO",
        "MY",
        "MW",
        "MV",
        "ML",
        "FK",
        "IM",
        "MA",
        "MH",
        "MR",
        "MU",
        "MK",
        "EH",
        "MX",
        "MF",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MZ",
        "MQ",
        "MS",
        "MT",
        "NA",
        "NP",
        "NE",
        "NG",
        "NI",
        "NF",
        "NO",
        "NR",
        "NU",
        "OM",
        "PA",
        "PK",
        "PS",
        "PG",
        "PY",
        "PE",
        "PN",
        "PF",
        "PL",
        "PT",
        "PR",
        "PW",
        "QO",
        "RE",
        "RW",
        "SH",
        "KN",
        "PM",
        "VC",
        "SB",
        "WS",
        "SM",
        "LC",
        "ST",
        "SA",
        "SN",
        "RS",
        "CS",
        "SC",
        "SL",
        "SG",
        "SY",
        "SO",
        "LK",
        "SD",
        "SE",
        "CH",
        "SR",
        "SV",
        "SJ",
        "SZ",
        "TA",
        "TJ",
        "TH",
        "TW",
        "TZ",
        "TG",
        "TK",
        "TO",
        "TT",
        "TN",
        "TC",
        "TR",
        "TM",
        "TV",
        "TD",
        "CZ",
        "CL",
        "CN",
        "UG",
        "UA",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "WF",
        "YE",
        "YT",
        "ZM",
        "NZ",
        "ZW",
        "CY",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AE", "Arabiar Emirrerri Batuak");
    namesMap.put("AF", "Afganistan");
    namesMap.put("AG", "Antigua eta Barbuda");
    namesMap.put("AN", "Holandarren Antillak");
    namesMap.put("AQ", "Antartika");
    namesMap.put("AS", "Amerikar Samoa");
    namesMap.put("AX", "Aland Uharteak");
    namesMap.put("BA", "Bosnia-Herzegovina");
    namesMap.put("BE", "Belgika");
    namesMap.put("BO", "Bolibia");
    namesMap.put("BR", "Brasil");
    namesMap.put("BS", "Bahamak");
    namesMap.put("BV", "Bouvet Uhartea");
    namesMap.put("BY", "Bielorrusia");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Cocos uharteak");
    namesMap.put("CD", "Kongoko Errepublika Demokratikoa");
    namesMap.put("CF", "Afrika Erdiko Errepublika");
    namesMap.put("CG", "Kongo");
    namesMap.put("CH", "Suitza");
    namesMap.put("CI", "Boli Kosta");
    namesMap.put("CK", "Cook uharteak");
    namesMap.put("CL", "Txile");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Txina");
    namesMap.put("CO", "Kolonbia");
    namesMap.put("CS", "Serbia eta Montenegro");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Cabo Verde");
    namesMap.put("CX", "Christmas uhartea");
    namesMap.put("CY", "Zipre");
    namesMap.put("CZ", "Txekiar errepublika");
    namesMap.put("DE", "Alemania");
    namesMap.put("DJ", "Djibuti");
    namesMap.put("DK", "Danimarka");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Dominikar Errepublika");
    namesMap.put("DZ", "Aljeria");
    namesMap.put("EC", "Ekuador");
    namesMap.put("EG", "Egipto");
    namesMap.put("EH", "Mendebaldeko Sahara");
    namesMap.put("ES", "Espainia");
    namesMap.put("ET", "Etiopia");
    namesMap.put("FI", "Finlandia");
    namesMap.put("FK", "Malvinak");
    namesMap.put("FM", "Mikronesia");
    namesMap.put("FO", "Faroe Uharteak");
    namesMap.put("FR", "Frantzia");
    namesMap.put("GB", "Erresuma Batua");
    namesMap.put("GF", "Guyana Frantsesa");
    namesMap.put("GL", "Groenlandia");
    namesMap.put("GN", "Ginea");
    namesMap.put("GQ", "Ekuatore Ginea");
    namesMap.put("GR", "Grezia");
    namesMap.put("GS", "Hegoaldeko Georgia eta Hegoaldeko Sandwich uharteak");
    namesMap.put("GW", "Ginea-Bissau");
    namesMap.put("HM", "Heard eta McDonald Uharteak");
    namesMap.put("HR", "Kroazia");
    namesMap.put("HU", "Hungaria");
    namesMap.put("IE", "Irlanda");
    namesMap.put("IM", "Man uhartea");
    namesMap.put("IO", "Indiako Ozeanoko Britainiar Lurraldea");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Islandia");
    namesMap.put("IT", "Italia");
    namesMap.put("JM", "Jamaika");
    namesMap.put("JO", "Jordania");
    namesMap.put("JP", "Japonia");
    namesMap.put("KE", "Kenia");
    namesMap.put("KG", "Kirgizistan");
    namesMap.put("KH", "Kanbodia");
    namesMap.put("KM", "Komoreak");
    namesMap.put("KN", "Saint Kitts eta Nevis");
    namesMap.put("KP", "Ipar Korea");
    namesMap.put("KR", "Hego Korea");
    namesMap.put("KY", "Kaiman Uharteak");
    namesMap.put("LB", "Libano");
    namesMap.put("LC", "Santa Luzia");
    namesMap.put("LT", "Lituania");
    namesMap.put("LU", "Luxenburgo");
    namesMap.put("LV", "Letonia");
    namesMap.put("LY", "Libia");
    namesMap.put("MA", "Maroko");
    namesMap.put("MC", "Monako");
    namesMap.put("MD", "Moldavia");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Marshall uharteak");
    namesMap.put("MK", "Mazedonia");
    namesMap.put("MM", "Birmania");
    namesMap.put("MO", "Makau");
    namesMap.put("MP", "Iparraldeko Mariana uharteak");
    namesMap.put("MU", "Maurizio");
    namesMap.put("MV", "Maldivak");
    namesMap.put("MX", "Mexiko");
    namesMap.put("MY", "Malasia");
    namesMap.put("MZ", "Mozambike");
    namesMap.put("NC", "Kaledonia Berria");
    namesMap.put("NF", "Norfolk uhartea");
    namesMap.put("NI", "Nikaragua");
    namesMap.put("NL", "Herbehereak");
    namesMap.put("NO", "Norvegia");
    namesMap.put("NZ", "Zeelanda Berria");
    namesMap.put("PF", "Polinesia Frantsesa");
    namesMap.put("PG", "Papua Ginea Berria");
    namesMap.put("PH", "Filipinak");
    namesMap.put("PL", "Polonia");
    namesMap.put("PM", "Saint-Pierre eta Mikelune");
    namesMap.put("PS", "Palestina");
    namesMap.put("PY", "Paraguai");
    namesMap.put("QA", "Katar");
    namesMap.put("RO", "Errumania");
    namesMap.put("RU", "Errusia");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SB", "Salomon uharteak");
    namesMap.put("SC", "Seychelleak");
    namesMap.put("SE", "Suedia");
    namesMap.put("SG", "Singapur");
    namesMap.put("SI", "Eslovenia");
    namesMap.put("SJ", "Svalbard eta Jan Mayen uharteak");
    namesMap.put("SK", "Eslovakia");
    namesMap.put("SL", "Sierra Leona");
    namesMap.put("SR", "Surinam");
    namesMap.put("ST", "Sao Tomé eta Principe");
    namesMap.put("SY", "Siria");
    namesMap.put("SZ", "Swazilandia");
    namesMap.put("TC", "Turk eta Caicos uharteak");
    namesMap.put("TD", "Txad");
    namesMap.put("TF", "Frantziaren Lurralde Australak");
    namesMap.put("TH", "Tailandia");
    namesMap.put("TJ", "Tadjikistan");
    namesMap.put("TL", "Ekialdeko Timor");
    namesMap.put("TR", "Turkia");
    namesMap.put("TT", "Trinidad eta Tobago");
    namesMap.put("UA", "Ukraina");
    namesMap.put("UM", "Estatu Batuetatik urruti dauden uharte txikiak");
    namesMap.put("US", "Ameriketako Estatu Batuak");
    namesMap.put("UY", "Uruguai");
    namesMap.put("VA", "Vatikano");
    namesMap.put("VC", "Saint Vincent eta Grenadinak");
    namesMap.put("VG", "Birjina uharte britainiarrak");
    namesMap.put("VI", "Birjina uharte amerikarrak");
    namesMap.put("WF", "Wallis eta Futuna");
    namesMap.put("ZA", "Hegoafrika");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AE": "Arabiar Emirrerri Batuak",
        "AF": "Afganistan",
        "AG": "Antigua eta Barbuda",
        "AN": "Holandarren Antillak",
        "AQ": "Antartika",
        "AS": "Amerikar Samoa",
        "AX": "Aland Uharteak",
        "BA": "Bosnia-Herzegovina",
        "BE": "Belgika",
        "BO": "Bolibia",
        "BR": "Brasil",
        "BS": "Bahamak",
        "BV": "Bouvet Uhartea",
        "BY": "Bielorrusia",
        "CA": "Kanada",
        "CC": "Cocos uharteak",
        "CD": "Kongoko Errepublika Demokratikoa",
        "CF": "Afrika Erdiko Errepublika",
        "CG": "Kongo",
        "CH": "Suitza",
        "CI": "Boli Kosta",
        "CK": "Cook uharteak",
        "CL": "Txile",
        "CM": "Kamerun",
        "CN": "Txina",
        "CO": "Kolonbia",
        "CS": "Serbia eta Montenegro",
        "CU": "Kuba",
        "CV": "Cabo Verde",
        "CX": "Christmas uhartea",
        "CY": "Zipre",
        "CZ": "Txekiar errepublika",
        "DE": "Alemania",
        "DJ": "Djibuti",
        "DK": "Danimarka",
        "DM": "Dominika",
        "DO": "Dominikar Errepublika",
        "DZ": "Aljeria",
        "EC": "Ekuador",
        "EG": "Egipto",
        "EH": "Mendebaldeko Sahara",
        "ES": "Espainia",
        "ET": "Etiopia",
        "FI": "Finlandia",
        "FK": "Malvinak",
        "FM": "Mikronesia",
        "FO": "Faroe Uharteak",
        "FR": "Frantzia",
        "GB": "Erresuma Batua",
        "GF": "Guyana Frantsesa",
        "GL": "Groenlandia",
        "GN": "Ginea",
        "GQ": "Ekuatore Ginea",
        "GR": "Grezia",
        "GS": "Hegoaldeko Georgia eta Hegoaldeko Sandwich uharteak",
        "GW": "Ginea-Bissau",
        "HM": "Heard eta McDonald Uharteak",
        "HR": "Kroazia",
        "HU": "Hungaria",
        "IE": "Irlanda",
        "IM": "Man uhartea",
        "IO": "Indiako Ozeanoko Britainiar Lurraldea",
        "IQ": "Irak",
        "IS": "Islandia",
        "IT": "Italia",
        "JM": "Jamaika",
        "JO": "Jordania",
        "JP": "Japonia",
        "KE": "Kenia",
        "KG": "Kirgizistan",
        "KH": "Kanbodia",
        "KM": "Komoreak",
        "KN": "Saint Kitts eta Nevis",
        "KP": "Ipar Korea",
        "KR": "Hego Korea",
        "KY": "Kaiman Uharteak",
        "LB": "Libano",
        "LC": "Santa Luzia",
        "LT": "Lituania",
        "LU": "Luxenburgo",
        "LV": "Letonia",
        "LY": "Libia",
        "MA": "Maroko",
        "MC": "Monako",
        "MD": "Moldavia",
        "MG": "Madagaskar",
        "MH": "Marshall uharteak",
        "MK": "Mazedonia",
        "MM": "Birmania",
        "MO": "Makau",
        "MP": "Iparraldeko Mariana uharteak",
        "MU": "Maurizio",
        "MV": "Maldivak",
        "MX": "Mexiko",
        "MY": "Malasia",
        "MZ": "Mozambike",
        "NC": "Kaledonia Berria",
        "NF": "Norfolk uhartea",
        "NI": "Nikaragua",
        "NL": "Herbehereak",
        "NO": "Norvegia",
        "NZ": "Zeelanda Berria",
        "PF": "Polinesia Frantsesa",
        "PG": "Papua Ginea Berria",
        "PH": "Filipinak",
        "PL": "Polonia",
        "PM": "Saint-Pierre eta Mikelune",
        "PS": "Palestina",
        "PY": "Paraguai",
        "QA": "Katar",
        "RO": "Errumania",
        "RU": "Errusia",
        "RW": "Ruanda",
        "SB": "Salomon uharteak",
        "SC": "Seychelleak",
        "SE": "Suedia",
        "SG": "Singapur",
        "SI": "Eslovenia",
        "SJ": "Svalbard eta Jan Mayen uharteak",
        "SK": "Eslovakia",
        "SL": "Sierra Leona",
        "SR": "Surinam",
        "ST": "Sao Tomé eta Principe",
        "SY": "Siria",
        "SZ": "Swazilandia",
        "TC": "Turk eta Caicos uharteak",
        "TD": "Txad",
        "TF": "Frantziaren Lurralde Australak",
        "TH": "Tailandia",
        "TJ": "Tadjikistan",
        "TL": "Ekialdeko Timor",
        "TR": "Turkia",
        "TT": "Trinidad eta Tobago",
        "UA": "Ukraina",
        "UM": "Estatu Batuetatik urruti dauden uharte txikiak",
        "US": "Ameriketako Estatu Batuak",
        "UY": "Uruguai",
        "VA": "Vatikano",
        "VC": "Saint Vincent eta Grenadinak",
        "VG": "Birjina uharte britainiarrak",
        "VI": "Birjina uharte amerikarrak",
        "WF": "Wallis eta Futuna",
        "ZA": "Hegoafrika"
    };
  }-*/;
}
