/*
 * easy_spice - a spice front end
 * Copyright (C) 2001 Routoure Jean-Marc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* This part of the code concerns the plot interface with nutmeg*/


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "easyspice.h"


void 
create_spice_plot_file(EasySpice *es, int n_step, int type_simul)
{
  FILE *file;
  gchar **plot_y;
  int i=0;
  SpiceVariables *sv=es->spice_vars;

  if (DEBUG)
    printf("plot.c: n_step=%d  type_simul=%d\n", n_step, type_simul);

  if ((file = fopen(es->file_spice_plot, "wt")) == NULL) {
    write_log(_("Unable to open plot file\n"));
    /* FIXME: Why exiting here? */
    // exit(1);
    return;
  }

  fprintf(file,"plot the result\n\n");
  fprintf(file,".control\n");
  fprintf(file,"\n");
  if (n_step>0) {
    for (i=1;i<=n_step;i++)
      fprintf(file,"load rawspice%d.raw\n",i);
  }
  else {
    fprintf(file,"load rawspice.raw\n");
  }
  fprintf(file,"\n\n");
      
  /* insert the plot_pre_text into the plotfile */
  fprintf(file,"*User defined vector and plot commands: \n%s\n", sv->plot_pre);
    
  plot_y=g_strsplit(sv->plot_yvalues,";",0);
  for (i=0; plot_y[i]!=NULL; i++)      {
    fprintf(file,"plot %s", plot_y[i]);
    if ((sv->plot_xlogscale != FALSE) 
	&& (sv->plot_ylogscale != FALSE))
      fprintf(file," loglog");
    else if (sv->plot_xlogscale==TRUE)
      fprintf(file," xlog");
    else if (sv->plot_ylogscale==TRUE)
      fprintf(file," ylog");
    if ((strlen(sv->plot_xvalue)>0) && (sv->plot_xdefault==FALSE))
      fprintf(file," vs %s",sv->plot_xvalue);

    if (sv->plot_xlinscale != FALSE)
      fprintf(file," linear");
    fprintf(file,"\n");
  }
  fprintf(file,"\n.endc \n.end \n");
  g_strfreev(plot_y);
  fclose (file);
}


void 
start_plot(EasySpice *es)
{
  gchar *buf=NULL;
  FILE *plotcommand_fid;

  if (VERBOSE2)
    printf("start_plot: entering plotting function\n");

  /*kill the old plot if there's one there */
  destroy_plot(es);

  /*creat the new plot */
  buf=g_strdup_printf("{ xterm -geometry 80x5-0-0 -T \"plot log\" -e %s -i %s & } && echo $!", es->commands->spice_command, es->file_spice_plot);
  if (VERBOSE1)
    printf("executing: \"%s\"\n",buf);
  plotcommand_fid=popen(buf, "r");
  fscanf(plotcommand_fid," %d", &(es->plotcommand_pid));
  if (VERBOSE3)
    printf("  pid of plotting command is %d\n",es->plotcommand_pid);
  g_free(buf);
}

void
destroy_plot(EasySpice *es)
{
  gchar *buf;
  /* destroy the last plot if pid exists */
  if (es->plotcommand_pid > 0) {
    buf=g_strdup_printf("kill -9 %d", es->plotcommand_pid);
    es->plotcommand_pid=0;
    if (VERBOSE1) {
      printf("killing plotcommand\n");
      printf("executing: \"%s\"\n",buf);
    }
    system(buf);
    g_free(buf);
  }
}

