/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Insets;
import javax.swing.JSplitPane;
import org.fest.swing.annotation.RunsInCurrentThread;

final class VerticalJSplitPaneDividerLocation {
    @RunsInCurrentThread
    static int locationToMoveDividerToVertically(JSplitPane splitPane, int desiredLocation) {
        int minimum = VerticalJSplitPaneDividerLocation.calculateMinimum(splitPane);
        int maximum = VerticalJSplitPaneDividerLocation.calculateMaximum(splitPane);
        if (maximum < minimum) {
            maximum = 0;
            minimum = 0;
        }
        return Math.min(maximum, Math.max(minimum, desiredLocation));
    }

    private static int calculateMinimum(JSplitPane splitPane) {
        Component left = splitPane.getLeftComponent();
        if (left == null || !left.isVisible()) {
            return 0;
        }
        int minimum = left.getMinimumSize().height;
        Insets insets = splitPane.getInsets();
        if (insets != null) {
            minimum += insets.top;
        }
        return minimum;
    }

    private static int calculateMaximum(JSplitPane splitPane) {
        Component rightComponent = splitPane.getRightComponent();
        if (splitPane.getLeftComponent() == null || rightComponent == null) {
            return -1;
        }
        Insets insets = splitPane.getInsets();
        int dividerSize = splitPane.getDividerSize();
        int bottom = insets != null ? insets.bottom : 0;
        int splitPaneHeight = splitPane.getSize().height;
        if (!rightComponent.isVisible()) {
            return Math.max(0, splitPaneHeight - (dividerSize + bottom));
        }
        return Math.max(0, splitPaneHeight - (dividerSize + bottom) - rightComponent.getMinimumSize().height);
    }

    private VerticalJSplitPaneDividerLocation() {
    }
}

