      SUBROUTINE MMA4 ( ZI, ZR, ZD, ZC, ZDC )
C
C     MMA4 PERFORMS THE MATRIX OPERATION USING METHODS 40 AND 41
C       (+/-)A(T & NT) * B (+/-)C = D
C     
C     MMA4 IS DESIGNED AS FOLLOWS:
C       1.  THIS IS FOR "A" NON-TRANSPOSED AND TRANSPOSED
C       2.  PACK (IN COMPACT FORM) AS MANY COLUMNS OF THE "B" MATRIX INTO 
C           MEMORY AS POSSIBLE LEAVING SPACE FOR A FULL COLUMN OF THE 
C           "D" MATRIX FOR EACH COLUMN OF THE "B" MATRIX READ.
C           SEE SUBROUTINES MMARM1,2,3,4 FOR FORMAT OF COMPACT FORM.
C       3.  INITIALIZE EACH COLUMN OF "D" WITH THE DATA FROM "C".
C       4.  CALL UNPACK TO READ MATRIX "C".
C       5.  FOR METHOD 40, CALL UNPACK TO READ COLUMNS OF MATRIX "A".
C       6.  FOR METHOD 41, CALL MMARC1,2,3,4 TO READ COLUMNS OF "A" INTO
C           MEMORY IN COMPACT FORM.
C
      INTEGER           ZI(2)      ,MODULE(3),SYSBUF,SCRTCH
      INTEGER           TYPEI      ,TYPEP    ,TYPEU ,SIGNAB, SIGNC
      INTEGER           RD         ,RDREW    ,WRT   ,WRTREW, CLSREW,CLS
      INTEGER           OFILE      ,FILEA    ,FILEB ,FILEC , FILED
      REAL              ZR(2)
      DOUBLE PRECISION  ZD(2)
      COMPLEX           ZC(2)
      DOUBLE COMPLEX    ZDC(2)
      COMMON / NAMES  / RD         ,RDREW    ,WRT   ,WRTREW, CLSREW,CLS
      COMMON / TYPE   / IPRC(2)    ,NWORDS(4),IRC(4)
      COMMON / MPYADX / FILEA(7)   ,FILEB(7) ,FILEC(7)    
     1,                 FILED(7)   ,NZ       ,T     ,SIGNAB,SIGNC ,PREC1 
     2,                 SCRTCH     ,TIME
      INCLUDE           'MMACOM.COM'
      COMMON / SYSTEM / KSYSTM(152)
      COMMON / UNPAKX / TYPEU      ,IUROW1   ,IUROWN, INCRU
      COMMON / PACKX  / TYPEI      ,TYPEP    ,IPROW1, IPROWN , INCRP
      EQUIVALENCE       (KSYSTM( 1),SYSBUF)  , (KSYSTM( 2),NOUT  ) 
      EQUIVALENCE       (KSYSTM(58),KSYS58)
      EQUIVALENCE       (FILEA(2)  ,NAC   )  , (FILEA(3)  ,NAR   )
     1,                 (FILEA(4)  ,NAFORM)  , (FILEA(5)  ,NATYPE)
     2,                 (FILEA(6)  ,NANZWD)  , (FILEA(7)  ,NADENS)
      EQUIVALENCE       (FILEB(2)  ,NBC   )  , (FILEB(3)  ,NBR   )
     1,                 (FILEB(4)  ,NBFORM)  , (FILEB(5)  ,NBTYPE)
     2,                 (FILEB(6)  ,NBNZWD)  , (FILEB(7)  ,NBDENS)
      EQUIVALENCE       (FILEC(2)  ,NCC   )  , (FILEC(3)  ,NCR   )
     1,                 (FILEC(4)  ,NCFORM)  , (FILEC(5)  ,NCTYPE)
     2,                 (FILEC(6)  ,NCNZWD)  , (FILEC(7)  ,NCDENS)
      EQUIVALENCE       (FILED(2)  ,NDC   )  , (FILED(3)  ,NDR   )
     1,                 (FILED(4)  ,NDFORM)  , (FILED(5)  ,NDTYPE)
     2,                 (FILED(6)  ,NDNZWD)  , (FILED(7)  ,NDDENS)
C
      DATA    MODULE / 4HMMA4  , 4H     ,4H    /
      DATA    KZERO  / 1H0   /   
      DATA    KONE   / 1H1   /
      DATA    JBEGN  / 4HBEGN/ , JEND  / 3HEND /
      MODULE( 3 ) = JBEGN
      IF ( NASTOR .EQ. 1 ) MODULE( 2 ) = KZERO
      IF ( NASTOR .EQ. 2 ) MODULE( 2 ) = KONE
      CALL CONMSG ( MODULE, 3, 0 )
      INCRU  = 1
      TYPEI  = NDTYPE
      TYPEP  = NDTYPE
      NWDD   = NWORDS( NDTYPE )
      NWDB   = NWORDS( NBTYPE )
C
C   OPEN CORE ALLOCATION AS FOLLOWS:
C     Z( 1        ) = ARRAY FOR ONE COLUMN OF "A" MATRIX
C     Z( IBX      ) = ARRAY FOR MULTIPLE COLUMNS OF "B" MATRIX
C     Z( IDX      ) = ARRAY FOR MULTIPLE COLUMNS OF "D" MATRIX
C        THROUGH
C     Z( LASMEM   )
C     Z( IBUF4    ) = BUFFER FOR "D" FILE
C     Z( IBUF3    ) = BUFFER FOR "C" FILE
C     Z( IBUF2    ) = BUFFER FOR "B" FILE 
C     Z( IBUF1    ) = BUFFER FOR "A" FILE
C     Z( NZ       ) = END OF OPEN CORE THAT IS AVAILABLE
C
      IBX = 1 + NWDD*NAR
      IF ( NASTOR .EQ. 2 .OR.  KSYS58 .EQ. 41 ) IBX = 1 + NWDD*NAR + NAR
      IF ( MOD ( IBX , 2 ) .EQ. 0 ) IBX = IBX + 1
      IBX2   = ( ( IBX+1 ) / 2 )
      IBUF1  = NZ    - SYSBUF
      IBUF2  = IBUF1 - SYSBUF
      IBUF3  = IBUF2 - SYSBUF
      IBUF4  = IBUF3 - SYSBUF
      LASMEMS= IBUF4 - 1
C
C INSURE THAT LASMEM IS ON A QUAD WORD BOUNDARY TO ALLOW FOR COMPLEX
C DOUBLE DATA TO BE REFERENCED FOR "D" MATRIX COLUMNS
C
      ITEST = MOD( LASMEMS, 4 )
      IF ( ITEST .EQ. 1 ) GO TO 90
      IF ( ITEST .EQ. 0 ) LASMEMS = LASMEMS - 3
      IF ( ITEST .EQ. 2 ) LASMEMS = LASMEMS - 5
      IF ( ITEST .EQ. 3 ) LASMEMS = LASMEMS - 6
90    CONTINUE
      IPROW1 = 1
      IPROWN = NDR
      INCRP  = 1
      CALL GOPEN ( FILEA, ZR( IBUF1 ), RDREW )
      CALL GOPEN ( FILEB, ZR( IBUF2 ), RDREW )
      IF ( FILEC( 1 ) .NE. 0 .AND. SIGNC .NE. 0 ) 
     &CALL GOPEN ( FILEC, ZR( IBUF3 ), RDREW )
      IPASS  = 0
      IRCOLN = 0
      NWDDNDR= NWDD*NDR
      CALL GOPEN ( FILED, ZR( IBUF4 ), WRTREW)
      FILED( 2 ) = 0
      FILED( 6 ) = 0
      FILED( 7 ) = 0
100   IPASS  = IPASS + 1
      IRCOL1 = IRCOLN + 1
      IRCOLN = NBC
      IRFILE = FILEB( 1 )       
      SIGN   = SIGNAB      
      LASMEM = LASMEMS - IBX
      IF ( IPASS  .NE. 1 ) 
     &  CALL DSSPOS ( IRFILE, IRPOS( 1 ), IRPOS( 2 ),IRPOS( 3 ) )
      IF ( NDTYPE .EQ. 1 ) CALL MMARM1 ( ZI( IBX ), ZR( IBX  ), NWDDNDR)
      IF ( NDTYPE .EQ. 2 ) CALL MMARM2 ( ZI( IBX ), ZD( IBX2 ), NWDDNDR)
      IF ( NDTYPE .EQ. 3 ) CALL MMARM3 ( ZI( IBX ), ZC( IBX2 ), NWDDNDR)
      IF ( NDTYPE .EQ. 4 ) CALL MMARM4 ( ZI( IBX ), ZD( IBX2 ), NWDDNDR)
      NCOLPP = IRCOLN - IRCOL1 + 1
      IBROW  = IRCOL1 - 1
      IDX    = LASMEM + IBX
      IDX2   = ( ( IDX+1 ) / 2 ) - 1  
      IDX4   = ( IDX+1 ) / 4    
      IF ( IPASS .EQ. 1 ) GO TO 300
      CALL REWIND( FILEA )
      CALL SKPREC( FILEA, 1 )
300   CONTINUE
C
C NOW READ INTO MEMORY THE "C" FILE.
C READ AS MANY COLUMNS OF THIS AS WERE READ OF THE "B" MATRIX
C
      IF ( FILEC( 1 ) .EQ. 0 .OR. SIGNC .EQ. 0 ) GO TO 800
      INDXD  = IDX
      TYPEU  = NDTYPE * SIGNC
      IUROW1 = 1
      IUROWN = NCR
      DO 700 I = 1, NCOLPP
      CALL UNPACK( * 650, FILEC, ZR( INDXD ) )
      GO TO 680
C
C NULL COLUMN READ ON "C"
C
650   CONTINUE
      LEN = INDXD + NWDDNDR - 1
      DO 620 K = INDXD, LEN
      ZR( K ) = 0.0
620   CONTINUE
680   CONTINUE
      INDXD   = INDXD + NWDDNDR
700   CONTINUE
      GO TO 900
C
C "C" MATRIX IS NULL OR "SIGNC" IS ZERO
C
800   CONTINUE
      LEN = IDX + NCOLPP*NWDDNDR - 1
      DO 850 K = IDX, LEN
      ZR( K ) = 0.0
850   CONTINUE
900   CONTINUE
C
C PROCESS ALL OF THE COLUMNS OF "A" MATRIX
C
      SIGN = 1
      IF ( KSYS58 .EQ. 40 ) GO TO 950
      IF ( KSYS58 .EQ. 41 ) GO TO 1000
      IF ( NASTOR .EQ. 2  ) GO TO 1000     
C PROCESS ALL OF THE COLUMNS OF "B", ADD "C" DATA ON FIRST PASS
950   CONTINUE
      IF ( NDTYPE .EQ. 1 ) CALL MMA401( ZI, ZR )
      IF ( NDTYPE .EQ. 2 ) CALL MMA402( ZI, ZD )
      IF ( NDTYPE .EQ. 3 ) CALL MMA403( ZI, ZC )
      IF ( NDTYPE .EQ. 4 ) CALL MMA404( ZI, ZD, ZDC )
      GO TO 60000
1000  CONTINUE
      IF ( NDTYPE .EQ. 1 ) CALL MMA411( ZI, ZR )
      IF ( NDTYPE .EQ. 2 ) CALL MMA412( ZI, ZD )
      IF ( NDTYPE .EQ. 3 ) CALL MMA413( ZI, ZC )
      IF ( NDTYPE .EQ. 4 ) CALL MMA414( ZI, ZD, ZDC )
60000 CONTINUE
      IF ( IRCOLN .LT. NBC ) GO TO 100
C
C ALL COLUMNS OF A HAVE BEEN PROCESSED, MULTIPLICATION COMPLETE
C
      CALL CLOSE ( FILEA, CLSREW )
      CALL CLOSE ( FILEB, CLSREW )
      CALL CLOSE ( FILEC, CLSREW )
      CALL CLOSE ( FILED, CLSREW )
      MODULE( 3 ) = JEND
      CALL CONMSG ( MODULE, 3, 0 )
      RETURN
      END
