#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2021 Anna Lea
set -o errexit

###
# Leisure Suit Larry series:
# - Leisure Suit Larry 1
# - Leisure Suit Larry 2
# - Leisure Suit Larry 3
# - Leisure Suit Larry 5
# - Leisure Suit Larry 6
# - Leisure Suit Larry 7
# send your bug reports to contact@dotslashplay.it
###

script_version=20241201.1

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID_LSL1='leisure-suit-larry-1'
GAME_NAME_LSL1='Leisure Suit Larry 1: In the Land of the Lounge Lizards'

GAME_ID_LSL2='leisure-suit-larry-2'
GAME_NAME_LSL2='Leisure Suit Larry 2: Looking For Love (In Several Wrong Places)'

GAME_ID_LSL3='leisure-suit-larry-3'
GAME_NAME_LSL3='Leisure Suit Larry 3: Passionate Patti in Pursuit of the Pulsating Pectorals!'

GAME_ID_LSL5='leisure-suit-larry-5'
GAME_NAME_LSL5='Leisure Suit Larry 5: Passionate Patti Does a Little Undercover Work!'

GAME_ID_LSL6='leisure-suit-larry-6'
GAME_NAME_LSL6='Leisure Suit Larry 6: Shape Up Or Slip Out'

GAME_ID_LSL7='leisure-suit-larry-7'
GAME_NAME_LSL7='Leisure Suit Larry 7: Love for Sail!'

ARCHIVE_BASE_LSL1_AGI_0_NAME='leisure_suit_larry_en_gog_2_20270.sh'
ARCHIVE_BASE_LSL1_AGI_0_MD5='bfd706b6e10333f538e30df3ccc572a4'
ARCHIVE_BASE_LSL1_AGI_0_SIZE='94000'
ARCHIVE_BASE_LSL1_AGI_0_VERSION='2-gog20270'
ARCHIVE_BASE_LSL1_AGI_0_URL='https://www.gog.com/game/leisure_suit_larry'

ARCHIVE_BASE_LSL1_SCI_0_NAME='leisure_suit_larry_vga_en_gog_2_20240.sh'
ARCHIVE_BASE_LSL1_SCI_0_MD5='40b241062ea3945e20e2d3c8fc811e0c'
ARCHIVE_BASE_LSL1_SCI_0_SIZE='97000'
ARCHIVE_BASE_LSL1_SCI_0_VERSION='2-gog20240'
ARCHIVE_BASE_LSL1_SCI_0_URL='https://www.gog.com/game/leisure_suit_larry'

ARCHIVE_BASE_LSL2_0_NAME='leisure_suit_larry_2_en_gog_2_20240.sh'
ARCHIVE_BASE_LSL2_0_MD5='087013fa8383ffa303dda015c5ea6249'
ARCHIVE_BASE_LSL2_0_SIZE='96000'
ARCHIVE_BASE_LSL2_0_VERSION='2-gog20240'
ARCHIVE_BASE_LSL2_0_URL='https://www.gog.com/game/leisure_suit_larry'

ARCHIVE_BASE_LSL3_0_NAME='leisure_suit_larry_3_en_gog_2_20240.sh'
ARCHIVE_BASE_LSL3_0_MD5='a0c5e4997f682e3a6c91a19a41a5bdac'
ARCHIVE_BASE_LSL3_0_SIZE='99000'
ARCHIVE_BASE_LSL3_0_VERSION='1.021-gog20240'
ARCHIVE_BASE_LSL3_0_URL='https://www.gog.com/game/leisure_suit_larry'

ARCHIVE_BASE_LSL5_0_NAME='leisure_suit_larry_5_en_gog_2_20240.sh'
ARCHIVE_BASE_LSL5_0_MD5='534a263fffc8cd919e38ae92e131ec22'
ARCHIVE_BASE_LSL5_0_SIZE='110000'
ARCHIVE_BASE_LSL5_0_VERSION='1.000-gog20240'
ARCHIVE_BASE_LSL5_0_URL='https://www.gog.com/game/leisure_suit_larry'

ARCHIVE_BASE_LSL6_SVGA_0_NAME='gog_leisure_suit_larry_6_2.0.0.1.sh'
ARCHIVE_BASE_LSL6_SVGA_0_MD5='09f667d1230974bd6321bde648de687b'
ARCHIVE_BASE_LSL6_SVGA_0_SIZE='550000'
ARCHIVE_BASE_LSL6_SVGA_0_VERSION='1.000.000-gog2.0.0.1'
ARCHIVE_BASE_LSL6_SVGA_0_URL='https://www.gog.com/game/leisure_suit_larry'

ARCHIVE_BASE_LSL6_VGA_0_NAME='leisure_suit_larry_6_vga_en_gog_2_20240.sh'
ARCHIVE_BASE_LSL6_VGA_0_MD5='d5e1973d126bc7750550729cbec4379f'
ARCHIVE_BASE_LSL6_VGA_0_SIZE='610000'
ARCHIVE_BASE_LSL6_VGA_0_VERSION='1.000.000-gog20240'
ARCHIVE_BASE_LSL6_VGA_0_URL='https://www.gog.com/game/leisure_suit_larry'

ARCHIVE_BASE_LSL7_EN_0_NAME='leisure_suit_larry_love_for_sail_en_gog_1_20744.sh'
ARCHIVE_BASE_LSL7_EN_0_MD5='38862663d3dd9298acdf3fcc5f4bd88d'
ARCHIVE_BASE_LSL7_EN_0_SIZE='680000'
ARCHIVE_BASE_LSL7_EN_0_VERSION='1.0-gog20744'
ARCHIVE_BASE_LSL7_EN_0_URL='https://www.gog.com/game/leisure_suit_larry_love_for_sail'

ARCHIVE_BASE_LSL7_FR_0_NAME='leisure_suit_larry_love_for_sail_fr_gog_1_20744.sh'
ARCHIVE_BASE_LSL7_FR_0_MD5='1386fa634b48ecb5af83fdab12e99c2d'
ARCHIVE_BASE_LSL7_FR_0_SIZE='630000'
ARCHIVE_BASE_LSL7_FR_0_VERSION='1.0-gog20744'
ARCHIVE_BASE_LSL7_FR_0_URL='https://www.gog.com/game/leisure_suit_larry_love_for_sail'

CONTENT_PATH_DEFAULT='data/noarch/data'
CONTENT_GAME_MAIN_FILES_LSL1_AGI='
object
words.tok
vol.*
*dir'
CONTENT_GAME_MAIN_FILES_LSL1_SCI='
version
resource.*
*.bat
*.drv
*.exe
*.hlp
*.txt'
## FIXME: An explicit list of files should be set.
CONTENT_GAME_MAIN_FILES_LSL2='
*'
CONTENT_GAME_MAIN_FILES_LSL3='
install.txt
readme.txt
lsl3sg.*
resource.*
*.com
*.drv
*.exe
*.hlp
*.inf
*.pif
*.scr'
## FIXME: An explicit list of files should be set.
CONTENT_GAME_MAIN_FILES_LSL5='
*'
CONTENT_GAME_MAIN_FILES_LSL6='
aud
patches
sfx
readme
version
resource.*
*.com
*.drv
*.err
*.exe
*.hlp
*.scr
*.txt'
CONTENT_GAME_MAIN_FILES_LSL7='
drivers
movie
music
patches
version
resource.???
*.000
*.bmp
*.csc
*.dll
*.err
*.exe
*.inf'
CONTENT_DOC_MAIN_PATH='data/noarch/docs'
CONTENT_DOC_MAIN_FILES='
*.pdf'
CONTENT_DOC_MAIN_FILES_LSL1='
lsl1 answers.txt
lsl1 vga answers.txt
*.pdf'
CONTENT_DOC0_MAIN_FILES_LSL3='
lsl3 answers.txt'
CONTENT_DOC0_MAIN_FILES_LSL7='
manual.pdf'

APP_MAIN_SCUMMID_LSL1_AGI='agi:lsl1'
APP_MAIN_SCUMMID_LSL1_SCI='sci:lsl1sci'
APP_MAIN_SCUMMID_LSL2='sci:lsl2'
APP_MAIN_SCUMMID_LSL3='sci:lsl3'
APP_MAIN_SCUMMID_LSL5='sci:lsl5'
APP_MAIN_SCUMMID_LSL6_SVGA='sci:lsl6hires'
APP_MAIN_SCUMMID_LSL6_VGA='sci:lsl6'
APP_MAIN_SCUMMID_LSL7='sci:lsl7'
APP_MAIN_ICON='../support/icon.png'
APP_MAIN_ICON_LSL7='lsl7.ico'

PKG_MAIN_ID_LSL1="$GAME_ID_LSL1"
PKG_MAIN_ID_LSL6="$GAME_ID_LSL6"
PKG_MAIN_ID_LSL7="$GAME_ID_LSL7"
PKG_MAIN_PROVIDES_LSL1="
$PKG_MAIN_ID_LSL1"
PKG_MAIN_PROVIDES_LSL6="
$PKG_MAIN_ID_LSL6"
PKG_MAIN_PROVIDES_LSL7="
$PKG_MAIN_ID_LSL7"
PKG_MAIN_ID_LSL1_AGI="${PKG_MAIN_ID_LSL1}-agi"
PKG_MAIN_ID_LSL1_SCI="${PKG_MAIN_ID_LSL1}-sci"
PKG_MAIN_ID_LSL6_SVGA="${PKG_MAIN_ID_LSL6}-svga"
PKG_MAIN_ID_LSL6_VGA="${PKG_MAIN_ID_LSL6}-vga"
PKG_MAIN_ID_LSL7_EN="${PKG_MAIN_ID_LSL7}-en"
PKG_MAIN_ID_LSL7_FR="${PKG_MAIN_ID_LSL7}-fr"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	## Convert all file paths to lowercase.
	tolower .
)

# Include game data

content_inclusion_icons
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
