
using System;
using System.Resources;
using System.Windows.Forms;



public class CreateKeyboards
{
	public static void Main() 
	{
		ResXResourceWriter rsxw = new ResXResourceWriter ("keyboards.resx"); 
		KeyboardLayout [] table = new KeyboardLayout [64];

				table [0] = new KeyboardLayout (1033, "United States keyboard layout", 0, 0, new uint [][] {
			new uint [] {0x60, 0x7e, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x40, }, new uint [] {0x33, 0x23, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x5e, }, new uint [] {0x37, 0x26, }, 
			new uint [] {0x38, 0x2a, }, new uint [] {0x39, 0x28, }, 
			new uint [] {0x30, 0x29, }, new uint [] {0x2d, 0x5f, }, 
			new uint [] {0x3d, 0x2b, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0x5b, 0x7b, }, 
			new uint [] {0x5d, 0x7d, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0x3b, 0x3a, }, new uint [] {0x27, 0x22, }, 
			new uint [] {0x5c, 0x7c, }, new uint [] {0x7a, 0x5a, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3c, }, new uint [] {0x2e, 0x3e, }, 
			new uint [] {0x2f, 0x3f, }, new uint [] {}, 
			new uint [] {}, 		});
		table [1] = new KeyboardLayout (1033, "United States keyboard layout (phantom key version)", 0, 0, new uint [][] {
			new uint [] {0x60, 0x7e, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x40, }, new uint [] {0x33, 0x23, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x5e, }, new uint [] {0x37, 0x26, }, 
			new uint [] {0x38, 0x2a, }, new uint [] {0x39, 0x28, }, 
			new uint [] {0x30, 0x29, }, new uint [] {0x2d, 0x5f, }, 
			new uint [] {0x3d, 0x2b, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0x5b, 0x7b, }, 
			new uint [] {0x5d, 0x7d, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0x3b, 0x3a, }, new uint [] {0x27, 0x22, }, 
			new uint [] {0x5c, 0x7c, }, new uint [] {0x7a, 0x5a, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3c, }, new uint [] {0x2e, 0x3e, }, 
			new uint [] {0x2f, 0x3f, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [2] = new KeyboardLayout (1033, "United States keyboard layout (dvorak)", 1, 2, new uint [][] {
			new uint [] {0x60, 0x7e, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x40, }, new uint [] {0x33, 0x23, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x5e, }, new uint [] {0x37, 0x26, }, 
			new uint [] {0x38, 0x2a, }, new uint [] {0x39, 0x28, }, 
			new uint [] {0x30, 0x29, }, new uint [] {0x5b, 0x7b, }, 
			new uint [] {0x5d, 0x7d, }, new uint [] {0x27, 0x22, }, 
			new uint [] {0x2c, 0x3c, }, new uint [] {0x2e, 0x3e, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0x79, 0x59, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x63, 0x43, }, new uint [] {0x72, 0x52, }, 
			new uint [] {0x6c, 0x4c, }, new uint [] {0x2f, 0x3f, }, 
			new uint [] {0x3d, 0x2b, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x6f, 0x4f, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x75, 0x55, }, new uint [] {0x69, 0x49, }, 
			new uint [] {0x64, 0x44, }, new uint [] {0x68, 0x48, }, 
			new uint [] {0x74, 0x54, }, new uint [] {0x6e, 0x4e, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x2d, 0x5f, }, 
			new uint [] {0x5c, 0x7c, }, new uint [] {0x3b, 0x3a, }, 
			new uint [] {0x71, 0x51, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x78, 0x58, }, 
			new uint [] {0x62, 0x42, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x76, 0x56, }, 
			new uint [] {0x7a, 0x5a, }, new uint [] {}, 
			new uint [] {}, 		});
		table [3] = new KeyboardLayout (1033, "United States International keyboard layout", 0, 0, new uint [][] {
			new uint [] {0x60, 0x7e, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x40, }, new uint [] {0x33, 0x23, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x5e, }, new uint [] {0x37, 0x26, }, 
			new uint [] {0x38, 0x2a, }, new uint [] {0x39, 0x28, }, 
			new uint [] {0x30, 0x29, }, new uint [] {0x2d, 0x5f, }, 
			new uint [] {0x3d, 0x2b, }, new uint [] {0x5c, 0x7c, }, 
			new uint [] {0x71, 0x51, }, new uint [] {0x77, 0x57, }, 
			new uint [] {0x65, 0x45, }, new uint [] {0x72, 0x52, }, 
			new uint [] {0x74, 0x54, }, new uint [] {0x79, 0x59, }, 
			new uint [] {0x75, 0x55, }, new uint [] {0x69, 0x49, }, 
			new uint [] {0x6f, 0x4f, }, new uint [] {0x70, 0x50, }, 
			new uint [] {0x5b, 0x7b, }, new uint [] {0x5d, 0x7d, }, 
			new uint [] {0x61, 0x41, }, new uint [] {0x73, 0x53, }, 
			new uint [] {0x64, 0x44, }, new uint [] {0x66, 0x46, }, 
			new uint [] {0x67, 0x47, }, new uint [] {0x68, 0x48, }, 
			new uint [] {0x6a, 0x4a, }, new uint [] {0x6b, 0x4b, }, 
			new uint [] {0x6c, 0x4c, }, new uint [] {0x3b, 0x3a, }, 
			new uint [] {0x27, 0x22, }, new uint [] {0x7a, 0x5a, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3c, }, new uint [] {0x2e, 0x3e, }, 
			new uint [] {0x2f, 0x3f, }, new uint [] {}, 
			new uint [] {}, 		});
		table [4] = new KeyboardLayout (2057, "British keyboard layout", 0, 0, new uint [][] {
			new uint [] {0x60, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x22, }, new uint [] {0x33, 0xffffffa3, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x5e, }, new uint [] {0x37, 0x26, }, 
			new uint [] {0x38, 0x2a, }, new uint [] {0x39, 0x28, }, 
			new uint [] {0x30, 0x29, }, new uint [] {0x2d, 0x5f, }, 
			new uint [] {0x3d, 0x2b, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0x5b, 0x7b, }, 
			new uint [] {0x5d, 0x7d, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0x3b, 0x3a, }, new uint [] {0x27, 0x40, }, 
			new uint [] {0x23, 0x7e, }, new uint [] {0x7a, 0x5a, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3c, }, new uint [] {0x2e, 0x3e, }, 
			new uint [] {0x2f, 0x3f, }, new uint [] {0x5c, 0x7c, }, 
			new uint [] {}, 		});
		table [5] = new KeyboardLayout (1031, "German keyboard layout", 0, 1, new uint [][] {
			new uint [] {0x5e, 0xffffffb0, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x22, }, new uint [] {0x33, 0xffffffa7, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x26, }, new uint [] {0x37, 0x2f, }, 
			new uint [] {0x38, 0x28, }, new uint [] {0x39, 0x29, }, 
			new uint [] {0x30, 0x3d, }, new uint [] {0xffffffdf, 0x3f, }, 
			new uint [] {0xffffffb4, 0x60, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x7a, 0x5a, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0xfffffffc, 0xffffffdc, }, 
			new uint [] {0x2b, 0x2a, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0xfffffff6, 0xffffffd6, }, new uint [] {0xffffffe4, 0xffffffc4, }, 
			new uint [] {0x23, 0x27, }, new uint [] {0x79, 0x59, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3b, }, new uint [] {0x2e, 0x3a, }, 
			new uint [] {0x2d, 0x5f, }, new uint [] {0x3c, 0x3e, 0x7c, }, 
			new uint [] {}, 		});
		table [6] = new KeyboardLayout (1031, "German keyboard layout without dead keys", 0, 1, new uint [][] {
			new uint [] {0x5e, 0xffffffb0, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x22, }, new uint [] {0x33, 0xffffffa7, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x26, }, new uint [] {0x37, 0x2f, 0x7b, }, 
			new uint [] {0x38, 0x28, 0x5b, }, new uint [] {0x39, 0x29, 0x5d, }, 
			new uint [] {0x30, 0x3d, 0x7d, }, new uint [] {0xffffffdf, 0x3f, 0x5c, }, 
			new uint [] {0xffffffb4, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x7a, 0x5a, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0xfffffffc, 0xffffffdc, }, 
			new uint [] {0x2b, 0x2a, 0x7e, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0xfffffff6, 0xffffffd6, }, new uint [] {0xffffffe4, 0xffffffc4, }, 
			new uint [] {0x23, 0x27, }, new uint [] {0x79, 0x59, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3b, }, new uint [] {0x2e, 0x3a, }, 
			new uint [] {0x2d, 0x5f, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [7] = new KeyboardLayout (1031, "German keyboard layout for logitech desktop pro", 0, 1, new uint [][] {
			new uint [] {0x5e, 0xffffffb0, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x22, }, new uint [] {0x33, 0xffffffa7, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x26, }, new uint [] {0x37, 0x2f, 0x7b, }, 
			new uint [] {0x38, 0x28, 0x5b, }, new uint [] {0x39, 0x29, 0x5d, }, 
			new uint [] {0x30, 0x3d, 0x7d, }, new uint [] {0xffffffdf, 0x3f, 0x5c, }, 
			new uint [] {0x27, 0x60, }, new uint [] {0x71, 0x51, 0x40, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x7a, 0x5a, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0xfffffffc, 0xffffffdc, }, 
			new uint [] {0x2b, 0x2a, 0x7e, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0xfffffff6, 0xffffffd6, }, new uint [] {0xffffffe4, 0xffffffc4, }, 
			new uint [] {0x23, 0x27, }, new uint [] {0x79, 0x59, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3b, }, new uint [] {0x2e, 0x3a, }, 
			new uint [] {0x2d, 0x5f, }, new uint [] {0x3c, 0x3e, 0x7c, }, 
			new uint [] {}, 		});
		table [8] = new KeyboardLayout (1031, "German keyboard layout without dead keys 105", 0, 3, new uint [][] {
			new uint [] {0x5e, 0xffffffb0, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x22, 0xffffffb2, }, new uint [] {0x33, 0xffffffa7, 0xffffffb3, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x26, }, new uint [] {0x37, 0x2f, 0x7b, }, 
			new uint [] {0x38, 0x28, 0x5b, }, new uint [] {0x39, 0x29, 0x5d, }, 
			new uint [] {0x30, 0x3d, 0x7d, }, new uint [] {0xffffffdf, 0x3f, 0x5c, }, 
			new uint [] {0x27, 0x60, }, new uint [] {0x71, 0x51, 0x40, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x7a, 0x5a, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0xfffffffc, 0xffffffdc, }, 
			new uint [] {0x2b, 0x2a, 0x7e, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0xfffffff6, 0xffffffd6, }, new uint [] {0xffffffe4, 0xffffffc4, }, 
			new uint [] {0x23, 0x27, }, new uint [] {0x3c, 0x3e, 0x7c, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0x78, 0x58, }, 
			new uint [] {0x63, 0x43, }, new uint [] {0x76, 0x56, }, 
			new uint [] {0x62, 0x42, }, new uint [] {0x6e, 0x4e, }, 
			new uint [] {0x6d, 0x4d, }, new uint [] {0x2c, 0x3b, }, 
			new uint [] {0x2e, 0x3a, }, new uint [] {0x2d, 0x5f, }, 
			new uint [] {}, 		});
		table [9] = new KeyboardLayout (2055, "Swiss German keyboard layout", 0, 1, new uint [][] {
			new uint [] {0xffffffa7, 0xffffffb0, }, new uint [] {0x31, 0x2b, }, 
			new uint [] {0x32, 0x22, }, new uint [] {0x33, 0x2a, }, 
			new uint [] {0x34, 0xffffffe7, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x26, }, new uint [] {0x37, 0x2f, }, 
			new uint [] {0x38, 0x28, }, new uint [] {0x39, 0x29, }, 
			new uint [] {0x30, 0x3d, }, new uint [] {0x27, 0x3f, }, 
			new uint [] {0x5e, 0x60, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x7a, 0x5a, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0xfffffffc, 0xffffffe8, }, 
			new uint [] {0xffffffa8, 0x21, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0xfffffff6, 0xffffffe9, }, new uint [] {0xffffffe4, 0xffffffe0, }, 
			new uint [] {0x24, 0xffffffa3, }, new uint [] {0x79, 0x59, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3b, }, new uint [] {0x2e, 0x3a, }, 
			new uint [] {0x2d, 0x5f, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [10] = new KeyboardLayout (4108, "Swiss French keyboard layout", 0, 1, new uint [][] {
			new uint [] {0xffffffa7, 0xffffffb0, }, new uint [] {0x31, 0x2b, }, 
			new uint [] {0x32, 0x22, }, new uint [] {0x33, 0x2a, }, 
			new uint [] {0x34, 0xffffffe7, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x26, }, new uint [] {0x37, 0x2f, }, 
			new uint [] {0x38, 0x28, }, new uint [] {0x39, 0x29, }, 
			new uint [] {0x30, 0x3d, }, new uint [] {0x27, 0x3f, }, 
			new uint [] {0x5e, 0x60, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x7a, 0x5a, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0xffffffe8, 0xfffffffc, }, 
			new uint [] {0xffffffa8, 0x21, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0xffffffe9, 0xfffffff6, }, new uint [] {0xffffffe0, 0xffffffe4, }, 
			new uint [] {0x24, 0xffffffa3, }, new uint [] {0x79, 0x59, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3b, }, new uint [] {0x2e, 0x3a, }, 
			new uint [] {0x2d, 0x5f, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [11] = new KeyboardLayout (1053, "Swedish keyboard layout", 0, 5, new uint [][] {
			new uint [] {0xffffffa7, 0xffffffbd, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x22, }, new uint [] {0x33, 0x23, }, 
			new uint [] {0x34, 0xffffffa4, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x26, }, new uint [] {0x37, 0x2f, }, 
			new uint [] {0x38, 0x28, }, new uint [] {0x39, 0x29, }, 
			new uint [] {0x30, 0x3d, }, new uint [] {0x2b, 0x3f, }, 
			new uint [] {0xffffffb4, 0x60, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0xffffffe5, 0xffffffc5, }, 
			new uint [] {0xffffffa8, 0x5e, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0xfffffff6, 0xffffffd6, }, new uint [] {0xffffffe4, 0xffffffc4, }, 
			new uint [] {0x27, 0x2a, }, new uint [] {0x7a, 0x5a, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3b, }, new uint [] {0x2e, 0x3a, }, 
			new uint [] {0x2d, 0x5f, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [12] = new KeyboardLayout (1061, "Estonian keyboard layout", 0, 0, new uint [][] {
			new uint [] {0xffffffb7, 0x7e, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x22, }, new uint [] {0x33, 0x23, }, 
			new uint [] {0x34, 0xffffffa4, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x26, }, new uint [] {0x37, 0x2f, }, 
			new uint [] {0x38, 0x28, }, new uint [] {0x39, 0x29, }, 
			new uint [] {0x30, 0x3d, }, new uint [] {0x2b, 0x3f, }, 
			new uint [] {0xffffffb4, 0x60, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0xfffffffc, 0xffffffdc, }, 
			new uint [] {0xfffffff5, 0xffffffd5, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0xfffffff6, 0xffffffd6, }, new uint [] {0xffffffe4, 0xffffffc4, }, 
			new uint [] {0x27, 0x2a, }, new uint [] {0x7a, 0x5a, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3b, }, new uint [] {0x2e, 0x3a, }, 
			new uint [] {0x2d, 0x5f, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [13] = new KeyboardLayout (1044, "Norwegian keyboard layout", 0, 0, new uint [][] {
			new uint [] {0x7c, 0xffffffa7, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x22, 0x40, }, new uint [] {0x33, 0x23, 0xffffffa3, }, 
			new uint [] {0x34, 0xffffffa4, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x26, }, new uint [] {0x37, 0x2f, 0x7b, }, 
			new uint [] {0x38, 0x28, 0x5b, }, new uint [] {0x39, 0x29, 0x5d, }, 
			new uint [] {0x30, 0x3d, 0x7d, }, new uint [] {0x2b, 0x3f, }, 
			new uint [] {0x5c, 0x60, 0xffffffb4, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0xffffffe5, 0xffffffc5, }, 
			new uint [] {0xffffffa8, 0x5e, 0x7e, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0xfffffff8, 0xffffffd8, }, new uint [] {0xffffffe6, 0xffffffc6, }, 
			new uint [] {0x27, 0x2a, }, new uint [] {0x7a, 0x5a, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3b, }, new uint [] {0x2e, 0x3a, }, 
			new uint [] {0x2d, 0x5f, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [14] = new KeyboardLayout (1030, "Danish keyboard layout", 0, 0, new uint [][] {
			new uint [] {0xffffffbd, 0xffffffa7, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x22, }, new uint [] {0x33, 0x23, }, 
			new uint [] {0x34, 0xffffffa4, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x26, }, new uint [] {0x37, 0x2f, }, 
			new uint [] {0x38, 0x28, }, new uint [] {0x39, 0x29, }, 
			new uint [] {0x30, 0x3d, }, new uint [] {0x2b, 0x3f, }, 
			new uint [] {0xffffffb4, 0x60, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0xffffffe5, 0xffffffc5, }, 
			new uint [] {0xffffffa8, 0x5e, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0xffffffe6, 0xffffffc6, }, new uint [] {0xfffffff8, 0xffffffd8, }, 
			new uint [] {0x27, 0x2a, }, new uint [] {0x7a, 0x5a, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3b, }, new uint [] {0x2e, 0x3a, }, 
			new uint [] {0x2d, 0x5f, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [15] = new KeyboardLayout (1036, "French keyboard layout", 0, 4, new uint [][] {
			new uint [] {0xffffffb2, }, new uint [] {0x26, 0x31, }, 
			new uint [] {0xffffffe9, 0x32, 0x7e, }, new uint [] {0x22, 0x33, 0x23, }, 
			new uint [] {0x27, 0x34, 0x7b, }, new uint [] {0x28, 0x35, 0x5b, }, 
			new uint [] {0x2d, 0x36, 0x7c, }, new uint [] {0xffffffe8, 0x37, 0x60, }, 
			new uint [] {0x5f, 0x38, 0x5c, }, new uint [] {0xffffffe7, 0x39, 0x5e, 0xffffffb1, }, 
			new uint [] {0xffffffe0, 0x30, 0x40, }, new uint [] {0x29, 0xffffffb0, 0x5d, }, 
			new uint [] {0x3d, 0x2b, 0x7d, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x7a, 0x5a, }, new uint [] {0x65, 0x45, 0xffffffbf, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0x5e, 0xffffffa8, }, 
			new uint [] {0x24, 0xffffffa3, 0xffffffa4, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x73, 0x53, 0xffffffdf, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0x6d, 0x4d, }, new uint [] {0xfffffff9, 0x25, }, 
			new uint [] {0x2a, 0xffffffb5, }, new uint [] {0x77, 0x57, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x2c, 0x3f, }, 
			new uint [] {0x3b, 0x2e, }, new uint [] {0x3a, 0x2f, }, 
			new uint [] {0x21, 0xffffffa7, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [16] = new KeyboardLayout (3084, "Canadian French keyboard layout", 0, 0, new uint [][] {
			new uint [] {0x23, 0x7c, 0x5c, }, new uint [] {0x31, 0x21, 0xffffffb1, }, 
			new uint [] {0x32, 0x22, 0x40, }, new uint [] {0x33, 0x2f, 0xffffffa3, }, 
			new uint [] {0x34, 0x24, 0xffffffa2, }, new uint [] {0x35, 0x25, 0xffffffa4, }, 
			new uint [] {0x36, 0x3f, 0xffffffac, }, new uint [] {0x37, 0x26, 0xffffffa6, }, 
			new uint [] {0x38, 0x2a, 0xffffffb2, }, new uint [] {0x39, 0x28, 0xffffffb3, }, 
			new uint [] {0x30, 0x29, 0xffffffbc, }, new uint [] {0x2d, 0x5f, 0xffffffbd, }, 
			new uint [] {0x3d, 0x2b, 0xffffffbe, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, 0xffffffa7, }, 
			new uint [] {0x70, 0x50, 0xffffffb6, }, new uint [] {0x5e, 0x5e, 0x5b, }, 
			new uint [] {0xffffffb8, 0xffffffa8, 0x5d, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0x3b, 0x3a, 0x7e, }, new uint [] {0x60, 0x60, 0x7b, }, 
			new uint [] {0x3c, 0x3e, 0x7d, }, new uint [] {0x7a, 0x5a, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x27, 0x2d, }, new uint [] {0x2e, }, 
			new uint [] {0xffffffe9, 0xffffffc9, }, new uint [] {0xffffffab, 0xffffffbb, 0xffffffb0, }, 
			new uint [] {}, 		});
		table [17] = new KeyboardLayout (3084, "Canadian French keyboard layout (CA_fr)", 0, 0, new uint [][] {
			new uint [] {0x23, 0x7c, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x22, }, new uint [] {0x33, 0x2f, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x3f, }, new uint [] {0x37, 0x26, }, 
			new uint [] {0x38, 0x2a, }, new uint [] {0x39, 0x28, }, 
			new uint [] {0x30, 0x29, }, new uint [] {0x2d, 0x5f, }, 
			new uint [] {0x3d, 0x2b, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0x5e, 0x5e, }, 
			new uint [] {0xffffffb8, 0xffffffa8, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0x3b, 0x3a, }, new uint [] {0x60, 0x60, }, 
			new uint [] {0x3c, 0x3e, }, new uint [] {0x7a, 0x5a, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x27, }, new uint [] {0x2e, }, 
			new uint [] {0xffffffe9, 0xffffffc9, }, new uint [] {0xffffffab, 0xffffffbb, }, 
			new uint [] {}, 		});
		table [18] = new KeyboardLayout (3084, "Canadian keyboard layout", 0, 0, new uint [][] {
			new uint [] {0x2f, 0x5c, }, new uint [] {0x31, 0x21, 0xffffffb9, 0xffffffa1, }, 
			new uint [] {0x32, 0x40, 0xffffffb2, }, new uint [] {0x33, 0x23, 0xffffffb3, 0xffffffa3, }, 
			new uint [] {0x34, 0x24, 0xffffffbc, 0xffffffa4, }, new uint [] {0x35, 0x25, 0xffffffbd, }, 
			new uint [] {0x36, 0x3f, 0xffffffbe, }, new uint [] {0x37, 0x26, }, 
			new uint [] {0x38, 0x2a, }, new uint [] {0x39, 0x28, }, 
			new uint [] {0x30, 0x29, }, new uint [] {0x2d, 0x5f, }, 
			new uint [] {0x3d, 0x2b, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, 0xfffffff8, 0xffffffd8, }, 
			new uint [] {0x70, 0x50, 0xfffffffe, 0xffffffde, }, new uint [] {0x5e, 0xffffffa8, 0xffffffa8, }, 
			new uint [] {0xffffffe7, 0xffffffc7, 0x7e, }, new uint [] {0x61, 0x41, 0xffffffe6, 0xffffffc6, }, 
			new uint [] {0x73, 0x53, 0xffffffdf, 0xffffffa7, }, new uint [] {0x64, 0x44, 0xfffffff0, 0xffffffd0, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0x3b, 0x3a, 0xffffffb4, }, new uint [] {0xffffffe8, 0xffffffc8, }, 
			new uint [] {0xffffffe0, 0xffffffc0, }, new uint [] {0x7a, 0x5a, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, 0xffffffa2, 0xffffffa9, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, 0xffffffb5, 0xffffffba, }, 
			new uint [] {0x2c, 0x27, }, new uint [] {0x2e, 0x22, 0xffffffb7, 0xfffffff7, }, 
			new uint [] {0xffffffe9, 0xffffffc9, }, new uint [] {0xfffffff9, 0xffffffd9, }, 
			new uint [] {}, 		});
		table [19] = new KeyboardLayout (2060, "Belgian keyboard layout", 0, 4, new uint [][] {
			new uint [] {}, new uint [] {0x26, 0x31, 0x7c, }, 
			new uint [] {0xffffffe9, 0x32, 0x40, }, new uint [] {0x22, 0x33, 0x23, }, 
			new uint [] {0x27, 0x34, }, new uint [] {0x28, 0x35, }, 
			new uint [] {0xffffffa7, 0x36, 0x5e, }, new uint [] {0xffffffe8, 0x37, }, 
			new uint [] {0x21, 0x38, }, new uint [] {0xffffffe7, 0x39, 0x7b, }, 
			new uint [] {0xffffffe0, 0x30, 0x7d, }, new uint [] {0x29, 0xffffffb0, }, 
			new uint [] {0x2d, 0x5f, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x7a, 0x5a, }, new uint [] {0x65, 0x45, 0xffffffa4, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0x5e, 0xffffffa8, 0x5b, }, 
			new uint [] {0x24, 0x2a, 0x5d, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x73, 0x53, 0xffffffdf, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0x6d, 0x4d, }, new uint [] {0xfffffff9, 0x25, 0xffffffb4, }, 
			new uint [] {0xffffffb5, 0xffffffa3, 0x60, }, new uint [] {0x77, 0x57, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x2c, 0x3f, }, 
			new uint [] {0x3b, 0x2e, }, new uint [] {0x3a, 0x2f, }, 
			new uint [] {0x3d, 0x2b, 0x7e, }, new uint [] {0x3c, 0x3e, 0x5c, }, 
			new uint [] {}, 		});
		table [20] = new KeyboardLayout (2070, "Portuguese keyboard layout", 0, 0, new uint [][] {
			new uint [] {0x5c, 0x7c, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x22, }, new uint [] {0x33, 0x23, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x26, }, new uint [] {0x37, 0x2f, }, 
			new uint [] {0x38, 0x28, }, new uint [] {0x39, 0x29, }, 
			new uint [] {0x30, 0x3d, }, new uint [] {0x27, 0x3f, }, 
			new uint [] {0xffffffab, 0xffffffbb, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0x2b, 0x2a, }, 
			new uint [] {0xffffffb4, 0x60, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0xffffffe7, 0xffffffc7, }, new uint [] {0xffffffba, 0xffffffaa, }, 
			new uint [] {0x7e, 0x5e, }, new uint [] {0x7a, 0x5a, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3b, }, new uint [] {0x2e, 0x3a, }, 
			new uint [] {0x2d, 0x5f, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [21] = new KeyboardLayout (1046, "Brazilian ABNT-2 keyboard layout", 2, 6, new uint [][] {
			new uint [] {0x27, 0x22, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x40, }, new uint [] {0x33, 0x23, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0xffffffa8, }, new uint [] {0x37, 0x26, }, 
			new uint [] {0x38, 0x2a, }, new uint [] {0x39, 0x28, }, 
			new uint [] {0x30, 0x29, }, new uint [] {0x2d, 0x5f, }, 
			new uint [] {0x3d, 0x2b, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0xffffffb4, 0x60, }, 
			new uint [] {0x5b, 0x7b, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0xffffffe7, 0xffffffc7, }, new uint [] {0x7e, 0x5e, }, 
			new uint [] {0x5d, 0x7d, }, new uint [] {0x5c, 0x7c, }, 
			new uint [] {0x7a, 0x5a, }, new uint [] {0x78, 0x58, }, 
			new uint [] {0x63, 0x43, }, new uint [] {0x76, 0x56, }, 
			new uint [] {0x62, 0x42, }, new uint [] {0x6e, 0x4e, }, 
			new uint [] {0x6d, 0x4d, }, new uint [] {0x2c, 0x3c, }, 
			new uint [] {0x2e, 0x3e, }, new uint [] {0x3b, 0x3a, }, 
			new uint [] {0x2f, 0x3f, }, 		});
		table [22] = new KeyboardLayout (1046, "Brazilian ABNT-2 keyboard layout ALT GR", 2, 6, new uint [][] {
			new uint [] {0x27, 0x22, }, new uint [] {0x31, 0x21, 0x39, }, 
			new uint [] {0x32, 0x40, 0x32, }, new uint [] {0x33, 0x23, 0x33, }, 
			new uint [] {0x34, 0x24, 0x23, }, new uint [] {0x35, 0x25, 0x22, }, 
			new uint [] {0x36, 0x28, 0x2c, }, new uint [] {0x37, 0x26, }, 
			new uint [] {0x38, 0x2a, }, new uint [] {0x39, 0x28, }, 
			new uint [] {0x30, 0x29, }, new uint [] {0x2d, 0x5f, }, 
			new uint [] {0x3d, 0x2b, 0x27, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0x34, 0x60, }, 
			new uint [] {0x5b, 0x7b, 0x2a, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0x67, 0x47, }, new uint [] {0x7e, 0x5e, }, 
			new uint [] {0x5d, 0x7d, 0x3a, }, new uint [] {0x5c, 0x7c, }, 
			new uint [] {0x7a, 0x5a, }, new uint [] {0x78, 0x58, }, 
			new uint [] {0x63, 0x43, }, new uint [] {0x76, 0x56, }, 
			new uint [] {0x62, 0x42, }, new uint [] {0x6e, 0x4e, }, 
			new uint [] {0x6d, 0x4d, }, new uint [] {0x2c, 0x3c, }, 
			new uint [] {0x2e, 0x3e, }, new uint [] {0x3b, 0x3a, }, 
			new uint [] {0x2f, 0x3f, 0x30, }, 		});
		table [23] = new KeyboardLayout (1035, "Finnish keyboard layout", 0, 0, new uint [][] {
			new uint [] {0xffffffa7, 0xffffffbd, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x22, }, new uint [] {0x33, 0x23, }, 
			new uint [] {0x34, 0xffffffa4, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x26, }, new uint [] {0x37, 0x2f, }, 
			new uint [] {0x38, 0x28, }, new uint [] {0x39, 0x29, }, 
			new uint [] {0x30, 0x3d, }, new uint [] {0x2b, 0x3f, }, 
			new uint [] {0xffffffb4, 0x60, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0xffffffe5, 0xffffffc5, }, 
			new uint [] {0xffffffa8, 0x5e, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0xfffffff6, 0xffffffd6, }, new uint [] {0xffffffe4, 0xffffffc4, }, 
			new uint [] {0x27, 0x2a, }, new uint [] {0x7a, 0x5a, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3b, }, new uint [] {0x2e, 0x3a, }, 
			new uint [] {0x2d, 0x5f, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [24] = new KeyboardLayout (1026, "Bulgarian bds keyboard layout", 0, 0, new uint [][] {
			new uint [] {0x60, 0x7e, 0x28, 0x29, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x40, 0x32, 0x3f, }, new uint [] {0x33, 0x23, 0x33, 0x2b, }, 
			new uint [] {0x34, 0x24, 0x34, 0x22, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x5e, 0x36, 0x3d, }, new uint [] {0x37, 0x26, 0x37, 0x3a, }, 
			new uint [] {0x38, 0x2a, 0x38, 0x2f, }, new uint [] {0x39, 0x28, }, 
			new uint [] {0x30, 0x29, }, new uint [] {0x2d, 0x5f, 0x2d, 0x49, }, 
			new uint [] {0x3d, 0x2b, 0x2e, 0x56, }, new uint [] {0x71, 0x51, 0x2c, 0xfffffffb, }, 
			new uint [] {0x77, 0x57, 0xfffffff3, 0xffffffd3, }, new uint [] {0x65, 0x45, 0xffffffe5, 0xffffffc5, }, 
			new uint [] {0x72, 0x52, 0xffffffe8, 0xffffffc8, }, new uint [] {0x74, 0x54, 0xfffffff8, 0xffffffd8, }, 
			new uint [] {0x79, 0x59, 0xfffffff9, 0xffffffd9, }, new uint [] {0x75, 0x55, 0xffffffea, 0xffffffca, }, 
			new uint [] {0x69, 0x49, 0xfffffff1, 0xffffffd1, }, new uint [] {0x6f, 0x4f, 0xffffffe4, 0xffffffc4, }, 
			new uint [] {0x70, 0x50, 0xffffffe7, 0xffffffc7, }, new uint [] {0x5b, 0x7b, 0xfffffff6, 0xffffffd6, }, 
			new uint [] {0x5d, 0x7d, 0x3b, }, new uint [] {0x61, 0x41, 0xfffffffc, 0xffffffdc, }, 
			new uint [] {0x73, 0x53, 0xffffffff, 0xffffffdf, }, new uint [] {0x64, 0x44, 0xffffffe0, 0xffffffc0, }, 
			new uint [] {0x66, 0x46, 0xffffffee, 0xffffffce, }, new uint [] {0x67, 0x47, 0xffffffe6, 0xffffffc6, }, 
			new uint [] {0x68, 0x48, 0xffffffe3, 0xffffffc3, }, new uint [] {0x6a, 0x4a, 0xfffffff2, 0xffffffd2, }, 
			new uint [] {0x6b, 0x4b, 0xffffffed, 0xffffffcd, }, new uint [] {0x6c, 0x4c, 0xffffffe2, 0xffffffc2, }, 
			new uint [] {0x3b, 0x3a, 0xffffffec, 0xffffffcc, }, new uint [] {0x27, 0x22, 0xfffffff7, 0xffffffd7, }, 
			new uint [] {0x5c, 0x7c, 0x27, 0xffffffdb, }, new uint [] {0x7a, 0x5a, 0xfffffffe, 0xffffffde, }, 
			new uint [] {0x78, 0x58, 0xffffffe9, 0xffffffc9, }, new uint [] {0x63, 0x43, 0xfffffffa, 0xffffffda, }, 
			new uint [] {0x76, 0x56, 0xfffffffd, 0xffffffdd, }, new uint [] {0x62, 0x42, 0xfffffff4, 0xffffffd4, }, 
			new uint [] {0x6e, 0x4e, 0xfffffff5, 0xffffffd5, }, new uint [] {0x6d, 0x4d, 0xffffffef, 0xffffffcf, }, 
			new uint [] {0x2c, 0x3c, 0xfffffff0, 0xffffffd0, }, new uint [] {0x2e, 0x3e, 0xffffffeb, 0xffffffcb, }, 
			new uint [] {0x2f, 0x3f, 0xffffffe1, 0xffffffc1, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [25] = new KeyboardLayout (1026, "Bulgarian phonetic keyboard layout", 0, 0, new uint [][] {
			new uint [] {0x60, 0x7e, 0xfffffff7, 0xffffffd7, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x40, }, new uint [] {0x33, 0x23, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x5e, }, new uint [] {0x37, 0x26, }, 
			new uint [] {0x38, 0x2a, }, new uint [] {0x39, 0x28, }, 
			new uint [] {0x30, 0x29, }, new uint [] {0x2d, 0x5f, }, 
			new uint [] {0x3d, 0x2b, }, new uint [] {0x71, 0x51, 0xffffffff, 0xffffffdf, }, 
			new uint [] {0x77, 0x57, 0xffffffe2, 0xffffffc2, }, new uint [] {0x65, 0x45, 0xffffffe5, 0xffffffc5, }, 
			new uint [] {0x72, 0x52, 0xfffffff0, 0xffffffd0, }, new uint [] {0x74, 0x54, 0xfffffff2, 0xffffffd2, }, 
			new uint [] {0x79, 0x59, 0xfffffffa, 0xffffffda, }, new uint [] {0x75, 0x55, 0xfffffff3, 0xffffffd3, }, 
			new uint [] {0x69, 0x49, 0xffffffe8, 0xffffffc8, }, new uint [] {0x6f, 0x4f, 0xffffffee, 0xffffffce, }, 
			new uint [] {0x70, 0x50, 0xffffffef, 0xffffffcf, }, new uint [] {0x5b, 0x7b, 0xfffffff8, 0xffffffd8, }, 
			new uint [] {0x5d, 0x7d, 0xfffffff9, 0xffffffd9, }, new uint [] {0x61, 0x41, 0xffffffe0, 0xffffffc0, }, 
			new uint [] {0x73, 0x53, 0xfffffff1, 0xffffffd1, }, new uint [] {0x64, 0x44, 0xffffffe4, 0xffffffc4, }, 
			new uint [] {0x66, 0x46, 0xfffffff4, 0xffffffd4, }, new uint [] {0x67, 0x47, 0xffffffe3, 0xffffffc3, }, 
			new uint [] {0x68, 0x48, 0xfffffff5, 0xffffffd5, }, new uint [] {0x6a, 0x4a, 0xffffffe9, 0xffffffc9, }, 
			new uint [] {0x6b, 0x4b, 0xffffffea, 0xffffffca, }, new uint [] {0x6c, 0x4c, 0xffffffeb, 0xffffffcb, }, 
			new uint [] {0x3b, 0x3a, }, new uint [] {0x27, 0x22, }, 
			new uint [] {0x5c, 0x7c, 0xfffffffe, 0xffffffde, }, new uint [] {0x7a, 0x5a, 0xffffffe7, 0xffffffc7, }, 
			new uint [] {0x78, 0x58, 0xfffffffc, 0xffffffdc, }, new uint [] {0x63, 0x43, 0xfffffff6, 0xffffffd6, }, 
			new uint [] {0x76, 0x56, 0xffffffe6, 0xffffffc6, }, new uint [] {0x62, 0x42, 0xffffffe1, 0xffffffc1, }, 
			new uint [] {0x6e, 0x4e, 0xffffffed, 0xffffffcd, }, new uint [] {0x6d, 0x4d, 0xffffffec, 0xffffffcc, }, 
			new uint [] {0x2c, 0x3c, }, new uint [] {0x2e, 0x3e, }, 
			new uint [] {0x2f, 0x3f, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [26] = new KeyboardLayout (1059, "Belarusian keyboard layout", 0, 0, new uint [][] {
			new uint [] {0x60, 0x7e, 0xffffffa3, 0xffffffb3, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x40, }, new uint [] {0x33, 0x23, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x5e, }, new uint [] {0x37, 0x26, }, 
			new uint [] {0x38, 0x2a, }, new uint [] {0x39, 0x28, }, 
			new uint [] {0x30, 0x29, }, new uint [] {0x2d, 0x5f, }, 
			new uint [] {0x3d, 0x2b, }, new uint [] {0x71, 0x51, 0xffffffca, 0xffffffea, }, 
			new uint [] {0x77, 0x57, 0xffffffc3, 0xffffffe3, }, new uint [] {0x65, 0x45, 0xffffffd5, 0xfffffff5, }, 
			new uint [] {0x72, 0x52, 0xffffffcb, 0xffffffeb, }, new uint [] {0x74, 0x54, 0xffffffc5, 0xffffffe5, }, 
			new uint [] {0x79, 0x59, 0xffffffce, 0xffffffee, }, new uint [] {0x75, 0x55, 0xffffffc7, 0xffffffe7, }, 
			new uint [] {0x69, 0x49, 0xffffffdb, 0xfffffffb, }, new uint [] {0x6f, 0x4f, 0xffffffae, 0xffffffbe, }, 
			new uint [] {0x70, 0x50, 0xffffffda, 0xfffffffa, }, new uint [] {0x5b, 0x7b, 0xffffffc8, 0xffffffe8, }, 
			new uint [] {0x5d, 0x7d, 0x27, 0x27, }, new uint [] {0x61, 0x41, 0xffffffc6, 0xffffffe6, }, 
			new uint [] {0x73, 0x53, 0xffffffd9, 0xfffffff9, }, new uint [] {0x64, 0x44, 0xffffffd7, 0xfffffff7, }, 
			new uint [] {0x66, 0x46, 0xffffffc1, 0xffffffe1, }, new uint [] {0x67, 0x47, 0xffffffd0, 0xfffffff0, }, 
			new uint [] {0x68, 0x48, 0xffffffd2, 0xfffffff2, }, new uint [] {0x6a, 0x4a, 0xffffffcf, 0xffffffef, }, 
			new uint [] {0x6b, 0x4b, 0xffffffcc, 0xffffffec, }, new uint [] {0x6c, 0x4c, 0xffffffc4, 0xffffffe4, }, 
			new uint [] {0x3b, 0x3a, 0xffffffd6, 0xfffffff6, }, new uint [] {0x27, 0x22, 0xffffffdc, 0xfffffffc, }, 
			new uint [] {0x5c, 0x7c, 0x2f, 0x7c, }, new uint [] {0x7a, 0x5a, 0xffffffd1, 0xfffffff1, }, 
			new uint [] {0x78, 0x58, 0xffffffde, 0xfffffffe, }, new uint [] {0x63, 0x43, 0xffffffd3, 0xfffffff3, }, 
			new uint [] {0x76, 0x56, 0xffffffcd, 0xffffffed, }, new uint [] {0x62, 0x42, 0xffffffa6, 0xffffffb6, }, 
			new uint [] {0x6e, 0x4e, 0xffffffd4, 0xfffffff4, }, new uint [] {0x6d, 0x4d, 0xffffffd8, 0xfffffff8, }, 
			new uint [] {0x2c, 0x3c, 0xffffffc2, 0xffffffe2, }, new uint [] {0x2e, 0x3e, 0xffffffc0, 0xffffffe0, }, 
			new uint [] {0x2f, 0x3f, 0x2e, 0x2c, }, new uint [] {0x3c, 0x3e, 0x7c, 0xffffffa6, }, 
			new uint [] {}, 		});
		table [27] = new KeyboardLayout (1049, "Russian keyboard layout", 0, 0, new uint [][] {
			new uint [] {0x60, 0x7e, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x40, }, new uint [] {0x33, 0x23, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x5e, }, new uint [] {0x37, 0x26, }, 
			new uint [] {0x38, 0x2a, }, new uint [] {0x39, 0x28, }, 
			new uint [] {0x30, 0x29, }, new uint [] {0x2d, 0x5f, }, 
			new uint [] {0x3d, 0x2b, }, new uint [] {0x71, 0x51, 0xffffffca, 0xffffffea, }, 
			new uint [] {0x77, 0x57, 0xffffffc3, 0xffffffe3, }, new uint [] {0x65, 0x45, 0xffffffd5, 0xfffffff5, }, 
			new uint [] {0x72, 0x52, 0xffffffcb, 0xffffffeb, }, new uint [] {0x74, 0x54, 0xffffffc5, 0xffffffe5, }, 
			new uint [] {0x79, 0x59, 0xffffffce, 0xffffffee, }, new uint [] {0x75, 0x55, 0xffffffc7, 0xffffffe7, }, 
			new uint [] {0x69, 0x49, 0xffffffdb, 0xfffffffb, }, new uint [] {0x6f, 0x4f, 0xffffffdd, 0xfffffffd, }, 
			new uint [] {0x70, 0x50, 0xffffffda, 0xfffffffa, }, new uint [] {0x5b, 0x7b, 0xffffffc8, 0xffffffe8, }, 
			new uint [] {0x5d, 0x7d, 0xffffffdf, 0xffffffff, }, new uint [] {0x61, 0x41, 0xffffffc6, 0xffffffe6, }, 
			new uint [] {0x73, 0x53, 0xffffffd9, 0xfffffff9, }, new uint [] {0x64, 0x44, 0xffffffd7, 0xfffffff7, }, 
			new uint [] {0x66, 0x46, 0xffffffc1, 0xffffffe1, }, new uint [] {0x67, 0x47, 0xffffffd0, 0xfffffff0, }, 
			new uint [] {0x68, 0x48, 0xffffffd2, 0xfffffff2, }, new uint [] {0x6a, 0x4a, 0xffffffcf, 0xffffffef, }, 
			new uint [] {0x6b, 0x4b, 0xffffffcc, 0xffffffec, }, new uint [] {0x6c, 0x4c, 0xffffffc4, 0xffffffe4, }, 
			new uint [] {0x3b, 0x3a, 0xffffffd6, 0xfffffff6, }, new uint [] {0x27, 0x22, 0xffffffdc, 0xfffffffc, }, 
			new uint [] {0x5c, 0x7c, }, new uint [] {0x7a, 0x5a, 0xffffffd1, 0xfffffff1, }, 
			new uint [] {0x78, 0x58, 0xffffffde, 0xfffffffe, }, new uint [] {0x63, 0x43, 0xffffffd3, 0xfffffff3, }, 
			new uint [] {0x76, 0x56, 0xffffffcd, 0xffffffed, }, new uint [] {0x62, 0x42, 0xffffffc9, 0xffffffe9, }, 
			new uint [] {0x6e, 0x4e, 0xffffffd4, 0xfffffff4, }, new uint [] {0x6d, 0x4d, 0xffffffd8, 0xfffffff8, }, 
			new uint [] {0x2c, 0x3c, 0xffffffc2, 0xffffffe2, }, new uint [] {0x2e, 0x3e, 0xffffffc0, 0xffffffe0, }, 
			new uint [] {0x2f, 0x3f, }, new uint [] {}, 
			new uint [] {}, 		});
		table [28] = new KeyboardLayout (1049, "Russian keyboard layout (phantom key version)", 0, 0, new uint [][] {
			new uint [] {0x60, 0x7e, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x40, }, new uint [] {0x33, 0x23, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x5e, }, new uint [] {0x37, 0x26, }, 
			new uint [] {0x38, 0x2a, }, new uint [] {0x39, 0x28, }, 
			new uint [] {0x30, 0x29, }, new uint [] {0x2d, 0x5f, }, 
			new uint [] {0x3d, 0x2b, }, new uint [] {0x71, 0x51, 0xffffffca, 0xffffffea, }, 
			new uint [] {0x77, 0x57, 0xffffffc3, 0xffffffe3, }, new uint [] {0x65, 0x45, 0xffffffd5, 0xfffffff5, }, 
			new uint [] {0x72, 0x52, 0xffffffcb, 0xffffffeb, }, new uint [] {0x74, 0x54, 0xffffffc5, 0xffffffe5, }, 
			new uint [] {0x79, 0x59, 0xffffffce, 0xffffffee, }, new uint [] {0x75, 0x55, 0xffffffc7, 0xffffffe7, }, 
			new uint [] {0x69, 0x49, 0xffffffdb, 0xfffffffb, }, new uint [] {0x6f, 0x4f, 0xffffffdd, 0xfffffffd, }, 
			new uint [] {0x70, 0x50, 0xffffffda, 0xfffffffa, }, new uint [] {0x5b, 0x7b, 0xffffffc8, 0xffffffe8, }, 
			new uint [] {0x5d, 0x7d, 0xffffffdf, 0xffffffff, }, new uint [] {0x61, 0x41, 0xffffffc6, 0xffffffe6, }, 
			new uint [] {0x73, 0x53, 0xffffffd9, 0xfffffff9, }, new uint [] {0x64, 0x44, 0xffffffd7, 0xfffffff7, }, 
			new uint [] {0x66, 0x46, 0xffffffc1, 0xffffffe1, }, new uint [] {0x67, 0x47, 0xffffffd0, 0xfffffff0, }, 
			new uint [] {0x68, 0x48, 0xffffffd2, 0xfffffff2, }, new uint [] {0x6a, 0x4a, 0xffffffcf, 0xffffffef, }, 
			new uint [] {0x6b, 0x4b, 0xffffffcc, 0xffffffec, }, new uint [] {0x6c, 0x4c, 0xffffffc4, 0xffffffe4, }, 
			new uint [] {0x3b, 0x3a, 0xffffffd6, 0xfffffff6, }, new uint [] {0x27, 0x22, 0xffffffdc, 0xfffffffc, }, 
			new uint [] {0x5c, 0x7c, }, new uint [] {0x7a, 0x5a, 0xffffffd1, 0xfffffff1, }, 
			new uint [] {0x78, 0x58, 0xffffffde, 0xfffffffe, }, new uint [] {0x63, 0x43, 0xffffffd3, 0xfffffff3, }, 
			new uint [] {0x76, 0x56, 0xffffffcd, 0xffffffed, }, new uint [] {0x62, 0x42, 0xffffffc9, 0xffffffe9, }, 
			new uint [] {0x6e, 0x4e, 0xffffffd4, 0xfffffff4, }, new uint [] {0x6d, 0x4d, 0xffffffd8, 0xfffffff8, }, 
			new uint [] {0x2c, 0x3c, 0xffffffc2, 0xffffffe2, }, new uint [] {0x2e, 0x3e, 0xffffffc0, 0xffffffe0, }, 
			new uint [] {0x2f, 0x3f, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [29] = new KeyboardLayout (1049, "Russian keyboard layout KOI8-R", 0, 0, new uint [][] {
			new uint [] {0x28, 0x29, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x22, }, new uint [] {0x33, 0x2f, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x3a, }, 
			new uint [] {0x36, 0x2c, }, new uint [] {0x37, 0x2e, }, 
			new uint [] {0x38, 0x3b, }, new uint [] {0x39, 0x3f, }, 
			new uint [] {0x30, 0x25, }, new uint [] {0x2d, 0x5f, }, 
			new uint [] {0x3d, 0x2b, }, new uint [] {0xffffffca, 0xffffffea, }, 
			new uint [] {0xffffffc3, 0xffffffe3, }, new uint [] {0xffffffd5, 0xfffffff5, }, 
			new uint [] {0xffffffcb, 0xffffffeb, }, new uint [] {0xffffffc5, 0xffffffe5, }, 
			new uint [] {0xffffffce, 0xffffffee, }, new uint [] {0xffffffc7, 0xffffffe7, }, 
			new uint [] {0xffffffdb, 0xfffffffb, }, new uint [] {0xffffffdd, 0xfffffffd, }, 
			new uint [] {0xffffffda, 0xfffffffa, }, new uint [] {0xffffffc8, 0xffffffe8, }, 
			new uint [] {0xffffffdf, 0xffffffff, }, new uint [] {0xffffffc6, 0xffffffe6, }, 
			new uint [] {0xffffffd9, 0xfffffff9, }, new uint [] {0xffffffd7, 0xfffffff7, }, 
			new uint [] {0xffffffc1, 0xffffffe1, }, new uint [] {0xffffffd0, 0xfffffff0, }, 
			new uint [] {0xffffffd2, 0xfffffff2, }, new uint [] {0xffffffcf, 0xffffffef, }, 
			new uint [] {0xffffffcc, 0xffffffec, }, new uint [] {0xffffffc4, 0xffffffe4, }, 
			new uint [] {0xffffffd6, 0xfffffff6, }, new uint [] {0xffffffdc, 0xfffffffc, }, 
			new uint [] {0x5c, 0x7c, }, new uint [] {0xffffffd1, 0xfffffff1, }, 
			new uint [] {0xffffffde, 0xfffffffe, }, new uint [] {0xffffffd3, 0xfffffff3, }, 
			new uint [] {0xffffffcd, 0xffffffed, }, new uint [] {0xffffffc9, 0xffffffe9, }, 
			new uint [] {0xffffffd4, 0xfffffff4, }, new uint [] {0xffffffd8, 0xfffffff8, }, 
			new uint [] {0xffffffc2, 0xffffffe2, }, new uint [] {0xffffffc0, 0xffffffe0, }, 
			new uint [] {0x2f, 0x3f, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [30] = new KeyboardLayout (1049, "Russian keyboard layout cp1251", 0, 0, new uint [][] {
			new uint [] {0x60, 0x7e, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x40, }, new uint [] {0x33, 0x23, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x5e, }, new uint [] {0x37, 0x26, }, 
			new uint [] {0x38, 0x2a, }, new uint [] {0x39, 0x28, }, 
			new uint [] {0x30, 0x29, }, new uint [] {0x2d, 0x5f, }, 
			new uint [] {0x3d, 0x2b, }, new uint [] {0x71, 0x51, 0xffffffe9, 0xffffffc9, }, 
			new uint [] {0x77, 0x57, 0xfffffff6, 0xffffffd6, }, new uint [] {0x65, 0x45, 0xfffffff3, 0xffffffd3, }, 
			new uint [] {0x72, 0x52, 0xffffffea, 0xffffffca, }, new uint [] {0x74, 0x54, 0xffffffe5, 0xffffffc5, }, 
			new uint [] {0x79, 0x59, 0xffffffed, 0xffffffcd, }, new uint [] {0x75, 0x55, 0xffffffe3, 0xffffffc3, }, 
			new uint [] {0x69, 0x49, 0xfffffff8, 0xffffffd8, }, new uint [] {0x6f, 0x4f, 0xfffffff9, 0xffffffd9, }, 
			new uint [] {0x70, 0x50, 0xffffffe7, 0xffffffc7, }, new uint [] {0x5b, 0x7b, 0xfffffff5, 0xffffffd5, }, 
			new uint [] {0x5d, 0x7d, 0xfffffffa, 0xffffffda, }, new uint [] {0x61, 0x41, 0xfffffff4, 0xffffffd4, }, 
			new uint [] {0x73, 0x53, 0xfffffffb, 0xffffffdb, }, new uint [] {0x64, 0x44, 0xffffffe2, 0xffffffc2, }, 
			new uint [] {0x66, 0x46, 0xffffffe0, 0xffffffc0, }, new uint [] {0x67, 0x47, 0xffffffef, 0xffffffcf, }, 
			new uint [] {0x68, 0x48, 0xfffffff0, 0xffffffd0, }, new uint [] {0x6a, 0x4a, 0xffffffee, 0xffffffce, }, 
			new uint [] {0x6b, 0x4b, 0xffffffeb, 0xffffffcb, }, new uint [] {0x6c, 0x4c, 0xffffffe4, 0xffffffc4, }, 
			new uint [] {0x3b, 0x3a, 0xffffffe6, 0xffffffc6, }, new uint [] {0x27, 0x22, 0xfffffffd, 0xffffffdd, }, 
			new uint [] {0x5c, 0x7c, }, new uint [] {0x7a, 0x5a, 0xffffffff, 0xffffffdf, }, 
			new uint [] {0x78, 0x58, 0xfffffff7, 0xffffffd7, }, new uint [] {0x63, 0x43, 0xfffffff1, 0xffffffd1, }, 
			new uint [] {0x76, 0x56, 0xffffffec, 0xffffffcc, }, new uint [] {0x62, 0x42, 0xffffffe8, 0xffffffc8, }, 
			new uint [] {0x6e, 0x4e, 0xfffffff2, 0xffffffd2, }, new uint [] {0x6d, 0x4d, 0xfffffffc, 0xffffffdc, }, 
			new uint [] {0x2c, 0x3c, 0xffffffe1, 0xffffffc1, }, new uint [] {0x2e, 0x3e, 0xfffffffe, 0xffffffde, }, 
			new uint [] {0x2f, 0x3f, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [31] = new KeyboardLayout (1049, "Russian phonetic keyboard layout", 0, 0, new uint [][] {
			new uint [] {0x60, 0x7e, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x40, }, new uint [] {0x33, 0x23, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x5e, }, new uint [] {0x37, 0x26, }, 
			new uint [] {0x38, 0x2a, }, new uint [] {0x39, 0x28, }, 
			new uint [] {0x30, 0x29, }, new uint [] {0x2d, 0x5f, }, 
			new uint [] {0x3d, 0x2b, }, new uint [] {0x71, 0x51, 0xffffffd1, 0xfffffff1, }, 
			new uint [] {0x77, 0x57, 0xffffffd7, 0xfffffff7, }, new uint [] {0x65, 0x45, 0xffffffc5, 0xffffffe5, }, 
			new uint [] {0x72, 0x52, 0xffffffd2, 0xfffffff2, }, new uint [] {0x74, 0x54, 0xffffffd4, 0xfffffff4, }, 
			new uint [] {0x79, 0x59, 0xffffffd9, 0xfffffff9, }, new uint [] {0x75, 0x55, 0xffffffd5, 0xfffffff5, }, 
			new uint [] {0x69, 0x49, 0xffffffc9, 0xffffffe9, }, new uint [] {0x6f, 0x4f, 0xffffffcf, 0xffffffef, }, 
			new uint [] {0x70, 0x50, 0xffffffd0, 0xfffffff0, }, new uint [] {0x5b, 0x7b, 0xffffffdb, 0xfffffffb, }, 
			new uint [] {0x5d, 0x7d, 0xffffffdd, 0xfffffffd, }, new uint [] {0x61, 0x41, 0xffffffc1, 0xffffffe1, }, 
			new uint [] {0x73, 0x53, 0xffffffd3, 0xfffffff3, }, new uint [] {0x64, 0x44, 0xffffffc4, 0xffffffe4, }, 
			new uint [] {0x66, 0x46, 0xffffffc6, 0xffffffe6, }, new uint [] {0x67, 0x47, 0xffffffc7, 0xffffffe7, }, 
			new uint [] {0x68, 0x48, 0xffffffc8, 0xffffffe8, }, new uint [] {0x6a, 0x4a, 0xffffffca, 0xffffffea, }, 
			new uint [] {0x6b, 0x4b, 0xffffffcb, 0xffffffeb, }, new uint [] {0x6c, 0x4c, 0xffffffcc, 0xffffffec, }, 
			new uint [] {0x3b, 0x3a, }, new uint [] {0x27, 0x22, }, 
			new uint [] {0x5c, 0x7c, }, new uint [] {0x7a, 0x5a, 0xffffffda, 0xfffffffa, }, 
			new uint [] {0x78, 0x58, 0xffffffd8, 0xfffffff8, }, new uint [] {0x63, 0x43, 0xffffffc3, 0xffffffe3, }, 
			new uint [] {0x76, 0x56, 0xffffffd6, 0xfffffff6, }, new uint [] {0x62, 0x42, 0xffffffc2, 0xffffffe2, }, 
			new uint [] {0x6e, 0x4e, 0xffffffce, 0xffffffee, }, new uint [] {0x6d, 0x4d, 0xffffffcd, 0xffffffed, }, 
			new uint [] {0x2c, 0x3c, }, new uint [] {0x2e, 0x3e, }, 
			new uint [] {0x2f, 0x3f, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [32] = new KeyboardLayout (1058, "Ukrainian keyboard layout KOI8-U", 0, 0, new uint [][] {
			new uint [] {0x60, 0x7e, 0xffffffad, 0xffffffbd, }, new uint [] {0x31, 0x21, 0x31, 0x21, }, 
			new uint [] {0x32, 0x40, 0x32, 0x22, }, new uint [] {0x33, 0x23, 0x33, 0x27, }, 
			new uint [] {0x34, 0x24, 0x34, 0x2a, }, new uint [] {0x35, 0x25, 0x35, 0x3a, }, 
			new uint [] {0x36, 0x5e, 0x36, 0x2c, }, new uint [] {0x37, 0x26, 0x37, 0x2e, }, 
			new uint [] {0x38, 0x2a, 0x38, 0x3b, }, new uint [] {0x39, 0x28, 0x39, 0x28, }, 
			new uint [] {0x30, 0x29, 0x30, 0x29, }, new uint [] {0x2d, 0x5f, 0x2d, 0x5f, }, 
			new uint [] {0x3d, 0x2b, 0x3d, 0x2b, }, new uint [] {0x71, 0x51, 0xffffffca, 0xffffffea, }, 
			new uint [] {0x77, 0x57, 0xffffffc3, 0xffffffe3, }, new uint [] {0x65, 0x45, 0xffffffd5, 0xfffffff5, }, 
			new uint [] {0x72, 0x52, 0xffffffcb, 0xffffffeb, }, new uint [] {0x74, 0x54, 0xffffffc5, 0xffffffe5, }, 
			new uint [] {0x79, 0x59, 0xffffffce, 0xffffffee, }, new uint [] {0x75, 0x55, 0xffffffc7, 0xffffffe7, }, 
			new uint [] {0x69, 0x49, 0xffffffdb, 0xfffffffb, }, new uint [] {0x6f, 0x4f, 0xffffffdd, 0xfffffffd, }, 
			new uint [] {0x70, 0x50, 0xffffffda, 0xfffffffa, }, new uint [] {0x5b, 0x7b, 0xffffffc8, 0xffffffe8, }, 
			new uint [] {0x5d, 0x7d, 0xffffffa7, 0xffffffb7, }, new uint [] {0x61, 0x41, 0xffffffc6, 0xffffffe6, }, 
			new uint [] {0x73, 0x53, 0xffffffa6, 0xffffffb6, }, new uint [] {0x64, 0x44, 0xffffffd7, 0xfffffff7, }, 
			new uint [] {0x66, 0x46, 0xffffffc1, 0xffffffe1, }, new uint [] {0x67, 0x47, 0xffffffd0, 0xfffffff0, }, 
			new uint [] {0x68, 0x48, 0xffffffd2, 0xfffffff2, }, new uint [] {0x6a, 0x4a, 0xffffffcf, 0xffffffef, }, 
			new uint [] {0x6b, 0x4b, 0xffffffcc, 0xffffffec, }, new uint [] {0x6c, 0x4c, 0xffffffc4, 0xffffffe4, }, 
			new uint [] {0x3b, 0x3a, 0xffffffd6, 0xfffffff6, }, new uint [] {0x27, 0x22, 0xffffffa4, 0xffffffb4, }, 
			new uint [] {0x5c, 0x7c, 0x5c, 0x7c, }, new uint [] {0x7a, 0x5a, 0xffffffd1, 0xfffffff1, }, 
			new uint [] {0x78, 0x58, 0xffffffde, 0xfffffffe, }, new uint [] {0x63, 0x43, 0xffffffd3, 0xfffffff3, }, 
			new uint [] {0x76, 0x56, 0xffffffcd, 0xffffffed, }, new uint [] {0x62, 0x42, 0xffffffc9, 0xffffffe9, }, 
			new uint [] {0x6e, 0x4e, 0xffffffd4, 0xfffffff4, }, new uint [] {0x6d, 0x4d, 0xffffffd8, 0xfffffff8, }, 
			new uint [] {0x2c, 0x3c, 0xffffffc2, 0xffffffe2, }, new uint [] {0x2e, 0x3e, 0xffffffc0, 0xffffffe0, }, 
			new uint [] {0x2f, 0x3f, 0x2f, 0x3f, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [33] = new KeyboardLayout (1058, "Ukrainian keyboard layout (standard)", 0, 0, new uint [][] {
			new uint [] {0xffffffad, 0xffffffbd, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x22, }, new uint [] {0x33, 0x27, }, 
			new uint [] {0x34, 0x3b, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x3a, }, new uint [] {0x37, 0x3f, }, 
			new uint [] {0x38, 0x2a, }, new uint [] {0x39, 0x28, }, 
			new uint [] {0x30, 0x29, }, new uint [] {0x2d, 0x5f, }, 
			new uint [] {0x3d, 0x2b, }, new uint [] {0xffffffca, 0xffffffea, }, 
			new uint [] {0xffffffc3, 0xffffffe3, }, new uint [] {0xffffffd5, 0xfffffff5, }, 
			new uint [] {0xffffffcb, 0xffffffeb, }, new uint [] {0xffffffc5, 0xffffffe5, }, 
			new uint [] {0xffffffce, 0xffffffee, }, new uint [] {0xffffffc7, 0xffffffe7, }, 
			new uint [] {0xffffffdb, 0xfffffffb, }, new uint [] {0xffffffdd, 0xfffffffd, }, 
			new uint [] {0xffffffda, 0xfffffffa, }, new uint [] {0xffffffc8, 0xffffffe8, }, 
			new uint [] {0xffffffa7, 0xffffffb7, }, new uint [] {0xffffffc6, 0xffffffe6, }, 
			new uint [] {0xffffffa6, 0xffffffb6, }, new uint [] {0xffffffd7, 0xfffffff7, }, 
			new uint [] {0xffffffc1, 0xffffffe1, }, new uint [] {0xffffffd0, 0xfffffff0, }, 
			new uint [] {0xffffffd2, 0xfffffff2, }, new uint [] {0xffffffcf, 0xffffffef, }, 
			new uint [] {0xffffffcc, 0xffffffec, }, new uint [] {0xffffffc4, 0xffffffe4, }, 
			new uint [] {0xffffffd6, 0xfffffff6, }, new uint [] {0xffffffa4, 0xffffffb4, }, 
			new uint [] {0x5c, 0x2f, }, new uint [] {0xffffffd1, 0xfffffff1, }, 
			new uint [] {0xffffffde, 0xfffffffe, }, new uint [] {0xffffffd3, 0xfffffff3, }, 
			new uint [] {0xffffffcd, 0xffffffed, }, new uint [] {0xffffffc9, 0xffffffe9, }, 
			new uint [] {0xffffffd4, 0xfffffff4, }, new uint [] {0xffffffd8, 0xfffffff8, }, 
			new uint [] {0xffffffc2, 0xffffffe2, }, new uint [] {0xffffffc0, 0xffffffe0, }, 
			new uint [] {0x2e, 0x2c, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [34] = new KeyboardLayout (1049, "Russian keyboard layout (standard)", 0, 0, new uint [][] {
			new uint [] {0xffffffa3, 0xffffffb3, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x22, }, new uint [] {0x33, 0x27, }, 
			new uint [] {0x34, 0x3b, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x3a, }, new uint [] {0x37, 0x3f, }, 
			new uint [] {0x38, 0x2a, }, new uint [] {0x39, 0x28, }, 
			new uint [] {0x30, 0x29, }, new uint [] {0x2d, 0x5f, }, 
			new uint [] {0x3d, 0x2b, }, new uint [] {0xffffffca, 0xffffffea, }, 
			new uint [] {0xffffffc3, 0xffffffe3, }, new uint [] {0xffffffd5, 0xfffffff5, }, 
			new uint [] {0xffffffcb, 0xffffffeb, }, new uint [] {0xffffffc5, 0xffffffe5, }, 
			new uint [] {0xffffffce, 0xffffffee, }, new uint [] {0xffffffc7, 0xffffffe7, }, 
			new uint [] {0xffffffdb, 0xfffffffb, }, new uint [] {0xffffffdd, 0xfffffffd, }, 
			new uint [] {0xffffffda, 0xfffffffa, }, new uint [] {0xffffffc8, 0xffffffe8, }, 
			new uint [] {0xffffffdf, 0xffffffff, }, new uint [] {0xffffffc6, 0xffffffe6, }, 
			new uint [] {0xffffffd9, 0xfffffff9, }, new uint [] {0xffffffd7, 0xfffffff7, }, 
			new uint [] {0xffffffc1, 0xffffffe1, }, new uint [] {0xffffffd0, 0xfffffff0, }, 
			new uint [] {0xffffffd2, 0xfffffff2, }, new uint [] {0xffffffcf, 0xffffffef, }, 
			new uint [] {0xffffffcc, 0xffffffec, }, new uint [] {0xffffffc4, 0xffffffe4, }, 
			new uint [] {0xffffffd6, 0xfffffff6, }, new uint [] {0xffffffdc, 0xfffffffc, }, 
			new uint [] {0x5c, 0x2f, }, new uint [] {0xffffffd1, 0xfffffff1, }, 
			new uint [] {0xffffffde, 0xfffffffe, }, new uint [] {0xffffffd3, 0xfffffff3, }, 
			new uint [] {0xffffffcd, 0xffffffed, }, new uint [] {0xffffffc9, 0xffffffe9, }, 
			new uint [] {0xffffffd4, 0xfffffff4, }, new uint [] {0xffffffd8, 0xfffffff8, }, 
			new uint [] {0xffffffc2, 0xffffffe2, }, new uint [] {0xffffffc0, 0xffffffe0, }, 
			new uint [] {0x2e, 0x2c, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [35] = new KeyboardLayout (1034, "Spanish keyboard layout", 0, 0, new uint [][] {
			new uint [] {0xffffffba, 0xffffffaa, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x22, }, new uint [] {0x33, 0xffffffb7, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x26, }, new uint [] {0x37, 0x2f, }, 
			new uint [] {0x38, 0x28, }, new uint [] {0x39, 0x29, }, 
			new uint [] {0x30, 0x3d, }, new uint [] {0x27, 0x3f, }, 
			new uint [] {0xffffffa1, 0xffffffbf, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0x60, 0x5e, }, 
			new uint [] {0x2b, 0x2a, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0xfffffff1, 0xffffffd1, }, new uint [] {0xffffffb4, 0xffffffa8, }, 
			new uint [] {0xffffffe7, 0xffffffc7, }, new uint [] {0x7a, 0x5a, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3b, }, new uint [] {0x2e, 0x3a, }, 
			new uint [] {0x2d, 0x5f, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [36] = new KeyboardLayout (1040, "Italian keyboard layout", 0, 0, new uint [][] {
			new uint [] {0x5c, 0x7c, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x22, }, new uint [] {0x33, 0xffffffa3, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x26, }, new uint [] {0x37, 0x2f, }, 
			new uint [] {0x38, 0x28, }, new uint [] {0x39, 0x29, }, 
			new uint [] {0x30, 0x3d, }, new uint [] {0x27, 0x3f, }, 
			new uint [] {0xffffffec, 0x5e, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0xffffffe8, 0xffffffe9, }, 
			new uint [] {0x2b, 0x2a, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0xfffffff2, 0xffffffe7, }, new uint [] {0xffffffe0, 0xffffffb0, }, 
			new uint [] {0xfffffff9, 0xffffffa7, }, new uint [] {0x7a, 0x5a, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3b, }, new uint [] {0x2e, 0x3a, }, 
			new uint [] {0x2d, 0x5f, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [37] = new KeyboardLayout (1039, "Icelandic keyboard layout", 0, 0, new uint [][] {
			new uint [] {0xffffffb0, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x22, }, new uint [] {0x33, 0x23, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x26, }, new uint [] {0x37, 0x2f, }, 
			new uint [] {0x38, 0x28, }, new uint [] {0x39, 0x29, }, 
			new uint [] {0x30, 0x3d, }, new uint [] {0xfffffff6, 0xffffffd6, }, 
			new uint [] {0x2d, 0x5f, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0xfffffff0, 0xffffffd0, }, 
			new uint [] {0x27, 0x3f, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0xffffffe6, 0xffffffc6, }, new uint [] {0xffffffb4, 0xffffffc4, }, 
			new uint [] {0x2b, 0x2a, }, new uint [] {0x7a, 0x5a, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3b, }, new uint [] {0x2e, 0x3a, }, 
			new uint [] {0xfffffffe, 0xffffffde, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [38] = new KeyboardLayout (1038, "Hungarian keyboard layout", 0, 1, new uint [][] {
			new uint [] {0x30, 0xffffffa7, }, new uint [] {0x31, 0x27, 0x7e, }, 
			new uint [] {0x32, 0x22, 0xffffffb7, }, new uint [] {0x33, 0x2b, 0x5e, }, 
			new uint [] {0x34, 0x21, 0xffffffa2, }, new uint [] {0x35, 0x25, 0x30, 0xffffffb0, }, 
			new uint [] {0x36, 0x2f, 0xffffffb2, }, new uint [] {0x37, 0x3d, 0x60, }, 
			new uint [] {0x38, 0x28, 0xffffffff, }, new uint [] {0x39, 0x29, 0xffffffb4, }, 
			new uint [] {0xfffffff6, 0xffffffd6, 0xffffffbd, }, new uint [] {0xfffffffc, 0xffffffdc, 0xffffffa8, }, 
			new uint [] {0xfffffff3, 0xffffffd3, 0xffffffb8, }, new uint [] {0x71, 0x51, 0x5c, }, 
			new uint [] {0x77, 0x57, 0x7c, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x7a, 0x5a, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, 0xffffffcd, }, new uint [] {0x6f, 0x4f, 0xfffffff8, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0xfffffff5, 0xffffffd5, 0xfffffff7, }, 
			new uint [] {0xfffffffa, 0xffffffda, 0xffffffd7, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, 0xfffffff0, }, new uint [] {0x64, 0x44, 0xffffffd0, }, 
			new uint [] {0x66, 0x46, 0x5b, }, new uint [] {0x67, 0x47, 0x5d, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, 0xffffffed, }, 
			new uint [] {0x6b, 0x4b, 0xffffffb3, }, new uint [] {0x6c, 0x4c, 0xffffffa3, }, 
			new uint [] {0xffffffe9, 0xffffffc9, 0x24, }, new uint [] {0xffffffe1, 0xffffffc1, 0xffffffdf, }, 
			new uint [] {0xfffffffb, 0xffffffdb, 0xffffffa4, }, new uint [] {0x79, 0x59, 0x3e, }, 
			new uint [] {0x78, 0x58, 0x23, }, new uint [] {0x63, 0x43, 0x26, }, 
			new uint [] {0x76, 0x56, 0x40, }, new uint [] {0x62, 0x42, 0x7b, }, 
			new uint [] {0x6e, 0x4e, 0x7d, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3f, 0x3b, }, new uint [] {0x2e, 0x3a, 0x3e, }, 
			new uint [] {0x2d, 0x5f, 0x2a, }, new uint [] {0xffffffed, 0xffffffcd, 0x3c, }, 
			new uint [] {}, 		});
		table [39] = new KeyboardLayout (1045, "Polish (programmer's) keyboard layout", 0, 0, new uint [][] {
			new uint [] {0x60, 0x7e, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x40, }, new uint [] {0x33, 0x23, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x5e, }, new uint [] {0x37, 0x26, 0xffffffa7, }, 
			new uint [] {0x38, 0x2a, }, new uint [] {0x39, 0x28, }, 
			new uint [] {0x30, 0x29, }, new uint [] {0x2d, 0x5f, }, 
			new uint [] {0x3d, 0x2b, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, 0xffffffea, 0xffffffca, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, 0xfffffff3, 0xffffffd3, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0x5b, 0x7b, }, 
			new uint [] {0x5d, 0x7d, }, new uint [] {0x61, 0x41, 0xffffffb1, 0xffffffa1, }, 
			new uint [] {0x73, 0x53, 0xffffffb6, 0xffffffa6, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, 0xffffffb3, 0xffffffa3, }, 
			new uint [] {0x3b, 0x3a, }, new uint [] {0x27, 0x22, }, 
			new uint [] {0x5c, 0x7c, }, new uint [] {0x7a, 0x5a, 0xffffffbf, 0xffffffaf, }, 
			new uint [] {0x78, 0x58, 0xffffffbc, 0xffffffac, }, new uint [] {0x63, 0x43, 0xffffffe6, 0xffffffc6, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, 0xfffffff1, 0xffffffd1, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3c, }, new uint [] {0x2e, 0x3e, }, 
			new uint [] {0x2f, 0x3f, }, new uint [] {0x3c, 0x3e, 0x7c, }, 
			new uint [] {}, 		});
		table [40] = new KeyboardLayout (1060, "Slovenian keyboard layout", 0, 1, new uint [][] {
			new uint [] {0xffffffb8, 0xffffffa8, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x22, }, new uint [] {0x33, 0x23, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x26, }, new uint [] {0x37, 0x2f, }, 
			new uint [] {0x38, 0x28, }, new uint [] {0x39, 0x29, }, 
			new uint [] {0x30, 0x3d, }, new uint [] {0x27, 0x3f, }, 
			new uint [] {0x2b, 0x2a, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x7a, 0x5a, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0xffffffb9, 0xffffffa9, }, 
			new uint [] {0xfffffff0, 0xffffffd0, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0xffffffe8, 0xffffffc8, }, new uint [] {0xffffffe6, 0xffffffc6, }, 
			new uint [] {0xffffffbe, 0xffffffae, }, new uint [] {0x79, 0x59, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3b, }, new uint [] {0x2e, 0x3a, }, 
			new uint [] {0x2d, 0x5f, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [41] = new KeyboardLayout (3098, "Serbian keyboard layout sr", 0, 0, new uint [][] {
			new uint [] {0x60, 0x7e, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x22, }, new uint [] {0x33, 0x23, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x26, }, new uint [] {0x37, 0x2f, }, 
			new uint [] {0x38, 0x28, }, new uint [] {0x39, 0x29, }, 
			new uint [] {0x30, 0x3d, }, new uint [] {0x27, 0x3f, }, 
			new uint [] {0x2b, 0x2a, }, new uint [] {0xffffffa9, 0xffffffb9, }, 
			new uint [] {0xffffffaa, 0xffffffba, }, new uint [] {0xffffffc5, 0xffffffe5, }, 
			new uint [] {0xffffffd2, 0xfffffff2, }, new uint [] {0xffffffd4, 0xfffffff4, }, 
			new uint [] {0xffffffda, 0xfffffffa, }, new uint [] {0xffffffd5, 0xfffffff5, }, 
			new uint [] {0xffffffc9, 0xffffffe9, }, new uint [] {0xffffffcf, 0xffffffef, }, 
			new uint [] {0xffffffd0, 0xfffffff0, }, new uint [] {0xffffffdb, 0xfffffffb, }, 
			new uint [] {0x5b, 0x5d, }, new uint [] {0xffffffc1, 0xffffffe1, }, 
			new uint [] {0xffffffd3, 0xfffffff3, }, new uint [] {0xffffffc4, 0xffffffe4, }, 
			new uint [] {0xffffffc6, 0xffffffe6, }, new uint [] {0xffffffc7, 0xffffffe7, }, 
			new uint [] {0xffffffc8, 0xffffffe8, }, new uint [] {0xffffffa8, 0xffffffb8, }, 
			new uint [] {0xffffffcb, 0xffffffeb, }, new uint [] {0xffffffcc, 0xffffffec, }, 
			new uint [] {0xffffffde, 0xfffffffe, }, new uint [] {0xffffffab, 0xffffffbb, }, 
			new uint [] {0x2d, 0x5f, }, new uint [] {0xffffffa1, 0xffffffb1, }, 
			new uint [] {0xffffffaf, 0xffffffbf, }, new uint [] {0xffffffc3, 0xffffffe3, }, 
			new uint [] {0xffffffd7, 0xfffffff7, }, new uint [] {0xffffffc2, 0xffffffe2, }, 
			new uint [] {0xffffffce, 0xffffffee, }, new uint [] {0xffffffcd, 0xffffffed, }, 
			new uint [] {0x2c, 0x3b, }, new uint [] {0x2e, 0x3a, }, 
			new uint [] {0xffffffd6, 0xfffffff6, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [42] = new KeyboardLayout (3098, "Serbian keyboard layout us,sr", 0, 0, new uint [][] {
			new uint [] {0x60, 0x7e, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x40, 0x32, 0x22, }, new uint [] {0x33, 0x23, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x5e, 0x36, 0x26, }, new uint [] {0x37, 0x26, 0x37, 0x2f, }, 
			new uint [] {0x38, 0x2a, 0x38, 0x28, }, new uint [] {0x39, 0x28, 0x39, 0x29, }, 
			new uint [] {0x30, 0x29, 0x30, 0x3d, }, new uint [] {0x2d, 0x5f, 0x27, 0x3f, }, 
			new uint [] {0x3d, 0x2b, 0x2b, 0x2a, }, new uint [] {0x71, 0x51, 0xffffffa9, 0xffffffb9, }, 
			new uint [] {0x77, 0x57, 0xffffffaa, 0xffffffba, }, new uint [] {0x65, 0x45, 0xffffffc5, 0xffffffe5, }, 
			new uint [] {0x72, 0x52, 0xffffffd2, 0xfffffff2, }, new uint [] {0x74, 0x54, 0xffffffd4, 0xfffffff4, }, 
			new uint [] {0x79, 0x59, 0xffffffda, 0xfffffffa, }, new uint [] {0x75, 0x55, 0xffffffd5, 0xfffffff5, }, 
			new uint [] {0x69, 0x49, 0xffffffc9, 0xffffffe9, }, new uint [] {0x6f, 0x4f, 0xffffffcf, 0xffffffef, }, 
			new uint [] {0x70, 0x50, 0xffffffd0, 0xfffffff0, }, new uint [] {0x5b, 0x7b, 0xffffffdb, 0xfffffffb, }, 
			new uint [] {0x5d, 0x7d, 0x5b, 0x5d, }, new uint [] {0x61, 0x41, 0xffffffc1, 0xffffffe1, }, 
			new uint [] {0x73, 0x53, 0xffffffd3, 0xfffffff3, }, new uint [] {0x64, 0x44, 0xffffffc4, 0xffffffe4, }, 
			new uint [] {0x66, 0x46, 0xffffffc6, 0xffffffe6, }, new uint [] {0x67, 0x47, 0xffffffc7, 0xffffffe7, }, 
			new uint [] {0x68, 0x48, 0xffffffc8, 0xffffffe8, }, new uint [] {0x6a, 0x4a, 0xffffffa8, 0xffffffb8, }, 
			new uint [] {0x6b, 0x4b, 0xffffffcb, 0xffffffeb, }, new uint [] {0x6c, 0x4c, 0xffffffcc, 0xffffffec, }, 
			new uint [] {0x3b, 0x3a, 0xffffffde, 0xfffffffe, }, new uint [] {0x27, 0x22, 0xffffffab, 0xffffffbb, }, 
			new uint [] {0x5c, 0x7c, 0x2d, 0x5f, }, new uint [] {0x7a, 0x5a, 0xffffffa1, 0xffffffb1, }, 
			new uint [] {0x78, 0x58, 0xffffffaf, 0xffffffbf, }, new uint [] {0x63, 0x43, 0xffffffc3, 0xffffffe3, }, 
			new uint [] {0x76, 0x56, 0xffffffd7, 0xfffffff7, }, new uint [] {0x62, 0x42, 0xffffffc2, 0xffffffe2, }, 
			new uint [] {0x6e, 0x4e, 0xffffffce, 0xffffffee, }, new uint [] {0x6d, 0x4d, 0xffffffcd, 0xffffffed, }, 
			new uint [] {0x2c, 0x3c, 0x2c, 0x3b, }, new uint [] {0x2e, 0x3e, 0x2e, 0x3a, }, 
			new uint [] {0x2f, 0x3f, 0xffffffd6, 0xfffffff6, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [43] = new KeyboardLayout (1050, "Croatian keyboard layout", 0, 1, new uint [][] {
			new uint [] {0xffffffb8, 0xffffffa8, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x22, }, new uint [] {0x33, 0x23, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x26, }, new uint [] {0x37, 0x2f, }, 
			new uint [] {0x38, 0x28, }, new uint [] {0x39, 0x29, }, 
			new uint [] {0x30, 0x3d, }, new uint [] {0x27, 0x3f, }, 
			new uint [] {0x2b, 0x2a, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x7a, 0x5a, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0xffffffb9, 0xffffffa9, }, 
			new uint [] {0xfffffff0, 0xffffffd0, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0xffffffe8, 0xffffffc8, }, new uint [] {0xffffffe6, 0xffffffc6, }, 
			new uint [] {0xffffffbe, 0xffffffae, }, new uint [] {0x79, 0x59, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3b, }, new uint [] {0x2e, 0x3a, }, 
			new uint [] {0x2f, 0x3f, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [44] = new KeyboardLayout (1050, "Croatian keyboard layout (specific)", 0, 0, new uint [][] {
			new uint [] {0x60, 0x7e, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x40, }, new uint [] {0x33, 0x23, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x5e, }, new uint [] {0x37, 0x26, }, 
			new uint [] {0x38, 0x2a, }, new uint [] {0x39, 0x28, }, 
			new uint [] {0x30, 0x29, }, new uint [] {0x2d, 0x5f, }, 
			new uint [] {0x3d, 0x2b, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0x5b, 0x7b, 0xffffffb9, 0xffffffa9, }, 
			new uint [] {0x5d, 0x7d, 0xfffffff0, 0xffffffd0, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0x3b, 0x3a, 0xffffffe8, 0xffffffc8, }, new uint [] {0x27, 0x22, 0xffffffe6, 0xffffffc6, }, 
			new uint [] {0x5c, 0x7c, 0xffffffbe, 0xffffffae, }, new uint [] {0x7a, 0x5a, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3c, }, new uint [] {0x2e, 0x3e, }, 
			new uint [] {0x2f, 0x3f, }, new uint [] {0x3c, 0x3e, 0x7c, }, 
			new uint [] {}, 		});
		table [45] = new KeyboardLayout (1041, "Japanese 106 keyboard layout", 3, 7, new uint [][] {
			new uint [] {0x31, 0x21, }, new uint [] {0x32, 0x22, }, 
			new uint [] {0x33, 0x23, }, new uint [] {0x34, 0x24, }, 
			new uint [] {0x35, 0x25, }, new uint [] {0x36, 0x26, }, 
			new uint [] {0x37, 0x27, }, new uint [] {0x38, 0x28, }, 
			new uint [] {0x39, 0x29, }, new uint [] {0x30, 0x7e, }, 
			new uint [] {0x2d, 0x3d, }, new uint [] {0x5e, 0x7e, }, 
			new uint [] {0x5c, 0x7c, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0x40, 0x60, }, 
			new uint [] {0x5b, 0x7b, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0x3b, 0x2b, }, new uint [] {0x3a, 0x2a, }, 
			new uint [] {0x5d, 0x7d, }, new uint [] {0x7a, 0x5a, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3c, }, new uint [] {0x2e, 0x3e, }, 
			new uint [] {0x2f, 0x3f, }, new uint [] {0x5c, 0x5f, }, 
			new uint [] {}, 		});
		table [46] = new KeyboardLayout (1041, "Japanese pc98x1 keyboard layout", 0, 0, new uint [][] {
			new uint [] {0x31, 0x21, }, new uint [] {0x32, 0x22, }, 
			new uint [] {0x33, 0x23, }, new uint [] {0x34, 0x24, }, 
			new uint [] {0x35, 0x25, }, new uint [] {0x36, 0x26, }, 
			new uint [] {0x37, 0x27, }, new uint [] {0x38, 0x28, }, 
			new uint [] {0x39, 0x29, }, new uint [] {0x30, }, 
			new uint [] {0x2d, 0x3d, }, new uint [] {0x5e, 0x60, }, 
			new uint [] {0x5c, 0x7c, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0x40, 0x7e, }, 
			new uint [] {0x5b, 0x7b, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0x3b, 0x2b, }, new uint [] {0x3a, 0x2a, }, 
			new uint [] {0x5d, 0x7d, }, new uint [] {0x7a, 0x5a, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3c, }, new uint [] {0x2e, 0x3e, }, 
			new uint [] {0x2f, 0x3f, }, new uint [] {0x5c, 0x5f, }, 
			new uint [] {}, 		});
		table [47] = new KeyboardLayout (1051, "Slovak keyboard layout", 0, 0, new uint [][] {
			new uint [] {0x3b, 0x30, }, new uint [] {0x2b, 0x31, }, 
			new uint [] {0xffffffb5, 0x32, }, new uint [] {0xffffffb9, 0x33, }, 
			new uint [] {0xffffffe8, 0x34, }, new uint [] {0xffffffbb, 0x35, }, 
			new uint [] {0xffffffbe, 0x36, }, new uint [] {0xfffffffd, 0x37, }, 
			new uint [] {0xffffffe1, 0x38, }, new uint [] {0xffffffed, 0x39, }, 
			new uint [] {0xffffffe9, 0x30, }, new uint [] {0x3d, 0x25, }, 
			new uint [] {0x27, 0x76, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0xfffffffa, 0x2f, }, 
			new uint [] {0xffffffe4, 0x28, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0xfffffff4, 0x22, }, new uint [] {0xffffffa7, 0x21, }, 
			new uint [] {0xfffffff2, 0x29, }, new uint [] {0x7a, 0x5a, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3f, }, new uint [] {0x2e, 0x3a, }, 
			new uint [] {0x2d, 0x5f, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [48] = new KeyboardLayout (1051, "Slovak and Czech keyboard layout without dead keys", 0, 0, new uint [][] {
			new uint [] {0x60, 0x7e, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x40, }, new uint [] {0x33, 0x23, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x5e, }, new uint [] {0x37, 0x26, }, 
			new uint [] {0x38, 0x2a, }, new uint [] {0x39, 0x28, }, 
			new uint [] {0x30, 0x29, }, new uint [] {0x2d, 0x5f, }, 
			new uint [] {0x3d, 0x2b, }, new uint [] {0x71, 0x51, 0xffffffe4, 0xffffffc4, }, 
			new uint [] {0x77, 0x57, 0xffffffec, 0xffffffcc, }, new uint [] {0x65, 0x45, 0xffffffe9, 0xffffffc9, }, 
			new uint [] {0x72, 0x52, 0xfffffff8, 0xffffffd8, }, new uint [] {0x74, 0x54, 0xffffffbb, 0xffffffab, }, 
			new uint [] {0x79, 0x59, 0xfffffffd, 0xffffffdd, }, new uint [] {0x75, 0x55, 0xfffffff9, 0xffffffd9, }, 
			new uint [] {0x69, 0x49, 0xffffffed, 0xffffffcd, }, new uint [] {0x6f, 0x4f, 0xfffffff3, 0xffffffd3, }, 
			new uint [] {0x70, 0x50, 0xfffffff6, 0xffffffd6, }, new uint [] {0x5b, 0x7b, }, 
			new uint [] {0x5d, 0x7d, }, new uint [] {0x61, 0x41, 0xffffffe1, 0xffffffc1, }, 
			new uint [] {0x73, 0x53, 0xffffffb9, 0xffffffa9, }, new uint [] {0x64, 0x44, 0xffffffef, 0xffffffcf, }, 
			new uint [] {0x66, 0x46, 0xffffffeb, 0xffffffcb, }, new uint [] {0x67, 0x47, 0xffffffe0, 0xffffffc0, }, 
			new uint [] {0x68, 0x48, 0xfffffffa, 0xffffffda, }, new uint [] {0x6a, 0x4a, 0xfffffffc, 0xffffffdc, }, 
			new uint [] {0x6b, 0x4b, 0xfffffff4, 0xffffffd4, }, new uint [] {0x6c, 0x4c, 0xffffffb5, 0xffffffa5, }, 
			new uint [] {0x3b, 0x3a, }, new uint [] {0x27, 0x22, }, 
			new uint [] {0x5c, 0x7c, }, new uint [] {0x7a, 0x5a, 0xffffffbe, 0xffffffae, }, 
			new uint [] {0x78, 0x58, 0xffffffa4, }, new uint [] {0x63, 0x43, 0xffffffe8, 0xffffffc8, }, 
			new uint [] {0x76, 0x56, 0xffffffe7, 0xffffffc7, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, 0xfffffff2, 0xffffffd2, }, new uint [] {0x6d, 0x4d, 0xffffffe5, 0xffffffc5, }, 
			new uint [] {0x2c, 0x3c, }, new uint [] {0x2e, 0x3e, }, 
			new uint [] {0x2f, 0x3f, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [49] = new KeyboardLayout (1029, "Czech keyboard layout", 0, 0, new uint [][] {
			new uint [] {0x3b, }, new uint [] {0x2b, 0x31, }, 
			new uint [] {0xffffffec, 0x32, }, new uint [] {0xffffffb9, 0x33, }, 
			new uint [] {0xffffffe8, 0x34, }, new uint [] {0xfffffff8, 0x35, }, 
			new uint [] {0xffffffbe, 0x36, }, new uint [] {0xfffffffd, 0x37, }, 
			new uint [] {0xffffffe1, 0x38, }, new uint [] {0xffffffed, 0x39, }, 
			new uint [] {0xffffffe9, 0x30, 0xffffffbd, 0x29, }, new uint [] {0x3d, 0x25, }, 
			new uint [] {}, new uint [] {0x71, 0x51, 0x5c, }, 
			new uint [] {0x77, 0x57, 0x7c, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0xfffffffa, 0x2f, 0x5b, 0x7b, }, 
			new uint [] {0x29, 0x28, 0x5d, 0x7d, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, 0xfffffff0, }, new uint [] {0x64, 0x44, 0xffffffd0, }, 
			new uint [] {0x66, 0x46, 0x5b, }, new uint [] {0x67, 0x47, 0x5d, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, 0xffffffb3, }, new uint [] {0x6c, 0x4c, 0xffffffa3, }, 
			new uint [] {0xfffffff9, 0x22, 0x24, }, new uint [] {0xffffffa7, 0x21, 0xffffffdf, }, 
			new uint [] {0xffffffa8, 0x27, }, new uint [] {0x7a, 0x5a, 0x3e, }, 
			new uint [] {0x78, 0x58, 0x23, }, new uint [] {0x63, 0x43, 0x26, }, 
			new uint [] {0x76, 0x56, 0x40, }, new uint [] {0x62, 0x42, 0x7b, }, 
			new uint [] {0x6e, 0x4e, 0x7d, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3f, 0x3c, }, new uint [] {0x2e, 0x3a, 0x3e, }, 
			new uint [] {0x2d, 0x5f, 0x2a, }, new uint [] {0x3c, 0x3e, 0x5c, 0x7c, }, 
			new uint [] {}, 		});
		table [50] = new KeyboardLayout (1029, "Czech keyboard layout cz", 0, 1, new uint [][] {
			new uint [] {0x3b, }, new uint [] {0x2b, 0x31, }, 
			new uint [] {0xffffffec, 0x32, }, new uint [] {0xffffffb9, 0x33, }, 
			new uint [] {0xffffffe8, 0x34, }, new uint [] {0xfffffff8, 0x35, }, 
			new uint [] {0xffffffbe, 0x36, }, new uint [] {0xfffffffd, 0x37, }, 
			new uint [] {0xffffffe1, 0x38, }, new uint [] {0xffffffed, 0x39, }, 
			new uint [] {0xffffffe9, 0x30, }, new uint [] {0x3d, 0x25, }, 
			new uint [] {0xffffffb4, 0xffffffb7, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x7a, 0x5a, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0xfffffffa, 0x2f, }, 
			new uint [] {0x29, 0x28, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0xfffffff9, 0x22, }, new uint [] {0xffffffa7, 0x21, }, 
			new uint [] {0xffffffa8, 0x27, }, new uint [] {0x79, 0x59, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3f, }, new uint [] {0x2e, 0x3a, }, 
			new uint [] {0x2d, 0x5f, }, new uint [] {0x5c, }, 
			new uint [] {}, 		});
		table [51] = new KeyboardLayout (1029, "Czech keyboard layout cz_qwerty", 0, 0, new uint [][] {
			new uint [] {0x3b, }, new uint [] {0x2b, 0x31, }, 
			new uint [] {0xffffffec, 0x32, }, new uint [] {0xffffffb9, 0x33, }, 
			new uint [] {0xffffffe8, 0x34, }, new uint [] {0xfffffff8, 0x35, }, 
			new uint [] {0xffffffbe, 0x36, }, new uint [] {0xfffffffd, 0x37, }, 
			new uint [] {0xffffffe1, 0x38, }, new uint [] {0xffffffed, 0x39, }, 
			new uint [] {0xffffffe9, 0x30, }, new uint [] {0x3d, 0x25, }, 
			new uint [] {0xffffffb4, 0xffffffb7, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0xfffffffa, 0x2f, }, 
			new uint [] {0x29, 0x28, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0xfffffff9, 0x22, }, new uint [] {0xffffffa7, 0x21, }, 
			new uint [] {0xffffffa8, 0x27, }, new uint [] {0x7a, 0x5a, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3f, }, new uint [] {0x2e, 0x3a, }, 
			new uint [] {0x2d, 0x5f, }, new uint [] {0x5c, }, 
			new uint [] {}, 		});
		table [52] = new KeyboardLayout (1034, "Latin American keyboard layout", 0, 0, new uint [][] {
			new uint [] {0x7c, 0xffffffb0, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x22, }, new uint [] {0x33, 0x23, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x26, }, new uint [] {0x37, 0x2f, }, 
			new uint [] {0x38, 0x28, }, new uint [] {0x39, 0x29, }, 
			new uint [] {0x30, 0x3d, }, new uint [] {0x27, 0x3f, }, 
			new uint [] {0xffffffbf, 0xffffffa1, }, new uint [] {0x71, 0x51, 0x40, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0xffffffb4, 0xffffffa8, }, 
			new uint [] {0x2b, 0x2a, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0xfffffff1, 0xffffffd1, }, new uint [] {0x7b, 0x5b, 0x5e, }, 
			new uint [] {0x7d, 0x5d, }, new uint [] {0x7a, 0x5a, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3b, }, new uint [] {0x2e, 0x3a, }, 
			new uint [] {0x2d, 0x5f, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [53] = new KeyboardLayout (1063, "Lithuanian (Baltic) keyboard layout", 0, 0, new uint [][] {
			new uint [] {0x60, 0x7e, }, new uint [] {0xffffffe0, 0xffffffc0, }, 
			new uint [] {0xffffffe8, 0xffffffc8, }, new uint [] {0xffffffe6, 0xffffffc6, }, 
			new uint [] {0xffffffeb, 0xffffffcb, }, new uint [] {0xffffffe1, 0xffffffc1, }, 
			new uint [] {0xfffffff0, 0xffffffd0, }, new uint [] {0xfffffff8, 0xffffffd8, }, 
			new uint [] {0xfffffffb, 0xffffffdb, }, new uint [] {0xffffffa5, 0x28, }, 
			new uint [] {0xffffffb4, 0x29, }, new uint [] {0x2d, 0x5f, }, 
			new uint [] {0xfffffffe, 0xffffffde, }, new uint [] {0x5c, 0x7c, }, 
			new uint [] {0x71, 0x51, }, new uint [] {0x77, 0x57, }, 
			new uint [] {0x65, 0x45, }, new uint [] {0x72, 0x52, }, 
			new uint [] {0x74, 0x54, }, new uint [] {0x79, 0x59, }, 
			new uint [] {0x75, 0x55, }, new uint [] {0x69, 0x49, }, 
			new uint [] {0x6f, 0x4f, }, new uint [] {0x70, 0x50, }, 
			new uint [] {0x5b, 0x7b, }, new uint [] {0x5d, 0x7d, }, 
			new uint [] {0x61, 0x41, }, new uint [] {0x73, 0x53, }, 
			new uint [] {0x64, 0x44, }, new uint [] {0x66, 0x46, }, 
			new uint [] {0x67, 0x47, }, new uint [] {0x68, 0x48, }, 
			new uint [] {0x6a, 0x4a, }, new uint [] {0x6b, 0x4b, }, 
			new uint [] {0x6c, 0x4c, }, new uint [] {0x3b, 0x3a, }, 
			new uint [] {0x27, 0x22, }, new uint [] {0x7a, 0x5a, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3c, }, new uint [] {0x2e, 0x3e, }, 
			new uint [] {0x2f, 0x3f, }, new uint [] {}, 
			new uint [] {}, 		});
		table [54] = new KeyboardLayout (1055, "Turkish keyboard layout", 0, 0, new uint [][] {
			new uint [] {0x22, 0xffffffe9, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x27, }, new uint [] {0x33, 0x5e, 0x23, }, 
			new uint [] {0x34, 0x2b, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x26, }, new uint [] {0x37, 0x2f, 0x7b, }, 
			new uint [] {0x38, 0x28, 0x5b, }, new uint [] {0x39, 0x29, 0x5d, }, 
			new uint [] {0x30, 0x3d, 0x7d, }, new uint [] {0x2a, 0x3f, 0x5c, }, 
			new uint [] {0x2d, 0x5f, }, new uint [] {0x71, 0x51, 0x40, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0xfffffffd, 0x49, 0xffffffee, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0xfffffff0, 0xffffffd0, }, 
			new uint [] {0xfffffffc, 0xffffffdc, 0x7e, }, new uint [] {0x61, 0x41, 0xffffffe6, }, 
			new uint [] {0x73, 0x53, 0xffffffdf, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0xfffffffe, 0xffffffde, }, new uint [] {0x69, 0xffffffdd, }, 
			new uint [] {0x2c, 0x3b, 0x60, }, new uint [] {0x7a, 0x5a, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0xfffffff6, 0xffffffd6, }, new uint [] {0xffffffe7, 0xffffffc7, }, 
			new uint [] {0x2e, 0x3a, }, new uint [] {}, 
			new uint [] {}, 		});
		table [55] = new KeyboardLayout (1055, "Turkish keyboard layout tr", 0, 0, new uint [][] {
			new uint [] {0x22, 0x5c, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x27, }, new uint [] {0x33, 0x5e, }, 
			new uint [] {0x34, 0x2b, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x26, }, new uint [] {0x37, 0x2f, }, 
			new uint [] {0x38, 0x28, }, new uint [] {0x39, 0x29, }, 
			new uint [] {0x30, 0x3d, }, new uint [] {0x2a, 0x3f, }, 
			new uint [] {0x2d, 0x5f, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0xffffffb9, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0xffffffbb, 0xffffffab, }, 
			new uint [] {0xfffffffc, 0xffffffdc, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0xffffffba, 0xffffffaa, }, new uint [] {0x69, }, 
			new uint [] {0x2c, 0x3b, }, new uint [] {0x7a, 0x5a, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0xfffffff6, 0xffffffd6, }, new uint [] {0xffffffe7, 0xffffffc7, }, 
			new uint [] {0x2e, 0x3a, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [56] = new KeyboardLayout (1055, "Turkish keyboard layout trf", 0, 0, new uint [][] {
			new uint [] {0x2b, 0x2a, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x22, }, new uint [] {0x33, 0x5e, 0x23, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x26, }, new uint [] {0x37, 0x27, }, 
			new uint [] {0x38, 0x28, }, new uint [] {0x39, 0x29, }, 
			new uint [] {0x30, 0x3d, }, new uint [] {0x2f, 0x3f, }, 
			new uint [] {0x2d, 0x5f, }, new uint [] {0x66, 0x46, }, 
			new uint [] {0x67, 0x47, }, new uint [] {0xffffffbb, 0xffffffab, }, 
			new uint [] {0xffffffb9, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x64, 0x44, }, new uint [] {0x72, 0x52, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x68, 0x48, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x61, 0x41, }, new uint [] {0xfffffffc, 0xffffffdc, }, 
			new uint [] {0x74, 0x54, }, new uint [] {0x6b, 0x4b, }, 
			new uint [] {0x6d, 0x4d, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0xffffffba, 0xffffffaa, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0xfffffff6, 0xffffffd6, }, new uint [] {0x76, 0x56, }, 
			new uint [] {0x63, 0x43, }, new uint [] {0xffffffe7, 0xffffffc7, }, 
			new uint [] {0x7a, 0x5a, }, new uint [] {0x73, 0x53, }, 
			new uint [] {0x62, 0x42, }, new uint [] {0x2e, 0x3a, }, 
			new uint [] {0x2c, 0x3b, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [57] = new KeyboardLayout (1037, "Israelian keyboard layout", 0, 0, new uint [][] {
			new uint [] {0x60, 0x7e, 0x3b, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x40, }, new uint [] {0x33, 0x23, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x5e, }, new uint [] {0x37, 0x26, }, 
			new uint [] {0x38, 0x2a, }, new uint [] {0x39, 0x28, }, 
			new uint [] {0x30, 0x29, }, new uint [] {0x2d, 0x5f, }, 
			new uint [] {0x3d, 0x2b, }, new uint [] {0x71, 0x51, 0x2f, }, 
			new uint [] {0x77, 0x57, 0x27, }, new uint [] {0x65, 0x45, 0xfffffff7, }, 
			new uint [] {0x72, 0x52, 0xfffffff8, }, new uint [] {0x74, 0x54, 0xffffffe0, }, 
			new uint [] {0x79, 0x59, 0xffffffe8, }, new uint [] {0x75, 0x55, 0xffffffe5, }, 
			new uint [] {0x69, 0x49, 0xffffffef, }, new uint [] {0x6f, 0x4f, 0xffffffed, }, 
			new uint [] {0x70, 0x50, 0xfffffff4, }, new uint [] {0x5b, 0x7b, }, 
			new uint [] {0x5d, 0x7d, }, new uint [] {0x61, 0x41, 0xfffffff9, }, 
			new uint [] {0x73, 0x53, 0xffffffe3, }, new uint [] {0x64, 0x44, 0xffffffe2, }, 
			new uint [] {0x66, 0x46, 0xffffffeb, }, new uint [] {0x67, 0x47, 0xfffffff2, }, 
			new uint [] {0x68, 0x48, 0xffffffe9, }, new uint [] {0x6a, 0x4a, 0xffffffe7, }, 
			new uint [] {0x6b, 0x4b, 0xffffffec, }, new uint [] {0x6c, 0x4c, 0xffffffea, }, 
			new uint [] {0x3b, 0x3a, 0xfffffff3, }, new uint [] {0x27, 0x22, 0x2c, }, 
			new uint [] {0x5c, 0x7c, }, new uint [] {0x7a, 0x5a, 0xffffffe6, }, 
			new uint [] {0x78, 0x58, 0xfffffff1, }, new uint [] {0x63, 0x43, 0xffffffe1, }, 
			new uint [] {0x76, 0x56, 0xffffffe4, }, new uint [] {0x62, 0x42, 0xfffffff0, }, 
			new uint [] {0x6e, 0x4e, 0xffffffee, }, new uint [] {0x6d, 0x4d, 0xfffffff6, }, 
			new uint [] {0x2c, 0x3c, 0xfffffffa, }, new uint [] {0x2e, 0x3e, 0xfffffff5, }, 
			new uint [] {0x2f, 0x3f, 0x2e, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [58] = new KeyboardLayout (1037, "Israelian phonetic keyboard layout", 0, 0, new uint [][] {
			new uint [] {0x60, 0x7e, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x40, }, new uint [] {0x33, 0x23, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x5e, }, new uint [] {0x37, 0x26, }, 
			new uint [] {0x38, 0x2a, }, new uint [] {0x39, 0x28, }, 
			new uint [] {0x30, 0x29, }, new uint [] {0x2d, 0x5f, }, 
			new uint [] {0x3d, 0x2b, }, new uint [] {0x71, 0x51, 0xfffffff7, }, 
			new uint [] {0x77, 0x57, 0xffffffe5, }, new uint [] {0x65, 0x45, 0xffffffe0, }, 
			new uint [] {0x72, 0x52, 0xfffffff8, }, new uint [] {0x74, 0x54, 0xfffffffa, }, 
			new uint [] {0x79, 0x59, 0xfffffff2, }, new uint [] {0x75, 0x55, 0xffffffe5, }, 
			new uint [] {0x69, 0x49, 0xffffffe9, }, new uint [] {0x6f, 0x4f, 0xfffffff1, }, 
			new uint [] {0x70, 0x50, 0xfffffff4, }, new uint [] {0x5b, 0x7b, }, 
			new uint [] {0x5d, 0x7d, }, new uint [] {0x61, 0x41, 0xffffffe0, }, 
			new uint [] {0x73, 0x53, 0xfffffff9, }, new uint [] {0x64, 0x44, 0xffffffe3, }, 
			new uint [] {0x66, 0x46, 0xfffffff4, }, new uint [] {0x67, 0x47, 0xffffffe2, }, 
			new uint [] {0x68, 0x48, 0xffffffe4, }, new uint [] {0x6a, 0x4a, 0xffffffe9, }, 
			new uint [] {0x6b, 0x4b, 0xffffffeb, }, new uint [] {0x6c, 0x4c, 0xffffffec, }, 
			new uint [] {0x3b, 0x3a, }, new uint [] {0x27, 0x22, }, 
			new uint [] {0x5c, 0x7c, }, new uint [] {0x7a, 0x5a, 0xffffffe6, }, 
			new uint [] {0x78, 0x58, 0xffffffe7, }, new uint [] {0x63, 0x43, 0xfffffff6, }, 
			new uint [] {0x76, 0x56, 0xffffffe5, }, new uint [] {0x62, 0x42, 0xffffffe1, }, 
			new uint [] {0x6e, 0x4e, 0xfffffff0, }, new uint [] {0x6d, 0x4d, 0xffffffee, }, 
			new uint [] {0x2c, 0x3c, }, new uint [] {0x2e, 0x3e, }, 
			new uint [] {0x2f, 0x3f, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [59] = new KeyboardLayout (1037, "Israelian Saharon keyboard layout", 0, 0, new uint [][] {
			new uint [] {0x60, 0x7e, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x40, }, new uint [] {0x33, 0x23, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x5e, }, new uint [] {0x37, 0x26, }, 
			new uint [] {0x38, 0x2a, }, new uint [] {0x39, 0x28, }, 
			new uint [] {0x30, 0x29, }, new uint [] {0x2d, 0x5f, }, 
			new uint [] {0x3d, 0x2b, }, new uint [] {0x71, 0x51, 0xfffffff7, }, 
			new uint [] {0x77, 0x57, 0xfffffff1, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, 0xfffffff8, }, new uint [] {0x74, 0x54, 0xffffffe8, }, 
			new uint [] {0x79, 0x59, 0xffffffe3, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, 0xfffffff4, }, new uint [] {0x5b, 0x7b, }, 
			new uint [] {0x5d, 0x7d, }, new uint [] {0x61, 0x41, 0xffffffe0, }, 
			new uint [] {0x73, 0x53, 0xffffffe5, }, new uint [] {0x64, 0x44, 0xffffffec, }, 
			new uint [] {0x66, 0x46, 0xfffffffa, }, new uint [] {0x67, 0x47, 0xffffffe2, }, 
			new uint [] {0x68, 0x48, 0xffffffe4, }, new uint [] {0x6a, 0x4a, 0xfffffff9, }, 
			new uint [] {0x6b, 0x4b, 0xffffffeb, }, new uint [] {0x6c, 0x4c, 0xffffffe9, }, 
			new uint [] {0x3b, 0x3a, }, new uint [] {0x27, 0x22, }, 
			new uint [] {0x5c, 0x7c, }, new uint [] {0x7a, 0x5a, 0xffffffe6, }, 
			new uint [] {0x78, 0x58, 0xffffffe7, }, new uint [] {0x63, 0x43, 0xfffffff6, }, 
			new uint [] {0x76, 0x56, 0xfffffff2, }, new uint [] {0x62, 0x42, 0xffffffe1, }, 
			new uint [] {0x6e, 0x4e, 0xfffffff0, }, new uint [] {0x6d, 0x4d, 0xffffffee, }, 
			new uint [] {0x2c, 0x3c, }, new uint [] {0x2e, 0x3e, }, 
			new uint [] {0x2f, 0x3f, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [60] = new KeyboardLayout (1033, "VNC keyboard layout", 4, 8, new uint [][] {
			new uint [] {0x31, 0x21, }, new uint [] {0x32, 0x40, }, 
			new uint [] {0x33, 0x23, }, new uint [] {0x34, 0x24, }, 
			new uint [] {0x35, 0x25, }, new uint [] {0x36, 0x5e, }, 
			new uint [] {0x37, 0x26, }, new uint [] {0x38, 0x2a, }, 
			new uint [] {0x39, 0x28, }, new uint [] {0x30, 0x29, }, 
			new uint [] {0x2d, 0x5f, }, new uint [] {0x3d, 0x2b, }, 
			new uint [] {0x5b, 0x7b, }, new uint [] {0x5d, 0x7d, }, 
			new uint [] {0x3b, 0x3a, }, new uint [] {0x27, 0x22, }, 
			new uint [] {0x60, 0x7e, }, new uint [] {0x2c, 0x3c, }, 
			new uint [] {0x2e, 0x3e, }, new uint [] {0x2f, 0x3f, }, 
			new uint [] {0x5c, 0x7c, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x62, 0x42, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x64, 0x44, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x69, 0x49, }, 
			new uint [] {0x6a, 0x4a, }, new uint [] {0x6b, 0x4b, }, 
			new uint [] {0x6c, 0x4c, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x73, 0x53, }, 
			new uint [] {0x74, 0x54, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x77, 0x57, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x79, 0x59, }, 
			new uint [] {0x7a, 0x5a, }, new uint [] {}, 
			new uint [] {}, 		});
		table [61] = new KeyboardLayout (1032, "Greek keyboard layout", 0, 0, new uint [][] {
			new uint [] {0x60, 0x7e, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x40, }, new uint [] {0x33, 0x23, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x5e, }, new uint [] {0x37, 0x26, }, 
			new uint [] {0x38, 0x2a, }, new uint [] {0x39, 0x28, }, 
			new uint [] {0x30, 0x29, }, new uint [] {0x2d, 0x5f, }, 
			new uint [] {0x3d, 0x2b, }, new uint [] {0x71, 0x51, 0x3b, 0x3a, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, 0xffffffe5, 0xffffffc5, }, 
			new uint [] {0x72, 0x52, 0xfffffff1, 0xffffffd1, }, new uint [] {0x74, 0x54, 0xfffffff4, 0xffffffd4, }, 
			new uint [] {0x79, 0x59, 0xfffffff5, 0xffffffd5, }, new uint [] {0x75, 0x55, 0xffffffe8, 0xffffffc8, }, 
			new uint [] {0x69, 0x49, 0xffffffe9, 0xffffffc9, }, new uint [] {0x6f, 0x4f, 0xffffffef, 0xffffffcf, }, 
			new uint [] {0x70, 0x50, 0xfffffff0, 0xffffffd0, }, new uint [] {0x5b, 0x7b, }, 
			new uint [] {0x5d, 0x7d, }, new uint [] {0x61, 0x41, 0xffffffe1, 0xffffffc1, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, 0xffffffe4, 0xffffffc4, }, 
			new uint [] {0x66, 0x46, 0xfffffff6, 0xffffffd6, }, new uint [] {0x67, 0x47, 0xffffffe3, 0xffffffc3, }, 
			new uint [] {0x68, 0x48, 0xffffffe7, 0xffffffc7, }, new uint [] {0x6a, 0x4a, 0xffffffee, 0xffffffce, }, 
			new uint [] {0x6b, 0x4b, 0xffffffea, 0xffffffca, }, new uint [] {0x6c, 0x4c, 0xffffffeb, 0xffffffcb, }, 
			new uint [] {0x3b, 0x3a, 0xffffffb4, 0xffffffa8, }, new uint [] {0x27, 0x22, }, 
			new uint [] {0x5c, 0x7c, }, new uint [] {0x7a, 0x5a, 0xffffffe6, 0xffffffc6, }, 
			new uint [] {0x78, 0x58, 0xfffffff7, 0xffffffd7, }, new uint [] {0x63, 0x43, 0xfffffff8, 0xffffffd8, }, 
			new uint [] {0x76, 0x56, 0xfffffff9, 0xffffffd9, }, new uint [] {0x62, 0x42, 0xffffffe2, 0xffffffc2, }, 
			new uint [] {0x6e, 0x4e, 0xffffffed, 0xffffffcd, }, new uint [] {0x6d, 0x4d, 0xffffffec, 0xffffffcc, }, 
			new uint [] {0x2c, 0x3c, }, new uint [] {0x2e, 0x3e, }, 
			new uint [] {0x2f, 0x3f, }, new uint [] {0x3c, 0x3e, }, 
			new uint [] {}, 		});
		table [62] = new KeyboardLayout (1054, "Thai (Kedmanee)  keyboard layout", 0, 0, new uint [][] {
			new uint [] {0x60, 0x7e, 0x5f, 0x25, }, new uint [] {0x31, 0x21, 0xffffffe5, 0x2b, }, 
			new uint [] {0x32, 0x40, 0x2f, 0xfffffff1, }, new uint [] {0x33, 0x23, 0x2d, 0xfffffff2, }, 
			new uint [] {0x34, 0x24, 0xffffffc0, 0xfffffff3, }, new uint [] {0x35, 0x25, 0xffffffb6, 0xfffffff4, }, 
			new uint [] {0x36, 0x5e, 0xffffffd8, 0xffffffd9, }, new uint [] {0x37, 0x26, 0xffffffd6, 0xffffffdf, }, 
			new uint [] {0x38, 0x2a, 0xffffffa4, 0xfffffff5, }, new uint [] {0x39, 0x28, 0xffffffb5, 0xfffffff6, }, 
			new uint [] {0x30, 0x29, 0xffffffa8, 0xfffffff7, }, new uint [] {0x2d, 0x5f, 0xffffffa2, 0xfffffff8, }, 
			new uint [] {0x3d, 0x2b, 0xffffffaa, 0xfffffff9, }, new uint [] {0x71, 0x51, 0xffffffe6, 0xfffffff0, }, 
			new uint [] {0x77, 0x57, 0xffffffe4, 0x22, }, new uint [] {0x65, 0x45, 0xffffffd3, 0xffffffae, }, 
			new uint [] {0x72, 0x52, 0xffffffbe, 0xffffffb1, }, new uint [] {0x74, 0x54, 0xffffffd0, 0xffffffb8, }, 
			new uint [] {0x79, 0x59, 0xffffffd1, 0xffffffed, }, new uint [] {0x75, 0x55, 0xffffffd5, 0xffffffea, }, 
			new uint [] {0x69, 0x49, 0xffffffc3, 0xffffffb3, }, new uint [] {0x6f, 0x4f, 0xffffffb9, 0xffffffcf, }, 
			new uint [] {0x70, 0x50, 0xffffffc2, 0xffffffad, }, new uint [] {0x5b, 0x7b, 0xffffffba, 0xffffffb0, }, 
			new uint [] {0x5d, 0x7d, 0xffffffc5, 0x2c, }, new uint [] {0x61, 0x41, 0xffffffbf, 0xffffffc4, }, 
			new uint [] {0x73, 0x53, 0xffffffcb, 0xffffffa6, }, new uint [] {0x64, 0x44, 0xffffffa1, 0xffffffaf, }, 
			new uint [] {0x66, 0x46, 0xffffffb4, 0xffffffe2, }, new uint [] {0x67, 0x47, 0xffffffe0, 0xffffffac, }, 
			new uint [] {0x68, 0x48, 0xffffffe9, 0xffffffe7, }, new uint [] {0x6a, 0x4a, 0xffffffe8, 0xffffffeb, }, 
			new uint [] {0x6b, 0x4b, 0xffffffd2, 0xffffffc9, }, new uint [] {0x6c, 0x4c, 0xffffffca, 0xffffffc8, }, 
			new uint [] {0x3b, 0x3a, 0xffffffc7, 0xffffffab, }, new uint [] {0x27, 0x22, 0xffffffa7, 0x2e, }, 
			new uint [] {0x5c, 0x7c, 0xffffffa3, 0xffffffa5, }, new uint [] {0x7a, 0x5a, 0xffffffbc, 0x28, }, 
			new uint [] {0x78, 0x58, 0xffffffbb, 0x29, }, new uint [] {0x63, 0x43, 0xffffffe1, 0xffffffa9, }, 
			new uint [] {0x76, 0x56, 0xffffffcd, 0xffffffce, }, new uint [] {0x62, 0x42, 0xffffffda, }, 
			new uint [] {0x6e, 0x4e, 0xffffffd7, 0xffffffec, }, new uint [] {0x6d, 0x4d, 0xffffffb7, 0x3f, }, 
			new uint [] {0x2c, 0x3c, 0xffffffc1, 0xffffffb2, }, new uint [] {0x2e, 0x3e, 0xffffffe3, 0xffffffcc, }, 
			new uint [] {0x2f, 0x3f, 0xffffffbd, 0xffffffc6, }, new uint [] {}, 
			new uint [] {}, 		});
		table [63] = new KeyboardLayout (1043, "Dutch keyboard layout", 0, 0, new uint [][] {
			new uint [] {0x40, 0xffffffa7, }, new uint [] {0x31, 0x21, }, 
			new uint [] {0x32, 0x22, }, new uint [] {0x33, 0x23, }, 
			new uint [] {0x34, 0x24, }, new uint [] {0x35, 0x25, }, 
			new uint [] {0x36, 0x26, }, new uint [] {0x37, 0x5f, }, 
			new uint [] {0x38, 0x28, }, new uint [] {0x39, 0x29, }, 
			new uint [] {0x30, 0x27, }, new uint [] {0x2f, 0x3f, }, 
			new uint [] {0xffffffb0, 0x7e, }, new uint [] {0x71, 0x51, }, 
			new uint [] {0x77, 0x57, }, new uint [] {0x65, 0x45, }, 
			new uint [] {0x72, 0x52, }, new uint [] {0x74, 0x54, }, 
			new uint [] {0x79, 0x59, }, new uint [] {0x75, 0x55, }, 
			new uint [] {0x69, 0x49, }, new uint [] {0x6f, 0x4f, }, 
			new uint [] {0x70, 0x50, }, new uint [] {0xffffffa8, 0x7e, }, 
			new uint [] {0x2a, 0x7c, }, new uint [] {0x61, 0x41, }, 
			new uint [] {0x73, 0x53, }, new uint [] {0x64, 0x44, }, 
			new uint [] {0x66, 0x46, }, new uint [] {0x67, 0x47, }, 
			new uint [] {0x68, 0x48, }, new uint [] {0x6a, 0x4a, }, 
			new uint [] {0x6b, 0x4b, }, new uint [] {0x6c, 0x4c, }, 
			new uint [] {0x2b, 0xffffffb1, }, new uint [] {0x27, 0x60, }, 
			new uint [] {0x3c, 0x3e, }, new uint [] {0x7a, 0x5a, }, 
			new uint [] {0x78, 0x58, }, new uint [] {0x63, 0x43, }, 
			new uint [] {0x76, 0x56, }, new uint [] {0x62, 0x42, }, 
			new uint [] {0x6e, 0x4e, }, new uint [] {0x6d, 0x4d, }, 
			new uint [] {0x2c, 0x3b, }, new uint [] {0x2e, 0x3a, }, 
			new uint [] {0x2d, 0x3d, }, new uint [] {0x5b, 0x5d, }, 
			new uint [] {}, 		});


		rsxw.AddResource ("keyboard_table", table);

		short [][] scan_table = new short [][] {
			main_key_scan_qwerty, main_key_scan_dvorak, main_key_scan_abnt_qwerty,
			main_key_scan_qwerty_jp106, main_key_scan_vnc
		};
		rsxw.AddResource ("scan_table", scan_table);

		VirtualKeys [][] vkeys = new VirtualKeys [][] {
			main_key_vkey_qwerty, main_key_vkey_qwertz, main_key_vkey_dvorak,
			main_key_vkey_qwertz_105, main_key_vkey_azerty, main_key_vkey_qwerty_v2,
			main_key_vkey_abnt_qwerty, main_key_vkey_qwerty_jp106, main_key_vkey_vnc
		};
		int [][] vkey_table = new int [vkeys.Length][];
		for (int i = 0; i < vkeys.Length; i++) {
			int [] cp = new int [vkeys [i].Length];
			for (int r = 0; r < vkeys [i].Length; r++)
				cp [r] = (int) vkeys [i][r];
			vkey_table [i] = cp;
		}
		
		rsxw.AddResource ("vkey_table", vkey_table);
		
		rsxw.Close ();
	}

	private static readonly short [] main_key_scan_vnc = new short []
		{
			0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x1A,0x1B,0x27,0x28,0x29,0x33,0x34,0x35,0x2B,
			0x1E,0x30,0x2E,0x20,0x12,0x21,0x22,0x23,0x17,0x24,0x25,0x26,0x32,0x31,0x18,0x19,0x10,0x13,0x1F,0x14,0x16,0x2F,0x11,0x2D,0x15,0x2C,
			0x56
		};

	private static readonly short [] main_key_scan_qwerty_jp106 = new short []
	{
		0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x29,
		0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,
		0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x2B,
		0x2C,0x2D,0x2E,0x2F,0x30,0x31,0x32,0x33,0x34,0x35,
		0x56 /* the 102nd key (actually to the right of l-shift) */
	};

	private static readonly VirtualKeys [] main_key_vkey_vnc = new VirtualKeys []
		{
			VirtualKeys.VK_1, VirtualKeys.VK_2, VirtualKeys.VK_3, VirtualKeys.VK_4, VirtualKeys.VK_5, VirtualKeys.VK_6, 
			VirtualKeys.VK_7, VirtualKeys.VK_8, VirtualKeys.VK_9, VirtualKeys.VK_0, VirtualKeys.VK_OEM_MINUS, 
			VirtualKeys.VK_OEM_PLUS, VirtualKeys.VK_OEM_4, VirtualKeys.VK_OEM_6, VirtualKeys.VK_OEM_1, 
			VirtualKeys.VK_OEM_7, VirtualKeys.VK_OEM_3, VirtualKeys.VK_OEM_COMMA, VirtualKeys.VK_OEM_PERIOD, 
			VirtualKeys.VK_OEM_2, VirtualKeys.VK_OEM_5, VirtualKeys.VK_A, VirtualKeys.VK_B, VirtualKeys.VK_C, 
			VirtualKeys.VK_D, VirtualKeys.VK_E, VirtualKeys.VK_F, VirtualKeys.VK_G, VirtualKeys.VK_H, 
			VirtualKeys.VK_I, VirtualKeys.VK_J, VirtualKeys.VK_K, VirtualKeys.VK_L, VirtualKeys.VK_M, 
			VirtualKeys.VK_N, VirtualKeys.VK_O, VirtualKeys.VK_P, VirtualKeys.VK_Q, VirtualKeys.VK_R, 
			VirtualKeys.VK_S, VirtualKeys.VK_T, VirtualKeys.VK_U, VirtualKeys.VK_V, VirtualKeys.VK_W, 
			VirtualKeys.VK_X, VirtualKeys.VK_Y, VirtualKeys.VK_Z, VirtualKeys.VK_OEM_102
		};

		private static readonly short [] main_key_scan_qwerty = new short []
		{
			/* this is my (102-key) keyboard layout, sorry if it doesn't quite match yours */
			/* `	1    2	  3    4    5	 6    7	   8	9    0	  -    = */
			0x29,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,
			/* q	w    e	  r    t    y	 u    i	   o	p    [	  ] */
			0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,
			/* a	s    d	  f    g    h	 j    k	   l	;    '	  \ */
			0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x2B,
			/* z	x    c	  v    b    n	 m    ,	   .	/ */
			0x2C,0x2D,0x2E,0x2F,0x30,0x31,0x32,0x33,0x34,0x35,
			0x56 /* the 102nd key (actually to the right of l-shift) */
		};

		private static readonly short [] main_key_scan_dvorak = new short []
		{
			/* `	1    2	  3    4    5	 6    7	   8	9    0	  [    ] */
			0x29,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x1A,0x1B,
			/* '	,    .	  p    y    f	 g    c	   r	l    /	  = */
			0x28,0x33,0x34,0x19,0x15,0x21,0x22,0x2E,0x13,0x26,0x35,0x0D,
			/* a	o    e	  u    i    d	 h    t	   n	s    -	  \ */
			0x1E,0x18,0x12,0x16,0x17,0x20,0x23,0x14,0x31,0x1F,0x0C,0x2B,
			/* ;	q    j	  k    x    b	 m    w	   v	z */
			0x27,0x10,0x24,0x25,0x2D,0x30,0x32,0x11,0x2F,0x2C,
			0x56 /* the 102nd key (actually to the right of l-shift) */
		};

	private static readonly short [] main_key_scan_abnt_qwerty = new short [] 
	{
		0x29,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,
		0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,
		0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x2B,
		0x5e,0x2C,0x2D,0x2E,0x2F,0x30,0x31,0x32,0x33,0x34,0x35,
		0x56,0x35,
	};

	private static readonly VirtualKeys [] main_key_vkey_qwerty = new VirtualKeys []
	{
		// NOTE: this layout must concur with the scan codes layout above
		VirtualKeys.VK_OEM_3, VirtualKeys.VK_1, VirtualKeys.VK_2, VirtualKeys.VK_3, VirtualKeys.VK_4, 
		VirtualKeys.VK_5, VirtualKeys.VK_6, VirtualKeys.VK_7, VirtualKeys.VK_8, VirtualKeys.VK_9, 
		VirtualKeys.VK_0, VirtualKeys.VK_OEM_MINUS, VirtualKeys.VK_OEM_PLUS,  VirtualKeys.VK_Q, 
		VirtualKeys.VK_W, VirtualKeys.VK_E, VirtualKeys.VK_R, VirtualKeys.VK_T, VirtualKeys.VK_Y, 
		VirtualKeys.VK_U, VirtualKeys.VK_I, VirtualKeys.VK_O, VirtualKeys.VK_P, VirtualKeys.VK_OEM_4, 
		VirtualKeys.VK_OEM_6, VirtualKeys.VK_A, VirtualKeys.VK_S, VirtualKeys.VK_D, VirtualKeys.VK_F, 
		VirtualKeys.VK_G, VirtualKeys.VK_H, VirtualKeys.VK_J, VirtualKeys.VK_K, VirtualKeys.VK_L, 
		VirtualKeys.VK_OEM_1, VirtualKeys.VK_OEM_7, VirtualKeys.VK_OEM_5, VirtualKeys.VK_Z, 
		VirtualKeys.VK_X, VirtualKeys.VK_C, VirtualKeys.VK_V, VirtualKeys.VK_B, VirtualKeys.VK_N, 
		VirtualKeys.VK_M, VirtualKeys.VK_OEM_COMMA, VirtualKeys.VK_OEM_PERIOD, VirtualKeys.VK_OEM_2, 
		VirtualKeys.VK_OEM_102 // the 102nd key (actually to the right of l-shift)
	};

	private static readonly VirtualKeys [] main_key_vkey_qwertz = new VirtualKeys []
	{
		VirtualKeys.VK_OEM_3, VirtualKeys.VK_1, VirtualKeys.VK_2, VirtualKeys.VK_3, VirtualKeys.VK_4, 
		VirtualKeys.VK_5, VirtualKeys.VK_6, VirtualKeys.VK_7, VirtualKeys.VK_8, VirtualKeys.VK_9, 
		VirtualKeys.VK_0, VirtualKeys.VK_OEM_MINUS, VirtualKeys.VK_OEM_PLUS,
		VirtualKeys.VK_Q, VirtualKeys.VK_W, VirtualKeys.VK_E, VirtualKeys.VK_R, VirtualKeys.VK_T, VirtualKeys.VK_Z,
		VirtualKeys.VK_U, VirtualKeys.VK_I, VirtualKeys.VK_O, VirtualKeys.VK_P, VirtualKeys.VK_OEM_4, 
		VirtualKeys.VK_OEM_6, VirtualKeys.VK_A, VirtualKeys.VK_S, VirtualKeys.VK_D, VirtualKeys.VK_F, 
		VirtualKeys.VK_G, VirtualKeys.VK_H, VirtualKeys.VK_J, VirtualKeys.VK_K, VirtualKeys.VK_L, 
		VirtualKeys.VK_OEM_1, VirtualKeys.VK_OEM_7, VirtualKeys.VK_OEM_5, VirtualKeys.VK_Y,
		VirtualKeys.VK_X, VirtualKeys.VK_C, VirtualKeys.VK_V, VirtualKeys.VK_B, VirtualKeys.VK_N, 
		VirtualKeys.VK_M, VirtualKeys.VK_OEM_COMMA, VirtualKeys.VK_OEM_PERIOD, VirtualKeys.VK_OEM_2, 
		VirtualKeys.VK_OEM_102 // the 102nd key (actually to the right of l-shift)
	};

	private static readonly VirtualKeys [] main_key_vkey_dvorak = new VirtualKeys []
	{
		// NOTE: this layout must concur with the scan codes layout above
		VirtualKeys.VK_OEM_3, VirtualKeys.VK_1, VirtualKeys.VK_2, VirtualKeys.VK_3, VirtualKeys.VK_4,
		VirtualKeys.VK_5, VirtualKeys.VK_6, VirtualKeys.VK_7, VirtualKeys.VK_8, VirtualKeys.VK_9,
		VirtualKeys.VK_0, VirtualKeys.VK_OEM_4, VirtualKeys.VK_OEM_6, VirtualKeys.VK_OEM_7,
		VirtualKeys.VK_OEM_COMMA, VirtualKeys.VK_OEM_PERIOD, VirtualKeys.VK_P, VirtualKeys.VK_Y,
		VirtualKeys.VK_F, VirtualKeys.VK_G, VirtualKeys.VK_C, VirtualKeys.VK_R, VirtualKeys.VK_L,
		VirtualKeys.VK_OEM_2, VirtualKeys.VK_OEM_PLUS, VirtualKeys.VK_A, VirtualKeys.VK_O,
		VirtualKeys.VK_E, VirtualKeys.VK_U, VirtualKeys.VK_I, VirtualKeys.VK_D, VirtualKeys.VK_H,
		VirtualKeys.VK_T, VirtualKeys.VK_N, VirtualKeys.VK_S, VirtualKeys.VK_OEM_MINUS, VirtualKeys.VK_OEM_5, 
		VirtualKeys.VK_OEM_1, VirtualKeys.VK_Q, VirtualKeys.VK_J, VirtualKeys.VK_K, VirtualKeys.VK_X,
		VirtualKeys.VK_B, VirtualKeys.VK_M, VirtualKeys.VK_W, VirtualKeys.VK_V, VirtualKeys.VK_Z,
		VirtualKeys.VK_OEM_102 // the 102nd key (actually to the right of l-shift)
	};

	private static readonly VirtualKeys [] main_key_vkey_azerty = new VirtualKeys []
	{
		// NOTE: this layout must concur with the scan codes layout above
		VirtualKeys.VK_OEM_7, VirtualKeys.VK_1, VirtualKeys.VK_2, VirtualKeys.VK_3, VirtualKeys.VK_4,
		VirtualKeys.VK_5, VirtualKeys.VK_6, VirtualKeys.VK_7, VirtualKeys.VK_8, VirtualKeys.VK_9,
		VirtualKeys.VK_0, VirtualKeys.VK_OEM_4, VirtualKeys.VK_OEM_PLUS, VirtualKeys.VK_A, VirtualKeys.VK_Z,
		VirtualKeys.VK_E, VirtualKeys.VK_R, VirtualKeys.VK_T, VirtualKeys.VK_Y, VirtualKeys.VK_U,
		VirtualKeys.VK_I, VirtualKeys.VK_O, VirtualKeys.VK_P, VirtualKeys.VK_OEM_6, VirtualKeys.VK_OEM_1, 
		VirtualKeys.VK_Q, VirtualKeys.VK_S, VirtualKeys.VK_D, VirtualKeys.VK_F, VirtualKeys.VK_G,
		VirtualKeys.VK_H, VirtualKeys.VK_J, VirtualKeys.VK_K, VirtualKeys.VK_L, VirtualKeys.VK_M,
		VirtualKeys.VK_OEM_3, VirtualKeys.VK_OEM_5, VirtualKeys.VK_W, VirtualKeys.VK_X, VirtualKeys.VK_C,
		VirtualKeys.VK_V, VirtualKeys.VK_B, VirtualKeys.VK_N, VirtualKeys.VK_OEM_COMMA, VirtualKeys.VK_OEM_PERIOD,
		VirtualKeys.VK_OEM_2, VirtualKeys.VK_OEM_8, 
		VirtualKeys.VK_OEM_102 // the 102nd key (actually to the right of l-shift)
	};


	//// WRONG
	private static readonly VirtualKeys [] main_key_vkey_qwerty_jp106 = new VirtualKeys []
	{
		// NOTE: this layout must concur with the scan codes layout above
		VirtualKeys.VK_OEM_7, VirtualKeys.VK_1, VirtualKeys.VK_2, VirtualKeys.VK_3, VirtualKeys.VK_4,
		VirtualKeys.VK_5, VirtualKeys.VK_6, VirtualKeys.VK_7, VirtualKeys.VK_8, VirtualKeys.VK_9,
		VirtualKeys.VK_0, VirtualKeys.VK_OEM_4, VirtualKeys.VK_OEM_PLUS, VirtualKeys.VK_A, VirtualKeys.VK_Z,
		VirtualKeys.VK_E, VirtualKeys.VK_R, VirtualKeys.VK_T, VirtualKeys.VK_Y, VirtualKeys.VK_U,
		VirtualKeys.VK_I, VirtualKeys.VK_O, VirtualKeys.VK_P, VirtualKeys.VK_OEM_6, VirtualKeys.VK_OEM_1, 
		VirtualKeys.VK_Q, VirtualKeys.VK_S, VirtualKeys.VK_D, VirtualKeys.VK_F, VirtualKeys.VK_G,
		VirtualKeys.VK_H, VirtualKeys.VK_J, VirtualKeys.VK_K, VirtualKeys.VK_L, VirtualKeys.VK_M,
		VirtualKeys.VK_OEM_3, VirtualKeys.VK_OEM_5, VirtualKeys.VK_W, VirtualKeys.VK_X, VirtualKeys.VK_C,
		VirtualKeys.VK_V, VirtualKeys.VK_B, VirtualKeys.VK_N, VirtualKeys.VK_OEM_COMMA, VirtualKeys.VK_OEM_PERIOD,
		VirtualKeys.VK_OEM_2, VirtualKeys.VK_OEM_8, 
		VirtualKeys.VK_OEM_ATTN,
		VirtualKeys.VK_OEM_102, // the 102nd key (actually to the right of l-shift)
		VirtualKeys.VK_OEM_COPY,
		VirtualKeys.VK_OEM_AUTO,
		VirtualKeys.VK_OEM_ENLW,
		VirtualKeys.VK_OEM_BACKTAB,
	};

	//// WRONG
	private static readonly VirtualKeys [] main_key_vkey_qwertz_105 = new VirtualKeys []
	{
		// NOTE: this layout must concur with the scan codes layout above
		VirtualKeys.VK_OEM_7, VirtualKeys.VK_1, VirtualKeys.VK_2, VirtualKeys.VK_3, VirtualKeys.VK_4,
		VirtualKeys.VK_5, VirtualKeys.VK_6, VirtualKeys.VK_7, VirtualKeys.VK_8, VirtualKeys.VK_9,
		VirtualKeys.VK_0, VirtualKeys.VK_OEM_4, VirtualKeys.VK_OEM_PLUS, VirtualKeys.VK_A, VirtualKeys.VK_Z,
		VirtualKeys.VK_E, VirtualKeys.VK_R, VirtualKeys.VK_T, VirtualKeys.VK_Y, VirtualKeys.VK_U,
		VirtualKeys.VK_I, VirtualKeys.VK_O, VirtualKeys.VK_P, VirtualKeys.VK_OEM_6, VirtualKeys.VK_OEM_1, 
		VirtualKeys.VK_Q, VirtualKeys.VK_S, VirtualKeys.VK_D, VirtualKeys.VK_F, VirtualKeys.VK_G,
		VirtualKeys.VK_H, VirtualKeys.VK_J, VirtualKeys.VK_K, VirtualKeys.VK_L, VirtualKeys.VK_M,
		VirtualKeys.VK_OEM_3, VirtualKeys.VK_OEM_5, VirtualKeys.VK_W, VirtualKeys.VK_X, VirtualKeys.VK_C,
		VirtualKeys.VK_V, VirtualKeys.VK_B, VirtualKeys.VK_N, VirtualKeys.VK_OEM_COMMA, VirtualKeys.VK_OEM_PERIOD,
		VirtualKeys.VK_OEM_2, VirtualKeys.VK_OEM_8, 
		VirtualKeys.VK_OEM_102 // the 102nd key (actually to the right of l-shift)
	};

	//// WRONG
	private static readonly VirtualKeys [] main_key_vkey_qwerty_v2 = new VirtualKeys []
	{
		// NOTE: this layout must concur with the scan codes layout above
		VirtualKeys.VK_OEM_7, VirtualKeys.VK_1, VirtualKeys.VK_2, VirtualKeys.VK_3, VirtualKeys.VK_4,
		VirtualKeys.VK_5, VirtualKeys.VK_6, VirtualKeys.VK_7, VirtualKeys.VK_8, VirtualKeys.VK_9,
		VirtualKeys.VK_0, VirtualKeys.VK_OEM_4, VirtualKeys.VK_OEM_PLUS, VirtualKeys.VK_A, VirtualKeys.VK_Z,
		VirtualKeys.VK_E, VirtualKeys.VK_R, VirtualKeys.VK_T, VirtualKeys.VK_Y, VirtualKeys.VK_U,
		VirtualKeys.VK_I, VirtualKeys.VK_O, VirtualKeys.VK_P, VirtualKeys.VK_OEM_6, VirtualKeys.VK_OEM_1, 
		VirtualKeys.VK_Q, VirtualKeys.VK_S, VirtualKeys.VK_D, VirtualKeys.VK_F, VirtualKeys.VK_G,
		VirtualKeys.VK_H, VirtualKeys.VK_J, VirtualKeys.VK_K, VirtualKeys.VK_L, VirtualKeys.VK_M,
		VirtualKeys.VK_OEM_3, VirtualKeys.VK_OEM_5, VirtualKeys.VK_W, VirtualKeys.VK_X, VirtualKeys.VK_C,
		VirtualKeys.VK_V, VirtualKeys.VK_B, VirtualKeys.VK_N, VirtualKeys.VK_OEM_COMMA, VirtualKeys.VK_OEM_PERIOD,
		VirtualKeys.VK_OEM_2, VirtualKeys.VK_OEM_8, 
		VirtualKeys.VK_OEM_102 // the 102nd key (actually to the right of l-shift)
	};

	private static readonly VirtualKeys [] main_key_vkey_abnt_qwerty = new VirtualKeys []
	{
		// NOTE: this layout must concur with the scan codes layout above
		VirtualKeys.VK_OEM_7, VirtualKeys.VK_1, VirtualKeys.VK_2, VirtualKeys.VK_3, VirtualKeys.VK_4, 
		VirtualKeys.VK_5, VirtualKeys.VK_6, VirtualKeys.VK_7, VirtualKeys.VK_8, VirtualKeys.VK_9, 
		VirtualKeys.VK_0, VirtualKeys.VK_OEM_MINUS, VirtualKeys.VK_OEM_PLUS,  VirtualKeys.VK_Q, 
		VirtualKeys.VK_W, VirtualKeys.VK_E, VirtualKeys.VK_R, VirtualKeys.VK_T, VirtualKeys.VK_Y, 
		VirtualKeys.VK_U, VirtualKeys.VK_I, VirtualKeys.VK_O, VirtualKeys.VK_P, VirtualKeys.VK_OEM_3, 
		VirtualKeys.VK_OEM_4, VirtualKeys.VK_A, VirtualKeys.VK_S, VirtualKeys.VK_D, VirtualKeys.VK_F, 
		VirtualKeys.VK_G, VirtualKeys.VK_H, VirtualKeys.VK_J, VirtualKeys.VK_K, VirtualKeys.VK_L, 
		VirtualKeys.VK_OEM_8, VirtualKeys.VK_OEM_102, VirtualKeys.VK_OEM_6, VirtualKeys.VK_Z, 
		VirtualKeys.VK_X, VirtualKeys.VK_C, VirtualKeys.VK_V, VirtualKeys.VK_B, VirtualKeys.VK_N, 
		VirtualKeys.VK_M, VirtualKeys.VK_OEM_COMMA, VirtualKeys.VK_OEM_PERIOD, VirtualKeys.VK_OEM_1, 
		VirtualKeys.VK_OEM_2, VirtualKeys.VK_OEM_5 
	};
	/*
	private static readonly VirtualKeys [] main_key_vkey_qwerty_jp = new VirtualKeys []
	{
		VirtualKeys.VK_1, VirtualKeys.VK_2, VirtualKeys.VK_3, VirtualKeys.VK_4, 
		VirtualKeys.VK_5, VirtualKeys.VK_6, VirtualKeys.VK_7, VirtualKeys.VK_8, VirtualKeys.VK_9,
		VirtualKeys.VK_0, VirtualKeys.VK_OEM_MINUS, VirtualKeys.VK_OEM_PLUS,VirtualKeys.VK_OEM_3,
		VirtualKeys.VK_Q, VirtualKeys.VK_W, VirtualKeys.VK_E, VirtualKeys.VK_R, VirtualKeys.VK_T
		VirtualKeys.VK_Y, VirtualKeys.VK_U, VirtualKeys.VK_I, VirtualKeys.VK_O, VirtualKeys.VK_P
		VirtualKeys.VK_OEM_4,VirtualKeys.VK_OEM_6,
		VirtualKeys.VK_A, VirtualKeys.VK_S, VirtualKeys.VK_D, VirtualKeys.VK_F, 
		VirtualKeys.VK_G, VirtualKeys.VK_H, VirtualKeys.VK_J, VirtualKeys.VK_K, VirtualKeys.VK_L, 
		VirtualKeys.VK_OEM_1, VirtualKeys.VK_OEM_7, VirtualKeys.VK_OEM_5, VirtualKeys.VK_Z, 
		VirtualKeys.VK_X, VirtualKeys.VK_C, VirtualKeys.VK_V, VirtualKeys.VK_B, VirtualKeys.VK_N, 
		VirtualKeys.VK_M, VirtualKeys.VK_OEM_COMMA, VirtualKeys.VK_OEM_PERIOD, VirtualKeys.VK_OEM_2, 
		VirtualKeys.VK_OEM_102
		};*/

	internal enum VirtualKeys {
		VK_LBUTTON		= 0x01,
		VK_RBUTTON              = 0x02,
		VK_CANCEL		= 0x03,
		VK_MBUTTON              = 0x04,
		VK_XBUTTON1             = 0x05,
		VK_XBUTTON2             = 0x06,
		VK_BACK			= 0x08,
		VK_TAB			= 0x09,
		VK_CLEAR		= 0x0C,
		VK_RETURN		= 0x0D,
		VK_SHIFT		= 0x10,
		VK_CONTROL		= 0x11,
		VK_MENU			= 0x12,
		VK_PAUSE		= 0x13,
		VK_CAPITAL		= 0x14,
		VK_ESCAPE		= 0x1B,
		VK_SPACE		= 0x20,
		VK_PRIOR		= 0x21,
		VK_NEXT			= 0x22,
		VK_END			= 0x23,
		VK_HOME			= 0x24,
		VK_LEFT			= 0x25,
		VK_UP			= 0x26,
		VK_RIGHT		= 0x27,
		VK_DOWN			= 0x28,
		VK_SELECT		= 0x29,
		VK_PRINT		= 0x2A,
		VK_EXECUTE		= 0x2B,
		VK_SNAPSHOT		= 0x2C,
		VK_INSERT		= 0x2D,
		VK_DELETE		= 0x2E,
		VK_HELP			= 0x2F,
		VK_0			= 0x30,
		VK_1			= 0x31,
		VK_2			= 0x32,
		VK_3			= 0x33,
		VK_4			= 0x34,
		VK_5			= 0x35,
		VK_6			= 0x36,
		VK_7			= 0x37,
		VK_8			= 0x38,
		VK_9			= 0x39,
		VK_A			= 0x41,
		VK_B			= 0x42,
		VK_C			= 0x43,
		VK_D			= 0x44,
		VK_E			= 0x45,
		VK_F			= 0x46,
		VK_G			= 0x47,
		VK_H			= 0x48,
		VK_I			= 0x49,
		VK_J			= 0x4A,
		VK_K			= 0x4B,
		VK_L			= 0x4C,
		VK_M			= 0x4D,
		VK_N			= 0x4E,
		VK_O			= 0x4F,
		VK_P			= 0x50,
		VK_Q			= 0x51,
		VK_R			= 0x52,
		VK_S			= 0x53,
		VK_T			= 0x54,
		VK_U			= 0x55,
		VK_V			= 0x56,
		VK_W			= 0x57,
		VK_X			= 0x58,
		VK_Y			= 0x59,
		VK_Z			= 0x5A,
		VK_LWIN			= 0x5B,
		VK_RWIN			= 0x5C,
		VK_APPS			= 0x5D,
		VK_NUMPAD0		= 0x60,
		VK_NUMPAD1		= 0x61,
		VK_NUMPAD2		= 0x62,
		VK_NUMPAD3		= 0x63,
		VK_NUMPAD4		= 0x64,
		VK_NUMPAD5		= 0x65,
		VK_NUMPAD6		= 0x66,
		VK_NUMPAD7		= 0x67,
		VK_NUMPAD8		= 0x68,
		VK_NUMPAD9		= 0x69,
		VK_MULTIPLY		= 0x6A,
		VK_ADD			= 0x6B,
		VK_SEPARATOR		= 0x6C,
		VK_SUBTRACT		= 0x6D,
		VK_DECIMAL		= 0x6E,
		VK_DIVIDE		= 0x6F,
		VK_F1			= 0x70,
		VK_F2			= 0x71,
		VK_F3			= 0x72,
		VK_F4			= 0x73,
		VK_F5			= 0x74,
		VK_F6			= 0x75,
		VK_F7			= 0x76,
		VK_F8			= 0x77,
		VK_F9			= 0x78,
		VK_F10			= 0x79,
		VK_F11			= 0x7A,
		VK_F12			= 0x7B,
		VK_F13			= 0x7C,
		VK_F14			= 0x7D,
		VK_F15			= 0x7E,
		VK_F16			= 0x7F,
		VK_F17			= 0x80,
		VK_F18			= 0x81,
		VK_F19			= 0x82,
		VK_F20			= 0x83,
		VK_F21			= 0x84,
		VK_F22			= 0x85,
		VK_F23			= 0x86,
		VK_F24			= 0x87,
		VK_NUMLOCK		= 0x90,
		VK_SCROLL		= 0x91,
		VK_LSHIFT		= 0xA0,   
		VK_RSHIFT		= 0xA1,   
		VK_LCONTROL		= 0xA2,   
		VK_RCONTROL		= 0xA3,   
		VK_LMENU		= 0xA4,   
		VK_RMENU		= 0xA5,
		VK_OEM_1		= 0xBA,
		VK_OEM_PLUS		= 0xBB,
		VK_OEM_COMMA		= 0xBC,
		VK_OEM_MINUS		= 0xBD,
		VK_OEM_PERIOD		= 0xBE,
		VK_OEM_2		= 0xBF, 
		VK_OEM_3		= 0xC0,
		VK_OEM_4		= 0xDB,
		VK_OEM_5		= 0xDC,
		VK_OEM_6		= 0xDD,
		VK_OEM_7		= 0xDE,
		VK_OEM_8		= 0xDF,
		VK_OEM_AX		= 0xE1,
		VK_OEM_102		= 0xE2,
		VK_ICO_HELP		= 0xE3,
		VK_ICO_00		= 0xE4,
		VK_PROCESSKEY		= 0xE5,
		VK_OEM_ATTN		= 0xF0,
		VK_OEM_COPY		= 0xF2,
		VK_OEM_AUTO		= 0xF3,
		VK_OEM_ENLW		= 0xF4,
		VK_OEM_BACKTAB		= 0xF5,
		VK_ATTN			= 0xF6,
		VK_CRSEL		= 0xF7,
		VK_EXSEL		= 0xF8,
		VK_EREOF		= 0xF9,
		VK_PLAY			= 0xFA,
		VK_ZOOM			= 0xFB,
		VK_NONAME		= 0xFC,
		VK_PA1			= 0xFD,
		VK_OEM_CLEAR		= 0xFE,
	}
}

