; A small test of defprime
;
; Copyright (C) 2021 Kestrel Institute
;
; License: A 3-clause BSD license. See the file books/3BSD-mod.txt.
;
; Author: Eric Smith (eric.smith@kestrel.edu)
; Contributing Author: Eric McCarthy (mccarthy@kestrel.edu)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "PRIMES")

(include-book "defprime")
(include-book "std/testing/must-be-redundant" :dir :system)

(defprime my97-prime ;; name to use for the prime
  97 ;; numeric value of the prime
  ;; Pratt certificate:
  (5 (2 3)
     (5 1)
     (() ()))
  )

;; Stuff generated by defprime:
(acl2::must-be-redundant

 ;; the constant:
 (defconst *my97-prime* 97)

 ;; the 0-ary function:
 (defund my97-prime () (declare (xargs :guard t)) *my97-prime*)

 (defmacro eviscerate-my97-prime ()
   (list 'table 'acl2::evisc-table 97 "#.*MY97-PRIME*"))

 (defmacro uneviscerate-my97-prime ()
   (list* 'table 'acl2::evisc-table 97 '(nil)))

 ;; causes 97 to be printed as #.*my97-prime*:
 (eviscerate-my97-prime)

 ;; the pratt certificate:
 (defconst *my97-prime-pratt-cert*
   '(5 (2 3) (5 1) (nil nil)))

 ;; proof of primality:
 (defthm primep-of-my97-prime-constant
   (rtl::primep *my97-prime*))

 ;; lift primality proof to the 0-ary function:
 (defthm primep-of-my97-prime
   (rtl::primep (my97-prime)))

 ;; strong linear rule about the 0-ary function:
 (defthm my97-prime-linear
   (= (my97-prime) *my97-prime*)
   :rule-classes ((:linear :trigger-terms ((my97-prime))))))

(defprime-alias my97-prime-alias my97-prime)

(acl2::must-be-redundant

 ;; the constant:
 (defconst *my97-prime-alias* 97)

 ;; the 0-ary function:
 (defund my97-prime-alias () (declare (xargs :guard t)) *my97-prime-alias*)

 (defmacro eviscerate-my97-prime-alias ()
   (list 'table 'acl2::evisc-table 97 "#.*MY97-PRIME-ALIAS*"))

 (defmacro uneviscerate-my97-prime-alias ()
   (list* 'table 'acl2::evisc-table 97 '(nil)))

 ;; causes 97 to be printed as #.*my97-prime-alias*:
 (eviscerate-my97-prime-alias)

 ;; proof of primality:
 (defthm primep-of-my97-prime-alias-constant
   (rtl::primep *my97-prime-alias*))

 ;; lift primality proof to the 0-ary function:
 (defthm primep-of-my97-prime-alias
   (rtl::primep (my97-prime-alias)))

 ;; strong linear rule about the 0-ary function:
 (defthm my97-prime-alias-linear
   (= (my97-prime-alias) *my97-prime-alias*)
   :rule-classes ((:linear :trigger-terms ((my97-prime-alias))))))

(defprime-alias my97-prime-alias2 my97-prime) ;second alias of same prime
(defprime-alias my97-prime-alias2 my97-prime-alias) ;alias of alias
(defprime-alias acl2::new-name my97-prime) ;new name in different package
(defprime-alias xdoc::new-name my97-prime) ;new name in different package

;; A test with :doc
(defprime my97-prime ;; name to use for the prime
  97 ;; numeric value of the prime
  ;; Pratt certificate:
  (5 (2 3)
     (5 1)
     (() ()))
  :short "short doc"
  ;; Makes sure we can calculate this:
  :long (concatenate 'string "foo" "bar"))

;; A test with :doc nil
(defprime my97-prime ;; name to use for the prime
  97 ;; numeric value of the prime
  ;; Pratt certificate:
  (5 (2 3)
     (5 1)
     (() ()))
  :doc nil)

;; A test with :long nil
(defprime my97-prime ;; name to use for the prime
  97 ;; numeric value of the prime
  ;; Pratt certificate:
  (5 (2 3)
     (5 1)
     (() ()))
  :long nil)

;; A test with :short nil
(defprime my97-prime ;; name to use for the prime
  97 ;; numeric value of the prime
  ;; Pratt certificate:
  (5 (2 3)
     (5 1)
     (() ()))
  :short nil)

;; A test with :parents nil
(defprime my97-prime ;; name to use for the prime
  97 ;; numeric value of the prime
  ;; Pratt certificate:
  (5 (2 3)
     (5 1)
     (() ()))
  :parents nil)
