------------------------------------------------------------------------------
--                                                                          --
--                            GNATPP COMPONENTS                             --
--                                                                          --
--                         G N A T P P . S T A C S                          --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 14583 $
--                                                                          --
--                       Copyright (C) 2001, ACT Europe                     --
--                                                                          --
-- GNATPP is free software; you can redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNATPP is  distributed in the  hope that it will  be  useful, but --
-- WITHOUT ANY WARRANTY; without even the implied warranty of  MERCHANTABI- --
-- LITY or  FITNESS  FOR A  PARTICULAR  PURPOSE. See the GNU General Public --
-- License  for more details. You  should  have  received a copy of the GNU --
-- General Public License  distributed with GNAT; see file COPYING. If not, --
-- write  to  the Free  Software  Foundation,  59 Temple Place - Suite 330, --
-- Boston,                                                                  --
--                                                                          --
-- GNATPP is maintained by ACT Europe (http://www.act-europe.fr).           --
--                                                                          --
------------------------------------------------------------------------------

with Table;

package body GNATPP.Stacs is

   package Stack_Table is new Table.Table
     (Table_Component_Type => Element_Type,
      Table_Index_Type     => Natural,
      Table_Low_Bound      => 1,
      Table_Initial        => 100,
      Table_Increment      => 100,
      Table_Name           => "Generic Stack");

   Stack : Stack_Table.Table_Ptr renames Stack_Table.Table;

   --------------
   -- Is_Empty --
   --------------

   function Is_Empty return Boolean is
   begin
      return Stack_Table.Last = 0;
   end Is_Empty;

   ---------
   -- Pop --
   ---------

   function Pop return Element_Type is
   begin

      if Is_Empty then
         return No_Element;
      else
         Stack_Table.Decrement_Last;
         return Stack (Stack_Table.Last + 1);
      end if;

   end Pop;

   ---------
   -- Pop --
   ---------

   procedure Pop is
   begin

      if not Is_Empty then
         Stack_Table.Decrement_Last;
      end if;

   end Pop;

   ----------
   -- Push --
   ----------

   procedure Push (Elem : Element_Type) is
   begin
      Stack_Table.Append (Elem);
   end Push;

   ----------
   -- Size --
   ----------

   function Size return Natural renames Stack_Table.Last;

   ---------
   -- Top --
   ---------

   function Top (Step_Down : Natural := 0) return Element_Type is
   begin

      if Is_Empty or else Step_Down > Stack_Table.Last then
         return No_Element;
      else
         return Stack (Stack_Table.Last - Step_Down);
      end if;

   end Top;

end GNATPP.Stacs;
