//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _complex_eriroot_5.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Ryan D. Reynolds <RyanDReynolds@u.northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <complex>
#include "comperirootlist.h"

using namespace std;
using namespace bagel;

void ComplexERIRootList::complex_eriroot5(const complex<double>* ta, complex<double>* rr, complex<double>* ww, const int n) {

  static constexpr double ax[5] = {1.175813202117782e-01,1.074562012436904e+00,3.085937443717551e+00,6.414729733662032e+00,1.180718948997173e+01
    };
  static constexpr double aw[5] = {6.108626337353256e-01,2.401386110823146e-01,3.387439445548104e-02,1.343645746781236e-03,7.640432855232646e-06
    };
  static constexpr double xr[15700] = {   4.883912892391429e-02,  -2.372326882435055e-03,   8.407765219623302e-05,  -2.550925026027147e-06,   6.882601448051686e-08,
  -1.653073692793668e-09,   3.418584575174108e-11,  -5.431333729509602e-13,   3.075044175587356e-15,   2.197744708736045e-16,  -1.223107959797413e-17,   3.884839150819286e-19,
  -8.449341619629729e-21,   1.331384659505653e-22,   4.884708945794173e-02,  -2.373049820615925e-03,   8.411663861023691e-05,  -2.552483649713319e-06,   6.887416887711234e-08,
  -1.654130217874417e-09,   3.419281179638988e-11,  -5.423383021311574e-13,   3.021746338183524e-15,   2.218147685705061e-16,  -1.228382152887885e-17,   3.894420274200482e-19,
  -8.459580096097467e-21,   1.328716462430576e-22,   4.886113894964877e-02,  -2.374325814357015e-03,   8.418545279217452e-05,  -2.555234667061678e-06,   6.895914559552611e-08,
  -1.655993174086499e-09,   3.420498871593630e-11,  -5.409297615097431e-13,   2.927520169358767e-15,   2.254189059818496e-16,  -1.237693493292352e-17,   3.911309215197497e-19,
  -8.477459955046969e-21,   1.323916734225333e-22,   4.887813286867081e-02,  -2.375869370077621e-03,   8.426870122033003e-05,  -2.558562592282611e-06,   6.906191309679910e-08,
  -1.658243659697393e-09,   3.421951720944509e-11,  -5.392169394391578e-13,   2.813271640885872e-15,   2.297838827222902e-16,  -1.248961230084005e-17,   3.931701966867239e-19,
  -8.498761709675479e-21,   1.317956192981586e-22,   4.889463563788575e-02,  -2.377368466674072e-03,   8.434955671384226e-05,  -2.561794713691275e-06,   6.916169123932598e-08,
  -1.660426058516037e-09,   3.423341566519291e-11,  -5.375440991460387e-13,   2.702037172144387e-15,   2.340284568942115e-16,  -1.259908429917332e-17,   3.951467486368850e-19,
  -8.519105420287602e-21,   1.312005262618532e-22,   4.890793390048657e-02,  -2.378576577652926e-03,   8.441472105154682e-05,  -2.564399492065902e-06,   6.924208061185163e-08,
  -1.662182492990957e-09,   3.424446456256181e-11,  -5.361892644367690e-13,   2.612195903197629e-15,   2.374529348065377e-16,  -1.268733509184096e-17,   3.967367486477752e-19,
  -8.535252234919569e-21,   1.307093034081547e-22,   4.891672303920063e-02,  -2.379375100285540e-03,   8.445779429507021e-05,  -2.566121184044647e-06,   6.929520504588608e-08,
  -1.663342289936802e-09,   3.425169315198571e-11,  -5.352904777742841e-13,   2.552716648055261e-15,   2.397182660289323e-16,  -1.274567955348424e-17,   3.977862600258223e-19,
  -8.545802833875496e-21,   1.303789090607637e-22,   4.892123726511240e-02,  -2.379785249278728e-03,   8.447991873764357e-05,  -2.567005510088384e-06,   6.932248839056508e-08,
  -1.663937645956339e-09,   3.425538299074898e-11,  -5.348278136911499e-13,   2.522136019287900e-15,   2.408823938831763e-16,  -1.277565142518419e-17,   3.983248812285299e-19,
  -8.551184178532027e-21,   1.302074381597228e-22,   4.892280857554562e-02,  -2.379928016443406e-03,   8.448762003246156e-05,  -2.567313332511086e-06,   6.933198483172690e-08,
  -1.664144824399079e-09,   3.425666370692513e-11,  -5.346666049821075e-13,   2.511486549094347e-15,   2.412877020912068e-16,  -1.278608486954656e-17,   3.985122967943546e-19,
  -8.553051321387015e-21,   1.301474697002259e-22,   4.892305792527491e-02,  -2.379950672150889e-03,   8.448884215416590e-05,  -2.567362180860037e-06,   6.933349179673511e-08,
  -1.664177698832937e-09,   3.425686676961744e-11,  -5.346410151074985e-13,   2.509796358866667e-15,   2.413520247530574e-16,  -1.278774058269136e-17,   3.985420343771216e-19,
  -8.553347331734108e-21,   1.301379399279525e-22,   4.063821213761093e-01,  -1.585680572388168e-02,   3.398450012045883e-04,  -2.243511615796671e-06,  -1.287529363140804e-07,
   4.954358607285968e-09,  -4.293304389596204e-11,  -2.767558050686669e-12,   1.186109815846541e-13,  -1.110767700812360e-15,  -7.342894167174531e-17,   3.090439527808469e-18,
  -2.147614406844679e-20,  -2.020271546113139e-21,   4.064138357504495e-01,  -1.585742052344892e-02,   3.397722592699072e-04,  -2.238913215593979e-06,  -1.288097154309028e-07,
   4.948857574785012e-09,  -4.262816540571626e-11,  -2.770908926572505e-12,   1.182979395744669e-13,  -1.095413107461864e-15,  -7.353465596724152e-17,   3.075539272557813e-18,
  -2.088395254412810e-20,  -2.022822297338808e-21,   4.064697906823084e-01,  -1.585850430358967e-02,   3.396438798574494e-04,  -2.230803474618222e-06,  -1.289095570658453e-07,
   4.939145747856745e-09,  -4.209087248786643e-11,  -2.776779895871462e-12,   1.177452331373883e-13,  -1.068382266513273e-15,  -7.371825579999809e-17,   3.049234679380494e-18,
  -1.984302451490276e-20,  -2.027151361918498e-21,   4.065374424672478e-01,  -1.585981304375065e-02,   3.394885993684204e-04,  -2.221004267656057e-06,  -1.290296971876805e-07,
   4.927393335532272e-09,  -4.144231498436342e-11,  -2.783808143757780e-12,   1.170763236102148e-13,  -1.035803023215345e-15,  -7.393527656660571e-17,   3.017405649724401e-18,
  -1.859115105443624e-20,  -2.032094473176598e-21,   4.066031076819376e-01,  -1.586108168460514e-02,   3.393378111461067e-04,  -2.211498887687065e-06,  -1.291457105433785e-07,
   4.915975173716571e-09,  -4.081390394649099e-11,  -2.790556854429067e-12,   1.164263685743753e-13,  -1.004287474560102e-15,  -7.414074859153210e-17,   2.986485219887465e-18,
  -1.738300640594451e-20,  -2.036589355988248e-21,   4.066559995825474e-01,  -1.586210235206183e-02,   3.392163062475582e-04,  -2.203846867940175e-06,  -1.292387280792266e-07,
   4.906770354880427e-09,  -4.030852250656963e-11,  -2.795940476556219e-12,   1.159023571748167e-13,  -9.789791030709682e-16,  -7.430255510727293e-17,   2.961561436781877e-18,
  -1.641486706136112e-20,  -2.039993827236184e-21,   4.066909461107138e-01,  -1.586277613844604e-02,   3.391360024107950e-04,  -2.198793189988218e-06,  -1.292999765215419e-07,
   4.900684810282776e-09,  -3.997499587661818e-11,  -2.799471945548718e-12,   1.155558985197173e-13,  -9.622950341152875e-16,  -7.440765802798664e-17,   2.945085301863279e-18,
  -1.577764838383546e-20,  -2.042137868305348e-21,   4.067088917433277e-01,  -1.586312195825708e-02,   3.390947577430904e-04,  -2.196198701310186e-06,  -1.293313638025870e-07,
   4.897558616857334e-09,  -3.980384404819088e-11,  -2.801277513074234e-12,   1.153779137065967e-13,  -9.537391077862961e-16,  -7.446107287899088e-17,   2.936621923765373e-18,
  -1.545118263539882e-20,  -2.043206383498270e-21,   4.067151377128793e-01,  -1.586324229189705e-02,   3.390804013945427e-04,  -2.195295795813039e-06,  -1.293422778141531e-07,
   4.896470361681600e-09,  -3.974429379494831e-11,  -2.801904682871741e-12,   1.153159546837591e-13,  -9.507630724025545e-16,  -7.447957526543421e-17,   2.933675838757811e-18,
  -1.533767687725314e-20,  -2.043573116221022e-21,   4.067161288540502e-01,  -1.586326138566407e-02,   3.390781232034808e-04,  -2.195152523319770e-06,  -1.293440092134311e-07,
   4.896297663224388e-09,  -3.973484497303816e-11,  -2.802004145592107e-12,   1.153061221768641e-13,  -9.502909083497913e-16,  -7.448250710942376e-17,   2.933208320128836e-18,
  -1.531967094623851e-20,  -2.043631066211682e-21,   9.707304298873705e-01,  -2.381954247951500e-02,   1.088992601670685e-05,   9.033119413274904e-06,  -5.521629489535623e-09,
  -6.209992705329969e-09,   2.256554744919615e-12,   5.209334353131828e-12,  -1.290302237784179e-16,  -4.901807499732777e-15,   1.928502648284734e-18,   4.631063483268454e-18,
  -3.572092378965873e-21,  -4.209807403091124e-21,   9.707314446173630e-01,  -2.381702211253159e-02,   1.088683800633032e-05,   9.027381414249563e-06,  -5.518458187512588e-09,
  -6.199989315031438e-09,   2.256368296354082e-12,   5.193379866444230e-12,  -1.215607285024321e-16,  -4.879041810213618e-15,   1.907593791024493e-18,   4.602163253461353e-18,
  -3.546105243851283e-21,  -4.175206118228596e-21,   9.707332348911958e-01,  -2.381257618281773e-02,   1.088139061326420e-05,   9.017264171744220e-06,  -5.512862529216685e-09,
  -6.182363423748193e-09,   2.256054844751399e-12,   5.165289577902695e-12,  -1.084513586215000e-16,  -4.838990634895003e-15,   1.870828754511669e-18,   4.551369776270908e-18,
  -3.500409864191002e-21,  -4.114470082628838e-21,   9.707353993118886e-01,  -2.380720232825268e-02,   1.087480603940913e-05,   9.005043149318599e-06,  -5.506096450126614e-09,
  -6.161092991175680e-09,   2.255702210182107e-12,   5.131427404653259e-12,  -9.271956976345332e-17,  -4.790763071658445e-15,   1.826591442514705e-18,   4.490291943448190e-18,
  -3.445425263961539e-21,  -4.041567854955409e-21,   9.707375000778130e-01,  -2.380198779727514e-02,   1.086841643775933e-05,   8.993192637643913e-06,  -5.499528305067147e-09,
  -6.140488950068490e-09,   2.255387388437835e-12,   5.098664164818603e-12,  -7.757291234773480e-17,  -4.744156174171112e-15,   1.783875648832870e-18,   4.431355346416433e-18,
  -3.392329504858742e-21,  -3.971358279458290e-21,   9.707391921293722e-01,  -2.379778869587125e-02,   1.086327091251617e-05,   8.983655641403235e-06,  -5.494237259444984e-09,
  -6.123922732286493e-09,   2.255153391189817e-12,   5.072348834059215e-12,  -6.546060665506374e-17,  -4.706761353119844e-15,   1.749627968912699e-18,   4.384131228201195e-18,
  -3.349757720757164e-21,  -3.915199181288282e-21,   9.707403100609452e-01,  -2.379501481532858e-02,   1.085987174922797e-05,   8.977358470584016e-06,  -5.490741108055052e-09,
  -6.112991778111147e-09,   2.255008339075328e-12,   5.054998394528468e-12,  -5.750079469731055e-17,  -4.682125293165713e-15,   1.727077623151876e-18,   4.353050492976266e-18,
  -3.321725357086290e-21,  -3.878285574642433e-21,   9.707408841271671e-01,  -2.379359054562125e-02,   1.085812639708108e-05,   8.974126026554102e-06,  -5.488945690027091e-09,
  -6.107383062632492e-09,   2.254936799350329e-12,   5.046099929569042e-12,  -5.342656787290026e-17,  -4.669496268382029e-15,   1.715521613189113e-18,   4.337127336293444e-18,
  -3.307359730802026e-21,  -3.859388880222593e-21,   9.707410839289882e-01,  -2.379309485540664e-02,   1.085751895599378e-05,   8.973001176275852e-06,  -5.488320781920519e-09,
  -6.105431669916689e-09,   2.254912368474374e-12,   5.043004616948254e-12,  -5.201064586397283e-17,  -4.665104241904706e-15,   1.711503362141985e-18,   4.331591222631881e-18,
  -3.302364465943266e-21,  -3.852821280495326e-21,   9.707411156344444e-01,  -2.379301619809037e-02,   1.085742256558161e-05,   8.972822689015143e-06,  -5.488221617778706e-09,
  -6.105122047411147e-09,   2.254908513890247e-12,   5.042513522664790e-12,  -5.178606056514931e-17,  -4.664407459624870e-15,   1.710865907253677e-18,   4.330713006425806e-18,
  -3.301572015040048e-21,  -3.851779546731065e-21,   1.530949493694226e+00,  -1.666618010844645e-02,  -3.154550723575571e-04,  -1.168553645572575e-06,   1.307694556203931e-07,
   3.960418982978130e-09,   1.348693842235375e-11,  -2.571505446205597e-12,  -8.149978314157557e-14,  -2.038406093765769e-16,   6.576778819516050e-17,   1.948157818818799e-18,
  -7.024948223830852e-21,  -1.709019627290568e-21,   1.530920067688019e+00,  -1.666649584504190e-02,  -3.153814228055715e-04,  -1.164883385275343e-06,   1.307859676792981e-07,
   3.955349886925439e-09,   1.327868743619872e-11,  -2.571945843726342e-12,  -8.122420584053501e-14,  -1.942715255706082e-16,   6.571131594396031e-17,   1.935886091513469e-18,
  -7.309719458897214e-21,  -1.705030219801854e-21,   1.530868150660210e+00,  -1.666705213542502e-02,  -3.152514600342672e-04,  -1.158411018537626e-06,   1.308148676118104e-07,
   3.946404803267929e-09,   1.291181223406973e-11,  -2.572697024868711e-12,  -8.073815035025251e-14,  -1.774379344822772e-16,   6.561026825436599e-17,   1.914257048088128e-18,
  -7.809393518749284e-21,  -1.697923973903410e-21,   1.530805381623519e+00,  -1.666772339000621e-02,  -3.150942958371596e-04,  -1.150591154415703e-06,   1.308494120249911e-07,
   3.935587344995913e-09,   1.246918328872849e-11,  -2.573561283116094e-12,  -8.015075963542380e-14,  -1.571698178303144e-16,   6.548570024497817e-17,   1.888145210414820e-18,
  -8.408822050543815e-21,  -1.689217786479293e-21,   1.530744456570067e+00,  -1.666837354851208e-02,  -3.149417112646387e-04,  -1.143006667903854e-06,   1.308825270785907e-07,
   3.925084966366934e-09,   1.204053405229356e-11,  -2.574354254348996e-12,  -7.958090445411653e-14,  -1.375851471462087e-16,   6.536229167951357e-17,   1.862840854331208e-18,
  -8.985737942676886e-21,  -1.680648388814536e-21,   1.530695383333749e+00,  -1.666889624514097e-02,  -3.148187823767010e-04,  -1.136901649819283e-06,   1.309089035726688e-07,
   3.916623711622782e-09,   1.169596989182481e-11,  -2.574960163428055e-12,  -7.912210708595819e-14,  -1.218733175355273e-16,   6.526110700871704e-17,   1.842488161090433e-18,
  -9.446918832484355e-21,  -1.673661450753505e-21,   1.530662960136076e+00,  -1.666924111370049e-02,  -3.147375489042298e-04,  -1.132869984211026e-06,   1.309261856931755e-07,
   3.911032344827510e-09,   1.146865518149017e-11,  -2.575344464276252e-12,  -7.881907559748997e-14,  -1.115231794240360e-16,   6.519338364298891e-17,   1.829055308935019e-18,
  -9.749911218826069e-21,  -1.669003985400024e-21,   1.530646310362117e+00,  -1.666941805942026e-02,  -3.146958303195167e-04,  -1.130800279927323e-06,   1.309350154642987e-07,
   3.908160813518458e-09,   1.135203172056273e-11,  -2.575536857809878e-12,  -7.866349600620125e-14,  -1.062177662063097e-16,   6.515833851065810e-17,   1.822161817018523e-18,
  -9.904972384887250e-21,  -1.666599651966231e-21,   1.530640515429259e+00,  -1.666947962140513e-02,  -3.146813095760517e-04,  -1.130080019627235e-06,   1.309380815184858e-07,
   3.907161335511690e-09,   1.131145792722515e-11,  -2.575603032629802e-12,  -7.860935174597731e-14,  -1.043727406250853e-16,   6.514609845887159e-17,   1.819763259156330e-18,
  -9.958856939150439e-21,  -1.665760816706362e-21,   1.530639595861457e+00,  -1.666948938922936e-02,  -3.146790053241821e-04,  -1.129965729897454e-06,   1.309385677159615e-07,
   3.907002731397548e-09,   1.130502028282318e-11,  -2.575613496194983e-12,  -7.860076011329624e-14,  -1.040800350967489e-16,   6.514415412574429e-17,   1.819382678365892e-18,
  -9.967403598676047e-21,  -1.665627610977674e-21,   1.905597691968813e+00,  -4.100455970462034e-03,  -1.274735701806253e-04,  -3.285775914631926e-06,  -7.132550502961772e-08,
  -1.226784912967634e-09,  -1.215087740672689e-11,   1.828798211497287e-13,   1.472588339727449e-14,   5.074888691173667e-16,   1.299863421009435e-17,   2.096598787279817e-19,
  -8.956054257375399e-22,  -1.452231827844670e-22,   1.905585660615514e+00,  -4.101384131856741e-03,  -1.275137842242585e-04,  -3.286922735294015e-06,  -7.134211995160302e-08,
  -1.226397137883146e-09,  -1.211109520923804e-11,   1.846194666143679e-13,   1.478048068002207e-14,   5.085264439698089e-16,   1.299141376705493e-17,   2.085498809657377e-19,
  -9.316502415472087e-22,  -1.460923110493476e-22,   1.905564428026905e+00,  -4.103022148910292e-03,  -1.275847500242667e-04,  -3.288946014296007e-06,  -7.137139131770937e-08,
  -1.225710104996262e-09,  -1.204078252732860e-11,   1.876919132883408e-13,   1.487679219846355e-14,   5.103525586540932e-16,   1.297849044388353e-17,   2.065860891088276e-19,
  -9.953801810456601e-22,  -1.476271297227391e-22,   1.905538748107938e+00,  -4.105003302753933e-03,  -1.276705753799300e-04,  -3.291392064904046e-06,  -7.140670816920019e-08,
  -1.224874564204079e-09,  -1.195556130281696e-11,   1.914119393496111e-13,   1.499320793295533e-14,   5.125526830404081e-16,   1.296255140094586e-17,   2.042026082419935e-19,
  -1.072661396412441e-21,  -1.494851078431828e-22,   1.905513812993132e+00,  -4.106927039721348e-03,  -1.277539064848087e-04,  -3.293766102102936e-06,  -7.144091094442191e-08,
  -1.224058433230791e-09,  -1.187262232465527e-11,   1.950282816772551e-13,   1.510617444704302e-14,   5.146800945989490e-16,   1.294675074738851e-17,   2.018795002439208e-19,
  -1.147912662023682e-21,  -1.512909119978257e-22,   1.905493721652146e+00,  -4.108477111842883e-03,  -1.278210464807677e-04,  -3.295678202789473e-06,  -7.146840526825556e-08,
  -1.223397381760063e-09,  -1.180565899063898e-11,   1.979451383677693e-13,   1.519714411717755e-14,   5.163878553997745e-16,   1.293378703845635e-17,   2.000013914288437e-19,
  -1.208697042617728e-21,  -1.527471251745273e-22,   1.905480443724254e+00,  -4.109501535716772e-03,  -1.278654160605442e-04,  -3.296941491997716e-06,  -7.148654411296324e-08,
  -1.222958813341316e-09,  -1.176133798458761e-11,   1.998742941126513e-13,   1.525723811502386e-14,   5.175133435550815e-16,   1.292510567464557e-17,   1.987571162334343e-19,
  -1.248941886941204e-21,  -1.537100770852055e-22,   1.905473624276773e+00,  -4.110027677054802e-03,  -1.278882034047946e-04,  -3.297590191693997e-06,  -7.149585032845655e-08,
  -1.222733043751089e-09,  -1.173855450778349e-11,   2.008655480362972e-13,   1.528809392420461e-14,   5.180904159942893e-16,   1.292061172594464e-17,   1.981171145995095e-19,
  -1.269634123149143e-21,  -1.542048164681838e-22,   1.905471250610711e+00,  -4.110210813430854e-03,  -1.278961349781133e-04,  -3.297815968040162e-06,  -7.149908801663510e-08,
  -1.222654375995376e-09,  -1.173062092518296e-11,   2.012106489717040e-13,   1.529883271897672e-14,   5.182911248399713e-16,   1.291904188693490e-17,   1.978941958576670e-19,
  -1.276840155829901e-21,  -1.543770494226701e-22,   1.905470873938092e+00,  -4.110239875034407e-03,  -1.278973936204553e-04,  -3.297851795184526e-06,  -7.149960172548026e-08,
  -1.222641888395207e-09,  -1.172936180470836e-11,   2.012654158154575e-13,   1.530053677729362e-14,   5.183229676125882e-16,   1.291879250544232e-17,   1.978588141122621e-19,
  -1.277983839545206e-21,  -1.544043820477646e-22,   4.052464473681925e-02,  -1.805677058033737e-03,   5.911372365803567e-05,  -1.674526579115007e-06,   4.281583069439600e-08,
  -9.993426488218349e-10,   2.103447042837597e-11,  -3.853591200599369e-13,   5.375655947187746e-15,  -2.535490797608548e-17,  -1.988959692295966e-18,   1.159315184194328e-19,
  -3.528208309761281e-21,   6.253399475512228e-23,   4.053023532583362e-02,  -1.806151341625578e-03,   5.913797549940848e-05,  -1.675469849742264e-06,   4.284557468608093e-08,
  -1.000102391348324e-09,   2.104839126530294e-11,  -3.854285650381792e-13,   5.366550613085976e-15,  -2.473899614992415e-17,  -2.011126797021271e-18,   1.163965558650035e-19,
  -3.535452986481434e-21,   6.267565692773077e-23,   4.054010187678905e-02,  -1.806988439294713e-03,   5.918078189665400e-05,  -1.677134845012454e-06,   4.289807426784760e-08,
  -1.001443072181006e-09,   2.107293493515532e-11,  -3.855493984352447e-13,   5.350407781301832e-15,  -2.365025266684794e-17,  -2.050277554595372e-18,   1.172179541437312e-19,
  -3.548246242414788e-21,   6.292490074527014e-23,   4.055203580261644e-02,  -1.808001036510347e-03,   5.923256711460481e-05,  -1.679149163073524e-06,   4.296158431660800e-08,
  -1.003064411842257e-09,   2.110257941810326e-11,  -3.856926034123915e-13,   5.330757467544979e-15,  -2.233039255040850e-17,  -2.097681426845278e-18,   1.182126140003057e-19,
  -3.563732642013943e-21,   6.322504888365323e-23,   4.056362438954016e-02,  -1.808984435694931e-03,   5.928286367700335e-05,  -1.681105662856540e-06,   4.302326701970286e-08,
  -1.004638560208977e-09,   2.113132203754424e-11,  -3.858285743264989e-13,   5.311544798644351e-15,  -2.104559469807624e-17,  -2.143765627325317e-18,   1.191796918188270e-19,
  -3.578783708258805e-21,   6.351511572613075e-23,   4.057296239699780e-02,  -1.809776926896124e-03,   5.932339939849463e-05,  -1.682682535025448e-06,   4.307297802780934e-08,
  -1.005906800858947e-09,   2.115445101577050e-11,  -3.859359220909855e-13,   5.295969454321603e-15,  -2.000806803243771e-17,  -2.180937305903906e-18,   1.199598142627689e-19,
  -3.590920713879521e-21,   6.374784066363464e-23,   4.057913395768709e-02,  -1.810300726920900e-03,   5.935019323421505e-05,  -1.683724867084281e-06,   4.310583607312853e-08,
  -1.006744893282380e-09,   2.116972160737965e-11,  -3.860057826254491e-13,   5.285629594145803e-15,  -1.932125896419012e-17,  -2.205522637426754e-18,   1.204758217598796e-19,
  -3.598946449347226e-21,   6.390115268928067e-23,   4.058230371181792e-02,  -1.810569765349458e-03,   5.936395579639514e-05,  -1.684260266741453e-06,   4.312271331101756e-08,
  -1.007175312745889e-09,   2.117755987371365e-11,  -3.860413272449422e-13,   5.280304745516369e-15,  -1.896816909504311e-17,  -2.218155480988987e-18,   1.207409757881472e-19,
  -3.603069829177542e-21,   6.397974007324370e-23,   4.058340703147337e-02,  -1.810663413333806e-03,   5.936874640339671e-05,  -1.684446635369230e-06,   4.312858807517500e-08,
  -1.007325127178184e-09,   2.118028743034408e-11,  -3.860536459778033e-13,   5.278449020732513e-15,  -1.884521233227236e-17,  -2.222553588336853e-18,   1.208332904453433e-19,
  -3.604505291100402e-21,   6.400706986875768e-23,   4.058358211584694e-02,  -1.810678274297051e-03,   5.936950662674698e-05,  -1.684476210352293e-06,   4.312952034245320e-08,
  -1.007348900807294e-09,   2.118072022638982e-11,  -3.860555982793211e-13,   5.278154430601314e-15,  -1.882569791018621e-17,  -2.223251561072060e-18,   1.208479407140005e-19,
  -3.604733092482807e-21,   6.401140562509527e-23,   3.481818161748288e-01,  -1.327368975882427e-02,   3.035963519555314e-04,  -3.586099915517462e-06,  -4.424074062621513e-08,
   3.371828073796868e-09,  -7.593778585456133e-11,   5.813545781758267e-14,   5.388744958502725e-14,  -1.867054074077516e-15,   1.939108656369653e-17,   9.679213649538385e-19,
  -4.474832209254516e-20,   5.445139674693434e-22,   3.482102271181611e-01,  -1.327468721300066e-02,   3.035708742907813e-04,  -3.582938789369873e-06,  -4.434583528779492e-08,
   3.371844733650344e-09,  -7.579484713602050e-11,   5.196831305820221e-14,   5.396059735368661e-14,  -1.861928074989575e-15,   1.912077382604396e-17,   9.714636362586982e-19,
  -4.460817013986840e-20,   5.365270244095696e-22,   3.482603566632455e-01,  -1.327644651382861e-02,   3.035258708882556e-04,  -3.577360949791635e-06,  -4.453111248131778e-08,
   3.371864325440658e-09,  -7.554247864201525e-11,   4.110045191328865e-14,   5.408874643335754e-14,  -1.852868768712740e-15,   1.864451964186703e-17,   9.776667552996298e-19,
  -4.435978997497082e-20,   5.224491720975530e-22,   3.483209704127969e-01,  -1.327857264683614e-02,   3.034713710765266e-04,  -3.570616201052604e-06,  -4.475487191189336e-08,
   3.371871313676541e-09,  -7.523705604621852e-11,   2.798309337045303e-14,   5.424213646214853e-14,  -1.841889740530186e-15,   1.806985401834884e-17,   9.850870910774744e-19,
  -4.405761481481181e-20,   5.054524256262187e-22,   3.483798095946299e-01,  -1.328063536946555e-02,   3.034183786193515e-04,  -3.564068558311711e-06,  -4.497180061614165e-08,
   3.371860627111154e-09,  -7.494029079332357e-11,   1.527433856248357e-14,   5.438940376336211e-14,  -1.831206092141787e-15,   1.751326711188155e-17,   9.922063652326072e-19,
  -4.376236354255565e-20,   4.889803310926100e-22,   3.484272070949403e-01,  -1.328229614737000e-02,   3.033756277411414e-04,  -3.558793897543421e-06,  -4.514634546789115e-08,
   3.371839514574265e-09,  -7.470103097741397e-11,   5.054517649219873e-15,   5.450686609260496e-14,  -1.822581408083904e-15,   1.706581443257906e-17,   9.978812478521089e-19,
  -4.352315713478707e-20,   4.757310531572013e-22,   3.484585252549773e-01,  -1.328339310710916e-02,   3.033473489503760e-04,  -3.555308514687045e-06,  -4.526157868913276e-08,
   3.371819447382812e-09,  -7.454284001184545e-11,  -1.689643761881787e-15,   5.458390876385753e-14,  -1.816873569155012e-15,   1.677060062174844e-17,   1.001601603060021e-18,
  -4.336443358857535e-20,   4.669862997118424e-22,   3.484746082376434e-01,  -1.328395630841767e-02,   3.033328172349506e-04,  -3.553518610093576e-06,  -4.532072462815380e-08,
   3.371807251577295e-09,  -7.446157292784677e-11,  -5.150334528711691e-15,   5.462329637367585e-14,  -1.813939609311077e-15,   1.661913518025788e-17,   1.003503063636192e-18,
  -4.328271805029983e-20,   4.624986122190964e-22,   3.484802060047745e-01,  -1.328415231350183e-02,   3.033277578735010e-04,  -3.552895618441904e-06,  -4.534130584511335e-08,
   3.371802705878301e-09,  -7.443328265432391e-11,  -6.354420255923455e-15,   5.463697734743895e-14,  -1.812917986983637e-15,   1.656643871457233e-17,   1.004163432978489e-18,
  -4.325424389582187e-20,   4.609371373418824e-22,   3.484810942903679e-01,  -1.328418341575113e-02,   3.033269549529852e-04,  -3.552796758296540e-06,  -4.534457156014927e-08,
   3.371801970258930e-09,  -7.442879316310888e-11,  -6.545471215159802e-15,   5.463914698893636e-14,  -1.812755849160675e-15,   1.655807757835995e-17,   1.004268155603932e-18,
  -4.324972390704584e-20,   4.606893768484833e-22,   8.762987667597621e-01,  -2.330951614609887e-02,   1.147993003879607e-04,   8.001693864134081e-06,  -1.180270895002121e-07,
  -4.559115745354007e-09,   1.238014178405270e-10,   2.762329288409746e-12,  -1.318356155577840e-13,  -1.496704230443268e-15,   1.363466062820125e-16,   4.489473721501926e-19,
  -1.275966068815396e-19,   4.767530488911017e-22,   8.763093978447766e-01,  -2.330728056084649e-02,   1.147338686135292e-04,   7.997464681438554e-06,  -1.178569353885527e-07,
  -4.553756613058088e-09,   1.234666640337779e-10,   2.757341537197019e-12,  -1.312843025501975e-13,  -1.494279993280783e-15,   1.355971680531812e-16,   4.518475967384534e-19,
  -1.267228746361342e-19,   4.659012352830491e-22,   8.763281516880327e-01,  -2.330333679467925e-02,   1.146184901081447e-04,   7.990006282258960e-06,  -1.175570740748315e-07,
  -4.544308291523577e-09,   1.228771478512561e-10,   2.748547301749587e-12,  -1.303140375819610e-13,  -1.489990820217350e-15,   1.342790988354096e-16,   4.569027262906059e-19,
  -1.251874162636612e-19,   4.469136845558006e-22,   8.763508207298089e-01,  -2.329856958534519e-02,   1.144791041737240e-04,   7.980994425158146e-06,  -1.171951226913720e-07,
  -4.532896831058065e-09,   1.221662765205089e-10,   2.737924714582079e-12,  -1.291450960014281e-13,  -1.484784756828483e-15,   1.326926308694804e-16,   4.629097513936319e-19,
  -1.233413533333981e-19,   4.242259465877306e-22,   8.763728187502553e-01,  -2.329394337224333e-02,   1.143439277409437e-04,   7.972253110386511e-06,  -1.168444199235928e-07,
  -4.521832963615470e-09,   1.214782415369906e-10,   2.727624556304122e-12,  -1.280148116600471e-13,  -1.479710551743890e-15,   1.311601905966899e-16,   4.686314029478483e-19,
  -1.215603115194709e-19,   4.024839793796757e-22,   8.763905338444786e-01,  -2.329021778063219e-02,   1.142351294338717e-04,   7.965216404677007e-06,  -1.165623799941902e-07,
  -4.512930209695069e-09,   1.209254469229051e-10,   2.719335546258071e-12,  -1.271074873168813e-13,  -1.475608486410308e-15,   1.299311569292467e-16,   4.731625449262413e-19,
  -1.201334359415876e-19,   3.851701127138458e-22,   8.764022366166431e-01,  -2.328775657587445e-02,   1.141632854257978e-04,   7.960569211521894e-06,  -1.163762485409939e-07,
  -4.507052397362778e-09,   1.205608921484565e-10,   2.713862565445438e-12,  -1.265095155538741e-13,  -1.472890950634146e-15,   1.291217089866911e-16,   4.761186099680883e-19,
  -1.191944408552830e-19,   3.738273125661439e-22,   8.764082456082408e-01,  -2.328649281491517e-02,   1.141264049177785e-04,   7.958183439631458e-06,  -1.162807338973692e-07,
  -4.504035395574527e-09,   1.203738988496709e-10,   2.711053243665117e-12,  -1.262029138246497e-13,  -1.471493225635550e-15,   1.287068445604051e-16,   4.776249775424667e-19,
  -1.187134125021557e-19,   3.680323876195267e-22,   8.764103369428753e-01,  -2.328605298085938e-02,   1.141135706790163e-04,   7.957353174686829e-06,  -1.162475007288673e-07,
  -4.502985544968893e-09,   1.203088495997802e-10,   2.710075643100566e-12,  -1.260962754899748e-13,  -1.471006395089605e-15,   1.285625785244703e-16,   4.781474221318250e-19,
  -1.185461754639498e-19,   3.660201986917265e-22,   8.764106688017628e-01,  -2.328598318665352e-02,   1.141115341740919e-04,   7.957221428999287e-06,  -1.162422276322376e-07,
  -4.502818959742531e-09,   1.202985288635495e-10,   2.709920521308332e-12,  -1.260793571186945e-13,  -1.470929125690620e-15,   1.285396917230135e-16,   4.782302386591447e-19,
  -1.185196462301045e-19,   3.657011190808599e-22,   1.459206804671969e+00,  -1.920435061435629e-02,  -3.143324274398714e-04,   1.545351219745251e-06,   2.059092862643320e-07,
   3.140578108778104e-09,  -9.163194796300341e-11,  -4.642383955362289e-12,  -2.445536768257461e-14,   3.664805403054196e-15,   1.058589370570900e-16,  -1.048553495659771e-18,
  -1.178452522413233e-19,  -1.552503592782811e-21,   1.459177567088229e+00,  -1.920390589503222e-02,  -3.142173350109061e-04,   1.548220484570061e-06,   2.057797861227316e-07,
   3.131632406196348e-09,  -9.168745078991362e-11,  -4.630167515248996e-12,  -2.403120027326882e-14,   3.659021012215580e-15,   1.051572476440500e-16,  -1.058482636358753e-18,
  -1.172517611489024e-19,  -1.526350283450615e-21,   1.459125985595794e+00,  -1.920312053767357e-02,  -3.140143119751285e-04,   1.553276588880770e-06,   2.055512210185119e-07,
   3.115867050949250e-09,  -9.178449470206328e-11,  -4.608627558591403e-12,  -2.328513274579028e-14,   3.648774181751192e-15,   1.039220872523962e-16,  -1.075850581037711e-18,
  -1.162048701513465e-19,  -1.480447872065740e-21,   1.459063627507885e+00,  -1.920216977964063e-02,  -3.137689155920006e-04,   1.559378970367453e-06,   2.052747359219661e-07,
   3.096836608097985e-09,  -9.190032427396820e-11,  -4.582608813671642e-12,  -2.238703535023629e-14,   3.636315523205427e-15,   1.024336006872798e-16,  -1.096593597403677e-18,
  -1.149395569004770e-19,  -1.425359805202214e-21,   1.459003106854037e+00,  -1.920124565430601e-02,  -3.135307950717348e-04,   1.565291012389764e-06,   2.050062233229113e-07,
   3.078396920231127e-09,  -9.201118547476965e-11,  -4.557379263481588e-12,  -2.151941582335615e-14,   3.624150128024226e-15,   1.009939243703424e-16,  -1.116461136466242e-18,
  -1.137118776536552e-19,  -1.372317307861359e-21,   1.458954363304116e+00,  -1.920050037086042e-02,  -3.133390442704925e-04,   1.570045055968522e-06,   2.047898379823802e-07,
   3.063567019972652e-09,  -9.209936188593476e-11,  -4.537075507885870e-12,  -2.082350294827888e-14,   3.614299541253545e-15,   9.983795081771755e-17,  -1.132274016694965e-18,
  -1.127233783898192e-19,  -1.329898479951171e-21,   1.458922159869249e+00,  -1.920000749967382e-02,  -3.132123759714718e-04,   1.573182226077618e-06,   2.046468178905584e-07,
   3.053779857749254e-09,  -9.215707431498046e-11,  -4.523669379043288e-12,  -2.036513721165725e-14,   3.607765974866351e-15,   9.907596950459235e-17,  -1.142629162348948e-18,
  -1.120704527771401e-19,  -1.302021035206243e-21,   1.458905623545020e+00,  -1.919975426275366e-02,  -3.131473372493262e-04,   1.574792009611945e-06,   2.045733589909683e-07,
   3.048757444456588e-09,  -9.218654166311377e-11,  -4.516787860106256e-12,  -2.013020197473613e-14,   3.604403140095230e-15,   9.868523242221720e-17,  -1.147918116384776e-18,
  -1.117352260164640e-19,  -1.287751612431884e-21,   1.458899868193446e+00,  -1.919966610159344e-02,  -3.131247017590428e-04,   1.575352102075661e-06,   2.045477891636686e-07,
   3.047009946435759e-09,  -9.219677088423626e-11,  -4.514393189536593e-12,  -2.004850340064384e-14,   3.603231477882172e-15,   9.854932461631121e-17,  -1.149754389742648e-18,
  -1.116185604942662e-19,  -1.282792481308958e-21,   1.458898954911114e+00,  -1.919965211069494e-02,  -3.131211099054764e-04,   1.575440971189606e-06,   2.045437314996050e-07,
   3.046732670996957e-09,  -9.219839283188936e-11,  -4.514013212286674e-12,  -2.003554241655131e-14,   3.603045494469847e-15,   9.852776227775921e-17,  -1.150045563007150e-18,
  -1.116000479143923e-19,  -1.282005890084472e-21,   1.886876611029795e+00,  -5.299316565101215e-03,  -1.746035204770095e-04,  -4.636160549842644e-06,  -9.800139668587846e-08,
  -1.382827457711368e-09,   3.123810015627366e-12,   1.062646324083716e-12,   4.419890614978202e-14,   1.161475014306068e-15,   1.721505411425033e-17,  -1.491533344475197e-19,
  -1.778991673103842e-20,  -5.829688424709586e-22,   1.886860131388445e+00,  -5.300624980980871e-03,  -1.746586127456211e-04,  -4.637438776612424e-06,  -9.799561289841874e-08,
  -1.380673482360323e-09,   3.241243716343056e-12,   1.066541172808792e-12,   4.426781635512235e-14,   1.160537061370690e-15,   1.710022924868842e-17,  -1.534835424093183e-19,
  -1.789282335243045e-20,  -5.842250271712935e-22,   1.886831048606845e+00,  -5.302933990510247e-03,  -1.747558209481405e-04,  -4.639692567097406e-06,  -9.798527250318098e-08,
  -1.376866537506705e-09,   3.448602129006755e-12,   1.073410996692815e-12,   4.438901150077696e-14,   1.158863809049564e-15,   1.689710429878947e-17,  -1.611313845368657e-19,
  -1.807413549354554e-20,  -5.864160094604237e-22,   1.886795874243673e+00,  -5.305726562222756e-03,  -1.748733610350746e-04,  -4.642415039659937e-06,  -9.797253881049337e-08,
  -1.372252534066656e-09,   3.699588447835442e-12,   1.081713426564414e-12,   4.453488214542085e-14,   1.156809408614951e-15,   1.665060684131706e-17,  -1.703912754625587e-19,
  -1.829291761898350e-20,  -5.890216175652570e-22,   1.886761720090570e+00,  -5.308438058133423e-03,  -1.749874615113492e-04,  -4.645054996007263e-06,  -9.795993619065464e-08,
  -1.367762237821063e-09,   3.943498807021855e-12,   1.089768384674898e-12,   4.467577740495070e-14,   1.154782454215159e-15,   1.641039463994645e-17,  -1.793930893213278e-19,
  -1.850481669411014e-20,  -5.915050991973378e-22,   1.886734200582467e+00,  -5.310622773187073e-03,  -1.750793754600056e-04,  -4.647179577529797e-06,  -9.794961092857318e-08,
  -1.364136962104380e-09,   4.140173564369828e-12,   1.096253814521578e-12,   4.478876853657263e-14,   1.153126206423614e-15,   1.621622684930262e-17,  -1.866536745478940e-19,
  -1.867516354081229e-20,  -5.934726747458634e-22,   1.886716013554239e+00,  -5.312066574653752e-03,  -1.751401086294380e-04,  -4.648582417612384e-06,  -9.794270355328002e-08,
  -1.361737552378895e-09,   4.270222492650983e-12,   1.100537525438980e-12,   4.486317981241311e-14,   1.152020342789751e-15,   1.608760340976759e-17,  -1.914556302410554e-19,
  -1.878754938758610e-20,  -5.947565628941089e-22,   1.886706672832460e+00,  -5.312808091646162e-03,  -1.751712974176177e-04,  -4.649302519524845e-06,  -9.793913010557635e-08,
  -1.360504137247082e-09,   4.337036551063917e-12,   1.102736873461355e-12,   4.490131576834983e-14,   1.151448888052716e-15,   1.602144997809851e-17,  -1.939229828551918e-19,
  -1.884520997287132e-20,  -5.954108642632911e-22,   1.886703421579344e+00,  -5.313066192316478e-03,  -1.751821528651006e-04,  -4.649553106051158e-06,  -9.793788216572490e-08,
  -1.360074644249054e-09,   4.360296203547669e-12,   1.103502290077600e-12,   4.491457694376872e-14,   1.151249424157563e-15,   1.599840889381418e-17,  -1.947819767183326e-19,
  -1.886527048818256e-20,  -5.956377970366514e-22,   1.886702905644110e+00,  -5.313107149760259e-03,  -1.751838754705556e-04,  -4.649592868234580e-06,  -9.793768393694232e-08,
  -1.360006480531511e-09,   4.363987399220037e-12,   1.103623747036938e-12,   4.491668072115483e-14,   1.151217745214417e-15,   1.599475184223771e-17,  -1.949182971302870e-19,
  -1.886845339818042e-20,  -5.956737700107486e-22,   3.413513456422192e-02,  -1.402856278145843e-03,   4.254979448246768e-05,  -1.125272624925971e-06,   2.709879057552907e-08,
  -6.057517404331717e-10,   1.245099956241096e-11,  -2.358755030935210e-13,   3.882173369890810e-15,  -4.263314949200433e-17,   3.575998121760868e-19,   9.413359541451843e-21,
  -1.156008028289216e-21,   3.328529765698143e-23,   3.413915440150612e-02,  -1.403174775442847e-03,   4.256513710373841e-05,  -1.125844441697927e-06,   2.711642061447466e-08,
  -6.062183798629156e-10,   1.246121582941651e-11,  -2.360178381096611e-13,   3.883446821229023e-15,  -4.257508019740733e-17,   3.503075493804296e-19,   9.658117663863648e-21,
  -1.159002077510228e-21,   3.330956414778074e-23,   3.414624864905490e-02,  -1.403736900376200e-03,   4.259221749171416e-05,  -1.126853777766557e-06,   2.714754078589805e-08,
  -6.070419995293690e-10,   1.247924516823025e-11,  -2.362688241384913e-13,   3.885668711595130e-15,  -4.247158856217391e-17,   3.374250544503715e-19,   1.009014499671739e-20,
  -1.164296060356294e-21,   3.335264273341118e-23,   3.415482910384089e-02,  -1.404416852027782e-03,   4.262497718633821e-05,  -1.128074885498903e-06,   2.718519156463711e-08,
  -6.080383161838682e-10,   1.250105079102652e-11,  -2.365720335594507e-13,   3.888312552822406e-15,  -4.234469305110432e-17,   3.218214788878412e-19,   1.061281008767914e-20,
  -1.170716236321826e-21,   3.340517659134183e-23,   3.416316097129878e-02,  -1.405077172147809e-03,   4.265679418686592e-05,  -1.129260952353790e-06,   2.722176316702436e-08,
  -6.090059281187820e-10,   1.252222382422864e-11,  -2.368660825072800e-13,   3.890834185888366e-15,  -4.221966952273063e-17,   3.066466013929499e-19,   1.112047061977854e-20,
  -1.176968332164318e-21,   3.345663854821924e-23,   3.416987452790936e-02,  -1.405609285752443e-03,   4.268243590974966e-05,  -1.130216888620204e-06,   2.725123973512837e-08,
  -6.097857137011143e-10,   1.253928374409358e-11,  -2.371027467458361e-13,   3.892833333087691e-15,  -4.211763663026839e-17,   2.944023974619380e-19,   1.152962709933013e-20,
  -1.182018900592200e-21,   3.349842688783918e-23,   3.417431146725534e-02,  -1.405960979369224e-03,   4.269938457780861e-05,  -1.130848777702147e-06,   2.727072465212645e-08,
  -6.103011240404831e-10,   1.255055818845653e-11,  -2.372590229304758e-13,   3.894138531596367e-15,  -4.204957081981546e-17,   2.863020744923648e-19,   1.180008468337261e-20,
  -1.185363057782427e-21,   3.352620187394376e-23,   3.417659027702174e-02,  -1.406141616364742e-03,   4.270809009940035e-05,  -1.131173352086358e-06,   2.728073335507181e-08,
  -6.105658557858198e-10,   1.255634863258889e-11,  -2.373392448868901e-13,   3.894803923673695e-15,  -4.201441648213111e-17,   2.821392081931833e-19,   1.193900682929438e-20,
  -1.187082554305486e-21,   3.354051571468954e-23,   3.417738347410761e-02,  -1.406204492784541e-03,   4.271112038581756e-05,  -1.131286334175702e-06,   2.728421733651183e-08,
  -6.106580050776932e-10,   1.255836412545875e-11,  -2.373671615520621e-13,   3.895034740767425e-15,  -4.200214896317254e-17,   2.806898125041670e-19,   1.198736461597626e-20,
  -1.187681376934513e-21,   3.354550574330027e-23,   3.417750934529282e-02,  -1.406214470599130e-03,   4.271160126240246e-05,  -1.131304263399609e-06,   2.728477021350912e-08,
  -6.106726282327181e-10,   1.255868396001089e-11,  -2.373715912894560e-13,   3.895071331288294e-15,  -4.200020077048696e-17,   2.804597909594380e-19,   1.199503855217488e-20,
  -1.187776417793531e-21,   3.354629797017690e-23,   2.996610307567064e-01,  -1.102458896946757e-02,   2.582290321352597e-04,  -3.850153724415676e-06,   5.870388520198691e-09,
   1.708389825923943e-09,  -5.888893063760504e-11,   9.070089514672387e-13,   6.003148091368037e-15,  -7.534859843758063e-16,   2.659758848183071e-17,  -3.649442190739581e-19,
  -1.115394050185183e-20,   5.446103723844148e-22,   2.996852453628508e-01,  -1.102566612697763e-02,   2.582318681202670e-04,  -3.848537486578189e-06,   5.787792745481635e-09,
   1.710134241122864e-09,  -5.887091001589918e-11,   9.044214837068226e-13,   6.113036094333001e-15,  -7.552146813276442e-16,   2.652584345606691e-17,  -3.610040880742888e-19,
  -1.121351699251417e-20,   5.438683803693105e-22,   2.997279725775669e-01,  -1.102756641628574e-02,   2.582368345406131e-04,  -3.845684292619703e-06,   5.642072689451798e-09,
   1.713208126104219e-09,  -5.883887924382271e-11,   8.998512251056936e-13,   6.306686751676168e-15,  -7.582485216786342e-16,   2.639895349794976e-17,  -3.540563083652040e-19,
  -1.131819234609135e-20,   5.425418672966982e-22,   2.997796390550915e-01,  -1.102986363181859e-02,   2.582427756808237e-04,  -3.842231936814388e-06,   5.465903260818108e-09,
   1.716917997287227e-09,  -5.879975019991251e-11,   8.943169541764987e-13,   6.540426878072755e-15,  -7.618890003613419e-16,   2.624501581553252e-17,  -3.456629661989347e-19,
  -1.144400115903415e-20,   5.409084625275278e-22,   2.998297962604821e-01,  -1.103209306408571e-02,   2.582484759029097e-04,  -3.838878103305508e-06,   5.294919818128714e-09,
   1.720512031084726e-09,  -5.876134903748571e-11,   8.889361826073815e-13,   6.766892533213452e-15,  -7.653937333622938e-16,   2.609505313082575e-17,  -3.375233081678941e-19,
  -1.156533058390440e-20,   5.392920921879568e-22,   2.998702024541498e-01,  -1.103388858921382e-02,   2.582530196895410e-04,  -3.836174619529693e-06,   5.157205735595765e-09,
   1.723401999253331e-09,  -5.873011628326528e-11,   8.845956575528147e-13,   6.949010712609264e-15,  -7.681960620185582e-16,   2.597387206777865e-17,  -3.309722249136456e-19,
  -1.166249501888213e-20,   5.379680245898594e-22,   2.998969022449590e-01,  -1.103507480684545e-02,   2.582559985267204e-04,  -3.834387384265790e-06,   5.066220476599902e-09,
   1.725309022964486e-09,  -5.870933281410311e-11,   8.817246650396391e-13,   7.069194425997866e-15,  -7.700374948537786e-16,   2.589361567901319e-17,  -3.266464072897128e-19,
  -1.172641656439282e-20,   5.370823810972187e-22,   2.999106138951856e-01,  -1.103568391416505e-02,   2.582575209992082e-04,  -3.833469299602359e-06,   5.019499460017898e-09,
   1.726287561555110e-09,  -5.869861456369764e-11,   8.802493937392533e-13,   7.130865989030440e-15,  -7.709799756716577e-16,   2.585234398759854e-17,  -3.244258327589591e-19,
  -1.175915571958050e-20,   5.366242487160394e-22,   2.999153863653942e-01,  -1.103589590805111e-02,   2.582580497471121e-04,  -3.833149711431203e-06,   5.003238462960880e-09,
   1.726628021992007e-09,  -5.869487682578947e-11,   8.797357722841265e-13,   7.152323611497414e-15,  -7.713075081020925e-16,   2.583797006177989e-17,  -3.236530915542958e-19,
  -1.177053692456167e-20,   5.364642646323504e-22,   2.999161436909153e-01,  -1.103592954801549e-02,   2.582581335969316e-04,  -3.833098995272434e-06,   5.000658099014747e-09,
   1.726682042255366e-09,  -5.869428335874954e-11,   8.796542610019207e-13,   7.155728273609419e-15,  -7.713594589376180e-16,   2.583568869372569e-17,  -3.235304753027125e-19,
  -1.177234230224240e-20,   5.364388523548809e-22,   7.854525985007337e-01,  -2.204493018485526e-02,   1.970535000673223e-04,   5.562686541846086e-06,  -1.757724545961930e-07,
  -1.149520035920406e-09,   1.412211380007856e-10,  -1.325552232017632e-12,  -9.733783827844599e-14,   2.826961920214558e-15,   5.216788168688546e-17,  -3.255308287876286e-18,
  -6.755609678015403e-21,   2.773728838533835e-21,   7.854708759901635e-01,  -2.204336955517284e-02,   1.969557309152138e-04,   5.561588281689852e-06,  -1.755768241452026e-07,
  -1.151985477131619e-09,   1.409701306591284e-10,  -1.316426392867642e-12,  -9.711949345536205e-14,   2.810923804230850e-15,   5.211544914761601e-17,  -3.235963315834334e-18,
  -6.990428767466282e-21,   2.756626720834679e-21,   7.855031195872471e-01,  -2.204061605415629e-02,   1.967833044750337e-04,   5.559648549292190e-06,  -1.752319163347672e-07,
  -1.156321383361976e-09,   1.405276891447018e-10,  -1.300367166698721e-12,  -9.673440959246234e-14,   2.782704434890016e-15,   5.202179045912986e-17,  -3.201929502507295e-18,
  -7.401079048505431e-21,   2.726522239825964e-21,   7.855420964117124e-01,  -2.203728692571194e-02,   1.965749558474127e-04,   5.557299882607245e-06,  -1.748153360481527e-07,
  -1.161539895397349e-09,   1.399934765266144e-10,  -1.281022133295208e-12,  -9.626908697449092e-14,   2.748717627455470e-15,   5.190660499837618e-17,  -3.160946847487547e-18,
  -7.891379569263820e-21,   2.690243314367695e-21,   7.855799213775116e-01,  -2.203405552069965e-02,   1.963728528976371e-04,   5.555016578237113e-06,  -1.744114355072285e-07,
  -1.166580327835003e-09,   1.394757015792136e-10,  -1.262319563722597e-12,  -9.581770339678672e-14,   2.715866246777991e-15,   5.179277730664697e-17,  -3.121340700878720e-18,
  -8.360838396032317e-21,   2.655154134075386e-21,   7.856103833241783e-01,  -2.203145266927823e-02,   1.962101547251316e-04,   5.553174849221387e-06,  -1.740864224172205e-07,
  -1.170622528418148e-09,   1.390591828279656e-10,  -1.247308235118185e-12,  -9.545432315411223e-14,   2.689503389811720e-15,   5.169965190778931e-17,  -3.089562565639519e-18,
  -8.734388291132877e-21,   2.626979865200679e-21,   7.856305074576037e-01,  -2.202973291135659e-02,   1.961027021310783e-04,   5.551956729978359e-06,  -1.738718376167934e-07,
  -1.173284596387511e-09,   1.387842453961218e-10,  -1.237415998901834e-12,  -9.521433057173159e-14,   2.672133017721562e-15,   5.163742195761326e-17,  -3.068626734356848e-18,
  -8.978963173925923e-21,   2.608408457533385e-21,   7.856408407474978e-01,  -2.202884978285722e-02,   1.960475372272800e-04,   5.551330816244406e-06,  -1.737616930927438e-07,
  -1.174648932611002e-09,   1.386431417607162e-10,  -1.232344195311335e-12,  -9.509112101437285e-14,   2.663227859115767e-15,   5.160525012269776e-17,  -3.057894518128290e-18,
  -9.103867556032054e-21,   2.598885279251938e-21,   7.856444371183525e-01,  -2.202854240977485e-02,   1.960283393061733e-04,   5.551112905373741e-06,  -1.737233650421759e-07,
  -1.175123362768754e-09,   1.385940436569969e-10,  -1.230580233233261e-12,  -9.504824288555464e-14,   2.660130780253128e-15,   5.159401847202250e-17,  -3.054162148076970e-18,
  -9.147231002596835e-21,   2.595572900059058e-21,   7.856450078021809e-01,  -2.202849363427399e-02,   1.960252929900268e-04,   5.551078323268682e-06,  -1.737172833242148e-07,
  -1.175198627440044e-09,   1.385862531433705e-10,  -1.230300379655449e-12,  -9.504143900631506e-14,   2.659639432435422e-15,   5.159223455379210e-17,  -3.053570018343511e-18,
  -9.154106935048772e-21,   2.595047377945251e-21,   1.377561647090635e+00,  -2.158504813123842e-02,  -2.744558512170007e-04,   5.178935265085610e-06,   2.363541004576206e-07,
  -5.599145192693472e-10,  -2.079553505242739e-10,  -2.692630692782755e-12,   1.565343537271274e-13,   5.229086413500643e-15,  -6.694208532305591e-17,  -6.140232217092324e-18,
  -3.125024933420025e-20,   5.397937790130458e-21,   1.377536180499951e+00,  -2.158359356469525e-02,  -2.743245234247096e-04,   5.178368278485269e-06,   2.360664435110499e-07,
  -5.649490820057965e-10,  -2.075503937658769e-10,  -2.675764268330005e-12,   1.562471692012330e-13,   5.198879498407807e-15,  -6.709649538497020e-17,  -6.102589211327151e-18,
  -3.039319741051547e-20,   5.364640281363749e-21,   1.377491254116813e+00,  -2.158102709596940e-02,  -2.740929238925060e-04,   5.177364065864620e-06,   2.355593289319213e-07,
  -5.738060333939439e-10,  -2.068364568686927e-10,  -2.646085018647560e-12,   1.557399317119235e-13,   5.145734854458651e-15,  -6.736476761766754e-17,  -6.036364142092780e-18,
  -2.889224388189965e-20,   5.305985474088888e-21,   1.377436945386080e+00,  -2.157792392842280e-02,  -2.738130935028845e-04,   5.176143370894959e-06,   2.349469054904320e-07,
  -5.844706637681051e-10,  -2.059742072101760e-10,  -2.610335774707552e-12,   1.551257388687860e-13,   5.081737099537726e-15,  -6.768206496633280e-17,  -5.956618897714564e-18,
  -2.709649400683333e-20,   5.235229897474376e-21,   1.377384240923288e+00,  -2.157491167269807e-02,  -2.735416715484615e-04,   5.174951666891179e-06,   2.343531967633699e-07,
  -5.947763883641567e-10,  -2.051382510783995e-10,  -2.575776448846311e-12,   1.545286280671045e-13,   5.019886306692228e-15,  -6.798270526598054e-17,  -5.879553680841117e-18,
  -2.537321498349769e-20,   5.166721796949037e-21,   1.377341795435453e+00,  -2.157248521514637e-02,  -2.733231840397724e-04,   5.173986875694253e-06,   2.338755007915210e-07,
  -6.030447254145396e-10,  -2.044656050987138e-10,  -2.548039838537231e-12,   1.540469936325066e-13,   4.970258162860741e-15,  -6.821963912265217e-17,  -5.817721403024121e-18,
  -2.399921066891753e-20,   5.111662851930319e-21,   1.377313754351724e+00,  -2.157088194183867e-02,  -2.731788928512438e-04,   5.173347028313008e-06,   2.335601355558626e-07,
  -6.084917678400842e-10,  -2.040215193775924e-10,  -2.529762763930946e-12,   1.537284430970381e-13,   4.937561536721989e-15,  -6.837364011164170e-17,  -5.776986213672158e-18,
  -2.309823420434179e-20,   5.075345148461486e-21,   1.377299355811387e+00,  -2.157005861111181e-02,  -2.731048176045849e-04,   5.173017716377942e-06,   2.333982693703363e-07,
  -6.112839803369343e-10,  -2.037935797716600e-10,  -2.520392294457091e-12,   1.535647616341296e-13,   4.920800137516514e-15,  -6.845193800657338e-17,  -5.756104589657934e-18,
  -2.263767894277974e-20,   5.056714244996552e-21,   1.377294344569664e+00,  -2.156977204758780e-02,  -2.730790390447642e-04,   5.172902981861393e-06,   2.333419445201816e-07,
  -6.122550234437601e-10,  -2.037142623591098e-10,  -2.517133311488424e-12,   1.535077764563154e-13,   4.914970932550383e-15,  -6.847906495956346e-17,  -5.748842571217964e-18,
  -2.247771838790975e-20,   5.050232777324479e-21,   1.377293549368959e+00,  -2.156972657410620e-02,  -2.730749485326086e-04,   5.172884769640836e-06,   2.333330072142421e-07,
  -6.124090760742682e-10,  -2.037016766827974e-10,  -2.516616274168234e-12,   1.534987330136916e-13,   4.914046143590789e-15,  -6.848336368806380e-17,  -5.747690474731913e-18,
  -2.245235097488628e-20,   5.049204409234832e-21,   1.862493047145272e+00,  -6.947348494505172e-03,  -2.405093236694827e-04,  -6.407833386862162e-06,  -1.214929358657561e-07,
  -7.482663935599953e-10,   5.974193396525987e-11,   3.245778942118842e-12,   9.356701065028275e-14,   1.331164304173247e-15,  -2.231863804131374e-17,  -2.043917680027518e-18,
  -6.710932203649785e-20,  -1.211490036707742e-21,   1.862470363252798e+00,  -6.949152961568682e-03,  -2.405771713059069e-04,  -6.408480536524495e-06,  -1.214060496544863e-07,
  -7.418099781167067e-10,   5.998528809467441e-11,   3.249987426985747e-12,   9.345959453677338e-14,   1.320309978134789e-15,  -2.273143901470620e-17,  -2.052126355777516e-18,
  -6.706215702889176e-20,  -1.199856035866765e-21,   1.862430332055220e+00,  -6.952337110634246e-03,  -2.406968491192087e-04,  -6.409617501096179e-06,  -1.212524602479810e-07,
  -7.304109358421026e-10,   6.041445301421964e-11,   3.257383352263187e-12,   9.326864357582954e-14,   1.301123611245415e-15,  -2.345955452715609e-17,  -2.066540121760789e-18,
  -6.697522313213645e-20,  -1.179222960962641e-21,   1.862381917188461e+00,  -6.956187653156656e-03,  -2.408414958233884e-04,  -6.410983902299561e-06,  -1.210662656343687e-07,
  -7.166158790780261e-10,   6.093299719152945e-11,   3.266275347785990e-12,   9.303533414480258e-14,   1.277865930390320e-15,  -2.433951226848749e-17,  -2.083848649994344e-18,
  -6.686377335824002e-20,  -1.154095377911068e-21,   1.862334907750524e+00,  -6.959925938752046e-03,  -2.409818439877987e-04,  -6.412301550399467e-06,  -1.208850164041352e-07,
  -7.032121768313821e-10,   6.143596245230575e-11,   3.274853809278936e-12,   9.280631912091579e-14,   1.255228012461086e-15,  -2.519323336998629e-17,  -2.100524483602174e-18,
  -6.674895081990259e-20,  -1.129516572761382e-21,   1.862297031023804e+00,  -6.962937628260698e-03,  -2.410948547260811e-04,  -6.413356700509276e-06,  -1.207386500877595e-07,
  -6.924059754726588e-10,   6.184083588669986e-11,   3.281725950213239e-12,   9.262002106657925e-14,   1.236948564782461e-15,  -2.588059113629293e-17,  -2.113866956551065e-18,
  -6.665170027225918e-20,  -1.109583989783451e-21,   1.862271999558707e+00,  -6.964927784559663e-03,  -2.411695047570207e-04,  -6.414050824322835e-06,  -1.206417604319972e-07,
  -6.852613522522199e-10,   6.210821707502287e-11,   3.286248037902852e-12,   9.249603438006231e-14,   1.224849030955933e-15,  -2.633458986312951e-17,  -2.122638540228562e-18,
  -6.658511212169815e-20,  -1.096348403966292e-21,   1.862259143714572e+00,  -6.965949851433058e-03,  -2.412078332419208e-04,  -6.414406330971592e-06,  -1.205919493468147e-07,
  -6.815909878228095e-10,   6.224548295291529e-11,   3.288564496322708e-12,   9.243208788036589e-14,   1.218628924681448e-15,  -2.656767862345585e-17,  -2.127129254883471e-18,
  -6.655019625846614e-20,  -1.089531406046320e-21,   1.862254668962841e+00,  -6.966305595363838e-03,  -2.412211725673308e-04,  -6.414529915596625e-06,  -1.205746036088641e-07,
  -6.803132837373148e-10,   6.229325207725177e-11,   3.289369829138115e-12,   9.240978719462828e-14,   1.216462939608441e-15,  -2.664879745237599e-17,  -2.128690071367309e-18,
  -6.653792889264706e-20,  -1.087155525485432e-21,   1.862253958873894e+00,  -6.966362047225339e-03,  -2.412232892749815e-04,  -6.414549519524013e-06,  -1.205718506740502e-07,
  -6.801105201994131e-10,   6.230083202203880e-11,   3.289497580122809e-12,   9.240624631695958e-14,   1.216119179208140e-15,  -2.666166942400617e-17,  -2.128937646099625e-18,
  -6.653597679098570e-20,  -1.086778355946254e-21,   2.912829788736744e-02,  -1.109925577646384e-03,   3.129523857719156e-05,  -7.743862607591937e-07,   1.750394284836935e-08,
  -3.734580052118312e-10,   7.375543184750960e-12,  -1.333778799721946e-13,   2.597056251292020e-15,  -3.089998015549440e-17,   7.728451730769976e-20,  -1.217549055328900e-20,
   9.688810884290491e-23,   1.462977105648796e-23,   2.913125169538747e-02,  -1.110144614902222e-03,   3.130514357083272e-05,  -7.747386005784237e-07,   1.751439540070206e-08,
  -3.737222786119590e-10,   7.382367511594267e-12,  -1.334836787270332e-13,   2.597396471437684e-15,  -3.095859758587731e-17,   7.774673883759847e-20,  -1.206851870494588e-20,
   9.391691451666173e-23,   1.462908714765572e-23,   2.913646449820217e-02,  -1.110531190544330e-03,   3.132262588732904e-05,  -7.753605116895278e-07,   1.753284689896737e-08,
  -3.741887632696871e-10,   7.394409878162205e-12,  -1.336705200758172e-13,   2.597998260161163e-15,  -3.106158051694393e-17,   7.854745559409833e-20,  -1.187976427736611e-20,
   8.868017669914510e-23,   1.462825136418402e-23,   2.914276917475209e-02,  -1.110998780013712e-03,   3.134377387704161e-05,  -7.761128776929582e-07,   1.755517195697904e-08,
  -3.747531316827746e-10,   7.408972890878169e-12,  -1.338967188189203e-13,   2.598728412474556e-15,  -3.118534392761372e-17,   7.949033904925808e-20,  -1.165151735046217e-20,
   8.235804275822374e-23,   1.462787059255005e-23,   2.914889100696040e-02,  -1.111452852405478e-03,   3.136431255461254e-05,  -7.768436223969999e-07,   1.757685867482142e-08,
  -3.753013148604846e-10,   7.423111727676118e-12,  -1.341165884114062e-13,   2.599439766428110e-15,  -3.130469055463566e-17,   8.037915199375979e-20,  -1.142993408826215e-20,
   7.623127333453162e-23,   1.462815710289386e-23,   2.915382365100721e-02,  -1.111818750874117e-03,   3.138086439249777e-05,  -7.774325594282380e-07,   1.759433919972933e-08,
  -3.757431421328078e-10,   7.434502735518321e-12,  -1.342939121905723e-13,   2.600014608722720e-15,  -3.140026089789796e-17,   8.107618365217682e-20,  -1.125142451031851e-20,
   7.130324493647909e-23,   1.462885562793319e-23,   2.915708353210950e-02,  -1.112060580827711e-03,   3.139180456240944e-05,  -7.778218451772257e-07,   1.760589490931880e-08,
  -3.760352005398452e-10,   7.442030173878848e-12,  -1.344111820547337e-13,   2.600395315519943e-15,  -3.146313115026878e-17,   8.152748187294586e-20,  -1.113346558532531e-20,
   6.805061611393175e-23,   1.462954523179658e-23,   2.915875778481522e-02,  -1.112184787781650e-03,   3.139742379427892e-05,  -7.780218012106646e-07,   1.761183083147818e-08,
  -3.761852195533596e-10,   7.445896017081664e-12,  -1.344714358193341e-13,   2.600591090333763e-15,  -3.149533115215126e-17,   8.175637432198636e-20,  -1.107288699896412e-20,
   6.638138632733640e-23,   1.462996968934289e-23,   2.915934054733034e-02,  -1.112228021649362e-03,   3.139937976764797e-05,  -7.780914039765252e-07,   1.761389712431983e-08,
  -3.762374403071378e-10,   7.447241582058199e-12,  -1.344924124765732e-13,   2.600659273285627e-15,  -3.150652482599204e-17,   8.183558554350612e-20,  -1.105180189244289e-20,
   6.580057871477448e-23,   1.463012860111885e-23,   2.915943302483256e-02,  -1.112234882387425e-03,   3.139969016072213e-05,  -7.781024492729984e-07,   1.761422502796678e-08,
  -3.762457272714077e-10,   7.447455105773451e-12,  -1.344957414101139e-13,   2.600670094957515e-15,  -3.150830045123024e-17,   8.184813358615474e-20,  -1.104845596792531e-20,
   6.570842123606379e-23,   1.463015434839035e-23,   2.594068301761489e-01,  -9.139825958625969e-03,   2.134935001777336e-04,  -3.550906951905580e-06,   2.799163485541899e-08,
   6.028973521824539e-10,  -3.362960172829641e-11,   8.332361164193084e-13,  -6.634701992172128e-15,  -8.358420777909917e-17,   6.773114732502183e-18,  -3.987913373842564e-19,
   6.208143485834618e-21,   1.398948614077780e-22,   2.594268762153876e-01,  -9.140822606955827e-03,   2.135089772745647e-04,  -3.550327995708763e-06,   2.794414562946079e-08,
   6.045323455090059e-10,  -3.364640047630499e-11,   8.329016562035450e-13,  -6.604979697361635e-15,  -8.559925951865312e-17,   6.809190657361728e-18,  -3.977370481983241e-19,
   6.157643617370501e-21,   1.404617877183227e-22,   2.594622489151171e-01,  -9.142581073868838e-03,   2.135362650920766e-04,  -3.549305173920098e-06,   2.786033118051376e-08,
   6.074167559343778e-10,  -3.367597801014574e-11,   8.323059972278527e-13,  -6.552412557303079e-15,  -8.915039832696496e-17,   6.872593669315042e-18,  -3.958733632998768e-19,
   6.068581578889989e-21,   1.414625113664207e-22,   2.595050239180964e-01,  -9.144707200904595e-03,   2.135692246984475e-04,  -3.548066245263873e-06,   2.775894957107701e-08,
   6.109036532510937e-10,  -3.371163397218691e-11,   8.315763527554941e-13,  -6.488640924515950e-15,  -9.343687312552770e-17,   6.948829149788047e-18,  -3.936140197487612e-19,
   5.960965621333006e-21,   1.426731807380293e-22,   2.595465511979520e-01,  -9.146770967184850e-03,   2.136011824407921e-04,  -3.546861293422160e-06,   2.766049631862391e-08,
   6.142876571407538e-10,  -3.374613326350450e-11,   8.308582279487802e-13,  -6.426516637761662e-15,  -9.759013744047450e-17,   7.022384932258058e-18,  -3.914146593410714e-19,
   5.856577413022535e-21,   1.438490214997156e-22,   2.595800065004973e-01,  -9.148433337581309e-03,   2.136268993248312e-04,  -3.545889008577913e-06,   2.758115952919984e-08,
   6.170130335534422e-10,  -3.377384296149222e-11,   8.302727028681800e-13,  -6.376315970902746e-15,  -1.009302330844999e-16,   7.081316589106495e-18,  -3.896385627502328e-19,
   5.772544139497309e-21,   1.447966058388799e-22,   2.596021138857848e-01,  -9.149531717607929e-03,   2.136438789417425e-04,  -3.545245761038264e-06,   2.752872339605514e-08,
   6.188135526093749e-10,  -3.379211258728989e-11,   8.298823675987276e-13,  -6.343069004721987e-15,  -1.031345045603329e-16,   7.120099036063679e-18,  -3.884628340543114e-19,
   5.717046350818299e-21,   1.454229011883262e-22,   2.596134673076884e-01,  -9.150095762092518e-03,   2.136525945681277e-04,  -3.544915181748669e-06,   2.750179128861754e-08,
   6.197380931511278e-10,  -3.380148239158811e-11,   8.296808514299350e-13,  -6.325971867973498e-15,  -1.042656354506041e-16,   7.139966660552547e-18,  -3.878583867512252e-19,
   5.688554886507054e-21,   1.457445756731132e-22,   2.596174190054498e-01,  -9.150292078765998e-03,   2.136556274499411e-04,  -3.544800082250162e-06,   2.749241674219382e-08,
   6.200598700584822e-10,  -3.380474164294702e-11,   8.296105431339602e-13,  -6.320017358992596e-15,  -1.046591976646246e-16,   7.146873966666852e-18,  -3.876478991519497e-19,
   5.678639658093022e-21,   1.458565437248825e-22,   2.596180460871363e-01,  -9.150323231320145e-03,   2.136561086946237e-04,  -3.544781815724398e-06,   2.749092910326722e-08,
   6.201109307717305e-10,  -3.380525874652502e-11,   8.295993781658471e-13,  -6.319072285142337e-15,  -1.047216440031842e-16,   7.147969690629800e-18,  -3.876144927229643e-19,
   5.677066318579725e-21,   1.458743118044875e-22,   7.007801030157826e-01,  -2.024993808373996e-02,   2.467225045741530e-04,   2.732896327800996e-06,  -1.692656189204340e-07,
   1.544094281091396e-09,   7.709855839915406e-11,  -2.676850104675390e-12,   9.817857511978312e-15,   2.373341487243286e-15,  -5.923490248806669e-17,  -1.237604765998313e-18,
   6.467305674076048e-20,  -1.043443447391379e-22,   7.008030433195953e-01,  -2.024916452062774e-02,   2.466279063156609e-04,   2.734300772758958e-06,  -1.691569596276307e-07,
   1.538948627704660e-09,   7.711945921093023e-11,  -2.669006740522781e-12,   9.580211248806518e-15,   2.366949854547909e-15,  -5.885132596795981e-17,  -1.237934743761617e-18,
   6.431350464343340e-20,  -9.637565838460181e-23,   7.008435147102459e-01,  -2.024779924264590e-02,   2.464610359429774e-04,   2.736775054237105e-06,  -1.689652065987680e-07,
   1.529881513177466e-09,   7.715583924096413e-11,  -2.655184544779907e-12,   9.162181749429186e-15,   2.355670772637426e-15,  -5.817629589280773e-17,  -1.238470743733161e-18,
   6.368014725257066e-20,  -8.239833930464735e-23,   7.008924409828349e-01,  -2.024614779963388e-02,   2.462593393268052e-04,   2.739760366195714e-06,  -1.687332996665237e-07,
   1.518938707675271e-09,   7.719898008034312e-11,  -2.638500512710450e-12,   8.658910242861563e-15,   2.342030505194545e-15,  -5.736310212869850e-17,  -1.239040355981097e-18,
   6.291613007799665e-20,  -6.563886994283165e-23,   7.009399250251871e-01,  -2.024454404860351e-02,   2.460636245750850e-04,   2.742651535780615e-06,  -1.685081300504976e-07,
   1.508337845844453e-09,   7.723997245828547e-11,  -2.622335271023511e-12,   8.172656337636784e-15,   2.328787385356320e-15,  -5.657686709854138e-17,  -1.239511524749479e-18,
   6.217637717731230e-20,  -4.951730053148700e-23,   7.009781684291374e-01,  -2.024325168782965e-02,   2.459060229693883e-04,   2.744975672347806e-06,  -1.683267091828389e-07,
   1.499813835761921e-09,   7.727236082678734e-11,  -2.609335209753196e-12,   7.782590256775981e-15,   2.318118025443774e-15,  -5.594577534062341e-17,  -1.239832784000648e-18,
   6.158183961297969e-20,  -3.663581309236471e-23,   7.010034345232435e-01,  -2.024239752331647e-02,   2.458019138043202e-04,   2.746508998075467e-06,  -1.682068163500061e-07,
   1.494189102934150e-09,   7.729345246939591e-11,  -2.600755991936491e-12,   7.525649733200735e-15,   2.311067521262047e-15,  -5.552988050718952e-17,  -1.240016638758222e-18,
   6.118966675554197e-20,  -2.817562833078067e-23,   7.010164084905732e-01,  -2.024195880854333e-02,   2.457484584061922e-04,   2.747295685580067e-06,  -1.681452416049708e-07,
   1.491302938407938e-09,   7.730418830751676e-11,  -2.596353552245523e-12,   7.393948097465173e-15,   2.307446642128685e-15,  -5.531664448799554e-17,  -1.240102291338955e-18,
   6.098848023077623e-20,  -2.384686715115551e-23,   7.010209239788860e-01,  -2.024180610023322e-02,   2.457298543000181e-04,   2.747569380232846e-06,  -1.681238093107502e-07,
   1.490298765147011e-09,   7.730790978693299e-11,  -2.594821783950751e-12,   7.348147847630728e-15,   2.306186345702194e-15,  -5.524248077672865e-17,  -1.240130710303523e-18,
   6.091848937732629e-20,  -2.234273837908091e-23,   7.010216405142573e-01,  -2.024178186707113e-02,   2.457269021574452e-04,   2.747612806149907e-06,  -1.681204082704829e-07,
   1.490139434847125e-09,   7.730849961183179e-11,  -2.594578739108791e-12,   7.340881863361662e-15,   2.305986353261271e-15,  -5.523071462945276e-17,  -1.240135153908492e-18,
   6.090738440593537e-20,  -2.210417420269612e-23,   1.287311080742824e+00,  -2.347050960646740e-02,  -1.909078079187888e-04,   8.586333409494593e-06,   1.726939502752997e-07,
  -5.746992297452963e-09,  -1.916016763733478e-10,   4.302470161816966e-12,   2.357338829963343e-13,  -2.160786045269383e-15,  -2.576943143818563e-16,  -1.166789376625061e-19,
   2.532851555812396e-19,   1.975900163465530e-21,   1.287293375174373e+00,  -2.346811342016307e-02,  -1.908121451629015e-04,   8.581015741870436e-06,   1.724315435306863e-07,
  -5.738637843753176e-09,  -1.910042141323884e-10,   4.295176210943266e-12,   2.346938295172760e-13,  -2.160907840726168e-15,  -2.562159996993553e-16,  -1.040663255580089e-19,
   2.513437667213698e-19,   1.941858740982884e-21,   1.287262140536625e+00,  -2.346388651543891e-02,  -1.906434650801236e-04,   8.571638965484023e-06,   1.719691974282227e-07,
  -5.723907953022569e-09,  -1.899521738739557e-10,   4.282305931821090e-12,   2.328636317387428e-13,  -2.161071723112133e-15,  -2.536170807712776e-16,  -8.200642970879597e-20,
   2.479340831924294e-19,   1.882323869837653e-21,   1.287224383406960e+00,  -2.345877734852090e-02,  -1.904396969187682e-04,   8.560311257429977e-06,   1.714112723493747e-07,
  -5.706116317040976e-09,  -1.886837646224971e-10,   4.266743166829194e-12,   2.306590281424742e-13,  -2.161183434592015e-15,  -2.504907387015225e-16,  -5.566217603134174e-20,
   2.438381154885634e-19,   1.811234373049353e-21,   1.287187742131900e+00,  -2.345381960470927e-02,  -1.902420931602480e-04,   8.549325806085697e-06,   1.708708491573087e-07,
  -5.688865348971354e-09,  -1.874563107277321e-10,   4.251635342357400e-12,   2.285277005836466e-13,  -2.161202043222833e-15,  -2.474727384536360e-16,  -3.043135673911565e-20,
   2.398900287028364e-19,   1.743157539851539e-21,   1.287158233486295e+00,  -2.344982724819735e-02,  -1.900830570253453e-04,   8.540484154217659e-06,   1.704363501209960e-07,
  -5.674983127854033e-09,  -1.864702747277256e-10,   4.239464929666036e-12,   2.268170615136437e-13,  -2.161153154128604e-15,  -2.450536075309247e-16,  -1.035012754798699e-20,
   2.367296227244909e-19,   1.688980777466838e-21,   1.287138739147076e+00,  -2.344718992254563e-02,  -1.899780425816792e-04,   8.534645704527548e-06,   1.701496608050390e-07,
  -5.665817315571565e-09,  -1.858200806573982e-10,   4.231423095760909e-12,   2.256897933386643e-13,  -2.161089768318728e-15,  -2.434610089462051e-16,   2.800289011214911e-21,
   2.346510987506757e-19,   1.653505228210305e-21,   1.287128729246284e+00,  -2.344583576224599e-02,  -1.899241354477589e-04,   8.531648604320148e-06,   1.700025618532242e-07,
  -5.661112493703571e-09,  -1.854865952243690e-10,   4.227293285240332e-12,   2.251118416062574e-13,  -2.161047646393856e-15,  -2.426449600388637e-16,   9.517046584223670e-21,
   2.335867052737192e-19,   1.635386425316502e-21,   1.287125245427534e+00,  -2.344536447137838e-02,  -1.899053762057158e-04,   8.530605630818470e-06,   1.699513833574533e-07,
  -5.659475297366727e-09,  -1.853705894336698e-10,   4.225855876412514e-12,   2.249108320051588e-13,  -2.161031465576393e-15,  -2.423612171822879e-16,   1.184906140878068e-20,
   2.332167147643602e-19,   1.629095824530580e-21,   1.287124692603869e+00,  -2.344528968576601e-02,  -1.899023995446397e-04,   8.530440134528702e-06,   1.699432630147015e-07,
  -5.659215513946216e-09,  -1.853521840858023e-10,   4.225627779893688e-12,   2.248789417528163e-13,  -2.161028825823891e-15,  -2.423162048793394e-16,   1.221884431573537e-20,
   2.331580252054365e-19,   1.628098342774914e-21,   1.830321211822876e+00,  -9.212496594896074e-03,  -3.292080330585793e-04,  -8.356088191567186e-06,  -1.128621463520414e-07,
   2.147051795604995e-09,   1.971833902320382e-10,   6.593399480195536e-12,   9.366434974844191e-14,  -2.494229292805895e-15,  -1.995053297896192e-16,  -6.082086680626441e-18,
  -6.687931255576107e-20,   3.033432503354713e-21,   1.830290224402283e+00,  -9.214839247062966e-03,  -3.292699361898073e-04,  -8.353967591510766e-06,  -1.125821861204877e-07,
   2.159884340485195e-09,   1.974116320056636e-10,   6.584193794970653e-12,   9.281234107108640e-14,  -2.524598875669133e-15,  -1.998395437659603e-16,  -6.057054349723130e-18,
  -6.516397110916217e-20,   3.085714131922319e-21,   1.830235542081550e+00,  -9.218972390153722e-03,  -3.293790365911494e-04,  -8.350216024796367e-06,  -1.120879378838208e-07,
   2.182512447242712e-09,   1.978125438452100e-10,   6.567867626704926e-12,   9.130788210286860e-14,  -2.578078655419053e-15,  -2.004206214453491e-16,  -6.012579387389422e-18,
  -6.213540886654772e-20,   3.177538476147463e-21,   1.830169411918514e+00,  -9.223969370900306e-03,  -3.295107425306354e-04,  -8.345663000113674e-06,  -1.114898559698739e-07,
   2.209848723984992e-09,   1.982942185367528e-10,   6.547985229700858e-12,   8.948685948110476e-14,  -2.642562256121234e-15,  -2.011085154769850e-16,  -5.958281471928858e-18,
  -5.847026949100030e-20,   3.287840686474943e-21,   1.830105205828956e+00,  -9.228819450759488e-03,  -3.296383704926543e-04,  -8.341225639904349e-06,  -1.109087981934864e-07,
   2.236359101033165e-09,   1.987585590365433e-10,   6.528536751018146e-12,   8.771716780331300e-14,  -2.704967279279131e-15,  -2.017608568861132e-16,  -5.905029488007750e-18,
  -5.490926624192698e-20,   3.394147744280589e-21,   1.830053476460744e+00,  -9.232725963988855e-03,  -3.297410211392309e-04,  -8.337638527261584e-06,  -1.104403843228596e-07,
   2.257695941454514e-09,   1.991302879169165e-10,   6.512764177147403e-12,   8.629020248144867e-14,  -2.755099791814629e-15,  -2.022752971610348e-16,  -5.861744716271328e-18,
  -5.203856807784217e-20,   3.479230338146469e-21,   1.830019291789442e+00,  -9.235307000497434e-03,  -3.298087701495820e-04,  -8.335262142583027e-06,  -1.101307079939841e-07,
   2.271785328734554e-09,   1.993747745654090e-10,   6.502290541372087e-12,   8.534664799145161e-14,  -2.788157523608438e-15,  -2.026098045171657e-16,  -5.832954728649431e-18,
  -5.014072808030188e-20,   3.535177256738929e-21,   1.830001735451517e+00,  -9.236632387830531e-03,  -3.298435375424150e-04,  -8.334039874275480e-06,  -1.099716260046306e-07,
   2.279017922251787e-09,   1.994999758898792e-10,   6.496895948519378e-12,   8.486189088435378e-14,  -2.805112864108411e-15,  -2.027799117604833e-16,  -5.818111634705113e-18,
  -4.916581736402843e-20,   3.563823592073140e-21,   1.829995624668305e+00,  -9.237093685351611e-03,  -3.298556346767920e-04,  -8.333614153185477e-06,  -1.099162483696063e-07,
   2.281534817463364e-09,   1.995434969475607e-10,   6.495015784440872e-12,   8.469313555471116e-14,  -2.811010914976859e-15,  -2.028388519261930e-16,  -5.812936129464871e-18,
  -4.882644719753194e-20,   3.573780639002347e-21,   1.829994654964570e+00,  -9.237166886170626e-03,  -3.298575541366921e-04,  -8.333546582898680e-06,  -1.099074603366464e-07,
   2.281934191498599e-09,   1.995504004618713e-10,   6.494717308377256e-12,   8.466635493068987e-14,  -2.811946692385731e-15,  -2.028481922323919e-16,  -5.812114410112276e-18,
  -4.877259177535517e-20,   3.575360040349490e-21,   2.513651093107572e-02,  -8.924839710577158e-04,   2.346456260416527e-05,  -5.455726926943484e-07,   1.154658629323377e-08,
  -2.328985968516356e-10,   4.636191075833942e-12,  -6.835115866634992e-14,   1.439022679533084e-15,  -3.517693738994543e-17,  -1.767325361942705e-19,   2.857340572305959e-21,
   3.887240249601607e-22,  -1.117443709839512e-24,   2.513872384306772e-02,  -8.926381864506763e-04,   2.347109462266067e-05,  -5.457921837850593e-07,   1.155315041413129e-08,
  -2.330350444560875e-10,   4.639954900085460e-12,  -6.846950030797116e-14,   1.438352887752249e-15,  -3.516233298234621e-17,  -1.743687191058801e-19,   2.853384658611290e-21,
   3.878287818157703e-22,  -1.039709779714786e-24,   2.514262906344976e-02,  -8.929103523305805e-04,   2.348262348457463e-05,  -5.461795838521030e-07,   1.156473720676830e-08,
  -2.332759976348832e-10,   4.646594843732465e-12,  -6.867827600622547e-14,   1.437179100796068e-15,  -3.513657560268410e-17,  -1.702022176003711e-19,   2.846854071373024e-21,
   3.862503484002839e-22,  -9.034712855221207e-25,   2.514735215438528e-02,  -8.932395441612939e-04,   2.349656944552312e-05,  -5.466482105764044e-07,   1.157875540770473e-08,
  -2.335676834094591e-10,   4.654621587387646e-12,  -6.893066164284772e-14,   1.435773496563648e-15,  -3.510544925167497e-17,  -1.651716936245249e-19,   2.839720216937340e-21,
   3.843436290046527e-22,  -7.403042068551322e-25,   2.515193814666558e-02,  -8.935592079097372e-04,   2.351011332512667e-05,  -5.471033322583315e-07,   1.159237170644919e-08,
  -2.338511846951754e-10,   4.662411368274951e-12,  -6.917560188653158e-14,   1.434423347298798e-15,  -3.507525139203484e-17,  -1.602961595684790e-19,   2.833589023085337e-21,
   3.824944331494340e-22,  -5.835501418146063e-25,   2.515563320550560e-02,  -8.938167893806320e-04,   2.352102795588691e-05,  -5.474701064188545e-07,   1.160334631562169e-08,
  -2.340798116265586e-10,   4.668684974687987e-12,  -6.937287144408632e-14,   1.433345983367708e-15,  -3.505093691281414e-17,  -1.563742305376903e-19,   2.829215509568896e-21,
   3.810058933055549e-22,  -4.584484430168755e-25,   2.515807514949807e-02,  -8.939870262209061e-04,   2.352824203867226e-05,  -5.477125299216913e-07,   1.161060083245826e-08,
  -2.342310026951480e-10,   4.672829614473147e-12,  -6.950319863043364e-14,   1.432639119197723e-15,  -3.503487601369816e-17,  -1.537854981886341e-19,   2.826601192601949e-21,
   3.800227940114432e-22,  -3.763591854980335e-25,   2.515932930199019e-02,  -8.940744607556204e-04,   2.353194739972544e-05,  -5.478370463070686e-07,   1.161432720598292e-08,
  -2.343086831761639e-10,   4.674957824105306e-12,  -6.957012013902284e-14,   1.432277668081255e-15,  -3.502662963176549e-17,  -1.524569286372582e-19,   2.825343565618080e-21,
   3.795180675890951e-22,  -3.343803104650716e-25,   2.515976583675905e-02,  -8.941048947019110e-04,   2.353323717761310e-05,  -5.478803886104803e-07,   1.161562433686379e-08,
  -2.343357264106907e-10,   4.675698525452963e-12,  -6.959341155120379e-14,   1.432152109586864e-15,  -3.502375965839572e-17,  -1.519946460702404e-19,   2.824919335449887e-21,
   3.793424144108417e-22,  -3.197974841057101e-25,   2.515983510955108e-02,  -8.941097242239044e-04,   2.353344185201788e-05,  -5.478872665907106e-07,   1.161583017995791e-08,
  -2.343400180764098e-10,   4.675816062587011e-12,  -6.959710751906963e-14,   1.432132196949081e-15,  -3.502330424509761e-17,  -1.519212947555573e-19,   2.824852656259324e-21,
   3.793145416669092e-22,  -3.174847338675566e-25,   2.260051973482268e-01,  -7.594038727498025e-03,   1.738462574602612e-04,  -3.042952714941276e-06,   3.373685277416814e-08,
   5.011055554618480e-11,  -1.352067671449713e-11,   5.967111264858654e-13,  -8.077305112843106e-15,  -6.118009287480722e-17,  -2.992781366326558e-18,  -4.235564422595980e-20,
   6.791538476465016e-21,  -7.132460306083660e-23,   2.260215332767278e-01,  -7.594894353955530e-03,   1.738651255070794e-04,  -3.042895891144025e-06,   3.371758555849023e-08,
   5.128193071199086e-11,  -1.354210868705293e-11,   5.964984173679430e-13,  -8.088594275449151e-15,  -6.141629561462682e-17,  -2.951150110987283e-18,  -4.282184153656895e-20,
   6.783125786986175e-21,  -7.030897177638456e-23,   2.260503597050419e-01,  -7.596404105618696e-03,   1.738984096019005e-04,  -3.042794732899349e-06,   3.368356366148909e-08,
   5.334849708756943e-11,  -1.357994902320324e-11,   5.961224277678225e-13,  -8.108371736544710e-15,  -6.183497724917342e-17,  -2.877733664383247e-18,  -4.363853042051912e-20,
   6.768260894474630e-21,  -6.852536223089453e-23,   2.260852193602524e-01,  -7.598229688288376e-03,   1.739386419521116e-04,  -3.042670890924130e-06,   3.364238207132051e-08,
   5.584682474321487e-11,  -1.362574545430974e-11,   5.956666465407047e-13,  -8.132044075413404e-15,  -6.234447129174671e-17,  -2.789030359524485e-18,  -4.461601358561261e-20,
   6.750249282377395e-21,  -6.638306455976485e-23,   2.261190630542818e-01,  -7.600001905805322e-03,   1.739776829644047e-04,  -3.042549075418981e-06,   3.360235974557641e-08,
   5.827154288253113e-11,  -1.367024492771351e-11,   5.952229936288945e-13,  -8.154770665209287e-15,  -6.284242954903705e-17,  -2.702994908705973e-18,  -4.555444053473549e-20,
   6.732723133468456e-21,  -6.431848996441521e-23,   2.261463289165442e-01,  -7.601429562050931e-03,   1.740091225278491e-04,  -3.042449802033444e-06,   3.357008677399993e-08,
   6.022442290018139e-11,  -1.370612237936796e-11,   5.948647380158475e-13,  -8.172896934045398e-15,  -6.324596364046726e-17,  -2.633740530657995e-18,  -4.630293515229310e-20,
   6.718573512404106e-21,  -6.266612690868776e-23,   2.261643466047661e-01,  -7.602372922443786e-03,   1.740298916622423e-04,  -3.042383645645076e-06,   3.354874593657291e-08,
   6.151463484495295e-11,  -1.372984380869897e-11,   5.946275894002192e-13,  -8.184785385666906e-15,  -6.351377367102618e-17,  -2.588005267951594e-18,  -4.679387229279264e-20,
   6.709207996441774e-21,  -6.157957410591336e-23,   2.261735998256560e-01,  -7.602857380219211e-03,   1.740405558836385e-04,  -3.042349498527649e-06,   3.353778162136990e-08,
   6.217715343755542e-11,  -1.374203028807335e-11,   5.945056721796490e-13,  -8.190863138370998e-15,  -6.365166497244432e-17,  -2.564526316373454e-18,  -4.704486439672087e-20,
   6.704393368107227e-21,  -6.102321521776966e-23,   2.261768205378413e-01,  -7.603025999717942e-03,   1.740442673892170e-04,  -3.042337585826408e-06,   3.353396463089842e-08,
   6.240773843317871e-11,  -1.374627260134508e-11,   5.944632170452380e-13,  -8.192974172776469e-15,  -6.369971618796915e-17,  -2.556355573346179e-18,  -4.713204521719196e-20,
   6.702716786770586e-21,  -6.082983009874246e-23,   2.261773316225935e-01,  -7.603052757287957e-03,   1.740448563410118e-04,  -3.042335694140041e-06,   3.353335889098952e-08,
   6.244432858978008e-11,  -1.374694583112007e-11,   5.944564790155425e-13,  -8.193308956797763e-15,  -6.370734395231662e-17,  -2.555059051686299e-18,  -4.714587110651536e-20,
   6.702450697908112e-21,  -6.079915491774731e-23,   6.238743823513403e-01,  -1.818814001394976e-02,   2.645462896292222e-04,   3.482292538093252e-07,  -1.254978869721205e-07,
   2.591470057602504e-09,   1.576897293861542e-11,  -1.507811023246956e-12,   4.720650188850515e-14,  -2.616200461575756e-16,  -5.553869654705582e-17,   1.058345855745237e-18,
   2.357868720459808e-20,  -9.824512718442197e-22,   6.238990420794147e-01,  -1.818803361099569e-02,   2.644758310475540e-04,   3.506336851851022e-07,  -1.254743096797017e-07,
   2.588489950786596e-09,   1.588816460152952e-11,  -1.508559675413926e-12,   4.697700132890046e-14,  -2.564276128746611e-16,  -5.538978358266312e-17,   1.051492647993177e-18,
   2.364519483063239e-20,  -9.764252075785487e-22,   6.239425492042339e-01,  -1.818784531588038e-02,   2.643515168798282e-04,   3.548740673654423e-07,  -1.254325727587465e-07,
   2.583230372751979e-09,   1.609799330519614e-11,  -1.509866629929685e-12,   4.657255733951628e-14,  -2.472938737323431e-16,  -5.512669980202096e-17,   1.039435617137456e-18,
   2.376164110399509e-20,  -9.658114869170943e-22,   6.239951493572276e-01,  -1.818761669777045e-02,   2.642012138414777e-04,   3.599977035115037e-07,  -1.253818752140402e-07,
   2.576868518733220e-09,   1.635089103062182e-11,  -1.511423102977848e-12,   4.608437541294038e-14,  -2.362975662387736e-16,  -5.480802590550785e-17,   1.024916682174068e-18,
   2.390089911190408e-20,  -9.530105261004096e-22,   6.240462031181588e-01,  -1.818739378620768e-02,   2.640553221835293e-04,   3.649675777288260e-07,  -1.253324197870793e-07,
   2.570690553914267e-09,   1.659553220242973e-11,  -1.512909128875452e-12,   4.561137520768603e-14,  -2.256729987579930e-16,  -5.449809067764431e-17,   1.010885261144603e-18,
   2.403446170815987e-20,  -9.406187190471029e-22,   6.240873245170045e-01,  -1.818721351467937e-02,   2.639378080779352e-04,   3.689683321036813e-07,  -1.252924081444292e-07,
   2.565712255740254e-09,   1.679199102185317e-11,  -1.514088407708784e-12,   4.523099106079536e-14,  -2.171500467024745e-16,  -5.424800379766257e-17,   9.996270186353099e-19,
   2.414089010522504e-20,  -9.306614382731119e-22,   6.241144934525598e-01,  -1.818709405338743e-02,   2.638601638752263e-04,   3.716105334979249e-07,  -1.252658855780356e-07,
   2.562422000097488e-09,   1.692150376148929e-11,  -1.514858936239488e-12,   4.497996276171920e-14,  -2.115358515982064e-16,  -5.408255266576049e-17,   9.922099168726278e-19,
   2.421064331121034e-20,  -9.240943669511841e-22,   6.241284449642887e-01,  -1.818703259884429e-02,   2.638202920376742e-04,   3.729669893467364e-07,  -1.252522391507538e-07,
   2.560732085754317e-09,   1.698792087165572e-11,  -1.515251947485494e-12,   4.485114759504204e-14,  -2.086581350249708e-16,  -5.399752454945184e-17,   9.884077221874035e-19,
   2.424628758133674e-20,  -9.207257527038947e-22,   6.241333007506760e-01,  -1.818701119224185e-02,   2.638064146261331e-04,   3.734390460167336e-07,  -1.252474852787333e-07,
   2.560143862161868e-09,   1.701102301468078e-11,  -1.515388310437247e-12,   4.480632820209982e-14,  -2.076573849741423e-16,  -5.396792003846632e-17,   9.870854221891505e-19,
   2.425866564571918e-20,  -9.195538967675147e-22,   6.241340712892660e-01,  -1.818700779451203e-02,   2.638042124885071e-04,   3.735139515758032e-07,  -1.252467307097458e-07,
   2.560050517593995e-09,   1.701468829744634e-11,  -1.515409929038385e-12,   4.479921673688993e-14,  -2.074986208003142e-16,  -5.396322175041166e-17,   9.868756430622068e-19,
   2.426062853257481e-20,  -9.193679688881314e-22,   1.191080147382330e+00,  -2.454875363102271e-02,  -7.575006875134642e-05,   1.023477043314033e-05,   2.537986875571081e-08,
  -8.186663615864260e-09,   9.593929253309105e-12,   8.814517169699314e-12,   3.031692229335089e-15,  -9.175099353085707e-15,  -2.586068936106669e-17,   8.617538142795660e-18,
   1.070145168565750e-20,  -8.740352780050581e-21,   1.191073074641394e+00,  -2.454590161226743e-02,  -7.573571605231968e-05,   1.022723691523787e-05,   2.539342491100974e-08,
  -8.169782856096252e-09,   9.599690161186333e-12,   8.784641588351463e-12,   2.924949382737141e-15,  -9.132932514984277e-15,  -2.578834129498049e-17,   8.558515461926743e-18,
   1.083469360737981e-20,  -8.650295302126347e-21,   1.191060595781656e+00,  -2.454087087839828e-02,  -7.571038427530756e-05,   1.021395662578145e-05,   2.541735068541696e-08,
  -8.140043775247169e-09,   9.609629016055744e-12,   8.732039705542968e-12,   2.736853456720972e-15,  -9.058770946329970e-15,  -2.566001841392737e-17,   8.454891214406499e-18,
   1.106920409761942e-20,  -8.492370969732248e-21,   1.191045508092011e+00,  -2.453479055468873e-02,  -7.567974222341275e-05,   1.019791962451801e-05,   2.544629157303659e-08,
  -8.104163462701583e-09,   9.621261602763342e-12,   8.668626962667667e-12,   2.509839651049464e-15,  -8.969505956048731e-15,  -2.550371968576704e-17,   8.330474120788187e-18,
   1.135174634797172e-20,  -8.303075889382789e-21,   1.191030863194125e+00,  -2.452889090917186e-02,  -7.564998435150597e-05,   1.018237383928427e-05,   2.547439669893777e-08,
  -8.069415619512426e-09,   9.632151019092084e-12,   8.607269568705822e-12,   2.289914820727162e-15,  -8.883278579999256e-15,  -2.535080770626238e-17,   8.210615432106319e-18,
   1.162493869071616e-20,  -8.121048483464094e-21,   1.191019066866666e+00,  -2.452414039889819e-02,  -7.562600384369760e-05,   1.016986656933768e-05,   2.549704469566295e-08,
  -8.041483386349327e-09,   9.640634770125432e-12,   8.557985609346318e-12,   2.113074522901638e-15,  -8.814121364054119e-15,  -2.522678037663384e-17,   8.114716832632258e-18,
   1.184422337516046e-20,  -7.975646766819659e-21,   1.191011272755010e+00,  -2.452100240686207e-02,  -7.561015405674203e-05,   1.016160991739279e-05,   2.551201338968535e-08,
  -8.023055684075544e-09,   9.646099502745219e-12,   8.525490363008122e-12,   1.996382901630925e-15,  -8.768573015986427e-15,  -2.514441315710005e-17,   8.051669505912388e-18,
   1.198872881783876e-20,  -7.880170714190886e-21,   1.191007270319582e+00,  -2.451939122563087e-02,  -7.560201322821202e-05,   1.015737218185928e-05,   2.551970153762971e-08,
  -8.013601266065284e-09,   9.648862272934558e-12,   8.508824334318604e-12,   1.936506172489727e-15,  -8.745227883687720e-15,  -2.510198635205466e-17,   8.019390583930958e-18,
   1.206281648913768e-20,  -7.831324990987346e-21,   1.191005877269325e+00,  -2.451883049142567e-02,  -7.559917954651644e-05,   1.015589758912370e-05,   2.552237762708699e-08,
  -8.010312015406248e-09,   9.649816936827851e-12,   8.503027043533573e-12,   1.915673499545524e-15,  -8.737109729544107e-15,  -2.508719906346765e-17,   8.008171327344505e-18,
   1.208858374933037e-20,  -7.814353313373061e-21,   1.191005656213051e+00,  -2.451874151310661e-02,  -7.559872987115314e-05,   1.015566361007263e-05,   2.552280229315949e-08,
  -8.009790125261498e-09,   9.649968099258786e-12,   8.502107258146310e-12,   1.912368019883893e-15,  -8.735821838202630e-15,  -2.508485156337152e-17,   8.006391731474660e-18,
   1.209267172493967e-20,  -7.811661542334686e-21,   1.787532305036150e+00,  -1.227268680914210e-02,  -4.378833365899583e-04,  -9.494074519873117e-06,  -6.488948117504190e-09,
   9.282000185192800e-09,   3.961286497493396e-10,   6.072367111231417e-12,  -2.054494994313396e-13,  -1.566550148289024e-14,  -4.127871616536654e-16,   1.055384995732516e-18,
   5.272313781201339e-19,   2.101024814165528e-20,   1.787491252527232e+00,  -1.227532601550208e-02,  -4.378838845420073e-04,  -9.485279998135764e-06,  -5.938717618125013e-09,
   9.293119834269841e-09,   3.955559303941252e-10,   6.019805995771328e-12,  -2.070833757766824e-13,  -1.565445989889684e-14,  -4.094524061272307e-16,   1.200633072798568e-18,
   5.288936152252240e-19,   2.086072361261413e-20,   1.787418815054996e+00,  -1.227998090998559e-02,  -4.378846014110682e-04,  -9.469753707786084e-06,  -4.968495024441073e-09,
   9.312656663963215e-09,   3.945419365859435e-10,   5.927095463080298e-12,  -2.099548778675267e-13,  -1.563437667835906e-14,  -4.035605509590744e-16,   1.456013363163419e-18,
   5.317600491512154e-19,   2.059514007066011e-20,   1.787331223457481e+00,  -1.228560620129735e-02,  -4.378850421986993e-04,  -9.450965182295945e-06,  -3.796432750062155e-09,
   9.336137679187907e-09,   3.933099873679370e-10,   5.815048638359399e-12,  -2.134075062424274e-13,  -1.560907114538794e-14,  -3.964232811180744e-16,   1.763259627429163e-18,
   5.351127880935037e-19,   2.027104708050595e-20,   1.787246191661751e+00,  -1.229106351522293e-02,  -4.378850242177906e-04,  -9.432711034256468e-06,  -2.659813445276042e-09,
   9.358782813213778e-09,   3.921079623479681e-10,   5.706339504474376e-12,  -2.167386882543414e-13,  -1.558343951661423e-14,  -3.894814556153960e-16,   2.059884220447001e-18,
   5.382490823399182e-19,   1.995337479251563e-20,   1.787177691602077e+00,  -1.229545726047026e-02,  -4.378846904474984e-04,  -9.417995327999968e-06,  -1.745028767867874e-09,
   9.376918124650037e-09,   3.911352926500808e-10,   5.618811685072461e-12,  -2.194074922125163e-13,  -1.556203001951401e-14,  -3.838800389837940e-16,   2.297656570439300e-18,
   5.406909219538937e-19,   1.969530414770039e-20,   1.787132428207470e+00,  -1.229835929760863e-02,  -4.378843136457894e-04,  -9.408266374239432e-06,  -1.140977894023032e-09,
   9.388849087098173e-09,   3.904904539489099e-10,   5.560998201073797e-12,  -2.211637610311930e-13,  -1.554751137802741e-14,  -3.801743142492681e-16,   2.454189866662563e-18,
   5.422630381825505e-19,   1.952372963878953e-20,   1.787109183358991e+00,  -1.229984923923610e-02,  -4.378840718343268e-04,  -9.403268524175888e-06,  -8.308997455408730e-10,
   9.394959965676860e-09,   3.901586453707415e-10,   5.531315514618256e-12,  -2.220634521438514e-13,  -1.553994063986916e-14,  -3.782699015271180e-16,   2.534396562705712e-18,
   5.430576049069507e-19,   1.943529668182781e-20,   1.787101092787907e+00,  -1.230036776444178e-02,  -4.378839799807783e-04,  -9.401528727557605e-06,  -7.229950602822808e-10,
   9.397084327556204e-09,   3.900430525064438e-10,   5.520985354183491e-12,  -2.223762416386339e-13,  -1.553728732992414e-14,  -3.776068405564116e-16,   2.562284433548256e-18,
   5.433321263141427e-19,   1.940446584071222e-20,   1.787099808926240e+00,  -1.230045004427762e-02,  -4.378839650399001e-04,  -9.401252633974008e-06,  -7.058730631876582e-10,
   9.397421311799262e-09,   3.900247045831050e-10,   5.519346155709292e-12,  -2.224258601097570e-13,  -1.553686542039390e-14,  -3.775016118470516e-16,   2.566708486216515e-18,
   5.433755925095670e-19,   1.939957099657884e-20,   2.190455761286771e-02,  -7.281319197019495e-04,   1.789044667692869e-05,  -3.926179569433394e-07,   7.868066024979712e-09,
  -1.405994005508928e-10,   3.169928652635767e-12,  -4.336498237357048e-14,   1.237831753981926e-16,  -3.449178994523019e-17,   3.367583446006851e-19,   2.031655882675806e-20,
   3.738575272091076e-22,   1.481968408928419e-24,   2.190624377462699e-02,  -7.282428103209598e-04,   1.789489764401119e-05,  -3.927505033619675e-07,   7.872527987123740e-09,
  -1.406865772824117e-10,   3.170284637560942e-12,  -4.347866155081825e-14,   1.252762060759146e-16,  -3.438703955432070e-17,   3.390170012888190e-19,   2.031787006214584e-20,
   3.727570851809216e-22,   1.308722459266867e-24,   2.190921937587805e-02,  -7.284385090018611e-04,   1.790275348711045e-05,  -3.929844506046701e-07,   7.880401608946472e-09,
  -1.408405826085735e-10,   3.170916008624720e-12,  -4.367896286662719e-14,   1.279183786899683e-16,  -3.420221007348337e-17,   3.429963142680528e-19,   2.031915949836193e-20,
   3.707619057261581e-22,   1.003435398213403e-24,   2.191281808846197e-02,  -7.286752018497364e-04,   1.791225633786147e-05,  -3.932674564474928e-07,   7.889923194295419e-09,
  -1.410271151379390e-10,   3.171684987983017e-12,  -4.392067936939598e-14,   1.311264300008773e-16,  -3.397872243690442e-17,   3.477975226186713e-19,   2.031897408685145e-20,
   3.682588234303190e-22,   6.349984241933446e-25,   2.191631226778732e-02,  -7.289050335446486e-04,   1.792148518667666e-05,  -3.935423134731559e-07,   7.899167339389048e-09,
  -1.412085194479432e-10,   3.172437293260157e-12,  -4.415482048339056e-14,   1.342544575573720e-16,  -3.376177887041671e-17,   3.524471029663615e-19,   2.031696954875328e-20,
   3.657349001385036e-22,   2.781093459314287e-25,   2.191912757140531e-02,  -7.290902219386319e-04,   1.792892243959524e-05,  -3.937638206765200e-07,   7.906614845624262e-09,
  -1.413548866572276e-10,   3.173047501632530e-12,  -4.434307392029970e-14,   1.367841627739980e-16,  -3.358702487736399e-17,   3.561844519238445e-19,   2.031404917021309e-20,
   3.636348815782839e-22,  -8.813837328236187e-27,   2.192098808847368e-02,  -7.292126102147277e-04,   1.793383812295123e-05,  -3.939102308116880e-07,   7.911536291953962e-09,
  -1.414517161269136e-10,   3.173452757857420e-12,  -4.446728846117803e-14,   1.384605429008880e-16,  -3.347155794086046e-17,   3.586499008395246e-19,   2.031148091850620e-20,
   3.622147532915679e-22,  -1.981142099955560e-25,   2.192194361938314e-02,  -7.292754683534118e-04,   1.793636295715097e-05,  -3.939854324551570e-07,   7.914063772861878e-09,
  -1.415014774987386e-10,   3.173661508505976e-12,  -4.453102291419549e-14,   1.393229262777005e-16,  -3.341226265529943e-17,   3.599147375408625e-19,   2.030996468552923e-20,
   3.614754543024018e-22,  -2.952365068551918e-25,   2.192227621123397e-02,  -7.292973476440327e-04,   1.793724181179528e-05,  -3.940116091514503e-07,   7.914943498927127e-09,
  -1.415188029388996e-10,   3.173734266802624e-12,  -4.455319741374327e-14,   1.396233225306958e-16,  -3.339162480805695e-17,   3.603547690673483e-19,   2.030940554819276e-20,
   3.612165475053010e-22,  -3.290259273034889e-25,   2.192232898948185e-02,  -7.293008196307451e-04,   1.793738127691339e-05,  -3.940157631311894e-07,   7.915083099964388e-09,
  -1.415215525105535e-10,   3.173745817325400e-12,  -4.455671578079712e-14,   1.396710024718867e-16,  -3.338834988626973e-17,   3.604245861840376e-19,   2.030931533048813e-20,
   3.611753873070836e-22,  -3.343871331744023e-25,   1.981922609449365e-01,  -6.340166400341444e-03,   1.405597076394636e-04,  -2.507655361085214e-06,   3.268484589807705e-08,
  -1.059516579092681e-10,  -9.224837549517021e-13,   2.814431457759533e-13,  -1.210764701581826e-14,  -1.352308792390755e-16,   1.072364810727712e-18,   2.056708273307355e-19,
   4.193525480462994e-21,  -1.154381018953929e-23,   1.982054752792253e-01,  -6.340872009708691e-03,   1.405780831897785e-04,  -2.507750095377111e-06,   3.268317431842997e-08,
  -1.054043299522312e-10,  -9.541532403265977e-13,   2.810141600700244e-13,  -1.210229613349965e-14,  -1.341778829978861e-16,   1.098116498033236e-18,   2.054928498437851e-19,
   4.190127561462776e-21,  -1.324433454959362e-23,   1.982287935796373e-01,  -6.342117089421419e-03,   1.406105062852915e-04,  -2.507916840419736e-06,   3.268018862804987e-08,
  -1.044392342860378e-10,  -1.010022625865122e-12,   2.802600914860694e-13,  -1.209276629055406e-14,  -1.323206962662961e-16,   1.143532414673173e-18,   2.051687413476999e-19,
   4.183563044851574e-21,  -1.624172678607664e-23,   1.982569927041470e-01,  -6.343622688657483e-03,   1.406497111746147e-04,  -2.508117762861153e-06,   3.267651665013960e-08,
  -1.032733748723323e-10,  -1.077560031280264e-12,   2.793531785098022e-13,  -1.208109250257886e-14,  -1.300764302135105e-16,   1.198408104857969e-18,   2.047596800931198e-19,
   4.174661340245022e-21,  -1.986048858777369e-23,   1.982843704251461e-01,  -6.345084335473581e-03,   1.406877690548161e-04,  -2.508312074497286e-06,   3.267288741149914e-08,
  -1.021427732987598e-10,  -1.143102593677859e-12,   2.784779076374399e-13,  -1.206960258702410e-14,  -1.278993053984822e-16,   1.251634341690918e-18,   2.043446351387056e-19,
   4.165018182484661e-21,  -2.336722337168465e-23,   1.983064273516641e-01,  -6.346261845693534e-03,   1.407184268690882e-04,  -2.508468079244317e-06,   3.266991750580593e-08,
  -1.012328284375204e-10,  -1.195887250796557e-12,   2.777764852821423e-13,  -1.206023388516918e-14,  -1.261465926173020e-16,   1.294477938504838e-18,   2.039974438970728e-19,
   4.156537653360674e-21,  -2.618747467754036e-23,   1.983210030524420e-01,  -6.347039936448095e-03,   1.407386844545711e-04,  -2.508570904935909e-06,   3.266793240911882e-08,
  -1.006319696207083e-10,  -1.230758737461962e-12,   2.773148012594314e-13,  -1.205398811936238e-14,  -1.249890050691907e-16,   1.322770512887967e-18,   2.037617469477282e-19,
   4.150587401604440e-21,  -2.804864401869346e-23,   1.983284886433253e-01,  -6.347439527289375e-03,   1.407490875224087e-04,  -2.508623630632688e-06,   3.266690596738313e-08,
  -1.003235284422742e-10,  -1.248664531075642e-12,   2.770782619945507e-13,  -1.205076358680264e-14,  -1.243947081625332e-16,   1.337294480138488e-18,   2.036387646796218e-19,
   4.147424983934087e-21,  -2.900368202597098e-23,   1.983310941149443e-01,  -6.347578609178747e-03,   1.407527083780416e-04,  -2.508641969526171e-06,   3.266654759065873e-08,
  -1.002161931129481e-10,  -1.254896426205578e-12,   2.769960210909730e-13,  -1.204963854754229e-14,  -1.241878864862110e-16,   1.342348771714650e-18,   2.035956507433234e-19,
   4.146307333939413e-21,  -2.933596887461327e-23,   1.983315075694560e-01,  -6.347600679589387e-03,   1.407532829566611e-04,  -2.508644879049902e-06,   3.266649066831115e-08,
  -1.001991614446995e-10,  -1.255885324062979e-12,   2.769829748053940e-13,  -1.204945989060784e-14,  -1.241550681060162e-16,   1.343150774800281e-18,   2.035887944965120e-19,
   4.146129174851691e-21,  -2.938869235466968e-23,   5.553381257834683e-01,  -1.608517707567418e-02,   2.584218839224281e-04,  -1.236064486582234e-06,  -7.250613716750680e-08,
   2.612492796354955e-09,  -9.177310776843947e-12,  -4.722496425357061e-13,   1.089290902918728e-14,  -1.371228198074558e-15,   1.700751115610405e-18,   1.328402663816936e-18,
  -3.162223479210382e-21,   4.463312741922512e-24,   5.553622707711673e-01,  -1.608551612300748e-02,   2.583810285575079e-04,  -1.233623757346616e-06,  -7.251870276082346e-08,
   2.611492674984862e-09,  -9.148580277295370e-12,  -4.766995075708294e-13,   1.089959573850881e-14,  -1.364396066006316e-15,   1.684991900554022e-18,   1.328019451212919e-18,
  -3.076754591744005e-21,  -3.093017863313246e-24,   5.554048718601335e-01,  -1.608611382078104e-02,   2.583089329560590e-04,  -1.229317835967425e-06,  -7.254084204787755e-08,
   2.609720910297260e-09,  -9.097870874251142e-12,  -4.845326322741785e-13,   1.091134373485221e-14,  -1.352342692917133e-15,   1.657589412950901e-18,   1.327298528734264e-18,
  -2.928221337445127e-21,  -1.641314264601195e-23,   5.554563802291007e-01,  -1.608683561442892e-02,   2.582217445315371e-04,  -1.224112409819155e-06,  -7.256755700227913e-08,
   2.607566499112856e-09,  -9.036528748397126e-12,  -4.939725948087051e-13,   1.092546382215822e-14,  -1.337771217261023e-15,   1.625136683690622e-18,   1.326350560426961e-18,
  -2.752477337981761e-21,  -3.249662464776869e-23,   5.555063780875538e-01,  -1.608753532570860e-02,   2.581370934229458e-04,  -1.219060480065069e-06,  -7.259343264806455e-08,
   2.605462520744142e-09,  -8.976954068597298e-12,  -5.031033101004980e-13,   1.093908275637486e-14,  -1.323629405696086e-15,   1.594337177877455e-18,   1.325350550613085e-18,
  -2.585888822318580e-21,  -4.808452481313467e-23,   5.555466517177537e-01,  -1.608809829229365e-02,   2.580688923667343e-04,  -1.214991723120407e-06,  -7.261423561401871e-08,
   2.603758635863219e-09,  -8.928943770804230e-12,  -5.104349422533961e-13,   1.094999131820201e-14,  -1.312239873399214e-15,   1.570023761360334e-18,   1.324487880969510e-18,
  -2.454550049296504e-21,  -6.062269757537063e-23,   5.555732618592939e-01,  -1.608846994215304e-02,   2.580238227904386e-04,  -1.212303657810560e-06,  -7.262796121745758e-08,
   2.602628365716541e-09,  -8.897210774923282e-12,  -5.152678276708770e-13,   1.095716913797832e-14,  -1.304715353020691e-15,   1.554199080314944e-18,   1.323889922826960e-18,
  -2.369158126323667e-21,  -6.889793941766163e-23,   5.555869268353381e-01,  -1.608866069439313e-02,   2.580006763146010e-04,  -1.210923361572954e-06,  -7.263500359200137e-08,
   2.602046566997044e-09,  -8.880911694527996e-12,  -5.177461194164152e-13,   1.096084597015261e-14,  -1.300851619263652e-15,   1.546146351082479e-18,   1.323574212951200e-18,
  -2.325734965321498e-21,  -7.314458159251044e-23,   5.555916829590898e-01,  -1.608872707030481e-02,   2.579926197979544e-04,  -1.210442961355907e-06,  -7.263745373924407e-08,
   2.601843851698144e-09,  -8.875238225954807e-12,  -5.186081342972141e-13,   1.096212424729837e-14,  -1.299506886652090e-15,   1.543355253775225e-18,   1.323462953836896e-18,
  -2.310689403445198e-21,  -7.462216586559550e-23,   5.555924376858550e-01,  -1.608873760243359e-02,   2.579913413314712e-04,  -1.210366729622611e-06,  -7.263784249564695e-08,
   2.601811673371636e-09,  -8.874337904491428e-12,  -5.187448967833322e-13,   1.096232702223524e-14,  -1.299293499699397e-15,   1.542912900822441e-18,   1.323445233357438e-18,
  -2.308305118048388e-21,  -7.485661434861693e-23,   1.092444909752149e+00,  -2.466854032045945e-02,   4.436232563645865e-05,   9.423766822600161e-06,  -1.172667712918153e-07,
  -5.278475856052034e-09,   2.107559045205178e-10,   4.117321378713173e-12,  -2.637437358205583e-13,  -3.861447826573539e-15,   2.365041381315111e-16,   1.599696092264902e-18,
  -1.926014896282382e-19,   3.072843947353872e-21,   1.092448939593531e+00,  -2.466590707394527e-02,   4.429798713480821e-05,   9.418884506906107e-06,  -1.169783193975806e-07,
  -5.270572885067603e-09,   2.100833478481390e-10,   4.104525917151776e-12,  -2.627813594369082e-13,  -3.852468535578385e-15,   2.353918155896825e-16,   1.618972743605776e-18,
  -1.908572332237587e-19,   3.014210603047593e-21,   1.092456045600126e+00,  -2.466126177390715e-02,   4.418459089234876e-05,   9.410275545149756e-06,  -1.164701026749292e-07,
  -5.256648330586079e-09,   2.088986435914011e-10,   4.081973287757110e-12,  -2.610869773965083e-13,  -3.836546862694216e-15,   2.334376462820144e-16,   1.652645175781683e-18,
  -1.878006360103978e-19,   2.911276099721002e-21,   1.092464630231468e+00,  -2.465564651043293e-02,   4.404769246514878e-05,   9.399875650205178e-06,  -1.158568578862699e-07,
  -5.239845301668832e-09,   2.074695468446558e-10,   4.054745455610629e-12,  -2.590444804289767e-13,  -3.817162907279773e-15,   2.310891355025457e-16,   1.692782033194108e-18,
  -1.841405107529927e-19,   2.787698903402218e-21,   1.092472955644626e+00,  -2.465019728050663e-02,   4.391502551612905e-05,   9.389790231484976e-06,  -1.152628859255677e-07,
  -5.223569504438596e-09,   2.060858211683587e-10,   4.028358407246190e-12,  -2.570683030442667e-13,  -3.798209038177765e-15,   2.288243257566258e-16,   1.731141307202328e-18,
  -1.806247705202215e-19,   2.668663186551710e-21,   1.092479656477614e+00,  -2.464580886288586e-02,   4.380831652988032e-05,   9.381673148495755e-06,  -1.147853596087181e-07,
  -5.210483911880715e-09,   2.049736962767555e-10,   4.007133898825513e-12,  -2.554810625431189e-13,  -3.782843284478228e-15,   2.270105676537107e-16,   1.761611531312830e-18,
  -1.778192285771433e-19,   2.573434074697584e-21,   1.092484081327590e+00,  -2.464290976529988e-02,   4.373788621907909e-05,   9.376313241585368e-06,  -1.144702929799897e-07,
  -5.201849894713681e-09,   2.042400884391686e-10,   3.993125111976229e-12,  -2.544345571696491e-13,  -3.772642839361987e-15,   2.258173028582766e-16,   1.781535197961303e-18,
  -1.759783905380226e-19,   2.510832751737206e-21,   1.092486352790713e+00,  -2.464142115347681e-02,   4.370174194307475e-05,   9.373561821603363e-06,  -1.143086377368519e-07,
  -5.197419842050626e-09,   2.038637363498521e-10,   3.985935885496437e-12,  -2.538978409780426e-13,  -3.767389952865325e-15,   2.252061175243227e-16,   1.791702012886493e-18,
  -1.750370450702913e-19,   2.478784085105203e-21,   1.092487143249576e+00,  -2.464090306248334e-02,   4.368916558455429e-05,   9.372604347480491e-06,  -1.142523954686117e-07,
  -5.195878546843690e-09,   2.037328057117327e-10,   3.983434399316634e-12,  -2.537111455907878e-13,  -3.765559340593132e-15,   2.249936452116279e-16,   1.795230341633807e-18,
  -1.747100389779824e-19,   2.467645172033306e-21,   1.092487268677643e+00,  -2.464082085019114e-02,   4.368717007894017e-05,   9.372452418200330e-06,  -1.142434717020594e-07,
  -5.195633994197373e-09,   2.037120317725365e-10,   3.983037485430917e-12,  -2.536815249942274e-13,  -3.765268738723259e-15,   2.249599409412325e-16,   1.795789748976752e-18,
  -1.746581778728784e-19,   2.465878335282957e-21,   1.730734466187533e+00,  -1.621556311684118e-02,  -5.445266890839795e-04,  -7.559488498723588e-06,   2.815660731327364e-07,
   1.946435520377626e-08,   3.700418525678838e-10,  -1.201010296408684e-11,  -9.580796555593120e-13,  -1.985420053635928e-14,   5.655655525231865e-16,   4.908750129130293e-17,
   1.100531900196705e-18,  -2.581200380900012e-20,   1.730683740446018e+00,  -1.621762572224307e-02,  -5.443655507167029e-04,  -7.541448416182441e-06,   2.820574206160268e-07,
   1.943975951018950e-08,   3.675805163897419e-10,  -1.207076981300648e-11,  -9.555098923026839e-13,  -1.960963222096276e-14,   5.714279295381241e-16,   4.887207553028377e-17,
   1.079922689894230e-18,  -2.631332270627985e-20,   1.730594246679360e+00,  -1.622126113347278e-02,  -5.440810016359190e-04,  -7.509635440411509e-06,   2.829216183116804e-07,
   1.939626602635548e-08,   3.632430431334418e-10,  -1.217715272869321e-11,  -9.509562250022986e-13,  -1.917901713340035e-14,   5.816697868284801e-16,   4.848913910838016e-17,
   1.043671683724002e-18,  -2.718555183037614e-20,   1.730486051358547e+00,  -1.622565014348765e-02,  -5.437365511809039e-04,  -7.471199351608315e-06,   2.839618581184681e-07,
   1.934351369391282e-08,   3.580076882563361e-10,  -1.230466050723073e-11,  -9.454172471844162e-13,  -1.865990555168445e-14,   5.938801536630074e-16,   4.802133953964180e-17,
   1.000032947448629e-18,  -2.821925774634665e-20,   1.730381039739429e+00,  -1.622990362543387e-02,  -5.434017775877022e-04,  -7.433920357375021e-06,   2.849667288315604e-07,
   1.929213648838426e-08,   3.529353465231891e-10,  -1.242726014964342e-11,  -9.400062327445072e-13,  -1.815763885859625e-14,   6.055518664555349e-16,   4.756229839384931e-17,
   9.578767815871769e-19,  -2.920085133099028e-20,   1.730296459893194e+00,  -1.623332495252420e-02,  -5.431318117895110e-04,  -7.403913356022681e-06,   2.857726782849393e-07,
   1.925062927970949e-08,   3.488563591967359e-10,  -1.252517903723107e-11,  -9.356231355940440e-13,  -1.775422842754116e-14,   6.148244823852729e-16,   4.718902782817232e-17,
   9.240663854688589e-19,  -2.997597135697952e-20,   1.730240578947933e+00,  -1.623558314848318e-02,  -5.429532881092223e-04,  -7.384097263063169e-06,   2.863034932337874e-07,
   1.922314434548600e-08,   3.461645844472452e-10,  -1.258946862544873e-11,  -9.327151716587123e-13,  -1.748825676999016e-14,   6.208881767217598e-16,   4.694069477814116e-17,
   9.017990893669339e-19,  -3.048052385011606e-20,   1.730211883855879e+00,  -1.623674204991963e-02,  -5.428615659463149e-04,  -7.373924465578515e-06,   2.865755536977032e-07,
   1.920901172497273e-08,   3.447833284566756e-10,  -1.262235667577616e-11,  -9.312181957031500e-13,  -1.735185212161318e-14,   6.239825724005407e-16,   4.681264736300330e-17,
   8.903867694362595e-19,  -3.073728032101360e-20,   1.730201896655966e+00,  -1.623714529039151e-02,  -5.428296345730421e-04,  -7.370384321915940e-06,   2.866701611488267e-07,
   1.920408990947628e-08,   3.443027448283059e-10,  -1.263378334062576e-11,  -9.306965884439091e-13,  -1.730440466303391e-14,   6.250564874112969e-16,   4.676799739776651e-17,
   8.864182789679977e-19,  -3.082627224792286e-20,   1.730200311843386e+00,  -1.623720927312984e-02,  -5.428245671890284e-04,  -7.369822577966982e-06,   2.866851699812522e-07,
   1.920330875101065e-08,   3.442264911447149e-10,  -1.263559563045487e-11,  -9.306137894780122e-13,  -1.729687680292758e-14,   6.252267549813830e-16,   4.676090818249767e-17,
   8.857887087094882e-19,  -3.084037627111663e-20,   1.925120900647155e-02,  -6.019028138283009e-04,   1.385382157588898e-05,  -2.855093984270204e-07,   5.716448671380220e-09,
  -7.964941007546110e-11,   1.854700135879709e-12,  -5.461206733618339e-14,  -6.136747758849262e-16,   1.725367956936859e-18,   1.553553418695547e-18,   2.910777881097914e-20,
  -4.543738071793995e-22,  -4.968003299719257e-23,   1.925251428431093e-02,  -6.019833795828786e-04,   1.385705168749279e-05,  -2.855849721030050e-07,   5.719039563980545e-09,
  -7.975677140412998e-11,   1.853221983402500e-12,  -5.460274630479168e-14,  -6.072308979756936e-16,   1.861647020085816e-18,   1.550208427262762e-18,   2.875170404154696e-20,
  -4.661824084349728e-22,  -4.955976905043960e-23,   1.925481771556361e-02,  -6.021255565638111e-04,   1.386275245117822e-05,  -2.857184048239621e-07,   5.723609596942191e-09,
  -7.994619554311442e-11,   1.850627443959969e-12,  -5.458593538922279e-14,  -5.958725067047055e-16,   2.100628773367469e-18,   1.544248957442169e-18,   2.812421612603100e-20,
  -4.868173915798721e-22,  -4.934032376277879e-23,   1.925760347211764e-02,  -6.022975082369349e-04,   1.386964788865574e-05,  -2.858798925293037e-07,   5.729132947725970e-09,
  -8.017522051660792e-11,   1.847513413360270e-12,  -5.456498990591931e-14,  -5.821582959590268e-16,   2.387078838942044e-18,   1.536945896140577e-18,   2.736686351450343e-20,
  -5.114266483012750e-22,  -4.906274352731818e-23,   1.926030827926459e-02,  -6.024644671135959e-04,   1.387634396749256e-05,  -2.860368079993999e-07,   5.734492021482440e-09,
  -8.039752342552434e-11,   1.844514757826989e-12,  -5.454401325187966e-14,  -5.688663876736812e-16,   2.662514235678052e-18,   1.529755714186550e-18,   2.663315408497357e-20,
  -5.349588987039282e-22,  -4.878061977700174e-23,   1.926248755412352e-02,  -6.025989893573621e-04,   1.388173975109844e-05,  -2.861633216620720e-07,   5.738807153659128e-09,
  -8.057658550547513e-11,   1.842116540067711e-12,  -5.452665642070888e-14,  -5.581741994166263e-16,   2.882508310244574e-18,   1.523892009953753e-18,   2.604319841422138e-20,
  -5.536603668672678e-22,  -4.854438219411421e-23,   1.926392773555592e-02,  -6.026878902044710e-04,   1.388530592773432e-05,  -2.862469708482784e-07,   5.741657507474593e-09,
  -8.069489550238530e-11,   1.840540382850588e-12,  -5.451496394161422e-14,  -5.511166769850635e-16,   3.026950504648123e-18,   1.519982674723548e-18,   2.565392039701327e-20,
  -5.658929959656996e-22,  -4.838393424864627e-23,   1.926466738570389e-02,  -6.027335484290002e-04,   1.388713755856216e-05,  -2.862899445447810e-07,   5.743120989431019e-09,
  -8.075564990404131e-11,   1.839733591095197e-12,  -5.450889042193959e-14,  -5.474946881492234e-16,   3.100842320292882e-18,   1.517964364540682e-18,   2.545418104605509e-20,
  -5.721364493352335e-22,  -4.830020130118544e-23,   1.926492483536500e-02,  -6.027494407312833e-04,   1.388777511081793e-05,  -2.863049044545804e-07,   5.743630318271926e-09,
  -8.077679547918137e-11,   1.839453200064510e-12,  -5.450676553233847e-14,  -5.462344026012380e-16,   3.126515504109662e-18,   1.517260177724818e-18,   2.538468775393897e-20,
  -5.743034027656045e-22,  -4.827084549956785e-23,   1.926496568944391e-02,  -6.027519626463782e-04,   1.388787628330706e-05,  -2.863072785059220e-07,   5.743711139398017e-09,
  -8.078015096453594e-11,   1.839408725816609e-12,  -5.450642782239229e-14,  -5.460344307390284e-16,   3.130587323273067e-18,   1.517148352580960e-18,   2.537366145002549e-20,
  -5.746469771645586e-22,  -4.826617710012322e-23,   1.749023098687427e-01,  -5.327324857874882e-03,   1.135370760688908e-04,  -2.001012153264502e-06,   3.074004830048328e-08,
  -8.100847852646943e-11,   9.800649526719149e-13,  -1.545629069616015e-13,  -1.352478130511411e-14,   1.408182824283474e-16,   1.358199492355381e-17,   3.031273254573465e-19,
  -4.256712800309860e-21,  -4.857425176909553e-22,   1.749129886705559e-01,  -5.327887918221611e-03,   1.135543725909751e-04,  -2.001090579564563e-06,   3.074102216400092e-08,
  -8.130454989391777e-11,   9.457210011922459e-13,  -1.540509777015203e-13,  -1.346852773242246e-14,   1.422455347959306e-16,   1.355029869218807e-17,   2.996292870038302e-19,
  -4.375261239220653e-21,  -4.848744187089400e-22,   1.749318329034894e-01,  -5.328881465437437e-03,   1.135848929275043e-04,  -2.001229187103850e-06,   3.074270175108348e-08,
  -8.182613527591367e-11,   8.852399623097912e-13,  -1.531438538416829e-13,  -1.336938075067024e-14,   1.447493406255645e-16,   1.349379592835991e-17,   2.934631224336020e-19,
  -4.582440282030613e-21,  -4.832664078929869e-22,   1.749546218005398e-01,  -5.330082904713550e-03,   1.136217990314019e-04,  -2.001397172777399e-06,   3.074466664378103e-08,
  -8.245541029074861e-11,   8.123090670190337e-13,  -1.520404696751981e-13,  -1.324968571923315e-14,   1.477520886463129e-16,   1.342449986869749e-17,   2.860177683246971e-19,
  -4.829557288369562e-21,  -4.811931619082573e-22,   1.749767472227124e-01,  -5.331249274056967e-03,   1.136576274375282e-04,  -2.001560647676920e-06,   3.074650504588569e-08,
  -8.306479520693682e-11,   7.417218206708329e-13,  -1.509625722156903e-13,  -1.313369326625046e-14,   1.506410747136659e-16,   1.335621899154240e-17,   2.788016792406866e-19,
  -5.065895999048906e-21,  -4.790470758898315e-22,   1.749945728627216e-01,  -5.332188909629318e-03,   1.136864907542369e-04,  -2.001692625201929e-06,   3.074793662549251e-08,
  -8.355462622693851e-11,   6.850099717903263e-13,  -1.500894194070106e-13,  -1.304039960303152e-14,   1.529497721965035e-16,   1.330049567680889e-17,   2.729971650150596e-19,
  -5.253744119208086e-21,  -4.772236710988697e-22,   1.750063525544024e-01,  -5.332809815642931e-03,   1.137055633203963e-04,  -2.001779972623289e-06,   3.074885842748727e-08,
  -8.387776681219047e-11,   6.476103089017117e-13,  -1.495101091110042e-13,  -1.297882591811923e-14,   1.544662030216638e-16,   1.326332605599668e-17,   2.691659993152639e-19,
  -5.376628074916397e-21,  -4.759729265682573e-22,   1.750124022452639e-01,  -5.333128684169849e-03,   1.137153580568413e-04,  -2.001824872663185e-06,   3.074932435230335e-08,
  -8.404355042608406e-11,   6.284268240075220e-13,  -1.492118819989589e-13,  -1.294722759319902e-14,   1.552421454126931e-16,   1.324413038234344e-17,   2.671998816234008e-19,
  -5.439351079691665e-21,  -4.753165129067685e-22,   1.750145079362529e-01,  -5.333239669850874e-03,   1.137187672142088e-04,  -2.001840507369376e-06,   3.074948533396474e-08,
  -8.410122670852315e-11,   6.217535018620476e-13,  -1.491079663184258e-13,  -1.293623313092323e-14,   1.555117708788789e-16,   1.323743211776272e-17,   2.665157763511080e-19,
  -5.461121345051352e-21,  -4.750858059017598e-22,   1.750148420823441e-01,  -5.333257281777002e-03,   1.137193082009878e-04,  -2.001842988706394e-06,   3.074951082316446e-08,
  -8.411037789478095e-11,   6.206947115307169e-13,  -1.490914708753022e-13,  -1.293448863340424e-14,   1.555545354434635e-16,   1.323636838768461e-17,   2.664072287506266e-19,
  -5.464573089037089e-21,  -4.750490898776592e-22,   4.950154957868680e-01,  -1.409298292701718e-02,   2.383021993590035e-04,  -1.994475616381953e-06,  -2.350918959048555e-08,
   2.230593395001546e-09,  -2.419731943388227e-11,  -7.884135455635859e-13,  -2.351999449041387e-14,  -1.749368549723929e-16,   5.663801200850930e-17,   1.068480430861877e-18,
  -1.981605186965139e-20,  -1.401815846900463e-21,   4.950378096293099e-01,  -1.409353655546386e-02,   2.382887792819783e-04,  -1.992397554945990e-06,  -2.354388261133011e-08,
   2.229034203390803e-09,  -2.425423621708712e-11,  -7.888722808222141e-13,  -2.328575475041398e-14,  -1.698251538514806e-16,   5.649491465760012e-17,   1.058253586316770e-18,
  -2.026874672026782e-20,  -1.401817645013409e-21,   4.950771817094858e-01,  -1.409451296870242e-02,   2.382650833249078e-04,  -1.988731973242621e-06,  -2.360516217367426e-08,
   2.226282315117270e-09,  -2.435416978381856e-11,  -7.896679927277126e-13,  -2.287294352457807e-14,  -1.608483029187368e-16,   5.624021997205618e-17,   1.040212192586243e-18,
  -2.106027920623887e-20,  -1.401518268958948e-21,   4.951247890653923e-01,  -1.409569285193570e-02,   2.382364025859099e-04,  -1.984301542714500e-06,  -2.367936941743772e-08,
   2.222953574565585e-09,  -2.447416386752139e-11,  -7.906068394094784e-13,  -2.237463982740296e-14,  -1.500664030857371e-16,   5.592851898534307e-17,   1.018404425891181e-18,
  -2.200505664613561e-20,  -1.400644614585373e-21,   4.951710035930186e-01,  -1.409683741826667e-02,   2.382085311722869e-04,  -1.980002683677539e-06,  -2.375152043919922e-08,
   2.219720928635734e-09,  -2.458976641530593e-11,  -7.914939201844268e-13,  -2.189181483102049e-14,  -1.396759459654463e-16,   5.562205971956123e-17,   9.972438064026357e-19,
  -2.290931833677684e-20,  -1.399266079914525e-21,   4.952082320752901e-01,  -1.409775886154389e-02,   2.381860577802288e-04,  -1.976541102454637e-06,  -2.380972420230725e-08,
   2.217115931634135e-09,  -2.468226046306770e-11,  -7.921911770399788e-13,  -2.150352067956521e-14,  -1.313602678925977e-16,   5.537243295155589e-17,   9.802053049136997e-19,
  -2.362854508477515e-20,  -1.397779305421236e-21,   4.952328313366740e-01,  -1.409836743894779e-02,   2.381711976975115e-04,  -1.974254497409209e-06,  -2.384822316276190e-08,
   2.215394200116921e-09,  -2.474306880666050e-11,  -7.926434393096469e-13,  -2.124726943687713e-14,  -1.258922094847381e-16,   5.520614794922841e-17,   9.689510180049180e-19,
  -2.409928257591963e-20,  -1.396614179018036e-21,   4.952454640313309e-01,  -1.409867988106911e-02,   2.381635632196721e-04,  -1.973080447088911e-06,  -2.386800623702893e-08,
   2.214509887298339e-09,  -2.477420096682547e-11,  -7.928730836007785e-13,  -2.111577355427979e-14,  -1.230923841685386e-16,   5.512034136643551e-17,   9.631728704381687e-19,
  -2.433963405436793e-20,  -1.395959656674229e-21,   4.952498609240539e-01,  -1.409878861484585e-02,   2.381609054738098e-04,  -1.972671844865960e-06,  -2.387489382749453e-08,
   2.214202074912844e-09,  -2.478502154873163e-11,  -7.929525977964548e-13,  -2.107002138382173e-14,  -1.221191980328743e-16,   5.509041029412880e-17,   9.611619748933588e-19,
  -2.442306867431522e-20,  -1.395722930083690e-21,   4.952505586488387e-01,  -1.409880586870730e-02,   2.381604837025982e-04,  -1.972607007064878e-06,  -2.387598688387833e-08,
   2.214153228416572e-09,  -2.478673790212412e-11,  -7.929651958853771e-13,  -2.106276191307832e-14,  -1.219648293959089e-16,   5.508565754835902e-17,   9.608428850981767e-19,
  -2.443629806716367e-20,  -1.395684942236980e-21,   9.951435426225933e-01,  -2.389931403562991e-02,   1.436598748740975e-04,   6.998812389611755e-06,  -1.681495045812906e-07,
   1.470875114314333e-10,   2.001405610452612e-10,  -4.712586643550117e-12,  -2.341187036436656e-13,   5.145511203436941e-15,   1.905725218491371e-16,  -1.751223237770095e-18,
   2.023753047047689e-20,  -6.421985686049516e-22,   9.951568239750375e-01,  -2.389734541993519e-02,   1.435668360539434e-04,   6.998874831879594e-06,  -1.678751031093495e-07,
   1.380814431467114e-10,   1.995425951472979e-10,  -4.695463480322521e-12,  -2.333150685865375e-13,   5.136232245003278e-15,   1.905799231233352e-16,  -1.757409758444355e-18,
   1.764318297359697e-20,  -6.709514037335068e-22,   9.951802522219904e-01,  -2.389387176526180e-02,   1.434027914267271e-04,   6.998978231459653e-06,  -1.673915945050815e-07,
   1.222173809117895e-10,   1.984891894493629e-10,  -4.665275037750813e-12,  -2.318971184652820e-13,   5.119831998004361e-15,   1.905803232118488e-16,  -1.768480719649338e-18,
   1.310085797996801e-20,  -7.204776806375549e-22,   9.952085701353486e-01,  -2.388967138371950e-02,   1.432046378496287e-04,   6.999091715714210e-06,  -1.668080839213387e-07,
   1.030808855735610e-10,   1.972183232365586e-10,  -4.628814636092890e-12,  -2.301826777806644e-13,   5.099953541795791e-15,   1.905593428050350e-16,  -1.782126880234072e-18,
   7.668549572153122e-21,  -7.783179033743118e-22,   9.952360483545695e-01,  -2.388559372609647e-02,   1.430124944131198e-04,   6.999189809792471e-06,  -1.662428278406038e-07,
   8.455216351056010e-11,   1.959876491779913e-10,  -4.593465429432085e-12,  -2.285185328073362e-13,   5.080606028493467e-15,   1.905166530392700e-16,  -1.795639472890322e-18,
   2.457980054444741e-21,  -8.323409582130622e-22,   9.952581756283115e-01,  -2.388230881912410e-02,   1.428578640491456e-04,   6.999260194532175e-06,  -1.657883277041725e-07,
   6.966050259477625e-11,   1.949984270298390e-10,  -4.565021518291464e-12,  -2.271780916984531e-13,   5.064983838947856e-15,   1.904663777508122e-16,  -1.806710717559707e-18,
  -1.694535460812061e-21,  -8.743489809925427e-22,   9.952727926192129e-01,  -2.388013821197090e-02,   1.427557642904279e-04,   6.999302478980463e-06,  -1.654884240787689e-07,
   5.983740498257899e-11,   1.943458402449044e-10,  -4.546242441404646e-12,  -2.262924469787217e-13,   5.054643161124867e-15,   1.904254229351708e-16,  -1.814115586224073e-18,
  -4.416427390017789e-21,  -9.013715089354385e-22,   9.952802978087174e-01,  -2.387902350168263e-02,   1.427033550473262e-04,   6.999322888687252e-06,  -1.653345396109703e-07,
   5.479804397362002e-11,   1.940110377006316e-10,  -4.536603486517990e-12,  -2.258376576036681e-13,   5.049327188738817e-15,   1.904020082747816e-16,  -1.817945556543891e-18,
  -5.807449415649925e-21,  -9.150223974377501e-22,   9.952829098462078e-01,  -2.387863551662058e-02,   1.426851173287431e-04,   6.999329784751723e-06,  -1.652809994623356e-07,
   5.304488696246478e-11,   1.938945594610744e-10,  -4.533249356324369e-12,  -2.256793692192672e-13,   5.047476031260724e-15,   1.903934801372870e-16,  -1.819282913104430e-18,
  -6.290525655003805e-21,  -9.197377508429139e-22,   9.952833243304993e-01,  -2.387857394873774e-02,   1.426822234342728e-04,   6.999330869202960e-06,  -1.652725043629799e-07,
   5.276672490332078e-11,   1.938760784776380e-10,  -4.532717139868298e-12,  -2.256542512845550e-13,   5.047182236013886e-15,   1.903921088898305e-16,  -1.819495336666228e-18,
  -6.367131864986840e-21,  -9.204843070374991e-22,   1.656735323246474e+00,  -2.082616825109447e-02,  -5.942767634745825e-04,   3.597257663274486e-07,   7.126597949496867e-07,
   2.045801407968741e-08,  -4.442841554253996e-10,  -4.496295227992197e-11,  -6.769736457452279e-13,   5.053235265870029e-14,   2.651593920061249e-15,   1.819802681084500e-18,
  -4.213917316480157e-18,  -1.366485606702844e-19,   1.656680407236103e+00,  -2.082600221053344e-02,  -5.938795318870342e-04,   3.781862273135100e-07,   7.120168410153305e-07,
   2.037219273058403e-08,  -4.458490372817866e-10,  -4.479313024236390e-11,  -6.665838391716304e-13,   5.050936834738860e-14,   2.626642156082996e-15,   9.656362046512917e-19,
  -4.190110085630061e-18,  -1.339741793764949e-19,   1.656583536908343e+00,  -2.082570513223641e-02,  -5.931789086856383e-04,   4.106954205206581e-07,   7.108806320341385e-07,
   2.022103100919276e-08,  -4.485886029254676e-10,  -4.449356293105639e-11,  -6.483354438051276e-13,   5.046537796173533e-14,   2.582737189249822e-15,  -5.260749243393090e-19,
  -4.147820035933388e-18,  -1.292863705749574e-19,   1.656466451130368e+00,  -2.082533892593776e-02,  -5.923322165546710e-04,   4.498959103753041e-07,   7.095038226760372e-07,
   2.003870728504716e-08,  -4.518644491776307e-10,  -4.413147644099327e-11,  -6.264132154504303e-13,   5.040637248416061e-14,   2.529857157715525e-15,  -2.303601642493945e-18,
  -4.096211105604372e-18,  -1.236709617793480e-19,   1.656352839520420e+00,  -2.082497612654201e-02,  -5.915107960739340e-04,   4.878360841762837e-07,   7.081642313380147e-07,
   1.986219489741237e-08,  -4.550061347207396e-10,  -4.378013785635928e-11,  -6.052818391648400e-13,   5.034306055244043e-14,   2.478743539351516e-15,  -4.001849682115657e-18,
  -4.045628075344544e-18,  -1.182752340405270e-19,   1.656261353614040e+00,  -2.082467864376607e-02,  -5.908494531746478e-04,   5.183179369039359e-07,   7.070829332022775e-07,
   1.972034572455201e-08,  -4.575095968836661e-10,  -4.349723052266236e-11,  -5.883661328117657e-13,   5.028777557630493e-14,   2.437726504801541e-15,  -5.350458179077896e-18,
  -4.004541838522147e-18,  -1.139683266046027e-19,   1.656200920019973e+00,  -2.082447952198265e-02,  -5.904126371561860e-04,   5.384195778419241e-07,   7.063673884799760e-07,
   1.962678413033448e-08,  -4.591504495967517e-10,  -4.331035455424033e-11,  -5.772410411897281e-13,   5.024916352745857e-14,   2.410701558505315e-15,  -6.232103652536606e-18,
  -3.977230937569929e-18,  -1.111418843744333e-19,   1.656169890248253e+00,  -2.082437647542591e-02,  -5.901883692813003e-04,   5.487303034820125e-07,   7.059996010017200e-07,
   1.957878828126052e-08,  -4.599889742767283e-10,  -4.321440511928302e-11,  -5.715439893018340e-13,   5.022869425052314e-14,   2.396847261895329e-15,  -6.681945403481715e-18,
  -3.963156120631184e-18,  -1.096963944280927e-19,   1.656159090970600e+00,  -2.082434048374629e-02,  -5.901103200389253e-04,   5.523170682536918e-07,   7.058715382075928e-07,
   1.956209124466098e-08,  -4.602801735371117e-10,  -4.318101231634626e-11,  -5.695636576227837e-13,   5.022146811642463e-14,   2.392029022601717e-15,  -6.838052090634437e-18,
  -3.958249454341123e-18,  -1.091942370958577e-19,   1.656157377317571e+00,  -2.082433476641150e-02,  -5.900979351380440e-04,   5.528861445564973e-07,   7.058512139873059e-07,
   1.955944205168162e-08,  -4.603263516794382e-10,  -4.317571349481454e-11,  -5.692495286702449e-13,   5.022031661046786e-14,   2.391264618485938e-15,  -6.862802021431000e-18,
  -3.957470465045541e-18,  -1.091145971496391e-19,   1.704561215336988e-02,  -5.033298990927928e-04,   1.093024771786540e-05,  -2.049260739296298e-07,   4.435227018018752e-09,
  -5.517071776211546e-11,   1.561438030445828e-13,  -5.960419789110574e-14,   7.324170151280525e-16,   7.128988739227924e-17,   1.163201003122669e-18,  -7.422595521188056e-20,
  -3.549375420762346e-21,  -3.096550160222237e-24,   1.704664187309760e-02,  -5.033877201825132e-04,   1.093274391564192e-05,  -2.049787487400059e-07,   4.435470482906518e-09,
  -5.528441591268599e-11,   1.581527397799885e-13,  -5.937349853868978e-14,   7.366899359507847e-16,   7.090954993933195e-17,   1.143174216397750e-18,  -7.417559382574956e-20,
  -3.507207092823687e-21,  -1.729125655118895e-24,   1.704845902021348e-02,  -5.034897586152353e-04,   1.093714861297319e-05,  -2.050717798172354e-07,   4.435902410502259e-09,
  -5.548467370854635e-11,   1.617062795937386e-13,  -5.896746748506917e-14,   7.441625716475440e-16,   7.023872232538817e-17,   1.108045658370303e-18,  -7.407901351520964e-20,
  -3.433079930982486e-21,   6.529214761183060e-25,   1.705065665867396e-02,  -5.036131654109643e-04,   1.094247502043167e-05,  -2.051844196647019e-07,   4.436428681349221e-09,
  -5.572620741748102e-11,   1.660180629902756e-13,  -5.847826576267043e-14,   7.530848079539927e-16,   6.942805583007380e-17,   1.065923257829532e-18,  -7.394919263694003e-20,
  -3.343922899542019e-21,   3.481139177010284e-24,   1.705279042813740e-02,  -5.037329884245232e-04,   1.094764601538134e-05,  -2.052939207890948e-07,   4.436943751515549e-09,
  -5.596003619255696e-11,   1.702192490241658e-13,  -5.800521553109371e-14,   7.616278573469269e-16,   6.864163135832391e-17,   1.025402515305355e-18,  -7.380967085995926e-20,
  -3.257873848605703e-21,   6.172501230187808e-24,   1.705450960874685e-02,  -5.038295319406505e-04,   1.095181185336751e-05,  -2.053822424324404e-07,   4.437361682967961e-09,
  -5.614794237055300e-11,   1.736146045692990e-13,  -5.762546331442362e-14,   7.684255554873406e-16,   6.800851584398711e-17,   9.930244397280442e-19,  -7.368771507814529e-20,
  -3.188915769343304e-21,   8.302071671126879e-24,   1.705564573198174e-02,  -5.038933338459274e-04,   1.095456463944522e-05,  -2.054406570836216e-07,   4.437639314699397e-09,
  -5.627188102335779e-11,   1.758635143612532e-13,  -5.737518121301515e-14,   7.728761694320085e-16,   6.759037660169267e-17,   9.717589338256192e-19,  -7.360249258513626e-20,
  -3.143527288056926e-21,   9.690494594927654e-24,   1.705622922252397e-02,  -5.039261015500258e-04,   1.095597834992461e-05,  -2.054706722657540e-07,   4.437782347011514e-09,
  -5.633545952297905e-11,   1.770200748449373e-13,  -5.724685077613387e-14,   7.751490734981902e-16,   6.737570934064558e-17,   9.608780055417993e-19,  -7.355730228232664e-20,
  -3.120273236482628e-21,   1.039773997084785e-23,   1.705643231762516e-02,  -5.039375070273782e-04,   1.095647040848802e-05,  -2.054811219445267e-07,   4.437832203219927e-09,
  -5.635757747708287e-11,   1.774228863831978e-13,  -5.720221625036227e-14,   7.759381601722015e-16,   6.730100328395946e-17,   9.570971483852917e-19,  -7.354134743443347e-20,
  -3.112188234487955e-21,   1.064298586260627e-23,   1.705646454629953e-02,  -5.039393169374954e-04,   1.095654849158031e-05,  -2.054827802889752e-07,   4.437840118156390e-09,
  -5.636108676380751e-11,   1.774868193599028e-13,  -5.719513488764000e-14,   7.760632816068792e-16,   6.728914897958473e-17,   9.564974797235058e-19,  -7.353880491000065e-20,
  -3.110905673222939e-21,   1.068185950437019e-23,   1.552691662557169e-01,  -4.506840914490015e-03,   9.242072396324291e-05,  -1.523104930404790e-06,   2.878704160908787e-08,
  -1.493775365440279e-10,  -7.783028357025960e-12,  -3.834673843078556e-13,   3.152811918330402e-15,   7.741527776010195e-16,   1.059201346083263e-17,  -7.155294166157887e-19,
  -3.558515159554596e-20,  -6.205374614952201e-23,   1.552778630633486e-01,  -4.507269802503936e-03,   9.243685553348360e-05,  -1.523250945019843e-06,   2.877620491679242e-08,
  -1.500926632246963e-10,  -7.773979898066258e-12,  -3.809502897339470e-13,   3.191132569748884e-15,   7.704797713775056e-16,   1.039110109105033e-17,  -7.152222263814005e-19,
  -3.516536414480761e-20,  -4.780720504334149e-23,   1.552932099397316e-01,  -4.508026616574195e-03,   9.246531501353254e-05,  -1.523509122982481e-06,   2.875709404331095e-08,
  -1.513505337619774e-10,  -7.757935778206894e-12,  -3.765189002435859e-13,   3.258077684707361e-15,   7.640007398441114e-16,   1.003867018990102e-17,  -7.145997263343952e-19,
  -3.442730443594801e-20,  -2.298527763380679e-23,   1.553117696308443e-01,  -4.508941823007571e-03,   9.249972011926848e-05,  -1.523822221080428e-06,   2.873400317243053e-08,
  -1.528647860725347e-10,  -7.738403074400884e-12,  -3.711775710546346e-13,   3.337886992174869e-15,   7.561699382109715e-16,   9.616047902360184e-18,  -7.137110683879376e-19,
  -3.353939404851897e-20,   6.493607579825600e-24,   1.553297892399589e-01,  -4.509830351219806e-03,   9.253311120668797e-05,  -1.524127118004363e-06,   2.871160608937403e-08,
  -1.543277120129388e-10,  -7.719304080969357e-12,  -3.660102586923198e-13,   3.414175355160634e-15,   7.485721035764725e-16,   9.209469625622616e-18,  -7.127076408989143e-19,
  -3.268222626243718e-20,   3.455404622291065e-23,   1.553443071660785e-01,  -4.510546182235901e-03,   9.256000433496419e-05,  -1.524373415473496e-06,   2.869357705247143e-08,
  -1.555011603772443e-10,  -7.703820895413741e-12,  -3.618604009630753e-13,   3.474784603036816e-15,   7.424545749250388e-16,   8.884575297774270e-18,  -7.117995830049987e-19,
  -3.199516018934926e-20,   5.676292721433785e-23,   1.553539011184006e-01,  -4.511019212310906e-03,   9.257777175287927e-05,  -1.524536494929496e-06,   2.868167054514904e-08,
  -1.562740778248675e-10,  -7.693542596142405e-12,  -3.591245445073261e-13,   3.514420824502646e-15,   7.384138616652069e-16,   8.671180043921169e-18,  -7.111511861419982e-19,
  -3.154285891389349e-20,   7.124533958199921e-23,   1.553588283086501e-01,  -4.511262142602576e-03,   9.258689521919945e-05,  -1.524620346077819e-06,   2.867555807867324e-08,
  -1.566702429417819e-10,  -7.688249647816237e-12,  -3.577214978633717e-13,   3.534648479371968e-15,   7.363392863577671e-16,   8.561989317839878e-18,  -7.108033409759717e-19,
  -3.131110770461895e-20,   7.862337323051971e-23,   1.553605433000161e-01,  -4.511346697784784e-03,   9.259007057352037e-05,  -1.524649547469448e-06,   2.867343091261860e-08,
  -1.568080101294240e-10,  -7.686405078882128e-12,  -3.572334644857652e-13,   3.541668644152772e-15,   7.356172963897870e-16,   8.524047774545438e-18,  -7.106799126992970e-19,
  -3.123052862484830e-20,   8.118193488242276e-23,   1.553608154473153e-01,  -4.511360115578471e-03,   9.259057445131901e-05,  -1.524654182098413e-06,   2.867309337651979e-08,
  -1.568298661083360e-10,  -7.686112261674917e-12,  -3.571560350191263e-13,   3.542781686682909e-15,   7.355027305891301e-16,   8.518029977380469e-18,  -7.106602145817017e-19,
  -3.121774582742707e-20,   8.158749613706157e-23,   4.422999509267826e-01,  -1.228555238295607e-02,   2.134575759877392e-04,  -2.054222984643934e-06,   1.310581045137989e-08,
   1.311486126882659e-09,  -5.424853243047745e-11,  -1.143537002288511e-12,   1.712140587542252e-14,   2.382115226645822e-15,   4.471849514094457e-17,  -2.556961736560229e-18,
  -1.267428634370625e-19,  -3.893090436409644e-22,   4.423199764667206e-01,  -1.228612586774110e-02,   2.134645209526199e-04,  -2.053011255169635e-06,   1.303009991889541e-08,
   1.309356449840423e-09,  -5.420022965971730e-11,  -1.135840307296782e-12,   1.728735342105941e-14,   2.368954039148999e-15,   4.400181062802403e-17,  -2.556820295439453e-18,
  -1.252727596348081e-19,  -3.334104156290571e-22,   4.423553123260381e-01,  -1.228713751665804e-02,   2.134767409667913e-04,  -2.050874725443668e-06,   1.289656400825246e-08,
   1.305610751561413e-09,  -5.411465810249032e-11,  -1.122295452981780e-12,   1.757777134525627e-14,   2.345734488499701e-15,   4.274450946663880e-17,  -2.556254605149382e-18,
  -1.226872958697777e-19,  -2.359854486397693e-22,   4.423980416397414e-01,  -1.228836034636865e-02,   2.134914587558547e-04,  -2.048293908870783e-06,   1.273518757860166e-08,
   1.301102091041776e-09,  -5.401060682763580e-11,  -1.105978388227940e-12,   1.792487409298135e-14,   2.317664132135354e-15,   4.123658439492094e-17,  -2.555036397180756e-18,
  -1.195756172046323e-19,  -1.202276600402582e-22,   4.424395233691129e-01,  -1.228954695958242e-02,   2.135056849973867e-04,  -2.045791314167361e-06,   1.257862764108447e-08,
   1.296746764676033e-09,  -5.390899556252925e-11,  -1.090202471044865e-12,   1.825759114904880e-14,   2.290422335633756e-15,   3.978568115409073e-17,  -2.553300546018160e-18,
  -1.165703644969378e-19,  -9.982945222197294e-24,   4.424729411191940e-01,  -1.229050252981618e-02,   2.135171014005881e-04,  -2.043777269433929e-06,   1.245257795025071e-08,
   1.293253613481911e-09,  -5.382671196764473e-11,  -1.077539734005574e-12,   1.852259791042064e-14,   2.268483513493890e-15,   3.862611392681261e-17,  -2.551510082971558e-18,
  -1.141605728033594e-19,   7.731272664410412e-23,   4.424950232703565e-01,  -1.229113378234988e-02,   2.135246235842892e-04,  -2.042447407917956e-06,   1.236932237483025e-08,
   1.290952948400494e-09,  -5.377213266107572e-11,  -1.069195008162690e-12,   1.869623430000428e-14,   2.253990380959086e-15,   3.786441617780421e-17,  -2.550136733190928e-18,
  -1.125737441697905e-19,   1.342582065924659e-22,   4.425063636033532e-01,  -1.229145790778669e-02,   2.135284799155727e-04,  -2.041764764031458e-06,   1.232657774885630e-08,
   1.289773777720404e-09,  -5.374403958345738e-11,  -1.064916575839380e-12,   1.878494993329957e-14,   2.246548659295211e-15,   3.747464453707374e-17,  -2.549372985387965e-18,
  -1.117605457447999e-19,   1.632751449672757e-22,   4.425103107247039e-01,  -1.229157071418617e-02,   2.135298210852493e-04,  -2.041527211871364e-06,   1.231170185852221e-08,
   1.289363727380527e-09,  -5.373425136630003e-11,  -1.063428540007219e-12,   1.881575590771615e-14,   2.243958696119734e-15,   3.733920307703881e-17,  -2.549097880595592e-18,
  -1.114777780990538e-19,   1.733386535545718e-22,   4.425109370791945e-01,  -1.229158861460814e-02,   2.135300338600043e-04,  -2.041489517907089e-06,   1.230934134357680e-08,
   1.289298675637145e-09,  -5.373269762898677e-11,  -1.063192461989264e-12,   1.882064096094608e-14,   2.243547714066516e-15,   3.731772092356859e-17,  -2.549053785580584e-18,
  -1.114329197654776e-19,   1.749338815295825e-22,   9.023142809204221e-01,  -2.245818501601577e-02,   2.122922648245843e-04,   4.535522165076734e-06,  -1.313314331000127e-07,
   2.740472660907144e-09,   7.461490185392848e-13,  -7.929408791604112e-12,   6.709657606447513e-14,   1.070352044717643e-14,   4.201954416782442e-17,  -8.246746245494474e-18,
  -3.407663178138041e-19,  -4.216075478507345e-21,   9.023340350230015e-01,  -2.245690082463938e-02,   2.122184100427117e-04,   4.537965304548119e-06,  -1.313282711655639e-07,
   2.725415814527615e-09,   9.245306693807651e-13,  -7.894411320567066e-12,   6.721430302871281e-14,   1.066037710209840e-14,   4.013337135316000e-17,  -8.264668851890735e-18,
  -3.359251158631783e-19,  -3.975012957735160e-21,   9.023688858219547e-01,  -2.245463431179053e-02,   2.120880940613324e-04,   4.542264956249595e-06,  -1.313224871295630e-07,
   2.698903232492401e-09,   1.239503613910199e-12,  -7.832776523124730e-12,   6.741575893564670e-14,   1.058418774371334e-14,   3.682921527663496e-17,  -8.294926866323573e-18,
  -3.274121006833183e-19,  -3.554608779658424e-21,   9.024110181881286e-01,  -2.245189270639276e-02,   2.119305179618237e-04,   4.547444891443398e-06,  -1.313151437454781e-07,
   2.666938368873742e-09,   1.620731101352688e-12,  -7.758449717275524e-12,   6.764871783290506e-14,   1.049195644074713e-14,   3.287465614192796e-17,  -8.329204654486383e-18,
  -3.171685903686755e-19,  -3.054652213732783e-21,   9.024519095152012e-01,  -2.244923024855601e-02,   2.117775494312058e-04,   4.552453361414294e-06,  -1.313076489860345e-07,
   2.636006156165659e-09,   1.991184510303353e-12,  -7.686506879288236e-12,   6.786379554868485e-14,   1.040231758642311e-14,   2.907829519856993e-17,  -8.360086565465077e-18,
  -3.072778404087916e-19,  -2.578040025134176e-21,   9.024848438397123e-01,  -2.244708472459954e-02,   2.116543226232704e-04,   4.556473728460039e-06,  -1.313013489933304e-07,
   2.611158185459172e-09,   2.289870017210261e-12,  -7.628702889945052e-12,   6.802917447326718e-14,   1.033003578179424e-14,   2.605046484250263e-17,  -8.383266744320133e-18,
  -2.993486880676528e-19,  -2.200305077591581e-21,   9.025066027309729e-01,  -2.244566666701994e-02,   2.115728978652128e-04,   4.559123279426110e-06,  -1.312970575861609e-07,
   2.594773617866428e-09,   2.487356764318735e-12,  -7.590581610510279e-12,   6.813461346736340e-14,   1.028224038276709e-14,   2.406460829303685e-17,  -8.397759565727803e-18,
  -2.941283539577217e-19,  -1.953731752121644e-21,   9.025177758730473e-01,  -2.244493832357425e-02,   2.115310827695697e-04,   4.560481776897293e-06,  -1.312948139979823e-07,
   2.586370026669530e-09,   2.588812297379087e-12,  -7.571027576947411e-12,   6.818757803824211e-14,   1.025768528125486e-14,   2.304936942041876e-17,  -8.404948931630290e-18,
  -2.914534049804704e-19,  -1.828037090534592e-21,   9.025216646139843e-01,  -2.244468480057778e-02,   2.115165287088982e-04,   4.560954268519191e-06,  -1.312940267681626e-07,
   2.583446777292645e-09,   2.624130596995678e-12,  -7.564225289473353e-12,   6.820582482581446e-14,   1.024913710641040e-14,   2.269673678752104e-17,  -8.407411050012598e-18,
  -2.905233134275318e-19,  -1.784436049049080e-21,   9.025222816953786e-01,  -2.244464456919196e-02,   2.115142191830679e-04,   4.561029230017011e-06,  -1.312939015451836e-07,
   2.582982978443736e-09,   2.629735397533049e-12,  -7.563146034514340e-12,   6.820871142167253e-14,   1.024778055586982e-14,   2.264081351212430e-17,  -8.407799848273745e-18,
  -2.903757658149432e-19,  -1.777524190206789e-21,   1.564256786405819e+00,  -2.534414817846713e-02,  -5.111340421262065e-04,   1.401236641383004e-05,   9.101520634827408e-07,
  -5.420965826263736e-09,  -1.606990199104799e-09,  -2.117222726210334e-11,   2.412042876831848e-12,   8.542381507709568e-14,  -2.602806999852609e-15,  -2.069759875301811e-16,
   4.278406663438375e-19,   3.843777113326225e-19,   1.564209870418134e+00,  -2.534022627208912e-02,  -5.106343939215035e-04,   1.400697258698017e-05,   9.079641332999888e-07,
  -5.458513681573953e-09,  -1.600881452175229e-09,  -2.090882450042968e-11,   2.401226645842908e-12,   8.445395484155105e-14,  -2.598016039225596e-15,  -2.044326186134981e-16,
   4.762650954421674e-19,   3.794630229965045e-19,   1.564127123050196e+00,  -2.533330729246724e-02,  -5.097537405496895e-04,   1.399742772880443e-05,   9.041103925875145e-07,
  -5.524357953670465e-09,  -1.590125450115260e-09,  -2.044663672806009e-11,   2.382159485795731e-12,   8.275301239238151e-14,  -2.589335091903237e-15,  -1.999733821719698e-16,
   5.602135912633375e-19,   3.708384136162000e-19,   1.564027126458259e+00,  -2.532494298484902e-02,  -5.086905203267541e-04,   1.398583953066223e-05,   8.994621493580070e-07,
  -5.603282084687581e-09,  -1.577158328436597e-09,  -1.989215222889764e-11,   2.359134900132016e-12,   8.071385142791110e-14,  -2.578455568781827e-15,  -1.946297603091170e-16,
   6.591983380757788e-19,   3.604903673463732e-19,   1.563930116790668e+00,  -2.531682536492128e-02,  -5.076601161292053e-04,   1.397454152655575e-05,   8.949619877271220e-07,
  -5.679175516862696e-09,  -1.564611032916707e-09,  -1.935844928843289e-11,   2.336816796747231e-12,   7.875263526874115e-14,  -2.567499775472196e-15,  -1.894928426436729e-16,
   7.526782095172427e-19,   3.505294506562379e-19,   1.563852013802712e+00,  -2.531028757099766e-02,  -5.068312890091912e-04,   1.396540552128002e-05,   8.913454930978209e-07,
  -5.739797484186489e-09,  -1.554532417557231e-09,  -1.893177027227279e-11,   2.318862265900291e-12,   7.718579177940595e-14,  -2.558395958045916e-15,  -1.853906734034486e-16,
   8.261354526650180e-19,   3.425658410044109e-19,   1.563800427606604e+00,  -2.530596832504552e-02,  -5.062842275962923e-04,   1.395935180399012e-05,   8.889600688583223e-07,
  -5.779603363547978e-09,  -1.547886994570489e-09,  -1.865142017700754e-11,   2.307010477414069e-12,   7.615682798086255e-14,  -2.552245987926026e-15,  -1.826976210602691e-16,
   8.737786786426128e-19,   3.373333946818488e-19,   1.563773942694687e+00,  -2.530375043693976e-02,  -5.060034747299277e-04,   1.395623774841410e-05,   8.877363650164504e-07,
  -5.799967855087366e-09,  -1.544478686384374e-09,  -1.850793780075498e-11,   2.300927842035617e-12,   7.563037223778951e-14,  -2.549046516886805e-15,  -1.813200340984058e-16,
   8.979706194682297e-19,   3.346554895456716e-19,   1.563764725503471e+00,  -2.530297852071715e-02,  -5.059057862531645e-04,   1.395515304926779e-05,   8.873106546090729e-07,
  -5.807043546680045e-09,  -1.543293099278965e-09,  -1.845807545338409e-11,   2.298811337415823e-12,   7.544744699825618e-14,  -2.547926391126646e-15,  -1.808414145590828e-16,
   9.063472182806258e-19,   3.337248859057466e-19,   1.563763262915563e+00,  -2.530285603014516e-02,  -5.058902858673391e-04,   1.395498088338219e-05,   8.872431102410329e-07,
  -5.808165775280833e-09,  -1.543104996434615e-09,  -1.845016668622001e-11,   2.298475506418675e-12,   7.541843410644479e-14,  -2.547748333714222e-15,  -1.807655051352201e-16,
   9.076744015103995e-19,   3.335772815109367e-19,   1.519319329505050e-02,  -4.246030365406628e-04,   8.859797420467834e-06,  -1.430740076569928e-07,   3.258364013219355e-09,
  -6.631873782819685e-11,  -7.851532714193319e-13,   4.858146266164575e-15,   2.970784467484387e-15,   1.516657183922838e-17,  -4.254003539186597e-18,  -1.001792719473088e-19,
   5.087708027516308e-21,   2.574588576511080e-22,   1.519402756718306e-02,  -4.246434946999904e-04,   8.861624555660578e-06,  -1.431360952948711e-07,   3.257347464495057e-09,
  -6.630856874510573e-11,  -7.777029341138024e-13,   4.897751591623174e-15,   2.953796334668252e-15,   1.471290791623124e-17,  -4.223969678149332e-18,  -9.852776388090274e-20,
   5.056676130311367e-21,   2.531732574629364e-22,   1.519549979211318e-02,  -4.247148979412795e-04,   8.864848120054348e-06,  -1.432456419830738e-07,   3.255562130416418e-09,
  -6.629056743775831e-11,  -7.645923739724880e-13,   4.966436431881150e-15,   2.923922241171217e-15,   1.391910169733710e-17,  -4.171131933373373e-18,  -9.563823337017862e-20,
   5.001790407975490e-21,   2.456781867757484e-22,   1.519728025858109e-02,  -4.248012636849292e-04,   8.868745333397659e-06,  -1.433780934679038e-07,   3.253417550070326e-09,
  -6.626870278755100e-11,  -7.487996298490083e-13,   5.047458127394791e-15,   2.887971261546920e-15,   1.297056212027457e-17,  -4.107508871874055e-18,  -9.218582848578869e-20,
   4.935209887641157e-21,   2.367284747907045e-22,   1.519900895208943e-02,  -4.248851313747366e-04,   8.872527893126800e-06,  -1.435066608622434e-07,   3.251350531357359e-09,
  -6.624737671857009e-11,  -7.335316684762817e-13,   5.123999531957769e-15,   2.853251459743196e-15,   1.206152296000142e-17,  -4.046026786725792e-18,  -8.887756590432767e-20,
   4.870363401913773e-21,   2.281580835347356e-22,   1.520040174240128e-02,  -4.249527122361623e-04,   8.875574512103070e-06,  -1.436102228746575e-07,   3.249696021056327e-09,
  -6.623012602757835e-11,  -7.212772633198519e-13,   5.184157249910332e-15,   2.825410837006464e-15,   1.133759632100878e-17,  -3.996700060450505e-18,  -8.624323917137136e-20,
   4.817980102208411e-21,   2.213376662806419e-22,   1.520132216023278e-02,  -4.249973773474260e-04,   8.877587389432683e-06,  -1.436786497996511e-07,   3.248607956214777e-09,
  -6.621869292525803e-11,  -7.132018808660858e-13,   5.223176870295136e-15,   2.807077372876873e-15,   1.086331852722122e-17,  -3.964205088637988e-18,  -8.451749157431728e-20,
   4.783298752143814e-21,   2.168716151686546e-22,   1.520179486567343e-02,  -4.250203177659308e-04,   8.878621013648056e-06,  -1.437137887489754e-07,   3.248050790771605e-09,
  -6.621281101514171e-11,  -7.090616120216429e-13,   5.242990015329736e-15,   2.797681754440857e-15,   1.062101072057618e-17,  -3.947548086611665e-18,  -8.363584649180061e-20,
   4.765468012891922e-21,   2.145906338908148e-22,   1.520195939940439e-02,  -4.250283028259467e-04,   8.878980762570067e-06,  -1.437260189350170e-07,   3.247857120030740e-09,
  -6.621076210503910e-11,  -7.076216393050494e-13,   5.249850377306949e-15,   2.794414624081345e-15,   1.053687284488890e-17,  -3.941755357654400e-18,  -8.332971378599047e-20,
   4.759258700272451e-21,   2.137987104643757e-22,   1.520198550884437e-02,  -4.250295699657577e-04,   8.879037849131199e-06,  -1.437279596853723e-07,   3.247826399291019e-09,
  -6.621043689271477e-11,  -7.073931869912587e-13,   5.250937325134153e-15,   2.793896322636382e-15,   1.052353078786365e-17,  -3.940836363687841e-18,  -8.328116945288409e-20,
   4.758273218971061e-21,   2.136731376376969e-22,   1.386154303011599e-01,  -3.833063175123057e-03,   7.676682357725432e-05,  -1.099664329452592e-06,   2.323426867074520e-08,
  -4.269807650902967e-10,  -1.282643556422292e-11,   1.569294552408860e-13,   2.722638626631156e-14,   1.886923471296867e-16,  -4.292366974214773e-17,  -1.000319621596386e-18,
   5.069293175905261e-20,   2.620991664043908e-21,   1.386226532159024e-01,  -3.833373855065534e-03,   7.677979594862857e-05,  -1.100061950334227e-06,   2.321702975163643e-08,
  -4.266637674632811e-10,  -1.275848010528560e-11,   1.574509842100483e-13,   2.705485795590918e-14,   1.841737722514367e-16,  -4.262425023049060e-17,  -9.835262160583096e-19,
   5.038776239131888e-20,   2.576998281659707e-21,   1.386353991401686e-01,  -3.833922145170855e-03,   7.680267820481264e-05,  -1.100763314652540e-06,   2.318668772926158e-08,
  -4.261036410478777e-10,  -1.263893193316450e-11,   1.583592935377144e-13,   2.675320792388689e-14,   1.762686906631240e-16,  -4.209747163808661e-17,  -9.541462670967905e-19,
   4.984771601504241e-20,   2.500062813481430e-21,   1.386508133144538e-01,  -3.834585297626296e-03,   7.683033457249539e-05,  -1.101610995491871e-06,   2.315012768805338e-08,
  -4.254250144481803e-10,  -1.249498588513437e-11,   1.594374026945299e-13,   2.639017540030244e-14,   1.668250427166704e-16,  -4.146313621956108e-17,  -9.190471161276174e-19,
   4.919210249315424e-20,   2.408203265053425e-21,   1.386657788726816e-01,  -3.835229235980027e-03,   7.685716920604853e-05,  -1.102433472861538e-06,   2.311477146287505e-08,
  -4.247648537842552e-10,  -1.235588548179350e-11,   1.604629883625171e-13,   2.603955238894012e-14,   1.577771116758432e-16,  -4.085011637518227e-17,  -8.854175290290265e-19,
   4.855305684628668e-20,   2.320244997218742e-21,   1.386778361814796e-01,  -3.835748099972319e-03,   7.687877705036195e-05,  -1.103095736838349e-06,   2.308638587670634e-08,
  -4.242320725963667e-10,  -1.224428519453127e-11,   1.612742345079653e-13,   2.575838335541292e-14,   1.505734195188013e-16,  -4.035827296098894e-17,  -8.586416814728688e-19,
   4.803647841907648e-20,   2.250252519965038e-21,   1.386858040480994e-01,  -3.836091012655995e-03,   7.689305034517326e-05,  -1.103533195642276e-06,   2.306767654559694e-08,
  -4.238795526578523e-10,  -1.217076503349254e-11,   1.618030151761460e-13,   2.557322131813982e-14,   1.458548120348722e-16,  -4.003425118319909e-17,  -8.411022713806745e-19,
   4.769429802809579e-20,   2.204423845560107e-21,   1.386898961180210e-01,  -3.836267132228145e-03,   7.690037888737900e-05,  -1.103757804190421e-06,   2.305808303355131e-08,
  -4.236983731515047e-10,  -1.213307786393454e-11,   1.620723285753962e-13,   2.547832613070888e-14,   1.434443505207140e-16,  -3.986815377777865e-17,  -8.321422354959967e-19,
   4.751832086248596e-20,   2.181018287563368e-21,   1.386913204305438e-01,  -3.836328435044051e-03,   7.690292941852523e-05,  -1.103835973691219e-06,   2.305474625019761e-08,
  -4.236352891815171e-10,  -1.211997146647210e-11,   1.621657096792513e-13,   2.544532791160064e-14,   1.426073954050896e-16,  -3.981039036685534e-17,  -8.290311230420019e-19,
   4.745703102681831e-20,   2.172892359830694e-21,   1.386915464507548e-01,  -3.836338163088912e-03,   7.690333414153477e-05,  -1.103848377755417e-06,   2.305421685903624e-08,
  -4.236252775444056e-10,  -1.211789218213689e-11,   1.621805110960814e-13,   2.544009301604256e-14,   1.424746783383646e-16,  -3.980122640319420e-17,  -8.285377884953035e-19,
   4.744730331726359e-20,   2.171603863510483e-21,   3.964239674280531e-01,  -1.067144160983409e-02,   1.906767834837727e-04,  -1.714124729803418e-06,   2.440048414702257e-08,
  -2.285201648866406e-10,  -6.500384004015171e-11,   8.057035170006022e-13,   9.409977272740636e-14,   5.439793332578747e-16,  -1.483199453474344e-16,  -3.652589185419890e-18,
   1.827918154196015e-19,   9.700720591422028e-21,   3.964418698811314e-01,  -1.067192441040071e-02,   1.906900098001288e-04,  -1.714325428955177e-06,   2.431183199168332e-08,
  -2.269123422783540e-10,  -6.476893531549532e-11,   8.071190705738131e-13,   9.350852663389372e-14,   5.275023056054649e-16,  -1.472396907905045e-16,  -3.590648796588035e-18,
   1.817065898210017e-19,   9.533817297170565e-21,   3.964734599909525e-01,  -1.067277636313721e-02,   1.907133079451136e-04,  -1.714678334006032e-06,   2.415566770973104e-08,
  -2.240732510610620e-10,  -6.435568324738225e-11,   8.095733270857838e-13,   9.246892374118509e-14,   4.986789537122731e-16,  -1.453391028167443e-16,  -3.482310253302851e-18,
   1.797842969542405e-19,   9.242001569561785e-21,   3.965116607066744e-01,  -1.067380662753621e-02,   1.907414123617833e-04,  -1.715102969340408e-06,   2.396728110428794e-08,
  -2.206367204478911e-10,  -6.385808515990873e-11,   8.124673121823199e-13,   9.121805254545320e-14,   4.642500918231406e-16,  -1.430503577468620e-16,  -3.352925885667427e-18,
   1.774476254157725e-19,   8.893688269070613e-21,   3.965487469914613e-01,  -1.067480686767427e-02,   1.907686245901602e-04,  -1.715512996365675e-06,   2.378486752599800e-08,
  -2.172970198270226e-10,  -6.337722912721303e-11,   8.152001198755996e-13,   9.001023329379288e-14,   4.312684161222994e-16,  -1.408384253676995e-16,  -3.229004355001270e-18,
   1.751669325556948e-19,   8.560282552976286e-21,   3.965786244301900e-01,  -1.067561270332743e-02,   1.907904955707440e-04,  -1.715841730507172e-06,   2.363825261031982e-08,
  -2.146040793457865e-10,  -6.299143186075228e-11,   8.173471439564425e-13,   8.904187867537339e-14,   4.050125796845849e-16,  -1.390636643334846e-16,  -3.130370790489498e-18,
   1.733211752747413e-19,   8.295058542661260e-21,   3.965983675011904e-01,  -1.067614521213112e-02,   1.908049226632675e-04,  -1.716058179054046e-06,   2.354153580949119e-08,
  -2.128234144208568e-10,  -6.273727270465365e-11,   8.187393439756844e-13,   8.840427861373426e-14,   3.878158605883609e-16,  -1.378944389744667e-16,  -3.065777250351353e-18,
   1.720975274931871e-19,   8.121439420514579e-21,   3.966085066956684e-01,  -1.067641868920384e-02,   1.908123239830498e-04,  -1.716169096573690e-06,   2.349191766399112e-08,
  -2.119085846735032e-10,  -6.260698716898867e-11,   8.194461401733849e-13,   8.807754190986810e-14,   3.790315329436260e-16,  -1.372950714141841e-16,  -3.032784477775988e-18,
   1.714679166798196e-19,   8.032781448475816e-21,   3.966120357642546e-01,  -1.067651387672703e-02,   1.908148988576609e-04,  -1.716207664350245e-06,   2.347465565665142e-08,
  -2.115901107154404e-10,  -6.256167784567202e-11,   8.196908502673172e-13,   8.796392978644977e-14,   3.759815332665345e-16,  -1.370866290180482e-16,  -3.021329481959685e-18,
   1.712485849611707e-19,   8.002003228010098e-21,   3.966125957802171e-01,  -1.067652898173882e-02,   1.908153073967742e-04,  -1.716213782717218e-06,   2.347191679549890e-08,
  -2.115395704856587e-10,  -6.255448967147850e-11,   8.197296208885660e-13,   8.794590640231325e-14,   3.754978943928874e-16,  -1.370535602948973e-16,  -3.019513080603569e-18,
   1.712137710745976e-19,   7.997122942067671e-21,   8.161775678760838e-01,  -2.057403346937713e-02,   2.557366789128959e-04,   2.807044076840779e-06,  -9.159173152355769e-08,
   6.815784504313466e-10,  -1.364529354562225e-10,  -2.725582547646869e-13,   3.561541341836565e-13,   1.259844810558345e-15,  -5.414127123464289e-16,  -1.005407732766790e-17,
   6.483702191553408e-19,   3.332238686029174e-20,   8.162014376522683e-01,  -2.057324175427747e-02,   2.556841402199348e-04,   2.807678986242712e-06,  -9.177315400369387e-08,
   6.810893493299000e-10,  -1.355623211744706e-10,  -2.694201289517239e-13,   3.539918865395561e-13,   1.215938148962767e-15,  -5.375934054046851e-16,  -9.844896866304480e-18,
   6.442503885130367e-19,   3.268101295960781e-20,   8.162435521251323e-01,  -2.057184461602193e-02,   2.555913543415267e-04,   2.808798934792494e-06,  -9.209227587460262e-08,
   6.802308111846440e-10,  -1.339953593767248e-10,  -2.639976187563172e-13,   3.501894958780491e-13,   1.139306483299762e-15,  -5.308751617419340e-16,  -9.479455699834530e-18,
   6.369564520574852e-19,   3.156065105777930e-20,   8.162944703623334e-01,  -2.057015493517129e-02,   2.554790196653242e-04,   2.810152578352442e-06,  -9.247645825467023e-08,
   6.792001897574868e-10,  -1.321082966820511e-10,  -2.576347990224295e-13,   3.456136004047189e-13,   1.048068621971550e-15,  -5.227872430563584e-16,  -9.043757527051776e-18,
   6.280964979458430e-19,   3.022511684144001e-20,   8.163438935355434e-01,  -2.056851436434748e-02,   2.553698240310444e-04,   2.811466035702987e-06,  -9.284763675512134e-08,
   6.782074142171841e-10,  -1.302844337935502e-10,  -2.516592261602300e-13,   3.411943707961112e-13,   9.609767054464520e-16,  -5.149732691248895e-16,  -8.627221547744960e-18,
   6.194554951544604e-19,   2.894855494798037e-20,   8.163837029171559e-01,  -2.056719255708720e-02,   2.552817552101431e-04,   2.812523685703636e-06,  -9.314538174849919e-08,
   6.774130808936461e-10,  -1.288209152661022e-10,  -2.469882724803770e-13,   3.376507104006319e-13,   8.918680260297339e-16,  -5.087054632146246e-16,  -8.296234071611678e-18,
   6.124672259526360e-19,   2.793434593117101e-20,   8.164100056588011e-01,  -2.056631903996226e-02,   2.552235109545449e-04,   2.813222340334160e-06,  -9.334150500290827e-08,
   6.768908169283770e-10,  -1.278566626116914e-10,  -2.439712018926177e-13,   3.353171411270179e-13,   8.467133851677510e-16,  -5.045770677348792e-16,  -8.079744158820074e-18,
   6.078367501436742e-19,   2.727106469681420e-20,   8.164235125743541e-01,  -2.056587041915866e-02,   2.551935843192283e-04,   2.813581064521384e-06,  -9.344203179466470e-08,
   6.766234096752551e-10,  -1.273623416498521e-10,  -2.424431413976178e-13,   3.341212175462665e-13,   8.236816139971265e-16,  -5.024610446657164e-16,  -7.969249581242434e-18,
   6.054549538923095e-19,   2.693255837716849e-20,   8.164282136524872e-01,  -2.056571426812813e-02,   2.551831656264528e-04,   2.813705910884705e-06,  -9.347699054097432e-08,
   6.765304627256433e-10,  -1.271904269165040e-10,  -2.419146744682683e-13,   3.337053592144649e-13,   8.156901680147821e-16,  -5.017251975107205e-16,  -7.930899418063515e-18,
   6.046253493526920e-19,   2.681507478234185e-20,   8.164289596427884e-01,  -2.056568948889882e-02,   2.551815122069746e-04,   2.813725721767142e-06,  -9.348253656395613e-08,
   6.765157193182475e-10,  -1.271631529743941e-10,  -2.418309746995806e-13,   3.336393869135891e-13,   8.144232197479832e-16,  -5.016084597603617e-16,  -7.924818919403181e-18,
   6.044936743337029e-19,   2.679644771598990e-20,   1.456088124551878e+00,  -2.853518735952138e-02,  -2.660907148803918e-04,   2.559342873642218e-05,   4.212717719038053e-07,
  -4.064757613545241e-08,  -8.884612150703205e-10,   7.070068259997879e-11,   2.011759658341751e-12,  -1.234314191081027e-13,  -4.565401712377662e-15,   2.096178471048224e-16,
   1.016422802979707e-17,  -3.386040305084489e-19,   1.456063640700034e+00,  -2.852811928916868e-02,  -2.658604459439819e-04,   2.555643416621134e-05,   4.200800680359071e-07,
  -4.051454675765917e-08,  -8.835367220449317e-10,   7.030971156354353e-11,   1.994251578381923e-12,  -1.224361936850110e-13,  -4.509798761206576e-15,   2.073808167808757e-16,
   1.000277920545482e-17,  -3.341909331421549e-19,   1.456020455323868e+00,  -2.851565583556971e-02,  -2.654546643691485e-04,   2.549125618078103e-05,   4.179827798605534e-07,
  -4.028042765035081e-08,  -8.748836970803900e-10,   6.962250568926570e-11,   1.963542726820670e-12,  -1.206892394583049e-13,  -4.412467089876955e-15,   2.034590185642734e-16,
   9.720780665066646e-18,  -3.264605269950033e-19,   1.455968263666889e+00,  -2.850059897642626e-02,  -2.649648936863552e-04,   2.541261163337075e-05,   4.154560532459477e-07,
  -3.999837121656144e-08,  -8.644820329502231e-10,   6.879606242878778e-11,   1.926721936338950e-12,  -1.185923106018414e-13,  -4.296093935396725e-15,   1.987599517163121e-16,
   9.384652499362976e-18,  -3.172088395037799e-19,   1.455917626786448e+00,  -2.848599676567141e-02,  -2.644903780926403e-04,   2.533644183026855e-05,   4.130128927507156e-07,
  -3.972564416234811e-08,  -8.544485190706723e-10,   6.799849150992784e-11,   1.891302115980006e-12,  -1.165727955351906e-13,  -4.184492339541621e-15,   1.942431431468145e-16,
   9.063386677251043e-18,  -3.083274062292642e-19,   1.455876855757822e+00,  -2.847424395325426e-02,  -2.641087903192665e-04,   2.527520693934084e-05,   4.110516697208616e-07,
  -3.950671609400484e-08,  -8.464114449311101e-10,   6.735934976090644e-11,   1.862999758286671e-12,  -1.149574056547208e-13,  -4.095561612661827e-15,   1.906364750067187e-16,
   8.808152543454517e-18,  -3.012438347129985e-19,   1.455849925449271e+00,  -2.846648305874695e-02,  -2.638569742142133e-04,   2.523480584471152e-05,   4.097591240018260e-07,
  -3.936243187853376e-08,  -8.411230172110873e-10,   6.693866075200942e-11,   1.844410719977452e-12,  -1.138955922373169e-13,  -4.037271265955789e-15,   1.882688464353550e-16,
   8.641232472846169e-18,  -2.965978287868873e-19,   1.455836098680421e+00,  -2.846249906101135e-02,  -2.637277566151812e-04,   2.521407704705415e-05,   4.090963879046172e-07,
  -3.928845219008005e-08,  -8.384140415409780e-10,   6.672312409630371e-11,   1.834899063546634e-12,  -1.133520289096721e-13,  -4.007482087601699e-15,   1.870577609920754e-16,
   8.556044022448091e-18,  -2.942225755782443e-19,   1.455831286661450e+00,  -2.846111264761011e-02,  -2.636827974768396e-04,   2.520686523741701e-05,   4.088658831875089e-07,
  -3.926272151449255e-08,  -8.374722520734595e-10,   6.664818523454709e-11,   1.831593957344583e-12,  -1.131631114348633e-13,  -3.997136822902787e-15,   1.866369950554030e-16,
   8.526477963424578e-18,  -2.933975461345249e-19,   1.455830523084735e+00,  -2.846089265492949e-02,  -2.636756638510503e-04,   2.520572096674112e-05,   4.088293131711155e-07,
  -3.925863929479470e-08,  -8.373228549706426e-10,   6.663629729543531e-11,   1.831069743982703e-12,  -1.131331458654086e-13,  -3.995496268702881e-15,   1.865702615081974e-16,
   8.521790245560920e-18,  -2.932667059261196e-19,   1.362677540889082e-02,  -3.598123922020575e-04,   7.409205856331760e-06,  -1.023415978106334e-07,   1.807560476811309e-09,
  -7.356820797428604e-11,   5.076121983945486e-13,   7.298603381066636e-14,   2.961590458419769e-16,  -1.409142116933918e-16,  -8.685148562758338e-19,   2.369045490202474e-19,
   2.652928257096414e-21,  -3.979878926708211e-22,   1.362747206993946e-02,  -3.598414143871544e-04,   7.410226687828733e-06,  -1.024094258407735e-07,   1.808282629938425e-09,
  -7.343155897066365e-11,   5.083244952155193e-13,   7.253931078042413e-14,   2.929417375617584e-16,  -1.397921675732032e-16,  -8.542887973748890e-19,   2.343006954663140e-19,
   2.604324550133260e-21,  -3.923046445719673e-22,   1.362870141763392e-02,  -3.598926398035076e-04,   7.412028293267678e-06,  -1.025290074615960e-07,   1.809557669806399e-09,
  -7.319114063576659e-11,   5.095747533506038e-13,   7.175406764085782e-14,   2.873116575445180e-16,  -1.378229107035635e-16,  -8.294208496989279e-19,   2.297387332082178e-19,
   2.519507197568877e-21,  -3.823668628747921e-22,   1.363018809155163e-02,  -3.599546082208756e-04,   7.414207380485341e-06,  -1.026734332659623e-07,   1.811100802493170e-09,
  -7.290161621246691e-11,   5.110753905980716e-13,   7.080965031321363e-14,   2.805831564099047e-16,  -1.354596594984927e-16,  -7.997463540701255e-19,   2.242775494420646e-19,
   2.418540704085087e-21,  -3.705029020836836e-22,   1.363163146873217e-02,  -3.600147933963082e-04,   7.416323394351517e-06,  -1.028134580334353e-07,   1.812600246782626e-09,
  -7.262179504258094e-11,   5.125205517070080e-13,   6.989814951780672e-14,   2.741337658555850e-16,  -1.331841841863089e-16,  -7.713496415071344e-19,   2.190332655867844e-19,
   2.322175852083211e-21,  -3.591441470269962e-22,   1.363279433485507e-02,  -3.600632973436591e-04,   7.418028453212253e-06,  -1.029261305830816e-07,   1.813809176665186e-09,
  -7.239726326699340e-11,   5.136764800897404e-13,   6.916765292382778e-14,   2.689968716591782e-16,  -1.313644278386511e-16,  -7.487651327665128e-19,   2.148493029051559e-19,
   2.245715604287648e-21,  -3.501062115402881e-22,   1.363356278515851e-02,  -3.600953574559777e-04,   7.419155334207557e-06,  -1.030005192792562e-07,   1.814608502396063e-09,
  -7.224933054775254e-11,   5.144362693402320e-13,   6.868680567985028e-14,   2.656310297026480e-16,  -1.301684626168063e-16,  -7.339833005527098e-19,   2.121044461982402e-19,
   2.195759549023023e-21,  -3.441887668342814e-22,   1.363395743633973e-02,  -3.601118248154766e-04,   7.419734106008838e-06,  -1.030387018801374e-07,   1.815019144449464e-09,
  -7.217349395123619e-11,   5.148252169528726e-13,   6.844043883514686e-14,   2.639112903185086e-16,  -1.295562796574376e-16,  -7.264356780455750e-19,   2.107009368163713e-19,
   2.170279098497126e-21,  -3.411666882778410e-22,   1.363409480071449e-02,  -3.601175569015349e-04,   7.419935563103162e-06,  -1.030519885734686e-07,   1.815162096030229e-09,
  -7.214711962965009e-11,   5.149603966877856e-13,   6.835477940559642e-14,   2.633141137128337e-16,  -1.293435219401695e-16,  -7.238155719010807e-19,   2.102134021783896e-19,
   2.161438054376836e-21,  -3.401174945386067e-22,   1.363411659866369e-02,  -3.601184665269962e-04,   7.419967532057037e-06,  -1.030540968410933e-07,   1.815184781609058e-09,
  -7.214293539879900e-11,   5.149818385047570e-13,   6.834119074207313e-14,   2.632194161358995e-16,  -1.293097753125861e-16,  -7.234001248966076e-19,   2.101360831298952e-19,
   2.160036413519478e-21,  -3.399511284534080e-22,   1.244358191789011e-01,  -3.266135926237348e-03,   6.547362173632857e-05,  -8.097395818445162e-07,   1.246060477351788e-08,
  -5.903101418579372e-10,   2.203966451654327e-12,   7.774683372965198e-13,   1.585651405603052e-15,  -1.381617253954125e-15,  -8.593558195916705e-18,   2.388863967143967e-18,
   2.614171868270321e-20,  -4.061475169496099e-21,   1.244419714252840e-01,  -3.266365568672222e-03,   6.548064855755607e-05,  -8.102807739223226e-07,   1.246374471018937e-08,
  -5.888484079792315e-10,   2.207483564343346e-12,   7.730961149560560e-13,   1.553780328327355e-15,  -1.370313083791786e-15,  -8.453893988284353e-18,   2.362334954255192e-18,
   2.565098144495514e-20,  -4.002650268307894e-21,   1.244528276986814e-01,  -3.266770898015056e-03,   6.549304893948578e-05,  -8.112346227368076e-07,   1.246928895059555e-08,
  -5.862760122922160e-10,   2.213624149654576e-12,   7.654115431472501e-13,   1.498003355108460e-15,  -1.350474724536480e-15,  -8.209816325978618e-18,   2.315861089868124e-18,
   2.479480744072085e-20,  -3.899804190470816e-21,   1.244659561376588e-01,  -3.267261233851885e-03,   6.550804607930088e-05,  -8.123861665575954e-07,   1.247599948870051e-08,
  -5.831771026626557e-10,   2.220938525831167e-12,   7.561707131614536e-13,   1.431336258049419e-15,  -1.326669215546044e-15,  -7.918669854031810e-18,   2.260235226856669e-18,
   2.377595994165665e-20,  -3.777050657735216e-21,   1.244787019595379e-01,  -3.267737460229619e-03,   6.552260762624998e-05,  -8.135021216808666e-07,   1.248252058465653e-08,
  -5.801809022670750e-10,   2.227923907272580e-12,   7.472534858106154e-13,   1.367425924095889e-15,  -1.303749930478890e-15,  -7.640171948610237e-18,   2.206827580494106e-18,
   2.280390201474051e-20,  -3.659551972127364e-21,   1.244889705162105e-01,  -3.268121257219905e-03,   6.553434007093939e-05,  -8.143997311115835e-07,   1.248777859508732e-08,
  -5.777758909747770e-10,   2.233469217472204e-12,   7.401081173788047e-13,   1.316515391426435e-15,  -1.285422238161488e-15,  -7.418756531992866e-18,   2.164224588708908e-18,
   2.203287978355440e-20,  -3.566080257820427e-21,   1.244957561325814e-01,  -3.268374939370939e-03,   6.554209356847895e-05,  -8.149921763594654e-07,   1.249125527839335e-08,
  -5.761909448868511e-10,   2.237093532873169e-12,   7.354052341047921e-13,   1.283154133048465e-15,  -1.273377770961305e-15,  -7.273876543809344e-18,   2.136278329618152e-18,
   2.152924808700717e-20,  -3.504890718377500e-21,   1.244992409755093e-01,  -3.268505240765226e-03,   6.554607564106627e-05,  -8.152962156009992e-07,   1.249304142410862e-08,
  -5.753783087814520e-10,   2.238942494079427e-12,   7.329958306763666e-13,   1.266107565134013e-15,  -1.267212744870721e-15,  -7.199912713236084e-18,   2.121989713223803e-18,
   2.127240512398127e-20,  -3.473643767724468e-21,   1.245004539235996e-01,  -3.268550597094333e-03,   6.554746168257771e-05,  -8.154020058762382e-07,   1.249366321998395e-08,
  -5.750956716031729e-10,   2.239584088473746e-12,   7.321581301507740e-13,   1.260188011682702e-15,  -1.265070189874746e-15,  -7.174238592642186e-18,   2.117026453676102e-18,
   2.118329344828264e-20,  -3.462796040424981e-21,   1.245006464025444e-01,  -3.268557794696422e-03,   6.554768163039797e-05,  -8.154187917523890e-07,   1.249376189571247e-08,
  -5.750508308578364e-10,   2.239685808018382e-12,   7.320252419967997e-13,   1.259249307859247e-15,  -1.264730349531776e-15,  -7.170167766272009e-18,   2.116239328113540e-18,
   2.116916615498052e-20,  -3.461075985832449e-21,   3.566670495648365e-01,  -9.222504054544764e-03,   1.720596492751721e-04,  -1.431460871537335e-06,   7.728363392519903e-09,
  -1.204524396119321e-09,  -6.314944314342737e-12,   2.881793745586677e-12,   1.156129490668480e-15,  -4.869807680949737e-15,  -2.434561525074587e-17,   8.613036531053191e-18,
   8.691460428817043e-20,  -1.523663538951550e-20,   3.566831887503850e-01,  -9.222910459879675e-03,   1.720639464162469e-04,  -1.432544685173556e-06,   7.719495168651933e-09,
  -1.199093388587891e-09,  -6.313689952492411e-12,   2.866402520772069e-12,   1.067849029296448e-15,  -4.829180035930957e-15,  -2.388518984219203e-17,   8.513926514126661e-18,
   8.519314156063623e-20,  -1.500804444735176e-20,   3.567116669191658e-01,  -9.223627808510092e-03,   1.720715247356744e-04,  -1.434453025790482e-06,   7.703847799431848e-09,
  -1.189534417722413e-09,  -6.311656461187370e-12,   2.839353201290922e-12,   9.135895557151843e-16,  -4.757895041826052e-15,  -2.308102763083469e-17,   8.340352750378768e-18,
   8.219161689593978e-20,  -1.460855024579942e-20,   3.567461035739333e-01,  -9.224495642782901e-03,   1.720806816087394e-04,  -1.436753691803913e-06,   7.684927979280708e-09,
  -1.178016630249328e-09,  -6.309502055993471e-12,   2.806829541179941e-12,   7.296179214887861e-16,  -4.672380152858973e-15,  -2.212259929964760e-17,   8.132679466847472e-18,
   7.862294388159598e-20,  -1.413200005882362e-20,   3.567795346567161e-01,  -9.225338548416373e-03,   1.720895637046172e-04,  -1.438979907842728e-06,   7.666561973796069e-09,
  -1.166878170849498e-09,  -6.307726759025091e-12,   2.775448571333482e-12,   5.536789317334946e-16,  -4.590075066135485e-15,  -2.120665375189447e-17,   7.933372889819078e-18,
   7.522142558702436e-20,  -1.367613283109410e-20,   3.568064667136490e-01,  -9.226017887727811e-03,   1.720967138194948e-04,  -1.440768148799650e-06,   7.651767175238854e-09,
  -1.157935740994056e-09,  -6.306521224852653e-12,   2.750305687574980e-12,   4.138321117971404e-16,  -4.524277524497476e-15,  -2.047904824923387e-17,   7.774447792391798e-18,
   7.252571815251926e-20,  -1.331368574043923e-20,   3.568242631384512e-01,  -9.226466932398508e-03,   1.721014359487705e-04,  -1.441947259775950e-06,   7.641991289549925e-09,
  -1.152041667577304e-09,  -6.305833844652611e-12,   2.733758636835891e-12,   3.223412045701339e-16,  -4.481046298655889e-15,  -2.000324443394860e-17,   7.670227373200200e-18,
   7.076601778110341e-20,  -1.307651441888168e-20,   3.568334025163706e-01,  -9.226697584465123e-03,   1.721038602028015e-04,  -1.442552009193223e-06,   7.636970972683267e-09,
  -1.149019385583533e-09,  -6.305514455404694e-12,   2.725281573242137e-12,   2.756385308192707e-16,  -4.458920985757935e-15,  -1.976042900001381e-17,   7.616949739061699e-18,
   6.986895340726775e-20,  -1.295543112387780e-20,   3.568365835704611e-01,  -9.226777872370841e-03,   1.721047038615964e-04,  -1.442762373595501e-06,   7.635223615370181e-09,
  -1.147968185260583e-09,  -6.305408625927250e-12,   2.722334334311218e-12,   2.594280513728615e-16,  -4.451232140979933e-15,  -1.967615805319434e-17,   7.598444798952909e-18,
   6.955777269541667e-20,  -1.291340051475245e-20,   3.568370883604055e-01,  -9.226790613304184e-03,   1.721048377326929e-04,  -1.442795749635873e-06,   7.634946334283463e-09,
  -1.147801409009675e-09,  -6.305392085314561e-12,   2.721866803726219e-12,   2.568577964507501e-16,  -4.450012599851430e-15,  -1.966279694331187e-17,   7.595510161054523e-18,
   6.950844240228481e-20,  -1.290673621857090e-20,   7.381513876066338e-01,  -1.841835657553285e-02,   2.805485929884074e-04,   1.292254032445749e-06,  -1.050690903894626e-07,
  -1.512903437986447e-09,  -8.981798360891668e-12,   7.540130307969008e-12,   1.957550746635881e-14,  -1.638053243932079e-14,  -1.636299317070224e-17,   3.007674266738426e-17,
   1.413039311137835e-19,  -5.644041046743586e-20,   7.381775702060963e-01,  -1.841799768784298e-02,   2.804894241299956e-04,   1.290952862891616e-06,  -1.050811255152111e-07,
  -1.498872495184862e-09,  -8.931332540397747e-12,   7.488474106347682e-12,   1.952793803352907e-14,  -1.623929329816310e-14,  -1.566843346067288e-17,   2.971342858056905e-17,
   1.372790654029459e-19,  -5.552032513744378e-20,   7.382237652977285e-01,  -1.841736470230849e-02,   2.803850143829222e-04,   1.288667375324083e-06,  -1.051023043227595e-07,
  -1.474195593989454e-09,  -8.842373765994769e-12,   7.397703463301939e-12,   1.944622972934577e-14,  -1.599154818663830e-14,  -1.446201578124616e-17,   2.907759508928335e-17,
   1.302781039586401e-19,  -5.391404943247765e-20,   7.382796171939657e-01,  -1.841659976092954e-02,   2.802587518702605e-04,   1.285921510317419e-06,  -1.051278162190006e-07,
  -1.444493587933776e-09,  -8.734952444232586e-12,   7.288583654533933e-12,   1.935118388471170e-14,  -1.569447003099579e-14,  -1.303550822472742e-17,   2.831760487712633e-17,
   1.219826765428056e-19,  -5.200082125054774e-20,   7.383338291821132e-01,  -1.841585766082716e-02,   2.801361688694995e-04,   1.283274429093915e-06,  -1.051524804466477e-07,
  -1.415802936977705e-09,  -8.630821346928754e-12,   7.183319862608652e-12,   1.926279403349725e-14,  -1.540866882007426e-14,  -1.168408407381903e-17,   2.758901813297257e-17,
   1.141053793806544e-19,  -5.017360911494640e-20,   7.383774958753430e-01,  -1.841526018556646e-02,   2.800374107795124e-04,   1.281155233913453e-06,  -1.051722763980465e-07,
  -1.392792606835641e-09,  -8.547040612514331e-12,   7.098996802838853e-12,   1.919432919148056e-14,  -1.518027885486491e-14,  -1.061903167145058e-17,   2.700860857165010e-17,
   1.078837326435674e-19,  -4.872296212589977e-20,   7.384063472184902e-01,  -1.841486555581728e-02,   2.799721498607996e-04,   1.279761384563596e-06,  -1.051853213760617e-07,
  -1.377637824202982e-09,  -8.491730561516018e-12,   7.043509758837685e-12,   1.915041545972303e-14,  -1.503026231468847e-14,  -9.926718626740241e-18,   2.662825758104152e-17,
   1.038327003880619e-19,  -4.777474595722457e-20,   7.384211628885075e-01,  -1.841466294740188e-02,   2.799386342272967e-04,   1.279047576153746e-06,  -1.051920095189012e-07,
  -1.369870560539594e-09,  -8.463341671415464e-12,   7.015086089488028e-12,   1.912827066601766e-14,  -1.495349870429496e-14,  -9.574700037230462e-18,   2.643390540034044e-17,
   1.017707483329768e-19,  -4.729097010364955e-20,   7.384263194788039e-01,  -1.841459243608947e-02,   2.799269686404140e-04,   1.278799446708683e-06,  -1.051943356250962e-07,
  -1.367169548978396e-09,  -8.453463100122287e-12,   7.005204348828037e-12,   1.912062747516303e-14,  -1.492682443656365e-14,  -9.452734470664759e-18,   2.636641431041925e-17,
   1.010559908590349e-19,  -4.712309165786471e-20,   7.384271377520517e-01,  -1.841458124731394e-02,   2.799251174646673e-04,   1.278760087079022e-06,  -1.051947046624182e-07,
  -1.366741052166453e-09,  -8.451895622417328e-12,   7.003636792448419e-12,   1.911941766258633e-14,  -1.492259368493938e-14,  -9.433406647164909e-18,   2.635571175154875e-17,
   1.009427072342330e-19,  -4.709647555780121e-20,   1.339710316446155e+00,  -2.938648966362010e-02,   5.291477882827856e-05,   2.541491991086977e-05,  -4.272084487977238e-07,
  -3.575117233644039e-08,   1.204827843653141e-09,   5.180459127406905e-11,  -2.844383142090996e-12,  -6.921375382539765e-14,   6.180825478470549e-15,   7.446483129860140e-17,
  -1.273700601892623e-17,  -2.985701884747981e-20,   1.339714813182826e+00,  -2.937945670632045e-02,   5.268353274404777e-05,   2.538222751884606e-05,  -4.255959697924235e-07,
  -3.565272236558381e-08,   1.197847385174145e-09,   5.158067289086716e-11,  -2.820528446848175e-12,  -6.884079126806588e-14,   6.110472989419188e-15,   7.419041896378369e-17,
  -1.255007507869403e-17,  -3.094489711957152e-20,   1.339722731180690e+00,  -2.936705427566765e-02,   5.227621379491395e-05,   2.532461523299868e-05,  -4.227585173824441e-07,
  -3.547935949670123e-08,   1.185579840213682e-09,   5.118658046609096e-11,  -2.778670460670621e-12,  -6.818389738786642e-14,   5.987241875131200e-15,   7.370041233347011e-17,
  -1.222327807126607e-17,  -3.281433436789572e-20,   1.339732277498246e+00,  -2.935206961635211e-02,   5.178490194338449e-05,   2.525507575735494e-05,  -4.193406879581284e-07,
  -3.527032916634642e-08,   1.170830003656304e-09,   5.071176817369510e-11,  -2.728452240754562e-12,  -6.739164356469387e-14,   5.839765693913140e-15,   7.309819348082586e-17,
  -1.183326233272225e-17,  -3.499063984114099e-20,   1.339741515400349e+00,  -2.933753583596166e-02,   5.130922215753790e-05,   2.518769966405874e-05,  -4.160365435839742e-07,
  -3.506803503741130e-08,   1.156598875972370e-09,   5.025263568056378e-11,  -2.680114251022563e-12,  -6.662472384359394e-14,   5.698194072223311e-15,   7.250366048301963e-17,
  -1.145998202068774e-17,  -3.701673140391191e-20,   1.339748936229791e+00,  -2.932583696417211e-02,   5.092693373819200e-05,   2.513351650567879e-05,  -4.133846396837343e-07,
  -3.490551912821265e-08,   1.145197044496439e-09,   4.988405715210486e-11,  -2.641467845647492e-12,  -6.600848358197022e-14,   5.585280034628274e-15,   7.201778358654107e-17,
  -1.116306106503314e-17,  -3.858795884578675e-20,   1.339753829460797e+00,  -2.931811113334459e-02,   5.067477055133921e-05,   2.509775927049188e-05,  -4.116371286923850e-07,
  -3.479835125147428e-08,   1.137693438099113e-09,   4.964113907746250e-11,  -2.616074219547018e-12,  -6.560206215894029e-14,   5.511220145563740e-15,   7.169340055374437e-17,
  -1.096870108959579e-17,  -3.959678768727987e-20,   1.339756339179851e+00,  -2.931414496361446e-02,   5.054541049625595e-05,   2.507941044068358e-05,  -4.107411858678017e-07,
  -3.474338329066161e-08,   1.133849390484758e-09,   4.951658430682842e-11,  -2.603077514606783e-12,  -6.539358741442376e-14,   5.473356691915708e-15,   7.152580072543700e-17,
  -1.086945383282256e-17,  -4.010586712098837e-20,   1.339757212203061e+00,  -2.931276472696294e-02,   5.050040746734674e-05,   2.507302622525173e-05,  -4.104295813463848e-07,
  -3.472426198620212e-08,   1.132512930854683e-09,   4.947326295133988e-11,  -2.598560905080002e-12,  -6.532106451409891e-14,   5.460204940705219e-15,   7.146730597766561e-17,
  -1.083499972492418e-17,  -4.028163190170649e-20,   1.339757350715733e+00,  -2.931254571309730e-02,   5.049326714687698e-05,   2.507201324558571e-05,  -4.103801452265074e-07,
  -3.472122821097557e-08,   1.132300924108049e-09,   4.946638992366410e-11,  -2.597844513981839e-12,  -6.530955796518491e-14,   5.458119217912808e-15,   7.145801609240748e-17,
  -1.082953659033811e-17,  -4.030945586906845e-20,   1.229885132211157e-02,  -3.050636856043979e-04,   6.310038383300707e-06,  -8.387388991928125e-08,   6.099521763703151e-10,
  -4.021729830963793e-11,   1.989249417443682e-12,   1.414223947456413e-14,  -3.096045808450593e-15,  -2.312313271026225e-18,   5.512621130360835e-18,  -4.956641068107626e-20,
  -9.063019283789590e-21,   1.688430494203249e-22,   1.229944360672384e-02,  -3.050874070263254e-04,   6.310396713423026e-06,  -8.391136158658646e-08,   6.126593479115168e-10,
  -4.018967891878644e-11,   1.981564300587437e-12,   1.412896132113836e-14,  -3.074409711280438e-15,  -2.528191593871137e-18,   5.461475264245109e-18,  -4.851791003313420e-20,
  -8.954565499418754e-21,   1.653635935137856e-22,   1.230048873136242e-02,  -3.051292723770378e-04,   6.311030209596327e-06,  -8.397745995618293e-08,   6.174275803442201e-10,
  -4.014096794679398e-11,   1.968048995141805e-12,   1.410496800102973e-14,  -3.036403626828276e-15,  -2.904902670831033e-18,   5.371757794093656e-18,  -4.668751616901298e-20,
  -8.764594868559530e-21,   1.592977460279470e-22,   1.230175255695850e-02,  -3.051799109450512e-04,   6.311798312455065e-06,  -8.405735105747727e-08,   6.231787245252279e-10,
  -4.008210742698690e-11,   1.951782974375106e-12,   1.407500136892824e-14,  -2.990736863663548e-15,  -3.353303021834432e-18,   5.264169803304881e-18,  -4.450748716649266e-20,
  -8.537248960435680e-21,   1.520872752180605e-22,   1.230297950910936e-02,  -3.052290852108712e-04,   6.312546140385095e-06,  -8.413487053285082e-08,   6.287465350550926e-10,
  -4.002501066470133e-11,   1.936072346881029e-12,   1.404492138039942e-14,  -2.946707118733602e-15,  -3.781213273076382e-18,   5.160661010707091e-18,  -4.242565888583464e-20,
  -8.319007184630046e-21,   1.452161691039413e-22,   1.230396796321768e-02,  -3.052687102624796e-04,   6.313150131111014e-06,  -8.419729241347092e-08,   6.332209590216309e-10,
  -3.997904631765690e-11,   1.923473272795087e-12,   1.401998762191227e-14,  -2.911453162272980e-15,  -4.120686817802790e-18,   5.077941934816722e-18,  -4.077303120648716e-20,
  -8.144945146089722e-21,   1.397719915631668e-22,   1.230462113442327e-02,  -3.052948991276894e-04,   6.313549995527218e-06,  -8.423852656304995e-08,   6.361722386991525e-10,
  -3.994868980628374e-11,   1.915175948839433e-12,   1.400317100429981e-14,  -2.888263214714532e-15,  -4.342456190617067e-18,   5.023607170044638e-18,  -3.969288042154137e-20,
  -8.030779979865091e-21,   1.362187339785326e-22,   1.230495657476671e-02,  -3.053083500133314e-04,   6.313755579286381e-06,  -8.425969821635672e-08,   6.376862132561585e-10,
  -3.993310525054274e-11,   1.910923491621820e-12,   1.399443004217679e-14,  -2.876386519861441e-15,  -4.455561318958965e-18,   4.995803672118286e-18,  -3.914182227184570e-20,
  -7.972413054412072e-21,   1.344075282211702e-22,   1.230507332875420e-02,  -3.053130319799607e-04,   6.313827171871164e-06,  -8.426706655863494e-08,   6.382129037155607e-10,
  -3.992768169767659e-11,   1.909444754896622e-12,   1.399137103371499e-14,  -2.872257885702012e-15,  -4.494804140263770e-18,   4.986142298849255e-18,  -3.895060073763488e-20,
  -7.952139578853821e-21,   1.337792722157159e-22,   1.230509185604698e-02,  -3.053137749560545e-04,   6.313838534397569e-06,  -8.426823578243212e-08,   6.382964697926963e-10,
  -3.992682109232813e-11,   1.909210164746218e-12,   1.399088482245215e-14,  -2.871602973033025e-15,  -4.501025534719010e-18,   4.984609925619304e-18,  -3.892028397595636e-20,
  -7.948924433578431e-21,   1.336796785746767e-22,   1.123609815851049e-01,  -2.778668606598219e-03,   5.659188672009113e-05,  -6.950123489780772e-07,   2.788977810386014e-09,
  -3.137431636616629e-10,   1.789679664703736e-11,   1.623936995292023e-13,  -3.121276667433469e-14,   8.353786817930427e-18,   5.469969684275991e-17,  -5.386451024879179e-19,
  -9.082734765600013e-20,   1.802078066087577e-21,   1.123662904903141e-01,  -2.778865104437048e-03,   5.659359195089416e-05,  -6.953038007058642e-07,   2.813234743417903e-09,
  -3.134240828510956e-10,   1.781924538994422e-11,   1.623621750671932e-13,  -3.099823135906837e-14,   6.000105636440780e-18,   5.418736719558177e-17,  -5.274543704223150e-19,
  -8.973506505404513e-20,   1.764932902668118e-21,   1.123756582832398e-01,  -2.779211894146506e-03,   5.659661173854748e-05,  -6.958178289170148e-07,   2.855949524578015e-09,
  -3.128611388486517e-10,   1.768285310699242e-11,   1.623003959985124e-13,  -3.062139460136233e-14,   1.891928148564545e-18,   5.328869295808336e-17,  -5.079184028354716e-19,
  -8.782184084065663e-20,   1.700182257830958e-21,   1.123869861682934e-01,  -2.779631348775707e-03,   5.660028182462809e-05,  -6.964389831325126e-07,   2.907452766758233e-09,
  -3.121805623260281e-10,   1.751868773831956e-11,   1.622152816543391e-13,  -3.016863006665626e-14,  -2.999701898938071e-18,   5.221106294775094e-17,  -4.846506790011648e-19,
  -8.553228672173289e-20,   1.623222810264934e-21,   1.123979833452391e-01,  -2.780038666151236e-03,   5.660386404769706e-05,  -6.970415552310062e-07,   2.957296752825910e-09,
  -3.115200267097905e-10,   1.736011328701347e-11,   1.621218565393693e-13,  -2.973212627692338e-14,  -7.669546631050322e-18,   5.117434154609626e-17,  -4.624309645669060e-19,
  -8.333450552834513e-20,   1.549895446090383e-21,   1.124068427163338e-01,  -2.780366880303520e-03,   5.660676369262642e-05,  -6.975266688136209e-07,   2.997340050883243e-09,
  -3.109880255596709e-10,   1.723293478937742e-11,   1.620389309829588e-13,  -2.938264605562158e-14,  -1.137552731935260e-17,   5.034588135742932e-17,  -4.447920911342362e-19,
  -8.158169478205723e-20,   1.491803086310451e-21,   1.124126969233487e-01,  -2.780583799763164e-03,   5.660868649935572e-05,  -6.978470711398414e-07,   3.023746033460326e-09,
  -3.106365486469080e-10,   1.714917424555156e-11,   1.619804122676585e-13,  -2.915276968600681e-14,  -1.379717027056440e-17,   4.980171746897114e-17,  -4.332633415654000e-19,
  -8.043207870594686e-20,   1.453891302496998e-21,   1.124157033673871e-01,  -2.780695211083680e-03,   5.660967604519025e-05,  -6.980115660354539e-07,   3.037290121552238e-09,
  -3.104560674720983e-10,   1.710624459523375e-11,   1.619492149495102e-13,  -2.903504217098275e-14,  -1.503243129503652e-17,   4.952327025444792e-17,  -4.273817265837123e-19,
  -7.984434732190765e-20,   1.434567542507188e-21,   1.124167497923272e-01,  -2.780733990851381e-03,   5.661002079863934e-05,  -6.980688125035256e-07,   3.042001617497680e-09,
  -3.103932524207809e-10,   1.709131611585181e-11,   1.619381746776066e-13,  -2.899411768827624e-14,  -1.546104685927250e-17,   4.942651414149235e-17,  -4.253407566361435e-19,
  -7.964020315104926e-20,   1.427864844610761e-21,   1.124169158457701e-01,  -2.780740144763144e-03,   5.661007552206670e-05,  -6.980778963741854e-07,   3.042749141357065e-09,
  -3.103832846840705e-10,   1.708894781605272e-11,   1.619364141209025e-13,  -2.898762598713521e-14,  -1.552899926461047e-17,   4.941116786765196e-17,  -4.250171757795839e-19,
  -7.960782825440970e-20,   1.426802314221748e-21,   3.224218413841491e-01,  -7.914389744001143e-03,   1.548731375943352e-04,  -1.483251647608868e-06,  -1.197358029506396e-08,
  -5.343278407897691e-10,   5.134815389655663e-11,   6.242987323728698e-13,  -1.097725478881437e-13,   2.427788348985769e-16,   1.918287428893512e-16,  -2.377993653015781e-18,
  -3.213258727561879e-19,   7.518120536480120e-21,   3.224363479790298e-01,  -7.914808633188592e-03,   1.548667902647738e-04,  -1.483742168912479e-06,  -1.190457457877735e-08,
  -5.330905447581833e-10,   5.107535859059260e-11,   6.248514006611026e-13,  -1.090206376300365e-13,   2.322854465849751e-16,   1.900175134904734e-16,  -2.331296832468999e-18,
  -3.174339126370202e-19,   7.363281171584243e-21,   3.224619446559847e-01,  -7.915547880108452e-03,   1.548556211132014e-04,  -1.484606756123011e-06,  -1.178311881752214e-08,
  -5.309065600260239e-10,   5.059557731482565e-11,   6.257990709511671e-13,  -1.076999390450237e-13,   2.139571967792913e-16,   1.868405981341539e-16,  -2.249775462591050e-18,
  -3.106166220974621e-19,   7.093409877188074e-21,   3.224928956860290e-01,  -7.916441973404839e-03,   1.548421676981765e-04,  -1.485650611993315e-06,  -1.163677361000652e-08,
  -5.282644017179549e-10,   5.001808951731377e-11,   6.268984198738192e-13,  -1.061132232100589e-13,   1.921117368232434e-16,   1.830313117675112e-16,  -2.152679256638405e-18,
  -3.024580540430597e-19,   6.772723631498834e-21,   3.225229416317348e-01,  -7.917310140405864e-03,   1.548291621538911e-04,  -1.486662280488968e-06,  -1.149524763415359e-08,
  -5.256981570038968e-10,   4.946025808200641e-11,   6.279173008933156e-13,  -1.045835835752256e-13,   1.712336690760545e-16,   1.793669035515319e-16,  -2.059953408472797e-18,
  -2.946261910063071e-19,   6.467243969006406e-21,   3.225471456984043e-01,  -7.918009665257247e-03,   1.548187242354782e-04,  -1.487476057232024e-06,  -1.138162442595878e-08,
  -5.236299301484460e-10,   4.901286308382503e-11,   6.287037614836670e-13,  -1.033589650277609e-13,   1.546482178619040e-16,   1.764388134384195e-16,  -1.986341728716326e-18,
  -2.883797796304882e-19,   6.225283787008748e-21,   3.225631390425608e-01,  -7.918471967705665e-03,   1.548118461942353e-04,  -1.488013193728965e-06,  -1.130673391022799e-08,
  -5.222628556067590e-10,   4.871820207694468e-11,   6.292067506176098e-13,  -1.025534835348815e-13,   1.438023779338870e-16,   1.745156296151945e-16,  -1.938228022173435e-18,
  -2.842828454018862e-19,   6.067402327441010e-21,   3.225713523060592e-01,  -7.918709403426106e-03,   1.548083199058698e-04,  -1.488288855706562e-06,  -1.126833261360889e-08,
  -5.215606675451173e-10,   4.856717875522406e-11,   6.294599239808167e-13,  -1.021409787758699e-13,   1.382674462008913e-16,   1.735315714177856e-16,  -1.913681501021010e-18,
  -2.821882929238857e-19,   5.986937236952825e-21,   3.225742109942751e-01,  -7.918792048491797e-03,   1.548070934899351e-04,  -1.488384773196296e-06,  -1.125497600630923e-08,
  -5.213162440797517e-10,   4.851466127969839e-11,   6.295472279899405e-13,  -1.019975852668768e-13,   1.363465064364047e-16,   1.731896311331181e-16,  -1.905163589382578e-18,
  -2.814607608659612e-19,   5.959028080101398e-21,   3.225746646280904e-01,  -7.918805163286372e-03,   1.548068989192773e-04,  -1.488399992595322e-06,  -1.125285693875969e-08,
  -5.212774564737512e-10,   4.850632973694494e-11,   6.295610432753522e-13,  -1.019748393520902e-13,   1.360419426090082e-16,   1.731353969645242e-16,  -1.903813133826075e-18,
  -2.813453825038779e-19,   5.954603899926646e-21,   6.690218896127758e-01,  -1.614255561618121e-02,   2.851173618507735e-04,  -5.761076997155898e-07,  -1.221480511988595e-07,
   3.866299542584031e-10,   1.351565867647289e-10,   9.043927398067847e-13,  -3.165482295516793e-13,   2.074887288087663e-15,   5.998831740668998e-16,  -1.197603561066373e-17,
  -9.867702226730988e-19,   3.487189014576788e-20,   6.690484834474575e-01,  -1.614271631030696e-02,   2.850496697913383e-04,  -5.757294543569792e-07,  -1.219671717994006e-07,
   3.884972034820263e-10,   1.343737305390652e-10,   9.100323230292436e-13,  -3.141944483584485e-13,   2.021373295746648e-15,   5.942991832290846e-16,  -1.175863201775306e-17,
  -9.753201816478238e-19,   3.416874297777500e-20,   6.690954036473573e-01,  -1.614299976835854e-02,   2.849303066678696e-04,  -5.750605856927859e-07,  -1.216488835810473e-07,
   3.918003641352898e-10,   1.329972856880310e-10,   9.198425452029396e-13,  -3.100598639665985e-13,   1.927820889091634e-15,   5.845022848197568e-16,  -1.137899739559178e-17,
  -9.552487996416422e-19,   3.294323298964410e-20,   6.691521314650212e-01,  -1.614334237643155e-02,   2.847861086327702e-04,  -5.742493082430425e-07,  -1.212654964989778e-07,
   3.958087032866733e-10,   1.313412313553678e-10,   9.314665029094358e-13,  -3.050920348373164e-13,   1.816175242561180e-15,   5.727510456599045e-16,  -1.092666109883350e-17,
  -9.312030635062940e-19,   3.148698921255272e-20,   6.692071928586296e-01,  -1.614367481449483e-02,   2.846462669365642e-04,  -5.734591379637756e-07,  -1.208948669112326e-07,
   3.997145280275798e-10,   1.297422801637216e-10,   9.425029363930780e-13,  -3.003024402516202e-13,   1.709326217603179e-15,   5.614423442075000e-16,  -1.049450414529631e-17,
  -9.080940642349419e-19,   3.009982010819820e-20,   6.692515431635495e-01,  -1.614394250748016e-02,   2.845337146908342e-04,  -5.728207233523162e-07,  -1.205974039889702e-07,
   4.028713362461106e-10,   1.284604080484089e-10,   9.512175418704153e-13,  -2.964675966330265e-13,   1.624339743072307e-15,   5.524028739696507e-16,  -1.015130028383011e-17,
  -8.896446891988837e-19,   2.900110434159565e-20,   6.692808459042788e-01,  -1.614411933794416e-02,   2.844593922162743e-04,  -5.723979564027084e-07,  -1.204013886241873e-07,
   4.049623015798165e-10,   1.276164066636377e-10,   9.568902948403514e-13,  -2.939451046900422e-13,   1.568711796236776e-15,   5.464641942963125e-16,  -9.926912930862655e-18,
  -8.775350593303568e-19,   2.828418785567421e-20,   6.692958932896436e-01,  -1.614421013142150e-02,   2.844212395255575e-04,  -5.721805623970032e-07,  -1.203008929423854e-07,
   4.060376481052710e-10,   1.271839086942679e-10,   9.597771414036874e-13,  -2.926532323160027e-13,   1.540307130617456e-15,   5.434250149671468e-16,  -9.812415666762392e-18,
  -8.713412811047591e-19,   2.791880968972403e-20,   6.693011305148702e-01,  -1.614424173014674e-02,   2.844079625909807e-04,  -5.721048513499664e-07,  -1.202659411543407e-07,
   4.064121758011290e-10,   1.270335228243536e-10,   9.607777452296159e-13,  -2.922041482614844e-13,   1.530446493697699e-15,   5.423688879254407e-16,  -9.772680679213166e-18,
  -8.691894686211368e-19,   2.779207930601098e-20,   6.693019615830252e-01,  -1.614424674429743e-02,   2.844058558410078e-04,  -5.720928349092323e-07,  -1.202603960517896e-07,
   4.064716197272961e-10,   1.270096657282041e-10,   9.609363286009075e-13,  -2.921329115619764e-13,   1.528882972917255e-15,   5.422013751421664e-16,  -9.766380822367809e-18,
  -8.688481948409474e-19,   2.777198992637235e-20,   1.224721723718116e+00,  -2.790194432342876e-02,   2.992468883423971e-04,   1.472589636345268e-05,  -7.923276851121908e-07,
  -3.372737200686189e-10,   1.335260650305179e-09,  -3.458705480403492e-11,  -1.501507622094073e-12,   1.002462043084635e-13,   2.775874423898692e-16,  -1.910555226133155e-16,
   4.067307902452199e-18,   2.582069912058504e-19,   1.224748904317675e+00,  -2.789780575138400e-02,   2.988115187378725e-04,   1.472505413801020e-05,  -7.904960586822402e-07,
  -4.004131264103476e-10,   1.331358582333933e-09,  -3.427233717664489e-11,  -1.499692476445126e-12,   9.932999487951792e-14,   2.982957899560689e-16,  -1.892682931792260e-16,
   3.968368198944961e-18,   2.564051805155346e-19,   1.224796832949589e+00,  -2.789050345799058e-02,   2.980441290043445e-04,   1.472352139998028e-05,  -7.872685698643600e-07,
  -5.113313749294586e-10,   1.324477574860099e-09,  -3.371947662992674e-11,  -1.496422431619830e-12,   9.772071639431304e-14,   3.343589586773849e-16,  -1.861256613809160e-16,
   3.795672300707622e-18,   2.532066245393343e-19,   1.224854734304013e+00,  -2.788167393465342e-02,   2.971176014876434e-04,   1.472158876007997e-05,  -7.833734311308491e-07,
  -6.446182763309073e-10,   1.316164332936769e-09,  -3.305513873770927e-11,  -1.492354782254634e-12,   9.578732405981246e-14,   3.771598909726211e-16,  -1.823443203652792e-16,
   3.590036061560081e-18,   2.493071338772340e-19,   1.224910886959854e+00,  -2.787310290586802e-02,   2.962196176542740e-04,   1.471962993018596e-05,  -7.796000259710842e-07,
  -7.731381668977225e-10,   1.308101793624389e-09,  -3.241457806626011e-11,  -1.488288531914976e-12,   9.392353682875235e-14,   4.178732314299125e-16,  -1.786931962394022e-16,
   3.393717242220155e-18,   2.454896132070364e-19,   1.224956082022548e+00,  -2.786619857500768e-02,   2.954972677400034e-04,   1.471799292372282e-05,  -7.765658970204354e-07,
  -8.760491935696360e-10,   1.301612397710772e-09,  -3.190166737566802e-11,  -1.484929632921835e-12,   9.243146325465199e-14,   4.500772598701265e-16,  -1.757660993157102e-16,
   3.237914913426068e-18,   2.423922700715619e-19,   1.224985926159585e+00,  -2.786163650395678e-02,   2.950204674389312e-04,   1.471688242216797e-05,  -7.745637770212283e-07,
  -9.437469237509858e-10,   1.297327135517298e-09,  -3.156426616138721e-11,  -1.482669793914391e-12,   9.145010336131794e-14,   4.710684816672435e-16,  -1.738389027576065e-16,
   3.136105271300269e-18,   2.403351899174279e-19,   1.225001246383773e+00,  -2.785929372078670e-02,   2.947757670340179e-04,   1.471630324002995e-05,  -7.735364515509001e-07,
  -9.784191231322346e-10,   1.295127326009057e-09,  -3.139146383071585e-11,  -1.481496865967815e-12,   9.094754070175835e-14,   4.817596986514518e-16,  -1.728513577350033e-16,
   3.084172413764541e-18,   2.392756370816996e-19,   1.225006577746402e+00,  -2.785847830302613e-02,   2.946906221785882e-04,   1.471610023735741e-05,  -7.731790182329483e-07,
  -9.904721808091381e-10,   1.294361802520245e-09,  -3.133139302217699e-11,  -1.481086652077441e-12,   9.077284383210189e-14,   4.854667834164993e-16,  -1.725079783721748e-16,
   3.066152466096413e-18,   2.389063562407321e-19,   1.225007423713628e+00,  -2.785834890790373e-02,   2.946771120664624e-04,   1.471606795658268e-05,  -7.731223049780697e-07,
  -9.923841271849555e-10,   1.294240331161385e-09,  -3.132186415297195e-11,  -1.481021463618023e-12,   9.074513250601246e-14,   4.860543786187122e-16,  -1.724535051703609e-16,
   3.063295592349518e-18,   2.388477331513432e-19,   1.117339414028196e-02,  -2.584894096758841e-04,   5.343885720693034e-06,  -7.800980180210738e-08,   2.618999369143469e-10,
   2.297908665996404e-12,   1.234661115326959e-12,  -5.369750134245285e-14,  -5.477034570670130e-16,   9.629917448821460e-17,   1.117415509412459e-02,  -2.585227070191813e-04,
   5.344124104534488e-06,  -7.800781734272640e-08,   2.645078851110484e-10,   2.144845030853448e-12,   1.232354440323578e-12,  -5.323056974184972e-14,  -5.538604456917903e-16,
   9.530861445646452e-17,   1.117540434993073e-02,  -2.585773696839288e-04,   5.344517050817162e-06,  -7.800471391360363e-08,   2.687856314252981e-10,   1.894557817287418e-12,
   1.228550941039258e-12,  -5.246764043589990e-14,  -5.637909536659068e-16,   9.368952190188820e-17,   1.117672994357448e-02,  -2.586353705958886e-04,   5.344936171333282e-06,
  -7.800163020374076e-08,   2.733197138504819e-10,   1.630327049700043e-12,   1.224492685388450e-12,  -5.166301148675058e-14,  -5.740891124919488e-16,   9.198115180027079e-17,
   1.117777321936689e-02,  -2.586810173485437e-04,   5.345267594536414e-06,  -7.799935439279339e-08,   2.768844755221291e-10,   1.423345315476896e-12,   1.221282776807840e-12,
  -5.103329927626520e-14,  -5.820223727181268e-16,   9.064361531722235e-17,   1.117837532492470e-02,  -2.587073608804411e-04,   5.345459495621764e-06,  -7.799810139851355e-08,
   2.789403287155236e-10,   1.304279547694922e-12,   1.219423916069497e-12,  -5.067129333228036e-14,  -5.865325828292277e-16,   8.987448665360603e-17,   1.117860142357359e-02,
  -2.587172531201860e-04,   5.345531675477290e-06,  -7.799764229001826e-08,   2.797120493636347e-10,   1.259642267979075e-12,   1.218724701612902e-12,  -5.053562318394073e-14,
  -5.882133740793222e-16,   8.958619848099871e-17,   1.117863890276785e-02,  -2.587188928995651e-04,   5.345543646603082e-06,  -7.799756678737918e-08,   2.798399587129426e-10,
   1.252246853127493e-12,   1.218608734033676e-12,  -5.051314797284363e-14,  -5.884913134785669e-16,   8.953843840631387e-17,   1.020999211156819e-01,  -2.358874828935119e-03,
   4.838765004164045e-05,  -6.775956975932815e-07,   6.445319468741411e-10,   7.049623514810580e-11,   1.095322179943362e-11,  -5.123157066418650e-13,  -5.246927009951993e-15,
   9.544839100372088e-16,   1.021068084058737e-01,  -2.359163800670364e-03,   4.838833119806037e-05,  -6.775076158837882e-07,   6.676464293095130e-10,   6.903870513484178e-11,
   1.093095553185676e-11,  -5.076838681235563e-13,  -5.314157388548799e-15,   9.448097195125077e-16,   1.021181150987032e-01,  -2.359638170207061e-03,   4.838946360578245e-05,
  -6.773644843619572e-07,   7.055575394232159e-10,   6.665577182737961e-11,   1.089421866682316e-11,  -5.001152745018755e-13,  -5.422701201183203e-15,   9.289945677828939e-16,
   1.021301124986333e-01,  -2.360141480118228e-03,   4.839068443653914e-05,  -6.772146015992127e-07,   7.457363686146774e-10,   6.414062474611344e-11,   1.085499187127760e-11,
  -4.921322774175351e-13,  -5.535412967717799e-15,   9.123040468974021e-16,   1.021395546065293e-01,  -2.360537564081449e-03,   4.839165917100128e-05,  -6.770980802244674e-07,
   7.773226027777797e-10,   6.217080907277105e-11,   1.082394416469305e-11,  -4.858841662465205e-13,  -5.622350851256656e-15,   8.992341476190212e-16,   1.021450038683554e-01,
  -2.360766142490923e-03,   4.839222729170466e-05,  -6.770314081348413e-07,   7.955376828309824e-10,   6.103783473992152e-11,   1.080595609234507e-11,  -4.822920731525267e-13,
  -5.671821198676476e-15,   8.917175748654916e-16,   1.021470501273237e-01,  -2.360851974189012e-03,   4.839244168143176e-05,  -6.770064805545754e-07,   8.023749847413655e-10,
   6.061311705167371e-11,   1.079918827845094e-11,  -4.809458132940794e-13,  -5.690265491014988e-15,   8.889000037635827e-16,   1.021473893244054e-01,  -2.360866201928474e-03,
   4.839247727523154e-05,  -6.770023541686127e-07,   8.035082259267269e-10,   6.054275225477932e-11,   1.079806572669064e-11,  -4.807227888717433e-13,  -5.693315930827474e-15,
   8.884332136055500e-16,   2.931253374636531e-01,  -6.750267095389272e-03,   1.357886636349365e-04,  -1.693968819469023e-06,  -1.077005952078069e-08,   5.626634203916142e-10,
   2.932883382249952e-11,  -1.665129752380794e-12,  -1.514987913523742e-14,   3.273503783208860e-15,   2.931446434049343e-01,  -6.750987606972454e-03,   1.357798174918200e-04,
  -1.693207761602314e-06,  -1.070824742527545e-08,   5.579398070267148e-10,   2.926270504137614e-11,  -1.649218247023347e-12,  -1.543413597914081e-14,   3.241330006262828e-15,
   2.931763363790374e-01,  -6.752170217702535e-03,   1.357653330058127e-04,  -1.691963116301851e-06,  -1.060687787309718e-08,   5.502190447439615e-10,   2.915336502492327e-11,
  -1.623214598680482e-12,  -1.589384104902420e-14,   3.188706107900268e-15,   2.932099639169744e-01,  -6.753424753200978e-03,   1.357500153050640e-04,  -1.690648894236106e-06,
  -1.049946028795001e-08,   5.420725363544641e-10,   2.903629893543071e-11,  -1.595782232516081e-12,  -1.637225281834512e-14,   3.133133312003390e-15,   2.932364281299560e-01,
  -6.754411858366948e-03,   1.357379974224241e-04,  -1.689619244608020e-06,  -1.041502636205329e-08,   5.356942558568882e-10,   2.894341699903144e-11,  -1.574307994945552e-12,
  -1.674203753821898e-14,   3.089589872718463e-15,   2.932517008101609e-01,  -6.754981447726763e-03,   1.357310765807603e-04,  -1.689026872807097e-06,  -1.036633985325930e-08,
   5.320264436807001e-10,   2.888951500216459e-11,  -1.561960858288613e-12,  -1.695276930390633e-14,   3.064537519306904e-15,   2.932574357902697e-01,  -6.755195317523012e-03,
   1.357284805535463e-04,  -1.688804782126402e-06,  -1.034806553519794e-08,   5.306516378816680e-10,   2.886921826398132e-11,  -1.557333080256087e-12,  -1.703139717422833e-14,
   3.055144766948183e-15,   2.932583864419807e-01,  -6.755230768624064e-03,   1.357280503734924e-04,  -1.688767985910488e-06,  -1.034503672527340e-08,   5.304238756158334e-10,
   2.886585084265605e-11,  -1.556566418181569e-12,  -1.704440433457375e-14,   3.053588557491598e-15,   6.089268577844864e-01,  -1.392084163963657e-02,   2.672791069217309e-04,
  -2.301925626539773e-06,  -8.505607647193938e-08,   2.987101617548886e-09,   5.417703766109836e-11,  -4.949012255402955e-12,  -7.428483057945563e-15,   9.270085190269240e-15,
   6.089647488398719e-01,  -1.392180980492719e-02,   2.672071332783486e-04,  -2.297792917078905e-06,  -8.494111166094016e-08,   2.973030229897636e-09,   5.412254610336299e-11,
  -4.903767297168393e-12,  -8.651976435968789e-15,   9.186195259232374e-15,   6.090269458428048e-01,  -1.392339795706888e-02,   2.670890476039662e-04,  -2.291022582269183e-06,
  -8.475247532359194e-08,   2.950026040523338e-09,   5.402971075210558e-11,  -4.829799208667618e-12,  -1.063519202495613e-14,   9.048711474620881e-15,   6.090929317572134e-01,
  -1.392508141558843e-02,   2.669638456384473e-04,  -2.283857947435983e-06,  -8.455245218954305e-08,   2.925747293080782e-09,   5.392665266063230e-11,  -4.751732567481285e-12,
  -1.270533005206689e-14,   8.903157582950967e-15,   6.091448558446086e-01,  -1.392640508185329e-02,   2.668653805544964e-04,  -2.278233211435704e-06,  -8.439513254008299e-08,
   2.906733972927008e-09,   5.384227985844366e-11,  -4.690596827311597e-12,  -1.430996153785317e-14,   8.788848486650932e-15,   6.091748193761222e-01,  -1.392716850531844e-02,
   2.668085822864024e-04,  -2.274992612004131e-06,  -8.430438092699238e-08,   2.895798672645701e-09,   5.379228772051247e-11,  -4.655435564076855e-12,  -1.522623553119067e-14,
   8.722977595616915e-15,   6.091860704369391e-01,  -1.392745508583507e-02,   2.667872592360407e-04,  -2.273776781250347e-06,  -8.427031055746372e-08,   2.891699465318614e-09,
   5.377327085350141e-11,  -4.642255083500841e-12,  -1.556846241667895e-14,   8.698261378640260e-15,   6.091879354326604e-01,  -1.392750258577515e-02,   2.667837249129052e-04,
  -2.273575295070381e-06,  -8.426466331763771e-08,   2.891020337664422e-09,   5.377010567552948e-11,  -4.640071439092803e-12,  -1.562509436802465e-14,   8.694165317383142e-15,
   1.118730809077767e+00,  -2.500765507378125e-02,   4.042430788496776e-04,   3.350856424370467e-06,  -5.717408181106064e-07,   1.773909091581247e-08,   1.789061616702778e-10,
  -3.464482604709957e-11,   9.818301630647959e-13,   2.100239805589263e-14,   1.118787359058893e+00,  -2.500613853010240e-02,   4.037573267307831e-04,   3.375243835471241e-06,
  -5.713164071719903e-07,   1.763742641231320e-08,   1.825209675798306e-10,  -3.452882900036532e-11,   9.674041764017695e-13,   2.132362132550528e-14,   1.118880145448757e+00,
  -2.500364155268877e-02,   4.029601611971585e-04,   3.415175938085869e-06,  -5.706142479093722e-07,   1.747078350783792e-08,   1.884142803376087e-10,  -3.433727798194850e-11,
   9.438208911525366e-13,   2.184214450044659e-14,   1.118978531646777e+00,  -2.500098212796461e-02,   4.021146827209870e-04,   3.457406087277985e-06,  -5.698618706947383e-07,
   1.729431148288217e-08,   1.946120082873590e-10,  -3.413251876067657e-11,   9.189323653105315e-13,   2.238042773574921e-14,   1.119055913364910e+00,  -2.499888196442963e-02,
   4.014495601680157e-04,   3.490539538510639e-06,  -5.692644642097308e-07,   1.715568073701387e-08,   1.994495697586398e-10,  -3.397029353125431e-11,   8.994429755959324e-13,
   2.279549350100588e-14,   1.119100552336171e+00,  -2.499766704443495e-02,   4.010658150038373e-04,   3.509620693557498e-06,  -5.689175809248609e-07,   1.707577622971080e-08,
   2.022253946723196e-10,  -3.387624231326174e-11,   8.882346030253855e-13,   2.303162119201675e-14,   1.119117311022676e+00,  -2.499721028710774e-02,   4.009217357366247e-04,
   3.516778148522661e-06,  -5.687869253573775e-07,   1.704579061155261e-08,   2.032647202371517e-10,  -3.384084480967463e-11,   8.840331880060419e-13,   2.311964627478678e-14,
   1.119120088820137e+00,  -2.499713454442131e-02,   4.008978536374270e-04,   3.517964192587119e-06,  -5.687652463855098e-07,   1.704082108622990e-08,   2.034368439000122e-10,
  -3.383497294173365e-11,   8.833371359728189e-13,   2.313420381434829e-14,   1.021912516200766e-02,  -2.194001595180000e-04,   4.438239555129691e-06,  -7.235244947236140e-08,
   4.838887456175753e-10,   1.458369432072198e-11,  -1.023261264908036e-13,  -3.186566734570228e-14,   1.325712119864254e-15,   3.145452567280369e-18,   1.021975758520879e-02,
  -2.194309780370108e-04,   4.438651848208753e-06,  -7.233249555874458e-08,   4.837296012602128e-10,   1.448891738442084e-11,  -9.730421228393079e-14,  -3.183871052292693e-14,
   1.313104525181997e-15,   3.555934516768030e-18,   1.022079585256520e-02,  -2.194815656552567e-04,   4.439328614478278e-06,  -7.229983526336911e-08,   4.834759500988632e-10,
   1.433339083826554e-11,  -8.909591694584897e-14,  -3.179298944818205e-14,   1.292462757793448e-15,   4.222788337174333e-18,   1.022189759199598e-02,  -2.195352349330889e-04,
   4.440046610210567e-06,  -7.226531234135445e-08,   4.832171190779421e-10,   1.416845537235337e-11,  -8.043510497877482e-14,  -3.174249603525550e-14,   1.270636195312946e-15,
   4.920874909693759e-18,   1.022276470836401e-02,  -2.195774670887381e-04,   4.440611602154036e-06,  -7.223823828698788e-08,   4.830208604882586e-10,   1.403871694261902e-11,
  -7.365428004390847e-14,  -3.170133503122602e-14,   1.253513819490301e-15,   5.463429844134990e-18,   1.022326515486994e-02,  -2.196018377516565e-04,   4.440937640850121e-06,
  -7.222265165804166e-08,   4.829105714551685e-10,   1.396386950860351e-11,  -6.975505202530468e-14,  -3.167701364992642e-14,   1.243654388824076e-15,   5.773816851815113e-18,
   1.022345308066464e-02,  -2.196109887361556e-04,   4.441060066180154e-06,  -7.221680596873696e-08,   4.828697183252580e-10,   1.393576873619034e-11,  -6.829351893917864e-14,
  -3.166777407302830e-14,   1.239956285522431e-15,   5.889855171256273e-18,   1.022348423222149e-02,  -2.196125056195287e-04,   4.441080359645744e-06,  -7.221583734422790e-08,
   4.828629759331542e-10,   1.393111090563420e-11,  -6.805138947588936e-14,  -3.166623686477206e-14,   1.239343494350177e-15,   5.909063042119435e-18,   9.338760289633879e-02,
  -2.003947299468978e-03,   4.039780866342301e-05,  -6.465836786377468e-07,   3.538698371351045e-09,   1.685710655163655e-10,  -1.701350782930594e-12,  -2.954088684825795e-13,
   1.291954944060691e-14,   1.892600463411749e-17,   9.339335784303346e-02,  -2.004222520476752e-03,   4.040081314134218e-05,  -6.463512097417909e-07,   3.535644356111840e-09,
   1.676917928196205e-10,  -1.652411754320014e-12,  -2.952008560530119e-13,   1.279665194331036e-14,   2.312829332842784e-17,   9.340280582620858e-02,  -2.004674270321166e-03,
   4.040574377520334e-05,  -6.459704772066382e-07,   3.530704855267471e-09,   1.662488444858506e-10,  -1.572421446366557e-12,  -2.948443347375465e-13,   1.259540227192987e-14,
   2.995730989449410e-17,   9.341283128350808e-02,  -2.005153516863899e-03,   4.041097326901737e-05,  -6.455677171840353e-07,   3.525564156885390e-09,   1.647184890550374e-10,
  -1.488021810500319e-12,  -2.944457438135979e-13,   1.238255282233090e-14,   3.710906862817446e-17,   9.342072167291973e-02,  -2.005530617779910e-03,   4.041508726950896e-05,
  -6.452516307747186e-07,   3.521590928965791e-09,   1.635146292948829e-10,  -1.421943040178314e-12,  -2.941174666199672e-13,   1.221554307682438e-14,   4.266953883248817e-17,
   9.342527549191758e-02,  -2.005748222621054e-03,   4.041746088912265e-05,  -6.450695669310764e-07,   3.519326898417269e-09,   1.628200784050964e-10,  -1.383945445011401e-12,
  -2.939222013819908e-13,   1.211936140090327e-14,   4.585144015620721e-17,   9.342698551909813e-02,  -2.005829930215039e-03,   4.041835208468781e-05,  -6.450012673874470e-07,
   3.518482204109723e-09,   1.625593097731729e-10,  -1.369702982105635e-12,  -2.938477834546262e-13,   1.208328268778908e-14,   4.704115555000685e-17,   9.342726898178640e-02,
  -2.005843474144727e-03,   4.041849980668069e-05,  -6.449899493074206e-07,   3.518342472372037e-09,   1.625160858754723e-10,  -1.367343461643214e-12,  -2.938353900145339e-13,
   1.207730415640660e-14,   4.723809809394186e-17,   2.681653552032127e-01,  -5.747172469344142e-03,   1.148793225824049e-04,  -1.753657222818490e-06,   3.850958313125321e-09,
   7.405287684163508e-10,  -1.059821864117295e-11,  -8.779160231908402e-13,   4.348647550023550e-14,  -5.203799594510337e-17,   2.681817097517694e-01,  -5.747917503744194e-03,
   1.148824945121859e-04,  -1.752625516302672e-06,   3.830282024667706e-09,   7.379083121104978e-10,  -1.043332235046640e-11,  -8.777696292841471e-13,   4.308134707958572e-14,
  -3.642789297896478e-17,   2.682085586991502e-01,  -5.749140285154347e-03,   1.148876896006816e-04,  -1.750934496570576e-06,   3.796588515815632e-09,   7.336069888912818e-10,
  -1.016377736391279e-11,  -8.774733122532187e-13,   4.241761640049294e-14,  -1.104213637916774e-17,   2.682370479270522e-01,  -5.750437325620555e-03,   1.148931855643083e-04,
  -1.749143854141403e-06,   3.761175846402563e-09,   7.290438056104694e-10,  -9.879342231853230e-12,  -8.770832888930516e-13,   4.171520233966478e-14,   1.556811195606953e-17,
   2.682594694025225e-01,  -5.751457795845710e-03,   1.148974990880129e-04,  -1.747737258843733e-06,   3.733550386413348e-09,   7.254532248438122e-10,  -9.656627399381890e-12,
  -8.767219752247568e-13,   4.116375494991380e-14,   3.627543043178462e-17,   2.682724093959333e-01,  -5.752046606048941e-03,   1.148999837867403e-04,  -1.746926547194034e-06,
   3.717704947954552e-09,   7.233813150659605e-10,  -9.528549550825599e-12,  -8.764917870311685e-13,   4.084605165079861e-14,   4.813210687694965e-17,   2.682772685150767e-01,
  -5.752267686878673e-03,   1.149009159261964e-04,  -1.746622317621399e-06,   3.711773274954226e-09,   7.226033481079676e-10,  -9.480541020880240e-12,  -8.764012685742413e-13,
   4.072685492845738e-14,   5.256669181207293e-17,   2.682780739848371e-01,  -5.752304332964152e-03,   1.149010703947839e-04,  -1.746571897803197e-06,   3.710790987665383e-09,
   7.224743919390673e-10,  -9.472587453785965e-12,  -8.763860489401574e-13,   4.070710186532049e-14,   5.330085410692520e-17,   5.573186393688370e-01,  -1.191146140969091e-02,
   2.335682318078721e-04,  -3.158604164319057e-06,  -2.263368348344705e-08,   2.831836787048437e-09,  -5.249746985122715e-11,  -1.962480238573385e-12,   1.293288540742915e-13,
  -1.119537926645165e-15,   5.573518377667706e-01,  -1.191279583727151e-02,   2.335483071896411e-04,  -3.154624385432817e-06,  -2.273991080902582e-08,   2.825905632508472e-09,
  -5.200371028060199e-11,  -1.966808305433530e-12,   1.282886514685464e-13,  -1.066472370220830e-15,   5.574063361679013e-01,  -1.191498529991379e-02,   2.335155339839856e-04,
  -3.148097060734320e-06,  -2.291354983101359e-08,   2.816160235519954e-09,  -5.119611380223221e-11,  -1.973722172592683e-12,   1.265820092316868e-13,  -9.800380101682315e-16,
   5.574641602694818e-01,  -1.191730683713369e-02,   2.334806727277055e-04,  -3.141179395347437e-06,  -2.309677702610622e-08,   2.805808358888895e-09,  -5.034325300654591e-11,
  -1.980799629027757e-12,   1.247725876946022e-13,  -8.892485868019881e-16,   5.575096660289004e-01,  -1.191913270395168e-02,   2.334531744098745e-04,  -3.135741191229576e-06,
  -2.324024327493301e-08,   2.797653401404987e-09,  -4.967498619840414e-11,  -1.986183404646827e-12,   1.233496760595685e-13,  -8.184644190742824e-16,   5.575359274449220e-01,
  -1.192018596858136e-02,   2.334372796738139e-04,  -3.132605117449739e-06,  -2.332274667478312e-08,   2.792943875912436e-09,  -4.929049398978931e-11,  -1.989216195563276e-12,
   1.225289506058984e-13,  -7.778805945108175e-16,   5.575457887074791e-01,  -1.192058138945450e-02,   2.334313063400260e-04,  -3.131427948122092e-06,  -2.335367207247414e-08,
   2.791174815543678e-09,  -4.914633586510794e-11,  -1.990341039084001e-12,   1.222208500776907e-13,  -7.626913901841392e-16,   5.575474233444409e-01,  -1.192064693135234e-02,
   2.334303159265663e-04,  -3.131232839597774e-06,  -2.335879547649505e-08,   2.790881537679175e-09,  -4.912245133004328e-11,  -1.990526760484558e-12,   1.221697828089327e-13,
  -7.601762208472711e-16,   1.025238982045146e+00,  -2.174126757128616e-02,   4.012907923117913e-04,  -2.987861071518561e-06,  -2.332559809265266e-07,   1.411398869396068e-08,
  -3.383365156174717e-10,  -4.289667940786207e-12,   6.623433979242332e-13,  -2.239605547095688e-14,   1.025295680254624e+00,  -2.174247266075563e-02,   4.010877287968587e-04,
  -2.967900073510318e-06,  -2.339469510791475e-07,   1.409945592906648e-08,  -3.357049761296457e-10,  -4.397726048456482e-12,   6.620251449996115e-13,  -2.214758363595171e-14,
   1.025388738042234e+00,  -2.174444488083160e-02,   4.007539506675575e-04,  -2.935146517670084e-06,  -2.350772350714324e-07,   1.407536899263488e-08,  -3.313860957752592e-10,
  -4.574198770520888e-12,   6.614501110886274e-13,  -2.173938922682735e-14,   1.025487450306417e+00,  -2.174652923134771e-02,   4.003992215786916e-04,  -2.900413863950402e-06,
  -2.362710434316824e-07,   1.404950068687719e-08,  -3.268051667252178e-10,  -4.760196217950706e-12,   6.607688513348074e-13,  -2.130589762350803e-14,   1.025565116189046e+00,
  -2.174816359912724e-02,   4.001196401422367e-04,  -2.873094676949994e-06,  -2.372065882656802e-07,   1.402891845787367e-08,  -3.232012731468268e-10,  -4.905669088426693e-12,
   6.601814845785230e-13,  -2.096449231257096e-14,   1.025609930189851e+00,  -2.174910440954236e-02,   3.999581251243233e-04,  -2.857334523424286e-06,  -2.377449109853454e-07,
   1.401695064960814e-08,  -3.211219465250817e-10,  -4.989260207737626e-12,   6.598220644171777e-13,  -2.076736882304609e-14,   1.025626756685759e+00,  -2.174945723680110e-02,
   3.998974438428492e-04,  -2.851417620587017e-06,  -2.379467544277767e-07,   1.401243975451589e-08,  -3.203412453152413e-10,  -5.020580669685577e-12,   6.596832459183975e-13,
  -2.069333040593873e-14,   1.025629545833513e+00,  -2.174951569889416e-02,   3.998873834287884e-04,  -2.850436872201605e-06,  -2.379801969318196e-07,   1.401169112025371e-08,
  -3.202118386001606e-10,  -5.025768852944346e-12,   6.596600317790485e-13,  -2.068105662217562e-14,   9.407250087456822e-03,  -1.872154076632101e-04,   3.625029074358558e-06,
  -6.263047947049385e-08,   7.023439331064700e-10,   5.892627077736812e-12,  -4.643457966944671e-13,   1.994855197596599e-15,   6.179317746886664e-16,  -2.707107448368378e-17,
   9.407767150669273e-03,  -1.872421162571951e-04,   3.625623332877626e-06,  -6.262206328043777e-08,   7.013822839380491e-10,   5.896472317193293e-12,  -4.618609042576035e-13,
   1.861719375932720e-15,   6.190729116790320e-16,  -2.686487878723974e-17,   9.408616053902079e-03,  -1.872859601350716e-04,   3.626598320382732e-06,  -6.260824366193520e-08,
   6.998074264341682e-10,   5.902500954217126e-12,  -4.577785565604211e-13,   1.643923282938213e-15,   6.208953292865114e-16,  -2.652578533530230e-17,   9.409516887750892e-03,
  -1.873324783421127e-04,   3.627632065045869e-06,  -6.259357595035485e-08,   6.981416092483339e-10,   5.908512811305859e-12,  -4.534428799111250e-13,   1.413869554100862e-15,
   6.227600733664934e-16,  -2.616519882847997e-17,   9.410225908004414e-03,  -1.873690858551929e-04,   3.628445054810851e-06,  -6.258202959184908e-08,   6.968343896433584e-10,
   5.912966147272376e-12,  -4.500278530027399e-13,   1.233573351295328e-15,   6.241778922313254e-16,  -2.588086431796897e-17,   9.410635121212011e-03,  -1.873902117404782e-04,
   3.628914017866528e-06,  -6.257536488403534e-08,   6.960814863612789e-10,   5.915425044053177e-12,  -4.480558616507477e-13,   1.129824723539810e-15,   6.249762691496241e-16,
  -2.571655343518965e-17,   9.410788789329610e-03,  -1.873981445264791e-04,   3.629090074869663e-06,  -6.257286202097495e-08,   6.957990508139731e-10,   5.916327392479859e-12,
  -4.473151514420545e-13,   1.090923542931102e-15,   6.252723190789226e-16,  -2.565481285616598e-17,   9.410814262256463e-03,  -1.873994594890724e-04,   3.629119256555341e-06,
  -6.257244712521726e-08,   6.957522482279275e-10,   5.916475862925971e-12,  -4.471923572171286e-13,   1.084478147522097e-15,   6.253211960319595e-16,  -2.564457636474513e-17,
   8.597070371302505e-02,  -1.710607161294990e-03,   3.307685916857720e-05,  -5.672181702427342e-07,   6.060426447082159e-09,   7.172061402216296e-11,  -4.857854762733406e-12,
   2.956443228956919e-14,   5.783240050134726e-15,  -2.640317404837285e-16,   8.597542108348143e-02,  -1.710848956604726e-03,   3.308197678478339e-05,  -5.671155538044035e-07,
   6.050333944049432e-09,   7.178829813169442e-11,  -4.834554812784324e-12,   2.826441443649090e-14,   5.796056318034597e-15,  -2.620779075564760e-16,   8.598316592810647e-02,
  -1.711245870967005e-03,   3.309037204010541e-05,  -5.669470312380446e-07,   6.033801545091193e-09,   7.189663893851168e-11,  -4.796270156994857e-12,   2.613751123939703e-14,
   5.816591266907028e-15,  -2.588634403917387e-16,   8.599138450994813e-02,  -1.711666984596480e-03,   3.309927172248401e-05,  -5.667681343106635e-07,   6.016308452119096e-09,
   7.200783601134285e-11,  -4.755601736713704e-12,   2.389061875421709e-14,   5.837696447866328e-15,  -2.554434131979492e-16,   8.599785308586699e-02,  -1.711998371962529e-03,
   3.310626979606216e-05,  -5.666272837228108e-07,   6.002576837686409e-09,   7.209263252153143e-11,  -4.723563194677367e-12,   2.212949237535465e-14,   5.853812991595915e-15,
  -2.527453043932823e-16,   8.600158643139669e-02,  -1.712189609553806e-03,   3.311030610993721e-05,  -5.665459733375623e-07,   5.994666308106179e-09,   7.214048371766712e-11,
  -4.705060388899830e-12,   2.111599725067980e-14,   5.862917027324575e-15,  -2.511856058142261e-16,   8.600298837829216e-02,  -1.712261418800987e-03,   3.311182133056434e-05,
  -5.665154362255081e-07,   5.991698520468802e-09,   7.215824722025176e-11,  -4.698110018145900e-12,   2.073596550378799e-14,   5.866298496280624e-15,  -2.505994442043480e-16,
   8.600322077308936e-02,  -1.712273322086536e-03,   3.311207247605826e-05,  -5.665103740388303e-07,   5.991206709374062e-09,   7.216118096180032e-11,  -4.696957769572381e-12,
   2.067299860227865e-14,   5.866857063187115e-15,  -2.505022543879031e-16,   2.468842687137136e-01,  -4.910260670246540e-03,   9.463275504746509e-05,  -1.593065061594742e-06,
   1.488268362450774e-08,   3.336308831692039e-10,  -1.843576433685300e-11,   1.716516250037875e-13,   1.746639808620846e-14,  -8.830534239559704e-16,   2.468977607626526e-01,
  -4.910939093784435e-03,   9.464524476565093e-05,  -1.592586598054191e-06,   1.484417251765209e-08,   3.340744674696298e-10,  -1.836501056528316e-11,   1.672889462472112e-13,
   1.752380404290062e-14,  -8.770782269611448e-16,   2.469199113952052e-01,  -4.912052687385472e-03,   9.466572516187743e-05,  -1.591800695149910e-06,   1.478106005899289e-08,
   3.347933652358994e-10,  -1.824870142617764e-11,   1.601492742963528e-13,   1.761630798768813e-14,  -8.672361114264420e-16,   2.469434166268940e-01,  -4.913234094471086e-03,
   9.468742454750350e-05,  -1.590966215527217e-06,   1.471424215477958e-08,   3.355435345625386e-10,  -1.812507999953522e-11,   1.526039987491035e-13,   1.771210785964001e-14,
  -8.567488842844168e-16,   2.469619165965872e-01,  -4.914163721903299e-03,   9.470447901263271e-05,  -1.590309062790899e-06,   1.466176430182667e-08,   3.361247934093264e-10,
  -1.802764050464118e-11,   1.466879365556728e-13,   1.778580409916068e-14,  -8.484640708723902e-16,   2.469725937831077e-01,  -4.914700169471504e-03,   9.471431224187957e-05,
  -1.589929642931459e-06,   1.463152170579504e-08,   3.364565970845881e-10,  -1.797134732844246e-11,   1.432825399990989e-13,   1.782765653079874e-14,  -8.436703673900998e-16,
   2.469766032658215e-01,  -4.914901599789577e-03,   9.471800297268156e-05,  -1.589787136131893e-06,   1.462017351687903e-08,   3.365805031908730e-10,  -1.795019762438574e-11,
   1.420054597838314e-13,   1.784324439574790e-14,  -8.418679657483213e-16,   2.469772678998776e-01,  -4.914934989163556e-03,   9.471861467213503e-05,  -1.589763511965443e-06,
   1.461829282515778e-08,   3.366010060489140e-10,  -1.794669117695179e-11,   1.417938541348981e-13,   1.784582155292513e-14,  -8.415690700827488e-16,   5.131661793898779e-01,
  -1.019688654191349e-02,   1.951069144952110e-04,  -3.147173319967266e-06,   1.909621690088004e-08,   1.312753252813120e-09,  -6.113618643466235e-11,   8.440536445239352e-13,
   3.897627560723603e-14,  -2.502317995317143e-15,   5.131939758504721e-01,  -1.019822346719464e-02,   1.951224921114504e-04,  -3.145285738410326e-06,   1.896763092764554e-08,
   1.315076821000008e-09,  -6.097552598078392e-11,   8.315675015332174e-13,   3.923906123736724e-14,  -2.490044667130064e-15,   5.132396097266074e-01,  -1.020041765957194e-02,
   1.951479865479213e-04,  -3.142184660180501e-06,   1.875678690281102e-08,   1.318864584609176e-09,  -6.071104750004633e-11,   8.111160664205198e-13,   3.966550080427026e-14,
  -2.469743829274651e-15,   5.132880328136080e-01,  -1.020274506934389e-02,   1.951749311847996e-04,  -3.138891055224279e-06,   1.853340636274848e-08,   1.322847395678286e-09,
  -6.042943332121470e-11,   7.894791326878228e-13,   4.011124958076646e-14,  -2.447998176574557e-15,   5.133261434948885e-01,  -1.020457617505914e-02,   1.951960594024701e-04,
  -3.136296722674663e-06,   1.835785225630704e-08,   1.325955651760823e-09,  -6.020709656468045e-11,   7.724970490047548e-13,   4.045718831919046e-14,  -2.430737402597235e-15,
   5.133481384973585e-01,  -1.020563271018635e-02,   1.952082219253366e-04,  -3.134798585326981e-06,   1.825663593258621e-08,   1.327738984575564e-09,  -6.007850112321641e-11,
   7.627149912050405e-13,   4.065488821299432e-14,  -2.420717514561574e-15,   5.133563979495763e-01,  -1.020602940581131e-02,   1.952127832198370e-04,  -3.134235850715687e-06,
   1.821864699925663e-08,   1.328406660431385e-09,  -6.003015946862802e-11,   7.590452624810563e-13,   4.072875865495811e-14,  -2.416943976125992e-15,   5.133577670778090e-01,
  -1.020609516147731e-02,   1.952135390109415e-04,  -3.134142560487333e-06,   1.821235078215996e-08,   1.328517232673483e-09,  -6.002214336849121e-11,   7.584371389277306e-13,
   4.074098434250330e-14,  -2.416317880804669e-15,   9.444025141500281e-01,  -1.871927695389628e-02,   3.509021585370451e-04,  -4.909758726175802e-06,  -3.251616406382753e-08,
   6.254149278919623e-09,  -2.715631110970096e-10,   5.809803898181833e-12,   5.174943873038450e-14,  -9.444236797296322e-15,   9.444523876479112e-01,  -1.872134107592160e-02,
   3.508711295216093e-04,  -4.900719415234427e-06,  -3.309276409838003e-08,   6.270721822108440e-09,  -2.713094263884331e-10,   5.760493841335402e-12,   5.404740863173049e-14,
  -9.479673997591219e-15,   9.445342593537254e-01,  -1.872472684488617e-02,   3.508198355419982e-04,  -4.885863206972876e-06,  -3.403892983557717e-08,   6.297821241874312e-09,
  -2.708864026305688e-10,   5.679419525065528e-12,   5.780966639149957e-14,  -9.536877296514000e-15,   9.446211264961516e-01,  -1.872831557018788e-02,   3.507649265730406e-04,
  -4.870076963488993e-06,  -3.504231318605799e-08,   6.326430132312637e-09,  -2.704286436255775e-10,   5.593227025707717e-12,   6.178771829065761e-14,  -9.596252937343490e-15,
   9.446894877109049e-01,  -1.873113713543945e-02,   3.507213639971697e-04,  -4.857636749430790e-06,  -3.583156295691817e-08,   6.348839886993404e-09,  -2.700619554105818e-10,
   5.525274161302122e-12,   6.490826450943161e-14,  -9.642025403560650e-15,   9.447289388233342e-01,  -1.873276440068544e-02,   3.506960833543892e-04,  -4.850450717481012e-06,
  -3.628688537575497e-08,   6.361730632046618e-09,  -2.698477595172063e-10,   5.486010078359983e-12,   6.670508079150574e-14,  -9.668058297388707e-15,   9.447437528277458e-01,
  -1.873337524409180e-02,   3.506865637973340e-04,  -4.847751056554015e-06,  -3.645783134891814e-08,   6.366563223779398e-09,  -2.697668410272616e-10,   5.471257172570172e-12,
   6.737902327779019e-14,  -9.677761475742933e-15,   9.447462084462035e-01,  -1.873347648900325e-02,   3.506849844006070e-04,  -4.847303484034818e-06,  -3.648616639210503e-08,
   6.367363872300871e-09,  -2.697534020136212e-10,   5.468811201755505e-12,   6.749069768306791e-14,  -9.679366095675660e-15,   8.711905824692277e-03,  -1.610251573140158e-04,
   2.942941485600203e-06,  -5.100704193747332e-08,   7.213688610614034e-10,  -3.144560595026365e-12,  -2.568828231004448e-13,   9.302659405193153e-15,  -4.814207996108516e-17,
  -8.941123297252814e-18,   8.712325859192087e-03,  -1.610469483049904e-04,   2.943554305919349e-06,  -5.101128925036994e-08,   7.208189771816701e-10,  -3.117517526091980e-12,
  -2.570190954286184e-13,   9.255432507595214e-15,  -4.545708232691603e-17,  -8.994925643248939e-18,   8.713015476355697e-03,  -1.610827230020898e-04,   2.944560009880466e-06,
  -5.101823440352793e-08,   7.199160730117612e-10,  -3.073224866670492e-12,  -2.572351230437301e-13,   9.177709667093230e-15,  -4.105744003034642e-17,  -9.082326438968303e-18,
   8.713747298464841e-03,  -1.611206844270026e-04,   2.945626677687503e-06,  -5.102556643381682e-08,   7.189577826741280e-10,  -3.026367024468803e-12,  -2.574539131079658e-13,
   9.094980327559932e-15,  -3.640032944045557e-17,  -9.173809353753623e-18,   8.714323307837996e-03,  -1.611505614997840e-04,   2.946465816446029e-06,  -5.103130980989180e-08,
   7.182034350170384e-10,  -2.989591261423730e-12,  -2.576185595080859e-13,   9.029685565777275e-15,  -3.274336978964833e-17,  -9.244897733776749e-18,   8.714655758769282e-03,
  -1.611678046353486e-04,   2.946949965771965e-06,  -5.103461362868307e-08,   7.177680205119814e-10,  -2.968408034741369e-12,  -2.577105602109401e-13,   8.991928474312544e-15,
  -3.063617968857951e-17,  -9.285559893688273e-18,   8.714780602059977e-03,  -1.611742796971908e-04,   2.947131743317940e-06,  -5.103585220677205e-08,   7.176045058125086e-10,
  -2.960461238085026e-12,  -2.577445370008953e-13,   8.977736342775926e-15,  -2.984553756278960e-17,  -9.300760088522401e-18,   8.714801296868217e-03,  -1.611753530362751e-04,
   2.947161874211262e-06,  -5.103605741131159e-08,   7.175774002705866e-10,  -2.959144349987865e-12,  -2.577501390597343e-13,   8.975383058353518e-15,  -2.971451054284925e-17,
  -9.303276106525280e-18,   7.961681842234344e-02,  -1.471499900048188e-03,   2.688030723190670e-05,  -4.645555081796359e-07,   6.470580131895608e-09,  -2.174483783170566e-11,
  -2.649873825805537e-12,   9.440826066526455e-14,  -6.057543613255760e-16,  -8.329934693002045e-17,   7.962065473257474e-02,  -1.471698329719975e-03,   2.688579991843251e-05,
  -4.645841369176331e-07,   6.464902183759294e-09,  -2.146978386998939e-11,  -2.651748785196841e-12,   9.396696338683312e-14,  -5.797231060365800e-16,  -8.384969641358672e-17,
   7.962695321667353e-02,  -1.472024092445142e-03,   2.689481354205834e-05,  -4.646308556792403e-07,   6.455578305926446e-09,  -2.101920075550291e-11,  -2.654752287170303e-12,
   9.324053174939842e-14,  -5.370619307425471e-16,  -8.474429116491910e-17,   7.963363715599356e-02,  -1.472369763116080e-03,   2.690437292191237e-05,  -4.646800479753032e-07,
   6.445681470565908e-09,  -2.054240762210379e-11,  -2.657838037553814e-12,   9.246707132402814e-14,  -4.918956532645501e-16,  -8.568143932977865e-17,   7.963889800212087e-02,
  -1.472641815853902e-03,   2.691189274883530e-05,  -4.647184879288158e-07,   6.437890138584235e-09,  -2.016811945560471e-11,  -2.660193363493555e-12,   9.185644196616718e-14,
  -4.564230023878756e-16,  -8.641022970512224e-17,   7.964193436001527e-02,  -1.472798826045010e-03,   2.691623120276874e-05,  -4.647405624296291e-07,   6.433392634449401e-09,
  -1.995249204258942e-11,  -2.661523366716224e-12,   9.150327409786844e-14,  -4.359807003787529e-16,  -8.682732159399521e-17,   7.964307458431054e-02,  -1.472857785543332e-03,
   2.691786007351636e-05,  -4.647488308597945e-07,   6.431703594740702e-09,  -1.987159400195646e-11,  -2.662017261587864e-12,   9.137051263389133e-14,  -4.283100442587596e-16,
  -8.698328086183806e-17,   7.964326359500878e-02,  -1.472867558956272e-03,   2.691813006834399e-05,  -4.647502003754455e-07,   6.431423602668553e-09,  -1.985818780417751e-11,
  -2.662098839850195e-12,   9.134849796858077e-14,  -4.270388209293643e-16,  -8.700909837357107e-17,   2.286424779586951e-01,  -4.225255195379262e-03,   7.709349161241121e-05,
  -1.323168915522545e-06,   1.773616345674390e-08,  -1.335285336994165e-11,  -9.765414233461157e-12,   3.397601042159106e-13,  -3.024331803609798e-15,  -2.475268653649834e-16,
   2.286534791417056e-01,  -4.225820121247852e-03,   7.710851669044577e-05,  -1.323179543821073e-06,   1.771519853052798e-08,  -1.235873185672796e-11,  -9.775694113616079e-12,
   3.384379246141658e-13,  -2.938814843389071e-15,  -2.495682065688111e-16,   2.286715408909273e-01,  -4.226747539845317e-03,   7.713316981344736e-05,  -1.323195978275859e-06,
   1.768076629061725e-08,  -1.072961099345958e-11,  -9.792324990881097e-12,   3.362600082937558e-13,  -2.798611832419585e-15,  -2.528910228438996e-16,   2.286907078772985e-01,
  -4.227731604333595e-03,   7.715931104462438e-05,  -1.323212040560060e-06,   1.764421095145969e-08,  -9.004924812195881e-12,  -9.809638681827155e-12,   3.339391467308952e-13,
  -2.650102671911032e-15,  -2.563781995204540e-16,   2.287057938977216e-01,  -4.228506069340197e-03,   7.717987155710173e-05,  -1.323223686739465e-06,   1.761542733763178e-08,
  -7.650444881487492e-12,  -9.823023820832226e-12,   3.321054766425364e-13,  -2.533413680876283e-15,  -2.590946693671954e-16,   2.287145009367662e-01,  -4.228953028630449e-03,
   7.719173230932857e-05,  -1.323230009590833e-06,   1.759881004454789e-08,  -6.869895508940166e-12,  -9.830652191275891e-12,   3.310443827320114e-13,  -2.466146520583046e-15,
  -2.606511852908644e-16,   2.287177706302071e-01,  -4.229120866357134e-03,   7.719618517156013e-05,  -1.323232308636168e-06,   1.759256901348806e-08,  -6.577008603979417e-12,
  -9.833498498839443e-12,   3.306453950768722e-13,  -2.440901554201215e-15,  -2.612335526770152e-16,   2.287183126346941e-01,  -4.229148687866220e-03,   7.719692324613347e-05,
  -1.323232685767405e-06,   1.759153441684547e-08,  -6.528469868929929e-12,  -9.833969354034905e-12,   3.305792289111343e-13,  -2.436717607984827e-15,  -2.613299765616078e-16,
   4.752705270033112e-01,  -8.780377019379676e-03,   1.598082649910460e-04,  -2.701669517387416e-06,   3.302033531286299e-08,   2.011965814961348e-10,  -3.069891397146560e-11,
   1.055207935412451e-12,  -1.363223337618495e-14,  -5.178419314443026e-16,   4.752933248303736e-01,  -8.781529312371814e-03,   1.598360843475646e-04,  -2.701357003584796e-06,
   3.295422330956517e-08,   2.043043178079513e-10,  -3.074846749821061e-11,   1.052370864434372e-12,  -1.340245238487124e-14,  -5.247642452837398e-16,   4.753307539552820e-01,
  -8.783420885313364e-03,   1.598817133430197e-04,  -2.700840784301420e-06,   3.284561583567407e-08,   2.093999234838837e-10,  -3.082915665787150e-11,   1.047688230870304e-12,
  -1.302536486379612e-14,  -5.360608743800531e-16,   4.753704729558391e-01,  -8.785427850578611e-03,   1.599300735137651e-04,  -2.700288721108758e-06,   3.273027500608213e-08,
   2.147982360969539e-10,  -3.091387601673640e-11,   1.042685589431627e-12,  -1.262543881429204e-14,  -5.479555627607381e-16,   4.754017347719927e-01,  -8.787007241137516e-03,
   1.599680928606445e-04,  -2.699851123383426e-06,   3.263942927174652e-08,   2.190405455883237e-10,  -3.097990056354534e-11,   1.038723972230204e-12,  -1.231084187189677e-14,
  -5.572500365766281e-16,   4.754197776807410e-01,  -8.787918697429014e-03,   1.599900183840681e-04,  -2.699597327022700e-06,   3.258697174734947e-08,   2.214863761723985e-10,
  -3.101774412186440e-11,   1.036427855640732e-12,  -1.212934311753963e-14,  -5.625872655669034e-16,   4.754265531808641e-01,  -8.788260950586033e-03,   1.599982485762521e-04,
  -2.699501787783995e-06,   3.256726802269880e-08,   2.224043384988388e-10,  -3.103190552549405e-11,   1.035563794918327e-12,  -1.206120039891590e-14,  -5.645863775303492e-16,
   4.754276763279885e-01,  -8.788317683536821e-03,   1.599996126869711e-04,  -2.699485938330736e-06,   3.256400156371139e-08,   2.225564790047189e-10,  -3.103425038400922e-11,
   1.035420467199305e-12,  -1.204990540094902e-14,  -5.649174913029449e-16,   8.747641861508774e-01,  -1.614908980937202e-02,   2.919964291982507e-04,  -4.727922585640125e-06,
   4.053103338189456e-08,   1.650396731777536e-09,  -1.196029608973768e-10,   4.336121046033076e-12,  -8.934646405051452e-14,  -2.149207975785417e-16,   8.748058059952247e-01,
  -1.615109955912166e-02,   2.920295649885271e-04,  -4.725464869629020e-06,   4.027168932710543e-08,   1.663320421545957e-09,  -1.199446696046818e-10,   4.334074752746491e-12,
  -8.866115938679746e-14,  -2.501421194687067e-16,   8.748741348781011e-01,  -1.615439810475281e-02,   2.920838014263288e-04,  -4.721416853461107e-06,   3.984541453585317e-08,
   1.684531715077156e-09,  -1.205036426074503e-10,   4.330585136980665e-12,  -8.753202491554086e-14,  -3.079475951066803e-16,   8.749466414066059e-01,  -1.615789704906234e-02,
   2.921411310515461e-04,  -4.717103553220441e-06,   3.939239962627932e-08,   1.707031539709549e-09,  -1.210940354754485e-10,   4.326705344039427e-12,  -8.632838308119631e-14,
  -3.692602269063051e-16,   8.750037075335976e-01,  -1.616064996192746e-02,   2.921860907607277e-04,  -4.713695902707662e-06,   3.903536584295274e-08,   1.724733832455308e-09,
  -1.215567028970136e-10,   4.323523776898534e-12,  -8.537711622488137e-14,  -4.174953062817188e-16,   8.750366427548307e-01,  -1.616223841065778e-02,   2.922119741054926e-04,
  -4.711724046482522e-06,   3.882911120825455e-08,   1.734948052432876e-09,  -1.218229240430743e-10,   4.321636274776081e-12,  -8.482652657037598e-14,  -4.453249539380661e-16,
   8.750490104926466e-01,  -1.616283483007815e-02,   2.922216814979541e-04,  -4.710982605591568e-06,   3.875162213929929e-08,   1.738783188276025e-09,  -1.219227425989148e-10,
   4.320917793230791e-12,  -8.461947395837883e-14,  -4.557737454019908e-16,   8.750510606345950e-01,  -1.616293369202658e-02,   2.922232900008094e-04,  -4.710859648965112e-06,
   3.873877519233670e-08,   1.739418895438481e-09,  -1.219392810284408e-10,   4.320798182644066e-12,  -8.458513617791542e-14,  -4.575057008182922e-16,   8.111284195660365e-03,
  -1.397402902664722e-04,   2.397176111586939e-06,  -4.022060594274897e-08,   6.161354199507519e-10,  -6.555140644336096e-12,  -4.694062551495734e-14,   5.205581154549203e-15,
  -1.487269287923323e-16,   1.121286353575774e-18,   8.111626388130821e-03,  -1.397574937933786e-04,   2.397701585203040e-06,  -4.022980237408098e-08,   6.160283646138530e-10,
  -6.539511981835182e-12,  -4.751942755272204e-14,   5.210226979611905e-15,  -1.480660570340982e-16,   1.080372323340533e-18,   8.112188206417761e-03,  -1.397857389746777e-04,
   2.398564166974969e-06,  -4.024488370096313e-08,   6.158517303591432e-10,  -6.513845682936935e-12,  -4.846769177127614e-14,   5.217702329087236e-15,  -1.469759469957581e-16,
   1.013201353702060e-18,   8.112784412384753e-03,  -1.398157131082786e-04,   2.399479339902782e-06,  -4.026086426350506e-08,   6.156631058229233e-10,  -6.486599269078501e-12,
  -4.947123816639405e-14,   5.225428317485277e-15,  -1.458122373902714e-16,   9.419240300911738e-19,   8.113253682713257e-03,  -1.398393056676998e-04,   2.400199518239569e-06,
  -4.027342519679762e-08,   6.155137883879836e-10,  -6.465147298426181e-12,  -5.025912011218149e-14,   5.231359608989697e-15,  -1.448913292911828e-16,   8.858270008063965e-19,
   8.113524529080084e-03,  -1.398529225002301e-04,   2.400615120079854e-06,  -4.028066800095450e-08,   6.154272664950003e-10,  -6.452763425687448e-12,  -5.071305273828500e-14,
   5.234722906541297e-15,  -1.443578322241214e-16,   8.534521749357562e-19,   8.113626238606866e-03,  -1.398580359650508e-04,   2.400771177560848e-06,  -4.028338654442746e-08,
   6.153947109618874e-10,  -6.448112498358477e-12,  -5.088336327064463e-14,   5.235974561795671e-15,  -1.441571171564707e-16,   8.412951316568835e-19,   8.113643098628992e-03,
  -1.398588836060510e-04,   2.400797046050570e-06,  -4.028383711853217e-08,   6.153893109514637e-10,  -6.447341505899936e-12,  -5.091158698771043e-14,   5.236181445636859e-15,
  -1.441238256475801e-16,   8.392799303229298e-19,   7.412801550718856e-02,  -1.277047401444070e-03,   2.190357557106384e-05,  -3.671271530207635e-07,   5.594343405101218e-09,
  -5.761593027288293e-11,  -5.419386417729649e-13,   5.193626890059154e-14,  -1.485684433870936e-15,   1.253946548868334e-17,   7.413114213852666e-02,  -1.277204420865638e-03,
   2.190834529077235e-05,  -3.672078264929635e-07,   5.593117959406291e-09,  -5.745988438056660e-11,  -5.477307810873737e-13,   5.198996318550462e-14,  -1.479578155814849e-15,
   1.214680580118980e-17,   7.413627549950080e-02,  -1.277462218250363e-03,   2.191617477984464e-05,  -3.673401042167300e-07,   5.591097324112105e-09,  -5.720360067917274e-11,
  -5.572216344214937e-13,   5.207665602176070e-14,  -1.469502283079114e-15,   1.150204520687479e-17,   7.414172305764760e-02,  -1.277735794596761e-03,   2.192448141288202e-05,
  -3.674802424560809e-07,   5.588941237051453e-09,  -5.693151729457104e-11,  -5.672677812507915e-13,   5.216666609525998e-14,  -1.458741332584542e-15,   1.081772179253089e-17,
   7.414601079627613e-02,  -1.277951124777835e-03,   2.193101800693793e-05,  -3.675903736337060e-07,   5.587235682273825e-09,  -5.671728147688380e-11,  -5.751564351115295e-13,
   5.223607240316031e-14,  -1.450222142223218e-15,   1.027903607957926e-17,   7.414848552717725e-02,  -1.278075405713041e-03,   2.193479009384766e-05,  -3.676538689993118e-07,
   5.586247888678772e-09,  -5.659360024903538e-11,  -5.797020091181394e-13,   5.227555403693886e-14,  -1.445285460552250e-15,   9.968106232763116e-18,   7.414941484973457e-02,
  -1.278122076268276e-03,   2.193620649143183e-05,  -3.676777001383629e-07,   5.585876304214057e-09,  -5.654714891822208e-11,  -5.814075686850426e-13,   5.229027126585476e-14,
  -1.443427897215256e-15,   9.851341200862305e-18,   7.414956890017584e-02,  -1.278129812677264e-03,   2.193644127651389e-05,  -3.676816498575659e-07,   5.585814674061650e-09,
  -5.653944853506447e-11,  -5.816902183875876e-13,   5.229270513231066e-14,  -1.443119779720283e-15,   9.831985326959872e-18,   2.128810902312691e-01,  -3.667283171420997e-03,
   6.287627293985964e-05,  -1.051296852945287e-06,   1.581610964197782e-08,  -1.496207634867049e-10,  -2.346456551658411e-12,   1.801523280915403e-13,  -5.187818126695766e-15,
   5.368225340155591e-17,   2.128900650833037e-01,  -3.667732728349520e-03,   6.288974756962220e-05,  -1.051505193428888e-06,   1.581086026970964e-08,  -1.490785995068383e-10,
  -2.366756827855712e-12,   1.803935822854205e-13,  -5.170102404770149e-15,   5.242599500297259e-17,   2.129048001369592e-01,  -3.668470812039225e-03,   6.291186503992799e-05,
  -1.051846658866460e-06,   1.580221145467405e-08,  -1.481880504750681e-10,  -2.400030975634677e-12,   1.807849783418724e-13,  -5.140841242560315e-15,   5.036229966261930e-17,
   2.129204370452325e-01,  -3.669254061728773e-03,   6.293532886932494e-05,  -1.052208219837948e-06,   1.579299214223786e-08,  -1.472424363196357e-10,  -2.435266410622108e-12,
   1.811939415913511e-13,  -5.109551711806462e-15,   4.817078507931136e-17,   2.129327447334361e-01,  -3.669870545433969e-03,   6.295379174844314e-05,  -1.052492219569847e-06,
   1.578570593908173e-08,  -1.464977502317620e-10,  -2.462945252729284e-12,   1.815112068504117e-13,  -5.084752585821810e-15,   4.644480784384189e-17,   2.129398482857631e-01,
  -3.670226355096959e-03,   6.296444572036197e-05,  -1.052655900570536e-06,   1.578148869210696e-08,  -1.460677852393740e-10,  -2.478898485788646e-12,   1.816924659289775e-13,
  -5.070370907921404e-15,   4.544822754696047e-17,   2.129425158432650e-01,  -3.670359969859760e-03,   6.296844614357733e-05,  -1.052717322672580e-06,   1.577990276246372e-08,
  -1.459062929729116e-10,  -2.484885149523341e-12,   1.817601824923495e-13,  -5.064957306850550e-15,   4.507391165342018e-17,   2.129429580345355e-01,  -3.670382118666901e-03,
   6.296910925783314e-05,  -1.052727502062934e-06,   1.577963975001832e-08,  -1.458795214159931e-10,  -2.485877316988895e-12,   1.817713891204853e-13,  -5.064059232393861e-15,
   4.501185872309029e-17,   4.425134355932316e-01,  -7.622518007553655e-03,   1.305862990785767e-04,  -2.172164162582716e-06,   3.177172302113502e-08,  -2.395586958502055e-10,
  -8.530351644285702e-12,   5.226847080480522e-13,  -1.542264335985031e-14,   2.110590092218460e-16,   4.425320733182017e-01,  -7.623446506927986e-03,   1.306133195665309e-04,
  -2.172491736958318e-06,   3.175279368538311e-08,  -2.379809286002209e-10,  -8.591083230458129e-12,   5.236809567346940e-13,  -1.538837094070848e-14,   2.079007120392443e-16,
   4.425626729227554e-01,  -7.624970886912321e-03,   1.306576661611233e-04,  -2.173027874012583e-06,   3.172162480664003e-08,  -2.353886719009909e-10,  -8.690682239962298e-12,
   5.253046997860081e-13,  -1.533158160884513e-14,   2.027071090621821e-16,   4.425951452223005e-01,  -7.626588504800614e-03,   1.307047051082343e-04,  -2.173594541352780e-06,
   3.168842548826726e-08,  -2.326352519841656e-10,  -8.796225415789550e-12,   5.270116160458141e-13,  -1.527061057591525e-14,   1.971845360920146e-16,   4.426207038102483e-01,
  -7.627861674591783e-03,   1.307417132403985e-04,  -2.174038906530199e-06,   3.166220576438206e-08,  -2.304662542748515e-10,  -8.879187109164596e-12,   5.283433698047680e-13,
  -1.522211063999286e-14,   1.928298299792467e-16,   4.426354552602937e-01,  -7.628596484189390e-03,   1.307630666324609e-04,  -2.174294714703979e-06,   3.164703711974118e-08,
  -2.292136684671735e-10,  -8.927025088854892e-12,   5.291072973815754e-13,  -1.519391408600175e-14,   1.903133053756038e-16,   4.426409947823135e-01,  -7.628872419752469e-03,
   1.307710841495345e-04,  -2.174390651523324e-06,   3.164133420336808e-08,  -2.287431564638361e-10,  -8.944980982131427e-12,   5.293932796929565e-13,  -1.518328704525972e-14,
   1.893676983288040e-16,   4.426419130482382e-01,  -7.628918160404113e-03,   1.307724131205653e-04,  -2.174406548003606e-06,   3.164038849732769e-08,  -2.286651542731482e-10,
  -8.947957019319563e-12,   5.294406389132515e-13,  -1.518152340703670e-14,   1.892109174440861e-16,   8.144982647579674e-01,  -1.402735721444269e-02,   2.398354259771965e-04,
  -3.935739093083206e-06,   5.304445926077042e-08,  -7.330076409188791e-11,  -3.560805966517503e-11,   1.835207386661862e-12,  -5.910507693926380e-14,   1.209359630780024e-15,
   8.145324852716858e-01,  -1.402903766049863e-02,   2.398802697465582e-04,  -3.935796207421206e-06,   5.296564896154496e-08,  -6.772084991129789e-11,  -3.584383017424699e-11,
   1.841207365761433e-12,  -5.911942057183151e-14,   1.202141196679946e-15,   8.145886683245505e-01,  -1.403179639125434e-02,   2.399538385249126e-04,  -3.935884190932502e-06,
   5.283590522005916e-08,  -5.854768644215015e-11,  -3.623091601419580e-11,   1.851030030613155e-12,  -5.914106594959371e-14,   1.190218993822025e-15,   8.146482890552462e-01,
  -1.403472362577955e-02,   2.400318332505612e-04,  -3.935969686998715e-06,   5.269774251836862e-08,  -4.879684494886684e-11,  -3.664168229379485e-11,   1.861415426487100e-12,
  -5.916144532514144e-14,   1.177470924123372e-15,   8.146952153480994e-01,  -1.403702737973163e-02,   2.400931665883087e-04,  -3.936031275454512e-06,   5.258864965391535e-08,
  -4.111030477289553e-11,  -3.696498286104364e-11,   1.869561731555442e-12,  -5.917560781507890e-14,   1.167367497811760e-15,   8.147222992181559e-01,  -1.403835692293334e-02,
   2.401285436148916e-04,  -3.936064533702775e-06,   5.252554648327741e-08,  -3.666921929058724e-11,  -3.715157531861303e-11,   1.874252240453301e-12,  -5.918302842171824e-14,
   1.161508335609450e-15,   8.147324698186994e-01,  -1.403885617992618e-02,   2.401418243238193e-04,  -3.936076590272623e-06,   5.250182348317346e-08,  -3.500059728666319e-11,
  -3.722164432132062e-11,   1.876011511696679e-12,  -5.918567254624881e-14,   1.159302821318761e-15,   8.147341557591489e-01,  -1.403893893893406e-02,   2.401440255952749e-04,
  -3.936078566014042e-06,   5.249788962499315e-08,  -3.472394920045376e-11,  -3.723325934779507e-11,   1.876303027225040e-12,  -5.918610333395028e-14,   1.158936944114374e-15,
   7.587844300729552e-03,  -1.223360341288399e-04,   1.969266713057790e-06,  -3.143192657487746e-08,   4.830189502858308e-10,  -6.415636654252790e-12,   4.148883003933949e-14,
   1.492732006461730e-15,  -7.876554976148590e-17,   2.011835792305213e-18,   7.588125372190320e-03,  -1.223494852198948e-04,   1.969679614522091e-06,  -3.144101732380985e-08,
   4.831037536448267e-10,  -6.411014331122160e-12,   4.117264896455479e-14,   1.502853391651734e-15,  -7.888003272535634e-17,   2.005016425403791e-18,   7.588586839041922e-03,
  -1.223715701593671e-04,   1.970357510259116e-06,  -3.145593643846861e-08,   4.832424830491024e-10,  -6.403404299787890e-12,   4.065326971397809e-14,   1.519443357739965e-15,
  -7.906573314946186e-17,   1.993731899928566e-18,   7.589076548884703e-03,  -1.223950077870934e-04,   1.971076879395620e-06,  -3.147176020791591e-08,   4.833890207697434e-10,
  -6.395299953307142e-12,   4.010174112583961e-14,   1.537011177365961e-15,  -7.925972484640824e-17,   1.981636750516667e-18,   7.589461994990083e-03,  -1.224134560739834e-04,
   1.971643076779489e-06,  -3.148420883532368e-08,   4.835038651169737e-10,  -6.388900444938552e-12,   3.966737882254189e-14,   1.550811358859912e-15,  -7.941018542996720e-17,
   1.972030028385731e-18,   7.589684460265352e-03,  -1.224241040435019e-04,   1.971969860398372e-06,  -3.149139126950699e-08,   4.835699509161921e-10,  -6.385198615481842e-12,
   3.941657794266561e-14,   1.558765330812826e-15,  -7.949613154262569e-17,   1.966450655363035e-18,   7.589768001362096e-03,  -1.224281026702799e-04,   1.972092574678860e-06,
  -3.149408798317830e-08,   4.835947302814955e-10,  -6.383806927012672e-12,   3.932237678760813e-14,   1.561750158379653e-15,  -7.952823727312918e-17,   1.964348907073033e-18,
   7.589781849662099e-03,  -1.224287655108942e-04,   1.972112916526753e-06,  -3.149453498297449e-08,   4.835988358897520e-10,  -6.383576149569810e-12,   3.930676039076590e-14,
   1.562244832316678e-15,  -7.953355039773263e-17,   1.964000162128089e-18,   6.934441098268694e-02,  -1.118009320240874e-03,   1.799592447744400e-05,  -2.871380835583068e-07,
   4.404362166579911e-09,  -5.796911002562358e-11,   3.436137588435996e-13,   1.519015938738866e-14,  -7.743560650291945e-16,   1.988537195025873e-17,   6.934697950543964e-02,
  -1.118132195774514e-03,   1.799968904366640e-05,  -2.872201796438959e-07,   4.405058664730619e-09,  -5.792211726503653e-11,   3.405033248799051e-13,   1.529035286362700e-14,
  -7.755777127787324e-16,   1.982360762670487e-17,   6.935119653919289e-02,  -1.118333941093898e-03,   1.800586960662567e-05,  -2.873549046596790e-07,   4.406197267209743e-09,
  -5.784475573545552e-11,   3.353936480086857e-13,   1.545460139795940e-14,  -7.775619477372400e-16,   1.972134086869225e-17,   6.935567166524698e-02,  -1.118548042772328e-03,
   1.801242822843010e-05,  -2.874977916047594e-07,   4.407398869778985e-09,  -5.776237683545766e-11,   3.299673041219159e-13,   1.562856026655543e-14,  -7.796383888519986e-16,
   1.961164594769552e-17,   6.935919399478083e-02,  -1.118716566747546e-03,   1.801759030737011e-05,  -2.876101959870404e-07,   4.408339798057646e-09,  -5.769733277125464e-11,
   3.256934522035065e-13,   1.576523263453724e-14,  -7.812515410659811e-16,   1.952446068276476e-17,   6.936122695308804e-02,  -1.118813835179661e-03,   1.802056960763942e-05,
  -2.876750473239458e-07,   4.408880925720296e-09,  -5.765970988941905e-11,   3.232256183488162e-13,   1.584401460561045e-14,  -7.821740874341678e-16,   1.947380205528295e-17,
   6.936199037807789e-02,  -1.118850362323664e-03,   1.802168839538286e-05,  -2.876993959696143e-07,   4.409083765249281e-09,  -5.764556612650283e-11,   3.222986755724559e-13,
   1.587358013649282e-14,  -7.825189171817792e-16,   1.945471457754443e-17,   6.936211692822365e-02,  -1.118856417319823e-03,   1.802187385209253e-05,  -2.877034319121274e-07,
   4.409117369848425e-09,  -5.764322075166882e-11,   3.221450085541870e-13,   1.587848010171790e-14,  -7.825759934441030e-16,   1.945154714480668e-17,   1.991438367172719e-01,
  -3.210673319537605e-03,   5.167432924927055e-05,  -8.238331497838678e-07,   1.258140988047568e-08,  -1.619505796954965e-10,   7.419029833268349e-13,   5.440713663550791e-14,
  -2.609325823774610e-15,   6.795763371131194e-17,   1.991512119735356e-01,  -3.211025840967938e-03,   5.168508001447618e-05,  -8.240621933107027e-07,   1.258286872885981e-08,
  -1.617825061980014e-10,   7.314065579837497e-13,   5.475067148368710e-14,  -2.614173788227891e-15,   6.778843143228628e-17,   1.991633207577570e-01,  -3.211604632305856e-03,
   5.170272999654458e-05,  -8.244380301856823e-07,   1.258524741803135e-08,  -1.615058473728571e-10,   7.141613959641089e-13,   5.531399128787936e-14,  -2.622066103745662e-15,
   6.750778037498799e-17,   1.991761706188922e-01,  -3.212218870243460e-03,   5.172145915646777e-05,  -8.248365837087173e-07,   1.258774929935599e-08,  -1.612112874265885e-10,
   6.958445938909349e-13,   5.591083027190077e-14,  -2.630350060540037e-15,   6.720607904775802e-17,   1.991862846169923e-01,  -3.212702347917961e-03,   5.173619994278007e-05,
  -8.251500744555570e-07,   1.258970228925795e-08,  -1.609787412217479e-10,   6.814159698095909e-13,   5.637989898574289e-14,  -2.636804006387733e-15,   6.696581059622044e-17,
   1.991921220399534e-01,  -3.212981400065045e-03,   5.174470747370746e-05,  -8.253309266532411e-07,   1.259082297989254e-08,  -1.608442434558746e-10,   6.730836630032220e-13,
   5.665034697311904e-14,  -2.640502381156684e-15,   6.682601413971355e-17,   1.991943141328993e-01,  -3.213086192160912e-03,   5.174790219929811e-05,  -8.253988253137102e-07,
   1.259124259695223e-08,  -1.607936832668589e-10,   6.699538069276240e-13,   5.675185341953089e-14,  -2.641886177573377e-15,   6.677330515115828e-17,   1.991946775080386e-01,
  -3.213103563227172e-03,   5.174843177411956e-05,  -8.254100797951617e-07,   1.259131209046461e-08,  -1.607852992940634e-10,   6.694349362294251e-13,   5.676867695223238e-14,
  -2.642115298801711e-15,   6.676455659302948e-17,   4.139593147670308e-01,  -6.673865019153562e-03,   1.073876658087777e-04,  -1.709199758725762e-06,   2.586282976385328e-08,
  -3.167762128639797e-10,   4.470539013774020e-13,   1.624607121122567e-13,  -7.245582092853677e-15,   1.950648564222485e-16,   4.139746412352319e-01,  -6.674596290956655e-03,
   1.074097518946804e-04,  -1.709646307234245e-06,   2.586343632224590e-08,  -3.162748696481775e-10,   4.178239696114613e-13,   1.634526955006466e-13,  -7.263038357060784e-15,
   1.947985940696457e-16,   4.139998043861353e-01,  -6.675796928796498e-03,   1.074460100436430e-04,  -1.710378866643052e-06,   2.586438679884986e-08,  -3.154496958541219e-10,
   3.697889320912184e-13,   1.650801525273530e-13,  -7.291538794994509e-15,   1.943537543266211e-16,   4.140265075232339e-01,  -6.677071084212044e-03,   1.074844830862412e-04,
  -1.711155457824391e-06,   2.586533373751892e-08,  -3.145712185507828e-10,   3.187531910348607e-13,   1.668055752699422e-13,  -7.321566278228361e-15,   1.938712425613003e-16,
   4.140475252691292e-01,  -6.678073985726786e-03,   1.075147618100744e-04,  -1.711766123456620e-06,   2.586603435764819e-08,  -3.138777506376188e-10,   2.785395872199811e-13,
   1.681624407440488e-13,  -7.345042945883250e-15,   1.934838987104615e-16,   4.140596559178502e-01,  -6.678652833696090e-03,   1.075322363447499e-04,  -1.712118343501091e-06,
   2.586642080045435e-08,  -3.134766946313684e-10,   2.553122709818583e-13,   1.689450888667518e-13,  -7.358529476939266e-15,   1.932573065742457e-16,   4.140642112665334e-01,
  -6.678870207048332e-03,   1.075387982230234e-04,  -1.712250566461712e-06,   2.586656252925313e-08,  -3.133259349849723e-10,   2.465865503132095e-13,   1.692389001160989e-13,
  -7.363582009817828e-15,   1.931716427749525e-16,   4.140649663897218e-01,  -6.678906240330071e-03,   1.075398859491439e-04,  -1.712272482242825e-06,   2.586658584426153e-08,
  -3.133009360219140e-10,   2.451399457749665e-13,   1.692875992564037e-13,  -7.364418916909668e-15,   1.931574123766559e-16,   7.619470179043546e-01,  -1.228350143368460e-02,
   1.975395983413994e-04,  -3.131070376919553e-06,   4.625217973825185e-08,  -4.872620346077109e-10,  -4.683821674493767e-12,   5.608695847627703e-13,  -2.371731248323792e-14,
   6.997146973680452e-16,   7.619752085283681e-01,  -1.228484055151254e-02,   1.975790267654583e-04,  -3.131749095514420e-06,   4.624103434500741e-08,  -4.855282620588705e-10,
  -4.780178492811627e-12,   5.644740758937493e-13,  -2.380685534406051e-14,   7.004729142461082e-16,   7.620214920463856e-01,  -1.228703913617712e-02,   1.976437476617878e-04,
  -3.132861514606137e-06,   4.622258772853946e-08,  -4.826741955554142e-10,  -4.938620103072028e-12,   5.703940766852310e-13,  -2.395357821414860e-14,   7.016961603302271e-16,
   7.620706079351728e-01,  -1.228937228413392e-02,   1.977124116403150e-04,  -3.134039416512754e-06,   4.620281083937421e-08,  -4.796352088524917e-10,  -5.107086785195816e-12,
   5.766792061664234e-13,  -2.410888483847282e-14,   7.029648429603782e-16,   7.621092663788581e-01,  -1.229120868610521e-02,   1.977664433480799e-04,  -3.134964646398273e-06,
   4.618709873924262e-08,  -4.772358321662750e-10,  -5.239922479607724e-12,   5.816281725476696e-13,  -2.423083673804774e-14,   7.039420515414000e-16,   7.621315785183654e-01,
  -1.229226859059122e-02,   1.977976232021650e-04,  -3.135497897956430e-06,   4.617797176398360e-08,  -4.758480263972331e-10,  -5.316685266415550e-12,   5.844853231352908e-13,
  -2.430110665263687e-14,   7.044974811802515e-16,   7.621399572502129e-01,  -1.229266661056525e-02,   1.978093309975217e-04,  -3.135698003619040e-06,   4.617453329510732e-08,
  -4.753263095587873e-10,  -5.345529477607580e-12,   5.855584002457620e-13,  -2.432747267118223e-14,   7.047044349016128e-16,   7.621413461608578e-01,  -1.229273258888001e-02,
   1.978112717031365e-04,  -3.135731166840054e-06,   4.617396272871893e-08,  -4.752397968212427e-10,  -5.350311821609402e-12,   5.857362880556834e-13,  -2.433184210485940e-14,
   7.047386551593871e-16,   7.127792734826979e-03,  -1.079685994964065e-04,   1.634422576714459e-06,  -2.466614455718791e-08,   3.668369710236256e-10,  -5.142928623289250e-12,
   5.753419022901098e-14,  -6.188239477200257e-17,  -2.467338827788074e-17,   9.828118527233964e-19,   7.128025956442686e-03,  -1.079791558766000e-04,   1.634736486665976e-06,
  -2.467346412137112e-08,   3.669585751565105e-10,  -5.143032095381963e-12,   5.743279071984525e-14,  -5.679176052470547e-17,  -2.482231983935303e-17,   9.849081050138751e-19,
   7.128408859879690e-03,  -1.079964881424403e-04,   1.635251895331103e-06,  -2.468548044337133e-08,   3.671580499406363e-10,  -5.143190930060339e-12,   5.726589947259471e-14,
  -4.842709235077702e-17,  -2.506657447441518e-17,   9.883237606982465e-19,   7.128815194074138e-03,  -1.080148820867389e-04,   1.635798885199313e-06,  -2.469823078245518e-08,
   3.673694928975754e-10,  -5.143344464310688e-12,   5.708823428273083e-14,  -3.954129973006746e-17,  -2.532541762021604e-17,   9.919130433014846e-19,   7.129135013120388e-03,
  -1.080293604408303e-04,   1.636229442503017e-06,  -2.470826542854808e-08,   3.675357435167801e-10,  -5.143454428055727e-12,   5.694799072549434e-14,  -3.254076653231011e-17,
  -2.552888742595913e-17,   9.947124230404960e-19,   7.129319599734110e-03,  -1.080377170732943e-04,   1.636477954951940e-06,  -2.471405664235984e-08,   3.676316273344162e-10,
  -5.143513531371007e-12,   5.686688512351670e-14,  -2.849768224257901e-17,  -2.564621643875838e-17,   9.963177936670397e-19,   7.129388916260325e-03,  -1.080408552403290e-04,
   1.636571279404764e-06,  -2.471623130495048e-08,   3.676676208058160e-10,  -5.143534901103804e-12,   5.683639736467774e-14,  -2.697890988335263e-17,  -2.569025615353901e-17,
   9.969186945232570e-19,   7.129400406594250e-03,  -1.080413754453204e-04,   1.636586749561765e-06,  -2.471659178662028e-08,   3.676735866131968e-10,  -5.143538399958737e-12,
   5.683134190502494e-14,  -2.672712243898485e-17,  -2.569755538872343e-17,   9.970182004654411e-19,   6.514006543502972e-02,  -9.867112271052319e-04,   1.493656906783973e-05,
  -2.253932313081429e-07,   3.349987103744848e-09,  -4.682556590447446e-11,   5.158398085904037e-13,  -9.728166254849637e-17,  -2.438427801103667e-16,   9.578708323176772e-18,
   6.514219678315829e-02,  -9.868076878437452e-04,   1.493943559950479e-05,  -2.254598625468923e-07,   3.351076275512845e-09,  -4.682506217074433e-11,   5.148378879485996e-13,
  -4.763823277968200e-17,  -2.453050812969901e-16,   9.600208430705907e-18,   6.514569603198961e-02,  -9.869660643212024e-04,   1.494414214365294e-05,  -2.255692476624718e-07,
   3.352862765351637e-09,  -4.682412761305067e-11,   5.131888736839586e-13,   3.393728154299486e-17,  -2.477035848335695e-16,   9.635263090607076e-18,   6.514940940770947e-02,
  -9.871341419530010e-04,   1.494913705878565e-05,  -2.256853125132688e-07,   3.354756242853115e-09,  -4.682298965007142e-11,   5.114334381849340e-13,   1.206004359643719e-16,
  -2.502457001228406e-16,   9.672130045115194e-18,   6.515233214519484e-02,  -9.872664401680319e-04,   1.495306874026744e-05,  -2.257766552361254e-07,   3.356244877313069e-09,
  -4.682198805250723e-11,   5.100477741227193e-13,   1.888805933893046e-16,  -2.522442496733650e-16,   9.700905822989829e-18,   6.515401903092014e-02,  -9.873428001663407e-04,
   1.495533805376269e-05,  -2.258293705212356e-07,   3.357103378227541e-09,  -4.682136749161252e-11,   5.092464268427153e-13,   2.283166632777660e-16,  -2.533967993642050e-16,
   9.717416975385327e-18,   6.515465249535619e-02,  -9.873714756381575e-04,   1.495619025328283e-05,  -2.258491655600771e-07,   3.357425636724231e-09,  -4.682112642544359e-11,
   5.089452005572352e-13,   2.431310030430757e-16,  -2.538294312848554e-16,   9.723598922191813e-18,   6.515475750231817e-02,  -9.873762290889452e-04,   1.495633152017493e-05,
  -2.258524468671090e-07,   3.357479049500810e-09,  -4.682108604109445e-11,   5.088952515101443e-13,   2.455869924131317e-16,  -2.539011376540448e-16,   9.724622709946006e-18,
   1.870698384416735e-01,  -2.833638437547501e-03,   4.289345805771009e-05,  -6.471005413295585e-07,   9.603767045369391e-09,  -1.332907259146969e-10,   1.413618985031502e-12,
   2.933681650706447e-15,  -8.275322453293410e-16,   3.170463801297428e-17,   1.870759590202420e-01,  -2.833915368791095e-03,   4.290167502397280e-05,  -6.472901251522261e-07,
   9.606744041503111e-09,  -1.332793251833828e-10,   1.410219438880155e-12,   3.098217807841491e-15,  -8.324599865947152e-16,   3.178396834509512e-17,   1.870860077887024e-01,
  -2.834370054736187e-03,   4.291516632861290e-05,  -6.476013448626864e-07,   9.611625963206125e-09,  -1.332602522775845e-10,   1.404624371127900e-12,   3.368618766226597e-15,
  -8.405445524221503e-16,   3.191347081679189e-17,   1.870966714615856e-01,  -2.834852591158205e-03,   4.292948412369133e-05,  -6.479315554087381e-07,   9.616798845332234e-09,
  -1.332395292439921e-10,   1.398668332023540e-12,   3.655925308451300e-15,  -8.491158562881763e-16,   3.204988631729871e-17,   1.871050646630014e-01,  -2.835232407411379e-03,
   4.294075409648390e-05,  -6.481914199273526e-07,   9.620864698112608e-09,  -1.332228685395565e-10,   1.393966974434027e-12,   3.882318421065876e-15,  -8.558563471494743e-16,
   3.215652209696052e-17,   1.871099088783285e-01,  -2.835451629867881e-03,   4.294725893634649e-05,  -6.483413875927089e-07,   9.623209080658739e-09,  -1.332131123082746e-10,
   1.391248150000814e-12,   4.013086704542538e-15,  -8.597443208823434e-16,   3.221777272949182e-17,   1.871117279926129e-01,  -2.835533954440575e-03,   4.294970170408724e-05,
  -6.483977009475863e-07,   9.624089022213050e-09,  -1.332094220831456e-10,   1.390226150157751e-12,   4.062212692005191e-15,  -8.612038949186950e-16,   3.224071786460611e-17,
   1.871120295401812e-01,  -2.835547601146900e-03,   4.295010663496234e-05,  -6.484070356395855e-07,   9.624234864147120e-09,  -1.332088089686508e-10,   1.390056683446054e-12,
   4.070357144690322e-15,  -8.614458191043963e-16,   3.224451844088703e-17,   3.888614668330329e-01,  -5.890242275573720e-03,   8.915617276096489e-05,  -1.344345398433140e-06,
   1.989220943853222e-08,  -2.719884068805026e-10,   2.643219904821056e-12,   2.034013650109637e-14,  -2.296716337950826e-15,   8.547730990192464e-17,   3.888741886308503e-01,
  -5.890817571529211e-03,   8.917318887972785e-05,  -1.344731878035839e-06,   1.989773915937988e-08,  -2.719204994139208e-10,   2.633781982184894e-12,   2.078493784087134e-14,
  -2.310522299291094e-15,   8.573567045765099e-17,   3.888950752767422e-01,  -5.891762132093076e-03,   8.920112697005150e-05,  -1.345366274047392e-06,   1.990680237738578e-08,
  -2.718080530801889e-10,   2.618248366485620e-12,   2.151609573806141e-14,  -2.333182988905529e-15,   8.615820073244414e-17,   3.889172400089768e-01,  -5.892764545776140e-03,
   8.923077602851351e-05,  -1.346039317753798e-06,   1.991639912131138e-08,  -2.716874258749792e-10,   2.601711998946293e-12,   2.229319113721745e-14,  -2.357222033482002e-15,
   8.660434081224500e-17,   3.889346854978924e-01,  -5.893553567838751e-03,   8.925411330930548e-05,  -1.346568934221540e-06,   1.992393727984905e-08,  -2.715915401420223e-10,
   2.588658698430789e-12,   2.290569370760232e-14,  -2.376136588245014e-15,   8.695385786437736e-17,   3.889447543234723e-01,  -5.894008974886937e-03,   8.926758303830424e-05,
  -1.346874557051686e-06,   1.992828186574606e-08,  -2.715358209199059e-10,   2.581109715205367e-12,   2.325955060548524e-14,  -2.387050766901442e-15,   8.715492841372619e-17,
   3.889485353985516e-01,  -5.894179993642698e-03,   8.927264130631782e-05,  -1.346989315929434e-06,   1.992991219745528e-08,  -2.715148256203038e-10,   2.578272035706507e-12,
   2.339249716142083e-14,  -2.391148806112820e-15,   8.723031068845461e-17,   3.889491621727759e-01,  -5.894208342917874e-03,   8.927347979987276e-05,  -1.347008338563695e-06,
   1.993018239003256e-08,  -2.715113415403484e-10,   2.577801493499176e-12,   2.341453863431313e-14,  -2.391828096487923e-15,   8.724279995203296e-17,   7.157524447187249e-01,
  -1.084165458566140e-02,   1.640770376451065e-04,  -2.471046823504639e-06,   3.629704000746105e-08,  -4.773426701845029e-10,   3.468678159469771e-12,   1.074578047558479e-13,
  -7.203811823477146e-15,   2.651273159571416e-16,   7.157758564911915e-01,  -1.084271191897920e-02,   1.641080694241198e-04,  -2.471723197469340e-06,   3.630409025518897e-08,
  -4.769992791965075e-10,   3.438993789336987e-12,   1.088467802468487e-13,  -7.250977640083977e-15,   2.662730278982932e-16,   7.158142939039841e-01,  -1.084444791080780e-02,
   1.641590173507353e-04,  -2.472833212315374e-06,   3.631561805629910e-08,  -4.764325271281918e-10,   3.390125886089023e-12,   1.111312358888385e-13,  -7.328471827131349e-15,
   2.681519348078683e-16,   7.158550833182371e-01,  -1.084629021503501e-02,   1.642130827842130e-04,  -2.474010529499054e-06,   3.632778687344521e-08,  -4.758270496708257e-10,
   3.338088048913842e-12,   1.135609614296355e-13,  -7.410785446989805e-15,   2.701429033186497e-16,   7.158871879502690e-01,  -1.084774032279571e-02,   1.642556367120237e-04,
  -2.474936725029333e-06,   3.633731804045896e-08,  -4.753475562500116e-10,   3.296999818830207e-12,   1.154773219868121e-13,  -7.475628785964915e-15,   2.717078322753279e-16,
   7.159057174234106e-01,  -1.084857729035915e-02,   1.642801970743091e-04,  -2.475471106118850e-06,   3.634280029206495e-08,  -4.750696356025042e-10,   3.273233186719585e-12,
   1.165849551054227e-13,  -7.513075902457598e-15,   2.726101852695081e-16,   7.159126756634087e-01,  -1.084889159550240e-02,   1.642894200475425e-04,  -2.475671744173902e-06,
   3.634485545612933e-08,  -4.749650474973102e-10,   3.264298406138375e-12,   1.170011967341396e-13,  -7.527142330987281e-15,   2.729488761137864e-16,   7.159138291038732e-01,
  -1.084894369689646e-02,   1.642909489038701e-04,  -2.475705001358870e-06,   3.634519594553226e-08,  -4.749476985882503e-10,   3.262816801574451e-12,   1.170702113238066e-13,
  -7.529474288522890e-15,   2.730050109472857e-16,   6.720325634223037e-03,  -9.598475215696232e-05,   1.370489204191400e-06,  -1.954643104633454e-08,   2.773023943287235e-10,
  -3.845254075193199e-12,   4.892736613780179e-14,  -4.401931561648619e-16,  -2.948687302924106e-18,   3.109597390571555e-19,   6.720521142247251e-03,  -9.599311633204111e-05,
   1.370726567961594e-06,  -1.955191398527129e-08,   2.774066766465083e-10,  -3.846543207275846e-12,   4.891419288056564e-14,  -4.385496855965486e-16,  -3.017173652497007e-18,
   3.128381654999695e-19,   6.720842124829630e-03,  -9.600684917394186e-05,   1.371116303323379e-06,  -1.956091643210202e-08,   2.775778518686912e-10,  -3.848655943560655e-12,
   4.889236881788317e-14,  -4.358447161190422e-16,  -3.129742249075849e-18,   3.159207147383299e-19,   6.721182745486777e-03,  -9.602142308430535e-05,   1.371529930072010e-06,
  -1.957047050944326e-08,   2.777594531924606e-10,  -3.850892842662887e-12,   4.886894244664292e-14,  -4.329650960279004e-16,  -3.249372056904048e-18,   3.191898832873327e-19,
   6.721450839868312e-03,  -9.603289449649455e-05,   1.371855519777125e-06,  -1.957799090965311e-08,   2.779023533921795e-10,  -3.852649756175064e-12,   4.885031058069329e-14,
  -4.306919882529121e-16,  -3.343655416058944e-18,   3.217615109575437e-19,   6.721605572053617e-03,  -9.603951554152289e-05,   1.372043449326749e-06,  -1.958233159669596e-08,
   2.779848154318008e-10,  -3.853662285047744e-12,   4.883947946975399e-14,  -4.293773955321646e-16,  -3.398121773141550e-18,   3.232451474738712e-19,   6.721663677356691e-03,
  -9.604200193617548e-05,   1.372114023535241e-06,  -1.958396166550414e-08,   2.780157791434594e-10,  -3.854042231008265e-12,   4.883539747439233e-14,  -4.288832355073397e-16,
  -3.418584541731049e-18,   3.238021721431305e-19,   6.721673309238865e-03,  -9.604241409834746e-05,   1.372125722473374e-06,  -1.958423187789202e-08,   2.780209117371183e-10,
  -3.854105198308385e-12,   4.883472004401532e-14,  -4.288012941175176e-16,  -3.421977071412594e-18,   3.238945018859154e-19,   6.141627374002728e-02,  -8.771932144524972e-04,
   1.252469011507724e-05,  -1.786261537283443e-07,   2.533641644649786e-09,  -3.509817927809965e-11,   4.445777163251149e-13,  -3.895668976900156e-15,  -3.229110716409495e-17,
   3.032784756867212e-18,   6.141806045673381e-02,  -8.772696507112740e-04,   1.252685881627210e-05,  -1.786761969020404e-07,   2.534588932475301e-09,  -3.510956416581930e-11,
   4.444352454578602e-13,  -3.879640074369404e-15,  -3.295497992527622e-17,   3.051108498231854e-18,   6.142099386539095e-02,  -8.773951486687618e-04,   1.253041967443678e-05,
  -1.787583624757198e-07,   2.536143831614079e-09,  -3.512821935932241e-11,   4.441994366011451e-13,  -3.853258253473592e-15,  -3.404621196887826e-17,   3.081180999290626e-18,
   6.142410674320183e-02,  -8.775283327262805e-04,   1.253419881403386e-05,  -1.788455622524959e-07,   2.537793389449876e-09,  -3.514796639154877e-11,   4.439466137431713e-13,
  -3.825172998553526e-15,  -3.520596004101724e-17,   3.113077840660493e-18,   6.142655681489852e-02,  -8.776331645038736e-04,   1.253717359148319e-05,  -1.789142003248622e-07,
   2.539091374168131e-09,  -3.516347290456155e-11,   4.437457483757560e-13,  -3.803003085034976e-15,  -3.612003491180939e-17,   3.138171580440188e-18,   6.142797088758162e-02,
  -8.776936710758979e-04,   1.253889062407869e-05,  -1.789538172590653e-07,   2.539840375529123e-09,  -3.517240816428382e-11,   4.436290658992449e-13,  -3.790181674853579e-15,
  -3.664810391031674e-17,   3.152649878248727e-18,   6.142850190264460e-02,  -8.777163930490053e-04,   1.253953543043026e-05,  -1.789686946731676e-07,   2.540121615737641e-09,
  -3.517576082248211e-11,   4.435851069163765e-13,  -3.785362058183825e-15,  -3.684650068309232e-17,   3.158085896491691e-18,   6.142858992687363e-02,  -8.777201596021464e-04,
   1.253964231860941e-05,  -1.789711608629328e-07,   2.540168234416540e-09,  -3.517631643525475e-11,   4.435778125110866e-13,  -3.784562871357592e-15,  -3.687939314430135e-17,
   3.158986955747751e-18,   1.763758361542385e-01,  -2.519130039126337e-03,   3.596818475661862e-05,  -5.129377369719724e-07,   7.272182819320618e-09,  -1.005060896895903e-10,
   1.259465870283278e-12,  -1.032491858440417e-14,  -1.292528652492696e-16,   1.002727686005267e-17,   1.763809672087301e-01,  -2.519349529796455e-03,   3.597440925771592e-05,
  -5.130810170728985e-07,   7.274864568334408e-09,  -1.005360949010105e-10,   1.258905673113239e-12,  -1.027191394960696e-14,  -1.314252051926809e-16,   1.008815309128406e-17,
   1.763893913080281e-01,  -2.519709903536280e-03,   3.598462943681730e-05,  -5.133162650607693e-07,   7.279266205055053e-09,  -1.005852377579756e-10,   1.257979734450449e-12,
  -1.018467291446173e-14,  -1.349963243342728e-16,   1.018808227883162e-17,   1.763983308024021e-01,  -2.520092348116983e-03,   3.599547608328113e-05,  -5.135659227635838e-07,
   7.283935469199132e-09,  -1.006372248125121e-10,   1.256988693325993e-12,  -1.009179718721299e-14,  -1.387921622887869e-16,   1.029410161289168e-17,   1.764053668642877e-01,
  -2.520393377595485e-03,   3.600401407737155e-05,  -5.137624346150641e-07,   7.287609322453110e-09,  -1.006780247870928e-10,   1.256202543286964e-12,  -1.001848178942878e-14,
  -1.417842757151639e-16,   1.037752897880648e-17,   1.764094277668866e-01,  -2.520567125065932e-03,   3.600894217255054e-05,  -5.138758574266163e-07,   7.289729220007069e-09,
  -1.007015254399001e-10,   1.255746355300838e-12,  -9.976081172761407e-15,  -1.435129902913747e-16,   1.042567210489008e-17,   1.764109527241484e-01,  -2.520632372271357e-03,
   3.601079284448879e-05,  -5.139184510824201e-07,   7.290525195355233e-09,  -1.007103415018457e-10,   1.255574582169311e-12,  -9.960142523569487e-15,  -1.441624998183679e-16,
   1.044374945684801e-17,   1.764112055101724e-01,  -2.520643188103818e-03,   3.601109962635148e-05,  -5.139255117098373e-07,   7.290657136110134e-09,  -1.007118024328871e-10,
   1.255546083513367e-12,  -9.957499578278675e-15,  -1.442701842993378e-16,   1.044674598998585e-17,   3.666319485758198e-01,  -5.236501355922287e-03,   7.476557087128764e-05,
  -1.066066065462748e-06,   1.510015508596818e-08,  -2.077019603370443e-10,   2.544345745439743e-12,  -1.773256276729465e-14,  -4.291298865157443e-16,   2.675070799278609e-17,
   3.666426142557777e-01,  -5.236957528850206e-03,   7.477849468612780e-05,  -1.066362066771413e-06,   1.510556436897267e-08,  -2.077526828893040e-10,   2.542516365520485e-12,
  -1.759105332945991e-14,  -4.348727721579437e-16,   2.691688441055747e-17,   3.666601250303395e-01,  -5.237706501998662e-03,   7.479971455169529e-05,  -1.066848052060274e-06,
   1.511444169642000e-08,  -2.078356435982859e-10,   2.539496517456984e-12,  -1.735812672650901e-14,  -4.443154891833387e-16,   2.718977305000320e-17,   3.666787071298548e-01,
  -5.238501344709566e-03,   7.482223499654618e-05,  -1.067363789472349e-06,   1.512385729044003e-08,  -2.079232512177719e-10,   2.536269607223098e-12,  -1.711013629694863e-14,
  -4.543550786359853e-16,   2.747943957515491e-17,   3.666933326536141e-01,  -5.239126980113980e-03,   7.483996198221632e-05,  -1.067769727678733e-06,   1.513126455114394e-08,
  -2.079918941320459e-10,   2.533713617450088e-12,  -1.691436017271587e-14,  -4.622708418668001e-16,   2.770748681053014e-17,   3.667017738560555e-01,  -5.239488082624291e-03,
   7.485019388570856e-05,  -1.068004022613811e-06,   1.513553827553794e-08,  -2.080313869548309e-10,   2.532231928018480e-12,  -1.680113084681021e-14,  -4.668450087887903e-16,
   2.783912802896668e-17,   3.667049437110660e-01,  -5.239623687028303e-03,   7.485403631543469e-05,  -1.068092006477540e-06,   1.513714288363276e-08,  -2.080461937554063e-10,
   2.531674294920580e-12,  -1.675856615654133e-14,  -4.685637539423390e-16,   2.788856634295087e-17,   3.667054691651587e-01,  -5.239646165759104e-03,   7.485467326625545e-05,
  -1.068106591261920e-06,   1.513740885888595e-08,  -2.080486469728799e-10,   2.531581793609602e-12,  -1.675150802555673e-14,  -4.688487185574616e-16,   2.789676175145629e-17,
   6.748362822302181e-01,  -9.638468397322393e-03,   1.376104752985776e-04,  -1.961495947448645e-06,   2.772280855770872e-08,  -3.769385917261896e-10,   4.350889802433992e-12,
  -1.532056627681556e-14,  -1.561848094979843e-15,   7.894480192995344e-17,   6.748559129191654e-01,  -9.639307699467796e-03,   1.376341983896675e-04,  -1.962032682356308e-06,
   2.773201732632381e-08,  -3.769776533429218e-10,   4.344309284113013e-12,  -1.490168227858754e-14,  -1.579003827255824e-15,   7.948179375404031e-17,   6.748881423215646e-01,
  -9.640685715509575e-03,   1.376731493420856e-04,  -1.962913856958896e-06,   2.774712466694088e-08,  -3.770408650824078e-10,   4.333456551363949e-12,  -1.421202005389466e-14,
  -1.607226564930467e-15,   8.036440223599530e-17,   6.749223435379257e-01,  -9.642148122296445e-03,   1.377144870007447e-04,  -1.963848901609092e-06,   2.776314062297011e-08,
  -3.771066927332897e-10,   4.321873259559248e-12,  -1.347751979819557e-14,  -1.637253003067618e-15,   8.130233986619319e-17,   6.749492624858380e-01,  -9.643299207224725e-03,
   1.377470255186687e-04,  -1.964584822665940e-06,   2.777573502239297e-08,  -3.771575962364028e-10,   4.312708055601861e-12,  -1.289749659927456e-14,  -1.660941826102792e-15,
   8.204152756571393e-17,   6.749647989035646e-01,  -9.643963586226849e-03,   1.377658063627737e-04,  -1.965009551395242e-06,   2.778299938002989e-08,  -3.771866109790069e-10,
   4.307398934417040e-12,  -1.256196459671690e-14,  -1.674636296703094e-15,   8.246853727361471e-17,   6.749706331656031e-01,  -9.644213079506600e-03,   1.377728591777107e-04,
  -1.965169043942706e-06,   2.778572643917868e-08,  -3.771974376826933e-10,   4.305401579724460e-12,  -1.243581974765963e-14,  -1.679783088696088e-15,   8.262896102439069e-17,
   6.749716002876842e-01,  -9.644254437240851e-03,   1.377740283049575e-04,  -1.965195482256702e-06,   2.778617844711936e-08,  -3.771992287419633e-10,   4.305070292914199e-12,
  -1.241490155836570e-14,  -1.680636474300041e-15,   8.265555763495455e-17,   6.356928198640263e-03,  -8.588909243687799e-05,   1.160210189641443e-06,  -1.566530685226020e-08,
   2.111212482451032e-10,  -2.821661891788434e-12,   3.649105740144440e-14,  -4.187717930681758e-16,   2.793731420365742e-18,   5.543137296260434e-20,   6.357093668477667e-03,
  -8.589579452704798e-05,   1.160390896381026e-06,  -1.566933280458395e-08,   2.111992686415715e-10,  -2.822908450395528e-12,   3.650173750589847e-14,  -4.184665100282678e-16,
   2.772049702341256e-18,   5.622295783645734e-20,   6.357365332662075e-03,  -8.590679833783844e-05,   1.160687603938724e-06,  -1.567594333719599e-08,   2.113273679892675e-10,
  -2.824954204817900e-12,   3.651920763456662e-14,  -4.179623922952865e-16,   2.736360219951383e-18,   5.752446837277584e-20,   6.357653614731513e-03,  -8.591847592402190e-05,
   1.161002499102718e-06,  -1.568295936290636e-08,   2.114633133160822e-10,  -2.827123989831085e-12,   3.653765902958563e-14,  -4.174234762112676e-16,   2.698361205067662e-18,
   5.890817890532513e-20,   6.357880512608547e-03,  -8.592766747129309e-05,   1.161250370689632e-06,  -1.568848227129910e-08,   2.115703189024282e-10,  -2.828830954231689e-12,
   3.655211816177346e-14,  -4.169964411954337e-16,   2.668361852581753e-18,   5.999912233618610e-20,   6.358011467176017e-03,  -8.593297258429087e-05,   1.161393441246452e-06,
  -1.569167015441697e-08,   2.116320802782487e-10,  -2.829815808167450e-12,   3.656043783268469e-14,  -4.167488253361660e-16,   2.651010985326762e-18,   6.062950979735893e-20,
   6.358060643310600e-03,  -8.593496479984892e-05,   1.161447169257809e-06,  -1.569286733160705e-08,   2.116552734893740e-10,  -2.830185579737455e-12,   3.656355722626921e-14,
  -4.166556226839006e-16,   2.644488444697188e-18,   6.086637432696788e-20,   6.358068795032255e-03,  -8.593529504299348e-05,   1.161456075634378e-06,  -1.569306578589383e-08,
   2.116591181593841e-10,  -2.830246871981424e-12,   3.656407406099745e-14,  -4.166401613782577e-16,   2.643406864739730e-18,   6.090564580466001e-20,   5.809522743228177e-02,
  -7.849303700651871e-04,   1.060301490693049e-05,  -1.431620019190756e-07,   1.929278223032505e-09,  -2.577677378839813e-11,   3.328688909392915e-13,  -3.795152935631261e-15,
   2.412173957136563e-17,   5.601947456348847e-19,   5.809673964005767e-02,  -7.849916190296960e-04,   1.060466624221244e-05,  -1.431987794551785e-07,   1.929989851826262e-09,
  -2.578806586462941e-11,   3.329606334876890e-13,  -3.792077428683377e-15,   2.391188623951819e-17,   5.678332314149543e-19,   5.809922234443615e-02,  -7.850921804915025e-04,
   1.060737761593512e-05,  -1.432591673285323e-07,   1.931158244902805e-09,  -2.580659685834800e-11,   3.331106340322092e-13,  -3.787000052720432e-15,   2.356645177410619e-17,
   5.803927932480434e-19,   5.810185691753054e-02,  -7.851988994353248e-04,   1.061025519053033e-05,  -1.433232592854065e-07,   1.932398188984974e-09,  -2.582625043066178e-11,
   3.332689661058022e-13,  -3.781573880680070e-15,   2.319866004678241e-17,   5.937462545326621e-19,   5.810393050829971e-02,  -7.852828990005120e-04,   1.061252028951812e-05,
  -1.433737113970438e-07,   1.933374167727654e-09,  -2.584171117564383e-11,   3.333929721131011e-13,  -3.777275415267595e-15,   2.290829427855271e-17,   6.042748614388534e-19,
   5.810512728538991e-02,  -7.853313812804299e-04,   1.061382769588096e-05,  -1.434028328678375e-07,   1.933937478619565e-09,  -2.585063117153836e-11,   3.334642966469620e-13,
  -3.774783436875997e-15,   2.274035299428133e-17,   6.103588753496292e-19,   5.810557669981092e-02,  -7.853495877070377e-04,   1.061431867275521e-05,  -1.434137691334748e-07,
   1.934149017741244e-09,  -2.585398020687719e-11,   3.334910339787162e-13,  -3.773845546623879e-15,   2.267722027898615e-17,   6.126449462127231e-19,   5.810565119735524e-02,
  -7.853526057276089e-04,   1.061440006092941e-05,  -1.434155820216085e-07,   1.934184083920524e-09,  -2.585453533039569e-11,   3.334954636600766e-13,  -3.773689965620207e-15,
   2.266675148265354e-17,   6.130239723311765e-19,   1.668384276097413e-01,  -2.254170147516149e-03,   3.044976634543312e-05,  -4.111246549574330e-07,   5.539629535448506e-09,
  -7.395901144476098e-11,   9.518014087120634e-13,  -1.068428813365165e-14,   5.974433210378497e-17,   1.973742448767985e-18,   1.668427703704319e-01,  -2.254346038527860e-03,
   3.045450785293993e-05,  -4.112301720192937e-07,   5.541663898569429e-09,  -7.399076736587767e-11,   9.520252299428721e-13,  -1.067351030317301e-14,   5.906118891726399e-17,
   1.998491260326534e-18,   1.668499002047150e-01,  -2.254634824721314e-03,   3.046229306144948e-05,  -4.114034279489319e-07,   5.545003972681604e-09,  -7.404287613564211e-11,
   9.523906837857372e-13,  -1.065572459665576e-14,   5.793665579151931e-17,   2.039188167429222e-18,   1.668574661756880e-01,  -2.254941293547991e-03,   3.047055547731357e-05,
  -4.115873101683334e-07,   5.548548506889820e-09,  -7.409813522853304e-11,   9.527757560427320e-13,  -1.063672720539059e-14,   5.673930237457771e-17,   2.082462644091465e-18,
   1.668634211166861e-01,  -2.255182518244491e-03,   3.047705927870459e-05,  -4.117320584961218e-07,   5.551338403798843e-09,  -7.414160092423439e-11,   9.530768494463345e-13,
  -1.062168527072492e-14,   5.579398287219343e-17,   2.116586325689316e-18,   1.668668580228447e-01,  -2.255321746610413e-03,   3.048081324542216e-05,  -4.118156084322360e-07,
   5.552948639646000e-09,  -7.416667637845875e-11,   9.532498292295503e-13,  -1.061296780825777e-14,   5.524721924484170e-17,   2.136306367298897e-18,   1.668681486518146e-01,
  -2.255374030680273e-03,   3.048222299096053e-05,  -4.118469846916095e-07,   5.553553324075320e-09,  -7.417609067157520e-11,   9.533146359380764e-13,  -1.060968741739527e-14,
   5.504167698214074e-17,   2.143716462056436e-18,   1.668683625939674e-01,  -2.255382697641642e-03,   3.048245668140584e-05,  -4.118521858837674e-07,   5.553653560484822e-09,
  -7.417765113093746e-11,   9.533253707178129e-13,  -1.060914328170348e-14,   5.500759342952112e-17,   2.144945056213938e-18,   3.468065795252567e-01,  -4.685735787475089e-03,
   6.329554921954865e-05,  -8.545654614502219e-07,   1.151154563318672e-08,  -1.534601851327208e-10,   1.961170731974909e-12,  -2.129962662932720e-14,   8.329883460620671e-17,
   5.692605468513053e-18,   3.468156067610415e-01,  -4.686101393827695e-03,   6.330540202484398e-05,  -8.547843793328834e-07,   1.151573541714172e-08,  -1.535233408833233e-10,
   1.961465589095580e-12,  -2.126873264715379e-14,   8.152088392977376e-17,   5.756867461843928e-18,   3.468304274472670e-01,  -4.686701663520897e-03,   6.332157958659825e-05,
  -8.551438332295009e-07,   1.152261406087440e-08,  -1.536269534093211e-10,   1.961944477542120e-12,  -2.121777574198527e-14,   7.859395633741034e-17,   5.862559661363948e-18,
   3.468461547241822e-01,  -4.687338688076581e-03,   6.333874874649816e-05,  -8.555253295756687e-07,   1.152991342072754e-08,  -1.537368017949687e-10,   1.962445579572897e-12,
  -2.116338071845132e-14,   7.547719989254957e-17,   5.974973040956708e-18,   3.468585331754887e-01,  -4.687840096381966e-03,   6.335226351176933e-05,  -8.558256328748627e-07,
   1.153565847698618e-08,  -1.538231858457585e-10,   1.962834845378824e-12,  -2.112033534218280e-14,   7.301628411365848e-17,   6.063635211469034e-18,   3.468656774233750e-01,
  -4.688129495632368e-03,   6.336006416776743e-05,  -8.559989692931796e-07,   1.153897422918879e-08,  -1.538730127572529e-10,   1.963057448962510e-12,  -2.109539822765758e-14,
   7.159282845224378e-17,   6.114880885131806e-18,   3.468683602354065e-01,  -4.688238172977965e-03,   6.336299358458883e-05,  -8.560640636627548e-07,   1.154021935871001e-08,
  -1.538917181433685e-10,   1.963140651080344e-12,  -2.108601616538282e-14,   7.105769923114065e-17,   6.134138691809745e-18,   3.468688049539065e-01,  -4.688256188069964e-03,
   6.336347918753577e-05,  -8.560748542405507e-07,   1.154042575841425e-08,  -1.538948185588275e-10,   1.963154422557517e-12,  -2.108446000819832e-14,   7.096896185244192e-17,
   6.137331716137049e-18,   6.383450379008380e-01,  -8.624732921116022e-03,   1.165029302106610e-04,  -1.572787497193797e-06,   2.117324824557169e-08,  -2.812810439360597e-10,
   3.534572961359173e-12,  -3.516485482920558e-14,  -3.325205568637405e-17,   1.797094577382582e-17,   6.383616535660315e-01,  -8.625405796183471e-03,   1.165210515930158e-04,
  -1.573188653425171e-06,   2.118079020736915e-08,  -2.813845714931018e-10,   3.534335434018107e-12,  -3.506780583458422e-14,  -3.828951300717403e-17,   1.815585427931645e-17,
   6.383889327411688e-01,  -8.626510553529261e-03,   1.165508054293099e-04,  -1.573847322152328e-06,   2.119317113589186e-08,  -2.815543158496426e-10,   3.533930842246822e-12,
  -3.490779418774602e-14,  -4.658441491804474e-17,   1.846011543620356e-17,   6.384178805984349e-01,  -8.627682955039717e-03,   1.165823828749095e-04,  -1.574546364319115e-06,
   2.120630767144617e-08,  -2.817341375811426e-10,   3.533481585621656e-12,  -3.473707023709773e-14,  -5.542009502021592e-17,   1.878391690380194e-17,   6.384406645564517e-01,
  -8.628605763262676e-03,   1.166072390704040e-04,  -1.575096618154298e-06,   2.121664575947121e-08,  -2.818754475044942e-10,   3.533113540072834e-12,  -3.460202843750700e-14,
  -6.239857281543671e-17,   1.903944329282985e-17,   6.384538143626819e-01,  -8.629138382871064e-03,   1.166215859026762e-04,  -1.575414222049911e-06,   2.122261189481656e-08,
  -2.819569155423506e-10,   3.532895319875610e-12,  -3.452381976323030e-14,  -6.643591915246982e-17,   1.918719037420677e-17,   6.384587523852806e-01,  -8.629338396080686e-03,
   1.166269736278396e-04,  -1.575533493338975e-06,   2.122485220404636e-08,  -2.819874915694355e-10,   3.532812275901153e-12,  -3.449439990660472e-14,  -6.795386084173773e-17,
   1.924272338576299e-17,   6.384595709405728e-01,  -8.629371551621138e-03,   1.166278667387088e-04,  -1.575553264677342e-06,   2.122522356556966e-08,  -2.819925591372428e-10,
   3.532798452107422e-12,  -3.448952041462880e-14,  -6.820558050243849e-17,   1.925193154775241e-17,   6.030820410802267e-03,  -7.730591943857791e-05,   9.907755695375099e-07,
  -1.269503716758463e-08,   1.625534310119589e-10,  -2.075359158431627e-12,   2.617842991510457e-14,  -3.157791942794707e-16,   3.244921742876592e-18,  -1.353867681298469e-20,
   6.030961685202121e-03,  -7.731134969356479e-05,   9.909146823714115e-07,  -1.269799853299554e-08,   1.626094640760173e-10,  -2.076303840384770e-12,   2.619126443802705e-14,
  -3.158419969634372e-16,   3.240369165327148e-18,  -1.329554487925615e-20,   6.031193624360501e-03,  -7.732026525190673e-05,   9.911430932384320e-07,  -1.270286106582052e-08,
   1.627014711726956e-10,  -2.077854820105038e-12,   2.621232105915000e-14,  -3.159441889152069e-16,   3.232858036341852e-18,  -1.289527492598537e-20,   6.031439749262736e-03,
  -7.732972659342642e-05,   9.913855019028814e-07,  -1.270802191040743e-08,   1.627991246491443e-10,  -2.079500706973910e-12,   2.623464559196678e-14,  -3.160513850088275e-16,
   3.224837343462391e-18,  -1.246902174607974e-20,   6.031633464995553e-03,  -7.733717362051411e-05,   9.915763128892154e-07,  -1.271208447904235e-08,   1.628759978692716e-10,
  -2.080796156261452e-12,   2.625220191467672e-14,  -3.161348511285266e-16,   3.218488183919134e-18,  -1.213244573895479e-20,   6.031745267802096e-03,  -7.734147180691696e-05,
   9.916864473088160e-07,  -1.271442945040576e-08,   1.629203706897767e-10,  -2.081543836273647e-12,   2.626232870446802e-14,  -3.161826605919884e-16,   3.214809179801196e-18,
  -1.193775501748100e-20,   6.031787251939300e-03,  -7.734308588697477e-05,   9.917278064621844e-07,  -1.271531008297066e-08,   1.629370345956355e-10,  -2.081824607139576e-12,
   2.626613040976001e-14,  -3.162005453180520e-16,   3.213424881710965e-18,  -1.186456237229931e-20,   6.031794211467526e-03,  -7.734335344745240e-05,   9.917346624701648e-07,
  -1.271545606424821e-08,   1.629397969541229e-10,  -2.081871149434408e-12,   2.626676054376734e-14,  -3.162035063676563e-16,   3.213195266968909e-18,  -1.185242519370685e-20,
   5.511496640653325e-02,  -7.064897962502056e-04,   9.054580394001812e-06,  -1.160181665400034e-07,   1.485527655403775e-09,  -1.896422132477513e-11,   2.390998750543210e-13,
  -2.878313455234799e-15,   2.930896650882826e-17,  -1.099679365807309e-19,   5.511625749646083e-02,  -7.065394225781497e-04,   9.055851703219806e-06,  -1.160452267180294e-07,
   1.486039415208942e-09,  -1.897283089842758e-11,   2.392157228489215e-13,  -2.878813691376222e-15,   2.926416086805974e-17,  -1.076268198256890e-19,   5.511837716082379e-02,
  -7.066209005966461e-04,   9.057939079382625e-06,  -1.160896592398844e-07,   1.486879730012610e-09,  -1.898696594653991e-11,   2.394057746543752e-13,  -2.879626158658675e-15,
   2.919024613704256e-17,  -1.037725832463501e-19,   5.512062646700733e-02,  -7.067073664484466e-04,   9.060154376812794e-06,  -1.161368176222077e-07,   1.487771611127539e-09,
  -1.900196572754644e-11,   2.396072555650091e-13,  -2.880476333203873e-15,   2.911132835271407e-17,  -9.966809927767159e-20,   5.512239681202723e-02,  -7.067754237666541e-04,
   9.061898138907870e-06,  -1.161739402365411e-07,   1.488473701496283e-09,  -1.901377164125705e-11,   2.397656922366900e-13,  -2.881136780005633e-15,   2.904886545106584e-17,
  -9.642709780308649e-20,   5.512341856456462e-02,  -7.068147042786106e-04,   9.062904622942458e-06,  -1.161953679186039e-07,   1.488878961794799e-09,  -1.902058546596137e-11,
   2.398570769345031e-13,  -2.881514465652495e-15,   2.901267475644744e-17,  -9.455234107646952e-20,   5.512380225259554e-02,  -7.068294551257633e-04,   9.063282591302151e-06,
  -1.162034148869828e-07,   1.489031154335190e-09,  -1.902314420037280e-11,   2.398913829126345e-13,  -2.881655633605217e-15,   2.899905790768220e-17,  -9.384753616340549e-20,
   5.512386585489532e-02,  -7.068319003227557e-04,   9.063345246212782e-06,  -1.162047488220289e-07,   1.489056383127094e-09,  -1.902356835120062e-11,   2.398970690976705e-13,
  -2.881678999550084e-15,   2.899679930143793e-17,  -9.373066165407108e-20,   1.582796863745762e-01,  -2.028904061993322e-03,   2.600301517970637e-05,  -3.331800949717851e-07,
   4.265959779700819e-09,  -5.444679054528780e-11,   6.857085040617803e-13,  -8.215604713530742e-15,   8.185226227622831e-17,  -2.231167948867832e-19,   1.582833941364321e-01,
  -2.029046578429326e-03,   2.600666596100719e-05,  -3.332577841835710e-07,   4.267427332421179e-09,  -5.447135710775601e-11,   6.860315093784406e-13,  -8.216544437163487e-15,
   8.170187035189369e-17,  -2.155780716757572e-19,   1.582894814046219e-01,  -2.029280566252678e-03,   2.601266021645448e-05,  -3.333853488763867e-07,   4.269837054460379e-09,
  -5.451168899374502e-11,   6.865613351329380e-13,  -8.218058962447469e-15,   8.145382339900387e-17,  -2.031665364519231e-19,   1.582959409791481e-01,  -2.029528878080118e-03,
   2.601902181778671e-05,  -3.335207392318036e-07,   4.272394630531522e-09,  -5.455448678776551e-11,   6.871229217191985e-13,  -8.219627615071176e-15,   8.118905563627198e-17,
  -1.899486610297249e-19,   1.583010250693588e-01,  -2.029724324445306e-03,   2.602402932434395e-05,  -3.336273170294425e-07,   4.274407944579625e-09,  -5.458817069336321e-11,
   6.875644578254635e-13,  -8.220834310897400e-15,   8.097954314373095e-17,  -1.795111473540895e-19,   1.583039593460115e-01,  -2.029837129846616e-03,   2.602691961225237e-05,
  -3.336888351325412e-07,   4.275570063099673e-09,  -5.460761105350102e-11,   6.878191019060323e-13,  -8.221519539447115e-15,   8.085817234886487e-17,  -1.734734266308921e-19,
   1.583050612241947e-01,  -2.029879491188892e-03,   2.602800501176536e-05,  -3.337119376768338e-07,   4.276006487121371e-09,  -5.461491123700876e-11,   6.879146901493818e-13,
  -8.221774734362074e-15,   8.081250996128122e-17,  -1.712035502581062e-19,   1.583052438777592e-01,  -2.029886513282283e-03,   2.602818493584044e-05,  -3.337157673536700e-07,
   4.276078832599441e-09,  -5.461612135401288e-11,   6.879305335192249e-13,  -8.221816924930279e-15,   8.080493620494486e-17,  -1.708271458222686e-19,   3.290155508231169e-01,
  -4.217477018057837e-03,   5.405233538114613e-05,  -6.925725290439479e-07,   8.866854211201894e-09,  -1.131175399697858e-10,   1.421492543226103e-12,  -1.686778778909774e-14,
   1.603865425153942e-16,  -6.887691789434033e-20,   3.290232581273941e-01,  -4.217773262831383e-03,   5.405992353019227e-05,  -6.927339291783814e-07,   8.869896021900405e-09,
  -1.131679448616613e-10,   1.422123124259840e-12,  -1.686762112251026e-14,   1.599799361821755e-16,  -4.961591284509706e-20,   3.290359116983836e-01,  -4.218259646490204e-03,
   5.407238258492299e-05,  -6.929989454715082e-07,   8.874890614943405e-09,  -1.132506919512965e-10,   1.423157137100006e-12,  -1.686727548775880e-14,   1.593094716696344e-16,
  -1.790276348745975e-20,   3.290493391804010e-01,  -4.218775804998488e-03,   5.408560516039440e-05,  -6.932802187122131e-07,   8.880191579453261e-09,  -1.133384919744754e-10,
   1.424252685378400e-12,  -1.686681066490040e-14,   1.585940360742151e-16,   1.587395824693291e-20,   3.290599074506614e-01,  -4.219182073593007e-03,   5.409601324727501e-05,
  -6.935016332536458e-07,   8.884364417874606e-09,  -1.134075902376443e-10,   1.425113711547292e-12,  -1.686637368654663e-14,   1.580280688179257e-16,   4.254816882824929e-20,
   3.290660069153119e-01,  -4.219416558841850e-03,   5.410202069959853e-05,  -6.936294363675830e-07,   8.886773025668823e-09,  -1.134474678469287e-10,   1.425610153937084e-12,
  -1.686609292402295e-14,   1.577002678427437e-16,   5.797918189557181e-20,   3.290682973833913e-01,  -4.219504614108012e-03,   5.410427669791335e-05,  -6.936774315734424e-07,
   8.887677553855294e-09,  -1.134624422170250e-10,   1.425796483510419e-12,  -1.686598208830322e-14,   1.575769539629701e-16,   6.378064020372471e-20,   3.290686770643443e-01,
  -4.219519210725221e-03,   5.410465066932389e-05,  -6.936853876697396e-07,   8.887827496147436e-09,  -1.134649244295176e-10,   1.425827365580238e-12,  -1.686596343033087e-14,
   1.575565012406752e-16,   6.474268217499317e-20,   6.055982237990134e-01,  -7.762843407604627e-03,   9.949048992558338e-05,  -1.274742397434461e-06,   1.631746159196832e-08,
  -2.079566065986134e-10,   2.600103382823604e-12,  -3.014795146576829e-14,   2.524969027759920e-16,   1.645383598740592e-18,   6.056124101085737e-01,  -7.763388671582676e-03,
   9.950445401163696e-05,  -1.275039094139246e-06,   1.632302342056998e-08,  -2.080465420272606e-10,   2.601084737725236e-12,  -3.013809887732212e-14,   2.513122813619905e-16,
   1.698127388979160e-18,   6.056357006737411e-01,  -7.764283902406813e-03,   9.952738175569999e-05,  -1.275526262249817e-06,   1.633215556344319e-08,  -2.081941633782501e-10,
   2.602692331551814e-12,  -3.012172687395526e-14,   2.493592892415619e-16,   1.784990138512979e-18,   6.056604157237038e-01,  -7.765233936228926e-03,   9.955171453577381e-05,
  -1.276043310906927e-06,   1.634184751002739e-08,  -2.083507706198007e-10,   2.604393398562942e-12,  -3.010408608711043e-14,   2.472757900916135e-16,   1.877532816469095e-18,
   6.056798680173456e-01,  -7.765981708158507e-03,   9.957086794433898e-05,  -1.276450321873975e-06,   1.634947659557935e-08,  -2.084739991305400e-10,   2.605728723648648e-12,
  -3.009000761534012e-14,   2.456279243818277e-16,   1.950635959340340e-18,   6.056910948854247e-01,  -7.766413298170026e-03,   9.958192310707855e-05,  -1.276685252318679e-06,
   1.635388007958171e-08,  -2.085451077491857e-10,   2.606497990122477e-12,  -3.008180431059468e-14,   2.446736407111265e-16,   1.992934188471171e-18,   6.056953107935884e-01,
  -7.766575371355368e-03,   9.958607468695621e-05,  -1.276773477927107e-06,   1.635553374295163e-08,  -2.085718080408964e-10,   2.606786596897654e-12,  -3.007870906300822e-14,
   2.443146794110221e-16,   2.008838205693670e-18,   6.056960096463866e-01,  -7.766602237666799e-03,   9.958676288426905e-05,  -1.276788102948031e-06,   1.635580786719676e-08,
  -2.085762339064798e-10,   2.606834423852676e-12,  -3.007819519890293e-14,   2.442551438056263e-16,   2.011475611888867e-18,   5.736542843003778e-03,  -6.994780898731429e-05,
   8.527733722784481e-07,  -1.039490531991033e-08,   1.266711175773667e-10,  -1.542026550464715e-12,   1.869237444255628e-14,  -2.228965648342542e-16,   2.508372871097764e-18,
  -2.290279634255241e-20,   5.736664416881082e-03,  -6.995225457522797e-05,   8.528817564659979e-07,  -1.039710537831255e-08,   1.267111372705931e-10,  -1.542694515538939e-12,
   1.870237180736845e-14,  -2.230124473296437e-16,   2.508503364446104e-18,  -2.284918271799094e-20,   5.736864011267081e-03,  -6.995955340769391e-05,   8.530597113921345e-07,
  -1.040071781817290e-08,   1.267768515016495e-10,  -1.543791337700134e-12,   1.871878441203673e-14,  -2.232024855755520e-16,   2.508706460854068e-18,  -2.276075636521627e-20,
   5.737075811548426e-03,  -6.996729895796333e-05,   8.532485689541617e-07,  -1.040455183118233e-08,   1.268466003479836e-10,  -1.544955489487474e-12,   1.873619986094802e-14,
  -2.234038559772026e-16,   2.508906805971705e-18,  -2.266636992430270e-20,   5.737242510497739e-03,  -6.997339541648896e-05,   8.533972252024647e-07,  -1.040756989673573e-08,
   1.269015082384389e-10,  -1.545871928103341e-12,   1.874990619141897e-14,  -2.235621358712313e-16,   2.509053481897136e-18,  -2.259168177513152e-20,   5.737338720136817e-03,
  -6.997691407042248e-05,   8.534830273941658e-07,  -1.040931195286290e-08,   1.269332027414336e-10,  -1.546400920911459e-12,   1.875781649066701e-14,  -2.236534020378152e-16,
   2.509133715678062e-18,  -2.254841502744232e-20,   5.737374848647656e-03,  -6.997823541071783e-05,   8.535152488160069e-07,  -1.040996616357843e-08,   1.269451054927485e-10,
  -1.546599581517447e-12,   1.876078690654372e-14,  -2.236876581958848e-16,   2.509163008714695e-18,  -2.253213714673752e-20,   5.737380837509497e-03,  -6.997845444446276e-05,
   8.535205900752576e-07,  -1.041007461107607e-08,   1.269470786048345e-10,  -1.546632513334691e-12,   1.876127929652696e-14,  -2.236933358421814e-16,   2.509167820353563e-18,
  -2.252943723028926e-20,   5.242559796027634e-02,  -6.392448900342455e-04,   7.793396211405974e-06,  -9.499776851605558e-08,   1.157626456692136e-09,  -1.409191931779383e-11,
   1.707963082537443e-13,  -2.035323770049601e-15,   2.284347108917122e-17,  -2.060029421860312e-19,   5.242670900972510e-02,  -6.392855177159865e-04,   7.794386716234197e-06,
  -9.501787386239912e-08,   1.157992121545750e-09,  -1.409801840077151e-11,   1.708873364191355e-13,  -2.036365033192205e-15,   2.284385903268196e-17,  -2.054814251127270e-19,
   5.242853307947904e-02,  -6.393522208488976e-04,   7.796013016276804e-06,  -9.505088632358937e-08,   1.158592560047046e-09,  -1.410803327273626e-11,   1.710367743928253e-13,
  -2.038072474321529e-15,   2.284438914152887e-17,  -2.046213310692855e-19,   5.243046869748237e-02,  -6.394230064805985e-04,   7.797738953609869e-06,  -9.508592363463072e-08,
   1.159229862610062e-09,  -1.411866286821041e-11,   1.711953401539402e-13,  -2.039881528327450e-15,   2.284480624007368e-17,  -2.037033432634492e-19,   5.243199213968577e-02,
  -6.394787212653568e-04,   7.799097497889764e-06,  -9.511350436550455e-08,   1.159731561298512e-09,  -1.412703061657236e-11,   1.713201324850754e-13,  -2.041303321680522e-15,
   2.284502900799868e-17,  -2.029769941473768e-19,   5.243287138832595e-02,  -6.395108778108591e-04,   7.799881629572733e-06,  -9.512942422339292e-08,   1.160021156828604e-09,
  -1.413186068938789e-11,   1.713921526333520e-13,  -2.042123086028638e-15,   2.284511521137048e-17,  -2.025562434437530e-19,   5.243320156256137e-02,  -6.395229533772752e-04,
   7.800176095680811e-06,  -9.513540275688989e-08,   1.160129913302297e-09,  -1.413367459632085e-11,   1.714191969200999e-13,  -2.042430767940979e-15,   2.284513956618158e-17,
  -2.023979521997848e-19,   5.243325629406935e-02,  -6.395249550997250e-04,   7.800224908542824e-06,  -9.513639380911171e-08,   1.160147941796996e-09,  -1.413397528614391e-11,
   1.714236798978650e-13,  -2.042481762821391e-15,   2.284514318027499e-17,  -2.023716975830568e-19,   1.505563325690578e-01,  -1.835789561004667e-03,   2.238114654169081e-05,
  -2.728150901687458e-07,   3.324442342231680e-09,  -4.046613887706168e-11,   4.902891121101064e-13,  -5.833793030428826e-15,   6.506854702408143e-17,  -5.695412680662890e-19,
   1.505595232909558e-01,  -1.835906235777544e-03,   2.238399104579605e-05,  -2.728728240815796e-07,   3.325491996934374e-09,  -4.048361869449209e-11,   4.905482888096937e-13,
  -5.836664565756949e-15,   6.506425515047979e-17,  -5.678302642038738e-19,   1.505647616710380e-01,  -1.836097794155650e-03,   2.238866140855580e-05,  -2.729676216444947e-07,
   3.327215574878532e-09,  -4.051232081677641e-11,   4.909737549993404e-13,  -5.841372225144875e-15,   6.505686831519036e-17,  -5.650087944995626e-19,   1.505703203963901e-01,
  -1.836301076671345e-03,   2.239361790649478e-05,  -2.730682336547043e-07,   3.329044967745639e-09,  -4.054278436895162e-11,   4.914251875228964e-13,  -5.846358650170871e-15,
   6.504856589505890e-17,  -5.619978746817784e-19,   1.505746954315342e-01,  -1.836461078655191e-03,   2.239751933518722e-05,  -2.731474335547129e-07,   3.330485103014629e-09,
  -4.056676540744450e-11,   4.917804523933369e-13,  -5.850276626229381e-15,   6.504169486705022e-17,  -5.596158481249050e-19,   1.505772204657561e-01,  -1.836553425974892e-03,
   2.239977118206229e-05,  -2.731931484694038e-07,   3.331316390958359e-09,  -4.058060776199270e-11,   4.919854765846115e-13,  -5.852535208097365e-15,   6.503759414418011e-17,
  -5.582361502367402e-19,   1.505781686631207e-01,  -1.836588104643614e-03,   2.240061682136335e-05,  -2.732103162172360e-07,   3.331628577657640e-09,  -4.058580616250879e-11,
   4.920624640350898e-13,  -5.853382843627259e-15,   6.503602867680552e-17,  -5.577171171993319e-19,   1.505783258415617e-01,  -1.836593853199602e-03,   2.240075700073560e-05,
  -2.732131620880148e-07,   3.331680328644226e-09,  -4.058666789599765e-11,   4.920752257447456e-13,  -5.853523325774463e-15,   6.503576782669581e-17,  -5.576310302903318e-19,
   3.129610370371934e-01,  -3.816050683198177e-03,   4.652361587170836e-05,  -5.670983465020857e-07,   6.910346532500871e-09,  -8.410400137343209e-11,   1.018324462678674e-12,
  -1.208035210736210e-14,   1.330456008974909e-16,  -1.091572762605254e-18,   3.129676695800342e-01,  -3.816293213962053e-03,   4.652952858489267e-05,  -5.672183382969488e-07,
   6.912526546600729e-09,  -8.414019013997016e-11,   1.018853919468263e-12,  -1.208582341184751e-14,   1.330137725620521e-16,  -1.087100420412230e-18,   3.129785585830147e-01,
  -3.816691404572581e-03,   4.653923660819060e-05,  -5.674153615129935e-07,   6.916106209180365e-09,  -8.419961159752669e-11,   1.019723011897666e-12,  -1.209478864307405e-14,
   1.329606620825860e-16,  -1.079726557887020e-18,   3.129901134866021e-01,  -3.817113966029897e-03,   4.654953940316960e-05,  -5.676244690269217e-07,   6.919905617630768e-09,
  -8.426267829301264e-11,   1.020645053512761e-12,  -1.210427854788640e-14,   1.329031377525242e-16,  -1.071859047920052e-18,   3.129992078573414e-01,  -3.817446560645754e-03,
   4.655764908356785e-05,  -5.677890744196957e-07,   6.922896575502089e-09,  -8.431232363644011e-11,   1.021370608011134e-12,  -1.211173052261539e-14,   1.328570168035837e-16,
  -1.065635892832659e-18,   3.130044566374213e-01,  -3.817638522146404e-03,   4.656232987055101e-05,  -5.678840861157450e-07,   6.924623037819666e-09,  -8.434097954856924e-11,
   1.021789300423752e-12,  -1.211602451988256e-14,   1.328300585614848e-16,  -1.062031790764722e-18,   3.130064276520682e-01,  -3.817710608366845e-03,   4.656408765314157e-05,
  -5.679197667320280e-07,   6.925271402454743e-09,  -8.435174099993250e-11,   1.021946516122255e-12,  -1.211763569337801e-14,   1.328198709583391e-16,  -1.060676031435372e-18,
   3.130067543783608e-01,  -3.817722557835744e-03,   4.656437903607025e-05,  -5.679256814515444e-07,   6.925378881384501e-09,  -8.435352491048843e-11,   1.021972576479743e-12,
  -1.211790270165407e-14,   1.328181788120290e-16,  -1.060451169146932e-18,   5.760476928371947e-01,  -7.023964196643313e-03,   8.563304503110945e-05,  -1.043815796330359e-06,
   1.271879104744164e-08,  -1.547530311481916e-10,   1.870932958274090e-12,  -2.204281838601022e-14,   2.355260288955115e-16,  -1.610582841029890e-18,   5.760599009335268e-01,
  -7.024410604727062e-03,   8.564392759165299e-05,  -1.044036578614636e-06,   1.272279586309472e-08,  -1.548190309172791e-10,   1.871868068940225e-12,  -2.205073425793657e-14,
   2.353659244594082e-16,  -1.598178834668802e-18,   5.760799436230478e-01,  -7.025143524124451e-03,   8.566179555166638e-05,  -1.044399096414931e-06,   1.272937185726192e-08,
  -1.549273971011243e-10,   1.873402730215709e-12,  -2.206368286054497e-14,   2.351007971753208e-16,  -1.577729392809360e-18,   5.761012119930218e-01,  -7.025921301065452e-03,
   8.568075820339817e-05,  -1.044783848179133e-06,   1.273635145355938e-08,  -1.550424048855961e-10,   1.875030476288641e-12,  -2.207735884278787e-14,   2.348163575760011e-16,
  -1.555913509628251e-18,   5.761179514179179e-01,  -7.026533482815352e-03,   8.569568434684665e-05,  -1.045086716718346e-06,   1.274184585002818e-08,  -1.551329331440954e-10,
   1.876311048853295e-12,  -2.208807580823982e-14,   2.345902384596381e-16,  -1.538659094319360e-18,   5.761276125107210e-01,  -7.026886811818424e-03,   8.570429949305985e-05,
  -1.045261534885686e-06,   1.274501734177162e-08,  -1.551851853829970e-10,   1.877049902114860e-12,  -2.209424225185036e-14,   2.344588315405281e-16,  -1.528667026139861e-18,
   5.761312404309430e-01,  -7.027019495465681e-03,   8.570753475080167e-05,  -1.045327185913746e-06,   1.274620837582286e-08,  -1.552048078660620e-10,   1.877327312797919e-12,
  -2.209655430554677e-14,   2.344093148849876e-16,  -1.524908433003787e-18,   5.761318418150703e-01,  -7.027041489948114e-03,   8.570807105082371e-05,  -1.045338068778720e-06,
   1.274640581242870e-08,  -1.552080606392850e-10,   1.877373295684154e-12,  -2.209693737638762e-14,   2.344010977089700e-16,  -1.524285050795549e-18,   5.469651707084115e-03,
  -6.359231834461541e-05,   7.392507286980954e-07,  -8.592485199101411e-09,   9.985493927402676e-11,  -1.159974570575958e-12,   1.345529137732916e-14,  -1.551737005313982e-16,
   1.751996828814394e-18,  -1.840335714685918e-20,   5.469757079681416e-03,  -6.359599251246463e-05,   7.393361524922858e-07,  -8.594139857501393e-09,   9.988374425877716e-11,
  -1.160439805382433e-12,   1.346229164316991e-14,  -1.552679072697023e-16,   1.752926827552428e-18,  -1.840068221810347e-20,   5.469930074671561e-03,  -6.360202476531098e-05,
   7.394764072832078e-07,  -8.596856726297188e-09,   9.993104311522157e-11,  -1.161203767071203e-12,   1.347378637679958e-14,  -1.554225520827116e-16,   1.754451059979458e-18,
  -1.839617262694400e-20,   5.470113647712874e-03,  -6.360842614734372e-05,   7.396252526629194e-07,  -8.599740185528716e-09,   9.998124555467538e-11,  -1.162014665977983e-12,
   1.348598679467784e-14,  -1.555866272694017e-16,   1.756064965503411e-18,  -1.839122653748819e-20,   5.470258129340463e-03,  -6.361346457230475e-05,   7.397424122881789e-07,
  -8.602009954863765e-09,   1.000207657813006e-10,  -1.162653047870115e-12,   1.349559120339685e-14,  -1.557157443163867e-16,   1.757332631341697e-18,  -1.838721706009925e-20,
   5.470341515992440e-03,  -6.361637254778876e-05,   7.398100344264889e-07,  -8.603320072269434e-09,   1.000435779437065e-10,  -1.163021550786565e-12,   1.350113514295762e-14,
  -1.557902558220553e-16,   1.758063226812655e-18,  -1.838485617455292e-20,   5.470372829167131e-03,  -6.361746455966641e-05,   7.398354285402559e-07,  -8.603812070135698e-09,
   1.000521449440773e-10,  -1.163159942462474e-12,   1.350321714525215e-14,  -1.558182347815857e-16,   1.758337383488835e-18,  -1.838396075648401e-20,   5.470378019808743e-03,
  -6.361764557827947e-05,   7.398396380481806e-07,  -8.603893627710587e-09,   1.000535650895655e-10,  -1.163182883663751e-12,   1.350356227736881e-14,  -1.558228726494944e-16,
   1.758382818893915e-18,  -1.838381185930084e-20,   4.998651090974403e-02,  -5.811628020293649e-04,   6.755926351686183e-06,  -7.852571048527606e-08,   9.125614195940364e-10,
  -1.060077248315014e-11,   1.229597475174216e-13,  -1.417746081424052e-15,   1.599350816906595e-17,  -1.674338871453711e-19,   4.998747389764178e-02,  -5.811963798161801e-04,
   6.756707028647669e-06,  -7.854083206344164e-08,   9.128246500259657e-10,  -1.060502304387607e-11,   1.230236472906141e-13,  -1.418602962948558e-15,   1.600181736135157e-17,
  -1.674017029498292e-19,   4.998905487871404e-02,  -5.812515078637336e-04,   6.757988798958331e-06,  -7.856566095978952e-08,   9.132568840748247e-10,  -1.061200287770552e-11,
   1.231285729042781e-13,  -1.420009544965878e-15,   1.601543399691448e-17,  -1.673477362963791e-19,   4.999073253136409e-02,  -5.813100093393345e-04,   6.759349077531088e-06,
  -7.859201228971519e-08,   9.137156519622436e-10,  -1.061941153569930e-11,   1.232399393902757e-13,  -1.421501861354401e-15,   1.602984924649331e-17,  -1.672889330403287e-19,
   4.999205293213563e-02,  -5.813560549109171e-04,   6.760419784104396e-06,  -7.861275523505400e-08,   9.140768018488103e-10,  -1.062524400917381e-11,   1.233276087560553e-13,
  -1.422676193057524e-15,   1.604117011551071e-17,  -1.672415366980872e-19,   4.999281499303872e-02,  -5.813826305559346e-04,   6.761037774025379e-06,  -7.862472812245068e-08,
   9.142852674576469e-10,  -1.062861077345501e-11,   1.233782138136332e-13,  -1.423353870482059e-15,   1.604769396144609e-17,  -1.672137344106278e-19,   4.999310116049618e-02,
  -5.813926103237023e-04,   6.761269847525347e-06,  -7.862922438737318e-08,   9.143635557287908e-10,  -1.062987516485429e-11,   1.233972182824465e-13,  -1.423608335124687e-15,
   1.605014190370164e-17,  -1.672032094231687e-19,   4.999314859716548e-02,  -5.813942646314593e-04,   6.761308317670249e-06,  -7.862996972487555e-08,   9.143765335187310e-10,
  -1.063008476310340e-11,   1.234003686383387e-13,  -1.423650515753894e-15,   1.605054758872616e-17,  -1.672014602718205e-19,   1.435517391302238e-01,  -1.668988878857064e-03,
   1.940173317018342e-05,  -2.255108030318648e-07,   2.620694378976908e-09,  -3.044274370246105e-11,   3.530736917488990e-13,  -4.069072042034278e-15,   4.581281162613030e-17,
  -4.758499039282709e-19,   1.435545046479579e-01,  -1.669085307827247e-03,   1.940397511815759e-05,  -2.255542283257424e-07,   2.621450228333673e-09,  -3.045494282363895e-11,
   3.532567051034454e-13,  -4.071505886774513e-15,   4.583540819482429e-17,  -4.757056502509673e-19,   1.435590449243228e-01,  -1.669243625016893e-03,   1.940765610587146e-05,
  -2.256255305397656e-07,   2.622691360031440e-09,  -3.047497491045978e-11,   3.535572157808017e-13,  -4.075500875637177e-15,   4.587242571977104e-17,  -4.754652448938071e-19,
   1.435638628230361e-01,  -1.669411630045084e-03,   1.941156255351306e-05,  -2.257012047814266e-07,   2.624008680895532e-09,  -3.049623764435137e-11,   3.538761685586907e-13,
  -4.079739097565121e-15,   4.591159731306081e-17,  -4.752052673407210e-19,   1.435676547624322e-01,  -1.669543864103352e-03,   1.941463740830365e-05,  -2.257607731773834e-07,
   2.625045697559920e-09,  -3.051297669781409e-11,   3.541272494870359e-13,  -4.083074037198104e-15,   4.594234794826586e-17,  -4.749971158433153e-19,   1.435698432561248e-01,
  -1.669620184263253e-03,   1.941641215153437e-05,  -2.257951562228583e-07,   2.625644291694841e-09,  -3.052263920517225e-11,   3.542721785884565e-13,  -4.084998468370609e-15,
   4.596006354907784e-17,  -4.748755627410724e-19,   1.435706650745295e-01,  -1.669648844243873e-03,   1.941707862012272e-05,  -2.258080683357969e-07,   2.625869090828742e-09,
  -3.052626796443052e-11,   3.543266057019226e-13,  -4.085721068146927e-15,   4.596671002814575e-17,  -4.748296487217649e-19,   1.435708013036040e-01,  -1.669653595098737e-03,
   1.941718909866989e-05,  -2.258102087527952e-07,   2.625906355615221e-09,  -3.052686950388026e-11,   3.543356280278858e-13,  -4.085840847114998e-15,   4.596781146542815e-17,
  -4.748220235843999e-19,   2.984006079239809e-01,  -3.469322610876767e-03,   4.033032732224953e-05,  -4.687683648586050e-07,   5.447597432273545e-09,  -6.327861483216533e-11,
   7.337585362142916e-13,  -8.448516095801884e-15,   9.475014977403017e-17,  -9.685747140504717e-19,   2.984063565977351e-01,  -3.469523057360530e-03,   4.033498762309731e-05,
  -4.688586288855465e-07,   5.449168216947551e-09,  -6.330394187674002e-11,   7.341369395383518e-13,  -8.453464029696196e-15,   9.479184772652732e-17,  -9.680567119745262e-19,
   2.984157944571436e-01,  -3.469852150617464e-03,   4.034263923223725e-05,  -4.690068379824898e-07,   5.451747498568525e-09,  -6.334553099883601e-11,   7.347582687937557e-13,
  -8.461584878528006e-15,   9.486010134765965e-17,  -9.671973900657473e-19,   2.984258094093236e-01,  -3.470201381940708e-03,   4.035075950091637e-05,  -4.691641347521454e-07,
   5.454485110026339e-09,  -6.338967478384606e-11,   7.354177085122834e-13,  -8.470199010128758e-15,   9.493225069301545e-17,  -9.662734098008362e-19,   2.984336917028223e-01,
  -3.470476256302691e-03,   4.035715115092299e-05,  -4.692879538175870e-07,   5.456640199814570e-09,  -6.342442667996344e-11,   7.359368076124550e-13,  -8.476976395635246e-15,
   9.498883432220745e-17,  -9.655373980381626e-19,   2.984382409183550e-01,  -3.470634902686735e-03,   4.036084028034631e-05,  -4.693594225173443e-07,   5.457884174862263e-09,
  -6.344448688921460e-11,   7.362364365006781e-13,  -8.480886958377137e-15,   9.502141015791982e-17,  -9.651090831814072e-19,   2.984399492299045e-01,  -3.470694478063551e-03,
   4.036222565756791e-05,  -4.693862616710002e-07,   5.458351343449599e-09,  -6.345202049301043e-11,   7.363489589345529e-13,  -8.482355261995029e-15,   9.503362762328157e-17,
  -9.649475752604743e-19,   2.984402324088891e-01,  -3.470704353644848e-03,   4.036245530749399e-05,  -4.693907107475647e-07,   5.458428785629381e-09,  -6.345326933765123e-11,
   7.363676116029490e-13,  -8.482598646326434e-15,   9.503565204666430e-17,  -9.649207675699307e-19,   5.492472274287119e-01,  -6.385763839627307e-03,   7.423348716454509e-05,
  -8.628311786710192e-07,   1.002692139679316e-08,  -1.164625428163901e-10,   1.349883237003132e-12,  -1.551067977134114e-14,   1.724215622503434e-16,  -1.696727484201161e-18,
   5.492578086493001e-01,  -6.386132788265396e-03,   7.424206496834444e-05,  -8.629973060757749e-07,   1.002981104727316e-08,  -1.165090337484070e-10,   1.350571383465622e-12,
  -1.551932044819507e-14,   1.724757810218565e-16,  -1.694821606376133e-18,   5.492751803208322e-01,  -6.386738528539064e-03,   7.425614860789396e-05,  -8.632700789822412e-07,
   1.003455593865057e-08,  -1.165853747695342e-10,   1.351701240356396e-12,  -1.553349828487451e-14,   1.725642537904510e-16,  -1.691669527222075e-18,   5.492936142105497e-01,
  -6.387381335617537e-03,   7.427109486621545e-05,  -8.635595772102380e-07,   1.003959207923874e-08,  -1.166664038074630e-10,   1.352900313070894e-12,  -1.554853218773159e-14,
   1.726573995498031e-16,  -1.688293226085203e-18,   5.493081226501638e-01,  -6.387887278733325e-03,   7.428285940848619e-05,  -8.637874609741133e-07,   1.004355659403124e-08,
  -1.167301924075821e-10,   1.353844138965903e-12,  -1.556035675908130e-14,   1.727301750999796e-16,  -1.685613049531296e-18,   5.493164961037552e-01,  -6.388179288670942e-03,
   7.428964966084275e-05,  -8.639189960480917e-07,   1.004584501223868e-08,  -1.167670133979694e-10,   1.354388898998144e-12,  -1.556717805627237e-14,   1.727719620492277e-16,
  -1.684057024968835e-18,   5.493196404848846e-01,  -6.388288945138134e-03,   7.429219960138116e-05,  -8.639683923485393e-07,   1.004670441526804e-08,  -1.167808414334336e-10,
   1.354593473055750e-12,  -1.556973897269733e-14,   1.727876130954438e-16,  -1.683470973149302e-18,   5.493201617145488e-01,  -6.388307122469326e-03,   7.429262229755485e-05,
  -8.639765806808435e-07,   1.004684687780165e-08,  -1.167831337014297e-10,   1.354627384726786e-12,  -1.557016345227928e-14,   1.727902053491987e-16,  -1.683373734342864e-18,
   5.226493571370232e-03,  -5.806524732645202e-05,   6.450144541108229e-07,  -7.164227117166863e-09,   7.956307580872403e-11,  -8.834222107904983e-13,   9.803811976986419e-15,
  -1.085816492174878e-16,   1.193567168393554e-18,  -1.277952326599118e-20,   5.226585498521159e-03,  -5.806831034465220e-05,   6.450825074921851e-07,  -7.165487041384796e-09,
   7.958405984167240e-11,  -8.837477515537174e-13,   9.808584501361256e-15,  -1.086472990650874e-16,   1.194368770805658e-18,  -1.278623512887136e-20,   5.226736418840566e-03,
  -5.807333917432844e-05,   6.451942411032321e-07,  -7.167555746240897e-09,   7.961851590111523e-11,  -8.842823213396848e-13,   9.816421680017547e-15,  -1.087550985692502e-16,
   1.195684494439974e-18,  -1.279722703278951e-20,   5.226896566510874e-03,  -5.807867568083489e-05,   6.453128167329403e-07,  -7.169751257832500e-09,   7.965508646627860e-11,
  -8.848497341353264e-13,   9.824740668046851e-15,  -1.088695156280562e-16,   1.197080254701780e-18,  -1.280885388942364e-20,   5.227022610482060e-03,  -5.808287592295891e-05,
   6.454061491453061e-07,  -7.171479467108485e-09,   7.968387495179208e-11,  -8.852964307025291e-13,   9.831290025424396e-15,  -1.089595866326899e-16,   1.198178488394207e-18,
  -1.281797784480755e-20,   5.227095355693883e-03,  -5.808530011854798e-05,   6.454600182245422e-07,  -7.172476982824112e-09,   7.970049225982997e-11,  -8.855542840388941e-13,
   9.835070697500336e-15,  -1.090115780483360e-16,   1.198812204807730e-18,  -1.282323283060170e-20,   5.227122672768131e-03,  -5.808621045715532e-05,   6.454802475670885e-07,
  -7.172851584912280e-09,   7.970673277434091e-11,  -8.856511211186371e-13,   9.836490549421698e-15,  -1.090311031693801e-16,   1.199050153441596e-18,  -1.282520411801384e-20,
   5.227127200991833e-03,  -5.808636136034284e-05,   6.454836009212224e-07,  -7.172913681890224e-09,   7.970776725796825e-11,  -8.856671738092886e-13,   9.836725919272598e-15,
  -1.090343398340373e-16,   1.199089595872326e-18,  -1.282553078089490e-20,   4.776431698416946e-02,  -5.306515430915734e-04,   5.894712072177432e-06,  -6.547303605731559e-08,
   7.271174469091475e-10,  -8.073472584608132e-12,   8.959454206679330e-14,  -9.922380091735068e-16,   1.090407572267336e-17,  -1.166264258769042e-19,   4.776515709570894e-02,
  -5.306795356575558e-04,   5.895334003884294e-06,  -6.548455032730744e-08,   7.273092144610005e-10,  -8.076447419196459e-12,   8.963814159557619e-14,  -9.928370861384185e-16,
   1.091135880601497e-17,  -1.166859741351145e-19,   4.776653633895313e-02,  -5.307254935452652e-04,   5.896355123980176e-06,  -6.550345592940110e-08,   7.276240992915888e-10,
  -8.081332386819041e-12,   8.970973824160361e-14,  -9.938207865201017e-16,   1.092331269298241e-17,  -1.167834755872773e-19,   4.776799990988386e-02,  -5.307742632556164e-04,
   5.897438772462932e-06,  -6.552352040003699e-08,   7.279583079988493e-10,  -8.086517475581724e-12,   8.978573630395262e-14,  -9.948648652119317e-16,   1.093599330279224e-17,
  -1.168865823201841e-19,   4.776915181107520e-02,  -5.308126487783352e-04,   5.898291726202883e-06,  -6.553931426050259e-08,   7.282213983178391e-10,  -8.090599442593457e-12,
   8.984556780096852e-14,  -9.956867749322903e-16,   1.094597053489855e-17,  -1.169674737521037e-19,   4.776981662110437e-02,  -5.308348032189827e-04,   5.898784029266375e-06,
  -6.554843041563045e-08,   7.283732594705977e-10,  -8.092955736691250e-12,   8.988010599340214e-14,  -9.961612008708397e-16,   1.095172759173103e-17,  -1.170140556522099e-19,
   4.777006626866841e-02,  -5.308431226973016e-04,   5.898968902804986e-06,  -6.555185385114602e-08,   7.284302898689686e-10,  -8.093840645169878e-12,   8.989307699025582e-14,
  -9.963393687229871e-16,   1.095388923417545e-17,  -1.170315282839271e-19,   4.777010765157811e-02,  -5.308445017839257e-04,   5.898999548706768e-06,  -6.555242134664603e-08,
   7.284397437389457e-10,  -8.093987336513619e-12,   8.989522720105569e-14,  -9.963689034486741e-16,   1.095424754732684e-17,  -1.170344236019481e-19,   1.371700214109958e-01,
  -1.523930165790062e-03,   1.692849027416973e-05,  -1.880260738340030e-07,   2.088141193135286e-09,  -2.318534354448502e-11,   2.572896063385233e-13,  -2.849013868705489e-15,
   3.128949218108864e-17,  -3.338469693727402e-19,   1.371724340513136e-01,  -1.524010555100670e-03,   1.693027634207414e-05,  -1.880591404228832e-07,   2.088691892860696e-09,
  -2.319388510015513e-11,   2.574147106178566e-13,  -2.850728439256918e-15,   3.131012542092521e-17,  -3.340060803500524e-19,   1.371763949751941e-01,  -1.524142537388770e-03,
   1.693320880202413e-05,  -1.881134333788053e-07,   2.089596148860581e-09,  -2.320791115283805e-11,   2.576201489168262e-13,  -2.853543767344364e-15,   3.134398903715910e-17,
  -3.342664651436300e-19,   1.371805980721273e-01,  -1.524282594695120e-03,   1.693632083142290e-05,  -1.881710543618508e-07,   2.090555897096630e-09,  -2.322279891723285e-11,
   2.578382155152504e-13,  -2.856531838764174e-15,   3.137990838080254e-17,  -3.345416336104782e-19,   1.371839061129355e-01,  -1.524392830595086e-03,   1.693877035001059e-05,
  -1.882164110398385e-07,   2.091311414267878e-09,  -2.323451931458546e-11,   2.580098934811524e-13,  -2.858884037858996e-15,   3.140816792431462e-17,  -3.347573792176209e-19,
   1.371858153207066e-01,  -1.524456453923078e-03,   1.694018414942789e-05,  -1.882425907381613e-07,   2.091747514282498e-09,  -2.324128484778136e-11,   2.581089956009788e-13,
  -2.860241766475048e-15,   3.142447336200557e-17,  -3.348815633205737e-19,   1.371865322609578e-01,  -1.524480345878019e-03,   1.694071507056181e-05,  -1.882524221316210e-07,
   2.091911288594084e-09,  -2.324382564925908e-11,   2.581462138564594e-13,  -2.860751650212536e-15,   3.143059551449101e-17,  -3.349281337967173e-19,   1.371866511047919e-01,
  -1.524484306351767e-03,   1.694080307967894e-05,  -1.882540518604415e-07,   2.091938437291193e-09,  -2.324424683805892e-11,   2.581523835484151e-13,  -2.860836173014997e-15,
   3.143161031182432e-17,  -3.349358502523347e-19,   2.851349487609493e-01,  -3.167789470054297e-03,   3.518920602110325e-05,  -3.908492227331436e-07,   4.340606931559600e-09,
  -4.819478457449593e-11,   5.347917817068808e-13,  -5.920207338966604e-15,   6.494048120459205e-17,  -6.895599704399703e-19,   2.851399639097088e-01,  -3.167956575064779e-03,
   3.519291870959938e-05,  -3.909179573581627e-07,   4.341751588867150e-09,  -4.821253343155330e-11,   5.350514093379527e-13,  -5.923747503009390e-15,   6.498221152453237e-17,
  -6.898414194582045e-19,   2.851481974712292e-01,  -3.168230926237206e-03,   3.519901439622186e-05,  -3.910308146523422e-07,   4.343631130179090e-09,  -4.824167870544385e-11,
   5.354777501496638e-13,  -5.929560281952409e-15,   6.505069078320787e-17,  -6.903013978359321e-19,   2.851569344372040e-01,  -3.168522062924641e-03,   3.520548335269432e-05,
  -3.911505898172165e-07,   4.345626014002898e-09,  -4.827261449543751e-11,   5.359302937998963e-13,  -5.935729480861853e-15,   6.512331455511871e-17,  -6.907866548551081e-19,
   2.851638108524855e-01,  -3.168751209947053e-03,   3.521057515194704e-05,  -3.912448714993605e-07,   4.347196392896341e-09,  -4.829696865692086e-11,   5.362865660835619e-13,
  -5.940585676754956e-15,   6.518044215583155e-17,  -6.911665097601082e-19,   2.851677795174003e-01,  -3.168883463560970e-03,   3.521351400809765e-05,  -3.912992905173860e-07,
   4.348102847562426e-09,  -4.831102693934249e-11,   5.364922250951112e-13,  -5.943388683692246e-15,   6.521340045724864e-17,  -6.913849096548094e-19,   2.851692698191180e-01,
  -3.168933127693340e-03,   3.521461763058853e-05,  -3.913197267637593e-07,   4.348443260226565e-09,  -4.831630653495964e-11,   5.365694610397015e-13,  -5.944441316394033e-15,
   6.522577451240436e-17,  -6.914667654088988e-19,   2.851695168594672e-01,  -3.168941360317792e-03,   3.521480057459802e-05,  -3.913231144360742e-07,   4.348499690076904e-09,
  -4.831718173361592e-11,   5.365822644746837e-13,  -5.944615809323082e-15,   6.522782557744340e-17,  -6.914803259582699e-19,   5.248299632056086e-01,  -5.830750793089132e-03,
   6.477055611947365e-05,  -7.194113354742484e-07,   7.989457229582414e-09,  -8.870706403876567e-11,   9.842184673445999e-13,  -1.088889088603200e-14,   1.191261890454170e-16,
  -1.251270304739900e-18,   5.248391942741458e-01,  -5.831058372655590e-03,   6.477738980856865e-05,  -7.195378478475203e-07,   7.991563810765727e-09,  -8.873970757779222e-11,
   9.846946305963570e-13,  -1.089530941077265e-14,   1.191981891758935e-16,  -1.251580332215085e-18,   5.248543492723986e-01,  -5.831563353411470e-03,   6.478860971740461e-05,
  -7.197455720086823e-07,   7.995022840265679e-09,  -8.879331110112453e-11,   9.854765365114901e-13,  -1.090584756553104e-14,   1.193163002762531e-16,  -1.252083912091881e-18,
   5.248704308555294e-01,  -5.832099230195995e-03,   6.480051667797074e-05,  -7.199660291071448e-07,   7.998694137783592e-09,  -8.885020743567430e-11,   9.863064801415350e-13,
  -1.091703085655263e-14,   1.194415041022878e-16,  -1.252610915888260e-18,   5.248830878401495e-01,  -5.832521006545605e-03,   6.480988880033709e-05,  -7.201395631030520e-07,
   8.001584192303593e-09,  -8.889499880140770e-11,   9.869598534965538e-13,  -1.092583323862527e-14,   1.195399520094205e-16,  -1.253020344602233e-18,   5.248903927117614e-01,
  -5.832764437360555e-03,   6.481529814931011e-05,  -7.202397262360340e-07,   8.003252389574417e-09,  -8.892085424697063e-11,   9.873370095148704e-13,  -1.093091369280162e-14,
   1.195967327422021e-16,  -1.253254493546192e-18,   5.248931358162925e-01,  -5.832855850969972e-03,   6.481732951077790e-05,  -7.202773409970086e-07,   8.003878869112104e-09,
  -8.893056425828969e-11,   9.874786507461080e-13,  -1.093282153429775e-14,   1.196180477493108e-16,  -1.253342013602809e-18,   5.248935905279077e-01,  -5.832871004238137e-03,
   6.481766624314232e-05,  -7.202835763143915e-07,   8.003982719957752e-09,  -8.893217388622331e-11,   9.875021306197049e-13,  -1.093313779056904e-14,   1.196215806617791e-16,
  -1.253356499913009e-18,   5.004037212635514e-03,  -5.322863801699033e-05,   5.661374878968312e-07,  -6.020742455411054e-09,   6.402190457272772e-11,  -6.806906357700608e-13,
   7.235533194706177e-15,  -7.685783109898599e-17,   8.142908178406571e-19,  -8.546093761223512e-21,   5.004117888266375e-03,  -5.323121183413548e-05,   5.661922403684527e-07,
  -6.021713074015663e-09,   6.403738831237930e-11,  -6.809210245483967e-13,   7.238789409802508e-15,  -7.690178045182497e-17,   8.148490061424733e-19,  -8.552322709254814e-21,
   5.004250336020954e-03,  -5.323543747162180e-05,   5.662821349826329e-07,  -6.023306738855677e-09,   6.406281240778196e-11,  -6.812993400660032e-13,   7.244136622782007e-15,
  -7.697395347085256e-17,   8.157655637439198e-19,  -8.562545407010747e-21,   5.004390881005037e-03,  -5.323992160749887e-05,   5.663775331257608e-07,  -6.024998063014781e-09,
   6.408979617684769e-11,  -6.817008912820594e-13,   7.249812616020092e-15,  -7.705056593418184e-17,   8.167383749660142e-19,  -8.573388198337329e-21,   5.004501496207053e-03,
  -5.324345094137455e-05,   5.664526213865496e-07,  -6.026329377626107e-09,   6.411103749753620e-11,  -6.820170077747781e-13,   7.254281236224439e-15,  -7.711088301118534e-17,
   8.175041795000426e-19,  -8.581918409522333e-21,   5.004565336632441e-03,  -5.324548790738136e-05,   5.664959600669633e-07,  -6.027097798978385e-09,   6.412329826469088e-11,
  -6.821994823011314e-13,   7.256860799234416e-15,  -7.714570225968868e-17,   8.179462190694345e-19,  -8.586840101956358e-21,   5.004589309768377e-03,  -5.324625283075495e-05,
   5.665122348863247e-07,  -6.027386366541126e-09,   6.412790268002382e-11,  -6.822680103922335e-13,   7.257829570809897e-15,  -7.715877895049335e-17,   8.181122241972337e-19,
  -8.588688007494059e-21,   5.004593283681034e-03,  -5.324637962893388e-05,   5.665149327082513e-07,  -6.027434201679140e-09,   6.412866594757408e-11,  -6.822793702783822e-13,
   7.257990164896846e-15,  -7.716094668973255e-17,   8.181397427075089e-19,  -8.588994311661736e-21,   4.573131419028725e-02,  -4.864503331123164e-04,   5.173864664946935e-06,
  -5.502286469994709e-08,   5.850886921852711e-10,  -6.220748564617572e-12,   6.612442515578274e-14,  -7.023791205664617e-16,   7.440924569524612e-18,  -7.806719202322896e-20,
   4.573205147549572e-02,  -4.864738549276838e-04,   5.174365041372897e-06,  -5.503173506438823e-08,   5.852301956625455e-10,  -6.222854011048966e-12,   6.615418000852089e-14,
  -7.027805808160613e-16,   7.446016585677530e-18,  -7.812372209737414e-20,   4.573326190012213e-02,  -4.865124725369204e-04,   5.175186577723743e-06,  -5.504629937194561e-08,
   5.854625424927832e-10,  -6.226311310366704e-12,   6.620304209157530e-14,  -7.034398518936156e-16,   7.454377721783475e-18,  -7.821649381450057e-20,   4.573454632438732e-02,
  -4.865534525328650e-04,   5.176058410180558e-06,  -5.506175617597556e-08,   5.857091429297663e-10,  -6.229980952447149e-12,   6.625490848812332e-14,  -7.041396735905247e-16,
   7.463251929508187e-18,  -7.831488862200874e-20,   4.573555722385479e-02,  -4.865857067044310e-04,   5.176744633001030e-06,  -5.507392289685709e-08,   5.859032640259297e-10,
  -6.232869834815587e-12,   6.629574206135141e-14,  -7.046906426108558e-16,   7.470237707661643e-18,  -7.839229438905434e-20,   4.573614065407824e-02,  -4.866043222997159e-04,
   5.177140700125037e-06,  -5.508094540529046e-08,   5.860153132507542e-10,  -6.234537408019396e-12,   6.631931370658327e-14,  -7.050087000312442e-16,   7.474270028738014e-18,
  -7.843695408667439e-20,   4.573635974177966e-02,  -4.866113128454092e-04,   5.177289433792870e-06,  -5.508358258882783e-08,   5.860573922787364e-10,  -6.235163663120984e-12,
   6.632816618853056e-14,  -7.051281493324847e-16,   7.475784335986703e-18,  -7.845372184119552e-20,   4.573639605890530e-02,  -4.866124716392104e-04,   5.177314088871453e-06,
  -5.508401974828270e-08,   5.860643676608839e-10,  -6.235267477285844e-12,   6.632963367188182e-14,  -7.051479505856511e-16,   7.476035360973086e-18,  -7.845650120937894e-20,
   1.313316245843014e-01,  -1.396992709557671e-03,   1.485835390547922e-05,  -1.580151849444900e-07,   1.680262973980498e-09,  -1.786477913057635e-11,   1.898949902580922e-13,
  -2.016996943279353e-15,   2.136378913820988e-17,  -2.239674883284257e-19,   1.313337419269965e-01,  -1.397060259730097e-03,   1.485979089098185e-05,  -1.580406589020339e-07,
   1.680669340989819e-09,  -1.787082524672958e-11,   1.899804188252013e-13,  -2.018148629046576e-15,   2.137835189436506e-17,  -2.241272202535720e-19,   1.313372180359855e-01,
  -1.397171162146495e-03,   1.486215018643131e-05,  -1.580824847539345e-07,   1.681336590188908e-09,  -1.788075341565526e-11,   1.901207056156528e-13,  -2.020039898313743e-15,
   2.140226362106231e-17,  -2.243893357680025e-19,   1.313409066578431e-01,  -1.397288848887425e-03,   1.486465392268487e-05,  -1.581268736812525e-07,   1.682044772579410e-09,
  -1.789129135611018e-11,   1.902696177939232e-13,  -2.022047483759186e-15,   2.142764205128870e-17,  -2.246673098191190e-19,   1.313438097685773e-01,  -1.397381476723153e-03,
   1.486662462352083e-05,  -1.581618141309577e-07,   1.682602245776065e-09,  -1.789958722267228e-11,   1.903868537732216e-13,  -2.023628044968016e-15,   2.144761951198746e-17,
  -2.248859670112511e-19,   1.313454852690586e-01,  -1.397434937166194e-03,   1.486776205263045e-05,  -1.581819814055665e-07,   1.682924026552296e-09,  -1.790437591257327e-11,
   1.904545295113618e-13,  -2.024540450548812e-15,   2.145915069509217e-17,  -2.250121140941305e-19,   1.313461144472095e-01,  -1.397455012681596e-03,   1.486818918730800e-05,
  -1.581895548823263e-07,   1.683044868280838e-09,  -1.790617429908503e-11,   1.904799455546135e-13,  -2.024883111911923e-15,   2.146348110860975e-17,  -2.250594751858578e-19,
   1.313462187430773e-01,  -1.397458340516621e-03,   1.486825999198317e-05,  -1.581908103190153e-07,   1.683064900046562e-09,  -1.790647241719526e-11,   1.904841587927418e-13,
  -2.024939915258380e-15,   2.146419895453544e-17,  -2.250673255213381e-19,   2.729986892322675e-01,  -2.903924928430160e-03,   3.088601958356698e-05,  -3.284657211909007e-07,
   3.492756807739592e-09,  -3.713536499445405e-11,   3.947271955881770e-13,  -4.192318987805697e-15,   4.438829878442056e-17,  -4.646474004369527e-19,   2.730030905467285e-01,
  -2.904065344783331e-03,   3.088900664025063e-05,  -3.285186736798569e-07,   3.493601505744166e-09,  -3.714793174317380e-11,   3.949046886905873e-13,  -4.194708026737989e-15,
   4.441832461249927e-17,  -4.649687597724711e-19,   2.730103163249631e-01,  -2.904295877323897e-03,   3.089391089934979e-05,  -3.286056167048341e-07,   3.494988488448275e-09,
  -3.716856726161002e-11,   3.951961588714391e-13,  -4.198631208508271e-15,   4.446762450429112e-17,  -4.654960119868710e-19,   2.730179838531153e-01,  -2.904540512420689e-03,
   3.089911540702349e-05,  -3.286978875699896e-07,   3.496460557067278e-09,  -3.719047016491447e-11,   3.955055488723679e-13,  -4.202795621170829e-15,   4.451994582917181e-17,
  -4.660550423326460e-19,   2.730240185414466e-01,  -2.904733057641790e-03,   3.090321189585450e-05,  -3.287705179681445e-07,   3.497619352763479e-09,  -3.720771295116132e-11,
   3.957491255929958e-13,  -4.206074203603051e-15,   4.456113042765033e-17,  -4.664946927588498e-19,   2.730275013997078e-01,  -2.904844185714068e-03,   3.090557626570240e-05,
  -3.288124394997334e-07,   3.498288224651104e-09,  -3.721766613946899e-11,   3.958897326226357e-13,  -4.207966805575093e-15,   4.458490183492463e-17,  -4.667482990430915e-19,
   2.730288092706066e-01,  -2.904885916631349e-03,   3.090646414903787e-05,  -3.288281824173740e-07,   3.498539413155346e-09,  -3.722140404612474e-11,   3.959425384138608e-13,
  -4.208677584861116e-15,   4.459382879463416e-17,  -4.668435071129135e-19,   2.730290260701415e-01,  -2.904892834192635e-03,   3.090661133046437e-05,  -3.288307920822590e-07,
   3.498581052324754e-09,  -3.722202367799297e-11,   3.959512920700622e-13,  -4.208795411366076e-15,   4.459530859548518e-17,  -4.668592879660368e-19,   5.024915137637543e-01,
  -5.345071937245547e-03,   5.684995297562863e-05,  -6.045861447619857e-07,   6.428893006590125e-09,  -6.835233759302541e-11,   7.265224769819278e-13,  -7.714950689621768e-15,
   8.162177080136074e-17,  -8.516072763880933e-19,   5.024996149863542e-01,  -5.345330392772123e-03,   5.685545105856786e-05,  -6.046836104754771e-07,   6.430447727238029e-09,
  -6.837546335438930e-11,   7.268488339170285e-13,  -7.719328210487286e-15,   8.167604351643214e-17,  -8.521549779003429e-19,   5.025129150217076e-01,  -5.345754719481883e-03,
   5.686447801253045e-05,  -6.048436400388548e-07,   6.433000557002736e-09,  -6.841343750057652e-11,   7.273847580007098e-13,  -7.726516640771966e-15,   8.176514692776384e-17,
  -8.530531977443277e-19,   5.025270281583388e-01,  -5.346205003877301e-03,   5.687405761465989e-05,  -6.050134761545329e-07,   6.435709992087805e-09,  -6.845374387261435e-11,
   7.279536273881682e-13,  -7.734146866172488e-15,   8.185970051952384e-17,  -8.540050215826908e-19,   5.025381358294492e-01,  -5.346559409723248e-03,   5.688159775781835e-05,
  -6.051471615188892e-07,   6.437842828095088e-09,  -6.848547451793105e-11,   7.284014844594803e-13,  -7.740153879840243e-15,   8.193412037829479e-17,  -8.547531977471146e-19,
   5.025445465075098e-01,  -5.346763956157713e-03,   5.688594970110563e-05,  -6.052243233576909e-07,   6.439073928461082e-09,  -6.850379062985350e-11,   7.286600132157515e-13,
  -7.743621440560713e-15,   8.197707178103296e-17,  -8.551846169968157e-19,   5.025469538231823e-01,  -5.346840767625419e-03,   5.688758397076875e-05,  -6.052533001724870e-07,
   6.439536256507668e-09,  -6.851066921823884e-11,   7.287571049935077e-13,  -7.744923694423513e-15,   8.199320088076872e-17,  -8.553465495229332e-19,   5.025473528724450e-01,
  -5.346853500344227e-03,   5.688785487813973e-05,  -6.052581035880579e-07,   6.439612895983628e-09,  -6.851180947998064e-11,   7.287731999604918e-13,  -7.745139569570651e-15,
   8.199587453202984e-17,  -8.553733884763875e-19,   4.799746577285065e-03,  -4.897209657338173e-05,   4.996141091468835e-07,  -5.096549479069799e-09,   5.198439942855178e-11,
  -5.301795239759317e-13,   5.406468856339550e-15,  -5.511675271819167e-17,   5.613907475778335e-19,  -5.699008085624290e-21,   4.799817765436317e-03,  -4.897427507341261e-05,
   4.996585612705824e-07,  -5.097305358552756e-09,   5.199596680583969e-11,  -5.303447065417418e-13,   5.408713415193056e-15,  -5.514606584026249e-17,   5.617586234427880e-19,
  -5.703354494403153e-21,   4.799934636894136e-03,  -4.897785166746537e-05,   4.997315437753117e-07,  -5.098546427192946e-09,   5.201495999544282e-11,  -5.306159438579630e-13,
   5.412399282598632e-15,  -5.519420418100326e-17,   5.623627574190076e-19,  -5.710491299402484e-21,   4.800058652777871e-03,  -4.898164702782206e-05,   4.998089935718160e-07,
  -5.099863528212164e-09,   5.203511795146793e-11,  -5.309038338019818e-13,   5.416311714834149e-15,  -5.524530457479269e-17,   5.630040704314639e-19,  -5.718065994640933e-21,
   4.800156258444255e-03,  -4.898463422637306e-05,   4.998699540059968e-07,  -5.100900261112821e-09,   5.205098578252309e-11,  -5.311304671187762e-13,   5.419391863905444e-15,
  -5.528553670731894e-17,   5.635089899287545e-19,  -5.724028757897813e-21,   4.800212590392590e-03,  -4.898635828927591e-05,   4.999051382858469e-07,  -5.101498647085337e-09,
   5.206014478674445e-11,  -5.312612866628594e-13,   5.421169896874972e-15,  -5.530876181360315e-17,   5.638004701092127e-19,  -5.727470560036587e-21,   4.800233743941405e-03,
  -4.898700570946874e-05,   4.999183508660812e-07,  -5.101723359660146e-09,   5.206358434262012e-11,  -5.313104154331574e-13,   5.421837645086358e-15,  -5.531748427338308e-17,
   5.639099391727963e-19,  -5.728763099420082e-21,   4.800237250462954e-03,  -4.898711302955220e-05,   4.999205410685108e-07,  -5.101760609655485e-09,   5.206415451188858e-11,
  -5.313185594796295e-13,   5.421948338086198e-15,  -5.531893020932559e-17,   5.639280860471076e-19,  -5.728977362040641e-21,   4.386432582985225e-02,  -4.475502958462568e-04,
   4.565915245067863e-06,  -4.657677294540126e-08,   4.750793720134644e-10,  -4.845248244403406e-12,   4.940903712023356e-14,  -5.037024902227005e-16,   5.130327017364874e-18,
  -5.207551114709941e-20,   4.386497641008830e-02,  -4.475702049046689e-04,   4.566321487848550e-06,  -4.658368083891400e-08,   4.751850848081084e-10,  -4.846757818769991e-12,
   4.942954921393426e-14,  -5.039703409874614e-16,   5.133687074085137e-18,  -5.211514836905393e-20,   4.386604448475069e-02,  -4.476028909817414e-04,   4.566988466458170e-06,
  -4.659502281894396e-08,   4.753586611591181e-10,  -4.849236608734791e-12,   4.946323282422787e-14,  -5.044102082487744e-16,   5.139205020045115e-18,  -5.218023207197415e-20,
   4.386717785149072e-02,  -4.476375763386213e-04,   4.567696271126864e-06,  -4.660705964991078e-08,   4.755428821613526e-10,  -4.851867584016068e-12,   4.949898690911578e-14,
  -5.048771410625030e-16,   5.145062526586731e-18,  -5.224930822969848e-20,   4.386806985832555e-02,  -4.476648759987521e-04,   4.568253381433932e-06,  -4.661653422967922e-08,
   4.756878962548609e-10,  -4.853938745735188e-12,   4.952713510037102e-14,  -5.052447642158345e-16,   5.149674252968431e-18,  -5.230368401952418e-20,   4.386858466945071e-02,
  -4.476806320091035e-04,   4.568574926469048e-06,  -4.662200280853992e-08,   4.757715992312510e-10,  -4.855134282333088e-12,   4.954338379627229e-14,  -5.054569846860117e-16,
   5.152336506970554e-18,  -5.233507034199713e-20,   4.386877798927345e-02,  -4.476865487069473e-04,   4.568695674700740e-06,  -4.662405643026956e-08,   4.758030328955002e-10,
  -4.855583261440272e-12,   4.954948606608484e-14,  -5.055366865386648e-16,   5.153336349007261e-18,  -5.234685715960586e-20,   4.386881003496612e-02,  -4.476875294927081e-04,
   4.568715690705617e-06,  -4.662439685358549e-08,   4.758082436000166e-10,  -4.855657688434392e-12,   4.955049764279264e-14,  -5.055498988395638e-16,   5.153502094478401e-18,
  -5.234881104295571e-20,   1.259699895911407e-01,  -1.285279211336385e-03,   1.311243897700989e-05,  -1.337596205267325e-07,   1.364337414728456e-09,  -1.391462515387755e-11,
   1.418930004698773e-13,  -1.446517461179712e-15,   1.473229520245688e-17,  -1.495048694750831e-19,   1.259718579336715e-01,  -1.285336386360085e-03,   1.311360562884895e-05,
  -1.337794586735931e-07,   1.364641000954856e-09,  -1.391896029966910e-11,   1.419519029420177e-13,  -1.447286426551270e-15,   1.474193208958844e-17,  -1.496181478320387e-19,
   1.259749252406802e-01,  -1.285430254547747e-03,   1.311552106429378e-05,  -1.338120306674510e-07,   1.365139477878795e-09,  -1.392607880626662e-11,   1.420486286704734e-13,
  -1.448549227397382e-15,   1.475775786532638e-17,  -1.498041449470876e-19,   1.259781800541007e-01,  -1.285529864286212e-03,   1.311755374439839e-05,  -1.338465981399965e-07,
   1.365668524125112e-09,  -1.393363435287658e-11,   1.421512999186815e-13,  -1.449889727227068e-15,   1.477455739055668e-17,  -1.500015460459055e-19,   1.259807417278419e-01,
  -1.285608263710359e-03,   1.311915365901748e-05,  -1.338738073179056e-07,   1.366084975885194e-09,  -1.393958224514396e-11,   1.422321300870839e-13,  -1.450945120771676e-15,
   1.478778388271059e-17,  -1.501569332957478e-19,   1.259822201673443e-01,  -1.285653511971051e-03,   1.312007707507305e-05,  -1.338895120286703e-07,   1.366325354255433e-09,
  -1.394301554655419e-11,   1.422787897259004e-13,  -1.451554374645870e-15,   1.479541922464647e-17,  -1.502466229114304e-19,   1.259827753450563e-01,  -1.285670503600308e-03,
   1.312042384098027e-05,  -1.338954096368201e-07,   1.366415625513003e-09,  -1.394430490947042e-11,   1.422963129575899e-13,  -1.451783186840318e-15,   1.479828676351718e-17,
  -1.502803046285896e-19,   1.259828673741823e-01,  -1.285673320230203e-03,   1.312048132313130e-05,  -1.338963872673608e-07,   1.366430589624249e-09,  -1.394451864637645e-11,
   1.422992177934501e-13,  -1.451821117388313e-15,   1.479876211981051e-17,  -1.502858879804449e-19,   2.618534732205436e-01,  -2.671706385221361e-03,   2.725679106285131e-05,
  -2.780457555050683e-07,   2.836044220972934e-09,  -2.892427367860272e-11,   2.949512381723612e-13,  -3.006792183728546e-15,   3.061990250413364e-17,  -3.105914025482807e-19,
   2.618573569390554e-01,  -2.671825234785854e-03,   2.725921617862302e-05,  -2.780869929766749e-07,   2.836675281734406e-09,  -2.893328487995468e-11,   2.950736612710958e-13,
  -3.008389627126650e-15,   3.063988423784267e-17,  -3.108246424228846e-19,   2.618637329417503e-01,  -2.672020358329336e-03,   2.726319778868791e-05,  -2.781547002416796e-07,
   2.837711459241301e-09,  -2.894808168039006e-11,   2.952746962151164e-13,  -3.011012953107326e-15,   3.067269801984441e-17,  -3.112075927899865e-19,   2.618704987135105e-01,
  -2.672227416818665e-03,   2.726742311488203e-05,  -2.782265554993825e-07,   2.838811180765623e-09,  -2.896378692605819e-11,   2.954880881489046e-13,  -3.013797679237825e-15,
   3.070753028544123e-17,  -3.116139993403672e-19,   2.618758236577142e-01,  -2.672390385485960e-03,   2.727074885272399e-05,  -2.782831151011585e-07,   2.839676853575479e-09,
  -2.897615043836353e-11,   2.956560854418229e-13,  -3.015990123797506e-15,   3.073495381405257e-17,  -3.119338912838933e-19,   2.618788968858666e-01,  -2.672484442920975e-03,
   2.727266835497867e-05,  -2.783157604161692e-07,   2.840176524929448e-09,  -2.898328702681056e-11,   2.957530627050908e-13,  -3.017255767358266e-15,   3.075078461650660e-17,
  -3.121185262370989e-19,   2.618800509322589e-01,  -2.672519763373965e-03,   2.727338917625592e-05,  -2.783280197489539e-07,   2.840364170602275e-09,  -2.898596714453011e-11,
   2.957894829304804e-13,  -3.017731093543842e-15,   3.075673002399779e-17,  -3.121878620852045e-19,   2.618802422329516e-01,  -2.672525618294779e-03,   2.727350866423515e-05,
  -2.783300519453678e-07,   2.840395276302906e-09,  -2.898641142600521e-11,   2.957955203309379e-13,  -3.017809889062550e-15,   3.075771560173123e-17,  -3.121993556833633e-19,
   4.819772157653256e-01,  -4.917641874212841e-03,   5.016986060886334e-05,  -5.117813227428908e-07,   5.220127307134366e-09,  -5.323901696835496e-11,   5.428930368920648e-13,
  -5.534107383195982e-15,   5.634433337672464e-17,  -5.709666675521945e-19,   4.819843642816674e-01,  -4.917860633125748e-03,   5.017432436608602e-05,  -5.118572258490597e-07,
   5.221288849177507e-09,  -5.325560234256551e-11,   5.431183062740755e-13,  -5.537043769248610e-15,   5.638091277258557e-17,  -5.713870330928041e-19,   4.819961001887164e-01,
  -4.918219784751020e-03,   5.018165306390508e-05,  -5.119818501648173e-07,   5.223196056450351e-09,  -5.328283626934710e-11,   5.434882278847255e-13,  -5.541865879016891e-15,
   5.644098147457133e-17,  -5.720771481500755e-19,   4.820085535191637e-01,  -4.918600904279866e-03,   5.018943035457863e-05,  -5.121141094169270e-07,   5.225220223864553e-09,
  -5.331174220381917e-11,   5.438808866663081e-13,  -5.546984626100233e-15,   5.650474304957670e-17,  -5.728094354563152e-19,   4.820183548089694e-01,  -4.918900870448313e-03,
   5.019555182986399e-05,  -5.122182149590679e-07,   5.226813596862054e-09,  -5.333449757838810e-11,   5.441900150115230e-13,  -5.551014638973866e-15,   5.655494113269758e-17,
  -5.733857643209329e-19,   4.820240115066940e-01,  -4.919073996048844e-03,   5.019908493624843e-05,  -5.122783030447007e-07,   5.227733300933503e-09,  -5.334763265671579e-11,
   5.443684606482263e-13,  -5.553341052326461e-15,   5.658391839268846e-17,  -5.737183806421437e-19,   4.820261356872876e-01,  -4.919139008183544e-03,   5.020041170637825e-05,
  -5.123008679927015e-07,   5.228078684922525e-09,  -5.335256548309136e-11,   5.444354766274719e-13,  -5.554214759749838e-15,   5.659480095768601e-17,  -5.738432824115931e-19,
   4.820264878024381e-01,  -4.919149784967770e-03,   5.020063164034344e-05,  -5.123046085230519e-07,   5.228135938632279e-09,  -5.335338319466959e-11,   5.444465859003885e-13,
  -5.554359595384859e-15,   5.659660496799906e-17,  -5.738639867213006e-19,   4.611483633195812e-03,  -4.520644085252270e-05,   4.431175854003184e-07,  -4.343068248142777e-09,
   4.256309734671696e-11,  -4.170884171549133e-13,   4.086749055909841e-15,  -4.003729859726129e-17,   3.921079327235281e-19,  -3.835519764912606e-21,   4.611546765267300e-03,
  -4.520829710480848e-05,   4.431539771902777e-07,  -4.343662808758911e-09,   4.257183958883641e-11,  -4.172083821657301e-13,   4.088316442593185e-15,  -4.005702411988334e-17,
   3.923483152877841e-19,  -3.838345325212819e-21,   4.611650410534332e-03,  -4.521134462715018e-05,   4.432137256061895e-07,  -4.344638999789384e-09,   4.258619381549838e-11,
  -4.174053668091629e-13,   4.090890254717554e-15,  -4.008941723402654e-17,   3.927430869262835e-19,  -3.842985616228554e-21,   4.611760391276427e-03,  -4.521457853372266e-05,
   4.432771306375699e-07,  -4.345674981871067e-09,   4.260142805090575e-11,  -4.176144407364244e-13,   4.093622210689492e-15,  -4.012380307358903e-17,   3.931621669077562e-19,
  -3.847911601254211e-21,   4.611846950393630e-03,  -4.521712381609348e-05,   4.433270360486186e-07,  -4.346490426834336e-09,   4.261341985785145e-11,  -4.177790250166399e-13,
   4.095772956891213e-15,  -4.015087522424919e-17,   3.934921275364066e-19,  -3.851790025711327e-21,   4.611896906834115e-03,  -4.521859282084278e-05,   4.433558395692181e-07,
  -4.346961084826434e-09,   4.262034151976455e-11,  -4.178740266623904e-13,   4.097014468219149e-15,  -4.016650322712413e-17,   3.936826113873235e-19,  -3.854029000815868e-21,
   4.611915666254279e-03,  -4.521914446044183e-05,   4.433666559806218e-07,  -4.347137830799231e-09,   4.262294085328424e-11,  -4.179097039082484e-13,   4.097480719795919e-15,
  -4.017237247933739e-17,   3.937541507645284e-19,  -3.854869883047230e-21,   4.611918775911461e-03,  -4.521923590332459e-05,   4.433684489768963e-07,  -4.347167129460359e-09,
   4.262337173955158e-11,  -4.179156180903626e-13,   4.097558010397629e-15,  -4.017334543314527e-17,   3.937660100099093e-19,  -3.855009277897172e-21,   4.214381267603924e-02,
  -4.131364061063034e-04,   4.049600084794164e-06,  -3.969079566805497e-08,   3.889791954356659e-10,  -3.811722396564149e-12,   3.734831422501640e-14,  -3.658956144962569e-16,
   3.583397834856629e-18,  -3.505096390116400e-20,   4.214438963269922e-02,  -4.131533701800803e-04,   4.049932665129141e-06,  -3.969622928816225e-08,   3.890590897465223e-10,
  -3.812818740926389e-12,   3.736263825814142e-14,  -3.660758760861485e-16,   3.585594274805362e-18,  -3.507676905212285e-20,   4.214533683474216e-02,  -4.131812211323659e-04,
   4.050478698951607e-06,  -3.970515058410183e-08,   3.891902713163771e-10,  -3.814618957505067e-12,   3.738615981081741e-14,  -3.663719003367242e-16,   3.589201406118235e-18,
  -3.511914756346788e-20,   4.214634193595500e-02,  -4.132107754284620e-04,   4.051058150157443e-06,  -3.971461830348015e-08,   3.893294951811945e-10,  -3.816529656426152e-12,
   3.741112660692017e-14,  -3.666861350114967e-16,   3.593030644994666e-18,  -3.516413506127769e-20,   4.214713298966153e-02,  -4.132340364680589e-04,   4.051514229903474e-06,
  -3.972207055986100e-08,   3.894390868778860e-10,  -3.818033770341269e-12,   3.743078184277269e-14,  -3.669335335477776e-16,   3.596045575019624e-18,  -3.519955538240401e-20,
   4.214758953576191e-02,  -4.132474615316327e-04,   4.051777461927487e-06,  -3.972637184833802e-08,   3.895023431223752e-10,  -3.818901977779330e-12,   3.744212776402576e-14,
  -3.670763498473058e-16,   3.597786070814105e-18,  -3.522000312232192e-20,   4.214776097592133e-02,  -4.132525029017784e-04,   4.051876311853019e-06,  -3.972798710916190e-08,
   3.895260981220543e-10,  -3.819228027395237e-12,   3.744638874292633e-14,  -3.671299859271563e-16,   3.598439742720712e-18,  -3.522768258199566e-20,   4.214778939471670e-02,
  -4.132533385876501e-04,   4.051892697837391e-06,  -3.972825486620758e-08,   3.895300359403692e-10,  -3.819282076320765e-12,   3.744709508610565e-14,  -3.671388772517759e-16,
   3.598548103388447e-18,  -3.522895562196475e-20,   1.210290034942345e-01,  -1.186449074326650e-03,   1.162968017506908e-05,  -1.139844057296871e-07,   1.117074154863440e-09,
  -1.094653981522653e-11,   1.072571795885257e-13,  -1.050778624357030e-15,   1.029063528745713e-17,  -1.006505597685376e-19,   1.210306604038773e-01,  -1.186497791915589e-03,
   1.163063528243896e-05,  -1.140000100503230e-07,   1.117303595957509e-09,  -1.094968829499121e-11,   1.072983146304554e-13,  -1.051296251461308e-15,   1.029694051377605e-17,
  -1.007245541062295e-19,   1.210333805877448e-01,  -1.186577774546108e-03,   1.163220338756473e-05,  -1.140256303107589e-07,   1.117680324193632e-09,  -1.095485815361393e-11,
   1.073658626419951e-13,  -1.052146294466552e-15,   1.030729533180556e-17,  -1.008460704496410e-19,   1.210362670470010e-01,  -1.186662648855634e-03,   1.163386746104984e-05,
  -1.140528197950775e-07,   1.118080148352191e-09,  -1.096034529507856e-11,   1.074375610213026e-13,  -1.053048628736544e-15,   1.031828771643354e-17,  -1.009750666354072e-19,
   1.210385388025857e-01,  -1.186729450131098e-03,   1.163517723520298e-05,  -1.140742212540550e-07,   1.118394874622665e-09,  -1.096466480640543e-11,   1.074940059241948e-13,
  -1.053759040639497e-15,   1.032694249007362e-17,  -1.010766292485722e-19,   1.210398499160342e-01,  -1.186768004356766e-03,   1.163593318743351e-05,  -1.140865737341830e-07,
   1.118576534387559e-09,  -1.096715812274405e-11,   1.075265885588221e-13,  -1.054169141528911e-15,   1.033193881613660e-17,  -1.011352598215026e-19,   1.210403422595204e-01,
  -1.186782482211653e-03,   1.163621706558995e-05,  -1.140912124551920e-07,   1.118644754176537e-09,  -1.096809447135385e-11,   1.075388250189171e-13,  -1.054323158961257e-15,
   1.033381526732251e-17,  -1.011572793596663e-19,   1.210404238728882e-01,  -1.186784882142314e-03,   1.163626412301574e-05,  -1.140919814023581e-07,   1.118656062833156e-09,
  -1.096824968894551e-11,   1.075408534589093e-13,  -1.054348690635208e-15,   1.033412633079357e-17,  -1.011609295807736e-19,   2.515826589195432e-01,  -2.466268449481688e-03,
   2.417458440535943e-05,  -2.369390723748954e-07,   2.322058950078432e-09,  -2.275453872495495e-11,   2.229549492758477e-13,  -2.184235368092938e-15,   2.139032380253311e-17,
  -2.091858829344463e-19,   2.515861031330908e-01,  -2.466369718600524e-03,   2.417656978439911e-05,  -2.369715090279134e-07,   2.322535888065161e-09,  -2.276108341237248e-11,
   2.230404532099194e-13,  -2.185311160634247e-15,   2.140342038387845e-17,  -2.093392420091760e-19,   2.515917575718640e-01,  -2.466535978275750e-03,   2.417982940017272e-05,
  -2.370247657839490e-07,   2.323318991048647e-09,  -2.277182990270861e-11,   2.231808595229252e-13,  -2.187077816763525e-15,   2.142492828997242e-17,  -2.095910906639436e-19,
   2.515977576468333e-01,  -2.466712406270741e-03,   2.418328850510808e-05,  -2.370812844807416e-07,   2.324150103396419e-09,  -2.278323592250215e-11,   2.233298928146030e-13,
  -2.188953148369219e-15,   2.144776037198029e-17,  -2.098584368806106e-19,   2.516024799389601e-01,  -2.466851265899272e-03,   2.418601112900496e-05,  -2.371257716271447e-07,
   2.324804323212611e-09,  -2.279221481064295e-11,   2.234472199810911e-13,  -2.190429603945096e-15,   2.146573696605095e-17,  -2.100689231988684e-19,   2.516052053469033e-01,
  -2.466931408462681e-03,   2.418758252480829e-05,  -2.371514486892574e-07,   2.325181938392858e-09,  -2.279739762094066e-11,   2.235149466910630e-13,  -2.191281919748993e-15,
   2.147611466689219e-17,  -2.101904323962664e-19,   2.516062287799628e-01,  -2.466961503540022e-03,   2.418817262154410e-05,  -2.371610911842213e-07,   2.325323746502406e-09,
  -2.279934399134841e-11,   2.235403815622624e-13,  -2.191602015231774e-15,   2.148001217455694e-17,  -2.102360666238609e-19,   2.516063984294474e-01,  -2.466966492269319e-03,
   2.418827043968446e-05,  -2.371626895923086e-07,   2.325347253746262e-09,  -2.279966663926228e-11,   2.235445979049115e-13,  -2.191655077877958e-15,   2.148065827272270e-17,
  -2.102436314834056e-19,   4.630723739871961e-01,  -4.539505189599082e-03,   4.449663675580903e-05,  -4.361188438815783e-07,   4.274067673366751e-09,  -4.188283427667813e-11,
   4.103781850589345e-13,  -4.020326809800877e-15,   3.936880480918500e-17,  -3.848962187408032e-19,   4.630787135344065e-01,  -4.539691589294867e-03,   4.450029111796195e-05,
  -4.361785479671767e-07,   4.274945540903234e-09,  -4.189488048602907e-11,   4.105355539239649e-13,  -4.022306192812445e-15,   3.939287168915409e-17,  -3.851767184618870e-19,
   4.630891213041500e-01,  -4.539997613018967e-03,   4.450629088741418e-05,  -4.362765742929225e-07,   4.276386945649096e-09,  -4.191466056926121e-11,   4.107939697855521e-13,
  -4.025556710192677e-15,   3.943239528947126e-17,  -3.856373452696903e-19,   4.631001652646967e-01,  -4.540322352929519e-03,   4.451265784400001e-05,  -4.363806046654245e-07,
   4.277916717960909e-09,  -4.193565458593335e-11,   4.110682633323304e-13,  -4.029007173869527e-15,   3.947435180500092e-17,  -3.861262974988707e-19,   4.631088572907470e-01,
  -4.540577943111506e-03,   4.451766920632354e-05,  -4.364624893277363e-07,   4.279120896129051e-09,  -4.195218120192645e-11,   4.112842021212757e-13,  -4.031723730565911e-15,
   3.950738550227432e-17,  -3.865112440205674e-19,   4.631138737776996e-01,  -4.540725456485859e-03,   4.452056157560439e-05,  -4.365097514635858e-07,   4.279815946843865e-09,
  -4.196172072491147e-11,   4.114088520132741e-13,  -4.033291918961320e-15,   3.952645538612633e-17,  -3.867334596679850e-19,   4.631157575465505e-01,  -4.540780850601311e-03,
   4.452164772949865e-05,  -4.365274997910440e-07,   4.280076963435634e-09,  -4.196530323006722e-11,   4.114556644657309e-13,  -4.033880866877523e-15,   3.953361735502764e-17,
  -3.868169143335134e-19,   4.631160698096848e-01,  -4.540790033041466e-03,   4.452182777718851e-05,  -4.365304418791907e-07,   4.280120231628697e-09,  -4.196589709842747e-11,
   4.114634245729947e-13,  -4.033978497517603e-15,   3.953480460864075e-17,  -3.868307486915962e-19,   4.437433227772953e-03,  -4.185899142831190e-05,   3.948278244249067e-07,
  -3.723820901217602e-09,   3.511816568824143e-11,  -3.311591067290421e-13,   3.122500364350915e-15,  -2.943907404815719e-17,   2.775089644948838e-19,  -2.614671197620124e-21,
   4.437489475049603e-03,  -4.186058287723837e-05,   3.948578477085301e-07,  -3.724292909761933e-09,   3.512484418829957e-11,  -3.312472989913298e-13,   3.123609413447136e-15,
  -2.945251786226385e-17,   2.776671912558730e-19,  -2.616483330031564e-21,   4.437581817154388e-03,  -4.186319564411709e-05,   3.949071399149193e-07,  -3.725067879003791e-09,
   3.513580974020273e-11,  -3.313921099379999e-13,   3.125430553314132e-15,  -2.947459477859615e-17,   2.779270391124517e-19,  -2.619459421149647e-21,   4.437679803474317e-03,
  -4.186596819003500e-05,   3.949594483657972e-07,  -3.725890304725779e-09,   3.514744736710874e-11,  -3.315458050687102e-13,   3.127363543753911e-15,  -2.949802922830242e-17,
   2.782028842279414e-19,  -2.622618891144423e-21,   4.437756922271312e-03,  -4.186815034184892e-05,   3.950006194539698e-07,  -3.726537647493490e-09,   3.515660792709536e-11,
  -3.316667925672861e-13,   3.128885266612399e-15,  -2.951647887943020e-17,   2.784200673668352e-19,  -2.625106574513730e-21,   4.437801430259063e-03,  -4.186940976190086e-05,
   3.950243817226275e-07,  -3.726911277504663e-09,   3.516189534151208e-11,  -3.317366282942064e-13,   3.129763662740743e-15,  -2.952712918654573e-17,   2.785454447227025e-19,
  -2.626542731820958e-21,   4.437818143682024e-03,  -4.186988269753566e-05,   3.950333049986389e-07,  -3.727051586064146e-09,   3.516388094600890e-11,  -3.317628544733734e-13,
   3.130093543268958e-15,  -2.953112898423204e-17,   2.785925321079343e-19,  -2.627082111366884e-21,   4.437820914183297e-03,  -4.186996109396070e-05,   3.950347841756040e-07,
  -3.727074844573647e-09,   3.516421009511837e-11,  -3.317672019524108e-13,   3.130148227484608e-15,  -2.953179203440678e-17,   2.786003378822469e-19,  -2.627171525900056e-21,
   4.055318626038372e-02,  -3.825444550780608e-04,   3.608285574727254e-06,  -3.403156618754645e-08,   3.209408321746393e-10,  -3.026424540147093e-12,   2.853616581575258e-14,
  -2.690401600278880e-16,   2.536116204411542e-18,  -2.389490268942584e-20,   4.055370029770429e-02,  -3.825589991447361e-04,   3.608559954024721e-06,  -3.403587981870347e-08,
   3.210018662056723e-10,  -3.027230518610827e-12,   2.854630126115657e-14,  -2.691630199874852e-16,   2.537562143699399e-18,  -2.391146008831348e-20,   4.055454420146188e-02,
  -3.825828769174121e-04,   3.609010429766454e-06,  -3.404296217241797e-08,   3.211020791021410e-10,  -3.028553928409171e-12,   2.856294440483728e-14,  -2.693647758925792e-16,
   2.539936736499376e-18,  -2.393865251553574e-20,   4.055543968704534e-02,  -3.826082148921469e-04,   3.609488470615791e-06,  -3.405047822538114e-08,   3.212084340134114e-10,
  -3.029958529690987e-12,   2.858060973503718e-14,  -2.695789379688800e-16,   2.542457517759405e-18,  -2.396752043142080e-20,   4.055614446676330e-02,  -3.826281573238201e-04,
   3.609864728402588e-06,  -3.405639421560012e-08,   3.212921512997608e-10,  -3.031064219860320e-12,   2.859451654792380e-14,  -2.697475450988141e-16,   2.544442222174248e-18,
  -2.399025024043078e-20,   4.055655122008772e-02,  -3.826396670172216e-04,   3.610081889012403e-06,  -3.405980877679054e-08,   3.213404723617130e-10,  -3.031702440151508e-12,
   2.860254408749792e-14,  -2.698448758078186e-16,   2.545587969214347e-18,  -2.400337231010423e-20,   4.055670396211664e-02,  -3.826439891209921e-04,   3.610163437794134e-06,
  -3.406109104038703e-08,   3.213586185689754e-10,  -3.031942118041697e-12,   2.860555881957076e-14,  -2.698814290386850e-16,   2.546018272007633e-18,  -2.400830058155254e-20,
   4.055672928140561e-02,  -3.826447055768041e-04,   3.610176955820396e-06,  -3.406130359719861e-08,   3.213616266241898e-10,  -3.031981849128576e-12,   2.860605857097898e-14,
  -2.698874885016423e-16,   2.546089604199020e-18,  -2.400911755549257e-20,   1.164610273716675e-01,  -1.098594817374964e-03,   1.036230895346335e-05,  -9.773217657974030e-08,
   9.216809430521448e-10,  -8.691314705161758e-12,   8.195042103861776e-14,  -7.726313616918674e-16,   7.283204255950250e-18,  -6.861983961716103e-20,   1.164625035889510e-01,
  -1.098636585164452e-03,   1.036309691854675e-05,  -9.774456450659943e-08,   9.218562211367585e-10,  -8.693629319445980e-12,   8.197952794378122e-14,  -7.729841824179020e-16,
   7.287356220448442e-18,  -6.866736674748616e-20,   1.164649271198169e-01,  -1.098705157579914e-03,   1.036439059907833e-05,  -9.776490367715012e-08,   9.221440134426903e-10,
  -8.697429896439550e-12,   8.202732361247948e-14,  -7.735635709778550e-16,   7.294174777275002e-18,  -6.874542098221122e-20,   1.164674987838626e-01,  -1.098777923417586e-03,
   1.036576344134881e-05,  -9.778648834931203e-08,   9.224494444421524e-10,  -8.701463639643235e-12,   8.207805478768946e-14,  -7.741785866071128e-16,   7.301413103475333e-18,
  -6.882828436532780e-20,   1.164695227769835e-01,  -1.098835194283197e-03,   1.036684398204950e-05,  -9.780347794611203e-08,   9.226898645046586e-10,  -8.704638967926848e-12,
   8.211799227704467e-14,  -7.746627806572161e-16,   7.307112101708814e-18,  -6.889352855595837e-20,   1.164706908950629e-01,  -1.098868247930556e-03,   1.036746762595994e-05,
  -9.781328391531092e-08,   9.228286333686907e-10,  -8.706471813138777e-12,   8.214104570928667e-14,  -7.749422880827151e-16,   7.310402066268913e-18,  -6.893119438992798e-20,
   1.164711295410794e-01,  -1.098880660189415e-03,   1.036770181852908e-05,  -9.781696633206383e-08,   9.228807458112910e-10,  -8.707160121671921e-12,   8.214970339575278e-14,
  -7.750472590519925e-16,   7.311637662385638e-18,  -6.894534057902420e-20,   1.164712022532551e-01,  -1.098882717714054e-03,   1.036774063972583e-05,  -9.781757675473048e-08,
   9.228893843715376e-10,  -8.707274221667078e-12,   8.215113857834346e-14,  -7.750646601865349e-16,   7.311842489714623e-18,  -6.894768563336826e-20,   2.420872194330264e-01,
  -2.283646045580464e-03,   2.154010331182841e-05,  -2.031556083821374e-07,   1.915895650309879e-09,  -1.806661145278966e-11,   1.703500684255678e-13,  -1.606063822533378e-15,
   1.513942618288365e-17,  -1.426329162792006e-19,   2.420902880418607e-01,  -2.283732868170330e-03,   2.154174125268712e-05,  -2.031813591308094e-07,   1.916260000275583e-09,
  -1.807142282596418e-11,   1.704105722285714e-13,  -1.606797191948784e-15,   1.514805489434247e-17,  -1.427316212688449e-19,   2.420953258288504e-01,  -2.283875409462956e-03,
   2.154443042286150e-05,  -2.032236381073391e-07,   1.916858233174208e-09,  -1.807932305976653e-11,   1.705099238960577e-13,  -1.608001502540096e-15,   1.516222536544489e-17,
  -1.428937246522115e-19,   2.421006715398764e-01,  -2.284026667610867e-03,   2.154728414632540e-05,  -2.032685061045466e-07,   1.917493131564422e-09,  -1.808770797448947e-11,
   1.706153775204061e-13,  -1.609279866725796e-15,   1.517726818843398e-17,  -1.430658147267284e-19,   2.421048788088473e-01,  -2.284145716402702e-03,   2.154953026331749e-05,
  -2.033038223315366e-07,   1.917992891937899e-09,  -1.809430850784226e-11,   1.706983945746359e-13,  -1.610286306414750e-15,   1.518911193579378e-17,  -1.432013126852959e-19,
   2.421073069727077e-01,  -2.284214424929139e-03,   2.155082663020428e-05,  -2.033242059720724e-07,   1.918281350307382e-09,  -1.809811843071293e-11,   1.707463151619853e-13,
  -1.610867286922317e-15,   1.519594918527841e-17,  -1.432795361269069e-19,   2.421082187849838e-01,  -2.284240226257708e-03,   2.155131344565568e-05,  -2.033318606013972e-07,
   1.918389676265923e-09,  -1.809954921297116e-11,   1.707643116757637e-13,  -1.611085478192876e-15,   1.519851701687239e-17,  -1.433089145173712e-19,   2.421083699315849e-01,
  -2.284244503228552e-03,   2.155139414317092e-05,  -2.033331294852737e-07,   1.918407633211947e-09,  -1.809978639185339e-11,   1.707672949534764e-13,  -1.611121647960080e-15,
   1.519894269157370e-17,  -1.433137846545985e-19,   4.455947158531620e-01,  -4.203363618990826e-03,   3.964751314294712e-05,  -3.739357481824346e-07,   3.526468570996534e-09,
  -3.325407267626945e-11,   3.135524770025679e-13,  -2.956169895096684e-15,   2.786562287805007e-17,  -2.625090681807538e-19,   4.456003640484062e-01,  -4.203523427870121e-03,
   3.965052799762048e-05,  -3.739831459617498e-07,   3.527139206649930e-09,  -3.326292863374830e-11,   3.136638401318636e-13,  -2.957519617601122e-15,   2.788149768245727e-17,
  -2.626904025882205e-19,   4.456096367860061e-01,  -4.203785794660408e-03,   3.965547778394770e-05,  -3.740609662078265e-07,   3.528240335639270e-09,  -3.327747004024754e-11,
   3.138467065099891e-13,  -2.959736077915189e-15,   2.790756796170966e-17,  -2.629882056026166e-19,   4.456194763000090e-01,  -4.204064206017855e-03,   3.966073045316029e-05,
  -3.741435519009579e-07,   3.529408952446092e-09,  -3.329290356451938e-11,   3.140408041027090e-13,  -2.962088827682216e-15,   2.793524307458529e-17,  -2.633043515115366e-19,
   4.456272203553370e-01,  -4.204283331639810e-03,   3.966486473937292e-05,  -3.742085562529392e-07,   3.530328829356316e-09,  -3.330505270288553e-11,   3.141936049976959e-13,
  -2.963941116107541e-15,   2.795703260922932e-17,  -2.635532714219150e-19,   4.456316897238062e-01,  -4.204409799102075e-03,   3.966725088032873e-05,  -3.742460751346681e-07,
   3.530859776200027e-09,  -3.331206536032379e-11,   3.142818074520790e-13,  -2.965010373399174e-15,   2.796961141430522e-17,  -2.636969726301744e-19,   4.456333680393035e-01,
  -4.204457289984450e-03,   3.966814693089767e-05,  -3.742601645281577e-07,   3.531059164852892e-09,  -3.331469890071244e-11,   3.143149317666430e-13,  -2.965411940319292e-15,
   2.797433556849962e-17,  -2.637509423039250e-19,   4.456336462453439e-01,  -4.204465162335624e-03,   3.966829546573615e-05,  -3.742625000826920e-07,   3.531092217053157e-09,
  -3.331513545921763e-11,   3.143204227761294e-13,  -2.965478508431346e-15,   2.797511870096466e-17,  -2.637598889951597e-19,   4.276044350304539e-03,  -3.887003832488416e-05,
   3.533072173348971e-07,  -3.211107224120815e-09,   2.918245604337911e-11,  -2.651878048121114e-13,   2.409626181033971e-15,  -2.189317861206519e-17,   1.988950279326201e-19,
  -1.806455626753708e-21,   4.276094678684286e-03,  -3.887141055265225e-05,   3.533321638032220e-07,  -3.211485159638676e-09,   2.918760909934768e-11,  -2.652533800323781e-13,
   2.410420888602891e-15,  -2.190246460081065e-17,   1.990004727742842e-19,  -1.807624398977870e-21,   4.276177303438006e-03,  -3.887366340343624e-05,   3.533731206527937e-07,
  -3.212105669486863e-09,   2.919606990225024e-11,  -2.653610524508394e-13,   2.411725833753409e-15,  -2.191771338815609e-17,   1.991736361987109e-19,  -1.809543879158497e-21,
   4.276264978185327e-03,  -3.887605401102669e-05,   3.534165833642214e-07,  -3.212764170187398e-09,   2.920504913670009e-11,  -2.654753285069717e-13,   2.413110894757858e-15,
  -2.193389942192154e-17,   1.993574557114696e-19,  -1.811581617506104e-21,   4.276333981204864e-03,  -3.887793554674280e-05,   3.534507918808777e-07,  -3.213282480169892e-09,
   2.921211704976085e-11,  -2.655652841326204e-13,   2.414201244393552e-15,  -2.194664218263586e-17,   1.995021803830523e-19,  -1.813186068119547e-21,   4.276373805212039e-03,
  -3.887902146389008e-05,   3.534705355412967e-07,  -3.213581633643942e-09,   2.921619656503843e-11,  -2.656172072089590e-13,   2.414830626507008e-15,  -2.195399798988228e-17,
   1.995857269756350e-19,  -1.814112324571857e-21,   4.276388759714644e-03,  -3.887942924528963e-05,   3.534779497196239e-07,  -3.213693973785298e-09,   2.921772855516412e-11,
  -2.656367063386532e-13,   2.415066988436603e-15,  -2.195676049206709e-17,   1.996171039290941e-19,  -1.814460199154686e-21,   4.276391238647631e-03,  -3.887949684135312e-05,
   3.534791787383366e-07,  -3.213712596037478e-09,   2.921798250928709e-11,  -2.656399386775475e-13,   2.415106170006602e-15,  -2.195721843340898e-17,   1.996223053391848e-19,
  -1.814517867304567e-21,   3.907827207635337e-02,  -3.552287602372148e-04,   3.228833574785626e-06,  -2.934593551613403e-08,   2.666950722309472e-10,  -2.423520505722644e-12,
   2.202129311024765e-14,  -2.000791921171672e-16,   1.817677408934354e-18,  -1.650893580038318e-20,   3.907873202156342e-02,  -3.552413008672172e-04,   3.229061557658684e-06,
  -2.934938942487571e-08,   2.667421654094061e-10,  -2.424119789966786e-12,   2.202855584552343e-14,  -2.001640554031688e-16,   1.818641042268906e-18,  -1.651961639546278e-20,
   3.907948711957963e-02,  -3.552618894085581e-04,   3.229435857544150e-06,  -2.935506019220938e-08,   2.668194877019231e-10,  -2.425103795565398e-12,   2.204048157961134e-14,
  -2.003034118265548e-16,   1.820223538221622e-18,  -1.653715718207249e-20,   3.908028836890011e-02,  -3.552837368933343e-04,   3.229833058209716e-06,  -2.936107815352400e-08,
   2.669015478799725e-10,  -2.426148151033022e-12,   2.205313948263050e-14,  -2.004513336037338e-16,   1.821903417254791e-18,  -1.655577863988515e-20,   3.908091897947162e-02,
  -3.553009320294486e-04,   3.230145685865415e-06,  -2.936581492817140e-08,   2.669661407144037e-10,  -2.426970244939659e-12,   2.206310405447549e-14,  -2.005677878135468e-16,
   1.823226018513957e-18,  -1.657044058036649e-20,   3.908128292644224e-02,  -3.553108560999812e-04,   3.230326120882041e-06,  -2.936854885697734e-08,   2.670034229294788e-10,
  -2.427444763840976e-12,   2.206885590054770e-14,  -2.006350114495641e-16,   1.823989529118403e-18,  -1.657890498143059e-20,   3.908141959390257e-02,  -3.553145827667725e-04,
   3.230393878195597e-06,  -2.936957552046333e-08,   2.670174236088415e-10,  -2.427622964098919e-12,   2.207101598327856e-14,  -2.006602575488435e-16,   1.824276274935171e-18,
  -1.658208396021099e-20,   3.908144224858287e-02,  -3.553152005193364e-04,   3.230405110054693e-06,  -2.936974570706012e-08,   2.670197444659990e-10,  -2.427652504064738e-12,
   2.207137405884864e-14,  -2.006644426070920e-16,   1.824323809268657e-18,  -1.658261094845978e-20,   1.122253547403170e-01,  -1.020149344210718e-03,   9.272595078379919e-06,
  -8.427593771063587e-08,   7.658974535868423e-10,  -6.959889288027991e-12,   6.324095746692204e-14,  -5.745891962065897e-16,   5.220016098350385e-18,  -4.741018309129575e-20,
   1.122266756153613e-01,  -1.020185358511654e-03,   9.273249801770451e-06,  -8.428585667867734e-08,   7.660326962210082e-10,  -6.961610317799978e-12,   6.326181462857885e-14,
  -5.748329055593384e-16,   5.222783373954509e-18,  -4.744085132957663e-20,   1.122288441130515e-01,  -1.020244484881186e-03,   9.274324719753541e-06,  -8.430214204235039e-08,
   7.662547511100542e-10,  -6.964436193743187e-12,   6.329606301466879e-14,  -5.752331076256451e-16,   5.227327842808448e-18,  -4.749121787177769e-20,   1.122311451484977e-01,
  -1.020307226696492e-03,   9.275465404415463e-06,  -8.431942448100617e-08,   7.664904123034007e-10,  -6.967435382966311e-12,   6.333241404699251e-14,  -5.756579075484230e-16,
   5.232151966504628e-18,  -4.754468740022146e-20,   1.122329561419560e-01,  -1.020356607852505e-03,   9.276363211500551e-06,  -8.433302759558059e-08,   7.666759106145386e-10,
  -6.969796279478619e-12,   6.336103035644805e-14,  -5.759923392864404e-16,   5.235950091620960e-18,  -4.758678756199160e-20,   1.122340013283400e-01,  -1.020385107892982e-03,
   9.276881386503216e-06,  -8.434087891837996e-08,   7.667829780314061e-10,  -6.971159007031777e-12,   6.337754853792492e-14,  -5.761853912743101e-16,   5.238142671102760e-18,
  -4.761109215158591e-20,   1.122343938112570e-01,  -1.020395810170243e-03,   9.277075972602903e-06,  -8.434382730036315e-08,   7.668231853144390e-10,  -6.971670764099122e-12,
   6.338375187472997e-14,  -5.762578927017978e-16,   5.238966121287709e-18,  -4.762022023415939e-20,   1.122344588711841e-01,  -1.020397584237952e-03,   9.277108228363042e-06,
  -8.434431604385369e-08,   7.668298503739115e-10,  -6.971755597232637e-12,   6.338478019801073e-14,  -5.762699112988968e-16,   5.239102625998505e-18,  -4.762173342192554e-20,
   2.332825383058438e-01,  -2.120581654824325e-03,   1.927491805716608e-05,  -1.751841614687545e-07,   1.592068942933288e-09,  -1.446750272507437e-11,   1.314587967217268e-13,
  -1.194396459428196e-15,   1.085080505439118e-17,  -9.855010487191682e-20,   2.332852840051898e-01,  -2.120656517653286e-03,   1.927627902888796e-05,  -1.752047800003334e-07,
   1.592350071407244e-09,  -1.447108022325089e-11,   1.315021523266590e-13,  -1.194903050197668e-15,   1.085655700694032e-17,  -9.861383754468712e-20,   2.332897916554141e-01,
  -2.120779423476092e-03,   1.927851345796056e-05,  -1.752386323409946e-07,   1.592811656265097e-09,  -1.447695436103287e-11,   1.315733441551206e-13,  -1.195734937260446e-15,
   1.086600296181416e-17,  -9.871850576779220e-20,   2.332945748115099e-01,  -2.120909844716149e-03,   1.928088459604862e-05,  -1.752745572986769e-07,   1.593301524508231e-09,
  -1.448318876446240e-11,   1.316489067349601e-13,  -1.196617955005725e-15,   1.087603019198270e-17,  -9.882962220651213e-20,   2.332983393186641e-01,  -2.121012493190239e-03,
   1.928275086518174e-05,  -1.753028340555128e-07,   1.593687119312568e-09,  -1.448809635120419e-11,   1.317083912115126e-13,  -1.197313127291221e-15,   1.088392481949873e-17,
  -9.891711152378824e-20,   2.333005119447450e-01,  -2.121071736146512e-03,   1.928382799414307e-05,  -1.753191545786118e-07,   1.593909680043127e-09,  -1.449092904786126e-11,
   1.317427274129798e-13,  -1.197714418102240e-15,   1.088848222427230e-17,  -9.896761939560971e-20,   2.333013277979124e-01,  -2.121093982941015e-03,   1.928423247973647e-05,
  -1.753252833721272e-07,   1.593993258806358e-09,  -1.449199283535787e-11,   1.317556222356508e-13,  -1.197865124427805e-15,   1.089019381343621e-17,  -9.898658864267735e-20,
   2.333014630378052e-01,  -2.121097670690715e-03,   1.928429952969688e-05,  -1.753262993218761e-07,   1.594007113446252e-09,  -1.449216917767428e-11,   1.317577598023740e-13,
  -1.197890107088866e-15,   1.089047754641453e-17,  -9.898973322722895e-20,   4.293884931775963e-01,  -3.903221252809428e-03,   3.547812914208394e-05,  -3.224504656733506e-07,
   2.930421145855750e-09,  -2.662942170768898e-11,   2.419679051735121e-13,  -2.198448458792688e-15,   1.997228966480473e-17,  -1.813900653809720e-19,   4.293935470136589e-01,
  -3.903359048109283e-03,   3.548063419711296e-05,  -3.224884169066821e-07,   2.930938601278574e-09,  -2.663600657721665e-11,   2.420477066616517e-13,  -2.199380881600925e-15,
   1.998287550458446e-17,  -1.815073082761729e-19,   4.294018439618643e-01,  -3.903585273125659e-03,   3.548474697013775e-05,  -3.225507267794392e-07,   2.931788211366925e-09,
  -2.664681872267912e-11,   2.421787442446978e-13,  -2.200912039289884e-15,   2.000025973964462e-17,  -1.816998558337258e-19,   4.294106480163962e-01,  -3.903825331297795e-03,
   3.548911137484680e-05,  -3.226168515878854e-07,   2.932689880894893e-09,  -2.665829398573785e-11,   2.423178267441621e-13,  -2.202537306953371e-15,   2.001871373106204e-17,
  -1.819042647726002e-19,   4.294175771079013e-01,  -3.904014269886722e-03,   3.549254649903203e-05,  -3.226688988344142e-07,   2.933399620890805e-09,  -2.666732706310074e-11,
   2.424273154540139e-13,  -2.203816829178109e-15,   2.003324289470701e-17,  -1.820652088974317e-19,   4.294215761240553e-01,  -3.904123314669523e-03,   3.549452910254829e-05,
  -3.226989389940429e-07,   2.933809274366720e-09,  -2.667254102452065e-11,   2.424905155782015e-13,  -2.204555438090907e-15,   2.004163027479647e-17,  -1.821581222532954e-19,
   4.294230778136577e-01,  -3.904164262944680e-03,   3.549527361373363e-05,  -3.227102198785103e-07,   2.933963112515852e-09,  -2.667449906931876e-11,   2.425142501309193e-13,
  -2.204832825524372e-15,   2.004478025717064e-17,  -1.821930176912860e-19,   4.294233267412209e-01,  -3.904171050753566e-03,   3.549539702837761e-05,  -3.227120898732675e-07,
   2.933988613876193e-09,  -2.667482365120772e-11,   2.425181845929257e-13,  -2.204878808173509e-15,   2.004530243493207e-17,  -1.821988024023666e-19,   4.125983767473512e-03,
  -3.619015976078074e-05,   3.174100608041981e-07,  -2.783672034948179e-09,   2.441083396294838e-11,  -2.140495449994819e-13,   1.876778671020322e-15,  -1.645426469195069e-17,
   1.442475995165749e-19,  -1.264330914858929e-21,   4.126028979217917e-03,  -3.619134924943010e-05,   3.174309265908259e-07,  -2.783977059315682e-09,   2.441484700112682e-11,
  -2.140988216949335e-13,   1.877354919541238e-15,  -1.646076243485781e-17,   1.443188220182288e-19,  -1.265093768205128e-21,   4.126103203765619e-03,  -3.619330208183606e-05,
   3.174651836363798e-07,  -2.784477856923982e-09,   2.442143594283586e-11,  -2.141797314165615e-13,   1.878301130113239e-15,  -1.647143236004455e-17,   1.444357824036651e-19,
  -1.266346581740110e-21,   4.126181964672826e-03,  -3.619537431610161e-05,   3.175015363801843e-07,  -2.785009310867295e-09,   2.442842852911667e-11,  -2.142656019849155e-13,
   1.879305411832214e-15,  -1.648275782064602e-17,   1.445599368794016e-19,  -1.267676547676723e-21,   4.126243952038960e-03,  -3.619700526815266e-05,   3.175301486214266e-07,
  -2.785427617860263e-09,   2.443393260739797e-11,  -2.143331964053887e-13,   1.880095988997827e-15,  -1.649167380253553e-17,   1.446576836551918e-19,  -1.268723697006545e-21,
   4.126279727009245e-03,  -3.619794655967302e-05,   3.175466622838385e-07,  -2.785669051029011e-09,   2.443710946984761e-11,  -2.143722120126339e-13,   1.880552327596827e-15,
  -1.649682050659925e-17,   1.447141098860402e-19,  -1.269328211460846e-21,   4.126293161026836e-03,  -3.619830003103040e-05,   3.175528635132403e-07,  -2.785759715369544e-09,
   2.443830247968229e-11,  -2.143868638093703e-13,   1.880723702601086e-15,  -1.649875335622627e-17,   1.447353012672410e-19,  -1.269555247452381e-21,   4.126295387916011e-03,
  -3.619835862433834e-05,   3.175538914655341e-07,  -2.785774744481412e-09,   2.443850024164160e-11,  -2.143892926097042e-13,   1.880752111269444e-15,  -1.649907376485408e-17,
   1.447388141881666e-19,  -1.269592883753864e-21,   3.770688585969982e-02,  -3.307376616703591e-04,   2.900773635566236e-06,  -2.543965502716799e-08,   2.230877729557532e-10,
  -1.956173900028419e-12,   1.715166196810418e-14,  -1.503736077021482e-16,   1.318261829824364e-18,  -1.155456345052044e-20,   3.770729904457449e-02,  -3.307485322688055e-04,
   2.900964325563834e-06,  -2.544244260939136e-08,   2.231244476448601e-10,  -1.956624234005393e-12,   1.715692823543895e-14,  -1.504329897654792e-16,   1.318912721178881e-18,
  -1.156153494862005e-20,   3.770797737408470e-02,  -3.307663789770778e-04,   2.901277396719544e-06,  -2.544701934049591e-08,   2.231846632166968e-10,  -1.957363658521933e-12,
   1.716557554235898e-14,  -1.505305008826780e-16,   1.319981603908776e-18,  -1.157298405138329e-20,   3.770869716085695e-02,  -3.307853168850601e-04,   2.901609620217866e-06,
  -2.545187623628110e-08,   2.232485676493201e-10,  -1.958148419638397e-12,   1.717475355463757e-14,  -1.506340028557399e-16,   1.321116232275839e-18,  -1.158513822629324e-20,
   3.770926365618782e-02,  -3.308002219661990e-04,   2.901871104163382e-06,  -2.545569909524492e-08,   2.232988687804818e-10,  -1.958766157169246e-12,   1.718197854617949e-14,
  -1.507154849026593e-16,   1.322009524772945e-18,  -1.159470782077466e-20,   3.770959059948115e-02,  -3.308088243199451e-04,   2.902022020603861e-06,  -2.545790552489785e-08,
   2.233279017568663e-10,  -1.959122716256703e-12,   1.718614897085014e-14,  -1.507625199892642e-16,   1.322525195262511e-18,  -1.160023230288084e-20,   3.770971337140574e-02,
  -3.308120546535766e-04,   2.902078692918249e-06,  -2.545873409576262e-08,   2.233388045349706e-10,  -1.959256617319443e-12,   1.718771514681464e-14,  -1.507801840609293e-16,
   1.322718859975754e-18,  -1.160230711881700e-20,   3.770973372268695e-02,  -3.308125901310043e-04,   2.902088087254726e-06,  -2.545887144506825e-08,   2.233406118585124e-10,
  -1.959278813842624e-12,   1.718797477028629e-14,  -1.507831122354138e-16,   1.322750964009712e-18,  -1.160265106603255e-20,   1.082869947138243e-01,  -9.498155735856656e-04,
   8.330469413707657e-06,  -7.305784412095637e-08,   6.406655956185512e-10,  -5.617758871443309e-12,   4.925630613417922e-14,  -4.318443366721048e-16,   3.785795567191785e-18,
  -3.318244281592964e-20,   1.082881813020911e-01,  -9.498467918740408e-04,   8.331017039062778e-06,  -7.306584952618320e-08,   6.407709183398268e-10,  -5.619052144775835e-12,
   4.927142984526562e-14,  -4.320148703039811e-16,   3.787664785105119e-18,  -3.320246279153611e-20,   1.082901293352530e-01,  -9.498980442211984e-04,   8.331916119795820e-06,
  -7.307899302623812e-08,   6.409438459921974e-10,  -5.621175631026529e-12,   4.929626325438675e-14,  -4.322949030925449e-16,   3.790734382867201e-18,  -3.323534104896144e-20,
   1.082921964257757e-01,  -9.499524302860990e-04,   8.332870202409172e-06,  -7.309294110589597e-08,   6.411273673500758e-10,  -5.623429315348420e-12,   4.932262074757381e-14,
  -4.325921404391170e-16,   3.793992787529560e-18,  -3.327024404444387e-20,   1.082938232924740e-01,  -9.499952348403779e-04,   8.333621134499611e-06,  -7.310391962874390e-08,
   6.412718226173260e-10,  -5.625203339772588e-12,   4.934336953926182e-14,  -4.328261408778899e-16,   3.796558128171306e-18,  -3.329772492496406e-20,   1.082947622113443e-01,
  -9.500199391619729e-04,   8.334054537773782e-06,  -7.311025607447369e-08,   6.413551997952473e-10,  -5.626227309497655e-12,   4.935534620000848e-14,  -4.329612164095134e-16,
   3.798039020951453e-18,  -3.331358950587878e-20,   1.082951147889292e-01,  -9.500292160649284e-04,   8.334217289867145e-06,  -7.311263557218891e-08,   6.413865104971807e-10,
  -5.626611847823010e-12,   4.935984395735015e-14,  -4.330119441541040e-16,   3.798595183608398e-18,  -3.331954772635060e-20,   1.082951732339328e-01,  -9.500307538541163e-04,
   8.334244268612304e-06,  -7.311303001323532e-08,   6.413917007861303e-10,  -5.626675592006047e-12,   4.936058954622511e-14,  -4.330203532961166e-16,   3.798687379364693e-18,
  -3.332053543482502e-20,   2.250958800781347e-01,  -1.974379037973993e-03,   1.731652401192082e-05,  -1.518651409822279e-07,   1.331749823093590e-09,  -1.167761999641847e-11,
   1.023889474039411e-13,  -8.976735456337580e-16,   7.869517724950229e-18,  -6.897600951765629e-20,   2.250983466359233e-01,  -1.974443931344751e-03,   1.731766235925019e-05,
  -1.518817817961683e-07,   1.331968757142908e-09,  -1.168030831984952e-11,   1.024203849987514e-13,  -8.980280320910335e-16,   7.873403192626968e-18,  -6.901762170465502e-20,
   2.251023960071350e-01,  -1.974550469458767e-03,   1.731953127591334e-05,  -1.519091031537685e-07,   1.332328221375414e-09,  -1.168472240440223e-11,   1.024720061019477e-13,
  -8.986101332756240e-16,   7.879783840738206e-18,  -6.908596023160246e-20,   2.251066928625574e-01,  -1.974663521623294e-03,   1.732151452483479e-05,  -1.519380969887873e-07,
   1.332709706714202e-09,  -1.168940713129435e-11,   1.025267953120167e-13,  -8.992279973762070e-16,   7.886556953249897e-18,  -6.915850720471021e-20,   2.251100746259185e-01,
  -1.974752499333333e-03,   1.732307548531934e-05,  -1.519609180141906e-07,   1.333009985478469e-09,  -1.169309479058189e-11,   1.025699257377066e-13,  -8.997144115796411e-16,
   7.891889421323569e-18,  -6.921562705118631e-20,   2.251120263540093e-01,  -1.974803852139141e-03,   1.732397639952113e-05,  -1.519740895665905e-07,   1.333183301387462e-09,
  -1.169522331339890e-11,   1.025948215717614e-13,  -8.999951916344254e-16,   7.894967691990790e-18,  -6.924860205440042e-20,   2.251127592560717e-01,  -1.974823136011970e-03,
   1.732431471185290e-05,  -1.519790358219799e-07,   1.333248386856914e-09,  -1.169602265207003e-11,   1.026041710409153e-13,  -9.001006388506145e-16,   7.896123764292626e-18,
  -6.926098639075115e-20,   2.251128807455411e-01,  -1.974826332610154e-03,   1.732437079249675e-05,  -1.519798557455038e-07,   1.333259175896189e-09,  -1.169615515691336e-11,
   1.026057208933539e-13,  -9.001181188434775e-16,   7.896315407793894e-18,  -6.926303937173184e-20,   4.143198263751690e-01,  -3.634115293128177e-03,   3.187343641978923e-05,
  -2.795286116316749e-07,   2.451268122178296e-09,  -2.149426044391281e-11,   1.884608887265243e-13,  -1.652290870158705e-15,   1.448490719453619e-17,  -1.269589003503415e-19,
   4.143243664129269e-01,  -3.634234738273486e-03,   3.187553170410762e-05,  -2.795592413309486e-07,   2.451671100297082e-09,  -2.149920867059625e-11,   1.885187538483050e-13,
  -1.652943346130061e-15,   1.449205866781086e-17,  -1.270354809728046e-19,   4.143318198357829e-01,  -3.634430836277966e-03,   3.187897170144026e-05,  -2.796095300349758e-07,
   2.452332743475062e-09,  -2.150733339647040e-11,   1.886137694313233e-13,  -1.654014774988192e-15,   1.450380269177250e-17,  -1.271612470744328e-19,   4.143397287872569e-01,
  -3.634638924285442e-03,   3.188262214296839e-05,  -2.796628971629630e-07,   2.453034919516576e-09,  -2.151595627654335e-11,   1.887146163401120e-13,  -1.655152029833442e-15,
   1.451626907045557e-17,  -1.272947580024794e-19,   4.143459533863394e-01,  -3.634802699958993e-03,   3.188549530473590e-05,  -2.797049023886487e-07,   2.453587623729708e-09,
  -2.152274391741750e-11,   1.887940036877269e-13,  -1.656047334936947e-15,   1.452608384184049e-17,  -1.273998777034997e-19,   4.143495458094589e-01,  -3.634897221838193e-03,
   3.188715356083270e-05,  -2.797291464364687e-07,   2.453906635409812e-09,  -2.152666175454186e-11,   1.888398278173965e-13,  -1.656564145107472e-15,   1.453174960815168e-17,
  -1.274605627418935e-19,   4.143508948161806e-01,  -3.634932716449821e-03,   3.188777627105934e-05,  -2.797382506975725e-07,   2.454026434135037e-09,  -2.152813304660130e-11,
   1.888570367722968e-13,  -1.656758233654406e-15,   1.453387743759695e-17,  -1.274833540562541e-19,   4.143511184342044e-01,  -3.634938600227009e-03,   3.188787949517257e-05,
  -2.797397598792177e-07,   2.454046292840250e-09,  -2.152837693987312e-11,   1.888598894840659e-13,  -1.656790407727077e-15,   1.453423017044397e-17,  -1.274871322263856e-19,
   3.986099094257571e-03,  -3.377816598179123e-05,   2.862156847227752e-07,  -2.425047069955355e-09,   2.054547939842731e-11,  -1.740530862423896e-13,   1.474403938590127e-15,
  -1.248879170788232e-17,   1.057774264896506e-19,  -8.957780855029271e-22,   3.986139860166166e-03,  -3.377920216407878e-05,   2.862332452215795e-07,  -2.425295076084882e-09,
   2.054863169629515e-11,  -1.740904820054097e-13,   1.474826431964522e-15,  -1.249339439398754e-17,   1.058261730316386e-19,  -8.962827440496692e-22,   3.986206785813883e-03,
  -3.378090330165499e-05,   2.862620755702889e-07,  -2.425702256791686e-09,   2.055380735596545e-11,  -1.741518831551601e-13,   1.475520163763999e-15,  -1.250095231924479e-17,
   1.059062221334122e-19,  -8.971115127400269e-22,   3.986277801560601e-03,  -3.378270844429525e-05,   2.862926694462487e-07,  -2.426134359334539e-09,   2.055930001790695e-11,
  -1.742170480495645e-13,   1.476256457879262e-15,  -1.250897440571203e-17,   1.059911927235335e-19,  -8.979912946484934e-22,   3.986333693109117e-03,  -3.378412917648553e-05,
   2.863167489046392e-07,  -2.426474464208925e-09,   2.056362341404186e-11,  -1.742683429610565e-13,   1.476836063579609e-15,  -1.251528967205297e-17,   1.060580884220805e-19,
  -8.986839731940424e-22,   3.986365949929316e-03,  -3.378494913905891e-05,   2.863306463995262e-07,  -2.426670760577248e-09,   2.056611878800021e-11,  -1.742979501853019e-13,
   1.477170620835639e-15,  -1.251893507432464e-17,   1.060967046190171e-19,  -8.990838460255427e-22,   3.986378062821136e-03,  -3.378525704887566e-05,   2.863358651923306e-07,
  -2.426744474687658e-09,   2.056705587441072e-11,  -1.743090687348794e-13,   1.477296260898150e-15,  -1.252030409874404e-17,   1.061112071583777e-19,  -8.992340238950813e-22,
   3.986380070713462e-03,  -3.378530808963673e-05,   2.863367302896028e-07,  -2.426756694008109e-09,   2.056721121246445e-11,  -1.743109118327902e-13,   1.477317088090110e-15,
  -1.252053104150333e-17,   1.061136112554250e-19,  -8.992589191685315e-22,   3.642849609770988e-02,  -3.086947310035853e-04,   2.615691860005918e-06,  -2.216222317499001e-08,
   1.877627470832079e-10,  -1.590650915192533e-12,   1.347440613165460e-14,  -1.141336144432744e-16,   9.666875622702096e-19,  -8.186409959662471e-21,   3.642886865260806e-02,
  -3.087042005530186e-04,   2.615852343362462e-06,  -2.216448967416804e-08,   1.877915555668295e-10,  -1.590992670719909e-12,   1.347826724931084e-14,  -1.141756778464929e-16,
   9.671330507264896e-19,  -8.191021951011443e-21,   3.642948027832007e-02,  -3.087197470515102e-04,   2.616115820566768e-06,  -2.216821085129798e-08,   1.878388553186590e-10,
  -1.591553808683650e-12,   1.348460718328701e-14,  -1.142447488302440e-16,   9.678646092965677e-19,  -8.198595931377903e-21,   3.643012928297124e-02,  -3.087362440401880e-04,
   2.616395414441543e-06,  -2.217215978618950e-08,   1.878890521173793e-10,  -1.592149343071855e-12,   1.349133608929928e-14,  -1.143180617281968e-16,   9.686411447170999e-19,
  -8.206636112845745e-21,   3.643064006933375e-02,  -3.087492279464646e-04,   2.616615473811685e-06,  -2.217526796508696e-08,   1.879285631318714e-10,  -1.592618121299937e-12,
   1.349663303816779e-14,  -1.143757761991127e-16,   9.692524959969257e-19,  -8.212966387393714e-21,   3.643093486066257e-02,  -3.087567214890732e-04,   2.616742481401382e-06,
  -2.217706189477049e-08,   1.879513680642798e-10,  -1.592888698277576e-12,   1.349969051789475e-14,  -1.144090910985651e-16,   9.696054045068912e-19,  -8.216620758914639e-21,
   3.643104555897236e-02,  -3.087595354410831e-04,   2.616790175341951e-06,  -2.217773555945358e-08,   1.879599319880080e-10,  -1.592990309408543e-12,   1.350083872776633e-14,
  -1.144216024505249e-16,   9.697379413683426e-19,  -8.217993209553889e-21,   3.643106390886684e-02,  -3.087600018966632e-04,   2.616798081365324e-06,  -2.217784723040225e-08,
   1.879613516044161e-10,  -1.593007153265908e-12,   1.350102906504353e-14,  -1.144236764535123e-16,   9.697599121052658e-19,  -8.218220723327664e-21,   1.046157027934601e-01,
  -8.865124749030828e-04,   7.511768849629416e-06,  -6.364568404619906e-08,   5.392188492057564e-10,  -4.568046479543936e-12,   3.869592806413068e-14,  -3.277699987745860e-16,
   2.776142324208543e-18,  -2.350979872135977e-20,   1.046167727001727e-01,  -8.865396696455292e-04,   7.512229727264497e-06,  -6.365219300017006e-08,   5.393015816838190e-10,
  -4.569027936314774e-12,   3.870701645762707e-14,  -3.278907967940637e-16,   2.777421678850757e-18,  -2.352304332485807e-20,   1.046185291727302e-01,  -8.865843162282846e-04,
   7.512986383614624e-06,  -6.366287951216680e-08,   5.394374175623039e-10,  -4.570639417650777e-12,   3.872522353881212e-14,  -3.280891553998402e-16,   2.779522570190036e-18,
  -2.354479409432793e-20,   1.046203929904820e-01,  -8.866316924378285e-04,   7.513789323972829e-06,  -6.367422010107694e-08,   5.395815732076817e-10,  -4.572349678965192e-12,
   3.874454767348458e-14,  -3.282996959681099e-16,   2.781752626096633e-18,  -2.356788368674702e-20,   1.046218598716332e-01,  -8.866689797438016e-04,   7.514421292572395e-06,
  -6.368314619889917e-08,   5.396950413159826e-10,  -4.573695920734481e-12,   3.875975950034589e-14,  -3.284654408479615e-16,   2.783508305842645e-18,  -2.358606280982228e-20,
   1.046227064561850e-01,  -8.866904997709887e-04,   7.514786034180728e-06,  -6.368829802328560e-08,   5.397605327384011e-10,  -4.574472966269574e-12,   3.876853999896366e-14,
  -3.285611148428247e-16,   2.784521789148242e-18,  -2.359655734141511e-20,   1.046230243606476e-01,  -8.866985809052291e-04,   7.514923002094478e-06,  -6.369023265995196e-08,
   5.397851266962518e-10,  -4.574764774080865e-12,   3.877183743871419e-14,  -3.285970450434671e-16,   2.784902408747596e-18,  -2.360049871030394e-20,   1.046230770580497e-01,
  -8.866999204768163e-04,   7.514945706687860e-06,  -6.369055335764811e-08,   5.397892035641938e-10,  -4.574813146430477e-12,   3.877238405107082e-14,  -3.286030011818351e-16,
   2.784965504349666e-18,  -2.360115207857578e-20,   2.174643755930204e-01,  -1.842791059682794e-03,   1.561469338602553e-05,  -1.323001095502683e-07,   1.120872748685134e-09,
  -9.495585733447887e-12,   8.043711966747249e-14,  -6.813345835046013e-16,   5.770758526135201e-18,  -4.886970982987145e-20,   2.174665996051808e-01,  -1.842847589319623e-03,
   1.561565141110644e-05,  -1.323136396950997e-07,   1.121044724460607e-09,  -9.497625884899904e-12,   8.046016907672689e-14,  -6.815856857729133e-16,   5.773417904122972e-18,
  -4.889724073969695e-20,   2.174702507798876e-01,  -1.842940396049224e-03,   1.561722427059424e-05,  -1.323358537183823e-07,   1.121327086129036e-09,  -9.500975666657712e-12,
   8.049801608001823e-14,  -6.819980128607123e-16,   5.777784999727936e-18,  -4.894245299561083e-20,   2.174741250927564e-01,  -1.843038876846574e-03,   1.561889334052318e-05,
  -1.323594273695572e-07,   1.121626742074102e-09,  -9.504530782080374e-12,   8.053818509888528e-14,  -6.824356625328366e-16,   5.782420587888452e-18,  -4.899044818979989e-20,
   2.174771742945980e-01,  -1.843116385867634e-03,   1.562020701192454e-05,  -1.323779820247062e-07,   1.121862607919922e-09,  -9.507329211089672e-12,   8.056980587621089e-14,
  -6.827801956195425e-16,   5.786070096389965e-18,  -4.902823622889922e-20,   2.174789340875930e-01,  -1.843161119489356e-03,   1.562096519930929e-05,  -1.323886911079789e-07,
   1.121998744760253e-09,  -9.508944453475011e-12,   8.058805787144515e-14,  -6.829790726928577e-16,   5.788176810822266e-18,  -4.905005068772623e-20,   2.174795949147310e-01,
  -1.843177917721024e-03,   1.562124991413740e-05,  -1.323927126319300e-07,   1.122049868153048e-09,  -9.509551033557970e-12,   8.059491224922111e-14,  -6.830537606280868e-16,
   5.788967999774219e-18,  -4.905824341404259e-20,   2.174797044566768e-01,  -1.843180702284823e-03,   1.562129711011364e-05,  -1.323933792653546e-07,   1.122058342727268e-09,
  -9.509651585026110e-12,   8.059604849063031e-14,  -6.830661416242509e-16,   5.789099155771399e-18,  -4.905960153795914e-20,   4.002729961437306e-01,  -3.391909579279964e-03,
   2.874098384364738e-05,  -2.435164890575394e-07,   2.063119957708276e-09,  -1.747792730747974e-11,   1.480555450963980e-13,  -1.254089643828829e-15,   1.062186878063572e-17,
  -8.995123761489908e-20,   4.002770897430086e-01,  -3.392013629826370e-03,   2.874274722014727e-05,  -2.435413931439690e-07,   2.063436502697362e-09,  -1.748168248571400e-11,
   1.480979706794229e-13,  -1.254551831081458e-15,   1.062676368246315e-17,  -9.000190976251057e-20,   4.002838102306073e-01,  -3.392184453335362e-03,   2.874564228366249e-05,
  -2.435822810991738e-07,   2.063956228054037e-09,  -1.748784821793456e-11,   1.481676332533973e-13,  -1.255310774133304e-15,   1.063480184146602e-17,  -9.008512537623039e-20,
   4.002909414345838e-01,  -3.392365720743920e-03,   2.874871443568440e-05,  -2.436256716359074e-07,   2.064507785897517e-09,  -1.749439189489184e-11,   1.482415698137044e-13,
  -1.256116326771064e-15,   1.064333419237306e-17,  -9.017346311190842e-20,   4.002965539085978e-01,  -3.392508386723131e-03,   2.875113242799367e-05,  -2.436598240223935e-07,
   2.064941929319020e-09,  -1.749954278684355e-11,   1.482997721689080e-13,  -1.256750485896310e-15,   1.065005154605503e-17,  -9.024301401005499e-20,   4.002997930488605e-01,
  -3.392590725086581e-03,   2.875252797581744e-05,  -2.436795355582804e-07,   2.065192507835152e-09,  -1.750251586172696e-11,   1.483333674564984e-13,  -1.257116545687334e-15,
   1.065392920391433e-17,  -9.028316467519456e-20,   4.003010093918029e-01,  -3.392621644534887e-03,   2.875305203249097e-05,  -2.436869377244290e-07,   2.065286607447533e-09,
  -1.750363235546533e-11,   1.483459838740185e-13,  -1.257254018797650e-15,   1.065538548101689e-17,  -9.029824381975358e-20,   4.003012110187716e-01,  -3.392626769906304e-03,
   2.875313890315546e-05,  -2.436881647546366e-07,   2.065302206063072e-09,  -1.750381743421702e-11,   1.483480752813624e-13,  -1.257276807673039e-15,   1.065562688918333e-17,
  -9.030074351831863e-20  };
  static constexpr double xi[15700] = {  -2.370420182479634e-03,   1.679400936860043e-04,  -7.646586886888106e-06,   2.751583960413899e-07,  -8.255032064824676e-09,
   2.041581824368310e-10,  -3.737161284839675e-12,   2.133173587159243e-14,   2.098681242897575e-15,  -1.253463997501661e-16,   4.322078062089934e-18,  -1.016184908854366e-19,
   1.693915399377484e-21,  -1.683969704699505e-23,  -2.255351672170345e-03,   1.597960902673960e-04,  -7.276130968608556e-06,   2.618353359202052e-07,  -7.855164334499598e-09,
   1.942405407996626e-10,  -3.553604205681740e-12,   2.015885191718913e-14,   2.002409985887056e-15,  -1.194160264061737e-16,   4.115161300688335e-18,  -9.671317271779343e-20,
   1.610357498438680e-21,  -1.590283766634886e-23,  -2.036385137658900e-03,   1.442952605749215e-04,  -6.570882194140790e-06,   2.364686891224667e-07,  -7.093894994233846e-09,
   1.753707937201237e-10,  -3.205174759807839e-12,   1.798263883882297e-14,   1.816936147932420e-15,  -1.080681888943482e-16,   3.720233378458796e-18,  -8.736710150001901e-20,
   1.451874101582029e-21,  -1.416796057879630e-23,  -1.734822747445022e-03,   1.229407736521144e-04,  -5.599027262893676e-06,   2.015066362022400e-07,  -6.044788556580031e-09,
   1.493887092630028e-10,  -2.726999336409980e-12,   1.509372835920039e-14,   1.557081036704668e-15,  -9.231808185321152e-17,   3.174049577354565e-18,  -7.447346333000539e-20,
   1.234639121087915e-21,  -1.187221757302241e-23,  -1.380085910185026e-03,   9.781246648332429e-05,  -4.455070042337493e-06,   1.603456847675762e-07,  -4.809834468622028e-09,
   1.188323225565370e-10,  -2.166648547319311e-12,   1.183266665806324e-14,   1.245805602716172e-15,  -7.363657086193718e-17,   2.528670216576926e-18,  -5.927884532237554e-20,
   9.804327026957990e-22,  -9.291121705742274e-24,  -1.006879926616683e-03,   7.136805037293564e-05,  -3.250867984062270e-06,   1.170099931856921e-07,  -3.509784803591374e-09,
   8.669183762628108e-11,  -1.579128186759345e-12,   8.530057685546038e-15,   9.130970369262198e-16,  -5.383863033373197e-17,   1.847004126386494e-18,  -4.326809257720086e-20,
   7.142623052633206e-22,  -6.687969688885669e-24,  -6.517901522557169e-04,   4.620182089931765e-05,  -2.104640031344024e-06,   7.575568422059696e-08,  -2.272283921658584e-09,
   5.611638322057336e-11,  -1.021537365312881e-12,   5.477811266616495e-15,   5.928719126952523e-16,  -3.490091704253054e-17,   1.196548793482936e-18,  -2.801730575453787e-20,
   4.619194009544501e-22,  -4.290465880398803e-24,  -3.496567712639980e-04,   2.478598338611911e-05,  -1.129111466048816e-06,   4.064258152465858e-08,  -1.219055344077477e-09,
   3.010330549278814e-11,  -5.478196171294640e-13,   2.926475151722411e-15,   3.185432146265446e-16,  -1.873636423250966e-17,   6.421479129151556e-19,  -1.503232334083139e-20,
   2.476751827603199e-22,  -2.290906677230376e-24,  -1.301193367531542e-04,   9.223814212479470e-06,  -4.201896605797392e-07,   1.512489224383195e-08,  -4.536622085897063e-10,
   1.120239085026089e-11,  -2.038379040103746e-13,   1.087470791300550e-15,   1.186048359889669e-16,  -6.974202812291764e-18,   2.389980123306160e-19,  -5.594338896821876e-21,
   9.215233631953343e-23,  -8.511329417691650e-25,  -1.469803622550106e-05,   1.041906464148633e-06,  -4.746398588826959e-08,   1.708486391924129e-09,  -5.124500596650527e-11,
   1.265399502941432e-12,  -2.302470525937854e-14,   1.228104902423644e-16,   1.339852572219562e-17,  -7.878243425370821e-19,   2.699735222161205e-20,  -6.319312809380203e-22,
   1.040906561665325e-23,  -9.611741494710790e-26,  -1.577004304672001e-02,   6.739761938667739e-04,  -6.568530624931152e-06,  -5.136544963749044e-07,   2.440760324259908e-08,
  -2.423610674789794e-10,  -1.942323546599061e-11,   9.247994514223671e-13,  -8.944086726897652e-15,  -7.370439594944842e-16,   3.261366786207149e-17,  -2.060643888524056e-19,
  -2.631708909068030e-20,   9.689129365115114e-22,  -1.500317184358976e-02,   6.411478214338789e-04,  -6.244702568402987e-06,  -4.887404612956964e-07,   2.321172011694783e-08,
  -2.299988953269631e-10,  -1.848568118704436e-11,   8.790259144835565e-13,  -8.465833957743790e-15,  -7.015096945092641e-16,   3.097559191825231e-17,  -1.938291472426596e-19,
  -2.504612610928286e-20,   9.192389801535091e-22,  -1.354441918386337e-02,   5.787232134784693e-04,  -5.630508112502875e-06,  -4.413223465783964e-07,   2.094054262149567e-08,
  -2.067184911281167e-10,  -1.669937165282625e-11,   7.922805173287089e-13,  -7.573801634909542e-15,  -6.337861727978123e-16,   2.788079180120658e-17,  -1.714636797116584e-19,
  -2.262453111042531e-20,   8.257871099986028e-22,  -1.153646936806296e-02,   4.928393141995863e-04,  -4.788558410390393e-06,  -3.760012928880305e-07,   1.782137862464484e-08,
  -1.751284997440050e-10,  -1.423500730960109e-11,   6.735086517113082e-13,  -6.380168815586982e-15,  -5.403191181040201e-16,   2.366191610741122e-17,  -1.424314896370655e-19,
  -1.928395330074223e-20,   6.991668927110634e-22,  -9.175794396944107e-03,   3.919225775880838e-04,  -3.803108865555721e-06,  -2.991417364705581e-07,   1.416325150977320e-08,
  -1.385643283549855e-10,  -1.133080693986519e-11,   5.346732116843624e-13,  -5.020047955239298e-15,  -4.301284651068602e-16,   1.875395232165034e-17,  -1.105066277430203e-19,
  -1.534789642349942e-20,   5.528560275136530e-22,  -6.693458420254573e-03,   2.858551975558397e-04,  -2.770972597301316e-06,  -2.182618222927651e-07,   1.032495926555547e-08,
  -1.006509690660501e-10,  -8.270536335192608e-12,   3.894295384919782e-13,  -3.629967083098021e-15,  -3.139816682534258e-16,   1.364157791436264e-17,  -7.898305648915386e-20,
  -1.120143508053939e-20,   4.013855559613912e-22,  -4.332493776248294e-03,   1.850091052382134e-04,  -1.792173845541065e-06,  -1.412950762415813e-07,   6.680201425522364e-09,
  -6.496596956180105e-11,  -5.355448965006455e-12,   2.518112965600313e-13,  -2.335911078937203e-15,  -2.033233027569294e-16,   8.813202670896313e-18,  -5.042890207892025e-20,
  -7.252713242370730e-21,   2.589906906419401e-22,  -2.324075050082713e-03,   9.923950093770353e-05,  -9.609879324993457e-07,  -7.580030557098627e-08,   3.582664233468876e-09,
  -3.479932854244562e-11,  -2.873409977311313e-12,   1.350083691578495e-13,  -1.249288306640057e-15,  -1.090935464945057e-16,   4.723077898209986e-18,  -2.686042658665310e-20,
  -3.891194436295502e-21,   1.387054868662253e-22,  -8.648532206377619e-04,   3.692917572252644e-05,  -3.575604540418534e-07,  -2.820812701414937e-08,   1.333107180035273e-09,
  -1.294328857493773e-11,  -1.069352686469687e-12,   5.023125213860323e-14,  -4.644079930991631e-16,  -4.059998868570178e-17,   1.756996040734615e-18,  -9.970779928099455e-21,
  -1.448102860562743e-21,   5.158709072088498e-23,  -9.769192497750618e-05,   4.171427781778488e-06,  -4.038834948179181e-08,  -3.186341071087985e-09,   1.505830340269706e-10,
  -1.461928777983999e-12,  -1.207931091257137e-13,   5.673848498296963e-15,  -5.244977981798192e-17,  -4.586143684676633e-18,   1.984557914480861e-19,  -1.125834175572484e-21,
  -1.635759701078096e-22,   5.826643232789314e-24,  -2.362855138499308e-02,   2.158084886050967e-05,   2.678213983885689e-05,  -2.184856426638212e-08,  -3.047559241931848e-08,
   1.344856269200402e-11,   3.542346004082938e-11,  -5.970654691764215e-16,  -4.237741610431785e-14,   1.768001038536971e-17,   4.838120253644994e-17,  -4.040215213411693e-20,
  -5.119624867093722e-20,   4.250788491237531e-23,  -2.247846258527868e-02,   2.052920827376054e-05,   2.547404982072126e-05,  -2.078184551354975e-08,  -2.897758608856170e-08,
   1.279413419266643e-11,   3.366554006990914e-11,  -5.495483231276973e-16,  -4.025224308989840e-14,   1.675491494793425e-17,   4.592901541996543e-17,  -3.833978343399330e-20,
  -4.856676538744606e-20,   4.033853026306859e-23,  -2.029118429611361e-02,   1.852965840603283e-05,   2.298811254052313e-05,  -1.875445067114612e-08,  -2.613459649205712e-08,
   1.154946916970516e-11,   3.033604032139986e-11,  -4.667706058958609e-16,  -3.623608640979188e-14,   1.502197120287451e-17,   4.130525493272207e-17,  -3.445675351543049e-20,
  -4.362250008680172e-20,   3.625400175905742e-23,  -1.728127542436745e-02,   1.577904422702273e-05,   1.957077102354958e-05,  -1.596713136493014e-08,  -2.223392143898196e-08,
   9.836575094346089e-12,   2.578095959060187e-11,  -3.674886197895254e-16,  -3.075886950124202e-14,   1.268831811199836e-17,   3.501950033246320e-17,  -2.918912702819713e-20,
  -3.692773204465040e-20,   3.071276974560090e-23,  -1.374370167591835e-02,   1.254743958168946e-05,   1.555882914437484e-05,  -1.269442892107763e-08,  -1.766402294002295e-08,
   7.823227849364049e-12,   2.046094769876382e-11,  -2.691786719264200e-16,  -2.438373032819843e-14,   1.000985824091149e-17,   2.772871440193529e-17,  -2.309352746675828e-20,
  -2.919629853876884e-20,   2.430003260299057e-23,  -1.002480942617526e-02,   9.151334117514334e-06,   1.134543874687703e-05,  -9.257024298237262e-09,  -1.287348237106809e-08,
   5.706509175333489e-12,   1.489950998608866e-11,  -1.828367588123568e-16,  -1.773967179375603e-14,   7.253784662255855e-18,   2.015411375789382e-17,  -1.677410997311553e-20,
  -2.119539077181728e-20,   1.765115845872091e-23,  -6.488446349219664e-03,   5.922710696266374e-06,   7.341778992444638e-06,  -5.990464915011409e-09,  -8.327580261424562e-09,
   3.693545851401248e-12,   9.632891787494716e-12,  -1.125816162316609e-16,  -1.146212595115695e-14,   4.674650381048930e-18,   1.301400913100042e-17,  -1.082673699692517e-20,
  -1.367554018649662e-20,   1.139314603600415e-23,  -3.480496644520339e-03,   3.176920829832151e-06,   3.937842810127086e-06,  -3.213085382013967e-09,  -4.465757711918084e-09,
   1.981291667191330e-12,   5.164291102681493e-12,  -5.880744791853464e-17,  -6.143034990312551e-15,   2.501970179122957e-18,   6.972508298486787e-18,  -5.799331731732525e-21,
  -7.323951000367402e-21,   6.102821765006898e-24,  -1.295177843133577e-03,   1.182196004798216e-06,   1.465316522391476e-06,  -1.195630429855251e-09,  -1.661652196437608e-09,
   7.372896799932156e-13,   1.921379324794634e-12,  -2.167884239818971e-17,  -2.285272334214269e-15,   9.303219114672290e-19,   2.593554097622134e-18,  -2.157000309544670e-21,
  -2.723893179686043e-21,   2.269892602104580e-24,  -1.463002338671280e-04,   1.335378234900152e-07,   1.655177835219461e-07,  -1.350549270037878e-10,  -1.876933483984791e-10,
   8.328255049067192e-14,   2.170276728878093e-13,  -2.445120044969276e-18,  -2.581264069731015e-16,   1.050740231531170e-19,   2.929422792776131e-19,  -2.436304414239738e-22,
  -3.076571669537332e-22,   2.563817054650244e-25,  -1.656916899398296e-02,  -6.254776049858993e-04,  -3.387856699213579e-06,   5.203799936203283e-07,   1.948532931942836e-08,
   7.110663964521456e-11,  -1.791053378252076e-11,  -6.319633120898732e-13,  -1.206647441065119e-15,   6.494312690303382e-16,   2.033671667341975e-17,  -1.077429187834197e-19,
  -2.169808245252766e-20,  -4.666254511407547e-22,  -1.576333477227577e-02,  -5.950077169586206e-04,  -3.219613994901425e-06,   4.950884754469947e-07,   1.852956608720667e-08,
   6.725670509027715e-11,  -1.704021043699671e-11,  -6.005306307020799e-13,  -1.121094108628403e-15,   6.176564456178878e-16,   1.930514634022461e-17,  -1.035600353001955e-19,
  -2.062581417643673e-20,  -4.421384366377837e-22,  -1.423050799179971e-02,  -5.370694234600658e-04,  -2.901004106570995e-06,   4.469728859295707e-07,   1.671484359964533e-08,
   6.009333067426289e-11,  -1.538438043372676e-11,  -5.410243870654965e-13,  -9.693583007955825e-16,   5.572904782974546e-16,   1.736025729261334e-17,  -9.516805642927828e-20,
  -1.859294792021516e-20,  -3.962926571362329e-22,  -1.212067743253568e-02,  -4.573608084944763e-04,  -2.465200878761148e-06,   3.807315939845693e-07,   1.422338897220749e-08,
   5.054272687504471e-11,  -1.310462596922468e-11,  -4.596680932954202e-13,  -7.817558938564111e-16,   4.743483879248556e-16,   1.471679535509615e-17,  -8.277840674953785e-20,
  -1.580810069719426e-20,  -3.346057026780527e-22,  -9.640327502531233e-03,  -3.637040539036379e-04,  -1.956330947090361e-06,   3.028404439530668e-07,   1.130248008528642e-08,
   3.970549935458923e-11,  -1.042377425948325e-11,  -3.647200919217845e-13,  -5.879906323744650e-16,   3.770306690787697e-16,   1.165149152021177e-17,  -6.715995982907099e-20,
  -1.255118814291753e-20,  -2.638732433298142e-22,  -7.032244529621708e-03,  -2.652707284181680e-04,  -1.424485253709055e-06,   2.209225629661403e-07,   8.238688397914837e-09,
   2.867355097655574e-11,  -7.604219556515910e-12,  -2.655307530515686e-13,  -4.091107715198279e-16,   2.748819809860650e-16,   8.467790944463713e-18,  -4.976332036194841e-20,
  -9.142599837218705e-21,  -1.911599196221233e-22,  -4.551748138917217e-03,  -1.716853694383622e-04,  -9.209199882379583e-07,   1.430013412444152e-07,   5.330061005456619e-09,
   1.843553624188658e-11,  -4.922169023128484e-12,  -1.716479547194994e-13,  -2.563493163617610e-16,   1.778589141759320e-16,   5.467460433557626e-18,  -3.253956741090469e-20,
  -5.912123429554956e-21,  -1.231656323548458e-22,  -2.441680434343881e-03,  -9.209227239112476e-05,  -4.937022538858588e-07,   7.671120135577397e-08,   2.858477738471683e-09,
   9.855195654522535e-12,  -2.640438173616462e-12,  -9.201554056174745e-14,  -1.351861008207753e-16,   9.539076181803728e-17,   2.929183769516267e-18,  -1.754564147290968e-20,
  -3.169877619599686e-21,  -6.591354268422348e-23,  -9.086163021982544e-04,  -3.426949357965000e-05,  -1.836807801127500e-07,   2.854652778286764e-08,   1.063625966119511e-09,
   3.662970282264088e-12,  -9.825864449171516e-13,  -3.423360124200809e-14,  -5.000526909916248e-17,   3.549524209320875e-17,   1.089549315611595e-18,  -6.540930428596192e-21,
  -1.179398095525980e-21,  -2.450806312958078e-23,  -1.026352858930949e-04,  -3.870995935094095e-06,  -2.074746843846445e-08,   3.224555882319752e-09,   1.201431843317443e-10,
   4.136818190973211e-13,  -1.109909134025673e-13,  -3.866810081222471e-15,  -5.643086553289423e-18,   4.009423098682550e-18,   1.230644687080839e-19,  -7.390589616061323e-22,
  -1.332186047767232e-22,  -2.768014956697849e-24,  -4.091522908556760e-03,  -2.542234033827675e-04,  -9.826735611604935e-06,  -2.840783852154097e-07,  -6.081119716269118e-09,
  -7.066257107979860e-11,   1.362099962840572e-12,   1.202572332227938e-13,   4.606223077590155e-15,   1.286489005208588e-16,   2.204264380557930e-18,  -1.377553709623353e-20,
  -1.957773204354536e-21,  -5.868650203764518e-23,  -3.892803630410795e-03,  -2.418832700714868e-04,  -9.349843176181981e-06,  -2.702814936608910e-07,  -5.784709863655052e-09,
  -6.714979231674460e-11,   1.299698046152981e-12,   1.145454060431787e-13,   4.385092071468793e-15,   1.223675322348835e-16,   2.093166877009765e-18,  -1.324269051554968e-20,
  -1.866116918804995e-21,  -5.591377793936387e-23,  -3.514697754598335e-03,  -2.184006298815858e-04,  -8.442299428638544e-06,  -2.440297710683405e-07,  -5.221155310176705e-09,
  -6.049875024078625e-11,   1.179440641467172e-12,   1.036249322713617e-13,   3.963282962158969e-15,   1.104290378449130e-16,   1.883414683400570e-18,  -1.217365341029723e-20,
  -1.690327731251613e-21,  -5.060626296305341e-23,  -2.994048212932829e-03,  -1.860595520715427e-04,  -7.192318809507835e-06,  -2.078809724309932e-07,  -4.445977044184832e-09,
  -5.140394131238462e-11,   1.010888794797969e-12,   8.848577494407420e-14,   3.380406599673246e-15,   9.401560019846260e-17,   1.597765012008699e-18,  -1.059437641043409e-20,
  -1.445563360129283e-21,  -4.323640306538637e-23,  -2.381694902775826e-03,  -1.480150171574750e-04,  -5.721797839728128e-06,  -1.653647946148401e-07,  -3.535321770839952e-09,
  -4.078793726747086e-11,   8.089012155298520e-13,   7.055143886568900e-14,   2.692286178188688e-15,   7.474432737330427e-17,   1.265838798425310e-18,  -8.600869388244023e-21,
  -1.154262715296083e-21,  -3.449106601118330e-23,  -1.737555203079542e-03,  -1.079890152279521e-04,  -4.174593200863951e-06,  -1.206413667793962e-07,  -2.578384911511454e-09,
  -2.969625297911960e-11,   5.929309400020448e-13,   5.156629335830279e-14,   1.966051943533375e-15,   5.450401264266868e-17,   9.204577080946634e-19,  -6.376708756456641e-21,
  -8.446453983280756e-22,  -2.521995913395057e-23,  -1.124750295190212e-03,  -6.990547118264683e-05,  -2.702408050359451e-06,  -7.809337331859720e-08,  -1.668694325859058e-09,
  -1.919705301288386e-11,   3.850130257501640e-13,   3.342073538671183e-14,   1.273474003514586e-15,   3.527049367994513e-17,   5.945310789411059e-19,  -4.171420838188732e-21,
  -5.478483700515716e-22,  -1.634971981020622e-23,  -6.033701061448570e-04,  -3.750127827618443e-05,  -1.449734540162718e-06,  -4.189305820712137e-08,  -8.950740988282532e-10,
  -1.029109492479223e-11,   2.068696820489070e-13,   1.793976964585501e-14,   6.833765493425593e-16,   1.891776911455311e-17,   3.185773040732785e-19,  -2.249786817946036e-21,
  -2.941937395798080e-22,  -8.777486681230662e-24,  -2.245336485915003e-04,  -1.395552670458376e-05,  -5.394976668625982e-07,  -1.558977258825421e-08,  -3.330740519347970e-10,
  -3.828727992934776e-12,   7.702571182567233e-14,   6.677433026290947e-15,   2.543356335236009e-16,   7.039525847189957e-18,   1.185066285031384e-19,  -8.387782803247930e-22,
  -1.095181230597023e-22,  -3.267257148562615e-24,  -2.536287891926490e-05,  -1.576390272607971e-06,  -6.094067097736565e-08,  -1.760990066067709e-09,  -3.762317150874910e-11,
  -4.324690261398967e-13,   8.701439479253510e-15,   7.542958770790317e-16,   2.872977191989384e-17,   7.951639592558795e-19,   1.338544451536785e-20,  -9.477469767017132e-23,
  -1.237165174329343e-23,  -3.690785050461773e-25,  -1.802892133307797e-03,   1.180097008488214e-04,  -5.017422881278782e-06,   1.711663063456441e-07,  -4.995161418385494e-09,
   1.260539018367952e-10,  -2.684361421939382e-12,   4.220417067550616e-14,  -1.866030343209288e-16,  -2.136114455025236e-17,   1.304023341665016e-18,  -4.269779025639884e-20,
   8.210934807076402e-22,  -1.180748159967062e-23,  -1.715349350720675e-03,   1.122850085900225e-04,  -4.774267742414269e-06,   1.628782772241411e-07,  -4.753392760524882e-09,
   1.199488374344008e-10,  -2.553938451844056e-12,   4.012800114364299e-14,  -1.757687973726114e-16,  -2.039221219899119e-17,   1.242212740328394e-18,  -4.064842203077076e-20,
   7.817299315052971e-22,  -1.123956621108720e-23,  -1.548771956280006e-03,   1.013897672388593e-04,  -4.311396132712657e-06,   1.470982551455552e-07,  -4.293034754287562e-09,
   1.083256296031765e-10,  -2.305798139855401e-12,   3.618827597628489e-14,  -1.558722932099144e-16,  -1.852077180571032e-17,   1.123986110621127e-18,  -3.673914814858687e-20,
   7.066207924961261e-22,  -1.015660395639404e-23,  -1.319379284564610e-03,   8.638167063670075e-05,  -3.673603792650524e-06,   1.253493311463749e-07,  -3.658462569435902e-09,
   9.230695852522122e-11,  -1.964145870780451e-12,   3.078400679567887e-14,  -1.298694951548719e-16,  -1.588978619910308e-17,   9.599878749266487e-19,  -3.133686733192297e-20,
   6.027874434593795e-22,  -8.660871826855406e-24,  -1.049561884255019e-03,   6.872329122344381e-05,  -2.922941985102873e-06,   9.974446648788167e-08,  -2.911283384207105e-09,
   7.344971031699880e-11,  -1.562365237587288e-12,   2.445422823941601e-14,  -1.010559296504286e-16,  -1.272694301693638e-17,   7.655822077070927e-19,  -2.495869749451569e-20,
   4.801511403790054e-22,  -6.896179342213862e-24,  -7.657190316383861e-04,   5.014189615106505e-05,  -2.132817360662793e-06,   7.278696428373350e-08,  -2.124538469262619e-09,
   5.359765202952472e-11,  -1.139776357627666e-12,   1.782059501585850e-14,  -7.239973567903840e-17,  -9.336037411776323e-18,   5.596647288768525e-19,  -1.822671002190157e-20,
   3.506718066392080e-22,  -5.034913995680482e-24,  -4.956702269843403e-04,   3.245992733618022e-05,  -1.380780619351550e-06,   4.712434309903187e-08,  -1.375518403647329e-09,
   3.470015179195806e-11,  -7.377797389732094e-13,   1.152706394210751e-14,  -4.629831874089918e-17,  -6.065269717117951e-18,   3.627676773206550e-19,  -1.180625960027847e-20,
   2.271580855978359e-22,  -3.260805318546563e-24,  -2.659031797251588e-04,   1.741366785450761e-05,  -7.407639439901701e-07,   2.528197994154516e-08,  -7.379677115384656e-10,
   1.861632694761508e-11,  -3.957755573646162e-13,   6.181319733804720e-15,  -2.468027186085739e-17,  -3.259733171961700e-18,   1.947401503379907e-19,  -6.335590562815520e-21,
   1.219030825144212e-22,  -1.749693814431886e-24,  -9.895146480275620e-05,   6.480270513183752e-06,  -2.756684368733115e-07,   9.408534609612911e-09,  -2.746313219585685e-10,
   6.927934966023809e-12,  -1.472803175500948e-13,   2.299965460473290e-15,  -9.164073575565239e-18,  -1.213834019617645e-18,   7.248652214948069e-20,  -2.357957316798006e-21,
   4.536987260396468e-23,  -6.511748951633257e-25,  -1.117736696345060e-05,   7.319999999648642e-07,  -3.113907275638633e-08,   1.062774696665664e-09,  -3.102198420943895e-11,
   7.825693719702293e-13,  -1.663648314801819e-14,   2.597941072305847e-16,  -1.034792551350767e-18,  -1.371263053641312e-19,   8.188246313459589e-21,  -2.663551984129358e-22,
   5.124994884860627e-24,  -7.355645278496009e-26,  -1.320954345633156e-02,   6.029189698619016e-04,  -1.060911891424977e-05,  -1.792475227732230e-07,   1.675550711000910e-08,
  -4.463929762596256e-10,   8.777983184008857e-14,   4.326259079898558e-13,  -1.636578173796479e-14,   1.734026493078420e-16,   1.085435987049535e-17,  -5.215692544014123e-19,
   6.289860291262045e-21,   2.277259981418166e-22,  -1.256733790789774e-02,   5.735765515697994e-04,  -1.009009906201820e-05,  -1.706607425521862e-07,   1.594050103262089e-08,
  -4.244093304503636e-10,   6.997051391243567e-14,   4.117626061132038e-13,  -1.555512604264039e-14,   1.641206191739809e-16,   1.033837866469923e-17,  -4.956625336690981e-19,
   5.951316687260553e-21,   2.173405031806425e-22,  -1.134566383603088e-02,   5.177705401691970e-04,  -9.104079444741177e-06,  -1.542740023963400e-07,   1.439026416801263e-08,
  -3.827039233417765e-10,   4.161529559757307e-14,   3.720039282780516e-13,  -1.401908713631081e-14,   1.468109115115662e-16,   9.351966885049130e-18,  -4.466012670296537e-19,
   5.320654621120278e-21,   1.973001597344669e-22,  -9.663928520772963e-03,   4.409729384764920e-04,  -7.749295289761730e-06,  -1.316155522583115e-07,   1.225654819546322e-08,
  -3.255147340678648e-10,   1.327421031221597e-14,   3.171379350046425e-13,  -1.191641075034399e-14,   1.236553502895128e-16,   7.984762883318963e-18,  -3.794956706467024e-19,
   4.478349985777582e-21,   1.691674787585607e-22,  -7.686619856757788e-03,   3.507081504001272e-04,  -6.159632750711564e-06,  -1.048474129419559e-07,   9.748229799450867e-09,
  -2.585551615327421e-10,  -6.540068447598199e-15,   2.524601288011403e-13,  -9.459157297676778e-15,   9.727965882914505e-17,   6.365594677010428e-18,  -3.011451344310017e-19,
   3.520677443758056e-21,   1.354074965142925e-22,  -5.607265391649112e-03,   2.558132701253910e-04,  -4.490942901695629e-06,  -7.657923448752380e-08,   7.110853429443774e-09,
  -1.884019945611344e-10,  -1.480720819697786e-14,   1.842887220062012e-13,  -6.889083183636157e-15,   7.033309463040167e-17,   4.652105109866637e-18,  -2.192660656890118e-19,
   2.543990840188791e-21,   9.927557228895070e-23,  -3.629479204945905e-03,   1.655734987151374e-04,  -2.905873613026860e-06,  -4.960881696807901e-08,   4.602584072097770e-09,
  -1.218593568371933e-10,  -1.387338677478602e-14,   1.193390903790034e-13,  -4.454373408542118e-15,   4.525575743846944e-17,   3.014841931018332e-18,  -1.417491828052671e-19,
   1.636298547607684e-21,   6.447121355011652e-23,  -1.946971094522627e-03,   8.881635558367333e-05,  -1.558521518484782e-06,  -2.662293985914971e-08,   2.468937502230859e-09,
  -6.534460179255984e-11,  -8.623059951170641e-15,   6.403177837509419e-14,  -2.388147534120664e-15,   2.420245189620363e-17,   1.618253965782637e-18,  -7.598986867844767e-20,
   8.749058440056142e-22,   3.464268801691266e-23,  -7.245240455077539e-04,   3.305077893764297e-05,  -5.799339918578214e-07,  -9.908607172665532e-09,   9.187577445644349e-10,
  -2.431340534812170e-11,  -3.361809069487688e-15,   2.382993186093836e-14,  -8.885270189700756e-16,   8.996820051822660e-18,   6.023275467142934e-19,  -2.827166658871478e-20,
   3.252075651052108e-22,   1.289907385015714e-23,  -8.184067993177600e-05,   3.733338791652848e-06,  -6.550743889268956e-08,  -1.119280867278576e-09,   1.037808109169633e-10,
  -2.746332613987559e-12,  -3.824836047193237e-16,   2.691811281375905e-15,  -1.003630293656375e-16,   1.016089230208800e-18,   6.803993039195906e-20,  -3.193392829973456e-21,
   3.672811428811658e-23,   1.457186621202934e-24,  -2.312668476063814e-02,   2.268096129733287e-04,   2.374642333497026e-05,  -4.637438074711512e-07,  -2.244966457739951e-08,
   7.232728280935556e-10,   1.896082440641116e-11,  -1.016317682315627e-12,  -1.322889041885227e-14,   1.301767743458916e-15,   5.128650130025912e-18,  -1.447910393342540e-18,
   5.166058254340794e-21,   1.429893069328373e-21,  -2.200109508385706e-02,   2.157365674045740e-04,   2.258740549385890e-05,  -4.409740589352960e-07,  -2.134929194217478e-08,
   6.874645632919839e-10,   1.802759124046751e-11,  -9.655064331485824e-13,  -1.257849340668427e-14,   1.236112963471167e-15,   4.888849238649421e-18,  -1.374221842393119e-18,
   4.871570237045236e-21,   1.356347009801742e-21,  -1.986038100561980e-02,   1.946910535040981e-04,   2.038444389412788e-05,  -3.977502922809227e-07,  -1.925968523326286e-08,
   6.196096418708576e-10,   1.625694404480740e-11,  -8.694209018658362e-13,  -1.134416786755768e-14,   1.112187095086453e-15,   4.428679638180514e-18,  -1.235396321848015e-18,
   4.329334375879960e-21,   1.218096839206942e-21,  -1.691449273818251e-02,   1.657566860130223e-04,   1.735546902295191e-05,  -3.384260623716539e-07,  -1.639022530591689e-08,
   5.267114235851909e-10,   1.382851207184951e-11,  -7.382591525515867e-13,  -9.650716778331203e-15,   9.434660023350433e-16,   3.787589070702997e-18,  -1.046901989306334e-18,
   3.617396995060858e-21,   1.030978503285881e-21,  -1.345209178387584e-02,   1.317831437812045e-04,   1.379866946163063e-05,  -2.688987641110227e-07,  -1.302536451077443e-08,
   4.181292146929220e-10,   1.098466319175612e-11,  -5.854421986991219e-13,  -7.666874092348074e-15,   7.474510896517358e-16,   3.024341919420602e-18,  -8.285637553422344e-19,
   2.823463509667356e-21,   8.149881482562771e-22,  -9.812158966484097e-03,   9.609929854092954e-05,   1.006253167399605e-05,  -1.959912398076100e-07,  -9.495155799938271e-09,
   3.045413768930063e-10,   8.004656986176190e-12,  -4.260363610290431e-13,  -5.587422612988192e-15,   5.435099856005413e-16,   2.213023850778997e-18,  -6.020023596533010e-19,
   2.028283544702471e-21,   5.915681120838865e-22,  -6.350833386430558e-03,   6.218859980866521e-05,   6.511847516148186e-06,  -1.267905288302399e-07,  -6.143201284091058e-09,
   1.969201697148058e-10,   5.177642264774250e-12,  -2.753237953239319e-13,  -3.614305998475378e-15,   3.510597380852470e-16,   1.435341417580543e-18,  -3.886318622085373e-19,
   1.299515535580169e-21,   3.816520312055915e-22,  -3.406685303851044e-03,   3.335594618921500e-05,   3.492770045429370e-06,  -6.799503401887962e-08,  -3.294632234479851e-09,
   1.055782946719352e-10,   2.776458196324754e-12,  -1.475711167240732e-13,  -1.938189466103333e-15,   1.881151284968127e-16,   7.707568885640893e-19,  -2.081906321293636e-19,
   6.934350556543405e-22,   2.043843809351823e-22,  -1.267711648781032e-03,   1.241218443505033e-05,   1.299708899738968e-06,  -2.530038064022158e-08,  -1.225926392014924e-09,
   3.928146046583366e-11,   1.033070841037005e-12,  -5.489972796487439e-14,  -7.211729344314790e-16,   6.997655194668122e-17,   2.869233230523263e-19,  -7.743695054279065e-20,
   2.575728261609669e-22,   7.601251073806134e-23,  -1.431977318459278e-04,   1.402044295594187e-06,   1.468114029029127e-07,  -2.857831292229371e-09,  -1.384761981607788e-10,
   4.437019185110595e-12,   1.166911464069852e-13,  -6.201073306781022e-15,  -8.146065385447307e-17,   7.903925931362895e-18,   3.241207793407033e-20,  -8.746452415257726e-21,
   2.908637439374715e-23,   8.585406987705023e-24,  -1.907833801278509e-02,  -6.223749339101687e-04,   4.682650593814658e-06,   8.143996396137474e-07,   1.526336012630686e-08,
  -5.488451672876374e-10,  -3.166850119093448e-11,  -1.699511462458636e-13,   3.240076381715222e-14,   1.002052748141145e-15,  -1.222544963954458e-17,  -1.354800031736182e-18,
  -1.764461950135696e-20,   9.681477135266411e-22,  -1.815021817724349e-02,  -5.920300901145565e-04,   4.457573298471990e-06,   7.746234908094957e-07,   1.450692563053252e-08,
  -5.222502889908532e-10,  -3.010125870385475e-11,  -1.606272542722758e-13,   3.080815297759215e-14,   9.511187765902519e-16,  -1.166425323765590e-17,  -1.286659942219229e-18,
  -1.668114623995954e-20,   9.208575518856560e-22,  -1.638488743206224e-02,  -5.343401824263586e-04,   4.028354724419442e-06,   6.990311665446247e-07,   1.307381652286538e-08,
  -4.716218131546873e-10,  -2.713112946877076e-11,  -1.433251778736050e-13,   2.778552429292561e-14,   8.551333507703649e-16,  -1.058291377031121e-17,  -1.157961866131467e-18,
  -1.489182459295798e-20,   8.309719797394599e-22,  -1.395523084759312e-02,  -4.549938507463427e-04,   3.435464114641599e-06,   5.951160559090006e-07,   1.111237541813147e-08,
  -4.018571291946940e-10,  -2.306429630779411e-11,  -1.203473265964137e-13,   2.363827826805342e-14,   7.247544857528730e-16,  -9.067943602949415e-18,  -9.825919149216144e-19,
  -1.251248348626531e-20,   7.073975369051543e-22,  -1.109914110750853e-02,  -3.617887886078147e-04,   2.735798405879964e-06,   4.731196251373024e-07,   8.820544669461275e-09,
  -3.197432059842996e-10,  -1.831025416675444e-11,  -9.438918103444758e-14,   1.877950467169579e-14,   5.736720297033977e-16,  -7.253701183869391e-18,  -7.786688708009406e-19,
  -9.820220952854790e-21,   5.623304737519378e-22,  -8.096204006882294e-03,  -2.638544290550102e-04,   1.997631246427778e-06,   3.449971288979948e-07,   6.423785155251844e-09,
  -2.333109489355947e-10,  -1.333652720229961e-11,  -6.807342611193335e-14,   1.368625579083961e-14,   4.168468167037981e-16,  -5.315445254529578e-18,  -5.663359611641666e-19,
  -7.086399291998170e-21,   4.100085407115965e-22,  -5.240334692012250e-03,  -1.707604419115543e-04,   1.293846121747902e-06,   2.232520834352610e-07,   4.153441544118519e-09,
  -1.510448115768693e-10,  -8.623720381779005e-12,  -4.372888440549377e-14,   8.853249872660400e-15,   2.691178448701361e-16,  -3.450792199432938e-18,  -3.658560002016756e-19,
  -4.553945789995025e-21,   2.653013664772557e-22,  -2.811034636432154e-03,  -9.159385759721730e-05,   6.942860552114313e-07,   1.197436757496687e-07,   2.226787148897057e-09,
  -8.103276015469509e-11,  -4.623630624836502e-12,  -2.336575900762140e-14,   4.747624675679610e-15,   1.441711007513799e-16,  -1.853918850419454e-18,  -1.960580179180928e-19,
  -2.433826333971404e-21,   1.422911414922051e-22,  -1.046060263591099e-03,  -3.408372724532752e-05,   2.583929524367395e-07,   4.455799614074723e-08,   8.284892189221388e-10,
  -3.015558087541177e-11,  -1.720273505578101e-12,  -8.683183168532159e-15,   1.766527395861315e-15,   5.362529895283148e-17,  -6.902588997880882e-19,  -7.293305461958706e-20,
  -9.045246654992005e-22,   5.294734470583006e-23,  -1.181605999627084e-04,  -3.850006938281628e-06,   2.918803456632687e-08,   5.033138323599535e-09,   9.358145102923262e-11,
  -3.406326767424397e-12,  -1.943127956436460e-13,  -9.806206455621131e-16,   1.995395448281893e-16,   6.056951920010608e-18,  -7.797665342653297e-20,  -8.237899044894546e-21,
  -1.021521568285265e-22,   5.980759216688411e-24,  -5.289687850358040e-03,  -3.482158742655275e-04,  -1.385636722896255e-05,  -3.894013230004864e-07,  -6.788471020406101e-09,
   2.391063243099605e-11,   7.593176410594518e-12,   3.553917567439953e-13,   1.032628305916192e-14,   1.627997863375207e-16,  -1.971558585360477e-18,  -2.209182992904156e-19,
  -7.645962802318916e-21,  -1.680320826790164e-22,  -5.032809411738293e-03,  -3.313132550038387e-04,  -1.318359151750047e-05,  -3.704529201915649e-07,  -6.454858523294552e-09,
   2.297030028306921e-11,   7.232421868983427e-12,   3.382771103515599e-13,   9.821248547024985e-15,   1.545162068263748e-16,  -1.890718614880151e-18,  -2.105600913175905e-19,
  -7.279006138790693e-21,  -1.596904863501976e-22,  -4.544029478486407e-03,  -2.991484514597820e-04,  -1.190340643609334e-05,  -3.344139918387040e-07,  -5.821674188679860e-09,
   2.109131854242811e-11,   6.542735334581630e-12,   3.056527752162730e-13,   8.861709858485197e-15,   1.389073557469259e-16,  -1.730845014162584e-18,  -1.906996179776642e-19,
  -6.578945830580687e-21,  -1.438897168506505e-22,  -3.870955617916806e-03,  -2.548500378087261e-04,  -1.014043430829940e-05,  -2.848167162866680e-07,  -4.952860083023318e-09,
   1.832976758576042e-11,   5.586698368141675e-12,   2.606133739180173e-13,   7.543166924354165e-15,   1.177103796446134e-16,  -1.498944092287639e-18,  -1.630582320325733e-19,
  -5.611443126752530e-21,  -1.222721107913173e-22,  -3.079297078701026e-03,  -2.027394958543215e-04,  -8.066736807421611e-06,  -2.265194253000116e-07,  -3.934920400011622e-09,
   1.486116166226117e-11,   4.454250645908573e-12,   2.074952240004642e-13,   5.995889310632258e-15,   9.315618697435180e-17,  -1.211302359446125e-18,  -1.301775775268924e-19,
  -4.469158574457584e-21,  -9.702792640843670e-23,  -2.246513090330989e-03,  -1.479149376330941e-04,  -5.885204984580978e-06,  -1.652294298560768e-07,  -2.867784597832594e-09,
   1.100665597782949e-11,   3.255548660677991e-12,   1.514846593238141e-13,   4.371600090911733e-15,   6.767932221019475e-17,  -8.948293474846225e-19,  -9.524544055707156e-20,
  -3.263584266698521e-21,  -7.064562077059459e-23,  -1.454218553219220e-03,  -9.575104717338804e-05,  -3.809662382233516e-06,  -1.069444442910626e-07,  -1.855118216646789e-09,
   7.195291791631028e-12,   2.109926476971382e-12,   9.810453208122839e-14,   2.828664659326639e-15,   4.368909526992669e-17,  -5.840007170958144e-19,  -6.177152821803809e-20,
  -2.113902477505592e-21,  -4.566948275177363e-23,  -7.801156842285229e-04,  -5.136631247967557e-05,  -2.043703793170853e-06,  -5.736696915587364e-08,  -9.948301637398122e-10,
   3.879321584276724e-12,   1.132568829195297e-12,   5.264058989150018e-14,   1.517114046062386e-15,   2.340358996573099e-17,  -3.145981440188158e-19,  -3.316955326091800e-20,
  -1.134362339004257e-21,  -2.448250436852192e-23,  -2.903068140066604e-04,  -1.911518623223327e-05,  -7.605309848944107e-07,  -2.134770506520252e-08,  -3.701640580356070e-10,
   1.446137454744351e-12,   4.215567398235703e-13,   1.959090770894364e-14,   5.645263089842469e-16,   8.704917492909454e-18,  -1.172421688539968e-19,  -1.234765706821020e-20,
  -4.221800968407168e-22,  -9.108555406007611e-24,  -3.279249310126236e-05,  -2.159215778126705e-06,  -8.590812417790419e-08,  -2.411387375069421e-09,  -4.181220351334694e-11,
   1.633979338210906e-13,   4.761985103255683e-14,   2.212979604088465e-15,   6.376704189430746e-17,   9.832129028971773e-19,  -1.324649123887666e-20,  -1.394842079197018e-21,
  -4.768947376779150e-23,  -1.028845365219316e-24,  -1.399815287216387e-03,   8.489839947023041e-05,  -3.370051229186090e-06,   1.082953759053715e-07,  -3.028061656831157e-09,
   7.470511510081705e-11,  -1.648284529085065e-12,   3.093820808549222e-14,  -3.774676472489246e-16,   3.029279884957103e-18,   1.221534257443158e-19,  -1.404377791305881e-20,
   4.323515623790896e-22,  -4.874601307752788e-24,  -1.331828800224158e-03,   8.077861498643902e-05,  -3.206672771565736e-06,   1.030501223740925e-07,  -2.881511989443489e-09,
   7.109076370267079e-11,  -1.568424662151009e-12,   2.943644675806304e-14,  -3.589371345887636e-16,   2.858861550822011e-18,   1.170613305548651e-19,  -1.337208243503769e-20,
   4.114233014071605e-22,  -4.644460532507871e-24,  -1.202469792883991e-03,   7.293837880189846e-05,  -2.895688389499963e-06,   9.306401401573185e-08,  -2.602458905030927e-09,
   6.420800476409433e-11,  -1.416394652490105e-12,   2.657863936644197e-14,  -3.237576682683913e-16,   2.544058597659412e-18,   1.070305994179359e-19,  -1.208983121336777e-20,
   3.715747202594248e-22,  -4.203871775472247e-24,  -1.024342827969962e-03,   6.213957650283603e-05,  -2.467228191010406e-06,   7.930177286212612e-08,  -2.217795251233618e-09,
   5.471946875871785e-11,  -1.206896247609833e-12,   2.264274209501427e-14,  -2.754700315353009e-16,   2.128927896232998e-18,   9.255529363299089e-20,  -1.031600236915173e-20,
   3.166484447465424e-22,  -3.591961825951119e-24,  -8.148412632234311e-04,   4.943514343035801e-05,  -1.963002297627027e-06,   6.310106896644332e-08,  -1.764861434421399e-09,
   4.354574047136005e-11,  -9.603036639815212e-13,   1.801275158913765e-14,  -2.188749430264721e-16,   1.663938958403212e-18,   7.469098523704382e-20,  -8.219363155355809e-21,
   2.519773396727482e-22,  -2.865675034545567e-24,  -5.944642997420964e-04,   3.606788254019293e-05,  -1.432323377768866e-06,   4.604591188867569e-08,  -1.287933428899122e-09,
   3.177900154671338e-11,  -7.007298320461263e-13,   1.314168050208702e-14,  -1.595284494990615e-16,   1.196527376358705e-18,   5.511665083057889e-20,  -6.004185721860921e-21,
   1.838827756996668e-22,  -2.095545412738063e-24,  -3.848074488744266e-04,   2.334852972657398e-05,  -9.272639523966709e-07,   2.981095536317648e-08,  -8.338674272868365e-10,
   2.057555702830570e-11,  -4.536565758990178e-13,   8.507073445942975e-15,  -1.032007802273346e-16,   7.670904834168278e-19,   3.594581975681000e-20,  -3.889949529634370e-21,
   1.190537022306344e-22,  -1.358579946782357e-24,  -2.064292527510109e-04,   1.252559008780096e-05,  -4.974552889659363e-07,   1.599330182212409e-08,  -4.473720907448386e-10,
   1.103894218947577e-11,  -2.433801832789152e-13,   4.563665354506538e-15,  -5.534395146520858e-17,   4.094531258459057e-19,   1.935685126872810e-20,  -2.087674863297721e-21,
   6.387251442854817e-23,  -7.293847916501010e-25,  -7.681904758737654e-05,   4.661220652699459e-06,  -1.851227115821949e-07,   5.951792857811049e-09,  -1.664876088613308e-10,
   4.108108186824693e-12,  -9.057188602091022e-14,   1.698296377086083e-15,  -2.059296281945107e-17,   1.521051312730879e-19,   7.212871284858135e-21,  -7.770108150740321e-22,
   2.376986928940423e-23,  -2.715025614925357e-25,  -8.677328493561083e-06,   5.265230441502398e-07,  -2.091115823253934e-08,   6.723057595730832e-10,  -1.880621825615402e-11,
   4.640466566100395e-13,  -1.023086138877217e-14,   1.918363586111785e-16,  -2.326098897557511e-18,   1.717673336335496e-20,   8.149230508562207e-22,  -8.777174654699207e-23,
   2.685012495807376e-24,  -3.066973462202467e-26,  -1.097567564687900e-02,   5.133383096362067e-04,  -1.143691338749824e-05,   2.068131587051110e-08,   8.556206600032846e-09,
  -3.503347987052586e-10,   6.176351037484500e-12,   5.410421682185476e-14,  -6.850340752407830e-15,   2.591610843201726e-16,  -3.680709604865288e-18,  -1.380539379996946e-19,
   6.964556351444639e-21,  -9.750928800409047e-23,  -1.044215292302662e-02,   4.883710094104676e-04,  -1.087908521138102e-05,   1.957132369901891e-08,   8.142762269047021e-09,
  -3.332593210102804e-10,   5.870201337801686e-12,   5.174837406097646e-14,  -6.521950900470003e-15,   2.463275415475229e-16,  -3.488048823704785e-18,  -1.315611862033205e-19,
   6.622622807696075e-21,  -9.248179427429440e-23,  -9.427195051842625e-03,   4.408797010226009e-04,  -9.818655353286997e-06,   1.750229724157846e-08,   7.355230292407108e-09,
  -3.007938514011896e-10,   5.290193442342500e-12,   4.715485477152260e-14,  -5.895334789189937e-15,   2.220088064478265e-16,  -3.127134915657838e-18,  -1.191199893830986e-19,
   5.973478975652254e-21,  -8.303392523834646e-23,  -8.029959147530453e-03,   3.755122145194697e-04,  -8.360306293929066e-06,   1.473653702447525e-08,   6.269128789924838e-09,
  -2.561363819283979e-10,   4.496391458406739e-12,   4.061473732886569e-14,  -5.029054530460400e-15,   1.887160342206322e-16,  -2.641129436777979e-18,  -1.018201276903000e-19,
   5.082475003529478e-21,  -7.025369118140647e-23,  -6.387072887342781e-03,   2.986664887169503e-04,  -6.647443676348777e-06,   1.158898713424266e-08,   4.989615030897062e-09,
  -2.036734444600279e-10,   3.568939357587902e-12,   3.265131617923067e-14,  -4.005886980410620e-15,   1.498055095521103e-16,  -2.083390859299304e-18,  -8.126148193661112e-20,
   4.038216274466228e-21,  -5.551377617647023e-23,  -4.659325957560518e-03,   2.178646026124393e-04,  -4.847860443483107e-06,   8.376219599793310e-09,   3.641718822298368e-09,
  -1.485436738037223e-10,   2.599097799557749e-12,   2.402208412299090e-14,  -2.925629798999330e-15,   1.091053585120673e-16,  -1.509613960620557e-18,  -5.943964373771499e-20,
   2.943234786520144e-21,  -4.028120497147428e-23,  -3.015920842877911e-03,   1.410163951425380e-04,  -3.137356078769546e-06,   5.388518596396184e-09,   2.358018467808263e-09,
  -9.613548830159528e-11,   1.680471064807534e-12,   1.563600505193298e-14,  -1.895155047401655e-15,   7.054678911066154e-17,  -9.727906097037377e-19,  -3.854272612363513e-20,
   1.903990897978306e-21,  -2.598110775758272e-23,  -1.617845337689874e-03,   7.564487787009820e-05,  -1.682821954128966e-06,   2.881417330382964e-09,   1.265138656630456e-09,
  -5.156632550975058e-11,   9.009423152173329e-13,   8.411605508025821e-15,  -1.017021332715384e-15,   3.782289787177867e-17,  -5.206373654128676e-19,  -2.069442729800054e-20,
   1.021055670190394e-21,  -1.391170132386285e-23,  -6.020477708754696e-04,   2.814951974189554e-05,  -6.262060432521093e-07,   1.071072052127571e-09,   4.708231134242133e-10,
  -1.918881157350648e-11,   3.351995965059122e-13,   3.133301104851116e-15,  -3.785144835372397e-16,   1.407230783655016e-17,  -1.935888545128465e-19,  -7.703432484143094e-21,
   3.799243750929583e-22,  -5.173652143778763e-24,  -6.800603921206784e-05,   3.179707153008119e-06,  -7.073452219279139e-08,   1.209647332783559e-10,   5.318367956325680e-11,
  -2.167517901764433e-12,   3.786222542368732e-14,   3.539865314232119e-16,  -4.275710661230337e-17,   1.589529581455312e-18,  -2.186459736823282e-20,  -8.702069094942437e-22,
   4.291472644829101e-23,  -5.843456041062289e-25,  -2.188177744877027e-02,   3.896253738838455e-04,   1.655646659953305e-05,  -6.924804894720997e-07,  -5.806261417667562e-09,
   8.308661477868690e-10,  -8.754792868102479e-12,  -7.612173663713282e-13,   2.425200092306425e-14,   5.145869382810666e-16,  -3.408002699768301e-17,  -1.001551601994340e-19,
   3.424614541323398e-20,  -3.858818481993722e-22,  -2.081694989439872e-02,   3.706125774214981e-04,   1.575010952053111e-05,  -6.585524483107132e-07,  -5.527670889396404e-09,
   7.899798836277810e-10,  -8.309026116429928e-12,  -7.236419452242098e-13,   2.302732286715014e-14,   4.893852787456494e-16,  -3.235594000321701e-17,  -9.614648612156444e-20,
   3.251090050807352e-20,  -3.647500514923347e-22,  -1.879172700604768e-02,   3.344730305251203e-04,   1.421675105712521e-05,  -5.941174805634493e-07,  -4.996192160757580e-09,
   7.124021741689531e-10,  -7.469279769919229e-12,  -6.523928755442789e-13,   2.071628077306457e-14,   4.415168552576218e-16,  -2.910371748387413e-17,  -8.816332768650652e-20,
   2.923867828052559e-20,  -3.255315858649023e-22,  -1.600463357393182e-02,   2.847795411539488e-04,   1.210708690973696e-05,  -5.056240620830767e-07,  -4.261646089476632e-09,
   6.059985636842773e-10,  -6.329224292514795e-12,  -5.547602897799130e-13,   1.757102609013191e-14,   3.757653312737118e-16,  -2.467994360337287e-17,  -7.648829515869078e-20,
   2.478977735103731e-20,  -2.734293619769597e-22,  -1.272869825345619e-02,   2.264224769086593e-04,   9.628070861009892e-06,  -4.018387334923529e-07,  -3.394320173343910e-09,
   4.813850202803594e-10,  -5.008876794648771e-12,  -4.405344860946169e-13,   1.391846682034451e-14,   2.986419459379441e-16,  -1.954569511982333e-17,  -6.190489484388694e-20,
   1.962906963697294e-20,  -2.145312950618578e-22,  -9.284632391095553e-03,   1.651191921646888e-04,   7.022452841166432e-06,  -2.929404883556609e-07,  -2.478819144566209e-09,
   3.507974808954564e-10,  -3.639035677094163e-12,  -3.209411464984924e-13,   1.011964463778664e-14,   2.177127897684560e-16,  -1.420870272472178e-17,  -4.578072602481007e-20,
   1.426716429884649e-20,  -1.547724842383752e-22,  -6.009451014419498e-03,   1.068562139449619e-04,   4.545046189087449e-06,  -1.895318616127302e-07,  -1.605653495947744e-09,
   2.269086560498419e-10,  -2.349135744869338e-12,  -2.075589857475433e-13,   6.535890578964413e-15,   1.408604846322394e-16,  -9.175869156054689e-18,  -2.989760516765512e-20,
   9.212696339267930e-21,  -9.944700667557951e-23,  -3.223577542061932e-03,   5.731499484568881e-05,   2.437984999948893e-06,  -1.016481909333390e-07,  -8.616440003365116e-10,
   1.216782322661863e-10,  -1.258406977972194e-12,  -1.112917596821260e-13,   3.502110991300295e-15,   7.554530093810959e-17,  -4.916412525160088e-18,  -1.611069374247439e-20,
   4.935887685740287e-21,  -5.314485968327122e-23,  -1.199574679045478e-03,   2.132776258797267e-05,   9.072281334761350e-07,  -3.782325711238188e-08,  -3.206838620500796e-10,
   4.527441101218684e-11,  -4.680634424676025e-13,  -4.140843994842503e-14,   1.302724525862234e-15,   2.811039589477620e-17,  -1.828784917905524e-18,  -6.004647629445408e-21,
   1.835995852844855e-21,  -1.975063328402839e-23,  -1.355011745781577e-04,   2.409123938120177e-06,   1.024782484654867e-07,  -4.272380759294985e-09,  -3.622450043437974e-11,
   5.114000468294786e-12,  -5.286738964882332e-14,  -4.677293167851063e-15,   1.471437900951792e-16,   3.175250712079827e-18,  -2.065621056209094e-19,  -6.784404109917775e-22,
   2.073759858102031e-22,  -2.230521439691307e-24,  -2.142659575647350e-02,  -5.427716085499316e-04,   1.542619616525701e-05,   9.303621688162276e-07,  -2.974518877060781e-09,
  -1.221901705428674e-09,  -1.786946931366303e-11,   1.227810774216263e-12,   4.482499546716180e-14,  -6.759377305621765e-16,  -6.419260697628045e-17,  -3.009348715489969e-19,
   6.663916761634589e-20,   1.406709697632139e-21,  -2.038394126108514e-02,  -5.162887340602270e-04,   1.467531115208017e-05,   8.847481234720319e-07,  -2.837665275469008e-09,
  -1.161704872058359e-09,  -1.696346329259551e-11,   1.167363073390674e-12,   4.255986593776579e-14,  -6.435218158587601e-16,  -6.094101061327255e-17,  -2.831332085589732e-19,
   6.326217490143571e-20,   1.331039374008780e-21,  -1.840088065769358e-02,  -4.659488016667549e-04,   1.324726452936667e-05,   7.981320623249523e-07,  -2.574150063069166e-09,
  -1.047514494073105e-09,  -1.525520367680979e-11,   1.052679371356977e-12,   3.828604946334819e-14,  -5.816682750786865e-16,  -5.480900679608182e-17,  -2.505814344302898e-19,
   5.689410807852536e-20,   1.190100195816107e-21,  -1.567179270905330e-02,  -3.967267172328352e-04,   1.128215840511930e-05,   6.792000150742516e-07,  -2.205261930110317e-09,
  -8.909469308893518e-10,  -1.293310293276576e-11,   8.954027732923493e-13,   3.247072328778429e-14,  -4.961634314325879e-16,  -4.647123557914034e-17,  -2.082931707847177e-19,
   4.823632786056309e-20,   1.001871930707560e-21,  -1.246401413601728e-02,  -3.154333535298362e-04,   8.972586627505961e-06,   5.397469850504669e-07,  -1.763805231139216e-09,
  -7.076518635499756e-10,  -1.024002262553833e-11,   7.112381160977805e-13,   2.571895205384033e-14,  -3.951877962808241e-16,  -3.679842849469545e-17,  -1.617299263678736e-19,
   3.819375338392533e-20,   7.878118626121970e-22,  -9.091581972594576e-03,  -2.300329228783001e-04,   6.544673689578335e-06,   3.934526130002618e-07,  -1.292385821817598e-09,
  -5.156328640597006e-10,  -7.442448537235996e-12,   5.182729160845003e-13,   1.869823228925430e-14,  -2.885977672517015e-16,  -2.674745470966300e-17,  -1.156756213190487e-19,
   2.776017060575878e-20,   5.693968898155627e-22,  -5.884506892927963e-03,  -1.488658607548833e-04,   4.235953486190874e-06,   2.545531523626420e-07,  -8.389785851017299e-10,
  -3.335083668931621e-10,  -4.805624672675765e-12,   3.352272080624120e-13,   1.207598280264525e-14,  -1.869371724733978e-16,  -1.727197516105921e-17,  -7.389394470643789e-20,
   1.792525687135798e-20,   3.663033108146586e-22,  -3.156557250782352e-03,  -7.984818925198989e-05,   2.272222981866240e-06,   1.365171732315190e-07,  -4.507272170612256e-10,
  -1.788355806830568e-10,  -2.574664546462258e-12,   1.797603315965952e-13,   6.470511146360864e-15,  -1.003156559569672e-16,  -9.253925543504356e-18,  -3.936970470157763e-20,
   9.603748184850846e-21,   1.958769618385746e-22,  -1.174634991320877e-03,  -2.971273492621539e-05,   8.455491878485394e-07,   5.079764265999095e-08,  -1.678155429279565e-10,
  -6.654091221720931e-11,  -9.576887877946621e-13,   6.688538698993847e-14,   2.406900460363545e-15,  -3.733505432147674e-17,  -3.442186168432055e-18,  -1.461575067000749e-20,
   3.572284814507890e-21,   7.281124151534808e-23,  -1.326840498736867e-04,  -3.356267409442582e-06,   9.551123259683957e-08,   5.737914971434441e-09,  -1.895764173158876e-11,
  -7.516157910048187e-12,  -1.081709754672734e-13,   7.555075270545298e-15,   2.718610437661440e-16,  -4.217371862068189e-18,  -3.887956789611000e-19,  -1.650339346025325e-21,
   4.034898992995870e-22,   8.223164024058991e-24,  -6.936301570232217e-03,  -4.794841284561010e-04,  -1.912202820318222e-05,  -4.801751642375472e-07,  -3.469808038718054e-09,
   3.671599179693479e-10,   2.279519553470449e-11,   7.375580264022251e-13,   1.119860668009017e-14,  -2.513937326188819e-16,  -2.298126900803686e-17,  -7.958547476882266e-19,
  -1.454946585893163e-20,   7.405660562779606e-23,  -6.599486949687160e-03,  -4.562044765323563e-04,  -1.819252043343320e-05,  -4.567087166949294e-07,  -3.290834975858015e-09,
   3.497603013763816e-10,   2.169557423443294e-11,   7.014049650458359e-13,   1.062292957072417e-14,  -2.404651763848528e-16,  -2.189145773204498e-17,  -7.569402672190042e-19,
  -1.379329008432595e-20,   7.281411175488786e-23,  -5.958596071312119e-03,  -4.119066128449005e-04,  -1.642424762907035e-05,  -4.121176323548171e-07,  -2.954548343011387e-09,
   3.164773922242076e-10,   1.960021748922453e-11,   6.327488169729443e-13,   9.540464150322637e-15,  -2.191492217547550e-16,  -1.980699739909638e-17,  -6.829957727941248e-19,
  -1.237443443367774e-20,   6.949258450481262e-23,  -5.076036764171747e-03,  -3.509022376162529e-04,  -1.398995837371966e-05,  -3.508302257316260e-07,  -2.499722888643648e-09,
   2.703053063007203e-10,   1.670896529183333e-11,   5.384689703946748e-13,   8.074938413303798e-15,  -1.887858748968840e-16,  -1.691578541603158e-17,  -5.813732667199131e-19,
  -1.045953718592549e-20,   6.306212603293374e-23,  -4.037958035803343e-03,  -2.791447839585149e-04,  -1.112768789834964e-05,  -2.788929232910788e-07,  -1.975221578654310e-09,
   2.155687568776073e-10,   1.330098226991510e-11,   4.279142825797125e-13,   6.383025343137551e-15,  -1.517955022323704e-16,  -1.348906217418558e-17,  -4.621144862671494e-19,
  -8.256881228694514e-21,   5.314824407507635e-23,  -2.945927779705537e-03,  -2.036549142410016e-04,  -8.117570291642207e-06,  -2.033567368973407e-07,  -1.433226332645820e-09,
   1.575886251363485e-10,   9.709170191308082e-12,   3.119320145147642e-13,   4.632940411697539e-15,  -1.116936959176161e-16,  -9.860163001749976e-18,  -3.369206577360086e-19,
  -5.986356868494757e-21,   4.052767446563730e-23,  -1.906973937944599e-03,  -1.318320190490087e-04,  -5.254395949756758e-06,  -1.315900314814256e-07,  -9.244211895704459e-10,
   1.021472941632577e-10,   6.287261170786805e-12,   2.018113986468098e-13,   2.988809938582023e-15,  -7.270829636724390e-17,  -6.390874634109350e-18,  -2.180021163101125e-19,
  -3.859028904334876e-21,   2.698434755138445e-23,  -1.022998692538644e-03,  -7.072174044944167e-05,  -2.818641177899718e-06,  -7.057843117954084e-08,  -4.949860419245535e-10,
   5.483455159734665e-11,   3.373433237499984e-12,   1.082315937526346e-13,   1.600536932405823e-15,  -3.911631291100101e-17,  -3.430630984339467e-18,  -1.169210502734133e-19,
  -2.065740990154163e-21,   1.468233416687996e-23,  -3.806919067837321e-04,  -2.631795270472297e-05,  -1.048899112651108e-06,  -2.626287442502326e-08,  -1.840815167808360e-10,
   2.041062051915370e-11,   1.255447636327629e-12,   4.027264221350061e-14,   5.952485609959175e-16,  -1.457096906053168e-17,  -1.276941689241741e-18,  -4.350677568119751e-20,
  -7.681555473215501e-22,   5.490538060361137e-24,  -4.300222282026773e-05,  -2.972825775517353e-06,  -1.184814178537737e-07,  -2.966572903214754e-09,  -2.079135454514152e-11,
   2.305631334971573e-12,   1.418143873907190e-13,   4.549049255382402e-15,   6.723159292767032e-17,  -1.646168172420240e-18,  -1.442460568739154e-19,  -4.914379578356824e-21,
  -8.675904929284116e-23,   6.206801069754615e-25,  -1.106941047531071e-03,   6.241348989611737e-05,  -2.318108854334867e-06,   6.992124616572803e-08,  -1.865961657083139e-09,
   4.428738666081069e-11,  -9.333594216573559e-13,   2.066847527458175e-14,  -2.801523500404351e-16,   7.996758486154313e-19,  -1.247026881513633e-19,   9.025247272473239e-22,
   1.890029216747720e-22,  -4.850447025316354e-24,  -1.053168479275338e-03,   5.938393882052594e-05,  -2.205689145118145e-06,   6.653346002609593e-08,  -1.775617794576119e-09,
   4.214614156997324e-11,  -8.881946564623855e-13,   1.966401897048332e-14,  -2.666894517540340e-16,   7.621478206852943e-19,  -1.182662416840997e-19,   8.474295082423933e-22,
   1.798098534677452e-22,  -4.610709311697074e-24,  -9.508587792091064e-04,   5.361884685940293e-05,  -1.991718554774090e-06,   6.008414553434003e-08,  -1.603604162040476e-09,
   3.806800573353170e-11,  -8.021911877300494e-13,   1.775307983759644e-14,  -2.410142308854056e-16,   6.901837046987384e-19,  -1.061741248348444e-19,   7.471950063760206e-22,
   1.623243747719768e-22,  -4.156256267407264e-24,  -8.099868714739755e-04,   4.567894544937599e-05,  -1.696950288172059e-06,   5.119702322275665e-08,  -1.366519120476025e-09,
   3.244476158066321e-11,  -6.836332234265836e-13,   1.512221778232725e-14,  -2.055455715297853e-16,   5.900308847201635e-19,  -8.982301697901646e-20,   6.180690895070634e-22,
   1.382583791966556e-22,  -3.533764550374936e-24,  -6.443127620554899e-04,   3.633878416752299e-05,  -1.350096295027212e-06,   4.073640759066831e-08,  -1.087392751329057e-09,
   2.582136384288664e-11,  -5.440263282679528e-13,   1.202859022571523e-14,  -1.636864504158353e-16,   4.709365731134828e-19,  -7.097112788581437e-20,   4.774384867035251e-22,
   1.099667596683127e-22,  -2.805781315915495e-24,  -4.700481043233799e-04,   2.651212986679170e-05,  -9.850816742064263e-07,   2.972517155725711e-08,  -7.935136495917586e-10,
   1.884510259927373e-11,  -3.970168314895478e-13,   8.774949724320052e-15,  -1.195219355240693e-16,   3.444825789332491e-19,  -5.149408091087862e-20,   3.399654139545377e-22,
   8.021774631885596e-23,  -2.043868126174353e-24,  -3.042672743992433e-04,   1.716233958504315e-05,  -6.377142087564039e-07,   1.924424099669483e-08,  -5.137457053517990e-10,
   1.220186463563743e-11,  -2.570494319043728e-13,   5.679985800213446e-15,  -7.741351572767452e-17,   2.233749864441879e-19,  -3.321217726917373e-20,   2.164981830752346e-22,
   5.192309769761044e-23,  -1.321717406169470e-24,  -1.632227058847242e-04,   9.206860089242462e-06,  -3.421152501978019e-07,   1.032425480246119e-08,  -2.756227472160690e-10,
   6.546519226559949e-12,  -1.379083815678132e-13,   3.046963728861997e-15,  -4.154066032004918e-17,   1.199343707999966e-19,  -1.778331721251110e-20,   1.151577511761234e-22,
   2.785316998399837e-23,  -7.086708275415098e-25,  -6.074036558805162e-05,   3.426192468858413e-06,  -1.273141207642354e-07,   3.842084291898228e-09,  -1.025714128058010e-10,
   2.436283250064801e-12,  -5.132210204681276e-14,   1.133867405404972e-15,  -1.546022697529381e-17,   4.464506929282934e-20,  -6.613439241276415e-21,   4.272674872422558e-23,
   1.036495910826846e-23,  -2.636726149265506e-25,  -6.861110075562225e-06,   3.870163195514517e-07,  -1.438118658643789e-08,   4.339959477577354e-10,  -1.158632259224808e-11,
   2.751997393434388e-13,  -5.797277780138621e-15,   1.280793055885112e-16,  -1.746385397479750e-18,   5.043262421674850e-21,  -7.469637913999394e-22,   4.824049590838991e-24,
   1.170803382049018e-24,  -2.978309966608373e-26,  -9.101090444442749e-03,   4.246839065339827e-04,  -1.057192169716951e-05,   1.097491872962229e-07,   3.058745378149186e-09,
  -2.012860069756251e-10,   5.779118075249732e-12,  -5.101085654120325e-14,  -8.780735250887945e-16,   6.987531886559419e-17,  -4.276490248787340e-18,   6.973242239582310e-20,
   1.860533682540364e-21,  -8.239571893264686e-23,  -8.658723893289189e-03,   4.040368145048085e-04,  -1.005714802384285e-05,   1.043510115867578e-07,   2.912541249607202e-09,
  -1.915268802180200e-10,   5.497256354483324e-12,  -4.845411629906737e-14,  -8.410549592437542e-16,   6.658875485579777e-17,  -4.064803707388222e-18,   6.614994068677603e-20,
   1.772362194673957e-21,  -7.835916891081421e-23,  -7.817165271082159e-03,   3.647597725803564e-04,  -9.078213997840019e-06,   9.410742032373754e-08,   2.633397686453337e-09,
  -1.729510526352675e-10,   4.961427273590098e-12,  -4.362145152395131e-14,  -7.683214318147117e-16,   6.029130521821011e-17,  -3.663639993864445e-18,   5.941324964136300e-20,
   1.603705546719322e-21,  -7.069251271388415e-23,  -6.658612123251686e-03,   3.106919318385668e-04,  -7.731261243057061e-06,   8.005555055004371e-08,   2.247160359980749e-09,
  -1.473587388740992e-10,   4.224517247036501e-12,  -3.702924473760991e-14,  -6.637206468356444e-16,   5.153477803865753e-17,  -3.114376903052013e-18,   5.029134712924816e-20,
   1.369737506421837e-21,  -6.016259091464532e-23,  -5.296338471883527e-03,   2.471217248290569e-04,  -6.148374117756486e-06,   6.359638841211704e-08,   1.790543112762605e-09,
  -1.172417726292820e-10,   3.358991238477194e-12,  -2.935506804969796e-14,  -5.350793031130753e-16,   4.112906301569970e-17,  -2.472349284688169e-18,   3.975810388760373e-20,
   1.092371292773637e-21,  -4.781277014667603e-23,  -3.863667609041190e-03,   1.802710675753929e-04,  -4.484542570147087e-06,   4.634597991109783e-08,   1.308033482361415e-09,
  -8.554573616117387e-11,   2.449644481906627e-12,  -2.135651958017585e-14,  -3.945350368636574e-16,   3.008419881876829e-17,  -1.800712186972654e-18,   2.886000823488690e-20,
   7.985668667815023e-22,  -3.485482676012180e-23,  -2.500912258201965e-03,   1.166860207317108e-04,  -2.902505907806323e-06,   2.997898003440715e-08,   8.474617605216506e-10,
  -5.538060754670692e-11,   1.585315089265053e-12,  -1.379904306107407e-14,  -2.571715362122589e-16,   1.950759122058497e-17,  -1.164357465777372e-18,   1.861945870096458e-20,
   5.176245517508484e-22,  -2.255062178932945e-23,  -1.341579675978554e-03,   6.259415974700878e-05,  -1.556928471262575e-06,   1.607621662074490e-08,   4.548253711625634e-10,
  -2.971028653345216e-11,   8.503334124033955e-13,  -7.395464762888062e-15,  -1.384498078972984e-16,   1.047403814637989e-17,  -6.242657474765886e-19,   9.971259723284125e-21,
   2.778709813508558e-22,  -1.209404968037611e-23,  -4.992415844390095e-04,   2.329308659562229e-05,  -5.793688243547633e-07,   5.981712779546929e-09,   1.692820194975146e-10,
  -1.105635423644902e-11,   3.164230170228611e-13,  -2.751185477947222e-15,  -5.158521051980774e-17,   3.898924825879117e-18,  -2.322640526813454e-19,   3.708414002480154e-21,
   1.034297399507002e-22,  -4.500175814946339e-24,  -5.639327728096086e-05,   2.631136959755182e-06,  -6.544409442075684e-08,   6.756686886541339e-10,   1.912224224874025e-11,
  -1.248907412126244e-12,   3.574227520432895e-14,  -3.107522256146359e-16,  -5.828102542524189e-18,   4.404362779051043e-19,  -2.623527372364805e-20,   4.188554221589891e-22,
   1.168366625305288e-23,  -5.083235835758494e-25,  -2.011169466044926e-02,   4.884183978871689e-04,   8.184982971051055e-06,  -6.693989885736225e-07,   7.475788881152250e-09,
   4.606516696059375e-10,  -1.821983517220206e-11,   6.433704329368977e-14,   2.081339575901175e-14,  -5.613766224906026e-16,  -1.355042240691843e-17,   7.407319524976725e-19,
  -6.138867153885314e-22,  -5.872242343319018e-22,  -1.913320992108413e-02,   4.646021259759615e-04,   7.788176511871299e-06,  -6.367021349767763e-07,   7.104104856292999e-09,
   4.382828003879368e-10,  -1.731639439372493e-11,   6.061506505551311e-14,   1.978289059569552e-14,  -5.328728267052333e-16,  -1.289217492471407e-17,   7.033501038499030e-19,
  -5.520315827060704e-22,  -5.579789101497609e-22,  -1.727212098698751e-02,   4.193250608910905e-04,   7.032869806291813e-06,  -5.745647192369085e-07,   6.400406058225578e-09,
   3.957189815270631e-10,  -1.560496868085116e-11,   5.377807099482915e-14,   1.783012289854795e-14,  -4.791454681586676e-16,  -1.163968245692082e-17,   6.327975063681993e-19,
  -4.475647451578823e-22,  -5.026246557622056e-22,  -1.471074507371252e-02,   3.570533863854004e-04,   5.992242043745833e-06,  -4.891479081259344e-07,   5.438209129429972e-09,
   3.371049671515316e-10,  -1.326298552594574e-11,   4.483646014682114e-14,   1.515665922659626e-14,  -4.061433377079870e-16,  -9.915022949541459e-18,   5.367581186889270e-19,
  -3.291690628130714e-22,  -4.269704046449706e-22,  -1.169991181414512e-02,   2.839079371871158e-04,   4.767600622602593e-06,  -3.888711714947516e-07,   4.315115779972238e-09,
   2.681629228484727e-10,  -1.052699427344744e-11,   3.491563663512950e-14,   1.203190663354322e-14,  -3.215186888233054e-16,  -7.886742856175005e-18,   4.252056021404332e-19,
  -2.218506601799380e-22,  -3.387156196290277e-22,  -8.534362630290884e-03,   2.070535252998649e-04,   3.478717561990970e-06,  -2.835614981529265e-07,   3.141704839419537e-09,
   1.956390405847240e-10,  -7.666188431503511e-12,   2.503258525923375e-14,   8.763218773255062e-15,  -2.336486354858274e-16,  -5.753435696600436e-18,   3.091666886617949e-19,
  -1.384665356213746e-22,  -2.465602043560812e-22,  -5.523906506952014e-03,   1.339993655866061e-04,   2.252064018642708e-06,  -1.834954603374782e-07,   2.030959594515968e-09,
   1.266413483681608e-10,  -4.956590299617293e-12,   1.601623831373317e-14,   5.666340236941387e-15,  -1.508546745364282e-16,  -3.724154163497884e-18,   1.996846846021078e-19,
  -7.966847089061600e-23,  -1.593675852557784e-22,  -2.963140751544532e-03,   7.187542086045292e-05,   1.208178218817470e-06,  -9.841955022625747e-08,   1.088754968789538e-09,
   6.793668842010680e-11,  -2.657337134540098e-12,   8.540207917799672e-15,   3.037976465807560e-15,  -8.081830572335969e-17,  -1.997771995676020e-18,   1.069981232063527e-19,
  -3.999957226130146e-23,  -8.542752186310734e-23,  -1.102661899423860e-03,   2.674611063421715e-05,   4.496105636247430e-07,  -3.662301456916642e-08,   4.050641162537520e-10,
   2.528147502656322e-11,  -9.886723419383501e-13,   3.171400318712890e-15,   1.130307026622339e-15,  -3.006121826733907e-17,  -7.434301927341969e-19,   3.980164282596765e-20,
  -1.453082934519083e-23,  -3.178194662574244e-23,  -1.245541734921307e-04,   3.021168786867786e-06,   5.078726998444152e-08,  -4.136825943645966e-09,   4.575350598457714e-11,
   2.855746051898968e-12,  -1.116747305741287e-13,   3.581152590689912e-16,   1.276732618058728e-16,  -3.395406864122959e-18,  -8.397630672130762e-20,   4.495631312426623e-21,
  -1.635024889608085e-24,  -3.589875271240007e-24,  -2.328385406499665e-02,  -3.774540594721167e-04,   2.546103480928244e-05,   6.781092710741689e-07,  -2.823754252199465e-08,
  -1.115834629605854e-09,   2.955615648174809e-11,   1.814147469494103e-12,  -1.933047845312183e-14,  -2.456042804263012e-15,  -3.073159910588204e-19,   2.856936069589676e-18,
   2.241554031036967e-20,  -3.178746824982157e-21,  -2.215057015277953e-02,  -3.590347208246944e-04,   2.421759677260992e-05,   6.447975216678903e-07,  -2.685094023931224e-08,
  -1.060439660374617e-09,   2.810244379026529e-11,   1.723309660173555e-12,  -1.839030430533291e-14,  -2.331977671001300e-15,  -2.498824020332583e-19,   2.710740229034603e-18,
   2.118991184882505e-20,  -3.013956428368474e-21,  -1.999524091587640e-02,  -3.240234218566550e-04,   2.185447452948165e-05,   5.815686987150790e-07,  -2.421880804930729e-08,
  -9.555297816072683e-10,   2.534385844695363e-11,   1.551588223559619e-12,  -1.660188246100995e-14,  -2.097878641133493e-15,  -1.582670337527107e-19,   2.435631633596149e-18,
   1.891479417311339e-20,  -2.704692572356348e-21,  -1.702927563193930e-02,  -2.758817062290529e-04,   1.860586311917439e-05,   4.948008442575901e-07,  -2.060633707965610e-08,
  -8.120188130764738e-10,   2.155967297692568e-11,   1.317287096705159e-12,  -1.414020495777588e-14,  -1.779311500950582e-15,  -6.599501787841388e-20,   2.062708566449448e-18,
   1.589111747966048e-20,  -2.287094253301546e-21,  -1.354332206893983e-02,  -2.193474207901058e-04,   1.479188349154350e-05,   3.931264920384461e-07,  -1.637270771971097e-08,
  -6.444286383203460e-10,   1.712714970436354e-11,   1.044438499379604e-12,  -1.124628673937925e-14,  -1.409399966880013e-15,   2.032765719870980e-22,   1.631517805419806e-18,
   1.247122385317331e-20,  -1.806313702606092e-21,  -9.878670523254814e-03,  -1.599593622813082e-04,   1.078627835362422e-05,   2.865243783437734e-07,  -1.193339345497024e-08,
  -4.692524308192110e-10,   1.248148742725073e-11,   7.599531377732896e-13,  -8.203507266659941e-15,  -1.024706264025556e-15,   3.088734468753189e-20,   1.184812069245370e-18,
   8.999292833937767e-21,  -1.310172456587672e-21,  -6.393868216345451e-03,  -1.035169134949551e-04,   6.979979025251432e-06,   1.853529370514149e-07,  -7.719890434589689e-09,
  -3.033762432007850e-10,   8.073693348687740e-12,   4.910718684224293e-13,  -5.309759092002097e-15,  -6.618104129366097e-16,   3.306835559935094e-20,   7.646235939232661e-19,
   5.783278046414406e-21,  -8.448509462203379e-22,  -3.429765944985360e-03,  -5.552384024661957e-05,   3.743798452750729e-06,   9.939935469147497e-08,  -4.139996457944365e-09,
  -1.626412214004628e-10,   4.329520864337707e-12,   2.631980770497039e-13,  -2.848265101555972e-15,  -3.546142209038787e-16,   2.132915419562554e-20,   4.095411121240125e-19,
   3.090862652942212e-21,  -4.523259127133701e-22,  -1.276300018726708e-03,  -2.066124246306681e-05,   1.393111810589716e-06,   3.698547806418672e-08,  -1.540455959815581e-09,
  -6.051057661431862e-11,   1.610948848849757e-12,   9.791395451219532e-14,  -1.059913213284932e-15,  -1.319100715512571e-16,   8.401503614644972e-21,   1.523207807982173e-19,
   1.148714853612541e-21,  -1.682096637564007e-22,  -1.441678448829843e-04,  -2.333835617088673e-06,   1.573617801312323e-07,   4.177730508583492e-09,  -1.740037999670142e-10,
  -6.834913405166467e-12,   1.819659049340589e-13,   1.105961887679698e-14,  -1.197253703047391e-16,  -1.489934466837148e-17,   9.573347364829837e-22,   1.720437185188791e-20,
   1.297297704717068e-22,  -1.899856224635827e-23,  -9.196991871257337e-03,  -6.556641310258693e-04,  -2.485806747464916e-05,  -4.396556654229171e-07,   1.116165142518156e-08,
   1.185955563290999e-09,   4.538944628779327e-11,   6.950257944281851e-13,  -2.427197043906887e-14,  -2.005833378367175e-15,  -6.448942567031147e-17,  -6.509057000032489e-19,
   4.402500388727943e-20,   2.795984446268738e-21,  -8.750383179838174e-03,  -6.238109437891090e-04,  -2.364692253948168e-05,  -4.179167825733088e-07,   1.063890695205799e-08,
   1.128694065059015e-09,   4.316099442785904e-11,   6.590659010605429e-13,  -2.317692223176738e-14,  -1.909270935407707e-15,  -6.126391190789072e-17,  -6.127460984272708e-19,
   4.209444853803569e-20,   2.661194732279308e-21,  -7.900583721678612e-03,  -5.632068758063227e-04,  -2.134401229070010e-05,  -3.767106350425651e-07,   9.636380072285664e-09,
   1.019602111478156e-09,   3.893053988419988e-11,   5.915400155624165e-13,  -2.105907848702488e-14,  -1.725176239002352e-15,  -5.516411412612898e-17,  -5.428004376197995e-19,
   3.833566051857959e-20,   2.404255281187904e-21,  -6.730354981788541e-03,  -4.797621237925542e-04,  -1.817593143751489e-05,  -3.202739638877261e-07,   8.240618562781295e-09,
   8.691141632295687e-10,   3.312403332011257e-11,   5.002944574155771e-13,  -1.807653706684506e-14,  -1.470987861264239e-15,  -4.683784347773278e-17,  -4.516473330126400e-19,
   3.299505406508844e-20,   2.049596031087171e-21,  -5.353934329030156e-03,  -3.816285063595260e-04,  -1.445366604457532e-05,  -2.542817811265990e-07,   6.579692002098694e-09,
   6.917827584130171e-10,   2.631875052706219e-11,   3.951778481377171e-13,  -1.448505197957298e-14,  -1.171176335798853e-15,  -3.713841581555304e-17,  -3.509756473656026e-19,
   2.650673813505654e-20,   1.631483028196629e-21,  -3.905995482741427e-03,  -2.784089440021773e-04,  -1.054175084927550e-05,  -1.852229746746031e-07,   4.814556917156874e-09,
   5.049343919766232e-10,   1.918266667116935e-11,   2.866574351766288e-13,  -1.062943997111041e-14,  -8.550283721264153e-16,  -2.702331584955752e-17,  -2.511746816161285e-19,
   1.948999280522431e-20,   1.190834566419080e-21,  -2.528443998448076e-03,  -1.802162649592596e-04,  -6.822638732998819e-06,  -1.197752622104294e-07,   3.122691152083305e-09,
   3.269583546821515e-10,   1.240953567843903e-11,   1.848556033332650e-13,  -6.907076331296191e-15,  -5.537293952101403e-16,  -1.746225800975576e-17,  -1.605031408705230e-19,
   1.268107443403418e-20,   7.710893465578405e-22,  -1.356385425715244e-03,  -9.667589658335695e-05,  -3.659654062053515e-06,  -6.421935950356947e-08,   1.676853300427800e-09,
   1.754251346485927e-10,   6.654934677890014e-12,   9.897178114291000e-14,  -3.712568190882259e-15,  -2.971166309866995e-16,  -9.359198002688452e-18,  -8.552671009490460e-20,
   6.820570309600869e-21,   4.137136681133839e-22,  -5.047560000936467e-04,  -3.597614714397856e-05,  -1.361832668327028e-06,  -2.389372914593823e-08,   6.242307520232243e-10,
   6.528514780151481e-11,   2.476240812128438e-12,   3.680553678047534e-14,  -1.382510036187690e-15,  -1.105757477350695e-16,  -3.481773532695161e-18,  -3.175280857579863e-20,
   2.540463825799292e-21,   1.539645192302369e-22,  -5.701625932096663e-05,  -4.063792972287916e-06,  -1.538291541890702e-07,  -2.698910022030248e-09,   7.051580361119557e-11,
   7.374548921989451e-12,   2.797063226798082e-13,   4.157031356542081e-15,  -1.561825061946694e-16,  -1.249057962149827e-17,  -3.932747658511624e-19,  -3.585399998404003e-21,
   2.870071465055551e-22,   1.739167534495814e-23,  -8.896994497746468e-04,   4.677760979715148e-05,  -1.632405179819765e-06,   4.611331368359660e-08,  -1.162578661965532e-09,
   2.781486684044639e-11,  -4.816062006605556e-13,   1.140300835684371e-14,  -3.136961274698418e-16,  -1.587354730044009e-18,   3.097846368282923e-20,   4.559661899093842e-21,
  -7.290102464441032e-24,  -1.461319049707998e-24,  -8.464730128950974e-04,   4.450646021045617e-05,  -1.553212361694414e-06,   4.387863812277826e-08,  -1.106246223469145e-09,
   2.646905403414724e-11,  -4.584416119845177e-13,   1.084671437974012e-14,  -2.983964827564155e-16,  -1.502721945206042e-18,   2.946080741932583e-20,   4.334500345554607e-21,
  -6.624262114142316e-24,  -1.389379903034265e-24,  -7.642316027202001e-04,   4.018479989020403e-05,  -1.402494220678463e-06,   3.962466561680287e-08,  -9.990080203202617e-10,
   2.390627412817959e-11,  -4.142738583110781e-13,   9.789261134769209e-15,  -2.693116566453210e-16,  -1.344765659576243e-18,   2.657930072804696e-20,   3.907592748753502e-21,
  -5.486308869932588e-24,  -1.252979425453943e-24,  -6.509975332208089e-04,   3.423329196812598e-05,  -1.194884701063960e-06,   3.376304348972685e-08,  -8.512374076285032e-10,
   2.037330450053399e-11,  -3.532765101592482e-13,   8.335110789132336e-15,  -2.293124381668229e-16,  -1.133214936445578e-18,   2.262259633443588e-20,   3.322668851779830e-21,
  -4.167291844532642e-24,  -1.066000171272614e-24,  -5.178341758666580e-04,   2.723275544899280e-05,  -9.506176396217462e-07,   2.686402086627836e-08,  -6.773073235358230e-10,
   1.621295532910244e-11,  -2.813095609586500e-13,   6.627295225850081e-15,  -1.823317944158032e-16,  -8.919256584706703e-19,   1.798178343844834e-20,   2.638418800633379e-21,
  -2.926590656532286e-24,  -8.470243391835020e-25,  -3.777724909741056e-04,   1.986811329910421e-05,  -6.935865590876077e-07,   1.960224153247897e-08,  -4.942254242672662e-10,
   1.183189229967472e-11,  -2.053964176995414e-13,   4.833106301886958e-15,  -1.329718717321221e-16,  -6.451117919966241e-19,   1.311085204415337e-20,   1.922094711008396e-21,
  -1.908172022795858e-24,  -6.174362774355786e-25,  -2.445340470459116e-04,   1.286122784320463e-05,  -4.489997852196781e-07,   1.269046622234427e-08,  -3.199631622406064e-10,
   7.660618827154583e-12,  -1.330286825488700e-13,   3.127784304680433e-15,  -8.605473950021711e-17,  -4.152038397175273e-19,   8.483767379303344e-21,   1.243029266419017e-21,
  -1.138564594607885e-24,  -3.994777148772804e-25,  -1.311784952527182e-04,   6.899448357392205e-06,  -2.408730242351863e-07,   6.808213314278938e-09,  -1.716552669990339e-10,
   4.109971652526718e-12,  -7.138279212767856e-14,   1.677681753646942e-15,  -4.615830293137368e-17,  -2.220776262140925e-19,   4.550268433159411e-21,   6.664965372537466e-22,
  -5.842312781429873e-25,  -2.142468239612017e-25,  -4.881561555786106e-05,   2.567517995761521e-06,  -8.963772118829865e-08,   2.533614353210323e-09,  -6.388001942713692e-11,
   1.529512147650196e-12,  -2.656642574699632e-14,   6.242925256278262e-16,  -1.717628182251329e-17,  -8.255714695396371e-20,   1.693196785318658e-21,   2.479830746854062e-22,
  -2.139768739538020e-25,  -7.972161667009522e-26,  -5.514112772779527e-06,   2.900219355233049e-07,  -1.012531901051290e-08,   2.861931051528566e-10,  -7.215788294027561e-12,
   1.727717201749964e-13,  -3.000937149916710e-15,   7.051836291128317e-17,  -1.940185993265989e-18,  -9.323966354185529e-21,   1.912582814829140e-22,   2.801092759442235e-23,
  -2.410886428307184e-26,  -9.005079504867366e-27,  -7.562334903092484e-03,   3.459489071964650e-04,  -9.071150002633897e-06,   1.334960754462348e-07,   2.940169349691199e-10,
  -8.158866421886498e-11,   4.140259113368937e-12,  -6.486575657434579e-14,  -5.627502214972844e-16,  -2.676172420164130e-17,  -4.989797730223069e-19,   8.027555711074285e-20,
  -8.276388380032493e-22,  -1.370752181054644e-23,  -7.194770040649318e-03,   3.291336978690019e-04,  -8.629869315788345e-06,   1.269784010104705e-07,   2.815603878043250e-10,
  -7.766079240119463e-11,   3.938403181153324e-12,  -6.173840686695374e-14,  -5.360582373723580e-16,  -2.532906987692814e-17,  -4.762877203385085e-19,   7.633896167561896e-20,
  -7.832875343441019e-22,  -1.305311691271745e-23,  -6.495510544280658e-03,   2.971444457286695e-04,  -7.790526264779742e-06,   1.145909403667665e-07,   2.571166301199766e-10,
  -7.017304672464426e-11,   3.554641575063200e-12,  -5.577836425527851e-14,  -4.850134130011840e-16,  -2.265729841426149e-17,  -4.324722588251371e-19,   6.886405814603022e-20,
  -7.006094102558219e-22,  -1.180424020657289e-23,  -5.532849947525815e-03,   2.531056682792045e-04,  -6.635314115360842e-06,   9.756026161314766e-08,   2.220187750088278e-10,
  -5.983505368238808e-11,   3.026810530028471e-12,  -4.755302058672404e-14,  -4.142227995833603e-16,  -1.908319254904907e-17,  -3.709109517972007e-19,   5.860088087077082e-20,
  -5.900576305435756e-22,  -1.007643338176907e-23,  -4.400905579810470e-03,   2.013231497363859e-04,  -5.277337747614868e-06,   7.756382680852062e-08,   1.789186781679844e-10,
  -4.764147493420306e-11,   2.406779406892671e-12,  -3.785593092572547e-14,  -3.303237923324443e-16,  -1.501220364102328e-17,  -2.969698914123923e-19,   4.656769407132859e-20,
  -4.641755781869525e-22,  -8.032696017033666e-24,  -3.210458049847753e-03,   1.468647604670698e-04,  -3.849530639946599e-06,   5.656103931280351e-08,   1.318851961767978e-10,
  -3.478255524562654e-11,   1.755280838398690e-12,  -2.763432405796720e-14,  -2.414694645327354e-16,  -1.085341045855779e-17,  -2.177736488700225e-19,   3.394506665099605e-20,
  -3.355930885406084e-22,  -5.870835474809699e-24,  -2.078099358622519e-03,   9.506402640374189e-05,  -2.491643426829667e-06,   3.660213435240633e-08,   8.595139060501976e-11,
  -2.252645535302008e-11,   1.135978493409374e-12,  -1.789528793050769e-14,  -1.565146597814164e-16,  -6.983420464153896e-18,  -1.414457546539443e-19,   2.196117620785017e-20,
  -2.159372746050008e-22,  -3.805010253439993e-24,  -1.114768368763365e-03,   5.099577198347374e-05,  -1.336574988109432e-06,   1.963216007271210e-08,   4.626814639676333e-11,
  -1.208732882098816e-11,   6.093256825951530e-13,  -9.601841622908776e-15,  -8.401915113770692e-17,  -3.734624691830411e-18,  -7.600933282087882e-20,   1.177770435277468e-20,
  -1.154821874997811e-22,  -2.042517720073797e-24,  -4.148384748701834e-04,   1.897703837463500e-05,  -4.973749747002105e-07,   7.305379075068675e-09,   1.723856467914416e-11,
  -4.498484152424239e-12,   2.267411335246417e-13,  -3.573409764058001e-15,  -3.127366947681356e-17,  -1.388270830760189e-18,  -2.830249539784611e-20,   4.382436140997144e-21,
  -4.292848627761863e-23,  -7.602609210178503e-25,  -4.685928176507503e-05,   2.143606249225893e-06,  -5.618235338618475e-08,   8.251943112097171e-10,   1.947605041825972e-12,
  -5.081470088886442e-13,   2.561207470555271e-14,  -4.036498485159909e-16,  -3.532744980718769e-18,  -1.567893727113368e-19,  -3.197297860446645e-21,   4.950236354022346e-22,
  -4.848289503946483e-24,  -8.588069812638319e-26,  -1.807432706845576e-02,   5.243539869787722e-04,   1.101300436737699e-06,  -4.981379800891489e-07,   1.276298543603647e-08,
   9.935458799833497e-11,  -1.052724941119596e-11,   3.620132825563644e-13,  -2.005542006006948e-15,  -5.412520593651749e-16,   1.103592365444078e-17,   2.867664716888620e-19,
  -1.213204202542256e-20,   1.091660911080865e-22,  -1.719514975638668e-02,   4.988048653626983e-04,   1.049997976588151e-06,  -4.738781596377781e-07,   1.213748895361198e-08,
   9.474525072015306e-11,  -1.001678672654108e-11,   3.438287916432026e-13,  -1.893419111823408e-15,  -5.144541387957850e-16,   1.047560078193864e-17,   2.730633503586688e-19,
  -1.151739869053701e-20,   1.032801246264232e-22,  -1.552286970691667e-02,   4.502255863596981e-04,   9.514930697231983e-07,  -4.277454326884691e-07,   1.094963356766181e-08,
   8.588651261694315e-11,  -9.045167607569347e-12,   3.094746681797130e-13,  -1.686115094302274e-15,  -4.636724519914848e-16,   9.419434371893015e-18,   2.468969001805825e-19,
  -1.035829417528423e-20,   9.231709241819259e-23,  -1.322120202872279e-02,   3.833969161562369e-04,   8.141264721963959e-07,  -3.642729137084811e-07,   9.318394463341628e-09,
   7.351705128728212e-11,  -7.706582635499181e-12,   2.626449128219974e-13,  -1.412311381844024e-15,  -3.941483087568152e-16,   7.984354542217691e-18,   2.106867716015777e-19,
  -8.782302642489527e-21,   7.768045424496258e-23,  -1.051546542006829e-02,   3.048793675190589e-04,   6.503828895139433e-07,  -2.896866735433366e-07,   7.405447748110973e-09,
   5.875325129236794e-11,  -6.131404220736446e-12,   2.081677100876726e-13,  -1.104960967147713e-15,  -3.128880747320483e-16,   6.320773323905710e-18,   1.678750521479005e-19,
  -6.954079694742728e-21,   6.104924329878439e-23,  -7.670519305559721e-03,   2.223623999116773e-04,   4.761075115984919e-07,  -2.112903271118274e-07,   5.398430813911869e-09,
   4.302277646403947e-11,  -4.473715833284571e-12,   1.514216775768520e-13,  -7.952774518854638e-16,  -2.278852822855310e-16,   4.593359970159571e-18,   1.226350701939419e-19,
  -5.054524461863005e-21,   4.410038473410219e-23,  -4.964838475946589e-03,   1.439130282308849e-04,   3.088868792594318e-07,  -1.367508600370151e-07,   3.492711571637828e-09,
   2.791755743207952e-11,  -2.896158758242749e-12,   9.782727268081226e-14,  -5.101692716219316e-16,  -1.473512030415498e-16,   2.965707707056037e-18,   7.945299438889762e-20,
  -3.263854939457415e-21,   2.835946043900630e-23,  -2.663260940518131e-03,   7.719467532081353e-05,   1.658929051938577e-07,  -7.335391302423977e-08,   1.873165653691957e-09,
   1.499507558118583e-11,  -1.553705155331842e-12,   5.242675341904216e-14,  -2.724059486974052e-16,  -7.900135366240516e-17,   1.588841519655019e-18,   4.264138642013867e-20,
  -1.748678640891064e-21,   1.516168531917712e-23,  -9.910708982943553e-04,   2.872571936713713e-05,   6.175890126458218e-08,  -2.729662385662723e-08,   6.970020767475941e-10,
   5.582583793665636e-12,  -5.781928125317419e-13,   1.950290297832650e-14,  -1.012062797620419e-16,  -2.939315623521055e-17,   5.909869158173720e-19,   1.587070214238038e-20,
  -6.504540777326520e-22,   5.635458878355186e-24,  -1.119491459919922e-04,   3.244784020744497e-06,   6.976607589724674e-09,  -3.083359378850643e-09,   7.873083864924973e-11,
   6.306411956912692e-13,  -6.531167530120611e-14,   2.202887686003476e-15,  -1.142910794204292e-17,  -3.320088773637787e-18,   6.675183105068982e-20,   1.792767251984153e-21,
  -7.346888361116474e-23,   6.364502762066586e-25,  -2.434742699293412e-02,  -1.502656844705076e-04,   3.031790545575746e-05,   1.013307509456883e-07,  -4.003486710609689e-08,
   5.745400524776108e-11,   5.979105737937025e-11,   1.791310236314698e-14,  -7.935187870992972e-14,  -2.517553219042127e-16,   8.963331727332557e-17,   1.389284125857212e-19,
  -1.046321896552017e-19,   2.177486291585227e-22,  -2.316226920701003e-02,  -1.429476414472700e-04,   2.883615575201406e-05,   9.641910117806953e-08,  -3.806114439013809e-08,
   5.466934593392866e-11,   5.681742106520439e-11,   1.677395675356322e-14,  -7.537389863115449e-14,  -2.392779087346740e-16,   8.507222465979300e-17,   1.326706599413523e-19,
  -9.918154237399297e-20,   2.067828078519432e-22,  -2.090832752515920e-02,  -1.290315810084026e-04,   2.602058311950403e-05,   8.706963686518693e-08,  -3.431767649377842e-08,
   4.936834509355164e-11,   5.118793731533154e-11,   1.471638736147402e-14,  -6.785577407242260e-14,  -2.156376060249543e-16,   7.647929923345378e-17,   1.205633239142097e-19,
  -8.896280318341947e-20,   1.860704767208566e-22,  -1.780674531516619e-02,  -1.098849132525789e-04,   2.215086305336464e-05,   7.418772155004976e-08,  -2.918608913660394e-08,
   4.206410268410624e-11,   4.349127084123906e-11,   1.209580427988622e-14,  -5.760152778595418e-14,  -1.832812373435146e-16,   6.481171555755092e-17,   1.035039338969584e-19,
  -7.518470373935588e-20,   1.578515021768188e-22,  -1.416150547182904e-02,  -8.738570518785512e-05,   1.760879242193682e-05,   5.902704970094051e-08,  -2.317988554294346e-08,
   3.346762131147694e-11,   3.450848105230175e-11,   9.282235375615493e-15,  -4.566482529379843e-14,  -1.454757897592115e-16,   5.129617506164427e-17,   8.295118296765329e-20,
  -5.934736628773060e-20,   1.250536094935845e-22,  -1.032950176018213e-02,  -6.373707912914061e-05,   1.283954905296865e-05,   4.307025246984836e-08,  -1.688909345074229e-08,
   2.441990007779076e-11,   2.512401013117894e-11,   6.572452186265593e-15,  -3.322324636816704e-14,  -1.059424344287427e-16,   3.727073558720043e-17,   6.087792929719564e-20,
  -4.302751567795061e-20,   9.092665478049215e-23,  -6.685630096506729e-03,  -4.125181862764462e-05,   8.308331417709864e-06,   2.788327070809534e-08,  -1.092334123008055e-08,
   1.580898827076349e-11,   1.624121909432822e-11,   4.169278919489896e-15,  -2.146701292068946e-14,  -6.849745248031499e-17,   2.406112617642982e-17,   3.956159102476213e-20,
  -2.773782036279641e-20,   5.872647802545525e-23,  -3.586261985377868e-03,  -2.212771596639301e-05,   4.456179573416504e-06,   1.495878923382939e-08,  -5.857253386986888e-09,
   8.481121340370366e-12,   8.706515248939003e-12,   2.213148248753263e-15,  -1.150521107055200e-14,  -3.672298560244573e-17,   1.288970385510497e-17,   2.126517813418727e-20,
  -1.484838801817465e-20,   3.146715057505369e-23,  -1.334534819888815e-03,  -8.234217486585107e-06,   1.658184691347017e-06,   5.566763964332851e-09,  -2.179344148618604e-09,
   3.156155193452187e-12,   3.239193636075302e-12,   8.205475756325090e-16,  -4.280074880521308e-15,  -1.366292227515185e-17,   4.794369445447634e-18,   7.918958754973843e-21,
  -5.521491182912344e-21,   1.170520405078371e-23,  -1.507458891518467e-04,  -9.301169532100946e-07,   1.873034013633975e-07,   6.288127019222377e-10,  -2.461685025282363e-10,
   3.565140426165320e-13,   3.658788853124191e-13,   9.263300741834693e-17,  -4.834439479937473e-16,  -1.543284889708527e-18,   5.415211607623912e-19,   8.946084561626855e-22,
  -6.236237157657766e-22,   1.322111661449958e-24,  -1.224361585697905e-02,  -8.703860654347709e-04,  -2.807591000912979e-05,  -8.124513912616197e-09,   4.654749682256341e-08,
   2.336208301181275e-09,   3.953982095589860e-11,  -1.727605389962432e-12,  -1.393478444286342e-13,  -3.862461318227853e-15,   2.284082916615854e-17,   6.421331415095342e-18,
   2.572235989859131e-19,   2.762800853563769e-21,  -1.164890473964437e-02,  -8.280495951932341e-04,  -2.670194331143850e-05,  -7.038162656024410e-09,   4.430060050779077e-08,
   2.221476672553702e-09,   3.750079456919890e-11,  -1.647635331727332e-12,  -1.325353095470503e-13,  -3.664035356228220e-15,   2.222753536951105e-17,   6.114826208116471e-18,
   2.440859713421973e-19,   2.585965538758360e-21,  -1.051736236338227e-02,  -7.475210044571689e-04,  -2.409189109261103e-05,  -5.253184788395692e-09,   4.001969164576271e-08,
   2.003686823879375e-09,   3.366944412695373e-11,  -1.493856832448775e-12,  -1.195902486712829e-13,  -3.290884092890908e-15,   2.085696766168971e-17,   5.529312911037194e-18,
   2.193474434514715e-19,   2.266953501546460e-21,  -8.959279451284219e-03,  -6.366833036738198e-04,  -2.050603508453466e-05,  -3.341510135197055e-09,   3.411391115199428e-08,
   1.704786556041649e-09,   2.848734091312474e-11,  -1.278983253120143e-12,  -1.017993008792204e-13,  -2.785591463952833e-15,   1.857666246301720e-17,   4.718698198915572e-18,
   1.857876758589584e-19,   1.861418369315868e-21,  -7.126822785634226e-03,  -5.063864008753630e-04,  -1.629893526461515e-05,  -1.783606298194122e-09,   2.715412256784300e-08,
   1.354504368096341e-09,   2.251092448964644e-11,  -1.022337257903667e-12,  -8.091959343505159e-14,  -2.202118065040150e-15,   1.539999441605325e-17,   3.759987817688830e-18,
   1.469616964685394e-19,   1.427008767754736e-21,  -5.199299386048252e-03,  -3.693848335038145e-04,  -1.188309854120600e-05,  -7.877138127331558e-10,   1.982029680822752e-08,
   9.872227570459917e-10,   1.633459389477209e-11,  -7.487319716680303e-13,  -5.899908851426291e-14,  -1.598456762733616e-15,   1.159975778853783e-17,   2.746742465561539e-18,
   1.067264274828798e-19,   1.009575765933001e-21,  -3.365580071175131e-03,  -2.390891610460683e-04,  -7.688838484322928e-06,  -2.903940317783295e-10,   1.283434477824299e-08,
   6.386398216975080e-10,   1.053598278443868e-11,  -4.859003241159148e-13,  -3.817581356078498e-14,  -1.031247830679904e-15,   7.664365516215405e-18,   1.779553029392891e-18,
   6.887612240450248e-20,   6.400687178086179e-22,  -1.805453731539999e-03,  -1.282533498123903e-04,  -4.123752751954140e-06,  -9.533199005679639e-11,   6.886145522632305e-09,
   3.424848697369614e-10,   5.641627130522986e-12,  -2.609993525438452e-13,  -2.047508439644084e-14,  -5.522569854272427e-16,   4.154346786998215e-18,   9.550568969284666e-19,
   3.689055320196807e-20,   3.396627323308818e-22,  -6.718674109109691e-04,  -4.772652352921984e-05,  -1.534464747344586e-06,  -2.764785593130963e-11,   2.562712303966325e-09,
   1.274352225191884e-10,   2.098088684651117e-12,  -9.717023537146977e-14,  -7.618892037645134e-15,  -2.053892236240576e-16,   1.551509124144968e-18,   3.554617658369880e-19,
   1.372066787486748e-20,   1.259204271749832e-22,  -7.589280810493854e-05,  -5.391081217565289e-06,  -1.733280049930317e-07,  -2.982733708985927e-12,   2.894816874223944e-10,
   1.439457118272336e-11,   2.369718713004762e-13,  -1.097694493049235e-14,  -8.606051225504376e-16,  -2.319814730686373e-17,   1.753547269949045e-19,   4.015322814195277e-20,
   1.549725028652329e-21,   1.421513647890431e-23,  -7.255981542295431e-04,   3.565423863264333e-05,  -1.174083134702366e-06,   3.142205161322014e-08,  -7.020293141254857e-10,
   1.891867889110496e-11,  -3.075214208120431e-13,   1.071709347403749e-15,  -3.017127148934047e-16,   3.508213725593446e-18,   2.220905012355223e-19,   4.357963732617940e-21,
   2.994061010848401e-24,  -1.752398638416094e-24,  -6.903399112177187e-04,   3.392281805446405e-05,  -1.117100909365562e-06,   2.989929928751075e-08,  -6.680204705090460e-10,
   1.799915516329483e-11,  -2.928129330147806e-13,   1.023384464516887e-15,  -2.867402155444413e-16,   3.344654620982521e-18,   2.112859489986537e-19,   4.141465228580254e-21,
   2.141919411610984e-24,  -1.701413683201402e-24,  -6.232604905330451e-04,   3.062831763282989e-05,  -1.008663274891173e-06,   2.700056561731715e-08,  -6.032758318230062e-10,
   1.624984117722156e-11,  -2.647339932309521e-13,   9.299296749618420e-16,  -2.583815943856676e-16,   3.030657593296301e-18,   1.907333619905549e-19,   3.731392112257467e-21,
   8.091831897097035e-25,  -1.590202377559454e-24,  -5.309059398099862e-04,   2.609161036114568e-05,  -8.593127536092898e-07,   2.300636709011730e-08,  -5.140538006575666e-10,
   1.384157878151649e-11,  -2.258897303049532e-13,   7.983128483212225e-16,  -2.195834470241104e-16,   2.592886394620531e-18,   1.624448912208127e-19,   3.170438884180088e-21,
  -4.674242863198944e-25,  -1.409842927736060e-24,  -4.223016447367678e-04,   2.075558418610592e-05,  -6.836154063600755e-07,   1.830529167424395e-08,  -4.090291982888270e-10,
   1.100981012037899e-11,  -1.799767965700938e-13,   6.397903909291005e-16,  -1.742698813543808e-16,   2.071193650864005e-18,   1.291923698490622e-19,   2.515547166018877e-21,
  -1.263577707646336e-24,  -1.163739748967485e-24,  -3.080756799764087e-04,   1.514233600280035e-05,  -4.987594200180263e-07,   1.335705389339269e-08,  -2.984710813421036e-10,
   8.031667683063327e-12,  -1.314696002327724e-13,   4.695545208089159e-16,  -1.269007229764261e-16,   1.516084053608476e-18,   9.423364896135242e-20,   1.831342470403203e-21,
  -1.445120610294329e-24,  -8.736252129200432e-25,  -1.994174378360369e-04,   9.801983688820666e-06,  -3.228689761272221e-07,   8.647330212049486e-09,  -1.932337069126572e-10,
   5.198831310078148e-12,  -8.517451032286952e-14,   3.051497029037183e-16,  -8.204369074122890e-17,   9.835469939235872e-19,   6.099099441635909e-20,   1.183786828917510e-21,
  -1.159017921517932e-24,  -5.759814447623461e-25,  -1.069756051700455e-04,   5.258277409579671e-06,  -1.732060591343142e-07,   4.639138846200732e-09,  -1.036675864087707e-10,
   2.788845301772390e-12,  -4.571149593502737e-14,   1.640275104290050e-16,  -4.398424812467813e-17,   5.282161712211791e-19,   3.271620055941285e-20,   6.345756270840165e-22,
  -6.832996055582714e-25,  -3.118574296414765e-25,  -3.980891026139721e-05,   1.956779009135816e-06,  -6.445607988011684e-08,   1.726412767891767e-09,  -3.857908479045850e-11,
   1.037812620306940e-12,  -1.701329816054748e-14,   6.108280544325909e-17,  -1.636435249224059e-17,   1.966433731930725e-19,   1.217446111776301e-20,   2.360858691816107e-22,
  -2.622471877739650e-25,  -1.164238288933729e-25,  -4.496732671955408e-06,   2.210339565643802e-07,  -7.280840310158317e-09,   1.950128733305889e-10,  -4.357835446198536e-12,
   1.172291368589118e-13,  -1.921834607606722e-15,   6.900561304409005e-18,  -1.848420202452264e-18,   2.221382747353114e-20,   1.375197734310108e-21,   2.666671181561526e-23,
  -2.976575850124535e-26,  -1.315766281058208e-26,  -6.313542350954861e-03,   2.797752981596046e-04,  -7.479132156993629e-06,   1.298794398384903e-07,  -5.054933466560318e-10,
  -6.922443578798180e-12,   1.936085535187741e-12,  -9.594610318870078e-14,  -1.141280134780213e-15,   1.250227368085534e-17,   2.233302628444125e-18,   4.965061884827979e-20,
  -3.078054427778713e-22,  -5.091776031003125e-24,  -6.006672053043326e-03,   2.661785150162442e-04,  -7.115432768509428e-06,   1.235598188870215e-07,  -4.800461556034081e-10,
  -6.645569502258740e-12,   1.840980726488203e-12,  -9.126531516247806e-14,  -1.082785771207804e-15,   1.197517465024973e-17,   2.123992728769256e-18,   4.721887003439106e-20,
  -2.997747319999684e-22,  -5.208557004043537e-24,  -5.422879635716584e-03,   2.403111897915870e-04,  -6.423599415773734e-06,   1.115400721579395e-07,  -4.319927636137930e-10,
  -6.094591241024868e-12,   1.660463274106710e-12,  -8.236747203698833e-14,  -9.727363039859698e-16,   1.093960014024987e-17,   1.916331000623287e-18,   4.259905693761021e-20,
  -2.816704037056919e-22,  -5.279492844238238e-24,  -4.619182976686940e-03,   2.046987451262217e-04,  -5.471302891790903e-06,   9.499805343811017e-08,  -3.665310933500368e-10,
  -5.289067709809798e-12,   1.412740859171001e-12,  -7.013151066320379e-14,  -8.236176589642276e-16,   9.450363639977256e-18,   1.631028039521239e-18,   3.625251738895084e-20,
  -2.512740398239027e-22,  -5.086983244696725e-24,  -3.674158929440663e-03,   1.628222533693508e-04,  -4.351723391843137e-06,   7.555398842308693e-08,  -2.904339113558494e-10,
  -4.282426957729591e-12,   1.122455429527986e-12,  -5.576121653810230e-14,  -6.512928907757222e-16,   7.618847383329998e-18,   1.296319688415916e-18,   2.880875389255126e-20,
  -2.086182516059109e-22,  -4.498011165593359e-24,  -2.680294874759721e-03,   1.187799329685096e-04,  -3.174446270804655e-06,   5.511141535727396e-08,  -2.112194956210234e-10,
  -3.168341608061596e-12,   8.180934207176250e-13,  -4.066456062657499e-14,  -4.728717142434352e-16,   5.617787902124987e-18,   9.450516651875060e-19,   2.099938748654087e-20,
  -1.573237043407299e-22,  -3.544809446358859e-24,  -1.734928892940225e-03,   7.688564630874274e-05,  -2.054732177936982e-06,   3.567088365185856e-08,  -1.364417207467557e-10,
  -2.069787018341700e-12,   5.292296169734079e-13,  -2.631611293088773e-14,  -3.051251247276604e-16,   3.661924697944619e-18,   6.114572291792199e-19,   1.358538899919639e-20,
  -1.040292663095675e-22,  -2.406606735718325e-24,  -9.306789761275889e-04,   4.124440850189575e-05,  -1.102217625315096e-06,   1.913455250466220e-08,  -7.311557280769828e-11,
  -1.115528822537800e-12,   2.838115479095018e-13,  -1.411535640218492e-14,  -1.634157737165472e-16,   1.971435814698310e-18,   3.279341264265843e-19,   7.285645606828856e-21,
  -5.640948167054562e-23,  -1.321765983698337e-24,  -3.463333059393565e-04,   1.534828966278813e-05,  -4.101659314984381e-07,   7.120456952950073e-09,  -2.719854063892752e-11,
  -4.157974636358582e-13,   1.056035185015246e-13,  -5.252540811268939e-15,  -6.077761819568020e-17,   7.345423725701189e-19,   1.220244418323268e-19,   2.710937360854243e-21,
  -2.106990810630231e-23,  -4.958482946835862e-25,  -3.912108141775865e-05,   1.733710851252360e-06,  -4.633144455267612e-08,   8.043104223183796e-10,  -3.072111803504426e-12,
  -4.697972411129329e-14,   1.192855062201818e-14,  -5.933123202107152e-16,  -6.864697985440582e-18,   8.298871669119793e-20,   1.378345202065371e-20,   3.062169656807665e-22,
  -2.381415235491651e-24,  -5.608128603079504e-26,  -1.599214164026166e-02,   5.128030127129207e-04,  -3.621334961268090e-06,  -2.886421031599928e-07,   1.294326005180626e-08,
  -5.343368258323862e-11,  -3.513265073334381e-12,   8.699180378202432e-14,  -1.182156899292586e-14,   1.581444499923646e-17,   1.448717855626012e-17,  -3.070188538877136e-20,
  -6.475115453321709e-22,   1.411883024274761e-22,  -1.521438286005784e-02,   4.878343308811880e-04,  -3.442887145008197e-06,  -2.746181744787852e-07,   1.231209164918444e-08,
  -5.078026111793404e-11,  -3.352108505177884e-12,   8.277709796446676e-14,  -1.122719612042356e-14,   1.499793496335677e-17,   1.378090301597285e-17,  -2.890082960651375e-20,
  -6.468685445322114e-22,   1.328632373959935e-22,  -1.373495527611474e-02,   4.403515496513934e-04,  -3.104396449150308e-06,  -2.479366658031521e-07,   1.111218396370900e-08,
  -4.575524575751178e-11,  -3.041593485559346e-12,   7.475343486609516e-14,  -1.010450710468249e-14,   1.346473552651783e-17,   1.243805940365891e-17,  -2.560470077552978e-20,
  -6.330737591060735e-22,   1.176305718637018e-22,  -1.169861563937257e-02,   3.750174181310954e-04,  -2.640320788404118e-06,  -2.112003108671312e-07,   9.461911058777258e-09,
  -3.888175482043268e-11,  -2.606517011647488e-12,   6.369666080397955e-14,  -8.574524888815780e-15,   1.139237312296391e-17,   1.059098576333794e-17,  -2.131485933861899e-20,
  -5.897411987959077e-22,   9.782299136217305e-23,  -9.304650836252171e-03,   2.982382541117844e-04,  -2.097066459673320e-06,  -1.679984609743786e-07,   7.523500889917444e-09,
  -3.085574711279394e-11,  -2.085353808659292e-12,   5.068209947787142e-14,  -6.795244215186169e-15,   9.003131673846808e-18,   8.421256300029591e-18,  -1.657741272052474e-20,
  -5.080293599403737e-22,   7.598893084203937e-23,  -6.787390447705570e-03,   2.175318427375620e-04,  -1.527998461316770e-06,  -1.225587634001379e-07,   5.486837805049158e-09,
  -2.246732178526664e-11,  -1.528356611584787e-12,   3.698244607939569e-14,  -4.942408753344967e-15,   6.533807730289578e-18,   6.141508986098471e-18,  -1.187473539011783e-20,
  -3.934664817600241e-22,   5.437035743054201e-23,  -4.393265743878485e-03,   1.407922962822884e-04,  -9.882849273522414e-07,  -7.933283654565100e-08,   3.550913796656845e-09,
  -1.452495229591332e-11,  -9.923195658131406e-13,   2.394260428939431e-14,  -3.192881071393589e-15,   4.214873890813887e-18,   3.974557726027657e-18,  -7.593877504297489e-21,
  -2.644563277345063e-22,   3.474060431140461e-23,  -2.356667269492048e-03,   7.552226505153659e-05,  -5.299388823901315e-07,  -4.255749742569216e-08,   1.904656475956898e-09,
  -7.786773954787757e-12,  -5.331500077817198e-13,   1.284484579649078e-14,  -1.711044385656178e-15,   2.257067384206857e-18,   2.131879300288768e-18,  -4.048295348664469e-21,
  -1.445539179097305e-22,   1.851172710605607e-23,  -8.769807083859769e-04,   2.810358129718962e-05,  -1.971784067119616e-07,  -1.583697139082834e-08,   7.087555825129050e-10,
  -2.897050294772353e-12,  -1.985088978728053e-13,   4.780099206860923e-15,  -6.365059934765297e-16,   8.394122549870706e-19,   7.933072373555262e-19,  -1.503218305257685e-21,
  -5.414113391154160e-23,   6.872671859442183e-24,  -9.906180172945171e-05,   3.174512476187340e-06,  -2.227236315086024e-08,  -1.788912069136219e-09,   8.005911427944427e-11,
  -3.272332380099292e-13,  -2.242508183510135e-14,   5.399526414817580e-16,  -7.189435399021141e-17,   9.480911429140085e-20,   8.960980601838378e-20,  -1.697417618281210e-22,
  -6.121911788642256e-24,   7.760342135294744e-25,  -2.447034578110820e-02,   8.682606423059731e-05,   2.796928526096842e-05,  -4.569309570588525e-07,  -2.592716926909185e-08,
   1.226670159241117e-09,   2.798652221408711e-11,  -2.041263361528461e-12,  -3.394865411798496e-14,   2.271587197890023e-15,   1.896306284625849e-17,  -2.150711017296763e-18,
   3.428624578813100e-20,   2.861380010966620e-21,  -2.327927534524958e-02,   8.256275653664595e-05,   2.660425539368443e-05,  -4.343448816829550e-07,  -2.465369026591775e-08,
   1.165741430064470e-09,   2.659713718038087e-11,  -1.939568098034437e-12,  -3.227148715450023e-14,   2.157641241744441e-15,   1.810534665947986e-17,  -2.039647486634586e-18,
   3.238242614241076e-20,   2.708668782729188e-21,  -2.101406014660965e-02,   7.446978914142390e-05,   2.400968478149959e-05,  -3.915307767584048e-07,  -2.223643550991323e-08,
   1.050363548266417e-09,   2.396582588607330e-11,  -1.747115822115774e-12,  -2.909173307310113e-14,   1.942321927456089e-15,   1.644695904081021e-17,  -1.831057573867939e-18,
   2.885827475976947e-20,   2.423772195482021e-21,  -1.789690903925833e-02,   6.336238667397698e-05,   2.044218848311974e-05,  -3.328870498123246e-07,  -1.891913711858625e-08,
   8.925569031820880e-10,   2.036631955201947e-11,  -1.484130150121792e-12,  -2.473547153758226e-14,   1.648697003633535e-15,   1.411282574731822e-17,  -1.549083998526077e-18,
   2.419488431271740e-20,   2.042384178544342e-21,  -1.423330088445404e-02,   5.034480353225925e-05,   1.625292791431261e-05,  -2.643070100448104e-07,  -1.503175750726301e-08,
   7.083035484028733e-10,   1.616288213673639e-11,  -1.177372268752229e-12,  -1.964024734129696e-14,   1.306962840901090e-15,   1.130458039927698e-17,  -1.224028066622853e-18,
   1.894795686891298e-20,   1.607513225142557e-21,  -1.038192220487090e-02,   3.669449828408277e-05,   1.185234770172114e-05,  -1.925324609875220e-07,  -1.095580561120942e-08,
   5.157396295644659e-10,   1.176922611091640e-11,  -8.570590842767165e-13,  -1.430709280437079e-14,   9.508324720420042e-16,   8.292731222996437e-18,  -8.881746892133710e-19,
   1.364874023430918e-20,   1.162723282629121e-21,  -6.719580897630801e-03,   2.373832470533445e-05,   7.670137578892421e-06,  -1.245050878330267e-07,  -7.087379847885095e-09,
   3.334201044765999e-10,   7.608883547760510e-12,  -5.539832538637155e-13,  -9.252075389689688e-15,   6.143574698831544e-16,   5.387373883673605e-18,  -5.728828740667747e-19,
   8.760608430083019e-21,   7.483770250984017e-22,  -3.604479813913512e-03,   1.273033723179958e-05,   4.114052754848961e-06,  -6.675621016660955e-08,  -3.800770089857872e-09,
   1.787449302195132e-10,   4.079142478496721e-12,  -2.969613059365317e-13,  -4.960730983169114e-15,   3.292591767122334e-16,   2.895353217420989e-18,  -3.067590754796831e-19,
   4.679137942381683e-21,   4.002905378456991e-22,  -1.341314912401039e-03,   4.736849423715967e-06,   1.530898084998242e-06,  -2.483771622296955e-08,  -1.414229516791230e-09,
   6.650157267201412e-11,   1.517641293800773e-12,  -1.104802302145312e-13,  -1.845721914556377e-15,   1.224877113863003e-16,   1.078141246951857e-18,  -1.140822208499166e-19,
   1.738610079168074e-21,   1.488091203256423e-22,  -1.515117666282876e-04,   5.350558067745660e-07,   1.729258930650924e-07,  -2.805539918681019e-09,  -1.597457017951766e-10,
   7.511613730267782e-12,   1.714236726038585e-13,  -1.247911431602654e-14,  -2.084832425216407e-16,   1.383524778878196e-17,   1.217970043465385e-19,  -1.288519839732886e-20,
   1.963424946076417e-22,   1.680646131662234e-23,  -1.615216357556318e-02,  -1.078960016496793e-03,  -2.206590409496172e-05,   1.135028595039015e-06,   9.577261839049074e-08,
   2.096385684115596e-09,  -8.663006681932025e-11,  -7.466292171674807e-12,  -1.617928227708215e-13,   6.030596585963488e-15,   5.193933900762855e-16,   1.137977395055402e-17,
  -3.787116239915192e-19,  -3.369787377478472e-20,  -1.536714797137476e-02,  -1.026376639846275e-03,  -2.097562309394485e-05,   1.080429439488861e-06,   9.107507468549284e-08,
   1.989786438897717e-09,  -8.254709618868780e-11,  -7.096552878670058e-12,  -1.532345778885041e-13,   5.755135962658019e-15,   4.933652757250702e-16,   1.074910449058444e-17,
  -3.622483171692839e-19,  -3.198677062009988e-20,  -1.387370242183441e-02,  -9.263986639101558e-04,  -1.890869999914800e-05,   9.763262466454959e-07,   8.215564174116179e-08,
   1.788910393246996e-09,  -7.472689325198782e-11,  -6.395914044817447e-12,  -1.372371472270547e-13,   5.223741797830491e-15,   4.441624796774479e-16,   9.581096406801222e-18,
  -3.301104638052534e-19,  -2.876055344486735e-20,  -1.181765306866413e-02,  -7.888714194858946e-04,  -1.607722176210357e-05,   8.325587345114078e-07,   6.990985919619574e-08,
   1.516082843889146e-09,  -6.385951530507892e-11,  -5.436725535390817e-12,  -1.157626213200934e-13,   4.478091843191533e-15,   3.770383470838005e-16,   8.034503357146547e-18,
  -2.843079876624217e-19,  -2.437607307172404e-20,  -9.399992829450509e-03,  -6.273006332367782e-04,  -1.276556459283460e-05,   6.629428865427141e-07,   5.555314217038027e-08,
   1.199972540311653e-09,  -5.095394917514185e-11,  -4.315700672925144e-12,  -9.120434167043875e-14,   3.583753002583605e-15,   2.988936610603565e-16,   6.293276641053789e-18,
  -2.285194897366489e-19,  -1.929391300256889e-20,  -6.857328620824941e-03,  -4.575104362403128e-04,  -9.299268748948997e-06,   4.840348650667439e-07,   4.049412946076110e-08,
   8.718921875493418e-10,  -3.726392596070786e-11,  -3.143145861175538e-12,  -6.602038067191604e-14,   2.627055718434833e-15,   2.174473512432111e-16,   4.533816915955394e-18,
  -1.680844490438744e-19,  -1.401850999341745e-20,  -4.438701134949810e-03,  -2.960972866732105e-04,  -6.013684704861776e-06,   3.134897911278074e-07,   2.619783063638890e-08,
   5.628774646661731e-10,  -2.416022678846494e-11,  -2.032318984246085e-12,  -4.251521283042166e-14,   1.705869653197809e-15,   1.404959912440780e-16,   2.910315161264627e-18,
  -1.093841111010984e-19,  -9.049784608238499e-21,  -2.381085923554997e-03,  -1.588250177687870e-04,  -3.224405441351320e-06,   1.682164963355545e-07,   1.404971309552679e-08,
   3.015377238751028e-10,  -1.297132046063488e-11,  -1.089600530662783e-12,  -2.274638961594428e-14,   9.165728802528547e-16,   7.529659386118654e-17,   1.554490962404718e-18,
  -5.883778234387298e-20,  -4.847925913653833e-21,  -8.860735017064323e-04,  -5.910191095762200e-05,  -1.199695861037286e-06,   6.260472193654561e-08,   5.227829113754091e-09,
   1.121580277099835e-10,  -4.828423515915136e-12,  -4.053937724586900e-13,  -8.456798211312649e-15,   3.412756607642817e-16,   2.801095073572118e-17,   5.776039542408988e-19,
  -2.191597905316255e-20,  -1.803187065595505e-21,  -1.000890100346775e-04,  -6.675998838563813e-06,  -1.355115129460175e-07,   7.071811705303367e-09,   5.905158509842907e-10,
   1.266818267294565e-11,  -5.454338192124795e-13,  -4.579101170520145e-14,  -9.551221644362879e-16,   3.855321395554638e-17,   3.163893993137739e-18,   6.522936517164525e-20,
  -2.475953481881214e-21,  -2.036686096857640e-22,  -5.996134266997193e-04,   2.760500930367787e-05,  -8.532407331129512e-07,   2.280830561433942e-08,  -3.999212713483747e-10,
   1.099415388169025e-11,  -3.794246697477416e-13,  -4.505148637701757e-15,   2.414298154492308e-17,   1.519397468441016e-17,   2.903405708766901e-19,  -6.401810193300521e-21,
  -6.296295927266341e-22,  -1.941598446708648e-23,  -5.704735044080787e-04,   2.626433308616668e-05,  -8.118105739899571e-07,   2.170216225238692e-08,  -3.806380868450418e-10,
   1.045665814839419e-11,  -3.609470730722746e-13,  -4.269830310772284e-15,   2.334706370735515e-17,   1.444405522707286e-17,   2.749891566289177e-19,  -6.133705402737557e-21,
  -5.984552074151609e-22,  -1.834310222679418e-23,  -5.150357282742593e-04,   2.371338641443423e-05,  -7.329766071572589e-07,   1.959682637894053e-08,  -3.438905381024625e-10,
   9.435406713918781e-12,  -3.258092120131071e-13,  -3.828823710879317e-15,   2.167706112187027e-17,   1.302194950396576e-17,   2.462902059950421e-19,  -5.605737389325650e-21,
  -5.393654236705677e-22,  -1.635495417926376e-23,  -4.387121041818448e-04,   2.020070182720212e-05,  -6.244144551540071e-07,   1.669650986851646e-08,  -2.931785846027224e-10,
   8.031944611471499e-12,  -2.774632253092771e-13,  -3.234602235213847e-15,   1.907811237166753e-17,   1.107307146177989e-17,   2.077597066291950e-19,  -4.844550421234517e-21,
  -4.584530690738734e-22,  -1.372011986478470e-23,  -3.489628895625684e-04,   1.606925758952865e-05,  -4.967203965546903e-07,   1.328373120645677e-08,  -2.333943930647182e-10,
   6.384801759155854e-12,  -2.206514436518476e-13,  -2.552196382537392e-15,   1.564603840341570e-17,   8.792911461400560e-18,   1.636902039079492e-19,  -3.906666618805502e-21,
  -3.638874960289942e-22,  -1.075075952792827e-23,  -2.545712802851052e-04,   1.172330119395025e-05,  -3.623881022992360e-07,   9.692292488113154e-09,  -1.703762795663935e-10,
   4.655415569589554e-12,  -1.609374175597557e-13,  -1.849701964679841e-15,   1.168912230466574e-17,   6.405689379381593e-18,   1.184935266792318e-19,  -2.880938511191874e-21,
  -2.649921363586058e-22,  -7.747483348021985e-24,  -1.647829077335679e-04,   7.588719548503978e-06,  -2.345836246406349e-07,   6.274507382093178e-09,  -1.103322339798649e-10,
   3.012428686649501e-12,  -1.041613561524826e-13,  -1.192113068993654e-15,   7.683563051262387e-18,   4.142588317167350e-18,   7.630731806182967e-20,  -1.877992365508165e-21,
  -1.713256076292957e-22,  -4.974241186168514e-24,  -8.839592838225894e-05,   4.070959008410937e-06,  -1.258428608024677e-07,   3.366088970183192e-09,  -5.919980976320790e-11,
   1.615707758120335e-12,  -5.587265586466095e-14,  -6.380661563603449e-16,   4.153981933258463e-18,   2.221198323519970e-18,   4.082598604367603e-20,  -1.011042983234442e-21,
  -9.184935103932872e-23,  -2.657184738573220e-24,  -3.289480144655182e-05,   1.514936976634603e-06,  -4.683034388578682e-08,   1.252649579555927e-09,  -2.203176813136570e-11,
   6.012181147521074e-13,  -2.079144942359820e-14,  -2.372586321463345e-16,   1.549991268589348e-18,   8.264394435745579e-19,   1.517857338512173e-20,  -3.767071424773695e-22,
  -3.417259836583722e-23,  -9.873702591145421e-25,  -3.715728434238731e-06,   1.711243105487628e-07,  -5.289865618613483e-09,   1.414971593934838e-10,  -2.488693703975283e-12,
   6.791171013867983e-14,  -2.348550727631164e-15,  -2.679692443798087e-17,   1.751584944325718e-19,   9.335044916925469e-20,   1.714288971271748e-21,  -4.256043056099468e-23,
  -3.859934239972765e-24,  -1.115053310403733e-25,  -5.304429598015068e-03,   2.260400431695057e-04,  -5.968146170112323e-06,   1.222331256059438e-07,  -4.138867765163114e-10,
   4.309081188412346e-12,  -1.048631731542168e-12,  -1.042678007926568e-13,   1.350874726788666e-15,   1.326501450326833e-16,   3.039836925532011e-18,  -6.063609449592372e-20,
  -6.184204490636812e-21,  -1.949023438425660e-22,  -5.046597935983339e-03,   2.150562849733738e-04,  -5.677928534370318e-06,   1.162887489726688e-07,  -3.942184213487632e-10,
   4.035053906180996e-12,  -9.964787816316527e-13,  -9.905492379583645e-14,   1.289135955837271e-15,   1.260947153077892e-16,   2.879891802442683e-18,  -5.812138458431448e-20,
  -5.879253218046361e-21,  -1.841462039183938e-22,  -4.556100813133631e-03,   1.941595035494757e-04,  -5.125871432400603e-06,   1.049814062460618e-07,  -3.566179847885210e-10,
   3.540133177120706e-12,  -8.977397253464805e-13,  -8.919701315547511e-14,   1.170066573570490e-15,   1.136665607625923e-16,   2.580582890226680e-18,  -5.315737693797739e-20,
  -5.300722281949056e-21,  -1.642087545856939e-22,  -3.880849527560759e-03,   1.653889583015524e-04,  -4.365971050874852e-06,   8.941730557607684e-08,  -3.044996676827709e-10,
   2.909827141505567e-12,  -7.627368202890396e-13,  -7.574023562907304e-14,   1.003032955934635e-15,   9.664115096728998e-17,   2.178156642361300e-18,  -4.597856919235465e-20,
  -4.507555793450940e-21,  -1.377760344761720e-22,  -3.086866908022024e-03,   1.315562755552806e-04,  -3.472579756435952e-06,   7.111953548523704e-08,  -2.427689842014984e-10,
   2.233101376458551e-12,  -6.051772132292650e-13,  -6.006172249979895e-14,   8.027210422992184e-16,   7.672991880629689e-17,   1.717130880592461e-18,  -3.710698549437128e-20,
  -3.579324030243583e-21,  -1.079745981019924e-22,  -2.251859014879564e-03,   9.597234423262092e-05,  -2.533142638000342e-06,   5.187915785465607e-08,  -1.774317888113956e-10,
   1.581283938632035e-12,  -4.405838522243465e-13,  -4.370749773471357e-14,   5.884465040335126e-16,   5.589169007064458e-17,   1.243602319334669e-18,  -2.738131399162982e-20,
  -2.607458392893070e-21,  -7.782098649709459e-23,  -1.457603528543263e-03,   6.212290338785707e-05,  -1.639635737234017e-06,   3.357981671376374e-08,  -1.149917544685282e-10,
   1.003147980280056e-12,  -2.848031715453221e-13,  -2.824551295190271e-14,   3.821154134368236e-16,   3.614259117820326e-17,   8.011070450622997e-19,  -1.785619885844527e-20,
  -1.686187349734903e-21,  -4.996873108145546e-23,  -7.819107391038231e-04,   3.332524307120330e-05,  -8.795484358219218e-07,   1.801314266310595e-08,  -6.172481909721720e-11,
   5.325090592644948e-13,  -1.526732722461452e-13,  -1.513927473020271e-14,   2.053158550970003e-16,   1.937837441318837e-17,   4.286788129471976e-19,  -9.615090508542462e-21,
  -9.040874874600410e-22,  -2.669386135476965e-23,  -2.909721171892444e-04,   1.240134670885051e-05,  -3.273045810190606e-07,   6.703187759536832e-09,  -2.297469699197427e-11,
   1.974353028825356e-13,  -5.680058754019969e-14,  -5.632136465550036e-15,   7.644750837673875e-17,   7.209994469766263e-18,   1.593863246794480e-19,  -3.582764330633597e-21,
  -3.363799040312876e-22,  -9.919185559907158e-24,  -3.286759612925633e-05,   1.400830625017634e-06,  -3.697160924735461e-08,   7.571773024917747e-10,  -2.595264069173464e-12,
   2.228884377437249e-14,  -6.415829681877266e-15,  -6.361649313586478e-16,   8.636126953326318e-18,   8.144029466837871e-19,   1.800147391507356e-20,  -4.047857835788223e-22,
  -3.799572622243990e-23,  -1.120192363603097e-24,  -1.401598065048526e-02,   4.733882256412413e-04,  -5.892089125551013e-06,  -9.457608738083796e-08,   1.102434811141204e-08,
  -1.468158201454930e-10,  -5.507556577705734e-12,  -1.734117605456383e-13,  -1.236812641259575e-15,   5.523988881852854e-16,   1.087815570372574e-17,  -2.740674555804918e-19,
  -1.807049866858253e-20,  -7.439501298260126e-22,  -1.333441100942329e-02,   4.503539464691495e-04,  -5.603535466071880e-06,  -9.001984776873935e-08,   1.048566049182857e-08,
  -1.397801472102763e-10,  -5.240615348029714e-12,  -1.643889466923448e-13,  -1.162389569624895e-15,   5.250660653800887e-16,   1.031361426386439e-17,  -2.623991293221809e-19,
  -1.718919671652345e-20,  -7.031419289429889e-22,  -1.203791840998160e-02,   4.065436011588532e-04,  -5.055471237040381e-06,  -8.133553499430221e-08,   9.462014937042872e-09,
  -1.263541156527958e-10,  -4.732461335317301e-12,  -1.474662330006857e-13,  -1.026691813191066e-15,   4.732608253069928e-16,   9.254201078165666e-18,  -2.395141592216796e-19,
  -1.551315587429479e-20,  -6.274074966203186e-22,  -1.025331359017418e-02,   3.462505428451867e-04,  -4.302671142933092e-06,  -6.934799082219611e-08,   8.055025605284556e-09,
  -1.077911437041887e-10,  -4.032284631846733e-12,  -1.246381882491729e-13,  -8.512239673265903e-16,   4.023191498725605e-16,   7.823972181405140e-18,  -2.066914385846795e-19,
  -1.320750796933007e-20,  -5.268192006411402e-22,  -8.155212952077880e-03,   2.753803031666765e-04,  -3.419657249137146e-06,  -5.521190584524062e-08,   6.403464507308599e-09,
  -8.586396614687255e-11,  -3.208236596032807e-12,  -9.838862724934517e-14,  -6.591598410559204e-16,   3.193862127953836e-16,   6.177976617534846e-18,  -1.664520052438952e-19,
  -1.049960229292246e-20,  -4.131795616171892e-22,  -5.948979260790009e-03,   2.008708578755400e-04,  -2.493024206745957e-06,  -4.030737135300238e-08,   4.669199392865925e-09,
  -6.271107454777372e-11,  -2.340926238009543e-12,  -7.133401727587588e-14,  -4.703712354848094e-16,   2.326230890336638e-16,   4.480209565647807e-18,  -1.226199744170573e-19,
  -7.655618442095413e-21,  -2.979769518057041e-22,  -3.850614139458872e-03,   1.300137312788232e-04,  -1.613021127133500e-06,  -2.610355784247873e-08,   3.021420357964103e-09,
  -4.062356322479860e-11,  -1.515478541647975e-12,  -4.598562362347788e-14,  -2.999956818527219e-16,   1.504162198313315e-16,   2.888615490049630e-18,  -7.987816138790297e-20,
  -4.953641155744960e-21,  -1.914095249287634e-22,  -2.065581281232997e-03,   6.974188378770110e-05,  -8.650933612352172e-07,  -1.400647700897350e-08,   1.620549892184231e-09,
  -2.180056051962991e-11,  -8.130178047764663e-13,  -2.461654374469704e-14,  -1.596991438226118e-16,   8.064496444954913e-17,   1.546423902933805e-18,  -4.298884600555929e-20,
  -2.656805492510871e-21,  -1.022749418868461e-22,  -7.686605252487368e-04,   2.595274115713995e-05,  -3.219023608670807e-07,  -5.212689976227066e-09,   6.030224069850137e-10,
  -8.113749759855563e-12,  -3.025558244082848e-13,  -9.153837516504708e-15,  -5.926968859126275e-17,   3.000471205481605e-17,   5.750643394459319e-19,  -1.601543950082008e-20,
  -9.886092511373605e-22,  -3.800722657232700e-23,  -8.682620982307782e-05,   2.931561891500807e-06,  -3.636097253708036e-08,  -5.888228008931481e-10,   6.811556188420283e-11,
  -9.165320485628796e-13,  -3.417620774520225e-14,  -1.033877955542388e-15,  -6.692128008380747e-18,   3.389167354993486e-18,   6.495078119479454e-20,  -1.809393053251066e-21,
  -1.116700123612058e-22,  -4.292278632996120e-24,  -2.371758312603415e-02,   2.835950952088778e-04,   2.086866454052260e-05,  -6.596577122306907e-07,   3.861156323917351e-10,
   1.166700881329899e-09,  -3.190481917598566e-11,  -1.814656380972708e-12,   4.541927390584603e-14,   1.893198867220571e-15,  -1.964840679004968e-17,   2.429826196917811e-20,
  -1.082318928160445e-20,  -4.258778061474235e-21,  -2.256333158210372e-02,   2.697427622934360e-04,   1.985364023520910e-05,  -6.272283398178185e-07,   3.532511033121292e-10,
   1.108828769817825e-09,  -3.031530131799529e-11,  -1.724365117969030e-12,   4.318359388553225e-14,   1.801061614901633e-15,  -1.871512013706397e-17,   1.354718623284612e-20,
  -1.040513007370187e-20,  -4.029037218006407e-21,  -2.036806687173633e-02,   2.434177456189435e-04,   1.792293184322752e-05,  -5.656840425517851e-07,   2.964865631397158e-10,
   9.992078272488429e-10,  -2.730719492815801e-11,  -1.553444462095341e-12,   3.894179407668928e-14,   1.625805710372311e-15,  -1.693107094889377e-17,  -2.940888745781593e-21,
  -9.563239262067140e-21,  -3.601282236372518e-21,  -1.734703319951843e-02,   2.072303538547656e-04,   1.526550930126087e-05,  -4.812466512436915e-07,   2.294781205264382e-10,
   8.492145424126030e-10,  -2.319659756322751e-11,  -1.319789002778600e-12,   3.312427751409275e-14,   1.384606876956693e-15,  -1.445813264805336e-17,  -1.802443768414533e-20,
  -8.316548731721105e-21,  -3.030386495962972e-21,  -1.379621413508766e-02,   1.647475475862260e-04,   1.214148844140898e-05,  -3.823269994970255e-07,   1.647484935117773e-10,
   6.740070794806002e-10,  -1.840185945462067e-11,  -1.047131515629482e-12,   2.631179814644699e-14,   1.101118511573595e-15,  -1.152856336880048e-17,  -2.623145590623983e-20,
  -6.743662129925599e-21,  -2.381781907115295e-21,  -1.006323920884264e-02,   1.201325275962852e-04,   8.856672225462625e-06,  -2.786354038990673e-07,   1.097502640585296e-10,
   4.908251516387569e-10,  -1.339535205709146e-11,  -7.623266333499882e-13,   1.917342981426703e-14,   8.031244985320256e-16,  -8.426915330057820e-18,  -2.607948467135302e-20,
  -4.993396815535976e-21,  -1.720722336300814e-21,  -6.513373709277910e-03,   7.773897752533683e-05,   5.732610660112285e-06,  -1.802418806036414e-07,   6.658275777070581e-11,
   3.173379454242020e-10,  -8.658377536233585e-12,  -4.927818048703906e-13,   1.240178621249095e-14,   5.197905277234908e-16,  -5.461915781162505e-18,  -1.983622003124911e-20,
  -3.263265065324249e-21,  -1.106640042699750e-21,  -3.493882941588970e-03,   4.169605510542796e-05,   3.075118151620029e-06,  -9.665633107434693e-08,   3.449027564460040e-11,
   1.701301896460334e-10,  -4.641280364024940e-12,  -2.641629545952232e-13,   6.650291632928622e-15,   2.788161762801072e-16,  -2.931977558338377e-18,  -1.145255427235947e-20,
  -1.759012041760887e-21,  -5.916696797696572e-22,  -1.300161140837518e-03,   1.551556933576875e-05,   1.144334718105920e-06,  -3.596455336126136e-08,   1.267596394336837e-11,
   6.329736606773427e-11,  -1.726719562192352e-12,  -9.827916725042178e-14,   2.474450162267363e-15,   1.037533645791668e-16,  -1.091336469747476e-18,  -4.366823384969426e-21,
  -6.556736447299376e-22,  -2.199225360111001e-22,  -1.468631700040100e-04,   1.752592225007580e-06,   1.292614957600413e-07,  -4.062406061244799e-09,   1.429002351921518e-12,
   7.149701870845455e-12,  -1.950387430874864e-13,  -1.110098276413318e-14,   2.795029289062626e-16,   1.171971811317068e-17,  -1.232797428617642e-19,  -4.951482942872092e-22,
  -7.408307943268349e-23,  -2.483741066626794e-23,  -2.069520791827997e-02,  -1.172885158516571e-03,   1.555448896634678e-06,   2.812348017338358e-06,   9.837532404386866e-08,
  -2.718245371643741e-09,  -3.040615520066815e-10,  -4.784831639708657e-12,   4.501767492542430e-13,   2.457586840651856e-14,  -4.541472876288127e-17,  -4.818768605514182e-17,
  -1.519519595923428e-18,   3.859444962889654e-20,  -1.968851450809326e-02,  -1.115586375115192e-03,   1.497011279590050e-06,   2.674737547714095e-06,   9.345615315965859e-08,
  -2.588895225806889e-09,  -2.888976554907928e-10,  -4.526327580191135e-12,   4.281960672718399e-13,   2.330258270914218e-14,  -4.606851529854625e-17,  -4.575188931501080e-17,
  -1.434896752457732e-18,   3.690043763596163e-20,  -1.777369831845883e-02,  -1.006699027174908e-03,   1.378824589917909e-06,   2.413317786840552e-06,   8.415409537389971e-08,
  -2.341669686324220e-09,  -2.602064349076929e-10,  -4.045211956371121e-12,   3.864152575718464e-13,   2.091252616992106e-14,  -4.611975852721609e-17,  -4.115553899552785e-17,
  -1.278357875634670e-18,   3.359910015464998e-20,  -1.513823578091782e-02,  -8.570249858767532e-04,   1.202552672825023e-06,   2.054147080497998e-06,   7.145686270684852e-08,
  -1.999113169970290e-09,  -2.210114028659056e-10,  -3.403430173770526e-12,   3.289701316173223e-13,   1.768449583877939e-14,  -4.390681036805860e-17,  -3.490113445337420e-17,
  -1.071409294763768e-18,   2.890637927287478e-20,  -1.204013545933682e-02,  -6.813212411956337e-04,   9.781631871370412e-07,   1.632731947142167e-06,   5.666414714323481e-08,
  -1.593561076801633e-09,  -1.753082095452733e-10,  -2.674643148460046e-12,   2.615246788764035e-13,   1.396737979030659e-14,  -3.845812091457284e-17,  -2.764053616200306e-17,
  -8.387935012283224e-19,   2.320840562712594e-20,  -8.782667781913996e-03,  -4.968070919956637e-04,   7.262620478369457e-07,   1.190391675436890e-06,   4.123458329019559e-08,
  -1.164508667291324e-09,  -1.276009672714561e-10,  -1.932130589333077e-12,   1.906950189816224e-13,   1.013109222422110e-14,  -3.011377730135325e-17,  -2.009272750364488e-17,
  -6.040573250554765e-19,   1.705448301953689e-20,  -5.684679963895533e-03,  -3.214860583019309e-04,   4.755243470232328e-07,   7.702360385368478e-07,   2.664723407601329e-08,
  -7.546294229995470e-10,  -8.247250437287168e-11,  -1.242538503549164e-12,   1.233968393094132e-13,   6.532954660113330e-15,  -2.036709832842103e-17,  -1.297535295855018e-17,
  -3.876606221499178e-19,   1.109131674206391e-20,  -3.049398668318990e-03,  -1.724313795436734e-04,   2.565810566878644e-07,   4.131018960300327e-07,   1.428256728873763e-08,
  -4.050452736784236e-10,  -4.420754839368036e-11,  -6.643123495060768e-13,   6.618386389253615e-14,   3.497689205120983e-15,  -1.116567719547587e-17,  -6.952039384200500e-18,
  -2.070375347227602e-19,   5.963992231761614e-21,  -1.134762740328072e-03,  -6.416354631273298e-05,   9.567467980030491e-08,   1.537170333512370e-07,   5.313416756781776e-09,
  -1.507597260920049e-10,  -1.644657758275014e-11,  -2.469216981536857e-13,   2.462758820930569e-14,   1.300710509174529e-15,  -4.186112613884840e-18,  -2.585969935876814e-18,
  -7.692609194687895e-20,   2.221209917543389e-21,  -1.281802475111751e-04,  -7.247720114028055e-06,   1.081067397835438e-08,   1.736336511712529e-08,   6.001645766164909e-10,
  -1.703004504755755e-11,  -1.857692554052738e-12,  -2.788658228309271e-14,   2.781855489484939e-15,   1.469096860493408e-16,  -4.734104186921761e-19,  -2.920861692747963e-19,
  -8.687282032156299e-21,   2.509359736916193e-22,  -5.012476202446628e-04,   2.177841801816234e-05,  -6.123780892606184e-07,   1.763961733813053e-08,  -2.785074223291127e-10,
   1.021856373837960e-12,  -4.028525277919000e-13,   6.066366869991345e-15,   6.129865672998731e-16,   1.014579067486136e-17,  -8.066170421732786e-19,  -3.876491919513663e-20,
   8.375563617211744e-23,   6.898658079066179e-23,  -4.768850504853185e-04,   2.072068246313764e-05,  -5.826419318720114e-07,   1.678193614363814e-08,  -2.651384524701712e-10,
   9.759892640361014e-13,  -3.827535425706492e-13,   5.781731886466874e-15,   5.820934916904435e-16,   9.590416080788933e-18,  -7.671594624534426e-19,  -3.672182492958674e-20,
   8.504421800222835e-23,   6.545401077105013e-23,  -4.305372614276912e-04,   1.870811022438205e-05,  -5.260600738270925e-07,   1.515040289147743e-08,  -2.396366171017843e-10,
   8.871943483914238e-13,  -3.447291356856201e-13,   5.235992159855621e-15,   5.237696774052254e-16,   8.559536332832344e-18,  -6.921833061898945e-19,  -3.290024335167381e-20,
   8.524832889838080e-23,   5.880572459963450e-23,  -3.667305987479678e-04,   1.593680188993224e-05,  -4.481423747685020e-07,   1.290454283535701e-08,  -2.043959981712694e-10,
   7.619636674473538e-13,  -2.927914913900697e-13,   4.476535979896467e-15,   4.443432320927439e-16,   7.189756599098980e-18,  -5.891501218188676e-19,  -2.776500737007343e-20,
   8.123917946515054e-23,   4.979383253125046e-23,  -2.917031308026344e-04,   1.267736337427241e-05,  -3.564946162948999e-07,   1.026406065271877e-08,  -1.627909556492229e-10,
   6.109162006599347e-13,  -2.322376712175416e-13,   3.573358853938250e-15,   3.520463909684640e-16,   5.641110325915152e-18,  -4.682547142019325e-19,  -2.188518906458015e-20,
   7.119705632508523e-23,   3.937664120337348e-23,  -2.127975744385674e-04,   9.248722756120955e-06,  -2.600837695949895e-07,   7.487397122874477e-09,  -1.188800145543652e-10,
   4.485122587025818e-13,  -1.690344846410673e-13,   2.614145531360713e-15,   2.560009941194730e-16,   4.069740618408443e-18,  -3.413691989352443e-19,  -1.584838560999492e-20,
   5.576163831748161e-23,   2.858952531793524e-23,  -1.377420058056778e-04,   5.986865289520687e-06,  -1.683588388657779e-07,   4.846424204742118e-09,  -7.700293349424936e-11,
   2.915380435736203e-13,  -1.092509872572435e-13,   1.695251203290737e-15,   1.653578923369874e-16,   2.614939248187548e-18,  -2.208672267597092e-19,  -1.020865562444041e-20,
   3.771593695394784e-23,   1.844752743532148e-23,  -7.388987780144416e-05,   3.211643060285734e-06,  -9.031632421871265e-08,   2.599772039116898e-09,  -4.132177901024837e-11,
   1.567280810782051e-13,  -5.856123490396976e-14,   9.102564681846005e-16,   8.860784975415412e-17,   1.397425926605313e-18,  -1.184538335119282e-19,  -5.462581352395886e-21,
   2.067681492941317e-23,   9.879867131309632e-24,  -2.749662656193093e-05,   1.195156988521091e-06,  -3.360971457896476e-08,   9.674490456564013e-10,  -1.537895292165413e-11,
   5.836677279200244e-14,  -2.178655393830976e-14,   3.388449605923970e-16,   3.296116338613609e-17,   5.193350252924249e-19,  -4.407661831097249e-20,  -2.031013923835451e-21,
   7.751914172041144e-24,   3.674510819937786e-24,  -3.105961199903333e-06,   1.350025825117754e-07,  -3.796488478651538e-09,   1.092809475046524e-10,  -1.737208049397030e-12,
   6.593769363991278e-15,  -2.460858941654024e-15,   3.827721093575228e-17,   3.723000480856852e-18,   5.865065066681286e-20,  -4.978737852025102e-21,  -2.293872496672719e-22,
   8.766691158461191e-25,   4.150276934260922e-25,  -4.486636865731049e-03,   1.840427982048506e-04,  -4.545031201707363e-06,   1.140912019672548e-07,  -7.695776789771295e-10,
  -4.599955369877758e-11,  -2.538814275157251e-12,   2.724145550835007e-14,   6.686149675179804e-15,   9.107491162426344e-17,  -7.788999271506635e-18,  -3.888844837650221e-19,
   4.883012194924910e-22,   6.866650751927462e-22,  -4.268540698481424e-03,   1.751010453725151e-04,  -4.324099380386324e-06,   1.085281463880493e-07,  -7.332562794195266e-10,
  -4.374467591212523e-11,  -2.409819297011081e-12,   2.600964609847155e-14,   6.350526546310304e-15,   8.602412022357257e-17,  -7.408565238456641e-18,  -3.683997265084029e-19,
   5.204540957075170e-22,   6.515813201398086e-22,  -3.853642138468553e-03,   1.580886938551529e-04,  -3.903805451827534e-06,   9.795212980730912e-08,  -6.637138875982549e-10,
  -3.946265563932030e-11,  -2.166706260556370e-12,   2.362780661486304e-14,   5.716366754205478e-15,   7.667283079891156e-17,  -6.685428530291929e-18,  -3.300787358207809e-19,
   5.581984157552095e-22,   5.855218958827295e-22,  -3.282476618021006e-03,   1.346652006021400e-04,  -3.325210417341735e-06,   8.340623392566105e-08,  -5.671181308472313e-10,
  -3.358263364185684e-11,  -1.836440672129751e-12,   2.027515284368203e-14,   4.851725512803349e-15,   6.429455583044365e-17,  -5.691216673395114e-18,  -2.785764241258606e-19,
   5.654342715626060e-22,   4.959161906339120e-22,  -2.610896266862390e-03,   1.071191077019416e-04,  -2.644891414470084e-06,   6.632009532949037e-08,  -4.524555372870213e-10,
  -2.668768051138645e-11,  -1.453679802657007e-12,   1.624114526401870e-14,   3.845659992537584e-15,   5.036136193699304e-17,  -4.524067554305088e-18,  -2.195957909695782e-19,
   5.183814623767121e-22,   3.922620787154869e-22,  -1.904628998626405e-03,   7.814599289985201e-05,  -1.929431007707060e-06,   4.836732529780333e-08,  -3.308641728255282e-10,
  -1.945425458770358e-11,  -1.056323289622815e-12,   1.191432774522957e-14,   2.797494573907256e-15,   3.628282232398384e-17,  -3.298564843660888e-18,  -1.590305229020700e-19,
   4.180528536826874e-22,   2.848579607708612e-22,  -1.232840645666804e-03,   5.058430766539369e-05,  -1.248895904095867e-06,   3.130209514874728e-08,  -2.145059360987771e-10,
  -1.258638570493139e-11,  -6.819820054210015e-13,   7.740259807168205e-15,   1.807409011057510e-15,   2.329131504014541e-17,  -2.134357180757783e-18,  -1.024420651985283e-19,
   2.875272695081797e-22,   1.838292251857067e-22,  -6.613385785904539e-04,   2.713558348779852e-05,  -6.699515310479805e-07,   1.679003868062273e-08,  -1.151625462219194e-10,
  -6.750094480404445e-12,  -3.653539290537559e-13,   4.159903974243926e-15,   9.686284264724574e-16,   1.244092788265710e-17,  -1.144729456755235e-18,  -5.481696953637697e-20,
   1.588801015763906e-22,   9.845904397734700e-23,  -2.461034810353827e-04,   1.009799857601389e-05,  -2.493086595736534e-07,   6.247872420543326e-09,  -4.286754288201807e-11,
  -2.511690337933470e-12,  -1.358961282972868e-13,   1.549025528260066e-15,   3.603347826223838e-16,   4.622732021865492e-18,  -4.259594144704457e-19,  -2.038133161469764e-20,
   5.972364971917028e-23,   3.661961802506218e-23,  -2.779932668720566e-05,   1.140649413133116e-06,  -2.816137768272159e-08,   7.057429365565466e-10,  -4.842444948954980e-12,
  -2.837113031402115e-13,  -1.534941285774890e-14,   1.749926084323120e-16,   4.070049633978131e-17,   5.220503125109445e-19,  -4.811496784724163e-20,  -2.301915266501489e-21,
   6.756999075062321e-24,   4.136117858125610e-24,  -1.222001794699580e-02,   4.244330298589688e-04,  -6.092971405993074e-06,   4.966762554853806e-08,   6.435814624975118e-09,
  -3.212972888018107e-10,  -7.561621789989728e-12,   1.455862466779164e-13,   2.045270387044848e-14,   3.937897100692612e-16,  -2.790600306024605e-17,  -1.387105393475165e-18,
   3.610342808722504e-23,   2.404075324364907e-21,  -1.162581170594753e-02,   4.037927139720907e-04,  -5.795467341794732e-06,   4.715654025740786e-08,   6.119466699556204e-09,
  -3.055764837328789e-10,  -7.177010070450868e-12,   1.389111760373138e-13,   1.942056804358391e-14,   3.724201393300095e-16,  -2.654615297518960e-17,  -1.314135335527378e-18,
   2.539433235901882e-22,   2.281740947858762e-21,  -1.049549128336658e-02,   3.645307623621699e-04,  -5.230045100573608e-06,   4.241891938298528e-08,   5.519091915696387e-09,
  -2.757111110334782e-10,  -6.452311345707995e-12,   1.260460594877852e-13,   1.747250069650672e-14,   3.326856791021658e-16,  -2.395999529209469e-17,  -1.177591585723911e-18,
   5.763982846856752e-22,   2.051189907682030e-21,  -8.939597216372519e-03,   3.104879641005646e-04,  -4.452707257599054e-06,   3.597323378753805e-08,   4.695363526415933e-09,
  -2.346777587798209e-10,  -5.468139417261427e-12,   1.080154675022727e-13,   1.482062652546411e-14,   2.797537058687506e-16,  -2.040186706563158e-17,  -9.940074049328455e-19,
   8.446431304396877e-22,   1.738070321359832e-21,  -7.110355018250801e-03,   2.469526113612344e-04,  -3.540028811393370e-06,   2.849087522681085e-08,   3.730309590623543e-09,
  -1.865328454430274e-10,  -4.327935266499934e-12,   8.641489114084756e-14,   1.174038180227072e-14,   2.197349655205905e-16,  -1.622170487389271e-17,  -7.836738915315628e-19,
   9.417198690005144e-22,   1.375379776587641e-21,  -5.186809082682279e-03,   1.801436571734911e-04,  -2.581440972229091e-06,   2.071198419989524e-08,   2.718651724877285e-09,
  -1.359971809547381e-10,  -3.144621024518514e-12,   6.333014084025870e-14,   8.536314882332510e-15,   1.586678646638912e-16,  -1.182970754497815e-17,  -5.676035514230192e-19,
   8.439135288736919e-22,   9.991326439561340e-22,  -3.357291242957046e-03,   1.166018195656254e-04,  -1.670511582684894e-06,   1.337584872170823e-08,   1.758644871137492e-09,
  -8.799609282367466e-11,  -2.030101377262459e-12,   4.111661597979047e-14,   5.513380942931463e-15,   1.020101465337295e-16,  -7.655427459132695e-18,  -3.656605692635936e-19,
   6.128513261958327e-22,   6.449206829048149e-22,  -1.800951123676548e-03,   6.254851457253421e-05,  -8.960047242033424e-07,   7.166803821965493e-09,   9.430950973429353e-10,
  -4.719504852530403e-11,  -1.087539277995439e-12,   2.209039864625617e-14,   2.954247229641223e-15,   5.453118007352102e-17,  -4.106127638207167e-18,  -1.956738999462586e-19,
   3.470142799930274e-22,   3.454592316504047e-22,  -6.701845810551069e-04,   2.327603893154219e-05,  -3.334146445758844e-07,   2.665881402028779e-09,   3.509141017859733e-10,
  -1.756148052579228e-11,  -4.045139579539879e-13,   8.224884747468119e-15,   1.098931797032227e-15,   2.026798797520039e-17,  -1.527943388151311e-18,  -7.275397459717520e-20,
   1.314940694681264e-22,   1.284908345477014e-22,  -7.570258877493507e-05,   2.629210184812598e-06,  -3.766154162822199e-08,   3.011126490575441e-10,   3.963780855362502e-11,
  -1.983686377509131e-12,  -4.568960921916401e-14,   9.291443447312546e-16,   1.241252906956958e-16,   2.288986932512734e-18,  -1.725920317274435e-19,  -8.217022956712216e-21,
   1.489556378961073e-23,   1.451289203511723e-23,  -2.229737947138697e-02,   4.204178171014456e-04,   1.358665275055073e-05,  -5.219824428538434e-07,   1.304205689153542e-08,
   1.247373092300380e-11,  -5.336996601940307e-11,   5.397975493401863e-13,   9.293109648897974e-14,   2.848337353118068e-16,  -9.140653474545275e-17,  -3.654370507897925e-18,
  -3.258948783277941e-20,   7.917565418769800e-21,  -2.121242029795719e-02,   3.999220093544351e-04,   1.292806240840237e-05,  -4.965882952263723e-07,   1.238418002525158e-08,
   1.220524085239351e-11,  -5.069737707365336e-11,   5.138067808927902e-13,   8.828819015247805e-14,   2.651770435698694e-16,  -8.701396355875148e-17,  -3.458514694629391e-18,
  -3.005530281002132e-20,   7.513975163160102e-21,  -1.914887076682780e-02,   3.609555857549439e-04,   1.167442121043578e-05,  -4.482875463593368e-07,   1.114242523527546e-08,
   1.155727151854181e-11,  -4.564510952929621e-11,   4.642531710109441e-13,   7.950664372327303e-14,   2.301868900353949e-16,  -7.863454265965369e-17,  -3.093395169339271e-18,
  -2.563157654871431e-20,   6.753576821187384e-21,  -1.630895938653464e-02,   3.073595876142749e-04,   9.947138573205716e-06,  -3.818108775809892e-07,   9.451866574848341e-09,
   1.039905302639864e-11,  -3.875180666289915e-11,   3.958314600325352e-13,   6.751650383298875e-14,   1.866386397859940e-16,  -6.705672806192717e-17,  -2.605179326511749e-18,
  -2.030106763461691e-20,   5.721320903578767e-21,  -1.297084967964935e-02,   2.444001494559679e-04,   7.914334205718954e-06,  -3.036676467262605e-07,   7.487932927930639e-09,
   8.699979332241905e-12,  -3.072467592353455e-11,   3.151349710160724e-13,   5.354369727027409e-14,   1.412208311209550e-16,  -5.339362756278827e-17,  -2.049292795618417e-18,
  -1.497812732220183e-20,   4.526341683417657e-21,  -9.461332433100973e-03,   1.782439763278991e-04,   5.774816095711943e-06,  -2.215076426190258e-07,   5.444719525496535e-09,
   6.598491926127311e-12,  -2.235552290921364e-11,   2.300530453079446e-13,   3.896610951201920e-14,   9.879540893965706e-17,  -3.898183385890482e-17,  -1.481539807974564e-18,
  -1.024604008815196e-20,   3.287441376389716e-21,  -6.123848957730161e-03,   1.153560697267711e-04,   3.738545035420442e-06,  -1.433722077570932e-07,   3.516745498167858e-09,
   4.378894158715730e-12,  -1.444569643103134e-11,   1.489789083161588e-13,   2.518218599808137e-14,   6.215047867654391e-17,  -2.524543309848743e-17,  -9.532608471270736e-19,
  -6.343271748007081e-21,   2.121675461820817e-21,  -3.284950739278000e-03,   6.187581307618577e-05,   2.005646343421381e-06,  -7.690798588828447e-08,   1.884426850328604e-09,
   2.378687204590015e-12,  -7.742365572614224e-12,   7.993610799177914e-14,   1.349756464300619e-14,   3.284559859436618e-17,  -1.354603284623990e-17,  -5.097886981324193e-19,
  -3.323534748341215e-21,   1.136414098900466e-21,  -1.222414243767129e-03,   2.302513219397687e-05,   7.463806455618563e-07,  -2.861947720362763e-08,   7.009814887571185e-10,
   8.890258751851295e-13,  -2.880279788550352e-12,   2.974896846900834e-14,   5.021410224920864e-15,   1.215889701887510e-17,  -5.041325267248413e-18,  -1.895036433805585e-19,
  -1.226545513691753e-21,   4.226689935721071e-22,  -1.380810976195480e-04,   2.600857989794773e-06,   8.430994611013715e-08,  -3.232791077516931e-09,   7.917655921099323e-11,
   1.004914265220970e-13,  -3.253344901094748e-13,   3.360423216177226e-15,   5.671822143752957e-16,   1.372297984785029e-18,  -5.694654237973556e-19,  -2.140227891543589e-20,
  -1.383645534089667e-22,   4.773977431039868e-23,  -2.511913419199499e-02,  -1.005472273851759e-03,   4.163614096791373e-05,   3.548087998967817e-06,  -2.836076792872663e-08,
  -9.309645094152208e-09,  -1.339119020708180e-10,   1.854961138252152e-11,   7.020717909725932e-13,  -2.550060463208126e-14,  -2.066235645249909e-15,   9.050007336664748e-18,
   4.512776322048036e-18,   8.017859985329259e-20,  -2.389610103080719e-02,  -9.562545763127203e-04,   3.960574557337699e-05,   3.372775303059723e-06,  -2.703883445397007e-08,
  -8.845367832536280e-09,  -1.268293186161794e-10,   1.762017450822388e-11,   6.652286310026472e-13,  -2.424381514193327e-14,  -1.957097790315623e-15,   8.782798601864452e-18,
   4.273509377757010e-18,   7.531496372597187e-20,  -2.157025395456107e-02,  -8.627637665215334e-04,   3.574580388418900e-05,   3.040426036220939e-06,  -2.450063498951946e-08,
  -7.966938526447005e-09,  -1.135917960189732e-10,   1.586335271438211e-11,   5.962595975071267e-13,  -2.185956125769473e-14,  -1.753068315711160e-15,   8.201224713356945e-18,
   3.826534992649310e-18,   6.646876605170556e-20,  -1.836996979234179e-02,  -7.343302661512972e-04,   3.043713479271127e-05,   2.585144410954386e-06,  -2.096142639308746e-08,
  -6.766932616132818e-09,  -9.582328766818293e-11,   1.346673820303436e-11,   5.034701053186132e-13,  -1.859051099643811e-14,  -1.479101946973808e-15,   7.261587572033159e-18,
   3.227003966724261e-18,   5.506509071825204e-20,  -1.460903734278214e-02,  -5.836579919752478e-04,   2.420161163523510e-05,   2.052653428559911e-06,  -1.674353427838528e-08,
  -5.367660029909356e-09,  -7.550194096550895e-11,   1.067645513445862e-11,   3.970724861081123e-13,  -1.476402413370576e-14,  -1.165634031233465e-15,   5.985339583384993e-18,
   2.541898798956944e-18,   4.261656392760365e-20,  -1.065570292033345e-02,  -4.255207216972515e-04,   1.765005413481146e-05,   1.495293392848013e-06,  -1.225562298984302e-08,
  -3.906992734696591e-09,  -5.465909476164134e-11,   7.767816117667709e-12,   2.876793660411221e-13,  -1.075652760016951e-14,  -8.439789474774861e-16,   4.487476392342646e-18,
   1.839746416512691e-18,   3.040185202725683e-20,  -6.896660247459625e-03,  -2.753255333630213e-04,   1.142257014013949e-05,   9.669853152600624e-07,  -7.950512256690277e-09,
  -2.525238470184012e-09,  -3.520150256381399e-11,   5.019207732104085e-12,   1.853664333340266e-13,  -6.956616750832894e-15,  -5.435942790986553e-16,   2.955942283120327e-18,
   1.184641679152067e-18,   1.938764219206377e-20,  -3.699434087474978e-03,  -1.476643680757235e-04,   6.126892561061332e-06,   5.184773424012872e-07,  -4.269771706031524e-09,
  -1.353605804045284e-09,  -1.883421294709612e-11,   2.690055707749507e-12,   9.920486965167054e-14,  -3.730123266049199e-15,  -2.908603164542265e-16,   1.599694527258268e-18,
   6.337781961452857e-19,   1.032045112793923e-20,  -1.376645358523922e-03,  -5.494638060601965e-05,   2.279922413555390e-06,   1.929086176103037e-07,  -1.589533557667396e-09,
  -5.035843681449290e-10,  -7.002409932062782e-12,   1.000735006669200e-12,   3.688700673621744e-14,  -1.387874139889041e-15,  -1.081415821570158e-16,   5.971040022717386e-19,
   2.356268590483406e-19,   3.830237975578877e-21,  -1.555025323413029e-04,  -6.206557277382331e-06,   2.575338685023007e-07,   2.178997418095837e-08,  -1.795615580875738e-10,
  -5.688145428524880e-11,  -7.908635127685781e-13,   1.130352803691775e-13,   4.166139760401938e-15,  -1.567674741712105e-16,  -1.221372200016608e-17,   6.748002715427619e-20,
   2.661195671293518e-20,   4.324709774901179e-22,  -4.227000347609458e-04,   1.764893649670287e-05,  -4.282089388078047e-07,   1.292084584575847e-08,  -3.291587509573792e-10,
  -4.349501470290754e-12,   3.575123354167546e-14,   2.263976228472989e-14,   1.068240845013594e-16,  -4.014038120701464e-17,  -9.682909532720067e-19,   5.801097048289797e-20,
   2.934451589514460e-21,  -5.049595971740189e-23,  -4.021525828063294e-04,   1.679163640392188e-05,  -4.074393902471212e-07,   1.229112139374385e-08,  -3.131321067047563e-10,
  -4.124004660155780e-12,   3.409408637322005e-14,   2.149623861860326e-14,   1.003778662200954e-16,  -3.809421938241818e-17,  -9.156235880599383e-19,   5.507108488320475e-20,
   2.774681867843404e-21,  -4.812593135151054e-23,  -3.630637996053618e-04,   1.516048716750657e-05,  -3.679095087599176e-07,   1.109382813420558e-08,  -2.826541772987195e-10,
  -3.700784571747991e-12,   3.090734688361963e-14,   1.933846556041632e-14,   8.863472624688741e-17,  -3.424055026368199e-17,  -8.177534901046924e-19,   4.952689310817203e-20,
   2.477852802526751e-21,  -4.357846819437661e-23,  -3.092526065916485e-04,   1.291449642769132e-05,  -3.134550500977473e-07,   9.446886042706262e-09,  -2.407176714171579e-10,
  -3.129289008187185e-12,   2.645536780906223e-14,   1.640202752752823e-14,   7.346661518829944e-17,  -2.901054691611204e-17,  -6.874792284567111e-19,   4.198890486233955e-20,
   2.082868249560885e-21,  -3.724741337733435e-23,  -2.459809676460058e-04,   1.027302871906527e-05,  -2.493814588756606e-07,   7.512035082138592e-09,  -1.914345826053484e-10,
  -2.471347437917195e-12,   2.114057436839052e-14,   1.299221408378247e-14,   5.687962319732081e-17,  -2.295572815590319e-17,  -5.398748537980158e-19,   3.324548833313578e-20,
   1.635487791318730e-21,  -2.972030736417305e-23,  -1.794413024651699e-04,   7.494555679718325e-06,  -1.819559230737648e-07,   5.478765985668689e-09,  -1.396304742241118e-10,
  -1.792449846900623e-12,   1.547851263324868e-14,   9.446060130005952e-15,   4.058523306029717e-17,  -1.667604810622635e-17,  -3.897796342154946e-19,   2.416248329147685e-20,
   1.180689489242027e-21,  -2.173302751387184e-23,  -1.161499570526886e-04,   4.851321119608375e-06,  -1.177921716676915e-07,   3.545816387784737e-09,  -9.037252993000115e-11,
  -1.155796789228350e-12,   1.004297223905849e-14,   6.100793858758456e-15,   2.588392508187700e-17,  -1.076430569728338e-17,  -2.505738154558940e-19,   1.560158073204356e-20,
   7.589757053233062e-22,  -1.408901734457865e-23,  -6.230688118975976e-05,   2.602471381271079e-06,  -6.319182583815968e-08,   1.901957519698548e-09,  -4.847665347764611e-11,
  -6.187899391932729e-13,   5.393948344578493e-15,   3.268959923646174e-15,   1.377893903099247e-17,  -5.766127045936555e-18,  -1.339427197630071e-19,   8.358626379230085e-21,
   4.056943429315476e-22,  -7.563628858271759e-24,  -2.318621870439188e-05,   9.684629324696536e-07,  -2.351605110029721e-08,   7.077558386882071e-10,  -1.803928481317682e-11,
  -2.301119879565660e-13,   2.008091879943078e-15,   1.215994578140279e-15,   5.113824986185283e-18,  -2.144680771346885e-18,  -4.978273714892482e-20,   3.109116203712478e-21,
   1.507836797327149e-22,  -2.815389901980970e-24,  -2.619066050928805e-06,   1.093956421653508e-07,  -2.656332512654773e-09,   7.994626821930160e-11,  -2.037673938990104e-12,
  -2.599013170978664e-14,   2.268449360852795e-16,   1.373475403161966e-16,   5.774009478506047e-19,  -2.422395134416969e-19,  -5.622254380389052e-21,   3.511745376070316e-22,
   1.702885239945242e-23,  -3.180337180432498e-25,  -3.814926300450489e-03,   1.528612803441521e-04,  -3.289113603308163e-06,   9.181339880864428e-08,  -2.109538893741009e-09,
  -7.345498539913389e-11,   1.117747580665183e-12,   2.065720577683558e-13,   1.400705746298697e-15,  -4.052801262578230e-16,  -9.645685560983829e-18,   5.783189720075587e-19,
   2.984063171746281e-20,  -4.963347608580528e-22,  -3.629465365343871e-03,   1.454342047871343e-04,  -3.129505101999198e-06,   8.732611708920273e-08,  -2.006427598095426e-09,
  -6.975515175997781e-11,   1.064475107122949e-12,   1.960969755867268e-13,   1.320129623312876e-15,  -3.846327265842114e-16,  -9.119898579765826e-18,   5.490248360340243e-19,
   2.821431606634568e-20,  -4.732327159056618e-22,  -3.276657749802194e-03,   1.313037534798584e-04,  -2.825759120631650e-06,   7.879956894877247e-08,  -1.810501909093424e-09,
  -6.276961809766124e-11,   9.626857079235432e-13,   1.763472572769661e-13,   1.172026074565897e-15,  -3.457414976969315e-16,  -8.143271602953572e-18,   4.937744005966499e-19,
   2.519346222970536e-20,  -4.288194641672670e-22,  -2.790982243315682e-03,   1.118484324707534e-04,  -2.407392941226983e-06,   6.708073387239886e-08,  -1.541228833491014e-09,
  -5.325525849199450e-11,   8.217082370906848e-13,   1.495022005685347e-13,   9.780848191452882e-16,  -2.929512722784894e-16,  -6.844123044868458e-18,   4.186436728641066e-19,
   2.117485206785440e-20,  -3.668252613802805e-22,  -2.219938332244560e-03,   8.896920340382511e-05,  -1.915199854058280e-06,   5.332579852137883e-08,  -1.225180990485645e-09,
  -4.219700639636433e-11,   6.548910417631116e-13,   1.183698676166310e-13,   7.624774737218360e-16,  -2.318240844891632e-16,  -5.373222400460015e-18,   3.314850051508693e-19,
   1.662467149494831e-20,  -2.929245976055968e-22,  -1.619415728257965e-03,   6.490498347761386e-05,  -1.397328722984647e-06,   3.888286927651508e-08,  -8.933372475012601e-10,
  -3.068716476679858e-11,   4.784936101471292e-13,   8.603063966247016e-14,   5.471805258790084e-16,  -1.684159775232764e-16,  -3.878517633000840e-18,   2.409291454247834e-19,
   1.200047558214387e-20,  -2.143329192574799e-22,  -1.048220632666045e-03,   4.201324204854370e-05,  -9.045596605595729e-07,   2.516071312704649e-08,  -5.780641192442074e-10,
  -1.982273223700645e-11,   3.100428411386563e-13,   5.555019721537706e-14,   3.503361718644088e-16,  -1.087154350398868e-16,  -2.492980401668474e-18,   1.555704543381901e-19,
   7.713686636305750e-21,  -1.390022099216463e-22,  -5.623005227519472e-04,   2.253767255146357e-05,  -4.852613833825156e-07,   1.349497733319854e-08,  -3.100438008317582e-10,
  -1.062241537164530e-11,   1.664055587208568e-13,   2.976156261009801e-14,   1.868762797783643e-16,  -5.823674990590374e-17,  -1.332507050553218e-18,   8.334870915606128e-20,
   4.123047035967533e-21,  -7.463777192475398e-23,  -2.092483263627252e-04,   8.386968970099044e-06,  -1.805831186128414e-07,   5.021604463175825e-09,  -1.153699287051837e-10,
  -3.951464035964813e-12,   6.193573381672375e-14,   1.107029674582493e-14,   6.940554077930428e-17,  -2.166098873653748e-17,  -4.952423034246856e-19,   3.100293459912403e-20,
   1.532387213221538e-21,  -2.778416044468873e-23,  -2.363624327058289e-05,   9.473749248781306e-07,  -2.039834169237680e-08,   5.672248962840915e-10,  -1.303182634370929e-11,
  -4.463230318323498e-13,   6.996332201141297e-15,   1.250390231502244e-15,   7.837455000160198e-18,  -2.446589073926708e-18,  -5.593036305858973e-20,   3.501782498505549e-21,
   1.730608148643273e-22,  -3.138605216518134e-24,  -1.061423669084336e-02,   3.792839875757463e-04,  -5.115955975523495e-06,   9.415977219871278e-08,  -1.073666510331099e-09,
  -3.771482995649523e-10,   5.674983456493891e-12,   7.140592933125845e-13,   3.819107044330879e-15,  -1.397164964522023e-15,  -3.517574076571193e-17,   2.086420475514396e-18,
   1.100810430965629e-19,  -1.763530408661446e-21,  -1.009810908870413e-02,   3.608436742467816e-04,  -4.867299491554956e-06,   8.946903345454696e-08,  -1.018901167317907e-09,
  -3.583647977592634e-10,   5.401871251165341e-12,   6.778549995201919e-13,   3.587976405892185e-15,  -1.325834756625397e-15,  -3.325611645945871e-17,   1.980782979107241e-18,
   1.040637844898380e-19,  -1.682628887525611e-21,  -9.116314126465448e-03,   3.257647738008238e-04,  -4.394250804680057e-06,   8.059192099407952e-08,  -9.157627458888769e-10,
  -3.228160976477333e-10,   4.881142703063970e-12,   6.095936873588127e-13,   3.167158793388526e-15,  -1.191536533302360e-15,  -2.969135552835783e-17,   1.781522433281197e-18,
   9.289358010042685e-20,  -1.526560695725973e-21,  -7.764869217887965e-03,   2.774763463008865e-04,  -3.743008506858119e-06,   6.846109404332508e-08,  -7.758064721600062e-10,
  -2.742345862603157e-10,   4.162070900966885e-12,   5.168050132087738e-13,   2.624067094193617e-15,  -1.009357111407667e-15,  -2.495100927629851e-17,   1.510523837207734e-18,
   7.804709843582750e-20,  -1.307717393998505e-21,  -6.175998431271853e-03,   2.207017336636458e-04,  -2.977242594994263e-06,   5.431091274030281e-08,  -6.138143879506794e-10,
  -2.175610608358778e-10,   3.313853058264606e-12,   4.091926209376957e-13,   2.030768652020883e-15,  -7.985532222170104e-16,  -1.958602442848589e-17,   1.196094245447989e-18,
   6.125351776003171e-20,  -1.045650484377404e-21,  -4.505219067972239e-03,   1.609977816074363e-04,  -2.171897344959521e-06,   3.953528322851668e-08,  -4.458531184376669e-10,
  -1.583771586188255e-10,   2.419351800596746e-12,   2.974034936616983e-13,   1.448510652288603e-15,  -5.800214915717519e-16,  -1.413611238477488e-17,   8.693703463281072e-19,
   4.420257716611387e-20,  -7.658948115989604e-22,  -2.916114087502775e-03,   1.042106375917770e-04,  -1.405848898191271e-06,   2.555471652563846e-08,  -2.877733224634115e-10,
  -1.023736660571916e-10,   1.566825368399189e-12,   1.920360612010201e-13,   9.235968898902744e-16,  -3.743655275466856e-16,  -9.085564754124436e-18,   5.613728351353602e-19,
   2.840700151828467e-20,  -4.970409103887630e-22,  -1.564290253363444e-03,   5.590191790012925e-05,  -7.541486935838476e-07,   1.369854410246746e-08,  -1.541452940240937e-10,
  -5.487779196690767e-11,   8.407215053736864e-13,   1.028857303090846e-13,   4.916039730002535e-16,  -2.005269929005600e-16,  -4.856088600413139e-18,   3.007651623290047e-19,
   1.518229677793303e-20,  -2.669783488766228e-22,  -5.821163755289691e-04,   2.080270548118643e-05,  -2.806411659828734e-07,   5.096348870451995e-09,  -5.733266869298055e-11,
  -2.041658688512821e-11,   3.128857728489487e-13,   3.827008788958624e-14,   1.824429155730897e-16,  -7.458369633660571e-17,  -1.804800753938228e-18,   1.118749770069955e-19,
   5.642509345585542e-21,  -9.939521412078207e-23,  -6.575459566178951e-05,   2.349828767025706e-06,  -3.170063596266138e-08,   5.756497854466104e-10,  -6.475651027289850e-12,
  -2.306123817344228e-12,   3.534342548281543e-14,   4.322608405374877e-15,   2.059945358482375e-17,  -8.424129944379795e-18,  -2.038253916927997e-19,   1.263628929797713e-20,
   6.372356489520726e-22,  -1.122827230497287e-23,  -2.043346908912910e-02,   5.072196949438308e-04,   8.385946265136936e-06,  -3.699088976543205e-07,   3.368333658980396e-09,
  -7.739573678613002e-10,  -1.742777625975532e-12,   2.706930584051913e-12,   8.496290303701935e-15,  -5.109046677328397e-15,  -9.390382657685629e-17,   7.377770155422009e-18,
   3.720521480986246e-19,  -6.697495514198340e-21,  -1.943932821687780e-02,   4.825149364217698e-04,   7.978650072754730e-06,  -3.521413848765096e-07,   3.203743849985549e-09,
  -7.346471447655842e-10,  -1.651617529292450e-12,   2.569878232621766e-12,   7.963084512734943e-15,  -4.848628614182170e-15,  -8.863435204421618e-17,   7.003171265119583e-18,
   3.514160228633351e-19,  -6.387974288529053e-21,  -1.754846157450261e-02,   4.355372521086240e-04,   7.203683037123155e-06,  -3.182534493711514e-07,   2.890985060935376e-09,
  -6.605558749083157e-10,  -1.480952357812278e-12,   2.311395985441367e-12,   6.998889697072326e-15,  -4.358161728794620e-15,  -7.890329436764421e-17,   6.296993864720816e-18,
   3.132206857655536e-19,  -5.791802373227913e-21,  -1.494610406389745e-02,   3.709043327864703e-04,   6.136560194021648e-06,  -2.714327621848172e-07,   2.461106281465068e-09,
  -5.598942884895691e-10,  -1.251215647311657e-12,   1.959887302773924e-12,   5.767522392653929e-15,  -3.692514301920323e-15,  -6.606926993929084e-17,   5.337387476386932e-18,
   2.626740820760676e-19,  -4.957663640406464e-21,  -1.188709894606604e-02,   2.949571337137564e-04,   4.881484523112560e-06,  -2.161675008159777e-07,   1.956503485258274e-09,
  -4.432188519705740e-10,  -9.874781055308897e-13,   1.552032393840541e-12,   4.439230471405689e-15,  -2.921872359758870e-15,  -5.168018151790440e-17,   4.225023326933171e-18,
   2.057787210422669e-19,  -3.961130758749027e-21,  -8.670903403497843e-03,   2.151326606206505e-04,   3.561262954593051e-06,  -1.578500088072359e-07,   1.426627165943254e-09,
  -3.220799090480707e-10,  -7.158903803879744e-13,   1.128169748828075e-12,   3.152044700510037e-15,  -2.122592847625735e-15,  -3.719234864447868e-17,   3.070133778663311e-18,
   1.482764750739630e-19,  -2.899564694286393e-21,  -5.612282885358242e-03,   1.392369254454803e-04,   2.305267351011969e-06,  -1.022413871063485e-07,   9.231689249453333e-10,
  -2.079464892607157e-10,  -4.615017771242599e-13,   7.285306721870584e-13,   2.003599389092422e-15,  -1.370130535540541e-15,  -2.385819116268991e-17,   1.982120811523067e-18,
   9.519634035648179e-20,  -1.880948010051824e-21,  -3.010547640919542e-03,   7.468724464058402e-05,   1.236655812214433e-06,  -5.486432531442953e-08,   4.951463032057249e-10,
  -1.114034680736626e-10,  -2.470508285170617e-13,   3.903363936670290e-13,   1.064738238401738e-15,  -7.339413957367231e-16,  -1.273910423646162e-17,   1.061862560967301e-18,
   5.085228054132293e-20,  -1.010109294833494e-21,  -1.120303228606099e-03,   2.779275947825017e-05,   4.601998168092785e-07,  -2.041901817444133e-08,   1.842489352517520e-10,
  -4.143756349834391e-11,  -9.186844220009143e-14,   1.451944192864470e-13,   3.949195160221434e-16,  -2.729859385345456e-16,  -4.732932054284872e-18,   3.949667319239831e-19,
   1.889591041865561e-20,  -3.760326878022091e-22,  -1.265468976279764e-04,   3.139401157475707e-06,   5.198326446776057e-08,  -2.306531837409416e-09,   2.081219781091824e-11,
  -4.680359848915217e-12,  -1.037607504486905e-14,   1.639975650124797e-14,   4.458596642309654e-17,  -3.083348932545115e-17,  -5.344846814903929e-19,   4.461131438669520e-20,
   2.133945398624208e-21,  -4.247838035176690e-23,  -2.823493878600652e-02,  -5.240652605645707e-04,   7.533916809492439e-05,   1.636592344352712e-06,  -1.969042268045646e-07,
  -5.079008838610894e-09,   4.719110878374197e-10,   1.499137234008773e-11,  -1.040268987587310e-12,  -4.146596700265796e-14,   2.118817636410004e-15,   1.077944636442280e-16,
  -3.969519634242587e-18,  -2.656130140228628e-19,  -2.685939332366043e-02,  -4.984314388055478e-04,   7.164002932029244e-05,   1.555506115141752e-06,  -1.871195426684117e-07,
  -4.822807562956046e-09,   4.481070435427117e-10,   1.421897358449343e-11,  -9.868969892347975e-13,  -3.927840863159820e-14,   2.008164243535065e-15,   1.019602701968244e-16,
  -3.758801384196211e-18,  -2.508420735260623e-19,  -2.424384133020231e-02,  -4.497313579292822e-04,   6.461796938188455e-05,   1.401876923635205e-06,  -1.685927000055344e-07,
  -4.339242138220249e-09,   4.031777494827080e-10,   1.276759600665497e-11,  -8.865183627285417e-13,  -3.518809237914961e-14,   1.800822599954598e-15,   9.110899160582708e-17,
  -3.365285127950852e-18,  -2.235209433250030e-19,  -2.064556903073128e-02,  -3.828144012314150e-04,   5.498026164906216e-05,   1.191595805152470e-06,  -1.432564700353861e-07,
  -3.680922482061018e-09,   3.420108580613604e-10,   1.080423773079950e-11,  -7.505575681030245e-13,  -2.969397736727535e-14,   1.521470510024136e-15,   7.664475978316159e-17,
  -2.837675960035663e-18,  -1.873968602434617e-19,  -1.641772940282362e-02,  -3.042915240996764e-04,   4.368497662296084e-05,   9.458727440169440e-07,  -1.136784969671458e-07,
  -2.916145114004836e-09,   2.709520307990775e-10,   8.539206902394295e-12,  -5.934882511739100e-13,  -2.340508986962967e-14,   1.200633415436726e-15,   6.022887241380355e-17,
  -2.234994064965439e-18,  -1.467705079220825e-19,  -1.197434951473413e-02,  -2.218605205057348e-04,   3.184052921370342e-05,   6.888765415735016e-07,  -8.277025687542804e-08,
  -2.120467419974292e-09,   1.970219368736199e-10,   6.197398882244392e-12,  -4.308922423675708e-13,  -1.694912072577030e-14,   8.702703843799445e-16,   4.350837493827692e-17,
  -1.617499396394991e-18,  -1.057386161445451e-19,  -7.749868800470580e-03,  -1.435569602297425e-04,   2.059826662349131e-05,   4.454177563472582e-07,  -5.350888077293882e-08,
  -1.369632609025683e-09,   1.272584711679274e-10,   3.997903837469228e-12,  -2.780354818706530e-13,  -1.091785613842579e-14,   5.609360538987074e-16,   2.798041028808362e-17,
  -1.041487937886190e-18,  -6.787897307706834e-20,  -4.157032957353460e-03,  -7.699507684636166e-05,   1.104641091383829e-05,   2.388047113413555e-07,  -2.868553207668893e-08,
  -7.339161047339008e-10,   6.819127201810105e-11,   2.140879358639531e-12,  -1.489072455761358e-13,  -5.842137765409044e-15,   3.002520120126965e-16,   1.495972273356895e-17,
  -5.571799655040142e-19,  -3.625793317702920e-20,  -1.546919423444406e-03,  -2.865033052578216e-05,   4.110277120703928e-06,   8.884903641101569e-08,  -1.067233375521383e-08,
  -2.730078464398766e-10,   2.536631674920398e-11,   7.962006883939638e-13,  -5.538161090018979e-14,  -2.172144937949434e-15,   1.116480183381909e-16,   5.560494101189291e-18,
  -2.071476234016673e-19,  -1.347264480841572e-20,  -1.747361159805015e-04,  -3.236248319726485e-06,   4.642807140667433e-07,   1.003589023310598e-08,  -1.205481254422486e-09,
  -3.083652538632792e-11,   2.865152242385598e-12,   8.992847862837479e-14,  -6.255231105441605e-15,  -2.453270900905931e-16,   1.261000785089561e-17,   6.279859181067897e-19,
  -2.339545482040288e-20,  -1.521483164134161e-21,  -3.581071158891416e-04,   1.474866019727143e-05,  -3.069123584600926e-07,   7.208989952026638e-09,  -3.603593743613599e-10,
   3.058511665677178e-12,   4.849625123523265e-13,   2.171336823518313e-15,  -1.188547091369280e-15,  -7.635649627143551e-18,   2.389122313116025e-18,   2.760714417122680e-20,
  -4.622467191461518e-21,  -8.002526409692025e-23,  -3.406978862271363e-04,   1.403192522580057e-05,  -2.920478008784567e-07,   6.859255649413578e-09,  -3.426188220683778e-10,
   2.911063344441323e-12,   4.604022155281071e-13,   2.057846803415194e-15,  -1.127611099455065e-15,  -7.220792838682544e-18,   2.264094388234417e-18,   2.608691723938835e-20,
  -4.375047210302612e-21,  -7.552529297930254e-23,  -3.075798193196988e-04,   1.266835236430745e-05,  -2.637477654346110e-07,   6.193650778153388e-09,  -3.089612698988582e-10,
   2.630057360235619e-12,   4.140841957536615e-13,   1.845239890151260e-15,  -1.012990066416496e-15,  -6.449743652215583e-18,   2.029922424382835e-18,   2.326927785382143e-20,
  -3.913801609965281e-21,  -6.722048058381607e-23,  -2.619894483460361e-04,   1.079104734997844e-05,  -2.247458110176694e-07,   5.276804988670655e-09,  -2.628036965331861e-10,
   2.242240266081626e-12,   3.511019604117812e-13,   1.558877895714510e-15,  -8.577055502262971e-16,  -5.423104983213749e-18,   1.714620718770676e-18,   1.953273786084415e-20,
  -3.296934450038344e-21,  -5.627595521394981e-23,  -2.083855553622335e-04,   8.583499709585942e-06,  -1.788326690431709e-07,   4.198076769015924e-09,  -2.087540870826711e-10,
   1.785020385062880e-12,   2.780300869097813e-13,   1.230076654056815e-15,  -6.782700165948198e-16,  -4.259450826258359e-18,   1.352742156160714e-18,   1.531656729551776e-20,
  -2.594230909916272e-21,  -4.401355122085694e-23,  -1.520145071418339e-04,   6.261746822883478e-06,  -1.304975077953296e-07,   3.062984290539000e-09,  -1.521197047529849e-10,
   1.303055273126210e-12,   2.020956441125660e-13,   8.915760380325859e-16,  -4.924802549962631e-16,  -3.075685102942424e-18,   9.803451991745729e-19,   1.104530343854442e-20,
  -1.876043986029915e-21,  -3.167242746840479e-23,  -9.839643763504548e-05,   4.053207939338804e-06,  -8.448655791085404e-08,   1.982850532732861e-09,  -9.839466106014303e-11,
   8.438321823032643e-13,   1.305043375447120e-13,   5.746559725227051e-16,  -3.177899618778239e-16,  -1.977432121124602e-18,   6.318090142773266e-19,   7.095095269332599e-21,
  -1.207350639389119e-21,  -2.031653460206083e-23,  -5.278313161916590e-05,   2.174299196022729e-06,  -4.532628565877956e-08,   1.063731163994316e-09,  -5.276295101196181e-11,
   4.527659546981239e-13,   6.992193674365222e-14,   3.075928103949701e-16,  -1.702025326438439e-16,  -1.057079929933137e-18,   3.381673003724859e-19,   3.791136449491922e-21,
  -6.457464134999858e-22,  -1.084788977052490e-23,  -1.964213344512045e-05,   8.091227737732657e-07,  -1.686785652802301e-08,   3.958534924759774e-10,  -1.963213444263237e-11,
   1.685010824276685e-13,   2.600898466964149e-14,   1.143773078006241e-16,  -6.330227886735822e-17,  -3.928941202573767e-19,   1.257440372894675e-19,   1.408864316263709e-21,
  -2.400530788748407e-22,  -4.030278041551897e-24,  -2.218733369193279e-06,   9.139683135326169e-08,  -1.905368305630836e-09,   4.471491215720540e-11,  -2.217559290903317e-12,
   1.903376806840042e-14,   2.937722215629254e-15,   1.291825907089723e-17,  -7.149862468155901e-18,  -4.437195166142765e-20,   1.420202466775048e-20,   1.591077689144560e-22,
  -2.711144098934777e-23,  -4.551345025165852e-25,  -3.250062926369793e-03,   1.302889249695721e-04,  -2.428441199347102e-06,   4.963672749024169e-08,  -2.877539919424180e-09,
   1.329635432423625e-11,   5.185739512163557e-12,   1.079042973772539e-14,  -1.163401671836381e-14,  -7.563455869854006e-17,   2.407064280176246e-17,   2.710844103997327e-19,
  -4.709886776296803e-20,  -8.081584979463033e-22,  -3.092051740445183e-03,   1.239560634186249e-04,  -2.310828744187099e-06,   4.722635324379183e-08,  -2.735299196933640e-09,
   1.265598604602885e-11,   4.923998436802531e-12,   1.018754026612487e-14,  -1.103666074191217e-14,  -7.152940723000196e-17,   2.281000708928132e-17,   2.561089109325503e-19,
  -4.457435130510103e-20,  -7.625843349896130e-22,  -2.791466975751884e-03,   1.119084429501646e-04,  -2.086909645296814e-06,   4.263993683010279e-08,  -2.465672219470414e-09,
   1.143527807308147e-11,   4.430036386499152e-12,   9.073112434049178e-15,  -9.913378409253688e-15,  -6.389815712884359e-17,   2.044927118352013e-17,   2.283708620638957e-19,
  -3.986945834556752e-20,  -6.785248024270013e-22,  -2.377690072109453e-03,   9.532282154043671e-05,  -1.778310793424100e-06,   3.632414789472897e-08,  -2.096361886253445e-09,
   9.750034493216209e-12,   3.757680712253424e-12,   7.601321524048339e-15,  -8.392272498224087e-15,  -5.373432589418176e-17,   1.727138412791296e-17,   1.916217910430600e-19,
  -3.357979862480915e-20,  -5.678409610534181e-22,  -1.891193368095078e-03,   7.582082979823559e-05,  -1.415024724652035e-06,   2.889552876574696e-08,  -1.664480655723478e-09,
   7.762576308369750e-12,   2.976750870503231e-12,   5.948792254385362e-15,  -6.635454311841805e-15,  -4.221005291021942e-17,   1.362498120858635e-17,   1.502002010552654e-19,
  -2.641827804461080e-20,  -4.439490285460606e-22,  -1.379592570542524e-03,   5.531109602193765e-05,  -1.032571761204903e-06,   2.108091685810215e-08,  -1.212481660572337e-09,
   5.667021985737067e-12,   2.164415028333460e-12,   4.282790114183807e-15,  -4.817231772865532e-15,  -3.048266573751507e-17,   9.873454638988846e-18,   1.082795028362746e-19,
  -1.910208424506874e-20,  -3.193745583504042e-22,  -8.929836876170720e-04,   3.580228705019159e-05,  -6.685073543650767e-07,   1.364618381879018e-08,  -7.840781499388396e-10,
   3.670005024993079e-12,   1.397966299106711e-12,   2.748017445962288e-15,  -3.108204339586527e-15,  -1.959953313869638e-17,   6.362907084377278e-18,   6.953978519316689e-20,
  -1.229228529784320e-20,  -2.048253122384964e-22,  -4.790252987586427e-04,   1.920563572379245e-05,  -3.586484670334428e-07,   7.320505304625353e-09,  -4.204017780406298e-10,
   1.969216986922768e-12,   7.490841240948894e-13,   1.467492653445145e-15,  -1.664620222989267e-15,  -1.047777844462086e-17,   3.405578720174613e-18,   3.715320716551548e-20,
  -6.574177111318284e-21,  -1.093541930839064e-22,  -1.782590786171864e-04,   7.146986070837408e-06,  -1.334685186989046e-07,   2.724202953123003e-09,  -1.564172912515801e-10,
   7.328678614690895e-13,   2.786482742169458e-13,   5.452383000285754e-16,  -6.191009096375485e-16,  -3.894421516479105e-18,   1.266318860931080e-18,   1.380636167038897e-20,
  -2.443879422293428e-21,  -4.062654644668130e-23,  -2.013576194688302e-05,   8.073084750315365e-07,  -1.507640841495944e-08,   3.077206875786315e-10,  -1.766808944982100e-11,
   8.278435246799734e-14,   3.147358375987466e-14,   6.157357409388914e-17,  -6.992599681667897e-17,  -4.398219690767300e-19,   1.430228278208932e-19,   1.559189107615315e-21,
  -2.760094804524708e-22,  -4.587881909350609e-24,  -9.172867685454410e-03,   3.420913038213608e-04,  -4.296292800459533e-06,   3.043794979665846e-08,  -5.778003437056500e-09,
  -3.761107442742612e-11,   1.926338876703977e-11,   4.179739552436511e-15,  -4.095779661658943e-14,  -2.097919311770491e-16,   8.652538879224768e-17,   8.940654367123193e-19,
  -1.759904182502821e-19,  -2.836489001537508e-21,  -8.726825596201892e-03,   3.254545632431889e-04,  -4.088329676169676e-06,   2.894626091788461e-08,  -5.488496850766437e-09,
  -3.578005704514872e-11,   1.829296130217027e-11,   3.761471662739172e-15,  -3.885255953995325e-14,  -1.981851421181923e-16,   8.198146720517436e-17,   8.443115905150307e-19,
  -1.665236220970992e-19,  -2.675335426008249e-21,  -7.878350643044379e-03,   2.938085061232228e-04,  -3.692347751855341e-06,   2.611344313254270e-08,  -4.941282553742495e-09,
  -3.229808637559581e-11,   1.646082261389656e-11,   3.055277720609845e-15,  -3.489471535508273e-14,  -1.766915761917591e-16,   7.347711461887406e-17,   7.522933014113720e-19,
  -1.488935700102175e-19,  -2.378543043726439e-21,  -6.710423259832824e-03,   2.502493214409371e-04,  -3.146527492492158e-06,   2.222321238803924e-08,  -4.194795273043657e-09,
  -2.750699878105181e-11,   1.396558348063987e-11,   2.254618550706441e-15,  -2.953687323963039e-14,  -1.482265776012151e-16,   6.203841621120480e-17,   6.306476665138406e-19,
  -1.253502879382097e-19,  -1.988614269958649e-21,  -5.337313349713637e-03,   1.990397422360059e-04,  -2.503870324444702e-06,   1.766112231908865e-08,  -3.325683287978366e-09,
  -2.187628043113450e-11,   1.106558572553987e-11,   1.527216946700122e-15,  -2.335093413601907e-14,  -1.161587931342520e-16,   4.892517995815882e-17,   4.938734583536279e-19,
  -9.857531602469945e-20,  -1.553256948766127e-21,  -3.893419879969632e-03,   1.451923011234500e-04,  -1.827204494297091e-06,   1.287465375920270e-08,  -2.419683202053896e-09,
  -1.595698429670544e-11,   8.047250362888603e-12,   9.589821645343583e-16,  -1.695078725227914e-14,  -8.372235322677776e-17,   3.544499604097979e-17,   3.557696885802754e-19,
  -7.125182866791082e-20,  -1.116539218633740e-21,  -2.520111241696576e-03,   9.397858771559142e-05,  -1.183002434893310e-06,   8.329740165029736e-09,  -1.563504808303707e-09,
  -1.032809322308427e-11,   5.198205578534813e-12,   5.547956193683757e-16,  -1.093640728290127e-14,  -5.376112478086505e-17,   2.283852506721184e-17,   2.283712904453430e-19,
  -4.584052273791785e-20,  -7.157037027999930e-22,  -1.351862355837960e-03,   5.041271210091632e-05,  -6.346800394747079e-07,   4.467301774357962e-09,  -8.379687641159189e-10,
  -5.540175737785791e-12,   2.785562844120685e-12,   2.795125924652582e-16,  -5.856879877367782e-15,  -2.872099251790133e-17,   1.222265882389890e-17,   1.219814660269515e-19,
  -2.451363707466068e-20,  -3.820054080008209e-22,  -5.030659572502254e-04,   1.875996200718713e-05,  -2.361929493153354e-07,   1.662276664425533e-09,  -3.117357092930317e-10,
  -2.061639879444077e-12,   1.036209695637718e-12,   1.016745240083969e-16,  -2.178250062649303e-15,  -1.067262214995823e-17,   4.544694652014703e-18,   4.532504147897876e-20,
  -9.112310494621890e-21,  -1.419069509842579e-22,  -5.682523242263964e-05,   2.119083923075781e-06,  -2.668003136569225e-08,   1.877647807850761e-10,  -3.521126456424533e-11,
  -2.328780710430352e-13,   1.170412382348739e-13,   1.144300972947702e-17,  -2.460278030314847e-16,  -1.205282603651163e-18,   5.132924900240286e-19,   5.118605177723027e-21,
  -1.029129288886103e-21,  -1.602505739752775e-23,  -1.829865499386183e-02,   5.563989102586511e-04,   3.818998018807200e-06,  -4.180741224364843e-07,  -6.982691188749427e-09,
  -5.129782435503267e-11,   4.982231872769602e-11,   1.530554792161931e-13,  -1.374829051854153e-13,  -1.147921187724133e-16,   3.008711318480698e-16,   1.354142127136129e-18,
  -6.454479935741115e-19,  -6.645690851688712e-21,  -1.740849060598429e-02,   5.292981670270671e-04,   3.632048433074308e-06,  -3.977538176016573e-07,  -6.621261567592529e-09,
  -4.870762842300875e-11,   4.728673815195214e-11,   1.455020609904577e-13,  -1.304031192039683e-13,  -1.071320940005877e-16,   2.850103494284730e-16,   1.273738150033570e-18,
  -6.104173332001231e-19,  -6.257348933482736e-21,  -1.571534279464589e-02,   4.777646555683484e-04,   3.276939041018445e-06,  -3.590961821480299e-07,  -5.942705998012736e-09,
  -4.381950193335989e-11,   4.250982898579484e-11,   1.311817619641854e-13,  -1.170983581009284e-13,  -9.343777928643147e-17,   2.553494582533500e-16,   1.126911676098184e-18,
  -5.453002370857419e-19,  -5.546138824042538e-21,  -1.338501288459298e-02,   4.068642686953490e-04,   2.789117509139416e-06,  -3.058766859861268e-07,  -5.025991052970600e-09,
  -3.716656120600519e-11,   3.602382945763750e-11,   1.115600582251558e-13,  -9.909742534137625e-14,  -7.625583868994003e-17,   2.155003594601551e-16,   9.364704794037195e-19,
  -4.585750049576763e-19,  -4.619486978200240e-21,  -1.064565727418381e-02,   3.235530943595385e-04,   2.216836760960483e-06,  -2.432985047013116e-07,  -3.970045075806968e-09,
  -2.944036103308877e-11,   2.851088544272376e-11,   8.860092475751508e-14,  -7.832701931247726e-14,  -5.811885555072497e-17,   1.698753545345243e-16,   7.270336291231808e-19,
  -3.602389857091060e-19,  -3.594764093813129e-21,  -7.765432237799632e-03,   2.359892579775281e-04,   1.616205509007083e-06,  -1.774860611804047e-07,  -2.879913335122316e-09,
  -2.140483401788192e-11,   2.071494621321019e-11,   6.455652444946338e-14,  -5.684919757711686e-14,  -4.092716041746032e-17,   1.230270715845986e-16,   5.200074441784002e-19,
  -2.601625209305717e-19,  -2.576196066884549e-21,  -5.026248258638607e-03,   1.527354398537335e-04,   1.045738457103114e-06,  -1.148850296383200e-07,  -1.857212327326752e-09,
  -1.382441767553001e-11,   1.337287008845094e-11,   4.175413076924087e-14,  -3.667423006356251e-14,  -2.586905944190871e-17,   7.925258121743745e-17,   3.322029195230233e-19,
  -1.672825579206559e-19,  -1.647989210390322e-21,  -2.696196103559067e-03,   8.192785515310667e-05,   5.608578131749702e-07,  -6.162851441210213e-08,  -9.943701510083472e-10,
  -7.407459719455979e-12,   7.163870584468275e-12,   2.238952613598022e-14,  -1.963938716533118e-14,  -1.370659358875993e-17,   4.240914817577035e-17,   1.770020758305700e-19,
  -8.942964321141508e-20,  -8.786856208740301e-22,  -1.003326108815188e-03,   3.048714323404761e-05,   2.086970614735130e-07,  -2.293380231483115e-08,  -3.697879397298331e-10,
  -2.755440211525492e-12,   2.664617683900245e-12,   8.330659787070042e-15,  -7.303999734918411e-15,  -5.078606688042650e-18,   1.576814670753088e-17,   6.571221611866856e-20,
  -3.323976148535373e-20,  -3.262932332221157e-22,  -1.133334518909244e-04,   3.443751954660371e-06,   2.357371567101799e-08,  -2.590554057378836e-09,  -4.176604536877292e-11,
  -3.112290886100671e-13,   3.009668201722021e-13,   9.409932456835590e-16,  -8.249655957778280e-16,  -5.732742712088937e-19,   1.780893751166381e-18,   7.419928094249054e-21,
  -3.753982876924191e-21,  -3.684500669144140e-23,  -2.908165575510709e-02,   1.003181025300672e-04,   7.491923679709934e-05,  -1.646746293807076e-06,  -1.738890827074810e-07,
   6.874000079678479e-09,   3.489386561077368e-10,  -2.124611694258178e-11,  -5.949821275759157e-13,   5.647601106440425e-14,   7.918575820968747e-16,  -1.363227756581558e-16,
  -4.807976399242514e-19,   3.072972281390097e-19,  -2.766493230869425e-02,   9.529558149206983e-05,   7.124449825823065e-05,  -1.564644301660509e-06,  -1.652773234530777e-07,
   6.526658858124186e-09,   3.314768925295866e-10,  -2.015373387184199e-11,  -5.649907540104035e-13,   5.351262177403560e-14,   7.523536836568345e-16,  -1.290057222168185e-16,
  -4.614810583170128e-19,   2.903944641906226e-19,  -2.497105230294996e-02,   8.580054601966526e-05,   6.426722204352953e-05,  -1.409296677104133e-06,  -1.489595693796322e-07,
   5.871305487667050e-09,   2.984627154322510e-10,  -1.810017917184569e-11,  -5.083729295361976e-13,   4.796539159536648e-14,   6.776038024311685e-16,  -1.153729258220207e-16,
  -4.229771454475579e-19,   2.590598863074377e-19,  -2.126496539592012e-02,   7.284468605651604e-05,   5.468800928928018e-05,  -1.197063091617809e-06,  -1.266215500141699e-07,
   4.979571932808726e-09,   2.534093364894154e-10,  -1.532047250413381e-11,  -4.312754560626415e-13,   4.050225570589797e-14,   5.754880051228943e-16,  -9.715564382232550e-17,
  -3.666726293181139e-19,   2.174931561225018e-19,  -1.691037554669703e-02,   5.775676490131968e-05,   4.345752786375099e-05,  -9.495649379100802e-07,  -1.005149169180271e-07,
   3.944217923849001e-09,   2.009336664384979e-10,  -1.211146047438933e-11,  -3.416901591656219e-13,   3.194420981000492e-14,   4.564324393620718e-16,  -7.642268991851069e-17,
  -2.964570128596909e-19,   1.705729306243781e-19,  -1.233371668440470e-02,   4.202502584066112e-05,   3.167754293649273e-05,  -6.911851779520722e-07,  -7.320729139257853e-08,
   2.867580469821282e-09,   1.462106100262843e-10,  -8.791632932271064e-12,  -2.484693697654604e-13,   2.314449645072175e-14,   3.321860596710621e-16,  -5.525097922054818e-17,
  -2.190204314166252e-19,   1.230217099754098e-19,  -7.982476109676954e-03,   2.715604961192217e-05,   2.049402086850111e-05,  -4.467478470471333e-07,  -4.733586622291869e-08,
   1.852009056955190e-09,   9.448259370332976e-11,  -5.672126929403665e-12,  -1.604929594234886e-13,   1.491360602199587e-14,   2.146848849305884e-16,  -3.555108846071866e-17,
  -1.429276517698921e-19,   7.903146401696621e-20,  -4.281809888524595e-03,   1.455473501629245e-05,   1.099083462755400e-05,  -2.394730209423561e-07,  -2.537877839933734e-08,
   9.923440377842672e-10,   5.064038428212406e-11,  -3.037618540577495e-12,  -8.600098245993285e-14,   7.981628037437788e-15,   1.150719219486133e-16,  -1.901260354103509e-17,
  -7.698715933931746e-20,   4.223095435321363e-20,  -1.593352356559891e-03,   5.414597516884468e-06,   4.089640183035307e-06,  -8.909188308864347e-08,  -9.442397636096149e-09,
   3.691330237691784e-10,   1.883915813090241e-11,  -1.129726030040913e-12,  -3.199144369831453e-14,   2.967798386273919e-15,   4.280963574486729e-17,  -7.067616345907356e-18,
  -2.868988240472037e-20,   1.569414113644080e-20,  -1.799810775288875e-04,   6.115919331012243e-07,   4.619504092230270e-07,  -1.006321681814302e-08,  -1.066561104404677e-09,
   4.169384288802565e-11,   2.127930685113000e-12,  -1.275996102016393e-13,  -3.613469687976534e-15,   3.351932098385030e-16,   4.835470338553938e-18,  -7.982080072029214e-19,
  -3.241476714324859e-21,   1.772396437542083e-21,  -3.036025016399985e-04,   1.254992981467768e-05,  -2.510555741650874e-07,   2.511534923052575e-09,  -1.987882682663186e-10,
   1.151964338935426e-11,   9.766161828932708e-14,  -2.337093479049186e-14,  -3.430837150538868e-17,   5.117355465864994e-17,  -4.617755956863758e-19,  -9.900128794662855e-20,
   1.865845885530015e-21,   1.779858021164521e-22,  -2.888426918382490e-04,   1.193972759908465e-05,  -2.388795017681156e-07,   2.392753730404176e-09,  -1.890757126358193e-10,
   1.094498533141804e-11,   9.287941548397242e-14,  -2.218047728292074e-14,  -3.322897266804776e-17,   4.852639332358268e-17,  -4.358045430083581e-19,  -9.378518316721404e-20,
   1.761407098240615e-21,   1.684329912343544e-22,  -2.607648118547291e-04,   1.077896073161819e-05,  -2.157048557795715e-07,   2.165438593985334e-09,  -1.706190069138119e-10,
   9.857794523153936e-12,   8.379543600153307e-14,  -1.993814485306516e-14,  -3.092993548961366e-17,   4.355633178927082e-17,  -3.878676634815569e-19,  -8.402923180103592e-20,
   1.568474105452554e-21,   1.506339066484433e-22,  -2.221130037064668e-04,   9.181120934124687e-06,  -1.837798206245766e-07,   1.849896364458012e-09,  -1.452497767297594e-10,
   8.372748502956425e-12,   7.131693267707321e-14,  -1.689436913947061e-14,  -2.729508393797701e-17,   3.684104567270842e-17,  -3.246889002447982e-19,  -7.091974670538940e-20,
   1.313859516886637e-21,   1.268483962144831e-22,  -1.766675793952299e-04,   7.302517508318842e-06,  -1.462144240453470e-07,   1.475583269658475e-09,  -1.154697781566363e-10,
   6.641263246448740e-12,   5.667961072753900e-14,  -1.336968645887440e-14,  -2.243604566825106e-17,   2.910416892488681e-17,  -2.539083681176145e-19,  -5.590745660506940e-20,
   1.028143276154058e-21,   9.977795941263512e-23,  -1.288764384194914e-04,   5.327021864036259e-06,  -1.066829593587912e-07,   1.078872017505533e-09,  -8.419759756073038e-11,
   4.833934183146754e-12,   4.131979622593667e-14,  -9.713173502468748e-15,  -1.678923957173122e-17,   2.111468458679825e-17,  -1.826902873345484e-19,  -4.049060325536971e-20,
   7.401871157462486e-22,   7.213507658178130e-23,  -8.341945808845738e-05,   3.448062733868826e-06,  -6.906326801518863e-08,   6.993839093885991e-10,  -5.448426495227098e-11,
   3.124323288058694e-12,   2.673383552233883e-14,  -6.270182683635441e-15,  -1.104682094400127e-17,   1.361756556948868e-17,  -1.171763269568086e-19,  -2.608406937712910e-20,
   4.749376776027853e-22,   4.641459836202995e-23,  -4.474895363101607e-05,   1.849647881990206e-06,  -3.705036930323018e-08,   3.754614093438292e-10,  -2.922292857659255e-11,
   1.674725259580502e-12,   1.433765633568070e-14,  -3.358862074075909e-15,  -5.975105402342441e-18,   7.291278029902436e-18,  -6.256204471595211e-20,  -1.395807294675494e-20,
   2.536279863368493e-22,   2.482221301825969e-23,  -1.665237946903662e-05,   6.883065628675112e-07,  -1.378784395455457e-08,   1.397574365190631e-10,  -1.087414863523800e-11,
   6.230499380955684e-13,   5.335033442925762e-15,  -1.249325138448179e-15,  -2.229873064471634e-18,   2.711531201225568e-18,  -2.324297927300590e-20,  -5.189767506061613e-21,
   9.423440223914218e-23,   9.227219507351887e-24,  -1.881017095066643e-06,   7.774961814881409e-08,  -1.557451223150984e-09,   1.578737065081524e-11,  -1.228310701433122e-12,
   7.037545093270550e-14,   6.026263542290248e-16,  -1.411102559809679e-16,  -2.519956829352131e-19,   3.062571400908505e-19,  -2.624793370553657e-21,  -5.861455473950775e-22,
   1.064186657864889e-23,   1.042110571418276e-24,  -2.765015817762920e-03,   1.125229355405190e-04,  -2.079844496106722e-06,   1.186412750979360e-08,  -1.546798957874820e-09,
   1.032642753513294e-10,   1.127690579385778e-12,  -2.358218653082918e-13,  -7.392739912359055e-17,   5.074380769285497e-16,  -5.033718668361304e-18,  -9.917214729152851e-19,
   1.991433187546136e-20,   1.792605303610653e-21,  -2.630586775294746e-03,   1.070508992374940e-04,  -1.978954861944894e-06,   1.131730782620199e-08,  -1.471059642525630e-09,
   9.809673822842076e-11,   1.072741238348602e-12,  -2.238191532034166e-13,  -7.676262974223406e-17,   4.811729688191934e-16,  -4.751412720223247e-18,  -9.394490370316713e-19,
   1.879965760151983e-20,   1.696362648224924e-21,  -2.374862256150999e-03,   9.664201756644931e-05,  -1.786939603918453e-06,   1.026483911047068e-08,  -1.327199224156523e-09,
   8.832677714692140e-11,   9.682540600480714e-13,  -2.012072883181045e-13,  -7.947388682520305e-17,   4.318662387176465e-16,  -4.230049597777313e-18,  -8.416894456232172e-19,
   1.674049436172840e-20,   1.517051628678704e-21,  -2.022838613384939e-03,   8.231454471256813e-05,  -1.522436681162268e-06,   8.792340683897096e-09,  -1.129588434724089e-09,
   7.499406957525812e-11,   8.245102779201058e-13,  -1.705063924570114e-13,  -7.807308407181196e-17,   3.652575634770680e-16,  -3.542346902657060e-18,  -7.103417850988943e-19,
   1.402301217763780e-20,   1.277454488442337e-21,  -1.608947906744316e-03,   6.547047536329098e-05,  -1.211220844163224e-06,   7.031148736654967e-09,  -8.977843176595826e-10,
   5.946478094328944e-11,   6.556294246461393e-13,  -1.349456207705557e-13,  -7.003142656029621e-17,   2.885310246466014e-16,  -2.771159163365548e-18,  -5.599498116785286e-19,
   1.097357274632584e-20,   1.004796366732428e-21,  -1.173699548514144e-03,   4.775852816935409e-05,  -8.837338304918943e-07,   5.151274917613394e-09,  -6.545183570967221e-10,
   4.327019714942644e-11,   4.781607817164426e-13,  -9.804608979769629e-14,  -5.570603900113299e-17,   2.093137054284459e-16,  -1.994491758364026e-18,  -4.055241685752949e-19,
   7.900198691904333e-21,   7.264002266557136e-22,  -7.597131512021721e-04,   3.091273018760309e-05,  -5.720962823825043e-07,   3.343793004519436e-09,  -4.234862168783989e-10,
   2.796172676009206e-11,   3.094560450090486e-13,  -6.329512965826516e-14,  -3.801980471942639e-17,   1.349884038833788e-16,  -1.279515371070602e-18,  -2.612321612994606e-19,
   5.069145083159819e-21,   4.673849432212493e-22,  -4.075346909997439e-04,   1.658246469509624e-05,  -3.069108683743731e-07,   1.796325936113003e-09,  -2.271246112491418e-10,
   1.498685113315645e-11,   1.659887053010934e-13,  -3.390728945289581e-14,  -2.093343745835678e-17,   7.227571055008014e-17,  -6.832232310886523e-19,  -1.397883550150318e-19,
   2.707049301974761e-21,   2.499515169500901e-22,  -1.516553708892093e-04,   6.170795762393458e-06,  -1.142129357226536e-07,   6.688020885893047e-10,  -8.451349712178654e-11,
   5.575391025293946e-12,   6.176740282976967e-14,  -1.261188923139841e-14,  -7.859536107224555e-18,   2.687821562481938e-17,  -2.538397252268994e-19,  -5.197463207321142e-20,
   1.005793430355537e-21,   9.291470216367211e-23,  -1.713066439802682e-05,   6.970395270119369e-07,  -1.290129374624395e-08,   7.555249541406259e-11,  -9.546353490318767e-12,
   6.297546570660374e-13,   6.977081218350062e-15,  -1.424504568949387e-15,  -8.890432008371676e-19,   3.035789065946431e-18,  -2.866589285776317e-20,  -5.870142883107641e-21,
   1.135840044932500e-22,   1.049366316397674e-23,  -7.873030594125790e-03,   3.077061754007966e-04,  -4.435212860772029e-06,  -4.539161692613907e-08,  -2.607598953906131e-09,
   2.940369419289664e-10,   4.369674252919609e-12,  -8.295180329115293e-13,   1.507639566119030e-15,   1.778546894558823e-15,  -2.242937326594636e-17,  -3.506132764676439e-18,
   8.309796752876115e-20,   6.387127011432735e-21,  -7.490216327490208e-03,   2.927353623472716e-04,  -4.219943009723411e-06,  -4.309790217567794e-08,  -2.478811705384696e-09,
   2.792257626276595e-10,   4.158223401458394e-12,  -7.873047810676107e-13,   1.405565967398243e-15,   1.686441790071010e-15,  -2.118206021304760e-17,  -3.321215546783524e-18,
   7.844762697356304e-20,   6.044343019238992e-21,  -6.762006470752767e-03,   2.642607723230958e-04,  -3.810287822266617e-06,  -3.877009793958473e-08,  -2.234636908512473e-09,
   2.512617489922923e-10,   3.755544111113928e-12,  -7.077767008100685e-13,   1.223375198822681e-15,   1.513554043558948e-15,  -1.887468795027917e-17,  -2.975427324538857e-18,
   6.985669485378689e-20,   5.405639500756487e-21,  -5.759607157659599e-03,   2.250719314948184e-04,  -3.246082563011823e-06,  -3.288124093067073e-08,  -1.900097511644360e-09,
   2.131753328907704e-10,   3.200412796137320e-12,  -5.997934204940760e-13,   9.955301461887114e-16,   1.280035094394825e-15,  -1.582360118087481e-17,  -2.510917900192081e-18,
   5.851863927486387e-20,   4.552092149883153e-21,  -4.581083860658293e-03,   1.790065570428710e-04,  -2.582360368004719e-06,  -2.604406076125158e-08,  -1.508771227199699e-09,
   1.689095057790741e-10,   2.546737789358527e-12,  -4.747097822849382e-13,   7.562683107757540e-16,   1.011090056123568e-15,  -1.239230331295442e-17,  -1.979166960903347e-18,
   4.579467837556659e-20,   3.580643805169277e-21,  -3.341787811662405e-03,   1.305741511534151e-04,  -1.884054111686887e-06,  -1.893454281945349e-08,  -1.099123935399841e-09,
   1.228366211702332e-10,   1.858461304768740e-12,  -3.449105538708843e-13,   5.309602634955784e-16,   7.334567657129430e-16,  -8.927178442658103e-18,  -1.433257138388020e-18,
   3.296987137247088e-20,   2.588644806674183e-21,  -2.163060760066880e-03,   8.451470816042955e-05,  -1.219626127888792e-06,  -1.222857190033980e-08,  -7.108008102693588e-10,
   7.934760911386661e-11,   1.203222371327242e-12,  -2.226645347248652e-13,   3.348722314758602e-16,   4.729984993103449e-16,  -5.730466289263804e-18,  -9.232444422934226e-19,
   2.115546340895063e-20,   1.665634750363757e-21,  -1.160331786971930e-03,   4.533547688580610e-05,  -6.542782995950424e-07,  -6.552261844473980e-09,  -3.811199393951075e-10,
   4.252000005208909e-11,   6.455223877988913e-13,  -1.192823481511614e-13,   1.772190292663094e-16,   2.532495616122849e-16,  -3.060857337335532e-18,  -4.940286237208133e-19,
   1.129766111148056e-20,   8.907690792918302e-22,  -4.317922972587226e-04,   1.687051157016192e-05,  -2.434798277314213e-07,  -2.437308838089072e-09,  -1.418028094577257e-10,
   1.581713761901158e-11,   2.402270868768449e-13,  -4.436740971940746e-14,   6.563574981186028e-17,   9.417905734539483e-17,  -1.137332856662614e-18,  -1.836831938236272e-19,
   4.197616730731584e-21,   3.311275205291209e-22,  -4.877431975793731e-05,   1.905654496709592e-06,  -2.750303040249038e-08,  -2.752956680442467e-10,  -1.601733025472272e-11,
   1.786566309603627e-12,   2.713570758887718e-14,  -5.011271162993430e-15,   7.408473695691958e-18,   1.063714581963215e-17,  -1.284402145239403e-19,  -2.074560838542075e-20,
   4.740361041188627e-22,   3.739712294318118e-23,  -1.604601330753685e-02,   5.653013014837201e-04,  -1.707722955662986e-06,  -4.797999743362150e-07,   1.993433284553056e-09,
   7.710896209837961e-10,   6.572121893402664e-12,  -2.381365023927706e-12,   1.516548981682757e-14,   5.567232046341959e-15,  -1.143047446905288e-16,  -1.080727840694487e-17,
   3.868063621483666e-19,   1.877813140115994e-20,  -1.526558016478302e-02,   5.377624991884483e-04,  -1.624295880746346e-06,  -4.562375876201878e-07,   1.899447719498618e-09,
   7.321242627203186e-10,   6.264239309212932e-12,  -2.259694416587168e-12,   1.428081159225929e-14,   5.279172960842067e-15,  -1.080164203725493e-16,  -1.023920868751327e-17,
   3.652291142755643e-19,   1.778013188520341e-20,  -1.378108767852274e-02,   4.853978285342962e-04,  -1.465754889227709e-06,  -4.115112074936006e-07,   1.719473954374626e-09,
   6.586058599761348e-10,   5.673655564873794e-12,  -2.030662177219395e-12,   1.265912988069432e-14,   4.738364987724953e-15,  -9.635874318511502e-17,  -9.176178093168646e-18,
   3.253426429712598e-19,   1.591669741001180e-20,  -1.173781945409744e-02,   4.133574514155692e-04,  -1.247827180485749e-06,  -3.501283162554852e-07,   1.469422750445047e-09,
   5.585712547155960e-10,   4.851340204905336e-12,  -1.720052961362732e-12,   1.054419477883431e-14,   4.007704733925538e-15,  -8.089439159950694e-17,  -7.746712660132935e-18,
   2.726521450435290e-19,   1.341904910395141e-20,  -9.335763483467404e-03,   3.287111614359598e-04,  -9.920000286447167e-07,  -2.781924481408001e-07,   1.172499113670067e-09,
   4.424278696550480e-10,   3.872941708048467e-12,  -1.360728665350548e-12,   8.204208178249938e-15,   3.165959419418857e-15,  -6.343945995545533e-17,  -6.108493253306060e-18,
   2.134567732724175e-19,   1.056717050800583e-20,  -6.810045664939820e-03,   2.397481457359992e-04,  -7.233462435337667e-07,  -2.027626952362188e-07,   8.575156646575964e-10,
   3.216566975563312e-10,   2.833501826922394e-12,  -9.883035244177393e-13,   5.878377400400539e-15,   2.296800889309617e-15,  -4.575177529578786e-17,  -4.424962725830833e-18,
   1.537305407579014e-19,   7.646453460889529e-21,  -4.407912545932007e-03,   1.551668621926030e-04,  -4.680794250850390e-07,  -1.311701528100062e-07,   5.559947468311345e-10,
   2.077383998306570e-10,   1.837570695634309e-12,  -6.378653920136307e-13,   3.759691875191702e-15,   1.481257266606610e-15,  -2.939062136703853e-17,  -2.850955314685856e-18,
   9.866534006581541e-20,   4.922933468990509e-21,  -2.364519473654099e-03,   8.323169966446898e-05,  -2.510574575503528e-07,  -7.034347779680927e-08,   2.985130876073360e-10,
   1.113099930087446e-10,   9.866909579162643e-13,  -3.416643384349816e-13,   2.004392588951272e-15,   7.931049216375974e-16,  -1.570471304880551e-17,  -1.525706677649251e-18,
   5.269652582271297e-20,   2.633545170969689e-21,  -8.799021158792600e-04,   3.097228314675259e-05,  -9.342109885439312e-08,  -2.617418450619509e-08,   1.111189268808029e-10,
   4.140513033589087e-11,   3.672999089460890e-13,  -1.270774659495637e-13,   7.442849734896179e-16,   2.949444160296305e-16,  -5.836240820999990e-18,  -5.672886400548848e-19,
   1.958006690810604e-20,   9.790764696522861e-22,  -9.939178646180071e-05,   3.498551274222670e-06,  -1.055256392719898e-08,  -2.956532157328210e-09,   1.255235774021297e-11,
   4.676738424150789e-12,   4.149162566059673e-14,  -1.435322057356583e-14,   8.404403560175998e-17,   3.331283318464911e-17,  -6.591070611699775e-19,  -6.407127049005402e-20,
   2.211187960669534e-21,   1.105775026090689e-22,  -2.765741547335025e-02,   5.856577595784353e-04,   4.388254209525386e-05,  -3.091059172696459e-06,  -4.078273683128347e-09,
   7.787262164925492e-09,  -2.245852573504050e-10,  -1.182691174201078e-11,   8.378555868673730e-13,   4.194449609945713e-15,  -1.949561405839034e-15,   4.029527154083371e-17,
   3.164891342527221e-18,  -1.628615310778174e-19,  -2.631084643432281e-02,   5.568998932601695e-04,   4.174711465469822e-05,  -2.938416534288830e-06,  -3.977448325262028e-09,
   7.401126701412409e-09,  -2.129785007950545e-10,  -1.124673237720444e-11,   7.945436795105227e-13,   4.052885179480768e-15,  -1.848608429553055e-15,   3.797392790534857e-17,
   3.003421452587474e-18,  -1.537305037922176e-19,  -2.375004968019317e-02,   5.023097201845973e-04,   3.768565962808902e-05,  -2.649007787359537e-06,  -3.745606027623488e-09,
   6.669649568532845e-09,  -1.911815985564836e-10,  -1.014507356496840e-11,   7.132106426006124e-13,   3.757428821001532e-15,  -1.659094957185659e-15,   3.370914818745578e-17,
   2.699307796471700e-18,  -1.368660718811531e-19,  -2.022644243534478e-02,   4.273868477629812e-04,   3.209628546259905e-05,  -2.252480375829056e-06,  -3.349235261580115e-09,
   5.668662649913188e-09,  -1.617216594736072e-10,  -8.632558407560686e-12,   6.032922487891402e-13,   3.300789212694421e-15,  -1.403099456444963e-15,   2.812757737876968e-17,
   2.286627716095079e-18,  -1.146189144902186e-19,  -1.608549382194972e-02,   3.395802845519176e-04,   2.552655298871916e-05,  -1.788620628439684e-06,  -2.786086560236497e-09,
   4.499273760417531e-09,  -1.277697814148538e-10,  -6.859421038994120e-12,   4.766243058594024e-13,   2.701917557486682e-15,  -1.108263782081476e-15,   2.192538616562275e-17,
   1.809017501184357e-18,  -8.966856262579246e-20,  -1.173265497010830e-02,   2.475068903839339e-04,   1.861966497692645e-05,  -1.303017153019224e-06,  -2.103908792220012e-09,
   3.276544901175816e-09,  -9.270103163603121e-11,  -4.999754266207018e-12,   3.457988443741059e-13,   2.015457251748714e-15,  -8.039189609669355e-16,   1.573386252800365e-17,
   1.313896992867183e-18,  -6.453886263302100e-20,  -7.593708953462519e-03,   1.601162532645434e-04,   1.205149981980791e-05,  -8.426698828234883e-07,  -1.392319761957912e-09,
   2.118451645734822e-09,  -5.978827712769779e-11,  -3.234484917222316e-12,   2.230227316296925e-13,   1.323423143048196e-15,  -5.184237120157815e-16,   1.007363322153839e-17,
   8.479940193278374e-19,  -4.140388845490350e-20,  -4.073342065585253e-03,   8.586669582426631e-05,   6.464633857510399e-06,  -4.518293911496774e-07,  -7.552736217990619e-10,
   1.135746924355646e-09,  -3.201314586542342e-11,  -1.734594583549554e-12,   1.194148841648963e-13,   7.150955352579320e-16,  -2.775661854634385e-16,   5.373479880656081e-18,
   4.542108578510211e-19,  -2.210861520564184e-20,  -1.515785776036786e-03,   3.195024880430302e-05,   2.405652664548515e-06,  -1.681120301405227e-07,  -2.821446698338706e-10,
   4.225587248453769e-10,  -1.190534727284136e-11,  -6.454291620992338e-13,   4.440901529702523e-14,   2.667755097172572e-16,  -1.032213551136302e-16,   1.995703573298153e-18,
   1.689367014387901e-19,  -8.214093458934909e-21,  -1.712195078751918e-04,   3.608973709864688e-06,   2.717369296418587e-07,  -1.898909516763647e-08,  -3.188991051665761e-11,
   4.772979462573591e-11,  -1.344665061528582e-12,  -7.290515330760193e-14,   5.015832585072895e-15,   3.014635152142074e-17,  -1.165842560576145e-17,   2.253601068272092e-19,
   1.908114476159867e-20,  -9.276106021246148e-22,  -2.563892911146023e-04,   1.058836729724269e-05,  -2.317485337252025e-07,   1.092209800382308e-09,   7.562949879939149e-12,
   7.268772624862617e-12,  -3.567003452222566e-13,  -4.566633620657391e-15,   8.155818117863364e-16,  -9.697983723872759e-18,  -2.370723013797544e-04,   9.790344251939947e-06,
  -2.142774326321897e-07,   1.013051529394525e-09,   6.761995911764868e-12,   6.716562798458077e-12,  -3.288256183146910e-13,  -4.236801803847857e-15,   7.514108497121399e-16,
  -8.848685031433073e-18,  -2.013730199971475e-04,   8.315699910302664e-06,  -1.819959760350286e-07,   8.648661423952783e-10,   5.422230695250937e-12,   5.698779085185546e-12,
  -2.779192948426363e-13,  -3.618430156461138e-15,   6.344736015122658e-16,  -7.352005848918426e-18,  -1.547194147052013e-04,   6.388833288921868e-06,  -1.398196748246686e-07,
   6.680508586534403e-10,   3.904739411286080e-12,   4.373286000646947e-12,  -2.124023019133788e-13,  -2.795890581844439e-15,   4.844038869534091e-16,  -5.516099704290814e-18,
  -1.042117648320366e-04,   4.303057633739804e-06,  -9.416971387221318e-08,   4.518507630604753e-10,   2.491952785252582e-12,   2.942869905420266e-12,  -1.424676753363665e-13,
  -1.891429942283300e-15,   3.246462860906489e-16,  -3.645701558281855e-18,  -5.754233309308077e-05,   2.375956391881639e-06,  -5.199544657076475e-08,   2.500969493344679e-10,
   1.332057663651279e-12,   1.624072009236821e-12,  -7.847634137761793e-14,  -1.046990123653364e-15,   1.787422393080027e-16,  -1.990965439407257e-18,  -2.182066976451093e-05,
   9.009808132313692e-07,  -1.971694756383548e-08,   9.492482046314292e-11,   4.988832621267286e-13,   6.157394380297817e-13,  -2.973209628793848e-14,  -3.973989879339377e-16,
   6.770746101380527e-17,  -7.518620729613876e-19,  -2.487853624330254e-06,   1.027239486176899e-07,  -2.247995282032650e-09,   1.082433613616802e-11,   5.676145699847370e-14,
   7.020030080355894e-14,  -3.389354434152570e-15,  -4.531586397825308e-17,   7.718184112855536e-18,  -8.566335811017042e-20,  -2.339539018571144e-03,   9.585491696534333e-05,
  -2.011762871975710e-06,   3.037896634605072e-09,   3.127641036068358e-10,   6.443072578767011e-11,  -3.397279298166740e-12,  -4.405599570202217e-14,   8.089876782362635e-15,
  -1.057871099561316e-16,  -2.163267877440302e-03,   8.862963036282061e-05,  -1.860035169838376e-06,   2.837024131451386e-09,   2.869902312896853e-10,   5.953247518387846e-11,
  -3.131403575771205e-12,  -4.089270080287361e-14,   7.453755943857709e-15,  -9.659439455456330e-17,  -1.837508045873801e-03,   7.527877159023954e-05,  -1.579726047416331e-06,
   2.448846011873479e-09,   2.407010464090404e-10,   5.050648689422248e-11,  -2.646076223879348e-12,  -3.495017372982961e-14,   6.294331244161471e-15,  -8.035655363397644e-17,
  -1.411793463073281e-03,   5.783457744534604e-05,  -1.213562260303319e-06,   1.913296654570789e-09,   1.824389740118124e-10,   3.875508466736301e-11,  -2.021840409179926e-12,
  -2.702614082379559e-14,   4.806006633335096e-15,  -6.037297883779042e-17,  -9.509152960064487e-04,   3.895265914544588e-05,  -8.173054693298963e-07,   1.305546941364102e-09,
   1.215627266004042e-10,   2.607693155967714e-11,  -1.355900678125225e-12,  -1.829418415479809e-14,   3.221211594699303e-15,  -3.994614098860460e-17,  -5.250634839339566e-04,
   2.150774672496766e-05,  -4.512597229192368e-07,   7.262436533990688e-10,   6.670333150532372e-11,   1.439030985682616e-11,  -7.468031388018507e-13,  -1.013008385160109e-14,
   1.773595298598351e-15,  -2.182943705367992e-17,  -1.991095773561470e-04,   8.155877172669748e-06,  -1.711183074286172e-07,   2.761628818973605e-10,   2.523492711426038e-11,
   5.455745321228220e-12,  -2.829282377397208e-13,  -3.845495747986671e-15,   6.718476763480510e-16,  -8.245656824697392e-18,  -2.270120197650272e-05,   9.298793882021502e-07,
  -1.950973856080213e-08,   3.150075920941010e-11,   2.875997725476904e-12,   6.220063316435542e-13,  -3.225261947784147e-14,  -4.385155149876446e-16,   7.658621006741143e-17,
  -9.395073544181086e-19,  -6.693712898630667e-03,   2.688466571536817e-04,  -5.020090935377648e-06,  -4.137080401778719e-08,   2.668589439453541e-09,   1.723241350405006e-10,
  -1.101314348669024e-11,  -1.305651995256683e-13,   2.778739642139341e-14,  -4.465080588745317e-16,  -6.189346220847491e-03,   2.485751452087733e-04,  -4.640981467155827e-06,
  -3.817699156662013e-08,   2.460310719361509e-09,   1.592105354152722e-10,  -1.014933520617267e-11,  -1.213925679404170e-13,   2.560517853677508e-14,  -4.082144250525713e-16,
  -5.257265700060475e-03,   2.111214872166545e-04,  -3.940894280537615e-06,  -3.232108403875625e-08,   2.079785680362303e-09,   1.350536232983984e-10,  -8.573658081245702e-12,
  -1.040307313210366e-13,   2.162612215311655e-14,  -3.403017430110313e-16,  -4.039222821259978e-03,   1.621912703824116e-04,  -3.026877339842375e-06,  -2.474581180098918e-08,
   1.589787883791450e-09,   1.036153470445304e-10,  -6.548870315954863e-12,  -8.066852936755899e-14,   1.651559396742379e-14,  -2.562570240074072e-16,  -2.720603816088188e-03,
   1.092348644564881e-04,  -2.038234024406270e-06,  -1.662143668212407e-08,   1.066496031145163e-09,   6.971092057612640e-11,  -4.390691023065567e-12,  -5.472214433307163e-14,
   1.107114226150945e-14,  -1.698669573464782e-16,  -1.502219697877818e-03,   6.031286926598266e-05,  -1.125277931620040e-06,  -9.163105690205058e-09,   5.875136283204932e-10,
   3.846667308171754e-11,  -2.417935176934188e-12,  -3.033833743572378e-14,   6.096269759408978e-15,  -9.292825319164507e-17,  -5.696565541841191e-04,   2.287085182591553e-05,
  -4.266935074682659e-07,  -3.472654081909101e-09,   2.225965093351138e-10,   1.458334968571723e-11,  -9.159879828506751e-13,  -1.152200625808935e-14,   2.309373323663250e-15,
  -3.511633212337619e-17,  -6.494858392603810e-05,   2.607580466465607e-06,  -4.864842030753894e-08,  -3.958903058462456e-10,   2.537535129045904e-11,   1.662631991170782e-12,
  -1.044177474245599e-13,  -1.313993806564401e-15,   2.632547223555138e-16,  -4.001416721199074e-18,  -1.379826805450567e-02,   5.284335467702345e-04,  -6.768766874702833e-06,
  -3.345444606560577e-07,   1.444130048170951e-08,   3.202515457456964e-10,  -3.280013960957031e-11,  -1.043513637009287e-13,   7.899088144679788e-14,  -1.917267748621569e-15,
  -1.275841756199777e-02,   4.885553910740364e-04,  -6.254775326072160e-06,  -3.091856933204102e-07,   1.333147802793542e-08,   2.960003775488815e-10,  -3.023192897192915e-11,
  -9.938345664194775e-14,   7.280694720301417e-14,  -1.755850798968325e-15,  -1.083684822340107e-02,   4.148966152623504e-04,  -5.307313260347048e-06,  -2.624135037234675e-07,
   1.129367817899537e-08,   2.512533830798470e-10,  -2.554461832997431e-11,  -8.842209461020313e-14,   6.151946396435681e-14,  -1.467942142092728e-15,  -8.325903090627765e-03,
   3.187009038127714e-04,  -4.073175477119703e-06,  -2.014439916067682e-07,   8.652571009346559e-09,   1.928985019271241e-10,  -1.951691920825532e-11,  -7.116826190697351e-14,
   4.700310979746562e-14,  -1.108847556241594e-15,  -5.607784857517917e-03,   2.146230923804805e-04,  -2.741090969742630e-06,  -1.355909612205661e-07,   5.814958259285581e-09,
   1.298489443869736e-10,  -1.308777279746527e-11,  -4.963271981143787e-14,   3.151952539052814e-14,  -7.368698278991873e-16,  -3.096386486070192e-03,   1.184954577421760e-04,
  -1.512773849705042e-06,  -7.483949973991905e-08,   3.206693190679419e-09,   7.167300116056646e-11,  -7.208225630886223e-12,  -2.794286969913168e-14,   1.735962039148939e-14,
  -4.037062731761456e-16,  -1.174175957068406e-03,   4.493298215222268e-05,  -5.735508957166605e-07,  -2.837575499139163e-08,   1.215423991710039e-09,   2.717553726675798e-11,
  -2.730817021214941e-12,  -1.067249564311270e-14,   6.576630423043957e-15,  -1.526396704485171e-16,  -1.338719229941412e-04,   5.122938727382644e-06,  -6.539055290317467e-08,
  -3.235143537017863e-09,   1.385637755735787e-10,   3.098312656956375e-12,  -3.113008546076589e-13,  -1.218249656661388e-15,   7.497059679663308e-16,  -1.739450295103862e-17,
  -2.475008836327817e-02,   7.940440785115603e-04,   1.037277558894417e-05,  -2.255995435635929e-06,   8.529979255517998e-08,   1.167902464343760e-09,  -2.362508539235541e-10,
   7.235368042960439e-12,   2.008097962962211e-13,  -2.240589216491858e-14,  -2.288388818498245e-02,   7.338915874106265e-04,   9.612920400364265e-06,  -2.085401389067042e-06,
   7.871526913014097e-08,   1.086360795144895e-09,  -2.181902763158865e-10,   6.655075149881600e-12,   1.865168101913800e-13,  -2.065155300887948e-14,  -1.943589334259865e-02,
   6.229230524893965e-04,   8.195514033314744e-06,  -1.770503013497156e-06,   6.664215210190887e-08,   9.317288100237646e-10,  -1.849694044477617e-10,   5.604024323170291e-12,
   1.595845291767797e-13,  -1.744929618683065e-14,  -1.493136228025441e-02,   4.782339657619668e-04,   6.321319454058785e-06,  -1.359604280339752e-06,   5.102365674696842e-08,
   7.231293044011564e-10,  -1.418174530361664e-10,   4.265964589806636e-12,   1.235404972341360e-13,  -1.333118650257106e-14,  -1.005618130871437e-02,   3.219190228431972e-04,
   4.270717874291837e-06,  -9.153863261406670e-07,   3.427237630933381e-08,   4.908953665893655e-10,  -9.536269435979194e-11,   2.852358184277485e-12,   8.369687573833281e-14,
  -8.939186930359486e-15,  -5.552412362650004e-03,   1.776904032439683e-04,   2.362279068178364e-06,  -5.053251225313353e-07,   1.889391133938442e-08,   2.722722809604454e-10,
  -5.260539870461641e-11,   1.568302890510833e-12,   4.636811081818711e-14,  -4.923143961738604e-15,  -2.105494070569007e-03,   6.737316957283305e-05,   8.963889747955750e-07,
  -1.916074052496234e-07,   7.160478706007501e-09,   1.034213956674306e-10,  -1.994129322843114e-11,   5.937676567676171e-13,   1.760503487859549e-14,  -1.865087866016986e-15,
  -2.400542474529697e-04,   7.681290288081241e-06,   1.022116543557809e-07,  -2.184552742300356e-08,   8.163109589895516e-10,   1.179471249942170e-11,  -2.273442246367947e-12,
   6.767966111618393e-14,   2.007624290078629e-15,  -2.126110025301055e-16,  -2.176471601655924e-04,   8.796865249555567e-06,  -2.146311109374441e-07,   1.913744319170406e-09,
   6.984288586585100e-11,  -4.619250051541075e-13,  -2.199639186455967e-13,   1.002737937661369e-14,   4.559727655284156e-17,  -1.955121344624350e-17,  -2.012498566494228e-04,
   8.133990925680258e-06,  -1.984337533951584e-07,   1.769308047045220e-09,   6.443351589828246e-11,  -4.180148781731025e-13,  -2.033202126244956e-13,   9.240904988171292e-15,
   4.325747253145113e-17,  -1.804095267125716e-17,  -1.709459193487506e-04,   6.909006965549978e-06,  -1.685158712304305e-07,   1.502534581337009e-09,   5.452562323434645e-11,
  -3.424033416140663e-13,  -1.726027551883183e-13,   7.806237326408227e-15,   3.826145398394356e-17,  -1.527216594855611e-17,  -1.313424522271351e-04,   5.308234734635084e-06,
  -1.294444610168305e-07,   1.154155476412996e-09,   4.172602002483516e-11,  -2.527872537968569e-13,  -1.325308549646168e-13,   5.962619247058717e-15,   3.062425838081889e-17,
  -1.169125993189105e-17,  -8.846659239330888e-05,   3.575320180275823e-06,  -8.717182391694831e-08,   7.772414793171084e-10,   2.801608331289294e-11,  -1.648293347428864e-13,
  -8.922142198834105e-14,   3.997579887417821e-15,   2.127254383914512e-17,  -7.851958371827098e-18,  -4.884850849596986e-05,   1.974156367958730e-06,  -4.812836864062416e-08,
   4.291220994047046e-10,   1.544133703443032e-11,  -8.928491064172587e-14,  -4.925058884613220e-14,   2.201426547101748e-15,   1.195058947756717e-17,  -4.328330715875582e-18,
  -1.852389894569789e-05,   7.486186061089264e-07,  -1.825007256644330e-08,   1.627212945271278e-10,   5.851501462267838e-12,  -3.361194708600642e-14,  -1.867426479904205e-14,
   8.339640907804742e-16,   4.560845016665567e-18,  -1.640313468774441e-18,  -2.111977228944349e-06,   8.535266956450975e-08,  -2.080743277485343e-09,   1.855232352369619e-11,
   6.670749287030924e-13,  -3.827575175733388e-15,  -2.129081083094567e-15,   9.506738718269504e-17,   5.205470808978444e-19,  -1.869984939159695e-19,  -1.987863988523060e-03,
   8.006067123772368e-05,  -1.917141380629606e-06,   1.395592452016123e-08,   8.127220380969603e-10,  -8.685958816067306e-12,  -2.040524287405244e-12,   9.771794246382515e-14,
   3.485571622727478e-16,  -1.905473099301532e-16,  -1.838098486934913e-03,   7.402736264113267e-05,  -1.772412755963083e-06,   1.290036445539716e-08,   7.501168586935941e-10,
  -7.942618519457345e-12,  -1.886211973617263e-12,   9.005344930406408e-14,   3.335260916728238e-16,  -1.758521748440944e-16,  -1.561317309818975e-03,   6.287815643612380e-05,
  -1.505116739425913e-06,   1.095212400931517e-08,   6.352477401249552e-10,  -6.622934491682611e-12,  -1.601361880916109e-12,   7.607214433929878e-14,   2.988637095377739e-16,
  -1.488969139562490e-16,  -1.199600804055906e-03,   4.830917178588289e-05,  -1.156090104847286e-06,   8.410202758635176e-09,   4.865157588009377e-10,  -4.988096076788994e-12,
  -1.229679675142584e-12,   5.810567699896790e-14,   2.422074837678964e-16,  -1.140114844295670e-16,  -8.079980074808013e-04,   3.253798949140307e-05,  -7.785162622128788e-07,
   5.662325603432020e-09,   3.268680131719472e-10,  -3.306671917267006e-12,  -8.278847975779112e-13,   3.895618957906276e-14,   1.697603358968673e-16,  -7.658529376586344e-17,
  -4.461510614541806e-04,   1.796615691490351e-05,  -4.298165004476228e-07,   3.125793630183266e-09,   1.802226162715531e-10,  -1.808960772975563e-12,  -4.570112754586543e-13,
   2.145270991638838e-14,   9.583490864505459e-17,  -4.222152637350838e-17,  -1.691854020058270e-04,   6.812922589577670e-06,  -1.629832330375063e-07,   1.185226948869768e-09,
   6.830487152541806e-11,  -6.835770375593423e-13,  -1.732864080565810e-13,   8.126897487248195e-15,   3.663970106359807e-17,  -1.600138701939739e-17,  -1.928944325952133e-05,
   7.767652952184721e-07,  -1.858216168632642e-08,   1.351299892227711e-10,   7.786977633668731e-12,  -7.789174742227037e-14,  -1.975668602749583e-14,   9.264220849148087e-16,
   4.183053803094760e-18,  -1.824197059127349e-18,  -5.700539238564194e-03,   2.275948532372925e-04,  -5.192778732673202e-06,   1.482600135317300e-08,   3.601378115641810e-09,
  -5.817944350754420e-11,  -6.079654862438465e-12,   3.292240729200676e-13,   2.050287451606923e-16,  -6.278183704823168e-16,  -5.271047234561494e-03,   2.104401882618036e-04,
  -4.800398529065827e-06,   1.368379920289919e-08,   3.325901025522555e-09,  -5.349523984155545e-11,  -5.620862929565249e-12,   3.034219875250515e-13,   2.314189815284075e-16,
  -5.796117264055607e-16,  -4.477312706832223e-03,   1.787413473612119e-04,  -4.075942220628711e-06,   1.158829089757763e-08,   2.819301147146450e-09,  -4.502135699599491e-11,
  -4.773364807573388e-12,   2.563423438807662e-13,   2.545705194524385e-16,  -4.910590510744395e-16,  -3.440020313902638e-03,   1.373228957949850e-04,  -3.130340462369450e-06,
   8.875217502046824e-09,   2.161427581867092e-09,  -3.425102729033832e-11,  -3.666535251073928e-12,   1.958230262808233e-13,   2.425211606349685e-16,  -3.762439182300645e-16,
  -2.317037048263291e-03,   9.248998984850343e-05,  -2.107763933764881e-06,   5.962995961792038e-09,   1.453343239487674e-09,  -2.289028905370299e-11,  -2.469073839522599e-12,
   1.312989024455515e-13,   1.880547828869331e-16,  -2.528598761869292e-16,  -1.279392238278149e-03,   5.106858341986216e-05,  -1.163619624677260e-06,   3.287829819086926e-09,
   8.016942739250601e-10,  -1.258216342424318e-11,  -1.363165443037264e-12,   7.230851087918038e-14,   1.116718819942204e-16,  -1.394412718353557e-16,  -4.851592633765517e-04,
   1.936555959801952e-05,  -4.412258973373351e-07,   1.246106369623519e-09,   3.038979558817132e-10,  -4.763168519073273e-12,  -5.169013444300597e-13,   2.739305781472995e-14,
   4.346001276688574e-17,  -5.285195924327694e-17,  -5.531476566261136e-05,   2.207933935436061e-06,  -5.030517477939440e-08,   1.420603725866351e-10,   3.464636944424192e-11,
  -5.429126405512777e-13,  -5.893330833565694e-14,   3.122669603127671e-15,   4.976049082150661e-18,  -6.025357827295338e-18,  -1.181240754279275e-02,   4.623746785642366e-04,
  -9.316652287432772e-06,  -9.188206725849570e-08,   1.387424739811477e-08,  -2.975758452599807e-10,  -1.374464026265782e-11,   9.852503034193940e-13,  -7.699596613172437e-15,
  -1.609530896326598e-15,  -1.092236722986416e-02,   4.275075870998021e-04,  -8.610715149961176e-06,  -8.508353581729751e-08,   1.281930221662918e-08,  -2.742486518881180e-10,
  -1.271716577350356e-11,   9.084436728608280e-13,  -6.976343685645744e-15,  -1.487582511586437e-15,  -9.277543398691574e-03,   3.630890357730761e-04,  -7.308508193516692e-06,
  -7.244387135898553e-08,   1.087549372926003e-08,  -2.316892183137297e-10,  -1.081322451995517e-11,   7.680570388814291e-13,  -5.727179359058215e-15,  -1.262579507776525e-15,
  -7.128070840940995e-03,   2.789345755320200e-04,  -5.610752475572980e-06,  -5.580042192315488e-08,   8.344934595700135e-09,  -1.769862522681553e-10,  -8.316843916665950e-12,
   5.871909735623786e-13,  -4.239393975496944e-15,  -9.692084184871254e-16,  -4.801095892958099e-03,   1.878587898385596e-04,  -3.776736519200768e-06,  -3.765861271527862e-08,
   5.614950233278631e-09,  -1.186674015859845e-10,  -5.606397606490070e-12,   3.939551033502629e-13,  -2.770645531812478e-15,  -6.523349853746185e-16,  -2.650995778454318e-03,
   1.037235913828817e-04,  -2.084624864357998e-06,  -2.081740150668021e-08,   3.098540953737737e-09,  -6.535179198460071e-11,  -3.097099780597648e-12,   2.170356540700618e-13,
  -1.502942271555083e-15,  -3.600405948441919e-16,  -1.005284235103059e-03,   3.933225828609108e-05,  -7.904030980113995e-07,  -7.897530827584695e-09,   1.174736317301196e-09,
  -2.475756444383507e-11,  -1.174655441589844e-12,   8.223199184664500e-14,  -5.661066248709137e-16,  -1.365084730192711e-16,  -1.146160642888647e-04,   4.484397409442117e-06,
  -9.011466117258180e-08,  -9.004893750370766e-10,   1.339309612070266e-10,  -2.822236057202614e-12,  -1.339305307288349e-13,   9.374239656338869e-15,  -6.447162049975741e-17,
  -1.556339293330098e-17,  -2.154638232715378e-02,   7.920801904200946e-04,  -8.535642317217278e-06,  -9.384949866147761e-07,   6.952251159836473e-08,  -1.933461801216448e-09,
  -3.333979399727378e-11,   5.233803162584730e-12,  -1.888107497492722e-13,  -4.406477295128109e-16,  -1.992251911774154e-02,   7.322464561581894e-04,  -7.873968864337790e-06,
  -8.685823109318479e-07,   6.425894239534349e-08,  -1.782897580803843e-09,  -3.105445303469097e-11,   4.838305527341209e-12,  -1.738939898907872e-13,  -4.423417648500659e-16,
  -1.692180035921411e-02,   6.217635711609914e-04,  -6.662380594738999e-06,  -7.388948341956137e-07,   5.454674216332979e-08,  -1.507601467210800e-09,  -2.669303767943334e-11,
   4.108037893936302e-12,  -1.467441207201216e-13,  -4.241746313566570e-16,  -1.300082178199599e-02,   4.775368202222638e-04,  -5.097756728702576e-06,  -5.686092743591163e-07,
   4.188009290431506e-08,  -1.152765936443638e-09,  -2.076448485350536e-11,   3.154847414479808e-12,  -1.119604878592236e-13,  -3.651708863640804e-16,  -8.756439188197504e-03,
   3.215520181477596e-04,  -3.422431111572787e-06,  -3.834642404291390e-07,   2.819280378530098e-08,  -7.735040111963164e-10,  -1.412096023262722e-11,   2.124156217997818e-12,
  -7.499442973769351e-14,  -2.666679161989800e-16,  -4.834921944559409e-03,   1.775204102668117e-04,  -1.886193340052029e-06,  -2.118876945434634e-07,   1.556213305607437e-08,
  -4.261653484032243e-10,  -7.840027443307206e-12,   1.172627064067219e-12,  -4.127659526585544e-14,  -1.538192868680121e-16,  -1.833440315367530e-03,   6.731335444046496e-05,
  -7.147576999779658e-07,  -8.037160426571193e-08,   5.900612596929904e-09,  -1.614728755192342e-10,  -2.979122119059307e-12,   4.446348442600965e-13,  -1.563360443453533e-14,
  -5.926429714564661e-17,  -2.090369102240822e-04,   7.674558381180228e-06,  -8.148253295458425e-08,  -9.163864373417378e-09,   6.727366983381608e-10,  -1.840758286485836e-11,
  -3.397757361751988e-13,   5.069371003940053e-14,  -1.782086244310540e-15,  -6.774585871365454e-18,  -1.857242415448591e-04,   7.188569871872741e-06,  -1.859420796202966e-07,
   2.762265769379452e-09,   2.927023867718146e-11,  -2.686434774779280e-12,   9.381730010580483e-15,   4.937372594263564e-15,  -2.323075161744719e-16,   1.814598550543589e-18,
  -1.717321102692111e-04,   6.647041895780542e-06,  -1.719176679459523e-07,   2.552876439188784e-09,   2.706886448273183e-11,  -2.479365813080641e-12,   8.392548133343685e-15,
   4.567789922981179e-15,  -2.142267104806129e-16,   1.644034732485332e-18,  -1.458731030949272e-04,   5.646210305368632e-06,  -1.460085933923006e-07,   2.166680946938687e-09,
   2.299796942889458e-11,  -2.099504034870422e-12,   6.735938063210402e-15,   3.883252683453992e-15,  -1.811606490345399e-16,   1.349431364841019e-18,  -1.120784705081901e-04,
   4.338196565520447e-06,  -1.121645349179314e-07,   1.663266673806994e-09,   1.767390008017170e-11,  -1.607787588197199e-12,   4.856042418058821e-15,   2.986213443593230e-15,
  -1.385312147219430e-16,   9.986186617225346e-19,  -7.549128901047651e-05,   2.922052081599232e-06,  -7.553969829487598e-08,   1.119535096177055e-09,   1.190634470088549e-11,
  -1.080115619246668e-12,   3.101979354221967e-15,   2.012732217467114e-15,  -9.295870525617343e-17,   6.524661952392045e-19,  -4.168397428661262e-05,   1.613476263315564e-06,
  -4.170765817282557e-08,   6.179276826727264e-10,   6.574917510496523e-12,  -5.955073377855306e-13,   1.659112805349078e-15,   1.111790805366816e-15,  -5.121733145313035e-17,
   3.538654549527854e-19,  -1.580703139754218e-05,   6.118495693789597e-07,  -1.581557883406092e-08,   2.342902171158200e-10,   2.493366147618572e-12,  -2.256949904399473e-13,
   6.215139274861501e-16,   4.216631229547853e-16,  -1.940628883676269e-17,   1.332788140240570e-19,  -1.802217327911546e-06,   6.975922544412701e-08,  -1.803183654656051e-09,
   2.671162303716735e-11,   2.842793410384883e-13,  -2.572988862513408e-14,   7.071671706018825e-17,   4.807647381461363e-17,  -2.212281295347268e-18,   1.517839552101387e-20,
  -1.696956542022727e-03,   6.558847543865936e-05,  -1.683547442244575e-06,   2.379758471800039e-08,   3.567939246967361e-10,  -2.818363466506687e-11,   1.615220795436269e-13,
   4.628902965980572e-14,  -2.268200717697126e-15,   2.031410034278614e-17,  -1.569110169161894e-03,   6.064738888074851e-05,  -1.556544043651488e-06,   2.199144584297306e-08,
   3.299936287135363e-10,  -2.601631914014776e-11,   1.465922219281659e-13,   4.282917979901601e-14,  -2.091821774948102e-15,   1.844804262102040e-17,  -1.332836350811129e-03,
   5.151557237580001e-05,  -1.321929195801119e-06,   1.866154514121504e-08,   2.804132700228315e-10,  -2.203744992789293e-11,   1.206769373321980e-13,   3.641775939226153e-14,
  -1.769166922937584e-15,   1.520367345990010e-17,  -1.024055417746011e-03,   3.958114521153712e-05,  -1.015485025337385e-06,   1.432315657840932e-08,   2.155363707674317e-10,
  -1.688192637466513e-11,   8.959631855502163e-14,   2.801087955677281e-14,  -1.353037161457838e-15,   1.130267961404146e-17,  -6.897597280222930e-04,   2.666031219517590e-05,
  -6.838863029897122e-07,   9.639508150414788e-09,   1.452210721775391e-10,  -1.134439134616742e-11,   5.869697379488177e-14,   1.888256061588320e-14,  -9.080235114239269e-16,
   7.413013053282091e-18,  -3.808640280884945e-04,   1.472105007630783e-05,  -3.775887907907605e-07,   5.320106718968214e-09,   8.020070202739790e-11,  -6.255559975102589e-12,
   3.188540727842947e-14,   1.043127928791139e-14,  -5.003223507147241e-16,   4.029679482164995e-18,  -1.444278991901855e-04,   5.582393758613435e-06,  -1.431813197932882e-07,
   2.017083606328678e-09,   3.041499500278989e-11,  -2.370973064480188e-12,   1.201657707814233e-14,   3.956352230524051e-15,  -1.895767980185168e-16,   1.519061414085661e-18,
  -1.646675142048760e-05,   6.364691985126502e-07,  -1.632453793564349e-08,   2.299682474902458e-10,   3.467762023498433e-12,  -2.703005050686054e-13,   1.368641904292923e-15,
   4.510912385763513e-16,  -2.161148719035800e-17,   1.730229900447765e-19,  -4.870897886798483e-03,   1.876187787462514e-04,  -4.725078242780962e-06,   5.815235636703802e-08,
   1.663045372904985e-09,  -1.074750084388082e-10,   1.044169829763541e-12,   1.405027425356813e-13,  -7.609916305878335e-15,   9.047457411278664e-17,  -4.503926179287995e-03,
   1.734832505607159e-04,  -4.368452871975034e-06,   5.372197905199843e-08,   1.538332609606737e-09,  -9.924327154787101e-11,   9.562093769320664e-13,   1.300454003230756e-13,
  -7.019708911372236e-15,   8.250379489436359e-17,  -3.825726065187527e-03,   1.473596256579811e-04,  -3.709760250740683e-06,   4.556400668821735e-08,   1.307493020129608e-09,
  -8.411142043628806e-11,   7.992908134766303e-13,   1.106396325213777e-13,  -5.939104056544022e-15,   6.847504585088043e-17,  -2.939406604374867e-03,   1.132198387823040e-04,
  -2.849579695437425e-06,   3.495224381015315e-08,   1.005227857896093e-09,  -6.447178580652603e-11,   6.036000050999875e-13,   8.514893730679880e-14,  -4.543905191871195e-15,
   5.130713461615114e-17,  -1.979854989307730e-03,   7.625965482502433e-05,  -1.918965967578161e-06,   2.351276011005034e-08,   6.774161954729234e-10,  -4.334406653922049e-11,
   4.009971029940058e-13,   5.742652818370918e-14,  -3.050341404443635e-15,   3.386926331784985e-17,  -1.093213847734736e-03,   4.210811050293898e-05,  -1.059469965107879e-06,
   1.297360613094020e-08,   3.741551704187533e-10,  -2.390731649087504e-11,   2.196487643435409e-13,   3.173245056407377e-14,  -1.681037351883148e-15,   1.848250563756138e-17,
  -4.145587816969922e-04,   1.596784979159595e-05,  -4.017452308114304e-07,   4.918396621349182e-09,   1.418989832981423e-10,  -9.062227248468559e-12,   8.304151322971788e-14,
   1.203659984494362e-14,  -6.370026301664991e-16,   6.977616549404711e-18,  -4.726535574856897e-05,   1.820552463729124e-06,  -4.580410547631056e-08,   5.607390129391852e-10,
   1.617870662234190e-11,  -1.033147742319090e-12,   9.463108979523307e-15,   1.372398895299874e-15,  -7.261819233692514e-17,   7.949548914331117e-19,  -1.011432135478929e-02,
   3.866789016224526e-04,  -9.318449867288408e-06,   7.295643821589868e-08,   6.558378996323585e-09,  -3.585668331395113e-10,   5.433629631074603e-12,   3.186029846642059e-13,
  -2.176444254811723e-14,   4.112317064802687e-16,  -9.352289153902597e-03,   3.575395477574298e-04,  -8.614271473368310e-06,   6.730048882761520e-08,   6.067466571137003e-09,
  -3.312408952629902e-10,   4.997504318364054e-12,   2.952101893054319e-13,  -2.008942168636998e-14,   3.769492203428367e-16,  -7.943991824535156e-03,   3.036914023736048e-04,
  -7.314166118706835e-06,   5.694425254572450e-08,   5.158260916321724e-09,  -2.809275373540109e-10,   4.207724661042543e-12,   2.516027622157552e-13,  -1.701494035623289e-14,
   3.155937964070193e-16,  -6.103553157482593e-03,   2.333260282161022e-04,  -5.617245103918100e-06,   4.357086457449244e-08,   3.966819465766290e-09,  -2.154886414354492e-10,
   3.202590982778811e-12,   1.939956283310447e-13,  -1.303252806739172e-14,   2.387416241604940e-16,  -4.111071097071651e-03,   1.571538364579941e-04,  -3.782244823889704e-06,
   2.925161171921072e-08,   2.673767912408196e-09,  -1.449549554655959e-10,   2.141083090752911e-12,   1.310255659559588e-13,  -8.756566623040481e-15,   1.588287214508886e-16,
  -2.270000149093630e-03,   8.677404435526055e-05,  -2.088027638176416e-06,   1.612131337791564e-08,   1.476971601200373e-09,  -7.997937648413056e-11,   1.177133442762462e-12,
   7.246179486789379e-14,  -4.828205183897019e-15,   8.707109561395344e-17,  -8.608085337788063e-04,   3.290548111204681e-05,  -7.917448759743113e-07,   6.109037353339373e-09,
   5.601693470339585e-10,  -3.032048623601062e-11,   4.456554635430720e-13,   2.749443801034408e-14,  -1.829925184502420e-15,   3.292879891041249e-17,  -9.814390251315386e-05,
   3.751669972604843e-06,  -9.026861354653087e-08,   6.964315156917360e-10,   6.386855896598747e-11,  -3.456786860511705e-12,   5.079707289899395e-14,   3.135045391937633e-15,
  -2.086178320437903e-16,   3.752640680715736e-18,  -1.856324723527909e-02,   6.946351359557985e-04,  -1.443273334781775e-05,  -1.409095903199324e-07,   3.138350137048535e-08,
  -1.606114556246224e-09,   3.861729761934866e-11,   4.968514325773380e-13,  -8.568214090190217e-14,   3.563592137833784e-15,  -1.716453220767413e-02,   6.422522096098503e-04,
  -1.333644360446568e-05,  -1.309904640239570e-07,   2.904274326580782e-08,  -1.484558000083556e-09,   3.560048226889746e-11,   4.649729768914476e-13,  -7.931639812161793e-14,
   3.288277277485819e-15,  -1.457966844146542e-02,   5.454730937861012e-04,  -1.131578264491289e-05,  -1.122374386463695e-07,   2.470240472758805e-08,  -1.260237237740216e-09,
   3.008988903056707e-11,   4.026886952596073e-13,  -6.749640939464577e-14,   2.783544539597013e-15,  -1.120175517125586e-02,   4.190451157954735e-04,  -8.684048861698032e-06,
  -8.702659956846213e-08,   1.900625075230746e-08,  -9.676344327724290e-10,   2.299654973497759e-11,   3.156848228716523e-13,  -5.195848959638216e-14,   2.130801407199440e-15,
  -7.544908640231260e-03,   2.822204621151101e-04,  -5.843801049566080e-06,  -5.903671468966576e-08,   1.281590422740441e-08,  -6.514141133937770e-10,   1.542457300355926e-11,
   2.159577702612325e-13,  -3.504884445456683e-14,   1.431015571971846e-15,  -4.166029794377435e-03,   1.558237527190754e-04,  -3.225044686662257e-06,  -3.273183596479342e-08,
   7.081033315309097e-09,  -3.595808313250075e-10,   8.496274438979294e-12,   1.203035365861144e-13,  -1.936925422932455e-14,   7.888180605366997e-16,  -1.579799986703082e-03,
   5.908873147613054e-05,  -1.222727779625914e-06,  -1.243129722871040e-08,   2.685845209425661e-09,  -1.363413706966795e-10,   3.218933982395538e-12,   4.577103585147231e-14,
  -7.347356977855757e-15,   2.989367446700428e-16,  -1.801186604622785e-04,   6.736895678610593e-06,  -1.394030175402010e-07,  -1.417696953180065e-09,   3.062350627811061e-10,
  -1.554447976822855e-11,   3.669466741072473e-13,   5.221368057657652e-15,  -8.377427236345621e-16,   3.407923920280803e-17,  -1.597289301957653e-04,   5.837756015527640e-06,
  -1.516234905385951e-07,   2.846210003308847e-09,  -1.489592830073002e-11,  -1.530271777045364e-12,   6.290016396265734e-14,  -2.798383296547930e-16,  -8.199831708701694e-17,
   4.160223662214632e-18,  -1.476948908008229e-04,   5.398067165269862e-06,  -1.401976187595178e-07,   2.630984961139797e-09,  -1.373205578053869e-11,  -1.415143211498524e-12,
   5.805708425759506e-14,  -2.522160674321539e-16,  -7.596092917944751e-17,   3.841259433022464e-18,  -1.254548651504258e-04,   4.585402567816983e-06,  -1.190830411606001e-07,
   2.233706682645683e-09,  -1.160633813163394e-11,  -1.202269410818494e-12,   4.916936596262925e-14,  -2.051300433441891e-16,  -6.471712706924442e-17,   3.255075182807844e-18,
  -9.639016044163809e-05,   3.523228776909350e-06,  -9.149166162714645e-08,   1.715315002751447e-09,  -8.870305913364136e-12,  -9.239057559407253e-13,   3.765931311048601e-14,
  -1.501940367177193e-16,  -4.988097325074935e-17,   2.494574511692584e-18,  -6.492410187117787e-05,   2.373167467593289e-06,  -6.162316729798221e-08,   1.154883161106964e-09,
  -5.949698185578693e-12,  -6.223889296619514e-13,   2.530258048738041e-14,  -9.724052110076620e-17,  -3.368023233728546e-17,   1.676824935414255e-18,  -3.584903113964430e-05,
   1.310412728427768e-06,  -3.402587238887759e-08,   6.375380903256386e-10,  -3.277296023438491e-12,  -3.436904601477919e-13,   1.395117038318640e-14,  -5.244416145661859e-17,
  -1.862334288846555e-17,   9.247976233786454e-19,  -1.359434592761371e-05,   4.969264250256269e-07,  -1.290291463434218e-08,   2.417398251492040e-10,  -1.241656861668086e-12,
  -1.303349832680420e-13,   5.287571403636143e-15,  -1.970964488759538e-17,  -7.065894170909046e-18,   3.505375097301393e-19,  -1.549940804687055e-06,   5.665645533045156e-08,
  -1.471106895116036e-09,   2.756122788786970e-11,  -1.415444658524045e-13,  -1.486003658676045e-14,   6.028010752945556e-16,  -2.243809348131570e-18,  -8.056784923878241e-19,
   3.996310719025227e-20,  -1.459646521776466e-03,   5.331959214901125e-05,  -1.380764764062034e-06,   2.551445104457928e-08,  -1.008040384171162e-10,  -1.579938776522416e-11,
   6.396193582948666e-13,  -3.814240218455485e-15,  -7.660552972233728e-16,   4.032751429418440e-17,  -1.349675963196142e-03,   4.930359539854302e-05,  -1.276705373718279e-06,
   2.358417967958769e-08,  -9.278811248102423e-11,  -1.461160718369063e-11,   5.904541954211966e-13,  -3.463408306906244e-15,  -7.097819894702763e-16,   3.723978222171285e-17,
  -1.146440263736756e-03,   4.188098011455412e-05,  -1.084413160699952e-06,   2.002169357374384e-08,  -7.822931898507629e-11,  -1.241486660595739e-11,   5.001801487111892e-13,
  -2.853488296970577e-15,  -6.048999523759755e-16,   3.156272540380037e-17,  -8.808389266848274e-04,   3.217949411042843e-05,  -8.331455271065708e-07,   1.537407767143965e-08,
  -5.962814136412865e-11,  -9.541428196956105e-12,   3.831879463534634e-13,  -2.120450001271585e-15,  -4.663752667140965e-16,   2.419328395592305e-17,  -5.932935769758687e-04,
   2.167534240127418e-05,  -5.611500764593049e-07,   1.035046827341054e-08,  -3.991018637034813e-11,  -6.428112641267128e-12,   2.575071989795451e-13,  -1.390149314946604e-15,
  -3.149793041764289e-16,   1.626495491278708e-17,  -3.275978639719908e-04,   1.196865169258777e-05,  -3.098430586099858e-07,   5.713663557635407e-09,  -2.195671728351171e-11,
  -3.549848934492174e-12,   1.419987425211204e-13,  -7.554698496074773e-16,  -1.741909552221899e-16,   8.971197107110104e-18,  -1.242286980799761e-04,   4.538674593675643e-06,
  -1.174949996026909e-07,   2.166465050937879e-09,  -8.314782780521276e-12,  -1.346205021637942e-12,   5.382061364923119e-14,  -2.847565156940016e-16,  -6.609337618698979e-17,
   3.400577435248959e-18,  -1.416376541399378e-05,   5.174713693035492e-07,  -1.339601530301430e-08,   2.470024208690930e-10,  -9.477823458083109e-13,  -1.534869230197033e-13,
   6.135775968044791e-15,  -3.243351154955178e-17,  -7.536268494149379e-18,   3.876857333970888e-19,  -4.191164155226943e-03,   1.529121105143172e-04,  -3.931542241901817e-06,
   6.982281578857446e-08,  -4.125953405322508e-11,  -5.832402550503493e-11,   2.310814595162923e-12,  -2.072352719361564e-14,  -2.293932617861209e-15,   1.324298183690831e-16,
  -3.875398030032398e-03,   1.413944188240149e-04,  -3.635181632038309e-06,   6.453379118108624e-08,  -3.664011275688232e-11,  -5.394553040506594e-11,   2.133771607571435e-12,
  -1.895318146333751e-14,  -2.126496666653081e-15,   1.223258846676778e-16,  -3.291834142606085e-03,   1.201069759620872e-04,  -3.087573851717558e-06,   5.477642511328479e-08,
  -2.901841997590126e-11,  -4.584397085656881e-11,   1.808351864643825e-12,  -1.580798724861321e-14,  -1.813762149920947e-15,   1.037275358039657e-16,  -2.529197304806906e-03,
   9.228437694161494e-05,  -2.372082467294122e-06,   4.205365838627496e-08,  -2.058260416039901e-11,  -3.524046050936125e-11,   1.386040573784203e-12,  -1.190855675081031e-14,
  -1.399611246693207e-15,   7.954913283301466e-17,  -1.703552877812837e-03,   6.216028949516199e-05,  -1.597633580089052e-06,   2.830825450936916e-08,  -1.295676527067510e-11,
  -2.374549015456203e-11,   9.317889839725277e-13,  -7.895515877759467e-15,  -9.459027864332371e-16,   5.350168765493500e-17,  -9.406474766871715e-04,   3.432346994538270e-05,
  -8.821322669483182e-07,   1.562543634828914e-08,  -6.865645747941165e-12,  -1.311437827070311e-11,   5.139343877968027e-13,  -4.319674533947828e-15,  -5.233086165779010e-16,
   2.951653936301780e-17,  -3.567037830284460e-04,   1.301591158924799e-05,  -3.345099078385646e-07,   5.924555886958900e-09,  -2.562442784346710e-12,  -4.973523126496862e-12,
   1.948083395304839e-13,  -1.632377311676173e-15,  -1.985880154285421e-16,   1.118936442514921e-17,  -4.066909404105959e-05,   1.483992823821954e-06,  -3.813860899979656e-08,
   6.754653959650863e-10,  -2.913770515557225e-13,  -5.670571349631785e-13,   2.220927171845159e-14,  -1.860057356690172e-16,  -2.264445450711008e-17,   1.275671404868238e-18,
  -8.709286092574464e-03,   3.169281041356110e-04,  -8.021754869228542e-06,   1.294236421050915e-07,   1.074105105961699e-09,  -1.838574806718246e-10,   7.219366824208256e-12,
  -9.929419086301249e-14,  -4.914031681613858e-15,   3.554774924566059e-16,  -8.053113595726604e-03,   2.930542848600878e-04,  -7.416764155300169e-06,   1.195865056241837e-07,
   9.978625419531619e-10,  -1.700866935411339e-10,   6.669012261362789e-12,  -9.124856459520370e-14,  -4.562327255715227e-15,   3.285983204168303e-16,  -6.840452636723976e-03,
   2.489310139887018e-04,  -6.299063394718150e-06,   1.014586795874457e-07,   8.541252116288848e-10,  -1.445873602773713e-10,   5.655773661559548e-12,  -7.672101340458564e-14,
  -3.901056287857239e-15,   2.789762685609434e-16,  -5.255680426221741e-03,   1.912641656946398e-04,  -4.839013271084111e-06,   7.785510463587158e-08,   6.615569758137378e-10,
  -1.111811758846104e-10,   4.338099666586797e-12,  -5.830518137301559e-14,  -3.018153226883111e-15,   2.142233508973068e-16,  -3.539984344597878e-03,   1.288291784693419e-04,
  -3.258962083267434e-06,   5.238765889222968e-08,   4.484075409770807e-10,  -7.493460381035370e-11,   2.918027369902516e-12,  -3.893184466335692e-14,  -2.043907380748918e-15,
   1.442241478834721e-16,  -1.954664921382797e-03,   7.113608485462478e-05,  -1.799374035080349e-06,   2.891021203716299e-08,   2.484919884641813e-10,  -4.139171747320392e-11,
   1.609989311546544e-12,  -2.138864301116555e-14,  -1.132079684366156e-15,   7.961397873325173e-17,  -7.412300667046689e-04,   2.697568285180931e-05,  -6.823250597240475e-07,
   1.096070659685577e-08,   9.435836731066203e-11,  -1.569835339125952e-11,   6.103469917093492e-13,  -8.095390624263642e-15,  -4.297944640424517e-16,   3.018731259537674e-17,
  -8.451032882738514e-05,   3.075597548853681e-06,  -7.779403347979689e-08,   1.249625348681341e-09,   1.076054951580955e-11,  -1.789867137237087e-12,   6.958450253870577e-14,
  -9.226935514963884e-16,  -4.901182574885713e-17,   3.441704858170952e-18,  -1.601708753610582e-02,   5.788374142285410e-04,  -1.400525893407161e-05,   1.551149791235234e-07,
   8.496647227949821e-09,  -7.206788568850728e-10,   2.998828177339333e-11,  -6.817417725746240e-13,  -3.446748744295178e-15,   1.055857852223792e-15,  -1.481029743567486e-02,
   5.352232543439052e-04,  -1.294722904969674e-05,   1.431040726373106e-07,   7.875862925302588e-09,  -6.669724225626489e-10,   2.772290613509627e-11,  -6.286627230297472e-13,
  -3.283614821022442e-15,   9.789830179574626e-16,  -1.258007094816210e-02,   4.546227874914029e-04,  -1.099361859252172e-05,   1.211025899853700e-07,   6.716892915778328e-09,
  -5.673595973316111e-10,   2.353979373412835e-11,  -5.315999723591345e-13,  -2.923751878240159e-15,   8.352805884866810e-16,  -9.665523623187264e-03,   3.492932277268710e-04,
  -8.443405095295118e-06,   9.267681613017988e-08,   5.182750748932422e-09,  -4.365836173019007e-10,   1.807908545783063e-11,  -4.064816841662386e-13,  -2.356069802951351e-15,
   6.447792244567121e-16,  -6.510230235644047e-03,   2.352656171493345e-04,  -5.685363060493005e-06,   6.222701835337476e-08,   3.502522709416761e-09,  -2.944156721694846e-10,
   1.217340904805071e-11,  -2.727464499710104e-13,  -1.645059387902879e-15,   4.358833849514516e-16,  -3.594731843232131e-03,   1.299053561675614e-04,  -3.138723084324284e-06,
   3.429731733701264e-08,   1.937694773349072e-09,  -1.626790993309545e-10,   6.720526457255993e-12,  -1.502695403698628e-13,  -9.268642014936003e-16,   2.411856282965690e-16,
  -1.363160196267109e-03,   4.926141340097112e-05,  -1.190159269090606e-06,   1.299702135165666e-08,   7.353237429735216e-10,  -6.170564567077940e-11,   2.548319066207707e-12,
  -5.693648680942806e-14,  -3.541131255968700e-16,   9.153197372035946e-17,  -1.554188206089018e-04,   5.616470517848171e-06,  -1.356928927805576e-07,   1.481669484521748e-09,
   8.384692370972831e-11,  -7.035586288687128e-12,   2.905397451447177e-13,  -6.490640344152242e-15,  -4.042354241082315e-17,   1.043724816638704e-17,  -1.385957209561220e-04,
   4.755511936371100e-06,  -1.196599741111014e-07,   2.438602516641408e-09,  -3.206872914318305e-11,  -2.958405883677037e-13,   3.624017641535088e-14,  -1.153108308714281e-15,
   8.215172709245365e-18,   1.017022444388720e-18,  -1.281533511552994e-04,   4.397352280501336e-06,  -1.106481393909630e-07,   2.254642603299476e-09,  -2.962744351199352e-11,
  -2.745937579427413e-13,   3.351774997018765e-14,  -1.064552500926948e-15,   7.483481625289378e-18,   9.437917215905805e-19,  -1.088551904269974e-04,   3.735365841867662e-06,
  -9.399137052420912e-08,   1.914808820108153e-09,  -2.513095284925367e-11,  -2.346961062854711e-13,   2.848149910712791e-14,  -9.019021793940412e-16,   6.199394414192927e-18,
   8.063895780303814e-19,  -8.363562427331132e-05,   2.870115604835089e-06,  -7.221980125476717e-08,   1.470928550179590e-09,  -1.928007890748286e-11,  -1.815037631485346e-13,
   2.189175667445238e-14,  -6.910328843784269e-16,   4.634998561538273e-18,   6.233973035420760e-19,  -5.633290708339462e-05,   1.933255253154766e-06,  -4.864606176720420e-08,
   9.906095220682236e-10,  -1.297099957085837e-11,  -1.228777238394046e-13,   1.474983404472934e-14,  -4.644271883700228e-16,   3.054004388514654e-18,   4.219137170094701e-19,
  -3.110514708859382e-05,   1.067505759509063e-06,  -2.686146029841010e-08,   5.469378145082377e-10,  -7.157330960497697e-12,  -6.804809545137602e-14,   8.145814273113545e-15,
  -2.561157168639455e-16,   1.664681761703852e-18,   2.336097171562968e-19,  -1.179539900928633e-05,   4.048132403802043e-07,  -1.018625251261046e-08,   2.073983561771231e-10,
  -2.713448653359931e-12,  -2.583289266982215e-14,   3.089183496297977e-15,  -9.707538281209159e-17,   6.281838976693094e-19,   8.867870968420897e-20,  -1.344836060728894e-06,
   4.615429253128745e-08,  -1.161373422902923e-09,   2.364611844641337e-11,  -3.093571099274865e-13,  -2.945836926873983e-15,   3.522128392230691e-16,  -1.106703808608883e-17,
   7.156328904414701e-20,   1.011230765626659e-20,  -1.266585234711201e-03,   4.345182288192760e-05,  -1.092180628445117e-06,   2.213652084411733e-08,  -2.813967891168699e-10,
  -3.389579333538638e-12,   3.618180514647140e-13,  -1.153761007180733e-14,   9.468871920160724e-17,   9.393591911364662e-18,  -1.171155446562147e-03,   4.017924489520249e-05,
  -1.009923269819561e-06,   2.046630482238198e-08,  -2.599460547152172e-10,  -3.144620190631937e-12,   3.346534460625859e-13,  -1.065278827857735e-14,   8.647155921665877e-17,
   8.719558131759816e-18,  -9.947951928681814e-04,   3.413055135943189e-05,  -8.578870393009621e-07,   1.738106041689101e-08,  -2.204542280791364e-10,  -2.685602596112470e-12,
   2.843917802924437e-13,  -9.026904047130761e-15,   7.194002294208264e-17,   7.453386121023251e-18,  -7.643210092956964e-04,   2.622461846645158e-05,  -6.591680360743305e-07,
   1.335152470467880e-08,  -1.690960825295081e-10,  -2.075220149525498e-12,   2.186103472225258e-13,  -6.917781511980329e-15,   5.404187082011484e-17,   5.764651783909319e-18,
  -5.148095864839133e-04,   1.766439199851145e-05,  -4.440028373616979e-07,   8.991510775243250e-09,  -1.137447275434283e-10,  -1.404022917936543e-12,   1.473009548606916e-13,
  -4.650032076087375e-15,   3.574740965470152e-17,   3.902895629432613e-18,  -2.842606220845861e-04,   9.753928146073000e-06,  -2.451696133125314e-07,   4.964355285944593e-09,
  -6.275816347913389e-11,  -7.772456970680690e-13,   8.135220095712649e-14,  -2.564573733096860e-15,   1.953057266684988e-17,   2.161439109011768e-18,  -1.077946166136688e-04,
   3.698826581730880e-06,  -9.297176418424341e-08,   1.882470744304530e-09,  -2.379173883343361e-11,  -2.950231374286564e-13,   3.085209525080302e-14,  -9.720830299545074e-16,
   7.376587199656768e-18,   8.205493031205794e-19,  -1.229005369518975e-05,   4.217172337519303e-07,  -1.060006315711052e-08,   2.146260625575609e-10,  -2.712453270829336e-12,
  -3.364200892979659e-14,   3.517605739305069e-15,  -1.108225630831758e-16,   8.404717241513503e-19,   9.357096068722884e-20,  -3.637223634008199e-03,   1.247295555797159e-04,
  -3.127153811008595e-06,   6.254594952617117e-08,  -7.273110115898338e-10,  -1.453673618750990e-11,   1.256905536246676e-12,  -4.042478903772332e-14,   4.238099310258187e-16,
   2.722527920287197e-17,  -3.363179673260053e-03,   1.153354024049447e-04,  -2.891611877203434e-06,   5.782461604620315e-08,  -6.716559546982832e-10,  -1.347794983191040e-11,
   1.162657696460927e-12,  -3.733359529612584e-14,   3.884053230658724e-16,   2.529078615235478e-17,  -2.856729451697642e-03,   9.797230606446617e-05,  -2.456272495041822e-06,
   4.910463099056147e-08,  -5.693191077877467e-10,  -1.149915528245855e-11,   9.882031206825013e-13,  -3.164810529665787e-14,   3.250725244273384e-16,   2.164475076904986e-17,
  -2.194881777836376e-03,   7.527804187894841e-05,  -1.887283179191144e-06,   3.771796014977030e-08,  -4.364451671420992e-10,  -8.876390785872784e-12,   7.597611780186893e-13,
  -2.426383737703425e-14,   2.458092451322342e-16,   1.676206742307424e-17,  -1.478365718217071e-03,   5.070574013433669e-05,  -1.271224728128828e-06,   2.539962232279603e-08,
  -2.934518409555234e-10,  -6.000603255207553e-12,   5.120033701370075e-13,  -1.631525400624999e-14,   1.634705028150631e-16,   1.135986002419077e-17,  -8.163039815427396e-04,
   2.799868138467333e-05,  -7.019411773738553e-07,   1.402310879629091e-08,  -1.618696751238731e-10,  -3.320303794136502e-12,   2.827950097206531e-13,  -8.999889115894216e-15,
   8.959530553066348e-17,   6.294712031012897e-18,  -3.095510403757242e-04,   1.061748959211496e-05,  -2.661853851703762e-07,   5.317466295970943e-09,  -6.135924083776597e-11,
  -1.260086390883223e-12,   1.072507445562064e-13,  -3.411590927279773e-15,   3.388040353565549e-17,   2.390175603378926e-18,  -3.529303227350695e-05,   1.210540148452047e-06,
  -3.034879356755046e-08,   6.062589317656247e-10,  -6.995345686115403e-12,  -1.436857528931145e-13,   1.222826959652995e-14,  -3.889439527654642e-16,   3.861030239152019e-18,
   2.725721559466440e-19,  -7.559971249272070e-03,   2.590347117926197e-04,  -6.459482053438548e-06,   1.254671016765680e-07,  -1.146677818809379e-09,  -5.246668030649858e-11,
   3.656732143863936e-12,  -1.208753686754108e-13,   1.743567785197384e-15,   5.249475218127613e-17,  -6.990368819467948e-03,   2.395246062785684e-04,  -5.972848808944896e-06,
   1.159857759786830e-07,  -1.057825009930472e-09,  -4.862255585782140e-11,   3.383170482009315e-12,  -1.116779841950264e-13,   1.603419940992346e-15,   4.888503768928749e-17,
  -5.937709382021062e-03,   2.034646832826973e-04,  -5.073488382297749e-06,   9.848062160300364e-08,  -8.951029128824364e-10,  -4.145244185563590e-11,   2.876418952374326e-12,
  -9.473445805845681e-14,   1.349712259266713e-15,   4.200456335703198e-17,  -4.562057453258218e-03,   1.563335221942423e-04,  -3.898118867827989e-06,   7.563256737962304e-08,
  -6.849295799119628e-10,  -3.197236582621022e-11,   2.212204423672985e-12,  -7.268272400006081e-14,   1.027009653279500e-15,   3.266423345359627e-17,  -3.072779074176292e-03,
   1.053026792429278e-04,  -2.625613452136462e-06,   5.092540920830592e-08,  -4.598526883564706e-10,  -2.160051141847898e-11,   1.491190158439257e-12,  -4.890029112144219e-14,
   6.864370706918636e-16,   2.220806553738950e-17,  -1.696685207435498e-03,   5.814588755290647e-05,  -1.449785181865508e-06,   2.811387586504976e-08,  -2.534426449375253e-10,
  -1.194793135779231e-11,   8.237523405909815e-13,  -2.698341992777251e-14,   3.773352920785778e-16,   1.232843278495466e-17,  -6.434007918065336e-04,   2.204971309625094e-05,
  -5.497751044199134e-07,   1.066030358811852e-08,  -9.604080633797599e-11,  -4.533749532166541e-12,   3.124277087702972e-13,  -1.022987324335673e-14,   1.428484503853805e-16,
   4.684446454625442e-18,  -7.335644736872993e-05,   2.513970878413537e-06,  -6.268187087363187e-08,   1.215405101444448e-09,  -1.094868715569497e-11,  -5.169652585785020e-13,
   3.562199701584383e-14,  -1.166297088701712e-15,   1.628211155085415e-17,   5.342678107216276e-19,  -1.391193372991223e-02,   4.756786558816124e-04,  -1.169470147214184e-05,
   2.084793177239571e-07,  -2.227854745879107e-10,  -2.185032496272671e-10,   1.292372680182524e-11,  -4.687710874991699e-13,   1.046274581398534e-14,  -2.400927248790398e-17,
  -1.286373654149841e-02,   4.398482643038122e-04,  -1.081316832862954e-05,   1.926665363771763e-07,  -1.974394527518350e-10,  -2.024639221016479e-10,   1.196224087489597e-11,
  -4.334624500636205e-13,   9.653901304893333e-15,  -2.094726895993139e-17,  -1.092661081445364e-02,   3.736258612749418e-04,  -9.184282107487980e-06,   1.635068021125008e-07,
  -1.557619882044703e-10,  -1.725662470127627e-10,   1.017792638162150e-11,  -3.682011340273509e-13,   8.171417279506673e-15,  -1.604389240437246e-17,  -8.395116850038154e-03,
   2.870746478556386e-04,  -7.056001010396167e-06,   1.255056860153821e-07,  -1.099273157036808e-10,  -1.330675888135095e-10,   7.833760968245572e-12,  -2.829038267249847e-13,
   6.254734207918006e-15,  -1.089922437297803e-17,  -5.654535095646043e-03,   1.933650927366829e-04,  -4.752331734182559e-06,   8.447090591880500e-08,  -6.887016916821919e-11,
  -8.988309121806591e-11,   5.283770806648140e-12,  -1.905530936572986e-13,   4.200363948066406e-15,  -6.583577933435429e-18,  -3.122242230241724e-03,   1.067714901605320e-04,
  -2.623999006370855e-06,   4.662170279769979e-08,  -3.637883844036496e-11,  -4.971175703684425e-11,   2.919853308929281e-12,  -1.052176603801229e-13,   2.315299145603574e-15,
  -3.393620175678532e-18,  -1.183986684450520e-03,   4.048912188123298e-05,  -9.950366684716663e-07,   1.767654693272711e-08,  -1.356036066182023e-11,  -1.886280068694823e-11,
   1.107570874972486e-12,  -3.989971216213211e-14,   8.774152305400113e-16,  -1.252478383358423e-18,  -1.349905920660273e-04,   4.616315798315847e-06,  -1.134475110606354e-07,
   2.015312294808705e-09,  -1.541626256412511e-12,  -2.150834904317401e-12,   1.262844263115720e-13,  -4.549111528729308e-15,   1.000264927481692e-16,  -1.421490254670069e-19,
  -1.213154820852839e-04,   3.906368488843430e-06,  -9.354554631808973e-08,   1.915285403905453e-09,  -3.165361399556954e-11,   2.372705347746267e-13,   1.068793928609520e-14,
  -6.283317796761339e-16,   1.763227234759857e-17,  -1.792065644181308e-19,  -1.121745867455049e-04,   3.612150609524380e-06,  -8.650220303767700e-08,   1.771009510004243e-09,
  -2.926038413255921e-11,   2.188045662319754e-13,   9.903802251305695e-15,  -5.812384613601341e-16,   1.628399513530374e-17,  -1.642219342504494e-19,  -9.528192918002429e-05,
   3.068354524102289e-06,  -7.348277830054445e-08,   1.504360345353608e-09,  -2.484255309836156e-11,   1.850339791916988e-13,   8.441865156192623e-15,  -4.940544859623117e-16,
   1.380412834313961e-17,  -1.374229218003748e-19,  -7.320645933044936e-05,   2.357596406074587e-06,  -5.646369824072908e-08,   1.155863219658649e-09,  -1.907754748099079e-11,
   1.414953148988166e-13,   6.510023034998084e-15,  -3.798683620720592e-16,   1.058326467314018e-17,  -1.038954459983719e-19,  -4.930803170132312e-05,   1.588025406048033e-06,
  -3.803407785793241e-08,   7.785508431674293e-10,  -1.284467700392150e-11,   9.494913329119529e-14,   4.397525667642240e-15,  -2.560060065755937e-16,   7.116267099446683e-18,
  -6.908235005039759e-20,  -2.722615193044584e-05,   8.768744656702861e-07,  -2.100205810858149e-08,   4.298952258198743e-10,  -7.090794676056507e-12,   5.231450410947879e-14,
   2.432206641811959e-15,  -1.414038626968479e-16,   3.925492698053910e-18,  -3.785900921004434e-20,  -1.032442986198639e-05,   3.325228633368795e-07,  -7.964331287339110e-09,
   1.630215715722811e-10,  -2.688675072856504e-12,   1.982208488133420e-14,   9.228933796998206e-16,  -5.362834664138553e-17,   1.488035788439815e-18,  -1.431579835723575e-20,
  -1.177125300490932e-06,   3.791218682920165e-08,  -9.080446421447696e-10,   1.858669312584890e-11,  -3.065412337310049e-13,   2.259682749007081e-15,   1.052332750861438e-16,
  -6.114484551240883e-18,   1.696458920955828e-19,  -1.631425904539615e-21,  -1.108682068773089e-03,   3.569779382321054e-05,  -8.545443641276239e-07,   1.746272991229590e-08,
  -2.858778233031330e-10,   1.950665459910247e-12,   1.086680860110380e-13,  -6.180901985549463e-15,   1.745265852834002e-16,  -1.909784862233108e-18,  -1.025144925594626e-03,
   3.300912007671219e-05,  -7.902021054462501e-07,   1.614719119027529e-08,  -2.642554429954947e-10,   1.797913418807212e-12,   1.006897783109659e-13,  -5.717880670375456e-15,
   1.611969745220362e-16,  -1.751805178175917e-18,  -8.707657090310508e-04,   2.803970998943183e-05,  -6.712677551298485e-07,   1.371588353871167e-08,  -2.243460126674489e-10,
   1.519108548416054e-12,   8.581867601506938e-14,  -4.860545827912136e-15,   1.366706138268403e-16,  -1.468338303490447e-18,  -6.690216411670706e-04,   2.154454446559882e-05,
  -5.157968565789186e-07,   1.053838133925642e-08,  -1.722746958217825e-10,   1.160585518438930e-12,   6.617347975785975e-14,  -3.737443477420027e-15,   1.047998622753678e-16,
  -1.112095238211987e-18,  -4.506178805221613e-04,   1.451193093173479e-05,  -3.474414225497016e-07,   7.098244245818520e-09,  -1.159855405848963e-10,   7.782272105819176e-13,
   4.469687758354024e-14,  -2.518931482861405e-15,   7.047782837699042e-17,  -7.405296233885117e-19,  -2.488152597789861e-04,   8.013184149453047e-06,  -1.918536973459540e-07,
   3.919444833033689e-09,  -6.402727268371814e-11,   4.285995986555366e-13,   2.472012029603869e-14,  -1.391367132640655e-15,   3.888022184001483e-17,  -4.061768952972465e-19,
  -9.435324140169812e-05,   3.038709542598671e-06,  -7.275410277935130e-08,   1.486299214651691e-09,  -2.427752674970126e-11,   1.623711934194952e-13,   9.379823121435375e-15,
  -5.276916668238019e-16,   1.473875612884135e-17,  -1.536392227914687e-19,  -1.075755165479251e-05,   3.464547423932025e-07,  -8.294980103453298e-09,   1.694584287344930e-10,
  -2.767925284118411e-12,   1.850953488407712e-14,   1.069535113977276e-15,  -6.016536683439331e-17,   1.680323662390331e-18,  -1.750964156493373e-20,  -3.183883549313652e-03,
   1.025034841108964e-04,  -2.451677223208872e-06,   4.987249250384715e-08,  -7.977426227017415e-10,   4.100798370110091e-12,   3.887115606619991e-13,  -2.085557172765660e-14,
   5.982642671228245e-16,  -7.561310674358168e-18,  -2.943983699412353e-03,   9.478312626006523e-05,  -2.267074047180540e-06,   4.611474000943689e-08,  -7.373485641107317e-10,
   3.772407063638895e-12,   3.601416008030041e-13,  -1.929503916983299e-14,   5.526886161221883e-16,  -6.947642174188661e-18,  -2.500641447500801e-03,   8.051379938824357e-05,
  -1.925845348677195e-06,   3.917025847595390e-08,  -6.259105152195822e-10,   3.177243316159139e-12,   3.069083711551192e-13,  -1.640445914929200e-14,   4.687600578809359e-16,
  -5.840022010979221e-18,  -1.921278151880325e-03,   6.186340554861083e-05,  -1.479797515736873e-06,   3.009509990075711e-08,  -4.805702217781877e-10,   2.419044483078907e-12,
   2.366176006675017e-13,  -1.261600832785742e-14,   3.595820303462398e-16,  -4.436859369423218e-18,  -1.294072103622443e-03,   4.166980592492788e-05,  -9.967898436395794e-07,
   2.027049375018396e-08,  -3.235139672611268e-10,   1.617633984310143e-12,   1.598050949062866e-13,  -8.503921104635799e-15,   2.418898566695138e-16,  -2.961827366577134e-18,
  -7.145408352241369e-04,   2.300918646303032e-05,  -5.504162692517456e-07,   1.119265294408414e-08,  -1.785778081761793e-10,   8.894684251639958e-13,   8.837625882449297e-14,
  -4.697607108164799e-15,   1.334651532808778e-16,  -1.626927381700093e-18,  -2.709610463461246e-04,   8.725398670004509e-06,  -2.087268083941292e-07,   4.244366578521599e-09,
  -6.771063579270826e-11,   3.367638607356642e-13,   3.353274158929158e-14,  -1.781669890773456e-15,   5.059735575099297e-17,  -6.157376716441116e-19,  -3.089324122420744e-05,
   9.948156109275088e-07,  -2.379775748548968e-08,   4.839154714036558e-10,  -7.719784008571430e-12,   3.838561108845292e-14,   3.823558180167958e-15,  -2.031400580255662e-16,
   5.768521915820938e-18,  -7.017959851359678e-20,  -6.618161419731203e-03,   2.130154056227433e-04,  -5.085981881098008e-06,   1.024694070938579e-07,  -1.556045958938306e-09,
   1.798942990944916e-12,   1.159592527484117e-12,  -5.806443397659369e-14,   1.726815519863649e-15,  -2.714710669833489e-17,  -6.119494474884294e-03,   1.969713503983323e-04,
  -4.702997691297965e-06,   9.474567412283008e-08,  -1.437976889583075e-09,   1.609652831254743e-12,   1.074296225054017e-12,  -5.372948926759558e-14,   1.595879765404795e-15,
  -2.499763621471782e-17,  -5.197943018654677e-03,   1.673176569160827e-04,  -3.995088737021171e-06,   8.047367274436857e-08,  -1.220277831237952e-09,   1.292271058148446e-12,
   9.154097828517536e-13,  -4.569394654893857e-14,   1.354393223445725e-15,  -2.108787073572852e-17,  -3.993652498516913e-03,   1.285596435826141e-04,  -3.069750080110202e-06,
   6.182576841149978e-08,  -9.366172747258233e-10,   9.317034168083449e-13,   7.056805884248635e-13,  -3.515252100954176e-14,   1.039643553083661e-15,  -1.608333284797295e-17,
  -2.689914376303186e-03,   8.659480259522345e-05,  -2.067763866959745e-06,   4.164083297675662e-08,  -6.303574624601668e-10,   5.951034957451773e-13,   4.765587641919065e-13,
  -2.370075830044251e-14,   6.997371598022684e-16,  -1.076977304672568e-17,  -1.485275463056887e-03,   4.781578949142693e-05,  -1.141791070063237e-06,   2.299203112193254e-08,
  -3.479019766460220e-10,   3.182523537628923e-13,   2.635368534133331e-13,  -1.309430254746906e-14,   3.862056903055325e-16,  -5.926540898062590e-18,  -5.632313286056612e-04,
   1.813239790465752e-05,  -4.329850250766164e-07,   8.718728143454092e-09,  -1.319052465508199e-10,   1.192113983387496e-13,   9.999247303000342e-14,  -4.966568822991985e-15,
   1.464295698867902e-16,  -2.244532430393794e-18,  -6.421602464763205e-05,   2.067342989449589e-06,  -4.936629753730426e-08,   9.940519595818132e-10,  -1.503856197193949e-11,
   1.356387708476590e-14,   1.140157137615336e-14,  -5.662766985496818e-16,   1.669451608672137e-17,  -2.558529167602356e-19,  -1.218089924812739e-02,   3.918253295314298e-04,
  -9.314577185531518e-06,   1.829948838186109e-07,  -2.369257664310903e-09,  -3.066261621813845e-11,   4.009551077869981e-12,  -1.913037722039819e-13,   6.269007578244793e-15,
  -1.387442591778308e-16,  -1.126308746159744e-02,   3.623127817831971e-04,  -8.613042104976332e-06,   1.691863519398666e-07,  -2.187990273830640e-09,  -2.852845041641511e-11,
   3.715013233525187e-12,  -1.771005800023587e-13,   5.798426982901517e-15,  -1.281048651429372e-16,  -9.566945117238180e-03,   3.077661736051381e-04,  -7.316400810313394e-06,
   1.436798758983782e-07,  -1.854657261633784e-09,  -2.447820027259600e-11,   3.166123652007090e-12,  -1.507246667339257e-13,   4.927675079691638e-15,  -1.085535154321070e-16,
  -7.350415520226327e-03,   2.364733443757868e-04,  -5.621635034895042e-06,   1.103681458616513e-07,  -1.421824685532286e-09,  -1.900765842298176e-11,   2.441191590639709e-12,
  -1.160432820850935e-13,   3.787966581801355e-15,  -8.319006138771807e-17,  -4.950852129164501e-03,   1.592825192480980e-04,  -3.786618496672771e-06,   7.432588031124520e-08,
  -9.560019078107586e-10,  -1.290906407346486e-11,   1.648825566721088e-12,  -7.828736754687189e-14,   2.552401052714640e-15,  -5.591878454494583e-17,  -2.733684793576162e-03,
   8.795223922981341e-05,  -2.090894109819736e-06,   4.103618896462374e-08,  -5.273393525707861e-10,  -7.161891441878357e-12,   9.118787024110033e-13,  -4.326784816892198e-14,
   1.409668940341560e-15,  -3.083999753194763e-17,  -1.036640586280758e-03,   3.335266493363465e-05,  -7.928961597275912e-07,   1.556077340167387e-08,  -1.998966974136721e-10,
  -2.720698968886155e-12,   3.460008239071141e-13,  -1.641334196150622e-14,   5.346063909080242e-16,  -1.168964519173488e-17,  -1.181911115428143e-04,   3.802662575281296e-06,
  -9.040109055402738e-08,   1.774129012363383e-09,  -2.278950938933008e-11,  -3.102880972439232e-13,   3.945271309513957e-14,  -1.871452484600461e-15,   6.095325713820566e-17,
  -1.332680223770400e-18,  -1.070527716545299e-04,   3.241753876407555e-06,  -7.341290829089893e-08,   1.455800117514175e-09,  -2.546994411435967e-11,   3.389065569405508e-13,
  -2.577435589547567e-16,  -2.011342695520506e-16,   8.850418840737948e-18,  -2.305567629712173e-19,  -9.898614336116161e-05,   2.997575642879680e-06,  -6.788559526494811e-08,
   1.346206971946856e-09,  -2.355009450198296e-11,   3.131720878174549e-13,  -2.274124438335352e-16,  -1.863351842799357e-16,   8.188903886315777e-18,  -2.130202584232493e-19,
  -8.407900720997691e-05,   2.546277240766627e-06,  -5.766840362360955e-08,   1.143615708854345e-09,  -2.000258957501522e-11,   2.657335450555076e-13,  -1.779449376473833e-16,
  -1.587705700707430e-16,   6.963135940140224e-18,  -1.807099005942197e-19,  -6.459863880230895e-05,   1.956434042421000e-06,  -4.431224100060662e-08,   8.787681496351512e-10,
  -1.536742004910829e-11,   2.039405168758492e-13,  -1.243019894103732e-16,  -1.223897356412536e-16,   5.355886731528977e-18,  -1.386517777113264e-19,  -4.351001326805780e-05,
   1.317800705315480e-06,  -2.984893897071144e-08,   5.919514268989210e-10,  -1.035023135442746e-11,   1.372434676241792e-13,  -7.713858377271439e-17,  -8.264930758009185e-17,
   3.610611641222283e-18,  -9.328685864926849e-20,  -2.402461402558039e-05,   7.276586843385947e-07,  -1.648233734077865e-08,   3.268735306156287e-10,  -5.714885294768654e-12,
   7.574265532483184e-14,  -4.049413700640944e-17,  -4.570417980269655e-17,   1.994657209322820e-18,  -5.147709958378868e-20,  -9.110363601464305e-06,   2.759377096394790e-07,
  -6.250382739480600e-09,   1.239564084881735e-10,  -2.167120880424454e-12,   2.871691264043279e-14,  -1.505682936303766e-17,  -1.734118538305570e-17,   7.565368425848603e-19,
  -1.951597545248232e-20,  -1.038705041640077e-06,   3.146069086433922e-08,  -7.126307429087947e-10,   1.413276576778050e-11,  -2.470808327319352e-13,   3.274015024099552e-15,
  -1.711032794917389e-18,  -1.977314123947484e-18,   8.625817794499933e-20,  -2.224998301455904e-21,  -9.783414492565824e-04,   2.962552750107200e-05,  -6.708249528163323e-07,
   1.329404363009485e-08,  -2.318634711922766e-10,   3.035838731885685e-12,   9.959249914249939e-16,  -1.987422223714391e-15,   8.630509058989755e-17,  -2.263496223220417e-18,
  -9.046215713309250e-04,   2.739404610572236e-05,  -6.203178027821603e-07,   1.229323703808280e-08,  -2.143840570009387e-10,   2.805143348634973e-12,   1.027177289938883e-15,
  -1.841169660703101e-15,   7.985725767476898e-17,  -2.091503430828105e-18,  -7.683871748437358e-04,   2.326974816931949e-05,  -5.269559023204500e-07,   1.044318578817701e-08,
  -1.820868728050222e-10,   2.379985995699228e-12,   1.020781328752499e-15,  -1.568775034879207e-15,   6.790782813436347e-17,  -1.774510350827157e-18,  -5.903586021972544e-04,
   1.787932701054688e-05,  -4.049111814655736e-07,   8.024640303627692e-09,  -1.398896188407028e-10,   1.826352788076841e-12,   9.052445882875568e-16,  -1.209280546172173e-15,
   5.223653410614753e-17,  -1.361710609194498e-18,  -3.976323793883763e-04,   1.204302705264418e-05,  -2.727499793463081e-07,   5.405502306617889e-09,  -9.421680229795912e-11,
   1.228954549687820e-12,   6.738815357217926e-16,  -8.166099339488984e-16,   3.521646986026996e-17,  -9.162826511657036e-19,  -2.195578370689950e-04,   6.649877201783175e-06,
  -1.506102382236112e-07,   2.984894587437857e-09,  -5.202142263838426e-11,   6.782085302288734e-13,   3.925456551934848e-16,  -4.515726035424379e-16,   1.945566428936255e-17,
  -5.056520584117082e-19,  -8.325843330399020e-05,   2.521720548512101e-06,  -5.711395822580590e-08,   1.131925778592281e-09,  -1.972679321269768e-11,   2.571298022902322e-13,
   1.517701224364919e-16,  -1.713361644566285e-16,   7.379257513519321e-18,  -1.917073535446185e-19,  -9.492590877307864e-06,   2.875107955597475e-07,  -6.511787103292742e-09,
   1.290553702754006e-10,  -2.249117722769804e-12,   2.931527695199530e-14,   1.735891116020909e-17,  -1.953645203305107e-17,   8.413634815781538e-19,  -2.185646809786983e-20,
  -2.809601134121093e-03,   8.507564628899007e-05,  -1.925898782770051e-06,   3.810839334751406e-08,  -6.597570178017499e-10,   8.300253818566671e-12,   2.587561565928991e-14,
  -6.743490364575053e-15,   2.860198451912950e-16,  -7.625774108356623e-18,  -2.597892348916926e-03,   7.866749041419998e-05,  -1.780894147877413e-06,   3.523932522686363e-08,
  -6.100047819253445e-10,   7.668294857287354e-12,   2.427756424887386e-14,  -6.247167309031084e-15,   2.646738567826317e-16,  -7.047613959963474e-18,  -2.206654352228327e-03,
   6.682372976446141e-05,  -1.512855664811340e-06,   2.993578806240334e-08,  -5.180854705294760e-10,   6.504360376573807e-12,   2.111213175189151e-14,  -5.322817675377221e-15,
   2.251008485841745e-16,  -5.981260984582161e-18,  -1.695391850919563e-03,   5.134404807327490e-05,  -1.162471495712941e-06,   2.300273085768759e-08,  -3.980055602898497e-10,
   4.989923065918885e-12,   1.662097250602007e-14,  -4.102980025911848e-15,   1.731793364462941e-16,  -4.591327367803024e-18,  -1.141920661832805e-03,   3.458394481860177e-05,
  -7.830450220895741e-07,   1.549483050575606e-08,  -2.680506899251596e-10,   3.356984787784435e-12,   1.140730059266186e-14,  -2.770642424120848e-15,   1.167665107364706e-16,
  -3.090244725621194e-18,  -6.305261881972062e-04,   1.909644173582406e-05,  -4.323905484575451e-07,   8.556142489189891e-09,  -1.480001227036562e-10,   1.852343203493374e-12,
   6.366385409494808e-15,  -1.532109278829836e-15,   6.451309381086717e-17,  -1.705606407754022e-18,  -2.391015648499276e-04,   7.241620612641198e-06,  -1.639697897734883e-07,
   3.244638358638758e-09,  -5.612199056385606e-11,   7.022468711201455e-13,   2.423836355176424e-15,  -5.813127380756419e-16,   2.446952210588261e-17,  -6.466804557227205e-19,
  -2.726082202089721e-05,   8.256442580175775e-07,  -1.869484007183051e-08,   3.699340599833875e-10,  -6.398647989233118e-12,   8.006227878486545e-14,   2.765324682631629e-16,
  -6.628362785198931e-17,   2.789962113130602e-18,  -7.372841787060070e-20,  -5.840272225607758e-03,   1.768330664007945e-04,  -4.000910045771611e-06,   7.892020382137137e-08,
  -1.345152494556249e-09,   1.542939283051056e-11,   1.559873125692926e-13,  -1.872104760827496e-14,   7.730735064731844e-16,  -2.135511510211173e-17,  -5.400196496973638e-03,
   1.635134234924262e-04,  -3.699666945807417e-06,   7.297774961015272e-08,  -1.243645799186260e-09,   1.424888868295182e-11,   1.451821596711928e-13,  -1.734351559433330e-14,
   7.155004402973894e-16,  -1.974282037175220e-17,  -4.586936284648666e-03,   1.388956531424502e-04,  -3.142828574106708e-06,   6.199346176038067e-08,  -1.056149360849591e-09,
   1.207807767122196e-11,   1.246419100577879e-13,  -1.477780714057216e-14,   6.086924854926835e-16,  -1.676506468515745e-17,  -3.524183157763625e-03,   1.067205031467373e-04,
  -2.414927515479294e-06,   4.763502650571479e-08,  -8.112804298788891e-10,   9.259313248202309e-12,   9.684372877415373e-14,  -1.139156782048747e-14,   4.684318132737179e-16,
  -1.287691885478631e-17,  -2.373691628548118e-03,   7.188398447705564e-05,  -1.626699780149124e-06,   3.208687271327929e-08,  -5.463432745221685e-10,   6.225732350499372e-12,
   6.580157932331537e-14,  -7.692672092298558e-15,   3.159152644491940e-16,  -8.671071451634854e-18,  -1.310664355816012e-03,   3.969263953180296e-05,  -8.982479281530174e-07,
   1.771800585472409e-08,  -3.016418258467687e-10,   3.434166145951345e-12,   3.651591261726424e-14,  -4.253964848310665e-15,   1.745657640346121e-16,  -4.787160122939433e-18,
  -4.970164638658425e-04,   1.505196725354143e-05,  -3.406305769549301e-07,   6.718954949837860e-09,  -1.143813823766165e-10,   1.301776819286010e-12,   1.387321013162413e-14,
  -1.614049313512758e-15,   6.621537052012792e-17,  -1.815238504695167e-18,  -5.666661929548638e-05,   1.716131077478069e-06,  -3.883662704596815e-08,   7.660542343584611e-10,
  -1.304095204179799e-11,   1.484109198329099e-13,   1.582226088008149e-15,  -1.840406237146477e-16,   7.549797428287261e-18,  -2.069599480849417e-19,  -1.074966128708607e-02,
   3.254278107393110e-04,  -7.353504168941110e-06,   1.439404867530894e-07,  -2.355106151708537e-09,   1.973882224688526e-11,   7.917792705253749e-13,  -5.886933971612180e-14,
   2.412965079476269e-15,  -7.288206646363837e-17,  -9.939653150575174e-03,   3.009153492118757e-04,  -6.799800355697604e-06,   1.330984434793732e-07,  -2.177040892300493e-09,
   1.819609351621445e-11,   7.350749503608270e-13,  -5.454705023032565e-14,   2.234209798782556e-15,  -6.743053511289190e-17,  -8.442757933464167e-03,   2.556107771191992e-04,
  -5.776315367919824e-06,   1.130598043966610e-07,  -1.848338501810835e-09,   1.537846234220083e-11,   6.285025814009957e-13,  -4.649087083797902e-14,   1.902014203446589e-15,
  -5.733146028365899e-17,  -6.486643976521036e-03,   1.963983885796024e-04,  -4.438444162352549e-06,   8.686949451056289e-08,  -1.419404292087610e-09,   1.175223768373967e-11,
   4.862542520669915e-13,  -3.584863314869013e-14,   1.464813865697003e-15,  -4.409346434614242e-17,  -4.369038360176442e-03,   1.322884239356753e-04,  -2.989725210652730e-06,
   5.851286249655534e-08,  -9.556638399296164e-10,   7.882100222828288e-12,   3.293021835745935e-13,  -2.421419155274257e-14,   9.884591805141873e-16,  -2.972268113887945e-17,
  -2.412420612033078e-03,   7.304651069470483e-05,  -1.650891280705775e-06,   3.230940843999228e-08,  -5.275648422176286e-10,   4.341499377859181e-12,   1.823988931006799e-13,
  -1.339203453047932e-14,   5.463773537733014e-16,  -1.641931043810451e-17,  -9.148129633727165e-04,   2.770018583743249e-05,  -6.260445978792602e-07,   1.225214749382484e-08,
  -2.000409232044381e-10,   1.644812964344277e-12,   6.924867105755485e-14,  -5.081500552560035e-15,   2.072750676305212e-16,  -6.227432161969586e-18,  -1.043010877050733e-04,
   3.158201686521073e-06,  -7.137778158723339e-08,   1.396913114605156e-09,  -2.280706298677928e-11,   1.875021610643524e-13,   7.896823988346587e-15,  -5.794188329703395e-16,
   2.363374839439419e-17,  -7.100320016974652e-19,  -9.515883509007671e-05,   2.717906662226571e-06,  -5.816987483744808e-08,   1.100741294316662e-09,  -1.907380200274695e-11,
   2.903525143449533e-13,  -2.996309091115245e-15,  -2.596733197702787e-17,   2.853391279884857e-18,  -1.057846905743945e-19,  -8.798812515459601e-05,   2.513170350148758e-06,
  -5.378993433488975e-08,   1.017892423158446e-09,  -1.763793709518400e-11,   2.684404225747461e-13,  -2.766906867191224e-15,  -2.417758668898684e-17,   2.643452011844722e-18,
  -9.790130211011831e-20,  -7.473683552397651e-05,   2.134779357379124e-06,  -4.569382526757174e-08,   8.647307791720914e-10,  -1.498361946614609e-11,   2.279669045211652e-13,
  -2.345154140890804e-15,  -2.076942419694029e-17,   2.252419079361615e-18,  -8.327943942916904e-20,  -5.742061141945697e-05,   1.640241424612771e-06,  -3.511068334311891e-08,
   6.644871190351426e-10,  -1.151361174681196e-11,   1.751105718138561e-13,  -1.797668739303407e-15,  -1.614738643550573e-17,   1.736311468914317e-18,  -6.408330618578194e-20,
  -3.867510921516829e-05,   1.104812475616963e-06,  -2.365055350544227e-08,   4.476178240248876e-10,  -7.755750200777440e-12,   1.179241932695251e-13,  -1.208613787132004e-15,
  -1.097679306451254e-17,   1.172532896644262e-18,  -4.321519057618471e-20,  -2.135489954635347e-05,   6.100485484306024e-07,  -1.305958542353448e-08,   2.471759901418511e-10,
  -4.282700931993090e-12,   6.510682490596927e-14,  -6.666514364247075e-16,  -6.093122324825242e-18,   6.484011222883382e-19,  -2.387843980767135e-20,  -8.097973778850675e-06,
   2.313379741504756e-07,  -4.952409195643034e-09,   9.373407080988105e-11,  -1.624078698873852e-12,   2.468819892509403e-14,  -2.527008380654598e-16,  -2.315148813726771e-18,
   2.460183002223697e-19,  -9.057295933125660e-21,  -9.232787064381632e-07,   2.637569998678272e-08,  -5.646435221712804e-10,   1.068700422592268e-11,  -1.851677126995813e-13,
   2.814771968866319e-15,  -2.880943778000211e-17,  -2.640449101411353e-19,   2.805203903769452e-20,  -1.032699248224826e-21,  -8.696452233119292e-04,   2.483852380514365e-05,
  -5.315875727330953e-07,   1.005707774224851e-08,  -1.740895916861425e-10,   2.637613010817557e-12,  -2.646698756206414e-14,  -2.810951991564469e-16,   2.782933971064739e-17,
  -1.025378946129100e-18,  -8.041129610786446e-04,   2.296747034462901e-05,  -4.915612643145214e-07,   9.300110562866480e-09,  -1.609836386889462e-10,   2.438517611403011e-12,
  -2.443738135110498e-14,  -2.615316833769699e-16,   2.578180716112348e-17,  -9.489960611182955e-19,  -6.830110073444399e-04,   1.950941384102755e-05,  -4.175745962551410e-07,
   7.900719158439360e-09,  -1.367565309321093e-10,   2.070796590131307e-12,  -2.070790595143052e-14,  -2.244025334115359e-16,   2.196806343452327e-17,  -8.073044418312156e-19,
  -5.247601037769330e-04,   1.498990883037571e-05,  -3.208601222249509e-07,   6.071160543077158e-09,  -1.050848590175147e-10,   1.590614257135572e-12,  -1.586984322105828e-14,
  -1.742520366516497e-16,   1.693444627736487e-17,  -6.212544877589919e-19,  -3.534471993587368e-04,   1.009670753589445e-05,  -2.161313171913033e-07,   4.089705951870494e-09,
  -7.078645924599005e-11,   1.071137083044958e-12,  -1.066767794288648e-14,  -1.183433461466628e-16,   1.143586699823278e-17,  -4.189679705931351e-19,  -1.951598737062097e-04,
   5.575137718690525e-06,  -1.193454153245253e-07,   2.258347352046716e-09,  -3.908794687835563e-11,   5.913745978929578e-13,  -5.883482267906416e-15,  -6.565629487567660e-17,
   6.323947351645243e-18,  -2.315057336716577e-19,  -7.400641412320552e-05,   2.114161345285513e-06,  -4.525773919984099e-08,   8.564102201984974e-10,  -1.482284974360246e-11,
   2.242452773038236e-13,  -2.230102015148848e-15,  -2.494186316442489e-17,   2.399452005452410e-18,  -8.781296680583074e-20,  -8.437733704963031e-06,   2.410433718521191e-07,
  -5.160011644056428e-09,   9.764282325737617e-11,  -1.690012119742499e-12,   2.556682161846069e-14,  -2.542435327916359e-16,  -2.844549356177852e-18,   2.735956047830200e-19,
  -1.001231867748572e-20,  -2.497453439221020e-03,   7.133078711224398e-05,  -1.526484352814379e-06,   2.886553428945198e-08,  -4.984522726039570e-10,   7.467612278909252e-12,
  -6.979200984318931e-14,  -1.106720098764966e-15,   9.202554244472145e-17,  -3.354922533370745e-18,  -2.309257408371335e-03,   6.595753013823301e-05,  -1.411546107898231e-06,
   2.669286298295997e-08,  -4.609233876400643e-10,   6.903643419459214e-12,  -6.441695385071576e-14,  -1.028615248339087e-15,   8.525566721544099e-17,  -3.105245629497094e-18,
  -1.961475934153228e-03,   5.602674829901439e-05,  -1.199088635786154e-06,   2.267631285830170e-08,  -3.915514924576074e-10,   5.862190131145381e-12,  -5.455375583824074e-14,
  -8.810876089422371e-16,   7.264555779043712e-17,  -2.641945449335062e-18,  -1.507009841252177e-03,   4.304772077510847e-05,  -9.213672047521320e-07,   1.742513793929954e-08,
  -3.008668657249176e-10,   4.502517475144025e-12,  -4.178172148521441e-14,  -6.829693778542908e-16,   5.600106787568145e-17,  -2.033360645024894e-18,  -1.015032205985755e-03,
   2.899552168287967e-05,  -6.206325346425227e-07,   1.173803929048946e-08,  -2.026652111775787e-10,   3.031868769434111e-12,  -2.807151496304454e-14,  -4.632047097710291e-16,
   3.781819919232647e-17,  -1.371423791280817e-18,  -5.604615259284848e-04,   1.601056796786347e-05,  -3.427066104472670e-07,   6.481770046005091e-09,  -1.119099933989316e-10,
   1.673838081038675e-12,  -1.547761868548181e-14,  -2.567831525037173e-16,   2.091335762864879e-17,  -7.578428578935315e-19,  -2.125321510290728e-04,   6.071405816165581e-06,
  -1.299599574741745e-07,   2.458014814073453e-09,  -4.243816407155800e-11,   6.347001615533318e-13,  -5.866065362071391e-15,  -9.751973356426474e-17,   7.935038004676829e-18,
  -2.874657018254710e-19,  -2.423154418605490e-05,   6.922234817219063e-07,  -1.481724223045840e-08,   2.802482733740252e-10,  -4.838541976354277e-12,   7.236376206569355e-14,
  -6.687506204544679e-16,  -1.112131521756960e-17,   9.047868848631012e-19,  -3.277658504612694e-20,  -5.191441407925693e-03,   1.482721393242185e-04,  -3.172543755676693e-06,
   5.993381023473087e-08,  -1.029797490275884e-09,   1.506536364678814e-11,  -1.181612630643193e-13,  -3.618577961295228e-15,   2.456736610849649e-16,  -8.867342440468269e-18,
  -4.800239426510012e-03,   1.371029793798800e-04,  -2.933662073212595e-06,   5.542247341722099e-08,  -9.522457911171177e-10,   1.392630508771272e-11,  -1.089496496294188e-13,
  -3.359878488748636e-15,   2.276111522135571e-16,  -8.208714056527530e-18,  -4.077308139450876e-03,   1.164602926005211e-04,  -2.492102490802245e-06,   4.708262316643470e-08,
  -8.089024529256980e-10,   1.182363779664779e-11,  -9.211199287133968e-14,  -2.873379815983097e-15,   1.939601237924179e-16,  -6.985781602670530e-18,  -3.132612195343615e-03,
   8.948135870249072e-05,  -1.914903667550279e-06,   3.617943148249784e-08,  -6.215380915141598e-10,   9.079794172894770e-12,  -7.041921069880159e-14,  -2.223551747451621e-15,
   1.495323141370121e-16,  -5.378045536920658e-18,  -2.109941259627659e-03,   6.027167957809773e-05,  -1.289877238597289e-06,   2.437131394539164e-08,  -4.186601683105044e-10,
   6.113293526794053e-12,  -4.724391346753766e-14,  -1.506100997107589e-15,   1.009874897398559e-16,  -3.628067618980478e-18,  -1.165027952577007e-03,   3.328044173994372e-05,
  -7.122560153492345e-07,   1.345785282499645e-08,  -2.311771888862476e-10,   3.374784553426773e-12,  -2.602682959062880e-14,  -8.343049301698382e-16,   5.584788255723566e-17,
  -2.005104051075563e-18,  -4.417892841916124e-04,   1.262035574445926e-05,  -2.700990960965048e-07,   5.103477315184873e-09,  -8.766582352990053e-11,   1.279643802886553e-12,
  -9.861144381389292e-15,  -3.167598644562567e-16,   2.119034657860638e-17,  -7.606136091809483e-19,  -5.036996287863836e-05,   1.438893532895984e-06,  -3.079505178292469e-08,
   5.818681177682053e-10,  -9.995116213766225e-12,   1.458947339100121e-13,  -1.124143965895710e-15,  -3.612216946468229e-17,   2.416219347051337e-18,  -8.672516305940914e-20,
  -9.555525733865516e-03,   2.729028024297995e-04,  -5.837149510084463e-06,   1.100189613835819e-07,  -1.867545265960797e-09,   2.566040561659104e-11,  -9.207603107751101e-14,
  -1.302807559003174e-14,   7.270742531330466e-16,  -2.647565781455990e-17,  -8.835467296222971e-03,   2.523453259285746e-04,  -5.397624779323207e-06,   1.017367224011258e-07,
  -1.726822930466964e-09,   2.371386979345449e-11,  -8.423360199820428e-14,  -1.208809423402640e-14,   6.737456542855239e-16,  -2.451867481079643e-17,  -7.504817731104637e-03,
   2.143513066528454e-04,  -4.585192038433275e-06,   8.642635839116662e-08,  -1.466766773241311e-09,   2.012446439030088e-11,  -7.028508303150177e-14,  -1.032587689051972e-14,
   5.743148712321244e-16,  -2.087918980073834e-17,  -5.765981430732742e-03,   1.646951108268738e-04,  -3.523201842658741e-06,   6.641109232555101e-08,  -1.126929259482069e-09,
   1.544696782619373e-11,  -5.296877021321722e-14,  -7.981002431278421e-15,   4.429107641123776e-16,  -1.608484221683116e-17,  -3.883622085421738e-03,   1.109331474315245e-04,
  -2.373220845411536e-06,   4.473552726546089e-08,  -7.590355831704221e-10,   1.039632293174490e-11,  -3.512875362021775e-14,  -5.400789905473177e-15,   2.992001828667867e-16,
  -1.085672538689308e-17,  -2.144385877873948e-03,   6.125436863230938e-05,  -1.310465004415747e-06,   2.470280921764237e-08,  -4.191109834225906e-10,   5.737945282326745e-12,
  -1.922192153984541e-14,  -2.990164878095643e-15,   1.654879217758186e-16,  -6.001969743019120e-18,  -8.131707881025826e-04,   2.322841421390142e-05,  -4.969494964908466e-07,
   9.367756930692974e-09,  -1.589308499798440e-10,   2.175524813778758e-12,  -7.264218651069642e-15,  -1.135045874228367e-15,   6.279458343458902e-17,  -2.277042182079992e-18,
  -9.271248500162884e-05,   2.648357574279478e-06,  -5.665914717919222e-08,   1.068055440123118e-09,  -1.812027203462132e-11,   2.480325555777411e-13,  -8.277484372845698e-16,
  -1.294323034845952e-16,   7.160190030530068e-18,  -2.596333121527996e-19,  -8.514104530970960e-05,   2.300610512480098e-06,  -4.661340195772552e-08,   8.380094557021199e-10,
  -1.400400797824600e-11,   2.171539927008735e-13,  -2.892887812191781e-15,   2.130864561593278e-17,   5.285980414981973e-19,  -3.344016721030013e-20,  -7.872498813119476e-05,
   2.127296210269499e-06,  -4.310327784094611e-08,   7.749338835179908e-10,  -1.295025770753056e-11,   2.008038489071828e-13,  -2.674154064111270e-15,   1.964907244045825e-17,
   4.909344930803605e-19,  -3.098230339016883e-20,  -6.686842226597700e-05,   1.806986435504264e-06,  -3.661518585594252e-08,   6.583278651438945e-10,  -1.100203248088116e-11,
   1.705809626152661e-13,  -2.270383411690768e-15,   1.661464810091742e-17,   4.200253219922432e-19,  -2.640276236674142e-20,  -5.137500560514349e-05,   1.388370188106448e-06,
  -2.813436483783506e-08,   5.058786709141028e-10,  -8.454637008669318e-12,   1.310733086691661e-13,  -1.743497986932741e-15,   1.270366787985473e-17,   3.251775965422868e-19,
  -2.035586091357715e-20,  -3.460300432983594e-05,   9.351528795689751e-07,  -1.895110363512458e-08,   3.407736395850054e-10,  -5.695458011337659e-12,   8.829124868168204e-14,
  -1.173866129924986e-15,   8.523813206967045e-18,   2.203311220978024e-19,  -1.374787527001101e-20,  -1.910639472517494e-05,   5.163645848626823e-07,  -1.046453448788095e-08,
   1.881759976936365e-10,  -3.145103866860852e-12,   4.875357517094333e-14,  -6.480195862179730e-16,   4.696111815872578e-18,   1.220763234548210e-19,  -7.602956090936602e-21,
  -7.245313577674695e-06,   1.958115156210039e-07,  -3.968314103101884e-09,   7.136005406869349e-11,  -1.192693839747160e-12,   1.848816725182228e-14,  -2.457144557222006e-16,
   1.779325669501464e-18,   4.635200377718535e-20,  -2.884806790730240e-21,  -8.260637695381534e-07,   2.232519037028140e-08,  -4.524428222962998e-10,   8.136050416715963e-12,
  -1.359840403265710e-13,   2.107908391953599e-15,  -2.801438853932952e-17,   2.028391958209214e-19,   5.285881751582919e-21,  -3.289391072899051e-22,  -7.780940474287066e-04,
   2.102498827237846e-05,  -4.259899925340394e-07,   7.657909535460330e-09,  -1.279286301538105e-10,   1.980696269517306e-12,  -2.620659511309637e-14,   1.831204761658338e-16,
   5.326330168528138e-18,  -3.236588600760018e-19,  -7.194584516507466e-04,   1.944109072577402e-05,  -3.939116990129639e-07,   7.081509816043226e-09,  -1.183023222649902e-10,
   1.831553500613630e-12,  -2.422442382602402e-14,   1.688007463303813e-16,   4.945890174016553e-18,  -2.998714810804156e-19,  -6.111026837367166e-04,   1.651382014271586e-05,
  -3.346183854362682e-07,   6.015937027074237e-09,  -1.005048203981341e-10,   1.555872639878419e-12,  -2.056584335815807e-14,   1.426517088990459e-16,   4.230229169395238e-18,
  -2.555493724013774e-19,  -4.695101622250202e-04,   1.268813919698619e-05,  -2.571139525649537e-07,   4.622822671419547e-09,  -7.723390412195207e-11,   1.195510488938898e-12,
  -1.579238700593572e-14,   1.090059723725699e-16,   3.273937805558638e-18,  -1.970240405370874e-19,  -3.162328057833384e-04,   8.546243605547353e-06,  -1.731900809951230e-07,
   3.114058148789822e-09,  -5.202845504797135e-11,   8.052919398274302e-13,  -1.063232704275983e-14,   7.310456224821788e-17,   2.217777486405914e-18,  -1.330665061314175e-19,
  -1.746111046690200e-04,   4.718990460405094e-06,  -9.563313882147209e-08,   1.719589843221109e-09,  -2.873074161429683e-11,   4.446724018321292e-13,  -5.869326932390592e-15,
   4.026488875434742e-17,   1.228604139136761e-18,  -7.358980410186452e-20,  -6.621407259478613e-05,   1.789496608122227e-06,  -3.626557205696824e-08,   6.521023779318301e-10,
  -1.089533674688211e-11,   1.686268869861954e-13,  -2.225498327937538e-15,   1.525447784265174e-17,   4.664724742565737e-19,  -2.792239382497998e-20,  -7.549300084380905e-06,
   2.040270834368892e-07,  -4.134777973389019e-09,   7.434884728073497e-11,  -1.242223083923165e-12,   1.922580665096057e-14,  -2.537330938936759e-16,   1.738946092977334e-18,
   5.319504014101572e-20,  -3.183842317536892e-21,  -2.234537485118517e-03,   6.037960609065044e-05,  -1.223332612341426e-06,   2.198833538459568e-08,  -3.670380469288553e-10,
   5.662445103995457e-12,  -7.370640498995201e-14,   4.473207590161116e-16,   1.867215108485735e-17,  -1.053592936125323e-18,  -2.066147252255835e-03,   5.583096523904358e-05,
  -1.131211993361669e-06,   2.033329424730192e-08,  -3.394183646510865e-10,   5.236002296692898e-12,  -6.812693477384665e-14,   4.119218211648215e-16,   1.733288832466952e-17,
  -9.761768940982663e-19,  -1.754970181419190e-03,   4.742442271596360e-05,  -9.609368828369320e-07,   1.727367625147252e-08,  -2.883545915318381e-10,   4.447792868956483e-12,
  -5.783140985070834e-14,   3.475235063264868e-16,   1.481710218011249e-17,  -8.319197016916715e-19,  -1.348343503492852e-03,   3.643782371548892e-05,  -7.383642252920026e-07,
   1.327358739935790e-08,  -2.215877498115827e-10,   3.417539731246883e-12,  -4.440314871396275e-14,   2.650747029096457e-16,   1.146125222950199e-17,  -6.414162589519814e-19,
  -9.081602128529471e-04,   2.454311930236398e-05,  -4.973566947120425e-07,   8.941440065762738e-09,  -1.492715136616057e-10,   2.302000348162191e-12,  -2.989192137438186e-14,
   1.775141917836398e-16,   7.760591296419737e-18,  -4.332122375365920e-19,  -5.014497389114603e-04,   1.355200604674590e-05,  -2.746333881550651e-07,   4.937480960969968e-09,
  -8.242934149560702e-11,   1.271122769361471e-12,  -1.650024472116391e-14,   9.768963722914681e-17,   4.298164863351382e-18,  -2.395830647937528e-19,  -1.901541684360619e-04,
   5.139079850128424e-06,  -1.041452451197225e-07,   1.872389838207532e-09,  -3.125901372130562e-11,   4.820281198131408e-13,  -6.256343012840343e-15,   3.699823716923745e-17,
   1.631764867728134e-18,  -9.090621320510535e-20,  -2.168014779207908e-05,   5.859253759630529e-07,  -1.187400168771203e-08,   2.134787834880602e-10,  -3.563970869817545e-12,
   5.495786190097122e-14,  -7.132945966002606e-16,   4.217419911629204e-18,   1.860784810654149e-19,  -1.036556253614326e-20,  -4.644925238036625e-03,   1.255102880315031e-04,
  -2.542817325778848e-06,   4.569174122236703e-08,  -7.615112961927836e-10,   1.166247079262710e-11,  -1.466192806826979e-13,   5.922033290633229e-16,   5.354410068765231e-17,
  -2.741884526145681e-18,  -4.294893045372773e-03,   1.160550864134134e-04,  -2.351335163054661e-06,   4.225252058855816e-08,  -7.042032092143396e-10,   1.078385423509649e-11,
  -1.355000248969937e-13,   5.431913470994325e-16,   4.968522216244814e-17,  -2.540555683596526e-18,  -3.648050351649636e-03,   9.858051513622222e-05,  -1.997401097182310e-06,
   3.589457896896205e-08,  -5.982535090712720e-10,   9.160060875504570e-12,  -1.149944039075514e-13,   4.552588554109285e-16,   4.244806849930389e-17,  -2.165314144394409e-18,
  -2.802796897875194e-03,   7.574281590865614e-05,  -1.534761667977114e-06,   2.758236888674950e-08,  -4.597265411449715e-10,   7.037942234007341e-12,  -8.826978016459619e-14,
   3.447728898675637e-16,   3.281350602286780e-17,  -1.669634124494323e-18,  -1.887789436428756e-03,   5.101745196168991e-05,  -1.033803903816108e-06,   1.858018595733016e-08,
  -3.096899944505166e-10,   4.740459104502294e-12,  -5.941027067368587e-14,   2.295609032398357e-16,   2.220762838015842e-17,  -1.127755861825839e-18,  -1.042361805317981e-03,
   2.817037227542884e-05,  -5.708519355585538e-07,   1.026000653800960e-08,  -1.710133407719801e-10,   2.617535783280106e-12,  -3.279032123874717e-14,   1.259066795525901e-16,
   1.229612853228573e-17,  -6.237198898483701e-19,  -3.952727997206182e-04,   1.068253594711954e-05,  -2.164759071962047e-07,   3.890794874482232e-09,  -6.485189206687795e-11,
   9.925988923816114e-13,  -1.243243304474988e-14,   4.762414095640085e-17,   4.667639010845061e-18,  -2.366651027739470e-19,  -4.506644679962557e-05,   1.217955172519233e-06,
  -2.468125418101978e-08,   4.436053294131153e-10,  -7.394033201427652e-12,   1.131698197455715e-13,  -1.417428769164410e-15,   5.427513167978069e-18,   5.322654527429611e-19,
  -2.698576435279414e-20,  -8.549614733454003e-03,   2.310163105764531e-04,  -4.679905418704084e-06,   8.403759797404541e-08,  -1.395484583755801e-09,   2.099633172080868e-11,
  -2.405062635769203e-13,  -4.555930856513830e-16,   1.682555407195748e-16,  -7.766631546691384e-18,  -7.905332995757439e-03,   2.136129014572379e-04,  -4.327492147941697e-06,
   7.771187849258567e-08,  -1.290447498601423e-09,   1.941310594715736e-11,  -2.221667891228289e-13,  -4.336396856493443e-16,   1.560831137430025e-16,  -7.197695460331172e-18,
  -6.714731278586109e-03,   1.814489058339478e-04,  -3.676095319073666e-06,   6.601791094193679e-08,  -1.096269020822384e-09,   1.648796183825284e-11,  -1.884057242561462e-13,
  -3.856221555095759e-16,   1.332837062172569e-16,  -6.136475643819596e-18,  -5.158927668944837e-03,   1.394134537258173e-04,  -2.824633697633475e-06,   5.072972228800688e-08,
  -8.424038445100221e-10,   1.266655551875390e-11,  -1.445058759952068e-13,  -3.104016690138004e-16,   1.029799127037358e-16,  -4.733266567801418e-18,  -3.474732372833359e-03,
   9.390354306222311e-05,  -1.902650996396359e-06,   3.417270889185167e-08,  -5.674651023774097e-10,   8.530789164957691e-12,  -9.719926192541580e-14,  -2.165716193283648e-16,
   6.966774324175279e-17,  -3.197909598067118e-18,  -1.918608204064349e-03,   5.185083883361800e-05,  -1.050616728749574e-06,   1.887018158698709e-08,  -3.133551955427840e-10,
   4.710163363484352e-12,  -5.362774924309191e-14,  -1.219769486644244e-16,   3.856563981601272e-17,  -1.768907043606028e-18,  -7.275531699459028e-04,   1.966244668299268e-05,
  -3.984101120732561e-07,   7.155935795528528e-09,  -1.188304255103197e-10,   1.786107351282878e-12,  -2.033015862433991e-14,  -4.659598612977657e-17,   1.463837919113330e-17,
  -6.712337744835066e-19,  -8.295090440181536e-05,   2.241787784433062e-06,  -4.542427462904669e-08,   8.158772035548361e-10,  -1.354833981829938e-11,   2.036398689229140e-13,
  -2.317800502726927e-15,  -5.319023696533453e-18,   1.669236925250913e-18,  -7.653821069401745e-20,  -7.662570086227014e-05,   1.964425331338107e-06,  -3.776995996535145e-08,
   6.451432165175382e-10,  -1.030079265589639e-11,   1.559371588897869e-13,  -2.191298296751966e-15,   2.553578573903131e-17,  -1.100566882162990e-19,  -7.005006142922116e-21,
  -7.085115854538680e-05,   1.816427930219880e-06,  -3.492549702316180e-08,   5.965794611922597e-10,  -9.525739884453748e-12,   1.442057610904909e-13,  -2.026244949909748e-15,
   2.359959626814750e-17,  -1.010875766253169e-19,  -6.501532942902979e-21,  -6.018019269451765e-05,   1.542913045194651e-06,  -2.966797571534336e-08,   5.068039969695648e-10,
  -8.092758066226260e-12,   1.225147774050130e-13,  -1.721185872543461e-15,   2.002873323963163e-17,  -8.491964663791959e-20,  -5.556426732229241e-21,  -4.623622962272175e-05,
   1.185462905919030e-06,  -2.279595646434248e-08,   3.894376707390630e-10,  -6.219023032636658e-12,   9.415047736150035e-14,  -1.322474348916013e-15,   1.537450333898976e-17,
  -6.447309671403151e-20,  -4.296816118593162e-21,  -3.114173378033930e-05,   7.984767223209405e-07,  -1.535502452526175e-08,   2.623328675275474e-10,  -4.189466125049223e-12,
   6.342575367846072e-14,  -8.907821387334784e-16,   1.034809086401302e-17,  -4.301577766256547e-20,  -2.908829080494395e-21,  -1.719518419714143e-05,   4.408941487760723e-07,
  -8.478776971592361e-09,   1.448598826778979e-10,  -2.313484873720568e-12,   3.502494010209002e-14,  -4.918687353433045e-16,   5.711496846472814e-18,  -2.362099663113720e-20,
  -1.610846891049915e-21,  -6.520560630227286e-06,   1.671919857495517e-07,  -3.215276459785137e-09,   5.493359442187131e-11,  -8.773265385741107e-13,   1.328230413647261e-14,
  -1.865230201456412e-16,   2.165521445952023e-18,  -8.938681914976308e-21,  -6.115180279463847e-22,  -7.434320331021054e-07,   1.906216781075488e-08,  -3.665859488836635e-10,
   6.263200323853522e-12,  -1.000277117492049e-13,   1.514372527144676e-15,  -2.126618650987318e-17,   2.468925298186156e-19,  -1.018778905436246e-21,  -6.973400523530906e-23,
  -7.002733562936888e-04,   1.795264969879339e-05,  -3.451743166313173e-07,   5.895766216417304e-09,  -9.412603115985378e-11,   1.424206625300887e-12,  -1.997114646180050e-14,
   2.305050748624530e-16,  -8.779339897103716e-19,  -6.895012327410447e-20,  -6.475004865209282e-04,   1.660011901768335e-05,  -3.191791694183196e-07,   5.451956550521173e-09,
  -8.704376039622286e-11,   1.317058778065019e-12,  -1.846672066989311e-14,   2.130184433233985e-16,  -8.052748482326997e-19,  -6.398885802184946e-20,  -5.499797723007637e-04,
   1.410049896044681e-05,  -2.711314226754812e-07,   4.631525607325190e-09,  -7.394949216856177e-11,   1.118947325429850e-12,  -1.568626632031431e-14,   1.807737725175771e-16,
  -6.749163868115741e-19,  -5.467924480243268e-20,  -4.225475176831716e-04,   1.083380459785149e-05,  -2.083290097508037e-07,   3.558950468223637e-09,  -5.682775474315871e-11,
   8.598886697327449e-13,  -1.205237565214055e-14,   1.387555361461399e-16,  -5.111221932338709e-19,  -4.227747517547463e-20,  -2.846006781111707e-04,   7.297183851418612e-06,
  -1.403273872722747e-07,   2.397378736342290e-09,  -3.828218993212113e-11,   5.792741911034557e-13,  -8.118052313504893e-15,   9.338639404963701e-17,  -3.403215277501817e-19,
  -2.861740023738993e-20,  -1.571447857396561e-04,   4.029279213919091e-06,  -7.748633735323213e-08,   1.323829477540169e-09,  -2.113998208689880e-11,   3.198860307207502e-13,
  -4.482565455171763e-15,   5.154165407477231e-17,  -1.866552104620744e-19,  -1.584664885661595e-20,  -5.959064418093286e-05,   1.527947682183891e-06,  -2.938395437844041e-08,
   5.020210476642055e-10,  -8.016765217297829e-12,   1.213084469712372e-13,  -1.699842805688502e-15,   1.954183189410795e-17,  -7.060223204429565e-20,  -6.015637568639639e-21,
  -6.794138766499403e-06,   1.742068855262765e-07,  -3.350176859526199e-09,   5.723744113938423e-11,  -9.140253132393716e-13,   1.383089559464964e-14,  -1.938053487901882e-16,
   2.227972369641509e-18,  -8.046224570115975e-21,  -6.859859558195042e-22,  -2.011051620614202e-03,   5.155655818307761e-05,  -9.912686184900486e-07,   1.693070939074268e-08,
  -2.702345430541160e-10,   4.084174099683153e-12,  -5.698738116192499e-14,   6.427758050294601e-16,  -1.659423939377995e-18,  -2.314828191078882e-19,  -1.859497995818492e-03,
   4.767235000765835e-05,  -9.166159589037979e-07,   1.565623085455147e-08,  -2.499012068265767e-10,   3.776890907660226e-12,  -5.269347111164403e-14,   5.939507042665125e-16,
  -1.513469383996836e-18,  -2.147929433064173e-19,  -1.579437089774731e-03,   4.049392166736886e-05,  -7.786328295450967e-07,   1.330021874345880e-08,  -2.123074505219318e-10,
   3.208748651429321e-12,  -4.475817177052725e-14,   5.039565479866946e-16,  -1.256333462994200e-18,  -1.834963700542834e-19,  -1.213475940465185e-03,   3.111260347601190e-05,
  -5.982773902316451e-07,   1.022013268384869e-08,  -1.631510316996822e-10,   2.465839753681895e-12,  -3.438826181513389e-14,   3.867474629513685e-16,  -9.413895360700857e-19,
  -1.418397629468602e-19,  -8.173189073345051e-04,   2.095610871371000e-05,  -4.029909254265173e-07,   6.884479985666280e-09,  -1.099070468068251e-10,   1.661131807235265e-12,
  -2.316207292825309e-14,   2.602538211011529e-16,  -6.213939312107280e-19,  -9.599062994176744e-20,  -4.512898753777537e-04,   1.157131501797011e-05,  -2.225245609218147e-07,
   3.801600564474582e-09,  -6.069222441181524e-11,   9.173047109148225e-13,  -1.278925623934599e-14,   1.436266456112442e-16,  -3.390668484277780e-19,  -5.314769004213367e-20,
  -1.711329730616797e-04,   4.387971895363666e-06,  -8.438457314528879e-08,   1.441638396234920e-09,  -2.301587460201804e-11,   3.478634526133950e-13,  -4.849810903254244e-15,
   5.445378633652152e-17,  -1.280011858913412e-19,  -2.017480201709138e-20,  -1.951147168278444e-05,   5.002886725071251e-07,  -9.621007448332191e-09,   1.643669972880395e-10,
  -2.624137097875669e-12,   3.966139319543169e-14,  -5.529442815335350e-16,   6.208265944754977e-18,  -1.458297937044718e-20,  -2.300592190048678e-21,  -4.180367157292003e-03,
   1.071703454526190e-04,  -2.060521941025771e-06,   3.519052511589776e-08,  -5.614177646372965e-10,   8.465454416463939e-12,  -1.169322012119500e-13,   1.255222169522814e-15,
   2.275959084181281e-19,  -6.260080556241952e-19,  -3.865333076787246e-03,   9.909626196488741e-05,  -1.905343492094523e-06,   3.254150749417650e-08,  -5.191738661843384e-10,
   7.828462367710833e-12,  -1.081170202180203e-13,   1.159597561564104e-15,   2.637553340678476e-19,  -5.807626464691355e-19,  -3.283171284039391e-03,   8.417450029150256e-05,
  -1.618521772326569e-06,   2.764451681019064e-08,  -4.410708515278723e-10,   6.650757970826089e-12,  -9.182896800312982e-14,   9.835087278157441e-16,   2.984943706739164e-19,
  -4.959889814637091e-19,  -2.522448906113057e-03,   6.467360338873802e-05,  -1.243621987262301e-06,   2.124254306032910e-08,  -3.389467813212481e-10,   5.110851823322489e-12,
  -7.054817289670535e-14,   7.544480708414212e-16,   2.901680139490461e-19,  -3.832675048903368e-19,  -1.698958433448106e-03,   4.356135146554909e-05,  -8.376855836526978e-07,
   1.430938340370471e-08,  -2.283316407063129e-10,   3.442920601241452e-12,  -4.751468534519536e-14,   5.075210453563060e-16,   2.277502079679293e-19,  -2.593125212267382e-19,
  -9.380949499958689e-04,   2.405323075362770e-05,  -4.625553537976903e-07,   7.901620172033468e-09,  -1.260877688510141e-10,   1.901224235870166e-12,  -2.623500792374894e-14,
   2.800322318364233e-16,   1.360650412564571e-19,  -1.435543726063180e-19,  -3.557336128073373e-04,   9.121253740984532e-06,  -1.754077635506618e-07,   2.996442611406840e-09,
  -4.781532828232169e-11,   7.209868108026854e-13,  -9.948446251494462e-15,   1.061621028945948e-16,   5.306625910286278e-20,  -5.449013635897077e-20,  -4.055843937388174e-05,
   1.039947391064209e-06,  -1.999890895914424e-08,   3.416364796571904e-10,  -5.451627069943799e-12,   8.220273807437642e-14,  -1.134255563779823e-15,   1.210337545002172e-17,
   6.078044423795871e-21,  -6.213615524848454e-21,  -7.694537461176241e-03,   1.972611902465035e-04,  -3.792570597586389e-06,   6.475953005069523e-08,  -1.032048070311856e-09,
   1.547939297440425e-11,  -2.086707658182816e-13,   1.955298467880996e-15,   1.697146469962211e-17,  -1.824190296580265e-18,  -7.114674146864459e-03,   1.823997702421567e-04,
  -3.506950758689722e-06,   5.988461831719113e-08,  -9.543873640267676e-10,   1.431431141020587e-11,  -1.929190379370176e-13,   1.804982049142014e-15,   1.583820815239762e-17,
  -1.692102718666544e-18,  -6.043125744470894e-03,   1.549342927216975e-04,  -2.979029895334696e-06,   5.087285250604121e-08,  -8.108061972580272e-10,   1.216043876034265e-11,
  -1.638265297821074e-13,   1.528988258097442e-15,   1.365636583995847e-17,  -1.444772030169337e-18,  -4.642912168178931e-03,   1.190403125317665e-04,  -2.288993878919996e-06,
   3.909156231725745e-08,  -6.230700219337943e-10,   9.344465781799457e-12,  -1.258371423162608e-13,   1.171327844230808e-15,   1.065848013573409e-17,  -1.116154097029044e-18,
  -3.127165334093675e-03,   8.018042213160788e-05,  -1.541832588981573e-06,   2.633279716204781e-08,  -4.197288180386282e-10,   6.294697260527638e-12,  -8.473964135887511e-14,
   7.871294239044947e-16,   7.267227600616886e-18,  -7.550299246338291e-19,  -1.726692041612866e-03,   4.427314844511683e-05,  -8.513729680680129e-07,   1.454092266492303e-08,
  -2.317790176092554e-10,   3.475949547958961e-12,  -4.678458306304851e-14,   4.340453596137492e-16,   4.040864786015390e-18,  -4.179367673280420e-19,  -6.547763614349252e-04,
   1.678887230544520e-05,  -3.228530867947005e-07,   5.514189443417254e-09,  -8.789571908448713e-11,   1.318149112216476e-12,  -1.774037666925963e-14,   1.645117282365396e-16,
   1.536349129359012e-18,  -1.586334146375031e-19,  -7.465335408763090e-05,   1.914160535380195e-06,  -3.680971313413529e-08,   6.286949039447791e-10,  -1.002135911811379e-11,
   1.502875566845098e-13,  -2.022628758662503e-15,   1.875501048257015e-17,   1.752405328175388e-19,  -1.808915499033532e-20,  -6.932695297614771e-05,   1.690650340057379e-06,
  -3.092281293849260e-08,   5.026567453355826e-10,  -7.652813241532584e-12,   1.113696137934549e-13,  -1.549172556981934e-15,   1.987872825088042e-17,  -2.017960762894832e-19,
   2.124711165905683e-22,  -6.410230393816423e-05,   1.563271874611208e-06,  -2.859380413670461e-08,   4.648143498697790e-10,  -7.076948600964204e-12,   1.029926540653615e-13,
  -1.432639693138478e-15,   1.838050806562204e-17,  -1.864352099428419e-19,   1.891360361981213e-22,  -5.444759036931430e-05,   1.327867159558790e-06,  -2.428913931172038e-08,
   3.948611900406222e-10,  -6.012273460017370e-12,   8.750299047085704e-14,  -1.217165647623802e-15,   1.561197556845106e-17,  -1.581414940610779e-19,   1.504209628753253e-22,
  -4.183172872025737e-05,   1.020229297569597e-06,  -1.866279066632187e-08,   3.034136769485768e-10,  -4.620179814718584e-12,   6.724630749602238e-14,  -9.353861762884521e-16,
   1.199442751587610e-17,  -1.213240830133183e-19,   1.072105266395029e-22,  -2.817506056281951e-05,   6.871783038115983e-07,  -1.257086015585844e-08,   2.043827402094418e-10,
  -3.112369232741408e-12,   4.530234048139211e-14,  -6.301438394118254e-16,   8.078558419139148e-18,  -8.162275576508018e-20,   6.777106953737178e-23,  -1.555708180037794e-05,
   3.794372721464606e-07,  -6.941370395889312e-09,   1.128590423837156e-10,  -1.718686347199284e-12,   2.501714035717826e-14,  -3.479803318183188e-16,   4.460610280076032e-18,
  -4.503893298907287e-20,   3.600386933726013e-23,  -5.899374302472261e-06,   1.438866619536589e-07,  -2.632263731495468e-09,   4.279815204910899e-11,  -6.517639024762405e-13,
   9.487147719820690e-15,  -1.319629241228519e-16,   1.691496067867540e-18,  -1.707490061658678e-20,   1.345112362218110e-23,  -6.726083227940170e-07,   1.640503929685847e-08,
  -3.001143347287438e-10,   4.879587375071695e-12,  -7.431033471375690e-14,   1.081671265397446e-15,  -1.504566657389039e-17,   1.928533079850383e-19,  -1.946689129164144e-21,
   1.529794163465269e-24,  -6.335709588353735e-04,   1.545065584560382e-05,  -2.825997935010423e-07,   4.593695665461199e-09,  -6.993564783189728e-11,   1.017599051126190e-12,
  -1.414530724580510e-14,   1.810027712143539e-16,  -1.813369318360236e-18,   7.021869559413040e-22,  -5.858234990215698e-04,   1.428655893502770e-05,  -2.613152671379768e-07,
   4.247860277166223e-09,  -6.467306968778944e-11,   9.410570586392665e-13,  -1.308122337464736e-14,   1.673589792005924e-16,  -1.675224073938577e-18,   5.790500054143190e-22,
  -4.975901947822219e-04,   1.213522275510555e-05,  -2.219754626073826e-07,   3.608569979516706e-09,  -5.494346836768580e-11,   7.995251936206114e-13,  -1.111371054176073e-14,
   1.421480617154658e-16,  -1.420835123320483e-18,   3.937540098698205e-22,  -3.822953026975482e-04,   9.323756290528627e-06,  -1.705569522197254e-07,   2.772846446510383e-09,
  -4.222174031082948e-11,   6.144368046448668e-13,  -8.540793616701226e-15,   1.092077937829754e-16,  -1.089919887528842e-18,   2.223820391537633e-22,  -2.574886010131176e-04,
   6.280042188503350e-06,  -1.148835469290612e-07,   1.867819357887476e-09,  -2.844253435572902e-11,   4.139320387684391e-13,  -5.753674731954988e-15,   7.355308613045256e-17,
  -7.331942114870473e-19,   1.072167018179556e-22,  -1.421743608906112e-04,   3.467632873857037e-06,  -6.343633133305368e-08,   1.031399718445639e-09,  -1.570629543159421e-11,
   2.285840114263051e-13,  -3.177308212442468e-15,   4.061226549376930e-17,  -4.045505743116623e-19,   4.561755045370045e-23,  -5.391369550322448e-05,   1.314963383118353e-06,
  -2.405593486222101e-08,   3.911250775823132e-10,  -5.956174633958621e-12,   8.668496249764525e-14,  -1.204914457086741e-15,   1.540041376941379e-17,  -1.533678197436298e-19,
   1.536300652050760e-23,  -6.146889220577957e-06,   1.499237363687525e-07,  -2.742708034968256e-09,   4.459372419989019e-11,  -6.790884341157095e-13,   9.883331946725127e-15,
  -1.373775155631092e-16,   1.755853324848049e-18,  -1.748522498700474e-20,   1.715001287210366e-24,  -1.819495109207892e-03,   4.437133431047648e-05,  -8.115714886950616e-07,
   1.319204932762279e-08,  -2.008252674932312e-10,   2.921064351874995e-12,  -4.054048556122591e-14,   5.153716145711873e-16,  -5.001689781705085e-18,  -6.311195775530301e-21,
  -1.682373499644218e-03,   4.102827016721872e-05,  -7.504464758943716e-07,   1.219888817609649e-08,  -1.857133411586941e-10,   2.701343144576109e-12,  -3.749057504106045e-14,
   4.765101536501006e-16,  -4.619897283749294e-18,  -6.059690710334741e-21,  -1.428984256744335e-03,   3.485004328452126e-05,  -6.374702246020006e-07,   1.036299111881675e-08,
  -1.577740218320612e-10,   2.295064578422482e-12,  -3.185137464742941e-14,   4.047101715746874e-16,  -3.917291212793554e-18,  -5.460081007543142e-21,  -1.097879288367530e-03,
   2.677604824687552e-05,  -4.898062886769568e-07,   7.962982829352545e-09,  -1.212426273146795e-10,   1.763757488727924e-12,  -2.447723675110194e-14,   3.109106221433954e-16,
  -3.004080616492752e-18,  -4.450734564748423e-21,  -7.394582147194109e-04,   1.803508234884203e-05,  -3.299231286712848e-07,   5.363951021743601e-09,  -8.167465887126171e-11,
   1.188200735530019e-12,  -1.648942726376401e-14,   2.093948765442832e-16,  -2.020398168279671e-18,  -3.133585046188894e-21,  -4.082976825623791e-04,   9.958379662122093e-06,
  -1.821767639115565e-07,   2.961944551476813e-09,  -4.510167813445649e-11,   6.561545106147813e-13,  -9.105784278417995e-15,   1.156145963916617e-16,  -1.114636758440212e-18,
  -1.773591233104826e-21,  -1.548298637968082e-04,   3.776323816565883e-06,  -6.908395025707950e-08,   1.123221924309403e-09,  -1.710355248731682e-11,   2.488306330071173e-13,
  -3.453133595492668e-15,   4.384137773439638e-17,  -4.225452129332911e-19,  -6.787388909715159e-22,  -1.765269495832371e-05,   4.305523511683474e-07,  -7.876522217365777e-09,
   1.280629943310849e-10,  -1.950047677516804e-12,   2.837026740560502e-14,  -3.937065889844407e-16,   4.998496977765892e-18,  -4.817332075166578e-20,  -7.750219239487101e-23,
  -3.782179442637856e-03,   9.223454498771283e-05,  -1.687006238993035e-06,   2.742159229665585e-08,  -4.173876002552704e-10,   6.066753690710346e-12,  -8.393331639260154e-14,
   1.052898875749739e-15,  -9.533944403707917e-18,  -4.840226251907947e-20,  -3.497145132476815e-03,   8.528532858340469e-05,  -1.559946215384791e-06,   2.535716017238595e-08,
  -3.859793294843120e-10,   5.610398713642533e-12,  -7.761788615355656e-14,   9.734484260586091e-16,  -8.802832262628781e-18,  -4.531847506002024e-20,  -2.970425614953959e-03,
   7.244266880329205e-05,  -1.325103491594111e-06,   2.154097838914668e-08,  -3.279110389375558e-10,   4.766579016775685e-12,  -6.594144573360331e-14,   8.266908514890816e-16,
  -7.459373087191874e-18,  -3.928062880373862e-20,  -2.282158634350295e-03,   5.565928212601075e-05,  -1.018155805868648e-06,   1.655221083445236e-08,  -2.519854419315877e-10,
   3.663098010174435e-12,  -5.067370316189791e-14,   6.350239287531440e-16,  -5.716571265748768e-18,  -3.082272556412987e-20,  -1.537109741639271e-03,   3.748946542968314e-05,
  -6.858081477640830e-07,   1.114974614667049e-08,  -1.697489523413850e-10,   2.467730531270203e-12,  -3.413641515160423e-14,   4.276470332745351e-16,  -3.842636795728137e-18,
  -2.110204842793843e-20,  -8.487272611570921e-04,   2.070045051802131e-05,  -3.786891460955422e-07,   6.156828674938780e-09,  -9.373726522533096e-11,   1.362740062890447e-12,
  -1.885059755618672e-14,   2.361085789985332e-16,  -2.119295017438186e-18,  -1.176077822189295e-20,  -3.218444087608670e-04,   7.849831692634862e-06,  -1.436041648754118e-07,
   2.334778603636826e-09,  -3.554723527910245e-11,   5.167855587770093e-13,  -7.148574130631192e-15,   8.953145814952641e-17,  -8.033054038435788e-19,  -4.475333715460619e-21,
  -3.669460808499515e-05,   8.949877329185309e-07,  -1.637285346725567e-08,   2.661973838501611e-10,  -4.052889111887631e-12,   5.892097040847096e-14,  -8.150390974232653e-16,
   1.020774075359160e-17,  -9.158106743745756e-20,  -5.105424074503639e-22,  -6.961619502701829e-03,   1.697702213654659e-04,  -3.105145717716791e-06,   5.047046373807122e-08,
  -7.679866099418633e-10,   1.114512974170713e-11,  -1.530817546974044e-13,   1.859943546132132e-15,  -1.381294081251037e-17,  -2.454209993663981e-19,  -6.436974798120406e-03,
   1.569792432997857e-04,  -2.871275799673794e-06,   4.667078996880830e-08,  -7.101949774104472e-10,   1.030669813979787e-11,  -1.415588990874076e-13,   1.719338094918621e-15,
  -1.273724381638357e-17,  -2.284259952307476e-19,  -5.467475353158506e-03,   1.333405812647462e-04,  -2.439018340088342e-06,   3.964695325885612e-08,  -6.033491031840033e-10,
   8.756444454183718e-12,  -1.202572622115299e-13,   1.459771301004834e-15,  -1.077030260239851e-17,  -1.961181956410611e-19,  -4.200625667606640e-03,   1.024484757808807e-04,
  -1.874042736358181e-06,   3.046493456803469e-08,  -4.636466339895796e-10,   6.729214903409192e-12,  -9.240841536750644e-14,   1.121032400652221e-15,  -8.235065036524998e-18,
  -1.523895762744763e-19,  -2.829261093455978e-03,   6.900445768812327e-05,  -1.262315379821897e-06,   2.052149983757957e-08,  -3.123330873845742e-10,   4.533248599257456e-12,
  -6.224835429624195e-14,   7.547859256564611e-16,  -5.525491969186592e-18,  -1.035496608176823e-19,  -1.562198816127427e-03,   3.810199326111131e-05,  -6.970245616858465e-07,
   1.133185783633372e-08,  -1.724736387154525e-10,   2.503355219664191e-12,  -3.437353083000290e-14,   4.166756980447360e-16,  -3.044207359865138e-18,  -5.746626860722207e-20,
  -5.923987331741288e-04,   1.444868235008819e-05,  -2.643213578936854e-07,   4.297241161990129e-09,  -6.540577688892346e-11,   9.493337974605807e-13,  -1.303509907348950e-14,
   1.579947071435472e-16,  -1.153428422534078e-18,  -2.183308514236676e-20,  -6.754145404419349e-05,   1.647346588431536e-06,  -3.013627675314160e-08,   4.899455313645694e-10,
  -7.457185967094526e-12,   1.082376409377612e-13,  -1.486184308895853e-15,   1.801329969625321e-17,  -1.314882600609953e-19,  -2.490049124101217e-21,  -6.302364565556745e-05,
   1.465470839384071e-06,  -2.555815582317749e-08,   3.961871159958464e-10,  -5.755821490833994e-12,   8.016126933579836e-14,  -1.078944913660961e-15,   1.391652145552211e-17,
  -1.639176766053338e-19,   1.440696738495773e-21,  -5.827391685395372e-05,   1.355052832016531e-06,  -2.363304593098704e-08,   3.663569150967709e-10,  -5.322646449723627e-12,
   7.413137677945016e-14,  -9.978130846194442e-16,   1.286972756701828e-17,  -1.515533653233135e-19,   1.330445273343960e-21,  -4.949688400554743e-05,   1.150995433238025e-06,
  -2.007499088950327e-08,   3.112166360383465e-10,  -4.521814251011590e-12,   6.298184143936731e-14,  -8.477794309323590e-16,   1.093413510254494e-17,  -1.287116784138411e-19,
   1.127716844240627e-21,  -3.802800545747309e-05,   8.843289649281906e-07,  -1.542463901737981e-08,   2.391369018632270e-10,  -3.474760111736633e-12,   4.840133738402873e-14,
  -6.515480892946117e-16,   8.402879827313991e-18,  -9.887544732082964e-20,   8.644998005976154e-22,  -2.561305867035598e-05,   5.956391112061123e-07,  -1.038961934905367e-08,
   1.610831914696947e-10,  -2.340726846000366e-12,   3.260669577328732e-14,  -4.389477887608855e-16,   5.660812712531891e-18,  -6.658898174699901e-20,   5.812497332148232e-22,
  -1.414243066266895e-05,   3.288913373840922e-07,  -5.736905249391098e-09,   8.894862343425909e-11,  -1.292565619924470e-12,   1.800620648781090e-14,  -2.424030473727037e-16,
   3.126042367970472e-18,  -3.676540716608198e-20,   3.206160150039471e-22,  -5.362923796025998e-06,   1.247189615915217e-07,  -2.175509769674232e-09,   3.373080528485625e-11,
  -4.901679449853746e-13,   6.828410599709594e-15,  -9.192616554309868e-17,   1.185475247995237e-18,  -1.394142894235878e-20,   1.215338342773810e-22,  -6.114456638783216e-07,
   1.421965768326432e-08,  -2.480380119575523e-10,   3.845781411713506e-12,  -5.588607296644767e-14,   7.785368240386960e-16,  -1.048091705984501e-17,   1.351612063430496e-19,
  -1.589505115284598e-21,   1.385562052850195e-23,  -5.759657683898574e-04,   1.339276738648057e-05,  -2.335729740578556e-07,   3.620702679421419e-09,  -5.260125751898640e-11,
   7.325431171109723e-13,  -9.857661168116470e-15,   1.270332830077814e-16,  -1.490980709821268e-18,   1.287382084703150e-20,  -5.325585492337503e-04,   1.238367007162826e-05,
  -2.159796214854879e-07,   3.348088323372637e-09,  -4.864255901912676e-11,   6.774396124369689e-13,  -9.116400888921371e-15,   1.174774576475056e-16,  -1.378494212436579e-18,
   1.188744314753997e-20,  -4.523462667438294e-04,   1.051881326027877e-05,  -1.834629756003229e-07,   2.844168440498583e-09,  -4.132391766195027e-11,   5.755508991824055e-13,
  -7.745624642200022e-15,   9.980835975077782e-17,  -1.170701037452584e-18,   1.007441327051927e-20,  -3.475335194507051e-04,   8.081779452077708e-06,  -1.409639577940257e-07,
   2.185441085170572e-09,  -3.175510619957197e-11,   4.423088163483890e-13,  -5.952773484114594e-15,   7.670218911846765e-17,  -8.992997345271696e-19,   7.721610705001863e-21,
  -2.340747645446575e-04,   5.443476489316646e-06,  -9.494950646478761e-08,   1.472118353082460e-09,  -2.139141221626860e-11,   2.979716244341051e-13,  -4.010377015245008e-15,
   5.167210137465496e-17,  -6.056320742952193e-19,   5.190927969129001e-21,  -1.292460291466484e-04,   3.005699640644600e-06,  -5.242890075957759e-08,   8.128899066201760e-10,
  -1.181248604415767e-11,   1.645471162776219e-13,  -2.214675480273567e-15,   2.853454058892346e-17,  -3.343800609530918e-19,   2.863071605640491e-21,  -4.901113689609958e-05,
   1.139792069356926e-06,  -1.988172731378510e-08,   3.082614441341368e-10,  -4.479541972903020e-12,   6.240043997488942e-14,  -8.398680278990000e-16,   1.082101558030448e-17,
  -1.267961929822290e-19,   1.085252846909548e-21,  -5.587930814729806e-06,   1.299517960179139e-07,  -2.266790149957270e-09,   3.514609631959215e-11,  -5.107310905756900e-13,
   7.114545790028919e-15,  -9.575714043912565e-17,   1.233750976053573e-18,  -1.445641182411964e-20,   1.237250147606911e-22,  -1.654063987639127e-03,   3.846147589823503e-05,
  -6.707768359187787e-07,   1.039793388907273e-08,  -1.510573515585709e-10,   2.103452511321132e-12,  -2.829160377005168e-14,   3.638360703956919e-16,  -4.235080802797791e-18,
   3.502182051128284e-20,  -1.529406721604502e-03,   3.556354069203608e-05,  -6.202520967698820e-07,   9.615039867320337e-09,  -1.396889709898011e-10,   1.945225312808695e-12,
  -2.616412308865091e-14,   3.364642611912434e-16,  -3.915419893317514e-18,   3.233031890062418e-20,  -1.299052323611417e-03,   3.020802727849868e-05,  -5.268705178540168e-07,
   8.167882608338359e-09,  -1.186716914647604e-10,   1.652657048663249e-12,  -2.222991055580797e-14,   2.858544911262813e-16,  -3.325007254327431e-18,   2.738798254500916e-20,
  -9.980500761474587e-04,   2.320933056316885e-05,  -4.048214796778949e-07,   6.276149327075157e-09,  -9.119250634620653e-11,   1.270060057457648e-12,  -1.708437236482228e-14,
   2.196742520359467e-16,  -2.554009552893728e-18,   2.098235858891191e-20,  -6.722181415609776e-04,   1.563262719295866e-05,  -2.726767907512318e-07,   4.227629157128847e-09,
  -6.143063294065250e-11,   8.556049745084019e-13,  -1.150968966993168e-14,   1.479865448606245e-16,  -1.719904695843647e-18,   1.410060306792234e-20,  -3.711699793248773e-04,
   8.631796614424825e-06,  -1.505657577068586e-07,   2.334457028899212e-09,  -3.392241892872415e-11,   4.724855293243731e-13,  -6.356056959995792e-15,   8.172104903371874e-17,
  -9.495609598942614e-19,   7.775632427455962e-21,  -1.407506504337360e-04,   3.273265629069333e-06,  -5.709651151971194e-08,   8.852651342543488e-10,  -1.286409102175736e-11,
   1.791784724084052e-13,  -2.410396333983085e-15,   3.099059545579179e-17,  -3.600673904960269e-19,   2.947140725132473e-21,  -1.604747301453032e-05,   3.731967950772155e-07,
  -6.509786994738994e-09,   1.009325501120114e-10,  -1.466688168048514e-12,   2.042891714436186e-14,  -2.748201246753868e-16,   3.533370812155869e-18,  -4.105227939419486e-20,
   3.359865439983274e-22,  -3.438298278652799e-03,   7.994975967671935e-05,  -1.394340940629838e-06,   2.161401838316768e-08,  -3.139886752048371e-10,   4.371342598068031e-12,
  -5.873760663360340e-14,   7.522939176384279e-16,  -8.610522623145687e-18,   6.467968383717484e-20,  -3.179173561280722e-03,   7.392583005328966e-05,  -1.289315377704090e-06,
   1.998662865728329e-08,  -2.903582476645171e-10,   4.042515194767065e-12,  -5.432041087793205e-14,   6.956855697462042e-16,  -7.959982032328864e-18,   5.967243754444013e-20,
  -2.700336505324437e-03,   6.279333965168485e-05,  -1.095203484290949e-06,   1.697844547626906e-08,  -2.466715519891008e-10,   3.434502648820101e-12,  -4.615211292927449e-14,
   5.910256531522435e-16,  -6.758810117094178e-18,   5.049924788380996e-20,  -2.074643958293373e-03,   4.824516884366450e-05,  -8.415006682018411e-07,   1.304612954956834e-08,
  -1.895531315033469e-10,   2.639396882217249e-12,  -3.546906340211040e-14,   4.541788501075008e-16,  -5.190873100502067e-18,   3.864639258334877e-20,  -1.397338008727135e-03,
   3.249549727742067e-05,  -5.668120695866190e-07,   8.787903690554330e-09,  -1.276899465001832e-10,   1.778087833422859e-12,  -2.389526194078387e-14,   3.059562138408868e-16,
  -3.495224550000340e-18,   2.594890280936547e-20,  -7.715500188645775e-04,   1.794289084383340e-05,  -3.129803908267805e-07,   4.852597610122794e-09,  -7.051125951571035e-11,
   9.819019303312384e-13,  -1.319576310710164e-14,   1.689525658734429e-16,  -1.929595359558312e-18,   1.430211411473418e-20,  -2.925779913406642e-04,   6.804127866332334e-06,
  -1.186862720117852e-07,   1.840186129154279e-09,  -2.673934363449660e-11,   3.723619670208551e-13,  -5.004199814142292e-15,   6.407055021948444e-17,  -7.316728170684668e-19,
   5.419805836442908e-21,  -3.335783817845640e-05,   7.757631065524660e-07,  -1.353186612143579e-08,   2.098068378459463e-10,  -3.048663022486315e-12,   4.245460592386290e-14,
  -5.705512039443405e-16,   7.304951959695934e-18,  -8.341971520265587e-20,   6.178615776722518e-22,  -6.328659296632299e-03,   1.471584732266697e-04,  -2.566471632876818e-06,
   3.978302121048357e-08,  -5.778843825276384e-10,   8.041649422144267e-12,  -1.078217048712649e-13,   1.368158115278002e-15,  -1.503998037319613e-17,   8.436445679884875e-20,
  -5.851704733834558e-03,   1.360706063493703e-04,  -2.373157974372465e-06,   3.678762624940588e-08,  -5.343932768694794e-10,   7.436714129725387e-12,  -9.971232204374002e-14,
   1.265154042852412e-15,  -1.390089929574476e-17,   7.765277801829802e-20,  -4.970339494113496e-03,   1.155797342720559e-04,  -2.015868964872251e-06,   3.125072583119529e-08,
  -4.539893147149868e-10,   6.318178031027635e-12,  -8.471699042118325e-14,   1.074747835621234e-15,  -1.179934262403142e-17,   6.546265338656277e-20,  -3.818666592547525e-03,
   8.880183504230069e-05,  -1.548894873771184e-06,   2.401285681503810e-08,  -3.488648852698630e-10,   4.855469026634305e-12,  -6.510605134639668e-14,   8.258383408293410e-16,
  -9.058896509050083e-18,   4.989010935108689e-20,  -2.571992148745884e-03,   5.981240932140266e-05,  -1.043293647446592e-06,   1.617511591296943e-08,  -2.350080754766818e-10,
   3.270984629512215e-12,  -4.386091363939571e-14,   5.562910397706735e-16,  -6.098026497712905e-18,   3.338764991613241e-20,  -1.420143571875202e-03,   3.302634583269462e-05,
  -5.760823903161377e-07,   8.931746214444311e-09,  -1.297730255237234e-10,   1.806311784893565e-12,  -2.422127828141863e-14,   3.071799878445743e-16,  -3.365973043002889e-18,
   1.836660406978899e-20,  -5.385298989193653e-04,   1.252392838601629e-05,  -2.184580029768434e-07,   3.387067412871909e-09,  -4.921263890151744e-11,   6.849985583562411e-13,
  -9.185354876270769e-15,   1.164879681338378e-16,  -1.276247913657028e-18,   6.954982963120666e-21,  -6.139967377609649e-05,   1.427898149707722e-06,  -2.490721461225457e-08,
   3.861728389012351e-10,  -5.610936148973486e-12,   7.809965448401193e-14,  -1.047262893938352e-15,   1.328125352090759e-17,  -1.455065259975380e-19,   7.927769639450002e-22,
  -5.754264292421003e-05,   1.278570311805156e-06,  -2.130778265294999e-08,   3.156352666940390e-10,  -4.382840241796621e-12,   5.839760974666242e-14,  -7.549756733882290e-16,
   9.487216462348618e-18,  -1.142014914307787e-19,   1.239949350347090e-21,  -5.320589642453777e-05,   1.182230633083603e-06,  -1.970271279101061e-08,   2.918676716015187e-10,
  -4.052949974826112e-12,   5.400422549674350e-14,  -6.982044097983659e-16,   8.774007214155248e-18,  -1.056110715419207e-19,   1.146325457746250e-21,  -4.519206827944947e-05,
   1.004193005643048e-06,  -1.673623311808957e-08,   2.479353988749479e-10,  -3.443091995190374e-12,   4.588102807088409e-14,  -5.932200384086231e-16,   7.454986159199645e-18,
  -8.972693950584159e-20,   9.734223270419245e-22,  -3.472055322776455e-05,   7.715337117575808e-07,  -1.285917652544686e-08,   1.905092673132520e-10,  -2.645772823502115e-12,
   3.525873981956856e-14,  -4.559098391194947e-16,   5.729629176553310e-18,  -6.895483373454699e-20,   7.476681744985574e-22,  -2.338533168601038e-05,   5.196635661355580e-07,
  -8.661527162254940e-09,   1.283260524533531e-10,  -1.782263938608379e-12,   2.375251720323730e-14,  -3.071461162537939e-16,   3.860162041141650e-18,  -4.645300712238753e-20,
   5.034693850129135e-22,  -1.291235838028170e-05,   2.869395057716804e-07,  -4.782672026032630e-09,   7.085997802366740e-11,  -9.841701028341695e-13,   1.311660029723779e-14,
  -1.696172663625751e-16,   2.131758616287165e-18,  -2.565245939887351e-20,   2.779593432277141e-22,  -4.896468022020518e-06,   1.088102893195998e-07,  -1.813649007512788e-09,
   2.687122280184670e-11,  -3.732167090472074e-13,   4.974131505236686e-15,  -6.432370690925636e-17,   8.084288984823724e-19,  -9.728061296331877e-21,   1.053994527422056e-22,
  -5.582633665524551e-07,   1.240585065402110e-08,  -2.067808553051145e-10,   3.063692266229282e-12,  -4.255195660859995e-14,   5.671220827184541e-16,  -7.333835981840828e-18,
   9.217272384077633e-20,  -1.109138575827416e-21,   1.201686549309348e-23,  -5.258755222183321e-04,   1.168470536133383e-05,  -1.947293400057020e-07,   2.884552939486681e-09,
  -4.005416075338069e-11,   5.336804369195897e-13,  -6.899070575504101e-15,   8.667086196647751e-17,  -1.042132581609067e-18,   1.126606236274558e-20,  -4.862425002650356e-04,
   1.080426824320335e-05,  -1.800607937483295e-07,   2.667343727761387e-09,  -3.703933961862836e-11,   4.935304222776285e-13,  -6.380285215882658e-15,   8.015521035173589e-17,
  -9.637369660005202e-19,   1.041519138056160e-20,  -4.130050567512800e-04,   9.177203074476843e-06,  -1.529504820365913e-07,   2.265851938726031e-09,  -3.146593282970267e-11,
   4.192946163598807e-13,  -5.420921457469996e-15,   6.810511523084008e-17,  -8.187822485388313e-19,   8.843944010421580e-21,  -3.173070983956175e-04,   7.050956849577812e-06,
  -1.175185140967006e-07,   1.741041390550759e-09,  -2.417934479211408e-11,   3.222202926895535e-13,  -4.166161013881068e-15,   5.234298295883249e-17,  -6.292258406586645e-19,
   6.792630415732049e-21,  -2.137158268654875e-04,   4.749144885327427e-06,  -7.915668625270305e-08,   1.172756430822229e-09,  -1.628785862079381e-11,   2.170679517982365e-13,
  -2.806738441528213e-15,   3.526442039426248e-17,  -4.238895633452438e-19,   4.573933478102943e-21,  -1.180045416963015e-04,   2.622306767343731e-06,  -4.370828167761581e-08,
   6.475808554301033e-10,  -8.994191611883033e-12,   1.198691239982478e-13,  -1.549982787599992e-15,   1.947461200661318e-17,  -2.340810181265773e-19,   2.525171793815090e-21,
  -4.474825185702312e-05,   9.944045776160923e-07,  -1.657472669031624e-08,   2.455728879185212e-10,  -3.410774798242962e-12,   4.545726501894564e-14,  -5.877976467317828e-16,
   7.385373366598405e-18,  -8.876931070031063e-20,   9.575144355327891e-22,  -5.101903988076981e-06,   1.133756261169111e-07,  -1.889746112532083e-09,   2.799871680596186e-11,
  -3.888763220580141e-13,   5.182777880130144e-15,  -6.701746024310875e-17,   8.420405793296607e-19,  -1.012097269969250e-20,   1.091685972908105e-22,  -1.510214343380242e-03,
   3.355624812928654e-05,  -5.592255261452639e-07,   8.283879776558432e-09,  -1.150272266146685e-10,   1.532572848469384e-12,  -1.980911918361729e-14,   2.486938368481851e-16,
  -2.982641552240357e-18,   3.191924392007949e-20,  -1.396395852695973e-03,   3.102780042815377e-05,  -5.171002586608099e-07,   7.660096783254536e-09,  -1.063692843783344e-10,
   1.417273658527314e-12,  -1.831953248824423e-14,   2.299971368785126e-16,  -2.758237456176588e-18,   2.950710722034060e-20,  -1.186071863471198e-03,   2.635517918099940e-05,
  -4.392446136113757e-07,   6.507089759436112e-09,  -9.036361520969088e-11,   1.204090080589767e-12,  -1.556492169829942e-14,   1.954197129285161e-16,  -2.343329706648323e-18,
   2.505363089217064e-20,  -9.112455533739073e-04,   2.024900502365427e-05,  -3.374907590788490e-07,   4.999935055808647e-09,  -6.943804698645280e-11,   9.253211307758960e-13,
  -1.196215369268824e-14,   1.501913581926606e-16,  -1.800789088836048e-18,   1.924091487090612e-20,  -6.137511511750286e-04,   1.363863950504135e-05,  -2.273229058554292e-07,
   3.367930249255631e-09,  -4.677533930663789e-11,   6.233546754607447e-13,  -8.058883496442681e-15,   1.011862541743331e-16,  -1.213115566390743e-18,   1.295532709531920e-20,
  -3.388865690114135e-04,   7.530765544983257e-06,  -1.255218487332611e-07,   1.859727296254788e-09,  -2.582944551660978e-11,   3.442284795461465e-13,  -4.450405491110712e-15,
   5.587951085681146e-17,  -6.699026394301084e-19,   7.152083495369050e-21,  -1.285084567346974e-04,   2.855740535041095e-06,  -4.759945384119132e-08,   7.052379615813805e-10,
  -9.795034954052259e-12,   1.305397426743734e-13,  -1.687720264525516e-15,   2.119121544382897e-17,  -2.540427762131654e-19,   2.711943423107596e-21,  -1.465169656260910e-05,
   3.255932026815660e-07,  -5.426990413421302e-09,   8.040691352919640e-11,  -1.116771815316150e-12,   1.488339622016895e-14,  -1.924245914735899e-16,   2.416108152700443e-18,
  -2.896449821406018e-20,   3.091946506783233e-22,  -3.139278427164847e-03,   6.975328031102490e-05,  -1.162460371616524e-06,   1.721965095607813e-08,  -2.391040154878163e-10,
   3.185531933781071e-12,  -4.116227914340860e-14,   5.161153972399453e-16,  -6.158569834139322e-18,   6.456484949966690e-20,  -2.902684241711130e-03,   6.449740305396876e-05,
  -1.074894707640584e-06,   1.592299690999532e-08,  -2.211069731454347e-10,   2.945875846372449e-12,  -3.806694955260583e-14,   4.773113621945519e-16,  -5.695088441678000e-18,
   5.967962234546898e-20,  -2.465484340252479e-03,   5.478443816762399e-05,  -9.130564181438155e-07,   1.352624803753328e-08,  -1.878364052039894e-10,   2.502761807899112e-12,
  -3.234295612833275e-14,   4.055493246995933e-16,  -4.838221934595679e-18,   5.066376207548111e-20,  -1.894203640730038e-03,   4.209155080838166e-05,  -7.015409949703212e-07,
   1.039333457909602e-08,  -1.443389808974116e-10,   1.923325654744622e-12,  -2.485656840211554e-14,   3.116850457380210e-16,  -3.717900361434971e-18,   3.890227792173919e-20,
  -1.275802840132438e-03,   2.835060226251833e-05,  -4.725354194474273e-07,   7.000896057718107e-09,  -9.723062054116870e-11,   1.295673007984389e-12,  -1.674579996217868e-14,
   2.099854263260365e-16,  -2.504512857218650e-18,   2.619006041214777e-20,  -7.044425845859092e-04,   1.565418153395862e-05,  -2.609218775600068e-07,   3.865803763433176e-09,
  -5.369096119977060e-11,   7.154954880988104e-13,  -9.247623885385577e-15,   1.159626879151151e-16,  -1.383008327615642e-18,   1.445723622358837e-20,  -2.671301777090924e-04,
   5.936219960852952e-06,  -9.894483701307944e-08,   1.465973837363900e-09,  -2.036067070828403e-11,   2.713331267698361e-13,  -3.506960485257311e-15,   4.397651485359518e-17,
  -5.244655366105176e-19,   5.481759884804946e-21,  -3.045644159114735e-05,   6.768096909206486e-07,  -1.128106813369199e-08,   1.671413593170992e-10,  -2.321402960269464e-12,
   3.093585370137741e-14,  -3.998443401114464e-16,   5.013963757490361e-18,  -5.979647962829006e-20,   6.249843557288309e-22,  -5.778272308769817e-03,   1.283904713030697e-04,
  -2.139666907278749e-06,   3.169502294708063e-08,  -4.400929491830561e-10,   5.862530836335148e-12,  -7.570561819741774e-14,   9.465829903797627e-16,  -1.116649824715357e-17,
   1.114369542115278e-19,  -5.342788275715385e-03,   1.187163089389921e-04,  -1.978490353343271e-06,   2.930836095838472e-08,  -4.069676976392711e-10,   5.421473905682893e-12,
  -7.001249116051254e-14,   8.754031243864816e-16,  -1.032557309259481e-17,   1.029784455619593e-19,  -4.538061921313639e-03,   1.008382659966414e-04,  -1.680604898478511e-06,
   2.489683025980265e-08,  -3.457301067936191e-10,   4.605980004598968e-12,  -5.948467884675750e-14,   7.437737562074304e-16,  -8.771238016121881e-18,   8.738396334489252e-20,
  -3.486541476967172e-03,   7.747526738762226e-05,  -1.291281903483992e-06,   1.913029246186309e-08,  -2.656690695259558e-10,   3.539606018024122e-12,  -4.571559792308881e-14,
   5.716147042791105e-16,  -6.739563620689846e-18,   6.706732727201679e-20,  -2.348290026935036e-03,   5.218316855361909e-05,  -8.697658996797707e-07,   1.288606516186117e-08,
  -1.789618087997665e-10,   2.384499155647142e-12,  -3.079834741935286e-14,   3.850958971133907e-16,  -4.539676067764620e-18,   4.513522763900605e-20,  -1.296623148879546e-03,
   2.881366631690601e-05,  -4.802623083402606e-07,   7.115517536897486e-09,  -9.882309451779876e-11,   1.316765578324617e-12,  -1.700789942757215e-14,   2.126637972508140e-16,
  -2.506730447887094e-18,   2.490999306639359e-20,  -4.916897129164570e-04,   1.092642631992162e-05,  -1.821214696356828e-07,   2.698316610290640e-09,  -3.747566412517771e-11,
   4.993491460812369e-13,  -6.449870871781537e-15,   8.064815342901127e-17,  -9.505889132883237e-19,   9.444395862492148e-21,  -5.605925601828041e-05,   1.245760984123921e-06,
  -2.076434475450865e-08,   3.076455352204952e-10,  -4.272753018471653e-12,   5.693293656629480e-14,  -7.353786863539096e-16,   9.195059265233209e-18,  -1.083802720636766e-19,
   1.076756880431048e-21,  -5.274687144523157e-05,   1.122149199035375e-06,  -1.790532871358061e-08,   2.539523431929828e-10,  -3.376534002363269e-12,   4.309154516210788e-14,
  -5.343133066319708e-16,   6.472934213149029e-18,  -7.644665756692382e-20,   8.630777518346691e-22,  -4.877149043905319e-05,   1.037592736247753e-06,  -1.655647764860857e-08,
   2.348278118317877e-10,  -3.122355815221537e-12,   3.984918436384436e-14,  -4.941296530839712e-16,   5.986354904274452e-18,  -7.070104994782814e-20,   7.981502710897261e-22,
  -4.142546902602287e-05,   8.813325622476267e-07,  -1.406358871484432e-08,   1.994788610881830e-10,  -2.652483281627646e-12,   3.385447905609210e-14,  -4.198231982931002e-16,
   5.086450035012495e-18,  -6.007421855702944e-20,   6.780991450745934e-22,  -3.182663637479774e-05,   6.771350786384100e-07,  -1.080557559964983e-08,   1.532741571756528e-10,
  -2.038210454009560e-12,   2.601600173175676e-14,  -3.226423847133885e-16,   3.909292675659303e-18,  -4.617235269953444e-20,   5.211104680436993e-22,  -2.143614893456569e-05,
   4.560798961343199e-07,  -7.278239012149068e-09,   1.032436443717233e-10,  -1.372974742606035e-12,   1.752573126095766e-14,  -2.173607208153503e-16,   2.633784136894269e-18,
  -3.110800630613562e-20,   3.510546344181912e-22,  -1.183609108184491e-05,   2.518303088468726e-07,  -4.018840446042592e-09,   5.700946965099205e-11,  -7.581537106182556e-13,
   9.677955083789055e-15,  -1.200334801886399e-16,   1.454502252293649e-18,  -1.717952284321327e-20,   1.938596544909930e-22,  -4.488337025744311e-06,   9.549645252711995e-08,
  -1.523992315561206e-09,   2.161884447314079e-11,  -2.875059835683317e-13,   3.670100930181941e-15,  -4.551997496340106e-17,   5.515931354635806e-19,  -6.515043380112495e-21,
   7.351632655999413e-23,  -5.117308937314579e-07,   1.088789088188798e-08,  -1.737559789268808e-10,   2.464847369843989e-12,  -3.277971169262582e-14,   4.184437085493762e-16,
  -5.189934931590550e-18,   6.288970435637859e-20,  -7.428109610144221e-22,   8.381913147954169e-24,  -4.820475244329913e-04,   1.025519103302297e-05,  -1.636347154666362e-07,
   2.320840726726067e-09,  -3.085773053325288e-11,   3.938069100711795e-13,  -4.882912250070919e-15,   5.914882525978156e-17,  -6.983116908058856e-19,   7.873403698217802e-21,
  -4.457169796972729e-04,   9.482439352817585e-06,  -1.513077225442712e-07,   2.146063873336916e-09,  -2.853482714949152e-11,   3.641754745385817e-13,  -4.515686770379232e-15,
   5.470250591089058e-17,  -6.458266825040375e-19,   7.281060089535223e-21,  -3.785825442404745e-04,   8.054395794401193e-06,  -1.285255006695314e-07,   1.823013950897714e-09,
  -2.424071954314165e-11,   3.093907903598491e-13,  -3.836624221983905e-15,   4.647926642407242e-17,  -5.487532620802584e-19,   6.185841503650888e-21,  -2.908599288475117e-04,
   6.188258738210134e-06,  -9.875089794189204e-08,   1.400754571922556e-09,  -1.862695538936199e-11,   2.377561649991833e-13,  -2.948520729569444e-15,   3.572254331003202e-17,
  -4.217642649687572e-19,   4.753688826103733e-21,  -1.959024723959889e-04,   4.168061132261266e-06,  -6.651497934746516e-08,   9.435315742075916e-10,  -1.254744775638667e-11,
   1.601649093751498e-13,  -1.986386617980152e-15,   2.406712031535354e-17,  -2.841574194833882e-19,   3.202373635795190e-21,  -1.081686600291480e-04,   2.301447906658756e-06,
  -3.672771515404461e-08,   5.210028661496501e-10,  -6.928673747645910e-12,   8.844531253404467e-14,  -1.096945582296174e-15,   1.329101702043638e-17,  -1.569268898501146e-19,
   1.768408558838739e-21,  -4.101839014897764e-05,   8.727309741549720e-07,  -1.392758842102603e-08,   1.975720876042598e-10,  -2.627481909230103e-12,   3.354047620632433e-14,
  -4.159917223198789e-16,   5.040372320601946e-18,  -5.951183954048009e-20,   6.706225862968962e-22,  -4.676649130839478e-06,   9.950316859302380e-08,  -1.587935670981638e-09,
   2.252595142549969e-11,  -2.995697633207146e-13,   3.824091354950104e-15,  -4.742906742502656e-17,   5.746763303409595e-19,  -6.785226228371824e-21,   7.646054731587170e-23,
  -1.384348681553317e-03,   2.945095544314815e-05,  -4.699277278933499e-07,   6.665011210888481e-09,  -8.861738824910583e-11,   1.130927313986925e-12,  -1.402204434337334e-14,
   1.698212071114498e-16,  -2.003283800910748e-18,   2.251772882901772e-20,  -1.280014276425114e-03,   2.723175979569948e-05,  -4.345269526650576e-07,   6.163085471126801e-09,
  -8.194646195070718e-11,   1.045832273256310e-12,  -1.296749655316713e-14,   1.570553132005485e-16,  -1.852710486965889e-18,   2.082334660671684e-20,  -1.087216963917277e-03,
   2.313069068087476e-05,  -3.691007517581370e-07,   5.235347800827824e-09,  -6.961462117032933e-11,   8.885025942158949e-13,  -1.101745934053070e-14,   1.334455319609909e-16,
  -1.574222347615979e-18,   1.769068201679469e-20,  -8.352943197658632e-04,   1.777150047984437e-05,  -2.835937652205965e-07,   4.022699526662480e-09,  -5.349298427817617e-11,
   6.827835936320979e-13,  -8.467130023912537e-15,   1.025619957835459e-16,  -1.209918043107879e-18,   1.359457893578244e-20,  -5.625945900102368e-04,   1.196987772245778e-05,
  -1.910183484671376e-07,   2.709642423341577e-09,  -3.603382334823359e-11,   4.599584906343145e-13,  -5.704212645391977e-15,   6.909835111694148e-17,  -8.151602147436961e-19,
   9.157955028204956e-21,  -3.106397902831306e-04,   6.609320053858383e-06,  -1.054750006697359e-07,   1.496220695196969e-09,  -1.989779989635146e-11,   2.539955312909321e-13,
  -3.150046334444114e-15,   3.815939307043518e-17,  -4.501736505870086e-19,   5.057130885587265e-21,  -1.177970043281948e-04,   2.506317137313898e-06,  -3.999738050234532e-08,
   5.673892897759275e-10,  -7.545615664893127e-12,   9.632088727780404e-14,  -1.194583527463953e-15,   1.447123998264380e-17,  -1.707204712695806e-19,   1.917776148296230e-21,
  -1.343044561003248e-05,   2.857541488121414e-07,  -4.560248718245231e-09,   6.469022894536390e-11,  -8.603059416799946e-13,   1.098195116234150e-14,  -1.361997825376923e-16,
   1.649933415463087e-18,  -1.946464463281110e-20,   2.186537009097229e-22,  -2.877641821899568e-03,   6.121962043198747e-05,  -9.768374456060177e-07,   1.385453532214335e-08,
  -1.842081821407277e-10,   2.350811341254503e-12,  -2.914459513007525e-14,   3.528346489015392e-16,  -4.155613004716967e-18,   4.642934811607656e-20,  -2.660762179029769e-03,
   5.660658451589346e-05,  -9.032499536105974e-07,   1.281118403578072e-08,  -1.703413846199900e-10,   2.173927681143241e-12,  -2.695272417796298e-14,   3.263105962448879e-16,
  -3.843235843565522e-18,   4.293447682080786e-20,  -2.259994932295978e-03,   4.808170337625489e-05,  -7.672486937118041e-07,   1.088269898478026e-08,  -1.447072936874974e-10,
   1.846892858819295e-12,  -2.289959023464143e-14,   2.772562408036800e-16,  -3.265505208678867e-18,   3.647370571656163e-20,  -1.736324020223561e-03,   3.694156938037827e-05,
  -5.895055613202328e-07,   8.361971277473627e-09,  -1.111953882740424e-10,   1.419273273232822e-12,  -1.759876512417609e-14,   2.130896841902246e-16,  -2.509774829672808e-18,
   2.802718158781567e-20,  -1.169463837076550e-03,   2.488175204184133e-05,  -3.970693030676752e-07,   5.632524109319248e-09,  -7.490318531827424e-11,   9.560960955315561e-13,
  -1.185608885604864e-14,   1.435630234506990e-16,  -1.690898113616522e-18,   1.887969983031077e-20,  -6.457260832997816e-04,   1.373877549601350e-05,  -2.192505868555237e-07,
   3.110188656514884e-09,  -4.136137775268725e-11,   5.279696468209256e-13,  -6.547304638956826e-15,   7.928221284253504e-17,  -9.337960349577977e-19,   1.042535590382264e-20,
  -2.448643110399595e-04,   5.209874569643805e-06,  -8.314244220634414e-08,   1.179430105294883e-09,  -1.568500338936049e-11,   2.002181041730471e-13,  -2.482916296743329e-15,
   3.006628861008912e-17,  -3.541250194588074e-19,   3.953492270459112e-21,  -2.791783059353230e-05,   5.939963665815919e-07,  -9.479376167596221e-09,   1.344713495753765e-10,
  -1.788310219164335e-12,   2.282771158097265e-14,  -2.830883278631167e-16,   3.427997185579647e-18,  -4.037544604158956e-20,   4.507535934656132e-22,  -5.296694276214344e-03,
   1.126831034823293e-04,  -1.798003090835044e-06,   2.550115157307173e-08,  -3.390583404496823e-10,   4.326819726323532e-12,  -5.363294792652292e-14,   6.487609115122776e-16,
  -7.614610924182697e-18,   8.393010531141603e-20,  -4.897497560940637e-03,   1.041921785141206e-04,  -1.662555233881618e-06,   2.358072192864424e-08,  -3.135347469480436e-10,
   4.001253339892350e-12,  -4.959934611401070e-14,   5.999885324899923e-16,  -7.042106557551395e-18,   7.760730053245273e-20,  -4.159830501148735e-03,   8.850096616968950e-05,
  -1.412226289761723e-06,   2.003108350680127e-08,  -2.663519672021199e-10,   3.399323913408088e-12,  -4.214057005648646e-14,   5.097888661849960e-16,  -5.983348651598272e-18,
   6.592177798755530e-20,  -3.195942396139248e-03,   6.799602244229989e-05,  -1.085065713360598e-06,   1.539134218773759e-08,  -2.046690833038278e-10,   2.612262133233498e-12,
  -3.238577267541113e-14,   3.918036758457485e-16,  -4.598501283479524e-18,   5.064983037323509e-20,  -2.152558516800221e-03,   4.579827545380846e-05,  -7.308604272054653e-07,
   1.036742446086228e-08,  -1.378687191692468e-10,   1.759754898919122e-12,  -2.181790359000025e-14,   2.639650081163469e-16,  -3.098055708981070e-18,   3.411566281967303e-20,
  -1.188547380481654e-03,   2.528809962791118e-05,  -4.035607293064424e-07,   5.724723986435220e-09,  -7.613080856856820e-11,   9.717611677740644e-13,  -1.204852366866264e-14,
   1.457733675746757e-16,  -1.710874523323682e-18,   1.883764347805339e-20,  -4.507063335162606e-04,   9.589488321084172e-06,  -1.530350504002476e-07,   2.170901045971947e-09,
  -2.887021773835761e-11,   3.685139304950723e-13,  -4.569127297924534e-15,   5.528174480596920e-17,  -6.488146111007290e-19,   7.143448425765825e-21,  -5.138659453106142e-05,
   1.093331738403538e-06,  -1.744808994119228e-08,   2.475127539048205e-10,  -3.291609447994129e-12,   4.201582913398958e-14,  -5.209464995243178e-16,   6.302927229291385e-18,
  -7.397432161328815e-20,   8.144506617877284e-22,  -4.852667511581491e-05,   9.902391239439562e-07,  -1.515570722039092e-08,   2.061826960309395e-10,  -2.629572791913554e-12,
   3.219294336181356e-14,  -3.830959264453862e-16,   4.461948293544042e-18,  -5.098738500887936e-20,   5.687441374590687e-22,  -4.486930029889868e-05,   9.156200191147203e-07,
  -1.401393146218082e-08,   1.906543530110377e-10,  -2.431602469414476e-12,   2.977028711512315e-14,  -3.542800539452901e-16,   4.126496522367467e-18,  -4.715579788732562e-20,
   5.260070695661772e-22,  -3.811095071723855e-05,   7.777254899570478e-07,  -1.190378665849613e-08,   1.619531818121445e-10,  -2.065648670273117e-12,   2.529131799619554e-14,
  -3.009974163876516e-16,   3.506119648739720e-18,  -4.006873365585393e-20,   4.469570423780270e-22,  -2.928007020225737e-05,   5.975302243372393e-07,  -9.146051282818150e-09,
   1.244390456298465e-10,  -1.587252636037794e-12,   1.943511508182753e-14,  -2.313170962996723e-16,   2.694651779422553e-18,  -3.079699301427793e-20,   3.435360277608458e-22,
  -1.972092893508516e-05,   4.024611442237988e-07,  -6.160408057901687e-09,   8.381991739283272e-11,  -1.069188433904767e-12,   1.309229601345762e-14,  -1.558330228643239e-16,
   1.815426900069950e-18,  -2.074939701743006e-20,   2.314580974740456e-22,  -1.088901151256427e-05,   2.222235800584224e-07,  -3.401593823422321e-09,   4.628376621001315e-11,
  -5.903993817226740e-13,   7.229683595793748e-15,  -8.605503379272056e-17,   1.002558218058325e-18,  -1.145904577064083e-20,   1.278253558069316e-22,  -4.129195563850080e-06,
   8.426923427002198e-08,  -1.289923373853438e-09,   1.755146356799948e-11,  -2.238898277007567e-13,   2.741651203282162e-15,  -3.263429149740442e-17,   3.802005893972587e-19,
  -4.345664506212441e-21,   4.847584274429113e-23,  -4.707838982973057e-07,   9.607834495842551e-09,  -1.470688853402259e-10,   2.001109039418476e-12,  -2.552656705572784e-14,
   3.125870553986406e-16,  -3.720778387171613e-18,   4.334842030647708e-20,  -4.954700869445382e-22,   5.526965007096907e-24,  -4.434796409410658e-04,   9.049680202065598e-06,
  -1.385062456132926e-07,   1.884279643436033e-09,  -2.403135588617383e-11,   2.942072307452115e-13,  -3.501046304868721e-15,   4.077590339746420e-17,  -4.659011585699119e-19,
   5.194734903071046e-21,  -4.100553177884378e-04,   8.367744880236586e-06,  -1.280716897513383e-07,   1.742367925127516e-09,  -2.222212842199975e-11,   2.720668810429505e-13,
  -3.237703033869526e-15,   3.771034367572221e-17,  -4.308895177718951e-19,   4.804378173434024e-21,  -3.482915468588092e-04,   7.107542813560092e-06,  -1.087873218079993e-07,
   1.480071264389063e-09,  -1.887771975563441e-11,   2.311341482254983e-13,  -2.750762279748380e-15,   3.204096996121023e-17,  -3.661306499536290e-19,   4.082347648523697e-21,
  -2.675871567345947e-04,   5.460759235373376e-06,  -8.358469894546477e-08,   1.137233943269537e-09,  -1.450571476185078e-11,   1.776150509864136e-13,  -2.113966038093055e-15,
   2.462529731823336e-17,  -2.814092694144015e-19,   3.137725870237233e-21,  -1.802272762821908e-04,   3.678045596161637e-06,  -5.629925275644759e-08,   7.660204615639517e-10,
  -9.771187070235207e-12,   1.196488315087366e-13,  -1.424130390852016e-15,   1.659042559200087e-17,  -1.895986586764799e-19,   2.114043453172283e-21,  -9.951340998057042e-05,
   2.030875456494300e-06,  -3.108677033052542e-08,   4.229819481512452e-10,  -5.395590355188459e-12,   6.607116051104441e-14,  -7.864416941342643e-16,   9.161958512566300e-18,
  -1.047075645768553e-19,   1.167502609448756e-21,  -3.773623809298327e-05,   7.701267325975473e-07,  -1.178845968932022e-08,   1.604007811080367e-10,  -2.046102743531969e-12,
   2.505560223721644e-14,  -2.982390009218646e-16,   3.474493390605045e-18,  -3.970870583555857e-20,   4.427575356949204e-22,  -4.302439301258278e-06,   8.780488219356233e-08,
  -1.344045438301169e-09,   1.828790241680673e-11,  -2.332842872778126e-13,   2.856693409239173e-15,  -3.400353360120232e-17,   3.961429917732087e-19,  -4.527380198856014e-21,
   5.048092057164440e-23,  -1.273589065723443e-03,   2.598895797194848e-05,  -3.977635562999457e-07,   5.411292009366122e-09,  -6.901345081791193e-11,   8.449049610784274e-13,
  -1.005418994448311e-14,   1.170920119890479e-16,  -1.337544457043351e-18,   1.489896788885007e-20,  -1.177600775469344e-03,   2.403056960648168e-05,  -3.677974993133628e-07,
   5.003748600507889e-09,  -6.381769600730232e-11,   7.813222491471701e-13,  -9.297928857582562e-15,   1.082889268346045e-16,  -1.237028943401423e-18,   1.377932741668134e-20,
  -1.000226988598423e-03,   2.041150928433449e-05,  -3.124164676392828e-07,   4.250482581028867e-09,  -5.421319482902913e-11,   6.637715288353127e-13,  -7.899547723894889e-15,
   9.200872676527884e-17,  -1.051112473821569e-18,   1.170840118837651e-20,  -7.684593507424993e-04,   1.568226048802675e-05,  -2.400393350838955e-07,   3.265919135853089e-09,
  -4.165763389856859e-11,   5.100752648501965e-13,  -6.070816840244132e-15,   7.071387606774008e-17,  -8.078870008136866e-19,   8.999102011566694e-21,  -5.175784122376789e-04,
   1.056264644522187e-05,  -1.616807306542235e-07,   2.199864766627478e-09,  -2.806097731488531e-11,   3.436077530462181e-13,  -4.089769625508976e-15,   4.764096227115484e-17,
  -5.443105927497704e-19,   6.063109019471982e-21,  -2.857835606051778e-04,   5.832287518020180e-06,  -8.927528332187185e-08,   1.214723537037715e-09,  -1.549510180129364e-11,
   1.897432890604355e-13,  -2.258476632428958e-15,   2.630941701884792e-17,  -3.006001420173814e-19,   3.348403297884872e-21,  -1.083712887354866e-04,   2.211657300528787e-06,
  -3.385421089089415e-08,   4.606404718014758e-10,  -5.876015079965320e-12,   7.195472770278048e-14,  -8.564726516630163e-16,   9.977330500374955e-18,  -1.139978616057473e-19,
   1.269829095754125e-21,  -1.235578625073021e-05,   2.521588986665264e-07,  -3.859842499726268e-09,   5.251937016305664e-11,  -6.699477795982859e-13,   8.203857737822927e-15,
  -9.765019470372121e-17,   1.137561381388922e-18,  -1.299744276918442e-20,   1.447793027667907e-22,  -2.647406111461104e-03,   5.402317590079181e-05,  -8.268300105798960e-07,
   1.124843691719111e-08,  -1.434579681156971e-10,   1.756293075763374e-12,  -2.089903059035584e-14,   2.433645948552558e-16,  -2.778612468305336e-18,   3.089283408217454e-20,
  -2.447875514750531e-03,   4.995227935821177e-05,  -7.645396503044904e-07,   1.040127761806087e-08,  -1.326575741974921e-10,   1.624124479195398e-12,  -1.932703478250755e-14,
   2.250681030404864e-16,  -2.569795916198828e-18,   2.857101916825176e-20,  -2.079169108568482e-03,   4.242934855835287e-05,  -6.494192520336992e-07,   8.835465735634644e-09,
  -1.126927377694290e-10,   1.379773270015358e-12,  -1.642030273540300e-14,   1.912311107980650e-16,  -2.183566131092799e-18,   2.427666157371615e-20,  -1.597394352948682e-03,
   3.259867201181550e-05,  -4.989691056198024e-07,   6.788856571381810e-09,  -8.659354616480209e-11,   1.060286803473390e-12,  -1.261903024087567e-14,   1.469717183293708e-16,
  -1.678286347405745e-18,   1.865880353280950e-20,  -1.075888831488092e-03,   2.195654429449947e-05,  -3.360852900972196e-07,   4.572852464590717e-09,  -5.833023379845159e-11,
   7.142529379268725e-13,  -8.501149067129551e-15,   9.901690320025399e-17,  -1.130735094748245e-18,   1.257114006419337e-20,  -5.940575066658310e-04,   1.212356012212362e-05,
  -1.855762858780793e-07,   2.525042267500179e-09,  -3.220960191654857e-11,   3.944168849127439e-13,  -4.694554125488929e-15,   5.468142925537596e-17,  -6.244569202106677e-19,
   6.942469291576377e-21,  -2.252711018227715e-04,   4.597365985409102e-06,  -7.037265505778648e-08,   9.575320028200458e-10,  -1.221444743269177e-11,   1.495713473317131e-13,
  -1.780296077748698e-15,   2.073685652947531e-17,  -2.368152748699021e-19,   2.632814869208210e-21,  -2.568393912323374e-05,   5.241620134233178e-07,  -8.023443987087164e-09,
   1.091718613032281e-10,  -1.392617585898982e-12,   1.705325130353102e-14,  -2.029793448208891e-16,   2.364304414206449e-18,  -2.700044187022601e-20,   3.001797121992429e-22,
  -4.872913888914747e-03,   9.943706131932562e-05,  -1.521893960189614e-06,   2.070428647903341e-08,  -2.640536659988073e-10,   3.232665580094375e-12,  -3.846527755070200e-14,
   4.478131112800949e-16,  -5.107612805403588e-18,   5.655521342465574e-20,  -4.505650471425193e-03,   9.194401815021371e-05,  -1.407240014450597e-06,   1.914497391729532e-08,
  -2.441740883229853e-10,   2.989393491598845e-12,  -3.557196511781520e-14,   4.141454260095277e-16,  -4.723745349867386e-18,   5.230365409345932e-20,  -3.826995783788630e-03,
   7.809703268872774e-05,  -1.195345142844553e-06,   1.626288298970028e-08,  -2.074261224635221e-10,   2.539635977619287e-12,  -3.022202954756775e-14,   3.518816827845547e-16,
  -4.013753185312878e-18,   4.444072305474856e-20,  -2.940223298136713e-03,   6.000232481036983e-05,  -9.184210275347683e-07,   1.249581892021384e-08,  -1.593870525834746e-10,
   1.951583191866924e-12,  -2.322567117571597e-14,   2.704400614780863e-16,  -3.084939268835588e-18,   3.415551867812439e-20,  -1.980320891147347e-03,   4.041402981029479e-05,
  -6.186110401663284e-07,   8.416960306330924e-09,  -1.073646290681789e-10,   1.314666886375759e-12,  -1.564659301012089e-14,   1.821989693951303e-16,  -2.078444649221522e-18,
   2.301123200008432e-20,  -1.093444282125156e-03,   2.231507443104033e-05,  -3.415785891644666e-07,   4.647685594294594e-09,  -5.928609779581580e-11,   7.259708343417531e-13,
  -8.640451277698994e-15,   1.006180838142980e-16,  -1.147832083235319e-18,   1.270785640144923e-20,  -4.146423459887053e-04,   8.462082351845711e-06,  -1.295305168767376e-07,
   1.762468593833647e-09,  -2.248233075254454e-11,   2.753037170854758e-13,  -3.276681884979629e-15,   3.815741631060577e-17,  -4.352962678724880e-19,   4.819212416279534e-21,
  -4.727481104374859e-05,   9.647920433946969e-07,  -1.476824834762381e-08,   2.009457399892390e-10,  -2.563299677783416e-12,   3.138852157553344e-14,  -3.735888332971155e-16,
   4.350502334579756e-18,  -4.963019674563906e-20,   5.494607257506020e-22,  -4.479348913832783e-05,   8.782208776879875e-07,  -1.291421613397593e-08,   1.688002327584653e-10,
  -2.068415519106862e-12,   2.433085142921723e-14,  -2.782315708051465e-16,   3.115855448785571e-18,  -3.431098678960493e-20,   3.716272509070644e-22,  -4.141743102773962e-05,
   8.120410131756872e-07,  -1.194126073901583e-08,   1.560864045196973e-10,  -1.912677315922308e-12,   2.249961451579074e-14,  -2.573000847703642e-16,   2.881563373805444e-18,
  -3.173232367233713e-20,   3.437086616689671e-22,  -3.517894644947739e-05,   6.897431414814238e-07,  -1.014314457525150e-08,   1.325878631489795e-10,  -1.624800003450169e-12,
   1.911419530692672e-14,  -2.185982732213764e-16,   2.448293360856080e-18,  -2.696288464528892e-20,   2.920642018546798e-22,  -2.702740163745687e-05,   5.299308569069860e-07,
  -7.793243325059388e-09,   1.018747709464085e-10,  -1.248485451234337e-12,   1.468803568843008e-14,  -1.679893923537375e-16,   1.881606489559444e-18,  -2.072347910423323e-20,
   2.244912414850572e-22,  -1.820366646936777e-05,   3.569290772591470e-07,  -5.249184286339192e-09,   6.862048885876801e-11,  -8.409824627046232e-13,   9.894324703102533e-15,
  -1.131685850947429e-16,   1.267641953997003e-18,  -1.396223131990077e-20,   1.512554449141368e-22,  -1.005123821634769e-05,   1.970821662138235e-07,  -2.898434479059599e-09,
   3.789075957145709e-11,  -4.643824996927097e-13,   5.463689629965780e-15,  -6.249398317833584e-17,   7.000396572929740e-19,  -7.710719807667048e-21,   8.353381679909611e-23,
  -3.811504296595292e-06,   7.473532721872017e-08,  -1.099118340335104e-09,   1.436869153389981e-11,  -1.761015933726783e-13,   2.071941912825120e-15,  -2.369924108393554e-17,
   2.654752433842824e-19,  -2.924163033580328e-21,   3.167912627720564e-23,  -4.345627913264782e-07,   8.520838956288333e-09,  -1.253144815968163e-10,   1.638228648469255e-12,
  -2.007803308869350e-14,   2.362305917572109e-16,  -2.702052459422961e-18,   3.026803441300942e-20,  -3.333977377512397e-22,   3.611893686530047e-24,  -4.093624884104038e-04,
   8.025958476756156e-06,  -1.180215194613338e-07,   1.542645690755535e-09,  -1.890300812847088e-11,   2.223567575851709e-13,  -2.542721540648205e-15,   2.847518040980300e-17,
  -3.135508339881970e-19,   3.395660707945579e-21,  -3.785090859236998e-04,   7.421148390741916e-06,  -1.091297932510308e-07,   1.426455493444518e-09,  -1.747973485502174e-11,
   2.056213009825467e-13,  -2.351431441199369e-15,   2.633403103650291e-17,  -2.899856848441732e-19,   3.140558882636097e-21,  -3.214963008070716e-04,   6.303482362807127e-06,
  -9.269701873206494e-08,   1.211705057392379e-09,  -1.484885767637394e-11,   1.746823571594037e-13,  -1.997740682335112e-15,   2.237446181716855e-17,  -2.464001264252217e-19,
   2.668666743260416e-21,  -2.470002806749306e-04,   4.842976477946763e-06,  -7.122154447514930e-08,   9.310216805698441e-10,  -1.140976288258351e-11,   1.342322106538291e-13,
  -1.535232801138645e-15,   1.719562315410437e-17,  -1.893813123063440e-19,   2.051232732507087e-21,  -1.663611910445452e-04,   3.261933331359803e-06,  -4.797168476757664e-08,
   6.271146650298142e-10,  -7.685640610525890e-12,   9.042305614450220e-14,  -1.034232696678269e-15,   1.158472423072835e-17,  -1.275936876809296e-19,   1.382057705184640e-21,
  -9.185709724784454e-05,   1.801110999210187e-06,  -2.648845564644446e-08,   3.462792438699276e-10,  -4.243937485332615e-12,   4.993200936250789e-14,  -5.711242244846824e-16,
   6.397521106270896e-18,  -7.046431403632014e-20,   7.632683717353957e-22,  -3.483289454462368e-05,   6.829974648094886e-07,  -1.004471469632438e-08,   1.313138004094585e-10,
  -1.609371916035068e-12,   1.893523057870733e-14,  -2.165842208957132e-16,   2.426124630771663e-18,  -2.672242511497428e-20,   2.894596642717213e-22,  -3.971418816663550e-06,
   7.787095637064478e-08,  -1.145234474546134e-09,   1.497158104218467e-11,  -1.834908018890791e-13,   2.158883266332037e-15,  -2.469369902913709e-17,   2.766134527334242e-19,
  -3.046750782726693e-21,   3.300272526476217e-23,  -1.175611101466007e-03,   2.304902415746120e-05,  -3.389353257274302e-07,   4.430184570942584e-09,  -5.428583417307522e-11,
   6.385658432655987e-13,  -7.302183307194794e-15,   8.177360693112035e-17,  -9.003719119346980e-19,   9.747796892582452e-21,  -1.087006005717685e-03,   2.131212477981755e-05,
  -3.133999815522135e-07,   4.096508456724797e-09,  -5.019846475882048e-11,   5.905048289954543e-13,  -6.752836628049549e-15,   7.562475471029208e-17,  -8.327034872920025e-19,
   9.015472628677370e-21,  -9.232761452488445e-04,   1.810240081320156e-05,  -2.662081828886286e-07,   3.479786111174379e-09,  -4.264308723774525e-11,   5.016541307168202e-13,
  -5.737107991359466e-15,   6.425385333846773e-17,  -7.075457014433943e-19,   7.660813262842363e-21,  -7.093377635899383e-04,   1.390810607322932e-05,  -2.045347110019810e-07,
   2.673716919169848e-09,  -3.276666288058783e-11,   3.854890885243405e-13,  -4.408878596259642e-15,   4.938151832268121e-17,  -5.438140481055388e-19,   5.888360339511518e-21,
  -4.777576563121319e-04,   9.367651274566768e-06,  -1.377655420485794e-07,   1.800953860729683e-09,  -2.207169398409512e-11,   2.596776228255125e-13,  -2.970107399844472e-15,
   3.326841979470961e-17,  -3.663888740501452e-19,   3.967388731402604e-21,  -2.637960886263094e-04,   5.172447758259307e-06,  -7.606979967099319e-08,   9.944480266395555e-10,
  -1.218777902617736e-11,   1.433951253143215e-13,  -1.640153391004484e-15,   1.837207344763869e-17,  -2.023402084200569e-19,   2.191065431488669e-21,  -1.000334390233522e-04,
   1.961438638317943e-06,  -2.884650750876262e-08,   3.771082211759946e-10,  -4.621809192322404e-12,   5.437833955068957e-14,  -6.219861239837378e-16,   6.967220289947764e-18,
  -7.673416770981173e-20,   8.309328856283614e-22,  -1.140515846376093e-05,   2.236305557455550e-07,  -3.288895291507931e-09,   4.299552885829924e-11,  -5.269505863821503e-13,
   6.199897424205127e-15,  -7.091531447063766e-17,   7.943643242253312e-19,  -8.748827263730733e-21,   9.473875348228373e-23,  -2.443739584902844e-03,   4.791194354112305e-05,
  -7.045439343026508e-07,   9.209012378435385e-09,  -1.128437957135695e-10,   1.327383447805754e-12,  -1.517891581504222e-14,   1.699759153154632e-16,  -1.871258466611963e-18,
   2.024721803288833e-20,  -2.259556414435718e-03,   4.430145555037965e-05,  -6.514636842220528e-07,   8.515400764696271e-09,  -1.043473934709790e-10,   1.227479265066395e-12,
  -1.403699844008965e-14,   1.571947899902275e-16,  -1.730620830321289e-18,   1.872604995204230e-20,  -1.919211600781378e-03,   3.762941111061302e-05,  -5.533662214446760e-07,
   7.233421734867707e-09,  -8.864205347697004e-11,   1.042785779977237e-12,  -1.192562125872467e-14,   1.335590246697731e-16,  -1.470501769996472e-18,   1.591221227569598e-20,
  -1.474498471296621e-03,   2.891074209435021e-05,  -4.251657441619435e-07,   5.557847941006664e-09,  -6.811196064471640e-11,   8.013141161519313e-13,  -9.164654682844219e-15,
   1.026451386487552e-16,  -1.130214714136915e-18,   1.223060519791682e-20,  -9.931135349642885e-04,   1.947251110989763e-05,  -2.863728553327819e-07,   3.743637792679224e-09,
  -4.588036187899803e-11,   5.397904884745035e-13,  -6.173907263326756e-15,   6.915220445793649e-17,  -7.614693047419080e-19,   8.240558589692211e-21,  -5.483522087488274e-04,
   1.075195302279018e-05,  -1.581260844497123e-07,   2.067156353257170e-09,  -2.533469847430268e-11,   2.980746804052963e-13,  -3.409356408152966e-15,   3.818844520476461e-17,
  -4.205252520254444e-19,   4.550994136327491e-21,  -2.079392364111236e-04,   4.077237138374422e-06,  -5.996315623449837e-08,   7.838938128157406e-10,  -9.607340436408131e-12,
   1.130359635511264e-13,  -1.292910998780760e-15,   1.448215951161383e-17,  -1.594771935647586e-19,   1.725903512667285e-21,  -2.370787174025553e-05,   4.648602252186605e-07,
  -6.836617644046159e-09,   8.937468651708146e-11,  -1.095370549863554e-12,   1.288769360890622e-14,  -1.474103462951671e-16,   1.651176550856156e-18,  -1.818275239182271e-20,
   1.967787381546534e-22,  -4.498037725782117e-03,   8.818850046048832e-05,  -1.296809694267398e-06,   1.695044908397862e-08,  -2.077044034144455e-10,   2.443225098893067e-12,
  -2.793844879775808e-14,   3.128385582068928e-16,  -3.442990091137457e-18,   3.720752012699629e-20,  -4.159023350300358e-03,   8.154290234223302e-05,  -1.199108217409717e-06,
   1.567376186882814e-08,  -1.920656154821412e-10,   2.259338191239696e-12,  -2.583662383735559e-14,   2.893149639216538e-16,  -3.184221616491139e-18,   3.441192123784641e-20,
  -3.532572061852978e-03,   6.926208986278411e-05,  -1.018546389344415e-06,   1.331410380670028e-08,  -1.631577938975255e-10,   1.919385333242833e-12,  -2.195040205584230e-14,
   2.458135168558806e-16,  -2.705614178287857e-18,   2.924078242784550e-20,  -2.714016579946765e-03,   5.321418427326322e-05,  -7.825758363892663e-07,   1.022998065345213e-08,
  -1.253693565574171e-10,   1.474924729268753e-12,  -1.686854118727429e-14,   1.889168366218012e-16,  -2.079505909699236e-18,   2.247510747415947e-20,  -1.827961610087141e-03,
   3.584182623475694e-05,  -5.271084979291859e-07,   6.890678296700747e-09,  -8.444906564570464e-11,   9.935558512268885e-13,  -1.136374514147380e-14,   1.272735380263389e-16,
  -1.401040613673340e-18,   1.514282326133703e-20,  -1.009317415491013e-03,   1.979044355151885e-05,  -2.910527352872166e-07,   3.804884501688344e-09,  -4.663196898285867e-11,
   5.486459037543787e-13,  -6.275289499099344e-15,   7.028521118976165e-17,  -7.737308179282531e-19,   8.362851402370147e-21,  -3.827406716433602e-04,   7.504713912169530e-06,
  -1.103704091526375e-07,   1.442863968415714e-09,  -1.768362080548969e-11,   2.080576522079744e-13,  -2.379742594488239e-15,   2.665417606825063e-17,  -2.934243890584308e-19,
   3.171493517504926e-21,  -4.363758812290516e-05,   8.556389734062527e-07,  -1.258373197771699e-08,   1.645063562877524e-10,  -2.016178938602766e-12,   2.372150587329686e-14,
  -2.713246922678684e-16,   3.038963199649554e-18,  -3.345470599080388e-20,   3.615974473321852e-22,  -4.147515258046925e-05,   7.824817152050527e-07,  -1.107222211742827e-08,
   1.392632858286620e-10,  -1.642099744575866e-12,   1.858750947188734e-14,  -2.045455799963595e-16,   2.204751551599104e-18,  -2.338481789926300e-20,   2.446180318586974e-22,
  -3.834915654824167e-05,   7.235149743084273e-07,  -1.023800771059311e-08,   1.287734917477986e-10,  -1.518449570987611e-12,   1.718837734297141e-14,  -1.891552610200311e-16,
   2.038939557938265e-18,  -2.162700563795784e-20,   2.262395387296351e-22,  -3.257277533730026e-05,   6.145475673219791e-07,  -8.696319289990696e-09,   1.093859524055226e-10,
  -1.289892510051676e-12,   1.460189093184405e-14,  -1.607003020929201e-16,   1.732325466825901e-18,  -1.837598354286463e-20,   1.922434924419899e-22,  -2.502507929452556e-05,
   4.721562976476545e-07,  -6.681570265307735e-09,   8.404668556513844e-11,  -9.911325298270445e-13,   1.122043434042514e-14,  -1.234931236473978e-16,   1.331324976798906e-18,
  -1.412329438187365e-20,   1.477636992709389e-22,  -1.685502619962411e-05,   3.180147762491482e-07,  -4.500389586574233e-09,   5.661150955975772e-11,  -6.676224949375735e-13,
   7.558341250289394e-15,  -8.319163915070476e-17,   8.968987481561157e-19,  -9.515236908799243e-21,   9.955784510071880e-23,  -9.306572807957300e-06,   1.755949413261288e-07,
  -2.484966948624802e-09,   3.125953384829785e-11,  -3.686527093996388e-13,   4.173718163674034e-15,  -4.593967218988580e-17,   4.952957180266958e-19,  -5.254782654124762e-21,
   5.498251037943127e-23,  -3.529120569936493e-06,   6.658713844706592e-08,  -9.423259435048082e-10,   1.185402266792391e-11,  -1.397989648201602e-13,   1.582754139408669e-15,
  -1.742138110989883e-17,   1.878296389852482e-19,  -1.992780952017226e-21,   2.085137018145813e-23,  -4.023672255791204e-07,   7.591834379895587e-09,  -1.074379919903698e-10,
   1.351521440904429e-12,  -1.593902251140800e-14,   1.804562044320613e-16,  -1.986285458758020e-18,   2.141529253383217e-20,  -2.272062751900861e-22,   2.377366965315196e-24,
  -3.790365964824250e-04,   7.151009404094303e-06,  -1.011877503847194e-07,   1.272710973539811e-09,  -1.500695846911526e-11,   1.698690754929079e-13,  -1.869317426443867e-15,
   2.014891795704577e-17,  -2.137085429963154e-19,   2.235417783844919e-21,  -3.504684822512773e-04,   6.612119216008300e-06,  -9.356396192822384e-08,   1.176845965341869e-09,
  -1.387693392171506e-11,   1.570825705315661e-13,  -1.728667151336377e-15,   1.863358501498468e-17,  -1.976442866170083e-19,   2.067467331545268e-21,  -2.976788060726945e-04,
   5.616278754872606e-06,  -7.947465072935282e-08,   9.996654979633905e-10,  -1.178817753906690e-11,   1.334449736195836e-13,  -1.468620704045925e-15,   1.583148123171927e-17,
  -1.679339222291493e-19,   1.756797308226442e-21,  -2.287012896238607e-04,   4.314981499338294e-06,  -6.106209368022650e-08,   7.680928851402565e-10,  -9.057844847131417e-12,
   1.025422372200121e-13,  -1.128588778368531e-15,   1.216679338186547e-17,  -1.290695555622774e-19,   1.350322848765412e-21,  -1.540361244466166e-04,   2.906300059679069e-06,
  -4.112853709847141e-08,   5.173660022074702e-10,  -6.101324286388867e-12,   6.907479671906476e-14,  -7.602783652412228e-16,   8.196632525408993e-18,  -8.695756722347223e-20,
   9.097985323441071e-22,  -8.505168667432729e-05,   1.604741749658954e-06,  -2.270982397609599e-08,   2.856772444979980e-10,  -3.369074208982705e-12,   3.814312216191149e-14,
  -4.198371276052425e-16,   4.526438428956911e-18,  -4.802225140897357e-20,   5.024516088084498e-22,  -3.225222250381163e-05,   6.085321151585275e-07,  -8.611807218177695e-09,
   1.083325345930914e-10,  -1.277606470272313e-12,   1.446460496827077e-14,  -1.592119022942291e-16,   1.716548846625188e-18,  -1.821156703405168e-20,   1.905479361814434e-22,
  -3.677187285174755e-06,   6.938089157868973e-08,  -9.818633152430490e-10,   1.235139727260982e-11,  -1.456648718146553e-13,   1.649168146936911e-15,  -1.815242341378261e-17,
   1.957113684500904e-19,  -2.076385915615599e-21,   2.172530440146462e-23,  -1.088520915578364e-03,   2.053633706080834e-05,  -2.905919473012131e-07,   3.654983512654500e-09,
  -4.309712563955223e-11,   4.878315543038670e-13,  -5.368318184544258e-15,   5.786353107701661e-17,  -6.137134672485923e-19,   6.418928427578143e-21,  -1.006478732454553e-03,
   1.898874707512478e-05,  -2.686978788493708e-07,   3.379677467737206e-09,  -3.985191042494822e-11,   4.511111528916248e-13,  -4.964397771356709e-15,   5.351180665063967e-17,
  -5.675811835066198e-19,   5.936661610817972e-21,  -8.548768365419447e-04,   1.612888293385051e-05,  -2.282360604782933e-07,   2.870848911567318e-09,  -3.385340003352862e-11,
   3.832284869572076e-13,  -4.217594633918627e-15,   4.546474182977128e-17,  -4.822609324216260e-19,   5.044579600114814e-21,  -6.567865464327459e-04,   1.239180505493426e-05,
  -1.753587034131029e-07,   2.205816473350545e-09,  -2.601240471539754e-11,   2.944817276212136e-13,  -3.241088681703305e-15,   3.494051444923711e-17,  -3.706528853685794e-19,
   3.877399954742417e-21,  -4.423624124182570e-04,   8.346340251101060e-06,  -1.181133253737714e-07,   1.485776619576600e-09,  -1.752184093414930e-11,   1.983696280275640e-13,
  -2.183372400893886e-15,   2.353903280051323e-17,  -2.497185986320088e-19,   2.612449776508488e-21,  -2.442522455863012e-04,   4.608512673422712e-06,  -6.521828923906414e-08,
   8.204106354218668e-10,  -9.675339255868289e-12,   1.095397642915684e-13,  -1.205691015561553e-15,   1.299899445864285e-17,  -1.379068976537537e-19,   1.442769009713560e-21,
  -9.262224042504362e-05,   1.747588336558675e-06,  -2.473147016098391e-08,   3.111104060748089e-10,  -3.669042374336483e-12,   4.153958377493120e-14,  -4.572257842616707e-16,
   4.929573029247787e-18,  -5.229868568277841e-20,   5.471504433722495e-22,  -1.056018154330660e-05,   1.992487066543289e-07,  -2.819724439701922e-09,   3.547086048991981e-11,
  -4.183217599265474e-13,   4.736096045945482e-15,  -5.213024849481733e-17,   5.620425449990389e-19,  -5.962817674528445e-21,   6.238330317853876e-23,  -2.262705453436775e-03,
   4.268882774310975e-05,  -6.040526867322337e-07,   7.597604208401711e-09,  -8.958587372456113e-11,   1.014053815601338e-12,  -1.115908710047897e-14,   1.202794954380011e-16,
  -1.275658571870707e-18,   1.333998510273168e-20,  -2.092164591511779e-03,   3.947185666787438e-05,  -5.585415464720073e-07,   7.025326287389716e-09,  -8.284005398104752e-11,
   9.377232391981564e-13,  -1.031946036004124e-14,   1.112336685248452e-16,  -1.179768240795511e-18,   1.233771507046456e-20,  -1.777030144645808e-03,   3.352706489053932e-05,
  -4.744336751959321e-07,   5.967625762355313e-09,  -7.037096730206626e-11,   7.966157677723392e-13,  -8.767085574582324e-15,   9.450642748945793e-17,  -1.002422140914425e-18,
   1.048375376450876e-20,  -1.365260399766985e-03,   2.575881131331529e-05,  -3.645176575659028e-07,   4.585224655993648e-09,  -5.407191240228719e-11,   6.121381760999485e-13,
  -6.737229134153875e-15,   7.262997261015734e-17,  -7.704346424760066e-19,   8.058083910643504e-21,  -9.195375381853612e-04,   1.734951467778281e-05,  -2.455218466746789e-07,
   3.088479785832826e-09,  -3.642260138046336e-11,   4.123502774432711e-13,  -4.538561402599149e-15,   4.892999533136366e-17,  -5.190619411681562e-19,   5.429234786111895e-21,
  -5.077264756172649e-04,   9.579702703797621e-06,  -1.355690796126865e-07,   1.705385338655915e-09,  -2.011210044731465e-11,   2.276999387511821e-13,  -2.506261721865546e-15,
   2.702068187445019e-17,  -2.866514987938394e-19,   2.998383521124697e-21,  -1.925335981329449e-04,   3.632707100797014e-06,  -5.140923943744275e-08,   6.467043481797040e-10,
  -7.626828044256180e-12,   8.634819272208355e-14,  -9.504321288767965e-16,   1.024697897609037e-17,  -1.087073670114715e-19,   1.137095710972168e-21,  -2.195142052426743e-05,
   4.141777421753213e-07,  -5.861353487061179e-09,   7.373318045481540e-11,  -8.695642635308632e-13,   9.844906880052801e-15,  -1.083627930493059e-16,   1.168303643361029e-18,
  -1.239423504544002e-20,   1.296458484640097e-22,  -4.164819588338330e-03,   7.857463980056388e-05,  -1.111841780496377e-06,   1.398443199928482e-08,  -1.648950688929881e-10,
   1.866503939777233e-12,  -2.053975021640733e-14,   2.213861242041597e-16,  -2.347774292278502e-18,   2.454250196322542e-20,  -3.850915751991177e-03,   7.265336351236708e-05,
  -1.028072287647561e-06,   1.293107603925172e-08,  -1.524784637989857e-10,   1.726007130025047e-12,  -1.899430776799323e-14,   2.047363811171633e-16,  -2.171292889406229e-18,
   2.269851475938478e-20,  -3.270867599778439e-03,   6.171115925683379e-05,  -8.732602200745245e-07,   1.098423323631272e-08,  -1.295274021266555e-10,   1.466279635464963e-12,
  -1.613695982797010e-14,   1.739482429060549e-16,  -1.844896726928027e-18,   1.928760146062858e-20,  -2.512948933541230e-03,   4.741262357477109e-05,  -6.709447210585031e-07,
   8.439734504903293e-09,  -9.952675948311175e-11,   1.126723539798177e-12,  -1.240074502934093e-14,   1.336824862712667e-16,  -1.417936863741991e-18,   1.482490164787847e-20,
  -1.692534901274790e-03,   3.193416026139360e-05,  -4.519166177850490e-07,   5.684770402845217e-09,  -6.704078558655175e-11,   7.589867463739170e-13,  -8.353811395545110e-15,
   9.006037601406343e-17,  -9.553005455855213e-19,   9.988437853735961e-21,  -9.345401841661729e-04,   1.763275613647397e-05,  -2.495334764071067e-07,   3.138995483411135e-09,
  -3.701907503332142e-11,   4.191126931778187e-13,  -4.613099969043353e-15,   4.973416784815822e-17,  -5.275637060882255e-19,   5.516269844192561e-21,  -3.543844823900281e-04,
   6.686495437712668e-06,  -9.462575295861493e-08,   1.190348000537301e-09,  -1.403822143524591e-11,   1.589355876583934e-13,  -1.749393674676927e-15,   1.886055138740818e-17,
  -2.000689144551141e-19,   2.091968330402943e-21,  -4.040459886303461e-05,   7.623509153407339e-07,  -1.078862463516071e-08,   1.357160256839445e-10,  -1.600552105354775e-12,
   1.812088951602755e-14,  -1.994557831334728e-16,   2.150375330879091e-18,  -2.281079164533152e-20,   2.385155287067947e-22,  -3.851239264354431e-05,   7.001685433280441e-07,
  -9.547246605072427e-09,   1.157165296957484e-10,  -1.314844971577747e-12,   1.434214485712740e-14,  -1.520920188298087e-16,   1.579877652460101e-18,  -1.615276378656023e-20,
   1.630205876135712e-22,  -3.560966853572552e-05,   6.474036367251753e-07,  -8.827901782965180e-09,   1.069998747064634e-10,  -1.215829392040330e-12,   1.326246087907285e-14,
  -1.406468653022659e-16,   1.461040925475926e-18,  -1.493834933422459e-20,   1.507704202418614e-22,  -3.024588052142946e-05,   5.498975986663659e-07,  -7.498516740214682e-09,
   9.088979472160986e-11,  -1.032811984632640e-12,   1.126658557291627e-14,  -1.194869901023453e-16,   1.241303696290129e-18,  -1.269246360558380e-20,   1.281117239012079e-22,
  -2.323733103461327e-05,   4.224844566095041e-07,  -5.761242361552283e-09,   6.983461402771409e-11,  -7.935872563894371e-13,   8.657380462765414e-15,  -9.182026246220839e-17,
   9.539433629027369e-19,  -9.754832140284978e-21,   9.846773529571495e-23,  -1.565091291237154e-05,   2.845582425921448e-07,  -3.880484200394427e-09,   4.703836159519583e-11,
  -5.345522282853645e-13,   5.831742056140788e-15,  -6.185417270934571e-17,   6.426492754353585e-19,  -6.571950934552461e-21,   6.634267961488613e-23,  -8.641710451054832e-06,
   1.571213667737695e-07,  -2.142670488848912e-09,   2.597337541129886e-11,  -2.951715092946496e-13,   3.220268101981470e-15,  -3.415651088799030e-17,   3.548874284816694e-19,
  -3.629311325559415e-21,   3.663844932110788e-23,  -3.276999012173845e-06,   5.958176524123130e-08,  -8.125227502779227e-10,   9.849429243422900e-12,  -1.119335155274086e-13,
   1.221184490579739e-15,  -1.295289354956857e-17,   1.345824568861399e-19,  -1.376344216038336e-21,   1.389457414613807e-23,  -3.736219592833429e-07,   6.793126480099707e-09,
  -9.263864627932213e-11,   1.122970000014919e-12,  -1.276197051526985e-14,   1.392321277246362e-16,  -1.476813477361627e-18,   1.534433444629766e-20,  -1.569233224328007e-22,
   1.584187399564361e-24,  -3.519602779443807e-04,   6.398758898160694e-06,  -8.725117651758629e-08,   1.057519908507788e-09,  -1.201621527155872e-11,   1.310711918230473e-13,
  -1.389951116242178e-15,   1.443830868631365e-17,  -1.476177356988357e-19,   1.489803410702702e-21,  -3.254326198671563e-04,   5.916546552500426e-06,  -8.067716783770014e-08,
   9.778594121974068e-10,  -1.111132340611769e-11,   1.212040856593697e-13,  -1.285355200332668e-15,   1.335227433407433e-17,  -1.365193786034768e-19,   1.377852187107526e-21,
  -2.764135849341803e-04,   5.025450209200533e-06,  -6.852807252017446e-08,   8.306312646149123e-10,  -9.438748605618212e-12,   1.029640136290515e-13,  -1.091977582668100e-15,
   1.134412262110662e-17,  -1.159945565735560e-19,   1.170780062257820e-21,  -2.123632661654173e-04,   3.861036320219244e-06,  -5.265132399336232e-08,   6.382104167063192e-10,
  -7.252501637288059e-12,   7.911879194270874e-14,  -8.391346043265707e-16,   8.717971649353069e-18,  -8.914797297875757e-20,   8.998711901385109e-22,  -1.430318731351256e-04,
   2.600544689106807e-06,  -3.546329386341182e-08,   4.298781166442225e-10,  -4.885210642675341e-12,   5.329561157004574e-14,  -5.652780259733363e-16,   5.873093058993165e-18,
  -6.006008973494643e-20,   6.062885579514844e-22,  -7.897558690833390e-05,   1.435913900038988e-06,  -1.958161643610873e-08,   2.373676575043318e-10,  -2.697538093209745e-12,
   2.942965519609303e-14,  -3.121523447162982e-16,   3.243272758909552e-18,  -3.316774026022918e-20,   3.348292787558309e-22,  -2.994811290545722e-05,   5.445108240557036e-07,
  -7.425550930185948e-09,   9.001278848987009e-11,  -1.022947379856382e-12,   1.116026285690008e-14,  -1.183749741023445e-16,   1.229932595155523e-18,  -1.257820649458375e-20,
   1.269789045232835e-22,  -3.414487639150410e-06,   6.208159296082766e-08,  -8.466138158165925e-10,   1.026269224273131e-11,  -1.166301642442107e-13,   1.272426202194230e-15,
  -1.349642506237068e-17,   1.402299937202012e-19,  -1.434099064088234e-21,   1.447747716874698e-23,  -1.010762885565367e-03,   1.837601687809145e-05,  -2.505687615004912e-07,
   3.036995765384963e-09,  -3.450828153803003e-11,   3.764114852905668e-13,  -3.991673867231100e-15,   4.146401171211985e-17,  -4.239268317954038e-19,   4.278284298053540e-21,
  -9.345805038999447e-04,   1.699119486124288e-05,  -2.316894606272869e-07,   2.808225991857717e-09,  -3.190960445406687e-11,   3.480750366610073e-13,  -3.691294390112903e-15,
   3.834513225351462e-17,  -3.920546922241211e-19,   3.956792255655033e-21,  -7.938071715061277e-04,   1.443213587729006e-05,  -1.967995727361446e-07,   2.385414792593482e-09,
  -2.710628820059394e-11,   2.956930256456051e-13,  -3.135950838377483e-15,   3.257811119536115e-17,  -3.331117415374042e-19,   3.362140379656515e-21,  -6.098668547232000e-04,
   1.108816095691046e-05,  -1.512045747796560e-07,   1.832818765253429e-09,  -2.082780332038377e-11,   2.272140930001537e-13,  -2.409834142104699e-15,   2.503631671909897e-17,
  -2.560140395307066e-19,   2.584168164060644e-21,  -4.107602984696040e-04,   7.468269059643825e-06,  -1.018438257996645e-07,   1.234528077778765e-09,  -1.402939448068453e-11,
   1.530548399911513e-13,  -1.623370407770884e-15,   1.686637932015308e-17,  -1.724798113029011e-19,   1.741083968843462e-21,  -2.268028442837527e-04,   4.123671243525830e-06,
  -5.623467297977390e-08,   6.816747040595652e-10,  -7.746815604035043e-12,   8.451636136182467e-14,  -8.964418488262372e-16,   9.314047603472386e-18,  -9.525069761053743e-20,
   9.615319640077153e-22,  -8.600527648844733e-05,   1.563731381725660e-06,  -2.132476803516728e-08,   2.584995849918869e-10,  -2.937710034299711e-12,   3.205014813039068e-14,
  -3.399502915863021e-16,   3.532126827275943e-18,  -3.612193424154841e-20,   3.646463387344183e-22,  -9.805758192463758e-06,   1.782865112162285e-07,  -2.431313636846120e-09,
   2.947249752121334e-11,  -3.349396171775565e-13,   3.654165568311363e-15,  -3.875915217619608e-17,   4.027132255965594e-19,  -4.118427538505573e-21,   4.157508704858332e-23,
  -2.101070048881401e-03,   3.819817608211849e-05,  -5.208565999487327e-07,   6.312994794436841e-09,  -7.173226990155726e-11,   7.824454703351390e-13,  -8.297477623876442e-15,
   8.619089045931101e-17,  -8.812030826691926e-19,   8.892680057923103e-21,  -1.942709940239163e-03,   3.531955033895986e-05,  -4.816122488038209e-07,   5.837451691631638e-09,
  -6.633040699342611e-11,   7.235425759658959e-13,  -7.673079906744203e-15,   7.970770121637452e-17,  -8.149514445944901e-19,   8.224436778597788e-21,  -1.650084798776399e-03,
   3.000004142023877e-05,  -4.090867341674210e-07,   4.958555207645088e-09,  -5.634576670790367e-11,   6.146562402670685e-13,  -6.518689312100930e-15,   6.771984220616630e-17,
  -6.924285699940706e-19,   6.988413278261495e-21,  -1.267728564793593e-03,   2.304892988881942e-05,  -3.143085364858742e-07,   3.809875356381238e-09,  -4.329469745776359e-11,
   4.723092800738242e-13,  -5.009313226373287e-15,   5.204277725785290e-17,  -5.321680257557866e-19,   5.371348339678781e-21,  -8.538463102563636e-04,   1.552427049133736e-05,
  -2.117024824404013e-07,   2.566210140047272e-09,  -2.916286370581272e-11,   3.181546545085020e-13,  -3.374493991405941e-15,   3.505999777730981e-17,  -3.585281248702566e-19,
   3.618946072876185e-21,  -4.714544528009223e-04,   8.571864148249673e-06,  -1.168948610832527e-07,   1.416995343607646e-09,  -1.610328428062031e-11,   1.756839165913457e-13,
  -1.863430313417843e-15,   1.936103055398584e-17,  -1.979944911488622e-19,   1.998600691629189e-21,  -1.787789332752985e-04,   3.250524151155711e-06,  -4.432773705289911e-08,
   5.373423805756119e-10,  -6.106609765070303e-12,   6.662255047000861e-14,  -7.066533973749338e-16,   7.342201597490234e-18,  -7.508547494208459e-20,   7.579387861261728e-22,
  -2.038320276593344e-05,   3.706036837951717e-07,  -5.053965014273847e-09,   6.126440001848078e-11,  -6.962380606256570e-13,   7.595903426296143e-15,  -8.056850439570488e-17,
   8.371165111689557e-19,  -8.560839649647684e-21,   8.641625396397913e-23,  -3.867307467164734e-03,   7.030897978465452e-05,  -9.587079778920164e-07,   1.161993236470110e-08,
  -1.320330743520658e-10,   1.440197950973923e-12,  -1.527263053438505e-14,   1.586452669586253e-16,  -1.621928399275951e-18,   1.636601689528763e-20,  -3.575823977131066e-03,
   6.501047446470573e-05,  -8.864733694914229e-07,   1.074463009191254e-08,  -1.220902052827049e-10,   1.331779113334015e-12,  -1.412334197449206e-14,   1.467121314199186e-16,
  -1.499986512287491e-18,   1.513617938622579e-20,  -3.037207287382144e-03,   5.521918903194700e-05,  -7.529802170769051e-07,   9.126900625508306e-09,  -1.037121063340996e-10,
   1.131358912439914e-12,  -1.199852978109140e-14,   1.246469520871783e-16,  -1.274472637747456e-18,   1.286140174729049e-20,  -2.333428220336784e-03,   4.242471530909560e-05,
  -5.785279508357154e-07,   7.012597887209978e-09,  -7.968982459850563e-11,   8.693498542170620e-13,  -9.220318783423494e-15,   9.579132335857507e-17,  -9.794995164406599e-19,
   9.885363468807152e-21,  -1.571621190461243e-03,   2.857454810931665e-05,  -3.896674418146424e-07,   4.723461563087287e-09,  -5.367824767731804e-11,   5.856071729931392e-13,
  -6.211212746138483e-15,   6.453236461173807e-17,  -6.599007296724192e-19,   6.660259033746875e-21,  -8.677765535307775e-04,   1.577769110808485e-05,  -2.151610172657543e-07,
   2.608174185000861e-09,  -2.964030181324238e-11,   3.233702862031399e-13,  -3.429895595191788e-15,   3.563642724556267e-17,  -3.644252374382204e-19,   3.678195929764649e-21,
  -3.290671360506955e-04,   5.983035324559601e-06,  -8.159127705875659e-08,   9.890523154102076e-10,  -1.124005223617036e-11,   1.226279196588841e-13,  -1.300691179384978e-15,
   1.351425124374608e-17,  -1.382010222549311e-19,   1.394899405981674e-21,  -3.751807908707935e-05,   6.821468872243447e-07,  -9.302515470906402e-09,   1.127655269356581e-10,
  -1.281521576010086e-12,   1.398129955243152e-14,  -1.482972322387036e-16,   1.540818879603880e-18,  -1.575693281553738e-20,   1.590391999578102e-22,  -3.585615765535892e-05,
   6.290079082491573e-07,  -8.276011277786995e-09,   9.678948023724214e-11,  -1.061201377434824e-12,   1.116937306032028e-14,  -1.142916722807495e-16,   1.145598675348066e-18,
  -1.130285179636134e-20,   1.101143226622386e-22,  -3.315361014862517e-05,   5.816047435519905e-07,  -7.652427978764881e-09,   8.949819233638066e-11,  -9.812810816372173e-13,
   1.032845874746855e-14,  -1.056900240204850e-16,   1.059415145024228e-18,  -1.045291731064216e-20,   1.018381473729424e-22,  -2.815973399918477e-05,   4.940074184427098e-07,
  -6.500027507091021e-09,   7.602268843167731e-11,  -8.335621891190560e-13,   8.774014021623249e-15,  -8.978786150209103e-17,   9.000636551349097e-19,  -8.881176687007592e-21,
   8.653099782338819e-23,  -2.163455397124729e-05,   3.795431474215002e-07,  -4.994061974753039e-09,   5.841115155049729e-11,  -6.404822895608271e-13,   6.741969439497261e-15,
  -6.899667791988865e-17,   6.916854213539509e-19,  -6.825483728202114e-21,   6.650657470404893e-23,  -1.457138698000309e-05,   2.556351810895678e-07,  -3.363737451801857e-09,
   3.934366388115507e-11,  -4.314189345799644e-13,   4.541445156662612e-15,  -4.647858144008693e-17,   4.659645282051757e-19,  -4.598321502140095e-21,   4.480784311113001e-23,
  -8.045640972840128e-06,   1.411510595315668e-07,  -1.857336653832369e-09,   2.172449116456314e-11,  -2.382218218458195e-13,   2.507755524534768e-15,  -2.566575368268090e-17,
   2.573151144237131e-19,  -2.539359993077377e-21,   2.474529155501112e-23,  -3.050964424694591e-06,   5.352566240670416e-08,  -7.043206506917028e-10,   8.238189191481135e-12,
  -9.033717736836059e-14,   9.509845659758344e-16,  -9.732985202473812e-18,   9.758017096230105e-20,  -9.629976884795118e-22,   9.384230177077951e-24,  -3.478509624819329e-07,
   6.102648421148983e-09,  -8.030212435185122e-11,   9.392663512591220e-13,  -1.029968607726533e-14,   1.084255132610246e-16,  -1.109697750899512e-18,   1.112553539287996e-20,
  -1.097957090592980e-22,   1.069940484981527e-24,  -3.276852552684420e-04,   5.748430129117213e-06,  -7.563350468896233e-08,   8.845478046497471e-10,  -9.698195981449785e-12,
   1.020756011543564e-13,  -1.044498273483723e-15,   1.046949132002059e-17,  -1.032953555408759e-19,   1.006317674692506e-21,  -3.029869878709372e-04,   5.315218119240915e-06,
  -6.993464943278993e-08,   8.179135723965567e-10,  -8.967813692053793e-12,   9.439058306443305e-14,  -9.658888123522359e-16,   9.681870183825687e-18,  -9.552790973453176e-20,
   9.306829797745167e-22,  -2.573485344555643e-04,   4.514676351348215e-06,  -5.940299552943429e-08,   6.947625092204770e-10,  -7.617827911511118e-12,   8.018469352905126e-14,
  -8.205608021857823e-16,   8.225575684123587e-18,  -8.116396740156529e-20,   7.907933003399049e-22,  -1.977156729627306e-04,   3.468600688997203e-06,  -4.564015165110109e-08,
   5.338127216342351e-10,  -5.853293162665028e-12,   6.161407446350176e-14,  -6.305525983512029e-16,   6.321231552472675e-18,  -6.237724513699812e-20,   6.077932009669524e-22,
  -1.331662111722096e-04,   2.336220193364421e-06,  -3.074080541868185e-08,   3.595571691014989e-10,  -3.942687473443105e-12,   4.150373901261049e-14,  -4.247623389060567e-16,
   4.258394906524622e-18,  -4.202348691264904e-20,   4.094918717217185e-22,  -7.352817726104906e-05,   1.289963119266008e-06,  -1.697398369835938e-08,   1.985375985036532e-10,
  -2.177081527043184e-12,   2.291808602898177e-14,  -2.345563316530724e-16,   2.351572503274197e-18,  -2.320689431513227e-20,   2.261433471199920e-22,  -2.788240909498462e-05,
   4.891648044872803e-07,  -6.436704524508758e-09,   7.528785303672713e-11,  -8.255809586623126e-13,   8.690937326994437e-15,  -8.894861741723712e-17,   8.917736813323282e-19,
  -8.800715778346289e-21,   8.576101061091969e-23,  -3.178969496170473e-06,   5.577139427259198e-08,  -7.338717764921475e-10,   8.583845960840950e-12,  -9.412763330999111e-14,
   9.908881533014373e-16,  -1.014139841370223e-17,   1.016749566629987e-19,  -1.003409292149439e-21,   9.778018598954574e-24,  -9.410496437462507e-04,   1.650839651198647e-05,
  -2.172050206648996e-07,   2.540252827872254e-09,  -2.785137175537415e-11,   2.931416830514158e-13,  -2.999599924849982e-15,   3.006637380614695e-17,  -2.966439915094802e-19,
   2.889924880507256e-21,  -8.701209236958741e-04,   1.526429412713397e-05,  -2.008389937463497e-07,   2.348892003702526e-09,  -2.575385292758239e-11,   2.710717749368152e-13,
  -2.773848537371120e-15,   2.780447671628318e-17,  -2.743374091290358e-19,   2.672718431281503e-21,  -7.390559775710227e-04,   1.296529063714823e-05,  -1.705940895452020e-07,
   1.995225605068846e-09,  -2.187695088190565e-11,   2.302751661304786e-13,  -2.356494195689480e-15,   2.362227778950462e-17,  -2.330869825984767e-19,   2.270985655507485e-21,
  -5.678017567565129e-04,   9.961160565503513e-06,  -1.310698231331789e-07,   1.533008468908602e-09,  -1.680954315369136e-11,   1.769438855180728e-13,  -1.810826855796140e-15,
   1.815336616342638e-17,  -1.791352013743923e-19,   1.745449219594512e-21,  -3.824279962794969e-04,   6.709179449884307e-06,  -8.828173841312507e-08,   1.032579709980574e-09,
  -1.132264750527974e-11,   1.191908327435833e-13,  -1.219836461470692e-15,   1.222929443402702e-17,  -1.206832024947451e-19,   1.175971085538798e-21,  -2.111589212646673e-04,
   3.704528398251942e-06,  -4.874604839652302e-08,   5.701621703034073e-10,  -6.252163501903067e-12,   6.581637759840468e-14,  -6.736010690031577e-16,   6.753265754137753e-18,
  -6.664564303094493e-20,   6.494342077886464e-22,  -8.007296856896269e-05,   1.404788154470332e-06,  -1.848498948989479e-08,   2.162123749276033e-10,  -2.370911274332269e-12,
   2.495871653800363e-14,  -2.554434721571006e-16,   2.561003180377779e-18,  -2.527392734167735e-20,   2.462868532610476e-22,  -9.129394941498683e-06,   1.601648223946761e-07,
  -2.107539972315732e-09,   2.465117075792723e-11,  -2.703166354544044e-13,   2.845642030147040e-15,  -2.912416289889199e-17,   2.919909981751712e-19,  -2.881594426201736e-21,
   2.808032939608993e-23,  -1.956157323564777e-03,   3.431595872949306e-05,  -4.515034830574464e-07,   5.280416612377334e-09,  -5.789457026144471e-11,   6.093528056005341e-13,
  -6.235259449628016e-15,   6.249884536554358e-17,  -6.166307384527512e-19,   6.007170545936950e-21,  -1.808717986969020e-03,   3.172984650091490e-05,  -4.174834676134006e-07,
   4.882635390040548e-09,  -5.353446361283323e-11,   5.634761486176019e-13,  -5.765990708549018e-15,   5.779704918592102e-17,  -5.702622720615561e-19,   5.555671842206054e-21,
  -1.536273641520775e-03,   2.695091422702436e-05,  -3.546134678787562e-07,   4.147470013543953e-09,  -4.547555793780409e-11,   4.786723507030432e-13,  -4.898437475272412e-15,
   4.910352957506604e-17,  -4.845154343428105e-19,   4.720605590465192e-21,  -1.180287960569798e-03,   2.070623725420395e-05,  -2.724544832673705e-07,   3.186660515554913e-09,
  -3.494195135822275e-11,   3.678127652066623e-13,  -3.764160395685145e-15,   3.773532576736739e-17,  -3.723664299350525e-19,   3.628193901802237e-21,  -7.949520310960965e-04,
   1.394635299338847e-05,  -1.835110084557817e-07,   2.146420621731217e-09,  -2.353635638717677e-11,   2.477616541877838e-13,  -2.535670420218315e-15,   2.542098271818443e-17,
  -2.508628788228008e-19,   2.444442753850921e-21,  -4.389354727594966e-04,   7.700593060891264e-06,  -1.013282776288169e-07,   1.185194545506203e-09,  -1.299635516358008e-11,
   1.368123219725921e-13,  -1.400212535844312e-15,   1.403798498384161e-17,  -1.385355817669261e-19,   1.349952113244578e-21,  -1.664474610098086e-04,   2.920129298898348e-06,
  -3.842469715209532e-08,   4.494400729860819e-10,  -4.928406778405048e-12,   5.188161499531376e-14,  -5.309895846672659e-16,   5.323546483601698e-18,  -5.253664084352569e-20,
   5.119463170384305e-22,  -1.897724832393998e-05,   3.329341787508797e-07,  -4.380937582703920e-09,   5.124232129795736e-11,  -5.619064504485696e-13,   5.915228212846822e-15,
  -6.054031066245725e-17,   6.069604533345474e-19,  -5.989939326164836e-21,   5.836942156542929e-23,  -3.600575729686706e-03,   6.316322652256558e-05,  -8.310540585502764e-07,
   9.719330679768744e-09,  -1.065628930841886e-10,   1.121597339970742e-12,  -1.147684719614664e-14,   1.150375321798681e-16,  -1.134984835968578e-18,   1.105661703981159e-20,
  -3.329193417766938e-03,   5.840313242774176e-05,  -7.684355562182080e-07,   8.987159807281493e-09,  -9.853751908738093e-11,   1.037155066043454e-12,  -1.061309393235507e-14,
   1.063832432045728e-16,  -1.049637928788716e-18,   1.022560062448720e-20,  -2.827722249730360e-03,   4.960685241903717e-05,  -6.527147026673424e-07,   7.633987146274662e-09,
  -8.370399842954471e-11,   8.810620549033561e-13,  -9.016243624148377e-15,   9.038165013578215e-17,  -8.918102700821198e-19,   8.688600966340157e-21,  -2.172481800760593e-03,
   3.811266834847767e-05,  -5.014898280654178e-07,   5.865485545589806e-09,  -6.431545151184860e-11,   6.770097963161000e-13,  -6.928451629888954e-15,   6.945694139708041e-17,
  -6.853861915565770e-19,   6.677939996148415e-21,  -1.463218195668283e-03,   2.567017463300293e-05,  -3.377771691437738e-07,   3.950781412087794e-09,  -4.332189042417917e-11,
   4.560392756059533e-13,  -4.667247934513663e-15,   4.679073670683993e-17,  -4.617439486305457e-19,   4.499163809435464e-21,  -8.079209126372011e-04,   1.417399722669286e-05,
  -1.865085863768173e-07,   2.181513042075700e-09,  -2.392157329029447e-11,   2.518218261165137e-13,  -2.577282524002631e-15,   2.583879873799919e-17,  -2.549917518817045e-19,
   2.484678753250506e-21,  -3.063693707864718e-04,   5.374898304180636e-06,  -7.072592286672981e-08,   8.272560691133558e-10,  -9.071408288667821e-12,   9.549522178308962e-14,
  -9.773588948483628e-16,   9.798703024452383e-18,  -9.670013862147313e-20,   9.422720018810313e-22,  -3.493022718995696e-05,   6.128109989674017e-07,  -8.063716216989801e-09,
   9.431851727760968e-11,  -1.034265851265662e-12,   1.088778809469196e-14,  -1.114327151200362e-16,   1.117192316510124e-18,  -1.102521883722093e-20,   1.074328879241322e-22,
  -3.346557247728891e-05,   5.671731267853543e-07,  -7.209495702898299e-09,   8.145853652617554e-11,  -8.628423844734988e-13,   8.773813311100881e-15,  -8.673634699475637e-17,
   8.399405067635340e-19,  -8.006507613460011e-21,   7.536670293004939e-23,  -3.094318534315481e-05,   5.244291758045578e-07,  -6.666256296355598e-09,   7.532187512147971e-11,
  -7.978566531073488e-13,   8.113199426022503e-15,  -8.020782350615079e-17,   7.767431851377994e-19,  -7.404348256172645e-21,   6.970106982700803e-23,  -2.628223045496025e-05,
   4.454421746493458e-07,  -5.662343533013006e-09,   6.398047784170391e-11,  -6.777441942802648e-13,   6.892076605581121e-15,  -6.813874282491474e-17,   6.598978360158744e-19,
  -6.290865044037543e-21,   5.922288843844981e-23,  -2.019208025844062e-05,   3.422298699506128e-07,  -4.350439216371543e-09,   4.915834586059229e-11,  -5.207521320336890e-13,
   5.295822184659279e-15,  -5.235980751463592e-17,   5.071119332382080e-19,  -4.834630116845948e-21,   4.551669287425647e-23,  -1.359983297077233e-05,   2.305029614926381e-07,
  -2.930217234713384e-09,   3.311113890143034e-11,  -3.507680991117605e-13,   3.567275330367516e-15,  -3.527097859330649e-17,   3.416186377131142e-19,  -3.257026176176777e-21,
   3.066556065739861e-23,  -7.509189771318246e-06,   1.272739514149368e-07,  -1.617959030883764e-09,   1.828300912758008e-11,  -1.936870890202550e-13,   1.969814863507244e-15,
  -1.947671263305566e-17,   1.886471464343616e-19,  -1.798629158856854e-21,   1.693495740551002e-23,  -2.847537685337733e-06,   4.826332597957058e-08,  -6.135458160384213e-10,
   6.933130152481996e-12,  -7.344884780072005e-14,   7.469865866288139e-16,  -7.385953469927384e-18,   7.153936937609546e-20,  -6.820887542082814e-22,   6.422264401939194e-24,
  -3.246575675733087e-07,   5.502670600331923e-09,  -6.995255138079754e-11,   7.904716119517510e-13,  -8.374181113806697e-15,   8.516686785781631e-17,  -8.421026280484638e-19,
   8.156507102348400e-21,  -7.776796389716535e-23,   7.322321920744835e-25,  -3.058379753159665e-04,   5.183329251796583e-06,  -6.588674287039497e-08,   7.444400928747285e-10,
  -7.885416214961104e-12,   8.018285951080523e-14,  -7.926733837509757e-16,   7.676118297022018e-18,  -7.317052494283823e-20,   6.887667306402586e-22,  -2.827861726136477e-04,
   4.792697254276063e-06,  -6.092214110476001e-08,   6.883578579012678e-10,  -7.291519172952152e-12,   7.414558604002103e-14,  -7.330099671359385e-16,   7.098565346550613e-18,
  -6.766746181964460e-20,   6.369892259385687e-22,  -2.401902478909530e-04,   4.070844235745366e-06,  -5.174749910087168e-08,   5.847101470002033e-10,  -6.193825379159630e-12,
   6.298588659254723e-14,  -6.227120429544009e-16,   6.030729331496665e-18,  -5.749147052216800e-20,   5.412304526402593e-22,  -1.845330734398739e-04,   3.127598985177018e-06,
  -3.975815810627622e-08,   4.492524064222565e-10,  -4.759093178310915e-12,   4.839790307391458e-14,  -4.785101889580670e-16,   4.634436790478395e-18,  -4.418311193032374e-20,
   4.159712694420085e-22,  -1.242872920592957e-04,   2.106539760976176e-06,  -2.677891456684591e-08,   3.025988480782651e-10,  -3.205628868251589e-12,   3.260091439177472e-14,
  -3.223373696711485e-16,   3.122012870877690e-18,  -2.976557635895117e-20,   2.802486583755508e-22,  -6.862561211172767e-05,   1.163141841892028e-06,  -1.478633943839014e-08,
   1.670862943699873e-10,  -1.770083783396964e-12,   1.800190896003071e-14,  -1.779954106810228e-16,   1.724024260157820e-18,  -1.643745878363334e-20,   1.547664211223176e-22,
  -2.602331577954102e-05,   4.410729238121611e-07,  -5.607123866413837e-09,   6.336107024174273e-11,  -6.712404789543381e-13,   6.826623545167684e-15,  -6.749936942172510e-17,
   6.537899495721372e-19,  -6.233528309946311e-21,   5.869225719208020e-23,  -2.967007757151362e-06,   5.028826673675537e-08,  -6.392882326154558e-10,   7.224028141322050e-12,
  -7.653066739634735e-14,   7.783301009595543e-16,  -7.695877940878366e-18,   7.454136671302820e-20,  -7.107122079724791e-22,   6.691776831623802e-24,  -8.783084166524248e-04,
   1.488553441877134e-05,  -1.892141770458280e-07,   2.137890164144096e-09,  -2.264541354477622e-11,   2.302699007944210e-13,  -2.276406955560814e-15,   2.204434773084296e-17,
  -2.101317021803740e-19,   1.978001706479061e-21,  -8.121080296287380e-04,   1.376371371981619e-05,  -1.749567863095335e-07,   1.976832666461320e-09,  -2.093985435134120e-11,
   2.129320012505540e-13,  -2.105064988661252e-15,   2.038572580214435e-17,  -1.943279608123102e-19,   1.829306943183693e-21,  -6.897806464436234e-04,   1.169068933130983e-05,
  -1.486089618333601e-07,   1.679176181013377e-09,  -1.778748683787712e-11,   1.808834699243679e-13,  -1.788310361762126e-15,   1.731910441860472e-17,  -1.651044666158902e-19,
   1.554306677926804e-21,  -5.299438416224694e-04,   8.981868617709367e-06,  -1.141778579301562e-07,   1.290167348723624e-09,  -1.366720921033828e-11,   1.389895597019654e-13,
  -1.374190107143797e-15,   1.330921854196549e-17,  -1.268854150855374e-19,   1.194587087220147e-21,  -3.569294316241785e-04,   6.049580991917995e-06,  -7.690394245035258e-08,
   8.690062601132887e-10,  -9.205955578406875e-12,   9.362361692030611e-14,  -9.256915207812344e-16,   8.965825502693567e-18,  -8.548102058169337e-20,   8.048186213793934e-22,
  -1.970796878752039e-04,   3.340321843416690e-06,  -4.246355073066204e-08,   4.798400149530098e-10,  -5.083343502856781e-12,   5.169805386567100e-14,  -5.111689115199853e-16,
   4.951068849938938e-18,  -4.720522570169570e-20,   4.444584939346096e-22,  -7.473400664113501e-05,   1.266677432524341e-06,  -1.610259183800343e-08,   1.819609262798798e-10,
  -1.927674813786310e-12,   1.960476261386374e-14,  -1.938453304100126e-16,   1.877560036799975e-18,  -1.790149648257388e-20,   1.685525320350757e-22,  -8.520681196266827e-06,
   1.444183244023836e-07,  -1.835914048253255e-09,   2.074603296711481e-11,  -2.197815010382049e-13,   2.235215808162020e-15,  -2.210109538830470e-17,   2.140685878051105e-19,
  -2.041029005911405e-21,   1.921745698920986e-23,  -1.825737306210138e-03,   3.094251972991776e-05,  -3.933189929021627e-07,   4.444026443425244e-09,  -4.707295924862683e-11,
   4.786614118886914e-13,  -4.731960789894904e-15,   4.582351746648313e-17,  -4.367997713828489e-19,   4.111646735294989e-21,  -1.688126742559437e-03,   2.861059410774614e-05,
  -3.636821937290498e-07,   4.109236663005244e-09,  -4.352761801421365e-11,   4.426211676018656e-13,  -4.375792720637422e-15,   4.237574516071465e-17,  -4.039486076245781e-19,
   3.802556765693720e-21,  -1.433845145323522e-03,   2.430140397473554e-05,  -3.089130429712666e-07,   3.490498939910186e-09,  -3.697480027886915e-11,   3.760019733314541e-13,
  -3.717355760449293e-15,   3.600116873400807e-17,  -3.432018669886968e-19,   3.230917153090812e-21,  -1.101592815806233e-03,   1.867058575770905e-05,  -2.373412013516052e-07,
   2.681867343012958e-09,  -2.840999043462050e-11,   2.889172169283707e-13,  -2.856525141784280e-15,   2.766583134148124e-17,  -2.637561050608590e-19,   2.483172614174071e-21,
  -7.419482344076478e-04,   1.257524748080947e-05,  -1.598600150740806e-07,   1.806400938743849e-09,  -1.913639470196497e-11,   1.946151559639858e-13,  -1.924232381291173e-15,
   1.863723367081811e-17,  -1.776889873750983e-19,   1.672965936473505e-21,  -4.096690087764469e-04,   6.943517890352422e-06,  -8.826886689567124e-08,   9.974421281439835e-10,
  -1.056673224715001e-11,   1.074646029167312e-13,  -1.062565389961675e-15,   1.029177145982201e-17,  -9.812527587459309e-20,   9.238900405099682e-22,  -1.553493754361595e-04,
   2.633038918501983e-06,  -3.347241366223545e-08,   3.782416803346772e-10,  -4.007052367284499e-12,   4.075236632774180e-14,  -4.029457473843069e-16,   3.902878223316736e-18,
  -3.721175468760991e-20,   3.503679350140502e-22,  -1.771191672469626e-05,   3.002019763930810e-07,  -3.816309516484754e-09,   4.312472204988833e-11,  -4.568592055682784e-13,
   4.646336975857451e-15,  -4.594148530874181e-17,   4.449837093007489e-19,  -4.242677182708762e-21,   3.994707545216271e-23,  -3.360519808061650e-03,   5.695394956875523e-05,
  -7.239575277504977e-07,   8.179839913776016e-09,  -8.664423479945637e-11,   8.810419432308009e-13,  -8.709822083167394e-15,   8.434443706811024e-17,  -8.039883088748710e-19,
   7.567975781385418e-21,  -3.107228700204165e-03,   5.266172077024404e-05,  -6.694069358721393e-07,   7.563613425594715e-09,  -8.011854822107704e-11,   8.147049332169086e-13,
  -8.054245956985671e-15,   7.799834153469630e-17,  -7.435213490298276e-19,   6.999058577681569e-21,  -2.639188560239748e-03,   4.473006557021941e-05,  -5.685968054305816e-07,
   6.424741821660894e-09,  -6.805718884320636e-11,   6.920831740055389e-13,  -6.842302527607182e-15,   6.626506359052057e-17,  -6.317088533003990e-19,   5.946887399171773e-21,
  -2.027632598262290e-03,   3.436577269547720e-05,  -4.368590189250260e-07,   4.936344509886496e-09,  -5.229248216208582e-11,   5.317917422973167e-13,  -5.257825844301732e-15,
   5.092273759077708e-17,  -4.854783156148850e-19,   4.570574294079916e-21,  -1.365657441408655e-03,   2.314646696804529e-05,  -2.942442734464039e-07,   3.324928572566672e-09,
  -3.522315788513235e-11,   3.582158722251574e-13,  -3.541813300891727e-15,   3.430437155459838e-17,  -3.270602942142219e-19,   3.079292447886194e-21,  -7.540519734462698e-04,
   1.278049658556129e-05,  -1.624709505727092e-07,   1.835928979118454e-09,  -1.944951930950213e-11,   1.978033328157709e-13,  -1.955797162086869e-15,   1.894340962466431e-17,
  -1.806126640836722e-19,   1.700529263984487e-21,  -2.859418228172704e-04,   4.846469100961237e-06,  -6.161056618177770e-08,   6.962056669182211e-10,  -7.375529214589003e-12,
   7.501031652183229e-14,  -7.416768479367054e-16,   7.183779892058191e-18,  -6.849319987106081e-20,   6.448937571580056e-22,  -3.260121091332370e-05,   5.525628931699613e-07,
  -7.024440854733057e-09,   7.937696302755207e-11,  -8.409119993372088e-13,   8.552220119505955e-15,  -8.456159727235059e-17,   8.190532320060022e-19,  -7.809213475286210e-21,
   7.352733212576174e-23  };
  static constexpr double wr[15700] = {   6.345967082162964e-01,  -2.304597573354443e-02,   9.407066271960514e-04,  -3.802202085134721e-05,   1.473954217393659e-06,
  -5.468686781355093e-08,   1.948503483481105e-09,  -6.693882600630125e-11,   2.223959534242595e-12,  -7.164616137958738e-14,   2.244235451178557e-15,  -6.864010624071027e-17,
   2.053712960396286e-18,  -5.994227116892504e-20,   6.346865960008496e-01,  -2.305685428339194e-02,   9.415516364480705e-04,  -3.807443557232093e-05,   1.476766091793068e-06,
  -5.482267723783041e-08,   1.954547243387388e-09,  -6.719040856371561e-11,   2.233863192073879e-12,  -7.201841558721852e-14,   2.257674673392579e-15,  -6.910672133726350e-17,
   2.069342163181156e-18,  -6.044910763765993e-20,   6.348452707360901e-01,  -2.307606184191603e-02,   9.430439715405475e-04,  -3.816702693485542e-05,   1.481734679813333e-06,
  -5.506272264292272e-08,   1.965232955041122e-09,  -6.763536495762588e-11,   2.251385095832827e-12,  -7.267724934222259e-14,   2.281468267170411e-15,  -6.993313808349921e-17,
   2.097032955588435e-18,  -6.134740664881014e-20,   6.350372550826155e-01,  -2.309930862212984e-02,   9.448507429814553e-04,  -3.827916824439517e-05,   1.487754687406155e-06,
  -5.535368414629763e-08,   1.978190793299055e-09,  -6.817517953425758e-11,   2.272652660430325e-12,  -7.347731223560364e-14,   2.310376320639579e-15,  -7.093769602810078e-17,
   2.130709971264606e-18,  -6.244044688986740e-20,   6.352237487552432e-01,  -2.312189799193782e-02,   9.466070571103029e-04,  -3.838822064613019e-05,   1.493611329445720e-06,
  -5.563687488313749e-08,   1.990808413486966e-09,  -6.870107900729749e-11,   2.293382747748474e-12,  -7.425756506297764e-14,   2.338583291968100e-15,  -7.191841799793482e-17,
   2.163605988061854e-18,  -6.350871153373500e-20,   6.353740706677520e-01,  -2.314011132779195e-02,   9.480235935851892e-04,  -3.847620642291841e-05,   1.498338351996930e-06,
  -5.586553398310809e-08,   2.001000562167083e-09,  -6.912607059681799e-11,   2.310142924489075e-12,  -7.488868938834570e-14,   2.361409657547822e-15,  -7.271244081028614e-17,
   2.190252594160521e-18,  -6.437444401726898e-20,   6.354734423710109e-01,  -2.315215403625628e-02,   9.489604354387697e-04,  -3.853441182935806e-05,   1.501466291179613e-06,
  -5.601688498488854e-08,   2.007748870748918e-09,  -6.940755191525629e-11,   2.321247338582080e-12,  -7.530698316521445e-14,   2.376543584648285e-15,  -7.323906477293161e-17,
   2.207931921544256e-18,  -6.494903634795347e-20,   6.355244873850809e-01,  -2.315834091368679e-02,   9.494418022559678e-04,  -3.856432350996656e-05,   1.503074001806566e-06,
  -5.609469057899096e-08,   2.011218636138116e-09,  -6.955230872832821e-11,   2.326959151659526e-12,  -7.552218679742690e-14,   2.384331281624846e-15,  -7.351011504277430e-17,
   2.217033334454432e-18,  -6.524490188322510e-20,   6.355422561222313e-01,  -2.316049469052295e-02,   9.496093867895579e-04,  -3.857473779660962e-05,   1.503633797511651e-06,
  -5.612178421096097e-08,   2.012426986658987e-09,  -6.960272495709462e-11,   2.328948660924777e-12,  -7.559715250512588e-14,   2.387044363275217e-15,  -7.360455279022441e-17,
   2.220204708520692e-18,  -6.534800571738050e-20,   6.355450758735529e-01,  -2.316083648316751e-02,   9.496359820654772e-04,  -3.857639055489866e-05,   1.503722639698653e-06,
  -5.612608419945170e-08,   2.012618766914678e-09,  -6.961072685190320e-11,   2.329264438002597e-12,  -7.560905148043971e-14,   2.387475010820403e-15,  -7.361954333025990e-17,
   2.220708130242903e-18,  -6.536437281945455e-20,   6.796860211897608e-01,  -7.951644399233819e-02,   7.117715864179336e-03,  -5.172817522804027e-04,   3.244092607906660e-05,
  -1.812336393470749e-06,   9.195777791995054e-08,  -4.293450081125884e-09,   1.861823639211999e-10,  -7.550904293202198e-12,   2.879470612056814e-13,  -1.036896951429371e-14,
   3.538455701013778e-16,  -1.146804148739280e-17,   6.803914994176037e-01,  -7.966819543348622e-02,   7.136731851295432e-03,  -5.190559551088118e-04,   3.257638156493209e-05,
  -1.821221732860165e-06,   9.247339962854219e-08,  -4.320434606638261e-09,   1.874732189294637e-10,  -7.607912257507551e-12,   2.902892536219690e-13,  -1.045904759880930e-14,
   3.571051043299648e-16,  -1.157940090349581e-17,   6.816378694663670e-01,  -7.993638216583000e-02,   7.170349268760564e-03,  -5.221934709333545e-04,   3.281599508989252e-05,
  -1.836943991670119e-06,   9.338602367681762e-08,  -4.368208278977188e-09,   1.897591218485370e-10,  -7.708887756265088e-12,   2.944387694957660e-13,  -1.061866616050633e-14,
   3.628821422135240e-16,  -1.177680630218306e-17,   6.831476273150089e-01,  -8.026139185459093e-02,   7.211108119209641e-03,  -5.259991889787444e-04,   3.310676392243506e-05,
  -1.856030608981949e-06,   9.449436718025856e-08,  -4.426248641449499e-09,   1.925372284130204e-10,  -7.831645199325538e-12,   2.994849389422889e-13,  -1.081283222386788e-14,
   3.699114908512668e-16,  -1.201706802552552e-17,   6.846160368347105e-01,  -8.057765625500254e-02,   7.250789772844770e-03,  -5.297061012708366e-04,   3.339011411377997e-05,
  -1.874638430176509e-06,   9.557535805261568e-08,  -4.482878913671697e-09,   1.952488443257206e-10,  -7.951506287513915e-12,   3.044136634703466e-13,  -1.100253810159628e-14,
   3.767814041779563e-16,  -1.225194740902352e-17,   6.858009511661257e-01,  -8.083297357195678e-02,   7.282838412791467e-03,  -5.327012379940551e-04,   3.361915090714686e-05,
  -1.889685313935085e-06,   9.644980526914618e-08,  -4.528704882176608e-09,   1.974438394860481e-10,  -8.048561178814304e-12,   3.084057483865993e-13,  -1.115623506317171e-14,
   3.823487687542537e-16,  -1.244234135756826e-17,   6.865848935446329e-01,  -8.100194694070473e-02,   7.304055614650507e-03,  -5.346847354167671e-04,   3.377087391075827e-05,
  -1.899655835903111e-06,   9.702939884242655e-08,  -4.559086681239463e-09,   1.988994345273035e-10,  -8.112937067606364e-12,   3.110542400432514e-13,  -1.125822378634824e-14,
   3.860438211342083e-16,  -1.256872914954818e-17,   6.869877863746474e-01,  -8.108880465473940e-02,   7.314964058113117e-03,  -5.357047078107034e-04,   3.384890849211292e-05,
  -1.904784790046135e-06,   9.732759757676030e-08,  -4.574720423858903e-09,   1.996485576997874e-10,  -8.146072700211694e-12,   3.124176501844618e-13,  -1.131073268901392e-14,
   3.879464403318129e-16,  -1.263381477361749e-17,   6.871280648435388e-01,  -8.111904930862741e-02,   7.318762816408982e-03,  -5.360599338753873e-04,   3.387608787383979e-05,
  -1.906571342099731e-06,   9.743147597437643e-08,  -4.580166868892300e-09,   1.999095527490668e-10,  -8.157617899235054e-12,   3.128927208391266e-13,  -1.132903006362273e-14,
   3.886094666561533e-16,  -1.265649702711902e-17,   6.871503273804915e-01,  -8.112384933744925e-02,   7.319365720803363e-03,  -5.361163135854068e-04,   3.388040175693696e-05,
  -1.906854908492218e-06,   9.744796420567137e-08,  -4.581031381121968e-09,   1.999509812214106e-10,  -8.159450535106528e-12,   3.129681328630719e-13,  -1.133193461052320e-14,
   3.887147179105701e-16,  -1.266009774715512e-17,   7.203777416077808e-01,  -1.689400510364283e-01,   2.372221024543360e-02,  -2.468080865428681e-03,   2.079151255383321e-04,
  -1.486644522109056e-05,   9.289221472602202e-07,  -5.173273564162577e-08,   2.604544589447112e-09,  -1.198196601273533e-10,   5.079112293599735e-12,  -1.997254819909791e-13,
   7.326129454510789e-15,  -2.516038772558875e-16,   7.228525717095028e-01,  -1.696867451203279e-01,   2.384707714893866e-02,  -2.482940014044928e-03,   2.093087107378878e-04,
  -1.497525696772431e-05,   9.362393051294661e-07,  -5.216632547091596e-08,   2.627560668821021e-09,  -1.209277469969326e-10,   5.127966148389763e-12,  -2.017133129583190e-13,
   7.401258366413674e-15,  -2.542530474248682e-16,   7.272299325369382e-01,  -1.710078593218071e-01,   2.406806492814557e-02,  -2.509244322935239e-03,   2.117762704436266e-04,
  -1.516796555003510e-05,   9.492006380039290e-07,  -5.293450011486975e-08,   2.668343592488166e-09,  -1.228914700270813e-10,   5.214554364102157e-12,  -2.052369237952584e-13,
   7.534444832202440e-15,  -2.589498716768023e-16,   7.325409986106556e-01,  -1.726114500570758e-01,   2.433641069411591e-02,  -2.541197267219618e-03,   2.147746997763331e-04,
  -1.540220239840346e-05,   9.649592851179928e-07,  -5.386868455520918e-08,   2.717950693272672e-09,  -1.252805413391083e-10,   5.319916069071901e-12,  -2.095251732326534e-13,
   7.696556642708293e-15,  -2.646675148399392e-16,   7.377156984403914e-01,  -1.741745785358610e-01,   2.459809771687686e-02,  -2.572369474319269e-03,   2.177008942482322e-04,
  -1.563086863013505e-05,   9.803475376820696e-07,  -5.478114481770461e-08,   2.766415308381177e-09,  -1.276150714725304e-10,   5.422891525661145e-12,  -2.137170066000573e-13,
   7.855048008488281e-15,  -2.702582689099362e-16,   7.418978802846673e-01,  -1.754384057913072e-01,   2.480975848322232e-02,  -2.597591251088780e-03,   2.200692479189908e-04,
  -1.581599449874743e-05,   9.928088490374825e-07,  -5.552021654516877e-08,   2.805678491704166e-09,  -1.295067152073344e-10,   5.506345081092788e-12,  -2.171146650379476e-13,
   7.983529494206591e-15,  -2.747910057551394e-16,   7.446680208214919e-01,  -1.762757734434987e-01,   2.495003689929384e-02,  -2.614311276504822e-03,   2.216396385323416e-04,
  -1.593877180340246e-05,   1.001074850130058e-06,  -5.601054913287235e-08,   2.831731308518193e-09,  -1.307620711807440e-10,   5.561734263008015e-12,  -2.193699813680362e-13,
   8.068822218610405e-15,  -2.778003553303944e-16,   7.460926736770961e-01,  -1.767064996857425e-01,   2.502220567779150e-02,  -2.622914515760752e-03,   2.224477900059612e-04,
  -1.600196308313069e-05,   1.005329687847681e-06,  -5.626296800044896e-08,   2.845144273131920e-09,  -1.314084275490190e-10,   5.590255059171889e-12,  -2.205313571330084e-13,
   8.112746383222933e-15,  -2.793502015053115e-16,   7.465888642786529e-01,  -1.768565291003188e-01,   2.504734525408856e-02,  -2.625911614244051e-03,   2.227293423829524e-04,
  -1.602397958095305e-05,   1.006812193075034e-06,  -5.635092186395072e-08,   2.849818133288164e-09,  -1.316336641535617e-10,   5.600194066123856e-12,  -2.209360887845577e-13,
   8.128054081658860e-15,  -2.798903412570152e-16,   7.466676184286999e-01,  -1.768803419832341e-01,   2.505133553562888e-02,  -2.626387338936638e-03,   2.227740335891817e-04,
  -1.602747435005887e-05,   1.007047520805609e-06,  -5.636488354578423e-08,   2.850560064873182e-09,  -1.316694187518294e-10,   5.601771823552670e-12,  -2.210003380716786e-13,
   8.130484128376974e-15,  -2.799760873225088e-16,   6.441122685214371e-01,  -2.174340681578358e-01,   4.033910863357359e-02,  -5.251391100897752e-03,   5.315295964276764e-04,
  -4.424548745182021e-05,   3.137821241884379e-06,  -1.942295734365063e-07,   1.068026000290313e-08,  -5.287478207688648e-10,   2.381750713436829e-11,  -9.845259878034032e-13,
   3.760958338858452e-14,  -1.334240677722695e-15,   6.485495053681050e-01,  -2.190702774970283e-01,   4.066524599194430e-02,  -5.296378325227094e-03,   5.363041292736794e-04,
  -4.465889485908593e-05,   3.168126640668001e-06,  -1.961589591091946e-07,   1.078893749764878e-08,  -5.342409313644821e-10,   2.406943840747395e-11,  -9.951046054931274e-13,
   3.801929264024843e-14,  -1.348952678881523e-15,   6.564072707038187e-01,  -2.219683034755730e-01,   4.124299060433179e-02,  -5.376083774167341e-03,   5.447644193501822e-04,
  -4.539151909314716e-05,   3.221837950964435e-06,  -1.995787724409598e-07,   1.098158180297366e-08,  -5.439788088287037e-10,   2.451607486475922e-11,  -1.013859918779318e-12,
   3.874571984667135e-14,  -1.375038649876047e-15,   6.659571671933692e-01,  -2.254912816655844e-01,   4.194548780059166e-02,  -5.473019927001116e-03,   5.550555001970521e-04,
  -4.628282194599449e-05,   3.287191578733812e-06,  -2.037403607600200e-07,   1.121603678814134e-08,  -5.558312783862448e-10,   2.505974485234275e-11,  -1.036691616692857e-12,
   3.963009257832479e-14,  -1.406798379430178e-15,   6.752786908180819e-01,  -2.289309311126535e-01,   4.263154008047363e-02,  -5.567707711979117e-03,   5.651098223507123e-04,
  -4.715376613813743e-05,   3.351061884983117e-06,  -2.078080239110377e-07,   1.144522658094649e-08,  -5.674187547794733e-10,   2.559130773943010e-11,  -1.059016672200063e-12,
   4.049490345675556e-14,  -1.437857635507560e-15,   6.828244007535174e-01,  -2.317159621565206e-01,   4.318714870222919e-02,  -5.644406810904092e-03,   5.732554221925406e-04,
  -4.785947465564169e-05,   3.402821478623123e-06,  -2.111047802758736e-07,   1.163099902241530e-08,  -5.768119632730653e-10,   2.602224542011890e-11,  -1.077116870859731e-12,
   4.119609996936350e-14,  -1.463042220731077e-15,   6.878283488002708e-01,  -2.335631815874669e-01,   4.355572567149119e-02,  -5.695294397202116e-03,   5.786604661063786e-04,
  -4.832780174303140e-05,   3.437173847150375e-06,  -2.132929931128081e-07,   1.175431420407666e-08,  -5.830475602300520e-10,   2.630833638414046e-11,  -1.089133865001619e-12,
   4.166165685868291e-14,  -1.479764148952018e-15,   6.904036547897784e-01,  -2.345139615842426e-01,   4.374545402660936e-02,  -5.721491505181469e-03,   5.814432115846673e-04,
  -4.856893227840018e-05,   3.454862093462185e-06,  -2.144197748255686e-07,   1.181781604458075e-08,  -5.862587435364955e-10,   2.645567160034850e-11,  -1.095322743817299e-12,
   4.190143036372374e-14,  -1.488376583164222e-15,   6.913008964134273e-01,  -2.348452310394963e-01,   4.381156187295147e-02,  -5.730619832853640e-03,   5.824128868493483e-04,
  -4.865295913861236e-05,   3.461026087223402e-06,  -2.148124444538616e-07,   1.183994611290972e-08,  -5.873778449291140e-10,   2.650701893649195e-11,  -1.097479641726688e-12,
   4.198499536430904e-14,  -1.491378192912409e-15,   6.914433182299486e-01,  -2.348978151722464e-01,   4.382205565728832e-02,  -5.732068856459354e-03,   5.825668139289069e-04,
  -4.866629775438892e-05,   3.462004581414858e-06,  -2.148747786545315e-07,   1.184345916431922e-08,  -5.875554983388339e-10,   2.651517018485165e-11,  -1.097822044811266e-12,
   4.199826118671715e-14,  -1.491854695764698e-15,   3.453719506141760e-01,  -1.376824235626835e-01,   2.944082079731693e-02,  -4.307786283607214e-03,   4.800331855180639e-04,
  -4.326002003893170e-05,   3.276182973293774e-06,  -2.141274179122382e-07,   1.231622900300588e-08,  -6.328027105408506e-10,   2.938746985292876e-11,  -1.245380728383918e-12,
   4.854106879273330e-14,  -1.749842488410435e-15,   3.487323048799855e-01,  -1.390514505020242e-01,   2.973945026246476e-02,  -4.352238322352895e-03,   4.850603519002663e-04,
  -4.371889650131993e-05,   3.311325322337023e-06,  -2.164469885952820e-07,   1.245081559987145e-08,  -6.397717653857368e-10,   2.971338353895595e-11,  -1.259279535720216e-12,
   4.908588957353414e-14,  -1.769583197903354e-15,   3.546879863918844e-01,  -1.414779766287111e-01,   3.026878630020288e-02,  -4.431036058571742e-03,   4.939721644969465e-04,
  -4.453239559600848e-05,   3.373628280547064e-06,  -2.205594366596735e-07,   1.268943630850818e-08,  -6.521281793353805e-10,   3.029125637643126e-11,  -1.283923880437267e-12,
   5.005194582291521e-14,  -1.804587337788605e-15,   3.619346196177530e-01,  -1.444307292957623e-01,   3.091297008916695e-02,  -4.526937400537756e-03,   5.048190752217348e-04,
  -4.552259589245448e-05,   3.449468208511933e-06,  -2.255656645823286e-07,   1.297993037289272e-08,  -6.671713283527232e-10,   3.099480509957701e-11,  -1.313928855835945e-12,
   5.122817255714314e-14,  -1.847207894716549e-15,   3.690167909497748e-01,  -1.473167349981272e-01,   3.154264841265993e-02,  -4.620686821799538e-03,   5.154233541686432e-04,
  -4.649070866988778e-05,   3.523620700145448e-06,  -2.304607571243100e-07,   1.326398891265307e-08,  -6.818818391449947e-10,   3.168282322575935e-11,  -1.343272502579013e-12,
   5.237851035083597e-14,  -1.888891504951702e-15,   3.747560915836419e-01,  -1.496557072028872e-01,   3.205301349166560e-02,  -4.696677742390570e-03,   5.240194609757002e-04,
  -4.727553073417932e-05,   3.583737110707980e-06,  -2.344294550484128e-07,   1.349429898323238e-08,  -6.938093302158590e-10,   3.224069705729065e-11,  -1.367066288337470e-12,
   5.331130662734899e-14,  -1.922693101934372e-15,   3.785652169674833e-01,  -1.512081564295708e-01,   3.239177854967323e-02,  -4.747120886494863e-03,   5.297258655202437e-04,
  -4.779654556921031e-05,   3.623647703348387e-06,  -2.370643166524093e-07,   1.364720899422290e-08,  -7.017285807838551e-10,   3.261110633573634e-11,  -1.382864911999559e-12,
   5.393067827378352e-14,  -1.945137577154574e-15,   3.805265602967606e-01,  -1.520075513702443e-01,   3.256622325467638e-02,  -4.773097049826258e-03,   5.326645137745419e-04,
  -4.806486122881342e-05,   3.644201585403593e-06,  -2.384212929829238e-07,   1.372596040104507e-08,  -7.058072049036760e-10,   3.280187980879774e-11,  -1.391001855268136e-12,
   5.424968411849552e-14,  -1.956697672238582e-15,   3.812100487025954e-01,  -1.522861288875413e-01,   3.262701566977372e-02,  -4.782149639914214e-03,   5.336886341830012e-04,
  -4.815837044215474e-05,   3.651364779124555e-06,  -2.388942145472577e-07,   1.375340638404305e-08,  -7.072286740529256e-10,   3.286836803133906e-11,  -1.393837754013966e-12,
   5.436086509534330e-14,  -1.960726654594359e-15,   3.813185480803548e-01,  -1.523303514896618e-01,   3.263666616723227e-02,  -4.783586700326927e-03,   5.338512095919682e-04,
  -4.817321474217019e-05,   3.652501917581753e-06,  -2.389692898283425e-07,   1.375776338567722e-08,  -7.074543302961799e-10,   3.287892296552075e-11,  -1.394287950740654e-12,
   5.437851501851202e-14,  -1.961366254411786e-15,   5.550483741941183e-01,  -1.701374682483181e-02,   5.966300008766364e-04,  -2.116579765100291e-05,   7.293516298267078e-07,
  -2.425592622835930e-08,   7.790356803808101e-10,  -2.425169186452315e-11,   7.329583325897709e-13,  -2.159048617878903e-14,   6.194683237501010e-16,  -1.728407087247628e-17,
   4.751304239115980e-19,  -1.287622898381978e-20,   5.551051445846400e-01,  -1.701978133679622e-02,   5.970465898067405e-04,  -2.118895029044210e-05,   7.304706545896016e-07,
  -2.430487503941281e-08,   7.810160350759463e-10,  -2.432699990520714e-11,   7.356715857039669e-13,  -2.168350193473319e-14,   6.225520349327967e-16,  -1.738336448858570e-17,
   4.782067851922457e-19,  -1.296839357843391e-20,   5.552053493466491e-01,  -1.703043469453411e-02,   5.977821848578460e-04,  -2.122984116893029e-05,   7.324474778321007e-07,
  -2.439136773584443e-08,   7.845162535596202e-10,  -2.446014023763429e-11,   7.404698676486967e-13,  -2.184805125303906e-14,   6.280089788706504e-16,  -1.755912608281003e-17,
   4.836541305793905e-19,  -1.313164873691003e-20,   5.553265734840483e-01,  -1.704332600478059e-02,   5.986725570696644e-04,  -2.127935117120035e-05,   7.348417768197376e-07,
  -2.449616350654777e-08,   7.887587481673825e-10,  -2.462157584773158e-11,   7.462902900488437e-13,  -2.204774644205680e-14,   6.346343877288667e-16,  -1.777261025571509e-17,
   4.902737095932651e-19,  -1.333013500915127e-20,   5.554443139001491e-01,  -1.705585026162518e-02,   5.995378404039541e-04,  -2.132748205656922e-05,   7.371702141341158e-07,
  -2.459811547932316e-08,   7.928877732526596e-10,  -2.477875746828452e-11,   7.519598545200417e-13,  -2.224236352612355e-14,   6.410943839764278e-16,  -1.798085657659846e-17,
   4.967341340507394e-19,  -1.352395360001435e-20,   5.555392057176234e-01,  -1.706594652099199e-02,   6.002355651078773e-04,  -2.136630404474383e-05,   7.390489099628106e-07,
  -2.468040315423704e-08,   7.962215887000469e-10,  -2.490571319964295e-11,   7.565409716212972e-13,  -2.239968796888201e-14,   6.463187122352332e-16,  -1.814933564112228e-17,
   5.019631961926812e-19,  -1.368090517946326e-20,   5.556019289528408e-01,  -1.707262132059638e-02,   6.006969343933337e-04,  -2.139198063097278e-05,   7.402917584219785e-07,
  -2.473485411042104e-08,   7.984282055074940e-10,  -2.498976626120484e-11,   7.595748575670738e-13,  -2.250391183492575e-14,   6.497807891990347e-16,  -1.826101636713382e-17,
   5.054305611281960e-19,  -1.378501571681686e-20,   5.556341466503031e-01,  -1.707605019263482e-02,   6.009339702340554e-04,  -2.140517412350040e-05,   7.409304661812594e-07,
  -2.476284103239727e-08,   7.995625515098351e-10,  -2.503298199415850e-11,   7.611349983184929e-13,  -2.255751837509855e-14,   6.515618087022659e-16,  -1.831847906062964e-17,
   5.072149665736630e-19,  -1.383860534642074e-20,   5.556453613204928e-01,  -1.707724380904723e-02,   6.010164887556802e-04,  -2.140976740788899e-05,   7.411528452393126e-07,
  -2.477258591999257e-08,   7.999575530510552e-10,  -2.504803166526055e-11,   7.616783534035538e-13,  -2.257618978324061e-14,   6.521821992260939e-16,  -1.833849689557195e-17,
   5.078366425299274e-19,  -1.385727745457312e-20,   5.556471409819413e-01,  -1.707743322741921e-02,   6.010295840695323e-04,  -2.141049635434281e-05,   7.411881371031534e-07,
  -2.477413247908148e-08,   8.000202429992288e-10,  -2.505042022256993e-11,   7.617645922245769e-13,  -2.257915330358441e-14,   6.522806699471230e-16,  -1.834167427755260e-17,
   5.079353223116547e-19,  -1.386024139890762e-20,   4.457973998903198e-01,  -4.071891792938143e-02,   3.128706288632272e-03,  -1.996300874841419e-04,   1.117156970893969e-05,
  -5.640229628221626e-07,   2.613300975333780e-08,  -1.123998783022872e-09,   4.524705893757623e-11,  -1.715165873319982e-12,   6.151150925864771e-14,  -2.094748602405952e-15,
   6.793313301290812e-17,  -2.101460293931196e-18,   4.461037707613482e-01,  -4.077699943251381e-02,   3.135206901461393e-03,  -2.001783813120016e-04,   1.120980022034855e-05,
  -5.663333762619901e-07,   2.625748668329804e-08,  -1.130088408253216e-09,   4.552106629060933e-11,  -1.726611756046240e-12,   6.195848534793063e-14,  -2.111157548480317e-15,
   6.850200822338322e-17,  -2.120137855077721e-18,   4.466448886896509e-01,  -4.087961396533901e-02,   3.146695170974412e-03,  -2.011476457144546e-04,   1.127740313631774e-05,
  -5.704200337622170e-07,   2.647772182709693e-08,  -1.140865532197648e-09,   4.600611326485301e-11,  -1.746878061319840e-12,   6.275008912959870e-14,  -2.140224349482440e-15,
   6.950991766428392e-17,  -2.153236348814691e-18,   4.473001048188249e-01,  -4.100391647054480e-02,   3.160617367138349e-03,  -2.023227501785637e-04,   1.135939629160466e-05,
  -5.753785736251254e-07,   2.674504702570642e-08,  -1.153951843829248e-09,   4.659529842887653e-11,  -1.771503747426494e-12,   6.371227663468361e-14,  -2.175565420387605e-15,
   7.073573994680701e-17,  -2.193501707032560e-18,   4.479371111410374e-01,  -4.112481785431026e-02,   3.174164748481852e-03,  -2.034667319337899e-04,   1.143925307185570e-05,
  -5.802099914335208e-07,   2.700562702621490e-08,  -1.166713048228114e-09,   4.717006476915316e-11,  -1.795535446236484e-12,   6.465157630976345e-14,  -2.210076966667433e-15,
   7.193315534552039e-17,  -2.232845374225874e-18,   4.484509451455621e-01,  -4.122237996743604e-02,   3.185101279570191e-03,  -2.043906139389100e-04,   1.150377082850517e-05,
  -5.841148707921027e-07,   2.721631226529719e-08,  -1.177034440351812e-09,   4.763509831617231e-11,  -1.814985293015919e-12,   6.541202034822764e-14,  -2.238025028543662e-15,
   7.290310572318459e-17,  -2.264723368522944e-18,   4.487908059125835e-01,  -4.128692842752205e-02,   3.192339191841791e-03,  -2.050022293022826e-04,   1.154649433996218e-05,
  -5.867014021451964e-07,   2.735590490851315e-08,  -1.183874820107054e-09,   4.794337050753504e-11,  -1.827881700483308e-12,   6.591635271500291e-14,  -2.256564313093383e-15,
   7.354664854992684e-17,  -2.285877792396931e-18,   4.489654423195756e-01,  -4.132010227036694e-02,   3.196059688061105e-03,  -2.053166731110748e-04,   1.156846318782355e-05,
  -5.880316474353721e-07,   2.742770874427052e-08,  -1.187393935996597e-09,   4.810198859125991e-11,  -1.834518347057725e-12,   6.617592306268408e-14,  -2.266107343179961e-15,
   7.387794961622421e-17,  -2.296769500632890e-18,   4.490262423086417e-01,  -4.133165273131895e-02,   3.197355195492554e-03,  -2.054261739239486e-04,   1.157611415206699e-05,
  -5.884949602174287e-07,   2.745271926341044e-08,  -1.188619793010396e-09,   4.815724576192529e-11,  -1.836830479875242e-12,   6.626635998990961e-14,  -2.269432423769933e-15,
   7.399339125821686e-17,  -2.300564906570238e-18,   4.490358911982079e-01,  -4.133348582038479e-02,   3.197560801017477e-03,  -2.054435528429946e-04,   1.157732846868141e-05,
  -5.885684962363293e-07,   2.745668896866103e-08,  -1.188814366961534e-09,   4.816601662653144e-11,  -1.837197487389822e-12,   6.628071541113098e-14,  -2.269960236478086e-15,
   7.401171639699722e-17,  -2.301167396453465e-18,   2.942294745217056e-01,  -5.770431712125736e-02,   7.150355332175048e-03,  -6.718355162639787e-04,   5.196427711851718e-05,
  -3.454144360555231e-06,   2.026370758847820e-07,  -1.068163527571545e-08,   5.125078032106167e-10,  -2.260067216662193e-11,   9.229681488038776e-13,  -3.511829708425605e-14,
   1.251197095880929e-15,  -4.187625655627373e-17,   2.949619836194408e-01,  -5.790538552868802e-02,   7.181299529753498e-03,  -6.752628781735723e-04,   5.226630864188863e-05,
  -3.476479963484229e-06,   2.040692351321278e-07,  -1.076302290832001e-08,   5.166717343903898e-10,  -2.279472381795175e-11,   9.312809188322085e-13,  -3.544801204362599e-14,
   1.263377838030110e-15,  -4.229705974832756e-17,   2.962570749531711e-01,  -5.826099099651365e-02,   7.236043252048542e-03,  -6.813279433136542e-04,   5.280091991316316e-05,
  -3.516024298760648e-06,   2.066053544949265e-07,  -1.090717475129232e-08,   5.240480747818538e-10,  -2.313853751143386e-11,   9.460112798990073e-13,  -3.603234725555845e-14,
   1.284967586082482e-15,  -4.304299063447437e-17,   2.978274992157253e-01,  -5.869238899944995e-02,   7.302482944672271e-03,  -6.886916771190571e-04,   5.345023549871348e-05,
  -3.564068790295339e-06,   2.096875342001562e-07,  -1.108241167271648e-08,   5.330172510479568e-10,  -2.355668629489391e-11,   9.639300338622628e-13,  -3.674329021233215e-14,
   1.311239458448917e-15,  -4.395082417751430e-17,   2.993566433117916e-01,  -5.911264830813145e-02,   7.367236601791723e-03,  -6.958715509883727e-04,   5.408358182965809e-05,
  -3.610948095277624e-06,   2.126959232645329e-07,  -1.125350277869804e-08,   5.417765299985396e-10,  -2.396514646128065e-11,   9.814373566717880e-13,  -3.743804357391673e-14,
   1.336917553702479e-15,  -4.483828018810756e-17,   3.005918076129653e-01,  -5.945225640862963e-02,   7.419584608421217e-03,  -7.016780460387352e-04,   5.459595482835789e-05,
  -3.648884914374632e-06,   2.151311331105729e-07,  -1.139203193060826e-08,   5.488703959976614e-10,  -2.429601505062085e-11,   9.956216563339044e-13,  -3.800102372761809e-14,
   1.357728524594039e-15,  -4.555762520765655e-17,   3.014096037233671e-01,  -5.967717984568575e-02,   7.454265184970438e-03,  -7.055259081723843e-04,   5.493558074655213e-05,
  -3.674037060596569e-06,   2.167460161956032e-07,  -1.148391342986928e-08,   5.535763137760817e-10,  -2.451554015715098e-11,   1.005033989570462e-12,  -3.837464988166419e-14,
   1.371541461391787e-15,  -4.603512789423315e-17,   3.018300832703518e-01,  -5.979284873311289e-02,   7.472103179109253e-03,  -7.075053872643211e-04,   5.511032296382306e-05,
  -3.686979969163646e-06,   2.175771143684701e-07,  -1.153120554024444e-08,   5.559987350716212e-10,  -2.462855356064289e-11,   1.009879946212891e-12,  -3.856702654734221e-14,
   1.378654102005579e-15,  -4.628102171353204e-17,   3.019765150212978e-01,  -5.983313383114443e-02,   7.478316295200809e-03,  -7.081949076953802e-04,   5.517119587010703e-05,
  -3.691489022861126e-06,   2.178666691272469e-07,  -1.154768297611032e-08,   5.568427906352579e-10,  -2.466793302228972e-11,   1.011568582046096e-12,  -3.863406498611183e-14,
   1.381132756160167e-15,  -4.636671464289280e-17,   3.019997555222044e-01,  -5.983952773152415e-02,   7.479302441959636e-03,  -7.083043509557064e-04,   5.518085804476715e-05,
  -3.692204744959436e-06,   2.179126309409839e-07,  -1.155029852490235e-08,   5.569767738334883e-10,  -2.467418409567392e-11,   1.011836638213315e-12,  -3.864470686190094e-14,
   1.381526228570090e-15,  -4.638031802884953e-17,   1.610575491765581e-01,  -4.986215666769848e-02,   8.634697600676356e-03,  -1.062859094394403e-03,   1.027096253722695e-04,
  -8.223763165811603e-06,   5.642980934330494e-07,  -3.395805174145411e-08,   1.822437796009666e-09,  -8.834280205042135e-11,   3.907066136134835e-12,  -1.589317192802749e-13,
   5.986306707603191e-15,  -2.097518973343163e-16,   1.619929203800546e-01,  -5.019053168077656e-02,   8.697332679739113e-03,  -1.071179611744182e-03,   1.035647203549444e-04,
  -8.295784597800157e-06,   5.694533041869983e-07,  -3.427953680636810e-08,   1.840222671182729e-09,  -8.922766469414710e-11,   3.947089860458731e-12,  -1.605918909228248e-13,
   6.049912419826190e-15,  -2.120139970968974e-16,   1.636487674683790e-01,  -5.077196536619770e-02,   8.808259035142475e-03,  -1.085917802669049e-03,   1.050795906272263e-04,
  -8.423393738002533e-06,   5.785885078893461e-07,  -3.484927877219862e-08,   1.871744287555479e-09,  -9.079610911969197e-11,   4.018038220433235e-12,  -1.635349971055509e-13,
   6.162677355324765e-15,  -2.160246218710633e-16,   1.656602154562707e-01,  -5.147847910892218e-02,   8.943086199158649e-03,  -1.103836010989711e-03,   1.069217204782831e-04,
  -8.578600028141470e-06,   5.897011785196425e-07,  -3.554245298701517e-08,   1.910099919504081e-09,  -9.270481831419331e-11,   4.104387218670297e-12,  -1.671172831233295e-13,
   6.299943517387417e-15,  -2.209070151163696e-16,   1.676225381112085e-01,  -5.216796249753997e-02,   9.074703146267099e-03,  -1.121332247274817e-03,   1.087208878959576e-04,
  -8.730217557119451e-06,   6.005588446364994e-07,  -3.621982781529706e-08,   1.947586545293109e-09,  -9.457051286896223e-11,   4.188799489610860e-12,  -1.706195622393258e-13,
   6.434155594018858e-15,  -2.256811470595637e-16,   1.692102910471386e-01,  -5.272599781588622e-02,   9.181256189204073e-03,  -1.135500001827527e-03,   1.101780826028233e-04,
  -8.853038928311422e-06,   6.093557506099450e-07,  -3.676871513815400e-08,   1.977966284424244e-09,  -9.608266538308074e-11,   4.257222571161511e-12,  -1.734586911788006e-13,
   6.542963186325736e-15,  -2.295518663867029e-16,   1.702628524007990e-01,  -5.309601232146055e-02,   9.251921890052235e-03,  -1.144897654097261e-03,   1.111448056213360e-04,
  -8.934531185074157e-06,   6.151932010599928e-07,  -3.713298329811084e-08,   1.998129581025695e-09,  -9.708637484824458e-11,   4.302642454768460e-12,  -1.753434510109135e-13,
   6.615199339363751e-15,  -2.321217233774177e-16,   1.708044471386624e-01,  -5.328642741777120e-02,   9.288291848529202e-03,  -1.149734907848966e-03,   1.116424524820561e-04,
  -8.976484891692415e-06,   6.181986387681782e-07,  -3.732054000699917e-08,   2.008511954173559e-09,  -9.760322432228443e-11,   4.326031939850481e-12,  -1.763140664048074e-13,
   6.652400841452910e-15,  -2.334452355671380e-16,   1.709931221304298e-01,  -5.335276607615148e-02,   9.300963453929540e-03,  -1.151420328942655e-03,   1.118158524288224e-04,
  -8.991103765347988e-06,   6.192459246515788e-07,  -3.738589855431733e-08,   2.012130026502201e-09,  -9.778334113862262e-11,   4.334183098199066e-12,  -1.766523285383062e-13,
   6.665365867701976e-15,  -2.339064967005268e-16,   1.710230702312355e-01,  -5.336329609690101e-02,   9.302974866769207e-03,  -1.151687866155248e-03,   1.118433776080392e-04,
  -8.993424363048489e-06,   6.194121722434071e-07,  -3.739627374703374e-08,   2.012704373376620e-09,  -9.781193377104794e-11,   4.335477060865525e-12,  -1.767060265313095e-13,
   6.667424032179646e-15,  -2.339797210177805e-16,   6.157185983545706e-02,  -2.396647143283315e-02,   5.016526516831942e-03,  -7.208177366080030e-04,   7.909133853020102e-05,
  -7.033564752669449e-06,   5.265667482446907e-07,  -3.407061438391986e-08,   1.942339226858935e-09,  -9.901182866500441e-11,   4.565792782464023e-12,  -1.922652152192050e-13,
   7.451063483910202e-15,  -2.672110375801350e-16,   6.214080954985630e-02,  -2.419474825089283e-02,   5.065605410042905e-03,  -7.280305708813615e-04,   7.989796956484155e-05,
  -7.106471973965397e-06,   5.321018071114556e-07,  -3.443313448005731e-08,   1.963227971856954e-09,  -1.000867386912499e-10,   4.615778855678040e-12,  -1.943860224082616e-13,
   7.533812397655806e-15,  -2.701968149873580e-16,   6.314903577645521e-02,  -2.459930548863661e-02,   5.152590620146775e-03,  -7.408151218416602e-04,   8.132778475736421e-05,
  -7.235712295670340e-06,   5.419140823504237e-07,  -3.507581838621058e-08,   2.000261383835178e-09,  -1.019924976549939e-10,   4.704404215075754e-12,  -1.981463192399066e-13,
   7.680534028034957e-15,  -2.754910007011795e-16,   6.437555795857690e-02,  -2.509150952911353e-02,   5.258432171872541e-03,  -7.563725125228041e-04,   8.306785545928330e-05,
  -7.393007899420772e-06,   5.538571617949757e-07,  -3.585811072267553e-08,   2.045341795784910e-09,  -1.043124679755691e-10,   4.812296622655668e-12,  -2.027242768673457e-13,
   7.859165950324016e-15,  -2.819368178825382e-16,   6.557398568046670e-02,  -2.557249598029200e-02,   5.361873177673384e-03,  -7.715785728354058e-04,   8.476878029842053e-05,
  -7.546776850046694e-06,   5.655332790621986e-07,  -3.662296386379306e-08,   2.089419703276355e-09,  -1.065809601660725e-10,   4.917799786316312e-12,  -2.072010422476564e-13,
   8.033855940457722e-15,  -2.882406089325371e-16,   6.654499083655906e-02,  -2.596224750764739e-02,   5.445701528323744e-03,  -7.839026178457698e-04,   8.614743507013821e-05,
  -7.671420158128228e-06,   5.749983818925376e-07,  -3.724301667086358e-08,   2.125154630913871e-09,  -1.084201580784117e-10,   5.003340743550900e-12,  -2.108308935731779e-13,
   8.175502816700766e-15,  -2.933521745017046e-16,   6.718934809929154e-02,  -2.622090580685907e-02,   5.501338229424104e-03,  -7.920825937767631e-04,   8.706255755886469e-05,
  -7.754160006447742e-06,   5.812817236425124e-07,  -3.765465093888796e-08,   2.148878824843996e-09,  -1.096412298952470e-10,   5.060134384312099e-12,  -2.132409441019685e-13,
   8.269551990554887e-15,  -2.967461727129094e-16,   6.752110380756593e-02,  -2.635408554057419e-02,   5.529986091578546e-03,  -7.962947052798042e-04,   8.753379743880876e-05,
  -7.796767968827692e-06,   5.845174999095059e-07,  -3.786663823153760e-08,   2.161096799026534e-09,  -1.102700949436384e-10,   5.089384236752166e-12,  -2.144821880473861e-13,
   8.317990680060245e-15,  -2.984942266277008e-16,   6.763670949103719e-02,  -2.640049516756733e-02,   5.539969317177606e-03,  -7.977625708443780e-04,   8.769802093628721e-05,
  -7.811616724789493e-06,   5.856451728469635e-07,  -3.794051694031860e-08,   2.165354870796754e-09,  -1.104892619212330e-10,   5.099578242276238e-12,  -2.149147830875825e-13,
   8.334872517027019e-15,  -2.991034615568286e-16,   6.765506093636438e-02,  -2.640786235812327e-02,   5.541554091117513e-03,  -7.979955864655216e-04,   8.772409064001801e-05,
  -7.813973904396058e-06,   5.858241870001747e-07,  -3.795224496686741e-08,   2.166030829102217e-09,  -1.105240542270339e-10,   5.101196523560581e-12,  -2.149834569765032e-13,
   8.337552491651164e-15,  -2.992001771652494e-16,   4.951694429591830e-01,  -1.308953056192269e-02,   3.994067119000925e-04,  -1.255221853759215e-05,   3.873711186105773e-07,
  -1.163508230449631e-08,   3.386104020267976e-10,  -9.616401968466856e-12,   2.656007669657866e-13,  -7.131781590414281e-15,   1.907513459756337e-16,  -4.920819719152813e-18,
   1.216382023578363e-19,  -3.058859791567977e-21,   4.952073302479026e-01,  -1.309309989751333e-02,   3.996273480418121e-04,  -1.256328930285419e-05,   3.878557642724209e-07,
  -1.165440993351209e-08,   3.393248249581506e-10,  -9.641160699519371e-12,   2.664308918657229e-13,  -7.158072531348805e-15,   1.915361052090830e-16,  -4.944246710394621e-18,
   1.223261996411127e-19,  -3.077890713300784e-21,   4.952742001117425e-01,  -1.309940060630939e-02,   4.000168876337147e-04,  -1.258283869641350e-05,   3.887117527802847e-07,
  -1.168855380958926e-08,   3.405872225669008e-10,  -9.684920688979131e-12,   2.678983803613329e-13,  -7.204562611160309e-15,   1.929243260261105e-16,  -4.985698656385302e-18,
   1.235437737044821e-19,  -3.111582705357326e-21,   4.953550891144472e-01,  -1.310702385807226e-02,   4.004883046710024e-04,  -1.260650338049706e-05,   3.897482289689803e-07,
  -1.172990918299387e-08,   3.421167784151028e-10,  -9.737960086228792e-12,   2.696775293229903e-13,  -7.260948560318410e-15,   1.946089591035391e-16,  -5.036018740998868e-18,
   1.250222180495240e-19,  -3.152514291205259e-21,   4.954336454026038e-01,  -1.311442895540575e-02,   4.009463481121999e-04,  -1.262950321777869e-05,   3.907558959892265e-07,
  -1.177012781996881e-08,   3.436048450312382e-10,  -9.789580273761924e-12,   2.714095723716956e-13,  -7.315865141297016e-15,   1.962506515894001e-16,  -5.085074389924571e-18,
   1.264639173374591e-19,  -3.192450518573346e-21,   4.954969512943159e-01,  -1.312039768668058e-02,   4.013156287437223e-04,  -1.264805064503957e-05,   3.915687167363710e-07,
  -1.180257877328765e-08,   3.448059087459449e-10,  -9.831258468471120e-12,   2.728083848649818e-13,  -7.360233116205740e-15,   1.975776884693418e-16,  -5.124740839056250e-18,
   1.276299682552117e-19,  -3.224766797034699e-21,   4.955387934600962e-01,  -1.312434332538280e-02,   4.015597833224790e-04,  -1.266031579326632e-05,   3.921063324021590e-07,
  -1.182404695306195e-08,   3.456006761899586e-10,  -9.858844595718966e-12,   2.737344125144750e-13,  -7.389613423789985e-15,   1.984567839464389e-16,  -5.151024283998633e-18,
   1.284027500664133e-19,  -3.246191602532280e-21,   4.955602847429526e-01,  -1.312637009693647e-02,   4.016852118571442e-04,  -1.266661742346237e-05,   3.923825841369838e-07,
  -1.183507968025339e-08,   3.460091758189583e-10,  -9.873025607411523e-12,   2.742105037488474e-13,  -7.404721046349501e-15,   1.989089269462364e-16,  -5.164544566841528e-18,
   1.288003156737746e-19,  -3.257216197325803e-21,   4.955677655107713e-01,  -1.312707561252162e-02,   4.017288753305321e-04,  -1.266881122375298e-05,   3.924787616234451e-07,
  -1.183892096266869e-08,   3.461514133680996e-10,  -9.877963702811858e-12,   2.743762963720894e-13,  -7.409982488129658e-15,   1.990664086626620e-16,  -5.169254006537453e-18,
   1.289388044001962e-19,  -3.261056903794078e-21,   4.955689526307602e-01,  -1.312718757188797e-02,   4.017358044511214e-04,  -1.266915937149536e-05,   3.924940248786477e-07,
  -1.183953058019544e-08,   3.461739871441337e-10,  -9.878747418068851e-12,   2.744026094006489e-13,  -7.410817553473570e-15,   1.990914040282442e-16,  -5.170001499844753e-18,
   1.289607859908979e-19,  -3.261666537022832e-21,   3.211945943766483e-01,  -2.291204097851938e-02,   1.520280741964560e-03,  -8.540150761096044e-05,   4.267293676751352e-06,
  -1.945518820741566e-07,   8.217034533680628e-09,  -3.247250852352361e-10,   1.209581453834232e-11,  -4.269597396258581e-13,   1.433799454381841e-14,  -4.597353781401855e-16,
   1.410969532475261e-17,  -4.148612900443543e-19,   3.213420765429478e-01,  -2.293672353559944e-02,   1.522748751413311e-03,  -8.558950164272990e-05,   4.279242039497036e-06,
  -1.952152959390415e-07,   8.250106237518837e-09,  -3.262316678886374e-10,   1.215929538231561e-11,  -4.294566996142479e-13,   1.443028398000913e-14,  -4.629558961634739e-16,
   1.421625228041064e-17,  -4.182131555767383e-19,   3.216025074334097e-01,  -2.298032026653224e-02,   1.527109150568381e-03,  -8.592173321112785e-05,   4.300363447712660e-06,
  -1.963883441581214e-07,   8.308599085379793e-09,  -3.288970017778628e-10,   1.227162928874896e-11,  -4.338763185477313e-13,   1.459367404935992e-14,  -4.686587962265933e-16,
   1.440498342586545e-17,  -4.241510821796613e-19,   3.219177582430791e-01,  -2.303311295557436e-02,   1.532391280303980e-03,  -8.632434741637607e-05,   4.325969151936558e-06,
  -1.978109815445377e-07,   8.379563854066136e-09,  -3.321318199314367e-10,   1.240801319874382e-11,  -4.392439766025666e-13,   1.479217694041994e-14,  -4.755894205405065e-16,
   1.463441282450090e-17,  -4.313714907120214e-19,   3.222241494673267e-01,  -2.308444188782480e-02,   1.537529032287180e-03,  -8.671611756372361e-05,   4.350895426752056e-06,
  -1.991964350906166e-07,   8.448701491222604e-09,  -3.352845865952239e-10,   1.254098842249492e-11,  -4.444793933452712e-13,   1.498585701988361e-14,  -4.823539244492541e-16,
   1.485841440715527e-17,  -4.384231966900656e-19,   3.224712261602923e-01,  -2.312584827343035e-02,   1.541675079977728e-03,  -8.703238230361990e-05,   4.371025031366687e-06,
  -2.003156849388228e-07,   8.504574750657693e-09,  -3.378333662836343e-10,   1.264852546094399e-11,  -4.487146466361137e-13,   1.514258535445231e-14,  -4.878294698903045e-16,
   1.503978426456037e-17,  -4.441343481918798e-19,   3.226346134898860e-01,  -2.315323655240943e-02,   1.544418215561002e-03,  -8.724168793913033e-05,   4.384350504450062e-06,
  -2.010568087129575e-07,   8.541581582337514e-09,  -3.395219470564366e-10,   1.271978716127988e-11,  -4.515218995280670e-13,   1.524649335450856e-14,  -4.914604513987988e-16,
   1.516008056799041e-17,  -4.479230994429979e-19,   3.227185589040961e-01,  -2.316731030993240e-02,   1.545828030644397e-03,  -8.734927655302060e-05,   4.391201261605884e-06,
  -2.014378891466255e-07,   8.560613234688736e-09,  -3.403904745439447e-10,   1.275644637796493e-11,  -4.529662449815043e-13,   1.529996188124529e-14,  -4.933291121504836e-16,
   1.522199802254299e-17,  -4.498734294893396e-19,   3.227477829583028e-01,  -2.317221017437817e-02,   1.546318902307196e-03,  -8.738673970915437e-05,   4.393586923404987e-06,
  -2.015706038193716e-07,   8.567241657174556e-09,  -3.406929902580315e-10,   1.276921598056457e-11,  -4.534693907888937e-13,   1.531858911099566e-14,  -4.939801506151080e-16,
   1.524357120036490e-17,  -4.505529968819809e-19,   3.227524207020973e-01,  -2.317298778016092e-02,   1.546396805075869e-03,  -8.739268535364210e-05,   4.393965551729092e-06,
  -2.015916674257582e-07,   8.568293699862905e-09,  -3.407410056298924e-10,   1.277124281680407e-11,  -4.535492534327982e-13,   1.532154580413084e-14,  -4.940834915637761e-16,
   1.524699562291507e-17,  -4.506608698806844e-19,   1.414668756637163e-01,  -2.254544768438279e-02,   2.438623144990971e-03,  -2.047911807754906e-04,   1.440917499015618e-05,
  -8.827822057676832e-07,   4.823358402400528e-08,  -2.388524773815321e-09,   1.084499815537678e-10,  -4.554316755066509e-12,   1.780892773275371e-13,  -6.519665610285335e-15,
   2.244445129481762e-16,  -7.286231340209141e-18,   1.417125907404576e-01,  -2.260611759880560e-02,   2.447133412739677e-03,  -2.056607871952504e-04,   1.448059326414768e-05,
  -8.877462518959218e-07,   4.853492603670946e-08,  -2.404839473694563e-09,   1.092495294168534e-10,  -4.590181108963712e-12,   1.795743214288492e-13,  -6.576814966742788e-15,
   2.264997941146372e-16,  -7.355556288694069e-18,   1.421468567728713e-01,  -2.271337686817993e-02,   2.462183430695698e-03,  -2.071990864445092e-04,   1.460696307360444e-05,
  -8.965319722133936e-07,   4.906838462685127e-08,  -2.433727093404008e-09,   1.106655231107869e-10,  -4.653707901836326e-12,   1.822052169771895e-13,  -6.678075360568785e-15,
   2.301419422045294e-16,  -7.478421358893283e-18,   1.426731678070431e-01,  -2.284342822677775e-02,   2.480439334553085e-03,  -2.090658186797986e-04,   1.476037090225240e-05,
  -9.072011961462083e-07,   4.971641591050523e-08,  -2.468829410836219e-09,   1.123866132313107e-10,  -4.730941712148442e-12,   1.854045017469927e-13,  -6.801237938272392e-15,
   2.345727028868486e-16,  -7.627915038778525e-18,   1.431853520395978e-01,  -2.297004956802046e-02,   2.498221957606552e-03,  -2.108849440957475e-04,   1.490992675471101e-05,
  -9.176064173963548e-07,   5.034863074831525e-08,  -2.503085897955654e-09,   1.140667229391443e-10,  -4.806356703672239e-12,   1.885292074366839e-13,  -6.921556161937171e-15,
   2.389020100524542e-16,  -7.774012272290891e-18,   1.435988587617038e-01,  -2.307231955462578e-02,   2.512590576147214e-03,  -2.123553888788257e-04,   1.503085977831523e-05,
  -9.260230223400410e-07,   5.086017524474023e-08,  -2.530811697682273e-09,   1.154268871723789e-10,  -4.867424782619278e-12,   1.910600171749904e-13,  -7.019025295409843e-15,
   2.424097829418736e-16,  -7.892404986936716e-18,   1.438725369027151e-01,  -2.314002795598687e-02,   2.522106280993553e-03,  -2.133294765910200e-04,   1.511099236014211e-05,
  -9.316013968313576e-07,   5.119929451620616e-08,  -2.549195850573008e-09,   1.163289440469195e-10,  -4.907932032471872e-12,   1.927390037679944e-13,  -7.083697518182924e-15,
   2.447375484671282e-16,  -7.970979974130432e-18,   1.440132200277477e-01,  -2.317483977935087e-02,   2.526999608919871e-03,  -2.138304741693595e-04,   1.515221309832126e-05,
  -9.344713731336937e-07,   5.137378920355069e-08,  -2.558656647751880e-09,   1.167932111485645e-10,  -4.928782334843190e-12,   1.936033115156047e-13,  -7.116992345617994e-15,
   2.459360331460010e-16,  -8.011438358728619e-18,   1.440622077908540e-01,  -2.318696277656028e-02,   2.528703821369694e-03,  -2.140049715668998e-04,   1.516657132006762e-05,
  -9.354711255302286e-07,   5.143457797303304e-08,  -2.561952697174075e-09,   1.169549657632648e-10,  -4.936047106361024e-12,   1.939044713151931e-13,  -7.128594072212863e-15,
   2.463536653665379e-16,  -8.025537224954152e-18,   1.440699825052475e-01,  -2.318888683427961e-02,   2.528974306033107e-03,  -2.140326676280471e-04,   1.516885029291574e-05,
  -9.356298119261059e-07,   5.144422689221904e-08,  -2.562475883590244e-09,   1.169806416964937e-10,  -4.937200288075752e-12,   1.939522768812801e-13,  -7.130435731360734e-15,
   2.464199610580612e-16,  -8.027775326180946e-18,   4.646274330138941e-02,  -1.281207472408094e-02,   2.033592716434020e-03,  -2.334027075293399e-04,   2.129410334249821e-05,
  -1.624861646419796e-06,   1.070421466071890e-07,  -6.221078612921387e-09,   3.240127876572019e-10,  -1.530445982657093e-11,   6.617628105629190e-13,  -2.639407007319216e-14,
   9.771305321235365e-16,  -3.372168657397282e-17,   4.667930358684433e-02,  -1.288350226357121e-02,   2.046487892284247e-03,  -2.350373861212795e-04,   2.145552984090245e-05,
  -1.638001191925429e-06,   1.079553680961495e-07,  -6.276594124889486e-09,   3.270165636365573e-10,  -1.545103934717220e-11,   6.682810687560464e-13,  -2.666043064758939e-14,
   9.872016672900964e-16,  -3.407570593550281e-17,   4.706252273596576e-02,  -1.300993078441084e-02,   2.069318061255498e-03,  -2.379320953512741e-04,   2.174143846050153e-05,
  -1.661276908620843e-06,   1.095733021126742e-07,  -6.374962101845377e-09,   3.323395494933052e-10,  -1.571081828298180e-11,   6.798342142198408e-13,  -2.713257245268380e-14,
   1.005054661787153e-15,  -3.470331107548010e-17,   4.752778716325011e-02,  -1.316348215258842e-02,   2.097055207225455e-03,  -2.414500077676735e-04,   2.208899020257134e-05,
  -1.689577400723716e-06,   1.115409107432453e-07,  -6.494610927118095e-09,   3.388151181190632e-10,  -1.602689075928764e-11,   6.938926294882314e-13,  -2.770715978150365e-14,
   1.026783521192075e-15,  -3.546723477888308e-17,   4.798142359649204e-02,  -1.331325372096490e-02,   2.124119217438127e-03,  -2.448836277850084e-04,   2.242830832985987e-05,
  -1.717214184850272e-06,   1.134627876585968e-07,  -6.611501008433778e-09,   3.451424403962143e-10,  -1.633577320297081e-11,   7.076330539524082e-13,  -2.826881617832496e-14,
   1.048025594728663e-15,  -3.621411387488875e-17,   4.834827972162294e-02,  -1.343441552555207e-02,   2.146020296806632e-03,  -2.476630003224247e-04,   2.270303963806378e-05,
  -1.739595331980362e-06,   1.150194807038769e-07,  -6.706196203105917e-09,   3.502691019226866e-10,  -1.658607556832117e-11,   7.187688812448074e-13,  -2.872405368299889e-14,
   1.065244450572664e-15,  -3.681958487272309e-17,   4.859138495171956e-02,  -1.351472632769999e-02,   2.160540574941330e-03,  -2.495060864544619e-04,   2.288525529097709e-05,
  -1.754442001820973e-06,   1.160522673761144e-07,  -6.769029426012382e-09,   3.536711743204505e-10,  -1.675219327582046e-11,   7.261600102810934e-13,  -2.902622936092441e-14,
   1.076674689198821e-15,  -3.722153358613614e-17,   4.871644585849071e-02,  -1.355604697929916e-02,   2.168012438457386e-03,  -2.504546214634760e-04,   2.297904186265900e-05,
  -1.762084328145806e-06,   1.165839393168879e-07,  -6.801377969352922e-09,   3.554227845312423e-10,  -1.683772655082842e-11,   7.299658663551113e-13,  -2.918183344571182e-14,
   1.082560882410678e-15,  -3.742853134268261e-17,   4.876000867016908e-02,  -1.357044131451654e-02,   2.170615480343291e-03,  -2.507850900165221e-04,   2.301171862469375e-05,
  -1.764747154883428e-06,   1.167691976628640e-07,  -6.812650035031981e-09,   3.560331630986214e-10,  -1.686753287641299e-11,   7.312921485234033e-13,  -2.923606020560573e-14,
   1.084612211176154e-15,  -3.750067092105155e-17,   4.876692311348492e-02,  -1.357272608162397e-02,   2.171028660815317e-03,  -2.508375461300002e-04,   2.301690556726256e-05,
  -1.765169843942817e-06,   1.167986053504779e-07,  -6.814439367373842e-09,   3.561300557123042e-10,  -1.687226442478803e-11,   7.315026881424048e-13,  -2.924466844380580e-14,
   1.084937851599237e-15,  -3.751212285392644e-17,   1.159491556375302e-02,  -4.363708150692201e-03,   8.874046677710789e-04,  -1.244959095321224e-04,   1.338985115858673e-05,
  -1.170782930519355e-06,   8.639078705194393e-08,  -5.520238713211619e-09,   3.112859741659517e-10,  -1.571625106021799e-11,   7.185897654621391e-13,  -3.003091143001065e-14,
   1.155921251795050e-15,  -4.120035202589590e-17,   1.169475850871348e-02,  -4.402964024548373e-03,   8.956878416021374e-04,  -1.256935951482592e-04,   1.352192094886670e-05,
  -1.182575004915839e-06,   8.727650494412423e-08,  -5.577704549325253e-09,   3.145696174531315e-10,  -1.588396581489541e-11,   7.263367890138819e-13,  -3.035761741542076e-14,
   1.168598719923572e-15,  -4.165550710379863e-17,   1.187165667852188e-02,  -4.472523261092393e-03,   9.103665641781068e-04,  -1.278162068087853e-04,   1.375600012574013e-05,
  -1.203476490019427e-06,   8.884653037630800e-08,  -5.679573669813853e-09,   3.203907569705452e-10,  -1.618129703976614e-11,   7.400715032646546e-13,  -3.093685385696856e-14,
   1.191076016627307e-15,  -4.246252392246010e-17,   1.208680159631840e-02,  -4.557133823152554e-03,   9.282238736795119e-04,  -1.303987591545908e-04,   1.404083009008047e-05,
  -1.228911904271365e-06,   9.075727433345501e-08,  -5.803558514671322e-09,   3.274761019377191e-10,  -1.654322126624508e-11,   7.567908193747083e-13,  -3.164199237941614e-14,
   1.218440077450242e-15,  -4.344503031254170e-17,   1.229696153098963e-02,  -4.639796587021214e-03,   9.456725926743547e-04,  -1.329225371414554e-04,   1.431920827030314e-05,
  -1.253773551547503e-06,   9.262507348829631e-08,  -5.924765792286269e-09,   3.344031783122786e-10,  -1.689708211064511e-11,   7.731385198320005e-13,  -3.233149147544855e-14,
   1.245198406907243e-15,  -4.440582663952062e-17,   1.246719917780313e-02,  -4.706765680324005e-03,   9.598104315722626e-04,  -1.349676572015093e-04,   1.454481125883154e-05,
  -1.273923609868422e-06,   9.413901442153846e-08,  -6.023016594976146e-09,   3.400186070062422e-10,  -1.718395421882097e-11,   7.863920963205528e-13,  -3.289051330382867e-14,
   1.266893974827056e-15,  -4.518486497399529e-17,   1.258014861906303e-02,  -4.751202838361961e-03,   9.691924317065784e-04,  -1.363249287499982e-04,   1.469454640581637e-05,
  -1.287298256318546e-06,   9.514395130795020e-08,  -6.088237540380022e-09,   3.437464080276748e-10,  -1.737440159604845e-11,   7.951911293713407e-13,  -3.326165895373872e-14,
   1.281298506272290e-15,  -4.570211240835989e-17,   1.263829593996140e-02,  -4.774080832219393e-03,   9.740229245095815e-04,  -1.370237789242148e-04,   1.477164734603425e-05,
  -1.294185326309405e-06,   9.566144527392583e-08,  -6.121824158229669e-09,   3.456661515187330e-10,  -1.747248049887566e-11,   7.997226573723427e-13,  -3.345280369083957e-14,
   1.288717151637868e-15,  -4.596851022676683e-17,   1.265855734046200e-02,  -4.782052874280123e-03,   9.757061961115743e-04,  -1.372673112259958e-04,   1.479851567503482e-05,
  -1.296585390772968e-06,   9.584178866732148e-08,  -6.133529039412065e-09,   3.463351869201990e-10,  -1.750666160521079e-11,   8.013019381398508e-13,  -3.351942003430167e-14,
   1.291302663195021e-15,  -4.606135461546652e-17,   1.266177362351475e-02,  -4.783318362006911e-03,   9.759734019085278e-04,  -1.373059702748127e-04,   1.480278085917596e-05,
  -1.296966388386246e-06,   9.587041736154627e-08,  -6.135387143518431e-09,   3.464413940505108e-10,  -1.751208775867887e-11,   8.015526451907719e-13,  -3.352999524718834e-14,
   1.291713109013711e-15,  -4.607609354517381e-17,   4.483764255381262e-01,  -1.040662853684854e-02,   2.795045814022893e-04,  -7.851208468246609e-06,   2.182455379325191e-07,
  -5.972588103493051e-09,   1.582108821433634e-10,  -4.092242416182992e-12,   1.063182546583022e-13,  -2.551127889010875e-15,   6.180600798904494e-17,  -1.601448048471885e-18,
   3.588105625147320e-20,  -7.609996757584407e-22,   4.484028780754419e-01,  -1.040885666602081e-02,   2.796286210220482e-04,  -7.856876822582118e-06,   2.184713964671561e-07,
  -5.980785677307916e-09,   1.584955281878701e-10,  -4.101074565299514e-12,   1.065864230419666e-13,  -2.559613378885622e-15,   6.203572248701192e-17,  -1.607268667993026e-18,
   3.604608324566394e-20,  -7.656071852633196e-22,   4.484495636017875e-01,  -1.041278954323545e-02,   2.798475949727543e-04,  -7.866885014892670e-06,   2.188702550407076e-07,
  -5.995264672110724e-09,   1.589983674508408e-10,  -4.116682483457822e-12,   1.070604050777034e-13,  -2.574610823330235e-15,   6.244189630234427e-17,  -1.617566899665870e-18,
   3.633806983612804e-20,  -7.737567682683577e-22,   4.485060326272672e-01,  -1.041754745203740e-02,   2.801125581997318e-04,  -7.878997763699805e-06,   2.193531181910092e-07,
  -6.012797145236405e-09,   1.596073907881223e-10,  -4.135595779309248e-12,   1.076349062395784e-13,  -2.592788027511166e-15,   6.293447928677355e-17,  -1.630066869294352e-18,
   3.669249988319172e-20,  -7.836447898692323e-22,   4.485608689484262e-01,  -1.042216868578317e-02,   2.803699660126784e-04,  -7.890767862500560e-06,   2.198224594456280e-07,
  -6.029842865160538e-09,   1.601996527922719e-10,  -4.153998462871792e-12,   1.081940456161494e-13,  -2.610478367130888e-15,   6.341417474541588e-17,  -1.642251193371781e-18,
   3.703799921642248e-20,  -7.932790850381631e-22,   4.486050566819876e-01,  -1.042589316783331e-02,   2.805774638317505e-04,  -7.900257769759451e-06,   2.202009749816543e-07,
  -6.043592968356886e-09,   1.606775123339739e-10,  -4.168853548476064e-12,   1.086455028165266e-13,  -2.624761233364029e-15,   6.380169157021084e-17,  -1.652102315837215e-18,
   3.731735266723329e-20,  -8.010656476879203e-22,   4.486342611767035e-01,  -1.042835506031883e-02,   2.807146400639212e-04,  -7.906532484815134e-06,   2.204512972727832e-07,
  -6.052687757706174e-09,   1.609936366325438e-10,  -4.178684290483159e-12,   1.089443187114106e-13,  -2.634214675942693e-15,   6.405828578367111e-17,  -1.658629217046854e-18,
   3.750244681704231e-20,  -8.062232962522371e-22,   4.486492609466339e-01,  -1.042961961391639e-02,   2.807851068470240e-04,  -7.909756074436759e-06,   2.205799134795837e-07,
  -6.057361142066441e-09,   1.611560940077655e-10,  -4.183737417065895e-12,   1.090979300705286e-13,  -2.639074295202054e-15,   6.419022331159288e-17,  -1.661986497517917e-18,
   3.759765712491042e-20,  -8.088758470185541e-22,   4.486544820507931e-01,  -1.043005979382193e-02,   2.808096366766401e-04,  -7.910878269113268e-06,   2.206246896776903e-07,
  -6.058988198230849e-09,   1.612126566907634e-10,  -4.185496931950374e-12,   1.091514206165706e-13,  -2.640766498755048e-15,   6.423617152395564e-17,  -1.663155890678807e-18,
   3.763082073882819e-20,  -8.097997055058239e-22,   4.486553105822110e-01,  -1.043012964623090e-02,   2.808135293756692e-04,  -7.911056355201575e-06,   2.206317955255552e-07,
  -6.059246410619912e-09,   1.612216332597720e-10,  -4.185776177292539e-12,   1.091599100026852e-13,  -2.641035064651054e-15,   6.424346411414337e-17,  -1.663341498151635e-18,
   3.763608452512892e-20,  -8.099463382831876e-22,   2.487013263468553e-01,  -1.392715072613581e-02,   8.045439174038428e-04,  -3.999213005075350e-05,   1.789440924549403e-06,
  -7.375482104596365e-08,   2.840445212798142e-09,  -1.030705487125943e-10,   3.545711130345819e-12,  -1.163623374293558e-13,   3.649842655527253e-15,  -1.097296741695937e-16,
   3.176323547543466e-18,  -8.850492999383630e-20,   2.487788200782384e-01,  -1.393864866246530e-02,   8.055737324735066e-04,  -4.006304259546869e-05,   1.793549835478727e-06,
  -7.396427013335554e-08,   2.850086570185330e-09,  -1.034788255770812e-10,   3.561778152723107e-12,  -1.169549292114156e-13,   3.670500529737289e-15,  -1.104127795002711e-16,
   3.197807795268190e-18,  -8.914971072858692e-20,   2.489156402844605e-01,  -1.395895347696473e-02,   8.073927636455556e-04,  -4.018833056419564e-05,   1.800811228655357e-06,
  -7.433450755243952e-08,   2.867133595085222e-09,  -1.042008823829915e-10,   3.590200409762178e-12,  -1.180034674538249e-13,   3.707061198973980e-15,  -1.116220191905180e-16,
   3.235847719571924e-18,  -9.029159696714454e-20,   2.490812234641621e-01,  -1.398353447795224e-02,   8.095956094900221e-04,  -4.034010612135337e-05,   1.809610830865608e-06,
  -7.478333183345534e-08,   2.887806308681083e-09,  -1.050768130048582e-10,   3.624691494304777e-12,  -1.192763283262132e-13,   3.751457954087240e-15,  -1.130908939049335e-16,
   3.282069343837055e-18,  -9.167949214436795e-20,   2.492421141531316e-01,  -1.400742685453425e-02,   8.117375061066864e-04,  -4.048773668294378e-05,   1.818173314326011e-06,
  -7.522022753090326e-08,   2.907937222269478e-09,  -1.059301028249044e-10,   3.658303546360480e-12,  -1.205172051816253e-13,   3.794754173000750e-15,  -1.145238368457145e-16,
   3.327175150414305e-18,  -9.303431239949649e-20,   2.493718298757822e-01,  -1.402669544993094e-02,   8.134654380548811e-04,  -4.060687366860292e-05,   1.825085481423606e-06,
  -7.557303561107909e-08,   2.924199086816372e-09,  -1.066196217354415e-10,   3.685473428800735e-12,  -1.215205793708679e-13,   3.829774329656870e-15,  -1.156832170717757e-16,
   3.363680476567229e-18,  -9.413111247636243e-20,   2.494575948088306e-01,  -1.403943818772339e-02,   8.146084245487276e-04,  -4.068569910149418e-05,   1.829659950432131e-06,
  -7.580658204039498e-08,   2.934966543702418e-09,  -1.070762834306511e-10,   3.703472164032522e-12,  -1.221854264441218e-13,   3.852984368398360e-15,  -1.164517790595550e-16,
   3.387885354535569e-18,  -9.485849730056178e-20,   2.495016550151588e-01,  -1.404598540950770e-02,   8.151957741420794e-04,  -4.072621125356734e-05,   1.832011336034649e-06,
  -7.592664845127827e-08,   2.940502931041170e-09,  -1.073111230832450e-10,   3.712729424291897e-12,  -1.225274256844588e-13,   3.864925314241974e-15,  -1.168472358216611e-16,
   3.400341374100279e-18,  -9.523286188225004e-20,   2.495169930910798e-01,  -1.404826474221168e-02,   8.154002656890472e-04,  -4.074031689964173e-05,   1.832830104080466e-06,
  -7.596845923775304e-08,   2.942431001955707e-09,  -1.073929124793702e-10,   3.715953736844092e-12,  -1.226465522292620e-13,   3.869084892656081e-15,  -1.169849998235052e-16,
   3.404680894543877e-18,  -9.536329321779509e-20,   2.495194271520231e-01,  -1.404862646523994e-02,   8.154327184894173e-04,  -4.074255550979821e-05,   1.832960047758446e-06,
  -7.597509501064435e-08,   2.942737011570497e-09,  -1.074058937664745e-10,   3.716465497138080e-12,  -1.226654602728658e-13,   3.869745123021957e-15,  -1.170068668510131e-16,
   3.405369710865534e-18,  -9.538399706371312e-20,   7.890769039401847e-02,  -9.970091109951486e-03,   9.369324437934692e-04,  -6.982462353325472e-05,   4.438930344836232e-06,
  -2.489565915054695e-07,   1.258487349226426e-08,  -5.816476186435976e-10,   2.483197707192494e-11,  -9.870057138700999e-13,   3.673951290235414e-14,  -1.286810540547705e-15,
   4.257784083926904e-17,  -1.334014034380627e-18,   7.900075345642210e-02,  -9.990589410217863e-03,   9.395342951305370e-04,  -7.006817816930862e-05,   4.457444442330034e-06,
  -2.501580610044764e-07,   1.265347438243906e-08,  -5.851640330279298e-10,   2.499607477105656e-11,  -9.940502897092548e-13,   3.701996331404942e-14,  -1.297229566318880e-15,
   4.294089964613273e-17,  -1.345919507014792e-18,   7.916517574087326e-02,  -1.002681646349721e-02,   9.441339640401513e-04,  -7.049886744203484e-05,   4.490192646101101e-06,
  -2.522837933165957e-07,   1.277487750825834e-08,  -5.913884347058154e-10,   2.528660472232421e-11,  -1.006524918526652e-12,   3.751667775090284e-14,  -1.315686076528767e-15,
   4.358412825457728e-17,  -1.367015267496675e-18,   7.936435726405977e-02,  -1.007072076281734e-02,   9.497107266038046e-04,  -7.102125587831380e-05,   4.529928450692061e-06,
  -2.548640272142081e-07,   1.292228753606290e-08,  -5.989486081307889e-10,   2.563958687489788e-11,  -1.021685225710180e-12,   3.812048260810315e-14,  -1.338126973096862e-15,
   4.436638352496672e-17,  -1.392675630511279e-18,   7.955809720677455e-02,  -1.011344528154043e-02,   9.551400757161343e-04,  -7.153005501534735e-05,   4.568646402995446e-06,
  -2.573791384563966e-07,   1.306602925118531e-08,  -6.063231454578635e-10,   2.598401051586026e-11,  -1.036482288494633e-12,   3.870997965962558e-14,  -1.360041567534066e-15,
   4.513046739043232e-17,  -1.417745146452207e-18,   7.971444283786741e-02,  -1.014793752308638e-02,   9.595250351039971e-04,  -7.194113877158319e-05,   4.599939882647024e-06,
  -2.594126537615548e-07,   1.318228457497833e-08,  -6.122893107459949e-10,   2.626273491912314e-11,  -1.048459902430389e-12,   3.918726762631989e-14,  -1.377788694692980e-15,
   4.574937172775481e-17,  -1.438055085617345e-18,   7.981788623613860e-02,  -1.017076563262147e-02,   9.624280050259040e-04,  -7.221336513047625e-05,   4.620668493672609e-06,
  -2.607599831075202e-07,   1.325932922314561e-08,  -6.162440814312970e-10,   2.644753016404654e-11,  -1.056402624595327e-12,   3.950382786655620e-14,  -1.389561355649097e-15,
   4.615998686031599e-17,  -1.451531650427285e-18,   7.987105053721121e-02,  -1.018250018181794e-02,   9.639205116538720e-04,  -7.235334894734741e-05,   4.631329247430478e-06,
  -2.614530219960461e-07,   1.329896509460401e-08,  -6.182788976013359e-10,   2.654262317792107e-11,  -1.060490307679325e-12,   3.966676135736648e-14,  -1.395621334301282e-15,
   4.637137000450790e-17,  -1.458469903397465e-18,   7.988956141620224e-02,  -1.018658628684001e-02,   9.644402619064722e-04,  -7.240210068098413e-05,   4.635042309117415e-06,
  -2.616944191123860e-07,   1.331277183826873e-08,  -6.189877478637406e-10,   2.657575173980766e-11,  -1.061914452134527e-12,   3.972352996844867e-14,  -1.397732821224263e-15,
   4.644502554877803e-17,  -1.460887598013604e-18,   7.989249914911919e-02,  -1.018723478032200e-02,   9.645227519183235e-04,  -7.240983829084251e-05,   4.635631639057022e-06,
  -2.617327339912252e-07,   1.331496330623691e-08,  -6.191002617917297e-10,   2.658101023808666e-11,  -1.062140510212042e-12,   3.973254112550055e-14,  -1.398067992263163e-15,
   4.645671754997144e-17,  -1.461271384520711e-18,   1.579845543011801e-02,  -3.744193217746051e-03,   5.343496238667872e-04,  -5.632627089265839e-05,   4.792624911426832e-06,
  -3.449595599311958e-07,   2.162739320211482e-08,  -1.204807166439151e-09,   6.050097921849743e-11,  -2.768773321677172e-12,   1.164726673863536e-13,  -4.535152860938199e-15,
   1.643960710287771e-16,  -5.569528429216625e-18,   1.585433718552012e-02,  -3.761254502040044e-03,   5.372297033890008e-04,  -5.667112545921794e-05,   4.825063857854932e-06,
  -3.474921815010598e-07,   2.179719990333739e-08,  -1.214813280085286e-09,   6.102790149570350e-11,  -2.793884658105856e-12,   1.175664134632012e-13,  -4.579039432666051e-15,
   1.660289453252692e-16,  -5.626117501413675e-18,   1.595318344457624e-02,  -3.791442055251822e-03,   5.423269676832710e-04,  -5.728160721419885e-05,   4.882501399538636e-06,
  -3.519773772065502e-07,   2.209797279878925e-08,  -1.232539409610033e-09,   6.196148346440120e-11,  -2.838381251220000e-12,   1.195047039182800e-13,  -4.656820600903017e-15,
   1.689231660205419e-16,  -5.726427366427367e-18,   1.607312295431438e-02,  -3.828086414786529e-03,   5.485168177047200e-04,  -5.802319381256617e-05,   4.952294877859701e-06,
  -3.574288715585660e-07,   2.246363078614226e-08,  -1.254094061256518e-09,   6.309691285804824e-11,  -2.892507268780518e-12,   1.218628022135692e-13,  -4.751460501821996e-15,
   1.724451071382809e-16,  -5.848505881608271e-18,   1.618999236344405e-02,  -3.863808453195264e-03,   5.545533179522671e-04,  -5.874666968748881e-05,   5.020405750689571e-06,
  -3.627504543555922e-07,   2.282066515110314e-08,  -1.275145089727793e-09,   6.420603379673907e-11,  -2.945388515773423e-12,   1.241670324552477e-13,  -4.843951426134273e-15,
   1.758875062449870e-16,  -5.967840587822079e-18,   1.628445275173055e-02,  -3.892692233083173e-03,   5.594360062231982e-04,  -5.933204849474752e-05,   5.075531291663013e-06,
  -3.670585637439148e-07,   2.310976842851506e-08,  -1.292194229304382e-09,   6.510446442186934e-11,  -2.988231064940572e-12,   1.260340996282880e-13,  -4.918904081417306e-15,
   1.786774607667111e-16,  -6.064567085447684e-18,   1.634702353867228e-02,  -3.911830418626942e-03,   5.626720991193461e-04,  -5.972011107758574e-05,   5.112083095807127e-06,
  -3.699156509668714e-07,   2.330152994633093e-08,  -1.303504538706542e-09,   6.570055602913646e-11,  -3.016659562521137e-12,   1.272731333900821e-13,  -4.968649137317453e-15,
   1.805292664937493e-16,  -6.128773041212230e-18,   1.637920403157920e-02,  -3.921674991713064e-03,   5.643369923049705e-04,  -5.991978848795301e-05,   5.130893181105617e-06,
  -3.713861136158967e-07,   2.340023400288435e-08,  -1.309326726495390e-09,   6.600742898884544e-11,  -3.031295806183276e-12,   1.279110819114493e-13,  -4.994263069345269e-15,
   1.814828154638139e-16,  -6.161836008975407e-18,   1.639041229913884e-02,  -3.925104066702459e-03,   5.649169524127062e-04,  -5.998934998231822e-05,   5.137446416353312e-06,
  -3.718984334495034e-07,   2.343462476771780e-08,  -1.311355392164603e-09,   6.611435869438608e-11,  -3.036395958298226e-12,   1.281333880009193e-13,  -5.003188986681706e-15,
   1.818151146762118e-16,  -6.173358245665353e-18,   1.639219125549513e-02,  -3.925648336259646e-03,   5.650090068330816e-04,  -6.000039137532395e-05,   5.138486619604910e-06,
  -3.719797558611326e-07,   2.344008381421244e-08,  -1.311677417953217e-09,   6.613133265426763e-11,  -3.037205561171397e-12,   1.281686773725854e-13,  -5.004605917613178e-15,
   1.818678653526705e-16,  -6.175187348400107e-18,   2.352419622290806e-03,  -8.430275878584856e-04,   1.647709774794491e-04,  -2.238839632661557e-05,   2.345669505341373e-06,
  -2.006765643466869e-07,   1.453761354721094e-08,  -9.144379419664365e-10,   5.086999209443798e-11,  -2.538151905426279e-12,   1.148530835131906e-13,  -4.756029333443110e-15,
   1.815753834348358e-16,  -6.424802056870146e-18,   2.370772204751913e-03,  -8.500490079202821e-04,   1.662165157525743e-04,  -2.259306972709405e-05,   2.367838901904326e-06,
  -2.026258352199413e-07,   1.468209275396565e-08,  -9.237037430248813e-10,   5.139407624116963e-11,  -2.564679399542665e-12,   1.160686194476402e-13,  -4.806922750326668e-15,
   1.835374762570828e-16,  -6.494834680889193e-18,   2.403281294482340e-03,  -8.624881494360282e-04,   1.687777423774285e-04,  -2.295575141310211e-05,   2.407126691494180e-06,
  -2.060805337506769e-07,   1.493817129402972e-08,  -9.401276717740726e-10,   5.232308179123057e-11,  -2.611704978943998e-12,   1.182235049326191e-13,  -4.897149352816489e-15,
   1.870161006537003e-16,  -6.619000474917203e-18,   2.442806536760750e-03,  -8.776147487739850e-04,   1.718928512292881e-04,  -2.339693071081687e-05,   2.454923898628471e-06,
  -2.102839569657485e-07,   1.524977890787547e-08,  -9.601147238878174e-10,   5.345371712366356e-11,  -2.668940726024741e-12,   1.208464143826876e-13,  -5.006978343387655e-15,
   1.912506866661695e-16,  -6.770156144113008e-18,   2.481402804945495e-03,  -8.923887843211495e-04,   1.749359130641781e-04,  -2.382797471550929e-05,   2.501629442926633e-06,
  -2.143918633746168e-07,   1.555433719213913e-08,  -9.796513952325624e-10,   5.455896394391859e-11,  -2.724895238515561e-12,   1.234107733659695e-13,  -5.114361823679368e-15,
   1.953911980706374e-16,  -6.917960721896688e-18,   2.512657842369080e-03,  -9.043548355598425e-04,   1.774010043113599e-04,  -2.417719928650458e-05,   2.539474065221200e-06,
  -2.177207715665521e-07,   1.580116348594421e-08,  -9.954859723388690e-10,   5.545483606301391e-11,  -2.770252758580442e-12,   1.254895965356974e-13,  -5.201417734666117e-15,
   1.987480694449476e-16,  -7.037796540903252e-18,   2.533390352079160e-03,  -9.122933551921820e-04,   1.790365913877831e-04,  -2.440893364270046e-05,   2.564588798298491e-06,
  -2.199300975126289e-07,   1.596498792609007e-08,  -1.005996377772040e-09,   5.604951391834762e-11,  -2.800362378807337e-12,   1.268696363616520e-13,  -5.259212512906393e-15,
   2.009767084586596e-16,  -7.117358410968292e-18,   2.544062196456370e-03,  -9.163799468002138e-04,   1.798786195337836e-04,  -2.452824185997241e-05,   2.577519787952473e-06,
  -2.210676806597377e-07,   1.604934463612043e-08,  -1.011408602906977e-09,   5.635574678774704e-11,  -2.815867938868990e-12,   1.275803336522196e-13,  -5.288976520344980e-15,
   2.021244691550151e-16,  -7.158333941776924e-18,   2.547780567633621e-03,  -9.178038814956529e-04,   1.801720260129253e-04,  -2.456981623922430e-05,   2.582025856618356e-06,
  -2.214641032507256e-07,   1.607874162912374e-08,  -1.013294709272698e-09,   5.646246741380107e-11,  -2.821271618118214e-12,   1.278280140993987e-13,  -5.299349485647636e-15,
   2.025244755138803e-16,  -7.172614453856951e-18,   2.548370808967803e-03,  -9.180299143705703e-04,   1.802186012956060e-04,  -2.457641580342580e-05,   2.582741160309929e-06,
  -2.215270326822624e-07,   1.608340823068915e-08,  -1.013594119135584e-09,   5.647940884706783e-11,  -2.822129431871447e-12,   1.278673325728732e-13,  -5.300996165541824e-15,
   2.025879756061719e-16,  -7.174881458095746e-18,   4.106986121976292e-01,  -8.495993730745792e-03,   2.028761498994213e-04,  -5.141571515745612e-06,   1.291625205777195e-07,
  -3.236799666131864e-09,   8.018361874353074e-11,  -1.794644398801719e-12,   4.577146965562678e-14,  -1.091375325015803e-15,   1.890625255376767e-17,  -5.198533801535043e-19,
   1.371093386516493e-20,  -2.161208986118979e-22,   4.107177789593124e-01,  -8.497450596712020e-03,   2.029494490956815e-04,  -5.144636279034892e-06,   1.292767224088591e-07,
  -3.240392757798514e-09,   8.030548232291006e-11,  -1.798399564105506e-12,   4.585403181843775e-14,  -1.094119242739936e-15,   1.899307354623473e-17,  -5.214767327818620e-19,
   1.375340901122059e-20,  -2.168856562984856e-22,   4.107516046765246e-01,  -8.500021965736146e-03,   2.030788392499761e-04,  -5.150046859297351e-06,   1.294783733425207e-07,
  -3.246738870677936e-09,   8.052069043260712e-11,  -1.805033188264424e-12,   4.600001359607509e-14,  -1.098967778682491e-15,   1.914648692942431e-17,  -5.243458403698078e-19,
   1.382860216789995e-20,  -2.182446793245666e-22,   4.107925167567789e-01,  -8.503132497043984e-03,   2.032353888863251e-04,  -5.156594095233631e-06,   1.297224506684749e-07,
  -3.254422975639845e-09,   8.078122616372632e-11,  -1.813067567952047e-12,   4.617704757841442e-14,  -1.104842373519309e-15,   1.933236580988756e-17,  -5.278232088007820e-19,
   1.391994353162253e-20,  -2.199044224206193e-22,   4.108322436172105e-01,  -8.506153408799302e-03,   2.033874585310732e-04,  -5.162954969082272e-06,   1.299596470254364e-07,
  -3.261893386730126e-09,   8.103446842432522e-11,  -1.820880761862355e-12,   4.634944514219436e-14,  -1.110557591144971e-15,   1.951320210682424e-17,  -5.312074191750662e-19,
   1.400905166737346e-20,  -2.215328894857951e-22,   4.108642543136236e-01,  -8.508587920497475e-03,   2.035100312265810e-04,  -5.168082741908181e-06,   1.301509088017890e-07,
  -3.267919209191776e-09,   8.123870582748856e-11,  -1.827184694602205e-12,   4.648871090966301e-14,  -1.115170494648509e-15,   1.965916044203616e-17,  -5.339397787148661e-19,
   1.408114726568065e-20,  -2.228571292310653e-22,   4.108854099644756e-01,  -8.510197045472092e-03,   2.035910580811059e-04,  -5.171472815110698e-06,   1.302773791037521e-07,
  -3.271904766124799e-09,   8.137377441816109e-11,  -1.831354987547289e-12,   4.658092371201406e-14,  -1.118222932100517e-15,   1.975574400222902e-17,  -5.357482663103353e-19,
   1.412893882228151e-20,  -2.237382316384004e-22,   4.108962755024379e-01,  -8.511023545180395e-03,   2.036326794571505e-04,  -5.173214315875344e-06,   1.303423548584634e-07,
  -3.273952716391270e-09,   8.144317332076161e-11,  -1.833498107601632e-12,   4.662833772243219e-14,  -1.119791839689446e-15,   1.980538668153921e-17,  -5.366779399275545e-19,
   1.415352903373191e-20,  -2.241925992858048e-22,   4.109000575274092e-01,  -8.511311237792705e-03,   2.036471677838716e-04,  -5.173820546513130e-06,   1.303649745966911e-07,
  -3.274665711527214e-09,   8.146733377461857e-11,  -1.834244275087747e-12,   4.664484989180820e-14,  -1.120338124957318e-15,   1.982267202653236e-17,  -5.370016694676088e-19,
   1.416209535209790e-20,  -2.243510455493698e-22,   4.109006576909924e-01,  -8.511356891684035e-03,   2.036494669589658e-04,  -5.173916751018413e-06,   1.303685642432865e-07,
  -3.274778862928244e-09,   8.147116796850380e-11,  -1.834362692745873e-12,   4.664747058672256e-14,  -1.120424823001173e-15,   1.982541529356308e-17,  -5.370530479245834e-19,
   1.416345506335178e-20,  -2.243762030096080e-22,   2.033906817978230e-01,  -9.015817785340613e-03,   4.575275382616962e-04,  -2.024971958521011e-05,   8.151620374911988e-07,
  -3.045030200879884e-08,   1.070187780315427e-09,  -3.576007610373319e-11,   1.134027639702670e-12,  -3.452503411631405e-14,   1.014466638918228e-15,  -2.850617319694070e-17,
   7.738107128146631e-19,  -2.041778119446236e-20,   2.034345131152405e-01,  -9.021615844757958e-03,   4.579947866692826e-04,  -2.027887673810884e-05,   8.167034252655501e-07,
  -3.052263090734929e-08,   1.073256830726217e-09,  -3.588061415662742e-11,   1.138469481112923e-12,  -3.467816302743448e-14,   1.019472951458761e-15,  -2.866291468100865e-17,
   7.784855279686443e-19,  -2.055141148427991e-20,   2.035118908287219e-01,  -9.031853385825451e-03,   4.588199673878258e-04,  -2.033038071950986e-05,   8.194267735929805e-07,
  -3.065045131264573e-08,   1.078681796921049e-09,  -3.609373016459531e-11,   1.146324544435205e-12,  -3.494902614758885e-14,   1.028330470556380e-15,  -2.894029252508353e-17,
   7.867600347539743e-19,  -2.078798648843162e-20,   2.036055193412159e-01,  -9.044244289023813e-03,   4.598190025216212e-04,  -2.039275500513150e-05,   8.227259281745853e-07,
  -3.080534594682890e-08,   1.085258081662927e-09,  -3.635215775553929e-11,   1.155852634791002e-12,  -3.527769250444582e-14,   1.039081750718143e-15,  -2.927707663150484e-17,
   7.968096253877748e-19,  -2.107539283830495e-20,   2.036964778365969e-01,  -9.056285279367629e-03,   4.607901252340986e-04,  -2.045340662309406e-05,   8.259350383182756e-07,
  -3.095606411730896e-08,   1.091659387323952e-09,  -3.660379606686701e-11,   1.165133475682910e-12,  -3.559794846654930e-14,   1.049561614369377e-15,  -2.960546569937580e-17,
   8.066117790112566e-19,  -2.135580688157366e-20,   2.037697998233746e-01,  -9.065994033703249e-03,   4.615733648268094e-04,  -2.050233833473925e-05,   8.285248108531118e-07,
  -3.107773129722817e-08,   1.096828515711034e-09,  -3.680705920833796e-11,   1.172632359895633e-12,  -3.585679892363224e-14,   1.058034736293025e-15,  -2.987104982006794e-17,
   8.145414578606763e-19,  -2.158271459731155e-20,   2.038182727154698e-01,  -9.072413663270898e-03,   4.620913643895031e-04,  -2.053470661177826e-05,   8.302383194839901e-07,
  -3.115824966502721e-08,   1.100250225095229e-09,  -3.694163995574893e-11,   1.177598457357376e-12,  -3.602826287012551e-14,   1.063648678705802e-15,  -3.004705255928555e-17,
   8.197975401955262e-19,  -2.173314688919735e-20,   2.038431729899779e-01,  -9.075711767633327e-03,   4.623575208310743e-04,  -2.055134012565438e-05,   8.311189793420199e-07,
  -3.119963773251899e-08,   1.102009306946419e-09,  -3.701083661464416e-11,   1.180152182478943e-12,  -3.611644793559842e-14,   1.066536369423734e-15,  -3.013759620030371e-17,
   8.225018369954913e-19,  -2.181055464821844e-20,   2.038518408931400e-01,  -9.076859912855038e-03,   4.624501811357421e-04,  -2.055713130130302e-05,   8.314256111608835e-07,
  -3.121404928658285e-08,   1.102621869435062e-09,  -3.703493436879992e-11,   1.181041571005141e-12,  -3.614716228740634e-14,   1.067542199546761e-15,  -3.016913589009997e-17,
   8.234438965245826e-19,  -2.183752160211316e-20,   2.038532164238636e-01,  -9.077042117650112e-03,   4.624648861001151e-04,  -2.055805036320814e-05,   8.314742746349461e-07,
  -3.121633648939966e-08,   1.102719088813486e-09,  -3.703875897843658e-11,   1.181182730411616e-12,  -3.615203721658528e-14,   1.067701846216340e-15,  -3.017414199873056e-17,
   8.235934265941271e-19,  -2.184180204868019e-20,   5.002439461103874e-02,  -4.912755730168169e-03,   4.020293545602390e-04,  -2.648486951166392e-05,   1.515431961180730e-06,
  -7.745134879618915e-08,   3.603968985578479e-09,  -1.547222991905680e-10,   6.177365666954269e-12,  -2.311364791661317e-13,   8.148760578414918e-15,  -2.716297407545542e-16,
   8.594225111323518e-18,  -2.586278536174185e-19,   5.006385670500155e-02,  -4.920470400866811e-03,   4.029116419033712e-04,  -2.656016451494999e-05,   1.520701891609603e-06,
  -7.776907253563164e-08,   3.620937888968666e-09,  -1.555412682260120e-10,   6.213570593952176e-12,  -2.326160375614662e-13,   8.205099036311783e-15,  -2.736404968389098e-16,
   8.661790748698485e-18,  -2.607723214192142e-19,   5.013355905342292e-02,  -4.934100747688433e-03,   4.044709098515010e-04,  -2.669326997692131e-05,   1.530020466046960e-06,
  -7.833103123365982e-08,   3.650958169555700e-09,  -1.569904702490962e-10,   6.277650792506209e-12,  -2.352352944054057e-13,   8.304854070234961e-15,  -2.772014601509052e-16,
   8.781466638192297e-18,  -2.645713042898532e-19,   5.021796484195395e-02,  -4.950612909681410e-03,   4.063605907888662e-04,  -2.685464309527169e-05,   1.541322236891409e-06,
  -7.901283029555216e-08,   3.687392953564149e-09,  -1.587498990469182e-10,   6.355472327320215e-12,  -2.384171484781628e-13,   8.426068654045313e-15,  -2.815295620317216e-16,
   8.926958508000633e-18,  -2.691907887367980e-19,   5.030003136795365e-02,  -4.966674307688604e-03,   4.081994639287747e-04,  -2.701174264450068e-05,   1.552329118902970e-06,
  -7.967709470245159e-08,   3.722903841855751e-09,  -1.604653131772024e-10,   6.431372058040882e-12,  -2.415213959754925e-13,   8.544361257532085e-15,  -2.857544795747518e-16,
   9.069017618865341e-18,  -2.737023295448896e-19,   5.036623410355995e-02,  -4.979635893357850e-03,   4.096839970570675e-04,  -2.713861683833358e-05,   1.561221481609858e-06,
  -8.021393092320149e-08,   3.751611974460924e-09,  -1.618525388543090e-10,   6.492768790774252e-12,  -2.440331757056961e-13,   8.640101600046509e-15,  -2.891747477692893e-16,
   9.184046807558834e-18,  -2.773562009786160e-19,   5.041002430253507e-02,  -4.988211823103727e-03,   4.106665000294442e-04,  -2.722260843593569e-05,   1.567109836922997e-06,
  -8.056950335343745e-08,   3.770631366242087e-09,  -1.627717988921627e-10,   6.533462781808328e-12,  -2.456983333730968e-13,   8.703583751149401e-15,  -2.914430139034413e-16,
   9.260344875948943e-18,  -2.797801570089371e-19,   5.043252647190778e-02,  -4.992619423108265e-03,   4.111715421359273e-04,  -2.726579025099047e-05,   1.570137641288813e-06,
  -8.075236713480297e-08,   3.780414086257077e-09,  -1.632446901087798e-10,   6.554399543562947e-12,  -2.465551501183027e-13,   8.736252612678101e-15,  -2.926104221278350e-16,
   9.299617083833332e-18,  -2.810279316251583e-19,   5.044036075705546e-02,  -4.994154078131643e-03,   4.113474030976058e-04,  -2.728082774136663e-05,   1.571192110027302e-06,
  -8.081605602429455e-08,   3.783821497661639e-09,  -1.634094128477636e-10,   6.561692902236174e-12,  -2.468536405305326e-13,   8.747634104319290e-15,  -2.930171548536808e-16,
   9.313300399464546e-18,  -2.814627023330936e-19,   5.044160405462711e-02,  -4.994397632839328e-03,   4.113753134395611e-04,  -2.728321434793302e-05,   1.571359468836838e-06,
  -8.082616454355033e-08,   3.784362323089675e-09,  -1.634355581861543e-10,   6.562850548796053e-12,  -2.469010195523368e-13,   8.749440703000957e-15,  -2.930817169996344e-16,
   9.315472430682663e-18,  -2.815317168428646e-19,   6.416073580944532e-03,  -1.254839496079749e-03,   1.582860192301588e-04,  -1.509585487121560e-05,   1.183375480265356e-06,
  -7.949882692517554e-08,   4.699676890273674e-09,  -2.489167428447849e-10,   1.196523568721450e-11,  -5.271703588637362e-13,   2.145336464153317e-14,  -8.114477741147903e-16,
   2.867466855717433e-17,  -9.499618808259345e-19,   6.432330027666641e-03,  -1.259364234641323e-03,   1.589914421365175e-04,  -1.517479174725239e-05,   1.190382846104665e-06,
  -8.001932408920776e-08,   4.733101432216102e-09,  -2.508138382698090e-10,   1.206192149038224e-11,  -5.316479929588322e-13,   2.164355212270659e-14,  -8.189121922478371e-16,
   2.894703222303909e-17,  -9.592399162676086e-19,   6.461073399298715e-03,  -1.267367035037261e-03,   1.602394716269137e-04,  -1.531448331319470e-05,   1.202786468700112e-06,
  -8.094084468163195e-08,   4.792289686430328e-09,  -2.541737969909357e-10,   1.223318875024257e-11,  -5.395806758240579e-13,   2.198053430881895e-14,  -8.321394205640890e-16,
   2.942971842019786e-17,  -9.756840119356244e-19,   6.495930325646368e-03,  -1.277076276510347e-03,   1.617542409898432e-04,  -1.548409411033467e-05,   1.217851753182320e-06,
  -8.206044862163526e-08,   4.864220016546368e-09,  -2.582580758007123e-10,   1.244142181737664e-11,  -5.492273912570489e-13,   2.239039989327797e-14,  -8.482299580548831e-16,
   3.001697334793296e-17,  -9.956930157750637e-19,   6.529873928511872e-03,  -1.286535612766291e-03,   1.632306737759805e-04,  -1.564947846845110e-05,   1.232546923011350e-06,
  -8.315289960902102e-08,   4.934426205763439e-09,  -2.622454901059898e-10,   1.264476352559014e-11,  -5.586494629809652e-13,   2.279079521834130e-14,  -8.639513201058064e-16,
   3.059083965915888e-17,  -1.015248433334937e-18,   6.557293930188588e-03,  -1.294180189022513e-03,   1.644243224757392e-04,  -1.578323386586034e-05,   1.244435504078554e-06,
  -8.403695937929554e-08,   4.991254741971719e-09,  -2.654738515063798e-10,   1.280943048157275e-11,  -5.662808974927220e-13,   2.311514983711516e-14,  -8.766888439325254e-16,
   3.105584995045469e-17,  -1.031096264391437e-18,   6.575449603462652e-03,  -1.299243490430710e-03,   1.652151515564399e-04,  -1.587187417169663e-05,   1.252315977200567e-06,
  -8.462309169015018e-08,   5.028939242155208e-09,  -2.676150259169306e-10,   1.291866054706140e-11,  -5.713438143325303e-13,   2.333036224834230e-14,  -8.851412288305840e-16,
   3.136445203811121e-17,  -1.041614518814317e-18,   6.584784875400567e-03,  -1.301847423829497e-03,   1.656219266197168e-04,  -1.591747485590757e-05,   1.256370632220998e-06,
  -8.492470633141536e-08,   5.048333311006403e-09,  -2.687170787954536e-10,   1.297488589161345e-11,  -5.739501244019831e-13,   2.344115827711722e-14,  -8.894929832921964e-16,
   3.152334666670030e-17,  -1.047030492756497e-18,   6.588035928848039e-03,  -1.302754333949311e-03,   1.657636114149891e-04,  -1.593335928282909e-05,   1.257783111881595e-06,
  -8.502978290541390e-08,   5.055090172120388e-09,  -2.691010500291253e-10,   1.299447643320492e-11,  -5.748582722265052e-13,   2.347976554667062e-14,  -8.910094126078120e-16,
   3.157871717748507e-17,  -1.048917858948880e-18,   6.588551912995294e-03,  -1.302898275983358e-03,   1.657860997326384e-04,  -1.593588052534118e-05,   1.258007310884482e-06,
  -8.504646170964515e-08,   5.056162705332101e-09,  -2.691619995765715e-10,   1.299758617004725e-11,  -5.750024301678000e-13,   2.348589406411172e-14,  -8.912501327135748e-16,
   3.158750683937644e-17,  -1.049217466591912e-18,   5.286515626958517e-04,  -1.761109616560895e-04,   3.257943342006533e-05,  -4.239822127500181e-06,   4.290978314351963e-07,
  -3.568335037961270e-08,   2.524645639078526e-09,  -1.556678188168202e-10,   8.513524746846727e-12,  -4.185882877468341e-13,   1.870096762099237e-14,  -7.657765910284206e-16,
   2.894809859085533e-17,  -1.015343683034493e-18,   5.322348287560513e-04,  -1.774317704261207e-04,   3.284262768156602e-05,  -4.276082806796381e-06,   4.329362422683801e-07,
  -3.601433623162064e-08,   2.548772415720696e-09,  -1.571929951007028e-10,   8.598714743596780e-12,  -4.228531156653808e-13,   1.889449710125124e-14,  -7.738096871632666e-16,
   2.925541113397596e-17,  -1.026236648842833e-18,   5.385802972572122e-04,  -1.797711475174050e-04,   3.330886241365084e-05,  -4.340325275713497e-06,   4.397374706867086e-07,
  -3.660086318840963e-08,   2.591530157663338e-09,  -1.598961297375598e-10,   8.749710406357427e-12,  -4.304127766867829e-13,   1.923755711262781e-14,  -7.880502032778754e-16,
   2.980021581407980e-17,  -1.045548445933664e-18,   5.462921856901956e-04,  -1.826149766208794e-04,   3.387575819817847e-05,  -4.418452491444386e-06,   4.480099771969847e-07,
  -3.731436909331057e-08,   2.643550852354477e-09,  -1.631852079920735e-10,   8.933453327492424e-12,  -4.396126839818431e-13,   1.965508194479215e-14,  -8.053828830581777e-16,
   3.046335661709590e-17,  -1.069056141729990e-18,   5.538196064548633e-04,  -1.853915101919713e-04,   3.442936950823596e-05,  -4.494764260159540e-06,   4.560916445884247e-07,
  -3.801151807334283e-08,   2.694385487027577e-09,  -1.663996542396239e-10,   9.113044526228499e-12,  -4.486054934029969e-13,   2.006323924619677e-14,  -8.223278506597380e-16,
   3.111170362416671e-17,  -1.092040685429192e-18,   5.599129673311181e-04,  -1.876396043490384e-04,   3.487770902946882e-05,  -4.556575996356605e-06,   4.626387065219822e-07,
  -3.857636116450932e-08,   2.735577312478255e-09,  -1.690046096624934e-10,   9.258596040242782e-12,  -4.558943637591079e-13,   2.039408217941615e-14,  -8.360638844830249e-16,
   3.163729925646127e-17,  -1.110674483941437e-18,   5.639537707786854e-04,  -1.891306802513967e-04,   3.517512141644862e-05,  -4.597585077278641e-06,   4.669828510563865e-07,
  -3.895118525275518e-08,   2.762914065368413e-09,  -1.707335011839674e-10,   9.355203767587316e-12,  -4.607325191616625e-13,   2.061369777155654e-14,  -8.451823563607461e-16,
   3.198622248343669e-17,  -1.123045210605162e-18,   5.660333843735313e-04,  -1.898981466498551e-04,   3.532821562691734e-05,  -4.618696330444871e-06,   4.692193438133263e-07,
  -3.914416682930203e-08,   2.776989344765197e-09,  -1.716237200352996e-10,   9.404949694631674e-12,  -4.632239001869257e-13,   2.072679098541805e-14,  -8.498781292524324e-16,
   3.216591308301406e-17,  -1.129416100528108e-18,   5.667579249414937e-04,  -1.901655456896249e-04,   3.538155864114188e-05,  -4.626052444358181e-06,   4.699986628520955e-07,
  -3.921141416990314e-08,   2.781894200249779e-09,  -1.719339434891315e-10,   9.422285457581602e-12,  -4.640921251821734e-13,   2.076620354410998e-14,  -8.515146084397969e-16,
   3.222853603470248e-17,  -1.131636405212335e-18,   5.668729333678127e-04,  -1.902079913114909e-04,   3.539002615829090e-05,  -4.627220145369790e-06,   4.701223721922669e-07,
  -3.922208911743010e-08,   2.782672809965533e-09,  -1.719831894729027e-10,   9.425037413149330e-12,  -4.642299516878853e-13,   2.077246012222513e-14,  -8.517743935866607e-16,
   3.223847723425586e-17,  -1.131988872744454e-18,   3.796137730567591e-01,  -7.088962586407337e-03,   1.517388618683572e-04,  -3.502828170685271e-06,   8.031766892917875e-08,
  -1.781883174076313e-09,   4.536513471446153e-11,  -8.471444080674709e-13,   1.610704367868073e-14,  -6.300074656507379e-16,   7.624491483211479e-18,  -3.630018226713865e-20,
   8.155824057509907e-21,  -2.059007389072797e-23,   3.796280899787485e-01,  -7.089953692689943e-03,   1.517844037218689e-04,  -3.504513024273634e-06,   8.038197295707051e-08,
  -1.783584901369290e-09,   4.540811874586320e-11,  -8.492758482721456e-13,   1.614084685690601e-14,  -6.302042304905033e-16,   7.675358338664340e-18,  -3.653368449196968e-20,
   8.165138394658580e-21,  -2.208305584399130e-23,   3.796533559278467e-01,  -7.091702903105582e-03,   1.518647925676895e-04,  -3.507487282478711e-06,   8.049548784947911e-08,
  -1.786591040145558e-09,   4.548403788142613e-11,  -8.530373553597558e-13,   1.620066789849102e-14,  -6.305524894688310e-16,   7.765155857008457e-18,  -3.695467234256935e-20,
   8.181145773795827e-21,  -2.472452998852681e-23,   3.796839137784168e-01,  -7.093818728448843e-03,   1.519620499837237e-04,  -3.511086018532198e-06,   8.063283559951301e-08,
  -1.790231917369632e-09,   4.557596507000180e-11,  -8.575867452430923e-13,   1.627330228515456e-14,  -6.309754485980591e-16,   7.873810396757988e-18,  -3.747905620793432e-20,
   8.199776346243768e-21,  -2.793047414838014e-23,   3.797135850906625e-01,  -7.095873427964437e-03,   1.520565185610849e-04,  -3.514581948022524e-06,   8.076625880063662e-08,
  -1.793772515574132e-09,   4.566533757549781e-11,  -8.620041963671771e-13,   1.634412681989796e-14,  -6.313880105985919e-16,   7.979362243362824e-18,  -3.800419690550343e-20,
   8.217107612355996e-21,  -3.105485674626762e-23,   3.797374924148667e-01,  -7.097529163820149e-03,   1.521326590359276e-04,  -3.517399900722385e-06,   8.087380617473221e-08,
  -1.796629144916134e-09,   4.573742912549364e-11,  -8.655635432070363e-13,   1.640140600734278e-14,  -6.317217933020744e-16,   8.064443660533023e-18,  -3.843878679762278e-20,
   8.230532049499236e-21,  -3.358028519338875e-23,   3.797532921531490e-01,  -7.098623487824840e-03,   1.521829898274193e-04,  -3.519262775597548e-06,   8.094490261654834e-08,
  -1.798518894328238e-09,   4.578511216395970e-11,  -8.679158424912330e-13,   1.643936471531056e-14,  -6.319430596534591e-16,   8.120688015268521e-18,  -3.873161737556264e-20,
   8.239140976984975e-21,  -3.525310483410978e-23,   3.797614067565812e-01,  -7.099185550805291e-03,   1.522088428264347e-04,  -3.520219705309194e-06,   8.098142364917168e-08,
  -1.799490032820855e-09,   4.580961400155342e-11,  -8.691239679930125e-13,   1.645889224239723e-14,  -6.320569116943031e-16,   8.149579515961205e-18,  -3.888375267729690e-20,
   8.243481443983845e-21,  -3.611341598805346e-23,   3.797642312271769e-01,  -7.099381193953007e-03,   1.522178421117238e-04,  -3.520552813960280e-06,   8.099413665902016e-08,
  -1.799828151822072e-09,   4.581814437136677e-11,  -8.695444842296318e-13,   1.646569437681938e-14,  -6.320965743316372e-16,   8.159636625020765e-18,  -3.893698398276371e-20,
   8.244979374109015e-21,  -3.641305070658053e-23,   3.797646794369151e-01,  -7.099412240394874e-03,   1.522192702176675e-04,  -3.520605675638552e-06,   8.099615411123857e-08,
  -1.799881811652565e-09,   4.581949813188936e-11,  -8.696112151766587e-13,   1.646677403822930e-14,  -6.321028699297358e-16,   8.161232604479539e-18,  -3.894544431684355e-20,
   8.245216467445486e-21,  -3.646060786083105e-23,   1.733705378755722e-01,  -6.144512138534885e-03,   2.764298028014562e-04,  -1.096268203235082e-05,   3.990705573609343e-07,
  -1.359955390971272e-08,   4.343848921763934e-10,  -1.345227208447221e-11,   3.965138935984255e-13,  -1.101381798790303e-14,   3.051121822947794e-16,  -8.139333273299565e-18,
   2.024047576441981e-19,  -5.109326450332439e-21,   1.733969109109992e-01,  -6.147641150322396e-03,   2.766578061373400e-04,  -1.097566001798645e-05,   3.996940883722871e-07,
  -1.362664998472083e-08,   4.354533236374266e-10,  -1.349058355027578e-11,   3.978432630657082e-13,  -1.105731255609232e-14,   3.064159761057317e-16,  -8.178304946647764e-18,
   2.035059447351953e-19,  -5.138271329587963e-21,   1.734434643498772e-01,  -6.153165348411775e-03,   2.770604097702081e-04,  -1.099858072013472e-05,   4.007955511006333e-07,
  -1.367452332201936e-08,   4.373414505642697e-10,  -1.355830520786544e-11,   4.001934737474542e-13,  -1.113422443881442e-14,   3.087221440236516e-16,  -8.247245276228223e-18,
   2.054547559075153e-19,  -5.189501533061978e-21,   1.734997876367161e-01,  -6.159850399234368e-03,   2.775477341117008e-04,  -1.102633224858656e-05,   4.021295552888518e-07,
  -1.373251792794675e-08,   4.396294817891747e-10,  -1.364040068926729e-11,   4.030430893153639e-13,  -1.122750900752091e-14,   3.115203607968290e-16,  -8.330906326161633e-18,
   2.078211005743191e-19,  -5.251717309647109e-21,   1.735544971329024e-01,  -6.166345508719051e-03,   2.780213355773533e-04,  -1.105331024278868e-05,   4.034267893116756e-07,
  -1.378892889830614e-08,   4.418557900296642e-10,  -1.372031339838224e-11,   4.058175435305369e-13,  -1.131836389692961e-14,   3.142468723392925e-16,  -8.412435561859650e-18,
   2.101286154804368e-19,  -5.312396637700609e-21,   1.735985932076052e-01,  -6.171581740668141e-03,   2.784032324153972e-04,  -1.107507011219211e-05,   4.044734066910142e-07,
  -1.383445235798792e-08,   4.436529545692531e-10,  -1.378484496567359e-11,   4.080584210241503e-13,  -1.139176784076561e-14,   3.164505341605941e-16,  -8.478338966843269e-18,
   2.119949221502388e-19,  -5.361481413923350e-21,   1.736277422852472e-01,  -6.175043638773859e-03,   2.786557641785168e-04,  -1.108946175472491e-05,   4.051657684779491e-07,
  -1.386457243060057e-08,   4.448422929237146e-10,  -1.382756224651791e-11,   4.095420041159594e-13,  -1.144037605267394e-14,   3.179102168000955e-16,  -8.521996925640606e-18,
   2.132317756463448e-19,  -5.394015104294632e-21,   1.736427151891559e-01,  -6.176822073642388e-03,   2.787855073703272e-04,  -1.109685660822984e-05,   4.055215694417950e-07,
  -1.388005259479075e-08,   4.454536335105572e-10,  -1.384952313313531e-11,   4.103047778016118e-13,  -1.146537095732847e-14,   3.186609306764408e-16,  -8.544451495546534e-18,
   2.138680835511266e-19,  -5.410753496908944e-21,   1.736479271960743e-01,  -6.177441167268169e-03,   2.788306746020462e-04,  -1.109943110073017e-05,   4.056454474587793e-07,
  -1.388544252949897e-08,   4.456665051498380e-10,  -1.385717056724789e-11,   4.105704088000923e-13,  -1.147407580244208e-14,   3.189223982975582e-16,  -8.552272450519790e-18,
   2.140897354874414e-19,  -5.416584354486438e-21,   1.736487542959321e-01,  -6.177539413319716e-03,   2.788378424434512e-04,  -1.109983966790661e-05,   4.056651070093689e-07,
  -1.388629792915845e-08,   4.457002891709321e-10,  -1.385838428761760e-11,   4.106125674593369e-13,  -1.147545738554325e-14,   3.189638979082858e-16,  -8.553513786530833e-18,
   2.141249171041919e-19,  -5.417509864332048e-21,   3.525085801183130e-02,  -2.648756182411487e-03,   1.905628039152234e-04,  -1.108189738806344e-05,   5.699164459554155e-07,
  -2.651324950294383e-08,   1.130193849555006e-09,  -4.495891499428197e-11,   1.673700576717131e-12,  -5.860527219172260e-14,   1.950011703442433e-15,  -6.162770173804844e-17,
   1.853763125926333e-18,  -5.340465763436896e-20,   3.526938570503412e-02,  -2.651963415668581e-03,   1.908926893533524e-04,  -1.110752880933445e-05,   5.715601356767365e-07,
  -2.660506769670893e-08,   1.134766506614835e-09,  -4.516547848704277e-11,   1.682319148185517e-12,  -5.893925561302440e-14,   1.962104893085164e-15,  -6.204089883852452e-17,
   1.867086207843787e-18,  -5.381170418111687e-20,   3.530210437984429e-02,  -2.657628626245363e-03,   1.914755420055683e-04,  -1.115282686548889e-05,   5.744657509771856e-07,
  -2.676741732495557e-08,   1.142853664684509e-09,  -4.553089144644306e-11,   1.697568783043401e-12,  -5.953033018964100e-14,   1.983511466737615e-15,  -6.277244773726598e-17,
   1.890678721564320e-18,  -5.453261794355462e-20,   3.534171298356604e-02,  -2.664489296275581e-03,   1.921816390674406e-04,  -1.120772301431772e-05,   5.779883019124921e-07,
  -2.696430442827340e-08,   1.152664575019788e-09,  -4.597433907399588e-11,   1.716080629911397e-12,  -6.024806439467223e-14,   2.009512675962517e-15,  -6.366124334498692e-17,
   1.919350189536715e-18,  -5.540892651665574e-20,   3.538021133265031e-02,  -2.671160250523980e-03,   1.928684750403354e-04,  -1.126114244923626e-05,   5.814174291768445e-07,
  -2.715603953441521e-08,   1.162222250773593e-09,  -4.640649584357344e-11,   1.734127031146231e-12,  -6.094797953453467e-14,   2.034876204515957e-15,  -6.452848179209562e-17,
   1.947334354606469e-18,  -5.626443606726581e-20,   3.541125881706651e-02,  -2.676541986076157e-03,   1.934227636957450e-04,  -1.130426775238287e-05,   5.841867065258954e-07,
  -2.731093003699384e-08,   1.169945786944776e-09,  -4.675583203980179e-11,   1.748719161398943e-12,  -6.151408631478265e-14,   2.055396411993393e-15,  -6.523028824104488e-17,
   1.969986146410892e-18,  -5.695707751295840e-20,   3.543179096486480e-02,  -2.680101916109231e-03,   1.937895094524132e-04,  -1.133280895253033e-05,   5.860199388428161e-07,
  -2.741349042133646e-08,   1.175061134204378e-09,  -4.698725414195309e-11,   1.758387969907092e-12,  -6.188927082337605e-14,   2.068998835658284e-15,  -6.569558578524047e-17,
   1.985007123622571e-18,  -5.741645861229037e-20,   3.544234031841993e-02,  -2.681931278875367e-03,   1.939780000442790e-04,  -1.134748008318680e-05,   5.869624264118417e-07,
  -2.746622557428217e-08,   1.177691755259451e-09,  -4.710628224891372e-11,   1.763361601092472e-12,  -6.208229023416719e-14,   2.075997663069832e-15,  -6.593502050936094e-17,
   1.992737558938081e-18,  -5.765289829902500e-20,   3.544601293185906e-02,  -2.682568191422124e-03,   1.940436296691747e-04,  -1.135258871212369e-05,   5.872906327261354e-07,
  -2.748459096014980e-08,   1.178607947803424e-09,  -4.714774003499684e-11,   1.765094031175846e-12,  -6.214952725641451e-14,   2.078435793539086e-15,  -6.601843479652621e-17,
   1.995430828477850e-18,  -5.773527705002700e-20,   3.544659576369642e-02,  -2.682669269507166e-03,   1.940540453144231e-04,  -1.135339948600359e-05,   5.873427223777735e-07,
  -2.748750578938523e-08,   1.178753362523094e-09,  -4.715432019013824e-11,   1.765369006287802e-12,  -6.216019945068832e-14,   2.078822792163702e-15,  -6.603167514443130e-17,
   1.995858337731011e-18,  -5.774835340112375e-20,   3.115937364487242e-03,  -4.815338392800199e-04,   5.312678454853399e-05,  -4.522231260606333e-06,   3.230361963647763e-07,
  -2.005828597929882e-08,   1.107835070373655e-09,  -5.533532774869694e-11,   2.527361549872715e-12,  -1.064736953654285e-13,   4.166416544099463e-15,  -1.522413400971677e-16,
   5.218529529088971e-18,  -1.683164922544981e-19,   3.121301699449352e-03,  -4.828755989244145e-04,   5.331780455723777e-05,  -4.542009393900632e-06,   3.246777650542990e-07,
  -2.017334331158128e-08,   1.114858976462024e-09,  -5.571669756357732e-11,   2.546058674372493e-12,  -1.073105183449536e-13,   4.200906979406941e-15,  -1.535596180127814e-16,
   5.265515118637474e-18,  -1.698842333112214e-19,   3.130782845083542e-03,  -4.852478490956185e-04,   5.365563303455547e-05,  -4.576997821714153e-06,   3.275825239822283e-07,
  -2.037698515793456e-08,   1.127293356958223e-09,  -5.639196519644088e-11,   2.579170293899268e-12,  -1.087927224252464e-13,   4.262006112181238e-15,  -1.558952213779020e-16,
   5.348769508560600e-18,  -1.726624216477757e-19,   3.142274348083890e-03,  -4.881244178876946e-04,   5.406545551717010e-05,  -4.619459309002558e-06,   3.311089781268730e-07,
  -2.062429313960839e-08,   1.142398525883243e-09,  -5.721249737743169e-11,   2.619414822759789e-12,  -1.105946239699480e-13,   4.336298634803354e-15,  -1.587356730957639e-16,
   5.450036085782739e-18,  -1.760421646318102e-19,   3.153458221488310e-03,  -4.909253566608417e-04,   5.446468626069428e-05,  -4.660840939833472e-06,   3.345470887460719e-07,
  -2.086549096704582e-08,   1.157135247130059e-09,  -5.801324915412316e-11,   2.658699550912361e-12,  -1.123539717207914e-13,   4.408852259654363e-15,  -1.615101773379701e-16,
   5.548968800216910e-18,  -1.793445294471128e-19,   3.162487992828041e-03,  -4.931877994191987e-04,   5.478729404954094e-05,  -4.694292921497827e-06,   3.373273404058933e-07,
  -2.106059840816016e-08,   1.169059340428256e-09,  -5.866133852554320e-11,   2.690502121337768e-12,  -1.137785357752905e-13,   4.467610941869104e-15,  -1.637575372273851e-16,
   5.629117083542155e-18,  -1.820202399627345e-19,   3.168464605647439e-03,  -4.946857453838999e-04,   5.500095453803062e-05,  -4.716454056821668e-06,   3.391696607015539e-07,
  -2.118991536544378e-08,   1.176964281617945e-09,  -5.909106414681889e-11,   2.711592942864694e-12,  -1.147234252954727e-13,   4.506590067021806e-15,  -1.652485710333956e-16,
   5.682298337083720e-18,  -1.837958499048962e-19,   3.171536947625403e-03,  -4.954559301208488e-04,   5.511083023885468e-05,  -4.727852409110482e-06,   3.401173846574569e-07,
  -2.125644768651805e-08,   1.181031812938775e-09,  -5.931220726162841e-11,   2.722447714248560e-12,  -1.152097753031073e-13,   4.526654949105004e-15,  -1.660161533080203e-16,
   5.709677850600620e-18,  -1.847100498734704e-19,   3.172606792694781e-03,  -4.957241461895188e-04,   5.514909751120368e-05,  -4.731822506115167e-06,   3.404475042953023e-07,
  -2.127962429098216e-08,   1.182448823863869e-09,  -5.938925120743248e-11,   2.726229581989905e-12,  -1.153792298310703e-13,   4.533646243547109e-15,  -1.662836146102098e-16,
   5.719218442365709e-18,  -1.850286184089560e-19,   3.172776585560887e-03,  -4.957667153291698e-04,   5.515517114137861e-05,  -4.732452638619504e-06,   3.404999018757554e-07,
  -2.128330302125186e-08,   1.182673744269837e-09,  -5.940148049044031e-11,   2.726829891140197e-12,  -1.154061282878695e-13,   4.534756023261311e-15,  -1.663260711542207e-16,
   5.720732920664242e-18,  -1.850791885582184e-19,   1.365866806149413e-04,  -4.072397315882485e-05,   6.985200280573616e-06,  -8.576633281325784e-07,   8.291591689879382e-08,
  -6.644609994843832e-09,   4.560028935055179e-10,  -2.741017409245095e-11,   1.467147872140601e-12,  -7.082129015197027e-14,   3.114251977853670e-15,  -1.257779223805268e-16,
   4.697636138528744e-18,  -1.630259768458514e-19,   1.373431596479526e-04,  -4.098897952762284e-05,   7.035767084308680e-06,  -8.643853094278894e-07,   8.360667672519237e-08,
  -6.702710657435610e-09,   4.601496937115699e-10,  -2.766762657314613e-11,   1.481305849274959e-12,  -7.152053331175810e-14,   3.145607621479243e-15,  -1.270658756211250e-16,
   4.746451366793966e-18,  -1.647419789050637e-19,   1.386823142604969e-04,  -4.145821178284158e-05,   7.125320741623174e-06,  -8.762919263609704e-07,   8.483039193512085e-08,
  -6.805651448921518e-09,   4.674976277655481e-10,  -2.812386181507065e-11,   1.506397399774348e-12,  -7.275985723536250e-14,   3.201185130958292e-15,  -1.293488824550870e-16,
   4.832984742162161e-18,  -1.677840202701753e-19,   1.403090459336007e-04,  -4.202838960383329e-05,   7.234170369193216e-06,  -8.907674691301898e-07,   8.631843038547939e-08,
  -6.930849010719975e-09,   4.764355748931160e-10,  -2.867889243479780e-11,   1.536925802422330e-12,  -7.426786628334800e-14,   3.268817676091233e-15,  -1.321272978999993e-16,
   4.938302926514025e-18,  -1.714866601423156e-19,   1.418960349183937e-04,  -4.258482619447612e-05,   7.340428544961080e-06,  -9.049019752231651e-07,   8.777172483868846e-08,
  -7.053145876128442e-09,   4.851678227022004e-10,  -2.922122392066795e-11,   1.566759283341536e-12,  -7.574170308660171e-14,   3.334923758881631e-15,  -1.348432280796551e-16,
   5.041260113372768e-18,  -1.751065331407489e-19,   1.431800887093167e-04,  -4.303518168530520e-05,   7.426452071845580e-06,  -9.163474337094885e-07,   8.894875896681822e-08,
  -7.152211168048258e-09,   4.922422797413853e-10,  -2.966064874920602e-11,   1.590934460125861e-12,  -7.693611863181852e-14,   3.388501333819371e-15,  -1.370445918429998e-16,
   5.124716210292785e-18,  -1.780409376358114e-19,   1.440313156338957e-04,  -4.333379826665649e-05,   7.483502730099775e-06,  -9.239393023081756e-07,   8.972960551521026e-08,
  -7.217939159668814e-09,   4.969365365716629e-10,  -2.995225525085871e-11,   1.606978589752796e-12,  -7.772886029754150e-14,   3.424063280525174e-15,  -1.385058184659758e-16,
   5.180115553836276e-18,  -1.799889205381411e-19,   1.444693124471103e-04,  -4.348747119917160e-05,   7.512865373223979e-06,  -9.278470494297372e-07,   9.013156305886030e-08,
  -7.251776497856963e-09,   4.993533305486854e-10,  -3.010239418391416e-11,   1.615239589910542e-12,  -7.813705371960355e-14,   3.442375272626988e-15,  -1.392582753512821e-16,
   5.208644198446180e-18,  -1.809920866031516e-19,   1.446218968727220e-04,  -4.354100931287412e-05,   7.523095573605107e-06,  -9.292086045054155e-07,   9.027162034756736e-08,
  -7.263567101379588e-09,   5.001954850651727e-10,  -3.015471278644502e-11,   1.618118345079306e-12,  -7.827930174686599e-14,   3.448756776447420e-15,  -1.395205011666171e-16,
   5.218586356416367e-18,  -1.813416914569923e-19,   1.446461163608546e-04,  -4.354950748888491e-05,   7.524719452978085e-06,  -9.294247323632095e-07,   9.029385274329431e-08,
  -7.265438735113672e-09,   5.003291693295180e-10,  -3.016301794312299e-11,   1.618575327194015e-12,  -7.830188274636354e-14,   3.449769805947117e-15,  -1.395621282910641e-16,
   5.220164633785822e-18,  -1.813971900085301e-19,   3.534472400165722e-01,  -6.023701819233368e-03,   1.164109423599543e-04,  -2.450955096065833e-06,   5.386617378249747e-08,
  -9.383216262156395e-10,   2.588626474761090e-11,  -6.321268076692680e-13,  -4.507069717409761e-16,  -2.467987180074648e-16,   1.397922564219306e-17,   2.849749249817952e-19,
   2.189298400137602e-21,  -3.817218436028759e-22,   3.534582147633549e-01,  -6.024394287117651e-03,   1.164414475199388e-04,  -2.451845352756467e-06,   5.390257865543410e-08,
  -9.395787389941001e-10,   2.588630503335786e-11,  -6.329247848922041e-13,  -3.915010552550323e-16,  -2.454404015550682e-16,   1.398726051635076e-17,   2.821278388949789e-19,
   2.068337047049446e-21,  -3.828434185122932e-22,   3.534775822265969e-01,  -6.025616363020822e-03,   1.164952910051968e-04,  -2.453417186733924e-06,   5.396681615516899e-08,
  -9.417981945215986e-10,   2.588650259744298e-11,  -6.343291830786585e-13,  -2.870085073592811e-16,  -2.430556177335985e-16,   1.400084496236390e-17,   2.770984764332712e-19,
   1.856279324417177e-21,  -3.847453066945739e-22,   3.535010055777160e-01,  -6.027094460683431e-03,   1.165604275138361e-04,  -2.455319506183877e-06,   5.404449382683640e-08,
  -9.444841287697320e-10,   2.588695718017916e-11,  -6.360212036245491e-13,  -1.606175370558882e-16,  -2.401923649307372e-16,   1.401626469945912e-17,   2.710076186893677e-19,
   1.602211810637943e-21,  -3.869143702231496e-22,   3.535237487593926e-01,  -6.028529739462062e-03,   1.166236906401476e-04,  -2.457167964253796e-06,   5.411990314025234e-08,
  -9.470938283766254e-10,   2.588762438088222e-11,  -6.376573317334983e-13,  -3.788188194947790e-17,  -2.374342052347437e-16,   1.403018576511869e-17,   2.650853728315519e-19,
   1.358034842919560e-21,  -3.888842229053511e-22,   3.535420733793346e-01,  -6.029686244582386e-03,   1.166746758946983e-04,  -2.458658290475501e-06,   5.418065283310919e-08,
  -9.491977706944144e-10,   2.588832374939840e-11,  -6.389707697925801e-13,   6.101800189705256e-17,  -2.352276392479455e-16,   1.404065368704150e-17,   2.603080660548082e-19,
   1.163097747211564e-21,  -3.903745256677268e-22,   3.535541834351343e-01,  -6.030450571489226e-03,   1.167083764731596e-04,  -2.459643675163390e-06,   5.422079563960643e-08,
  -9.505888013896272e-10,   2.588886514992098e-11,  -6.398364195185585e-13,   1.263813429922316e-16,  -2.337771109485443e-16,   1.404720682649007e-17,   2.571482723722200e-19,
   1.035153088872361e-21,  -3.913122999163642e-22,   3.535604029839574e-01,  -6.030843129810838e-03,   1.167256865584818e-04,  -2.460149904090005e-06,   5.424141105123535e-08,
  -9.513034040878173e-10,   2.588916770200011e-11,  -6.402802789972932e-13,   1.599521710663412e-16,  -2.330345253650933e-16,   1.405046001386934e-17,   2.555246520801383e-19,
   9.697153559267434e-22,  -3.917794231590714e-22,   3.535625678274402e-01,  -6.030979769680130e-03,   1.167317120057488e-04,  -2.460326131437596e-06,   5.424858646015532e-08,
  -9.515521665816129e-10,   2.588927691133238e-11,  -6.404346581709924e-13,   1.716373730001146e-16,  -2.327764326967077e-16,   1.405157449182905e-17,   2.549593925691596e-19,
   9.469818200329315e-22,  -3.919397119201495e-22,   3.535629113617308e-01,  -6.031001452847051e-03,   1.167326681856262e-04,  -2.460354097702265e-06,   5.424972509998297e-08,
  -9.515916435896217e-10,   2.588929442665569e-11,  -6.404591507921355e-13,   1.734916803827493e-16,  -2.327354945612147e-16,   1.405175049864712e-17,   2.548696868944359e-19,
   9.433763465850995e-22,  -3.919650385714855e-22,   1.525121606008949e-01,  -4.368271618971949e-03,   1.757509065245140e-04,  -6.293298229425071e-06,   2.069362053817452e-07,
  -6.557302680496876e-09,   1.891892424575775e-10,  -5.313799595375781e-12,   1.537958802879263e-13,  -3.848879071677524e-15,   9.188475152787954e-17,  -2.663419623148677e-18,
   5.914709971984251e-20,  -1.123068068490893e-21,   1.525288739989175e-01,  -4.370063595858810e-03,   1.758688399123677e-04,  -6.299535653082344e-06,   2.072071376777189e-07,
  -6.567977509647458e-09,   1.896012551243504e-10,  -5.327157667880920e-12,   1.541958900532015e-13,  -3.862949429629762e-15,   9.226699267757690e-17,  -2.672022212502377e-18,
   5.949776645073774e-20,  -1.130022774012329e-21,   1.525583742259401e-01,  -4.373227009278190e-03,   1.760770602911120e-04,  -6.310549887735908e-06,   2.076856763138966e-07,
  -6.586834976886818e-09,   1.903291191901072e-10,  -5.350767054156431e-12,   1.549030389412383e-13,  -3.887813265804089e-15,   9.294323051516220e-17,  -2.687244041319009e-18,
   6.011681731423386e-20,  -1.142374663782647e-21,   1.525940618636019e-01,  -4.377054702638551e-03,   1.763290559864655e-04,  -6.323882415236239e-06,   2.082651398105760e-07,
  -6.609674437734624e-09,   1.912107306220920e-10,  -5.379382100080680e-12,   1.557603949451136e-13,  -3.917941187004910e-15,   9.376395900028769e-17,  -2.705723099958092e-18,
   6.086588700181736e-20,  -1.157446998074722e-21,   1.526287231994790e-01,  -4.380773138905360e-03,   1.765739126954420e-04,  -6.336840074462910e-06,   2.088285214745318e-07,
  -6.631885192703328e-09,   1.920681260506715e-10,  -5.407230633195768e-12,   1.565950774710283e-13,  -3.947254254548807e-15,   9.456386607380266e-17,  -2.723738751080378e-18,
   6.159360884924684e-20,  -1.172221109604455e-21,   1.526566576739395e-01,  -4.383770510973085e-03,   1.767713264555254e-04,  -6.347289119130489e-06,   2.092829829995864e-07,
  -6.649805584658907e-09,   1.927599394800442e-10,  -5.429714938137784e-12,   1.572691931104514e-13,  -3.970915453593886e-15,   9.521052451265977e-17,  -2.738307027179700e-18,
   6.218024274013872e-20,  -1.184224385026385e-21,   1.526751220340808e-01,  -4.385752026426117e-03,   1.769018525320825e-04,  -6.354198818133812e-06,   2.095835813055271e-07,
  -6.661660637000571e-09,   1.932176201115864e-10,  -5.444596618388874e-12,   1.577154736529926e-13,  -3.986573396980072e-15,   9.563893364867778e-17,  -2.747960580286676e-18,
   6.256807334418435e-20,  -1.192205441106331e-21,   1.526846061474453e-01,  -4.386769909523776e-03,   1.769689082312811e-04,  -6.357748874744806e-06,   2.097380452007355e-07,
  -6.667752975628039e-09,   1.934528289839604e-10,  -5.452246640670695e-12,   1.579449192179266e-13,  -3.994621636542747e-15,   9.585928521648032e-17,  -2.752926546107458e-18,
   6.276730317483269e-20,  -1.196319370473175e-21,   1.526879074635301e-01,  -4.387124237658795e-03,   1.769922514532336e-04,  -6.358984758551893e-06,   2.097918224701242e-07,
  -6.669874139140422e-09,   1.935347223403695e-10,  -5.454910506203552e-12,   1.580248211341192e-13,  -3.997424037018532e-15,   9.593603520759228e-17,  -2.754656336181443e-18,
   6.283665657572160e-20,  -1.197753689997090e-21,   1.526884313503895e-01,  -4.387180466771490e-03,   1.769959558848958e-04,  -6.359180888355423e-06,   2.098003568799114e-07,
  -6.670210770354684e-09,   1.935477189585701e-10,  -5.455333282201707e-12,   1.580375024283581e-13,  -3.997868793372951e-15,   9.594821696683114e-17,  -2.754930893710957e-18,
   6.284766246346460e-20,  -1.197981411989116e-21,   2.703824055392310e-02,  -1.533648414836221e-03,   9.861435566755457e-05,  -5.071265056035679e-06,   2.335447725314938e-07,
  -9.961243283948352e-09,   3.868628033539456e-10,  -1.416751370027637e-11,   4.955606607307361e-13,  -1.612048619887806e-14,   5.009389104250530e-16,  -1.516344372567840e-17,
   4.285761923490134e-19,  -1.166601575808309e-20,   2.704775579104450e-02,  -1.535108509367718e-03,   9.874889429091993e-05,  -5.080846723662328e-06,   2.341047943756021e-07,
  -9.990039878748995e-09,   3.882094336814334e-10,  -1.422406431602861e-11,   4.977641982900278e-13,  -1.620219595972111e-14,   5.037235931894765e-16,  -1.525328407386383e-17,
   4.314205357972765e-19,  -1.174738700120400e-20,   2.706455621365572e-02,  -1.537687102718410e-03,   9.898654971478119e-05,  -5.097775956277416e-06,   2.350945194636209e-07,
  -1.004094350221647e-08,   3.905903418344823e-10,  -1.432407557875503e-11,   5.016620436782133e-13,  -1.634675541744207e-14,   5.086516931792120e-16,  -1.541229971453150e-17,
   4.364552050742752e-19,  -1.189149820431135e-20,   2.708488961544532e-02,  -1.540808977352063e-03,   9.927436884994684e-05,  -5.118284916511562e-06,   2.362939654440403e-07,
  -1.010265310812027e-08,   3.934774880334443e-10,  -1.444539772113897e-11,   5.063918801798081e-13,  -1.652220982615436e-14,   5.146355545949328e-16,  -1.560542238239426e-17,
   4.425701568547844e-19,  -1.206666536779628e-20,   2.710464795597161e-02,  -1.543843635650689e-03,   9.955424391076188e-05,  -5.138234464122088e-06,   2.374611569957739e-07,
  -1.016272382703403e-08,   3.962888079240011e-10,  -1.456358181923143e-11,   5.110008672028433e-13,  -1.669322206152260e-14,   5.204705719448905e-16,  -1.579378416637962e-17,
   4.485347831367151e-19,  -1.223766635688888e-20,   2.712057866310185e-02,  -1.546291183563187e-03,   9.978004140008923e-05,  -5.154334123336839e-06,   2.384034338642156e-07,
  -1.021123382168484e-08,   3.985596940591539e-10,  -1.465908141607475e-11,   5.147262648044089e-13,  -1.683147875676771e-14,   5.251898560331317e-16,  -1.594615962644769e-17,
   4.533601740806245e-19,  -1.237610629258143e-20,   2.713111207670341e-02,  -1.547909884509344e-03,   9.992940796669279e-05,  -5.164986494232111e-06,   2.390270554989071e-07,
  -1.024334613379866e-08,   4.000632585403911e-10,  -1.472232909499667e-11,   5.171940532574880e-13,  -1.692307747032962e-14,   5.283174362287041e-16,  -1.604715766510822e-17,
   4.565587031822878e-19,  -1.246792047064860e-20,   2.713652355744686e-02,  -1.548741599648398e-03,   1.000061654813958e-04,  -5.170461330670909e-06,   2.393476189915296e-07,
  -1.025985522858372e-08,   4.008363407768359e-10,  -1.475485416102348e-11,   5.184632735965961e-13,  -1.697019248199996e-14,   5.299264358103977e-16,  -1.609912135482688e-17,
   4.582043978821147e-19,  -1.251517537081810e-20,   2.713840740233939e-02,  -1.549031154956798e-03,   1.000328897020333e-04,  -5.172367587989955e-06,   2.394592424651487e-07,
  -1.026560421942353e-08,   4.011055672742915e-10,  -1.476618187475528e-11,   5.189053389472190e-13,  -1.698660319381007e-14,   5.304869149644139e-16,  -1.611722314932491e-17,
   4.587776905134334e-19,  -1.253163943102141e-20,   2.713870635822177e-02,  -1.549077106683854e-03,   1.000371308507243e-04,  -5.172670117553471e-06,   2.394769578720243e-07,
  -1.026651664039007e-08,   4.011482968465345e-10,  -1.476797976249481e-11,   5.189755029523384e-13,  -1.698920791291916e-14,   5.305758767581785e-16,  -1.612009638413464e-17,
   4.588686875972294e-19,  -1.253425283704744e-20,   1.789267583805671e-03,  -2.089003734046413e-04,   2.018867946758935e-05,  -1.516920219639310e-06,   9.779103464045400e-08,
  -5.574000664138604e-09,   2.851317124106494e-10,  -1.332638108332730e-11,   5.745890063930964e-13,  -2.298093528858301e-14,   8.592378855600077e-16,  -3.017240826442487e-17,
   9.973823841095407e-19,  -3.117078947931333e-20,   1.791275534126154e-03,  -2.093462856093126e-04,   2.024606733101568e-05,  -1.522378778407206e-06,   9.821090837841556e-08,
  -5.601549547660634e-09,   2.867199270088271e-10,  -1.340828454955607e-11,   5.784270288771391e-13,  -2.314606944547401e-14,   8.658041544576250e-16,  -3.041564357703262e-17,
   1.005818969525180e-18,  -3.144513425945199e-20,   1.794823257064271e-03,  -2.101343938903384e-04,   2.034752563752139e-05,  -1.532031897233322e-06,   9.895362971752292e-08,
  -5.650293239648259e-09,   2.895306778869423e-10,  -1.355326470094462e-11,   5.852221514806623e-13,  -2.343848673936055e-14,   8.774335393186282e-16,  -3.084649415698717e-17,
   1.020764942003202e-18,  -3.193121759728615e-20,   1.799121163447644e-03,  -2.110895844763735e-04,   2.047054577815129e-05,  -1.543741121407096e-06,   9.985489308199747e-08,
  -5.709462351785022e-09,   2.929436900655228e-10,  -1.372936288803633e-11,   5.934779864295704e-13,  -2.379385123188002e-14,   8.915696117181427e-16,  -3.137031859597506e-17,
   1.038939499451676e-18,  -3.252241128988245e-20,   1.803301848355564e-03,  -2.120191769273261e-04,   2.059032387034018e-05,  -1.555146619451575e-06,   1.007331381551688e-07,
  -5.767141819448155e-09,   2.962719197508300e-10,  -1.390114223379037e-11,   6.015336840310063e-13,  -2.414069299447897e-14,   9.053701042392966e-16,  -3.188181791041043e-17,
   1.056689959090541e-18,  -3.309992289356045e-20,   1.806675747777458e-03,  -2.127697027316790e-04,   2.068706847754697e-05,  -1.564362307587662e-06,   1.014430215433018e-07,
  -5.813779436742009e-09,   2.989638308129136e-10,  -1.404011923923211e-11,   6.080527723935674e-13,  -2.442144127969579e-14,   9.165432725870365e-16,  -3.229601741475228e-17,
   1.071066374426870e-18,  -3.356774103421650e-20,   1.808908099289616e-03,  -2.132664499858035e-04,   2.075111964963520e-05,  -1.570465393613313e-06,   1.019132678470678e-07,
  -5.844681042029025e-09,   3.007478649586416e-10,  -1.413224422652688e-11,   6.123749625276216e-13,  -2.460761116770561e-14,   9.239536368232953e-16,  -3.257076500332597e-17,
   1.080603804303847e-18,  -3.387813508075259e-20,   1.810055428342891e-03,  -2.135218052207496e-04,   2.078405140374745e-05,  -1.573603808081351e-06,   1.021551235563964e-07,
  -5.860576604862832e-09,   3.016656834434682e-10,  -1.417964510492879e-11,   6.145991039422983e-13,  -2.470342169286053e-14,   9.277676827549292e-16,  -3.271218699814393e-17,
   1.085513429198850e-18,  -3.403793027256200e-20,   1.810454911635094e-03,  -2.136107240519945e-04,   2.079551972177501e-05,  -1.574696829167639e-06,   1.022393612849550e-07,
  -5.866113361357541e-09,   3.019853985581294e-10,  -1.419615780260109e-11,   6.153739522500998e-13,  -2.473680183529816e-14,   9.290965461357423e-16,  -3.276146216926871e-17,
   1.087224133588267e-18,  -3.409361109019950e-20,   1.810518311012614e-03,  -2.136248361502217e-04,   2.079733987649400e-05,  -1.574870308244315e-06,   1.022527313893420e-07,
  -5.866992165933763e-09,   3.020361452907673e-10,  -1.419877882362021e-11,   6.154969439876287e-13,  -2.474210034355189e-14,   9.293074825597899e-16,  -3.276928392772421e-17,
   1.087495687370236e-18,  -3.410244984418785e-20,   4.244543950489507e-05,  -1.068530357361974e-05,   1.658549173445348e-06,  -1.884702013053528e-07,   1.716017362250981e-08,
  -1.310729787535370e-09,   8.648820047443008e-11,  -5.032557144164529e-12,   2.621254603104466e-13,  -1.236369065645713e-14,   5.330210634333373e-16,  -2.116294550773168e-17,
   7.787469735697359e-19,  -2.667740429853182e-20,   4.262181327640845e-05,  -1.074297672083712e-05,   1.668942932870414e-06,  -1.897890901497912e-07,   1.729061085341867e-08,
  -1.321357576714351e-09,   8.722672346330559e-11,  -5.077378132201013e-12,   2.645428220429881e-13,  -1.248109249840042e-14,   5.382092174591826e-16,  -2.137334546859550e-17,
   7.866319995236838e-19,  -2.695182907883588e-20,   4.293391048514724e-05,  -1.084505942151311e-05,   1.687344642659598e-06,  -1.921246153127629e-07,   1.752163381686982e-08,
  -1.340183758796176e-09,   8.853512120407915e-11,  -5.156793755156712e-12,   2.688264175328803e-13,  -1.268914776159408e-14,   5.474041625207605e-16,  -2.174626105979937e-17,
   8.006083407294097e-19,  -2.743827698447694e-20,   4.331281081848950e-05,  -1.096904169004653e-05,   1.709701767876753e-06,  -1.949629912808308e-07,   1.780246734769810e-08,
  -1.363073894391880e-09,   9.012624923072380e-11,  -5.253385433957185e-12,   2.740371834809272e-13,  -1.294226616352943e-14,   5.585918345839702e-16,  -2.220003679449904e-17,
   8.176166039959183e-19,  -2.803029453594585e-20,   4.368222558859712e-05,  -1.108997167150628e-05,   1.731516598385459e-06,  -1.977333932252470e-07,   1.807664888613737e-08,
  -1.385426937521326e-09,   9.168034727949112e-11,  -5.347745101485542e-12,   2.791282867098106e-13,  -1.318960351825486e-14,   5.695252182689949e-16,  -2.264354245387393e-17,
   8.342413948862752e-19,  -2.860900970229763e-20,   4.398096015170027e-05,  -1.118780103381277e-05,   1.749170068363495e-06,  -1.999759440347550e-07,   1.829864262518542e-08,
  -1.403528947982319e-09,   9.293910969731235e-11,  -5.424184397534038e-12,   2.832530447057180e-13,  -1.339001633826726e-14,   5.783852155667372e-16,  -2.300297402255200e-17,
   8.477157232392084e-19,  -2.907808861705094e-20,   4.417891754997613e-05,  -1.125264605481776e-05,   1.760874304925951e-06,  -2.014630599453709e-07,   1.844588041143967e-08,
  -1.415536930121574e-09,   9.377421736132738e-11,  -5.474902532421176e-12,   2.859901190350571e-13,  -1.352301581043873e-14,   5.842653855019379e-16,  -2.324153563831239e-17,
   8.566594075365959e-19,  -2.938945910781222e-20,   4.428075127911318e-05,  -1.128600938128091e-05,   1.766897116022164e-06,  -2.022284005318706e-07,   1.852166394717337e-08,
  -1.421718011376793e-09,   9.420412009037307e-11,  -5.501013307459706e-12,   2.873993040263509e-13,  -1.359149413511298e-14,   5.872930811584679e-16,  -2.336437562274883e-17,
   8.612648423866715e-19,  -2.954980024600900e-20,   4.431622302925366e-05,  -1.129763172122461e-05,   1.768995342931080e-06,  -2.024950449633004e-07,   1.854806817626601e-08,
  -1.423871689605182e-09,   9.435391662993199e-11,  -5.510111695889294e-12,   2.878903522040166e-13,  -1.361535681263994e-14,   5.883481650663372e-16,  -2.340718335540482e-17,
   8.628697866831711e-19,  -2.960567818367133e-20,   4.432185321768341e-05,  -1.129947649804560e-05,   1.769328394418571e-06,  -2.025373701408122e-07,   1.855225944972937e-08,
  -1.424213557743017e-09,   9.437769511259118e-11,  -5.511555973761184e-12,   2.879683017860254e-13,  -1.361914482889927e-14,   5.885156525173432e-16,  -2.341397883009204e-17,
   8.631245633105888e-19,  -2.961454855517249e-20,   3.310477788547283e-01,  -5.196645698006294e-03,   9.164402773936225e-05,  -1.711581771654483e-06,   3.985148702841265e-08,
  -5.348392207310442e-10,   7.553396780177478e-12,  -6.582981376557005e-13,   3.309677855527984e-15,   4.914098618412335e-16,   1.807394850946896e-17,  -3.938389728761469e-19,
  -3.251420564547372e-20,  -4.896171791152722e-22,   3.310564155885366e-01,  -5.197128885435296e-03,   9.166650487134848e-05,  -1.712093840868398e-06,   3.986223086212262e-08,
  -5.361098790086588e-10,   7.563518112209449e-12,  -6.566956133838615e-13,   3.379955184076983e-15,   4.892771769120029e-16,   1.788613632582799e-17,  -3.965865025056844e-19,
  -3.222498237817695e-20,  -4.741628988856687e-22,   3.310716569619059e-01,  -5.197981596200649e-03,   9.170617106780113e-05,  -1.712998355782377e-06,   3.988120065408226e-08,
  -5.383494383290626e-10,   7.581523756067320e-12,  -6.538738579189318e-13,   3.503328202225680e-15,   4.855033391054032e-16,   1.755618839888399e-17,  -4.013460485882054e-19,
  -3.171509905962585e-20,  -4.471440543265401e-22,   3.310900899276234e-01,  -5.199012906129306e-03,   9.175414428940227e-05,  -1.714093741696580e-06,   3.990415992128064e-08,
  -5.410532178025331e-10,   7.603545074997861e-12,  -6.504718807442588e-13,   3.651437218697889e-15,   4.809220097692433e-16,   1.715968178697767e-17,  -4.069514270578021e-19,
  -3.109935625674482e-20,  -4.148979151222164e-22,   3.311079874046637e-01,  -5.200014296683387e-03,   9.180072469866467e-05,  -1.715158835769716e-06,   3.992647029652332e-08,
  -5.436734850578965e-10,   7.625182266926437e-12,  -6.471799215023053e-13,   3.794097537838121e-15,   4.764560384226787e-16,   1.677734418697044e-17,  -4.122373222275249e-19,
  -3.050250193343425e-20,  -3.840370946763904e-22,   3.311224075814532e-01,  -5.200821156443045e-03,   9.183825560533990e-05,  -1.716018087449918e-06,   3.994445904784885e-08,
  -5.457811091736859e-10,   7.642797861505183e-12,  -6.445355888531730e-13,   3.908222444271775e-15,   4.728452790510163e-16,   1.647118781753077e-17,  -4.163849053203634e-19,
  -3.002235954659398e-20,  -3.594919710541458e-22,   3.311319372556619e-01,  -5.201354389745861e-03,   9.186305846301646e-05,  -1.716586465337330e-06,   3.995635347232253e-08,
  -5.471722109749175e-10,   7.654528162171744e-12,  -6.427920019785759e-13,   3.983243487762881e-15,   4.704530622339969e-16,   1.626979015845369e-17,  -4.190717317210425e-19,
  -2.970543370435253e-20,  -3.434270495614574e-22,   3.311368315328325e-01,  -5.201628253688893e-03,   9.187579687719582e-05,  -1.716878539935391e-06,   3.996246424244571e-08,
  -5.478861206035749e-10,   7.660580067203377e-12,  -6.418977450551614e-13,   4.021649829812322e-15,   4.692226176588536e-16,   1.616664255406767e-17,  -4.204349774707594e-19,
  -2.954278612793792e-20,  -3.352244512611089e-22,   3.311385350839155e-01,  -5.201723578225225e-03,   9.188023075176556e-05,  -1.716980228674095e-06,   3.996459153702817e-08,
  -5.481345257892347e-10,   7.662690913220151e-12,  -6.415866752820337e-13,   4.034998339950719e-15,   4.687940450871405e-16,   1.613078560523820e-17,  -4.209068368036609e-19,
  -2.948619274426370e-20,  -3.323770129014483e-22,   3.311388054165312e-01,  -5.201738705091173e-03,   9.188093435385275e-05,  -1.716996366676732e-06,   3.996492912767727e-08,
  -5.481739405881739e-10,   7.663026085357851e-12,  -6.415373215563317e-13,   4.037115655130937e-15,   4.687260220736109e-16,   1.612509771449075e-17,  -4.209815896250664e-19,
  -2.947721299382285e-20,  -3.319255218783472e-22,   1.374408758856266e-01,  -3.216635882575055e-03,   1.164512312585077e-04,  -3.826796673488747e-06,   1.115512222036506e-07,
  -3.353588337569220e-09,   9.242095422306886e-11,  -2.085406029640699e-12,   5.968346775610214e-14,  -1.818396210187116e-15,   2.493034089141797e-17,  -5.234222006240063e-19,
   3.843284420070190e-20,  -1.947663971278663e-22,   1.374519206436757e-01,  -3.217723373917389e-03,   1.165147239835105e-04,  -3.829976105904678e-06,   1.116830731483019e-07,
  -3.357792912921088e-09,   9.257997139105134e-11,  -2.091615905687395e-12,   5.979608179493723e-14,  -1.821176135639363e-15,   2.516257126610121e-17,  -5.254174438458948e-19,
   3.831096229424913e-20,  -2.053344165612061e-22,   1.374714142220743e-01,  -3.219643002732919e-03,   1.166268186400947e-04,  -3.835589499750428e-06,   1.119159089537488e-07,
  -3.365221927952385e-09,   9.286080452149448e-11,  -2.102581019257965e-12,   5.999558270948074e-14,  -1.826090296745280e-15,   2.557174455987378e-17,  -5.289988671485926e-19,
   3.809699729957153e-20,  -2.238295039897368e-22,   1.374949944730793e-01,  -3.221965489147571e-03,   1.167624683285249e-04,  -3.842382797299616e-06,   1.121977682780641e-07,
  -3.374222190148853e-09,   9.320080956127431e-11,  -2.115853280632001e-12,   6.023816981918358e-14,  -1.832047965773956e-15,   2.606550065340901e-17,  -5.334325969764083e-19,
   3.784015736504124e-20,  -2.459356582581748e-22,   1.375178945812230e-01,  -3.224221429178654e-03,   1.168942632939766e-04,  -3.848983401948847e-06,   1.124717191738684e-07,
  -3.382977320655470e-09,   9.353132041034773e-11,  -2.128751533174736e-12,   6.047507952019356e-14,  -1.837847925657121e-15,   2.654376672320325e-17,  -5.378439075350301e-19,
   3.759282150596949e-20,  -2.671273064116494e-22,   1.375363489248355e-01,  -3.226039724508334e-03,   1.170005134648279e-04,  -3.854304915709833e-06,   1.126926447390663e-07,
  -3.390043123983683e-09,   9.379789183256572e-11,  -2.139152080526484e-12,   6.066694014831146e-14,  -1.842532170998813e-15,   2.692829298425496e-17,  -5.414738115078358e-19,
   3.739501913603007e-20,  -2.840078713112407e-22,   1.375485463191753e-01,  -3.227241681802830e-03,   1.170707598285518e-04,  -3.857823312276384e-06,   1.128387432008533e-07,
  -3.394718343452931e-09,   9.397419270739271e-11,  -2.146029422350212e-12,   6.079421188973071e-14,  -1.845633311612485e-15,   2.718201106433278e-17,  -5.439094832746433e-19,
   3.726503000264197e-20,  -2.950691864003554e-22,   1.375548112215322e-01,  -3.227859086725345e-03,   1.171068464982220e-04,  -3.859630807032744e-06,   1.129138072647354e-07,
  -3.397121229747883e-09,   9.406477973687545e-11,  -2.149562766330321e-12,   6.085972457983481e-14,  -1.847227725551336e-15,   2.731219331366140e-17,  -5.451717431382866e-19,
   3.719849681246860e-20,  -3.007210340253761e-22,   1.375569919305064e-01,  -3.228074002826974e-03,   1.171194086731631e-04,  -3.860260022431601e-06,   1.129399396546893e-07,
  -3.397957884822682e-09,   9.409631704669108e-11,  -2.150792817968442e-12,   6.088255115004208e-14,  -1.847782968395787e-15,   2.735748629642708e-17,  -5.456128991384694e-19,
   3.717537485407201e-20,  -3.026836576053249e-22,   1.375573379862198e-01,  -3.228108108128449e-03,   1.171214022065317e-04,  -3.860359875011825e-06,   1.129440867735673e-07,
  -3.398090665106895e-09,   9.410132194744481e-11,  -2.150988021567149e-12,   6.088617456474824e-14,  -1.847871091696231e-15,   2.736467280833774e-17,  -5.456829905958525e-19,
   3.717170740661912e-20,  -3.029948829601888e-22,   2.216922347744321e-02,  -9.370526904921641e-04,   5.493558087874532e-05,  -2.532241881967767e-06,   1.024365991921157e-07,
  -4.069543919190409e-09,   1.464187948214849e-10,  -4.742073497519658e-12,   1.577073822432310e-13,  -5.004832506432081e-15,   1.345509685181591e-16,  -3.863686621802014e-18,
   1.186548914972035e-19,  -2.541589526152084e-21,   2.217449177410182e-02,  -9.377786242760868e-04,   5.499439494290342e-05,  -2.536138186571257e-06,   1.026475607860725e-07,
  -4.079158396226004e-09,   1.468450811859243e-10,  -4.759507621313332e-12,   1.582995600268596e-13,  -5.025536711042440e-15,   1.353103092524014e-16,  -3.883582617593259e-18,
   1.191933702588321e-19,  -2.565321228052780e-21,   2.218379239305290e-02,  -9.390604510132269e-04,   5.509827096151005e-05,  -2.543020691828718e-06,   1.030202980846120e-07,
  -4.096151466517042e-09,   1.475985489351211e-10,  -4.790327797410622e-12,   1.593470937636017e-13,  -5.062154355433065e-15,   1.366529215010704e-16,  -3.918830691621921e-18,
   1.201466478269404e-19,  -2.607209690806664e-21,   2.219504669494730e-02,  -9.406119941508330e-04,   5.522404565693480e-05,  -2.551355747896343e-06,   1.034718563425341e-07,
  -4.116747771623651e-09,   1.485118344302059e-10,  -4.827693899947752e-12,   1.606182680246490e-13,  -5.106577713395349e-15,   1.382811115496419e-16,  -3.961693988352775e-18,
   1.213047178342040e-19,  -2.657885480642289e-21,   2.220598044981572e-02,  -9.421198243260808e-04,   5.534632032425667e-05,  -2.559460549491108e-06,   1.039111025651227e-07,
  -4.136792762058814e-09,   1.494007284315766e-10,  -4.864071112983454e-12,   1.618570072331090e-13,  -5.149855408019603e-15,   1.398666545391705e-16,  -4.003557333897146e-18,
   1.224346010037379e-19,  -2.707106614729531e-21,   2.221479447320727e-02,  -9.433356737517091e-04,   5.544494856917431e-05,  -2.565999196027999e-06,   1.042655859583769e-07,
  -4.152976952971020e-09,   1.501184557531580e-10,  -4.893449958041325e-12,   1.628582965849645e-13,  -5.184828820676260e-15,   1.411474855147865e-16,  -4.037462801287445e-18,
   1.233488952939804e-19,  -2.746777839184366e-21,   2.222062152957199e-02,  -9.441396543033440e-04,   5.551018179439912e-05,  -2.570324485681808e-06,   1.045001322533747e-07,
  -4.163688929189719e-09,   1.505935244526183e-10,  -4.912899186047752e-12,   1.635215866685732e-13,  -5.207992373081983e-15,   1.419955722131216e-16,  -4.059955527681904e-18,
   1.239550510975392e-19,  -2.773001630235163e-21,   2.222361490117373e-02,  -9.445527128187422e-04,   5.554370118924599e-05,  -2.572547173808958e-06,   1.046206789425068e-07,
  -4.169195536174820e-09,   1.508377449173558e-10,  -4.922898506248914e-12,   1.638627304778420e-13,  -5.219904617965668e-15,   1.424316431734501e-16,  -4.071534023692359e-18,
   1.242669639797092e-19,  -2.786471880681259e-21,   2.222465691478573e-02,  -9.446965096506123e-04,   5.555537094946389e-05,  -2.573321030904365e-06,   1.046626516030219e-07,
  -4.171113036358603e-09,   1.509227879067437e-10,  -4.926380647142658e-12,   1.639815503587227e-13,  -5.224053437768815e-15,   1.425835073696871e-16,  -4.075568388602264e-18,
   1.243756274874527e-19,  -2.791160820498229e-21,   2.222482227479466e-02,  -9.447193295584066e-04,   5.555722292345706e-05,  -2.573443842295149e-06,   1.046693128117897e-07,
  -4.171417358786750e-09,   1.509362849488606e-10,  -4.926933299752066e-12,   1.640004093146969e-13,  -5.224711924378150e-15,   1.426076101963766e-16,  -4.076208793902775e-18,
   1.243928756113882e-19,  -2.791904914320603e-21,   1.190203214846352e-03,  -1.001668988734145e-04,   8.624997356582514e-06,  -5.696629798592919e-07,   3.270662540435011e-08,
  -1.709643256185830e-09,   8.060402461124816e-11,  -3.485241859110158e-12,   1.413871681988370e-13,  -5.348326783815548e-15,   1.888606507829212e-16,  -6.355481943910158e-18,
   2.025352675353713e-19,  -6.036586926392782e-21,   1.191050097855198e-03,  -1.003329886714827e-04,   8.644063267557923e-06,  -5.713263153461019e-07,   3.282459786651508e-08,
  -1.716808460547628e-09,   8.099264175402992e-11,  -3.504202153666037e-12,   1.422269692310465e-13,  -5.382941967429822e-15,   1.901878428273635e-16,  -6.402449472071907e-18,
   2.041170729422964e-19,  -6.087285044966359e-21,   1.192545970406827e-03,  -1.006264477212819e-04,   8.677760418216715e-06,  -5.742668526577882e-07,   3.303321336907288e-08,
  -1.729482376189215e-09,   8.168018138496629e-11,  -3.537754239369113e-12,   1.437134290293057e-13,  -5.444220813428692e-15,   1.925377672014368e-16,  -6.485630445916964e-18,
   2.069186375513268e-19,  -6.177084532731297e-21,   1.194357414423338e-03,  -1.009819691047777e-04,   8.718601383204974e-06,  -5.778320710086993e-07,   3.328624430261243e-08,
  -1.744860433435566e-09,   8.251466928047303e-11,  -3.578490439761548e-12,   1.455187647344662e-13,  -5.518661427330549e-15,   1.953931225270698e-16,  -6.586736981807996e-18,
   2.103241812671713e-19,  -6.286255603531945e-21,   1.196118679380020e-03,  -1.013278033243390e-04,   8.758347716066354e-06,  -5.813030811465040e-07,   3.353269141128752e-08,
  -1.759844428057060e-09,   8.332803867742949e-11,  -3.618209352896459e-12,   1.472796429420408e-13,  -5.591285917543421e-15,   1.981795514556335e-16,  -6.685439157050435e-18,
   2.136489977461906e-19,  -6.392851285264696e-21,   1.197539502128617e-03,  -1.016069053853905e-04,   8.790437643833732e-06,  -5.841064312932876e-07,   3.373180698668292e-08,
  -1.771955016997978e-09,   8.398562256648653e-11,  -3.650330628232505e-12,   1.487041402507785e-13,  -5.650049164052403e-15,   2.004346839582011e-16,  -6.765347473646801e-18,
   2.163409265035712e-19,  -6.479165034389466e-21,   1.198479322470906e-03,  -1.017915774255058e-04,   8.811676814064440e-06,  -5.859623416819268e-07,   3.386366400621895e-08,
  -1.779976944695535e-09,   8.442129250009741e-11,  -3.671616762255776e-12,   1.496483462584728e-13,  -5.689005469865001e-15,   2.019299513109006e-16,  -6.818343444357423e-18,
   2.181263346197904e-19,  -6.536416480518466e-21,   1.198962264163120e-03,  -1.018864916164385e-04,   8.822594892204223e-06,  -5.869165261731985e-07,   3.393146714439759e-08,
  -1.784102616849027e-09,   8.464538610289621e-11,  -3.682567094914399e-12,   1.501341468533672e-13,  -5.709050618043211e-15,   2.026994276383906e-16,  -6.845619510403787e-18,
   2.190452815635237e-19,  -6.565885033832364e-21,   1.199130404060691e-03,  -1.019195395170404e-04,   8.826396741376436e-06,  -5.872488117824244e-07,   3.395508070701509e-08,
  -1.785539555301925e-09,   8.472344069570898e-11,  -3.686381467522392e-12,   1.503033785099690e-13,  -5.716033765654882e-15,   2.029675035069843e-16,  -6.855122772640987e-18,
   2.193654569076072e-19,  -6.576152543096392e-21,   1.199157087807832e-03,  -1.019247843405180e-04,   8.827000123778893e-06,  -5.873015491455085e-07,   3.395882852184168e-08,
  -1.785767623256586e-09,   8.473582958024623e-11,  -3.686986898825413e-12,   1.503302400967664e-13,  -5.717142191850343e-15,   2.030100554515300e-16,  -6.856631264357546e-18,
   2.194162798776293e-19,  -6.577782364057321e-21,   1.657826699946908e-05,  -3.238784620714618e-06,   4.455364966316618e-07,  -4.581394343599447e-08,   3.861697955271069e-09,
  -2.775960389745024e-10,   1.742222563436804e-11,  -9.726850372651218e-13,   4.895772917327936e-14,  -2.242889656361675e-15,   9.432176125114968e-17,  -3.666935634323321e-18,
   1.324723560368457e-19,  -4.465404282023663e-21,   1.662469856888323e-05,  -3.252651390616011e-06,   4.478571549503058e-07,  -4.609151499847844e-08,   3.887836979933534e-09,
  -2.796411301735305e-10,   1.755963682740916e-11,  -9.807892472882460e-13,   4.938426950062500e-14,  -2.263180136383280e-15,   9.520234228749703e-17,  -3.702083123198956e-18,
   1.337719269384721e-19,  -4.510089241436213e-21,   1.670682281904171e-05,  -3.277186057826458e-06,   4.519643383744564e-07,  -4.658289371701521e-08,   3.934120339769687e-09,
  -2.832629634115926e-10,   1.780302886211050e-11,  -9.951459545015392e-13,   5.013998092907774e-14,  -2.299132928874719e-15,   9.676279153204707e-17,  -3.764371873797346e-18,
   1.360751940764438e-19,  -4.589290926070864e-21,   1.680646157383339e-05,  -3.306967347153973e-06,   4.569518900065306e-07,  -4.717980815813372e-08,   3.990361315403684e-09,
  -2.876651571711178e-10,   1.809892767505350e-11,  -1.012603203303919e-12,   5.105905300215572e-14,  -2.342863842080284e-15,   9.866107780647414e-17,  -3.840154699699277e-18,
   1.388776978903640e-19,  -4.685668629928773e-21,   1.690353902772669e-05,  -3.335997916246956e-06,   4.618158823380790e-07,  -4.776215445148030e-08,   4.045247628436768e-09,
  -2.919625137151887e-10,   1.838784837377498e-11,  -1.029652303545689e-12,   5.195679830668209e-14,  -2.385586571307343e-15,   1.005158575724545e-16,  -3.914209653279777e-18,
   1.416165792251840e-19,  -4.779867716447113e-21,   1.698199469389757e-05,  -3.359470358271848e-06,   4.657501781863906e-07,  -4.823334926764176e-08,   4.089670739210851e-09,
  -2.954415057056369e-10,   1.862179782507180e-11,  -1.043460109364397e-12,   5.268398391385904e-14,  -2.420197262502864e-15,   1.020186426203365e-16,  -3.974217109684202e-18,
   1.438361191696570e-19,  -4.856211647217747e-21,   1.703396012092362e-05,  -3.375022632257851e-06,   4.683577079421943e-07,  -4.854571968189811e-08,   4.119126563324472e-09,
  -2.977487560507297e-10,   1.877697603108000e-11,  -1.052620041803474e-12,   5.316644659563464e-14,  -2.443162575126373e-15,   1.030158792289928e-16,  -4.014040747574100e-18,
   1.453092020661272e-19,  -4.906883501026730e-21,   1.706068504801611e-05,  -3.383022510131360e-06,   4.696992208016977e-07,  -4.870645075086808e-08,   4.134285086050466e-09,
  -2.989362404724106e-10,   1.885684984279636e-11,  -1.057335254902352e-12,   5.341481898529711e-14,  -2.454985859947274e-15,   1.035293167110338e-16,  -4.034545329474003e-18,
   1.460676998098546e-19,  -4.932975702847862e-21,   1.706999298912181e-05,  -3.385809018859137e-06,   4.701665325138587e-07,  -4.876244469608575e-08,   4.139566176266419e-09,
  -2.993499698167761e-10,   1.888467972089828e-11,  -1.058978205001436e-12,   5.350136365179141e-14,  -2.459105764075272e-15,   1.037082319320429e-16,  -4.041690622747281e-18,
   1.463320205559335e-19,  -4.942068455337730e-21,   1.707147032018305e-05,  -3.386251298102861e-06,   4.702407067727403e-07,  -4.877133253986037e-08,   4.140404451330119e-09,
  -2.994156426530885e-10,   1.888909731979452e-11,  -1.059239002955168e-12,   5.351510167623089e-14,  -2.459759759429563e-15,   1.037366332216193e-16,  -4.042824885435622e-18,
   1.463739797537082e-19,  -4.943511878236080e-21,   3.116116961501216e-01,  -4.535588148690040e-03,   7.459363238063745e-05,  -1.155486151724638e-06,   2.961964040854430e-08,
  -5.428095649729259e-10,  -6.077963015157868e-12,  -1.918909929311057e-13,   2.562603356235980e-14,   4.239625021999190e-16,  -2.901995964264117e-17,  -1.288993544014145e-18,
   2.453213770100545e-20,   2.547407610539790e-21,   3.116187226472381e-01,  -4.535914932155563e-03,   7.461024987016855e-05,  -1.155998023875152e-06,   2.961185654890047e-08,
  -5.431673811392714e-10,  -6.013106637489564e-12,  -1.906142751627830e-13,   2.550852755493480e-14,   4.179536496066271e-16,  -2.886701850762243e-17,  -1.272310635655654e-18,
   2.456481880192501e-20,   2.511501542816908e-21,   3.116311222736942e-01,  -4.536491664285769e-03,   7.463956831111196e-05,  -1.156901497053486e-06,   2.959819501253906e-08,
  -5.437967846821917e-10,  -5.898914322997543e-12,  -1.883775122913822e-13,   2.530171168403562e-14,   4.074189083799063e-16,  -2.859704685819215e-17,  -1.243080728866756e-18,
   2.461700328134804e-20,   2.448600274005454e-21,   3.116461181857438e-01,  -4.537189255437050e-03,   7.467501474123769e-05,  -1.157994440258960e-06,   2.958179996788868e-08,
  -5.445545265384636e-10,  -5.761253480551546e-12,  -1.856999945328480e-13,   2.505252361305106e-14,   3.947955018504942e-16,  -2.827043406705816e-17,  -1.208087327757866e-18,
   2.467087741606012e-20,   2.373312835451001e-21,   3.116606782101725e-01,  -4.537866674861424e-03,   7.470941953789351e-05,  -1.159055924547067e-06,   2.956601421013963e-08,
  -5.452866538395787e-10,  -5.628055362565388e-12,  -1.831290306234098e-13,   2.481155449783396e-14,   3.826609296567320e-16,  -2.795321925112384e-17,  -1.174482323661191e-18,
   2.471366482039727e-20,   2.301030814314622e-21,   3.116724091903540e-01,  -4.538412545647802e-03,   7.473713132729816e-05,  -1.159911381182516e-06,   2.955339057320020e-08,
  -5.458739713249940e-10,  -5.521067720081550e-12,  -1.810780776795237e-13,   2.461810534861806e-14,   3.729709419554653e-16,  -2.769758741387674e-17,  -1.147671160372640e-18,
   2.474142323395719e-20,   2.243375671381917e-21,   3.116801616032104e-01,  -4.538773321046209e-03,   7.475544070281800e-05,  -1.160476817168437e-06,   2.954509464505039e-08,
  -5.462608547283436e-10,  -5.450526159396292e-12,  -1.797326812350126e-13,   2.449060687800642e-14,   3.666096069441750e-16,  -2.752863390956117e-17,  -1.130081755660893e-18,
   2.475652194390939e-20,   2.205558173610474e-21,   3.116841430824964e-01,  -4.538958619273456e-03,   7.476484280131067e-05,  -1.160767246703407e-06,   2.954084835982136e-08,
  -5.464591663591611e-10,  -5.414347249093066e-12,  -1.790447883232462e-13,   2.442523215305314e-14,   3.633555887847543e-16,  -2.744185825484186e-17,  -1.121087870481475e-18,
   2.476328167071302e-20,   2.186223412472798e-21,   3.116855289117222e-01,  -4.539023117648058e-03,   7.476811518575476e-05,  -1.160868341491396e-06,   2.953937264014038e-08,
  -5.465281315102883e-10,  -5.401762413793631e-12,  -1.788058428305463e-13,   2.440249409502863e-14,   3.622250368309457e-16,  -2.741165373004026e-17,  -1.117963681235961e-18,
   2.476547697034098e-20,   2.179507493303478e-21,   3.116857488255811e-01,  -4.539033352824140e-03,   7.476863446325704e-05,  -1.160884384227708e-06,   2.953913857000659e-08,
  -5.465390725300675e-10,  -5.399765732816675e-12,  -1.787679483335383e-13,   2.439888664810120e-14,   3.620457305176616e-16,  -2.740686062087828e-17,  -1.117468210218250e-18,
   2.476581787375583e-20,   2.178442420366341e-21,   1.261837125664637e-01,  -2.442770099006213e-03,   7.936914348965796e-05,  -2.474716767217466e-06,   6.281258566419710e-08,
  -1.674526490871267e-09,   5.218560186752087e-11,  -1.045999888499712e-12,   1.097885548027058e-14,  -8.283619979194067e-16,   3.207514955300477e-17,   4.357726487287127e-19,
  -1.266127108453586e-20,  -1.608865585004445e-21,   1.261912251825028e-01,  -2.443471707680637e-03,   7.940489207946152e-05,  -2.476304356863042e-06,   6.288634897198073e-08,
  -1.676629430293105e-09,   5.221715938010254e-11,  -1.048749190068992e-12,   1.111178152248074e-14,  -8.265207280885297e-16,   3.200024090086994e-17,   4.251686887104674e-19,
  -1.259039584779439e-20,  -1.587380159979664e-21,   1.262044840864245e-01,  -2.444710073356621e-03,   7.946800485308387e-05,  -2.479107300059357e-06,   6.301654264467539e-08,
  -1.680344478449184e-09,   5.227312534964068e-11,  -1.053595617969093e-12,   1.134607781113600e-14,  -8.233150625571344e-16,   3.186844426666485e-17,   4.065814032984276e-19,
  -1.246309917914622e-20,  -1.549779291413418e-21,   1.262205216276492e-01,  -2.446208142906841e-03,   7.954437917899553e-05,  -2.482499407106111e-06,   6.317403779833608e-08,
  -1.684844215046692e-09,   5.234128087664428e-11,  -1.059447937568894e-12,   1.162895955823646e-14,  -8.195121921994443e-16,   3.170973113077551e-17,   3.843149118498469e-19,
  -1.230541554373490e-20,  -1.504838428543356e-21,   1.262360955536236e-01,  -2.447663097238756e-03,   7.961858247592833e-05,  -2.485795297156312e-06,   6.332699822155468e-08,
  -1.689220287894888e-09,   5.240794818553476e-11,  -1.065120957913345e-12,   1.190312524939205e-14,  -8.158969100386565e-16,   3.155635220698713e-17,   3.629167451771744e-19,
  -1.214847966373989e-20,  -1.461758252540392e-21,   1.262486452602597e-01,  -2.448835658594837e-03,   7.967840299104595e-05,  -2.488452496932766e-06,   6.345026924795456e-08,
  -1.692751184168287e-09,   5.246201464464095e-11,  -1.069685186463942e-12,   1.212366726536626e-14,  -8.130389719996843e-16,   3.143329802995658e-17,   3.458335751082448e-19,
  -1.201933989309501e-20,  -1.427443187832588e-21,   1.262569396238195e-01,  -2.449610696012005e-03,   7.971795252903341e-05,  -2.490209343330276e-06,   6.353174817636204e-08,
  -1.695087072235245e-09,   5.249791699997397e-11,  -1.072698295685143e-12,   1.226924003983113e-14,  -8.111770506561474e-16,   3.135223629619497e-17,   3.346207256681598e-19,
  -1.193269801992253e-20,  -1.404958191217343e-21,   1.262611997149305e-01,  -2.450008785885722e-03,   7.973826966865247e-05,  -2.491111882438168e-06,   6.357359882956328e-08,
  -1.696287507886886e-09,   5.251640904122833e-11,  -1.074244795630935e-12,   1.234395000275799e-14,  -8.102290502904067e-16,   3.131068516114004e-17,   3.288856160559874e-19,
  -1.188780287959567e-20,  -1.393469539105922e-21,   1.262626825644050e-01,  -2.450147356029009e-03,   7.974534227951891e-05,  -2.491426069511723e-06,   6.358816650030337e-08,
  -1.696705465058237e-09,   5.252285403374884e-11,  -1.074782930211279e-12,   1.236994575543130e-14,  -8.099003908455783e-16,   3.129623536499139e-17,   3.268931476983743e-19,
  -1.187211335335547e-20,  -1.389480097062412e-21,   1.262629178762655e-01,  -2.450169345739626e-03,   7.974646465503882e-05,  -2.491475929050629e-06,   6.359047824448258e-08,
  -1.696771795491967e-09,   5.252387717675775e-11,  -1.074868318175336e-12,   1.237407055633217e-14,  -8.098482988220896e-16,   3.129394297368956e-17,   3.265771453730126e-19,
  -1.186962064133600e-20,  -1.388847468108895e-21,   1.914004326048057e-02,  -5.963870490084958e-04,   3.221249218424715e-05,  -1.390159763586356e-06,   4.778544037864011e-08,
  -1.714529997733182e-09,   6.310825359494174e-11,  -1.788236442922265e-12,   4.577319571024846e-14,  -1.736083052185602e-15,   5.237610745199196e-17,  -6.148017541209538e-19,
   2.247574828261862e-20,  -1.678019573456631e-21,   1.914311817105994e-02,  -5.967838065532311e-04,   3.223988157356824e-05,  -1.391797625454400e-06,   4.787566970453951e-08,
  -1.718145533390328e-09,   6.323308142422507e-11,  -1.794192031374177e-12,   4.599879340577222e-14,  -1.739709036966447e-15,   5.251958737988910e-17,  -6.265922768780595e-19,
   2.256580421195126e-20,  -1.669081516451102e-21,   1.914854604808097e-02,  -5.974842713430619e-04,   3.228825219815594e-05,  -1.394690443607673e-06,   4.803502533102285e-08,
  -1.724534783863116e-09,   6.345382637666038e-11,  -1.804711043918505e-12,   4.639736025064297e-14,  -1.746156090304599e-15,   5.277325198320513e-17,  -6.473459289833418e-19,
   2.272826668690508e-20,  -1.653475548537302e-21,   1.915511316131125e-02,  -5.983319289895197e-04,   3.234681347942909e-05,  -1.398193224117782e-06,   4.822796672769462e-08,
  -1.732277081631598e-09,   6.372158000556772e-11,  -1.817448371104388e-12,   4.688015874634193e-14,  -1.754035250691966e-15,   5.308083680982833e-17,  -6.723553293201140e-19,
   2.293073266897342e-20,  -1.634886124494772e-21,   1.916149224337280e-02,  -5.991554996520394e-04,   3.240373817237218e-05,  -1.401598647452483e-06,   4.841552990289333e-08,
  -1.739810304375411e-09,   6.398237700114446e-11,  -1.829832120905047e-12,   4.734973991795684e-14,  -1.761771268491080e-15,   5.338034102486812e-17,  -6.965446732078889e-19,
   2.313351706314781e-20,  -1.617133949456124e-21,   1.916663390387452e-02,  -5.998194445792120e-04,   3.244964932419828e-05,  -1.404345588218700e-06,   4.856681427884065e-08,
  -1.745891257648265e-09,   6.419309310521070e-11,  -1.839821698250582e-12,   4.772866630149606e-14,  -1.768065559075728e-15,   5.362227761884257e-17,  -7.159678764339908e-19,
   2.330129904719770e-20,  -1.603043297518386e-21,   1.917003277124981e-02,  -6.002584062241258e-04,   3.248001273844946e-05,  -1.406162470483141e-06,   4.866687147012644e-08,
  -1.749915463529701e-09,   6.433263509051244e-11,  -1.846429221951452e-12,   4.797936689096683e-14,  -1.772255145144466e-15,   5.378247236755353e-17,  -7.287715742639851e-19,
   2.341431324369553e-20,  -1.593835209068427e-21,   1.917177866986106e-02,  -6.004839078761643e-04,   3.249561389304896e-05,  -1.407096068902055e-06,   4.871828385037668e-08,
  -1.751983948538146e-09,   6.440439081457073e-11,  -1.849824546264741e-12,   4.810821046846078e-14,  -1.774416098330511e-15,   5.386484217695591e-17,  -7.353374093569738e-19,
   2.347301155473949e-20,  -1.589138154555452e-21,   1.917238641235658e-02,  -6.005624075503508e-04,   3.250104530580460e-05,  -1.407421102773545e-06,   4.873618289622961e-08,
  -1.752704200319170e-09,   6.442938105928037e-11,  -1.851006646136220e-12,   4.815307107957447e-14,  -1.775169733455834e-15,   5.389352808448474e-17,  -7.376212043214359e-19,
   2.349354679191151e-20,  -1.587508351010485e-21,   1.917248285587771e-02,  -6.005748649258342e-04,   3.250190725735951e-05,  -1.407472685274528e-06,   4.873902344179385e-08,
  -1.752818508441037e-09,   6.443334737951742e-11,  -1.851194244601773e-12,   4.816019057313431e-14,  -1.775289395951725e-15,   5.389808092031958e-17,  -7.379835398189603e-19,
   2.349681041734988e-20,  -1.587249963265724e-21,   8.940704916233510e-04,  -5.166428994196949e-05,   4.068358152874138e-06,  -2.406298434328646e-07,   1.199541136112956e-08,
  -5.716473336526839e-10,   2.532053694672973e-11,  -9.959779619511517e-13,   3.706700117669479e-14,  -1.361367590050245e-15,   4.545492523477016e-17,  -1.375243564289825e-18,
   4.369441441195229e-20,  -1.343477611937737e-21,   8.944658683229716e-04,  -5.173391909611934e-05,   4.075314025037581e-06,  -2.411829693072990e-07,   1.203222495772294e-08,
  -5.736848241037701e-10,   2.542201643149698e-11,  -1.000769561853190e-12,   3.726796844615280e-14,  -1.368862630921990e-15,   4.573903897064801e-17,  -1.385549527491741e-18,
   4.398768327579182e-20,  -1.352113251533701e-21,   8.951640720949133e-04,  -5.185691033504398e-05,   4.087604893287289e-06,  -2.421605453854610e-07,   1.209730080554239e-08,
  -5.772877753849134e-10,   2.560151309315748e-11,  -1.009245279770458e-12,   3.762356503804430e-14,  -1.382131450064295e-15,   4.624186445254353e-17,  -1.403786789189661e-18,
   4.450760457843414e-20,  -1.367416471021945e-21,   8.960092954465055e-04,  -5.200585371916568e-05,   4.102496375132482e-06,  -2.433453334576006e-07,   1.217619221002202e-08,
  -5.816577696334283e-10,   2.581930471208234e-11,  -1.019529866896147e-12,   3.805524218142902e-14,  -1.398250914195807e-15,   4.685245641749923e-17,  -1.425928803399379e-18,
   4.514046760424650e-20,  -1.386033451850257e-21,   8.968308174759037e-04,  -5.215067719859015e-05,   4.116983428034999e-06,  -2.444983301580550e-07,   1.225298953861154e-08,
  -5.859140071095274e-10,   2.603151227421946e-11,  -1.029551412997690e-12,   3.847607694986394e-14,  -1.413977794343883e-15,   4.744791059001452e-17,  -1.447517771225010e-18,
   4.575920778659899e-20,  -1.404224568306378e-21,   8.974933378686867e-04,  -5.226751143772371e-05,   4.128676011180994e-06,  -2.454291970781765e-07,   1.231500790093082e-08,
  -5.893527731242379e-10,   2.620302355449144e-11,  -1.037651545505091e-12,   3.881636744258031e-14,  -1.426703462760881e-15,   4.792954433694329e-17,  -1.464977075129970e-18,
   4.626078801050005e-20,  -1.418964126606404e-21,   8.979314689558462e-04,  -5.234479495251881e-05,   4.136413048147933e-06,  -2.460452917056707e-07,   1.235606280117644e-08,
  -5.916299514227527e-10,   2.631662969285529e-11,  -1.043017172510056e-12,   3.904184919246534e-14,  -1.435139978264880e-15,   4.824875404503862e-17,  -1.476547027026041e-18,
   4.659375711728701e-20,  -1.428745571305885e-21,   8.981565783659440e-04,  -5.238450896917391e-05,   4.140389725523954e-06,  -2.463619936073392e-07,   1.237716945271756e-08,
  -5.928009095309844e-10,   2.637505689803134e-11,  -1.045776768535949e-12,   3.915783807152741e-14,  -1.439481086371164e-15,   4.841297940962850e-17,  -1.482499025569449e-18,
   4.676522719440713e-20,  -1.433781777261175e-21,   8.982349469790921e-04,  -5.239833581539422e-05,   4.141774376286065e-06,  -2.464722736401282e-07,   1.238451947943381e-08,
  -5.932087140668956e-10,   2.639540656681272e-11,  -1.046737922883703e-12,   3.919823984747747e-14,  -1.440993411620020e-15,   4.847018671849932e-17,  -1.484572310794719e-18,
   4.682498448172373e-20,  -1.435536742350634e-21,   8.982473838163801e-04,  -5.240053013629508e-05,   4.141994126543071e-06,  -2.464897758909879e-07,   1.238568600140729e-08,
  -5.932734385146942e-10,   2.639863642221572e-11,  -1.046890475790411e-12,   3.920465251483705e-14,  -1.441233461527655e-15,   4.847926697088330e-17,  -1.484901390387857e-18,
   4.683447072744420e-20,  -1.435815329356904e-21,   8.338572629882468e-06,  -1.133240921342183e-06,   1.375699198251279e-07,  -1.254895439830342e-08,   9.579548588696917e-10,
  -6.397661701653724e-11,   3.778407941786181e-12,  -1.999985447246129e-13,   9.644042331050973e-15,  -4.267804222354700e-16,   1.738200273505050e-17,  -6.573941442959156e-19,
   2.328192305489183e-20,  -7.694245611515066e-22,   8.352616555480811e-06,  -1.136994848913547e-06,   1.381407525205304e-07,  -1.261247493029725e-08,   9.635895099206046e-10,
  -6.439501039783281e-11,   3.805356943550533e-12,  -2.015344336104641e-13,   9.722385540890860e-15,  -4.304077128545172e-16,   1.753630425910700e-17,  -6.634354262725598e-19,
   2.350054950166304e-20,  -7.768598761583535e-22,   8.377444690862614e-06,  -1.143633863512992e-06,   1.391506492866596e-07,  -1.272488448560986e-08,   9.735634002345898e-10,
  -6.513577796959106e-11,   3.853079145128549e-12,  -2.042546628893204e-13,   9.861161688173483e-15,  -4.368338787852959e-16,   1.780969016118536e-17,  -6.741403386246360e-19,
   2.388799908793918e-20,  -7.900365979015857e-22,   8.407548124157093e-06,  -1.151687716884802e-06,   1.403763617961118e-07,  -1.286136949622271e-08,   9.856777121231981e-10,
  -6.603580599916891e-11,   3.911076451607367e-12,  -2.075613132119143e-13,   1.002989182451790e-14,  -4.446485113276178e-16,   1.814218417969503e-17,  -6.871617540449671e-19,
   2.435938019384430e-20,  -8.060675302135946e-22,   8.436857019684213e-06,  -1.159533434133265e-06,   1.415710237596021e-07,  -1.299445300331398e-08,   9.974945645079132e-10,
  -6.691403815162918e-11,   3.967685099111725e-12,  -2.107895520360009e-13,   1.019465949195456e-14,  -4.522811105646116e-16,   1.846697422021491e-17,  -6.998835696669127e-19,
   2.482000851916212e-20,  -8.217325972801584e-22,   8.460528927339095e-06,  -1.165873361511578e-06,   1.425368486252906e-07,  -1.310208457665870e-08,   1.007054663028357e-09,
  -6.762476533109861e-11,   4.013508161170066e-12,  -2.134032636655758e-13,   1.032808970040857e-14,  -4.584631171892563e-16,   1.873006672264089e-17,  -7.101902403830428e-19,
   2.519325624025355e-20,  -8.344259166606578e-22,   8.476200846002849e-06,  -1.170072249394199e-06,   1.431767270660852e-07,  -1.317341233616461e-08,   1.013391732167248e-09,
  -6.809598913823737e-11,   4.043895170490181e-12,  -2.151367821203131e-13,   1.041659952040470e-14,  -4.625644214270626e-16,   1.890462363376783e-17,  -7.170292582336235e-19,
   2.544095813141265e-20,  -8.428496620685765e-22,   8.484258398394814e-06,  -1.172231545111474e-06,   1.435058551666495e-07,  -1.321010659179882e-08,   1.016652293362222e-09,
  -6.833847707649248e-11,   4.059533799266726e-12,  -2.160290174095147e-13,   1.046215937207649e-14,  -4.646757022290976e-16,   1.899448701243394e-17,  -7.205502698816273e-19,
   2.556849539767021e-20,  -8.471868869511555e-22,   8.487064380513268e-06,  -1.172983580303047e-06,   1.436204940558809e-07,  -1.322288856775072e-08,   1.017788145233016e-09,
  -6.842295562397346e-11,   4.064982297338334e-12,  -2.163398853221153e-13,   1.047803376148469e-14,  -4.654113600828450e-16,   1.902579985763407e-17,  -7.217772005961143e-19,
   2.561293858710228e-20,  -8.486982876459695e-22,   8.487509721380706e-06,  -1.173102940371407e-06,   1.436386896028657e-07,  -1.322491737591429e-08,   1.017968435999613e-09,
  -6.843636492948536e-11,   4.065847152094211e-12,  -2.163892308462522e-13,   1.048055360950691e-14,  -4.655281371930787e-16,   1.903077044078672e-17,  -7.219719645906639e-19,
   2.561999361111796e-20,  -8.489382111367653e-22,   2.945852434093189e-01,  -3.987124408111459e-03,   6.318657964139719e-05,  -7.764224907733773e-07,   1.737208365855589e-08,
  -6.564983920072333e-10,   2.636777713707887e-13,   5.757931783182779e-13,   1.256222108199186e-14,  -1.127870431421646e-15,  -2.437792563467968e-17,   1.783992514633613e-18,
   5.273648985691439e-20,  -2.815830622776321e-21,   2.945911867647482e-01,  -3.987344910748676e-03,   6.319635576490673e-05,  -7.770289570017597e-07,   1.737281894675566e-08,
  -6.554213912533755e-10,   2.947457801286879e-13,   5.722051148888569e-13,   1.246852593408137e-14,  -1.119382382272392e-15,  -2.408786245170051e-17,   1.765419478879943e-18,
   5.193456087878448e-20,  -2.778492266946355e-21,   2.946016746547980e-01,  -3.987734128255841e-03,   6.321360630995501e-05,  -7.780982725905875e-07,   1.737415115481265e-08,
  -6.535266431454433e-10,   3.493712690711301e-13,   5.658966952701716e-13,   1.230416299112084e-14,  -1.104480914069519e-15,  -2.357992575039580e-17,   1.732861859182322e-18,
   5.053320767533435e-20,  -2.713144795258050e-21,   2.946143579953568e-01,  -3.988205007929654e-03,   6.323446658232982e-05,  -7.793899330867817e-07,   1.737582122996412e-08,
  -6.512450799345130e-10,   4.150947302174007e-13,   5.583071796519036e-13,   1.210704770262858e-14,  -1.086590587165995e-15,  -2.297230050807638e-17,   1.693856941376710e-18,
   4.886177388510205e-20,  -2.635034619113616e-21,   2.946266720947429e-01,  -3.988662374346165e-03,   6.325471815055325e-05,  -7.806424265500483e-07,   1.737750426737775e-08,
  -6.490401854662542e-10,   4.785538298963022e-13,   5.509797498714125e-13,   1.191739153128216e-14,  -1.069356958679054e-15,  -2.238925787993393e-17,   1.656370214220356e-18,
   4.726311008763331e-20,  -2.560150136322062e-21,   2.946365931274227e-01,  -3.989030997915953e-03,   6.327103311669799e-05,  -7.816503982907258e-07,   1.737890421651806e-08,
  -6.472710996192655e-10,   5.294303380859818e-13,   5.451056465681453e-13,   1.176581705559090e-14,  -1.055569236235493e-15,  -2.192441886408220e-17,   1.626440737513407e-18,
   4.599222051127342e-20,  -2.500494570193705e-21,   2.946431492363725e-01,  -3.989274663509939e-03,   6.328181403671535e-05,  -7.823159493381984e-07,   1.737985082492008e-08,
  -6.461056104479378e-10,   5.629290082953050e-13,   5.412381843268335e-13,   1.166624864005264e-14,  -1.046505079966329e-15,  -2.161962112493010e-17,   1.606794986258882e-18,
   4.516067924284589e-20,  -2.461401220053725e-21,   2.946465162565338e-01,  -3.989399823947451e-03,   6.328735064271806e-05,  -7.826575876337587e-07,   1.738034360585478e-08,
  -6.455081538111469e-10,   5.800952895935279e-13,   5.392563889008051e-13,   1.161529706435597e-14,  -1.041864544270841e-15,  -2.146381916711177e-17,   1.596746338997235e-18,
   4.473617633110165e-20,  -2.441425248662147e-21,   2.946476882017428e-01,  -3.989443391401288e-03,   6.328927772317849e-05,  -7.827764734718329e-07,   1.738051618080527e-08,
  -6.453003749806233e-10,   5.860643075889835e-13,   5.385672954825430e-13,   1.159759174800064e-14,  -1.040251642540542e-15,  -2.140970618408109e-17,   1.593255230413239e-18,
   4.458882618700982e-20,  -2.434488359717020e-21,   2.946478741743994e-01,  -3.989450305156387e-03,   6.328958352497528e-05,  -7.827953378543470e-07,   1.738054361628108e-08,
  -6.452674114764464e-10,   5.870112303708320e-13,   5.384579785196833e-13,   1.159478352634751e-14,  -1.039995805368412e-15,  -2.140112466711978e-17,   1.592701543817465e-18,
   4.456546280513273e-20,  -2.433388326407862e-21,   1.175157232629458e-01,  -1.911668978627340e-03,   5.479172108721963e-05,  -1.679094138175300e-06,   3.959674335155526e-08,
  -7.519585136516384e-10,   2.521663608882789e-11,  -9.079201502587297e-13,   5.425202661343968e-15,   4.279675125312045e-16,   1.763609091917096e-17,  -1.207459935450240e-18,
  -2.400003905579984e-20,   1.738281225550963e-21,   1.175209050978233e-01,  -1.912143761541715e-03,   5.481419554020915e-05,  -1.679813936474271e-06,   3.963239183325713e-08,
  -7.537257076798951e-10,   2.523231679344485e-11,  -9.066250218059997e-13,   5.495498450256889e-15,   4.221766593173751e-16,   1.750563103410688e-17,  -1.196074722064719e-18,
  -2.360118956036835e-20,   1.713717715435392e-21,   1.175300502641781e-01,  -1.912981690636510e-03,   5.485386841429370e-05,  -1.681085372736597e-06,   3.969531262985066e-08,
  -7.568419491610754e-10,   2.526013322036574e-11,  -9.043553214454745e-13,   5.619104584825430e-15,   4.120050016187659e-16,   1.727736674121455e-17,  -1.176126399590694e-18,
  -2.290399896662343e-20,   1.670746210426143e-21,   1.175411116599699e-01,  -1.913995208703498e-03,   5.490186915862644e-05,  -1.682625092288399e-06,   3.977142876998324e-08,
  -7.606067479890824e-10,   2.529402015633252e-11,  -9.016372451912359e-13,   5.767838475308990e-15,   3.997840326312823e-16,   1.700462301351670e-17,  -1.152243728051874e-18,
  -2.207208211784330e-20,   1.619412695071916e-21,   1.175518529753781e-01,  -1.914979413478601e-03,   5.494849665485627e-05,  -1.684122217178295e-06,   3.984535428012803e-08,
  -7.642580171103049e-10,   2.532717908592799e-11,  -8.990261937940988e-13,   5.911465891336796e-15,   3.880020452877661e-16,   1.674325055787383e-17,  -1.129307305910344e-18,
  -2.127600950464944e-20,   1.570230612139594e-21,   1.175605082640593e-01,  -1.915772490451783e-03,   5.498608008984991e-05,  -1.685329994340912e-06,   3.990493165606259e-08,
  -7.671969161185787e-10,   2.535407871837255e-11,  -8.969424708187402e-13,   6.026629062488666e-15,   3.785689693942970e-16,   1.653511050495234e-17,  -1.111006733284353e-18,
  -2.064288603414195e-20,   1.531072755713954e-21,   1.175662286142054e-01,  -1.916296646641815e-03,   5.501092480445778e-05,  -1.686128910256107e-06,   3.994431109065778e-08,
  -7.691376624307099e-10,   2.537194496866085e-11,  -8.955752017000608e-13,   6.102463432660759e-15,   3.723641834461551e-16,   1.639875140603823e-17,  -1.099000036924443e-18,
  -2.022850171426107e-20,   1.505422721341398e-21,   1.175691666247419e-01,  -1.916565858430481e-03,   5.502368692465249e-05,  -1.686539450975052e-06,   3.996453796203323e-08,
  -7.701339507230414e-10,   2.538114837873351e-11,  -8.948760114846485e-13,   6.141326887921630e-15,   3.691864887136797e-16,   1.632908654666128e-17,  -1.092860507247312e-18,
  -2.001691686244784e-20,   1.492319352622666e-21,   1.175701892798758e-01,  -1.916659565235187e-03,   5.502812940224289e-05,  -1.686682384685266e-06,   3.997157869130904e-08,
  -7.704806579552009e-10,   2.538435620089364e-11,  -8.946331238408222e-13,   6.154840784558820e-15,   3.680818548425799e-16,   1.630489654709024e-17,  -1.090727794003701e-18,
  -1.994346661754630e-20,   1.487769581838072e-21,   1.175703515637089e-01,  -1.916674435460307e-03,   5.502883438621829e-05,  -1.686705068254856e-06,   3.997269598569817e-08,
  -7.705356727704249e-10,   2.538486545121023e-11,  -8.945946033084283e-13,   6.156984642755871e-15,   3.679066306835184e-16,   1.630106065368639e-17,  -1.090389561270263e-18,
  -1.993182026276368e-20,   1.487048116323454e-21,   1.717973878836958e-02,  -3.945631578234381e-04,   1.921226480741269e-05,  -8.322772393861994e-07,   2.524443611631829e-08,
  -6.796882533273277e-10,   2.676742019839166e-11,  -9.646469885775619e-13,   1.531750146229942e-14,  -1.312547273685556e-16,   2.441340874211138e-17,  -9.792730547136588e-19,
  -1.505499320823921e-20,   7.840121037627636e-22,   1.718156887842291e-02,  -3.947995398831622e-04,   1.922668036783749e-05,  -8.329305015950445e-07,   2.528258094928611e-08,
  -6.815967281121015e-10,   2.680970076682753e-11,  -9.652158948488386e-13,   1.541816673518333e-14,  -1.361136381178640e-16,   2.433824146650687e-17,  -9.742665658718983e-19,
  -1.465820521683908e-20,   7.706132964463525e-22,   1.718479922575812e-02,  -3.952167919222529e-04,   1.925213441535148e-05,  -8.340846506635685e-07,   2.534993725953331e-08,
  -6.849652342406933e-10,   2.688451896352415e-11,  -9.662329337735884e-13,   1.559554992802916e-14,  -1.446670088068700e-16,   2.420753814166929e-17,  -9.655100451350279e-19,
  -1.396404723778625e-20,   7.471312917611728e-22,   1.718870731482434e-02,  -3.957215972480676e-04,   1.928294368599779e-05,  -8.354827459597899e-07,   2.543146920473334e-08,
  -6.890401401263779e-10,   2.697535356953347e-11,  -9.674852092644192e-13,   1.580963494091710e-14,  -1.549755208432559e-16,   2.405276190743848e-17,  -9.550530830296634e-19,
  -1.313477067216764e-20,   7.190084108664305e-22,   1.719250323033068e-02,  -3.962119257701870e-04,   1.931288419118958e-05,  -8.368425965883422e-07,   2.551070715584445e-08,
  -6.929977577155512e-10,   2.706391460795274e-11,  -9.687243705246334e-13,   1.601704268598011e-14,  -1.649471900298022e-16,   2.390590839472812e-17,  -9.450385542313710e-19,
  -1.234019190197136e-20,   6.919896959631658e-22,   1.719556261171089e-02,  -3.966071233237358e-04,   1.933702638396877e-05,  -8.379399407604409e-07,   2.557460352739706e-08,
  -6.961872436927430e-10,   2.713553046723538e-11,  -9.697394085779786e-13,   1.618382906453462e-14,  -1.729548854160344e-16,   2.379002381880033e-17,  -9.370685042963356e-19,
  -1.170750986175056e-20,   6.704246683150703e-22,   1.719758490242383e-02,  -3.968683585209427e-04,   1.935299014268235e-05,  -8.386659601773549e-07,   2.561685616928279e-08,
  -6.982954314722837e-10,   2.718298612670604e-11,  -9.704183331452098e-13,   1.629389391846519e-14,  -1.782338937344988e-16,   2.371462648223365e-17,  -9.318495584970055e-19,
  -1.129304580752401e-20,   6.562726415030475e-22,   1.719862366387716e-02,  -3.970025449063715e-04,   1.936119170829408e-05,  -8.390390885728580e-07,   2.563856454036665e-08,
  -6.993782834094454e-10,   2.720739803890212e-11,  -9.707695282002144e-13,   1.635037310197264e-14,  -1.809411193745722e-16,   2.367626886693707e-17,  -9.291840278078301e-19,
  -1.108130549553912e-20,   6.490350028805484e-22,   1.719898524909120e-02,  -3.970492544225156e-04,   1.936404688156517e-05,  -8.391690043357651e-07,   2.564612187002439e-08,
  -6.997552113462200e-10,   2.721590137904243e-11,  -9.708921681488622e-13,   1.637002416279067e-14,  -1.818827909337933e-16,   2.366297572791119e-17,  -9.282585930520606e-19,
  -1.100778294205945e-20,   6.465206576932292e-22,   1.719904262933597e-02,  -3.970566668033423e-04,   1.936449998403335e-05,  -8.391896223148556e-07,   2.564732118692629e-08,
  -6.998150261114656e-10,   2.721725105294313e-11,  -9.709116485602937e-13,   1.637314218207658e-14,  -1.820321926393979e-16,   2.366086902063947e-17,  -9.281118497136614e-19,
  -1.099612424955625e-20,   6.461218924893062e-22,   7.379023477506165e-04,  -2.809826583316668e-05,   2.040869647298624e-06,  -1.146953375994757e-07,   4.918951253637304e-09,
  -1.996830221728588e-10,   8.632188898778106e-12,  -3.329657032307359e-13,   1.033608425080265e-14,  -3.306346674335944e-16,   1.291419734387186e-17,  -3.929254455095186e-19,
   6.717442170018398e-21,  -2.140899306394667e-22,   7.380993768387477e-04,  -2.813120452460101e-05,   2.043707157151082e-06,  -1.148882279779578e-07,   4.931426666831776e-09,
  -2.003572926565815e-10,   8.660482734603551e-12,  -3.341364248402557e-13,   1.039210118188691e-14,  -3.327277625929685e-16,   1.296111701165370e-17,  -3.946278782386838e-19,
   6.833736803815359e-21,  -2.165547387055216e-22,   7.384472625533765e-04,  -2.818937046715510e-05,   2.048719773148227e-06,  -1.152291058384561e-07,   4.953472537117313e-09,
  -2.015489545553142e-10,   8.710528146865327e-12,  -3.362079746152552e-13,   1.049110955460640e-14,  -3.364283397306723e-16,   1.304448708221341e-17,  -3.976466515745571e-19,
   7.038439456851847e-21,  -2.209151410699367e-22,   7.388683132770989e-04,  -2.825978233440703e-05,   2.054790956720489e-06,  -1.156421862189066e-07,   4.980186673441211e-09,
  -2.029931726504259e-10,   8.771249292933226e-12,  -3.387228062651301e-13,   1.061111528071716e-14,  -3.409155691386194e-16,   1.314628565328516e-17,  -4.013222715821920e-19,
   7.285128513701154e-21,  -2.262068091355286e-22,   7.392774641385049e-04,  -2.832821768357384e-05,   2.060695110754138e-06,  -1.160441278869194e-07,   5.006179094623857e-09,
  -2.043986038042782e-10,   8.830412052419945e-12,  -3.411745373320807e-13,   1.072791362204114e-14,  -3.452847879970614e-16,   1.324614102940658e-17,  -4.049170374096213e-19,
   7.523749497711084e-21,  -2.313636773781586e-22,   7.396073591455284e-04,  -2.838340622662312e-05,   2.065458848591181e-06,  -1.163685943943297e-07,   5.027160466802265e-09,
  -2.055332493291522e-10,   8.878227589888634e-12,  -3.431570669175642e-13,   1.082222019396912e-14,  -3.488139944172707e-16,   1.332732055859122e-17,  -4.078319882655257e-19,
   7.715376021796538e-21,  -2.355320996999545e-22,   7.398254892099458e-04,  -2.841990222007280e-05,   2.068610282516212e-06,  -1.165833232885883e-07,   5.041045288301616e-09,
  -2.062842040420311e-10,   8.909899124120040e-12,  -3.444707384320484e-13,   1.088464222626304e-14,  -3.511506592770924e-16,   1.338132299478796e-17,  -4.097674815046376e-19,
   7.841709205906592e-21,  -2.382934007852653e-22,   7.399375531644711e-04,  -2.843865344448432e-05,   2.070229821400255e-06,  -1.166936981201837e-07,   5.048182218955555e-09,
  -2.066702271866972e-10,   8.926187457991356e-12,  -3.451465018872813e-13,   1.091673179065647e-14,  -3.523520831048564e-16,   1.340916718181345e-17,  -4.107643435574381e-19,
   7.906498703804490e-21,  -2.397135830947615e-22,   7.399765650140485e-04,  -2.844518137909847e-05,   2.070793696196419e-06,  -1.167321312204069e-07,   5.050667314237249e-09,
  -2.068046453393161e-10,   8.931860502428554e-12,  -3.453818875842664e-13,   1.092790609868848e-14,  -3.527704783595724e-16,   1.341887632288142e-17,  -4.111117715047918e-19,
   7.929035269460930e-21,  -2.402082278480516e-22,   7.399827559879422e-04,  -2.844621733885559e-05,   2.070883183881600e-06,  -1.167382307899549e-07,   5.051061713126597e-09,
  -2.068259784631561e-10,   8.932760914067021e-12,  -3.454192486015344e-13,   1.092967955648614e-14,  -3.528368827868724e-16,   1.342041787071219e-17,  -4.111669254256231e-19,
   7.932610848828622e-21,  -2.402867371596489e-22,   5.323881536299854e-06,  -4.471189278736226e-07,   4.867042505333353e-08,  -3.951277270236053e-09,   2.654577212005927e-10,
  -1.612750682756250e-11,   8.946992744003993e-13,  -4.453291451864701e-14,   2.014814839179349e-15,  -8.545863691319419e-17,   3.397746708138048e-18,  -1.234970823140455e-19,
   4.160878745560772e-21,  -1.372010694483038e-22,   5.328759417558790e-06,  -4.482864142810507e-07,   4.882726077603039e-08,  -3.967180165476662e-09,   2.667826883470561e-10,
  -1.622009329202297e-11,   9.003054641921946e-13,  -4.483920464620792e-14,   2.030045305894545e-15,  -8.613759149410914e-17,   3.425332427646937e-18,  -1.245699950279390e-19,
   4.200215691598449e-21,  -1.384480534941110e-22,   5.337379383782960e-06,  -4.503502369358253e-07,   4.910462173510260e-08,  -3.995313172977993e-09,   2.691271492715640e-10,
  -1.638396270016550e-11,   9.102307268770853e-13,  -4.538155264822961e-14,   2.057015949780773e-15,  -8.734018732181922e-17,   3.474208609902128e-18,  -1.264707181231192e-19,
   4.269884031746828e-21,  -1.406586068313392e-22,   5.347824715443497e-06,  -4.528522809528962e-07,   4.944107199042928e-08,  -4.029455105822903e-09,   2.719732663850336e-10,
  -1.658296850912751e-11,   9.222889603441566e-13,  -4.604060418266687e-14,   2.089793723270513e-15,  -8.880219281629048e-17,   3.533653399131741e-18,  -1.287820110281509e-19,
   4.354568897410617e-21,  -1.433491077747519e-22,   5.357987921309487e-06,  -4.552879888549434e-07,   4.976880731356895e-08,  -4.062728855931119e-09,   2.747479582116738e-10,
  -1.677705602410114e-11,   9.340542327518957e-13,  -4.668380246323904e-14,   2.121786776139954e-15,  -9.022969296659695e-17,   3.591721904207994e-18,  -1.310393555652588e-19,
   4.437243778228763e-21,  -1.459793424911914e-22,   5.366191821205230e-06,  -4.572550225101237e-07,   5.003362758838246e-08,  -4.089626676777096e-09,   2.769916425179469e-10,
  -1.693405436964313e-11,   9.435748345698788e-13,  -4.720440032512647e-14,   2.147684316920322e-15,  -9.138557114294783e-17,   3.638760270778063e-18,  -1.328676118034874e-19,
   4.504179860851624e-21,  -1.481113980228006e-22,   5.371620930015640e-06,  -4.585571867105909e-07,   5.020900904648476e-08,  -4.107445870902173e-09,   2.784783656248077e-10,
  -1.703811215183667e-11,   9.498868139467905e-13,  -4.754960276589098e-14,   2.164858011125759e-15,  -9.215225294544066e-17,   3.669969593807262e-18,  -1.340804893247183e-19,
   4.548574355112327e-21,  -1.495266842379728e-22,   5.374411550456144e-06,  -4.592266483375539e-07,   5.029919750025952e-08,  -4.116611000537754e-09,   2.792431503719774e-10,
  -1.709164871434341e-11,   9.531348029225022e-13,  -4.772725272519099e-14,   2.173696445500565e-15,  -9.254687870965730e-17,   3.686036485238588e-18,  -1.347048471676470e-19,
   4.571424010033935e-21,  -1.502555024562014e-22,   5.375383251821279e-06,  -4.594597781602209e-07,   5.033060780424471e-08,  -4.119803257738756e-09,   2.795095448732176e-10,
  -1.711029820759890e-11,   9.542663287280936e-13,  -4.778914470183176e-14,   2.176775759027417e-15,  -9.268437493202250e-17,   3.691634994455636e-18,  -1.349223976876600e-19,
   4.579385166662323e-21,  -1.505094931125271e-22,   5.375537466457034e-06,  -4.594967782355668e-07,   5.033559310754339e-08,  -4.120309931839437e-09,   2.795518277078506e-10,
  -1.711325836632623e-11,   9.544459353733905e-13,  -4.779896892163851e-14,   2.177264546897781e-15,  -9.270620048592767e-17,   3.692523699048126e-18,  -1.349569312186873e-19,
   4.580648878546812e-21,  -1.505498130709624e-22,   2.795941160668219e-01,  -3.515141734019854e-03,   5.512088092185537e-05,  -5.973792601393832e-07,   5.676027248087990e-09,
  -4.512635907739547e-10,   1.556778489055632e-11,   3.125975382733451e-13,  -2.450612252836986e-14,  -4.175740140662495e-16,   4.789467810483282e-17,   2.843851402366210e-19,
  -8.545371983504868e-20,   2.284050221556088e-22,   2.795992902905296e-01,  -3.515311218175897e-03,   5.512419286832459e-05,  -5.977973484539617e-07,   5.697209628218175e-09,
  -4.506698695950431e-10,   1.550727162597777e-11,   3.112274887018326e-13,  -2.431919913143732e-14,  -4.160727128912317e-16,   4.741635507593773e-17,   2.853838128542538e-19,
  -8.434253344271396e-20,   2.156971932896196e-22,   2.796084205562785e-01,  -3.515610370382702e-03,   5.513004637200051e-05,  -5.985346259990797e-07,   5.734518569959571e-09,
  -4.496244127163954e-10,   1.540088488874592e-11,   3.088141574034136e-13,  -2.399096681455948e-14,  -4.134201194310231e-16,   4.657776173940669e-17,   2.870754430613571e-19,
  -8.239773608992673e-20,   1.936499639734051e-22,   2.796194614262486e-01,  -3.515972269911449e-03,   5.513714070642731e-05,  -5.994253907744325e-07,   5.779517803909633e-09,
  -4.483639364968896e-10,   1.527290338007587e-11,   3.059030009394210e-13,  -2.359677526246440e-14,  -4.102067613345294e-16,   4.557290537113760e-17,   2.890021714636205e-19,
  -8.007299889927289e-20,   1.676234724593439e-22,   2.796301801888452e-01,  -3.516323764727383e-03,   5.514404471767458e-05,  -6.002893363002467e-07,   5.823082091761695e-09,
  -4.471441582593649e-10,   1.514935196697850e-11,   3.030843110266151e-13,  -2.321692345960890e-14,  -4.070814471263018e-16,   4.460695292981227e-17,   2.907500533658652e-19,
  -7.784414330375559e-20,   1.430107567636267e-22,   2.796388154268984e-01,  -3.516607045419974e-03,   5.514961862850413e-05,  -6.009847520509059e-07,   5.858091067864091e-09,
  -4.461642896936940e-10,   1.505031348003852e-11,   3.008189255640940e-13,  -2.291293100364149e-14,  -4.045597208591901e-16,   4.383558523328829e-17,   2.920716156305099e-19,
  -7.606846763309124e-20,   1.236443756709954e-22,   2.796445216061416e-01,  -3.516794291494989e-03,   5.515330770080056e-05,  -6.014439929200388e-07,   5.881182450104790e-09,
  -4.455181640795309e-10,   1.498511113837892e-11,   2.993246032595635e-13,  -2.271303848112223e-14,  -4.028915125177517e-16,   4.332918510427156e-17,   2.929030433362197e-19,
  -7.490478881973895e-20,   1.110705564007844e-22,   2.796474520541339e-01,  -3.516890469629135e-03,   5.515520404867134e-05,  -6.016797493565836e-07,   5.893028036844560e-09,
  -4.451867660683073e-10,   1.495170082616660e-11,   2.985580029879993e-13,  -2.261068631695488e-14,  -4.020342357252085e-16,   4.307014272139082e-17,   2.933171927336343e-19,
  -7.431015573161092e-20,   1.046817304474357e-22,   2.796484720316628e-01,  -3.516923948224841e-03,   5.515586438154645e-05,  -6.017617929037105e-07,   5.897148943295006e-09,
  -4.450714865352300e-10,   1.494008385983882e-11,   2.982913090523996e-13,  -2.257510973696730e-14,  -4.017357629131056e-16,   4.298014240368575e-17,   2.934593086515868e-19,
  -7.410366004113776e-20,   1.024688844829815e-22,   2.796486338884419e-01,  -3.516929260955296e-03,   5.515596918112138e-05,  -6.017748114373559e-07,   5.897802776712379e-09,
  -4.450531964211014e-10,   1.493824096708798e-11,   2.982489944897625e-13,  -2.256946650203985e-14,  -4.016883951525699e-16,   4.296586826456541e-17,   2.934817641941256e-19,
  -7.407091439085991e-20,   1.021182500479059e-22,   1.106320212919245e-01,  -1.544131514095650e-03,   3.803178740600092e-05,  -1.141059123249626e-06,   2.872111892851995e-08,
  -4.158323064519667e-10,   4.874436967110207e-12,  -4.609689804109019e-13,   2.032041371539247e-14,   9.432668943397003e-17,  -2.565590142978083e-17,  -1.190837117916185e-19,
   4.902548285589133e-20,  -3.354708759238641e-22,   1.106356192827817e-01,  -1.544453837881454e-03,   3.804798542907682e-05,  -1.141456551140778e-06,   2.872857730149099e-08,
  -4.167351032866010e-10,   4.925749322676018e-12,  -4.606687574791324e-13,   2.022091972142488e-14,   9.364159698361434e-17,  -2.537985219730254e-17,  -1.209922846231936e-19,
   4.842456713076259e-20,  -3.252270989427476e-22,   1.106419692341607e-01,  -1.545022675473313e-03,   3.807657064797579e-05,  -1.142158505578177e-06,   2.874179559562208e-08,
  -4.183276310515527e-10,   5.016083680775463e-12,  -4.601409395563130e-13,   2.004628417908516e-14,   9.242527993099973e-17,  -2.489569209081483e-17,  -1.243025813107681e-19,
   4.737241665803103e-20,  -3.074135937017228e-22,   1.106496497775739e-01,  -1.545710677284923e-03,   3.811114227497370e-05,  -1.143008486974529e-06,   2.875787782575170e-08,
  -4.202525309317522e-10,   5.124965153681156e-12,  -4.595060009521854e-13,   1.983668034329322e-14,   9.094193477538038e-17,  -2.431521408801544e-17,  -1.282085679747752e-19,
   4.611399205778897e-20,  -2.863147854880458e-22,   1.106571081305757e-01,  -1.546378742412731e-03,   3.814471019630008e-05,  -1.143834859725046e-06,   2.877359315167228e-08,
  -4.221203536344087e-10,   5.230298689457288e-12,  -4.588930908607659e-13,   1.963483326397933e-14,   8.948897645227957e-17,  -2.375686929355512e-17,  -1.319003047449805e-19,
   4.490671934054485e-20,  -2.662885150404047e-22,   1.106631180695686e-01,  -1.546917045223192e-03,   3.817175666749142e-05,  -1.144501452734437e-06,   2.878632685343582e-08,
  -4.236244497152976e-10,   5.314892451643180e-12,  -4.584018417385975e-13,   1.947339167223347e-14,   8.830935271675903e-17,  -2.331075598088330e-17,  -1.348034888297275e-19,
   4.394438080220711e-20,  -2.504780582687165e-22,   1.106670901072124e-01,  -1.547272804059016e-03,   3.818963074782460e-05,  -1.144942355260844e-06,   2.879477705550536e-08,
  -4.246180378014601e-10,   5.370662910383146e-12,  -4.580784634547354e-13,   1.936728134292353e-14,   8.752545993983215e-17,  -2.301776517668798e-17,  -1.366875445922075e-19,
   4.331345819808015e-20,  -2.401869334386633e-22,   1.106691301789148e-01,  -1.547455521166770e-03,   3.819881064175780e-05,  -1.145168912687362e-06,   2.879912775940837e-08,
  -4.251282027491420e-10,   5.399264351673195e-12,  -4.579127747378102e-13,   1.931296356987663e-14,   8.712153901159050e-17,  -2.286785276174379e-17,  -1.376445617747455e-19,
   4.299098043115385e-20,  -2.349498701338821e-22,   1.106698402828135e-01,  -1.547519120383519e-03,   3.820200589922267e-05,  -1.145247789227889e-06,   2.880064383111346e-08,
  -4.253057560059541e-10,   5.409213088427279e-12,  -4.578551660869541e-13,   1.929408557939076e-14,   8.698073605868044e-17,  -2.281576212670283e-17,  -1.379759899214001e-19,
   4.287898224105284e-20,  -2.331346589773522e-22,   1.106699529683389e-01,  -1.547529212838824e-03,   3.820251294786345e-05,  -1.145260306852756e-06,   2.880088449478931e-08,
  -4.253339305827467e-10,   5.410791519084370e-12,  -4.578460272767768e-13,   1.929109122149882e-14,   8.695838240403839e-17,  -2.280750022253021e-17,  -1.380285038399783e-19,
   4.286122120143631e-20,  -2.328469699502669e-22,   1.585419593030313e-02,  -2.747957982228470e-04,   1.129016006267089e-05,  -5.104058187685065e-07,   1.617219722989815e-08,
  -3.058373744462080e-10,   6.737020777298035e-12,  -4.503782936162110e-13,   1.736408612424637e-14,  -1.891368010961764e-17,  -1.342647830643154e-17,  -2.819297129916102e-19,
   3.613182469827389e-20,  -1.286792588041397e-23,   1.585527275750667e-02,  -2.749403874681133e-04,   1.129931363347407e-05,  -5.107000118784888e-07,   1.618219660312494e-08,
  -3.067257567459952e-10,   6.781584005711959e-12,  -4.504799490038488e-13,   1.731388810323112e-14,  -2.036503950662667e-17,  -1.322297599781602e-17,  -2.818893246302964e-19,
   3.568891730471830e-20,  -1.026568162328227e-23,   1.585717354065514e-02,  -2.751955860395415e-04,   1.131546994950854e-05,  -5.112197979314368e-07,   1.619989121109064e-08,
  -3.082935026553873e-10,   6.860113252540960e-12,  -4.506633017279020e-13,   1.722599355593138e-14,  -2.292568674305380e-17,  -1.286604579420931e-17,  -2.818041244390493e-19,
   3.491425506885836e-20,  -5.789544716160670e-24,   1.585947318962905e-02,  -2.755042919086882e-04,   1.133501436283119e-05,  -5.118494843896864e-07,   1.622137384504340e-08,
  -3.101895513642318e-10,   6.954896549055898e-12,  -4.508917996485510e-13,   1.712086614529225e-14,  -2.602150083910003e-17,  -1.243808961868099e-17,  -2.816777910166997e-19,
   3.398912596922623e-20,  -5.713149928599548e-25,   1.586170690777705e-02,  -2.758041009110373e-04,   1.135399616294568e-05,  -5.124619833813366e-07,   1.624231890396126e-08,
  -3.120305365989047e-10,   7.046728404825793e-12,  -4.511207265999759e-13,   1.702001413588955e-14,  -2.902624248044595e-17,  -1.202642763324656e-17,  -2.815313094946395e-19,
   3.310306420363421e-20,   4.294303792320393e-24,   1.586350726418680e-02,  -2.760457111459388e-04,   1.136929370267818e-05,  -5.129562718600321e-07,   1.625925645025503e-08,
  -3.135138535735509e-10,   7.120577333146024e-12,  -4.513102372755908e-13,   1.693962722159509e-14,  -3.144634543602256e-17,  -1.169749340933545e-17,  -2.813966217877117e-19,
   3.239781181828338e-20,   8.072935785508838e-24,   1.586469734942889e-02,  -2.762054060115515e-04,   1.137940501156520e-05,  -5.132833135523274e-07,   1.627048002180330e-08,
  -3.144941236720690e-10,   7.169312275242937e-12,  -4.514379545105889e-13,   1.688692738379033e-14,  -3.304525934601548e-17,  -1.148145099138476e-17,  -2.812996119916992e-19,
   3.193594763080269e-20,   1.050166938665772e-23,   1.586530865179534e-02,  -2.762874303116727e-04,   1.138459857131580e-05,  -5.134513964515481e-07,   1.627625361173142e-08,
  -3.149975769264081e-10,   7.194320555971774e-12,  -4.515043140184228e-13,   1.685999251437669e-14,  -3.386629900522213e-17,  -1.137090670398134e-17,  -2.812473489689971e-19,
   3.170003636281245e-20,   1.172807273692204e-23,   1.586552144293902e-02,  -2.763159817458419e-04,   1.138640638373469e-05,  -5.135099201544327e-07,   1.627826471408932e-08,
  -3.151728144667553e-10,   7.203021828239640e-12,  -4.515275337270562e-13,   1.685063809300095e-14,  -3.415205653572274e-17,  -1.133249488772362e-17,  -2.812287722456926e-19,
   3.161812817598642e-20,   1.215162911200816e-23,   1.586555521099582e-02,  -2.763205125661400e-04,   1.138669326561958e-05,  -5.135192080527862e-07,   1.627858392198075e-08,
  -3.152006225376150e-10,   7.204402453808479e-12,  -4.515312241986583e-13,   1.684915464800039e-14,  -3.419740170576794e-17,  -1.132640250308016e-17,  -2.812258061058950e-19,
   3.160514009489344e-20,   1.221868515275486e-23,   6.510107824271611e-04,  -1.618252163501903e-05,   1.034125865826845e-06,  -5.929431828084458e-08,   2.398888784761102e-09,
  -7.519236688704725e-11,   2.689109657544402e-12,  -1.219758062543870e-13,   4.285798425746222e-15,  -8.168109097332729e-17,   1.419216395152599e-18,  -1.264648384596266e-19,
   6.014993418457127e-21,  -1.693275009523840e-23,   6.511104854247404e-04,  -1.619945415330606e-05,   1.035497420059399e-06,  -5.936687424025263e-08,   2.402805403013729e-09,
  -7.543720357609076e-11,   2.700510328676693e-12,  -1.222686853434449e-13,   4.292918433496941e-15,  -8.234004821449771e-17,   1.454704980021771e-18,  -1.266343481379417e-19,
   5.976252897784883e-21,  -1.775714586697379e-23,   6.512865201550535e-04,  -1.622934879982299e-05,   1.037919372161750e-06,  -5.949508844896985e-08,   2.409729432534675e-09,
  -7.586969904676669e-11,   2.720642870275547e-12,  -1.227872884379815e-13,   4.305602044195832e-15,  -8.350354623288806e-17,   1.517141052505902e-18,  -1.269383853690734e-19,
   5.908878256342374e-21,  -1.921438007949865e-23,   6.514995661561786e-04,  -1.626552665961236e-05,   1.040851135155144e-06,  -5.965044738056778e-08,   2.418124383969566e-09,
  -7.639349298736161e-11,   2.745014602339476e-12,  -1.234174822081376e-13,   4.321143812332339e-15,  -8.491176645580455e-17,   1.592328835282058e-18,  -1.273144540844427e-19,
   5.829072312940784e-21,  -2.098074128773500e-23,   6.517065792118295e-04,  -1.630067783702380e-05,   1.043700504709578e-06,  -5.980160355227494e-08,   2.426297469273823e-09,
  -7.690283991575557e-11,   2.768703013525769e-12,  -1.240325046611765e-13,   4.336445229921750e-15,  -8.628022804796554e-17,   1.664998795721220e-18,  -1.276883680912702e-19,
   5.753324412600154e-21,  -2.269978746551606e-23,   6.518734836704789e-04,  -1.632901693197177e-05,   1.045998262695771e-06,  -5.992361426442871e-08,   2.432898386677742e-09,
  -7.731377889288990e-11,   2.787806849112288e-12,  -1.245302824510219e-13,   4.348924626640389e-15,  -8.738364862706640e-17,   1.723313691800597e-18,  -1.279959253038184e-19,
   5.693528340628836e-21,  -2.408759055786589e-23,   6.519838384911654e-04,  -1.634775356796123e-05,   1.047517728901127e-06,  -6.000435499239329e-08,   2.437268379014834e-09,
  -7.758562224354849e-11,   2.800440550802383e-12,  -1.248603434437178e-13,   4.357245444047046e-15,  -8.811326689085575e-17,   1.761737133506288e-18,  -1.282022595732380e-19,
   5.654611588432682e-21,  -2.500603109985875e-23,   6.520405318014334e-04,  -1.635737902821063e-05,   1.048298403055531e-06,  -6.004585580081790e-08,   2.439515123450477e-09,
  -7.772532042245835e-11,   2.806931737470261e-12,  -1.250301977033758e-13,   4.361541638197163e-15,  -8.848811577212558e-17,   1.781435640536162e-18,  -1.283091833042068e-19,
   5.634809144011151e-21,  -2.547811927934932e-23,   6.520602677440466e-04,  -1.636072978355233e-05,   1.048570180477369e-06,  -6.006030636279990e-08,   2.440297528568924e-09,
  -7.777395856971312e-11,   2.809191561306676e-12,  -1.250893731067874e-13,   4.363040635732504e-15,  -8.861861013121793e-17,   1.788286532503924e-18,  -1.283465521728644e-19,
   5.627945796690827e-21,  -2.564250072063188e-23,   6.520633997238045e-04,  -1.636126152724115e-05,   1.048613310500372e-06,  -6.006259974456387e-08,   2.440421704721036e-09,
  -7.778167748225242e-11,   2.809550188313686e-12,  -1.250987660905078e-13,   4.363278680064235e-15,  -8.863931896685981e-17,   1.789373420993687e-18,  -1.283524893662913e-19,
   5.626858056534340e-21,  -2.566858894716296e-23,   4.090946338617996e-06,  -1.938218258094781e-07,   1.896707202248333e-08,  -1.439469148687459e-09,   8.494788865103547e-11,
  -4.447666347020439e-12,   2.270626701376244e-13,  -1.097845228405152e-14,   4.684961372430097e-16,  -1.781254413857152e-17,   6.665923715799963e-19,  -2.547499300329861e-20,
   8.678245820644445e-22,  -2.317057660179544e-23,   4.092824279371080e-06,  -1.942420796731588e-07,   1.901675281819316e-08,  -1.443830175743304e-09,   8.528257500964642e-11,
  -4.470302542505009e-12,   2.283548854735192e-13,  -1.104221105807427e-14,   4.714910943067911e-16,  -1.795112705140496e-17,   6.722339628548322e-19,  -2.565853461991893e-20,
   8.735899258290741e-22,  -2.342447276199721e-23,   4.096141952434831e-06,  -1.949846551006566e-07,   1.910457208319229e-08,  -1.451542848102677e-09,   8.587463653468546e-11,
  -4.510348326623086e-12,   2.306415230428761e-13,  -1.115510004232002e-14,   4.767953354732515e-16,  -1.819644274079060e-17,   6.822184229220839e-19,  -2.598392241974992e-20,
   8.838336792755707e-22,  -2.387367736901522e-23,   4.100160576426107e-06,  -1.958843458117974e-07,   1.921103177703583e-08,  -1.460899110010348e-09,   8.659313016718182e-11,
  -4.558949635705757e-12,   2.334176671436599e-13,  -1.129226562099727e-14,   4.832427581661977e-16,  -1.849442221617813e-17,   6.943427648118092e-19,  -2.637999129032808e-20,
   8.963409564128402e-22,  -2.441891873463662e-23,   4.104068980263572e-06,  -1.967595972679968e-07,   1.931466195254198e-08,  -1.470013510232548e-09,   8.729332558252619e-11,
  -4.606317387746557e-12,   2.361243788660392e-13,  -1.142611560978706e-14,   4.895369529679920e-16,  -1.878510557537115e-17,   7.061666095858854e-19,  -2.676722392855830e-20,
   9.086087201841217e-22,  -2.495039898561502e-23,   4.107222701479074e-06,  -1.974660146012856e-07,   1.939834680612466e-08,  -1.477378574252572e-09,   8.785932898264019e-11,
  -4.644610204032218e-12,   2.383132647336813e-13,  -1.153444059815583e-14,   4.946327226300874e-16,  -1.902029057687756e-17,   7.157304702308653e-19,  -2.708113823186542e-20,
   9.185815608699812e-22,  -2.538011674725970e-23,   4.109309154914285e-06,  -1.979334529431600e-07,   1.945374321529172e-08,  -1.482256373714849e-09,   8.823428330151043e-11,
  -4.669979166779704e-12,   2.397637620428254e-13,  -1.160626379807229e-14,   4.980123047297826e-16,  -1.917619485632075e-17,   7.220691477151131e-19,  -2.728953102101990e-20,
   9.252154963761771e-22,  -2.566483644308754e-23,   4.110381431898286e-06,  -1.981737062467432e-07,   1.948222256025834e-08,  -1.484764793088508e-09,   8.842713428517537e-11,
  -4.683027710696100e-12,   2.405099383745546e-13,  -1.164322401663506e-14,   4.997517186154578e-16,  -1.925641358580377e-17,   7.253302716263224e-19,  -2.739684914731719e-20,
   9.286359551905651e-22,  -2.581129256772471e-23,   4.110754772487847e-06,  -1.982573606839731e-07,   1.949213993806346e-08,  -1.485638418815077e-09,   8.849430467723934e-11,
  -4.687572621430729e-12,   2.407698553105939e-13,  -1.165610040021740e-14,   5.003577488639195e-16,  -1.928435906400935e-17,   7.264662781711093e-19,  -2.743424975370873e-20,
   9.298286438953037e-22,  -2.586230607837194e-23,   4.110814022421953e-06,  -1.982706370141451e-07,   1.949371392112041e-08,  -1.485777077180359e-09,   8.850496591780175e-11,
  -4.688293990306664e-12,   2.408111102102735e-13,  -1.165814427679308e-14,   5.004539465492220e-16,  -1.928879479569157e-17,   7.266465915418033e-19,  -2.744018697290062e-20,
   9.300180100082891e-22,  -2.587040303093812e-23,   2.663718644877026e-01,  -3.101862433699067e-03,   4.826934744953171e-05,  -5.571391760120780e-07,   6.269668901182131e-10,
  -6.254800108622983e-11,   1.354048655304107e-11,  -3.804640657590546e-13,  -1.116658483924640e-14,   8.227195444981989e-16,   2.663787349726289e-01,  -3.102100636759760e-03,
   4.827004331511973e-05,  -5.572372024826946e-07,   6.553467788454463e-10,  -6.362253155790070e-11,   1.349634731171551e-11,  -3.765210575575252e-13,  -1.115036657765684e-14,
   8.124998729747374e-16,   2.663900140830917e-01,  -3.102491717976231e-03,   4.827120303934567e-05,  -5.573992083358253e-07,   7.018690610042887e-10,  -6.537820525492973e-11,
   1.342393775219808e-11,  -3.700850576446774e-13,  -1.112278853726158e-14,   7.958228813433990e-16,   2.664019822245841e-01,  -3.102906729504530e-03,   4.827245715125787e-05,
  -5.575725716387643e-07,   7.511405665746480e-10,  -6.722981666512181e-11,   1.334717794403766e-11,  -3.633061657734775e-13,  -1.109224544868558e-14,   7.782631188383521e-16,
   2.664114013122805e-01,  -3.103233377848514e-03,   4.827346118034750e-05,  -5.577100647995636e-07,   7.898507603926404e-10,  -6.867890132020799e-11,   1.328682107581806e-11,
  -3.580073313697185e-13,  -1.106729214522730e-14,   7.645414821913865e-16,   2.664168372912848e-01,  -3.103421905903854e-03,   4.827404744830239e-05,  -5.577898366341281e-07,
   8.121644302016328e-10,  -6.951194334065362e-11,   1.325200976458178e-11,  -3.549637248813060e-13,  -1.105252779499236e-14,   7.566616223626341e-16,   2.664188785629151e-01,
  -3.103492702508571e-03,   4.827426888668963e-05,  -5.578198713430566e-07,   8.205383824849333e-10,  -6.982414536351237e-11,   1.323894193867133e-11,  -3.538235462516100e-13,
  -1.104691541055931e-14,   7.537100456713351e-16,   2.664192169333004e-01,  -3.103504438188298e-03,   4.827430566125215e-05,  -5.578248542213608e-07,   8.219262184281467e-10,
  -6.987586498292620e-11,   1.323677598040358e-11,  -3.536346889749438e-13,  -1.104598148921632e-14,   7.532211690596595e-16,   1.049876961764340e-01,  -1.287458556440429e-03,
   2.683444817318076e-05,  -7.448175366425305e-07,   2.089737039592636e-08,  -3.837631879311060e-10,   2.885890016772941e-13,   7.007778798216914e-14,   9.032003654473229e-15,
  -5.284129452012555e-16,   1.049915508100121e-01,  -1.287778459714876e-03,   2.685229739874021e-05,  -7.453622711950410e-07,   2.089841440450086e-08,  -3.835943735595699e-10,
   3.246155887581235e-13,   6.751815322824011e-14,   9.034366303452652e-15,  -5.228710646787096e-16,   1.049978806521281e-01,  -1.288303800516026e-03,   2.688160057263210e-05,
  -7.462563842579421e-07,   2.090018391044166e-08,  -3.833226713563508e-10,   3.837625366088266e-13,   6.333622374099176e-14,   9.037661649893740e-15,  -5.138256216330800e-16,
   1.050045996009322e-01,  -1.288861455748196e-03,   2.691269458589510e-05,  -7.472048971492173e-07,   2.090213705471464e-08,  -3.830417359184677e-10,   4.465258488215700e-13,
   5.892611942134957e-14,   9.040373955537875e-15,  -5.042988075578635e-16,   1.050098892569830e-01,  -1.289300498437554e-03,   2.693716653522547e-05,  -7.479512319728019e-07,
   2.090372889858339e-08,  -3.828259498131394e-10,   4.959229816630900e-13,   5.547498813616196e-14,   9.041947305218775e-15,  -4.968524873257104e-16,   1.050129427456970e-01,
  -1.289553944730346e-03,   2.695129010027447e-05,  -7.483818971204173e-07,   2.090466951291188e-08,  -3.827035385149714e-10,   5.244316377977138e-13,   5.349111982510899e-14,
   9.042632503464467e-15,  -4.925755986636486e-16,   1.050140894980644e-01,  -1.289649128840030e-03,   2.695659370131888e-05,  -7.485436050548758e-07,   2.090502686795648e-08,
  -3.826579724207921e-10,   5.351370090552811e-13,   5.274763747991663e-14,   9.042847944740223e-15,  -4.909734587495422e-16,   1.050142795959107e-01,  -1.289664907628413e-03,
   2.695747285238755e-05,  -7.485704098757606e-07,   2.090508632333775e-08,  -3.826504403025493e-10,   5.369115815308857e-13,   5.262447263326069e-14,   9.042881455286662e-15,
  -4.907080853721557e-16,   1.490255857495848e-02,  -2.050059163053753e-04,   6.535787177688100e-06,  -2.950194575381535e-07,   1.095894137441241e-08,  -2.371025654932872e-10,
   1.062234734428336e-12,  -6.412971315778810e-15,   8.007879372110153e-15,  -3.964684666120020e-16,   1.490350751349502e-02,  -2.051330603657697e-04,   6.545159591793353e-06,
  -2.953573203068624e-07,   1.096158826546327e-08,  -2.371523923560796e-10,   1.094174036454647e-12,  -8.344134419084753e-15,   8.009654355992233e-15,  -3.927036669310423e-16,
   1.490506631632559e-02,  -2.053418923013787e-04,   6.560547681126300e-06,  -2.959120406471641e-07,   1.096598285650962e-08,  -2.372382983742133e-10,   1.146610996528516e-12,
  -1.150083971850573e-14,   8.012272375676984e-15,  -3.865667902220937e-16,   1.490672164049240e-02,  -2.055636210071438e-04,   6.576878034857514e-06,  -2.965007309692823e-07,
   1.097071284985312e-08,  -2.373350174051188e-10,   1.202254873402243e-12,  -1.483193665058537e-14,   8.014653919461912e-15,  -3.801142034182619e-16,   1.490802534070112e-02,
  -2.057382254023033e-04,   6.589731861056836e-06,  -2.969640996977994e-07,   1.097448388528879e-08,  -2.374151533812631e-10,   1.246049596606050e-12,  -1.744026586310176e-14,
   8.016245726276148e-15,  -3.750786169497493e-16,   1.490877811298222e-02,  -2.058390341997599e-04,   6.597150762119189e-06,  -2.972315460373749e-07,   1.097667966750288e-08,
  -2.374630077931588e-10,   1.271325356489327e-12,  -1.894029033531310e-14,   8.017052630395891e-15,  -3.721895161426489e-16,   1.490906085855132e-02,  -2.058768966908402e-04,
   6.599936767313214e-06,  -2.973319800056368e-07,   1.097750788070595e-08,  -2.374812807378629e-10,   1.280816825364835e-12,  -1.950256663066762e-14,   8.017334681876975e-15,
  -3.711078432395904e-16,   1.490910773147983e-02,  -2.058831733514080e-04,   6.600398594637858e-06,  -2.973486286499319e-07,   1.097764536278062e-08,  -2.374843257200473e-10,
   1.282390180816569e-12,  -1.959571940137439e-14,   8.017380335037317e-15,  -3.709287098229773e-16,   5.991173299674989e-04,  -1.020003362171474e-05,   5.121016649987389e-07,
  -3.035384586998042e-08,   1.333251338411116e-09,  -3.865125705664683e-11,   7.902787619860757e-13,  -2.720827456606063e-14,   1.707266425525030e-15,  -6.527095837481833e-17,
   5.991925155015139e-04,  -1.021318941900930e-05,   5.132501170523408e-07,  -3.040958485488213e-08,   1.335020209070266e-09,  -3.873779545722946e-11,   7.971659560709096e-13,
  -2.753619457309661e-14,   1.711326930726528e-15,  -6.502384341087218e-17,   5.993160645001140e-04,  -1.023480416489630e-05,   5.151366048139440e-07,  -3.050118060452362e-08,
   1.337934767705296e-09,  -3.888056649256783e-11,   8.084841369205400e-13,  -2.807366288324401e-14,   1.718000047742081e-15,  -6.462474077323303e-17,   5.994473223920740e-04,
  -1.025776271189059e-05,   5.171398370349866e-07,  -3.059849509894907e-08,   1.341041852747625e-09,  -3.903301374128777e-11,   8.205095670771973e-13,  -2.864279530291099e-14,
   1.725091117086394e-15,  -6.421016714414342e-17,   5.995507410088466e-04,  -1.027584833130926e-05,   5.187174968070344e-07,  -3.067517244294168e-08,   1.343497660745019e-09,
  -3.915368203635108e-11,   8.299852144698949e-13,  -2.908987382392200e-14,   1.730679862474650e-15,  -6.389031720160884e-17,   5.996104732193294e-04,  -1.028629276359547e-05,
   5.196284391883928e-07,  -3.071946074672773e-08,   1.344919173386345e-09,  -3.922359900977269e-11,   8.354584377825413e-13,  -2.934756160134279e-14,   1.733908629349181e-15,
  -6.370829117521027e-17,   5.996329122014957e-04,  -1.029021605033919e-05,   5.199705911583069e-07,  -3.073609832018133e-08,   1.345453763040395e-09,  -3.924990584360127e-11,
   8.375145653975414e-13,  -2.944426395874006e-14,   1.735121724931574e-15,  -6.364042251278305e-17,   5.996366322558197e-04,  -1.029086645979119e-05,   5.200273121814226e-07,
  -3.073885659911070e-08,   1.345542421007936e-09,  -3.925426933699129e-11,   8.378554443019937e-13,  -2.946029049955031e-14,   1.735322848279311e-15,  -6.362919781486708e-17,
   3.535406772212707e-06,  -9.333983387641404e-08,   7.647667210461595e-09,  -5.761133231787043e-10,   3.236653605518079e-11,  -1.444714132381418e-12,   6.013000407682406e-14,
  -2.707335538803565e-15,   1.228950196852228e-16,  -4.704143557378238e-18,   3.536552219886821e-06,  -9.359332210034933e-08,   7.676067969826334e-09,  -5.782413311656281e-10,
   3.250097386756350e-11,  -1.453206689515280e-12,   6.063970013802296e-14,  -2.732360231874164e-15,   1.238519956994617e-16,  -4.738164638508445e-18,   3.538435703929968e-06,
  -9.401013782272513e-08,   7.722777334264537e-09,  -5.817437046043535e-10,   3.272247244901389e-11,  -1.467203263157833e-12,   6.147924817878884e-14,  -2.773571725333876e-15,
   1.254305554411767e-16,  -4.794470000481384e-18,   3.540438371461765e-06,  -9.445332880743837e-08,   7.772455271198189e-09,  -5.854721260162592e-10,   3.295858537373954e-11,
  -1.482129162907637e-12,   6.237389033602711e-14,  -2.817477111532587e-15,   1.271158060472983e-16,  -4.854832271048077e-18,   3.542017486797357e-06,  -9.480278781476844e-08,
   7.811636048851761e-09,  -5.884152221343240e-10,   3.314519553852666e-11,  -1.493929954174264e-12,   6.308075139914812e-14,  -2.852159622741915e-15,   1.284495826922510e-16,
  -4.902785541137294e-18,   3.542930031221965e-06,  -9.500473456188997e-08,   7.834281776627087e-09,  -5.901172795982554e-10,   3.325320842920776e-11,  -1.500762120134557e-12,
   6.348980943137740e-14,  -2.872227424166179e-15,   1.292223393427076e-16,  -4.930639978910509e-18,   3.543272928851009e-06,  -9.508061811053067e-08,   7.842791857339853e-09,
  -5.907570890028772e-10,   3.329382824302158e-11,  -1.503331772513184e-12,   6.364362585304600e-14,  -2.879772911181354e-15,   1.295130870730033e-16,  -4.941133574292391e-18,
   3.543329781079630e-06,  -9.509319956213010e-08,   7.844202862061092e-09,  -5.908631819337019e-10,   3.330056472036057e-11,  -1.503757945911620e-12,   6.366913427030210e-14,
  -2.881024202828821e-15,   1.295613127703928e-16,  -4.942874830808563e-18,   2.546946175818394e-01,  -2.742279918049754e-03,   4.164886762843655e-05,  -5.434731025797573e-07,
   1.663598408306447e-09,   1.195223245665297e-10,   1.866231275805350e-12,  -3.422646536767318e-13,   9.486888595548659e-15,   1.895971809258363e-16,   2.547005474292623e-01,
  -2.742511369426774e-03,   4.165031321434440e-05,  -5.433114946437644e-07,   1.667998181201910e-09,   1.185160026612174e-10,   1.901556607160157e-12,  -3.412376213394799e-13,
   9.366770362286732e-15,   1.917287698962084e-16,   2.547102823866692e-01,  -2.742891286444062e-03,   4.165268922331618e-05,  -5.430472171851233e-07,   1.675274314483547e-09,
   1.168662157439053e-10,   1.959207706447917e-12,  -3.395441377584753e-13,   9.170411158465191e-15,   1.951684257986630e-16,   2.547206121372739e-01,  -2.743294342868009e-03,
   4.165521423758331e-05,  -5.427681943922520e-07,   1.683066863929663e-09,   1.151187352880797e-10,   2.019917647259014e-12,  -3.377372231413323e-13,   8.963192818495824e-15,
   1.987375383024057e-16,   2.547287418563249e-01,  -2.743611503541667e-03,   4.165720426370186e-05,  -5.425496117273860e-07,   1.689251554496407e-09,   1.137456890551026e-10,
   2.067362985250827e-12,  -3.363080263794586e-13,   8.800931919475438e-15,   2.014884623453250e-16,   2.547334337367569e-01,  -2.743794524432993e-03,   4.165835388423328e-05,
  -5.424238678161305e-07,   1.692841596224643e-09,   1.129541733014903e-10,   2.094611193338645e-12,  -3.354803752443109e-13,   8.707617084652282e-15,   2.030529590107995e-16,
   2.547351955959738e-01,  -2.743863247061744e-03,   4.165878579371638e-05,  -5.423767261265745e-07,   1.694193603147497e-09,   1.126571208880266e-10,   2.104817988456026e-12,
  -3.351690520290057e-13,   8.672638639002093e-15,   2.036360892740312e-16,   2.547354876499626e-01,  -2.743874638634735e-03,   4.165885740027928e-05,  -5.423689157461961e-07,
   1.694417923733443e-09,   1.126078891531102e-10,   2.106508583584639e-12,  -3.351174177735376e-13,   8.666843742396395e-15,   2.037325221519682e-16,   1.002178716069666e-01,
  -1.103426047383996e-03,   1.965349327430796e-05,  -4.704420745754660e-07,   1.354988064633031e-08,  -3.366180500622052e-10,   3.786505944059515e-12,   1.100434267343311e-13,
  -3.989863768326213e-15,  -1.285711661171507e-16,   1.002206918001031e-01,  -1.103628571887278e-03,   1.966510751260508e-05,  -4.709184347390464e-07,   1.355779391973829e-08,
  -3.363003474716070e-10,   3.772066738328183e-12,   1.093495407450959e-13,  -3.919145314014186e-15,  -1.299138757076560e-16,   1.002253228054483e-01,  -1.103961195017880e-03,
   1.968417899594362e-05,  -4.717001349747794e-07,   1.357076333289852e-08,  -3.357803082565156e-10,   3.748563585607552e-12,   1.082056922360603e-13,  -3.803489853772366e-15,
  -1.320849990419506e-16,   1.002302382937981e-01,  -1.104314332761303e-03,   1.970442187334504e-05,  -4.725291424984110e-07,   1.358449582305109e-08,  -3.352305790371389e-10,
   3.723897593883507e-12,   1.069856286767065e-13,  -3.681369139238219e-15,  -1.343439350342801e-16,   1.002341079920595e-01,  -1.104592397984902e-03,   1.972035786814069e-05,
  -4.731812601757685e-07,   1.359528245720167e-08,  -3.347994440729267e-10,   3.704682201785240e-12,   1.060208850802254e-13,  -3.585693110190849e-15,  -1.360895033641793e-16,
   1.002363417449106e-01,  -1.104752932557156e-03,   1.972955674217212e-05,  -4.735574837570727e-07,   1.360149929726044e-08,  -3.345512322382487e-10,   3.693671359473564e-12,
   1.054623069313109e-13,  -3.530650466758401e-15,  -1.370840547170940e-16,   1.002371806309771e-01,  -1.104813225788595e-03,   1.973301136971763e-05,  -4.736987356112929e-07,
   1.360383221182351e-08,  -3.344581406618752e-10,   3.689551539200808e-12,   1.052522159902880e-13,  -3.510014274395432e-15,  -1.374550978405838e-16,   1.002373196930804e-01,
  -1.104823220829885e-03,   1.973358404260913e-05,  -4.737221488708796e-07,   1.360421884306969e-08,  -3.344427154415630e-10,   3.688869403454780e-12,   1.052173725595430e-13,
  -3.506595264170203e-15,  -1.375164760372579e-16,   1.416843193525763e-02,  -1.642498647685704e-04,   3.896348061528388e-06,  -1.559272811978292e-07,   6.554650437484418e-09,
  -1.969017081188149e-10,   2.565901116108416e-12,   5.996981241961245e-14,  -2.049370192517297e-15,  -1.116708858268893e-16,   1.416899773082522e-02,  -1.643174181968616e-04,
   3.901975235357595e-06,  -1.562060632360496e-07,   6.560044871992166e-09,  -1.967320553573286e-10,   2.558805328159405e-12,   5.937417514409923e-14,  -1.997484769314121e-15,
  -1.125697609186015e-16,   1.416992715952129e-02,  -1.644284037817725e-04,   3.911216455885815e-06,  -1.566635585960754e-07,   6.568890327547062e-09,  -1.964548442976035e-10,
   2.547303964926505e-12,   5.839318754902817e-14,  -1.912638996228637e-15,  -1.140220404428926e-16,   1.417091414869193e-02,  -1.645462845112320e-04,   3.921026592269351e-06,
  -1.571487655884744e-07,   6.578262053564936e-09,  -1.961624742613694e-10,   2.535300098066738e-12,   5.734804577654253e-14,  -1.823062876319061e-15,  -1.155314705332445e-16,
   1.417169148901009e-02,  -1.646391415535580e-04,   3.928750467448754e-06,  -1.575304594166624e-07,   6.585627621883342e-09,  -1.959336635251355e-10,   2.525997362082384e-12,
   5.652248158183488e-14,  -1.7528929851241