/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.apache.batik.ext.awt.MultipleGradientPaintContext;
import org.apache.batik.ext.awt.RadialGradientPaint;

final class RadialGradientPaintContext
extends MultipleGradientPaintContext {
    private boolean isSimpleFocus = false;
    private boolean isNonCyclic = false;
    private float radius;
    private float centerX;
    private float centerY;
    private float focusX;
    private float focusY;
    private float radiusSq;
    private float constA;
    private float constB;
    private float trivial;
    private static final int FIXED_POINT_IMPL = 1;
    private static final int DEFAULT_IMPL = 2;
    private static final int ANTI_ALIAS_IMPL = 3;
    private int fillMethod;
    private static final float SCALEBACK = 0.999f;
    private float invSqStepFloat;
    private int MAX_PRECISION = 256;
    private int[] sqrtLutFixed = new int[this.MAX_PRECISION];

    public RadialGradientPaintContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints, float f, float f2, float f3, float f4, float f5, float[] fArray, Color[] colorArray, MultipleGradientPaint.CycleMethodEnum cycleMethodEnum, MultipleGradientPaint.ColorSpaceEnum colorSpaceEnum) throws NoninvertibleTransformException {
        super(colorModel, rectangle, rectangle2D, affineTransform, renderingHints, fArray, colorArray, cycleMethodEnum, colorSpaceEnum);
        this.centerX = f;
        this.centerY = f2;
        this.focusX = f4;
        this.focusY = f5;
        this.radius = f3;
        this.isSimpleFocus = this.focusX == this.centerX && this.focusY == this.centerY;
        this.isNonCyclic = cycleMethodEnum == RadialGradientPaint.NO_CYCLE;
        this.radiusSq = this.radius * this.radius;
        float f6 = this.focusX - this.centerX;
        float f7 = this.focusY - this.centerY;
        double d = Math.sqrt(f6 * f6 + f7 * f7);
        if (d > (double)(this.radius * 0.999f)) {
            double d2 = Math.atan2(f7, f6);
            this.focusX = (float)((double)(0.999f * this.radius) * Math.cos(d2)) + this.centerX;
            this.focusY = (float)((double)(0.999f * this.radius) * Math.sin(d2)) + this.centerY;
        }
        f6 = this.focusX - this.centerX;
        this.trivial = (float)Math.sqrt(this.radiusSq - f6 * f6);
        this.constA = this.a02 - this.centerX;
        this.constB = this.a12 - this.centerY;
        Object object = renderingHints.get(RenderingHints.KEY_COLOR_RENDERING);
        Object object2 = renderingHints.get(RenderingHints.KEY_RENDERING);
        this.fillMethod = 0;
        if (object2 == RenderingHints.VALUE_RENDER_QUALITY || object == RenderingHints.VALUE_COLOR_RENDER_QUALITY) {
            this.fillMethod = 3;
        }
        if (object2 == RenderingHints.VALUE_RENDER_SPEED || object == RenderingHints.VALUE_COLOR_RENDER_SPEED) {
            this.fillMethod = 2;
        }
        if (this.fillMethod == 0) {
            this.fillMethod = 2;
        }
        if (this.fillMethod == 2 && this.isSimpleFocus && this.isNonCyclic && this.isSimpleLookup) {
            this.calculateFixedPointSqrtLookupTable();
            this.fillMethod = 1;
        }
    }

    protected void fillRaster(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        switch (this.fillMethod) {
            case 1: {
                this.fixedPointSimplestCaseNonCyclicFillRaster(nArray, n, n2, n3, n4, n5, n6);
                break;
            }
            case 3: {
                this.antiAliasFillRaster(nArray, n, n2, n3, n4, n5, n6);
                break;
            }
            default: {
                this.cyclicCircularGradientFillRaster(nArray, n, n2, n3, n4, n5, n6);
            }
        }
    }

    private void fixedPointSimplestCaseNonCyclicFillRaster(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        float f = 0.0f;
        float f2 = (float)this.fastGradientArraySize / this.radius;
        float f3 = this.a00 * (float)n3 + this.a01 * (float)n4 + this.constA;
        float f4 = this.a10 * (float)n3 + this.a11 * (float)n4 + this.constB;
        float f5 = f2 * this.a00;
        float f6 = f2 * this.a10;
        int n7 = this.fastGradientArraySize * this.fastGradientArraySize;
        int n8 = n;
        float f7 = f5 * f5 + f6 * f6;
        float f8 = f7 * 2.0f;
        if (f7 > (float)n7) {
            int n9 = this.gradientOverflow;
            for (int i = 0; i < n6; ++i) {
                int n10 = n8 + n5;
                while (n8 < n10) {
                    nArray[n8] = n9;
                    ++n8;
                }
                n8 += n2;
            }
            return;
        }
        for (int i = 0; i < n6; ++i) {
            float f9 = f2 * (this.a01 * (float)i + f3);
            float f10 = f2 * (this.a11 * (float)i + f4);
            float f11 = f10 * f10 + f9 * f9;
            float f12 = (f6 * f10 + f5 * f9) * 2.0f + f7;
            int n11 = n8 + n5;
            while (n8 < n11) {
                if (f11 >= (float)n7) {
                    nArray[n8] = this.gradientOverflow;
                } else {
                    f = f11 * this.invSqStepFloat;
                    int n12 = (int)f;
                    int n13 = this.sqrtLutFixed[n12];
                    n13 += (int)((f -= (float)n12) * (float)(this.sqrtLutFixed[n12 + 1] - n13));
                    nArray[n8] = this.gradient[n13];
                }
                f11 += f12;
                f12 += f8;
                ++n8;
            }
            n8 += n2;
        }
    }

    private void calculateFixedPointSqrtLookupTable() {
        int n;
        float f = this.fastGradientArraySize * this.fastGradientArraySize / (this.MAX_PRECISION - 2);
        for (n = 0; n < this.MAX_PRECISION - 1; ++n) {
            this.sqrtLutFixed[n] = (int)Math.sqrt((float)n * f);
        }
        this.sqrtLutFixed[n] = this.sqrtLutFixed[n - 1];
        this.invSqStepFloat = 1.0f / f;
    }

    private void cyclicCircularGradientFillRaster(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        double d = -this.radiusSq + this.centerX * this.centerX + this.centerY * this.centerY;
        float f = this.a00 * (float)n3 + this.a01 * (float)n4 + this.a02;
        float f2 = this.a10 * (float)n3 + this.a11 * (float)n4 + this.a12;
        float f3 = 2.0f * this.centerY;
        float f4 = -2.0f * this.centerX;
        int n7 = n;
        int n8 = n5 + n2;
        for (int i = 0; i < n6; ++i) {
            float f5 = this.a01 * (float)i + f;
            float f6 = this.a11 * (float)i + f2;
            for (int j = 0; j < n5; ++j) {
                double d2;
                double d3;
                if ((double)(f5 - this.focusX) > -1.0E-6 && (double)(f5 - this.focusX) < 1.0E-6) {
                    d3 = this.focusX;
                    d2 = this.centerY;
                    d2 += f6 > this.focusY ? (double)this.trivial : (double)(-this.trivial);
                } else {
                    double d4 = (f6 - this.focusY) / (f5 - this.focusX);
                    double d5 = (double)f6 - d4 * (double)f5;
                    double d6 = d4 * d4 + 1.0;
                    double d7 = (double)f4 + -2.0 * d4 * ((double)this.centerY - d5);
                    double d8 = d + d5 * (d5 - (double)f3);
                    float f7 = (float)Math.sqrt(d7 * d7 - 4.0 * d6 * d8);
                    d3 = -d7;
                    d3 += f5 < this.focusX ? (double)(-f7) : (double)f7;
                    d2 = d4 * (d3 /= 2.0 * d6) + d5;
                }
                float f8 = (float)d3 - this.focusX;
                f8 *= f8;
                float f9 = (float)d2 - this.focusY;
                f9 *= f9;
                float f10 = f8 + f9;
                f8 = f5 - this.focusX;
                f8 *= f8;
                f9 = f6 - this.focusY;
                f9 *= f9;
                float f11 = f8 + f9;
                float f12 = (float)Math.sqrt(f11 / f10);
                nArray[n7 + j] = this.indexIntoGradientsArrays(f12);
                f5 += this.a00;
                f6 += this.a10;
            }
            n7 += n8;
        }
    }

    private void antiAliasFillRaster(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        int n7;
        double d13 = -this.radiusSq + this.centerX * this.centerX + this.centerY * this.centerY;
        float f = 2.0f * this.centerY;
        float f2 = -2.0f * this.centerX;
        float f3 = this.a00 * ((float)n3 - 0.5f) + this.a01 * ((float)n4 + 0.5f) + this.a02;
        float f4 = this.a10 * ((float)n3 - 0.5f) + this.a11 * ((float)n4 + 0.5f) + this.a12;
        int n8 = n - 1;
        double[] dArray = new double[n5 + 1];
        float f5 = f3 - this.a01;
        float f6 = f4 - this.a11;
        for (n7 = 0; n7 <= n5; ++n7) {
            if ((double)(f5 - this.focusX) > -1.0E-6 && (double)(f5 - this.focusX) < 1.0E-6) {
                d12 = this.focusX;
                d11 = this.centerY;
                d11 += f6 > this.focusY ? (double)this.trivial : (double)(-this.trivial);
            } else {
                d10 = (f6 - this.focusY) / (f5 - this.focusX);
                d9 = (double)f6 - d10 * (double)f5;
                d8 = d10 * d10 + 1.0;
                d7 = (double)f2 + -2.0 * d10 * ((double)this.centerY - d9);
                d6 = d13 + d9 * (d9 - (double)f);
                d5 = Math.sqrt(d7 * d7 - 4.0 * d8 * d6);
                d12 = -d7;
                d12 += f5 < this.focusX ? -d5 : d5;
                d11 = d10 * (d12 /= 2.0 * d8) + d9;
            }
            d4 = d12 - (double)this.focusX;
            d4 *= d4;
            d3 = d11 - (double)this.focusY;
            d3 *= d3;
            d2 = d4 + d3;
            d4 = f5 - this.focusX;
            d4 *= d4;
            d3 = f6 - this.focusY;
            d3 *= d3;
            d = d4 + d3;
            dArray[n7] = Math.sqrt(d / d2);
            f5 += this.a00;
            f6 += this.a10;
        }
        for (int i = 0; i < n6; ++i) {
            double d14;
            f5 = this.a01 * (float)i + f3;
            f6 = this.a11 * (float)i + f4;
            double d15 = dArray[0];
            if ((double)(f5 - this.focusX) > -1.0E-6 && (double)(f5 - this.focusX) < 1.0E-6) {
                d12 = this.focusX;
                d11 = this.centerY;
                d11 += f6 > this.focusY ? (double)this.trivial : (double)(-this.trivial);
            } else {
                d10 = (f6 - this.focusY) / (f5 - this.focusX);
                d9 = (double)f6 - d10 * (double)f5;
                d8 = d10 * d10 + 1.0;
                d7 = (double)f2 + -2.0 * d10 * ((double)this.centerY - d9);
                d6 = d13 + d9 * (d9 - (double)f);
                d5 = Math.sqrt(d7 * d7 - 4.0 * d8 * d6);
                d12 = -d7;
                d12 += f5 < this.focusX ? -d5 : d5;
                d11 = d10 * (d12 /= 2.0 * d8) + d9;
            }
            d4 = d12 - (double)this.focusX;
            d4 *= d4;
            d3 = d11 - (double)this.focusY;
            d3 *= d3;
            d2 = d4 + d3;
            d4 = f5 - this.focusX;
            d4 *= d4;
            d3 = f6 - this.focusY;
            d3 *= d3;
            d = d4 + d3;
            dArray[0] = d14 = Math.sqrt(d / d2);
            f5 += this.a00;
            f6 += this.a10;
            for (n7 = 1; n7 <= n5; ++n7) {
                double d16 = d15;
                double d17 = d14;
                d15 = dArray[n7];
                if ((double)(f5 - this.focusX) > -1.0E-6 && (double)(f5 - this.focusX) < 1.0E-6) {
                    d12 = this.focusX;
                    d11 = this.centerY;
                    d11 += f6 > this.focusY ? (double)this.trivial : (double)(-this.trivial);
                } else {
                    d10 = (f6 - this.focusY) / (f5 - this.focusX);
                    d9 = (double)f6 - d10 * (double)f5;
                    d8 = d10 * d10 + 1.0;
                    d7 = (double)f2 + -2.0 * d10 * ((double)this.centerY - d9);
                    d6 = d13 + d9 * (d9 - (double)f);
                    d5 = Math.sqrt(d7 * d7 - 4.0 * d8 * d6);
                    d12 = -d7;
                    d12 += f5 < this.focusX ? -d5 : d5;
                    d11 = d10 * (d12 /= 2.0 * d8) + d9;
                }
                d4 = d12 - (double)this.focusX;
                d4 *= d4;
                d3 = d11 - (double)this.focusY;
                d3 *= d3;
                d2 = d4 + d3;
                d4 = f5 - this.focusX;
                d4 *= d4;
                d3 = f6 - this.focusY;
                d3 *= d3;
                d = d4 + d3;
                dArray[n7] = d14 = Math.sqrt(d / d2);
                nArray[n8 + n7] = this.indexGradientAntiAlias((float)((d16 + d17 + d15 + d14) / 4.0), (float)Math.max(Math.abs(d14 - d16), Math.abs(d15 - d17)));
                f5 += this.a00;
                f6 += this.a10;
            }
            n8 += n5 + n2;
        }
    }
}

