/*
 * Decompiled with CFR 0.152.
 */
package yuku.alkitab.yes2.section.base;

import java.io.IOException;
import yuku.alkitab.yes2.io.RandomInputStream;
import yuku.alkitab.yes2.io.RandomOutputStream;
import yuku.bintex.ValueMap;

public class SectionContent {
    private final String name;
    private final byte[] nameAsBytesWithLength;
    private final ValueMap attributes;

    public SectionContent(String name) {
        this(name, null);
    }

    public SectionContent(String name, ValueMap attributes) {
        this.name = name;
        this.attributes = attributes;
        int len = name.length();
        if (len > 255) {
            throw new RuntimeException("section name " + name + " is longer than 255 characters");
        }
        byte[] bb = new byte[len + 1];
        bb[0] = (byte)len;
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (c > '\u00ff') {
                throw new RuntimeException("section name " + name + " is not a 8-bit only string");
            }
            bb[i + 1] = (byte)c;
        }
        this.nameAsBytesWithLength = bb;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getNameAsBytesWithLength() {
        return this.nameAsBytesWithLength;
    }

    public ValueMap getAttributes() {
        return this.attributes;
    }

    public static interface Reader<T extends SectionContent> {
        public T read(RandomInputStream var1) throws Exception;
    }

    public static interface Writer {
        public void write(RandomOutputStream var1) throws IOException;
    }
}

