//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Detector/SphericalDetectorItem.h
//! @brief     Defines class SphericalDetectorItem
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_DETECTOR_SPHERICALDETECTORITEM_H
#define BORNAGAIN_GUI_MODEL_DETECTOR_SPHERICALDETECTORITEM_H

#include "GUI/Model/Descriptor/AxisProperty.h"
#include "GUI/Model/Detector/DetectorItem.h"

class SphericalDetectorItem : public DetectorItem {
public:
    SphericalDetectorItem();

    void writeTo(QXmlStreamWriter* w) const override;
    void readFrom(QXmlStreamReader* r) override;

    int xSize() const override;
    int ySize() const override;
    void setXSize(size_t nx) override;
    void setYSize(size_t ny) override;

    double axesToCoreUnitsFactor() const override;

    AxisProperty& phiAxis() { return m_phiAxis; }
    const AxisProperty& phiAxis() const { return m_phiAxis; }

    AxisProperty& alphaAxis() { return m_alphaAxis; }
    const AxisProperty& alphaAxis() const { return m_alphaAxis; }

protected:
    std::unique_ptr<IDetector> createDomainDetector() const override;

    AxisProperty m_phiAxis;
    AxisProperty m_alphaAxis;
};

#endif // BORNAGAIN_GUI_MODEL_DETECTOR_SPHERICALDETECTORITEM_H
