# search, a bzr plugin for searching within bzr branches/repositories.
# Copyright (C) 2008 Robert Collins
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as published
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
# 

"""Tests for the transport layer."""

from bzrlib.plugins.search import transport
from bzrlib.tests import TestCaseWithTransport


class TestFileView(TestCaseWithTransport):
    
    def get_bulk_and_view_data(self):
        """Get sample data for a view on a file."""
        bulk_data = []
        for count in range(4096):
            bulk_data.append(str(count))
        bulk_data = ":".join(bulk_data)
        view_data = bulk_data[400:1600]
        file_map = {"Foo.1": (400, 1600)}
        base_transport = self.get_transport(".")
        base_transport.put_bytes("foo.pack", bulk_data)
        return bulk_data, view_data, file_map

    def test_get(self):
        bulk_data, view_data, file_map = self.get_bulk_and_view_data()
        base_transport = self.get_transport(".")
        view = transport.FileView(base_transport, "foo.pack", file_map)
        # Doing a get() returns a file which only contains the view_data.
        visible_bytes = view.get("Foo.1").read()
        self.assertEqual(visible_bytes, view_data)

    def test_readv(self):
        bulk_data, view_data, file_map = self.get_bulk_and_view_data()
        base_transport = self.get_transport(".")
        view = transport.FileView(base_transport, "foo.pack", file_map)
        # Doing a readv for '' on view is trimmed to the data between 400 and
        # 1600.
        for offset, data in view.readv('Foo.1', [(0, 10), (700, 100)], True,
            800):
            matching_data = view_data[offset:offset + len(data)]
            self.assertEqual(matching_data, data)
