# Upgrading to 0.19.1

**There are no language changes**, so once you swap to `"elm-version": "0.19.1"` in your `elm.json`, most users should be able to proceed without any further code changes. **You may run into a handful of bugfixes though!** These cases are outlined below!


<br>

## Improvements

- Parse error message quality (like [this](https://github.com/elm/error-message-catalog/issues/255) and [this](https://github.com/elm/error-message-catalog/issues/225))
- Faster compilation, especially for incremental compiles
- Uses filelocks so that cached files are not corrupted when plugins run `elm make` multiple times on the same project at the same time. (Still worth avoiding that though!)
- More intuitive multiline declarations in REPL
- Various bug fixes (e.g. `--debug`, `x /= 0`, `type Height = Height Float` in `--optimize`)


<br>

## Detectable Bug Fixes

There are three known cases where code that compiled with 0.19.0 will not compile with 0.19.1 due to bug fixes:


### 1. Ambiguous Imports

Say you have an import like this:

```elm
import Html exposing (min)
import Regex exposing (never)

x = min
y = never
```

These should be reported as ambiguous usages since the names are also exposed by `Basics`, but there was a regression in 0.19.0 described [here](https://github.com/elm/compiler/issues/1945) such that they weren't caught in specific circumstances.

The fix is to use a qualified name like `Html.min` or `Regex.never` to make it unambiguous.

We found a couple instances of this in packages and have submitted PRs to the relevant authors in August 2019. You may run into this in your own code as well.

For more details on why this is considered a regression, check out the details [here](https://github.com/elm/compiler/issues/1945#issuecomment-507871919) or try it in 0.18.0 to see how it worked before.


### 2. Tabs in Comments

The 0.19.0 binaries did not catch tab characters in comments. The new parser is better at checking for tabs, so it will object when it finds these.

Again, we found this in some packages and reached out to the relevant authors with PRs so patches would be published before the 0.19.1 release.


### 3. Port Module with no Ports

If you have any files that start with:

```elm
port module Main exposing (..)
```

But they do not actually have any `port` declarations, the 0.19.1 binary will ask you to switch to a normal module declaration like `module Main exposing (..)`
