/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.util.Random;
import visad.Delaunay;
import visad.VisADException;

public class DelaunayWatson
extends Delaunay {
    private static final float BIGNUM = 1.0E37f;
    private static final float EPSILON = 1.0E-5f;
    private static final int TSIZE = 75;
    private static final float RANGE = 10.0f;

    public DelaunayWatson(float[][] samples) throws VisADException {
        int i;
        int i11;
        int i1;
        int i0;
        int dim = samples.length;
        int nrs = samples[0].length;
        int[] ii = new int[3];
        float[][] mxy = new float[2][dim];
        for (i0 = 0; i0 < dim; ++i0) {
            mxy[1][i0] = 1.0E37f;
            mxy[0][i0] = -1.0E37f;
        }
        int dim1 = dim + 1;
        float[][] wrk = new float[dim][dim1];
        for (i0 = 0; i0 < dim; ++i0) {
            for (i1 = 0; i1 < dim1; ++i1) {
                wrk[i0][i1] = -10.0f;
            }
        }
        for (i0 = 0; i0 < dim; ++i0) {
            wrk[i0][i0] = 10.0f * (float)(3 * dim - 1);
        }
        float[][] pts = new float[nrs + dim1][dim];
        for (i0 = 0; i0 < nrs; ++i0) {
            if (dim < 3) {
                pts[i0][0] = samples[0][i0];
                pts[i0][1] = samples[1][i0];
            } else {
                pts[i0][0] = samples[0][i0];
                pts[i0][1] = samples[1][i0];
                pts[i0][2] = samples[2][i0];
            }
            for (i1 = 0; i1 < dim; ++i1) {
                if (mxy[0][i1] < pts[i0][i1]) {
                    mxy[0][i1] = pts[i0][i1];
                }
                if (!(mxy[1][i1] > pts[i0][i1])) continue;
                mxy[1][i1] = pts[i0][i1];
            }
        }
        float bgs = 0.0f;
        for (i0 = 0; i0 < dim; ++i0) {
            float[] fArray = mxy[0];
            int n = i0;
            fArray[n] = fArray[n] - mxy[1][i0];
            if (!(bgs < mxy[0][i0])) continue;
            bgs = mxy[0][i0];
        }
        bgs *= 1.0E-5f;
        Random rand = new Random(367L);
        for (i0 = 0; i0 < nrs; ++i0) {
            i1 = 0;
            while (i1 < dim) {
                float[] fArray = pts[i0];
                int n = i1++;
                fArray[n] = (float)((double)fArray[n] + (double)bgs * (0.5 - rand.nextDouble()));
            }
        }
        for (i0 = 0; i0 < dim1; ++i0) {
            for (i1 = 0; i1 < dim; ++i1) {
                pts[nrs + i0][i1] = mxy[1][i1] + wrk[i1][i0] * mxy[0][i1];
            }
        }
        i1 = 1;
        for (i0 = 2; i0 < dim1; ++i0) {
            i1 *= i0;
        }
        int tsz = 75 * i1;
        int[][] tmp = new int[tsz + 1][dim];
        i1 *= nrs + 50 * i1;
        if (dim == 3) {
            i1 *= 10;
        }
        int[] id = new int[i1];
        for (i0 = 0; i0 < i1; ++i0) {
            id[i0] = i0;
        }
        int[][] a3s = new int[i1][dim1];
        float[][] ccr = new float[i1][dim1];
        a3s[0][0] = nrs;
        for (i0 = 1; i0 < dim1; ++i0) {
            a3s[0][i0] = a3s[0][i0 - 1] + 1;
        }
        ccr[0][dim] = 1.0E37f;
        for (i0 = 0; i0 < dim; ++i0) {
            ccr[0][i0] = 0.0f;
        }
        int i4 = 1;
        int nts = 1;
        int dm = dim - 1;
        for (i0 = 0; i0 < nrs; ++i0) {
            int i3;
            int i2;
            float xx;
            int i7 = -1;
            i1 = -1;
            int i9 = 0;
            block16: for (i11 = 0; i11 < nts; ++i11) {
                ++i1;
                while (a3s[i1][0] < 0) {
                    ++i1;
                }
                xx = ccr[i1][dim];
                for (i2 = 0; i2 < dim; ++i2) {
                    if ((xx -= (pts[i0][i2] - ccr[i1][i2]) * (pts[i0][i2] - ccr[i1][i2])) < 0.0f) continue block16;
                }
                --i9;
                id[--i4] = i1;
                block19: for (i2 = 0; i2 < dim1; ++i2) {
                    ii[0] = 0;
                    if (ii[0] == i2) {
                        ii[0] = ii[0] + 1;
                    }
                    for (i3 = 1; i3 < dim; ++i3) {
                        ii[i3] = ii[i3 - 1] + 1;
                        if (ii[i3] != i2) continue;
                        int n = i3;
                        ii[n] = ii[n] + 1;
                    }
                    if (i7 > dm) {
                        int i8 = i7;
                        block21: for (i3 = 0; i3 <= i8; ++i3) {
                            for (int i5 = 0; i5 < dim; ++i5) {
                                if (a3s[i1][ii[i5]] != tmp[i3][i5]) continue block21;
                            }
                            for (int i6 = 0; i6 < dim; ++i6) {
                                tmp[i3][i6] = tmp[i8][i6];
                            }
                            --i7;
                            continue block19;
                        }
                    }
                    if (++i7 > tsz) {
                        int newtsz = 2 * tsz;
                        int[][] newtmp = new int[newtsz + 1][dim];
                        System.arraycopy(tmp, 0, newtmp, 0, tsz);
                        tsz = newtsz;
                        tmp = newtmp;
                    }
                    for (i3 = 0; i3 < dim; ++i3) {
                        tmp[i7][i3] = a3s[i1][ii[i3]];
                    }
                }
                a3s[i1][0] = -1;
            }
            for (i1 = 0; i1 <= i7; ++i1) {
                for (i2 = 0; i2 < dim; ++i2) {
                    wrk[i2][dim] = 0.0f;
                    for (i3 = 0; i3 < dim; ++i3) {
                        wrk[i2][i3] = pts[tmp[i1][i2]][i3] - pts[i0][i3];
                        float[] fArray = wrk[i2];
                        int n = dim;
                        fArray[n] = fArray[n] + wrk[i2][i3] * (pts[tmp[i1][i2]][i3] + pts[i0][i3]) / 2.0f;
                    }
                }
                if (dim < 3) {
                    xx = wrk[0][0] * wrk[1][1] - wrk[1][0] * wrk[0][1];
                    ccr[id[i4]][0] = (wrk[0][2] * wrk[1][1] - wrk[1][2] * wrk[0][1]) / xx;
                    ccr[id[i4]][1] = (wrk[0][0] * wrk[1][2] - wrk[1][0] * wrk[0][2]) / xx;
                } else {
                    xx = wrk[0][0] * (wrk[1][1] * wrk[2][2] - wrk[2][1] * wrk[1][2]) - wrk[0][1] * (wrk[1][0] * wrk[2][2] - wrk[2][0] * wrk[1][2]) + wrk[0][2] * (wrk[1][0] * wrk[2][1] - wrk[2][0] * wrk[1][1]);
                    ccr[id[i4]][0] = (wrk[0][3] * (wrk[1][1] * wrk[2][2] - wrk[2][1] * wrk[1][2]) - wrk[0][1] * (wrk[1][3] * wrk[2][2] - wrk[2][3] * wrk[1][2]) + wrk[0][2] * (wrk[1][3] * wrk[2][1] - wrk[2][3] * wrk[1][1])) / xx;
                    ccr[id[i4]][1] = (wrk[0][0] * (wrk[1][3] * wrk[2][2] - wrk[2][3] * wrk[1][2]) - wrk[0][3] * (wrk[1][0] * wrk[2][2] - wrk[2][0] * wrk[1][2]) + wrk[0][2] * (wrk[1][0] * wrk[2][3] - wrk[2][0] * wrk[1][3])) / xx;
                    ccr[id[i4]][2] = (wrk[0][0] * (wrk[1][1] * wrk[2][3] - wrk[2][1] * wrk[1][3]) - wrk[0][1] * (wrk[1][0] * wrk[2][3] - wrk[2][0] * wrk[1][3]) + wrk[0][3] * (wrk[1][0] * wrk[2][1] - wrk[2][0] * wrk[1][1])) / xx;
                }
                ccr[id[i4]][dim] = 0.0f;
                for (i2 = 0; i2 < dim; ++i2) {
                    float[] fArray = ccr[id[i4]];
                    int n = dim;
                    fArray[n] = fArray[n] + (pts[i0][i2] - ccr[id[i4]][i2]) * (pts[i0][i2] - ccr[id[i4]][i2]);
                    a3s[id[i4]][i2] = tmp[i1][i2];
                }
                a3s[id[i4]][dim] = i0;
                ++i4;
                ++i9;
            }
            nts += i9;
        }
        int[] nverts = new int[nrs];
        for (int i2 = 0; i2 < nrs; ++i2) {
            nverts[i2] = 0;
        }
        int ntris = 0;
        i0 = -1;
        for (i11 = 0; i11 < nts; ++i11) {
            ++i0;
            while (a3s[i0][0] < 0) {
                ++i0;
            }
            if (a3s[i0][0] >= nrs) continue;
            ++ntris;
            if (dim < 3) {
                int n = a3s[i0][0];
                nverts[n] = nverts[n] + 1;
                int n2 = a3s[i0][1];
                nverts[n2] = nverts[n2] + 1;
                int n3 = a3s[i0][2];
                nverts[n3] = nverts[n3] + 1;
                continue;
            }
            int n = a3s[i0][0];
            nverts[n] = nverts[n] + 1;
            int n4 = a3s[i0][1];
            nverts[n4] = nverts[n4] + 1;
            int n5 = a3s[i0][2];
            nverts[n5] = nverts[n5] + 1;
            int n6 = a3s[i0][3];
            nverts[n6] = nverts[n6] + 1;
        }
        this.Vertices = new int[nrs][];
        for (i = 0; i < nrs; ++i) {
            this.Vertices[i] = new int[nverts[i]];
        }
        for (i = 0; i < nrs; ++i) {
            nverts[i] = 0;
        }
        this.Tri = new int[ntris][dim1];
        int itri = 0;
        i0 = -1;
        for (i11 = 0; i11 < nts; ++i11) {
            int c;
            int b;
            int a;
            ++i0;
            while (a3s[i0][0] < 0) {
                ++i0;
            }
            if (a3s[i0][0] >= nrs) continue;
            if (dim < 3) {
                a = a3s[i0][0];
                b = a3s[i0][1];
                c = a3s[i0][2];
                this.Vertices[a][nverts[a]] = itri;
                int n = a;
                nverts[n] = nverts[n] + 1;
                this.Vertices[b][nverts[b]] = itri;
                int n7 = b;
                nverts[n7] = nverts[n7] + 1;
                this.Vertices[c][nverts[c]] = itri;
                int n8 = c;
                nverts[n8] = nverts[n8] + 1;
                this.Tri[itri][0] = a;
                this.Tri[itri][1] = b;
                this.Tri[itri][2] = c;
            } else {
                a = a3s[i0][0];
                b = a3s[i0][1];
                c = a3s[i0][2];
                int d = a3s[i0][3];
                this.Vertices[a][nverts[a]] = itri;
                int n = a;
                nverts[n] = nverts[n] + 1;
                this.Vertices[b][nverts[b]] = itri;
                int n9 = b;
                nverts[n9] = nverts[n9] + 1;
                this.Vertices[c][nverts[c]] = itri;
                int n10 = c;
                nverts[n10] = nverts[n10] + 1;
                this.Vertices[d][nverts[d]] = itri;
                int n11 = d;
                nverts[n11] = nverts[n11] + 1;
                this.Tri[itri][0] = a;
                this.Tri[itri][1] = b;
                this.Tri[itri][2] = c;
                this.Tri[itri][3] = d;
            }
            ++itri;
        }
        this.finish_triang(samples);
    }
}

