/* findpilot.cc: ROM loader state handling the search for the pilot pulses
   Copyright (c) 2008 Fredrick Meunier

   $Id: findpilot.cc 3772 2008-09-22 12:35:12Z fredm $

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

   Author contact information:

   E-mail: fredm@spamcop.net

*/

#include "findpilot.h"
#include "findsync1.h"

findpilot* findpilot::unique_instance;

findpilot*
findpilot::instance()
{
  if( unique_instance == 0 ) {
    unique_instance = new findpilot();
  }
  return unique_instance;
}

void
findpilot::handle_pulse( romloader* loader, double tstates,
                         unsigned int pulse_length )
{
  if( pulse_length < loader->PILOT_MAX ) {
    loader->add_pilot_pulse( tstates, pulse_length );
  } else {
    loader->reset_pilot_count();
  }

  if( loader->get_pilot_count() >= loader->MIN_PILOT_COUNT ) {
    loader->change_state( findsync1::instance() );
  }
}
