/*******************************************************************************
*
*       This file is part of the General Hidden Markov Model Library,
*       GHMM version __VERSION__, see http://ghmm.org
*
*       Filename: ghmm/ghmm/sreestimate.h
*       Authors:  Bernhard Knab, Benjamin Georgi
*
*       Copyright (C) 1998-2004 Alexander Schliep 
*       Copyright (C) 1998-2001 ZAIK/ZPR, Universitaet zu Koeln
*	Copyright (C) 2002-2004 Max-Planck-Institut fuer Molekulare Genetik, 
*                               Berlin
*                                   
*       Contact: schliep@ghmm.org             
*
*       This library is free software; you can redistribute it and/or
*       modify it under the terms of the GNU Library General Public
*       License as published by the Free Software Foundation; either
*       version 2 of the License, or (at your option) any later version.
*
*       This library is distributed in the hope that it will be useful,
*       but WITHOUT ANY WARRANTY; without even the implied warranty of
*       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*       Library General Public License for more details.
*
*       You should have received a copy of the GNU Library General Public
*       License along with this library; if not, write to the Free
*       Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
*
*       This file is version $Revision: 2262 $ 
*                       from $Date: 2009-04-22 09:44:25 -0400 (Wed, 22 Apr 2009) $
*             last change by $Author: grunau $.
*
*******************************************************************************/
#ifndef GHMM_SREESTIMATE_H
#define GHMM_SREESTIMATE_H

#ifdef __cplusplus
extern "C" {
#endif

#include "smodel.h"

/**@name SHMM-Baum-Welch-Algorithm */
/*@{ (Doc++-Group: sreestimate) */

/** Baum-Welch-Algorithm for parameter reestimation (training) in
    a continuous (continuous output functions) HMM. Scaled version
    for multiple sequences. Sequences may carry different weights 
    For reference see:  
    Rabiner, L.R.: "`A Tutorial on Hidden {Markov} Models and Selected
                Applications in Speech Recognition"', Proceedings of the IEEE,
	77, no 2, 1989, pp 257--285    
*/

/** structure that combines a continuous model sequence struct.

    Is used by ghmm_cmodel_baum_welch() for parameter reestimation.
 */
  typedef struct {
  /** pointer of continuous model*/
    ghmm_cmodel *smo;
  /** ghmm_cseq pointer */
    ghmm_cseq *sqd;
  /** calculated log likelihood */
    double *logp;
  /** leave reestimation loop if diff. between successive logp values 
      is smaller than eps */
    double eps;
  /** max. no of iterations */
    int max_iter;
  } ghmm_cmodel_baum_welch_context;


/**
  Baum-Welch Algorithm for SHMMs.
  Training of model parameter with multiple double sequences (incl. scaling).
  New parameters set directly in hmm (no storage of previous values!). Matrices
  are allocated with stat_matrix_d_alloc.
  @return            0/-1 success/error
  @param cs         initial model and train sequences
  */
  int ghmm_cmodel_baum_welch (ghmm_cmodel_baum_welch_context * cs);


#ifdef __cplusplus
}
#endif
#endif                          /* GHMM_SREESTIMATE_H */
/*@} (Doc++-Group: sreestimate) */
