#ifndef __GM_NET_H__
#define __GM_NET_H__

#include <glib.h>
#include <glib-object.h>

G_BEGIN_DECLS

/*
 * Type checking and casting macros
 */
#define GM_TYPE_NET					(gm_net_get_type())
#define GM_NET(obj)					(G_TYPE_CHECK_INSTANCE_CAST((obj), \
		GM_TYPE_NET, GmNet))
#define GM_NET_CONST(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), \
		GM_TYPE_NET, GmNet const))
#define GM_NET_CLASS(klass)			(G_TYPE_CHECK_CLASS_CAST((klass), \
		GM_TYPE_NET, GmNetClass))
#define GM_IS_NET(obj)				(G_TYPE_CHECK_INSTANCE_TYPE((obj), \
		GM_TYPE_NET))
#define GM_IS_NET_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE ((klass), \
		GM_TYPE_NET))
#define GM_NET_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), \
		GM_TYPE_NET, GmNetClass))

typedef enum _GmNetState { 
	GM_NET_STATE_CONNECTED, /**< socket connected */
	GM_NET_STATE_DISCONNECTED, /**< socket disconnected */
	GM_NET_STATE_CONNECTING, /**< socket still connecting */
	GM_NET_STATE_TRY_ADDRESS, /**< connecting to address */
	GM_NET_STATE_DISCONNECTING, /**< socket still disconnecting */
	GM_NET_STATE_END
} GmNetState;

typedef enum _GmNetError { 
	GM_NET_ERROR_CONNECTING, /**< error while connecting */
	GM_NET_ERROR_DISCONNECTED, /**< error while connecting */
	GM_NET_ERROR /**< general error */
} GmNetError;

/* Private structure type */
typedef struct _GmNetPrivate GmNetPrivate;

/*
 * Main object structure
 */
typedef struct _GmNet GmNet;
 
struct _GmNet {
	GObject object;
	
	/*< private > */
	GmNetPrivate *priv;
};

/*
 * Class definition
 */
typedef struct _GmNetClass 	GmNetClass;

struct _GmNetClass {
	GObjectClass parent_class;

	/* Signals */
	void (* state_changing) (GmNet *net, guint state);
	void (* state_changed) (GmNet *net, guint state);
	void (* net_error) (GmNet *net, gchar *error, gint code);
	void (* bytes_recv) (GmNet *net, gchar *text);
};

GType gm_net_get_type(void) G_GNUC_CONST;
GmNet *gm_net_new(void);

GmNetState gm_net_state(GmNet *net);
void gm_net_connect(GmNet *net, const gchar *host, const gchar *port);
void gm_net_disconnect(GmNet *net);
void gm_net_send_line(GmNet *net, gchar *line);
void gm_net_send(GmNet *net, gchar *text);
const gchar *gm_net_current_host(GmNet *net);
const gchar *gm_net_current_port(GmNet *net);

G_END_DECLS
#endif /* __GM_NET_H__ */
