#include "gtest/gtest.h"
#include "osl/oslConfig.h"
#include <iostream>

bool isShortTest = false;
int main(int argc, char **argv)
{
  testing::InitGoogleTest(&argc, argv);
  osl::OslConfig::setInUnitTest(1);
  extern int optind;
  bool error_flag = false;
  char c;
  while ((c = getopt(argc, argv, "s")) != EOF)
  {
    switch (c)
    {
    case 's':	isShortTest = true;
      break;
    default:	error_flag = true;
    }
  }
  argc -= optind;
  argv += optind;
  if (error_flag)
  {
    std::cerr << "unknown option\n";
    return 1;
  } 
  return RUN_ALL_TESTS();
}
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
