# RFC 3: PSC Voting Procedures

Author: [GRASS PSC](https://trac.osgeo.org/grass/wiki/PSC)

Contact: [grass-psc AT lists.osgeo.org](https://lists.osgeo.org/mailman/listinfo/grass-psc)

Status: Adopted (6 Oct 2014)

## Introduction

In brief, the PSC members vote on proposals on the dedicated
[GRASS-PSC mailing list](https://lists.osgeo.org/mailman/listinfo/grass-psc).
Proposals are available for review for at least seven calendar days, and a
single veto is sufficient to delay progress although ultimately a majority
of committee members can pass a proposal.

## Detailed Process

Proposals:

 1. Proposals are written up and submitted on the PSC mailing list for discussion.
    Any committee member may call a vote on any proposal, although it is normal
    practice for the proposer to call the vote. Any interested  party may subscribe
    to the list and join the discussion, but only
    [PSC committee members](https://trac.osgeo.org/grass/wiki/PSC) including the
    PSC Chair get a vote ("eligible voters").
 2. Proposals are available for review for at least seven calendar days before a
    vote can be closed. It is acknowledged that some more complex issues may
    require more time for discussion and deliberation: a vote should only be closed
    after the minimum time period (see above) has passed and sufficient discussion
    has taken place, or no more progress is being made. The PSC Chair may override
    this and prolong the discussion period or close a vote straight away if
    necessary (although the minimum time period for discussion/voting always
    applies).

Voting:

 1. A voting procedure is started by the proposer. For a more visible communication,
    the word [MOTION] should be put into the subject of the email to the
    [GRASS-PSC mailing list](https://lists.osgeo.org/mailman/listinfo/grass-psc)
    along with a short title.
 2. Respondents may vote "+1" to indicate support for the proposal and a
    willingness to support implementation.
 3. Respondents may vote "-1" to veto a proposal, but must provide clear reasoning
    and alternative approaches to resolving the problem within the period the issue
    is open for discussion/voting. Otherwise the veto will be considered invalid.
 4. A vote of -0 indicates mild disagreement, but has no effect.  A 0 indicates
    no opinion.  A +0 indicate mild support, but has no effect.
 5. A proposal will be accepted if it receives majority (51% of all eligible
    voters including the proposer) of votes (+1) and no vetoes (-1).
 6. The committee member who called the vote (normally the proposer) is responsible
    for collating votes and presenting the result to the PSC after closing the vote.
 7. The Chair adjudicates in cases of disputes over voting.
 8. If a proposal is vetoed, and it cannot be revised to satisfy all parties, then
    it can be resubmitted for an override vote in which a majority of all eligible
    voters indicating +1 is sufficient to pass it. Note that this is a majority of
    all eligible voters, not just those who actively vote.
