// Copyright (C) 2000-2007, Luca Padovani <padovani@sti.uniurb.it>.
// 
// This file is part of GtkMathView, a flexible, high-quality rendering
// engine for MathML documents.
// 
// GtkMathView is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published
// by the Free Software Foundation; either version 3 of the License, or
// (at your option) any later version.
// 
// GtkMathView is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

#ifndef __MathMLValueConversion_hh__
#define __MathMLValueConversion_hh__

#include "ValueConversion.hh"
// full path needed for Win32
#include "../../common/mathvariants/MathVariant.hh"

bool isTokenId(const SmartPtr<Value>&, TokenId);
MathVariant toMathVariant(TokenId);
MathVariant toMathVariant(const SmartPtr<Value>&);
Length toLength(const SmartPtr<Value>&, const class FormattingContext&);
Length resolveLength(const class FormattingContext&, const SmartPtr<Value>&, int = -1, int = -1);

#endif // __MathMLValueConversion_hh__
