{- This module was generated from data in the Kate syntax
   highlighting file cs.xml, version 1.15, by  -}

module Text.Highlighting.Kate.Syntax.Cs
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Doxygen
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "C#"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.cs"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("C#","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("C#","Normal") -> return ()
      ("C#","String") -> (popContext) >> pEndLine
      ("C#","Member") -> (popContext) >> pEndLine
      ("C#","Commentar 1") -> (popContext) >> pEndLine
      ("C#","Commentar 2") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keywords = Set.fromList $ words $ "abstract as base break case catch class checked continue default delegate do else enum event explicit extern false for foreach finally fixed goto if implicit in interface internal is lock namespace new null operator out override params private protected public readonly ref return sealed sizeof stackalloc static struct switch this throw true try typeof unchecked unsafe using virtual while #if #else #elif #endif #define #undef #warning #error #line"
list_types = Set.fromList $ words $ "bool byte char const decimal double float int long object uint ushort ulong sbyte short string void"

regex_'5cbpartial'28'3f'3d'5cs'2b'28class'7cstruct'7cinterface'7cvoid'29'29 = compileRegex True "\\bpartial(?=\\s+(class|struct|interface|void))"
regex_'5cbvar'28'3f'3d'5cs'2b'5cw'2b'5cs'2a'3d'5cs'2a'5cw'2b'29 = compileRegex True "\\bvar(?=\\s+\\w+\\s*=\\s*\\w+)"
regex_'5cbyield'28'3f'3d'5cs'2b'28return'7cbreak'29'29 = compileRegex True "\\byield(?=\\s+(return|break))"
regex_'5cb'28set'7cget'29'28'3f'3d'5cs'2a'5b'3b'7b'5d'29 = compileRegex True "\\b(set|get)(?=\\s*[;{])"
regex_'5cbglobal'28'3f'3d'5cs'2a'3a'3a'5cs'2a'5cw'2b'29 = compileRegex True "\\bglobal(?=\\s*::\\s*\\w+)"
regex_'23region'2e'2a'24 = compileRegex True "#region.*$"
regex_'23endregion'2e'2a'24 = compileRegex True "#endregion.*$"
regex_'5cb'5b'5f'5cw'5d'5b'5f'5cw'5cd'5d'2a'28'3f'3d'5b'5cs'5d'2a'5b'28'5d'29 = compileRegex True "\\b[_\\w][_\\w\\d]*(?=[\\s]*[(])"
regex_'5b'2e'5d'7b1'2c1'7d = compileRegex True "[.]{1,1}"
regex_'5cb'5b'5f'5cw'5d'5b'5f'5cw'5cd'5d'2a'28'3f'3d'5b'5cs'5d'2a'29 = compileRegex True "\\b[_\\w][_\\w\\d]*(?=[\\s]*)"

parseRules ("C#","Normal") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute DataTypeTok))
   <|>
   (withChildren (pFloat >>= withAttribute FloatTok) ((pAnyChar "fF" >>= withAttribute FloatTok)))
   <|>
   ((pHlCOct >>= withAttribute BaseNTok))
   <|>
   ((pHlCHex >>= withAttribute BaseNTok))
   <|>
   (withChildren (pInt >>= withAttribute DecValTok) (((pString False "ULL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LUL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LLU" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "UL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LU" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "U" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "L" >>= withAttribute DecValTok))))
   <|>
   ((pHlCChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("C#","String"))
   <|>
   ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression (Just ("Doxygen",""))))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("C#","Commentar 1"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("C#","Commentar 2"))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5cbpartial'28'3f'3d'5cs'2b'28class'7cstruct'7cinterface'7cvoid'29'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbvar'28'3f'3d'5cs'2b'5cw'2b'5cs'2a'3d'5cs'2a'5cw'2b'29 >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'5cbyield'28'3f'3d'5cs'2b'28return'7cbreak'29'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cb'28set'7cget'29'28'3f'3d'5cs'2a'5b'3b'7b'5d'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbglobal'28'3f'3d'5cs'2a'3a'3a'5cs'2a'5cw'2b'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'23region'2e'2a'24 >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'23endregion'2e'2a'24 >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cb'5b'5f'5cw'5d'5b'5f'5cw'5cd'5d'2a'28'3f'3d'5b'5cs'5d'2a'5b'28'5d'29 >>= withAttribute FunctionTok))
   <|>
   ((pRegExpr regex_'5b'2e'5d'7b1'2c1'7d >>= withAttribute NormalTok) >>~ pushContext ("C#","Member"))
   <|>
   ((pAnyChar ":!%&()+,-/.*<=>?[]|~^;" >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("C#","Normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("C#","String") =
  (((pLineContinue >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("C#","String")) >> pDefault >>= withAttribute StringTok))

parseRules ("C#","Member") =
  (((pRegExpr regex_'5cb'5b'5f'5cw'5d'5b'5f'5cw'5cd'5d'2a'28'3f'3d'5b'5cs'5d'2a'29 >>= withAttribute FunctionTok) >>~ (popContext))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("C#","Commentar 1") =
  (currentContext >>= \x -> guard (x == ("C#","Commentar 1")) >> pDefault >>= withAttribute CommentTok)

parseRules ("C#","Commentar 2") =
  (((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("C#","Commentar 2")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Doxygen", _) = Text.Highlighting.Kate.Syntax.Doxygen.parseExpression Nothing

parseRules x = parseRules ("C#","Normal") <|> fail ("Unknown context" ++ show x)
