{- This module was generated from data in the Kate syntax
   highlighting file eiffel.xml, version 1.02, by Sebastian Vuorinen -}

module Text.Highlighting.Kate.Syntax.Eiffel
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Eiffel"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.e"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Eiffel","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("Eiffel","Normal") -> return ()
      ("Eiffel","Quoted String") -> (popContext) >> pEndLine
      ("Eiffel","Documentation") -> (popContext) >> pEndLine
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keywords = Set.fromList $ words $ "agent alias all and as assign class convert create creation debug deferred do else elseif end expanded export external feature from frozen if implies indexing infix inherit inspect is like local loop not obsolete old once or prefix pure redefine reference rename rescue retry separate then undefine"
list_predefined'2dentities = Set.fromList $ words $ "Current False Precursor Result True TUPLE"
list_assertions = Set.fromList $ words $ "check ensure require variant invariant"


parseRules ("Eiffel","Normal") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_predefined'2dentities >>= withAttribute OtherTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_assertions >>= withAttribute OtherTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pFloat >>= withAttribute FloatTok))
   <|>
   ((pHlCChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("Eiffel","Quoted String"))
   <|>
   ((pDetect2Chars False '-' '-' >>= withAttribute CommentTok) >>~ pushContext ("Eiffel","Documentation"))
   <|>
   (currentContext >>= \x -> guard (x == ("Eiffel","Normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Eiffel","Quoted String") =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Eiffel","Quoted String")) >> pDefault >>= withAttribute StringTok))

parseRules ("Eiffel","Documentation") =
  (currentContext >>= \x -> guard (x == ("Eiffel","Documentation")) >> pDefault >>= withAttribute CommentTok)


parseRules x = parseRules ("Eiffel","Normal") <|> fail ("Unknown context" ++ show x)
