{- This module was generated from data in the Kate syntax
   highlighting file relaxng.xml, version 0.8, by Thomas Schraitle (tom_schr AT web DOT de) -}

module Text.Highlighting.Kate.Syntax.Relaxng
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "RELAX NG"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.rng;*.RNG"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("RELAX NG","normalText")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = False, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("RELAX NG","normalText") -> return ()
      ("RELAX NG","detectEntRef") -> return ()
      ("RELAX NG","tagname") -> return ()
      ("RELAX NG","attributes") -> return ()
      ("RELAX NG","attrValue") -> return ()
      ("RELAX NG","string") -> return ()
      ("RELAX NG","comment") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_relaxngnames = Set.fromList $ words $ "anyname attribute choice data define div element empty except externalref grammar group include interleave list mixed name notallowed nsname oneormore optional param parentref ref start text value zeroormore"

regex_'26'28'23'5b0'2d9'5d'2b'7c'23'5bxX'5d'5b0'2d9A'2dFa'2df'5d'2b'7c'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'29'3b = compileRegex True "&(#[0-9]+|#[xX][0-9A-Fa-f]+|[A-Za-z_:][\\w.:_-]*);"
regex_'5cs'2a = compileRegex True "\\s*"
regex_'5cs'2a'3d'5cs'2a = compileRegex True "\\s*=\\s*"
regex_'2d'28'2d'28'3f'21'2d'3e'29'29'2b = compileRegex True "-(-(?!->))+"

parseRules ("RELAX NG","normalText") =
  (((pString False "<!--" >>= withAttribute CommentTok) >>~ pushContext ("RELAX NG","comment"))
   <|>
   ((pDetectChar False '<' >>= withAttribute KeywordTok) >>~ pushContext ("RELAX NG","tagname"))
   <|>
   ((pRegExpr regex_'26'28'23'5b0'2d9'5d'2b'7c'23'5bxX'5d'5b0'2d9A'2dFa'2df'5d'2b'7c'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'29'3b >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("RELAX NG","normalText")) >> pDefault >>= withAttribute NormalTok))

parseRules ("RELAX NG","detectEntRef") =
  (((pRegExpr regex_'26'28'23'5b0'2d9'5d'2b'7c'23'5bxX'5d'5b0'2d9A'2dFa'2df'5d'2b'7c'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'29'3b >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("RELAX NG","detectEntRef")) >> pDefault >>= withAttribute NormalTok))

parseRules ("RELAX NG","tagname") =
  (((pKeyword " \n\t.()!+,<=>%&*/;?[]^{|}~\\\"{}" list_relaxngnames >>= withAttribute NormalTok) >>~ pushContext ("RELAX NG","attributes"))
   <|>
   ((pRegExpr regex_'5cs'2a >>= withAttribute OtherTok) >>~ pushContext ("RELAX NG","attributes"))
   <|>
   ((pDetectChar False '>' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("RELAX NG","tagname")) >> pDefault >>= withAttribute KeywordTok))

parseRules ("RELAX NG","attributes") =
  (((pDetect2Chars False '/' '>' >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((pDetectChar False '>' >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((pRegExpr regex_'5cs'2a'3d'5cs'2a >>= withAttribute NormalTok) >>~ pushContext ("RELAX NG","attrValue"))
   <|>
   (currentContext >>= \x -> guard (x == ("RELAX NG","attributes")) >> pDefault >>= withAttribute OtherTok))

parseRules ("RELAX NG","attrValue") =
  (((pDetect2Chars False '/' '>' >>= withAttribute ErrorTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((pDetectChar False '>' >>= withAttribute ErrorTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("RELAX NG","string"))
   <|>
   (currentContext >>= \x -> guard (x == ("RELAX NG","attrValue")) >> pDefault >>= withAttribute ErrorTok))

parseRules ("RELAX NG","string") =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules ("RELAX NG","detectEntRef")))
   <|>
   (currentContext >>= \x -> guard (x == ("RELAX NG","string")) >> pDefault >>= withAttribute StringTok))

parseRules ("RELAX NG","comment") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pString False "-->" >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'2d'28'2d'28'3f'21'2d'3e'29'29'2b >>= withAttribute NormalTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   (currentContext >>= \x -> guard (x == ("RELAX NG","comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Alerts", _) = Text.Highlighting.Kate.Syntax.Alert.parseExpression Nothing

parseRules x = parseRules ("RELAX NG","normalText") <|> fail ("Unknown context" ++ show x)
