{- This module was generated from data in the Kate syntax
   highlighting file xslt.xml, version 1.03, by Peter Lammich (views@gmx.de) -}

module Text.Highlighting.Kate.Syntax.Xslt
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "xslt"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.xsl;*.xslt"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("xslt","normalText")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = False, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("xslt","normalText") -> return ()
      ("xslt","CDATA") -> return ()
      ("xslt","PI") -> return ()
      ("xslt","Doctype") -> return ()
      ("xslt","Doctype Internal Subset") -> return ()
      ("xslt","Doctype Markupdecl") -> return ()
      ("xslt","Doctype Markupdecl DQ") -> return ()
      ("xslt","Doctype Markupdecl SQ") -> return ()
      ("xslt","detectEntRef") -> return ()
      ("xslt","FindPEntityRefs") -> return ()
      ("xslt","tagname") -> return ()
      ("xslt","attributes") -> return ()
      ("xslt","attrValue") -> return ()
      ("xslt","xattributes") -> return ()
      ("xslt","xattrValue") -> return ()
      ("xslt","string") -> return ()
      ("xslt","sqstring") -> return ()
      ("xslt","comment") -> return ()
      ("xslt","xpath") -> return ()
      ("xslt","sqxpath") -> return ()
      ("xslt","sqxpathstring") -> return ()
      ("xslt","xpathstring") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keytags = Set.fromList $ words $ "xsl:value-of xsl:output xsl:decimal-format xsl:apply-templates xsl:param xsl:transform xsl:namespace-alias xsl:comment xsl:element xsl:attribute xsl:apply-imports xsl:text xsl:when xsl:template xsl:processing-instruction xsl:include xsl:copy-of xsl:copy xsl:with-param xsl:stylesheet xsl:for-each xsl:choose xsl:sort xsl:otherwise xsl:key xsl:variable xsl:number xsl:message xsl:fallback xsl:strip-space xsl:import xsl:preserve-space xsl:if xsl:call-template xsl:attribute-set"
list_keytags'5f2'2e0 = Set.fromList $ words $ "xsl:perform-sort xsl:import-schema xsl:for-each-group xsl:sequence xsl:non-matching-substring xsl:namespace xsl:next-match xsl:function xsl:analyze-string xsl:output-character xsl:matching-substring xsl:result-document xsl:character-map xsl:document"
list_functions = Set.fromList $ words $ "format-number position lang substring-before substring normalize-space round translate starts-with concat local-name key count document system-property current boolean number contains name last unparsed-entity-uri sum generate-id function-available element-available false substring-after not string-length id floor ceiling namespace-uri true string text"
list_functions'5f2'2e0 = Set.fromList $ words $ "zero-or-one replace namespace-uri-for-prefix current-grouping-key seconds-from-duration resolve-uri node-kind minutes-from-datetime implicit-timezone exactly-one current-time current-datetime unordered subtract-dates-yielding-daytimeduration string-join static-base-uri months-from-duration input exists default-collation datetime current-group current-date collection timezone-from-time matches local-name-from-qname day-from-date timezone-from-date round-half-to-even month-from-datetime month-from-date hours-from-duration escape-uri distinct-values avg years-from-duration unparsed-text unparsed-entity-public-id subtract-datetimes-yielding-daytimeduration subtract-dates-yielding-yearmonthduration string-to-codepoints sequence-node-identical hours-from-time hours-from-datetime format-time codepoints-to-string trace tokenize subtract-datetimes-yielding-yearmonthduration subsequence seconds-from-datetime regex-group one-or-more node-name namespace-uri-from-qname min idref format-datetime format-date days-from-duration compare base-uri seconds-from-time in-scope-prefixes expanded-qname adjust-date-to-timezone year-from-date resolve-qname remove qname minutes-from-time max lower-case index-of doc deep-equal data minutes-from-duration adjust-datetime-to-timezone abs timezone-from-datetime reverse error ends-with day-from-datetime year-from-datetime upper-case root normalize-unicode empty insert-before document-uri adjust-time-to-timezone"

regex_'3c'21DOCTYPE'5cs'2b = compileRegex True "<!DOCTYPE\\s+"
regex_'3c'5c'3f'5b'5cw'3a'5f'2d'5d'2a = compileRegex True "<\\?[\\w:_-]*"
regex_'26'28'23'5b0'2d9'5d'2b'7c'23'5bxX'5d'5b0'2d9A'2dFa'2df'5d'2b'7c'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'29'3b = compileRegex True "&(#[0-9]+|#[xX][0-9A-Fa-f]+|[A-Za-z_:][\\w.:_-]*);"
regex_'3c'21'28ELEMENT'7cENTITY'7cATTLIST'7cNOTATION'29'5cb = compileRegex True "<!(ELEMENT|ENTITY|ATTLIST|NOTATION)\\b"
regex_'25'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'3b = compileRegex True "%[A-Za-z_:][\\w.:_-]*;"
regex_'5cs'2a = compileRegex True "\\s*"
regex_'5cs'2a'3d'5cs'2a = compileRegex True "\\s*=\\s*"
regex_select'5cs'2a'3d'5cs'2a = compileRegex True "select\\s*=\\s*"
regex_test'5cs'2a'3d'5cs'2a = compileRegex True "test\\s*=\\s*"
regex_match'5cs'2a'3d'5cs'2a = compileRegex True "match\\s*=\\s*"
regex_'2d'28'2d'28'3f'21'2d'3e'29'29'2b = compileRegex True "-(-(?!->))+"
regex_'28FIXME'7cTODO'7cHACK'29 = compileRegex True "(FIXME|TODO|HACK)"
regex_'28ancestor'7cancestor'2dor'2dself'7cattribute'7cchild'7cdescendant'7cdescendant'2dor'2dself'7cfollowing'7cfollowing'2dsibling'7cnamespace'7cparent'7cpreceding'7cpreceding'2dsibling'7cself'29'3a'3a = compileRegex True "(ancestor|ancestor-or-self|attribute|child|descendant|descendant-or-self|following|following-sibling|namespace|parent|preceding|preceding-sibling|self)::"
regex_'40'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a = compileRegex True "@[A-Za-z_:][\\w.:_-]*"
regex_'5c'24'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a = compileRegex True "\\$[A-Za-z_:][\\w.:_-]*"
regex_'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a = compileRegex True "[A-Za-z_:][\\w.:_-]*"

parseRules ("xslt","normalText") =
  (((pString False "<!--" >>= withAttribute CommentTok) >>~ pushContext ("xslt","comment"))
   <|>
   ((pString False "<![CDATA[" >>= withAttribute BaseNTok) >>~ pushContext ("xslt","CDATA"))
   <|>
   ((pRegExpr regex_'3c'21DOCTYPE'5cs'2b >>= withAttribute DataTypeTok) >>~ pushContext ("xslt","Doctype"))
   <|>
   ((pRegExpr regex_'3c'5c'3f'5b'5cw'3a'5f'2d'5d'2a >>= withAttribute KeywordTok) >>~ pushContext ("xslt","PI"))
   <|>
   ((pDetectChar False '<' >>= withAttribute KeywordTok) >>~ pushContext ("xslt","tagname"))
   <|>
   ((pRegExpr regex_'26'28'23'5b0'2d9'5d'2b'7c'23'5bxX'5d'5b0'2d9A'2dFa'2df'5d'2b'7c'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'29'3b >>= withAttribute DecValTok))
   <|>
   (currentContext >>= \x -> guard (x == ("xslt","normalText")) >> pDefault >>= withAttribute NormalTok))

parseRules ("xslt","CDATA") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok))
   <|>
   ((pString False "]]>" >>= withAttribute BaseNTok) >>~ (popContext))
   <|>
   ((pString False "]]&gt;" >>= withAttribute DecValTok))
   <|>
   (currentContext >>= \x -> guard (x == ("xslt","CDATA")) >> pDefault >>= withAttribute NormalTok))

parseRules ("xslt","PI") =
  (((pDetect2Chars False '?' '>' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("xslt","PI")) >> pDefault >>= withAttribute NormalTok))

parseRules ("xslt","Doctype") =
  (((pDetectChar False '>' >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   ((pDetectChar False '[' >>= withAttribute DataTypeTok) >>~ pushContext ("xslt","Doctype Internal Subset"))
   <|>
   (currentContext >>= \x -> guard (x == ("xslt","Doctype")) >> pDefault >>= withAttribute NormalTok))

parseRules ("xslt","Doctype Internal Subset") =
  (((pDetectChar False ']' >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'3c'21'28ELEMENT'7cENTITY'7cATTLIST'7cNOTATION'29'5cb >>= withAttribute DataTypeTok) >>~ pushContext ("xslt","Doctype Markupdecl"))
   <|>
   ((pString False "<!--" >>= withAttribute CommentTok) >>~ pushContext ("xslt","comment"))
   <|>
   ((pRegExpr regex_'3c'5c'3f'5b'5cw'3a'5f'2d'5d'2a >>= withAttribute KeywordTok) >>~ pushContext ("xslt","PI"))
   <|>
   ((parseRules ("xslt","FindPEntityRefs")))
   <|>
   (currentContext >>= \x -> guard (x == ("xslt","Doctype Internal Subset")) >> pDefault >>= withAttribute NormalTok))

parseRules ("xslt","Doctype Markupdecl") =
  (((pDetectChar False '>' >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   ((pDetectChar False '"' >>= withAttribute NormalTok) >>~ pushContext ("xslt","Doctype Markupdecl DQ"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute NormalTok) >>~ pushContext ("xslt","Doctype Markupdecl SQ"))
   <|>
   (currentContext >>= \x -> guard (x == ("xslt","Doctype Markupdecl")) >> pDefault >>= withAttribute NormalTok))

parseRules ("xslt","Doctype Markupdecl DQ") =
  (((pDetectChar False '"' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((parseRules ("xslt","FindPEntityRefs")))
   <|>
   (currentContext >>= \x -> guard (x == ("xslt","Doctype Markupdecl DQ")) >> pDefault >>= withAttribute NormalTok))

parseRules ("xslt","Doctype Markupdecl SQ") =
  (((pDetectChar False '\'' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((parseRules ("xslt","FindPEntityRefs")))
   <|>
   (currentContext >>= \x -> guard (x == ("xslt","Doctype Markupdecl SQ")) >> pDefault >>= withAttribute NormalTok))

parseRules ("xslt","detectEntRef") =
  (((pRegExpr regex_'26'28'23'5b0'2d9'5d'2b'7c'23'5bxX'5d'5b0'2d9A'2dFa'2df'5d'2b'7c'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'29'3b >>= withAttribute DecValTok))
   <|>
   (currentContext >>= \x -> guard (x == ("xslt","detectEntRef")) >> pDefault >>= withAttribute NormalTok))

parseRules ("xslt","FindPEntityRefs") =
  (((pRegExpr regex_'26'28'23'5b0'2d9'5d'2b'7c'23'5bxX'5d'5b0'2d9A'2dFa'2df'5d'2b'7c'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'29'3b >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'25'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'3b >>= withAttribute DecValTok))
   <|>
   ((pAnyChar "&%" >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("xslt","FindPEntityRefs")) >> pDefault >>= withAttribute NormalTok))

parseRules ("xslt","tagname") =
  (((pKeyword " \n\t.()!+,<=>%&*/;?[]^{|}~\\\"{}" list_keytags >>= withAttribute KeywordTok) >>~ pushContext ("xslt","xattributes"))
   <|>
   ((pKeyword " \n\t.()!+,<=>%&*/;?[]^{|}~\\\"{}" list_keytags'5f2'2e0 >>= withAttribute KeywordTok) >>~ pushContext ("xslt","xattributes"))
   <|>
   ((pRegExpr regex_'5cs'2a >>= withAttribute OtherTok) >>~ pushContext ("xslt","attributes"))
   <|>
   ((pDetectChar False '>' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("xslt","tagname")) >> pDefault >>= withAttribute KeywordTok))

parseRules ("xslt","attributes") =
  (((pDetect2Chars False '/' '>' >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((pDetectChar False '>' >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((pRegExpr regex_'5cs'2a'3d'5cs'2a >>= withAttribute NormalTok) >>~ pushContext ("xslt","attrValue"))
   <|>
   (currentContext >>= \x -> guard (x == ("xslt","attributes")) >> pDefault >>= withAttribute OtherTok))

parseRules ("xslt","attrValue") =
  (((pDetect2Chars False '/' '>' >>= withAttribute ErrorTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((pDetectChar False '>' >>= withAttribute ErrorTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("xslt","string"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext ("xslt","sqstring"))
   <|>
   (currentContext >>= \x -> guard (x == ("xslt","attrValue")) >> pDefault >>= withAttribute ErrorTok))

parseRules ("xslt","xattributes") =
  (((pDetect2Chars False '/' '>' >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((pDetectChar False '>' >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((pRegExpr regex_select'5cs'2a'3d'5cs'2a >>= withAttribute OtherTok) >>~ pushContext ("xslt","xattrValue"))
   <|>
   ((pRegExpr regex_test'5cs'2a'3d'5cs'2a >>= withAttribute OtherTok) >>~ pushContext ("xslt","xattrValue"))
   <|>
   ((pRegExpr regex_match'5cs'2a'3d'5cs'2a >>= withAttribute OtherTok) >>~ pushContext ("xslt","xattrValue"))
   <|>
   ((pRegExpr regex_'5cs'2a'3d'5cs'2a >>= withAttribute OtherTok) >>~ pushContext ("xslt","attrValue"))
   <|>
   (currentContext >>= \x -> guard (x == ("xslt","xattributes")) >> pDefault >>= withAttribute OtherTok))

parseRules ("xslt","xattrValue") =
  (((pDetect2Chars False '/' '>' >>= withAttribute ErrorTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((pDetectChar False '>' >>= withAttribute ErrorTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((pDetectChar False '"' >>= withAttribute OtherTok) >>~ pushContext ("xslt","xpath"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute OtherTok) >>~ pushContext ("xslt","sqxpath"))
   <|>
   (currentContext >>= \x -> guard (x == ("xslt","xattrValue")) >> pDefault >>= withAttribute ErrorTok))

parseRules ("xslt","string") =
  (((pDetectChar False '{' >>= withAttribute OtherTok) >>~ pushContext ("xslt","xpath"))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules ("xslt","detectEntRef")))
   <|>
   (currentContext >>= \x -> guard (x == ("xslt","string")) >> pDefault >>= withAttribute StringTok))

parseRules ("xslt","sqstring") =
  (((pDetectChar False '{' >>= withAttribute OtherTok) >>~ pushContext ("xslt","sqxpath"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules ("xslt","detectEntRef")))
   <|>
   (currentContext >>= \x -> guard (x == ("xslt","sqstring")) >> pDefault >>= withAttribute StringTok))

parseRules ("xslt","comment") =
  (((pString False "-->" >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'2d'28'2d'28'3f'21'2d'3e'29'29'2b >>= withAttribute ErrorTok))
   <|>
   ((pRegExpr regex_'28FIXME'7cTODO'7cHACK'29 >>= withAttribute AlertTok))
   <|>
   (currentContext >>= \x -> guard (x == ("xslt","comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("xslt","xpath") =
  (((pKeyword " \n\t.()!+,<=>%&*/;?[]^{|}~\\\"{}" list_functions >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.()!+,<=>%&*/;?[]^{|}~\\\"{}" list_functions'5f2'2e0 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'28ancestor'7cancestor'2dor'2dself'7cattribute'7cchild'7cdescendant'7cdescendant'2dor'2dself'7cfollowing'7cfollowing'2dsibling'7cnamespace'7cparent'7cpreceding'7cpreceding'2dsibling'7cself'29'3a'3a >>= withAttribute KeywordTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext ("xslt","sqxpathstring"))
   <|>
   ((pDetectChar False '"' >>= withAttribute OtherTok) >>~ (popContext >> popContext))
   <|>
   ((pRegExpr regex_'40'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5c'24'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute OtherTok))
   <|>
   ((pDetectChar False '$' >>= withAttribute ErrorTok))
   <|>
   ((parseRules ("xslt","detectEntRef")))
   <|>
   (currentContext >>= \x -> guard (x == ("xslt","xpath")) >> pDefault >>= withAttribute OtherTok))

parseRules ("xslt","sqxpath") =
  (((pKeyword " \n\t.()!+,<=>%&*/;?[]^{|}~\\\"{}" list_functions >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.()!+,<=>%&*/;?[]^{|}~\\\"{}" list_functions'5f2'2e0 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'28ancestor'7cancestor'2dor'2dself'7cattribute'7cchild'7cdescendant'7cdescendant'2dor'2dself'7cfollowing'7cfollowing'2dsibling'7cnamespace'7cparent'7cpreceding'7cpreceding'2dsibling'7cself'29'3a'3a >>= withAttribute KeywordTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("xslt","xpathstring"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute OtherTok) >>~ (popContext >> popContext))
   <|>
   ((pRegExpr regex_'40'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5c'24'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute OtherTok))
   <|>
   ((pDetectChar False '$' >>= withAttribute ErrorTok))
   <|>
   ((parseRules ("xslt","detectEntRef")))
   <|>
   (currentContext >>= \x -> guard (x == ("xslt","sqxpath")) >> pDefault >>= withAttribute OtherTok))

parseRules ("xslt","sqxpathstring") =
  (((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((parseRules ("xslt","detectEntRef")))
   <|>
   (currentContext >>= \x -> guard (x == ("xslt","sqxpathstring")) >> pDefault >>= withAttribute StringTok))

parseRules ("xslt","xpathstring") =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((parseRules ("xslt","detectEntRef")))
   <|>
   (currentContext >>= \x -> guard (x == ("xslt","xpathstring")) >> pDefault >>= withAttribute StringTok))


parseRules x = parseRules ("xslt","normalText") <|> fail ("Unknown context" ++ show x)
