
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQMediaCaptureSession.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QMediaCaptureSession>
#include <QAudioInput>
#include <QAudioOutput>
#include <QCamera>
#include <QChildEvent>
#include <QEvent>
#include <QImageCapture>
#include <QMediaRecorder>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include <QVideoSink>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QMediaCaptureSession

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QMediaCaptureSession::staticMetaObject);
}


// QAudioInput *QMediaCaptureSession::audioInput()


static void _init_f_audioInput_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAudioInput * > ();
}

static void _call_f_audioInput_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAudioInput * > ((QAudioInput *)((QMediaCaptureSession *)cls)->audioInput ());
}


// void QMediaCaptureSession::audioInputChanged()


static void _init_f_audioInputChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_audioInputChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaCaptureSession *)cls)->audioInputChanged ();
}


// QAudioOutput *QMediaCaptureSession::audioOutput()


static void _init_f_audioOutput_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAudioOutput * > ();
}

static void _call_f_audioOutput_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAudioOutput * > ((QAudioOutput *)((QMediaCaptureSession *)cls)->audioOutput ());
}


// void QMediaCaptureSession::audioOutputChanged()


static void _init_f_audioOutputChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_audioOutputChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaCaptureSession *)cls)->audioOutputChanged ();
}


// QCamera *QMediaCaptureSession::camera()


static void _init_f_camera_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QCamera * > ();
}

static void _call_f_camera_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QCamera * > ((QCamera *)((QMediaCaptureSession *)cls)->camera ());
}


// void QMediaCaptureSession::cameraChanged()


static void _init_f_cameraChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_cameraChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaCaptureSession *)cls)->cameraChanged ();
}


// QImageCapture *QMediaCaptureSession::imageCapture()


static void _init_f_imageCapture_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QImageCapture * > ();
}

static void _call_f_imageCapture_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QImageCapture * > ((QImageCapture *)((QMediaCaptureSession *)cls)->imageCapture ());
}


// void QMediaCaptureSession::imageCaptureChanged()


static void _init_f_imageCaptureChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_imageCaptureChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaCaptureSession *)cls)->imageCaptureChanged ();
}


// QMediaRecorder *QMediaCaptureSession::recorder()


static void _init_f_recorder_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaRecorder * > ();
}

static void _call_f_recorder_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaRecorder * > ((QMediaRecorder *)((QMediaCaptureSession *)cls)->recorder ());
}


// void QMediaCaptureSession::recorderChanged()


static void _init_f_recorderChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_recorderChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaCaptureSession *)cls)->recorderChanged ();
}


// void QMediaCaptureSession::setAudioInput(QAudioInput *input)


static void _init_f_setAudioInput_1729 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("input");
  decl->add_arg<QAudioInput * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAudioInput_1729 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAudioInput *arg1 = gsi::arg_reader<QAudioInput * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaCaptureSession *)cls)->setAudioInput (arg1);
}


// void QMediaCaptureSession::setAudioOutput(QAudioOutput *output)


static void _init_f_setAudioOutput_1858 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("output");
  decl->add_arg<QAudioOutput * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAudioOutput_1858 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAudioOutput *arg1 = gsi::arg_reader<QAudioOutput * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaCaptureSession *)cls)->setAudioOutput (arg1);
}


// void QMediaCaptureSession::setCamera(QCamera *camera)


static void _init_f_setCamera_1288 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("camera");
  decl->add_arg<QCamera * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCamera_1288 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCamera *arg1 = gsi::arg_reader<QCamera * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaCaptureSession *)cls)->setCamera (arg1);
}


// void QMediaCaptureSession::setImageCapture(QImageCapture *imageCapture)


static void _init_f_setImageCapture_1910 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("imageCapture");
  decl->add_arg<QImageCapture * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setImageCapture_1910 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QImageCapture *arg1 = gsi::arg_reader<QImageCapture * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaCaptureSession *)cls)->setImageCapture (arg1);
}


// void QMediaCaptureSession::setRecorder(QMediaRecorder *recorder)


static void _init_f_setRecorder_2005 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("recorder");
  decl->add_arg<QMediaRecorder * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRecorder_2005 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMediaRecorder *arg1 = gsi::arg_reader<QMediaRecorder * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaCaptureSession *)cls)->setRecorder (arg1);
}


// void QMediaCaptureSession::setVideoOutput(QObject *output)


static void _init_f_setVideoOutput_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("output");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVideoOutput_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaCaptureSession *)cls)->setVideoOutput (arg1);
}


// void QMediaCaptureSession::setVideoSink(QVideoSink *sink)


static void _init_f_setVideoSink_1611 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sink");
  decl->add_arg<QVideoSink * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVideoSink_1611 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QVideoSink *arg1 = gsi::arg_reader<QVideoSink * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaCaptureSession *)cls)->setVideoSink (arg1);
}


// QObject *QMediaCaptureSession::videoOutput()


static void _init_f_videoOutput_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_f_videoOutput_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QMediaCaptureSession *)cls)->videoOutput ());
}


// void QMediaCaptureSession::videoOutputChanged()


static void _init_f_videoOutputChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_videoOutputChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaCaptureSession *)cls)->videoOutputChanged ();
}


// QVideoSink *QMediaCaptureSession::videoSink()


static void _init_f_videoSink_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVideoSink * > ();
}

static void _call_f_videoSink_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QVideoSink * > ((QVideoSink *)((QMediaCaptureSession *)cls)->videoSink ());
}


// static QString QMediaCaptureSession::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QMediaCaptureSession::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QMediaCaptureSession () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("audioInput", "@brief Method QAudioInput *QMediaCaptureSession::audioInput()\n", true, &_init_f_audioInput_c0, &_call_f_audioInput_c0);
  methods += new qt_gsi::GenericMethod ("audioInputChanged", "@brief Method void QMediaCaptureSession::audioInputChanged()\n", false, &_init_f_audioInputChanged_0, &_call_f_audioInputChanged_0);
  methods += new qt_gsi::GenericMethod ("audioOutput", "@brief Method QAudioOutput *QMediaCaptureSession::audioOutput()\n", true, &_init_f_audioOutput_c0, &_call_f_audioOutput_c0);
  methods += new qt_gsi::GenericMethod ("audioOutputChanged", "@brief Method void QMediaCaptureSession::audioOutputChanged()\n", false, &_init_f_audioOutputChanged_0, &_call_f_audioOutputChanged_0);
  methods += new qt_gsi::GenericMethod ("camera", "@brief Method QCamera *QMediaCaptureSession::camera()\n", true, &_init_f_camera_c0, &_call_f_camera_c0);
  methods += new qt_gsi::GenericMethod ("cameraChanged", "@brief Method void QMediaCaptureSession::cameraChanged()\n", false, &_init_f_cameraChanged_0, &_call_f_cameraChanged_0);
  methods += new qt_gsi::GenericMethod ("imageCapture", "@brief Method QImageCapture *QMediaCaptureSession::imageCapture()\n", false, &_init_f_imageCapture_0, &_call_f_imageCapture_0);
  methods += new qt_gsi::GenericMethod ("imageCaptureChanged", "@brief Method void QMediaCaptureSession::imageCaptureChanged()\n", false, &_init_f_imageCaptureChanged_0, &_call_f_imageCaptureChanged_0);
  methods += new qt_gsi::GenericMethod ("recorder", "@brief Method QMediaRecorder *QMediaCaptureSession::recorder()\n", false, &_init_f_recorder_0, &_call_f_recorder_0);
  methods += new qt_gsi::GenericMethod ("recorderChanged", "@brief Method void QMediaCaptureSession::recorderChanged()\n", false, &_init_f_recorderChanged_0, &_call_f_recorderChanged_0);
  methods += new qt_gsi::GenericMethod ("setAudioInput", "@brief Method void QMediaCaptureSession::setAudioInput(QAudioInput *input)\n", false, &_init_f_setAudioInput_1729, &_call_f_setAudioInput_1729);
  methods += new qt_gsi::GenericMethod ("setAudioOutput", "@brief Method void QMediaCaptureSession::setAudioOutput(QAudioOutput *output)\n", false, &_init_f_setAudioOutput_1858, &_call_f_setAudioOutput_1858);
  methods += new qt_gsi::GenericMethod ("setCamera", "@brief Method void QMediaCaptureSession::setCamera(QCamera *camera)\n", false, &_init_f_setCamera_1288, &_call_f_setCamera_1288);
  methods += new qt_gsi::GenericMethod ("setImageCapture", "@brief Method void QMediaCaptureSession::setImageCapture(QImageCapture *imageCapture)\n", false, &_init_f_setImageCapture_1910, &_call_f_setImageCapture_1910);
  methods += new qt_gsi::GenericMethod ("setRecorder", "@brief Method void QMediaCaptureSession::setRecorder(QMediaRecorder *recorder)\n", false, &_init_f_setRecorder_2005, &_call_f_setRecorder_2005);
  methods += new qt_gsi::GenericMethod ("setVideoOutput", "@brief Method void QMediaCaptureSession::setVideoOutput(QObject *output)\n", false, &_init_f_setVideoOutput_1302, &_call_f_setVideoOutput_1302);
  methods += new qt_gsi::GenericMethod ("setVideoSink", "@brief Method void QMediaCaptureSession::setVideoSink(QVideoSink *sink)\n", false, &_init_f_setVideoSink_1611, &_call_f_setVideoSink_1611);
  methods += new qt_gsi::GenericMethod ("videoOutput", "@brief Method QObject *QMediaCaptureSession::videoOutput()\n", true, &_init_f_videoOutput_c0, &_call_f_videoOutput_c0);
  methods += new qt_gsi::GenericMethod ("videoOutputChanged", "@brief Method void QMediaCaptureSession::videoOutputChanged()\n", false, &_init_f_videoOutputChanged_0, &_call_f_videoOutputChanged_0);
  methods += new qt_gsi::GenericMethod ("videoSink", "@brief Method QVideoSink *QMediaCaptureSession::videoSink()\n", true, &_init_f_videoSink_c0, &_call_f_videoSink_c0);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QMediaCaptureSession::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QMediaCaptureSession> decl_QMediaCaptureSession (qtdecl_QObject (), "QtMultimedia", "QMediaCaptureSession_Native",
  methods_QMediaCaptureSession (),
  "@hide\n@alias QMediaCaptureSession");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QMediaCaptureSession> &qtdecl_QMediaCaptureSession () { return decl_QMediaCaptureSession; }

}


class QMediaCaptureSession_Adaptor : public QMediaCaptureSession, public qt_gsi::QtObjectBase
{
public:

  virtual ~QMediaCaptureSession_Adaptor();

  //  [adaptor ctor] QMediaCaptureSession::QMediaCaptureSession(QObject *parent)
  QMediaCaptureSession_Adaptor() : QMediaCaptureSession()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMediaCaptureSession::QMediaCaptureSession(QObject *parent)
  QMediaCaptureSession_Adaptor(QObject *parent) : QMediaCaptureSession(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QMediaCaptureSession::isSignalConnected(const QMetaMethod &signal)
  bool fp_QMediaCaptureSession_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QMediaCaptureSession::isSignalConnected(signal);
  }

  //  [expose] int QMediaCaptureSession::receivers(const char *signal)
  int fp_QMediaCaptureSession_receivers_c1731 (const char *signal) const {
    return QMediaCaptureSession::receivers(signal);
  }

  //  [expose] QObject *QMediaCaptureSession::sender()
  QObject * fp_QMediaCaptureSession_sender_c0 () const {
    return QMediaCaptureSession::sender();
  }

  //  [expose] int QMediaCaptureSession::senderSignalIndex()
  int fp_QMediaCaptureSession_senderSignalIndex_c0 () const {
    return QMediaCaptureSession::senderSignalIndex();
  }

  //  [adaptor impl] bool QMediaCaptureSession::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QMediaCaptureSession::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QMediaCaptureSession_Adaptor, bool, QEvent *>(&QMediaCaptureSession_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QMediaCaptureSession::event(_event);
    }
  }

  //  [adaptor impl] bool QMediaCaptureSession::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QMediaCaptureSession::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QMediaCaptureSession_Adaptor, bool, QObject *, QEvent *>(&QMediaCaptureSession_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QMediaCaptureSession::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] void QMediaCaptureSession::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QMediaCaptureSession::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QMediaCaptureSession_Adaptor, QChildEvent *>(&QMediaCaptureSession_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QMediaCaptureSession::childEvent(event);
    }
  }

  //  [adaptor impl] void QMediaCaptureSession::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QMediaCaptureSession::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QMediaCaptureSession_Adaptor, QEvent *>(&QMediaCaptureSession_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QMediaCaptureSession::customEvent(event);
    }
  }

  //  [adaptor impl] void QMediaCaptureSession::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QMediaCaptureSession::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QMediaCaptureSession_Adaptor, const QMetaMethod &>(&QMediaCaptureSession_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QMediaCaptureSession::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QMediaCaptureSession::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QMediaCaptureSession::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QMediaCaptureSession_Adaptor, QTimerEvent *>(&QMediaCaptureSession_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QMediaCaptureSession::timerEvent(event);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QMediaCaptureSession_Adaptor::~QMediaCaptureSession_Adaptor() { }

//  Constructor QMediaCaptureSession::QMediaCaptureSession(QObject *parent) (adaptor class)

static void _init_ctor_QMediaCaptureSession_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QMediaCaptureSession_Adaptor> ();
}

static void _call_ctor_QMediaCaptureSession_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QMediaCaptureSession_Adaptor *> (new QMediaCaptureSession_Adaptor (arg1));
}


// void QMediaCaptureSession::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaCaptureSession_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaCaptureSession_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QMediaCaptureSession::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaCaptureSession_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaCaptureSession_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// void QMediaCaptureSession::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaCaptureSession_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaCaptureSession_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QMediaCaptureSession::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMediaCaptureSession_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaCaptureSession_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QMediaCaptureSession::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMediaCaptureSession_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaCaptureSession_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed bool QMediaCaptureSession::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QMediaCaptureSession_Adaptor *)cls)->fp_QMediaCaptureSession_isSignalConnected_c2394 (arg1));
}


// exposed int QMediaCaptureSession::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QMediaCaptureSession_Adaptor *)cls)->fp_QMediaCaptureSession_receivers_c1731 (arg1));
}


// exposed QObject *QMediaCaptureSession::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QMediaCaptureSession_Adaptor *)cls)->fp_QMediaCaptureSession_sender_c0 ());
}


// exposed int QMediaCaptureSession::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaCaptureSession_Adaptor *)cls)->fp_QMediaCaptureSession_senderSignalIndex_c0 ());
}


// void QMediaCaptureSession::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaCaptureSession_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaCaptureSession_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QMediaCaptureSession> &qtdecl_QMediaCaptureSession ();

static gsi::Methods methods_QMediaCaptureSession_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMediaCaptureSession::QMediaCaptureSession(QObject *parent)\nThis method creates an object of class QMediaCaptureSession.", &_init_ctor_QMediaCaptureSession_Adaptor_1302, &_call_ctor_QMediaCaptureSession_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QMediaCaptureSession::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QMediaCaptureSession::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QMediaCaptureSession::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QMediaCaptureSession::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QMediaCaptureSession::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QMediaCaptureSession::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QMediaCaptureSession::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QMediaCaptureSession::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QMediaCaptureSession::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QMediaCaptureSession::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QMediaCaptureSession_Adaptor> decl_QMediaCaptureSession_Adaptor (qtdecl_QMediaCaptureSession (), "QtMultimedia", "QMediaCaptureSession",
  methods_QMediaCaptureSession_Adaptor (),
  "@qt\n@brief Binding of QMediaCaptureSession");

}

