#include "rrset.h"

namespace ADNS {

	RRSet::RRSet() {

		set = gcnew array<ResourceRecord^>(0);
		return;
	}
	Void RRSet::Add(ResourceRecord^ rr)
	{
		if (set == nullptr)
		{
			set = gcnew array<ResourceRecord^>(1);
			set[0] = rr;
		}
		else
		{
			set->Resize(set,set->Length + 1);
			set[set->Length - 1] = rr;
		}

		return;
	}
	
	RRSet^ RRSet::GetAllOfType(RR_TYPE type)
	{
		RRSet^ output = gcnew RRSet();
		int i;

		for (i = 0; i < set->Length; ++i)
		{
			if (set[i]->rr_type == type)
				output->Add(set[i]);
		}

		return output;
	}

	int RRSet::Length()
	{
		if (set == nullptr)
			return 0;
		else
			return set->Length;
	}

	Void RRSet::SortCanonical()
	{
		int i;
		bool swapped = true;
		int n;
		ResourceRecord^ rrhold;

		n = set->Length;
		while(swapped)
		{
			swapped = false;
			for (i = 0; i < n - 1; ++i)
			{		
				if (set[i]->RdataIsLess(set[i+1],set[i]))
				{ 
					rrhold = set[i];
					set[i] = set[i+1];
					set[i+1] = rrhold;
					swapped = true;
				}
			}
			n--;
		}

		return;
	}

	Void RRSet::ToCanonical()
	{
		int i = 0;


		for (i = 0; i < set->Length; ++i)
		{
			switch(set[i]->rr_type)
			{
			case RR_TYPE::NS:
				safe_cast<NS_RR^>(set[i])->ToCanonical();
				break;
			case RR_TYPE::MF:
				safe_cast<MF_RR^>(set[i])->ToCanonical();
				break;
			case RR_TYPE::CNAME: 
				safe_cast<CNAME_RR^>(set[i])->ToCanonical();
				break;
			case RR_TYPE::SOA: 
				safe_cast<SOA_RR^>(set[i])->ToCanonical();
				break;
			case RR_TYPE::MB:
				safe_cast<MB_RR^>(set[i])->ToCanonical();
				break;
			case RR_TYPE::MG: 
				safe_cast<MG_RR^>(set[i])->ToCanonical();
				break;
			case RR_TYPE::MR: 
				safe_cast<MR_RR^>(set[i])->ToCanonical();
				break;
			case RR_TYPE::PTR:
				safe_cast<PTR_RR^>(set[i])->ToCanonical();
				break;
			case RR_TYPE::HINFO: 
				safe_cast<HINFO_RR^>(set[i])->ToCanonical();
				break;
			case RR_TYPE::MINFO:
				safe_cast<MINFO_RR^>(set[i])->ToCanonical();
				break;
			case RR_TYPE::MX:
				safe_cast<MX_RR^>(set[i])->ToCanonical();
				break;
			case RR_TYPE::RRSIG:
				safe_cast<RRSIG_RR^>(set[i])->ToCanonical();
				break;
			case RR_TYPE::NSEC:
				safe_cast<NSEC_RR^>(set[i])->ToCanonical();
				break;
			case RR_TYPE::NSEC3:
				safe_cast<NSEC3_RR^>(set[i])->ToCanonical();
				break;

			case RR_TYPE::OPT:
				break;
			case RR_TYPE::A:
			case RR_TYPE::AAAA:
			case RR_TYPE::DS:
			case RR_TYPE::DNSKEY:
			case RR_TYPE::NULL:
			case RR_TYPE::TXT:
				set[i]->owner->MakeCanonical();
				break;
			default:
				//Throw some error:  We're processing something that we don't support yet.
				throw gcnew Exception("Error:  Unsupposed RRSet sent to RRSetToCanonical!");
			}

		}

		return;
	}

	array<Byte>^ RRSet::GetCanonicalByteArray()
	{
		ToCanonical();
		SortCanonical();
		return GetByteArray();
	}

	array<Byte>^ RRSet::GetByteArray()
	{
		int i = 0;
		int oldlen;
		array<Byte>^ output;
		array<Byte>^ tmparray;

		if (set == nullptr)
			return nullptr;

		for (i = 0; i < set->Length; ++i)
		{
			tmparray = set[i]->ToWire();
			if (output == nullptr)
			{
				output = tmparray;
			}
			else
			{
				oldlen = output->Length;
				output->Resize(output,oldlen + tmparray->Length);
				tmparray->CopyTo(output,oldlen);
			}
		}

		return output;
	}

}