# Contributing to liquidctl

Thank you for your interest in contributing to liquidctl!  There are many ways
to contribute and we appreciate all of them.

We ask you, however, to adhere to our [code of conduct].

[code of conduct]: CODE_OF_CONDUCT.md

## Reporting bugs and other issues

Reporting problems with the software is an easy and very valuable way to
contribute to the project.  Please check the existing [issues] and, if none
matches your problem, use the appropriate template to create a [new issue].

[issues]: https://github.com/liquidctl/liquidctl/issues
[new issue]: https://github.com/liquidctl/liquidctl/issues/new/choose

## Contributing changes to code and/or documentation

Awesome!

We generally use [pull requests] to review and (assuming everything goes
well) merge contributions.

[pull requests]: https://github.com/liquidctl/liquidctl/pulls

It is not necessary to discuss a change beforehand in an issue, but that can
sometimes be helpful (e.g. to decide the best approach).  You can also reach
out to us and other fellow contributors on [Discord].

[Discord]: https://discord.gg/GyCBjQhqCd

Please also read the following documents, they will give you a general idea of
our development process and coding styling:

- [Development process](docs/developer/process.md)
- [Style guide](docs/developer/style-guide.md)

And, depending on what you are doing, some of these may also be useful:

- [Capturing USB Traffic](docs/developer/capturing-usb-traffic.md)
- [Techniques for analyzing USB protocols](docs/developer/techniques-for-analyzing-usb-protocols.md)
- [Porting drivers from OpenCorsairLink](docs/developer/porting-drivers-from-opencorsairlink.md) (introduces the liquidctl driver model)
- other documents in [`docs/developer`](docs/developer)

---

_The first sentences in this file were taken from rust-lang/rust's
CONTRIBUTING.md document._

