#ifndef __VIRTFILE_H__
#define __VIRTFILE_H__
/*
 * Jeffrey Friedl
 * Omron Corporation			ʳ
 * Nagaokakyoshi, Japan			617Ĺ
 *
 * jfriedl@nff.ncl.omron.co.jp
 *
 * This work is placed under the terms of the GNU General Purpose License
 * (the "GNU Copyleft").
 *
 * July 1996
 *
 * Routine to access a file with virtualmemory-like access.
 */

typedef long int fileloc; /* index to a file position */

/*
 * Information on a single virtual file.
 */
typedef struct
{
    int fd;                   /* open file descriptor */
    const char *filename;     /* for reference, filename of opened file */
    fileloc length;           /* length of opened file */
}  VirtFile;

/*
 * Pages used for access to all files.
 */
typedef struct
{
    VirtFile *owner;           /* this page represents part of this file */
    const unsigned char *text; /* pointer to this page's text */
    fileloc start;             /* offset into file this page starts */
    fileloc end;               /* offset into file this page ends */
} Page;


/*
 * Open the file and return it's virtual handle.
 */
VirtFile *
OpenVertFile(const char *filename);

/*
 * Given a firtual file and an offset into the file, return a pointer
 * to the string which starts (or encompasses) the starting position.
 * If pCount is not NULL, is filled with the length of the line.
 */
const unsigned char *
VirtPos2Str(VirtFile *v, fileloc start, unsigned *pCount);


/* convenient utility */
extern long int filesize(const char *filename);

#endif /* File Wrapper */
