/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper;

import com.google.caliper.Arguments;
import com.google.caliper.ConfiguredBenchmark;
import com.google.caliper.CountingPrintStream;
import com.google.caliper.DebugMeasurer;
import com.google.caliper.InstancesAllocationMeasurer;
import com.google.caliper.Json;
import com.google.caliper.MeasurementSet;
import com.google.caliper.MeasurementType;
import com.google.caliper.Measurer;
import com.google.caliper.MemoryAllocationMeasurer;
import com.google.caliper.Scenario;
import com.google.caliper.ScenarioSelection;
import com.google.caliper.TimeMeasurer;
import com.google.caliper.UserException;
import com.google.common.base.Supplier;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;

final class InProcessRunner {
    InProcessRunner() {
    }

    public void run(String ... args) {
        Arguments arguments = Arguments.parse(args);
        ScenarioSelection scenarioSelection = new ScenarioSelection(arguments);
        try {
            Measurer measurer = this.getMeasurer(arguments);
            List<Scenario> scenarios = scenarioSelection.select();
            if (scenarios.size() != 1) {
                throw new IllegalArgumentException("Invalid arguments to subprocess. Expected exactly one scenario but got " + scenarios.size());
            }
            Scenario scenario = scenarios.get(0);
            System.out.println("starting " + scenario);
            MeasurementSet measurementSet = this.run(scenarioSelection, scenario, measurer);
            System.out.println(arguments.getMarker() + Json.measurementSetToJson(measurementSet));
        }
        catch (UserException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UserException.ExceptionFromUserCodeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MeasurementSet run(final ScenarioSelection scenarioSelection, final Scenario scenario, Measurer measurer) throws Exception {
        Supplier<ConfiguredBenchmark> supplier = new Supplier<ConfiguredBenchmark>(){

            public ConfiguredBenchmark get() {
                return scenarioSelection.createBenchmark(scenario);
            }
        };
        PrintStream out = System.out;
        PrintStream err = System.err;
        measurer.setLogStream(out);
        CountingPrintStream countedOut = new CountingPrintStream(out);
        CountingPrintStream countedErr = new CountingPrintStream(err);
        System.setOut(countedOut);
        System.setErr(countedErr);
        try {
            MeasurementSet measurementSet = measurer.run(supplier);
            if (measurementSet != null) {
                measurementSet = measurementSet.plusCharCounts(countedOut.getCount(), countedErr.getCount());
            }
            MeasurementSet measurementSet2 = measurementSet;
            return measurementSet2;
        }
        finally {
            System.setOut(out);
            System.setErr(err);
        }
    }

    private Measurer getMeasurer(Arguments arguments) {
        if (arguments.getMeasurementType() == MeasurementType.TIME) {
            return new TimeMeasurer(arguments.getWarmupMillis(), arguments.getRunMillis());
        }
        if (arguments.getMeasurementType() == MeasurementType.INSTANCE) {
            return new InstancesAllocationMeasurer();
        }
        if (arguments.getMeasurementType() == MeasurementType.MEMORY) {
            return new MemoryAllocationMeasurer();
        }
        if (arguments.getMeasurementType() == MeasurementType.DEBUG) {
            return new DebugMeasurer(arguments.getDebugReps());
        }
        throw new IllegalArgumentException("unrecognized measurement type: " + (Object)((Object)arguments.getMeasurementType()));
    }

    public static void main(String ... args) throws Exception {
        try {
            new InProcessRunner().run(args);
            System.exit(0);
        }
        catch (UserException e) {
            e.display();
            System.out.println("[caliper] [scenarios finished]");
            System.exit(1);
        }
    }

    public PrintStream nullPrintStream() {
        return new PrintStream(new OutputStream(){

            @Override
            public void write(int b) {
            }
        });
    }
}

