jush.api.js = {
	'decodeURI': 'Decodes an encoded URI (string)',
	'decodeURIComponent': 'Decodes an encoded URI component (string)',
	'encodeURI': 'Encodes a string as a URI (string)',
	'encodeURIComponent': 'Encodes a string as a URI component (string)',
	'escape': 'Encodes a string (string)',
	'eval': 'Evaluates a string and executes it as if it was script code (string)',
	'isFinite': 'Checks if a value is a finite number (number)',
	'isNaN': 'Checks if a value is not a number (number)',
	'parseFloat': 'Parses a string and returns a floating point number (string)',
	'parseInt': 'Parses a string and returns an integer (string, [radix])',
	'unescape': 'Decodes a string encoded by escape() (string)',
	'Math.abs': 'Returns the absolute value of a number (x)',
	'Math.acos': 'Returns the arccosine of a number (x)',
	'Math.asin': 'Returns the arcsine of a number (x)',
	'Math.atan': 'Returns the arctangent of x as a numeric value between -PI/2 and PI/2 radians (x)',
	'Math.atan2': 'Returns the angle theta of an (x,y) point as a numeric value between -PI and PI radians (y, x)',
	'Math.ceil': 'Returns the value of a number rounded upwards to the nearest integer (x)',
	'Math.cos': 'Returns the cosine of a number (x)',
	'Math.exp': 'Returns the value of Ex (x)',
	'Math.floor': 'Returns the value of a number rounded downwards to the nearest integer (x)',
	'Math.log': 'Returns the natural logarithm (base E) of a number (x)',
	'Math.max': 'Returns the number with the highest value of x and y (x, y)',
	'Math.min': 'Returns the number with the lowest value of x and y (x, y)',
	'Math.pow': 'Returns the value of x to the power of y (x, y)',
	'Math.random': 'Returns a random number between 0 and 1 ()',
	'Math.round': 'Rounds a number to the nearest integer (x)',
	'Math.sin': 'Returns the sine of a number (x)',
	'Math.sqrt': 'Returns the square root of a number (x)',
	'Math.tan': 'Returns the tangent of an angle (x)',
	'Math.toSource': 'Represents the source code of an object ()',
	'Math.valueOf': 'Returns the primitive value of a Math object ()',
	'document.close': 'Closes an output stream opened with the document.open() method, and displays the collected data ()',
	'document.createAttribute': 'Creates an attribute node with the specified name, and returns the new Attr object (name)',
	'document.createCDATASection': 'Creates a CDATA section node (data)',
	'document.createComment': 'Creates a comment node (data)',
	'document.createDocumentFragment': 'Creates an empty DocumentFragment object, and returns it ()',
	'document.createElement': 'Creates an element node (name)',
	'document.createTextNode': 'Creates a text node (text)',
	'document.getElementById': 'Returns the element that has an ID attribute with the given value. If no such element exists, it returns null (id)',
	'document.getElementsByTagName': 'Returns a NodeList of all elements with a specified name (tagname)',
	'document.open': 'Opens a stream to collect the output from any document.write() or document.writeln() methods ([mimetype, [replace]])',
	'document.write': 'Writes HTML expressions or JavaScript code to a document (s, ...)',
	'document.writeln': 'Identical to the write() method, with the addition of writing a new line character after each expression (s, ...)',
	'location.assign': 'Loads a new document (url)',
	'location.reload': 'Reloads the current document ()',
	'location.replace': 'Replaces the current document with a new one (url)',
	'window.alert': 'Displays an alert box with a message and an OK button (message)',
	'window.blur': 'Removes focus from the current window ()',
	'window.clearInterval': 'Cancels a timeout set with setInterval() (id)',
	'window.clearTimeout': 'Cancels a timeout set with setTimeout() (id)',
	'window.close': 'Closes the current window ()',
	'window.confirm': 'Displays a dialog box with a message and an OK and a Cancel button (message)',
	'window.focus': 'Sets focus to the current window ()',
	'window.moveBy': 'Moves a window relative to its current position (x, y)',
	'window.moveTo': 'Moves a window to the specified position (x, y)',
	'window.open': 'Opens a new browser window ([url, [name, [specs, [replace]]]])',
	'window.print': 'Prints the contents of the current window ()',
	'window.prompt': 'Displays a dialog box that prompts the user for input (message, default)',
	'window.resizeBy': 'Resizes a window by the specified pixels (width, height)',
	'window.resizeTo': 'Resizes a window to the specified width and height (width, height)',
	'window.scrollBy': 'Scrolls the content by the specified number of pixels (x, y)',
	'window.scrollTo': 'Scrolls the content to the specified coordinates (x, y)',
	'window.setInterval': 'Evaluates an expression at specified intervals (fn, milisec)',
	'window.setTimeout': 'Evaluates an expression after a specified number of milliseconds (fn, milisec)'
};

jush.api.php = {
	apache_child_terminate: 'Terminate apache process after this request (): bool',
	apache_get_modules: 'Get a list of loaded Apache modules (): array',
	apache_get_version: 'Fetch Apache version (): string',
	apache_getenv: 'Get an Apache subprocess_env variable (string variable, [bool walk_to_top]): string',
	apache_lookup_uri: 'Perform a partial request for the specified URI and return all info about it (string filename): object',
	apache_note: 'Get and set apache request notes (string note_name, [string note_value]): string',
	apache_request_headers: 'Fetch all HTTP request headers (): array',
	apache_reset_timeout: 'Reset the Apache write timer (): bool',
	apache_response_headers: 'Fetch all HTTP response headers (): array',
	apache_setenv: 'Set an Apache subprocess_env variable (string variable, string value, [bool walk_to_top]): bool',
	getallheaders: 'Fetch all HTTP request headers (): array',
	virtual: 'Perform an Apache sub-request (string filename): bool',
	apc_add: 'Cache a variable in the data store (string key, mixed var, [int ttl]): bool',
	apc_cache_info: 'Retrieves cached information from APC\'s data store ([string cache_type, [bool limited]]): array',
	apc_clear_cache: 'Clears the APC cache ([string cache_type]): bool',
	apc_compile_file: 'Stores a file in the bytecode cache, bypassing all filters. (string filename): bool',
	apc_define_constants: 'Defines a set of constants for retrieval and mass-definition (string key, array constants, [bool case_sensitive]): bool',
	apc_delete: 'Removes a stored variable from the cache (string key): bool',
	apc_fetch: 'Fetch a stored variable from the cache (mixed key, [bool &success]): mixed',
	apc_load_constants: 'Loads a set of constants from the cache (string key, [bool case_sensitive]): bool',
	apc_sma_info: 'Retrieves APC\'s Shared Memory Allocation information ([bool limited]): array',
	apc_store: 'Cache a variable in the data store (string key, mixed var, [int ttl]): bool',
	apd_breakpoint: 'Stops the interpreter and waits on a CR from the socket (int debug_level): bool',
	apd_callstack: 'Returns the current call stack as an array (): array',
	apd_clunk: 'Throw a warning and a callstack (string warning, [string delimiter]): null',
	apd_continue: 'Restarts the interpreter (int debug_level): bool',
	apd_croak: 'Throw an error, a callstack and then exit (string warning, [string delimiter]): null',
	apd_dump_function_table: 'Outputs the current function table (): null',
	apd_dump_persistent_resources: 'Return all persistent resources as an array (): array',
	apd_dump_regular_resources: 'Return all current regular resources as an array (): array',
	apd_echo: 'Echo to the debugging socket (string output): bool',
	apd_get_active_symbols: 'Get an array of the current variables names in the local scope (): array',
	apd_set_pprof_trace: 'Starts the session debugging ([string dump_directory, [string fragment]]): string',
	apd_set_session_trace_socket: 'Starts the remote session debugging (string tcp_server, int socket_type, int port, int debug_level): bool',
	apd_set_session_trace: 'Starts the session debugging (int debug_level, [string dump_directory]): null',
	apd_set_session: 'Changes or sets the current debugging level (int debug_level): null',
	override_function: 'Overrides built-in functions (string function_name, string function_args, string function_code): bool',
	rename_function: 'Renames orig_name to new_name in the global function table (string original_name, string new_name): bool',
	array_change_key_case: 'Changes all keys in an array (array input, [int case]): array',
	array_chunk: 'Split an array into chunks (array input, int size, [bool preserve_keys]): array',
	array_combine: 'Creates an array by using one array for keys and another for its values (array keys, array values): array',
	array_count_values: 'Counts all the values of an array (array input): array',
	array_diff_assoc: 'Computes the difference of arrays with additional index check (array array1, array array2, [array ...]): array',
	array_diff_key: 'Computes the difference of arrays using keys for comparison (array array1, array array2, [array ...]): array',
	array_diff_uassoc: 'Computes the difference of arrays with additional index check which is performed by a user supplied callback function (array array1, array array2, [array ...], callback key_compare_func): array',
	array_diff_ukey: 'Computes the difference of arrays using a callback function on the keys for comparison (array array1, array array2, [array  ...], callback key_compare_func): array',
	array_diff: 'Computes the difference of arrays (array array1, array array2, [array  ...]): array',
	array_fill_keys: 'Fill an array with values, specifying keys (array keys, mixed value): array',
	array_fill: 'Fill an array with values (int start_index, int num, mixed value): array',
	array_filter: 'Filters elements of an array using a callback function (array input, [callback callback]): array',
	array_flip: 'Exchanges all keys with their associated values in an array (array trans): array',
	array_intersect_assoc: 'Computes the intersection of arrays with additional index check (array array1, array array2, [array  ...]): array',
	array_intersect_key: 'Computes the intersection of arrays using keys for comparison (array array1, array array2, [array  ...]): array',
	array_intersect_uassoc: 'Computes the intersection of arrays with additional index check, compares indexes by a callback function (array array1, array array2, [array  ...], callback key_compare_func): array',
	array_intersect_ukey: 'Computes the intersection of arrays using a callback function on the keys for comparison (array array1, array array2, [array ...], callback key_compare_func): array',
	array_intersect: 'Computes the intersection of arrays (array array1, array array2, [array  ...]): array',
	array_key_exists: 'Checks if the given key or index exists in the array (mixed key, array search): bool',
	array_keys: 'Return all the keys of an array (array input, [mixed search_value, [bool strict]]): array',
	array_map: 'Applies the callback to the elements of the given arrays (callback callback, array arr1, [array ...]): array',
	array_merge_recursive: 'Merge two or more arrays recursively (array array1, [array ...]): array',
	array_merge: 'Merge one or more arrays (array array1, [array array2, [array ...]]): array',
	array_multisort: 'Sort multiple or multi-dimensional arrays (array &arr, [mixed arg, [mixed arg, [mixed ...]]]): bool',
	array_pad: 'Pad array to the specified length with a value (array input, int pad_size, mixed pad_value): array',
	array_pop: 'Pop the element off the end of array (array &array): mixed',
	array_product: 'Calculate the product of values in an array (array array): number',
	array_push: 'Push one or more elements onto the end of array (array &array, mixed var, [mixed ...]): int',
	array_rand: 'Pick one or more random entries out of an array (array input, [int num_req]): mixed',
	array_reduce: 'Iteratively reduce the array to a single value using a callback function (array input, callback function, [mixed initial]): mixed',
	array_replace_recursive: 'Replaces elements from passed arrays into the first array recursively (array &array, array &array1, [array &array2, [array &...]]): array',
	array_replace: 'Replaces elements from passed arrays into the first array (array &array, array &array1, [array &array2, [array &...]]): array',
	array_reverse: 'Return an array with elements in reverse order (array array, [bool preserve_keys]): array',
	array_search: 'Searches the array for a given value and returns the corresponding key if successful (mixed needle, array haystack, [bool strict]): mixed',
	array_shift: 'Shift an element off the beginning of array (array &array): mixed',
	array_slice: 'Extract a slice of the array (array array, int offset, [int length, [bool preserve_keys]]): array',
	array_splice: 'Remove a portion of the array and replace it with something else (array &input, int offset, [int length, [mixed replacement]]): array',
	array_sum: 'Calculate the sum of values in an array (array array): number',
	array_udiff_assoc: 'Computes the difference of arrays with additional index check, compares data by a callback function (array array1, array array2, [array  ...], callback data_compare_func): array',
	array_udiff_uassoc: 'Computes the difference of arrays with additional index check, compares data and indexes by a callback function (array array1, array array2, [array  ...], callback data_compare_func, callback key_compare_func): array',
	array_udiff: 'Computes the difference of arrays by using a callback function for data comparison (array array1, array array2, [array  ...], callback data_compare_func): array',
	array_uintersect_assoc: 'Computes the intersection of arrays with additional index check, compares data by a callback function (array array1, array array2, [array  ...], callback data_compare_func): array',
	array_uintersect_uassoc: 'Computes the intersection of arrays with additional index check, compares data and indexes by a callback functions (array array1, array array2, [array  ...], callback data_compare_func, callback key_compare_func): array',
	array_uintersect: 'Computes the intersection of arrays, compares data by a callback function (array array1, array array2, [array  ...], callback data_compare_func): array',
	array_unique: 'Removes duplicate values from an array (array array, [int sort_flags]): array',
	array_unshift: 'Prepend one or more elements to the beginning of an array (array &array, mixed var, [mixed ...]): int',
	array_values: 'Return all the values of an array (array input): array',
	array_walk_recursive: 'Apply a user function recursively to every member of an array (array &input, callback funcname, [mixed userdata]): bool',
	array_walk: 'Apply a user function to every member of an array (array &array, callback funcname, [mixed userdata]): bool',
	array: 'Create an array ([mixed ...]): array',
	arsort: 'Sort an array in reverse order and maintain index association (array &array, [int sort_flags]): bool',
	asort: 'Sort an array and maintain index association (array &array, [int sort_flags]): bool',
	compact: 'Create array containing variables and their values (mixed varname, [mixed ...]): array',
	count: 'Count all elements in an array, or properties in an object (mixed var, [int mode]): int',
	current: 'Return the current element in an array (array &array): mixed',
	each: 'Return the current key and value pair from an array and advance the array cursor (array &array): array',
	end: 'Set the internal pointer of an array to its last element (array &array): mixed',
	extract: 'Import variables into the current symbol table from an array (array var_array, [int extract_type, [string prefix]]): int',
	in_array: 'Checks if a value exists in an array (mixed needle, array haystack, [bool strict]): bool',
	key: 'Fetch a key from an array (array &array): mixed',
	krsort: 'Sort an array by key in reverse order (array &array, [int sort_flags]): bool',
	ksort: 'Sort an array by key (array &array, [int sort_flags]): bool',
	list: 'Assign variables as if they were an array (mixed varname): array',
	natcasesort: 'Sort an array using a case insensitive "natural order" algorithm (array &array): bool',
	natsort: 'Sort an array using a "natural order" algorithm (array &array): bool',
	next: 'Advance the internal array pointer of an array (array &array): mixed',
	pos: 'Alias of current',
	prev: 'Rewind the internal array pointer (array &array): mixed',
	range: 'Create an array containing a range of elements (mixed low, mixed high, [number step]): array',
	reset: 'Set the internal pointer of an array to its first element (array &array): mixed',
	rsort: 'Sort an array in reverse order (array &array, [int sort_flags]): bool',
	shuffle: 'Shuffle an array (array &array): bool',
	sizeof: 'Alias of count',
	sort: 'Sort an array (array &array, [int sort_flags]): bool',
	uasort: 'Sort an array with a user-defined comparison function and maintain index association (array &array, callback cmp_function): bool',
	uksort: 'Sort an array by keys using a user-defined comparison function (array &array, callback cmp_function): bool',
	usort: 'Sort an array by values using a user-defined comparison function (array &array, callback cmp_function): bool',
	bbcode_add_element: 'Adds a bbcode element (resource bbcode_container, string tag_name, array tag_rules): bool',
	bbcode_add_smiley: 'Adds a smiley to the parser (resource bbcode_container, string smiley, string replace_by): bool',
	bbcode_create: 'Create a BBCode Resource ([array bbcode_initial_tags]): resource',
	bbcode_destroy: 'Close BBCode_container resource (resource bbcode_container): bool',
	bbcode_parse: 'Parse a string following a given rule set (resource bbcode_container, string to_parse): string',
	bbcode_set_arg_parser: 'Attach another parser in order to use another rule set for argument parsing (resource bbcode_container, resource bbcode_arg_parser): bool',
	bbcode_set_flags: 'Set or alter parser options (resource bbcode_container, int flags, [int mode]): bool',
	bcadd: 'Add two arbitrary precision numbers (string left_operand, string right_operand, [int scale]): string',
	bccomp: 'Compare two arbitrary precision numbers (string left_operand, string right_operand, [int scale]): int',
	bcdiv: 'Divide two arbitrary precision numbers (string left_operand, string right_operand, [int scale]): string',
	bcmod: 'Get modulus of an arbitrary precision number (string left_operand, string modulus): string',
	bcmul: 'Multiply two arbitrary precision number (string left_operand, string right_operand, [int scale]): string',
	bcpow: 'Raise an arbitrary precision number to another (string left_operand, string right_operand, [int scale]): string',
	bcpowmod: 'Raise an arbitrary precision number to another, reduced by a specified modulus (string left_operand, string right_operand, string modulus, [int scale]): string',
	bcscale: 'Set default scale parameter for all bc math functions (int scale): bool',
	bcsqrt: 'Get the square root of an arbitrary precision number (string operand, [int scale]): string',
	bcsub: 'Subtract one arbitrary precision number from another (string left_operand, string right_operand, [int scale]): string',
	bcompiler_load_exe: 'Reads and creates classes from a bcompiler exe file (string filename): bool',
	bcompiler_load: 'Reads and creates classes from a bz compressed file (string filename): bool',
	bcompiler_parse_class: 'Reads the bytecodes of a class and calls back to a user function (string class, string callback): bool',
	bcompiler_read: 'Reads and creates classes from a filehandle (resource filehandle): bool',
	bcompiler_write_class: 'Writes an defined class as bytecodes (resource filehandle, string className, [string extends]): bool',
	bcompiler_write_constant: 'Writes a defined constant as bytecodes (resource filehandle, string constantName): bool',
	bcompiler_write_exe_footer: 'Writes the start pos, and sig to the end of a exe type file (resource filehandle, int startpos): bool',
	bcompiler_write_file: 'Writes a php source file as bytecodes (resource filehandle, string filename): bool',
	bcompiler_write_footer: 'Writes the single character \\x00 to indicate End of compiled data (resource filehandle): bool',
	bcompiler_write_function: 'Writes an defined function as bytecodes (resource filehandle, string functionName): bool',
	bcompiler_write_functions_from_file: 'Writes all functions defined in a file as bytecodes (resource filehandle, string fileName): bool',
	bcompiler_write_header: 'Writes the bcompiler header (resource filehandle, [string write_ver]): bool',
	bcompiler_write_included_filename: 'Writes an included file as bytecodes (resource filehandle, string filename): bool',
	bzclose: 'Close a bzip2 file (resource bz): int',
	bzcompress: 'Compress a string into bzip2 encoded data (string source, [int blocksize, [int workfactor]]): mixed',
	bzdecompress: 'Decompresses bzip2 encoded data (string source, [int small]): mixed',
	bzerrno: 'Returns a bzip2 error number (resource bz): int',
	bzerror: 'Returns the bzip2 error number and error string in an array (resource bz): array',
	bzerrstr: 'Returns a bzip2 error string (resource bz): string',
	bzflush: 'Force a write of all buffered data (resource bz): int',
	bzopen: 'Opens a bzip2 compressed file (string filename, string mode): resource',
	bzread: 'Binary safe bzip2 file read (resource bz, [int length]): string',
	bzwrite: 'Binary safe bzip2 file write (resource bz, string data, [int length]): int',
	cairo_available_fonts: 'Retrieves the availables font types (): array',
	cairo_available_surfaces: 'Retrieves all available surfaces (): array',
	cairo_status_to_string: 'Retrieves the current status as string (int status): string',
	cairo_version: 'Retrives cairo\'s library version (): int',
	cairo_version_string: 'Retrieves cairo version as string (): string',
	cairo_append_path: 'Appends a path to current path (CairoContext context, CairoPath path): null',
	cairo_arc: 'Adds a circular arc (CairoContext context, float x, float y, float radius, float angle1, float angle2): null',
	cairo_arc_negative: 'Adds a negative arc (CairoContext context, float x, float y, float radius, float angle1, float angle2): null',
	cairo_clip: 'Establishes a new clip region (CairoContext context): null',
	cairo_clip_extents: 'Computes the area inside the current clip (CairoContext context): array',
	cairo_clip_preserve: 'Establishes a new clip region from the current clip (CairoContext context): null',
	cairo_clip_rectangle_list: 'Retrieves the current clip as a list of rectangles (CairoContext context): array',
	cairo_close_path: 'Closes the current path (CairoContext context): null',
	cairo_copy_page: 'Emits the current page (CairoContext context): null',
	cairo_copy_path: 'Creates a copy of the current path (CairoContext context): CairoPath',
	cairo_copy_path_flat: 'Gets a flattened copy of the current path (CairoContext context): CairoPath',
	cairo_curve_to: 'Adds a curve (CairoContext context, float x1, float y1, float x2, float y2, float x3, float y3): null',
	cairo_device_to_user: 'Transform a coordinate (CairoContext context, float x, float y): array',
	cairo_device_to_user_distance: 'Transform a distance (CairoContext context, float x, float y): array',
	cairo_fill: 'Fills the current path (CairoContext context): null',
	cairo_fill_extents: 'Computes the filled area (CairoContext context): array',
	cairo_fill_preserve: 'Fills and preserve the current path (CairoContext context): null',
	cairo_font_extents: 'Get the font extents (CairoContext context): array',
	cairo_get_antialias: 'Retrives the current antialias mode (CairoContext context): int',
	cairo_get_current_point: 'The getCurrentPoint purpose (CairoContext context): array',
	cairo_get_dash: 'The getDash purpose (CairoContext context): array',
	cairo_get_dash_count: 'The getDashCount purpose (CairoContext context): int',
	cairo_get_fill_rule: 'The getFillRule purpose (CairoContext context): int',
	cairo_get_font_face: 'The getFontFace purpose (CairoContext context): null',
	cairo_get_font_matrix: 'The getFontMatrix purpose (CairoContext context): null',
	cairo_get_font_options: 'The getFontOptions purpose (CairoContext context): null',
	cairo_get_group_target: 'The getGroupTarget purpose (CairoContext context): null',
	cairo_get_line_cap: 'The getLineCap purpose (CairoContext context): int',
	cairo_get_line_join: 'The getLineJoin purpose (CairoContext context): int',
	cairo_get_line_width: 'The getLineWidth purpose (CairoContext context): float',
	cairo_get_matrix: 'The getMatrix purpose (CairoContext context): null',
	cairo_get_miter_limit: 'The getMiterLimit purpose (CairoContext context): float',
	cairo_get_operator: 'The getOperator purpose (CairoContext context): int',
	cairo_get_scaled_font: 'The getScaledFont purpose (CairoContext context): null',
	cairo_get_source: 'The getSource purpose (CairoContext context): null',
	cairo_get_target: 'The getTarget purpose (CairoContext context): null',
	cairo_get_tolerance: 'The getTolerance purpose (CairoContext context): float',
	cairo_glyph_path: 'The glyphPath purpose (CairoContext context, array glyphs): null',
	cairo_has_current_point: 'The hasCurrentPoint purpose (CairoContext context): bool',
	cairo_identity_matrix: 'The identityMatrix purpose (CairoContext context): null',
	cairo_in_fill: 'The inFill purpose (CairoContext context, string x, string y): bool',
	cairo_in_stroke: 'The inStroke purpose (CairoContext context, string x, string y): bool',
	cairo_line_to: 'The lineTo purpose (CairoContext context, string x, string y): null',
	cairo_mask: 'The mask purpose (CairoContext context, CairoPattern pattern): null',
	cairo_mask_surface: 'The maskSurface purpose (CairoContext context, CairoSurface surface, [string x, [string y]]): null',
	cairo_move_to: 'The moveTo purpose (CairoContext context, string x, string y): null',
	cairo_new_path: 'The newPath purpose (CairoContext context): null',
	cairo_new_sub_path: 'The newSubPath purpose (CairoContext context): null',
	cairo_paint: 'The paint purpose (CairoContext context): null',
	cairo_paint_with_alpha: 'The paintWithAlpha purpose (CairoContext context, string alpha): null',
	cairo_path_extents: 'The pathExtents purpose (CairoContext context): array',
	cairo_pop_group: 'The popGroup purpose (CairoContext context): null',
	cairo_pop_group_to_source: 'The popGroupToSource purpose (CairoContext context): null',
	cairo_push_group: 'The pushGroup purpose (CairoContext context): null',
	cairo_push_group_with_content: 'The pushGroupWithContent purpose (CairoContext context, string content): null',
	cairo_rectangle: 'The rectangle purpose (CairoContext context, string x, string y, string width, string height): null',
	cairo_rel_curve_to: 'The relCurveTo purpose (CairoContext context, string x1, string y1, string x2, string y2, string x3, string y3): null',
	cairo_rel_line_to: 'The relLineTo purpose (CairoContext context, string x, string y): null',
	cairo_rel_move_to: 'The relMoveTo purpose (CairoContext context, string x, string y): null',
	cairo_reset_clip: 'The resetClip purpose (CairoContext context): null',
	cairo_restore: 'The restore purpose (CairoContext context): null',
	cairo_rotate: 'The rotate purpose (CairoContext context, string angle): null',
	cairo_save: 'The save purpose (CairoContext context): null',
	cairo_scale: 'The scale purpose (CairoContext context, string x, string y): null',
	cairo_select_font_face: 'The selectFontFace purpose (CairoContext context, string family, [string slant, [string weight]]): null',
	cairo_set_antialias: 'The setAntialias purpose (CairoContext context, [string antialias]): null',
	cairo_set_dash: 'The setDash purpose (CairoContext context, array dashes, [string offset]): null',
	cairo_set_fill_rule: 'The setFillRule purpose (CairoContext context, string setting): null',
	cairo_set_font_face: 'The setFontFace purpose (CairoContext context, CairoFontFace fontface): null',
	cairo_set_font_matrix: 'The setFontMatrix purpose (CairoContext context, CairoMatrix matrix): null',
	cairo_set_font_options: 'The setFontOptions purpose (CairoContext context, CairoFontOptions fontoptions): null',
	cairo_set_font_size: 'The setFontSize purpose (CairoContext context, string size): null',
	cairo_set_line_cap: 'The setLineCap purpose (CairoContext context, string setting): null',
	cairo_set_line_join: 'The setLineJoin purpose (CairoContext context, string setting): null',
	cairo_set_line_width: 'The setLineWidth purpose (CairoContext context, string width): null',
	cairo_set_matrix: 'The setMatrix purpose (CairoContext context, CairoMatrix matrix): null',
	cairo_set_miter_limit: 'The setMiterLimit purpose (CairoContext context, string limit): null',
	cairo_set_operator: 'The setOperator purpose (CairoContext context, string setting): null',
	cairo_set_scaled_font: 'The setScaledFont purpose (CairoContext context, CairoScaledFont scaledfont): null',
	cairo_set_source: 'The setSource purpose (CairoContext context, CairoPattern pattern): null',
	cairo_set_source: 'The setSourceRGB purpose (CairoContext context, CairoPattern pattern): null',
	cairo_set_source: 'The setSourceRGBA purpose (CairoContext context, CairoPattern pattern): null',
	cairo_set_source_surface: 'The setSourceSurface purpose (CairoContext context, CairoSurface surface, [string x, [string y]]): null',
	cairo_set_tolerance: 'The setTolerance purpose (CairoContext context, string tolerance): null',
	cairo_show_page: 'The showPage purpose (CairoContext context): null',
	cairo_show_text: 'The showText purpose (CairoContext context, string text): null',
	cairo_status: 'The status purpose (CairoContext context): int',
	cairo_stroke: 'The stroke purpose (CairoContext context): null',
	cairo_stroke_extents: 'The strokeExtents purpose (CairoContext context): array',
	cairo_stroke_preserve: 'The strokePreserve purpose (CairoContext context): null',
	cairo_text_extents: 'The textExtents purpose (CairoContext context): array',
	cairo_text_path: 'The textPath purpose (CairoContext context, string text): null',
	cairo_transform: 'The transform purpose (CairoContext context, CairoMatrix matrix): null',
	cairo_translate: 'The translate purpose (CairoContext context, string x, string y): null',
	cairo_user_to_device: 'The userToDevice purpose (CairoContext context, string x, string y): array',
	cairo_user_to_device_distance: 'The userToDeviceDistance purpose (CairoContext context, string x, string y): array',
	cairo_font_face_status: 'Check for CairoFontFace errors (CairoFontFace fontface): int',
	cairo_get_antialias: 'The getAntialias purpose (CairoContext context): int',
	cairo_set_antialias: 'The setAntialias purpose (CairoContext context, [string antialias]): null',
	cairo_status: 'The status purpose (CairoContext context): int',
	cairo_matrix_init: 'Creates a new CairoMatrix object ([float xx, [float yx, [float xy, [float yy, [float x0, [float y0]]]]]]): object',
	cairo_matrix_init_identity: 'Creates a new identity matrix (): object',
	cairo_matrix_init_rotate: 'Creates a new rotated matrix (float radians): object',
	cairo_matrix_init_scale: 'Creates a new scaling matrix (float sx, float sy): object',
	cairo_matrix_init_translate: 'Creates a new translation matrix (float tx, float ty): object',
	cairo_rotate: 'The rotate purpose (CairoContext context, string angle): null',
	cairo_matrix_scale: 'Applies scaling to a matrix (CairoContext context, float sx, float sy): null',
	cairo_translate: 'The translate purpose (CairoContext context, string x, string y): null',
	cairo_get_matrix: 'The getMatrix purpose (CairoContext context): null',
	cairo_set_matrix: 'The setMatrix purpose (CairoContext context, CairoMatrix matrix): null',
	cairo_status: 'The status purpose (CairoContext context): int',
	cairo_get_font_face: 'The getFontFace purpose (CairoContext context): null',
	cairo_get_font_matrix: 'The getFontMatrix purpose (CairoContext context): null',
	cairo_get_font_options: 'The getFontOptions purpose (CairoContext context): null',
	cairo_status: 'The status purpose (CairoContext context): int',
	cairo_text_extents: 'The textExtents purpose (CairoContext context): array',
	cairo_copy_page: 'The copyPage purpose (CairoContext context): null',
	cairo_get_font_options: 'The getFontOptions purpose (CairoContext context): null',
	cairo_show_page: 'The showPage purpose (CairoContext context): null',
	cairo_status: 'The status purpose (CairoContext context): int',
	cairo_svg_get_versions: 'Used to retrieve a list of supported SVG versions (): array',
	cairo_create: 'Returns a new CairoContext object on the requested surface. (CairoSurface surface): CairoContext',
	cairo_font_face_get_type: 'Description (CairoFontFace fontface): int',
	cairo_font_face_status: 'Description (CairoFontFace fontface): int',
	cairo_font_options_create: 'Description (): CairoFontOptions',
	cairo_font_options_equal: 'Description (CairoFontOptions options, CairoFontOptions other): bool',
	cairo_font_options_get_antialias: 'Description (CairoFontOptions options): int',
	cairo_font_options_get_hint_metrics: 'Description (CairoFontOptions options): int',
	cairo_font_options_get_hint_style: 'Description (CairoFontOptions options): int',
	cairo_font_options_get_subpixel_order: 'Description (CairoFontOptions options): int',
	cairo_font_options_hash: 'Description (CairoFontOptions options): int',
	cairo_font_options_merge: 'Description (CairoFontOptions options, CairoFontOptions other): null',
	cairo_font_options_set_antialias: 'Description (CairoFontOptions options, string antialias): null',
	cairo_font_options_set_hint_metrics: 'Description (CairoFontOptions options, string hint_metrics): null',
	cairo_font_options_set_hint_style: 'Description (CairoFontOptions options, string hint_style): null',
	cairo_font_options_set_subpixel_order: 'Description (CairoFontOptions options, string subpixel_order): null',
	cairo_font_options_status: 'Description (CairoFontOptions options): int',
	cairo_format_stride_for_width: 'Description (int format, int width): int',
	cairo_image_surface_create_for_data: 'Description (string data, int format, int width, int height, [int stride]): CairoImageSurface',
	cairo_image_surface_create_from_png: 'Description (string file): CairoImageSurface',
	cairo_image_surface_create: 'Description (int format, int width, int height): CairoImageSurface',
	cairo_image_surface_get_data: 'Description (CairoImageSurface surface): string',
	cairo_image_surface_get_format: 'Description (CairoImageSurface surface): int',
	cairo_image_surface_get_height: 'Description (CairoImageSurface surface): int',
	cairo_image_surface_get_stride: 'Description (CairoImageSurface surface): int',
	cairo_image_surface_get_width: 'Description (CairoImageSurface surface): int',
	cairo_matrix_create_scale: 'Alias of CairoMatrix::initScale',
	cairo_matrix_create_translate: 'Alias of CairoMatrix::initTranslate',
	cairo_matrix_invert: 'Description (CairoMatrix matrix): null',
	cairo_matrix_multiply: 'Description (CairoMatrix matrix1, CairoMatrix matrix2): CairoMatrix',
	cairo_matrix_rotate: 'Description (CairoMatrix matrix, string radians): null',
	cairo_matrix_transform_distance: 'Description (CairoMatrix matrix, string dx, string dy): array',
	cairo_matrix_transform_point: 'Description (CairoMatrix matrix, string dx, string dy): array',
	cairo_matrix_translate: 'Description (CairoMatrix matrix, string tx, string ty): null',
	cairo_pattern_add_color_stop_rgb: 'Description (CairoGradientPattern pattern, string offset, string red, string green, string blue): null',
	cairo_pattern_add_color_stop_rgba: 'Description (CairoGradientPattern pattern, string offset, string red, string green, string blue, string alpha): null',
	cairo_pattern_create_for_surface: 'Description (CairoSurface surface): CairoPattern',
	cairo_pattern_create_linear: 'Description (float x0, float y0, float x1, float y1): CairoPattern',
	cairo_pattern_create_radial: 'Description (float x0, float y0, float r0, float x1, float y1, float r1): CairoPattern',
	cairo_pattern_create_rgb: 'Description (float red, float green, float blue): CairoPattern',
	cairo_pattern_create_rgba: 'Description (float red, float green, float blue, float alpha): CairoPattern',
	cairo_pattern_get_color_stop_count: 'Description (CairoGradientPattern pattern): int',
	cairo_pattern_get_color_stop_rgba: 'Description (CairoGradientPattern pattern, string index): array',
	cairo_pattern_get_extend: 'Description (string pattern): int',
	cairo_pattern_get_filter: 'Description (CairoSurfacePattern pattern): int',
	cairo_pattern_get_linear_points: 'Description (CairoLinearGradient pattern): array',
	cairo_pattern_get_matrix: 'Description (CairoPattern pattern): CairoMatrix',
	cairo_pattern_get_radial_circles: 'Description (CairoRadialGradient pattern): array',
	cairo_pattern_get_rgba: 'Description (CairoSolidPattern pattern): array',
	cairo_pattern_get_surface: 'Description (CairoSurfacePattern pattern): CairoSurface',
	cairo_pattern_get_type: 'Description (CairoPattern pattern): int',
	cairo_pattern_set_extend: 'Description (string pattern, string extend): null',
	cairo_pattern_set_filter: 'Description (CairoSurfacePattern pattern, [string filter]): null',
	cairo_pattern_set_matrix: 'Description (CairoPattern pattern, [CairoMatrix matrix]): null',
	cairo_pattern_status: 'Description (CairoPattern pattern): int',
	cairo_pdf_surface_create: 'Description (string file, float width, float height): CairoPdfSurface',
	cairo_pdf_surface_set_size: 'Description (CairoPdfSurface surface, string width, string height): null',
	cairo_ps_get_levels: 'Description (): array',
	cairo_ps_level_to_string: 'Description (string level): string',
	cairo_ps_surface_create: 'Description (string file, float width, float height): CairoPsSurface',
	cairo_ps_surface_dsc_begin_page_setup: 'Description (CairoPsSurface surface): null',
	cairo_ps_surface_dsc_begin_setup: 'Description (CairoPsSurface surface): null',
	cairo_ps_surface_dsc_comment: 'Description (CairoPsSurface surface, string comment): null',
	cairo_ps_surface_get_eps: 'Description (CairoPsSurface surface): bool',
	cairo_ps_surface_restrict_to_level: 'Description (CairoPsSurface surface, string level): null',
	cairo_ps_surface_set_eps: 'Description (CairoPsSurface surface, string level): null',
	cairo_ps_surface_set_size: 'Description (CairoPsSurface surface, string width, string height): null',
	cairo_scaled_font_create: 'Description (CairoFontFace fontface, CairoMatrix matrix, CairoMatrix ctm, CairoFontOptions fontoptions): CairoScaledFont',
	cairo_scaled_font_extents: 'Description (CairoScaledFont scaledfont): array',
	cairo_scaled_font_get_ctm: 'Description (CairoScaledFont scaledfont): CairoMatrix',
	cairo_scaled_font_get_font_face: 'Description (CairoScaledFont scaledfont): CairoFontFace',
	cairo_scaled_font_get_font_matrix: 'Description (CairoScaledFont scaledfont): CairoFontOptions',
	cairo_scaled_font_get_font_options: 'Description (CairoScaledFont scaledfont): CairoFontOptions',
	cairo_scaled_font_get_scale_matrix: 'Description (CairoScaledFont scaledfont): CairoMatrix',
	cairo_scaled_font_get_type: 'Description (CairoScaledFont scaledfont): int',
	cairo_scaled_font_glyph_extents: 'Description (CairoScaledFont scaledfont, string glyphs): array',
	cairo_scaled_font_status: 'Description (CairoScaledFont scaledfont): int',
	cairo_scaled_font_text_extents: 'Description (CairoScaledFont scaledfont, string text): array',
	cairo_surface_copy_page: 'Description (CairoSurface surface): null',
	cairo_surface_create_similar: 'Description (CairoSurface surface, string content, string width, string height): CairoSurface',
	cairo_surface_finish: 'Description (CairoSurface surface): null',
	cairo_surface_flush: 'Description (CairoSurface surface): null',
	cairo_surface_get_content: 'Description (CairoSurface surface): int',
	cairo_surface_get_device_offset: 'Description (CairoSurface surface): array',
	cairo_surface_get_font_options: 'Description (CairoSurface surface): CairoFontOptions',
	cairo_surface_get_type: 'Description (CairoSurface surface): int',
	cairo_surface_mark_dirty_rectangle: 'Description (CairoSurface surface, string x, string y, string width, string height): null',
	cairo_surface_mark_dirty: 'Description (CairoSurface surface): null',
	cairo_surface_set_device_offset: 'Description (CairoSurface surface, string x, string y): null',
	cairo_surface_set_fallback_resolution: 'Description (CairoSurface surface, string x, string y): null',
	cairo_surface_show_page: 'Description (CairoSurface surface): null',
	cairo_surface_status: 'Description (CairoSurface surface): int',
	cairo_surface_write_to_png: 'Description (CairoSurface surface, string x, string y): null',
	cairo_svg_surface_create: 'Description (string file, float width, float height): CairoSvgSurface',
	cairo_svg_surface_restrict_to_version: 'Description (CairoSvgSurface surface, string version): null',
	cairo_svg_version_to_string: 'Description (int version): string',
	cal_days_in_month: 'Return the number of days in a month for a given year and calendar (int calendar, int month, int year): int',
	cal_from_jd: 'Converts from Julian Day Count to a supported calendar (int jd, int calendar): array',
	cal_info: 'Returns information about a particular calendar ([int calendar]): array',
	cal_to_jd: 'Converts from a supported calendar to Julian Day Count (int calendar, int month, int day, int year): int',
	easter_date: 'Get Unix timestamp for midnight on Easter of a given year ([int year]): int',
	easter_days: 'Get number of days after March 21 on which Easter falls for a given year ([int year, [int method]]): int',
	frenchtojd: 'Converts a date from the French Republican Calendar to a Julian Day Count (int month, int day, int year): int',
	gregoriantojd: 'Converts a Gregorian date to Julian Day Count (int month, int day, int year): int',
	jddayofweek: 'Returns the day of the week (int julianday, [int mode]): mixed',
	jdmonthname: 'Returns a month name (int julianday, int mode): string',
	jdtofrench: 'Converts a Julian Day Count to the French Republican Calendar (int juliandaycount): string',
	jdtogregorian: 'Converts Julian Day Count to Gregorian date (int julianday): string',
	jdtojewish: 'Converts a Julian day count to a Jewish calendar date (int juliandaycount, [bool hebrew, [int fl]]): string',
	jdtojulian: 'Converts a Julian Day Count to a Julian Calendar Date (int julianday): string',
	jdtounix: 'Convert Julian Day to Unix timestamp (int jday): int',
	jewishtojd: 'Converts a date in the Jewish Calendar to Julian Day Count (int month, int day, int year): int',
	juliantojd: 'Converts a Julian Calendar date to Julian Day Count (int month, int day, int year): int',
	unixtojd: 'Convert Unix timestamp to Julian Day ([int timestamp]): int',
	classkit_import: 'Import new class method definitions from a file (string filename): array',
	classkit_method_add: 'Dynamically adds a new method to a given class (string classname, string methodname, string args, string code, [int flags]): bool',
	classkit_method_copy: 'Copies a method from class to another (string dClass, string dMethod, string sClass, [string sMethod]): bool',
	classkit_method_redefine: 'Dynamically changes the code of the given method (string classname, string methodname, string args, string code, [int flags]): bool',
	classkit_method_remove: 'Dynamically removes the given method (string classname, string methodname): bool',
	classkit_method_rename: 'Dynamically changes the name of the given method (string classname, string methodname, string newname): bool',
	call_user_method_array: 'Call a user method given with an array of parameters [deprecated] (string method_name, object &obj, array params): mixed',
	call_user_method: 'Call a user method on an specific object [deprecated] (string method_name, object &obj, [mixed parameter, [mixed ...]]): mixed',
	class_alias: 'Creates an alias for a class ([string original, [string alias]]): boolean',
	class_exists: 'Checks if the class has been defined (string class_name, [bool autoload]): bool',
	get_called_class: 'the "Late Static Binding" class name (): string',
	get_class_methods: 'Gets the class methods\' names (mixed class_name): array',
	get_class_vars: 'Get the default properties of the class (string class_name): array',
	get_class: 'Returns the name of the class of an object ([object object]): string',
	get_declared_classes: 'Returns an array with the name of the defined classes (): array',
	get_declared_interfaces: 'Returns an array of all declared interfaces (): array',
	get_object_vars: 'Gets the properties of the given object (object object): array',
	get_parent_class: 'Retrieves the parent class name for object or class ([mixed object]): string',
	interface_exists: 'Checks if the interface has been defined (string interface_name, [bool autoload]): bool',
	is_a: 'Checks if the object is of this class or has this class as one of its parents (object object, string class_name): bool',
	is_subclass_of: 'Checks if the object has this class as one of its parents (mixed object, string class_name): bool',
	method_exists: 'Checks if the class method exists (mixed object, string method_name): bool',
	property_exists: 'Checks if the object or class has a property (mixed class, string property): bool',
	com_addref: 'Increases the components reference counter [deprecated] (): null',
	com_create_guid: 'Generate a globally unique identifier (GUID) (): string',
	com_event_sink: 'Connect events from a COM object to a PHP object (variant comobject, object sinkobject, [mixed sinkinterface]): bool',
	com_get_active_object: 'Returns a handle to an already running instance of a COM object (string progid, [int code_page]): variant',
	com_get: 'Gets the value of a COM Component\'s property [deprecated]',
	com_isenum: 'Indicates if a COM object has an IEnumVariant interface for iteration [deprecated] (variant com_module): bool',
	com_load_typelib: 'Loads a Typelib (string typelib_name, [bool case_insensitive]): bool',
	com_load: 'Creates a new reference to a COM component [deprecated]',
	com_message_pump: 'Process COM messages, sleeping for up to timeoutms milliseconds ([int timeoutms]): bool',
	com_print_typeinfo: 'Print out a PHP class definition for a dispatchable interface (object comobject, [string dispinterface, [bool wantsink]]): bool',
	com_propget: 'Alias of com_get',
	com_propput: 'Alias of com_set',
	com_propset: 'Alias of com_set',
	com_release: 'Decreases the components reference counter [deprecated] (): null',
	com_set: 'Assigns a value to a COM component\'s property',
	variant_abs: 'Returns the absolute value of a variant (mixed val): mixed',
	variant_add: '"Adds" two variant values together and returns the result (mixed left, mixed right): mixed',
	variant_and: 'Performs a bitwise AND operation between two variants (mixed left, mixed right): mixed',
	variant_cast: 'Convert a variant into a new variant object of another type (variant variant, int type): variant',
	variant_cat: 'concatenates two variant values together and returns the result (mixed left, mixed right): mixed',
	variant_cmp: 'Compares two variants (mixed left, mixed right, [int lcid, [int flags]]): int',
	variant_date_from_timestamp: 'Returns a variant date representation of a Unix timestamp (int timestamp): variant',
	variant_date_to_timestamp: 'Converts a variant date/time value to Unix timestamp (variant variant): int',
	variant_div: 'Returns the result from dividing two variants (mixed left, mixed right): mixed',
	variant_eqv: 'Performs a bitwise equivalence on two variants (mixed left, mixed right): mixed',
	variant_fix: 'Returns the integer portion of a variant (mixed variant): mixed',
	variant_get_type: 'Returns the type of a variant object (variant variant): int',
	variant_idiv: 'Converts variants to integers and then returns the result from dividing them (mixed left, mixed right): mixed',
	variant_imp: 'Performs a bitwise implication on two variants (mixed left, mixed right): mixed',
	variant_int: 'Returns the integer portion of a variant (mixed variant): mixed',
	variant_mod: 'Divides two variants and returns only the remainder (mixed left, mixed right): mixed',
	variant_mul: 'Multiplies the values of the two variants (mixed left, mixed right): mixed',
	variant_neg: 'Performs logical negation on a variant (mixed variant): mixed',
	variant_not: 'Performs bitwise not negation on a variant (mixed variant): mixed',
	variant_or: 'Performs a logical disjunction on two variants (mixed left, mixed right): mixed',
	variant_pow: 'Returns the result of performing the power function with two variants (mixed left, mixed right): mixed',
	variant_round: 'Rounds a variant to the specified number of decimal places (mixed variant, int decimals): mixed',
	variant_set_type: 'Convert a variant into another type "in-place" (variant variant, int type): null',
	variant_set: 'Assigns a new value for a variant object (variant variant, mixed value): null',
	variant_sub: 'Subtracts the value of the right variant from the left variant value (mixed left, mixed right): mixed',
	variant_xor: 'Performs a logical exclusion on two variants (mixed left, mixed right): mixed',
	crack_check: 'Performs an obscure check with the given password (resource dictionary, string password): bool',
	crack_check: 'Performs an obscure check with the given password (string password): bool',
	crack_closedict: 'Closes an open CrackLib dictionary ([resource dictionary]): bool',
	crack_getlastmessage: 'Returns the message from the last obscure check (): string',
	crack_opendict: 'Opens a new CrackLib dictionary (string dictionary): resource',
	ctype_alnum: 'Check for alphanumeric character(s) (string text): bool',
	ctype_alpha: 'Check for alphabetic character(s) (string text): bool',
	ctype_cntrl: 'Check for control character(s) (string text): bool',
	ctype_digit: 'Check for numeric character(s) (string text): bool',
	ctype_graph: 'Check for any printable character(s) except space (string text): bool',
	ctype_lower: 'Check for lowercase character(s) (string text): bool',
	ctype_print: 'Check for printable character(s) (string text): bool',
	ctype_punct: 'Check for any printable character which is not whitespace or an alphanumeric character (string text): bool',
	ctype_space: 'Check for whitespace character(s) (string text): bool',
	ctype_upper: 'Check for uppercase character(s) (string text): bool',
	ctype_xdigit: 'Check for character(s) representing a hexadecimal digit (string text): bool',
	curl_close: 'Close a cURL session (resource ch): null',
	curl_copy_handle: 'Copy a cURL handle along with all of its preferences (resource ch): resource',
	curl_errno: 'Return the last error number (resource ch): int',
	curl_error: 'Return a string containing the last error for the current session (resource ch): string',
	curl_exec: 'Perform a cURL session (resource ch): mixed',
	curl_getinfo: 'Get information regarding a specific transfer (resource ch, [int opt]): mixed',
	curl_init: 'Initialize a cURL session ([string url]): resource',
	curl_multi_add_handle: 'Add a normal cURL handle to a cURL multi handle (resource mh, resource ch): int',
	curl_multi_close: 'Close a set of cURL handles (resource mh): null',
	curl_multi_exec: 'Run the sub-connections of the current cURL handle (resource mh, int &still_running): int',
	curl_multi_getcontent: 'Return the content of a cURL handle if CURLOPT_RETURNTRANSFER is set (resource ch): string',
	curl_multi_info_read: 'Get information about the current transfers (resource mh, [int &msgs_in_queue]): array',
	curl_multi_init: 'Returns a new cURL multi handle (): resource',
	curl_multi_remove_handle: 'Remove a multi handle from a set of cURL handles (resource mh, resource ch): int',
	curl_multi_select: 'Wait for activity on any curl_multi connection (resource mh, [float timeout]): int',
	curl_setopt_array: 'Set multiple options for a cURL transfer (resource ch, array options): bool',
	curl_setopt: 'Set an option for a cURL transfer (resource ch, int option, mixed value): bool',
	curl_version: 'Gets cURL version information ([int age]): array',
	cyrus_authenticate: 'Authenticate against a Cyrus IMAP server (resource connection, [string mechlist, [string service, [string user, [int minssf, [int maxssf, [string authname, [string password]]]]]]]): null',
	cyrus_bind: 'Bind callbacks to a Cyrus IMAP connection (resource connection, array callbacks): bool',
	cyrus_close: 'Close connection to a Cyrus IMAP server (resource connection): bool',
	cyrus_connect: 'Connect to a Cyrus IMAP server ([string host, [string port, [int flags]]]): resource',
	cyrus_query: 'Send a query to a Cyrus IMAP server (resource connection, string query): array',
	cyrus_unbind: 'Unbind ... (resource connection, string trigger_name): bool',
	date_add: 'Adds an amount of days, months, years, hours, minutes and seconds to a DateTime object (DateTime &object, DateInterval interval): DateTime',
	date_create: 'Returns new DateTime object ([string time, [DateTimeZone timezone]]): DateTime',
	date_create_from_format: 'Returns new DateTime object formatted according to the specified format (string format, string time, [DateTimeZone timezone]): DateTime',
	date_diff: 'Returns the difference between two DateTime objects (DateTime datetime1, DateTime datetime2, [bool absolute]): DateInterval',
	date_format: 'Returns date formatted according to given format (DateTime object, string format): string',
	date_get_last_errors: 'Returns the warnings and errors (): array',
	date_offset_get: 'Returns the timezone offset (DateTime object): int',
	date_timestamp_get: 'Gets the Unix timestamp (DateTime object): int',
	date_timezone_get: 'Return time zone relative to given DateTime (DateTime object): DateTimeZone',
	date_modify: 'Alters the timestamp (DateTime &object, string modify): DateTime',
	date_date_set: 'Sets the date (DateTime &object, int year, int month, int day): DateTime',
	date_isodate_set: 'Sets the ISO date (DateTime &object, int year, int week, [int day]): DateTime',
	date_time_set: 'Sets the time (DateTime &object, int hour, int minute, [int second]): DateTime',
	date_timestamp_set: 'Sets the date and time based on an Unix timestamp (DateTime &object, int unixtimestamp): DateTime',
	date_timezone_set: 'Sets the time zone for the DateTime object (DateTime &object, DateTimeZone timezone): DateTime',
	date_sub: 'Subtracts an amount of days, months, years, hours, minutes and seconds from a DateTime object (DateTime &object, DateInterval interval): DateTime',
	timezone_open: 'Creates new DateTimeZone object (string timezone): DateTimeZone',
	timezone_offset_get: 'Returns the timezone offset from GMT (DateTimeZone object, DateTime datetime): int',
	timezone_transitions_get: 'Returns all transitions for the timezone (DateTimeZone object, [int timestamp_begin, [int timestamp_end]]): array',
	timezone_abbreviations_list: 'Returns associative array containing dst, offset and the timezone name (): array',
	timezone_identifiers_list: 'Returns numerically index array with all timezone identifiers ([int what, [string country]]): array',
	checkdate: 'Validate a Gregorian date (int month, int day, int year): bool',
	date_add: 'Alias of DateTime::add',
	date_create_from_format: 'Alias of DateTime::createFromFormat',
	date_create: 'Alias of DateTime::__construct',
	date_date_set: 'Alias of DateTime::setDate',
	date_default_timezone_get: 'Gets the default timezone used by all date/time functions in a script (): string',
	date_default_timezone_set: 'Sets the default timezone used by all date/time functions in a script (string timezone_identifier): bool',
	date_diff: 'Alias of DateTime::diff',
	date_format: 'Alias of DateTime::format',
	date_get_last_errors: 'Alias of DateTime::getLastErrors',
	date_interval_create_from_date_string: 'Alias of DateInterval::createFromDateString',
	date_interval_format: 'Alias of DateInterval::format',
	date_isodate_set: 'Alias of DateTime::setISODate',
	date_modify: 'Alias of DateTime::modify',
	date_offset_get: 'Alias of DateTime::getOffset',
	date_parse_from_format: 'Get info about given date (string format, string date): array',
	date_parse: 'Returns associative array with detailed info about given date (string date): array',
	date_sub: 'Alias of DateTime::sub',
	date_sun_info: 'Returns an array with information about sunset/sunrise and twilight begin/end (int time, float latitude, float longitude): array',
	date_sunrise: 'Returns time of sunrise for a given day and location (int timestamp, [int format, [float latitude, [float longitude, [float zenith, [float gmt_offset]]]]]): mixed',
	date_sunset: 'Returns time of sunset for a given day and location (int timestamp, [int format, [float latitude, [float longitude, [float zenith, [float gmt_offset]]]]]): mixed',
	date_time_set: 'Alias of DateTime::setTime',
	date_timestamp_get: 'Alias of DateTime::getTimestamp',
	date_timestamp_set: 'Alias of DateTime::setTimestamp',
	date_timezone_get: 'Alias of DateTime::getTimezone',
	date_timezone_set: 'Alias of DateTime::setTimezone',
	date: 'Format a local time/date (string format, [int timestamp]): string',
	getdate: 'Get date/time information ([int timestamp]): array',
	gettimeofday: 'Get current time ([bool return_float]): mixed',
	gmdate: 'Format a GMT/UTC date/time (string format, [int timestamp]): string',
	gmmktime: 'Get Unix timestamp for a GMT date ([int hour, [int minute, [int second, [int month, [int day, [int year, [int is_dst]]]]]]]): int',
	gmstrftime: 'Format a GMT/UTC time/date according to locale settings (string format, [int timestamp]): string',
	idate: 'Format a local time/date as integer (string format, [int timestamp]): int',
	localtime: 'Get the local time ([int timestamp, [bool is_associative]]): array',
	microtime: 'Return current Unix timestamp with microseconds ([bool get_as_float]): mixed',
	mktime: 'Get Unix timestamp for a date ([int hour, [int minute, [int second, [int month, [int day, [int year, [int is_dst]]]]]]]): int',
	strftime: 'Format a local time/date according to locale settings (string format, [int timestamp]): string',
	strptime: 'Parse a time/date generated with strftime (string date, string format): array',
	strtotime: 'Parse about any English textual datetime description into a Unix timestamp (string time, [int now]): int',
	time: 'Return current Unix timestamp (): int',
	timezone_abbreviations_list: 'Alias of DateTimeZone::listAbbreviations',
	timezone_identifiers_list: 'Alias of DateTimeZone::listIdentifiers',
	timezone_location_get: 'Alias of DateTimeZone::getLocation',
	timezone_name_from_abbr: 'Returns the timezone name from abbreviation (string abbr, [int gmtOffset, [int isdst]]): string',
	timezone_name_get: 'Alias of DateTimeZone::getName',
	timezone_offset_get: 'Alias of DateTimeZone::getOffset',
	timezone_open: 'Alias of DateTimeZone::__construct',
	timezone_transitions_get: 'Alias of DateTimeZone::getTransitions',
	timezone_version_get: 'Gets the version of the timezonedb (): string',
	dba_close: 'Close a DBA database (resource handle): null',
	dba_delete: 'Delete DBA entry specified by key (string key, resource handle): bool',
	dba_exists: 'Check whether key exists (string key, resource handle): bool',
	dba_fetch: 'Fetch data specified by key (string key, resource handle): string',
	dba_fetch: 'Fetch data specified by key (string key, int skip, resource handle): string',
	dba_firstkey: 'Fetch first key (resource handle): string',
	dba_handlers: 'List all the handlers available ([bool full_info]): array',
	dba_insert: 'Insert entry (string key, string value, resource handle): bool',
	dba_key_split: 'Splits a key in string representation into array representation (mixed key): mixed',
	dba_list: 'List all open database files (): array',
	dba_nextkey: 'Fetch next key (resource handle): string',
	dba_open: 'Open database (string path, string mode, [string handler, [mixed ...]]): resource',
	dba_optimize: 'Optimize database (resource handle): bool',
	dba_popen: 'Open database persistently (string path, string mode, [string handler, [mixed ...]]): resource',
	dba_replace: 'Replace or insert entry (string key, string value, resource handle): bool',
	dba_sync: 'Synchronize database (resource handle): bool',
	dbase_add_record: 'Adds a record to a database (int dbase_identifier, array record): bool',
	dbase_close: 'Closes a database (int dbase_identifier): bool',
	dbase_create: 'Creates a database (string filename, array fields): int',
	dbase_delete_record: 'Deletes a record from a database (int dbase_identifier, int record_number): bool',
	dbase_get_header_info: 'Gets the header info of a database (int dbase_identifier): array',
	dbase_get_record_with_names: 'Gets a record from a database as an associative array (int dbase_identifier, int record_number): array',
	dbase_get_record: 'Gets a record from a database as an indexed array (int dbase_identifier, int record_number): array',
	dbase_numfields: 'Gets the number of fields of a database (int dbase_identifier): int',
	dbase_numrecords: 'Gets the number of records in a database (int dbase_identifier): int',
	dbase_open: 'Opens a database (string filename, int mode): int',
	dbase_pack: 'Packs a database (int dbase_identifier): bool',
	dbase_replace_record: 'Replaces a record in a database (int dbase_identifier, array record, int record_number): bool',
	dbplus_add: 'Add a tuple to a relation (resource relation, array tuple): int',
	dbplus_aql: 'Perform AQL query (string query, [string server, [string dbpath]]): resource',
	dbplus_chdir: 'Get/Set database virtual current directory ([string newdir]): string',
	dbplus_close: 'Close a relation (resource relation): mixed',
	dbplus_curr: 'Get current tuple from relation (resource relation, array &tuple): int',
	dbplus_errcode: 'Get error string for given errorcode or last error ([int errno]): string',
	dbplus_errno: 'Get error code for last operation (): int',
	dbplus_find: 'Set a constraint on a relation (resource relation, array constraints, mixed tuple): int',
	dbplus_first: 'Get first tuple from relation (resource relation, array &tuple): int',
	dbplus_flush: 'Flush all changes made on a relation (resource relation): int',
	dbplus_freealllocks: 'Free all locks held by this client (): int',
	dbplus_freelock: 'Release write lock on tuple (resource relation, string tuple): int',
	dbplus_freerlocks: 'Free all tuple locks on given relation (resource relation): int',
	dbplus_getlock: 'Get a write lock on a tuple (resource relation, string tuple): int',
	dbplus_getunique: 'Get an id number unique to a relation (resource relation, int uniqueid): int',
	dbplus_info: 'Get information about a relation (resource relation, string key, array &result): int',
	dbplus_last: 'Get last tuple from relation (resource relation, array &tuple): int',
	dbplus_lockrel: 'Request write lock on relation (resource relation): int',
	dbplus_next: 'Get next tuple from relation (resource relation, array &tuple): int',
	dbplus_open: 'Open relation file (string name): resource',
	dbplus_prev: 'Get previous tuple from relation (resource relation, array &tuple): int',
	dbplus_rchperm: 'Change relation permissions (resource relation, int mask, string user, string group): int',
	dbplus_rcreate: 'Creates a new DB++ relation (string name, mixed domlist, [bool overwrite]): resource',
	dbplus_rcrtexact: 'Creates an exact but empty copy of a relation including indices (string name, resource relation, [bool overwrite]): mixed',
	dbplus_rcrtlike: 'Creates an empty copy of a relation with default indices (string name, resource relation, [int overwrite]): mixed',
	dbplus_resolve: 'Resolve host information for relation (string relation_name): array',
	dbplus_restorepos: 'Restore position (resource relation, array tuple): int',
	dbplus_rkeys: 'Specify new primary key for a relation (resource relation, mixed domlist): mixed',
	dbplus_ropen: 'Open relation file local (string name): resource',
	dbplus_rquery: 'Perform local (raw) AQL query (string query, [string dbpath]): resource',
	dbplus_rrename: 'Rename a relation (resource relation, string name): int',
	dbplus_rsecindex: 'Create a new secondary index for a relation (resource relation, mixed domlist, int type): mixed',
	dbplus_runlink: 'Remove relation from filesystem (resource relation): int',
	dbplus_rzap: 'Remove all tuples from relation (resource relation): int',
	dbplus_savepos: 'Save position (resource relation): int',
	dbplus_setindex: 'Set index (resource relation, string idx_name): int',
	dbplus_setindexbynumber: 'Set index by number (resource relation, int idx_number): int',
	dbplus_sql: 'Perform SQL query (string query, [string server, [string dbpath]]): resource',
	dbplus_tcl: 'Execute TCL code on server side (int sid, string script): string',
	dbplus_tremove: 'Remove tuple and return new current tuple (resource relation, array tuple, [array &current]): int',
	dbplus_undo: 'Undo (resource relation): int',
	dbplus_undoprepare: 'Prepare undo (resource relation): int',
	dbplus_unlockrel: 'Give up write lock on relation (resource relation): int',
	dbplus_unselect: 'Remove a constraint from relation (resource relation): int',
	dbplus_update: 'Update specified tuple in relation (resource relation, array old, array new): int',
	dbplus_xlockrel: 'Request exclusive lock on relation (resource relation): int',
	dbplus_xunlockrel: 'Free exclusive lock on relation (resource relation): int',
	dbx_close: 'Close an open connection/database (object link_identifier): int',
	dbx_compare: 'Compare two rows for sorting purposes (array row_a, array row_b, string column_key, [int flags]): int',
	dbx_connect: 'Open a connection/database (mixed module, string host, string database, string username, string password, [int persistent]): object',
	dbx_error: 'Report the error message of the latest function call in the module (object link_identifier): string',
	dbx_escape_string: 'Escape a string so it can safely be used in an sql-statement (object link_identifier, string text): string',
	dbx_fetch_row: 'Fetches rows from a query-result that had the DBX_RESULT_UNBUFFERED flag set (object result_identifier): mixed',
	dbx_query: 'Send a query and fetch all results (if any) (object link_identifier, string sql_statement, [int flags]): mixed',
	dbx_sort: 'Sort a result from a dbx_query by a custom sort function (object result, string user_compare_function): bool',
	dio_close: 'Closes the file descriptor given by fd (resource fd): null',
	dio_fcntl: 'Performs a c library fcntl on fd (resource fd, int cmd, [mixed args]): mixed',
	dio_open: 'Opens a file (creating it if necessary) at a lower level than the C library input/ouput stream functions allow. (string filename, int flags, [int mode]): resource',
	dio_read: 'Reads bytes from a file descriptor (resource fd, [int len]): string',
	dio_seek: 'Seeks to pos on fd from whence (resource fd, int pos, [int whence]): int',
	dio_stat: 'Gets stat information about the file descriptor fd (resource fd): array',
	dio_tcsetattr: 'Sets terminal attributes and baud rate for a serial port (resource fd, array options): bool',
	dio_truncate: 'Truncates file descriptor fd to offset bytes (resource fd, int offset): bool',
	dio_write: 'Writes data to fd with optional truncation at length (resource fd, string data, [int len]): int',
	chdir: 'Change directory (string directory): bool',
	chroot: 'Change the root directory (string directory): bool',
	closedir: 'Close directory handle ([resource dir_handle]): null',
	getcwd: 'Gets the current working directory (): string',
	opendir: 'Open directory handle (string path, [resource context]): resource',
	readdir: 'Read entry from directory handle ([resource dir_handle]): string',
	rewinddir: 'Rewind directory handle ([resource dir_handle]): null',
	scandir: 'List files and directories inside the specified path (string directory, [int sorting_order, [resource context]]): array',
	dom_import_simplexml: 'Gets a DOMElement object from a SimpleXMLElement object (SimpleXMLElement node): DOMElement',
	domxml_new_doc: 'Creates new empty XML document (string version): DomDocument',
	domxml_open_file: 'Creates a DOM object from an XML file (string filename, [int mode, [array &error]]): DomDocument',
	domxml_open_mem: 'Creates a DOM object of an XML document (string str, [int mode, [array &error]]): DomDocument',
	domxml_version: 'Gets the XML library version (): string',
	domxml_xmltree: 'Creates a tree of PHP objects from an XML document (string str): DomDocument',
	domxml_xslt_stylesheet_doc: 'Creates a DomXsltStylesheet Object from a DomDocument Object (DomDocument xsl_doc): DomXsltStylesheet',
	domxml_xslt_stylesheet_file: 'Creates a DomXsltStylesheet Object from an XSL document in a file (string xsl_file): DomXsltStylesheet',
	domxml_xslt_stylesheet: 'Creates a DomXsltStylesheet object from an XSL document in a string (string xsl_buf): DomXsltStylesheet',
	domxml_xslt_version: 'Gets the XSLT library version (): int',
	xpath_new_context: 'Creates new xpath context (domdocument dom_document): XPathContext',
	xpath_register_ns_auto: 'Register the given namespace in the passed XPath context (XPathContext xpath_context, [object context_node]): bool',
	xpath_register_ns: 'Register the given namespace in the passed XPath context (XPathContext xpath_context, string prefix, string uri): bool',
	xptr_new_context: 'Create new XPath Context (): XPathContext',
	dotnet_load: 'Loads a DOTNET module (string assembly_name, [string datatype_name, [int codepage]]): int',
	enchant_broker_describe: 'Enumerates the Enchant providers (resource broker): array',
	enchant_broker_dict_exists: 'Whether a dictionary exists or not. Using non-empty tag (resource broker, string tag): bool',
	enchant_broker_free_dict: 'Free a dictionary resource (resource dict): bool',
	enchant_broker_free: 'Free the broker resource and its dictionnaries (resource broker): bool',
	enchant_broker_get_error: 'Returns the last error of the broker (resource broker): string',
	enchant_broker_init: 'create a new broker object capable of requesting (): resource',
	enchant_broker_list_dicts: 'Returns a list of available dictionaries (resource broker): mixed',
	enchant_broker_request_dict: 'create a new dictionary using a tag (resource broker, string tag): resource',
	enchant_broker_request_pwl_dict: 'creates a dictionary using a PWL file (resource broker, string filename): resource',
	enchant_broker_set_ordering: 'Declares a preference of dictionaries to use for the language (resource broker, string tag, string ordering): bool',
	enchant_dict_add_to_personal: 'add a word to personal word list (resource dict, string word): null',
	enchant_dict_add_to_session: 'add \'word\' to this spell-checking session (resource dict, string word): null',
	enchant_dict_check: 'Check whether a word is correctly spelled or not (resource dict, string word): bool',
	enchant_dict_describe: 'Describes an individual dictionary (resource dict): mixed',
	enchant_dict_get_error: 'Returns the last error of the current spelling-session (resource dict): string',
	enchant_dict_is_in_session: 'whether or not \'word\' exists in this spelling-session (resource dict, string word): bool',
	enchant_dict_quick_check: 'Check the word is correctly spelled and provide suggestions (resource dict, string word, [array &suggestions]): bool',
	enchant_dict_store_replacement: 'Add a correction for a word (resource dict, string mis, string cor): null',
	enchant_dict_suggest: 'Will return a list of values if any of those pre-conditions are not met (resource dict, string word): array',
	debug_backtrace: 'Generates a backtrace ([bool provide_object]): array',
	debug_print_backtrace: 'Prints a backtrace (): null',
	error_get_last: 'Get the last occurred error (): array',
	error_log: 'Send an error message somewhere (string message, [int message_type, [string destination, [string extra_headers]]]): bool',
	error_reporting: 'Sets which PHP errors are reported ([int level]): int',
	restore_error_handler: 'Restores the previous error handler function (): bool',
	restore_exception_handler: 'Restores the previously defined exception handler function (): bool',
	set_error_handler: 'Sets a user-defined error handler function (callback error_handler, [int error_types]): mixed',
	set_exception_handler: 'Sets a user-defined exception handler function (callback exception_handler): callback',
	trigger_error: 'Generates a user-level error/warning/notice message (string error_msg, [int error_type]): bool',
	user_error: 'Alias of trigger_error',
	escapeshellarg: 'Escape a string to be used as a shell argument (string arg): string',
	escapeshellcmd: 'Escape shell metacharacters (string command): string',
	exec: 'Execute an external program (string command, [array &output, [int &return_var]]): string',
	passthru: 'Execute an external program and display raw output (string command, [int &return_var]): null',
	proc_close: 'Close a process opened by proc_open and return the exit code of that process (resource process): int',
	proc_get_status: 'Get information about a process opened by proc_open (resource process): array',
	proc_nice: 'Change the priority of the current process (int increment): bool',
	proc_open: 'Execute a command and open file pointers for input/output (string cmd, array descriptorspec, array &pipes, [string cwd, [array env, [array other_options]]]): resource',
	proc_terminate: 'Kills a process opened by proc_open (resource process, [int signal]): bool',
	shell_exec: 'Execute command via shell and return the complete output as a string (string cmd): string',
	system: 'Execute an external program and display the output (string command, [int &return_var]): string',
	exif_imagetype: 'Determine the type of an image (string filename): int',
	exif_read_data: 'Reads the EXIF headers from JPEG or TIFF (string filename, [string sections, [bool arrays, [bool thumbnail]]]): array',
	exif_tagname: 'Get the header name for an index (int index): string',
	exif_thumbnail: 'Retrieve the embedded thumbnail of a TIFF or JPEG image (string filename, [int &width, [int &height, [int &imagetype]]]): string',
	read_exif_data: 'Alias of exif_read_data',
	expect_expectl: 'Waits until the output from a process matches one of the patterns, a specified time period has passed, or an EOF is seen (resource expect, array cases, [array &match]): int',
	expect_popen: 'Execute command via Bourne shell, and open the PTY stream to the process (string command): resource',
	fam_cancel_monitor: 'Terminate monitoring (resource fam, resource fam_monitor): bool',
	fam_close: 'Close FAM connection (resource fam): null',
	fam_monitor_collection: 'Monitor a collection of files in a directory for changes (resource fam, string dirname, int depth, string mask): resource',
	fam_monitor_directory: 'Monitor a directory for changes (resource fam, string dirname): resource',
	fam_monitor_file: 'Monitor a regular file for changes (resource fam, string filename): resource',
	fam_next_event: 'Get next pending FAM event (resource fam): array',
	fam_open: 'Open connection to FAM daemon ([string appname]): resource',
	fam_pending: 'Check for pending FAM events (resource fam): int',
	fam_resume_monitor: 'Resume suspended monitoring (resource fam, resource fam_monitor): bool',
	fam_suspend_monitor: 'Temporarily suspend monitoring (resource fam, resource fam_monitor): bool',
	fbsql_affected_rows: 'Get number of affected rows in previous FrontBase operation ([resource link_identifier]): int',
	fbsql_autocommit: 'Enable or disable autocommit (resource link_identifier, [bool OnOff]): bool',
	fbsql_blob_size: 'Get the size of a BLOB (string blob_handle, [resource link_identifier]): int',
	fbsql_change_user: 'Change logged in user of the active connection (string user, string password, [string database, [resource link_identifier]]): bool',
	fbsql_clob_size: 'Get the size of a CLOB (string clob_handle, [resource link_identifier]): int',
	fbsql_close: 'Close FrontBase connection ([resource link_identifier]): bool',
	fbsql_commit: 'Commits a transaction to the database ([resource link_identifier]): bool',
	fbsql_connect: 'Open a connection to a FrontBase Server ([string hostname, [string username, [string password]]]): resource',
	fbsql_create_blob: 'Create a BLOB (string blob_data, [resource link_identifier]): string',
	fbsql_create_clob: 'Create a CLOB (string clob_data, [resource link_identifier]): string',
	fbsql_create_db: 'Create a FrontBase database (string database_name, [resource link_identifier, [string database_options]]): bool',
	fbsql_data_seek: 'Move internal result pointer (resource result, int row_number): bool',
	fbsql_database_password: 'Sets or retrieves the password for a FrontBase database (resource link_identifier, [string database_password]): string',
	fbsql_database: 'Get or set the database name used with a connection (resource link_identifier, [string database]): string',
	fbsql_db_query: 'Send a FrontBase query (string database, string query, [resource link_identifier]): resource',
	fbsql_db_status: 'Get the status for a given database (string database_name, [resource link_identifier]): int',
	fbsql_drop_db: 'Drop (delete) a FrontBase database (string database_name, [resource link_identifier]): bool',
	fbsql_errno: 'Returns the error number from previous operation ([resource link_identifier]): int',
	fbsql_error: 'Returns the error message from previous operation ([resource link_identifier]): string',
	fbsql_fetch_array: 'Fetch a result row as an associative array, a numeric array, or both (resource result, [int result_type]): array',
	fbsql_fetch_assoc: 'Fetch a result row as an associative array (resource result): array',
	fbsql_fetch_field: 'Get column information from a result and return as an object (resource result, [int field_offset]): object',
	fbsql_fetch_lengths: 'Get the length of each output in a result (resource result): array',
	fbsql_fetch_object: 'Fetch a result row as an object (resource result): object',
	fbsql_fetch_row: 'Get a result row as an enumerated array (resource result): array',
	fbsql_field_flags: 'Get the flags associated with the specified field in a result (resource result, [int field_offset]): string',
	fbsql_field_len: 'Returns the length of the specified field (resource result, [int field_offset]): int',
	fbsql_field_name: 'Get the name of the specified field in a result (resource result, [int field_index]): string',
	fbsql_field_seek: 'Set result pointer to a specified field offset (resource result, [int field_offset]): bool',
	fbsql_field_table: 'Get name of the table the specified field is in (resource result, [int field_offset]): string',
	fbsql_field_type: 'Get the type of the specified field in a result (resource result, [int field_offset]): string',
	fbsql_free_result: 'Free result memory (resource result): bool',
	fbsql_get_autostart_info: ' ([resource link_identifier]): array',
	fbsql_hostname: 'Get or set the host name used with a connection (resource link_identifier, [string host_name]): string',
	fbsql_insert_id: 'Get the id generated from the previous INSERT operation ([resource link_identifier]): int',
	fbsql_list_dbs: 'List databases available on a FrontBase server ([resource link_identifier]): resource',
	fbsql_list_fields: 'List FrontBase result fields (string database_name, string table_name, [resource link_identifier]): resource',
	fbsql_list_tables: 'List tables in a FrontBase database (string database, [resource link_identifier]): resource',
	fbsql_next_result: 'Move the internal result pointer to the next result (resource result): bool',
	fbsql_num_fields: 'Get number of fields in result (resource result): int',
	fbsql_num_rows: 'Get number of rows in result (resource result): int',
	fbsql_password: 'Get or set the user password used with a connection (resource link_identifier, [string password]): string',
	fbsql_pconnect: 'Open a persistent connection to a FrontBase Server ([string hostname, [string username, [string password]]]): resource',
	fbsql_query: 'Send a FrontBase query (string query, [resource link_identifier, [int batch_size]]): resource',
	fbsql_read_blob: 'Read a BLOB from the database (string blob_handle, [resource link_identifier]): string',
	fbsql_read_clob: 'Read a CLOB from the database (string clob_handle, [resource link_identifier]): string',
	fbsql_result: 'Get result data (resource result, [int row, [mixed field]]): mixed',
	fbsql_rollback: 'Rollback a transaction to the database ([resource link_identifier]): bool',
	fbsql_rows_fetched: 'Get the number of rows affected by the last statement (resource result): int',
	fbsql_select_db: 'Select a FrontBase database ([string database_name, [resource link_identifier]]): bool',
	fbsql_set_characterset: 'Change input/output character set (resource link_identifier, int characterset, [int in_out_both]): null',
	fbsql_set_lob_mode: 'Set the LOB retrieve mode for a FrontBase result set (resource result, int lob_mode): bool',
	fbsql_set_password: 'Change the password for a given user (resource link_identifier, string user, string password, string old_password): bool',
	fbsql_set_transaction: 'Set the transaction locking and isolation (resource link_identifier, int locking, int isolation): null',
	fbsql_start_db: 'Start a database on local or remote server (string database_name, [resource link_identifier, [string database_options]]): bool',
	fbsql_stop_db: 'Stop a database on local or remote server (string database_name, [resource link_identifier]): bool',
	fbsql_table_name: 'Get table name of field (resource result, int index): string',
	fbsql_tablename: 'Alias of of fbsql_table_name',
	fbsql_username: 'Get or set the username for the connection (resource link_identifier, [string username]): string',
	fbsql_warnings: 'Enable or disable FrontBase warnings ([bool OnOff]): bool',
	fdf_add_doc_javascript: 'Adds javascript code to the FDF document (resource fdf_document, string script_name, string script_code): bool',
	fdf_add_template: 'Adds a template into the FDF document (resource fdf_document, int newpage, string filename, string template, int rename): bool',
	fdf_close: 'Close an FDF document (resource fdf_document): null',
	fdf_create: 'Create a new FDF document (): resource',
	fdf_enum_values: 'Call a user defined function for each document value (resource fdf_document, callback function, [mixed userdata]): bool',
	fdf_errno: 'Return error code for last fdf operation (): int',
	fdf_error: 'Return error description for FDF error code ([int error_code]): string',
	fdf_get_ap: 'Get the appearance of a field (resource fdf_document, string field, int face, string filename): bool',
	fdf_get_attachment: 'Extracts uploaded file embedded in the FDF (resource fdf_document, string fieldname, string savepath): array',
	fdf_get_encoding: 'Get the value of the /Encoding key (resource fdf_document): string',
	fdf_get_file: 'Get the value of the /F key (resource fdf_document): string',
	fdf_get_flags: 'Gets the flags of a field (resource fdf_document, string fieldname, int whichflags): int',
	fdf_get_opt: 'Gets a value from the opt array of a field (resource fdf_document, string fieldname, [int element]): mixed',
	fdf_get_status: 'Get the value of the /STATUS key (resource fdf_document): string',
	fdf_get_value: 'Get the value of a field (resource fdf_document, string fieldname, [int which]): mixed',
	fdf_get_version: 'Gets version number for FDF API or file ([resource fdf_document]): string',
	fdf_header: 'Sets FDF-specific output headers (): null',
	fdf_next_field_name: 'Get the next field name (resource fdf_document, [string fieldname]): string',
	fdf_open_string: 'Read a FDF document from a string (string fdf_data): resource',
	fdf_open: 'Open a FDF document (string filename): resource',
	fdf_remove_item: 'Sets target frame for form (resource fdf_document, string fieldname, int item): bool',
	fdf_save_string: 'Returns the FDF document as a string (resource fdf_document): string',
	fdf_save: 'Save a FDF document (resource fdf_document, [string filename]): bool',
	fdf_set_ap: 'Set the appearance of a field (resource fdf_document, string field_name, int face, string filename, int page_number): bool',
	fdf_set_encoding: 'Sets FDF character encoding (resource fdf_document, string encoding): bool',
	fdf_set_file: 'Set PDF document to display FDF data in (resource fdf_document, string url, [string target_frame]): bool',
	fdf_set_flags: 'Sets a flag of a field (resource fdf_document, string fieldname, int whichFlags, int newFlags): bool',
	fdf_set_javascript_action: 'Sets an javascript action of a field (resource fdf_document, string fieldname, int trigger, string script): bool',
	fdf_set_on_import_javascript: 'Adds javascript code to be executed when Acrobat opens the FDF (resource fdf_document, string script, bool before_data_import): bool',
	fdf_set_opt: 'Sets an option of a field (resource fdf_document, string fieldname, int element, string str1, string str2): bool',
	fdf_set_status: 'Set the value of the /STATUS key (resource fdf_document, string status): bool',
	fdf_set_submit_form_action: 'Sets a submit form action of a field (resource fdf_document, string fieldname, int trigger, string script, int flags): bool',
	fdf_set_target_frame: 'Set target frame for form display (resource fdf_document, string frame_name): bool',
	fdf_set_value: 'Set the value of a field (resource fdf_document, string fieldname, mixed value, [int isName]): bool',
	fdf_set_version: 'Sets version number for a FDF file (resource fdf_document, string version): bool',
	finfo_buffer: 'Return information about a string buffer (resource finfo, string string, [int options, [resource context]]): string',
	finfo_close: 'Close fileinfo resource (resource finfo): bool',
	finfo_file: 'Return information about a file (resource finfo, string file_name, [int options, [resource context]]): string',
	finfo_open: 'Create a new fileinfo resource ([int options, [string magic_file]]): resource',
	finfo_set_flags: 'Set libmagic configuration options (resource finfo, int options): bool',
	mime_content_type: 'Detect MIME Content-type for a file (deprecated) (string filename): string',
	filepro_fieldcount: 'Find out how many fields are in a filePro database (): int',
	filepro_fieldname: 'Gets the name of a field (int field_number): string',
	filepro_fieldtype: 'Gets the type of a field (int field_number): string',
	filepro_fieldwidth: 'Gets the width of a field (int field_number): int',
	filepro_retrieve: 'Retrieves data from a filePro database (int row_number, int field_number): string',
	filepro_rowcount: 'Find out how many rows are in a filePro database (): int',
	filepro: 'Read and verify the map file (string directory): bool',
	basename: 'Returns filename component of path (string path, [string suffix]): string',
	chgrp: 'Changes file group (string filename, mixed group): bool',
	chmod: 'Changes file mode (string filename, int mode): bool',
	chown: 'Changes file owner (string filename, mixed user): bool',
	clearstatcache: 'Clears file status cache ([bool clear_realpath_cache, [string filename]]): null',
	copy: 'Copies file (string source, string dest, [resource context]): bool',
	dirname: 'Returns directory name component of path (string path): string',
	disk_free_space: 'Returns available space on filesystem or disk partition (string directory): float',
	disk_total_space: 'Returns the total size of a filesystem or disk partition (string directory): float',
	diskfreespace: 'Alias of disk_free_space',
	fclose: 'Closes an open file pointer (resource handle): bool',
	feof: 'Tests for end-of-file on a file pointer (resource handle): bool',
	fflush: 'Flushes the output to a file (resource handle): bool',
	fgetc: 'Gets character from file pointer (resource handle): string',
	fgetcsv: 'Gets line from file pointer and parse for CSV fields (resource handle, [int length, [string delimiter, [string enclosure, [string escape]]]]): array',
	fgets: 'Gets line from file pointer (resource handle, [int length]): string',
	fgetss: 'Gets line from file pointer and strip HTML tags (resource handle, [int length, [string allowable_tags]]): string',
	file_exists: 'Checks whether a file or directory exists (string filename): bool',
	file_get_contents: 'Reads entire file into a string (string filename, [bool use_include_path, [resource context, [int offset, [int maxlen]]]]): string',
	file_put_contents: 'Write a string to a file (string filename, mixed data, [int flags, [resource context]]): int',
	file: 'Reads entire file into an array (string filename, [int flags, [resource context]]): array',
	fileatime: 'Gets last access time of file (string filename): int',
	filectime: 'Gets inode change time of file (string filename): int',
	filegroup: 'Gets file group (string filename): int',
	fileinode: 'Gets file inode (string filename): int',
	filemtime: 'Gets file modification time (string filename): int',
	fileowner: 'Gets file owner (string filename): int',
	fileperms: 'Gets file permissions (string filename): int',
	filesize: 'Gets file size (string filename): int',
	filetype: 'Gets file type (string filename): string',
	flock: 'Portable advisory file locking (resource handle, int operation, [int &wouldblock]): bool',
	fnmatch: 'Match filename against a pattern (string pattern, string string, [int flags]): bool',
	fopen: 'Opens file or URL (string filename, string mode, [bool use_include_path, [resource context]]): resource',
	fpassthru: 'Output all remaining data on a file pointer (resource handle): int',
	fputcsv: 'Format line as CSV and write to file pointer (resource handle, array fields, [string delimiter, [string enclosure]]): int',
	fputs: 'Alias of fwrite',
	fread: 'Binary-safe file read (resource handle, int length): string',
	fscanf: 'Parses input from a file according to a format (resource handle, string format, [mixed &...]): mixed',
	fseek: 'Seeks on a file pointer (resource handle, int offset, [int whence]): int',
	fstat: 'Gets information about a file using an open file pointer (resource handle): array',
	ftell: 'Returns the current position of the file read/write pointer (resource handle): int',
	ftruncate: 'Truncates a file to a given length (resource handle, int size): bool',
	fwrite: 'Binary-safe file write (resource handle, string string, [int length]): int',
	glob: 'Find pathnames matching a pattern (string pattern, [int flags]): array',
	is_dir: 'Tells whether the filename is a directory (string filename): bool',
	is_executable: 'Tells whether the filename is executable (string filename): bool',
	is_file: 'Tells whether the filename is a regular file (string filename): bool',
	is_link: 'Tells whether the filename is a symbolic link (string filename): bool',
	is_readable: 'Tells whether a file exists and is readable (string filename): bool',
	is_uploaded_file: 'Tells whether the file was uploaded via HTTP POST (string filename): bool',
	is_writable: 'Tells whether the filename is writable (string filename): bool',
	is_writeable: 'Alias of is_writable',
	lchgrp: 'Changes group ownership of symlink (string filename, mixed group): bool',
	lchown: 'Changes user ownership of symlink (string filename, mixed user): bool',
	link: 'Create a hard link (string from_path, string to_path): bool',
	linkinfo: 'Gets information about a link (string path): int',
	lstat: 'Gives information about a file or symbolic link (string filename): array',
	mkdir: 'Makes directory (string pathname, [int mode, [bool recursive, [resource context]]]): bool',
	move_uploaded_file: 'Moves an uploaded file to a new location (string filename, string destination): bool',
	parse_ini_file: 'Parse a configuration file (string filename, [bool process_sections, [int scanner_mode]]): array',
	parse_ini_string: 'Parse a configuration string (string ini, [bool process_sections, [int scanner_mode]]): array',
	pathinfo: 'Returns information about a file path (string path, [int options]): mixed',
	pclose: 'Closes process file pointer (resource handle): int',
	popen: 'Opens process file pointer (string command, string mode): resource',
	readfile: 'Outputs a file (string filename, [bool use_include_path, [resource context]]): int',
	readlink: 'Returns the target of a symbolic link (string path): string',
	realpath: 'Returns canonicalized absolute pathname (string path): string',
	realpath_cache_get: 'Get realpath cache entries (): array',
	realpath_cache_size: 'Get realpath cache size (): int',
	rename: 'Renames a file or directory (string oldname, string newname, [resource context]): bool',
	rewind: 'Rewind the position of a file pointer (resource handle): bool',
	rmdir: 'Removes directory (string dirname, [resource context]): bool',
	set_file_buffer: 'Alias of stream_set_write_buffer',
	stat: 'Gives information about a file (string filename): array',
	symlink: 'Creates a symbolic link (string target, string link): bool',
	tempnam: 'Create file with unique file name (string dir, string prefix): string',
	tmpfile: 'Creates a temporary file (): resource',
	touch: 'Sets access and modification time of file (string filename, [int time, [int atime]]): bool',
	umask: 'Changes the current umask ([int mask]): int',
	unlink: 'Deletes a file (string filename, [resource context]): bool',
	filter_has_var: 'Checks if variable of specified type exists (int type, string variable_name): bool',
	filter_id: 'Returns the filter ID belonging to a named filter (string filtername): int',
	filter_input_array: 'Gets external variables and optionally filters them (int type, [mixed definition]): mixed',
	filter_input: 'Gets a specific external variable by name and optionally filters it (int type, string variable_name, [int filter, [mixed options]]): mixed',
	filter_list: 'Returns a list of all supported filters (): array',
	filter_var_array: 'Gets multiple variables and optionally filters them (array data, [mixed definition]): mixed',
	filter_var: 'Filters a variable with a specified filter (mixed variable, [int filter, [mixed options]]): mixed',
	fribidi_log2vis: 'Convert a logical string to a visual one (string str, string direction, int charset): string',
	ftp_alloc: 'Allocates space for a file to be uploaded (resource ftp_stream, int filesize, [string &result]): bool',
	ftp_cdup: 'Changes to the parent directory (resource ftp_stream): bool',
	ftp_chdir: 'Changes the current directory on a FTP server (resource ftp_stream, string directory): bool',
	ftp_chmod: 'Set permissions on a file via FTP (resource ftp_stream, int mode, string filename): int',
	ftp_close: 'Closes an FTP connection (resource ftp_stream): bool',
	ftp_connect: 'Opens an FTP connection (string host, [int port, [int timeout]]): resource',
	ftp_delete: 'Deletes a file on the FTP server (resource ftp_stream, string path): bool',
	ftp_exec: 'Requests execution of a command on the FTP server (resource ftp_stream, string command): bool',
	ftp_fget: 'Downloads a file from the FTP server and saves to an open file (resource ftp_stream, resource handle, string remote_file, int mode, [int resumepos]): bool',
	ftp_fput: 'Uploads from an open file to the FTP server (resource ftp_stream, string remote_file, resource handle, int mode, [int startpos]): bool',
	ftp_get_option: 'Retrieves various runtime behaviours of the current FTP stream (resource ftp_stream, int option): mixed',
	ftp_get: 'Downloads a file from the FTP server (resource ftp_stream, string local_file, string remote_file, int mode, [int resumepos]): bool',
	ftp_login: 'Logs in to an FTP connection (resource ftp_stream, string username, string password): bool',
	ftp_mdtm: 'Returns the last modified time of the given file (resource ftp_stream, string remote_file): int',
	ftp_mkdir: 'Creates a directory (resource ftp_stream, string directory): string',
	ftp_nb_continue: 'Continues retrieving/sending a file (non-blocking) (resource ftp_stream): int',
	ftp_nb_fget: 'Retrieves a file from the FTP server and writes it to an open file (non-blocking) (resource ftp_stream, resource handle, string remote_file, int mode, [int resumepos]): int',
	ftp_nb_fput: 'Stores a file from an open file to the FTP server (non-blocking) (resource ftp_stream, string remote_file, resource handle, int mode, [int startpos]): int',
	ftp_nb_get: 'Retrieves a file from the FTP server and writes it to a local file (non-blocking) (resource ftp_stream, string local_file, string remote_file, int mode, [int resumepos]): int',
	ftp_nb_put: 'Stores a file on the FTP server (non-blocking) (resource ftp_stream, string remote_file, string local_file, int mode, [int startpos]): int',
	ftp_nlist: 'Returns a list of files in the given directory (resource ftp_stream, string directory): array',
	ftp_pasv: 'Turns passive mode on or off (resource ftp_stream, bool pasv): bool',
	ftp_put: 'Uploads a file to the FTP server (resource ftp_stream, string remote_file, string local_file, int mode, [int startpos]): bool',
	ftp_pwd: 'Returns the current directory name (resource ftp_stream): string',
	ftp_quit: 'Alias of ftp_close',
	ftp_raw: 'Sends an arbitrary command to an FTP server (resource ftp_stream, string command): array',
	ftp_rawlist: 'Returns a detailed list of files in the given directory (resource ftp_stream, string directory, [bool recursive]): array',
	ftp_rename: 'Renames a file or a directory on the FTP server (resource ftp_stream, string oldname, string newname): bool',
	ftp_rmdir: 'Removes a directory (resource ftp_stream, string directory): bool',
	ftp_set_option: 'Set miscellaneous runtime FTP options (resource ftp_stream, int option, mixed value): bool',
	ftp_site: 'Sends a SITE command to the server (resource ftp_stream, string command): bool',
	ftp_size: 'Returns the size of the given file (resource ftp_stream, string remote_file): int',
	ftp_ssl_connect: 'Opens an Secure SSL-FTP connection (string host, [int port, [int timeout]]): resource',
	ftp_systype: 'Returns the system type identifier of the remote FTP server (resource ftp_stream): string',
	call_user_func_array: 'Call a user function given with an array of parameters (callback function, array param_arr): mixed',
	call_user_func: 'Call a user function given by the first parameter (callback function, [mixed parameter, [mixed ...]]): mixed',
	create_function: 'Create an anonymous (lambda-style) function (string args, string code): string',
	forward_static_call_array: 'Call a static method and pass the arguments as array (callback function, [array parameters]): mixed',
	forward_static_call: 'Call a static method (callback function, [mixed parameter, [mixed ...]]): mixed',
	func_get_arg: 'Return an item from the argument list (int arg_num): mixed',
	func_get_args: 'Returns an array comprising a function\'s argument list (): array',
	func_num_args: 'Returns the number of arguments passed to the function (): int',
	function_exists: 'Return TRUE if the given function has been defined (string function_name): bool',
	get_defined_functions: 'Returns an array of all defined functions (): array',
	register_shutdown_function: 'Register a function for execution on shutdown (callback function, [mixed parameter, [mixed ...]]): null',
	register_tick_function: 'Register a function for execution on each tick (callback function, [mixed arg, [mixed ...]]): bool',
	unregister_tick_function: 'De-register a function for execution on each tick (string function_name): null',
	geoip_continent_code_by_name: 'Get the two letter continent code (string hostname): string',
	geoip_country_code_by_name: 'Get the two letter country code (string hostname): string',
	geoip_country_code3_by_name: 'Get the three letter country code (string hostname): string',
	geoip_country_name_by_name: 'Get the full country name (string hostname): string',
	geoip_database_info: 'Get GeoIP Database information ([int database]): string',
	geoip_db_avail: 'Determine if GeoIP Database is available (int database): bool',
	geoip_db_filename: 'Returns the filename of the corresponding GeoIP Database (int database): string',
	geoip_db_get_all_info: 'Returns detailed information about all GeoIP database types (): array',
	geoip_id_by_name: 'Get the Internet connection speed (string hostname): int',
	geoip_isp_by_name: 'Get the Internet Service Provider (ISP) name (string hostname): string',
	geoip_org_by_name: 'Get the organization name (string hostname): string',
	geoip_record_by_name: 'Returns the detailed City information found in the GeoIP Database (string hostname): array',
	geoip_region_by_name: 'Get the country code and region (string hostname): array',
	geoip_region_name_by_code: 'Returns the region name for some country and region code combo (string country_code, string region_code): string',
	geoip_time_zone_by_country_and_region: 'Returns the time zone for some country and region code combo (string country_code, [string region_code]): string',
	bind_textdomain_codeset: 'Specify the character encoding in which the messages from the DOMAIN message catalog will be returned (string domain, string codeset): string',
	bindtextdomain: 'Sets the path for a domain (string domain, string directory): string',
	dcgettext: 'Overrides the domain for a single lookup (string domain, string message, int category): string',
	dcngettext: 'Plural version of dcgettext (string domain, string msgid1, string msgid2, int n, int category): string',
	dgettext: 'Override the current domain (string domain, string message): string',
	dngettext: 'Plural version of dgettext (string domain, string msgid1, string msgid2, int n): string',
	gettext: 'Lookup a message in the current domain (string message): string',
	ngettext: 'Plural version of gettext (string msgid1, string msgid2, int n): string',
	textdomain: 'Sets the default domain (string text_domain): string',
	gmp_abs: 'Absolute value (resource a): resource',
	gmp_add: 'Add numbers (resource a, resource b): resource',
	gmp_and: 'Bitwise AND (resource a, resource b): resource',
	gmp_clrbit: 'Clear bit (resource a, int index): null',
	gmp_cmp: 'Compare numbers (resource a, resource b): int',
	gmp_com: 'Calculates one\'s complement (resource a): resource',
	gmp_div_q: 'Divide numbers (resource a, resource b, [int round]): resource',
	gmp_div_qr: 'Divide numbers and get quotient and remainder (resource n, resource d, [int round]): array',
	gmp_div_r: 'Remainder of the division of numbers (resource n, resource d, [int round]): resource',
	gmp_div: 'Alias of gmp_div_q',
	gmp_divexact: 'Exact division of numbers (resource n, resource d): resource',
	gmp_fact: 'Factorial (mixed a): resource',
	gmp_gcd: 'Calculate GCD (resource a, resource b): resource',
	gmp_gcdext: 'Calculate GCD and multipliers (resource a, resource b): array',
	gmp_hamdist: 'Hamming distance (resource a, resource b): int',
	gmp_init: 'Create GMP number (mixed number, [int base]): resource',
	gmp_intval: 'Convert GMP number to integer (resource gmpnumber): int',
	gmp_invert: 'Inverse by modulo (resource a, resource b): resource',
	gmp_jacobi: 'Jacobi symbol (resource a, resource p): int',
	gmp_legendre: 'Legendre symbol (resource a, resource p): int',
	gmp_mod: 'Modulo operation (resource n, resource d): resource',
	gmp_mul: 'Multiply numbers (resource a, resource b): resource',
	gmp_neg: 'Negate number (resource a): resource',
	gmp_nextprime: 'Find next prime number (int a): resource',
	gmp_or: 'Bitwise OR (resource a, resource b): resource',
	gmp_perfect_square: 'Perfect square check (resource a): bool',
	gmp_popcount: 'Population count (resource a): int',
	gmp_pow: 'Raise number into power (resource base, int exp): resource',
	gmp_powm: 'Raise number into power with modulo (resource base, resource exp, resource mod): resource',
	gmp_prob_prime: 'Check if number is "probably prime" (resource a, [int reps]): int',
	gmp_random: 'Random number ([int limiter]): resource',
	gmp_scan0: 'Scan for 0 (resource a, int start): int',
	gmp_scan1: 'Scan for 1 (resource a, int start): int',
	gmp_setbit: 'Set bit (resource a, int index, [bool set_clear]): null',
	gmp_sign: 'Sign of number (resource a): int',
	gmp_sqrt: 'Calculate square root (resource a): resource',
	gmp_sqrtrem: 'Square root with remainder (resource a): array',
	gmp_strval: 'Convert GMP number to string (resource gmpnumber, [int base]): string',
	gmp_sub: 'Subtract numbers (resource a, resource b): resource',
	gmp_testbit: 'Tests if a bit is set (resource a, int index): bool',
	gmp_xor: 'Bitwise XOR (resource a, resource b): resource',
	gnupg_adddecryptkey: 'Add a key for decryption (resource identifier, string fingerprint, string passphrase): bool',
	gnupg_addencryptkey: 'Add a key for encryption (resource identifier, string fingerprint): bool',
	gnupg_addsignkey: 'Add a key for signing (resource identifier, string fingerprint, [string passphrase]): bool',
	gnupg_cleardecryptkeys: 'Removes all keys which were set for decryption before (resource identifier): bool',
	gnupg_clearencryptkeys: 'Removes all keys which were set for encryption before (resource identifier): bool',
	gnupg_clearsignkeys: 'Removes all keys which were set for signing before (resource identifier): bool',
	gnupg_decrypt: 'Decrypts a given text (resource identifier, string text): string',
	gnupg_decryptverify: 'Decrypts and verifies a given text (resource identifier, string text, string &plaintext): array',
	gnupg_encrypt: 'Encrypts a given text (resource identifier, string plaintext): string',
	gnupg_encryptsign: 'Encrypts and signs a given text (resource identifier, string plaintext): string',
	gnupg_export: 'Exports a key (resource identifier, string fingerprint): string',
	gnupg_geterror: 'Returns the errortext, if a function fails (resource identifier): string',
	gnupg_getprotocol: 'Returns the currently active protocol for all operations (resource identifier): int',
	gnupg_import: 'Imports a key (resource identifier, string keydata): array',
	gnupg_init: 'Initialize a connection (): resource',
	gnupg_keyinfo: 'Returns an array with information about all keys that matches the given pattern (resource identifier, string pattern): array',
	gnupg_setarmor: 'Toggle armored output (resource identifier, int armor): bool',
	gnupg_seterrormode: 'Sets the mode for error_reporting (resource identifier, int errormode): null',
	gnupg_setsignmode: 'Sets the mode for signing (resource identifier, int signmode): bool',
	gnupg_sign: 'Signs a given text (resource identifier, string plaintext): string',
	gnupg_verify: 'Verifies a signed text (resource identifier, string signed_text, string signature, [string &plaintext]): array',
	gupnp_context_get_host_ip: 'Get the IP address (resource context): string',
	gupnp_context_get_port: 'Get the port (resource context): int',
	gupnp_context_get_subscription_timeout: 'Get the event subscription timeout (resource context): int',
	gupnp_context_host_path: 'Start hosting (resource context, string local_path, string server_path): bool',
	gupnp_context_new: 'Create a new context ([string host_ip, [int port]]): resource',
	gupnp_context_set_subscription_timeout: 'Sets the event subscription timeout (resource context, int timeout): null',
	gupnp_context_timeout_add: 'Sets a function to be called at regular intervals (resource context, int timeout, mixed callback, [mixed arg]): bool',
	gupnp_context_unhost_path: 'Stop hosting (resource context, string server_path): bool',
	gupnp_control_point_browse_start: 'Start browsing (resource cpoint): bool',
	gupnp_control_point_browse_stop: 'Stop browsing (resource cpoint): bool',
	gupnp_control_point_callback_set: 'Set control point callback (resource cpoint, int signal, mixed callback, [mixed arg]): bool',
	gupnp_control_point_new: 'Create a new control point (resource context, string target): resource',
	gupnp_device_action_callback_set: 'Set device callback function (resource root_device, int signal, string action_name, mixed callback, [mixed arg]): bool',
	gupnp_device_info_get_service: 'Get the service with type (resource root_device, string type): resource',
	gupnp_device_info_get: 'Get info of root device (resource root_device): array',
	gupnp_root_device_get_available: 'Check whether root device is available (resource root_device): bool',
	gupnp_root_device_get_relative_location: 'Get the relative location of root device. (resource root_device): string',
	gupnp_root_device_new: 'Create a new root device (resource context, string location): resource',
	gupnp_root_device_set_available: 'Set whether or not root_device is available (resource root_device, bool available): bool',
	gupnp_root_device_start: 'Start main loop (resource root_device): bool',
	gupnp_root_device_stop: 'Stop main loop (resource root_device): bool',
	gupnp_service_action_get: 'Retrieves the specified action arguments (resource action, string name, int type): mixed',
	gupnp_service_action_return_error: 'Return error code (resource action, int error_code, [string error_description]): bool',
	gupnp_service_action_return: 'Return succesfully (resource action): bool',
	gupnp_service_action_set: 'Sets the specified action return values (resource action, string name, int type, mixed value): bool',
	gupnp_service_freeze_notify: 'Freeze new notifications (resource service): bool',
	gupnp_service_info_get_introspection: 'Get resource introspection of service (resource proxy, [mixed callback, [mixed arg]]): mixed',
	gupnp_service_info_get: 'Get full info of service (resource proxy): array',
	gupnp_service_introspection_get_state_variable: 'Returns the state variable data (resource introspection, string variable_name): array',
	gupnp_service_notify: 'Notifies listening clients (resource service, string name, int type, mixed value): bool',
	gupnp_service_proxy_action_get: 'Send action to the service and get value (resource proxy, string action, string name, int type): mixed',
	gupnp_service_proxy_action_set: 'Send action to the service and set value (resource proxy, string action, string name, mixed value, int type): bool',
	gupnp_service_proxy_add_notify: 'Sets up callback for variable change notification (resource proxy, string value, int type, mixed callback, [mixed arg]): bool',
	gupnp_service_proxy_callback_set: 'Set service proxy callback for signal (resource proxy, int signal, mixed callback, [mixed arg]): bool',
	gupnp_service_proxy_get_subscribed: 'Check whether subscription is valid to the service (resource proxy): bool',
	gupnp_service_proxy_remove_notify: 'Cancels the variable change notification (resource proxy, string value): bool',
	gupnp_service_proxy_send_action: 'Send action with multiple parameters synchronously (resource proxy, string action, array in_params, array out_params): array',
	gupnp_service_proxy_set_subscribed: '(Un)subscribes to the service. (resource proxy, bool subscribed): bool',
	gupnp_service_thaw_notify: 'Sends out any pending notifications and stops queuing of new ones. (resource service): bool',
	hash_algos: 'Return a list of registered hashing algorithms (): array',
	hash_copy: 'Copy hashing context (resource context): resource',
	hash_file: 'Generate a hash value using the contents of a given file (string algo, string filename, [bool raw_output]): string',
	hash_final: 'Finalize an incremental hash and return resulting digest (resource context, [bool raw_output]): string',
	hash_hmac_file: 'Generate a keyed hash value using the HMAC method and the contents of a given file (string algo, string filename, string key, [bool raw_output]): string',
	hash_hmac: 'Generate a keyed hash value using the HMAC method (string algo, string data, string key, [bool raw_output]): string',
	hash_init: 'Initialize an incremental hashing context (string algo, [int options, [string key]]): resource',
	hash_update_file: 'Pump data into an active hashing context from a file (resource context, string filename, [resource context]): bool',
	hash_update_stream: 'Pump data into an active hashing context from an open stream (resource context, resource handle, [int length]): int',
	hash_update: 'Pump data into an active hashing context (resource context, string data): bool',
	hash: 'Generate a hash value (message digest) (string algo, string data, [bool raw_output]): string',
	hw_array2objrec: 'Convert attributes from object array to object record (array object_array): string',
	hw_changeobject: 'Changes attributes of an object (obsolete) (int link, int objid, array attributes): bool',
	hw_children: 'Object ids of children (int connection, int objectID): array',
	hw_childrenobj: 'Object records of children (int connection, int objectID): array',
	hw_close: 'Closes the Hyperwave connection (int connection): bool',
	hw_connect: 'Opens a connection (string host, int port, [string username], string password): int',
	hw_connection_info: 'Prints information about the connection to Hyperwave server (int link): null',
	hw_cp: 'Copies objects (int connection, array object_id_array, int destination_id): int',
	hw_deleteobject: 'Deletes object (int connection, int object_to_delete): bool',
	hw_docbyanchor: 'Object id object belonging to anchor (int connection, int anchorID): int',
	hw_docbyanchorobj: 'Object record object belonging to anchor (int connection, int anchorID): string',
	hw_document_attributes: 'Object record of hw_document (int hw_document): string',
	hw_document_bodytag: 'Body tag of hw_document (int hw_document, [string prefix]): string',
	hw_document_content: 'Returns content of hw_document (int hw_document): string',
	hw_document_setcontent: 'Sets/replaces content of hw_document (int hw_document, string content): bool',
	hw_document_size: 'Size of hw_document (int hw_document): int',
	hw_dummy: 'Hyperwave dummy function (int link, int id, int msgid): string',
	hw_edittext: 'Retrieve text document (int connection, int hw_document): bool',
	hw_error: 'Error number (int connection): int',
	hw_errormsg: 'Returns error message (int connection): string',
	hw_free_document: 'Frees hw_document (int hw_document): bool',
	hw_getanchors: 'Object ids of anchors of document (int connection, int objectID): array',
	hw_getanchorsobj: 'Object records of anchors of document (int connection, int objectID): array',
	hw_getandlock: 'Return object record and lock object (int connection, int objectID): string',
	hw_getchildcoll: 'Object ids of child collections (int connection, int objectID): array',
	hw_getchildcollobj: 'Object records of child collections (int connection, int objectID): array',
	hw_getchilddoccoll: 'Object ids of child documents of collection (int connection, int objectID): array',
	hw_getchilddoccollobj: 'Object records of child documents of collection (int connection, int objectID): array',
	hw_getobject: 'Object record (int connection, mixed objectID, [string query]): mixed',
	hw_getobjectbyquery: 'Search object (int connection, string query, int max_hits): array',
	hw_getobjectbyquerycoll: 'Search object in collection (int connection, int objectID, string query, int max_hits): array',
	hw_getobjectbyquerycollobj: 'Search object in collection (int connection, int objectID, string query, int max_hits): array',
	hw_getobjectbyqueryobj: 'Search object (int connection, string query, int max_hits): array',
	hw_getparents: 'Object ids of parents (int connection, int objectID): array',
	hw_getparentsobj: 'Object records of parents (int connection, int objectID): array',
	hw_getrellink: 'Get link from source to dest relative to rootid (int link, int rootid, int sourceid, int destid): string',
	hw_getremote: 'Gets a remote document (int connection, int objectID): int',
	hw_getremotechildren: 'Gets children of remote document (int connection, string object_record): mixed',
	hw_getsrcbydestobj: 'Returns anchors pointing at object (int connection, int objectID): array',
	hw_gettext: 'Retrieve text document (int connection, int objectID, [mixed rootID/prefix]): int',
	hw_getusername: 'Name of currently logged in user (int connection): string',
	hw_identify: 'Identifies as user (int link, string username, string password): string',
	hw_incollections: 'Check if object ids in collections (int connection, array object_id_array, array collection_id_array, int return_collections): array',
	hw_info: 'Info about connection (int connection): string',
	hw_inscoll: 'Insert collection (int connection, int objectID, array object_array): int',
	hw_insdoc: 'Insert document (resource connection, int parentID, string object_record, [string text]): int',
	hw_insertanchors: 'Inserts only anchors into text (int hwdoc, array anchorecs, array dest, [array urlprefixes]): bool',
	hw_insertdocument: 'Upload any document (int connection, int parent_id, int hw_document): int',
	hw_insertobject: 'Inserts an object record (int connection, string object_rec, string parameter): int',
	hw_mapid: 'Maps global id on virtual local id (int connection, int server_id, int object_id): int',
	hw_modifyobject: 'Modifies object record (int connection, int object_to_change, array remove, array add, [int mode]): bool',
	hw_mv: 'Moves objects (int connection, array object_id_array, int source_id, int destination_id): int',
	hw_new_document: 'Create new document (string object_record, string document_data, int document_size): int',
	hw_objrec2array: 'Convert attributes from object record to object array (string object_record, [array format]): array',
	hw_output_document: 'Prints hw_document (int hw_document): bool',
	hw_pconnect: 'Make a persistent database connection (string host, int port, [string username], string password): int',
	hw_pipedocument: 'Retrieve any document (int connection, int objectID, [array url_prefixes]): int',
	hw_root: 'Root object id (): int',
	hw_setlinkroot: 'Set the id to which links are calculated (int link, int rootid): int',
	hw_stat: 'Returns status string (int link): string',
	hw_unlock: 'Unlock object (int connection, int objectID): bool',
	hw_who: 'List of currently logged in users (int connection): array',
	hw_api_attribute: 'Creates instance of class hw_api_attribute ([string name, [string value]]): HW_API_Attribute',
	hwapi_hgcsp: 'Returns object of class hw_api (string hostname, [int port]): HW_API',
	hw_api_content: 'Create new instance of class hw_api_content (string content, string mimetype): HW_API_Content',
	hw_api_object: 'Creates a new instance of class hw_api_object (array parameter): hw_api_object',
	locale_get_default: 'Get the default Locale (): string',
	locale_set_default: 'Set the default Locale (string name): bool',
	ibase_add_user: 'Add a user to a security database (only for IB6 or later) (resource service_handle, string user_name, string password, [string first_name, [string middle_name, [string last_name]]]): bool',
	ibase_affected_rows: 'Return the number of rows that were affected by the previous query ([resource link_identifier]): int',
	ibase_backup: 'Initiates a backup task in the service manager and returns immediately (resource service_handle, string source_db, string dest_file, [int options, [bool verbose]]): mixed',
	ibase_blob_add: 'Add data into a newly created blob (resource blob_handle, string data): null',
	ibase_blob_cancel: 'Cancel creating blob (resource blob_handle): bool',
	ibase_blob_close: 'Close blob (resource blob_handle): mixed',
	ibase_blob_create: 'Create a new blob for adding data ([resource link_identifier]): resource',
	ibase_blob_echo: 'Output blob contents to browser (string blob_id): bool',
	ibase_blob_echo: 'Output blob contents to browser (resource link_identifier, string blob_id): bool',
	ibase_blob_get: 'Get len bytes data from open blob (resource blob_handle, int len): string',
	ibase_blob_import: 'Create blob, copy file in it, and close it (resource link_identifier, resource file_handle): string',
	ibase_blob_import: 'Create blob, copy file in it, and close it (resource file_handle): string',
	ibase_blob_info: 'Return blob length and other useful info (resource link_identifier, string blob_id): array',
	ibase_blob_info: 'Return blob length and other useful info (string blob_id): array',
	ibase_blob_open: 'Open blob for retrieving data parts (resource link_identifier, string blob_id): resource',
	ibase_blob_open: 'Open blob for retrieving data parts (string blob_id): resource',
	ibase_close: 'Close a connection to an InterBase database ([resource connection_id]): bool',
	ibase_commit_ret: 'Commit a transaction without closing it ([resource link_or_trans_identifier]): bool',
	ibase_commit: 'Commit a transaction ([resource link_or_trans_identifier]): bool',
	ibase_connect: 'Open a connection to an InterBase database ([string database, [string username, [string password, [string charset, [int buffers, [int dialect, [string role, [int sync]]]]]]]]): resource',
	ibase_db_info: 'Request statistics about a database (resource service_handle, string db, int action, [int argument]): string',
	ibase_delete_user: 'Delete a user from a security database (only for IB6 or later) (resource service_handle, string user_name): bool',
	ibase_drop_db: 'Drops a database ([resource connection]): bool',
	ibase_errcode: 'Return an error code (): int',
	ibase_errmsg: 'Return error messages (): string',
	ibase_execute: 'Execute a previously prepared query (resource query, [mixed bind_arg, [mixed ...]]): resource',
	ibase_fetch_assoc: 'Fetch a result row from a query as an associative array (resource result, [int fetch_flag]): array',
	ibase_fetch_object: 'Get an object from a InterBase database (resource result_id, [int fetch_flag]): object',
	ibase_fetch_row: 'Fetch a row from an InterBase database (resource result_identifier, [int fetch_flag]): array',
	ibase_field_info: 'Get information about a field (resource result, int field_number): array',
	ibase_free_event_handler: 'Cancels a registered event handler (resource event): bool',
	ibase_free_query: 'Free memory allocated by a prepared query (resource query): bool',
	ibase_free_result: 'Free a result set (resource result_identifier): bool',
	ibase_gen_id: 'Increments the named generator and returns its new value (string generator, [int increment, [resource link_identifier]]): mixed',
	ibase_maintain_db: 'Execute a maintenance command on the database server (resource service_handle, string db, int action, [int argument]): bool',
	ibase_modify_user: 'Modify a user to a security database (only for IB6 or later) (resource service_handle, string user_name, string password, [string first_name, [string middle_name, [string last_name]]]): bool',
	ibase_name_result: 'Assigns a name to a result set (resource result, string name): bool',
	ibase_num_fields: 'Get the number of fields in a result set (resource result_id): int',
	ibase_num_params: 'Return the number of parameters in a prepared query (resource query): int',
	ibase_param_info: 'Return information about a parameter in a prepared query (resource query, int param_number): array',
	ibase_pconnect: 'Open a persistent connection to an InterBase database ([string database, [string username, [string password, [string charset, [int buffers, [int dialect, [string role, [int sync]]]]]]]]): resource',
	ibase_prepare: 'Prepare a query for later binding of parameter placeholders and execution (string query): resource',
	ibase_prepare: 'Prepare a query for later binding of parameter placeholders and execution (resource link_identifier, string query): resource',
	ibase_prepare: 'Prepare a query for later binding of parameter placeholders and execution (resource link_identifier, string trans, string query): resource',
	ibase_query: 'Execute a query on an InterBase database ([resource link_identifier], string query, [int bind_args]): resource',
	ibase_restore: 'Initiates a restore task in the service manager and returns immediately (resource service_handle, string source_file, string dest_db, [int options, [bool verbose]]): mixed',
	ibase_rollback_ret: 'Roll back a transaction without closing it ([resource link_or_trans_identifier]): bool',
	ibase_rollback: 'Roll back a transaction ([resource link_or_trans_identifier]): bool',
	ibase_server_info: 'Request information about a database server (resource service_handle, int action): string',
	ibase_service_attach: 'Connect to the service manager (string host, string dba_username, string dba_password): resource',
	ibase_service_detach: 'Disconnect from the service manager (resource service_handle): bool',
	ibase_set_event_handler: 'Register a callback function to be called when events are posted (callback event_handler, string event_name1, [string event_name2, [string ...]]): resource',
	ibase_set_event_handler: 'Register a callback function to be called when events are posted (resource connection, callback event_handler, string event_name1, [string event_name2, [string ...]]): resource',
	ibase_timefmt: 'Sets the format of timestamp, date and time type columns returned from queries (string format, [int columntype]): bool',
	ibase_trans: 'Begin a transaction ([int trans_args, [resource link_identifier]]): resource',
	ibase_trans: 'Begin a transaction ([resource link_identifier, [int trans_args]]): resource',
	ibase_wait_event: 'Wait for an event to be posted by the database (string event_name1, [string event_name2, [string ...]]): string',
	ibase_wait_event: 'Wait for an event to be posted by the database (resource connection, string event_name1, [string event_name2, [string ...]]): string',
	db2_autocommit: 'Returns or sets the AUTOCOMMIT state for a database connection (resource connection, [bool value]): mixed',
	db2_bind_param: 'Binds a PHP variable to an SQL statement parameter (resource stmt, int parameter-number, string variable-name, [int parameter-type, [int data-type, [int precision, [int scale]]]]): bool',
	db2_client_info: 'Returns an object with properties that describe the DB2 database client (resource connection): object',
	db2_close: 'Closes a database connection (resource connection): bool',
	db2_column_privileges: 'Returns a result set listing the columns and associated privileges for a table (resource connection, [string qualifier, [string schema, [string table-name, [string column-name]]]]): resource',
	db2_columns: 'Returns a result set listing the columns and associated metadata for a table (resource connection, [string qualifier, [string schema, [string table-name, [string column-name]]]]): resource',
	db2_commit: 'Commits a transaction (resource connection): bool',
	db2_conn_error: 'Returns a string containing the SQLSTATE returned by the last connection attempt ([resource connection]): string',
	db2_conn_errormsg: 'Returns the last connection error message and SQLCODE value ([resource connection]): string',
	db2_connect: 'Returns a connection to a database (string database, string username, string password, [array options]): resource',
	db2_cursor_type: 'Returns the cursor type used by a statement resource (resource stmt): int',
	db2_escape_string: 'Used to escape certain characters (string string_literal): string',
	db2_exec: 'Executes an SQL statement directly (resource connection, string statement, [array options]): resource',
	db2_execute: 'Executes a prepared SQL statement (resource stmt, [array parameters]): bool',
	db2_fetch_array: 'Returns an array, indexed by column position, representing a row in a result set (resource stmt, [int row_number]): array',
	db2_fetch_assoc: 'Returns an array, indexed by column name, representing a row in a result set (resource stmt, [int row_number]): array',
	db2_fetch_both: 'Returns an array, indexed by both column name and position, representing a row in a result set (resource stmt, [int row_number]): array',
	db2_fetch_object: 'Returns an object with properties representing columns in the fetched row (resource stmt, [int row_number]): object',
	db2_fetch_row: 'Sets the result set pointer to the next row or requested row (resource stmt, [int row_number]): bool',
	db2_field_display_size: 'Returns the maximum number of bytes required to display a column (resource stmt, mixed column): int',
	db2_field_name: 'Returns the name of the column in the result set (resource stmt, mixed column): string',
	db2_field_num: 'Returns the position of the named column in a result set (resource stmt, mixed column): int',
	db2_field_precision: 'Returns the precision of the indicated column in a result set (resource stmt, mixed column): int',
	db2_field_scale: 'Returns the scale of the indicated column in a result set (resource stmt, mixed column): int',
	db2_field_type: 'Returns the data type of the indicated column in a result set (resource stmt, mixed column): string',
	db2_field_width: 'Returns the width of the current value of the indicated column in a result set (resource stmt, mixed column): int',
	db2_foreign_keys: 'Returns a result set listing the foreign keys for a table (resource connection, string qualifier, string schema, string table-name): resource',
	db2_free_result: 'Frees resources associated with a result set (resource stmt): bool',
	db2_free_stmt: 'Frees resources associated with the indicated statement resource (resource stmt): bool',
	db2_get_option: 'Retrieves an option value for a statement resource or a connection resource (resource resource, string option): string',
	db2_last_insert_id: 'Returns the auto generated ID of the last insert query that successfully executed on this connection (resource resource): int',
	db2_lob_read: 'Gets a user defined size of LOB files with each invocation (resource stmt, int colnum, int length): string',
	db2_next_result: 'Requests the next result set from a stored procedure (resource stmt): resource',
	db2_num_fields: 'Returns the number of fields contained in a result set (resource stmt): int',
	db2_num_rows: 'Returns the number of rows affected by an SQL statement (resource stmt): int',
	db2_pclose: 'Closes a persistent database connection (resource resource): bool',
	db2_pconnect: 'Returns a persistent connection to a database (string database, string username, string password, [array options]): resource',
	db2_prepare: 'Prepares an SQL statement to be executed (resource connection, string statement, [array options]): resource',
	db2_primary_keys: 'Returns a result set listing primary keys for a table (resource connection, string qualifier, string schema, string table-name): resource',
	db2_procedure_columns: 'Returns a result set listing stored procedure parameters (resource connection, string qualifier, string schema, string procedure, string parameter): resource',
	db2_procedures: 'Returns a result set listing the stored procedures registered in a database (resource connection, string qualifier, string schema, string procedure): resource',
	db2_result: 'Returns a single column from a row in the result set (resource stmt, mixed column): mixed',
	db2_rollback: 'Rolls back a transaction (resource connection): bool',
	db2_server_info: 'Returns an object with properties that describe the DB2 database server (resource connection): object',
	db2_set_option: 'Set options for connection or statement resources (resource resource, array options, int type): bool',
	db2_special_columns: 'Returns a result set listing the unique row identifier columns for a table (resource connection, string qualifier, string schema, string table_name, int scope): resource',
	db2_statistics: 'Returns a result set listing the index and statistics for a table (resource connection, string qualifier, string schema, string table-name, bool unique): resource',
	db2_stmt_error: 'Returns a string containing the SQLSTATE returned by an SQL statement ([resource stmt]): string',
	db2_stmt_errormsg: 'Returns a string containing the last SQL statement error message ([resource stmt]): string',
	db2_table_privileges: 'Returns a result set listing the tables and associated privileges in a database (resource connection, [string qualifier, [string schema, [string table_name]]]): resource',
	db2_tables: 'Returns a result set listing the tables and associated metadata in a database (resource connection, [string qualifier, [string schema, [string table-name, [string table-type]]]]): resource',
	iconv_get_encoding: 'Retrieve internal configuration variables of iconv extension ([string type]): mixed',
	iconv_mime_decode_headers: 'Decodes multiple MIME header fields at once (string encoded_headers, [int mode, [string charset]]): array',
	iconv_mime_decode: 'Decodes a MIME header field (string encoded_header, [int mode, [string charset]]): string',
	iconv_mime_encode: 'Composes a MIME header field (string field_name, string field_value, [array preferences]): string',
	iconv_set_encoding: 'Set current setting for character encoding conversion (string type, string charset): bool',
	iconv_strlen: 'Returns the character count of string (string str, [string charset]): int',
	iconv_strpos: 'Finds position of first occurrence of a needle within a haystack (string haystack, string needle, [int offset, [string charset]]): int',
	iconv_strrpos: 'Finds the last occurrence of a needle within a haystack (string haystack, string needle, [string charset]): int',
	iconv_substr: 'Cut out part of a string (string str, int offset, [int length, [string charset]]): string',
	iconv: 'Convert string to requested character encoding (string in_charset, string out_charset, string str): string',
	ob_iconv_handler: 'Convert character encoding as output buffer handler (string contents, int status): string',
	id3_get_frame_long_name: 'Get the long name of an ID3v2 frame (string frameId): string',
	id3_get_frame_short_name: 'Get the short name of an ID3v2 frame (string frameId): string',
	id3_get_genre_id: 'Get the id for a genre (string genre): int',
	id3_get_genre_list: 'Get all possible genre values (): array',
	id3_get_genre_name: 'Get the name for a genre id (int genre_id): string',
	id3_get_tag: 'Get all information stored in an ID3 tag (string filename, [int version]): array',
	id3_get_version: 'Get version of an ID3 tag (string filename): int',
	id3_remove_tag: 'Remove an existing ID3 tag (string filename, [int version]): bool',
	id3_set_tag: 'Update information stored in an ID3 tag (string filename, array tag, [int version]): bool',
	idn_strerror: 'Returns string describing the IDNA error code (int errorcode): string',
	idn_to_ascii: 'Convert UTF-8 encoded domain name to ASCII (string utf8_domain, [int &errorcode]): string',
	idn_to_utf8: 'Convert ASCII encoded domain name to UTF-8 (string ascii_domain, [int &errorcode]): string',
	ifx_affected_rows: 'Get number of rows affected by a query (resource result_id): int',
	ifx_blobinfile_mode: 'Set the default blob mode for all select queries (int mode): bool',
	ifx_byteasvarchar: 'Set the default byte mode (int mode): bool',
	ifx_close: 'Close Informix connection ([resource link_identifier]): bool',
	ifx_connect: 'Open Informix server connection ([string database, [string userid, [string password]]]): resource',
	ifx_copy_blob: 'Duplicates the given blob object (int bid): int',
	ifx_create_blob: 'Creates an blob object (int type, int mode, string param): int',
	ifx_create_char: 'Creates an char object (string param): int',
	ifx_do: 'Execute a previously prepared SQL-statement (resource result_id): bool',
	ifx_error: 'Returns error code of last Informix call ([resource link_identifier]): string',
	ifx_errormsg: 'Returns error message of last Informix call ([int errorcode]): string',
	ifx_fetch_row: 'Get row as an associative array (resource result_id, [mixed position]): array',
	ifx_fieldproperties: 'List of SQL fieldproperties (resource result_id): array',
	ifx_fieldtypes: 'List of Informix SQL fields (resource result_id): array',
	ifx_free_blob: 'Deletes the blob object (int bid): bool',
	ifx_free_char: 'Deletes the char object (int bid): bool',
	ifx_free_result: 'Releases resources for the query (resource result_id): bool',
	ifx_get_blob: 'Return the content of a blob object (int bid): string',
	ifx_get_char: 'Return the content of the char object (int bid): string',
	ifx_getsqlca: 'Get the contents of sqlca.sqlerrd[0..5] after a query (resource result_id): array',
	ifx_htmltbl_result: 'Formats all rows of a query into a HTML table (resource result_id, [string html_table_options]): int',
	ifx_nullformat: 'Sets the default return value on a fetch row (int mode): bool',
	ifx_num_fields: 'Returns the number of columns in the query (resource result_id): int',
	ifx_num_rows: 'Count the rows already fetched from a query (resource result_id): int',
	ifx_pconnect: 'Open persistent Informix connection ([string database, [string userid, [string password]]]): resource',
	ifx_prepare: 'Prepare an SQL-statement for execution (string query, resource link_identifier, [int cursor_def], mixed blobidarray): resource',
	ifx_query: 'Send Informix query (string query, resource link_identifier, [int cursor_type, [mixed blobidarray]]): resource',
	ifx_textasvarchar: 'Set the default text mode (int mode): bool',
	ifx_update_blob: 'Updates the content of the blob object (int bid, string content): bool',
	ifx_update_char: 'Updates the content of the char object (int bid, string content): bool',
	ifxus_close_slob: 'Deletes the slob object (int bid): bool',
	ifxus_create_slob: 'Creates an slob object and opens it (int mode): int',
	ifxus_free_slob: 'Deletes the slob object (int bid): bool',
	ifxus_open_slob: 'Opens an slob object (int bid, int mode): int',
	ifxus_read_slob: 'Reads nbytes of the slob object (int bid, int nbytes): string',
	ifxus_seek_slob: 'Sets the current file or seek position (int bid, int mode, int offset): int',
	ifxus_tell_slob: 'Returns the current file or seek position (int bid): int',
	ifxus_write_slob: 'Writes a string into the slob object (int bid, string content): int',
	iis_add_server: 'Creates a new virtual web server (string path, string comment, string server_ip, int port, string host_name, int rights, int start_server): int',
	iis_get_dir_security: 'Gets Directory Security (int server_instance, string virtual_path): int',
	iis_get_script_map: 'Gets script mapping on a virtual directory for a specific extension (int server_instance, string virtual_path, string script_extension): string',
	iis_get_server_by_comment: 'Return the instance number associated with the Comment (string comment): int',
	iis_get_server_by_path: 'Return the instance number associated with the Path (string path): int',
	iis_get_server_rights: 'Gets server rights (int server_instance, string virtual_path): int',
	iis_get_service_state: 'Returns the state for the service defined by ServiceId (string service_id): int',
	iis_remove_server: 'Removes the virtual web server indicated by ServerInstance (int server_instance): int',
	iis_set_app_settings: 'Creates application scope for a virtual directory (int server_instance, string virtual_path, string application_scope): int',
	iis_set_dir_security: 'Sets Directory Security (int server_instance, string virtual_path, int directory_flags): int',
	iis_set_script_map: 'Sets script mapping on a virtual directory (int server_instance, string virtual_path, string script_extension, string engine_path, int allow_scripting): int',
	iis_set_server_rights: 'Sets server rights (int server_instance, string virtual_path, int directory_flags): int',
	iis_start_server: 'Starts the virtual web server (int server_instance): int',
	iis_start_service: 'Starts the service defined by ServiceId (string service_id): int',
	iis_stop_server: 'Stops the virtual web server (int server_instance): int',
	iis_stop_service: 'Stops the service defined by ServiceId (string service_id): int',
	gd_info: 'Retrieve information about the currently installed GD library (): array',
	getimagesize: 'Get the size of an image (string filename, [array &imageinfo]): array',
	image_type_to_extension: 'Get file extension for image type (int imagetype, [bool include_dot]): string',
	image_type_to_mime_type: 'Get Mime-Type for image-type returned by getimagesize, exif_read_data, exif_thumbnail, exif_imagetype (int imagetype): string',
	image2wbmp: 'Output image to browser or file (resource image, [string filename, [int threshold]]): bool',
	imagealphablending: 'Set the blending mode for an image (resource image, bool blendmode): bool',
	imageantialias: 'Should antialias functions be used or not (resource image, bool enabled): bool',
	imagearc: 'Draws an arc (resource image, int cx, int cy, int width, int height, int start, int end, int color): bool',
	imagechar: 'Draw a character horizontally (resource image, int font, int x, int y, string c, int color): bool',
	imagecharup: 'Draw a character vertically (resource image, int font, int x, int y, string c, int color): bool',
	imagecolorallocate: 'Allocate a color for an image (resource image, int red, int green, int blue): int',
	imagecolorallocatealpha: 'Allocate a color for an image (resource image, int red, int green, int blue, int alpha): int',
	imagecolorat: 'Get the index of the color of a pixel (resource image, int x, int y): int',
	imagecolorclosest: 'Get the index of the closest color to the specified color (resource image, int red, int green, int blue): int',
	imagecolorclosestalpha: 'Get the index of the closest color to the specified color + alpha (resource image, int red, int green, int blue, int alpha): int',
	imagecolorclosesthwb: 'Get the index of the color which has the hue, white and blackness (resource image, int red, int green, int blue): int',
	imagecolordeallocate: 'De-allocate a color for an image (resource image, int color): bool',
	imagecolorexact: 'Get the index of the specified color (resource image, int red, int green, int blue): int',
	imagecolorexactalpha: 'Get the index of the specified color + alpha (resource image, int red, int green, int blue, int alpha): int',
	imagecolormatch: 'Makes the colors of the palette version of an image more closely match the true color version (resource image1, resource image2): bool',
	imagecolorresolve: 'Get the index of the specified color or its closest possible alternative (resource image, int red, int green, int blue): int',
	imagecolorresolvealpha: 'Get the index of the specified color + alpha or its closest possible alternative (resource image, int red, int green, int blue, int alpha): int',
	imagecolorset: 'Set the color for the specified palette index (resource image, int index, int red, int green, int blue): null',
	imagecolorsforindex: 'Get the colors for an index (resource image, int index): array',
	imagecolorstotal: 'Find out the number of colors in an image\'s palette (resource image): int',
	imagecolortransparent: 'Define a color as transparent (resource image, [int color]): int',
	imageconvolution: 'Apply a 3x3 convolution matrix, using coefficient and offset (resource image, array matrix, float div, float offset): bool',
	imagecopy: 'Copy part of an image (resource dst_im, resource src_im, int dst_x, int dst_y, int src_x, int src_y, int src_w, int src_h): bool',
	imagecopymerge: 'Copy and merge part of an image (resource dst_im, resource src_im, int dst_x, int dst_y, int src_x, int src_y, int src_w, int src_h, int pct): bool',
	imagecopymergegray: 'Copy and merge part of an image with gray scale (resource dst_im, resource src_im, int dst_x, int dst_y, int src_x, int src_y, int src_w, int src_h, int pct): bool',
	imagecopyresampled: 'Copy and resize part of an image with resampling (resource dst_image, resource src_image, int dst_x, int dst_y, int src_x, int src_y, int dst_w, int dst_h, int src_w, int src_h): bool',
	imagecopyresized: 'Copy and resize part of an image (resource dst_image, resource src_image, int dst_x, int dst_y, int src_x, int src_y, int dst_w, int dst_h, int src_w, int src_h): bool',
	imagecreate: 'Create a new palette based image (int width, int height): resource',
	imagecreatefromgd: 'Create a new image from GD file or URL (string filename): resource',
	imagecreatefromgd2: 'Create a new image from GD2 file or URL (string filename): resource',
	imagecreatefromgd2part: 'Create a new image from a given part of GD2 file or URL (string filename, int srcX, int srcY, int width, int height): resource',
	imagecreatefromgif: 'Create a new image from file or URL (string filename): resource',
	imagecreatefromjpeg: 'Create a new image from file or URL (string filename): resource',
	imagecreatefrompng: 'Create a new image from file or URL (string filename): resource',
	imagecreatefromstring: 'Create a new image from the image stream in the string (string data): resource',
	imagecreatefromwbmp: 'Create a new image from file or URL (string filename): resource',
	imagecreatefromxbm: 'Create a new image from file or URL (string filename): resource',
	imagecreatefromxpm: 'Create a new image from file or URL (string filename): resource',
	imagecreatetruecolor: 'Create a new true color image (int width, int height): resource',
	imagedashedline: 'Draw a dashed line (resource image, int x1, int y1, int x2, int y2, int color): bool',
	imagedestroy: 'Destroy an image (resource image): bool',
	imageellipse: 'Draw an ellipse (resource image, int cx, int cy, int width, int height, int color): bool',
	imagefill: 'Flood fill (resource image, int x, int y, int color): bool',
	imagefilledarc: 'Draw a partial arc and fill it (resource image, int cx, int cy, int width, int height, int start, int end, int color, int style): bool',
	imagefilledellipse: 'Draw a filled ellipse (resource image, int cx, int cy, int width, int height, int color): bool',
	imagefilledpolygon: 'Draw a filled polygon (resource image, array points, int num_points, int color): bool',
	imagefilledrectangle: 'Draw a filled rectangle (resource image, int x1, int y1, int x2, int y2, int color): bool',
	imagefilltoborder: 'Flood fill to specific color (resource image, int x, int y, int border, int color): bool',
	imagefilter: 'Applies a filter to an image (resource image, int filtertype, [int arg1, [int arg2, [int arg3, [int arg4]]]]): bool',
	imagefontheight: 'Get font height (int font): int',
	imagefontwidth: 'Get font width (int font): int',
	imageftbbox: 'Give the bounding box of a text using fonts via freetype2 (float size, float angle, string fontfile, string text, [array extrainfo]): array',
	imagefttext: 'Write text to the image using fonts using FreeType 2 (resource image, float size, float angle, int x, int y, int color, string fontfile, string text, [array extrainfo]): array',
	imagegammacorrect: 'Apply a gamma correction to a GD image (resource image, float inputgamma, float outputgamma): bool',
	imagegd: 'Output GD image to browser or file (resource image, [string filename]): bool',
	imagegd2: 'Output GD2 image to browser or file (resource image, [string filename, [int chunk_size, [int type]]]): bool',
	imagegif: 'Output image to browser or file (resource image, [string filename]): bool',
	imagegrabscreen: 'Captures the whole screen (): resource',
	imagegrabwindow: 'Captures a window (int window_handle, [int client_area]): resource',
	imageinterlace: 'Enable or disable interlace (resource image, [int interlace]): int',
	imageistruecolor: 'Finds whether an image is a truecolor image (resource image): bool',
	imagejpeg: 'Output image to browser or file (resource image, [string filename, [int quality]]): bool',
	imagelayereffect: 'Set the alpha blending flag to use the bundled libgd layering effects (resource image, int effect): bool',
	imageline: 'Draw a line (resource image, int x1, int y1, int x2, int y2, int color): bool',
	imageloadfont: 'Load a new font (string file): int',
	imagepalettecopy: 'Copy the palette from one image to another (resource destination, resource source): null',
	imagepng: 'Output a PNG image to either the browser or a file (resource image, [string filename, [int quality, [int filters]]]): bool',
	imagepolygon: 'Draws a polygon (resource image, array points, int num_points, int color): bool',
	imagepsbbox: 'Give the bounding box of a text rectangle using PostScript Type1 fonts (string text, resource font, int size): array',
	imagepsbbox: 'Give the bounding box of a text rectangle using PostScript Type1 fonts (string text, resource font, int size, int space, int tightness, float angle): array',
	imagepsencodefont: 'Change the character encoding vector of a font (resource font_index, string encodingfile): bool',
	imagepsextendfont: 'Extend or condense a font (resource font_index, float extend): bool',
	imagepsfreefont: 'Free memory used by a PostScript Type 1 font (resource font_index): bool',
	imagepsloadfont: 'Load a PostScript Type 1 font from file (string filename): resource',
	imagepsslantfont: 'Slant a font (resource font_index, float slant): bool',
	imagepstext: 'Draws a text over an image using PostScript Type1 fonts (resource image, string text, resource font_index, int size, int foreground, int background, int x, int y, [int space, [int tightness, [float angle, [int antialias_steps]]]]): array',
	imagerectangle: 'Draw a rectangle (resource image, int x1, int y1, int x2, int y2, int color): bool',
	imagerotate: 'Rotate an image with a given angle (resource image, float angle, int bgd_color, [int ignore_transparent]): resource',
	imagesavealpha: 'Set the flag to save full alpha channel information (as opposed to single-color transparency) when saving PNG images (resource image, bool saveflag): bool',
	imagesetbrush: 'Set the brush image for line drawing (resource image, resource brush): bool',
	imagesetpixel: 'Set a single pixel (resource image, int x, int y, int color): bool',
	imagesetstyle: 'Set the style for line drawing (resource image, array style): bool',
	imagesetthickness: 'Set the thickness for line drawing (resource image, int thickness): bool',
	imagesettile: 'Set the tile image for filling (resource image, resource tile): bool',
	imagestring: 'Draw a string horizontally (resource image, int font, int x, int y, string string, int color): bool',
	imagestringup: 'Draw a string vertically (resource image, int font, int x, int y, string string, int color): bool',
	imagesx: 'Get image width (resource image): int',
	imagesy: 'Get image height (resource image): int',
	imagetruecolortopalette: 'Convert a true color image to a palette image (resource image, bool dither, int ncolors): bool',
	imagettfbbox: 'Give the bounding box of a text using TrueType fonts (float size, float angle, string fontfile, string text): array',
	imagettftext: 'Write text to the image using TrueType fonts (resource image, float size, float angle, int x, int y, int color, string fontfile, string text): array',
	imagetypes: 'Return the image types supported by this PHP build (): int',
	imagewbmp: 'Output image to browser or file (resource image, [string filename, [int foreground]]): bool',
	imagexbm: 'Output XBM image to browser or file (resource image, string filename, [int foreground]): bool',
	iptcembed: 'Embeds binary IPTC data into a JPEG image (string iptcdata, string jpeg_file_name, [int spool]): mixed',
	iptcparse: 'Parse a binary IPTC block into single tags. (string iptcblock): array',
	jpeg2wbmp: 'Convert JPEG image file to WBMP image file (string jpegname, string wbmpname, int dest_height, int dest_width, int threshold): bool',
	png2wbmp: 'Convert PNG image file to WBMP image file (string pngname, string wbmpname, int dest_height, int dest_width, int threshold): bool',
	imap_8bit: 'Convert an 8bit string to a quoted-printable string (string string): string',
	imap_alerts: 'Returns all IMAP alert messages that have occurred (): array',
	imap_append: 'Append a string message to a specified mailbox (resource imap_stream, string mailbox, string message, [string options, [string internal_date]]): bool',
	imap_base64: 'Decode BASE64 encoded text (string text): string',
	imap_binary: 'Convert an 8bit string to a base64 string (string string): string',
	imap_body: 'Read the message body (resource imap_stream, int msg_number, [int options]): string',
	imap_bodystruct: 'Read the structure of a specified body section of a specific message (resource imap_stream, int msg_number, string section): object',
	imap_check: 'Check current mailbox (resource imap_stream): object',
	imap_clearflag_full: 'Clears flags on messages (resource imap_stream, string sequence, string flag, [int options]): bool',
	imap_close: 'Close an IMAP stream (resource imap_stream, [int flag]): bool',
	imap_createmailbox: 'Create a new mailbox (resource imap_stream, string mailbox): bool',
	imap_delete: 'Mark a message for deletion from current mailbox (resource imap_stream, int msg_number, [int options]): bool',
	imap_deletemailbox: 'Delete a mailbox (resource imap_stream, string mailbox): bool',
	imap_errors: 'Returns all of the IMAP errors that have occured (): array',
	imap_expunge: 'Delete all messages marked for deletion (resource imap_stream): bool',
	imap_fetch_overview: 'Read an overview of the information in the headers of the given message (resource imap_stream, string sequence, [int options]): array',
	imap_fetchbody: 'Fetch a particular section of the body of the message (resource imap_stream, int msg_number, string section, [int options]): string',
	imap_fetchheader: 'Returns header for a message (resource imap_stream, int msg_number, [int options]): string',
	imap_fetchstructure: 'Read the structure of a particular message (resource imap_stream, int msg_number, [int options]): object',
	imap_gc: 'Clears IMAP cache (resource imap_stream, int caches): string',
	imap_get_quota: 'Retrieve the quota level settings, and usage statics per mailbox (resource imap_stream, string quota_root): array',
	imap_get_quotaroot: 'Retrieve the quota settings per user (resource imap_stream, string quota_root): array',
	imap_getacl: 'Gets the ACL for a given mailbox (resource imap_stream, string mailbox): array',
	imap_getmailboxes: 'Read the list of mailboxes, returning detailed information on each one (resource imap_stream, string ref, string pattern): array',
	imap_getsubscribed: 'List all the subscribed mailboxes (resource imap_stream, string ref, string pattern): array',
	imap_header: 'Alias of imap_headerinfo',
	imap_headerinfo: 'Read the header of the message (resource imap_stream, int msg_number, [int fromlength, [int subjectlength, [string defaulthost]]]): object',
	imap_headers: 'Returns headers for all messages in a mailbox (resource imap_stream): array',
	imap_last_error: 'Gets the last IMAP error that occurred during this page request (): string',
	imap_list: 'Read the list of mailboxes (resource imap_stream, string ref, string pattern): array',
	imap_listmailbox: 'Alias of imap_list',
	imap_listscan: 'Returns the list of mailboxes that matches the given text (resource imap_stream, string ref, string pattern, string content): array',
	imap_listsubscribed: 'Alias of imap_lsub',
	imap_lsub: 'List all the subscribed mailboxes (resource imap_stream, string ref, string pattern): array',
	imap_mail_compose: 'Create a MIME message based on given envelope and body sections (array envelope, array body): string',
	imap_mail_copy: 'Copy specified messages to a mailbox (resource imap_stream, string msglist, string mailbox, [int options]): bool',
	imap_mail_move: 'Move specified messages to a mailbox (resource imap_stream, string msglist, string mailbox, [int options]): bool',
	imap_mail: 'Send an email message (string to, string subject, string message, [string additional_headers, [string cc, [string bcc, [string rpath]]]]): bool',
	imap_mailboxmsginfo: 'Get information about the current mailbox (resource imap_stream): object',
	imap_mime_header_decode: 'Decode MIME header elements (string text): array',
	imap_msgno: 'Gets the message sequence number for the given UID (resource imap_stream, int uid): int',
	imap_num_msg: 'Gets the number of messages in the current mailbox (resource imap_stream): int',
	imap_num_recent: 'Gets the number of recent messages in current mailbox (resource imap_stream): int',
	imap_open: 'Open an IMAP stream to a mailbox (string mailbox, string username, string password, [int options, [int n_retries, [array params]]]): resource',
	imap_ping: 'Check if the IMAP stream is still active (resource imap_stream): bool',
	imap_qprint: 'Convert a quoted-printable string to an 8 bit string (string string): string',
	imap_renamemailbox: 'Rename an old mailbox to new mailbox (resource imap_stream, string old_mbox, string new_mbox): bool',
	imap_reopen: 'Reopen IMAP stream to new mailbox (resource imap_stream, string mailbox, [int options, [int n_retries]]): bool',
	imap_rfc822_parse_adrlist: 'Parses an address string (string address, string default_host): array',
	imap_rfc822_parse_headers: 'Parse mail headers from a string (string headers, [string defaulthost]): object',
	imap_rfc822_write_address: 'Returns a properly formatted email address given the mailbox, host, and personal info (string mailbox, string host, string personal): string',
	imap_savebody: 'Save a specific body section to a file (resource imap_stream, mixed file, int msg_number, [string part_number, [int options]]): bool',
	imap_scanmailbox: 'Alias of imap_listscan',
	imap_search: 'This function returns an array of messages matching the given search criteria (resource imap_stream, string criteria, [int options, [string charset]]): array',
	imap_set_quota: 'Sets a quota for a given mailbox (resource imap_stream, string quota_root, int quota_limit): bool',
	imap_setacl: 'Sets the ACL for a giving mailbox (resource imap_stream, string mailbox, string id, string rights): bool',
	imap_setflag_full: 'Sets flags on messages (resource imap_stream, string sequence, string flag, [int options]): bool',
	imap_sort: 'Gets and sort messages (resource imap_stream, int criteria, int reverse, [int options, [string search_criteria, [string charset]]]): array',
	imap_status: 'Returns status information on a mailbox (resource imap_stream, string mailbox, int options): object',
	imap_subscribe: 'Subscribe to a mailbox (resource imap_stream, string mailbox): bool',
	imap_thread: 'Returns a tree of threaded message (resource imap_stream, [int options]): array',
	imap_timeout: 'Set or fetch imap timeout (int timeout_type, [int timeout]): mixed',
	imap_uid: 'This function returns the UID for the given message sequence number (resource imap_stream, int msg_number): int',
	imap_undelete: 'Unmark the message which is marked deleted (resource imap_stream, int msg_number, [int flags]): bool',
	imap_unsubscribe: 'Unsubscribe from a mailbox (resource imap_stream, string mailbox): bool',
	imap_utf7_decode: 'Decodes a modified UTF-7 encoded string (string text): string',
	imap_utf7_encode: 'Converts ISO-8859-1 string to modified UTF-7 text (string data): string',
	imap_utf8: 'Converts MIME-encoded text to UTF-8 (string mime_encoded_text): string',
	inclued_get_data: 'Get the inclued data (): array',
	assert_options: 'Set/get the various assert flags (int what, [mixed value]): mixed',
	assert: 'Checks if assertion is FALSE (mixed assertion): bool',
	dl: 'Loads a PHP extension at runtime (string library): bool',
	extension_loaded: 'Find out whether an extension is loaded (string name): bool',
	gc_collect_cycles: 'Forces collection of any existing garbage cycles (): int',
	gc_disable: 'Deactivates the circular reference collector (): null',
	gc_enable: 'Activates the circular reference collector (): null',
	gc_enabled: 'Returns status of the circular reference collector (): bool',
	get_cfg_var: 'Gets the value of a PHP configuration option (string option): string',
	get_current_user: 'Gets the name of the owner of the current PHP script (): string',
	get_defined_constants: 'Returns an associative array with the names of all the constants and their values ([bool categorize]): array',
	get_extension_funcs: 'Returns an array with the names of the functions of a module (string module_name): array',
	get_include_path: 'Gets the current include_path configuration option (): string',
	get_included_files: 'Returns an array with the names of included or required files (): array',
	get_loaded_extensions: 'Returns an array with the names of all modules compiled and loaded ([bool zend_extensions]): array',
	get_magic_quotes_gpc: 'Gets the current configuration setting of magic_quotes_gpc (): int',
	get_magic_quotes_runtime: 'Gets the current active configuration setting of magic_quotes_runtime (): int',
	get_required_files: 'Alias of get_included_files',
	getenv: 'Gets the value of an environment variable (string varname): string',
	getlastmod: 'Gets time of last page modification (): int',
	getmygid: 'Get PHP script owner\'s GID (): int',
	getmyinode: 'Gets the inode of the current script (): int',
	getmypid: 'Gets PHP\'s process ID (): int',
	getmyuid: 'Gets PHP script owner\'s UID (): int',
	getopt: 'Gets options from the command line argument list (string options, [array longopts]): array',
	getrusage: 'Gets the current resource usages ([int who]): array',
	ini_alter: 'Alias of ini_set',
	ini_get_all: 'Gets all configuration options ([string extension, [bool details]]): array',
	ini_get: 'Gets the value of a configuration option (string varname): string',
	ini_restore: 'Restores the value of a configuration option (string varname): null',
	ini_set: 'Sets the value of a configuration option (string varname, string newvalue): string',
	magic_quotes_runtime: 'Alias of set_magic_quotes_runtime',
	memory_get_peak_usage: 'Returns the peak of memory allocated by PHP ([bool real_usage]): int',
	memory_get_usage: 'Returns the amount of memory allocated to PHP ([bool real_usage]): int',
	php_ini_loaded_file: 'Retrieve a path to the loaded php.ini file (): string',
	php_ini_scanned_files: 'Return a list of .ini files parsed from the additional ini dir (): string',
	php_logo_guid: 'Gets the logo guid (): string',
	php_sapi_name: 'Returns the type of interface between web server and PHP (): string',
	php_uname: 'Returns information about the operating system PHP is running on ([string mode]): string',
	phpcredits: 'Prints out the credits for PHP ([int flag]): bool',
	phpinfo: 'Outputs information about PHP\'s configuration ([int what]): bool',
	phpversion: 'Gets the current PHP version ([string extension]): string',
	putenv: 'Sets the value of an environment variable (string setting): bool',
	restore_include_path: 'Restores the value of the include_path configuration option (): null',
	set_include_path: 'Sets the include_path configuration option (string new_include_path): string',
	set_magic_quotes_runtime: 'Sets the current active configuration setting of magic_quotes_runtime (bool new_setting): bool',
	set_time_limit: 'Limits the maximum execution time (int seconds): null',
	sys_get_temp_dir: 'Returns directory path used for temporary files (): string',
	version_compare: 'Compares two "PHP-standardized" version number strings (string version1, string version2, [string operator]): mixed',
	zend_logo_guid: 'Gets the Zend guid (): string',
	zend_thread_id: 'Returns a unique identifier for the current thread (): int',
	zend_version: 'Gets the version of the current Zend engine (): string',
	ingres_autocommit_state: 'Test if the connection is using autocommit (resource link): bool',
	ingres_autocommit: 'Switch autocommit on or off (resource link): bool',
	ingres_charset: 'Returns the installation character set (resource link): string',
	ingres_close: 'Close an Ingres database connection (resource link): bool',
	ingres_commit: 'Commit a transaction (resource link): bool',
	ingres_connect: 'Open a connection to an Ingres database ([string database, [string username, [string password, [array options]]]]): resource',
	ingres_cursor: 'Get a cursor name for a given result resource (resource result): string',
	ingres_errno: 'Get the last Ingres error number generated ([resource link]): int',
	ingres_error: 'Get a meaningful error message for the last error generated ([resource link]): string',
	ingres_errsqlstate: 'Get the last SQLSTATE error code generated ([resource link]): string',
	ingres_escape_string: 'Escape special characters for use in a query (resource link, string source_string): string',
	ingres_execute: 'Execute a prepared query (resource result, [array params, [string types]]): boolean',
	ingres_fetch_array: 'Fetch a row of result into an array (resource result, [int result_type]): array',
	ingres_fetch_assoc: 'Fetch a row of result into an associative array (resource result): array',
	ingres_fetch_object: 'Fetch a row of result into an object (resource result, [int result_type]): object',
	ingres_fetch_proc_return: 'Get the return value from a procedure call (resource result): int',
	ingres_fetch_row: 'Fetch a row of result into an enumerated array (resource result): array',
	ingres_field_length: 'Get the length of a field (resource result, int index): int',
	ingres_field_name: 'Get the name of a field in a query result (resource result, int index): string',
	ingres_field_nullable: 'Test if a field is nullable (resource result, int index): bool',
	ingres_field_precision: 'Get the precision of a field (resource result, int index): int',
	ingres_field_scale: 'Get the scale of a field (resource result, int index): int',
	ingres_field_type: 'Get the type of a field in a query result (resource result, int index): string',
	ingres_free_result: 'Free the resources associated with a result identifier (resource result): bool',
	ingres_next_error: 'Get the next Ingres error ([resource link]): bool',
	ingres_num_fields: 'Get the number of fields returned by the last query (resource result): int',
	ingres_num_rows: 'Get the number of rows affected or returned by a query (resource result): int',
	ingres_pconnect: 'Open a persistent connection to an Ingres database ([string database, [string username, [string password, [array options]]]]): resource',
	ingres_prepare: 'Prepare a query for later execution (resource link, string query): mixed',
	ingres_query: 'Send an SQL query to Ingres (resource link, string query, [array params, [string types]]): mixed',
	ingres_result_seek: 'Set the row position before fetching data (resource result, integer position): boolean',
	ingres_rollback: 'Roll back a transaction (resource link): bool',
	ingres_set_environment: 'Set environment features controlling output options (resource link, array options): bool',
	ingres_unbuffered_query: 'Send an unbuffered SQL query to Ingres (resource link, string query, [array params, [string types]]): mixed',
	inotify_add_watch: 'Add a watch to an initialized inotify instance (resource inotify_instance, string pathname, int mask): int',
	inotify_init: 'Initialize an inotify instance (): resource',
	inotify_queue_len: 'Return a number upper than zero if there are pending events (resource inotify_instance): int',
	inotify_read: 'Read events from an inotify instance (resource inotify_instance): array',
	inotify_rm_watch: 'Remove an existing watch from an inotify instance (resource inotify_instance, int watch_descriptor): bool',
	collator_asort: 'Sort array maintaining index association (Collator coll, array &arr, [int sort_flag]): bool',
	collator_compare: 'Compare two Unicode strings (Collator coll, string str1, string str2): int',
	collator_create: 'Create a collator (string locale): Collator',
	collator_get_attribute: 'Get collation attribute value (Collator coll, int attr): int',
	collator_get_error_code: 'Get collator\'s last error code (Collator coll): int',
	collator_get_error_message: 'Get text for collator\'s last error code (Collator coll): string',
	collator_get_locale: 'Get the locale name of the collator (Collator coll, int type): string',
	collator_get_sort_key: 'Get sorting key for a string (Collator coll, string str): string',
	collator_get_strength: 'Get current collation strength (Collator coll): int',
	collator_set_attribute: 'Set collation attribute (Collator coll, int attr, int val): bool',
	collator_set_strength: 'Set collation strength (Collator coll, int strength): bool',
	collator_sort_with_sort_keys: 'Sort array using specified collator and sort keys (Collator coll, array &arr): bool',
	collator_sort: 'Sort array using specified collator (Collator coll, array &arr, [int sort_flag]): bool',
	datefmt_create: 'Create a date formatter (string locale, int datetype, int timetype, [string timezone, [int calendar, [string pattern]]]): IntlDateFormatter',
	datefmt_format: 'Format the date/time value as a string (IntlDateFormatter fmt, mixed value): string',
	datefmt_get_calendar: 'Get the calendar used for the IntlDateFormatter (IntlDateFormatter fmt): int',
	datefmt_get_datetype: 'Get the datetype used for the IntlDateFormatter (IntlDateFormatter fmt): int',
	datefmt_get_error_code: 'Get the error code from last operation (IntlDateFormatter fmt): int',
	datefmt_get_error_message: 'Get the error text from the last operation. (IntlDateFormatter fmt): string',
	datefmt_get_locale: 'Get the locale used by formatter (IntlDateFormatter fmt, [int which]): string',
	datefmt_get_pattern: 'Get the pattern used for the IntlDateFormatter (IntlDateFormatter fmt): string',
	datefmt_get_timetype: 'Get the timetype used for the IntlDateFormatter (IntlDateFormatter fmt): int',
	datefmt_get_timezone_id: 'Get the timezone-id used for the IntlDateFormatter (IntlDateFormatter fmt): string',
	datefmt_is_lenient: 'Get the lenient used for the IntlDateFormatter (IntlDateFormatter fmt): bool',
	datefmt_localtime: 'Parse string to a field-based time value (IntlDateFormatter fmt, string value, [int &position]): array',
	datefmt_parse: 'Parse string to a timestamp value (IntlDateFormatter fmt, string value, [int &position]): int',
	datefmt_set_calendar: 'sets the calendar used to the appropriate calendar, which must be (IntlDateFormatter fmt, int which): bool',
	datefmt_set_lenient: 'Set the leniency of the parser (IntlDateFormatter fmt, bool lenient): bool',
	datefmt_set_pattern: 'Set the pattern used for the IntlDateFormatter (IntlDateFormatter fmt, string pattern): bool',
	datefmt_set_timezone_id: 'Sets the time zone to use (IntlDateFormatter fmt, string zone): bool',
	intl_error_name: 'Get symbolic name for a given error code (int error_code): string',
	intl_get_error_code: 'Get the last error code (): int',
	intl_get_error_message: 'Get description of the last error (): string',
	intl_is_failure: 'Check whether the given error code indicates failure (int error_code): bool',
	grapheme_extract: 'Function to extract a sequence of default grapheme clusters from a text buffer, which must be encoded in UTF-8. (string haystack, int size, [int extract_type, [int start, [int &next]]]): string',
	grapheme_stripos: 'Find position (in grapheme units) of first occurrence of a case-insensitive string (string haystack, string needle, [int offset]): int',
	grapheme_stristr: 'Returns part of haystack string from the first occurrence of case-insensitive needle to the end of haystack. (string haystack, string needle, [bool before_needle]): string',
	grapheme_strlen: 'Get string length in grapheme units (string input): int',
	grapheme_strpos: 'Find position (in grapheme units) of first occurrence of a string (string haystack, string needle, [int offset]): int',
	grapheme_strripos: 'Find position (in grapheme units) of last occurrence of a case-insensitive string (string haystack, string needle, [int offset]): int',
	grapheme_strrpos: 'Find position (in grapheme units) of last occurrence of a string (string haystack, string needle, [int offset]): int',
	grapheme_strstr: 'Returns part of haystack string from the first occurrence of needle to the end of haystack. (string haystack, string needle, [bool before_needle]): string',
	grapheme_substr: 'Return part of a string (string string, int start, [int length]): int',
	idn_to_ascii: 'Convert domain name to IDNA ASCII form. (string domain, [int options]): string',
	idn_to_unicode: 'Alias of idn_to_utf8',
	idn_to_utf8: 'Convert domain name from IDNA ASCII to Unicode. (string domain, [int options]): string',
	locale_accept_from_http: 'Tries to find out best available locale based on HTTP "Accept-Language" header (string header): string',
	locale_compose: 'Returns a correctly ordered and delimited locale ID (array subtags): string',
	locale_filter_matches: 'Checks if a language tag filter matches with locale (string langtag, string locale, [bool canonicalize]): bool',
	locale_get_all_variants: 'Gets the variants for the input locale (string locale): array',
	locale_get_default: 'Gets the default locale value from the INTL global \'default_locale\' (): string',
	locale_get_display_language: 'Returns an appropriately localized display name for language of the inputlocale (string locale, [string in_locale]): string',
	locale_get_display_name: 'Returns an appropriately localized display name for the input locale (string locale, [string in_locale]): string',
	locale_get_display_region: 'Returns an appropriately localized display name for region of the input locale (string locale, [string in_locale]): string',
	locale_get_display_script: 'Returns an appropriately localized display name for script of the input locale (string locale, [string in_locale]): string',
	locale_get_display_variant: 'Returns an appropriately localized display name for variants of the input locale (string locale, [string in_locale]): string',
	locale_get_keywords: 'Gets the keywords for the input locale (string locale): array',
	locale_get_primary_language: 'Gets the primary language for the input locale (string locale): string',
	locale_get_region: 'Gets the region for the input locale (string locale): string',
	locale_get_script: 'Gets the script for the input locale (string locale): string',
	locale_lookup: 'Searches the language tag list for the best match to the language (array langtag, string locale, [bool canonicalize, [string default]]): string',
	locale_parse: 'Returns a key-value array of locale ID subtag elements. (string locale): array',
	locale_set_default: 'sets the default runtime locale (string locale): bool',
	msgfmt_create: 'Constructs a new Message Formatter (string locale, string pattern): MessageFormatter',
	msgfmt_format_message: 'Quick format message (string locale, string pattern, array args): string',
	msgfmt_format: 'Format the message (MessageFormatter fmt, array args): string',
	msgfmt_get_error_code: 'Get the error code from last operation (MessageFormatter fmt): int',
	msgfmt_get_error_message: 'Get the error text from the last operation (MessageFormatter fmt): string',
	msgfmt_get_locale: 'Get the locale for which the formatter was created. (NumberFormatter formatter): string',
	msgfmt_get_pattern: 'Get the pattern used by the formatter (MessageFormatter fmt): string',
	msgfmt_parse_message: 'Quick parse input string (string locale, string value): array',
	msgfmt_parse: 'Parse input string according to pattern (MessageFormatter fmt, string value): array',
	msgfmt_set_pattern: 'Set the pattern used by the formatter (MessageFormatter fmt, string pattern): bool',
	normalizer_is_normalized: 'Checks if the provided string is already in the specified normalization form. (string input, [string form]): bool',
	normalizer_normalize: 'Normalizes the input provided and returns the normalized string (string input, [string form]): string',
	numfmt_create: 'Create a number formatter (string locale, int style, [string pattern]): NumberFormatter',
	numfmt_format_currency: 'Format a currency value (NumberFormatter fmt, float value, string currency): string',
	numfmt_format: 'Format a number (NumberFormatter fmt, number value, [int type]): string',
	numfmt_get_attribute: 'Get an attribute (NumberFormatter fmt, int attr): int',
	numfmt_get_error_code: 'Get formatter\'s last error code. (NumberFormatter fmt): int',
	numfmt_get_error_message: 'Get formatter\'s last error message. (NumberFormatter fmt): string',
	numfmt_get_locale: 'Get formatter locale (NumberFormatter fmt, [int type]): string',
	numfmt_get_pattern: 'Get formatter pattern (NumberFormatter fmt): string',
	numfmt_get_symbol: 'Get a symbol value (NumberFormatter fmt, int attr): string',
	numfmt_get_text_attribute: 'Get a text attribute (NumberFormatter fmt, int attr): string',
	numfmt_parse_currency: 'Parse a currency number (NumberFormatter fmt, string value, string &currency, [int &position]): float',
	numfmt_parse: 'Parse a number (NumberFormatter fmt, string value, [int type, [int &position]]): mixed',
	numfmt_set_attribute: 'Set an attribute (NumberFormatter fmt, int attr, int value): bool',
	numfmt_set_pattern: 'Set formatter pattern (NumberFormatter fmt, string pattern): bool',
	numfmt_set_symbol: 'Set a symbol value (NumberFormatter fmt, int attr, string value): bool',
	numfmt_set_text_attribute: 'Set a text attribute (NumberFormatter fmt, int attr, string value): bool',
	resourcebundle_count: 'Get number of elements in the bundle (ResourceBundle r): int',
	resourcebundle_create: 'Create a resource bundle (string locale, string bundlename, [bool fallback]): ResourceBundle',
	resourcebundle_get_error_code: 'Get bundle\'s last error code. (ResourceBundle r): int',
	resourcebundle_get_error_message: 'Get bundle\'s last error message. (ResourceBundle r): string',
	resourcebundle_get: 'Get data from the bundle (ResourceBundle r, string|int index): mixed',
	resourcebundle_locales: 'Get supported locales (ResourceBundle r): array',
	java_last_exception_clear: 'Clear last Java exception (): null',
	java_last_exception_get: 'Get last Java exception (): object',
	json_decode: 'Decodes a JSON string (string json, [bool assoc, [int depth]]): mixed',
	json_encode: 'Returns the JSON representation of a value (mixed value, [int options]): string',
	json_last_error: 'Returns the last error occurred (): int',
	kadm5_chpass_principal: 'Changes the principal\'s password (resource handle, string principal, string password): bool',
	kadm5_create_principal: 'Creates a kerberos principal with the given parameters (resource handle, string principal, [string password, [array options]]): bool',
	kadm5_delete_principal: 'Deletes a kerberos principal (resource handle, string principal): bool',
	kadm5_destroy: 'Closes the connection to the admin server and releases all related resources (resource handle): bool',
	kadm5_flush: 'Flush all changes to the Kerberos database (resource handle): bool',
	kadm5_get_policies: 'Gets all policies from the Kerberos database (resource handle): array',
	kadm5_get_principal: 'Gets the principal\'s entries from the Kerberos database (resource handle, string principal): array',
	kadm5_get_principals: 'Gets all principals from the Kerberos database (resource handle): array',
	kadm5_init_with_password: 'Opens a connection to the KADM5 library (string admin_server, string realm, string principal, string password): resource',
	kadm5_modify_principal: 'Modifies a kerberos principal with the given parameters (resource handle, string principal, array options): bool',
	ldap_8859_to_t61: 'Translate 8859 characters to t61 characters (string value): string',
	ldap_add: 'Add entries to LDAP directory (resource link_identifier, string dn, array entry): bool',
	ldap_bind: 'Bind to LDAP directory (resource link_identifier, [string bind_rdn, [string bind_password]]): bool',
	ldap_close: 'Alias of ldap_unbind',
	ldap_compare: 'Compare value of attribute found in entry specified with DN (resource link_identifier, string dn, string attribute, string value): mixed',
	ldap_connect: 'Connect to an LDAP server ([string hostname, [int port]]): resource',
	ldap_count_entries: 'Count the number of entries in a search (resource link_identifier, resource result_identifier): int',
	ldap_delete: 'Delete an entry from a directory (resource link_identifier, string dn): bool',
	ldap_dn2ufn: 'Convert DN to User Friendly Naming format (string dn): string',
	ldap_err2str: 'Convert LDAP error number into string error message (int errno): string',
	ldap_errno: 'Return the LDAP error number of the last LDAP command (resource link_identifier): int',
	ldap_error: 'Return the LDAP error message of the last LDAP command (resource link_identifier): string',
	ldap_explode_dn: 'Splits DN into its component parts (string dn, int with_attrib): array',
	ldap_first_attribute: 'Return first attribute (resource link_identifier, resource result_entry_identifier): string',
	ldap_first_entry: 'Return first result id (resource link_identifier, resource result_identifier): resource',
	ldap_first_reference: 'Return first reference (resource link, resource result): resource',
	ldap_free_result: 'Free result memory (resource result_identifier): bool',
	ldap_get_attributes: 'Get attributes from a search result entry (resource link_identifier, resource result_entry_identifier): array',
	ldap_get_dn: 'Get the DN of a result entry (resource link_identifier, resource result_entry_identifier): string',
	ldap_get_entries: 'Get all result entries (resource link_identifier, resource result_identifier): array',
	ldap_get_option: 'Get the current value for given option (resource link_identifier, int option, mixed &retval): bool',
	ldap_get_values_len: 'Get all binary values from a result entry (resource link_identifier, resource result_entry_identifier, string attribute): array',
	ldap_get_values: 'Get all values from a result entry (resource link_identifier, resource result_entry_identifier, string attribute): array',
	ldap_list: 'Single-level search (resource link_identifier, string base_dn, string filter, [array attributes, [int attrsonly, [int sizelimit, [int timelimit, [int deref]]]]]): resource',
	ldap_mod_add: 'Add attribute values to current attributes (resource link_identifier, string dn, array entry): bool',
	ldap_mod_del: 'Delete attribute values from current attributes (resource link_identifier, string dn, array entry): bool',
	ldap_mod_replace: 'Replace attribute values with new ones (resource link_identifier, string dn, array entry): bool',
	ldap_modify: 'Modify an LDAP entry (resource link_identifier, string dn, array entry): bool',
	ldap_next_attribute: 'Get the next attribute in result (resource link_identifier, resource result_entry_identifier): string',
	ldap_next_entry: 'Get next result entry (resource link_identifier, resource result_entry_identifier): resource',
	ldap_next_reference: 'Get next reference (resource link, resource entry): resource',
	ldap_parse_reference: 'Extract information from reference entry (resource link, resource entry, array &referrals): bool',
	ldap_parse_result: 'Extract information from result (resource link, resource result, int &errcode, [string &matcheddn, [string &errmsg, [array &referrals]]]): bool',
	ldap_read: 'Read an entry (resource link_identifier, string base_dn, string filter, [array attributes, [int attrsonly, [int sizelimit, [int timelimit, [int deref]]]]]): resource',
	ldap_rename: 'Modify the name of an entry (resource link_identifier, string dn, string newrdn, string newparent, bool deleteoldrdn): bool',
	ldap_sasl_bind: 'Bind to LDAP directory using SASL (resource link, [string binddn, [string password, [string sasl_mech, [string sasl_realm, [string sasl_authc_id, [string sasl_authz_id, [string props]]]]]]]): bool',
	ldap_search: 'Search LDAP tree (resource link_identifier, string base_dn, string filter, [array attributes, [int attrsonly, [int sizelimit, [int timelimit, [int deref]]]]]): resource',
	ldap_set_option: 'Set the value of the given option (resource link_identifier, int option, mixed newval): bool',
	ldap_set_rebind_proc: 'Set a callback function to do re-binds on referral chasing (resource link, callback callback): bool',
	ldap_sort: 'Sort LDAP result entries (resource link, resource result, string sortfilter): bool',
	ldap_start_tls: 'Start TLS (resource link): bool',
	ldap_t61_to_8859: 'Translate t61 characters to 8859 characters (string value): string',
	ldap_unbind: 'Unbind from LDAP directory (resource link_identifier): bool',
	event_add: 'Add an event to the set of monitored events (resource event, [int timeout]): bool',
	event_base_free: 'Destroy event base (resource event_base): null',
	event_base_loop: 'Handle events (resource event_base, [int flags]): int',
	event_base_loopbreak: 'Abort event loop (resource event_base): bool',
	event_base_loopexit: 'Exit loop after a time (resource event_base, [int timeout]): bool',
	event_base_new: 'Create and initialize new event base (): resource',
	event_base_priority_init: 'Set the number of event priority levels (resource event_base, int npriorities): bool',
	event_base_set: 'Associate event base with an event (resource event, resource event_base): bool',
	event_buffer_base_set: 'Associate buffered event with an event base (resource bevent, resource event_base): bool',
	event_buffer_disable: 'Disable a buffered event (resource bevent, int events): bool',
	event_buffer_enable: 'Enable a buffered event (resource bevent, int events): bool',
	event_buffer_fd_set: 'Change a buffered event file descriptor (resource bevent, resource fd): null',
	event_buffer_free: 'Destroy buffered event (resource bevent): null',
	event_buffer_new: 'Create new buffered event (resource stream, mixed readcb, mixed writecb, mixed errorcb, [mixed arg]): resource',
	event_buffer_priority_set: 'Assign a priority to a buffered event (resource bevent, int priority): bool',
	event_buffer_read: 'Read data from a buffered event (resource bevent, int data_size): string',
	event_buffer_timeout_set: 'Set read and write timeouts for a buffered event (resource bevent, int read_timeout, int write_timeout): null',
	event_buffer_watermark_set: 'Set the watermarks for read and write events (resource bevent, int events, int lowmark, int highmark): null',
	event_buffer_write: 'Write data to a buffered event (resource bevent, string data, [int data_size]): bool',
	event_del: 'Remove an event from the set of monitored events (resource event): bool',
	event_free: 'Free event resource (resource event): null',
	event_new: 'Create new event (): resource',
	event_set: 'Prepare an event (resource event, resource fd, int events, mixed callback, [mixed arg]): bool',
	libxml_clear_errors: 'Clear libxml error buffer (): null',
	libxml_disable_entity_loader: 'Disable the ability to load external entities ([bool disable]): ReturnType',
	libxml_get_errors: 'Retrieve array of errors (): array',
	libxml_get_last_error: 'Retrieve last error from libxml (): LibXMLError',
	libxml_set_streams_context: 'Set the streams context for the next libxml document load or write (resource streams_context): null',
	libxml_use_internal_errors: 'Disable libxml errors and allow user to fetch error information as needed ([bool use_errors]): bool',
	lzf_compress: 'LZF compression (string data): string',
	lzf_decompress: 'LZF decompression (string data): string',
	lzf_optimized_for: 'Determines what LZF extension was optimized for (): int',
	ezmlm_hash: 'Calculate the hash value needed by EZMLM (string addr): int',
	mail: 'Send mail (string to, string subject, string message, [string additional_headers, [string additional_parameters]]): bool',
	mailparse_determine_best_xfer_encoding: 'Gets the best way of encoding (resource fp): string',
	mailparse_msg_create: 'Create a mime mail resource (): resource',
	mailparse_msg_extract_part_file: 'Extracts/decodes a message section (resource mimemail, mixed filename, [callback callbackfunc]): string',
	mailparse_msg_extract_part: 'Extracts/decodes a message section (resource mimemail, string msgbody, [callback callbackfunc]): null',
	mailparse_msg_extract_whole_part_file: 'Extracts a message section including headers without decoding the transfer encoding (resource mimemail, string filename, [callback callbackfunc]): string',
	mailparse_msg_free: 'Frees a MIME resource (resource mimemail): bool',
	mailparse_msg_get_part_data: 'Returns an associative array of info about the message (resource mimemail): array',
	mailparse_msg_get_part: 'Returns a handle on a given section in a mimemessage (resource mimemail, string mimesection): resource',
	mailparse_msg_get_structure: 'Returns an array of mime section names in the supplied message (resource mimemail): array',
	mailparse_msg_parse_file: 'Parses a file (string filename): resource',
	mailparse_msg_parse: 'Incrementally parse data into buffer (resource mimemail, string data): bool',
	mailparse_rfc822_parse_addresses: 'Parse RFC 822 compliant addresses (string addresses): array',
	mailparse_stream_encode: 'Streams data from source file pointer, apply encoding and write to destfp (resource sourcefp, resource destfp, string encoding): bool',
	mailparse_uudecode_all: 'Scans the data from fp and extract each embedded uuencoded file (resource fp): array',
	abs: 'Absolute value (mixed number): number',
	acos: 'Arc cosine (float arg): float',
	acosh: 'Inverse hyperbolic cosine (float arg): float',
	asin: 'Arc sine (float arg): float',
	asinh: 'Inverse hyperbolic sine (float arg): float',
	atan: 'Arc tangent (float arg): float',
	atan2: 'Arc tangent of two variables (float y, float x): float',
	atanh: 'Inverse hyperbolic tangent (float arg): float',
	base_convert: 'Convert a number between arbitrary bases (string number, int frombase, int tobase): string',
	bindec: 'Binary to decimal (string binary_string): number',
	ceil: 'Round fractions up (float value): float',
	cos: 'Cosine (float arg): float',
	cosh: 'Hyperbolic cosine (float arg): float',
	decbin: 'Decimal to binary (int number): string',
	dechex: 'Decimal to hexadecimal (int number): string',
	decoct: 'Decimal to octal (int number): string',
	deg2rad: 'Converts the number in degrees to the radian equivalent (float number): float',
	exp: 'Calculates the exponent of e (float arg): float',
	expm1: 'Returns exp(number) - 1, computed in a way that is accurate even when the value of number is close to zero (float arg): float',
	floor: 'Round fractions down (float value): float',
	fmod: 'Returns the floating point remainder (modulo) of the division of the arguments (float x, float y): float',
	getrandmax: 'Show largest possible random value (): int',
	hexdec: 'Hexadecimal to decimal (string hex_string): number',
	hypot: 'Calculate the length of the hypotenuse of a right-angle triangle (float x, float y): float',
	is_finite: 'Finds whether a value is a legal finite number (float val): bool',
	is_infinite: 'Finds whether a value is infinite (float val): bool',
	is_nan: 'Finds whether a value is not a number (float val): bool',
	lcg_value: 'Combined linear congruential generator (): float',
	log: 'Natural logarithm (float arg, [float base]): float',
	log10: 'Base-10 logarithm (float arg): float',
	log1p: 'Returns log(1 + number), computed in a way that is accurate even when the value of number is close to zero (float number): float',
	max: 'Find highest value (array values): mixed',
	max: 'Find highest value (mixed value1, mixed value2, [mixed value3...]): mixed',
	min: 'Find lowest value (array values): mixed',
	min: 'Find lowest value (mixed value1, mixed value2, [mixed value3...]): mixed',
	mt_getrandmax: 'Show largest possible random value (): int',
	mt_rand: 'Generate a better random value (): int',
	mt_rand: 'Generate a better random value (int min, int max): int',
	mt_srand: 'Seed the better random number generator ([int seed]): null',
	octdec: 'Octal to decimal (string octal_string): number',
	pi: 'Get value of pi (): float',
	pow: 'Exponential expression (number base, number exp): number',
	rad2deg: 'Converts the radian number to the equivalent number in degrees (float number): float',
	rand: 'Generate a random integer (): int',
	rand: 'Generate a random integer (int min, int max): int',
	round: 'Rounds a float (float val, [int precision, [int mode]]): float',
	sin: 'Sine (float arg): float',
	sinh: 'Hyperbolic sine (float arg): float',
	sqrt: 'Square root (float arg): float',
	srand: 'Seed the random number generator ([int seed]): null',
	tan: 'Tangent (float arg): float',
	tanh: 'Hyperbolic tangent (float arg): float',
	maxdb_affected_rows: 'Gets the number of affected rows in a previous MaxDB operation (resource link): int',
	maxdb_autocommit: 'Turns on or off auto-commiting database modifications (resource link, bool mode): bool',
	maxdb_bind_param: 'Alias of maxdb_stmt_bind_param',
	maxdb_bind_result: 'Alias of maxdb_stmt_bind_result',
	maxdb_change_user: 'Changes the user of the specified database connection (resource link, string user, string password, string database): bool',
	maxdb_character_set_name: 'Returns the default character set for the database connection (resource link): string',
	maxdb_client_encoding: 'Alias of maxdb_character_set_name',
	maxdb_close: 'Closes a previously opened database connection (resource link): bool',
	maxdb_commit: 'Commits the current transaction (resource link): bool',
	maxdb_connect_errno: 'Returns the error code from last connect call (): int',
	maxdb_connect_error: 'Returns a string description of the last connect error (): string',
	maxdb_connect: 'Open a new connection to the MaxDB server ([string host, [string username, [string passwd, [string dbname, [int port, [string socket]]]]]]): resource',
	maxdb_data_seek: 'Adjusts the result pointer to an arbitary row in the result (resource result, int offset): bool',
	maxdb_debug: 'Performs debugging operations (string debug): null',
	maxdb_disable_reads_from_master: 'Disable reads from master (resource link): bool',
	maxdb_disable_rpl_parse: 'Disable RPL parse (resource link): bool',
	maxdb_dump_debug_info: 'Dump debugging information into the log (resource link): bool',
	maxdb_embedded_connect: 'Open a connection to an embedded MaxDB server ([string dbname]): resource',
	maxdb_enable_reads_from_master: 'Enable reads from master (resource link): bool',
	maxdb_enable_rpl_parse: 'Enable RPL parse (resource link): bool',
	maxdb_errno: 'Returns the error code for the most recent function call (resource link): int',
	maxdb_error: 'Returns a string description of the last error (resource link): string',
	maxdb_escape_string: 'Alias of maxdb_real_escape_string',
	maxdb_execute: 'Alias of maxdb_stmt_execute',
	maxdb_fetch_array: 'Fetch a result row as an associative, a numeric array, or both (resource result, [int resulttype]): mixed',
	maxdb_fetch_assoc: 'Fetch a result row as an associative array (resource result): array',
	maxdb_fetch_field_direct: 'Fetch meta-data for a single field (resource result, int fieldnr): mixed',
	maxdb_fetch_field: 'Returns the next field in the result set (resource result): mixed',
	maxdb_fetch_fields: 'Returns an array of resources representing the fields in a result set (resource result): mixed',
	maxdb_fetch_lengths: 'Returns the lengths of the columns of the current row in the result set (resource result): array',
	maxdb_fetch_object: 'Returns the current row of a result set as an object (object result): object',
	maxdb_fetch_row: 'Get a result row as an enumerated array (resource result): mixed',
	maxdb_fetch: 'Alias of maxdb_stmt_fetch',
	maxdb_field_count: 'Returns the number of columns for the most recent query (resource link): int',
	maxdb_field_seek: 'Set result pointer to a specified field offset (resource result, int fieldnr): bool',
	maxdb_field_tell: 'Get current field offset of a result pointer (resource result): int',
	maxdb_free_result: 'Frees the memory associated with a result (resource result): null',
	maxdb_get_client_info: 'Returns the MaxDB client version as a string (): string',
	maxdb_get_client_version: 'Get MaxDB client info (): int',
	maxdb_get_host_info: 'Returns a string representing the type of connection used (resource link): string',
	maxdb_get_metadata: 'Alias of maxdb_stmt_result_metadata',
	maxdb_get_proto_info: 'Returns the version of the MaxDB protocol used (resource link): int',
	maxdb_get_server_info: 'Returns the version of the MaxDB server (resource link): string',
	maxdb_get_server_version: 'Returns the version of the MaxDB server as an integer (resource link): int',
	maxdb_info: 'Retrieves information about the most recently executed query (resource link): string',
	maxdb_init: 'Initializes MaxDB and returns an resource for use with maxdb_real_connect (): resource',
	maxdb_insert_id: 'Returns the auto generated id used in the last query (resource link): mixed',
	maxdb_kill: 'Disconnects from a MaxDB server (resource link, int processid): bool',
	maxdb_master_query: 'Enforce execution of a query on the master in a master/slave setup (resource link, string query): bool',
	maxdb_more_results: 'Check if there any more query results from a multi query (resource link): bool',
	maxdb_multi_query: 'Performs a query on the database (resource link, string query): bool',
	maxdb_next_result: 'Prepare next result from multi_query (resource link): bool',
	maxdb_num_fields: 'Get the number of fields in a result (resource result): int',
	maxdb_num_rows: 'Gets the number of rows in a result (resource result): int',
	maxdb_options: 'Set options (resource link, int option, mixed value): bool',
	maxdb_param_count: 'Alias of maxdb_stmt_param_count',
	maxdb_ping: 'Pings a server connection, or tries to reconnect if the connection has gone down (resource link): bool',
	maxdb_prepare: 'Prepare a SQL statement for execution (resource link, string query): resource',
	maxdb_query: 'Performs a query on the database (resource link, string query, [int resultmode]): mixed',
	maxdb_real_connect: 'Opens a connection to a MaxDB server (resource link, [string hostname, [string username, [string passwd, [string dbname, [int port, [string socket]]]]]]): bool',
	maxdb_real_escape_string: 'Escapes special characters in a string for use in a SQL statement, taking into account the current charset of the connection (resource link, string escapestr): string',
	maxdb_real_query: 'Execute an SQL query (resource link, string query): bool',
	maxdb_report: 'Enables or disables internal report functions (int flags): bool',
	maxdb_rollback: 'Rolls back current transaction (resource link): bool',
	maxdb_rpl_parse_enabled: 'Check if RPL parse is enabled (resource link): int',
	maxdb_rpl_probe: 'RPL probe (resource link): bool',
	maxdb_rpl_query_type: 'Returns RPL query type (resource link): int',
	maxdb_select_db: 'Selects the default database for database queries (resource link, string dbname): bool',
	maxdb_send_long_data: 'Alias of maxdb_stmt_send_long_data',
	maxdb_send_query: 'Send the query and return (resource link, string query): bool',
	maxdb_server_end: 'Shut down the embedded server (): null',
	maxdb_server_init: 'Initialize embedded server ([array server, [array groups]]): bool',
	maxdb_set_opt: 'Alias of maxdb_options',
	maxdb_sqlstate: 'Returns the SQLSTATE error from previous MaxDB operation (resource link): string',
	maxdb_ssl_set: 'Used for establishing secure connections using SSL (resource link, string key, string cert, string ca, string capath, string cipher): bool',
	maxdb_stat: 'Gets the current system status (resource link): string',
	maxdb_stmt_affected_rows: 'Returns the total number of rows changed, deleted, or inserted by the last executed statement (resource stmt): int',
	maxdb_stmt_bind_param: 'Binds variables to a prepared statement as parameters (resource stmt, string types, mixed &var1, [mixed &...]): bool',
	maxdb_stmt_bind_param: 'Binds variables to a prepared statement as parameters (resource stmt, string types, array &var): bool',
	maxdb_stmt_bind_result: 'Binds variables to a prepared statement for result storage (resource stmt, mixed &var1, [mixed &...]): bool',
	maxdb_stmt_close_long_data: 'Ends a sequence of maxdb_stmt_send_long_data (resource stmt, int param_nr): bool',
	maxdb_stmt_close: 'Closes a prepared statement (resource stmt): bool',
	maxdb_stmt_data_seek: 'Seeks to an arbitray row in statement result set (resource statement, int offset): bool',
	maxdb_stmt_errno: 'Returns the error code for the most recent statement call (resource stmt): int',
	maxdb_stmt_error: 'Returns a string description for last statement error (resource stmt): string',
	maxdb_stmt_execute: 'Executes a prepared Query (resource stmt): bool',
	maxdb_stmt_fetch: 'Fetch results from a prepared statement into the bound variables (resource stmt): bool',
	maxdb_stmt_free_result: 'Frees stored result memory for the given statement handle (resource stmt): null',
	maxdb_stmt_init: 'Initializes a statement and returns an resource for use with maxdb_stmt_prepare (resource link): resource',
	maxdb_stmt_num_rows: 'Return the number of rows in statements result set (resource stmt): int',
	maxdb_stmt_param_count: 'Returns the number of parameter for the given statement (resource stmt): int',
	maxdb_stmt_prepare: 'Prepare a SQL statement for execution (resource stmt, string query): bool',
	maxdb_stmt_reset: 'Resets a prepared statement (resource stmt): bool',
	maxdb_stmt_result_metadata: 'Returns result set metadata from a prepared statement (resource stmt): resource',
	maxdb_stmt_send_long_data: 'Send data in blocks (resource stmt, int param_nr, string data): bool',
	maxdb_stmt_sqlstate: 'Returns SQLSTATE error from previous statement operation (resource stmt): string',
	maxdb_stmt_store_result: 'Transfers a result set from a prepared statement (resource stmt): bool',
	maxdb_store_result: 'Transfers a result set from the last query (resource link): resource',
	maxdb_thread_id: 'Returns the thread ID for the current connection (resource link): int',
	maxdb_thread_safe: 'Returns whether thread safety is given or not (): bool',
	maxdb_use_result: 'Initiate a result set retrieval (resource link): resource',
	maxdb_warning_count: 'Returns the number of warnings from the last query for the given link (resource link): int',
	mb_check_encoding: 'Check if the string is valid for the specified encoding ([string var, [string encoding]]): bool',
	mb_convert_case: 'Perform case folding on a string (string str, int mode, [string encoding]): string',
	mb_convert_encoding: 'Convert character encoding (string str, string to_encoding, [mixed from_encoding]): string',
	mb_convert_kana: 'Convert "kana" one from another ("zen-kaku", "han-kaku" and more) (string str, [string option, [string encoding]]): string',
	mb_convert_variables: 'Convert character code in variable(s) (string to_encoding, mixed from_encoding, mixed &vars, [mixed &...]): string',
	mb_decode_mimeheader: 'Decode string in MIME header field (string str): string',
	mb_decode_numericentity: 'Decode HTML numeric string reference to character (string str, array convmap, string encoding): string',
	mb_detect_encoding: 'Detect character encoding (string str, [mixed encoding_list, [bool strict]]): string',
	mb_detect_order: 'Set/Get character encoding detection order ([mixed encoding_list]): mixed',
	mb_encode_mimeheader: 'Encode string for MIME header (string str, [string charset, [string transfer_encoding, [string linefeed, [int indent]]]]): string',
	mb_encode_numericentity: 'Encode character to HTML numeric string reference (string str, array convmap, string encoding): string',
	mb_ereg_match: 'Regular expression match for multibyte string (string pattern, string string, [string option]): bool',
	mb_ereg_replace: 'Replace regular expression with multibyte support (string pattern, string replacement, string string, [string option]): string',
	mb_ereg_search_getpos: 'Returns start point for next regular expression match (): int',
	mb_ereg_search_getregs: 'Retrieve the result from the last multibyte regular expression match (): array',
	mb_ereg_search_init: 'Setup string and regular expression for a multibyte regular expression match (string string, [string pattern, [string option]]): bool',
	mb_ereg_search_pos: 'Returns position and length of a matched part of the multibyte regular expression for a predefined multibyte string ([string pattern, [string option]]): array',
	mb_ereg_search_regs: 'Returns the matched part of a multibyte regular expression ([string pattern, [string option]]): array',
	mb_ereg_search_setpos: 'Set start point of next regular expression match (int position): bool',
	mb_ereg_search: 'Multibyte regular expression match for predefined multibyte string ([string pattern, [string option]]): bool',
	mb_ereg: 'Regular expression match with multibyte support (string pattern, string string, [array regs]): int',
	mb_eregi_replace: 'Replace regular expression with multibyte support ignoring case (string pattern, string replace, string string, [string option]): string',
	mb_eregi: 'Regular expression match ignoring case with multibyte support (string pattern, string string, [array regs]): int',
	mb_get_info: 'Get internal settings of mbstring ([string type]): mixed',
	mb_http_input: 'Detect HTTP input character encoding ([string type]): mixed',
	mb_http_output: 'Set/Get HTTP output character encoding ([string encoding]): mixed',
	mb_internal_encoding: 'Set/Get internal character encoding ([string encoding]): mixed',
	mb_language: 'Set/Get current language ([string language]): mixed',
	mb_list_encodings: 'Returns an array of all supported encodings (): array',
	mb_output_handler: 'Callback function converts character encoding in output buffer (string contents, int status): string',
	mb_parse_str: 'Parse GET/POST/COOKIE data and set global variable (string encoded_string, [array &result]): bool',
	mb_preferred_mime_name: 'Get MIME charset string (string encoding): string',
	mb_regex_encoding: 'Returns current encoding for multibyte regex as string ([string encoding]): mixed',
	mb_regex_set_options: 'Set/Get the default options for mbregex functions ([string options]): string',
	mb_send_mail: 'Send encoded mail (string to, string subject, string message, [string additional_headers, [string additional_parameter]]): bool',
	mb_split: 'Split multibyte string using regular expression (string pattern, string string, [int limit]): array',
	mb_strcut: 'Get part of string (string str, int start, [int length, [string encoding]]): string',
	mb_strimwidth: 'Get truncated string with specified width (string str, int start, int width, [string trimmarker, [string encoding]]): string',
	mb_stripos: 'Finds position of first occurrence of a string within another, case insensitive (string haystack, string needle, [int offset, [string encoding]]): int',
	mb_stristr: 'Finds first occurrence of a string within another, case insensitive (string haystack, string needle, [bool part, [string encoding]]): string',
	mb_strlen: 'Get string length (string str, [string encoding]): int',
	mb_strpos: 'Find position of first occurrence of string in a string (string haystack, string needle, [int offset, [string encoding]]): int',
	mb_strrchr: 'Finds the last occurrence of a character in a string within another (string haystack, string needle, [bool part, [string encoding]]): string',
	mb_strrichr: 'Finds the last occurrence of a character in a string within another, case insensitive (string haystack, string needle, [bool part, [string encoding]]): string',
	mb_strripos: 'Finds position of last occurrence of a string within another, case insensitive (string haystack, string needle, [int offset, [string encoding]]): int',
	mb_strrpos: 'Find position of last occurrence of a string in a string (string haystack, string needle, [int offset, [string encoding]]): int',
	mb_strstr: 'Finds first occurrence of a string within another (string haystack, string needle, [bool part, [string encoding]]): string',
	mb_strtolower: 'Make a string lowercase (string str, [string encoding]): string',
	mb_strtoupper: 'Make a string uppercase (string str, [string encoding]): string',
	mb_strwidth: 'Return width of string (string str, [string encoding]): int',
	mb_substitute_character: 'Set/Get substitution character ([mixed substrchar]): mixed',
	mb_substr_count: 'Count the number of substring occurrences (string haystack, string needle, [string encoding]): int',
	mb_substr: 'Get part of string (string str, int start, [int length, [string encoding]]): string',
	mcrypt_cbc: 'Encrypt/decrypt data in CBC mode (int cipher, string key, string data, int mode, [string iv]): string',
	mcrypt_cbc: 'Encrypt/decrypt data in CBC mode (string cipher, string key, string data, int mode, [string iv]): string',
	mcrypt_cfb: 'Encrypt/decrypt data in CFB mode (int cipher, string key, string data, int mode, string iv): string',
	mcrypt_cfb: 'Encrypt/decrypt data in CFB mode (string cipher, string key, string data, int mode, [string iv]): string',
	mcrypt_create_iv: 'Create an initialization vector (IV) from a random source (int size, [int source]): string',
	mcrypt_decrypt: 'Decrypts crypttext with given parameters (string cipher, string key, string data, string mode, [string iv]): string',
	mcrypt_ecb: 'Deprecated: Encrypt/decrypt data in ECB mode (int cipher, string key, string data, int mode): string',
	mcrypt_ecb: 'Deprecated: Encrypt/decrypt data in ECB mode (string cipher, string key, string data, int mode, [string iv]): string',
	mcrypt_enc_get_algorithms_name: 'Returns the name of the opened algorithm (resource td): string',
	mcrypt_enc_get_block_size: 'Returns the blocksize of the opened algorithm (resource td): int',
	mcrypt_enc_get_iv_size: 'Returns the size of the IV of the opened algorithm (resource td): int',
	mcrypt_enc_get_key_size: 'Returns the maximum supported keysize of the opened mode (resource td): int',
	mcrypt_enc_get_modes_name: 'Returns the name of the opened mode (resource td): string',
	mcrypt_enc_get_supported_key_sizes: 'Returns an array with the supported keysizes of the opened algorithm (resource td): array',
	mcrypt_enc_is_block_algorithm_mode: 'Checks whether the encryption of the opened mode works on blocks (resource td): bool',
	mcrypt_enc_is_block_algorithm: 'Checks whether the algorithm of the opened mode is a block algorithm (resource td): bool',
	mcrypt_enc_is_block_mode: 'Checks whether the opened mode outputs blocks (resource td): bool',
	mcrypt_enc_self_test: 'Runs a self test on the opened module (resource td): int',
	mcrypt_encrypt: 'Encrypts plaintext with given parameters (string cipher, string key, string data, string mode, [string iv]): string',
	mcrypt_generic_deinit: 'This function deinitializes an encryption module (resource td): bool',
	mcrypt_generic_end: 'This function terminates encryption (resource td): bool',
	mcrypt_generic_init: 'This function initializes all buffers needed for encryption (resource td, string key, string iv): int',
	mcrypt_generic: 'This function encrypts data (resource td, string data): string',
	mcrypt_get_block_size: 'Get the block size of the specified cipher (int cipher): int',
	mcrypt_get_block_size: 'Get the block size of the specified cipher (string cipher, string module): int',
	mcrypt_get_cipher_name: 'Get the name of the specified cipher (int cipher): string',
	mcrypt_get_cipher_name: 'Get the name of the specified cipher (string cipher): string',
	mcrypt_get_iv_size: 'Returns the size of the IV belonging to a specific cipher/mode combination (string cipher, string mode): int',
	mcrypt_get_key_size: 'Get the key size of the specified cipher (int cipher): int',
	mcrypt_get_key_size: 'Get the key size of the specified cipher (string cipher, string module): int',
	mcrypt_list_algorithms: 'Get an array of all supported ciphers ([string lib_dir]): array',
	mcrypt_list_modes: 'Get an array of all supported modes ([string lib_dir]): array',
	mcrypt_module_close: 'Close the mcrypt module (resource td): bool',
	mcrypt_module_get_algo_block_size: 'Returns the blocksize of the specified algorithm (string algorithm, [string lib_dir]): int',
	mcrypt_module_get_algo_key_size: 'Returns the maximum supported keysize of the opened mode (string algorithm, [string lib_dir]): int',
	mcrypt_module_get_supported_key_sizes: 'Returns an array with the supported keysizes of the opened algorithm (string algorithm, [string lib_dir]): array',
	mcrypt_module_is_block_algorithm_mode: 'Returns if the specified module is a block algorithm or not (string mode, [string lib_dir]): bool',
	mcrypt_module_is_block_algorithm: 'This function checks whether the specified algorithm is a block algorithm (string algorithm, [string lib_dir]): bool',
	mcrypt_module_is_block_mode: 'Returns if the specified mode outputs blocks or not (string mode, [string lib_dir]): bool',
	mcrypt_module_open: 'Opens the module of the algorithm and the mode to be used (string algorithm, string algorithm_directory, string mode, string mode_directory): resource',
	mcrypt_module_self_test: 'This function runs a self test on the specified module (string algorithm, [string lib_dir]): bool',
	mcrypt_ofb: 'Encrypt/decrypt data in OFB mode (int cipher, string key, string data, int mode, string iv): string',
	mcrypt_ofb: 'Encrypt/decrypt data in OFB mode (string cipher, string key, string data, int mode, [string iv]): string',
	mdecrypt_generic: 'Decrypt data (resource td, string data): string',
	m_checkstatus: 'Check to see if a transaction has completed (resource conn, int identifier): int',
	m_completeauthorizations: 'Number of complete authorizations in queue, returning an array of their identifiers (resource conn, int &array): int',
	m_connect: 'Establish the connection to MCVE (resource conn): int',
	m_connectionerror: 'Get a textual representation of why a connection failed (resource conn): string',
	m_deletetrans: 'Delete specified transaction from MCVE_CONN structure (resource conn, int identifier): bool',
	m_destroyconn: 'Destroy the connection and MCVE_CONN structure (resource conn): bool',
	m_destroyengine: 'Free memory associated with IP/SSL connectivity (): null',
	m_getcell: 'Get a specific cell from a comma delimited response by column name (resource conn, int identifier, string column, int row): string',
	m_getcellbynum: 'Get a specific cell from a comma delimited response by column number (resource conn, int identifier, int column, int row): string',
	m_getcommadelimited: 'Get the RAW comma delimited data returned from MCVE (resource conn, int identifier): string',
	m_getheader: 'Get the name of the column in a comma-delimited response (resource conn, int identifier, int column_num): string',
	m_initconn: 'Create and initialize an MCVE_CONN structure (): resource',
	m_initengine: 'Ready the client for IP/SSL Communication (string location): int',
	m_iscommadelimited: 'Checks to see if response is comma delimited (resource conn, int identifier): int',
	m_maxconntimeout: 'The maximum amount of time the API will attempt a connection to MCVE (resource conn, int secs): bool',
	m_monitor: 'Perform communication with MCVE (send/receive data) Non-blocking (resource conn): int',
	m_numcolumns: 'Number of columns returned in a comma delimited response (resource conn, int identifier): int',
	m_numrows: 'Number of rows returned in a comma delimited response (resource conn, int identifier): int',
	m_parsecommadelimited: 'Parse the comma delimited response so m_getcell, etc will work (resource conn, int identifier): int',
	m_responsekeys: 'Returns array of strings which represents the keys that can be used for response parameters on this transaction (resource conn, int identifier): array',
	m_responseparam: 'Get a custom response parameter (resource conn, int identifier, string key): string',
	m_returnstatus: 'Check to see if the transaction was successful (resource conn, int identifier): int',
	m_setblocking: 'Set blocking/non-blocking mode for connection (resource conn, int tf): int',
	m_setdropfile: 'Set the connection method to Drop-File (resource conn, string directory): int',
	m_setip: 'Set the connection method to IP (resource conn, string host, int port): int',
	m_setssl_cafile: 'Set SSL CA (Certificate Authority) file for verification of server certificate (resource conn, string cafile): int',
	m_setssl_files: 'Set certificate key files and certificates if server requires client certificate verification (resource conn, string sslkeyfile, string sslcertfile): int',
	m_setssl: 'Set the connection method to SSL (resource conn, string host, int port): int',
	m_settimeout: 'Set maximum transaction time (per trans) (resource conn, int seconds): int',
	m_sslcert_gen_hash: 'Generate hash for SSL client certificate verification (string filename): string',
	m_transactionssent: 'Check to see if outgoing buffer is clear (resource conn): int',
	m_transinqueue: 'Number of transactions in client-queue (resource conn): int',
	m_transkeyval: 'Add key/value pair to a transaction. Replaces deprecated transparam() (resource conn, int identifier, string key, string value): int',
	m_transnew: 'Start a new transaction (resource conn): int',
	m_transsend: 'Finalize and send the transaction (resource conn, int identifier): int',
	m_uwait: 'Wait x microsecs (int microsecs): int',
	m_validateidentifier: 'Whether or not to validate the passed identifier on any transaction it is passed to (resource conn, int tf): int',
	m_verifyconnection: 'Set whether or not to PING upon connect to verify connection (resource conn, int tf): bool',
	m_verifysslcert: 'Set whether or not to verify the server ssl certificate (resource conn, int tf): bool',
	memcache_debug: 'Turn debug output on/off (bool on_off): bool',
	mhash_count: 'Get the highest available hash id (): int',
	mhash_get_block_size: 'Get the block size of the specified hash (int hash): int',
	mhash_get_hash_name: 'Get the name of the specified hash (int hash): string',
	mhash_keygen_s2k: 'Generates a key (int hash, string password, string salt, int bytes): string',
	mhash: 'Compute hash (int hash, string data, [string key]): string',
	ming_keypress: 'Returns the action flag for keyPress(char) (string char): int',
	ming_setcubicthreshold: 'Set cubic threshold (int threshold): null',
	ming_setscale: 'Set the global scaling factor. (float scale): null',
	ming_setswfcompression: 'Sets the SWF output compression (int level): null',
	ming_useconstants: 'Use constant pool (int use): null',
	ming_useswfversion: 'Sets the SWF version (int version): null',
	connection_aborted: 'Check whether client disconnected (): int',
	connection_status: 'Returns connection status bitfield (): int',
	connection_timeout: 'Check if the script timed out (): int',
	constant: 'Returns the value of a constant (string name): mixed',
	define: 'Defines a named constant (string name, mixed value, [bool case_insensitive]): bool',
	defined: 'Checks whether a given named constant exists (string name): bool',
	die: 'Equivalent to exit',
	eval: 'Evaluate a string as PHP code (string code_str): mixed',
	exit: 'Output a message and terminate the current script ([string status]): null',
	exit: 'Output a message and terminate the current script (int status): null',
	get_browser: 'Tells what the user\'s browser is capable of ([string user_agent, [bool return_array]]): mixed',
	__halt_compiler: 'Halts the compiler execution (): null',
	highlight_file: 'Syntax highlighting of a file (string filename, [bool return]): mixed',
	highlight_string: 'Syntax highlighting of a string (string str, [bool return]): mixed',
	ignore_user_abort: 'Set whether a client disconnect should abort script execution ([string value]): int',
	pack: 'Pack data into binary string (string format, [mixed args, [mixed ...]]): string',
	php_check_syntax: 'Check the PHP syntax of (and execute) the specified file (string filename, [string &error_message]): bool',
	php_strip_whitespace: 'Return source with stripped comments and whitespace (string filename): string',
	show_source: 'Alias of highlight_file',
	sleep: 'Delay execution (int seconds): int',
	sys_getloadavg: 'Gets system load average (): array',
	time_nanosleep: 'Delay for a number of seconds and nanoseconds (int seconds, int nanoseconds): mixed',
	time_sleep_until: 'Make the script sleep until the specified time (float timestamp): bool',
	uniqid: 'Generate a unique ID ([string prefix, [bool more_entropy]]): string',
	unpack: 'Unpack data from binary string (string format, string data): array',
	usleep: 'Delay execution in microseconds (int micro_seconds): null',
	udm_add_search_limit: 'Add various search limits (resource agent, int var, string val): bool',
	udm_alloc_agent_array: 'Allocate mnoGoSearch session (array databases): resource',
	udm_alloc_agent: 'Allocate mnoGoSearch session (string dbaddr, [string dbmode]): resource',
	udm_api_version: 'Get mnoGoSearch API version (): int',
	udm_cat_list: 'Get all the categories on the same level with the current one (resource agent, string category): array',
	udm_cat_path: 'Get the path to the current category (resource agent, string category): array',
	udm_check_charset: 'Check if the given charset is known to mnogosearch (resource agent, string charset): bool',
	udm_check_stored: 'Check connection to stored (resource agent, int link, string doc_id): int',
	udm_clear_search_limits: 'Clear all mnoGoSearch search restrictions (resource agent): bool',
	udm_close_stored: 'Close connection to stored (resource agent, int link): int',
	udm_crc32: 'Return CRC32 checksum of given string (resource agent, string str): int',
	udm_errno: 'Get mnoGoSearch error number (resource agent): int',
	udm_error: 'Get mnoGoSearch error message (resource agent): string',
	udm_find: 'Perform search (resource agent, string query): resource',
	udm_free_agent: 'Free mnoGoSearch session (resource agent): int',
	udm_free_ispell_data: 'Free memory allocated for ispell data (int agent): bool',
	udm_free_res: 'Free mnoGoSearch result (resource res): bool',
	udm_get_doc_count: 'Get total number of documents in database (resource agent): int',
	udm_get_res_field: 'Fetch a result field (resource res, int row, int field): string',
	udm_get_res_param: 'Get mnoGoSearch result parameters (resource res, int param): string',
	udm_hash32: 'Return Hash32 checksum of gived string (resource agent, string str): int',
	udm_load_ispell_data: 'Load ispell data (resource agent, int var, string val1, string val2, int flag): bool',
	udm_open_stored: 'Open connection to stored (resource agent, string storedaddr): int',
	udm_set_agent_param: 'Set mnoGoSearch agent session parameters (resource agent, int var, string val): bool',
	bson_decode: 'Deserializes a BSON object into a PHP array (string bson): array',
	bson_encode: 'Serializes a PHP variable into a BSON string (mixed anything): string',
	mqseries_back: 'MQSeries MQBACK (resource hconn, resource &compCode, resource &reason): null',
	mqseries_begin: 'MQseries MQBEGIN (resource hconn, array beginOptions, resource &compCode, resource &reason): null',
	mqseries_close: 'MQSeries MQCLOSE (resource hconn, resource hobj, int options, resource &compCode, resource &reason): null',
	mqseries_cmit: 'MQSeries MQCMIT (resource hconn, resource &compCode, resource &reason): null',
	mqseries_conn: 'MQSeries MQCONN (string qManagerName, resource &hconn, resource &compCode, resource &reason): null',
	mqseries_connx: 'MQSeries MQCONNX (string qManagerName, array &connOptions, resource &hconn, resource &compCode, resource &reason): null',
	mqseries_disc: 'MQSeries MQDISC (resource hconn, resource &compCode, resource &reason): null',
	mqseries_get: 'MQSeries MQGET (resource hConn, resource hObj, array &md, array &gmo, int &bufferLength, string &msg, int &data_length, resource &compCode, resource &reason): null',
	mqseries_inq: 'MQSeries MQINQ (resource hconn, resource hobj, int selectorCount, array selectors, int intAttrCount, resource &intAttr, int charAttrLength, resource &charAttr, resource &compCode, resource &reason): null',
	mqseries_open: 'MQSeries MQOPEN (resource hconn, array &objDesc, int option, resource &hobj, resource &compCode, resource &reason): null',
	mqseries_put: 'MQSeries MQPUT (resource hConn, resource hObj, array &md, array &pmo, string message, resource &compCode, resource &reason): null',
	mqseries_put1: 'MQSeries MQPUT1 (resource hconn, resource &objDesc, resource &msgDesc, resource &pmo, string buffer, resource &compCode, resource &reason): null',
	mqseries_set: 'MQSeries MQSET (resource hconn, resource hobj, int selectorcount, array selectors, int intattrcount, array intattrs, int charattrlength, array charattrs, resource &compCode, resource &reason): null',
	mqseries_strerror: 'Returns the error message corresponding to a result code (MQRC). (int reason): string',
	msession_connect: 'Connect to msession server (string host, string port): bool',
	msession_count: 'Get session count (): int',
	msession_create: 'Create a session (string session, [string classname, [string data]]): bool',
	msession_destroy: 'Destroy a session (string name): bool',
	msession_disconnect: 'Close connection to msession server (): null',
	msession_find: 'Find all sessions with name and value (string name, string value): array',
	msession_get_array: 'Get array of msession variables (string session): array',
	msession_get_data: 'Get data session unstructured data (string session): string',
	msession_get: 'Get value from session (string session, string name, string value): string',
	msession_inc: 'Increment value in session (string session, string name): string',
	msession_list: 'List all sessions (): array',
	msession_listvar: 'List sessions with variable (string name): array',
	msession_lock: 'Lock a session (string name): int',
	msession_plugin: 'Call an escape function within the msession personality plugin (string session, string val, [string param]): string',
	msession_randstr: 'Get random string (int param): string',
	msession_set_array: 'Set msession variables from an array (string session, array tuples): null',
	msession_set_data: 'Set data session unstructured data (string session, string value): bool',
	msession_set: 'Set value in session (string session, string name, string value): bool',
	msession_timeout: 'Set/get session timeout (string session, [int param]): int',
	msession_uniq: 'Get unique id (int param, [string classname, [string data]]): string',
	msession_unlock: 'Unlock a session (string session, int key): int',
	msql_affected_rows: 'Returns number of affected rows (resource result): int',
	msql_close: 'Close mSQL connection ([resource link_identifier]): bool',
	msql_connect: 'Open mSQL connection ([string hostname]): resource',
	msql_create_db: 'Create mSQL database (string database_name, [resource link_identifier]): bool',
	msql_createdb: 'Alias of msql_create_db',
	msql_data_seek: 'Move internal row pointer (resource result, int row_number): bool',
	msql_db_query: 'Send mSQL query (string database, string query, [resource link_identifier]): resource',
	msql_dbname: 'Alias of msql_result',
	msql_drop_db: 'Drop (delete) mSQL database (string database_name, [resource link_identifier]): bool',
	msql_error: 'Returns error message of last msql call (): string',
	msql_fetch_array: 'Fetch row as array (resource result, [int result_type]): array',
	msql_fetch_field: 'Get field information (resource result, [int field_offset]): object',
	msql_fetch_object: 'Fetch row as object (resource result, [int result_type]): object',
	msql_fetch_row: 'Get row as enumerated array (resource result, [int result_type]): array',
	msql_field_flags: 'Get field flags (resource result, int field_offset): string',
	msql_field_len: 'Get field length (resource result, int field_offset): int',
	msql_field_name: 'Get the name of the specified field in a result (resource result, int field_offset): string',
	msql_field_seek: 'Set field offset (resource result, int field_offset): bool',
	msql_field_table: 'Get table name for field (resource result, int field_offset): int',
	msql_field_type: 'Get field type (resource result, int field_offset): string',
	msql_fieldflags: 'Alias of msql_field_flags',
	msql_fieldlen: 'Alias of msql_field_len',
	msql_fieldname: 'Alias of msql_field_name',
	msql_fieldtable: 'Alias of msql_field_table',
	msql_fieldtype: 'Alias of msql_field_type',
	msql_free_result: 'Free result memory (resource result): bool',
	msql_list_dbs: 'List mSQL databases on server ([resource link_identifier]): resource',
	msql_list_fields: 'List result fields (string database, string tablename, [resource link_identifier]): resource',
	msql_list_tables: 'List tables in an mSQL database (string database, [resource link_identifier]): resource',
	msql_num_fields: 'Get number of fields in result (resource result): int',
	msql_num_rows: 'Get number of rows in result (resource query_identifier): int',
	msql_numfields: 'Alias of msql_num_fields',
	msql_numrows: 'Alias of msql_num_rows',
	msql_pconnect: 'Open persistent mSQL connection ([string hostname]): resource',
	msql_query: 'Send mSQL query (string query, [resource link_identifier]): resource',
	msql_regcase: 'Alias of sql_regcase',
	msql_result: 'Get result data (resource result, int row, [mixed field]): string',
	msql_select_db: 'Select mSQL database (string database_name, [resource link_identifier]): bool',
	msql_tablename: 'Alias of msql_result',
	msql: 'Alias of msql_db_query',
	mssql_bind: 'Adds a parameter to a stored procedure or a remote stored procedure (resource stmt, string param_name, mixed &var, int type, [bool is_output, [bool is_null, [int maxlen]]]): bool',
	mssql_close: 'Close MS SQL Server connection ([resource link_identifier]): bool',
	mssql_connect: 'Open MS SQL server connection ([string servername, [string username, [string password, [bool new_link]]]]): resource',
	mssql_data_seek: 'Moves internal row pointer (resource result_identifier, int row_number): bool',
	mssql_execute: 'Executes a stored procedure on a MS SQL server database (resource stmt, [bool skip_results]): mixed',
	mssql_fetch_array: 'Fetch a result row as an associative array, a numeric array, or both (resource result, [int result_type]): array',
	mssql_fetch_assoc: 'Returns an associative array of the current row in the result (resource result_id): array',
	mssql_fetch_batch: 'Returns the next batch of records (resource result): int',
	mssql_fetch_field: 'Get field information (resource result, [int field_offset]): object',
	mssql_fetch_object: 'Fetch row as object (resource result): object',
	mssql_fetch_row: 'Get row as enumerated array (resource result): array',
	mssql_field_length: 'Get the length of a field (resource result, [int offset]): int',
	mssql_field_name: 'Get the name of a field (resource result, [int offset]): string',
	mssql_field_seek: 'Seeks to the specified field offset (resource result, int field_offset): bool',
	mssql_field_type: 'Gets the type of a field (resource result, [int offset]): string',
	mssql_free_result: 'Free result memory (resource result): bool',
	mssql_free_statement: 'Free statement memory (resource stmt): bool',
	mssql_get_last_message: 'Returns the last message from the server (): string',
	mssql_guid_string: 'Converts a 16 byte binary GUID to a string (string binary, [bool short_format]): string',
	mssql_init: 'Initializes a stored procedure or a remote stored procedure (string sp_name, [resource link_identifier]): resource',
	mssql_min_error_severity: 'Sets the minimum error severity (int severity): null',
	mssql_min_message_severity: 'Sets the minimum message severity (int severity): null',
	mssql_next_result: 'Move the internal result pointer to the next result (resource result_id): bool',
	mssql_num_fields: 'Gets the number of fields in result (resource result): int',
	mssql_num_rows: 'Gets the number of rows in result (resource result): int',
	mssql_pconnect: 'Open persistent MS SQL connection ([string servername, [string username, [string password, [bool new_link]]]]): resource',
	mssql_query: 'Send MS SQL query (string query, [resource link_identifier, [int batch_size]]): mixed',
	mssql_result: 'Get result data (resource result, int row, mixed field): string',
	mssql_rows_affected: 'Returns the number of records affected by the query (resource link_identifier): int',
	mssql_select_db: 'Select MS SQL database (string database_name, [resource link_identifier]): bool',
	mysql_affected_rows: 'Get number of affected rows in previous MySQL operation ([resource link_identifier]): int',
	mysql_client_encoding: 'Returns the name of the character set ([resource link_identifier]): string',
	mysql_close: 'Close MySQL connection ([resource link_identifier]): bool',
	mysql_connect: 'Open a connection to a MySQL Server ([string server, [string username, [string password, [bool new_link, [int client_flags]]]]]): resource',
	mysql_create_db: 'Create a MySQL database (string database_name, [resource link_identifier]): bool',
	mysql_data_seek: 'Move internal result pointer (resource result, int row_number): bool',
	mysql_db_name: 'Get result data (resource result, int row, [mixed field]): string',
	mysql_db_query: 'Send a MySQL query (string database, string query, [resource link_identifier]): resource',
	mysql_drop_db: 'Drop (delete) a MySQL database (string database_name, [resource link_identifier]): bool',
	mysql_errno: 'Returns the numerical value of the error message from previous MySQL operation ([resource link_identifier]): int',
	mysql_error: 'Returns the text of the error message from previous MySQL operation ([resource link_identifier]): string',
	mysql_escape_string: 'Escapes a string for use in a mysql_query (string unescaped_string): string',
	mysql_fetch_array: 'Fetch a result row as an associative array, a numeric array, or both (resource result, [int result_type]): array',
	mysql_fetch_assoc: 'Fetch a result row as an associative array (resource result): array',
	mysql_fetch_field: 'Get column information from a result and return as an object (resource result, [int field_offset]): object',
	mysql_fetch_lengths: 'Get the length of each output in a result (resource result): array',
	mysql_fetch_object: 'Fetch a result row as an object (resource result, [string class_name, [array params]]): object',
	mysql_fetch_row: 'Get a result row as an enumerated array (resource result): array',
	mysql_field_flags: 'Get the flags associated with the specified field in a result (resource result, int field_offset): string',
	mysql_field_len: 'Returns the length of the specified field (resource result, int field_offset): int',
	mysql_field_name: 'Get the name of the specified field in a result (resource result, int field_offset): string',
	mysql_field_seek: 'Set result pointer to a specified field offset (resource result, int field_offset): bool',
	mysql_field_table: 'Get name of the table the specified field is in (resource result, int field_offset): string',
	mysql_field_type: 'Get the type of the specified field in a result (resource result, int field_offset): string',
	mysql_free_result: 'Free result memory (resource result): bool',
	mysql_get_client_info: 'Get MySQL client info (): string',
	mysql_get_host_info: 'Get MySQL host info ([resource link_identifier]): string',
	mysql_get_proto_info: 'Get MySQL protocol info ([resource link_identifier]): int',
	mysql_get_server_info: 'Get MySQL server info ([resource link_identifier]): string',
	mysql_info: 'Get information about the most recent query ([resource link_identifier]): string',
	mysql_insert_id: 'Get the ID generated in the last query ([resource link_identifier]): int',
	mysql_list_dbs: 'List databases available on a MySQL server ([resource link_identifier]): resource',
	mysql_list_fields: 'List MySQL table fields (string database_name, string table_name, [resource link_identifier]): resource',
	mysql_list_processes: 'List MySQL processes ([resource link_identifier]): resource',
	mysql_list_tables: 'List tables in a MySQL database (string database, [resource link_identifier]): resource',
	mysql_num_fields: 'Get number of fields in result (resource result): int',
	mysql_num_rows: 'Get number of rows in result (resource result): int',
	mysql_pconnect: 'Open a persistent connection to a MySQL server ([string server, [string username, [string password, [int client_flags]]]]): resource',
	mysql_pconnect: 'Open a persistent connection to a MySQL server ([string server, [string username, [string password, [bool new_link, [int client_flags]]]]]): resource',
	mysql_ping: 'Ping a server connection or reconnect if there is no connection ([resource link_identifier]): bool',
	mysql_query: 'Send a MySQL query (string query, [resource link_identifier]): resource',
	mysql_real_escape_string: 'Escapes special characters in a string for use in a SQL statement (string unescaped_string, [resource link_identifier]): string',
	mysql_result: 'Get result data (resource result, int row, [mixed field]): string',
	mysql_select_db: 'Select a MySQL database (string database_name, [resource link_identifier]): bool',
	mysql_set_charset: 'Sets the client character set (string charset, [resource link_identifier]): bool',
	mysql_stat: 'Get current system status ([resource link_identifier]): string',
	mysql_tablename: 'Get table name of field (resource result, int i): string',
	mysql_thread_id: 'Return the current thread ID ([resource link_identifier]): int',
	mysql_unbuffered_query: 'Send an SQL query to MySQL without fetching and buffering the result rows. (string query, [resource link_identifier]): resource',
	mysqli_bind_param: 'Alias for mysqli_stmt_bind_param',
	mysqli_bind_result: 'Alias for mysqli_stmt_bind_result',
	mysqli_client_encoding: 'Alias of mysqli_character_set_name',
	mysqli_connect: 'Alias of mysqli::__construct',
	mysqli_disable_reads_from_master: 'Disable reads from master (mysqli link): bool',
	mysqli_disable_rpl_parse: 'Disable RPL parse (mysqli link): bool',
	mysqli_enable_reads_from_master: 'Enable reads from master (mysqli link): bool',
	mysqli_enable_rpl_parse: 'Enable RPL parse (mysqli link): bool',
	mysqli_escape_string: 'Alias of mysqli_real_escape_string',
	mysqli_execute: 'Alias for mysqli_stmt_execute',
	mysqli_fetch: 'Alias for mysqli_stmt_fetch',
	mysqli_get_cache_stats: 'Returns client Zval cache statistics (): array',
	mysqli_get_client_stats: 'Returns client per-process statistics (): array',
	mysqli_get_metadata: 'Alias for mysqli_stmt_result_metadata',
	mysqli_master_query: 'Enforce execution of a query on the master in a master/slave setup (mysqli link, string query): bool',
	mysqli_param_count: 'Alias for mysqli_stmt_param_count',
	mysqli_report: 'Enables or disables internal report functions (int flags): bool',
	mysqli_rpl_parse_enabled: 'Check if RPL parse is enabled (mysqli link): int',
	mysqli_rpl_probe: 'RPL probe (mysqli link): bool',
	mysqli_rpl_query_type: 'Returns RPL query type (mysqli link, string query): int',
	mysqli_send_long_data: 'Alias for mysqli_stmt_send_long_data',
	mysqli_send_query: 'Send the query and return (mysqli link, string query): bool',
	mysqli_set_opt: 'Alias of mysqli_options',
	mysqli_slave_query: 'Force execution of a query on a slave in a master/slave setup (mysqli link, string query): bool',
	mysqli_affected_rows: 'Gets the number of affected rows in a previous MySQL operation (mysqli link): int',
	mysqli_autocommit: 'Turns on or off auto-commiting database modifications (mysqli link, bool mode): bool',
	mysqli_change_user: 'Changes the user of the specified database connection (mysqli link, string user, string password, string database): bool',
	mysqli_character_set_name: 'Returns the default character set for the database connection (mysqli link): string',
	mysqli_get_client_info: 'Returns the MySQL client version as a string (mysqli link): string',
	mysqli_get_client_version: 'Get MySQL client info (mysqli link): int',
	mysqli_close: 'Closes a previously opened database connection (mysqli link): bool',
	mysqli_commit: 'Commits the current transaction (mysqli link): bool',
	mysqli_connect_errno: 'Returns the error code from last connect call (): int',
	mysqli_connect_error: 'Returns a string description of the last connect error (): string',
	mysqli_connect: 'Open a new connection to the MySQL server ([string host, [string username, [string passwd, [string dbname, [int port, [string socket]]]]]]): mysqli',
	mysqli_debug: 'Performs debugging operations (string message): bool',
	mysqli_dump_debug_info: 'Dump debugging information into the log (mysqli link): bool',
	mysqli_errno: 'Returns the error code for the most recent function call (mysqli link): int',
	mysqli_error: 'Returns a string description of the last error (mysqli link): string',
	mysqli_field_count: 'Returns the number of columns for the most recent query (mysqli link): int',
	mysqli_get_charset: 'Returns a character set object (mysqli link): object',
	mysqli_get_client_info: 'Returns the MySQL client version as a string (mysqli link): string',
	mysqli_get_client_version: 'Get MySQL client info (mysqli link): int',
	mysqli_get_connection_stats: 'Returns statistics about the client connection (mysqli link): array',
	mysqli_get_host_info: 'Returns a string representing the type of connection used (mysqli link): string',
	mysqli_get_proto_info: 'Returns the version of the MySQL protocol used (mysqli link): int',
	mysqli_get_server_info: 'Returns the version of the MySQL server (mysqli link): string',
	mysqli_get_server_version: 'Returns the version of the MySQL server as an integer (mysqli link): int',
	mysqli_get_warnings: 'Get result of SHOW WARNINGS (mysqli link): mysqli_warnings',
	mysqli_info: 'Retrieves information about the most recently executed query (mysqli link): string',
	mysqli_init: 'Initializes MySQLi and returns a resource for use with mysqli_real_connect() (): mysqli',
	mysqli_insert_id: 'Returns the auto generated id used in the last query (mysqli link): mixed',
	mysqli_kill: 'Asks the server to kill a MySQL thread (mysqli link, int processid): bool',
	mysqli_more_results: 'Check if there are any more query results from a multi query (mysqli link): bool',
	mysqli_multi_query: 'Performs a query on the database (mysqli link, string query): bool',
	mysqli_next_result: 'Prepare next result from multi_query (mysqli link): bool',
	mysqli_options: 'Set options (mysqli link, int option, mixed value): bool',
	mysqli_ping: 'Pings a server connection, or tries to reconnect if the connection has gone down (mysqli link): bool',
	mysqli_poll: 'Poll connections (array &read, array &error, array &reject, int sec, [int usec]): int',
	mysqli_prepare: 'Prepare a SQL statement for execution (mysqli link, string query): mysqli_stmt',
	mysqli_query: 'Performs a query on the database (mysqli link, string query, [int resultmode]): mixed',
	mysqli_real_connect: 'Opens a connection to a mysql server (mysqli link, [string host, [string username, [string passwd, [string dbname, [int port, [string socket, [int flags]]]]]]]): bool',
	mysqli_real_escape_string: 'Escapes special characters in a string for use in a SQL statement, taking into account the current charset of the connection (mysqli link, string escapestr): string',
	mysqli_real_query: 'Execute an SQL query (mysqli link, string query): bool',
	mysqli_reap_async_query: 'Get result from async query (mysql link): mysqli_result',
	mysqli_rollback: 'Rolls back current transaction (mysqli link): bool',
	mysqli_select_db: 'Selects the default database for database queries (mysqli link, string dbname): bool',
	mysqli_set_charset: 'Sets the default client character set (mysqli link, string charset): bool',
	mysqli_set_local_infile_default: 'Unsets user defined handler for load local infile command (mysqli link): null',
	mysqli_set_local_infile_handler: 'Set callback function for LOAD DATA LOCAL INFILE command (mysqli link, callback read_func): bool',
	mysqli_sqlstate: 'Returns the SQLSTATE error from previous MySQL operation (mysqli link): string',
	mysqli_ssl_set: 'Used for establishing secure connections using SSL (mysqli link, string key, string cert, string ca, string capath, string cipher): bool',
	mysqli_stat: 'Gets the current system status (mysqli link): string',
	mysqli_stmt_init: 'Initializes a statement and returns an object for use with mysqli_stmt_prepare (mysqli link): mysqli_stmt',
	mysqli_store_result: 'Transfers a result set from the last query (mysqli link): mysqli_result',
	mysqli_thread_id: 'Returns the thread ID for the current connection (mysqli link): int',
	mysqli_thread_safe: 'Returns whether thread safety is given or not (): bool',
	mysqli_use_result: 'Initiate a result set retrieval (mysqli link): mysqli_result',
	mysqli_warning_count: 'Returns the number of warnings from the last query for the given link (mysqli link): int',
	mysqli_embedded_server_end: 'Stop embedded server (): null',
	mysqli_embedded_server_start: 'Initialize and start embedded server (bool start, array arguments, array groups): bool',
	mysqli_field_tell: 'Get current field offset of a result pointer (mysqli_result result): int',
	mysqli_data_seek: 'Adjusts the result pointer to an arbitary row in the result (mysqli_result result, int offset): bool',
	mysqli_fetch_all: 'Fetches all result rows as an associative array, a numeric array, or both (mysqli_result result, [int resulttype]): mixed',
	mysqli_fetch_array: 'Fetch a result row as an associative, a numeric array, or both (mysqli_result result, [int resulttype]): mixed',
	mysqli_fetch_assoc: 'Fetch a result row as an associative array (mysqli_result result): array',
	mysqli_fetch_field_direct: 'Fetch meta-data for a single field (mysqli_result result, int fieldnr): object',
	mysqli_fetch_field: 'Returns the next field in the result set (mysqli_result result): object',
	mysqli_fetch_fields: 'Returns an array of objects representing the fields in a result set (mysqli_result result): array',
	mysqli_fetch_object: 'Returns the current row of a result set as an object (mysqli_result result, [string class_name, [array params]]): object',
	mysqli_fetch_row: 'Get a result row as an enumerated array (mysqli_result result): mixed',
	mysqli_num_fields: 'Get the number of fields in a result (mysqli_result result): int',
	mysqli_field_seek: 'Set result pointer to a specified field offset (mysqli_result result, int fieldnr): bool',
	mysqli_free_result: 'Frees the memory associated with a result (mysqli_result result): null',
	mysqli_fetch_lengths: 'Returns the lengths of the columns of the current row in the result set (mysqli_result result): array',
	mysqli_num_rows: 'Gets the number of rows in a result (mysqli_result result): int',
	mysqli_stmt_affected_rows: 'Returns the total number of rows changed, deleted, or inserted by the last executed statement (mysqli_stmt stmt): int',
	mysqli_stmt_attr_get: 'Used to get the current value of a statement attribute (mysqli_stmt stmt, int attr): int',
	mysqli_stmt_attr_set: 'Used to modify the behavior of a prepared statement (mysqli_stmt stmt, int attr, int mode): bool',
	mysqli_stmt_bind_param: 'Binds variables to a prepared statement as parameters (mysqli_stmt stmt, string types, mixed &var1, [mixed &...]): bool',
	mysqli_stmt_bind_result: 'Binds variables to a prepared statement for result storage (mysqli_stmt stmt, mixed &var1, [mixed &...]): bool',
	mysqli_stmt_close: 'Closes a prepared statement (mysqli_stmt stmt): bool',
	mysqli_stmt_data_seek: 'Seeks to an arbitrary row in statement result set (mysqli_stmt stmt, int offset): null',
	mysqli_stmt_errno: 'Returns the error code for the most recent statement call (mysqli_stmt stmt): int',
	mysqli_stmt_error: 'Returns a string description for last statement error (mysqli_stmt stmt): string',
	mysqli_stmt_execute: 'Executes a prepared Query (mysqli_stmt stmt): bool',
	mysqli_stmt_fetch: 'Fetch results from a prepared statement into the bound variables (mysqli_stmt stmt): bool',
	mysqli_stmt_field_count: 'Returns the number of field in the given statement (mysqli_stmt stmt): int',
	mysqli_stmt_free_result: 'Frees stored result memory for the given statement handle (mysqli_stmt stmt): null',
	mysqli_stmt_get_warnings: 'Get result of SHOW WARNINGS (mysqli_stmt stmt): object',
	mysqli_stmt_insert_id: 'Get the ID generated from the previous INSERT operation (mysqli_stmt stmt): mixed',
	mysqli_stmt_num_rows: 'Return the number of rows in statements result set (mysqli_stmt stmt): int',
	mysqli_stmt_param_count: 'Returns the number of parameter for the given statement (mysqli_stmt stmt): int',
	mysqli_stmt_prepare: 'Prepare a SQL statement for execution (mysqli_stmt stmt, string query): bool',
	mysqli_stmt_reset: 'Resets a prepared statement (mysqli_stmt stmt): bool',
	mysqli_stmt_result_metadata: 'Returns result set metadata from a prepared statement (mysqli_stmt stmt): mysqli_result',
	mysqli_stmt_send_long_data: 'Send data in blocks (mysqli_stmt stmt, int param_nr, string data): bool',
	mysqli_stmt_sqlstate: 'Returns SQLSTATE error from previous statement operation (mysqli_stmt stmt): string',
	mysqli_stmt_store_result: 'Transfers a result set from a prepared statement (mysqli_stmt stmt): bool',
	ncurses_addch: 'Add character at current position and advance cursor (int ch): int',
	ncurses_addchnstr: 'Add attributed string with specified length at current position (string s, int n): int',
	ncurses_addchstr: 'Add attributed string at current position (string s): int',
	ncurses_addnstr: 'Add string with specified length at current position (string s, int n): int',
	ncurses_addstr: 'Output text at current position (string text): int',
	ncurses_assume_default_colors: 'Define default colors for color 0 (int fg, int bg): int',
	ncurses_attroff: 'Turn off the given attributes (int attributes): int',
	ncurses_attron: 'Turn on the given attributes (int attributes): int',
	ncurses_attrset: 'Set given attributes (int attributes): int',
	ncurses_baudrate: 'Returns baudrate of terminal (): int',
	ncurses_beep: 'Let the terminal beep (): int',
	ncurses_bkgd: 'Set background property for terminal screen (int attrchar): int',
	ncurses_bkgdset: 'Control screen background (int attrchar): null',
	ncurses_border: 'Draw a border around the screen using attributed characters (int left, int right, int top, int bottom, int tl_corner, int tr_corner, int bl_corner, int br_corner): int',
	ncurses_bottom_panel: 'Moves a visible panel to the bottom of the stack (resource panel): int',
	ncurses_can_change_color: 'Checks if terminal color definitions can be changed (): bool',
	ncurses_cbreak: 'Switch of input buffering (): bool',
	ncurses_clear: 'Clear screen (): bool',
	ncurses_clrtobot: 'Clear screen from current position to bottom (): bool',
	ncurses_clrtoeol: 'Clear screen from current position to end of line (): bool',
	ncurses_color_content: 'Retrieves RGB components of a color (int color, int &r, int &g, int &b): int',
	ncurses_color_set: 'Set active foreground and background colors (int pair): int',
	ncurses_curs_set: 'Set cursor state (int visibility): int',
	ncurses_def_prog_mode: 'Saves terminals (program) mode (): bool',
	ncurses_def_shell_mode: 'Saves terminals (shell) mode (): bool',
	ncurses_define_key: 'Define a keycode (string definition, int keycode): int',
	ncurses_del_panel: 'Remove panel from the stack and delete it (but not the associated window) (resource panel): bool',
	ncurses_delay_output: 'Delay output on terminal using padding characters (int milliseconds): int',
	ncurses_delch: 'Delete character at current position, move rest of line left (): bool',
	ncurses_deleteln: 'Delete line at current position, move rest of screen up (): bool',
	ncurses_delwin: 'Delete a ncurses window (resource window): bool',
	ncurses_doupdate: 'Write all prepared refreshes to terminal (): bool',
	ncurses_echo: 'Activate keyboard input echo (): bool',
	ncurses_echochar: 'Single character output including refresh (int character): int',
	ncurses_end: 'Stop using ncurses, clean up the screen (): int',
	ncurses_erase: 'Erase terminal screen (): bool',
	ncurses_erasechar: 'Returns current erase character (): string',
	ncurses_filter: 'Set LINES for iniscr() and newterm() to 1 (): null',
	ncurses_flash: 'Flash terminal screen (visual bell) (): bool',
	ncurses_flushinp: 'Flush keyboard input buffer (): bool',
	ncurses_getch: 'Read a character from keyboard (): int',
	ncurses_getmaxyx: 'Returns the size of a window (resource window, int &y, int &x): null',
	ncurses_getmouse: 'Reads mouse event (array &mevent): bool',
	ncurses_getyx: 'Returns the current cursor position for a window (resource window, int &y, int &x): null',
	ncurses_halfdelay: 'Put terminal into halfdelay mode (int tenth): int',
	ncurses_has_colors: 'Checks if terminal has color capabilities (): bool',
	ncurses_has_ic: 'Check for insert- and delete-capabilities (): bool',
	ncurses_has_il: 'Check for line insert- and delete-capabilities (): bool',
	ncurses_has_key: 'Check for presence of a function key on terminal keyboard (int keycode): int',
	ncurses_hide_panel: 'Remove panel from the stack, making it invisible (resource panel): int',
	ncurses_hline: 'Draw a horizontal line at current position using an attributed character and max. n characters long (int charattr, int n): int',
	ncurses_inch: 'Get character and attribute at current position (): string',
	ncurses_init_color: 'Define a terminal color (int color, int r, int g, int b): int',
	ncurses_init_pair: 'Define a color pair (int pair, int fg, int bg): int',
	ncurses_init: 'Initialize ncurses (): null',
	ncurses_insch: 'Insert character moving rest of line including character at current position (int character): int',
	ncurses_insdelln: 'Insert lines before current line scrolling down (negative numbers delete and scroll up) (int count): int',
	ncurses_insertln: 'Insert a line, move rest of screen down (): int',
	ncurses_insstr: 'Insert string at current position, moving rest of line right (string text): int',
	ncurses_instr: 'Reads string from terminal screen (string &buffer): int',
	ncurses_isendwin: 'Ncurses is in endwin mode, normal screen output may be performed (): bool',
	ncurses_keyok: 'Enable or disable a keycode (int keycode, bool enable): int',
	ncurses_keypad: 'Turns keypad on or off (resource window, bool bf): int',
	ncurses_killchar: 'Returns current line kill character (): string',
	ncurses_longname: 'Returns terminals description (): string',
	ncurses_meta: 'Enables/Disable 8-bit meta key information (resource window, bool 8bit): int',
	ncurses_mouse_trafo: 'Transforms coordinates (int &y, int &x, bool toscreen): bool',
	ncurses_mouseinterval: 'Set timeout for mouse button clicks (int milliseconds): int',
	ncurses_mousemask: 'Sets mouse options (int newmask, int &oldmask): int',
	ncurses_move_panel: 'Moves a panel so that its upper-left corner is at [startx, starty] (resource panel, int startx, int starty): int',
	ncurses_move: 'Move output position (int y, int x): int',
	ncurses_mvaddch: 'Move current position and add character (int y, int x, int c): int',
	ncurses_mvaddchnstr: 'Move position and add attributed string with specified length (int y, int x, string s, int n): int',
	ncurses_mvaddchstr: 'Move position and add attributed string (int y, int x, string s): int',
	ncurses_mvaddnstr: 'Move position and add string with specified length (int y, int x, string s, int n): int',
	ncurses_mvaddstr: 'Move position and add string (int y, int x, string s): int',
	ncurses_mvcur: 'Move cursor immediately (int old_y, int old_x, int new_y, int new_x): int',
	ncurses_mvdelch: 'Move position and delete character, shift rest of line left (int y, int x): int',
	ncurses_mvgetch: 'Move position and get character at new position (int y, int x): int',
	ncurses_mvhline: 'Set new position and draw a horizontal line using an attributed character and max. n characters long (int y, int x, int attrchar, int n): int',
	ncurses_mvinch: 'Move position and get attributed character at new position (int y, int x): int',
	ncurses_mvvline: 'Set new position and draw a vertical line using an attributed character and max. n characters long (int y, int x, int attrchar, int n): int',
	ncurses_mvwaddstr: 'Add string at new position in window (resource window, int y, int x, string text): int',
	ncurses_napms: 'Sleep (int milliseconds): int',
	ncurses_new_panel: 'Create a new panel and associate it with window (resource window): resource',
	ncurses_newpad: 'Creates a new pad (window) (int rows, int cols): resource',
	ncurses_newwin: 'Create a new window (int rows, int cols, int y, int x): resource',
	ncurses_nl: 'Translate newline and carriage return / line feed (): bool',
	ncurses_nocbreak: 'Switch terminal to cooked mode (): bool',
	ncurses_noecho: 'Switch off keyboard input echo (): bool',
	ncurses_nonl: 'Do not translate newline and carriage return / line feed (): bool',
	ncurses_noqiflush: 'Do not flush on signal characters (): null',
	ncurses_noraw: 'Switch terminal out of raw mode (): bool',
	ncurses_pair_content: 'Retrieves foreground and background colors of a color pair (int pair, int &f, int &b): int',
	ncurses_panel_above: 'Returns the panel above panel (resource panel): resource',
	ncurses_panel_below: 'Returns the panel below panel (resource panel): resource',
	ncurses_panel_window: 'Returns the window associated with panel (resource panel): resource',
	ncurses_pnoutrefresh: 'Copies a region from a pad into the virtual screen (resource pad, int pminrow, int pmincol, int sminrow, int smincol, int smaxrow, int smaxcol): int',
	ncurses_prefresh: 'Copies a region from a pad into the virtual screen (resource pad, int pminrow, int pmincol, int sminrow, int smincol, int smaxrow, int smaxcol): int',
	ncurses_putp: 'Apply padding information to the string and output it (string text): int',
	ncurses_qiflush: 'Flush on signal characters (): null',
	ncurses_raw: 'Switch terminal into raw mode (): bool',
	ncurses_refresh: 'Refresh screen (int ch): int',
	ncurses_replace_panel: 'Replaces the window associated with panel (resource panel, resource window): int',
	ncurses_reset_prog_mode: 'Resets the prog mode saved by def_prog_mode (): int',
	ncurses_reset_shell_mode: 'Resets the shell mode saved by def_shell_mode (): int',
	ncurses_resetty: 'Restores saved terminal state (): bool',
	ncurses_savetty: 'Saves terminal state (): bool',
	ncurses_scr_dump: 'Dump screen content to file (string filename): int',
	ncurses_scr_init: 'Initialize screen from file dump (string filename): int',
	ncurses_scr_restore: 'Restore screen from file dump (string filename): int',
	ncurses_scr_set: 'Inherit screen from file dump (string filename): int',
	ncurses_scrl: 'Scroll window content up or down without changing current position (int count): int',
	ncurses_show_panel: 'Places an invisible panel on top of the stack, making it visible (resource panel): int',
	ncurses_slk_attr: 'Returns current soft label key attribute (): int',
	ncurses_slk_attroff: 'Turn off the given attributes for soft function-key labels (int intarg): int',
	ncurses_slk_attron: 'Turn on the given attributes for soft function-key labels (int intarg): int',
	ncurses_slk_attrset: 'Set given attributes for soft function-key labels (int intarg): int',
	ncurses_slk_clear: 'Clears soft labels from screen (): bool',
	ncurses_slk_color: 'Sets color for soft label keys (int intarg): int',
	ncurses_slk_init: 'Initializes soft label key functions (int format): bool',
	ncurses_slk_noutrefresh: 'Copies soft label keys to virtual screen (): bool',
	ncurses_slk_refresh: 'Copies soft label keys to screen (): int',
	ncurses_slk_restore: 'Restores soft label keys (): int',
	ncurses_slk_set: 'Sets function key labels (int labelnr, string label, int format): bool',
	ncurses_slk_touch: 'Forces output when ncurses_slk_noutrefresh is performed (): int',
	ncurses_standend: 'Stop using \'standout\' attribute (): int',
	ncurses_standout: 'Start using \'standout\' attribute (): int',
	ncurses_start_color: 'Initializes color functionality (): int',
	ncurses_termattrs: 'Returns a logical OR of all attribute flags supported by terminal (): bool',
	ncurses_termname: 'Returns terminals (short)-name (): string',
	ncurses_timeout: 'Set timeout for special key sequences (int millisec): null',
	ncurses_top_panel: 'Moves a visible panel to the top of the stack (resource panel): int',
	ncurses_typeahead: 'Specify different filedescriptor for typeahead checking (int fd): int',
	ncurses_ungetch: 'Put a character back into the input stream (int keycode): int',
	ncurses_ungetmouse: 'Pushes mouse event to queue (array mevent): bool',
	ncurses_update_panels: 'Refreshes the virtual screen to reflect the relations between panels in the stack (): null',
	ncurses_use_default_colors: 'Assign terminal default colors to color id -1 (): bool',
	ncurses_use_env: 'Control use of environment information about terminal size (bool flag): null',
	ncurses_use_extended_names: 'Control use of extended names in terminfo descriptions (bool flag): int',
	ncurses_vidattr: 'Display the string on the terminal in the video attribute mode (int intarg): int',
	ncurses_vline: 'Draw a vertical line at current position using an attributed character and max. n characters long (int charattr, int n): int',
	ncurses_waddch: 'Adds character at current position in a window and advance cursor (resource window, int ch): int',
	ncurses_waddstr: 'Outputs text at current postion in window (resource window, string str, [int n]): int',
	ncurses_wattroff: 'Turns off attributes for a window (resource window, int attrs): int',
	ncurses_wattron: 'Turns on attributes for a window (resource window, int attrs): int',
	ncurses_wattrset: 'Set the attributes for a window (resource window, int attrs): int',
	ncurses_wborder: 'Draws a border around the window using attributed characters (resource window, int left, int right, int top, int bottom, int tl_corner, int tr_corner, int bl_corner, int br_corner): int',
	ncurses_wclear: 'Clears window (resource window): int',
	ncurses_wcolor_set: 'Sets windows color pairings (resource window, int color_pair): int',
	ncurses_werase: 'Erase window contents (resource window): int',
	ncurses_wgetch: 'Reads a character from keyboard (window) (resource window): int',
	ncurses_whline: 'Draws a horizontal line in a window at current position using an attributed character and max. n characters long (resource window, int charattr, int n): int',
	ncurses_wmouse_trafo: 'Transforms window/stdscr coordinates (resource window, int &y, int &x, bool toscreen): bool',
	ncurses_wmove: 'Moves windows output position (resource window, int y, int x): int',
	ncurses_wnoutrefresh: 'Copies window to virtual screen (resource window): int',
	ncurses_wrefresh: 'Refresh window on terminal screen (resource window): int',
	ncurses_wstandend: 'End standout mode for a window (resource window): int',
	ncurses_wstandout: 'Enter standout mode for a window (resource window): int',
	ncurses_wvline: 'Draws a vertical line in a window at current position using an attributed character and max. n characters long (resource window, int charattr, int n): int',
	gopher_parsedir: 'Translate a gopher formatted directory entry into an associative array. (string dirent): array',
	checkdnsrr: 'Check DNS records corresponding to a given Internet host name or IP address (string host, [string type]): bool',
	closelog: 'Close connection to system logger (): bool',
	define_syslog_variables: 'Initializes all syslog related variables (): null',
	dns_check_record: 'Alias of checkdnsrr',
	dns_get_mx: 'Alias of getmxrr',
	dns_get_record: 'Fetch DNS Resource Records associated with a hostname (string hostname, [int type, [array &authns, [array &addtl]]]): array',
	fsockopen: 'Open Internet or Unix domain socket connection (string hostname, [int port, [int &errno, [string &errstr, [float timeout]]]]): resource',
	gethostbyaddr: 'Get the Internet host name corresponding to a given IP address (string ip_address): string',
	gethostbyname: 'Get the IPv4 address corresponding to a given Internet host name (string hostname): string',
	gethostbynamel: 'Get a list of IPv4 addresses corresponding to a given Internet host name (string hostname): array',
	gethostname: 'Gets the host name (): string',
	getmxrr: 'Get MX records corresponding to a given Internet host name (string hostname, array &mxhosts, [array &weight]): bool',
	getprotobyname: 'Get protocol number associated with protocol name (string name): int',
	getprotobynumber: 'Get protocol name associated with protocol number (int number): string',
	getservbyname: 'Get port number associated with an Internet service and protocol (string service, string protocol): int',
	getservbyport: 'Get Internet service which corresponds to port and protocol (int port, string protocol): string',
	header_remove: 'Remove previously set headers ([string name]): null',
	header: 'Send a raw HTTP header (string string, [bool replace, [int http_response_code]]): null',
	headers_list: 'Returns a list of response headers sent (or ready to send) (): array',
	headers_sent: 'Checks if or where headers have been sent ([string &file, [int &line]]): bool',
	inet_ntop: 'Converts a packed internet address to a human readable representation (string in_addr): string',
	inet_pton: 'Converts a human readable IP address to its packed in_addr representation (string address): string',
	ip2long: 'Converts a string containing an (IPv4) Internet Protocol dotted address into a proper address (string ip_address): int',
	long2ip: 'Converts an (IPv4) Internet network address into a string in Internet standard dotted format (string proper_address): string',
	openlog: 'Open connection to system logger (string ident, int option, int facility): bool',
	pfsockopen: 'Open persistent Internet or Unix domain socket connection (string hostname, [int port, [int &errno, [string &errstr, [float timeout]]]]): resource',
	setcookie: 'Send a cookie (string name, [string value, [int expire, [string path, [string domain, [bool secure, [bool httponly]]]]]]): bool',
	setrawcookie: 'Send a cookie without urlencoding the cookie value (string name, [string value, [int expire, [string path, [string domain, [bool secure, [bool httponly]]]]]]): bool',
	socket_get_status: 'Alias of stream_get_meta_data',
	socket_set_blocking: 'Alias of stream_set_blocking',
	socket_set_timeout: 'Alias of stream_set_timeout',
	syslog: 'Generate a system log message (int priority, string message): bool',
	newt_bell: 'Send a beep to the terminal (): null',
	newt_button_bar: 'This function returns a grid containing the buttons created. (array &buttons): resource',
	newt_button: 'Create a new button (int left, int top, string text): resource',
	newt_centered_window: 'Open a centered window of the specified size (int width, int height, [string title]): int',
	newt_checkbox_get_value: 'Retreives value of checkox resource (resource checkbox): string',
	newt_checkbox_set_flags: 'Configures checkbox resource (resource checkbox, int flags, int sense): null',
	newt_checkbox_set_value: 'Sets the value of the checkbox (resource checkbox, string value): null',
	newt_checkbox_tree_add_item: 'Adds new item to the checkbox tree (resource checkboxtree, string text, mixed data, int flags, int index, [int ...]): null',
	newt_checkbox_tree_find_item: 'Finds an item in the checkbox tree (resource checkboxtree, mixed data): array',
	newt_checkbox_tree_get_current: 'Returns checkbox tree selected item (resource checkboxtree): mixed',
	newt_checkbox_tree_get_entry_value: ' (resource checkboxtree, mixed data): string',
	newt_checkbox_tree_get_multi_selection: ' (resource checkboxtree, string seqnum): array',
	newt_checkbox_tree_get_selection: ' (resource checkboxtree): array',
	newt_checkbox_tree_multi: ' (int left, int top, int height, string seq, [int flags]): resource',
	newt_checkbox_tree_set_current: ' (resource checkboxtree, mixed data): null',
	newt_checkbox_tree_set_entry_value: ' (resource checkboxtree, mixed data, string value): null',
	newt_checkbox_tree_set_entry: ' (resource checkboxtree, mixed data, string text): null',
	newt_checkbox_tree_set_width: ' (resource checkbox_tree, int width): null',
	newt_checkbox_tree: ' (int left, int top, int height, [int flags]): resource',
	newt_checkbox: ' (int left, int top, string text, string def_value, [string seq]): resource',
	newt_clear_key_buffer: 'Discards the contents of the terminal\'s input buffer without waiting for additional input (): null',
	newt_cls: ' (): null',
	newt_compact_button: ' (int left, int top, string text): resource',
	newt_component_add_callback: ' (resource component, mixed func_name, mixed data): null',
	newt_component_takes_focus: ' (resource component, bool takes_focus): null',
	newt_create_grid: ' (int cols, int rows): resource',
	newt_cursor_off: ' (): null',
	newt_cursor_on: ' (): null',
	newt_delay: ' (int microseconds): null',
	newt_draw_form: ' (resource form): null',
	newt_draw_root_text: 'Displays the string text at the position indicated (int left, int top, string text): null',
	newt_entry_get_value: ' (resource entry): string',
	newt_entry_set_filter: ' (resource entry, callback filter, mixed data): null',
	newt_entry_set_flags: ' (resource entry, int flags, int sense): null',
	newt_entry_set: ' (resource entry, string value, [bool cursor_at_end]): null',
	newt_entry: ' (int left, int top, int width, [string init_value, [int flags]]): resource',
	newt_finished: 'Uninitializes newt interface (): int',
	newt_form_add_component: 'Adds a single component to the form (resource form, resource component): null',
	newt_form_add_components: 'Add several components to the form (resource form, array components): null',
	newt_form_add_hot_key: ' (resource form, int key): null',
	newt_form_destroy: 'Destroys a form (resource form): null',
	newt_form_get_current: ' (resource form): resource',
	newt_form_run: 'Runs a form (resource form, array &exit_struct): null',
	newt_form_set_background: ' (resource from, int background): null',
	newt_form_set_height: ' (resource form, int height): null',
	newt_form_set_size: ' (resource form): null',
	newt_form_set_timer: ' (resource form, int milliseconds): null',
	newt_form_set_width: ' (resource form, int width): null',
	newt_form_watch_fd: ' (resource form, resource stream, [int flags]): null',
	newt_form: 'Create a form ([resource vert_bar, [string help, [int flags]]]): resource',
	newt_get_screen_size: 'Fills in the passed references with the current size of the terminal (int &cols, int &rows): null',
	newt_grid_add_components_to_form: ' (resource grid, resource form, bool recurse): null',
	newt_grid_basic_window: ' (resource text, resource middle, resource buttons): resource',
	newt_grid_free: ' (resource grid, bool recurse): null',
	newt_grid_get_size: ' (resouce grid, int &width, int &height): null',
	newt_grid_h_close_stacked: ' (int element1_type, resource element1, [int ..., [resource ...]]): resource',
	newt_grid_h_stacked: ' (int element1_type, resource element1, [int ..., [resource ...]]): resource',
	newt_grid_place: ' (resource grid, int left, int top): null',
	newt_grid_set_field: ' (resource grid, int col, int row, int type, resource val, int pad_left, int pad_top, int pad_right, int pad_bottom, int anchor, [int flags]): null',
	newt_grid_simple_window: ' (resource text, resource middle, resource buttons): resource',
	newt_grid_v_close_stacked: ' (int element1_type, resource element1, [int ..., [resource ...]]): resource',
	newt_grid_v_stacked: ' (int element1_type, resource element1, [int ..., [resource ...]]): resource',
	newt_grid_wrapped_window_at: ' (resource grid, string title, int left, int top): null',
	newt_grid_wrapped_window: ' (resource grid, string title): null',
	newt_init: 'Initialize newt (): int',
	newt_label_set_text: ' (resource label, string text): null',
	newt_label: ' (int left, int top, string text): resource',
	newt_listbox_append_entry: ' (resource listbox, string text, mixed data): null',
	newt_listbox_clear_selection: ' (resource listbox): null',
	newt_listbox_clear: ' (resource listobx): null',
	newt_listbox_delete_entry: ' (resource listbox, mixed key): null',
	newt_listbox_get_current: ' (resource listbox): string',
	newt_listbox_get_selection: ' (resource listbox): array',
	newt_listbox_insert_entry: ' (resource listbox, string text, mixed data, mixed key): null',
	newt_listbox_item_count: ' (resource listbox): int',
	newt_listbox_select_item: ' (resource listbox, mixed key, int sense): null',
	newt_listbox_set_current_by_key: ' (resource listbox, mixed key): null',
	newt_listbox_set_current: ' (resource listbox, int num): null',
	newt_listbox_set_data: ' (resource listbox, int num, mixed data): null',
	newt_listbox_set_entry: ' (resource listbox, int num, string text): null',
	newt_listbox_set_width: ' (resource listbox, int width): null',
	newt_listbox: ' (int left, int top, int height, [int flags]): resource',
	newt_listitem_get_data: ' (resource item): mixed',
	newt_listitem_set: ' (resource item, string text): null',
	newt_listitem: ' (int left, int top, string text, bool is_default, resouce prev_item, mixed data, [int flags]): resource',
	newt_open_window: 'Open a window of the specified size and position (int left, int top, int width, int height, [string title]): int',
	newt_pop_help_line: 'Replaces the current help line with the one from the stack (): null',
	newt_pop_window: 'Removes the top window from the display (): null',
	newt_push_help_line: 'Saves the current help line on a stack, and displays the new line ([string text]): null',
	newt_radio_get_current: ' (resource set_member): resource',
	newt_radiobutton: ' (int left, int top, string text, bool is_default, [resource prev_button]): resource',
	newt_redraw_help_line: ' (): null',
	newt_reflow_text: ' (string text, int width, int flex_down, int flex_up, int &actual_width, int &actual_height): string',
	newt_refresh: 'Updates modified portions of the screen (): null',
	newt_resize_screen: ' ([bool redraw]): null',
	newt_resume: 'Resume using the newt interface after calling newt_suspend (): null',
	newt_run_form: 'Runs a form (resource form): resource',
	newt_scale_set: ' (resource scale, int amount): null',
	newt_scale: ' (int left, int top, int width, int full_value): resource',
	newt_scrollbar_set: ' (resource scrollbar, int where, int total): null',
	newt_set_help_callback: ' (mixed function): null',
	newt_set_suspend_callback: 'Set a callback function which gets invoked when user presses the suspend key (callback function, mixed data): null',
	newt_suspend: 'Tells newt to return the terminal to its initial state (): null',
	newt_textbox_get_num_lines: ' (resource textbox): int',
	newt_textbox_reflowed: ' (int left, int top, char *text, int width, int flex_down, int flex_up, [int flags]): resource',
	newt_textbox_set_height: ' (resource textbox, int height): null',
	newt_textbox_set_text: ' (resource textbox, string text): null',
	newt_textbox: ' (int left, int top, int width, int height, [int flags]): resource',
	newt_vertical_scrollbar: ' (int left, int top, int height, [int normal_colorset, [int thumb_colorset]]): resource',
	newt_wait_for_key: 'Doesn\'t return until a key has been pressed (): null',
	newt_win_choice: ' (string title, string button1_text, string button2_text, string format, [mixed args, [mixed ...]]): int',
	newt_win_entries: ' (string title, string text, int suggested_width, int flex_down, int flex_up, int data_width, array &items, string button1, [string ...]): int',
	newt_win_menu: ' (string title, string text, int suggestedWidth, int flexDown, int flexUp, int maxListHeight, array items, int &listItem, [string button1, [string ...]]): int',
	newt_win_message: ' (string title, string button_text, string format, [mixed args, [mixed ...]]): null',
	newt_win_messagev: ' (string title, string button_text, string format, array args): null',
	newt_win_ternary: ' (string title, string button1_text, string button2_text, string button3_text, string format, [mixed args, [mixed ...]]): int',
	yp_all: 'Traverse the map and call a function on each entry (string domain, string map, string callback): null',
	yp_cat: 'Return an array containing the entire map (string domain, string map): array',
	yp_err_string: 'Returns the error string associated with the given error code (int errorcode): string',
	yp_errno: 'Returns the error code of the previous operation (): int',
	yp_first: 'Returns the first key-value pair from the named map (string domain, string map): array',
	yp_get_default_domain: 'Fetches the machine\'s default NIS domain (): string',
	yp_master: 'Returns the machine name of the master NIS server for a map (string domain, string map): string',
	yp_match: 'Returns the matched line (string domain, string map, string key): string',
	yp_next: 'Returns the next key-value pair in the named map (string domain, string map, string key): array',
	yp_order: 'Returns the order number for a map (string domain, string map): int',
	notes_body: 'Open the message msg_number in the specified mailbox on the specified server (leave serv (string server, string mailbox, int msg_number): array',
	notes_copy_db: 'Copy a Lotus Notes database (string from_database_name, string to_database_name): bool',
	notes_create_db: 'Create a Lotus Notes database (string database_name): bool',
	notes_create_note: 'Create a note using form form_name (string database_name, string form_name): bool',
	notes_drop_db: 'Drop a Lotus Notes database (string database_name): bool',
	notes_find_note: 'Returns a note id found in database_name (string database_name, string name, [string type]): int',
	notes_header_info: 'Open the message msg_number in the specified mailbox on the specified server (leave serv (string server, string mailbox, int msg_number): object',
	notes_list_msgs: 'Returns the notes from a selected database_name (string db): bool',
	notes_mark_read: 'Mark a note_id as read for the User user_name (string database_name, string user_name, string note_id): bool',
	notes_mark_unread: 'Mark a note_id as unread for the User user_name (string database_name, string user_name, string note_id): bool',
	notes_nav_create: 'Create a navigator name, in database_name (string database_name, string name): bool',
	notes_search: 'Find notes that match keywords in database_name (string database_name, string keywords): array',
	notes_unread: 'Returns the unread note id\'s for the current User user_name (string database_name, string user_name): array',
	notes_version: 'Get the version Lotus Notes (string database_name): float',
	nsapi_request_headers: 'Fetch all HTTP request headers (): array',
	nsapi_response_headers: 'Fetch all HTTP response headers (): array',
	nsapi_virtual: 'Perform an NSAPI sub-request (string uri): bool',
	oauth_get_sbs: 'Generate a Signature Base String (string http_method, string uri, [array request_parameters]): string',
	oauth_urlencode: 'Encode a URI to RFC 3986 (string uri): string',
	aggregate_info: 'Gets aggregation information for a given object (object object): array',
	aggregate_methods_by_list: 'Selective dynamic class methods aggregation to an object (object object, string class_name, array methods_list, [bool exclude]): null',
	aggregate_methods_by_regexp: 'Selective class methods aggregation to an object using a regular expression (object object, string class_name, string regexp, [bool exclude]): null',
	aggregate_methods: 'Dynamic class and object aggregation of methods (object object, string class_name): null',
	aggregate_properties_by_list: 'Selective dynamic class properties aggregation to an object (object object, string class_name, array properties_list, [bool exclude]): null',
	aggregate_properties_by_regexp: 'Selective class properties aggregation to an object using a regular expression (object object, string class_name, string regexp, [bool exclude]): null',
	aggregate_properties: 'Dynamic aggregation of class properties to an object (object object, string class_name): null',
	aggregate: 'Dynamic class and object aggregation of methods and properties (object object, string class_name): null',
	aggregation_info: 'Alias of aggregate_info',
	deaggregate: 'Removes the aggregated methods and properties from an object (object object, [string class_name]): null',
	oci_bind_array_by_name: 'Binds PHP array to Oracle PL/SQL array by name (resource statement, string name, array &var_array, int max_table_length, [int max_item_length, [int type]]): bool',
	oci_bind_by_name: 'Binds a PHP variable to an Oracle placeholder (resource statement, string bv_name, mixed &variable, [int maxlength, [int type]]): bool',
	oci_cancel: 'Cancels reading from cursor (resource statement): bool',
	oci_close: 'Closes an Oracle connection (resource connection): bool',
	oci_commit: 'Commits the outstanding database transaction (resource connection): bool',
	oci_connect: 'Connect to an Oracle database (string username, string password, [string connection_string, [string character_set, [int session_mode]]]): resource',
	oci_define_by_name: 'Associates a PHP variable with a column for query fetches (resource statement, string column_name, mixed &variable, [int type]): bool',
	oci_error: 'Returns the last error found ([resource resource]): array',
	oci_execute: 'Executes a statement (resource statement, [int mode]): bool',
	oci_fetch_all: 'Fetches multiple rows from a query into a two-dimensional array (resource statement, array &output, [int skip, [int maxrows, [int flags]]]): int',
	oci_fetch_array: 'Returns the next row from a query as an associative or numeric array (resource statement, [int mode]): array',
	oci_fetch_assoc: 'Returns the next row from a query as an associative array (resource statement): array',
	oci_fetch_object: 'Returns the next row from a query as an object (resource statement): object',
	oci_fetch_row: 'Returns the next row from a query as a numeric array (resource statement): array',
	oci_fetch: 'Fetches the next row from a query into internal buffers (resource statement): bool',
	oci_field_is_null: 'Checks if the field is NULL (resource statement, mixed field): bool',
	oci_field_name: 'Returns the name of a field from the statement (resource statement, int field): string',
	oci_field_precision: 'Tell the precision of a field (resource statement, int field): int',
	oci_field_scale: 'Tell the scale of the field (resource statement, int field): int',
	oci_field_size: 'Returns field\'s size (resource statement, mixed field): int',
	oci_field_type_raw: 'Tell the raw Oracle data type of the field (resource statement, int field): int',
	oci_field_type: 'Returns field\'s data type (resource statement, int field): mixed',
	oci_free_statement: 'Frees all resources associated with statement or cursor (resource statement): bool',
	oci_internal_debug: 'Enables or disables internal debug output (bool onoff): null',
	oci_lob_copy: 'Copies large object (OCI-Lob lob_to, OCI-Lob lob_from, [int length]): bool',
	oci_lob_is_equal: 'Compares two LOB/FILE locators for equality (OCI-Lob lob1, OCI-Lob lob2): bool',
	oci_new_collection: 'Allocates new collection object (resource connection, string tdo, [string schema]): OCI-Collection',
	oci_new_connect: 'Connect to the Oracle server using a unique connection (string username, string password, [string connection_string, [string character_set, [int session_mode]]]): resource',
	oci_new_cursor: 'Allocates and returns a new cursor (statement handle) (resource connection): resource',
	oci_new_descriptor: 'Initializes a new empty LOB or FILE descriptor (resource connection, [int type]): OCI-Lob',
	oci_num_fields: 'Returns the number of result columns in a statement (resource statement): int',
	oci_num_rows: 'Returns number of rows affected during statement execution (resource statement): int',
	oci_parse: 'Prepares an Oracle statement for execution (resource connection, string sql_text): resource',
	oci_password_change: 'Changes password of Oracle\'s user (resource connection, string username, string old_password, string new_password): bool',
	oci_password_change: 'Changes password of Oracle\'s user (string dbname, string username, string old_password, string new_password): resource',
	oci_pconnect: 'Connect to an Oracle database using a persistent connection (string username, string password, [string connection_string, [string character_set, [int session_mode]]]): resource',
	oci_result: 'Returns field\'s value from the fetched row (resource statement, mixed field): mixed',
	oci_rollback: 'Rolls back the outstanding database transaction (resource connection): bool',
	oci_server_version: 'Returns server version (resource connection): string',
	oci_set_action: 'Sets the action name (resource connection, string action_name): bool',
	oci_set_client_identifier: 'Sets the client identifier (resource connection, string client_identifier): bool',
	oci_set_client_info: 'Sets the client information (resource connection, string client_info): bool',
	oci_set_edition: 'Sets the database edition (string edition): bool',
	oci_set_module_name: 'Sets the module name (resource connection, string module_name): bool',
	oci_set_prefetch: 'Sets number of rows to be prefetched by queries (resource statement, int rows): bool',
	oci_statement_type: 'Returns the type of a statement (resource statement): string',
	ocibindbyname: 'Alias of oci_bind_by_name',
	ocicancel: 'Alias of oci_cancel',
	ocicloselob: 'Alias of OCI-Lob->close',
	ocicollappend: 'Alias of OCI-Collection->append',
	ocicollassign: 'Alias of OCI-Collection->assign',
	ocicollassignelem: 'Alias of OCI-Collection->assignElem',
	ocicollgetelem: 'Alias of OCI-Collection->getElem',
	ocicollmax: 'Alias of OCI-Collection->max',
	ocicollsize: 'Alias of OCI-Collection->size',
	ocicolltrim: 'Alias of OCI-Collection->trim',
	ocicolumnisnull: 'Alias of oci_field_is_null',
	ocicolumnname: 'Alias of oci_field_name',
	ocicolumnprecision: 'Alias of oci_field_precision',
	ocicolumnscale: 'Alias of oci_field_scale',
	ocicolumnsize: 'Alias of oci_field_size',
	ocicolumntype: 'Alias of oci_field_type',
	ocicolumntyperaw: 'Alias of oci_field_type_raw',
	ocicommit: 'Alias of oci_commit',
	ocidefinebyname: 'Alias of oci_define_by_name',
	ocierror: 'Alias of oci_error',
	ociexecute: 'Alias of oci_execute',
	ocifetch: 'Alias of oci_fetch',
	ocifetchinto: 'Fetches the next row into an array (deprecated) (resource statement, array &result, [int mode]): int',
	ocifetchstatement: 'Alias of oci_fetch_all',
	ocifreecollection: 'Alias of OCI-Collection->free',
	ocifreecursor: 'Alias of oci_free_statement',
	ocifreedesc: 'Alias of OCI-Lob->free',
	ocifreestatement: 'Alias of oci_free_statement',
	ociinternaldebug: 'Alias of oci_internal_debug',
	ociloadlob: 'Alias of OCI-Lob->load',
	ocilogoff: 'Alias of oci_close',
	ocilogon: 'Alias of oci_connect',
	ocinewcollection: 'Alias of oci_new_collection',
	ocinewcursor: 'Alias of oci_new_cursor',
	ocinewdescriptor: 'Alias of oci_new_descriptor',
	ocinlogon: 'Alias of oci_new_connect',
	ocinumcols: 'Alias of oci_num_fields',
	ociparse: 'Alias of oci_parse',
	ociplogon: 'Alias of oci_pconnect',
	ociresult: 'Alias of oci_result',
	ocirollback: 'Alias of oci_rollback',
	ocirowcount: 'Alias of oci_num_rows',
	ocisavelob: 'Alias of OCI-Lob->save',
	ocisavelobfile: 'Alias of OCI-Lob->import',
	ociserverversion: 'Alias of oci_server_version',
	ocisetprefetch: 'Alias of oci_set_prefetch',
	ocistatementtype: 'Alias of oci_statement_type',
	ociwritelobtofile: 'Alias of OCI-Lob->export',
	ociwritetemporarylob: 'Alias of OCI-Lob->writeTemporary',
	openal_buffer_create: 'Generate OpenAL buffer (): resource',
	openal_buffer_data: 'Load a buffer with data (resource buffer, int format, string data, int freq): bool',
	openal_buffer_destroy: 'Destroys an OpenAL buffer (resource buffer): bool',
	openal_buffer_get: 'Retrieve an OpenAL buffer property (resource buffer, int property): int',
	openal_buffer_loadwav: 'Load a .wav file into a buffer (resource buffer, string wavfile): bool',
	openal_context_create: 'Create an audio processing context (resource device): resource',
	openal_context_current: 'Make the specified context current (resource context): bool',
	openal_context_destroy: 'Destroys a context (resource context): bool',
	openal_context_process: 'Process the specified context (resource context): bool',
	openal_context_suspend: 'Suspend the specified context (resource context): bool',
	openal_device_close: 'Close an OpenAL device (resource device): bool',
	openal_device_open: 'Initialize the OpenAL audio layer ([string device_desc]): resource',
	openal_listener_get: 'Retrieve a listener property (int property): mixed',
	openal_listener_set: 'Set a listener property (int property, mixed setting): bool',
	openal_source_create: 'Generate a source resource (): resource',
	openal_source_destroy: 'Destroy a source resource (resource source): bool',
	openal_source_get: 'Retrieve an OpenAL source property (resource source, int property): mixed',
	openal_source_pause: 'Pause the source (resource source): bool',
	openal_source_play: 'Start playing the source (resource source): bool',
	openal_source_rewind: 'Rewind the source (resource source): bool',
	openal_source_set: 'Set source property (resource source, int property, mixed setting): bool',
	openal_source_stop: 'Stop playing the source (resource source): bool',
	openal_stream: 'Begin streaming on a source (resource source, int format, int rate): resource',
	openssl_csr_export_to_file: 'Exports a CSR to a file (resource csr, string outfilename, [bool notext]): bool',
	openssl_csr_export: 'Exports a CSR as a string (resource csr, string &out, [bool notext]): bool',
	openssl_csr_get_public_key: 'Returns the public key of a CERT (mixed csr, [bool use_shortnames]): resource',
	openssl_csr_get_subject: 'Returns the subject of a CERT (mixed csr, [bool use_shortnames]): array',
	openssl_csr_new: 'Generates a CSR (array dn, resource &privkey, [array configargs, [array extraattribs]]): mixed',
	openssl_csr_sign: 'Sign a CSR with another certificate (or itself) and generate a certificate (mixed csr, mixed cacert, mixed priv_key, int days, [array configargs, [int serial]]): resource',
	openssl_decrypt: 'Decrypts data (string data, string method, string password, [string raw_input]): string',
	openssl_dh_compute_key: 'Computes shared secret for public value of remote DH key and local DH key (string pub_key, resource dh_key): string',
	openssl_digest: 'Computes a digest (string data, string method, [bool raw_output]): string',
	openssl_encrypt: 'Encrypts data (string data, string method, string password, [bool raw_output]): string',
	openssl_error_string: 'Return openSSL error message (): string',
	openssl_free_key: 'Free key resource (resource key_identifier): null',
	openssl_get_cipher_methods: 'Gets available cipher methods ([bool aliases]): array',
	openssl_get_md_methods: 'Gets available digest methods ([bool aliases]): array',
	openssl_get_privatekey: 'Alias of openssl_pkey_get_private',
	openssl_get_publickey: 'Alias of openssl_pkey_get_public',
	openssl_open: 'Open sealed data (string sealed_data, string &open_data, string env_key, mixed priv_key_id): bool',
	openssl_pkcs12_export_to_file: 'Exports a PKCS#12 Compatible Certificate Store File (mixed x509, string filename, mixed priv_key, string pass, [array args]): bool',
	openssl_pkcs12_export: 'Exports a PKCS#12 Compatible Certificate Store File to variable. (mixed x509, string &out, mixed priv_key, string pass, [array args]): bool',
	openssl_pkcs12_read: 'Parse a PKCS#12 Certificate Store into an array (string pkcs12, array &certs, string pass): bool',
	openssl_pkcs7_decrypt: 'Decrypts an S/MIME encrypted message (string infilename, string outfilename, mixed recipcert, [mixed recipkey]): bool',
	openssl_pkcs7_encrypt: 'Encrypt an S/MIME message (string infile, string outfile, mixed recipcerts, array headers, [int flags, [int cipherid]]): bool',
	openssl_pkcs7_sign: 'Sign an S/MIME message (string infilename, string outfilename, mixed signcert, mixed privkey, array headers, [int flags, [string extracerts]]): bool',
	openssl_pkcs7_verify: 'Verifies the signature of an S/MIME signed message (string filename, int flags, [string outfilename, [array cainfo, [string extracerts, [string content]]]]): mixed',
	openssl_pkey_export_to_file: 'Gets an exportable representation of a key into a file (mixed key, string outfilename, [string passphrase, [array configargs]]): bool',
	openssl_pkey_export: 'Gets an exportable representation of a key into a string (mixed key, string &out, [string passphrase, [array configargs]]): bool',
	openssl_pkey_free: 'Frees a private key (resource key): null',
	openssl_pkey_get_details: 'Returns an array with the key details (resource key): array',
	openssl_pkey_get_private: 'Get a private key (mixed key, [string passphrase]): resource',
	openssl_pkey_get_public: 'Extract public key from certificate and prepare it for use (mixed certificate): resource',
	openssl_pkey_new: 'Generates a new private key ([array configargs]): resource',
	openssl_private_decrypt: 'Decrypts data with private key (string data, string &decrypted, mixed key, [int padding]): bool',
	openssl_private_encrypt: 'Encrypts data with private key (string data, string &crypted, mixed key, [int padding]): bool',
	openssl_public_decrypt: 'Decrypts data with public key (string data, string &decrypted, mixed key, [int padding]): bool',
	openssl_public_encrypt: 'Encrypts data with public key (string data, string &crypted, mixed key, [int padding]): bool',
	openssl_random_pseudo_bytes: 'Generate a pseudo-random string of bytes (string length, [bool &crypto_strong]): string',
	openssl_seal: 'Seal (encrypt) data (string data, string &sealed_data, array &env_keys, array pub_key_ids): int',
	openssl_sign: 'Generate signature (string data, string &signature, mixed priv_key_id, [int signature_alg]): bool',
	openssl_verify: 'Verify signature (string data, string signature, mixed pub_key_id, [int signature_alg]): int',
	openssl_x509_check_private_key: 'Checks if a private key corresponds to a certificate (mixed cert, mixed key): bool',
	openssl_x509_checkpurpose: 'Verifies if a certificate can be used for a particular purpose (mixed x509cert, int purpose, [array cainfo, [string untrustedfile]]): int',
	openssl_x509_export_to_file: 'Exports a certificate to file (mixed x509, string outfilename, [bool notext]): bool',
	openssl_x509_export: 'Exports a certificate as a string (mixed x509, string &output, [bool notext]): bool',
	openssl_x509_free: 'Free certificate resource (resource x509cert): null',
	openssl_x509_parse: 'Parse an X509 certificate and return the information as an array (mixed x509cert, [bool shortnames]): array',
	openssl_x509_read: 'Parse an X.509 certificate and return a resource identifier for it (mixed x509certdata): resource',
	flush: 'Flush the output buffer (): null',
	ob_clean: 'Clean (erase) the output buffer (): null',
	ob_end_clean: 'Clean (erase) the output buffer and turn off output buffering (): bool',
	ob_end_flush: 'Flush (send) the output buffer and turn off output buffering (): bool',
	ob_flush: 'Flush (send) the output buffer (): null',
	ob_get_clean: 'Get current buffer contents and delete current output buffer (): string',
	ob_get_contents: 'Return the contents of the output buffer (): string',
	ob_get_flush: 'Flush the output buffer, return it as a string and turn off output buffering (): string',
	ob_get_length: 'Return the length of the output buffer (): int',
	ob_get_level: 'Return the nesting level of the output buffering mechanism (): int',
	ob_get_status: 'Get status of output buffers ([bool full_status]): array',
	ob_gzhandler: 'ob_start callback function to gzip output buffer (string buffer, int mode): string',
	ob_implicit_flush: 'Turn implicit flush on/off ([int flag]): null',
	ob_list_handlers: 'List all output handlers in use (): array',
	ob_start: 'Turn on output buffering ([callback output_callback, [int chunk_size, [bool erase]]]): bool',
	output_add_rewrite_var: 'Add URL rewriter values (string name, string value): bool',
	output_reset_rewrite_vars: 'Reset URL rewriter values (): bool',
	overload: 'Enable property and method call overloading for a class (string class_name): null',
	ovrimos_close: 'Closes the connection to ovrimos (int connection): null',
	ovrimos_commit: 'Commits the transaction (int connection_id): bool',
	ovrimos_connect: 'Connect to the specified database (string host, string dborport, string user, string password): int',
	ovrimos_cursor: 'Returns the name of the cursor (int result_id): string',
	ovrimos_exec: 'Executes an SQL statement (int connection_id, string query): int',
	ovrimos_execute: 'Executes a prepared SQL statement (int result_id, [array parameters_array]): bool',
	ovrimos_fetch_into: 'Fetches a row from the result set (int result_id, array &result_array, [string how, [int rownumber]]): bool',
	ovrimos_fetch_row: 'Fetches a row from the result set (int result_id, [int how, [int row_number]]): bool',
	ovrimos_field_len: 'Returns the length of the output column (int result_id, int field_number): int',
	ovrimos_field_name: 'Returns the output column name (int result_id, int field_number): string',
	ovrimos_field_num: 'Returns the (1-based) index of the output column (int result_id, string field_name): int',
	ovrimos_field_type: 'Returns the type of the output column (int result_id, int field_number): int',
	ovrimos_free_result: 'Frees the specified result_id (int result_id): bool',
	ovrimos_longreadlen: 'Specifies how many bytes are to be retrieved from long datatypes (int result_id, int length): bool',
	ovrimos_num_fields: 'Returns the number of columns (int result_id): int',
	ovrimos_num_rows: 'Returns the number of rows affected by update operations (int result_id): int',
	ovrimos_prepare: 'Prepares an SQL statement (int connection_id, string query): int',
	ovrimos_result_all: 'Prints the whole result set as an HTML table (int result_id, [string format]): int',
	ovrimos_result: 'Retrieves the output column (int result_id, mixed field): string',
	ovrimos_rollback: 'Rolls back the transaction (int connection_id): bool',
	px_close: 'Closes a paradox database (resource pxdoc): bool',
	px_create_fp: 'Create a new paradox database (resource pxdoc, resource file, array fielddesc): bool',
	px_date2string: 'Converts a date into a string. (resource pxdoc, int value, string format): string',
	px_delete_record: 'Deletes record from paradox database (resource pxdoc, int num): bool',
	px_delete: 'Deletes resource of paradox database (resource pxdoc): bool',
	px_get_field: 'Returns the specification of a single field (resource pxdoc, int fieldno): array',
	px_get_info: 'Return lots of information about a paradox file (resource pxdoc): array',
	px_get_parameter: 'Gets a parameter (resource pxdoc, string name): string',
	px_get_record: 'Returns record of paradox database (resource pxdoc, int num, [int mode]): array',
	px_get_schema: 'Returns the database schema (resource pxdoc, [int mode]): array',
	px_get_value: 'Gets a value (resource pxdoc, string name): float',
	px_insert_record: 'Inserts record into paradox database (resource pxdoc, array data): int',
	px_new: 'Create a new paradox object (): resource',
	px_numfields: 'Returns number of fields in a database (resource pxdoc): int',
	px_numrecords: 'Returns number of records in a database (resource pxdoc): int',
	px_open_fp: 'Open paradox database (resource pxdoc, resource file): bool',
	px_put_record: 'Stores record into paradox database (resource pxdoc, array record, [int recpos]): bool',
	px_retrieve_record: 'Returns record of paradox database (resource pxdoc, int num, [int mode]): array',
	px_set_blob_file: 'Sets the file where blobs are read from (resource pxdoc, string filename): bool',
	px_set_parameter: 'Sets a parameter (resource pxdoc, string name, string value): bool',
	px_set_tablename: 'Sets the name of a table (deprecated) (resource pxdoc, string name): null',
	px_set_targetencoding: 'Sets the encoding for character fields (deprecated) (resource pxdoc, string encoding): bool',
	px_set_value: 'Sets a value (resource pxdoc, string name, float value): bool',
	px_timestamp2string: 'Converts the timestamp into a string. (resource pxdoc, float value, string format): string',
	px_update_record: 'Updates record in paradox database (resource pxdoc, array data, int num): bool',
	parsekit_compile_file: 'Compile a string of PHP code and return the resulting op array (string filename, [array &errors, [int options]]): array',
	parsekit_compile_string: 'Compile a string of PHP code and return the resulting op array (string phpcode, [array &errors, [int options]]): array',
	parsekit_func_arginfo: 'Return information regarding function argument(s) (mixed function): array',
	pcntl_alarm: 'Set an alarm clock for delivery of a signal (int seconds): int',
	pcntl_exec: 'Executes specified program in current process space (string path, [array args, [array envs]]): null',
	pcntl_fork: 'Forks the currently running process (): int',
	pcntl_getpriority: 'Get the priority of any process ([int pid, [int process_identifier]]): int',
	pcntl_setpriority: 'Change the priority of any process (int priority, [int pid, [int process_identifier]]): bool',
	pcntl_signal_dispatch: 'Calls signal handlers for pending signals (): bool',
	pcntl_signal: 'Installs a signal handler (int signo, callback handler, [bool restart_syscalls]): bool',
	pcntl_sigprocmask: 'Sets and retrieves blocked signals (int how, array set, [array &oldset]): bool',
	pcntl_sigtimedwait: 'Waits for signals, with a timeout (array set, [array &siginfo, [int seconds, [int nanoseconds]]]): int',
	pcntl_sigwaitinfo: 'Waits for signals (array set, [array &siginfo]): int',
	pcntl_wait: 'Waits on or returns the status of a forked child (int &status, [int options]): int',
	pcntl_waitpid: 'Waits on or returns the status of a forked child (int pid, int &status, [int options]): int',
	pcntl_wexitstatus: 'Returns the return code of a terminated child (int status): int',
	pcntl_wifexited: 'Checks if status code represents a normal exit (int status): bool',
	pcntl_wifsignaled: 'Checks whether the status code represents a termination due to a signal (int status): bool',
	pcntl_wifstopped: 'Checks whether the child process is currently stopped (int status): bool',
	pcntl_wstopsig: 'Returns the signal which caused the child to stop (int status): int',
	pcntl_wtermsig: 'Returns the signal which caused the child to terminate (int status): int',
	preg_filter: 'Perform a regular expression search and replace (mixed pattern, mixed replacement, mixed subject, [int limit, [int &count]]): mixed',
	preg_grep: 'Return array entries that match the pattern (string pattern, array input, [int flags]): array',
	preg_last_error: 'Returns the error code of the last PCRE regex execution (): int',
	preg_match_all: 'Perform a global regular expression match (string pattern, string subject, array &matches, [int flags, [int offset]]): int',
	preg_match: 'Perform a regular expression match (string pattern, string subject, [array &matches, [int flags, [int offset]]]): int',
	preg_quote: 'Quote regular expression characters (string str, [string delimiter]): string',
	preg_replace_callback: 'Perform a regular expression search and replace using a callback (mixed pattern, callback callback, mixed subject, [int limit, [int &count]]): mixed',
	preg_replace: 'Perform a regular expression search and replace (mixed pattern, mixed replacement, mixed subject, [int limit, [int &count]]): mixed',
	preg_split: 'Split string by a regular expression (string pattern, string subject, [int limit, [int flags]]): array',
	pdf_activate_item: 'Activate structure element or other content item (resource pdfdoc, int id): bool',
	pdf_add_annotation: 'Add annotation [deprecated]',
	pdf_add_bookmark: 'Add bookmark for current page [deprecated]',
	pdf_add_launchlink: 'Add launch annotation for current page [deprecated] (resource pdfdoc, float llx, float lly, float urx, float ury, string filename): bool',
	pdf_add_locallink: 'Add link annotation for current page [deprecated] (resource pdfdoc, float lowerleftx, float lowerlefty, float upperrightx, float upperrighty, int page, string dest): bool',
	pdf_add_nameddest: 'Create named destination (resource pdfdoc, string name, string optlist): bool',
	pdf_add_note: 'Set annotation for current page [deprecated] (resource pdfdoc, float llx, float lly, float urx, float ury, string contents, string title, string icon, int open): bool',
	pdf_add_outline: 'Add bookmark for current page [deprecated]',
	pdf_add_pdflink: 'Add file link annotation for current page [deprecated] (resource pdfdoc, float bottom_left_x, float bottom_left_y, float up_right_x, float up_right_y, string filename, int page, string dest): bool',
	pdf_add_table_cell: 'Add a cell to a new or existing table (resource pdfdoc, int table, int column, int row, string text, string optlist): int',
	pdf_add_textflow: 'Create Textflow or add text to existing Textflow (resource pdfdoc, int textflow, string text, string optlist): int',
	pdf_add_thumbnail: 'Add thumbnail for current page (resource pdfdoc, int image): bool',
	pdf_add_weblink: 'Add weblink for current page [deprecated] (resource pdfdoc, float lowerleftx, float lowerlefty, float upperrightx, float upperrighty, string url): bool',
	pdf_arc: 'Draw a counterclockwise circular arc segment (resource p, float x, float y, float r, float alpha, float beta): bool',
	pdf_arcn: 'Draw a clockwise circular arc segment (resource p, float x, float y, float r, float alpha, float beta): bool',
	pdf_attach_file: 'Add file attachment for current page [deprecated] (resource pdfdoc, float llx, float lly, float urx, float ury, string filename, string description, string author, string mimetype, string icon): bool',
	pdf_begin_document: 'Create new PDF file (resource pdfdoc, string filename, string optlist): int',
	pdf_begin_font: 'Start a Type 3 font definition (resource pdfdoc, string filename, float a, float b, float c, float d, float e, float f, string optlist): bool',
	pdf_begin_glyph: 'Start glyph definition for Type 3 font (resource pdfdoc, string glyphname, float wx, float llx, float lly, float urx, float ury): bool',
	pdf_begin_item: 'Open structure element or other content item (resource pdfdoc, string tag, string optlist): int',
	pdf_begin_layer: 'Start layer (resource pdfdoc, int layer): bool',
	pdf_begin_page_ext: 'Start new page (resource pdfdoc, float width, float height, string optlist): bool',
	pdf_begin_page: 'Start new page [deprecated] (resource pdfdoc, float width, float height): bool',
	pdf_begin_pattern: 'Start pattern definition (resource pdfdoc, float width, float height, float xstep, float ystep, int painttype): int',
	pdf_begin_template_ext: 'Start template definition (resource pdfdoc, float width, float height, string optlist): int',
	pdf_begin_template: 'Start template definition [deprecated] (resource pdfdoc, float width, float height): int',
	pdf_circle: 'Draw a circle (resource pdfdoc, float x, float y, float r): bool',
	pdf_clip: 'Clip to current path (resource p): bool',
	pdf_close_image: 'Close image (resource p, int image): bool',
	pdf_close_pdi_page: 'Close the page handle (resource p, int page): bool',
	pdf_close_pdi: 'Close the input PDF document [deprecated] (resource p, int doc): bool',
	pdf_close: 'Close pdf resource [deprecated] (resource p): bool',
	pdf_closepath_fill_stroke: 'Close, fill and stroke current path (resource p): bool',
	pdf_closepath_stroke: 'Close and stroke path (resource p): bool',
	pdf_closepath: 'Close current path (resource p): bool',
	pdf_concat: 'Concatenate a matrix to the CTM (resource p, float a, float b, float c, float d, float e, float f): bool',
	pdf_continue_text: 'Output text in next line (resource p, string text): bool',
	pdf_create_3dview: 'Create 3D view (resource pdfdoc, string username, string optlist): int',
	pdf_create_action: 'Create action for objects or events (resource pdfdoc, string type, string optlist): int',
	pdf_create_annotation: 'Create rectangular annotation (resource pdfdoc, float llx, float lly, float urx, float ury, string type, string optlist): bool',
	pdf_create_bookmark: 'Create bookmark (resource pdfdoc, string text, string optlist): int',
	pdf_create_field: 'Create form field (resource pdfdoc, float llx, float lly, float urx, float ury, string name, string type, string optlist): bool',
	pdf_create_fieldgroup: 'Create form field group (resource pdfdoc, string name, string optlist): bool',
	pdf_create_gstate: 'Create graphics state object (resource pdfdoc, string optlist): int',
	pdf_create_pvf: 'Create PDFlib virtual file (resource pdfdoc, string filename, string data, string optlist): bool',
	pdf_create_textflow: 'Create textflow object (resource pdfdoc, string text, string optlist): int',
	pdf_curveto: 'Draw Bezier curve (resource p, float x1, float y1, float x2, float y2, float x3, float y3): bool',
	pdf_define_layer: 'Create layer definition (resource pdfdoc, string name, string optlist): int',
	pdf_delete_pvf: 'Delete PDFlib virtual file (resource pdfdoc, string filename): int',
	pdf_delete_table: 'Delete table object (resource pdfdoc, int table, string optlist): bool',
	pdf_delete_textflow: 'Delete textflow object (resource pdfdoc, int textflow): bool',
	pdf_delete: 'Delete PDFlib object (resource pdfdoc): bool',
	pdf_encoding_set_char: 'Add glyph name and/or Unicode value (resource pdfdoc, string encoding, int slot, string glyphname, int uv): bool',
	pdf_end_document: 'Close PDF file (resource pdfdoc, string optlist): bool',
	pdf_end_font: 'Terminate Type 3 font definition (resource pdfdoc): bool',
	pdf_end_glyph: 'Terminate glyph definition for Type 3 font (resource pdfdoc): bool',
	pdf_end_item: 'Close structure element or other content item (resource pdfdoc, int id): bool',
	pdf_end_layer: 'Deactivate all active layers (resource pdfdoc): bool',
	pdf_end_page_ext: 'Finish page (resource pdfdoc, string optlist): bool',
	pdf_end_page: 'Finish page (resource p): bool',
	pdf_end_pattern: 'Finish pattern (resource p): bool',
	pdf_end_template: 'Finish template (resource p): bool',
	pdf_endpath: 'End current path (resource p): bool',
	pdf_fill_imageblock: 'Fill image block with variable data (resource pdfdoc, int page, string blockname, int image, string optlist): int',
	pdf_fill_pdfblock: 'Fill PDF block with variable data (resource pdfdoc, int page, string blockname, int contents, string optlist): int',
	pdf_fill_stroke: 'Fill and stroke path (resource p): bool',
	pdf_fill_textblock: 'Fill text block with variable data (resource pdfdoc, int page, string blockname, string text, string optlist): int',
	pdf_fill: 'Fill current path (resource p): bool',
	pdf_findfont: 'Prepare font for later use [deprecated] (resource p, string fontname, string encoding, int embed): int',
	pdf_fit_image: 'Place image or template (resource pdfdoc, int image, float x, float y, string optlist): bool',
	pdf_fit_pdi_page: 'Place imported PDF page (resource pdfdoc, int page, float x, float y, string optlist): bool',
	pdf_fit_table: 'Place table on page (resource pdfdoc, int table, float llx, float lly, float urx, float ury, string optlist): string',
	pdf_fit_textflow: 'Format textflow in rectangular area (resource pdfdoc, int textflow, float llx, float lly, float urx, float ury, string optlist): string',
	pdf_fit_textline: 'Place single line of text (resource pdfdoc, string text, float x, float y, string optlist): bool',
	pdf_get_apiname: 'Get name of unsuccessfull API function (resource pdfdoc): string',
	pdf_get_buffer: 'Get PDF output buffer (resource p): string',
	pdf_get_errmsg: 'Get error text (resource pdfdoc): string',
	pdf_get_errnum: 'Get error number (resource pdfdoc): int',
	pdf_get_font: 'Get font [deprecated]',
	pdf_get_fontname: 'Get font name [deprecated]',
	pdf_get_fontsize: 'Font handling [deprecated]',
	pdf_get_image_height: 'Get image height [deprecated]',
	pdf_get_image_width: 'Get image width [deprecated]',
	pdf_get_majorversion: 'Get major version number [deprecated] (): int',
	pdf_get_minorversion: 'Get minor version number [deprecated] (): int',
	pdf_get_parameter: 'Get string parameter (resource p, string key, float modifier): string',
	pdf_get_pdi_parameter: 'Get PDI string parameter [deprecated] (resource p, string key, int doc, int page, int reserved): string',
	pdf_get_pdi_value: 'Get PDI numerical parameter [deprecated] (resource p, string key, int doc, int page, int reserved): float',
	pdf_get_value: 'Get numerical parameter (resource p, string key, float modifier): float',
	pdf_info_font: 'Query detailed information about a loaded font (resource pdfdoc, int font, string keyword, string optlist): float',
	pdf_info_matchbox: 'Query matchbox information (resource pdfdoc, string boxname, int num, string keyword): float',
	pdf_info_table: 'Retrieve table information (resource pdfdoc, int table, string keyword): float',
	pdf_info_textflow: 'Query textflow state (resource pdfdoc, int textflow, string keyword): float',
	pdf_info_textline: 'Perform textline formatting and query metrics (resource pdfdoc, string text, string keyword, string optlist): float',
	pdf_initgraphics: 'Reset graphic state (resource p): bool',
	pdf_lineto: 'Draw a line (resource p, float x, float y): bool',
	pdf_load_3ddata: 'Load 3D model (resource pdfdoc, string filename, string optlist): int',
	pdf_load_font: 'Search and prepare font (resource pdfdoc, string fontname, string encoding, string optlist): int',
	pdf_load_iccprofile: 'Search and prepare ICC profile (resource pdfdoc, string profilename, string optlist): int',
	pdf_load_image: 'Open image file (resource pdfdoc, string imagetype, string filename, string optlist): int',
	pdf_makespotcolor: 'Make spot color (resource p, string spotname): int',
	pdf_moveto: 'Set current point (resource p, float x, float y): bool',
	pdf_new: 'Create PDFlib object (): resource',
	pdf_open_ccitt: 'Open raw CCITT image [deprecated] (resource pdfdoc, string filename, int width, int height, int BitReverse, int k, int Blackls1): int',
	pdf_open_file: 'Create PDF file [deprecated] (resource p, string filename): bool',
	pdf_open_gif: 'Open GIF image [deprecated]',
	pdf_open_image_file: 'Read image from file [deprecated] (resource p, string imagetype, string filename, string stringparam, int intparam): int',
	pdf_open_image: 'Use image data [deprecated] (resource p, string imagetype, string source, string data, int length, int width, int height, int components, int bpc, string params): int',
	pdf_open_jpeg: 'Open JPEG image [deprecated]',
	pdf_open_memory_image: 'Open image created with PHP\'s image functions [not supported] (resource p, resource image): int',
	pdf_open_pdi_page: 'Prepare a page (resource p, int doc, int pagenumber, string optlist): int',
	pdf_open_pdi: 'Open PDF file [deprecated] (resource pdfdoc, string filename, string optlist, int len): int',
	pdf_open_tiff: 'Open TIFF image [deprecated]',
	pdf_pcos_get_number: 'Get value of pCOS path with type number or boolean (resource p, int doc, string path): float',
	pdf_pcos_get_stream: 'Get contents of pCOS path with type stream, fstream, or string (resource p, int doc, string optlist, string path): string',
	pdf_pcos_get_string: 'Get value of pCOS path with type name, string, or boolean (resource p, int doc, string path): string',
	pdf_place_image: 'Place image on the page [deprecated] (resource pdfdoc, int image, float x, float y, float scale): bool',
	pdf_place_pdi_page: 'Place PDF page [deprecated] (resource pdfdoc, int page, float x, float y, float sx, float sy): bool',
	pdf_process_pdi: 'Process imported PDF document (resource pdfdoc, int doc, int page, string optlist): int',
	pdf_rect: 'Draw rectangle (resource p, float x, float y, float width, float height): bool',
	pdf_restore: 'Restore graphics state (resource p): bool',
	pdf_resume_page: 'Resume page (resource pdfdoc, string optlist): bool',
	pdf_rotate: 'Rotate coordinate system (resource p, float phi): bool',
	pdf_save: 'Save graphics state (resource p): bool',
	pdf_scale: 'Scale coordinate system (resource p, float sx, float sy): bool',
	pdf_set_border_color: 'Set border color of annotations [deprecated] (resource p, float red, float green, float blue): bool',
	pdf_set_border_dash: 'Set border dash style of annotations [deprecated] (resource pdfdoc, float black, float white): bool',
	pdf_set_border_style: 'Set border style of annotations [deprecated] (resource pdfdoc, string style, float width): bool',
	pdf_set_char_spacing: 'Set character spacing [deprecated]',
	pdf_set_duration: 'Set duration between pages [deprecated]',
	pdf_set_gstate: 'Activate graphics state object (resource pdfdoc, int gstate): bool',
	pdf_set_horiz_scaling: 'Set horizontal text scaling [deprecated]',
	pdf_set_info_author: 'Fill the author document info field [deprecated]',
	pdf_set_info_creator: 'Fill the creator document info field [deprecated]',
	pdf_set_info_keywords: 'Fill the keywords document info field [deprecated]',
	pdf_set_info_subject: 'Fill the subject document info field [deprecated]',
	pdf_set_info_title: 'Fill the title document info field [deprecated]',
	pdf_set_info: 'Fill document info field (resource p, string key, string value): bool',
	pdf_set_layer_dependency: 'Define relationships among layers (resource pdfdoc, string type, string optlist): bool',
	pdf_set_leading: 'Set distance between text lines [deprecated]',
	pdf_set_parameter: 'Set string parameter (resource p, string key, string value): bool',
	pdf_set_text_matrix: 'Set text matrix [deprecated]',
	pdf_set_text_pos: 'Set text position (resource p, float x, float y): bool',
	pdf_set_text_rendering: 'Determine text rendering [deprecated]',
	pdf_set_text_rise: 'Set text rise [deprecated]',
	pdf_set_value: 'Set numerical parameter (resource p, string key, float value): bool',
	pdf_set_word_spacing: 'Set spacing between words [deprecated]',
	pdf_setcolor: 'Set fill and stroke color (resource p, string fstype, string colorspace, float c1, float c2, float c3, float c4): bool',
	pdf_setdash: 'Set simple dash pattern (resource pdfdoc, float b, float w): bool',
	pdf_setdashpattern: 'Set dash pattern (resource pdfdoc, string optlist): bool',
	pdf_setflat: 'Set flatness (resource pdfdoc, float flatness): bool',
	pdf_setfont: 'Set font (resource pdfdoc, int font, float fontsize): bool',
	pdf_setgray_fill: 'Set fill color to gray [deprecated] (resource p, float g): bool',
	pdf_setgray_stroke: 'Set stroke color to gray [deprecated] (resource p, float g): bool',
	pdf_setgray: 'Set color to gray [deprecated] (resource p, float g): bool',
	pdf_setlinecap: 'Set linecap parameter (resource p, int linecap): bool',
	pdf_setlinejoin: 'Set linejoin parameter (resource p, int value): bool',
	pdf_setlinewidth: 'Set line width (resource p, float width): bool',
	pdf_setmatrix: 'Set current transformation matrix (resource p, float a, float b, float c, float d, float e, float f): bool',
	pdf_setmiterlimit: 'Set miter limit (resource pdfdoc, float miter): bool',
	pdf_setpolydash: 'Set complicated dash pattern [deprecated]',
	pdf_setrgbcolor_fill: 'Set fill rgb color values [deprecated] (resource p, float red, float green, float blue): bool',
	pdf_setrgbcolor_stroke: 'Set stroke rgb color values [deprecated] (resource p, float red, float green, float blue): bool',
	pdf_setrgbcolor: 'Set fill and stroke rgb color values [deprecated] (resource p, float red, float green, float blue): bool',
	pdf_shading_pattern: 'Define shading pattern (resource pdfdoc, int shading, string optlist): int',
	pdf_shading: 'Define blend (resource pdfdoc, string shtype, float x0, float y0, float x1, float y1, float c1, float c2, float c3, float c4, string optlist): int',
	pdf_shfill: 'Fill area with shading (resource pdfdoc, int shading): bool',
	pdf_show_boxed: 'Output text in a box [deprecated] (resource p, string text, float left, float top, float width, float height, string mode, string feature): int',
	pdf_show_xy: 'Output text at given position (resource p, string text, float x, float y): bool',
	pdf_show: 'Output text at current position (resource pdfdoc, string text): bool',
	pdf_skew: 'Skew the coordinate system (resource p, float alpha, float beta): bool',
	pdf_stringwidth: 'Return width of text (resource p, string text, int font, float fontsize): float',
	pdf_stroke: 'Stroke path (resource p): bool',
	pdf_suspend_page: 'Suspend page (resource pdfdoc, string optlist): bool',
	pdf_translate: 'Set origin of coordinate system (resource p, float tx, float ty): bool',
	pdf_utf16_to_utf8: 'Convert string from UTF-16 to UTF-8 (resource pdfdoc, string utf16string): string',
	pdf_utf32_to_utf16: 'Convert string from UTF-32 to UTF-16 (resource pdfdoc, string utf32string, string ordering): string',
	pdf_utf8_to_utf16: 'Convert string from UTF-8 to UTF-16 (resource pdfdoc, string utf8string, string ordering): string',
	pdo_drivers: 'Return an array of available PDO drivers (): array',
	pg_affected_rows: 'Returns number of affected records (tuples) (resource result): int',
	pg_cancel_query: 'Cancel an asynchronous query (resource connection): bool',
	pg_client_encoding: 'Gets the client encoding ([resource connection]): string',
	pg_close: 'Closes a PostgreSQL connection ([resource connection]): bool',
	pg_connect: 'Open a PostgreSQL connection (string connection_string, [int connect_type]): resource',
	pg_connection_busy: 'Get connection is busy or not (resource connection): bool',
	pg_connection_reset: 'Reset connection (reconnect) (resource connection): bool',
	pg_connection_status: 'Get connection status (resource connection): int',
	pg_convert: 'Convert associative array values into suitable for SQL statement (resource connection, string table_name, array assoc_array, [int options]): array',
	pg_copy_from: 'Insert records into a table from an array (resource connection, string table_name, array rows, [string delimiter, [string null_as]]): bool',
	pg_copy_to: 'Copy a table to an array (resource connection, string table_name, [string delimiter, [string null_as]]): array',
	pg_dbname: 'Get the database name ([resource connection]): string',
	pg_delete: 'Deletes records (resource connection, string table_name, array assoc_array, [int options]): mixed',
	pg_end_copy: 'Sync with PostgreSQL backend ([resource connection]): bool',
	pg_escape_bytea: 'Escape a string for insertion into a bytea field ([resource connection], string data): string',
	pg_escape_string: 'Escape a string for insertion into a text field ([resource connection], string data): string',
	pg_execute: 'Sends a request to execute a prepared statement with given parameters, and waits for the result. ([resource connection], string stmtname, array params): resource',
	pg_fetch_all_columns: 'Fetches all rows in a particular result column as an array (resource result, [int column]): array',
	pg_fetch_all: 'Fetches all rows from a result as an array (resource result): array',
	pg_fetch_array: 'Fetch a row as an array (resource result, [int row, [int result_type]]): array',
	pg_fetch_assoc: 'Fetch a row as an associative array (resource result, [int row]): array',
	pg_fetch_object: 'Fetch a row as an object (resource result, [int row, [int result_type]]): object',
	pg_fetch_object: 'Fetch a row as an object (resource result, [int row, [string class_name, [array params]]]): object',
	pg_fetch_result: 'Returns values from a result resource (resource result, int row, mixed field): string',
	pg_fetch_result: 'Returns values from a result resource (resource result, mixed field): string',
	pg_fetch_row: 'Get a row as an enumerated array (resource result, [int row, [int result_type]]): array',
	pg_field_is_null: 'Test if a field is SQL NULL (resource result, int row, mixed field): int',
	pg_field_is_null: 'Test if a field is SQL NULL (resource result, mixed field): int',
	pg_field_name: 'Returns the name of a field (resource result, int field_number): string',
	pg_field_num: 'Returns the field number of the named field (resource result, string field_name): int',
	pg_field_prtlen: 'Returns the printed length (resource result, int row_number, mixed field_name_or_number): int',
	pg_field_prtlen: 'Returns the printed length (resource result, mixed field_name_or_number): int',
	pg_field_size: 'Returns the internal storage size of the named field (resource result, int field_number): int',
	pg_field_table: 'Returns the name or oid of the tables field (resource result, int field_number, [bool oid_only]): mixed',
	pg_field_type_oid: 'Returns the type ID (OID) for the corresponding field number (resource result, int field_number): int',
	pg_field_type: 'Returns the type name for the corresponding field number (resource result, int field_number): string',
	pg_free_result: 'Free result memory (resource result): bool',
	pg_get_notify: 'Gets SQL NOTIFY message (resource connection, [int result_type]): array',
	pg_get_pid: 'Gets the backend\'s process ID (resource connection): int',
	pg_get_result: 'Get asynchronous query result ([resource connection]): resource',
	pg_host: 'Returns the host name associated with the connection ([resource connection]): string',
	pg_insert: 'Insert array into table (resource connection, string table_name, array assoc_array, [int options]): mixed',
	pg_last_error: 'Get the last error message string of a connection ([resource connection]): string',
	pg_last_notice: 'Returns the last notice message from PostgreSQL server (resource connection): string',
	pg_last_oid: 'Returns the last row\'s OID (resource result): string',
	pg_lo_close: 'Close a large object (resource large_object): bool',
	pg_lo_create: 'Create a large object ([resource connection, [mixed object_id]]): int',
	pg_lo_create: 'Create a large object (mixed object_id): int',
	pg_lo_export: 'Export a large object to file ([resource connection], int oid, string pathname): bool',
	pg_lo_import: 'Import a large object from file ([resource connection], string pathname, [mixed object_id]): int',
	pg_lo_open: 'Open a large object (resource connection, int oid, string mode): resource',
	pg_lo_read_all: 'Reads an entire large object and send straight to browser (resource large_object): int',
	pg_lo_read: 'Read a large object (resource large_object, [int len]): string',
	pg_lo_seek: 'Seeks position within a large object (resource large_object, int offset, [int whence]): bool',
	pg_lo_tell: 'Returns current seek position a of large object (resource large_object): int',
	pg_lo_unlink: 'Delete a large object (resource connection, int oid): bool',
	pg_lo_write: 'Write to a large object (resource large_object, string data, [int len]): int',
	pg_meta_data: 'Get meta data for table (resource connection, string table_name): array',
	pg_num_fields: 'Returns the number of fields in a result (resource result): int',
	pg_num_rows: 'Returns the number of rows in a result (resource result): int',
	pg_options: 'Get the options associated with the connection ([resource connection]): string',
	pg_parameter_status: 'Looks up a current parameter setting of the server. ([resource connection], string param_name): string',
	pg_pconnect: 'Open a persistent PostgreSQL connection (string connection_string, [int connect_type]): resource',
	pg_ping: 'Ping database connection ([resource connection]): bool',
	pg_port: 'Return the port number associated with the connection ([resource connection]): int',
	pg_prepare: 'Submits a request to create a prepared statement with the given parameters, and waits for completion. ([resource connection], string stmtname, string query): resource',
	pg_put_line: 'Send a NULL-terminated string to PostgreSQL backend ([resource connection], string data): bool',
	pg_query_params: 'Submits a command to the server and waits for the result, with the ability to pass parameters separately from the SQL command text. ([resource connection], string query, array params): resource',
	pg_query: 'Execute a query ([resource connection], string query): resource',
	pg_result_error_field: 'Returns an individual field of an error report. (resource result, int fieldcode): string',
	pg_result_error: 'Get error message associated with result (resource result): string',
	pg_result_seek: 'Set internal row offset in result resource (resource result, int offset): bool',
	pg_result_status: 'Get status of query result (resource result, [int type]): mixed',
	pg_select: 'Select records (resource connection, string table_name, array assoc_array, [int options]): mixed',
	pg_send_execute: 'Sends a request to execute a prepared statement with given parameters, without waiting for the result(s). (resource connection, string stmtname, array params): bool',
	pg_send_prepare: 'Sends a request to create a prepared statement with the given parameters, without waiting for completion. (resource connection, string stmtname, string query): bool',
	pg_send_query_params: 'Submits a command and separate parameters to the server without waiting for the result(s). (resource connection, string query, array params): bool',
	pg_send_query: 'Sends asynchronous query (resource connection, string query): bool',
	pg_set_client_encoding: 'Set the client encoding ([resource connection], string encoding): int',
	pg_set_error_verbosity: 'Determines the verbosity of messages returned by pg_last_error and pg_result_error. ([resource connection], int verbosity): int',
	pg_trace: 'Enable tracing a PostgreSQL connection (string pathname, [string mode, [resource connection]]): bool',
	pg_transaction_status: 'Returns the current in-transaction status of the server. (resource connection): int',
	pg_tty: 'Return the TTY name associated with the connection ([resource connection]): string',
	pg_unescape_bytea: 'Unescape binary for bytea type (string data): string',
	pg_untrace: 'Disable tracing of a PostgreSQL connection ([resource connection]): bool',
	pg_update: 'Update table (resource connection, string table_name, array data, array condition, [int options]): mixed',
	pg_version: 'Returns an array with client, protocol and server version (when available) ([resource connection]): array',
	posix_access: 'Determine accessibility of a file (string file, [int mode]): bool',
	posix_ctermid: 'Get path name of controlling terminal (): string',
	posix_errno: 'Alias of posix_get_last_error',
	posix_get_last_error: 'Retrieve the error number set by the last posix function that failed (): int',
	posix_getcwd: 'Pathname of current directory (): string',
	posix_getegid: 'Return the effective group ID of the current process (): int',
	posix_geteuid: 'Return the effective user ID of the current process (): int',
	posix_getgid: 'Return the real group ID of the current process (): int',
	posix_getgrgid: 'Return info about a group by group id (int gid): array',
	posix_getgrnam: 'Return info about a group by name (string name): array',
	posix_getgroups: 'Return the group set of the current process (): array',
	posix_getlogin: 'Return login name (): string',
	posix_getpgid: 'Get process group id for job control (int pid): int',
	posix_getpgrp: 'Return the current process group identifier (): int',
	posix_getpid: 'Return the current process identifier (): int',
	posix_getppid: 'Return the parent process identifier (): int',
	posix_getpwnam: 'Return info about a user by username (string username): array',
	posix_getpwuid: 'Return info about a user by user id (int uid): array',
	posix_getrlimit: 'Return info about system resource limits (): array',
	posix_getsid: 'Get the current sid of the process (int pid): int',
	posix_getuid: 'Return the real user ID of the current process (): int',
	posix_initgroups: 'Calculate the group access list (string name, int base_group_id): bool',
	posix_isatty: 'Determine if a file descriptor is an interactive terminal (int fd): bool',
	posix_kill: 'Send a signal to a process (int pid, int sig): bool',
	posix_mkfifo: 'Create a fifo special file (a named pipe) (string pathname, int mode): bool',
	posix_mknod: 'Create a special or ordinary file (POSIX.1) (string pathname, int mode, [int major, [int minor]]): bool',
	posix_setegid: 'Set the effective GID of the current process (int gid): bool',
	posix_seteuid: 'Set the effective UID of the current process (int uid): bool',
	posix_setgid: 'Set the GID of the current process (int gid): bool',
	posix_setpgid: 'Set process group id for job control (int pid, int pgid): bool',
	posix_setsid: 'Make the current process a session leader (): int',
	posix_setuid: 'Set the UID of the current process (int uid): bool',
	posix_strerror: 'Retrieve the system error message associated with the given errno (int errno): string',
	posix_times: 'Get process times (): array',
	posix_ttyname: 'Determine terminal device name (int fd): string',
	posix_uname: 'Get system name (): array',
	printer_abort: 'Deletes the printer\'s spool file (resource printer_handle): null',
	printer_close: 'Close an open printer connection (resource printer_handle): null',
	printer_create_brush: 'Create a new brush (int style, string color): resource',
	printer_create_dc: 'Create a new device context (resource printer_handle): null',
	printer_create_font: 'Create a new font (string face, int height, int width, int font_weight, bool italic, bool underline, bool strikeout, int orientation): resource',
	printer_create_pen: 'Create a new pen (int style, int width, string color): resource',
	printer_delete_brush: 'Delete a brush (resource brush_handle): null',
	printer_delete_dc: 'Delete a device context (resource printer_handle): bool',
	printer_delete_font: 'Delete a font (resource font_handle): null',
	printer_delete_pen: 'Delete a pen (resource pen_handle): null',
	printer_draw_bmp: 'Draw a bmp (resource printer_handle, string filename, int x, int y, [int width], int height): bool',
	printer_draw_chord: 'Draw a chord (resource printer_handle, int rec_x, int rec_y, int rec_x1, int rec_y1, int rad_x, int rad_y, int rad_x1, int rad_y1): null',
	printer_draw_elipse: 'Draw an ellipse (resource printer_handle, int ul_x, int ul_y, int lr_x, int lr_y): null',
	printer_draw_line: 'Draw a line (resource printer_handle, int from_x, int from_y, int to_x, int to_y): null',
	printer_draw_pie: 'Draw a pie (resource printer_handle, int rec_x, int rec_y, int rec_x1, int rec_y1, int rad1_x, int rad1_y, int rad2_x, int rad2_y): null',
	printer_draw_rectangle: 'Draw a rectangle (resource printer_handle, int ul_x, int ul_y, int lr_x, int lr_y): null',
	printer_draw_roundrect: 'Draw a rectangle with rounded corners (resource printer_handle, int ul_x, int ul_y, int lr_x, int lr_y, int width, int height): null',
	printer_draw_text: 'Draw text (resource printer_handle, string text, int x, int y): null',
	printer_end_doc: 'Close document (resource printer_handle): bool',
	printer_end_page: 'Close active page (resource printer_handle): bool',
	printer_get_option: 'Retrieve printer configuration data (resource printer_handle, string option): mixed',
	printer_list: 'Return an array of printers attached to the server (int enumtype, [string name, [int level]]): array',
	printer_logical_fontheight: 'Get logical font height (resource printer_handle, int height): int',
	printer_open: 'Opens a connection to a printer ([string printername]): resource',
	printer_select_brush: 'Select a brush (resource printer_handle, resource brush_handle): null',
	printer_select_font: 'Select a font (resource printer_handle, resource font_handle): null',
	printer_select_pen: 'Select a pen (resource printer_handle, resource pen_handle): null',
	printer_set_option: 'Configure the printer connection (resource printer_handle, int option, mixed value): bool',
	printer_start_doc: 'Start a new document (resource printer_handle, [string document]): bool',
	printer_start_page: 'Start a new page (resource printer_handle): bool',
	printer_write: 'Write data to the printer (resource printer_handle, string content): bool',
	ps_add_bookmark: 'Add bookmark to current page (resource psdoc, string text, [int parent, [int open]]): int',
	ps_add_launchlink: 'Adds link which launches file (resource psdoc, float llx, float lly, float urx, float ury, string filename): bool',
	ps_add_locallink: 'Adds link to a page in the same document (resource psdoc, float llx, float lly, float urx, float ury, int page, string dest): bool',
	ps_add_note: 'Adds note to current page (resource psdoc, float llx, float lly, float urx, float ury, string contents, string title, string icon, int open): bool',
	ps_add_pdflink: 'Adds link to a page in a second pdf document (resource psdoc, float llx, float lly, float urx, float ury, string filename, int page, string dest): bool',
	ps_add_weblink: 'Adds link to a web location (resource psdoc, float llx, float lly, float urx, float ury, string url): bool',
	ps_arc: 'Draws an arc counterclockwise (resource psdoc, float x, float y, float radius, float alpha, float beta): bool',
	ps_arcn: 'Draws an arc clockwise (resource psdoc, float x, float y, float radius, float alpha, float beta): bool',
	ps_begin_page: 'Start a new page (resource psdoc, float width, float height): bool',
	ps_begin_pattern: 'Start a new pattern (resource psdoc, float width, float height, float xstep, float ystep, int painttype): int',
	ps_begin_template: 'Start a new template (resource psdoc, float width, float height): int',
	ps_circle: 'Draws a circle (resource psdoc, float x, float y, float radius): bool',
	ps_clip: 'Clips drawing to current path (resource psdoc): bool',
	ps_close_image: 'Closes image and frees memory (resource psdoc, int imageid): null',
	ps_close: 'Closes a PostScript document (resource psdoc): bool',
	ps_closepath_stroke: 'Closes and strokes path (resource psdoc): bool',
	ps_closepath: 'Closes path (resource psdoc): bool',
	ps_continue_text: 'Continue text in next line (resource psdoc, string text): bool',
	ps_curveto: 'Draws a curve (resource psdoc, float x1, float y1, float x2, float y2, float x3, float y3): bool',
	ps_delete: 'Deletes all resources of a PostScript document (resource psdoc): bool',
	ps_end_page: 'End a page (resource psdoc): bool',
	ps_end_pattern: 'End a pattern (resource psdoc): bool',
	ps_end_template: 'End a template (resource psdoc): bool',
	ps_fill_stroke: 'Fills and strokes the current path (resource psdoc): bool',
	ps_fill: 'Fills the current path (resource psdoc): bool',
	ps_findfont: 'Loads a font (resource psdoc, string fontname, string encoding, [bool embed]): int',
	ps_get_buffer: 'Fetches the full buffer containig the generated PS data (resource psdoc): string',
	ps_get_parameter: 'Gets certain parameters (resource psdoc, string name, [float modifier]): string',
	ps_get_value: 'Gets certain values (resource psdoc, string name, [float modifier]): float',
	ps_hyphenate: 'Hyphenates a word (resource psdoc, string text): array',
	ps_include_file: 'Reads an external file with raw PostScript code (resource psdoc, string file): bool',
	ps_lineto: 'Draws a line (resource psdoc, float x, float y): bool',
	ps_makespotcolor: 'Create spot color (resource psdoc, string name, [int reserved]): int',
	ps_moveto: 'Sets current point (resource psdoc, float x, float y): bool',
	ps_new: 'Creates a new PostScript document object (): resource',
	ps_open_file: 'Opens a file for output (resource psdoc, [string filename]): bool',
	ps_open_image_file: 'Opens image from file (resource psdoc, string type, string filename, [string stringparam, [int intparam]]): int',
	ps_open_image: 'Reads an image for later placement (resource psdoc, string type, string source, string data, int lenght, int width, int height, int components, int bpc, string params): int',
	ps_open_memory_image: 'Takes an GD image and returns an image for placement in a PS document (resource psdoc, int gd): int',
	ps_place_image: 'Places image on the page (resource psdoc, int imageid, float x, float y, float scale): bool',
	ps_rect: 'Draws a rectangle (resource psdoc, float x, float y, float width, float height): bool',
	ps_restore: 'Restore previously save context (resource psdoc): bool',
	ps_rotate: 'Sets rotation factor (resource psdoc, float rot): bool',
	ps_save: 'Save current context (resource psdoc): bool',
	ps_scale: 'Sets scaling factor (resource psdoc, float x, float y): bool',
	ps_set_border_color: 'Sets color of border for annotations (resource psdoc, float red, float green, float blue): bool',
	ps_set_border_dash: 'Sets length of dashes for border of annotations (resource psdoc, float black, float white): bool',
	ps_set_border_style: 'Sets border style of annotations (resource psdoc, string style, float width): bool',
	ps_set_info: 'Sets information fields of document (resource p, string key, string val): bool',
	ps_set_parameter: 'Sets certain parameters (resource psdoc, string name, string value): bool',
	ps_set_text_pos: 'Sets position for text output (resource psdoc, float x, float y): bool',
	ps_set_value: 'Sets certain values (resource psdoc, string name, float value): bool',
	ps_setcolor: 'Sets current color (resource psdoc, string type, string colorspace, float c1, float c2, float c3, float c4): bool',
	ps_setdash: 'Sets appearance of a dashed line (resource psdoc, float on, float off): bool',
	ps_setflat: 'Sets flatness (resource psdoc, float value): bool',
	ps_setfont: 'Sets font to use for following output (resource psdoc, int fontid, float size): bool',
	ps_setgray: 'Sets gray value (resource psdoc, float gray): bool',
	ps_setlinecap: 'Sets appearance of line ends (resource psdoc, int type): bool',
	ps_setlinejoin: 'Sets how contected lines are joined (resource psdoc, int type): bool',
	ps_setlinewidth: 'Sets width of a line (resource psdoc, float width): bool',
	ps_setmiterlimit: 'Sets the miter limit (resource psdoc, float value): bool',
	ps_setoverprintmode: 'Sets overprint mode (resource psdoc, int mode): bool',
	ps_setpolydash: 'Sets appearance of a dashed line (resource psdoc, float arr): bool',
	ps_shading_pattern: 'Creates a pattern based on a shading (resource psdoc, int shadingid, string optlist): int',
	ps_shading: 'Creates a shading for later use (resource psdoc, string type, float x0, float y0, float x1, float y1, float c1, float c2, float c3, float c4, string optlist): int',
	ps_shfill: 'Fills an area with a shading (resource psdoc, int shadingid): bool',
	ps_show_boxed: 'Output text in a box (resource psdoc, string text, float left, float bottom, float width, float height, string hmode, [string feature]): int',
	ps_show_xy: 'Output text at given position (resource psdoc, string text, float x, float y): bool',
	ps_show_xy2: 'Output text at position (resource psdoc, string text, int len, float xcoor, float ycoor): bool',
	ps_show: 'Output text (resource psdoc, string text): bool',
	ps_show2: 'Output a text at current position (resource psdoc, string text, int len): bool',
	ps_string_geometry: 'Gets geometry of a string (resource psdoc, string text, [int fontid, [float size]]): array',
	ps_stringwidth: 'Gets width of a string (resource psdoc, string text, [int fontid, [float size]]): float',
	ps_stroke: 'Draws the current path (resource psdoc): bool',
	ps_symbol_name: 'Gets name of a glyph (resource psdoc, int ord, [int fontid]): string',
	ps_symbol_width: 'Gets width of a glyph (resource psdoc, int ord, [int fontid, [float size]]): float',
	ps_symbol: 'Output a glyph (resource psdoc, int ord): bool',
	ps_translate: 'Sets translation (resource psdoc, float x, float y): bool',
	pspell_add_to_personal: 'Add the word to a personal wordlist (int dictionary_link, string word): bool',
	pspell_add_to_session: 'Add the word to the wordlist in the current session (int dictionary_link, string word): bool',
	pspell_check: 'Check a word (int dictionary_link, string word): bool',
	pspell_clear_session: 'Clear the current session (int dictionary_link): bool',
	pspell_config_create: 'Create a config used to open a dictionary (string language, [string spelling, [string jargon, [string encoding]]]): int',
	pspell_config_data_dir: 'location of language data files (int conf, string directory): bool',
	pspell_config_dict_dir: 'Location of the main word list (int conf, string directory): bool',
	pspell_config_ignore: 'Ignore words less than N characters long (int dictionary_link, int n): bool',
	pspell_config_mode: 'Change the mode number of suggestions returned (int dictionary_link, int mode): bool',
	pspell_config_personal: 'Set a file that contains personal wordlist (int dictionary_link, string file): bool',
	pspell_config_repl: 'Set a file that contains replacement pairs (int dictionary_link, string file): bool',
	pspell_config_runtogether: 'Consider run-together words as valid compounds (int dictionary_link, bool flag): bool',
	pspell_config_save_repl: 'Determine whether to save a replacement pairs list along with the wordlist (int dictionary_link, bool flag): bool',
	pspell_new_config: 'Load a new dictionary with settings based on a given config (int config): int',
	pspell_new_personal: 'Load a new dictionary with personal wordlist (string personal, string language, [string spelling, [string jargon, [string encoding, [int mode]]]]): int',
	pspell_new: 'Load a new dictionary (string language, [string spelling, [string jargon, [string encoding, [int mode]]]]): int',
	pspell_save_wordlist: 'Save the personal wordlist to a file (int dictionary_link): bool',
	pspell_store_replacement: 'Store a replacement pair for a word (int dictionary_link, string misspelled, string correct): bool',
	pspell_suggest: 'Suggest spellings of a word (int dictionary_link, string word): array',
	qdom_error: 'Returns the error string from the last QDOM operation or FALSE if no errors occurred (): string',
	qdom_tree: 'Creates a tree of an XML string (string doc): QDomDocument',
	radius_acct_open: 'Creates a Radius handle for accounting (): resource',
	radius_add_server: 'Adds a server (resource radius_handle, string hostname, int port, string secret, int timeout, int max_tries): bool',
	radius_auth_open: 'Creates a Radius handle for authentication (): resource',
	radius_close: 'Frees all ressources (resource radius_handle): bool',
	radius_config: 'Causes the library to read the given configuration file (resource radius_handle, string file): bool',
	radius_create_request: 'Create accounting or authentication request (resource radius_handle, int type): bool',
	radius_cvt_addr: 'Converts raw data to IP-Address (string data): string',
	radius_cvt_int: 'Converts raw data to integer (string data): int',
	radius_cvt_string: 'Converts raw data to string (string data): string',
	radius_demangle_mppe_key: 'Derives mppe-keys from mangled data (resource radius_handle, string mangled): string',
	radius_demangle: 'Demangles data (resource radius_handle, string mangled): string',
	radius_get_attr: 'Extracts an attribute (resource radius_handle): mixed',
	radius_get_vendor_attr: 'Extracts a vendor specific attribute (string data): array',
	radius_put_addr: 'Attaches an IP-Address attribute (resource radius_handle, int type, string addr): bool',
	radius_put_attr: 'Attaches a binary attribute (resource radius_handle, int type, string value): bool',
	radius_put_int: 'Attaches an integer attribute (resource radius_handle, int type, int value): bool',
	radius_put_string: 'Attaches a string attribute (resource radius_handle, int type, string value): bool',
	radius_put_vendor_addr: 'Attaches a vendor specific IP-Address attribute (resource radius_handle, int vendor, int type, string addr): bool',
	radius_put_vendor_attr: 'Attaches a vendor specific binary attribute (resource radius_handle, int vendor, int type, string value): bool',
	radius_put_vendor_int: 'Attaches a vendor specific integer attribute (resource radius_handle, int vendor, int type, int value): bool',
	radius_put_vendor_string: 'Attaches a vendor specific string attribute (resource radius_handle, int vendor, int type, string value): bool',
	radius_request_authenticator: 'Returns the request authenticator (resource radius_handle): string',
	radius_send_request: 'Sends the request and waites for a reply (resource radius_handle): int',
	radius_server_secret: 'Returns the shared secret (resource radius_handle): string',
	radius_strerror: 'Returns an error message (resource radius_handle): string',
	rar_close: 'Close RAR archive and free all resources. (RarArchive rarfile): bool',
	rar_comment_get: 'Get comment text from the RAR archive. (RarArchive rarfile): string',
	rar_list: 'Get full list of entries from the RAR archive. (RarArchive rarfile): array',
	rar_entry_get: 'Get entry object from the RAR archive. (RarArchive rarfile, string entryname): RarEntry',
	rar_solid_is: 'Check whether the RAR archive is solid. (RarArchive rarfile): bool',
	rar_open: 'Open RAR archive. (string filename, [string password]): RarArchive',
	readline_add_history: 'Adds a line to the history (string line): bool',
	readline_callback_handler_install: 'Initializes the readline callback interface and terminal, prints the prompt and returns immediately (string prompt, callback callback): bool',
	readline_callback_handler_remove: 'Removes a previously installed callback handler and restores terminal settings (): bool',
	readline_callback_read_char: 'Reads a character and informs the readline callback interface when a line is received (): null',
	readline_clear_history: 'Clears the history (): bool',
	readline_completion_function: 'Registers a completion function (callback function): bool',
	readline_info: 'Gets/sets various internal readline variables ([string varname, [string newvalue]]): mixed',
	readline_list_history: 'Lists the history (): array',
	readline_on_new_line: 'Inform readline that the cursor has moved to a new line (): null',
	readline_read_history: 'Reads the history ([string filename]): bool',
	readline_redisplay: 'Redraws the display (): null',
	readline_write_history: 'Writes the history ([string filename]): bool',
	readline: 'Reads a line ([string prompt]): string',
	recode_file: 'Recode from file to file according to recode request (string request, resource input, resource output): bool',
	recode_string: 'Recode a string according to a recode request (string request, string string): string',
	recode: 'Alias of recode_string',
	ereg_replace: 'Replace regular expression (string pattern, string replacement, string string): string',
	ereg: 'Regular expression match (string pattern, string string, [array &regs]): int',
	eregi_replace: 'Replace regular expression case insensitive (string pattern, string replacement, string string): string',
	eregi: 'Case insensitive regular expression match (string pattern, string string, [array &regs]): int',
	split: 'Split string into array by regular expression (string pattern, string string, [int limit]): array',
	spliti: 'Split string into array by regular expression case insensitive (string pattern, string string, [int limit]): array',
	sql_regcase: 'Make regular expression for case insensitive match (string string): string',
	rpm_close: 'Closes an RPM file (resource rpmr): bool',
	rpm_get_tag: 'Retrieves a header tag from an RPM file (resource rpmr, int tagnum): mixed',
	rpm_is_valid: 'Tests a filename for validity as an RPM file (string filename): bool',
	rpm_open: 'Opens an RPM file (string filename): resource',
	rpm_version: 'Returns a string representing the current version of the rpmreader extension (): string',
	runkit_class_adopt: 'Convert a base class to an inherited class, add ancestral methods when appropriate (string classname, string parentname): bool',
	runkit_class_emancipate: 'Convert an inherited class to a base class, removes any method whose scope is ancestral (string classname): bool',
	runkit_constant_add: 'Similar to define(), but allows defining in class definitions as well (string constname, mixed value): bool',
	runkit_constant_redefine: 'Redefine an already defined constant (string constname, mixed newvalue): bool',
	runkit_constant_remove: 'Remove/Delete an already defined constant (string constname): bool',
	runkit_function_add: 'Add a new function, similar to create_function (string funcname, string arglist, string code): bool',
	runkit_function_copy: 'Copy a function to a new function name (string funcname, string targetname): bool',
	runkit_function_redefine: 'Replace a function definition with a new implementation (string funcname, string arglist, string code): bool',
	runkit_function_remove: 'Remove a function definition (string funcname): bool',
	runkit_function_rename: 'Change a function\'s name (string funcname, string newname): bool',
	runkit_import: 'Process a PHP file importing function and class definitions, overwriting where appropriate (string filename, [int flags]): bool',
	runkit_lint_file: 'Check the PHP syntax of the specified file (string filename): bool',
	runkit_lint: 'Check the PHP syntax of the specified php code (string code): bool',
	runkit_method_add: 'Dynamically adds a new method to a given class (string classname, string methodname, string args, string code, [int flags]): bool',
	runkit_method_copy: 'Copies a method from class to another (string dClass, string dMethod, string sClass, [string sMethod]): bool',
	runkit_method_redefine: 'Dynamically changes the code of the given method (string classname, string methodname, string args, string code, [int flags]): bool',
	runkit_method_remove: 'Dynamically removes the given method (string classname, string methodname): bool',
	runkit_method_rename: 'Dynamically changes the name of the given method (string classname, string methodname, string newname): bool',
	runkit_return_value_used: 'Determines if the current functions return value will be used (): bool',
	runkit_sandbox_output_handler: 'Specify a function to capture and/or process output from a runkit sandbox (object sandbox, [mixed callback]): mixed',
	runkit_superglobals: 'Return numerically indexed array of registered superglobals (): array',
	ftok: 'Convert a pathname and a project identifier to a System V IPC key (string pathname, string proj): int',
	msg_get_queue: 'Create or attach to a message queue (int key, [int perms]): resource',
	msg_queue_exists: 'Check whether a message queue exists (int key): bool',
	msg_receive: 'Receive a message from a message queue (resource queue, int desiredmsgtype, int &msgtype, int maxsize, mixed &message, [bool unserialize, [int flags, [int &errorcode]]]): bool',
	msg_remove_queue: 'Destroy a message queue (resource queue): bool',
	msg_send: 'Send a message to a message queue (resource queue, int msgtype, mixed message, [bool serialize, [bool blocking, [int &errorcode]]]): bool',
	msg_set_queue: 'Set information in the message queue data structure (resource queue, array data): bool',
	msg_stat_queue: 'Returns information from the message queue data structure (resource queue): array',
	sem_acquire: 'Acquire a semaphore (resource sem_identifier): bool',
	sem_get: 'Get a semaphore id (int key, [int max_acquire, [int perm, [int auto_release]]]): resource',
	sem_release: 'Release a semaphore (resource sem_identifier): bool',
	sem_remove: 'Remove a semaphore (resource sem_identifier): bool',
	shm_attach: 'Creates or open a shared memory segment (int key, [int memsize, [int perm]]): resource',
	shm_detach: 'Disconnects from shared memory segment (resource shm_identifier): bool',
	shm_get_var: 'Returns a variable from shared memory (resource shm_identifier, int variable_key): mixed',
	shm_has_var: 'Check whether a specific entry exists (resource shm_identifier, int variable_key): bool',
	shm_put_var: 'Inserts or updates a variable in shared memory (resource shm_identifier, int variable_key, mixed variable): bool',
	shm_remove_var: 'Removes a variable from shared memory (resource shm_identifier, int variable_key): bool',
	shm_remove: 'Removes shared memory from Unix systems (resource shm_identifier): bool',
	session_cache_expire: 'Return current cache expire ([string new_cache_expire]): int',
	session_cache_limiter: 'Get and/or set the current cache limiter ([string cache_limiter]): string',
	session_commit: 'Alias of session_write_close',
	session_decode: 'Decodes session data from a string (string data): bool',
	session_destroy: 'Destroys all data registered to a session (): bool',
	session_encode: 'Encodes the current session data as a string (): string',
	session_get_cookie_params: 'Get the session cookie parameters (): array',
	session_id: 'Get and/or set the current session id ([string id]): string',
	session_is_registered: 'Find out whether a global variable is registered in a session (string name): bool',
	session_module_name: 'Get and/or set the current session module ([string module]): string',
	session_name: 'Get and/or set the current session name ([string name]): string',
	session_regenerate_id: 'Update the current session id with a newly generated one ([bool delete_old_session]): bool',
	session_register: 'Register one or more global variables with the current session (mixed name, [mixed ...]): bool',
	session_save_path: 'Get and/or set the current session save path ([string path]): string',
	session_set_cookie_params: 'Set the session cookie parameters (int lifetime, [string path, [string domain, [bool secure, [bool httponly]]]]): null',
	session_set_save_handler: 'Sets user-level session storage functions (callback open, callback close, callback read, callback write, callback destroy, callback gc): bool',
	session_start: 'Initialize session data (): bool',
	session_unregister: 'Unregister a global variable from the current session (string name): bool',
	session_unset: 'Free all session variables (): null',
	session_write_close: 'Write session data and end session (): null',
	session_pgsql_add_error: 'Increments error counts and sets last error message (int error_level, [string error_message]): bool',
	session_pgsql_get_error: 'Returns number of errors and last error message ([bool with_error_message]): array',
	session_pgsql_get_field: 'Get custom field value (): string',
	session_pgsql_reset: 'Reset connection to session database servers (): bool',
	session_pgsql_set_field: 'Set custom field value (string value): bool',
	session_pgsql_status: 'Get current save handler status (): array',
	shmop_close: 'Close shared memory block (int shmid): null',
	shmop_delete: 'Delete shared memory block (int shmid): bool',
	shmop_open: 'Create or open shared memory block (int key, string flags, int mode, int size): int',
	shmop_read: 'Read data from shared memory block (int shmid, int start, int count): string',
	shmop_size: 'Get size of shared memory block (int shmid): int',
	shmop_write: 'Write data into shared memory block (int shmid, string data, int offset): int',
	simplexml_import_dom: 'Get a SimpleXMLElement object from a DOM node. (DOMNode node, [string class_name]): SimpleXMLElement',
	simplexml_load_file: 'Interprets an XML file into an object (string filename, [string class_name, [int options, [string ns, [bool is_prefix]]]]): object',
	simplexml_load_string: 'Interprets a string of XML into an object (string data, [string class_name, [int options, [string ns, [bool is_prefix]]]]): object',
	snmp_get_quick_print: 'Fetches the current value of the UCD library\'s quick_print setting (): bool',
	snmp_get_valueretrieval: 'Return the method how the SNMP values will be returned (): int',
	snmp_read_mib: 'Reads and parses a MIB file into the active MIB tree (string filename): bool',
	snmp_set_enum_print: 'Return all values that are enums with their enum value instead of the raw integer (int enum_print): null',
	snmp_set_oid_numeric_print: 'Return all objects including their respective object id within the specified one (int oid_numeric_print): null',
	snmp_set_oid_output_format: 'Set the OID output format (int oid_format): null',
	snmp_set_quick_print: 'Set the value of quick_print within the UCD SNMP library (bool quick_print): null',
	snmp_set_valueretrieval: 'Specify the method how the SNMP values will be returned (int method): null',
	snmpget: 'Fetch an SNMP object (string hostname, string community, string object_id, [int timeout, [int retries]]): string',
	snmpgetnext: 'Fetch a SNMP object (string host, string community, string object_id, [int timeout, [int retries]]): string',
	snmprealwalk: 'Return all objects including their respective object ID within the specified one (string host, string community, string object_id, [int timeout, [int retries]]): array',
	snmpset: 'Set an SNMP object (string hostname, string community, string object_id, string type, mixed value, [int timeout, [int retries]]): bool',
	snmpwalk: 'Fetch all the SNMP objects from an agent (string hostname, string community, string object_id, [int timeout, [int retries]]): array',
	snmpwalkoid: 'Query for a tree of information about a network entity (string hostname, string community, string object_id, [int timeout, [int retries]]): array',
	is_soap_fault: 'Checks if a SOAP call has failed (mixed object): bool',
	use_soap_error_handler: 'Set whether to use the SOAP error handler ([bool handler]): bool',
	socket_accept: 'Accepts a connection on a socket (resource socket): resource',
	socket_bind: 'Binds a name to a socket (resource socket, string address, [int port]): bool',
	socket_clear_error: 'Clears the error on the socket or the last error code ([resource socket]): null',
	socket_close: 'Closes a socket resource (resource socket): null',
	socket_connect: 'Initiates a connection on a socket (resource socket, string address, [int port]): bool',
	socket_create_listen: 'Opens a socket on port to accept connections (int port, [int backlog]): resource',
	socket_create_pair: 'Creates a pair of indistinguishable sockets and stores them in an array (int domain, int type, int protocol, array &fd): bool',
	socket_create: 'Create a socket (endpoint for communication) (int domain, int type, int protocol): resource',
	socket_get_option: 'Gets socket options for the socket (resource socket, int level, int optname): mixed',
	socket_getpeername: 'Queries the remote side of the given socket which may either result in host/port or in a Unix filesystem path, dependent on its type (resource socket, string &address, [int &port]): bool',
	socket_getsockname: 'Queries the local side of the given socket which may either result in host/port or in a Unix filesystem path, dependent on its type (resource socket, string &addr, [int &port]): bool',
	socket_last_error: 'Returns the last error on the socket ([resource socket]): int',
	socket_listen: 'Listens for a connection on a socket (resource socket, [int backlog]): bool',
	socket_read: 'Reads a maximum of length bytes from a socket (resource socket, int length, [int type]): string',
	socket_recv: 'Receives data from a connected socket (resource socket, string &buf, int len, int flags): int',
	socket_recvfrom: 'Receives data from a socket whether or not it is connection-oriented (resource socket, string &buf, int len, int flags, string &name, [int &port]): int',
	socket_select: 'Runs the select() system call on the given arrays of sockets with a specified timeout (array &read, array &write, array &except, int tv_sec, [int tv_usec]): int',
	socket_send: 'Sends data to a connected socket (resource socket, string buf, int len, int flags): int',
	socket_sendto: 'Sends a message to a socket, whether it is connected or not (resource socket, string buf, int len, int flags, string addr, [int port]): int',
	socket_set_block: 'Sets blocking mode on a socket resource (resource socket): bool',
	socket_set_nonblock: 'Sets nonblocking mode for file descriptor fd (resource socket): bool',
	socket_set_option: 'Sets socket options for the socket (resource socket, int level, int optname, mixed optval): bool',
	socket_shutdown: 'Shuts down a socket for receiving, sending, or both (resource socket, [int how]): bool',
	socket_strerror: 'Return a string describing a socket error (int errno): string',
	socket_write: 'Write to a socket (resource socket, string buffer, [int length]): int',
	solr_get_version: 'Returns the current version of the Apache Solr extension (): string',
	class_implements: 'Return the interfaces which are implemented by the given class (mixed class, [bool autoload]): array',
	class_parents: 'Return the parent classes of the given class (mixed class, [bool autoload]): array',
	iterator_apply: 'Call a function for every element in an iterator (Traversable iterator, callback function, [array args]): int',
	iterator_count: 'Count the elements in an iterator (Traversable iterator): int',
	iterator_to_array: 'Copy the iterator into an array (Traversable iterator, [bool use_keys]): array',
	spl_autoload_call: 'Try all registered __autoload() function to load the requested class (string class_name): null',
	spl_autoload_extensions: 'Register and return default file extensions for spl_autoload ([string file_extensions]): string',
	spl_autoload_functions: 'Return all registered __autoload() functions (): array',
	spl_autoload_register: 'Register given function as __autoload() implementation ([callback autoload_function, [bool throw, [bool prepend]]]): bool',
	spl_autoload_unregister: 'Unregister given function as __autoload() implementation (mixed autoload_function): bool',
	spl_autoload: 'Default implementation for __autoload() (string class_name, [string file_extensions]): null',
	spl_classes: 'Return available SPL classes (): array',
	spl_object_hash: 'Return hash id for given object (object obj): string',
	calcul_hmac: 'Obtain a hmac key (needs 8 arguments) (string clent, string siretcode, string price, string reference, string validity, string taxation, string devise, string language): string',
	calculhmac: 'Obtain a hmac key (needs 2 arguments) (string clent, string data): string',
	nthmac: 'Obtain a nthmac key (needs 2 arguments) (string clent, string data): string',
	nthmac: 'Obtain the payment url (needs 2 arguments) (string clent, string data): string',
	sqlite_array_query: 'Execute a query against a given database and returns an array (resource dbhandle, string query, [int result_type, [bool decode_binary]]): array',
	sqlite_array_query: 'Execute a query against a given database and returns an array (string query, resource dbhandle, [int result_type, [bool decode_binary]]): array',
	sqlite_busy_timeout: 'Set busy timeout duration, or disable busy handlers (resource dbhandle, int milliseconds): null',
	sqlite_changes: 'Returns the number of rows that were changed by the most recent SQL statement (resource dbhandle): int',
	sqlite_close: 'Closes an open SQLite database (resource dbhandle): null',
	sqlite_column: 'Fetches a column from the current row of a result set (resource result, mixed index_or_name, [bool decode_binary]): mixed',
	sqlite_create_aggregate: 'Register an aggregating UDF for use in SQL statements (resource dbhandle, string function_name, callback step_func, callback finalize_func, [int num_args]): null',
	sqlite_create_function: 'Registers a "regular" User Defined Function for use in SQL statements (resource dbhandle, string function_name, callback callback, [int num_args]): null',
	sqlite_current: 'Fetches the current row from a result set as an array (resource result, [int result_type, [bool decode_binary]]): array',
	sqlite_error_string: 'Returns the textual description of an error code (int error_code): string',
	sqlite_escape_string: 'Escapes a string for use as a query parameter (string item): string',
	sqlite_exec: 'Executes a result-less query against a given database (resource dbhandle, string query, [string &error_msg]): bool',
	sqlite_exec: 'Executes a result-less query against a given database (string query, resource dbhandle): bool',
	sqlite_factory: 'Opens a SQLite database and returns a SQLiteDatabase object (string filename, [int mode, [string &error_message]]): SQLiteDatabase',
	sqlite_fetch_all: 'Fetches all rows from a result set as an array of arrays (resource result, [int result_type, [bool decode_binary]]): array',
	sqlite_fetch_array: 'Fetches the next row from a result set as an array (resource result, [int result_type, [bool decode_binary]]): array',
	sqlite_fetch_column_types: 'Return an array of column types from a particular table (string table_name, resource dbhandle, [int result_type]): array',
	sqlite_fetch_object: 'Fetches the next row from a result set as an object (resource result, [string class_name, [array ctor_params, [bool decode_binary]]]): object',
	sqlite_fetch_single: 'Fetches the first column of a result set as a string (resource result, [bool decode_binary]): string',
	sqlite_fetch_string: 'Alias of sqlite_fetch_single',
	sqlite_field_name: 'Returns the name of a particular field (resource result, int field_index): string',
	sqlite_has_more: 'Finds whether or not more rows are available (resource result): bool',
	sqlite_has_prev: 'Returns whether or not a previous row is available (resource result): bool',
	sqlite_key: 'Returns the current row index (resource result): int',
	sqlite_last_error: 'Returns the error code of the last error for a database (resource dbhandle): int',
	sqlite_last_insert_rowid: 'Returns the rowid of the most recently inserted row (resource dbhandle): int',
	sqlite_libencoding: 'Returns the encoding of the linked SQLite library (): string',
	sqlite_libversion: 'Returns the version of the linked SQLite library (): string',
	sqlite_next: 'Seek to the next row number (resource result): bool',
	sqlite_num_fields: 'Returns the number of fields in a result set (resource result): int',
	sqlite_num_rows: 'Returns the number of rows in a buffered result set (resource result): int',
	sqlite_open: 'Opens a SQLite database and create the database if it does not exist (string filename, [int mode, [string &error_message]]): resource',
	sqlite_popen: 'Opens a persistent handle to an SQLite database and create the database if it does not exist (string filename, [int mode, [string &error_message]]): resource',
	sqlite_prev: 'Seek to the previous row number of a result set (resource result): bool',
	sqlite_query: 'Executes a query against a given database and returns a result handle (resource dbhandle, string query, [int result_type, [string &error_msg]]): resource',
	sqlite_query: 'Executes a query against a given database and returns a result handle (string query, resource dbhandle, [int result_type, [string &error_msg]]): resource',
	sqlite_rewind: 'Seek to the first row number (resource result): bool',
	sqlite_seek: 'Seek to a particular row number of a buffered result set (resource result, int rownum): bool',
	sqlite_single_query: 'Executes a query and returns either an array for one single column or the value of the first row (resource db, string query, [bool first_row_only, [bool decode_binary]]): array',
	sqlite_udf_decode_binary: 'Decode binary data passed as parameters to an UDF (string data): string',
	sqlite_udf_encode_binary: 'Encode binary data before returning it from an UDF (string data): string',
	sqlite_unbuffered_query: 'Execute a query that does not prefetch and buffer all data (resource dbhandle, string query, [int result_type, [string &error_msg]]): resource',
	sqlite_unbuffered_query: 'Execute a query that does not prefetch and buffer all data (string query, resource dbhandle, [int result_type, [string &error_msg]]): resource',
	sqlite_valid: 'Returns whether more rows are available (resource result): bool',
	ssh2_auth_hostbased_file: 'Authenticate using a public hostkey (resource session, string username, string hostname, string pubkeyfile, string privkeyfile, [string passphrase, [string local_username]]): bool',
	ssh2_auth_none: 'Authenticate as "none" (resource session, string username): mixed',
	ssh2_auth_password: 'Authenticate over SSH using a plain password (resource session, string username, string password): bool',
	ssh2_auth_pubkey_file: 'Authenticate using a public key (resource session, string username, string pubkeyfile, string privkeyfile, [string passphrase]): bool',
	ssh2_connect: 'Connect to an SSH server (string host, [int port, [array methods, [array callbacks]]]): resource',
	ssh2_exec: 'Execute a command on a remote server (resource session, string command, [string pty, [array env, [int width, [int height, [int width_height_type]]]]]): resource',
	ssh2_fetch_stream: 'Fetch an extended data stream (resource channel, int streamid): resource',
	ssh2_fingerprint: 'Retrieve fingerprint of remote server (resource session, [int flags]): string',
	ssh2_methods_negotiated: 'Return list of negotiated methods (resource session): array',
	ssh2_publickey_add: 'Add an authorized publickey (resource pkey, string algoname, string blob, [bool overwrite, [array attributes]]): bool',
	ssh2_publickey_init: 'Initialize Publickey subsystem (resource session): resource',
	ssh2_publickey_list: 'List currently authorized publickeys (resource pkey): array',
	ssh2_publickey_remove: 'Remove an authorized publickey (resource pkey, string algoname, string blob): bool',
	ssh2_scp_recv: 'Request a file via SCP (resource session, string remote_file, string local_file): bool',
	ssh2_scp_send: 'Send a file via SCP (resource session, string local_file, string remote_file, [int create_mode]): bool',
	ssh2_sftp_lstat: 'Stat a symbolic link (resource sftp, string path): array',
	ssh2_sftp_mkdir: 'Create a directory (resource sftp, string dirname, [int mode, [bool recursive]]): bool',
	ssh2_sftp_readlink: 'Return the target of a symbolic link (resource sftp, string link): string',
	ssh2_sftp_realpath: 'Resolve the realpath of a provided path string (resource sftp, string filename): string',
	ssh2_sftp_rename: 'Rename a remote file (resource sftp, string from, string to): bool',
	ssh2_sftp_rmdir: 'Remove a directory (resource sftp, string dirname): bool',
	ssh2_sftp_stat: 'Stat a file on a remote filesystem (resource sftp, string path): array',
	ssh2_sftp_symlink: 'Create a symlink (resource sftp, string target, string link): bool',
	ssh2_sftp_unlink: 'Delete a file (resource sftp, string filename): bool',
	ssh2_sftp: 'Initialize SFTP subsystem (resource session): resource',
	ssh2_shell: 'Request an interactive shell (resource session, [string term_type, [array env, [int width, [int height, [int width_height_type]]]]]): resource',
	ssh2_tunnel: 'Open a tunnel through a remote server (resource session, string host, int port): resource',
	stats_absolute_deviation: 'Returns the absolute deviation of an array of values (array a): float',
	stats_cdf_beta: 'CDF function for BETA Distribution. Calculates any one parameter of the beta distribution given values for the others. (float par1, float par2, float par3, int which): float',
	stats_cdf_binomial: 'Calculates any one parameter of the binomial distribution given values for the others. (float par1, float par2, float par3, int which): float',
	stats_cdf_cauchy: 'Not documented (float par1, float par2, float par3, int which): float',
	stats_cdf_chisquare: 'Calculates any one parameter of the chi-square distribution given values for the others. (float par1, float par2, int which): float',
	stats_cdf_exponential: 'Not documented (float par1, float par2, int which): float',
	stats_cdf_f: 'Calculates any one parameter of the F distribution given values for the others. (float par1, float par2, float par3, int which): float',
	stats_cdf_gamma: 'Calculates any one parameter of the gamma distribution given values for the others. (float par1, float par2, float par3, int which): float',
	stats_cdf_laplace: 'Not documented (float par1, float par2, float par3, int which): float',
	stats_cdf_logistic: 'Not documented (float par1, float par2, float par3, int which): float',
	stats_cdf_negative_binomial: 'Calculates any one parameter of the negative binomial distribution given values for the others. (float par1, float par2, float par3, int which): float',
	stats_cdf_noncentral_chisquare: 'Calculates any one parameter of the non-central chi-square distribution given values for the others. (float par1, float par2, float par3, int which): float',
	stats_cdf_noncentral_f: 'Calculates any one parameter of the Non-central F distribution given values for the others. (float par1, float par2, float par3, float par4, int which): float',
	stats_cdf_poisson: 'Calculates any one parameter of the Poisson distribution given values for the others. (float par1, float par2, int which): float',
	stats_cdf_t: 'Calculates any one parameter of the T distribution given values for the others. (float par1, float par2, int which): float',
	stats_cdf_uniform: 'Not documented (float par1, float par2, float par3, int which): float',
	stats_cdf_weibull: 'Not documented (float par1, float par2, float par3, int which): float',
	stats_covariance: 'Computes the covariance of two data sets (array a, array b): float',
	stats_den_uniform: 'Not documented (float x, float a, float b): float',
	stats_dens_beta: 'Not documented (float x, float a, float b): float',
	stats_dens_cauchy: 'Not documented (float x, float ave, float stdev): float',
	stats_dens_chisquare: 'Not documented (float x, float dfr): float',
	stats_dens_exponential: 'Not documented (float x, float scale): float',
	stats_dens_f: ' (float x, float dfr1, float dfr2): float',
	stats_dens_gamma: 'Not documented (float x, float shape, float scale): float',
	stats_dens_laplace: 'Not documented (float x, float ave, float stdev): float',
	stats_dens_logistic: 'Not documented (float x, float ave, float stdev): float',
	stats_dens_negative_binomial: 'Not documented (float x, float n, float pi): float',
	stats_dens_normal: 'Not documented (float x, float ave, float stdev): float',
	stats_dens_pmf_binomial: 'Not documented (float x, float n, float pi): float',
	stats_dens_pmf_hypergeometric: ' (float n1, float n2, float N1, float N2): float',
	stats_dens_pmf_poisson: 'Not documented (float x, float lb): float',
	stats_dens_t: 'Not documented (float x, float dfr): float',
	stats_dens_weibull: 'Not documented (float x, float a, float b): float',
	stats_harmonic_mean: 'Returns the harmonic mean of an array of values (array a): number',
	stats_kurtosis: 'Computes the kurtosis of the data in the array (array a): float',
	stats_rand_gen_beta: 'Generates beta random deviate (float a, float b): float',
	stats_rand_gen_chisquare: 'Generates random deviate from the distribution of a chisquare with "df" degrees of freedom random variable. (float df): float',
	stats_rand_gen_exponential: 'Generates a single random deviate from an exponential distribution with mean "av" (float av): float',
	stats_rand_gen_f: 'Generates a random deviate (float dfn, float dfd): float',
	stats_rand_gen_funiform: 'Generates uniform float between low (exclusive) and high (exclusive) (float low, float high): float',
	stats_rand_gen_gamma: 'Generates random deviates from a gamma distribution (float a, float r): float',
	stats_rand_gen_ibinomial_negative: 'Generates a single random deviate from a negative binomial distribution. Arguments : n - the number of trials in the negative binomial distribution from which a random deviate is to be generated (n > 0), p - the probability of an event (0 < p < 1)). (int n, float p): int',
	stats_rand_gen_ibinomial: 'Generates a single random deviate from a binomial distribution whose number of trials is "n" (n >= 0) and whose probability of an event in each trial is "pp" ([0;1]). Method : algorithm BTPE (int n, float pp): int',
	stats_rand_gen_int: 'Generates random integer between 1 and 2147483562 (): int',
	stats_rand_gen_ipoisson: 'Generates a single random deviate from a Poisson distribution with mean "mu" (mu >= 0.0). (float mu): int',
	stats_rand_gen_iuniform: 'Generates integer uniformly distributed between LOW (inclusive) and HIGH (inclusive) (int low, int high): int',
	stats_rand_gen_noncenral_chisquare: 'Generates random deviate from the distribution of a noncentral chisquare with "df" degrees of freedom and noncentrality parameter "xnonc". d must be >= 1.0, xnonc must >= 0.0 (float df, float xnonc): float',
	stats_rand_gen_noncentral_f: 'Generates a random deviate from the noncentral F (variance ratio) distribution with "dfn" degrees of freedom in the numerator, and "dfd" degrees of freedom in the denominator, and noncentrality parameter "xnonc". Method : directly generates ratio of noncentral numerator chisquare variate to central denominator chisquare variate. (float dfn, float dfd, float xnonc): float',
	stats_rand_gen_noncentral_t: 'Generates a single random deviate from a noncentral T distribution (float df, float xnonc): float',
	stats_rand_gen_normal: 'Generates a single random deviate from a normal distribution with mean, av, and standard deviation, sd (sd >= 0). Method : Renames SNORM from TOMS as slightly modified by BWB to use RANF instead of SUNIF. (float av, float sd): float',
	stats_rand_gen_t: 'Generates a single random deviate from a T distribution (float df): float',
	stats_rand_get_seeds: 'Not documented (): array',
	stats_rand_phrase_to_seeds: 'generate two seeds for the RGN random number generator (string phrase): array',
	stats_rand_ranf: 'Returns a random floating point number from a uniform distribution over 0 - 1 (endpoints of this interval are not returned) using the current generator (): float',
	stats_rand_setall: 'Not documented (int iseed1, int iseed2): null',
	stats_skew: 'Computes the skewness of the data in the array (array a): float',
	stats_standard_deviation: 'Returns the standard deviation (array a, [bool sample]): float',
	stats_stat_binomial_coef: 'Not documented (int x, int n): float',
	stats_stat_correlation: 'Not documented (array arr1, array arr2): float',
	stats_stat_gennch: 'Not documented (int n): float',
	stats_stat_independent_t: 'Not documented (array arr1, array arr2): float',
	stats_stat_innerproduct: ' (array arr1, array arr2): float',
	stats_stat_noncentral_t: 'Calculates any one parameter of the noncentral t distribution give values for the others. (float par1, float par2, float par3, int which): float',
	stats_stat_paired_t: 'Not documented (array arr1, array arr2): float',
	stats_stat_percentile: 'Not documented (float df, float xnonc): float',
	stats_stat_powersum: 'Not documented (array arr, float power): float',
	stats_variance: 'Returns the population variance (array a, [bool sample]): float',
	stomp_connect_error: 'Returns a string description of the last connect error (): string',
	stomp_version: 'Gets the current stomp extension version (): string',
	stomp_abort: 'Rolls back a transaction in progress (resource link, string transaction_id, [array headers]): bool',
	stomp_ack: 'Acknowledges consumption of a message (resource link, mixed msg, [array headers]): bool',
	stomp_begin: 'Starts a transaction (resource link, string transaction_id, [array headers]): bool',
	stomp_commit: 'Commits a transaction in progress (resource link, string transaction_id, [array headers]): bool',
	stomp_connect: 'Opens a connection ([string broker, [string username, [string password]]]): resource',
	stomp_close: 'Closes stomp connection (resource link): bool',
	stomp_error: 'Gets the last stomp error (resource link): string',
	stomp_get_read_timeout: 'Gets read timeout (resource link): array',
	stomp_get_session_id: 'Gets the current stomp session ID (resource link): string',
	stomp_has_frame: 'Indicates whether or not there is a frame ready to read (resource link): bool',
	stomp_read_frame: 'Reads the next frame (resource link): array',
	stomp_send: 'Sends a message (resource link, string destination, mixed msg, [array headers]): bool',
	stomp_set_read_timeout: 'Sets read timeout (resource link, integer seconds, [integer microseconds]): null',
	stomp_subscribe: 'Registers to listen to a given destination (resource link, string destination, [array headers]): bool',
	stomp_unsubscribe: 'Removes an existing subscription (resource link, string destination, [array headers]): bool',
	set_socket_blocking: 'Alias of stream_set_blocking',
	stream_bucket_append: 'Append bucket to brigade (resource brigade, resource bucket): null',
	stream_bucket_make_writeable: 'Return a bucket object from the brigade for operating on (resource brigade): object',
	stream_bucket_new: 'Create a new bucket for use on the current stream (resource stream, string buffer): object',
	stream_bucket_prepend: 'Prepend bucket to brigade (resource brigade, resource bucket): null',
	stream_context_create: 'Create a streams context ([array options, [array params]]): resource',
	stream_context_get_default: 'Retreive the default streams context ([array options]): resource',
	stream_context_get_options: 'Retrieve options for a stream/wrapper/context (resource stream_or_context): array',
	stream_context_get_params: 'Retrieves parameters from a context (resource stream_or_context): array',
	stream_context_set_default: 'Set the default streams context (array options): resource',
	stream_context_set_option: 'Sets an option for a stream/wrapper/context (resource stream_or_context, string wrapper, string option, mixed value): bool',
	stream_context_set_option: 'Sets an option for a stream/wrapper/context (resource stream_or_context, array options): bool',
	stream_context_set_params: 'Set parameters for a stream/wrapper/context (resource stream_or_context, array params): bool',
	stream_copy_to_stream: 'Copies data from one stream to another (resource source, resource dest, [int maxlength, [int offset]]): int',
	stream_encoding: 'Set character set for stream encoding (resource stream, [string encoding]): bool',
	stream_filter_append: 'Attach a filter to a stream (resource stream, string filtername, [int read_write, [mixed params]]): resource',
	stream_filter_prepend: 'Attach a filter to a stream (resource stream, string filtername, [int read_write, [mixed params]]): resource',
	stream_filter_register: 'Register a user defined stream filter (string filtername, string classname): bool',
	stream_filter_remove: 'Remove a filter from a stream (resource stream_filter): bool',
	stream_get_contents: 'Reads remainder of a stream into a string (resource handle, [int maxlength, [int offset]]): string',
	stream_get_filters: 'Retrieve list of registered filters (): array',
	stream_get_line: 'Gets line from stream resource up to a given delimiter (resource handle, int length, [string ending]): string',
	stream_get_meta_data: 'Retrieves header/meta data from streams/file pointers (resource stream): array',
	stream_get_transports: 'Retrieve list of registered socket transports (): array',
	stream_get_wrappers: 'Retrieve list of registered streams (): array',
	stream_is_local: 'Checks if a stream is a local stream (mixed stream_or_url): bool',
	stream_register_wrapper: 'Alias of stream_wrapper_register',
	stream_resolve_include_path: 'Resolve filename against the include path (string filename, [resource context]): string',
	stream_select: 'Runs the equivalent of the select() system call on the given arrays of streams with a timeout specified by tv_sec and tv_usec (array &read, array &write, array &except, int tv_sec, [int tv_usec]): int',
	stream_set_blocking: 'Set blocking/non-blocking mode on a stream (resource stream, int mode): bool',
	stream_set_timeout: 'Set timeout period on a stream (resource stream, int seconds, [int microseconds]): bool',
	stream_set_write_buffer: 'Sets file buffering on the given stream (resource stream, int buffer): int',
	stream_socket_accept: 'Accept a connection on a socket created by stream_socket_server (resource server_socket, [float timeout, [string &peername]]): resource',
	stream_socket_client: 'Open Internet or Unix domain socket connection (string remote_socket, [int &errno, [string &errstr, [float timeout, [int flags, [resource context]]]]]): resource',
	stream_socket_enable_crypto: 'Turns encryption on/off on an already connected socket (resource stream, bool enable, [int crypto_type, [resource session_stream]]): mixed',
	stream_socket_get_name: 'Retrieve the name of the local or remote sockets (resource handle, bool want_peer): string',
	stream_socket_pair: 'Creates a pair of connected, indistinguishable socket streams (int domain, int type, int protocol): array',
	stream_socket_recvfrom: 'Receives data from a socket, connected or not (resource socket, int length, [int flags, [string &address]]): string',
	stream_socket_sendto: 'Sends a message to a socket, whether it is connected or not (resource socket, string data, [int flags, [string address]]): int',
	stream_socket_server: 'Create an Internet or Unix domain server socket (string local_socket, [int &errno, [string &errstr, [int flags, [resource context]]]]): resource',
	stream_socket_shutdown: 'Shutdown a full-duplex connection (resource stream, int how): bool',
	stream_supports_lock: 'Tells whether the stream supports locking. (resource stream): bool',
	stream_wrapper_register: 'Register a URL wrapper implemented as a PHP class (string protocol, string classname, [int flags]): bool',
	stream_wrapper_restore: 'Restores a previously unregistered built-in wrapper (string protocol): bool',
	stream_wrapper_unregister: 'Unregister a URL wrapper (string protocol): bool',
	addcslashes: 'Quote string with slashes in a C style (string str, string charlist): string',
	addslashes: 'Quote string with slashes (string str): string',
	bin2hex: 'Convert binary data into hexadecimal representation (string str): string',
	chop: 'Alias of rtrim',
	chr: 'Return a specific character (int ascii): string',
	chunk_split: 'Split a string into smaller chunks (string body, [int chunklen, [string end]]): string',
	convert_cyr_string: 'Convert from one Cyrillic character set to another (string str, string from, string to): string',
	convert_uudecode: 'Decode a uuencoded string (string data): string',
	convert_uuencode: 'Uuencode a string (string data): string',
	count_chars: 'Return information about characters used in a string (string string, [int mode]): mixed',
	crc32: 'Calculates the crc32 polynomial of a string (string str): int',
	crypt: 'One-way string hashing (string str, [string salt]): string',
	echo: 'Output one or more strings (string arg1, [string ...]): null',
	explode: 'Split a string by string (string delimiter, string string, [int limit]): array',
	fprintf: 'Write a formatted string to a stream (resource handle, string format, [mixed args, [mixed ...]]): int',
	get_html_translation_table: 'Returns the translation table used by htmlspecialchars and htmlentities ([int table, [int quote_style]]): array',
	hebrev: 'Convert logical Hebrew text to visual text (string hebrew_text, [int max_chars_per_line]): string',
	hebrevc: 'Convert logical Hebrew text to visual text with newline conversion (string hebrew_text, [int max_chars_per_line]): string',
	html_entity_decode: 'Convert all HTML entities to their applicable characters (string string, [int quote_style, [string charset]]): string',
	htmlentities: 'Convert all applicable characters to HTML entities (string string, [int quote_style, [string charset, [bool double_encode]]]): string',
	htmlspecialchars_decode: 'Convert special HTML entities back to characters (string string, [int quote_style]): string',
	htmlspecialchars: 'Convert special characters to HTML entities (string string, [int quote_style, [string charset, [bool double_encode]]]): string',
	implode: 'Join array elements with a string (string glue, array pieces): string',
	implode: 'Join array elements with a string (array pieces): string',
	join: 'Alias of implode',
	lcfirst: 'Make a string\'s first character lowercase (string str): string',
	levenshtein: 'Calculate Levenshtein distance between two strings (string str1, string str2): int',
	levenshtein: 'Calculate Levenshtein distance between two strings (string str1, string str2, int cost_ins, int cost_rep, int cost_del): int',
	localeconv: 'Get numeric formatting information (): array',
	ltrim: 'Strip whitespace (or other characters) from the beginning of a string (string str, [string charlist]): string',
	md5_file: 'Calculates the md5 hash of a given file (string filename, [bool raw_output]): string',
	md5: 'Calculate the md5 hash of a string (string str, [bool raw_output]): string',
	metaphone: 'Calculate the metaphone key of a string (string str, [int phonemes]): string',
	money_format: 'Formats a number as a currency string (string format, float number): string',
	nl_langinfo: 'Query language and locale information (int item): string',
	nl2br: 'Inserts HTML line breaks before all newlines in a string (string string, [bool is_xhtml]): string',
	number_format: 'Format a number with grouped thousands (float number, [int decimals]): string',
	number_format: 'Format a number with grouped thousands (float number, int decimals, string dec_point, string thousands_sep): string',
	ord: 'Return ASCII value of character (string string): int',
	parse_str: 'Parses the string into variables (string str, [array &arr]): null',
	print: 'Output a string (string arg): int',
	printf: 'Output a formatted string (string format, [mixed args, [mixed ...]]): int',
	quoted_printable_decode: 'Convert a quoted-printable string to an 8 bit string (string str): string',
	quoted_printable_encode: 'Convert a 8 bit string to a quoted-printable string (string str): string',
	quotemeta: 'Quote meta characters (string str): string',
	rtrim: 'Strip whitespace (or other characters) from the end of a string (string str, [string charlist]): string',
	setlocale: 'Set locale information (int category, string locale, [string ...]): string',
	setlocale: 'Set locale information (int category, array locale): string',
	sha1_file: 'Calculate the sha1 hash of a file (string filename, [bool raw_output]): string',
	sha1: 'Calculate the sha1 hash of a string (string str, [bool raw_output]): string',
	similar_text: 'Calculate the similarity between two strings (string first, string second, [float &percent]): int',
	soundex: 'Calculate the soundex key of a string (string str): string',
	sprintf: 'Return a formatted string (string format, [mixed args, [mixed ...]]): string',
	sscanf: 'Parses input from a string according to a format (string str, string format, [mixed &...]): mixed',
	str_getcsv: 'Parse a CSV string into an array (string input, [string delimiter, [string enclosure, [string escape]]]): array',
	str_ireplace: 'Case-insensitive version of str_replace. (mixed search, mixed replace, mixed subject, [int &count]): mixed',
	str_pad: 'Pad a string to a certain length with another string (string input, int pad_length, [string pad_string, [int pad_type]]): string',
	str_repeat: 'Repeat a string (string input, int multiplier): string',
	str_replace: 'Replace all occurrences of the search string with the replacement string (mixed search, mixed replace, mixed subject, [int &count]): mixed',
	str_rot13: 'Perform the rot13 transform on a string (string str): string',
	str_shuffle: 'Randomly shuffles a string (string str): string',
	str_split: 'Convert a string to an array (string string, [int split_length]): array',
	str_word_count: 'Return information about words used in a string (string string, [int format, [string charlist]]): mixed',
	strcasecmp: 'Binary safe case-insensitive string comparison (string str1, string str2): int',
	strchr: 'Alias of strstr',
	strcmp: 'Binary safe string comparison (string str1, string str2): int',
	strcoll: 'Locale based string comparison (string str1, string str2): int',
	strcspn: 'Find length of initial segment not matching mask (string str1, string str2, [int start, [int length]]): int',
	strip_tags: 'Strip HTML and PHP tags from a string (string str, [string allowable_tags]): string',
	stripcslashes: 'Un-quote string quoted with addcslashes (string str): string',
	stripos: 'Find position of first occurrence of a case-insensitive string (string haystack, string needle, [int offset]): int',
	stripslashes: 'Un-quotes a quoted string (string str): string',
	stristr: 'Case-insensitive strstr (string haystack, mixed needle, [bool before_needle]): string',
	strlen: 'Get string length (string string): int',
	strnatcasecmp: 'Case insensitive string comparisons using a "natural order" algorithm (string str1, string str2): int',
	strnatcmp: 'String comparisons using a "natural order" algorithm (string str1, string str2): int',
	strncasecmp: 'Binary safe case-insensitive string comparison of the first n characters (string str1, string str2, int len): int',
	strncmp: 'Binary safe string comparison of the first n characters (string str1, string str2, int len): int',
	strpbrk: 'Search a string for any of a set of characters (string haystack, string char_list): string',
	strpos: 'Find position of first occurrence of a string (string haystack, mixed needle, [int offset]): int',
	strrchr: 'Find the last occurrence of a character in a string (string haystack, mixed needle): string',
	strrev: 'Reverse a string (string string): string',
	strripos: 'Find position of last occurrence of a case-insensitive string in a string (string haystack, string needle, [int offset]): int',
	strrpos: 'Find position of last occurrence of a char in a string (string haystack, string needle, [int offset]): int',
	strspn: 'Finds the length of the first segment of a string consisting entirely of characters contained within a given mask. (string subject, string mask, [int start, [int length]]): int',
	strstr: 'Find first occurrence of a string (string haystack, mixed needle, [bool before_needle]): string',
	strtok: 'Tokenize string (string str, string token): string',
	strtok: 'Tokenize string (string token): string',
	strtolower: 'Make a string lowercase (string str): string',
	strtoupper: 'Make a string uppercase (string string): string',
	strtr: 'Translate certain characters (string str, string from, string to): string',
	strtr: 'Translate certain characters (string str, array replace_pairs): string',
	substr_compare: 'Binary safe comparison of two strings from an offset, up to length characters (string main_str, string str, int offset, [int length, [bool case_insensitivity]]): int',
	substr_count: 'Count the number of substring occurrences (string haystack, string needle, [int offset, [int length]]): int',
	substr_replace: 'Replace text within a portion of a string (mixed string, string replacement, int start, [int length]): mixed',
	substr: 'Return part of a string (string string, int start, [int length]): string',
	trim: 'Strip whitespace (or other characters) from the beginning and end of a string (string str, [string charlist]): string',
	ucfirst: 'Make a string\'s first character uppercase (string str): string',
	ucwords: 'Uppercase the first character of each word in a string (string str): string',
	vfprintf: 'Write a formatted string to a stream (resource handle, string format, array args): int',
	vprintf: 'Output a formatted string (string format, array args): int',
	vsprintf: 'Return a formatted string (string format, array args): string',
	wordwrap: 'Wraps a string to a given number of characters (string str, [int width, [string break, [bool cut]]]): string',
	svn_add: 'Schedules the addition of an item in a working directory (string path, [bool recursive, [bool force]]): bool',
	svn_auth_get_parameter: 'Retrieves authentication parameter (string key): string',
	svn_auth_set_parameter: 'Sets an authentication parameter (string key, string value): null',
	svn_blame: 'Get the SVN blame for a file (string repository_url, [int revision_no]): array',
	svn_cat: 'Returns the contents of a file in a repository (string repos_url, [int revision_no]): string',
	svn_checkout: 'Checks out a working copy from the repository (string repos, string targetpath, [int revision, [int flags]]): bool',
	svn_cleanup: 'Recursively cleanup a working copy directory, finishing incomplete operations and removing locks (string workingdir): bool',
	svn_client_version: 'Returns the version of the SVN client libraries (): string',
	svn_commit: 'Sends changes from the local working copy to the repository (string log, array targets, [bool dontrecurse]): array',
	svn_delete: 'Delete items from a working copy or repository. (string path, [bool force]): bool',
	svn_diff: 'Recursively diffs two paths (string path1, int rev1, string path2, int rev2): array',
	svn_export: 'Export the contents of a SVN directory (string frompath, string topath, [bool working_copy]): bool',
	svn_fs_abort_txn: 'Abort a transaction, returns true if everything is okay, false otherwise (resource txn): bool',
	svn_fs_apply_text: 'Creates and returns a stream that will be used to replace (resource root, string path): resource',
	svn_fs_begin_txn2: 'Create a new transaction (resource repos, int rev): resource',
	svn_fs_change_node_prop: 'Return true if everything is ok, false otherwise (resource root, string path, string name, string value): bool',
	svn_fs_check_path: 'Determines what kind of item lives at path in a given repository fsroot (resource fsroot, string path): int',
	svn_fs_contents_changed: 'Return true if content is different, false otherwise (resource root1, string path1, resource root2, string path2): bool',
	svn_fs_copy: 'Copies a file or a directory, returns true if all is ok, false otherwise (resource from_root, string from_path, resource to_root, string to_path): bool',
	svn_fs_delete: 'Deletes a file or a directory, return true if all is ok, false otherwise (resource root, string path): bool',
	svn_fs_dir_entries: 'Enumerates the directory entries under path; returns a hash of dir names to file type (resource fsroot, string path): array',
	svn_fs_file_contents: 'Returns a stream to access the contents of a file from a given version of the fs (resource fsroot, string path): resource',
	svn_fs_file_length: 'Returns the length of a file from a given version of the fs (resource fsroot, string path): int',
	svn_fs_is_dir: 'Return true if the path points to a directory, false otherwise (resource root, string path): bool',
	svn_fs_is_file: 'Return true if the path points to a file, false otherwise (resource root, string path): bool',
	svn_fs_make_dir: 'Creates a new empty directory, returns true if all is ok, false otherwise (resource root, string path): bool',
	svn_fs_make_file: 'Creates a new empty file, returns true if all is ok, false otherwise (resource root, string path): bool',
	svn_fs_node_created_rev: 'Returns the revision in which path under fsroot was created (resource fsroot, string path): int',
	svn_fs_node_prop: 'Returns the value of a property for a node (resource fsroot, string path, string propname): string',
	svn_fs_props_changed: 'Return true if props are different, false otherwise (resource root1, string path1, resource root2, string path2): bool',
	svn_fs_revision_prop: 'Fetches the value of a named property (resource fs, int revnum, string propname): string',
	svn_fs_revision_root: 'Get a handle on a specific version of the repository root (resource fs, int revnum): resource',
	svn_fs_txn_root: 'Creates and returns a transaction root (resource txn): resource',
	svn_fs_youngest_rev: 'Returns the number of the youngest revision in the filesystem (resource fs): int',
	svn_import: 'Imports an unversioned path into a repository (string path, string url, bool nonrecursive): bool',
	svn_log: 'Returns the commit log messages of a repository URL (string repos_url, [int start_revision, [int end_revision, [int limit, [int flags]]]]): array',
	svn_ls: 'Returns list of directory contents in repository URL, optionally at revision number (string repos_url, [int revision_no, [bool recurse]]): array',
	svn_mkdir: 'Creates a directory in a working copy or repository (string path): bool',
	svn_repos_create: 'Create a new subversion repository at path (string path, [array config, [array fsconfig]]): resource',
	svn_repos_fs_begin_txn_for_commit: 'Create a new transaction (resource repos, int rev, string author, string log_msg): resource',
	svn_repos_fs_commit_txn: 'Commits a transaction and returns the new revision (resource txn): int',
	svn_repos_fs: 'Gets a handle on the filesystem for a repository (resource repos): resource',
	svn_repos_hotcopy: 'Make a hot-copy of the repos at repospath; copy it to destpath (string repospath, string destpath, bool cleanlogs): bool',
	svn_repos_open: 'Open a shared lock on a repository. (string path): resource',
	svn_repos_recover: 'Run recovery procedures on the repository located at path. (string path): bool',
	svn_revert: 'Revert changes to the working copy (string path, [bool recursive]): bool',
	svn_status: 'Returns the status of working copy files and directories (string path, [int flags]): array',
	svn_update: 'Update working copy (string path, [int revno, [bool recurse]]): int',
	swf_actiongeturl: 'Get a URL from a Shockwave Flash movie (string url, string target): null',
	swf_actiongotoframe: 'Play a frame and then stop (int framenumber): null',
	swf_actiongotolabel: 'Display a frame with the specified label (string label): null',
	swf_actionnextframe: 'Go forward one frame (): null',
	swf_actionplay: 'Start playing the flash movie from the current frame (): null',
	swf_actionprevframe: 'Go backwards one frame (): null',
	swf_actionsettarget: 'Set the context for actions (string target): null',
	swf_actionstop: 'Stop playing the flash movie at the current frame (): null',
	swf_actiontogglequality: 'Toggle between low and high quality (): null',
	swf_actionwaitforframe: 'Skip actions if a frame has not been loaded (int framenumber, int skipcount): null',
	swf_addbuttonrecord: 'Controls location, appearance and active area of the current button (int states, int shapeid, int depth): null',
	swf_addcolor: 'Set the global add color to the rgba value specified (float r, float g, float b, float a): null',
	swf_closefile: 'Close the current Shockwave Flash file ([int return_file]): null',
	swf_definebitmap: 'Define a bitmap (int objid, string image_name): null',
	swf_definefont: 'Defines a font (int fontid, string fontname): null',
	swf_defineline: 'Define a line (int objid, float x1, float y1, float x2, float y2, float width): null',
	swf_definepoly: 'Define a polygon (int objid, array coords, int npoints, float width): null',
	swf_definerect: 'Define a rectangle (int objid, float x1, float y1, float x2, float y2, float width): null',
	swf_definetext: 'Define a text string (int objid, string str, int docenter): null',
	swf_endbutton: 'End the definition of the current button (): null',
	swf_enddoaction: 'End the current action (): null',
	swf_endshape: 'Completes the definition of the current shape (): null',
	swf_endsymbol: 'End the definition of a symbol (): null',
	swf_fontsize: 'Change the font size (float size): null',
	swf_fontslant: 'Set the font slant (float slant): null',
	swf_fonttracking: 'Set the current font tracking (float tracking): null',
	swf_getbitmapinfo: 'Get information about a bitmap (int bitmapid): array',
	swf_getfontinfo: 'Gets font information (): array',
	swf_getframe: 'Get the frame number of the current frame (): int',
	swf_labelframe: 'Label the current frame (string name): null',
	swf_lookat: 'Define a viewing transformation (float view_x, float view_y, float view_z, float reference_x, float reference_y, float reference_z, float twist): null',
	swf_modifyobject: 'Modify an object (int depth, int how): null',
	swf_mulcolor: 'Sets the global multiply color to the rgba value specified (float r, float g, float b, float a): null',
	swf_nextid: 'Returns the next free object id (): int',
	swf_oncondition: 'Describe a transition used to trigger an action list (int transition): null',
	swf_openfile: 'Open a new Shockwave Flash file (string filename, float width, float height, float framerate, float r, float g, float b): null',
	swf_ortho: 'Defines an orthographic mapping of user coordinates onto the current viewport (float xmin, float xmax, float ymin, float ymax, float zmin, float zmax): null',
	swf_ortho2: 'Defines 2D orthographic mapping of user coordinates onto the current viewport (float xmin, float xmax, float ymin, float ymax): null',
	swf_perspective: 'Define a perspective projection transformation (float fovy, float aspect, float near, float far): null',
	swf_placeobject: 'Place an object onto the screen (int objid, int depth): null',
	swf_polarview: 'Define the viewer\'s position with polar coordinates (float dist, float azimuth, float incidence, float twist): null',
	swf_popmatrix: 'Restore a previous transformation matrix (): null',
	swf_posround: 'Enables or Disables the rounding of the translation when objects are placed or moved (int round): null',
	swf_pushmatrix: 'Push the current transformation matrix back unto the stack (): null',
	swf_removeobject: 'Remove an object (int depth): null',
	swf_rotate: 'Rotate the current transformation (float angle, string axis): null',
	swf_scale: 'Scale the current transformation (float x, float y, float z): null',
	swf_setfont: 'Change the current font (int fontid): null',
	swf_setframe: 'Switch to a specified frame (int framenumber): null',
	swf_shapearc: 'Draw a circular arc (float x, float y, float r, float ang1, float ang2): null',
	swf_shapecurveto: 'Draw a quadratic bezier curve between two points (float x1, float y1, float x2, float y2): null',
	swf_shapecurveto3: 'Draw a cubic bezier curve (float x1, float y1, float x2, float y2, float x3, float y3): null',
	swf_shapefillbitmapclip: 'Set current fill mode to clipped bitmap (int bitmapid): null',
	swf_shapefillbitmaptile: 'Set current fill mode to tiled bitmap (int bitmapid): null',
	swf_shapefilloff: 'Turns off filling (): null',
	swf_shapefillsolid: 'Set the current fill style to the specified color (float r, float g, float b, float a): null',
	swf_shapelinesolid: 'Set the current line style (float r, float g, float b, float a, float width): null',
	swf_shapelineto: 'Draw a line (float x, float y): null',
	swf_shapemoveto: 'Move the current position (float x, float y): null',
	swf_showframe: 'Display the current frame (): null',
	swf_startbutton: 'Start the definition of a button (int objid, int type): null',
	swf_startdoaction: 'Start a description of an action list for the current frame (): null',
	swf_startshape: 'Start a complex shape (int objid): null',
	swf_startsymbol: 'Define a symbol (int objid): null',
	swf_textwidth: 'Get the width of a string (string str): float',
	swf_translate: 'Translate the current transformations (float x, float y, float z): null',
	swf_viewport: 'Select an area for future drawing (float xmin, float xmax, float ymin, float ymax): null',
	sybase_affected_rows: 'Gets number of affected rows in last query ([resource link_identifier]): int',
	sybase_close: 'Closes a Sybase connection ([resource link_identifier]): bool',
	sybase_connect: 'Opens a Sybase server connection ([string servername, [string username, [string password, [string charset, [string appname, [bool new]]]]]]): resource',
	sybase_data_seek: 'Moves internal row pointer (resource result_identifier, int row_number): bool',
	sybase_deadlock_retry_count: 'Sets the deadlock retry count (int retry_count): null',
	sybase_fetch_array: 'Fetch row as array (resource result): array',
	sybase_fetch_assoc: 'Fetch a result row as an associative array (resource result): array',
	sybase_fetch_field: 'Get field information from a result (resource result, [int field_offset]): object',
	sybase_fetch_object: 'Fetch a row as an object (resource result, [mixed object]): object',
	sybase_fetch_row: 'Get a result row as an enumerated array (resource result): array',
	sybase_field_seek: 'Sets field offset (resource result, int field_offset): bool',
	sybase_free_result: 'Frees result memory (resource result): bool',
	sybase_get_last_message: 'Returns the last message from the server (): string',
	sybase_min_client_severity: 'Sets minimum client severity (int severity): null',
	sybase_min_error_severity: 'Sets minimum error severity (int severity): null',
	sybase_min_message_severity: 'Sets minimum message severity (int severity): null',
	sybase_min_server_severity: 'Sets minimum server severity (int severity): null',
	sybase_num_fields: 'Gets the number of fields in a result set (resource result): int',
	sybase_num_rows: 'Get number of rows in a result set (resource result): int',
	sybase_pconnect: 'Open persistent Sybase connection ([string servername, [string username, [string password, [string charset, [string appname]]]]]): resource',
	sybase_query: 'Sends a Sybase query (string query, [resource link_identifier]): mixed',
	sybase_result: 'Get result data (resource result, int row, mixed field): string',
	sybase_select_db: 'Selects a Sybase database (string database_name, [resource link_identifier]): bool',
	sybase_set_message_handler: 'Sets the handler called when a server message is raised (callback handler, [resource connection]): bool',
	sybase_unbuffered_query: 'Send a Sybase query and do not block (string query, resource link_identifier, [bool store_result]): resource',
	tcpwrap_check: 'Performs a tcpwrap check (string daemon, string address, [string user, [bool nodns]]): bool',
	ob_tidyhandler: 'ob_start callback function to repair the buffer (string input, [int mode]): string',
	tidy_access_count: 'Returns the Number of Tidy accessibility warnings encountered for specified document (tidy object): int',
	tidy_config_count: 'Returns the Number of Tidy configuration errors encountered for specified document (tidy object): int',
	tidy_error_count: 'Returns the Number of Tidy errors encountered for specified document (tidy object): int',
	tidy_get_error_buffer: 'Return warnings and errors which occurred parsing the specified document (tidy object): string',
	tidy_get_output: 'Return a string representing the parsed tidy markup (tidy object): string',
	tidy_load_config: 'Load an ASCII Tidy configuration file with the specified encoding (string filename, string encoding): null',
	tidy_reset_config: 'Restore Tidy configuration to default values (): bool',
	tidy_save_config: 'Save current settings to named file (string filename): bool',
	tidy_set_encoding: 'Set the input/output character encoding for parsing markup (string encoding): bool',
	tidy_setopt: 'Updates the configuration settings for the specified tidy document (string option, mixed value): bool',
	tidy_warning_count: 'Returns the Number of Tidy warnings encountered for specified document (tidy object): int',
	tidy_get_body: 'Returns a tidyNode object starting from the <body> tag of the tidy parse tree (tidy object): tidyNode',
	tidy_clean_repair: 'Execute configured cleanup and repair operations on parsed markup (tidy object): bool',
	tidy_diagnose: 'Run configured diagnostics on parsed and repaired markup (tidy object): bool',
	tidy_get_config: 'Get current Tidy configuration (tidy object): array',
	tidy_get_html_ver: 'Get the Detected HTML version for the specified document (tidy object): int',
	tidy_getopt: 'Returns the value of the specified configuration option for the tidy document (tidy object, string option): mixed',
	tidy_get_opt_doc: 'Returns the documentation for the given option name (tidy object, string optname): string',
	tidy_get_release: 'Get release date (version) for Tidy library (): string',
	tidy_get_status: 'Get status of specified document (tidy object): int',
	tidy_get_head: 'Returns a tidyNode object starting from the <head> tag of the tidy parse tree (tidy object): tidyNode',
	tidy_get_html: 'Returns a tidyNode object starting from the <html> tag of the tidy parse tree (tidy object): tidyNode',
	tidy_is_xhtml: 'Indicates if the document is a XHTML document (tidy object): bool',
	tidy_is_xml: 'Indicates if the document is a generic (non HTML/XHTML) XML document (tidy object): bool',
	tidy_parse_file: 'Parse markup in file or URI (string filename, [mixed config, [string encoding, [bool use_include_path]]]): tidy',
	tidy_parse_string: 'Parse a document stored in a string (string input, [mixed config, [string encoding]]): tidy',
	tidy_repair_file: 'Repair a file and return it as a string (string filename, [mixed config, [string encoding, [bool use_include_path]]]): string',
	tidy_repair_string: 'Repair a string using an optionally provided configuration file (string data, [mixed config, [string encoding]]): string',
	tidy_get_root: 'Returns a tidyNode object representing the root of the tidy parse tree (tidy object): tidyNode',
	token_get_all: 'Split given source into PHP tokens (string source): array',
	token_name: 'Get the symbolic name of a given PHP token (int token): string',
	unicode_decode: 'Convert a binary string into a Unicode string (string input, string encoding, [int errmode]): unicode',
	unicode_encode: 'Convert a unicode string in any encoding (unicode input, string encoding, [int errmode]): string',
	unicode_get_error_mode: 'Get the error mode for strings conversions (int direction): int',
	unicode_get_subst_char: 'Get the substitution character for string conversion errors (): unicode',
	unicode_set_error_mode: 'Set the error mode for strings conversions (int direction, int mode): bool',
	unicode_set_subst_char: 'Set the substitution character for string conversion errors (unicode character): bool',
	odbc_autocommit: 'Toggle autocommit behaviour (resource connection_id, [bool OnOff]): mixed',
	odbc_binmode: 'Handling of binary column data (resource result_id, int mode): bool',
	odbc_close_all: 'Close all ODBC connections (): null',
	odbc_close: 'Close an ODBC connection (resource connection_id): null',
	odbc_columnprivileges: 'Lists columns and associated privileges for the given table (resource connection_id, string qualifier, string owner, string table_name, string column_name): resource',
	odbc_columns: 'Lists the column names in specified tables (resource connection_id, [string qualifier, [string schema, [string table_name, [string column_name]]]]): resource',
	odbc_commit: 'Commit an ODBC transaction (resource connection_id): bool',
	odbc_connect: 'Connect to a datasource (string dsn, string user, string password, [int cursor_type]): resource',
	odbc_cursor: 'Get cursorname (resource result_id): string',
	odbc_data_source: 'Returns information about a current connection (resource connection_id, int fetch_type): array',
	odbc_do: 'Alias of odbc_exec',
	odbc_error: 'Get the last error code ([resource connection_id]): string',
	odbc_errormsg: 'Get the last error message ([resource connection_id]): string',
	odbc_exec: 'Prepare and execute a SQL statement (resource connection_id, string query_string, [int flags]): resource',
	odbc_execute: 'Execute a prepared statement (resource result_id, [array parameters_array]): bool',
	odbc_fetch_array: 'Fetch a result row as an associative array (resource result, [int rownumber]): array',
	odbc_fetch_into: 'Fetch one result row into array (resource result_id, array &result_array, [int rownumber]): int',
	odbc_fetch_object: 'Fetch a result row as an object (resource result, [int rownumber]): object',
	odbc_fetch_row: 'Fetch a row (resource result_id, [int row_number]): bool',
	odbc_field_len: 'Get the length (precision) of a field (resource result_id, int field_number): int',
	odbc_field_name: 'Get the columnname (resource result_id, int field_number): string',
	odbc_field_num: 'Return column number (resource result_id, string field_name): int',
	odbc_field_precision: 'Alias of odbc_field_len',
	odbc_field_scale: 'Get the scale of a field (resource result_id, int field_number): int',
	odbc_field_type: 'Datatype of a field (resource result_id, int field_number): string',
	odbc_foreignkeys: 'Retrieves a list of foreign keys (resource connection_id, string pk_qualifier, string pk_owner, string pk_table, string fk_qualifier, string fk_owner, string fk_table): resource',
	odbc_free_result: 'Free resources associated with a result (resource result_id): bool',
	odbc_gettypeinfo: 'Retrieves information about data types supported by the data source (resource connection_id, [int data_type]): resource',
	odbc_longreadlen: 'Handling of LONG columns (resource result_id, int length): bool',
	odbc_next_result: 'Checks if multiple results are available (resource result_id): bool',
	odbc_num_fields: 'Number of columns in a result (resource result_id): int',
	odbc_num_rows: 'Number of rows in a result (resource result_id): int',
	odbc_pconnect: 'Open a persistent database connection (string dsn, string user, string password, [int cursor_type]): resource',
	odbc_prepare: 'Prepares a statement for execution (resource connection_id, string query_string): resource',
	odbc_primarykeys: 'Gets the primary keys for a table (resource connection_id, string qualifier, string owner, string table): resource',
	odbc_procedurecolumns: 'Retrieve information about parameters to procedures (resource connection_id): resource',
	odbc_procedurecolumns: 'Retrieve information about parameters to procedures (resource connection_id, string qualifier, string owner, string proc, string column): resource',
	odbc_procedures: 'Get the list of procedures stored in a specific data source (resource connection_id): resource',
	odbc_procedures: 'Get the list of procedures stored in a specific data source (resource connection_id, string qualifier, string owner, string name): resource',
	odbc_result_all: 'Print result as HTML table (resource result_id, [string format]): int',
	odbc_result: 'Get result data (resource result_id, mixed field): mixed',
	odbc_rollback: 'Rollback a transaction (resource connection_id): bool',
	odbc_setoption: 'Adjust ODBC settings (resource id, int function, int option, int param): bool',
	odbc_specialcolumns: 'Retrieves special columns (resource connection_id, int type, string qualifier, string owner, string table, int scope, int nullable): resource',
	odbc_statistics: 'Retrieve statistics about a table (resource connection_id, string qualifier, string owner, string table_name, int unique, int accuracy): resource',
	odbc_tableprivileges: 'Lists tables and the privileges associated with each table (resource connection_id, string qualifier, string owner, string name): resource',
	odbc_tables: 'Get the list of table names stored in a specific data source (resource connection_id, [string qualifier, [string owner, [string name, [string types]]]]): resource',
	base64_decode: 'Decodes data encoded with MIME base64 (string data, [bool strict]): string',
	base64_encode: 'Encodes data with MIME base64 (string data): string',
	get_headers: 'Fetches all the headers sent by the server in response to a HTTP request (string url, [int format]): array',
	get_meta_tags: 'Extracts all meta tag content attributes from a file and returns an array (string filename, [bool use_include_path]): array',
	http_build_query: 'Generate URL-encoded query string (array formdata, [string numeric_prefix, [string arg_separator]]): string',
	parse_url: 'Parse a URL and return its components (string url, [int component]): mixed',
	rawurldecode: 'Decode URL-encoded strings (string str): string',
	rawurlencode: 'URL-encode according to RFC 1738 (string str): string',
	urldecode: 'Decodes URL-encoded string (string str): string',
	urlencode: 'URL-encodes string (string str): string',
	debug_zval_dump: 'Dumps a string representation of an internal zend value to output (mixed variable): null',
	doubleval: 'Alias of floatval',
	empty: 'Determine whether a variable is empty (mixed var): bool',
	floatval: 'Get float value of a variable (mixed var): float',
	get_defined_vars: 'Returns an array of all defined variables (): array',
	get_resource_type: 'Returns the resource type (resource handle): string',
	gettype: 'Get the type of a variable (mixed var): string',
	import_request_variables: 'Import GET/POST/Cookie variables into the global scope (string types, [string prefix]): bool',
	intval: 'Get the integer value of a variable (mixed var, [int base]): int',
	is_array: 'Finds whether a variable is an array (mixed var): bool',
	is_bool: 'Finds out whether a variable is a boolean (mixed var): bool',
	is_callable: 'Verify that the contents of a variable can be called as a function (callback name, [bool syntax_only, [string &callable_name]]): bool',
	is_double: 'Alias of is_float',
	is_float: 'Finds whether the type of a variable is float (mixed var): bool',
	is_int: 'Find whether the type of a variable is integer (mixed var): bool',
	is_integer: 'Alias of is_int',
	is_long: 'Alias of is_int',
	is_null: 'Finds whether a variable is NULL (mixed var): bool',
	is_numeric: 'Finds whether a variable is a number or a numeric string (mixed var): bool',
	is_object: 'Finds whether a variable is an object (mixed var): bool',
	is_real: 'Alias of is_float',
	is_resource: 'Finds whether a variable is a resource (mixed var): bool',
	is_scalar: 'Finds whether a variable is a scalar (mixed var): bool',
	is_string: 'Find whether the type of a variable is string (mixed var): bool',
	isset: 'Determine if a variable is set and is not NULL (mixed var, [mixed var]): bool',
	print_r: 'Prints human-readable information about a variable (mixed expression, [bool return]): mixed',
	serialize: 'Generates a storable representation of a value (mixed value): string',
	settype: 'Set the type of a variable (mixed &var, string type): bool',
	strval: 'Get string value of a variable (mixed var): string',
	unserialize: 'Creates a PHP value from a stored representation (string str): mixed',
	unset: 'Unset a given variable (mixed var, [mixed var, [mixed ...]]): null',
	var_dump: 'Dumps information about a variable (mixed expression, [mixed expression]): null',
	var_export: 'Outputs or returns a parsable string representation of a variable (mixed expression, [bool return]): mixed',
	vpopmail_add_alias_domain_ex: 'Add alias to an existing virtual domain (string olddomain, string newdomain): bool',
	vpopmail_add_alias_domain: 'Add an alias for a virtual domain (string domain, string aliasdomain): bool',
	vpopmail_add_domain_ex: 'Add a new virtual domain (string domain, string passwd, [string quota, [string bounce, [bool apop]]]): bool',
	vpopmail_add_domain: 'Add a new virtual domain (string domain, string dir, int uid, int gid): bool',
	vpopmail_add_user: 'Add a new user to the specified virtual domain (string user, string domain, string password, [string gecos, [bool apop]]): bool',
	vpopmail_alias_add: 'Insert a virtual alias (string user, string domain, string alias): bool',
	vpopmail_alias_del_domain: 'Deletes all virtual aliases of a domain (string domain): bool',
	vpopmail_alias_del: 'Deletes all virtual aliases of a user (string user, string domain): bool',
	vpopmail_alias_get_all: 'Get all lines of an alias for a domain (string domain): array',
	vpopmail_alias_get: 'Get all lines of an alias for a domain (string alias, string domain): array',
	vpopmail_auth_user: 'Attempt to validate a username/domain/password (string user, string domain, string password, [string apop]): bool',
	vpopmail_del_domain_ex: 'Delete a virtual domain (string domain): bool',
	vpopmail_del_domain: 'Delete a virtual domain (string domain): bool',
	vpopmail_del_user: 'Delete a user from a virtual domain (string user, string domain): bool',
	vpopmail_error: 'Get text message for last vpopmail error (): string',
	vpopmail_passwd: 'Change a virtual user\'s password (string user, string domain, string password, [bool apop]): bool',
	vpopmail_set_user_quota: 'Sets a virtual user\'s quota (string user, string domain, string quota): bool',
	w32api_deftype: 'Defines a type for use with other w32api_functions (string typename, string member1_type, string member1_name, [string ..., [string ...]]): bool',
	w32api_init_dtype: 'Creates an instance of the data type typename and fills it with the values passed (string typename, mixed value, [mixed ...]): resource',
	w32api_invoke_function: 'Invokes function funcname with the arguments passed after the function name (string funcname, mixed argument, [mixed ...]): mixed',
	w32api_register_function: 'Registers function function_name from library with PHP (string library, string function_name, string return_type): bool',
	w32api_set_call_method: 'Sets the calling method used (int method): null',
	wddx_add_vars: 'Add variables to a WDDX packet with the specified ID (resource packet_id, mixed var_name, [mixed ...]): bool',
	wddx_deserialize: 'Alias of wddx_unserialize',
	wddx_packet_end: 'Ends a WDDX packet with the specified ID (resource packet_id): string',
	wddx_packet_start: 'Starts a new WDDX packet with structure inside it ([string comment]): resource',
	wddx_serialize_value: 'Serialize a single value into a WDDX packet (mixed var, [string comment]): string',
	wddx_serialize_vars: 'Serialize variables into a WDDX packet (mixed var_name, [mixed ...]): string',
	wddx_unserialize: 'Unserializes a WDDX packet (string packet): mixed',
	win32_ps_list_procs: 'List running processes (): array',
	win32_ps_stat_mem: 'Stat memory utilization (): array',
	win32_ps_stat_proc: 'Stat process ([int pid]): array',
	win32_create_service: 'Creates a new service entry in the SCM database (array details, [string machine]): mixed',
	win32_delete_service: 'Deletes a service entry from the SCM database (string servicename, [string machine]): int',
	win32_get_last_control_message: 'Returns the last control message that was sent to this service (): int',
	win32_query_service_status: 'Queries the status of a service (string servicename, [string machine]): mixed',
	win32_set_service_status: 'Update the service status (int status): bool',
	win32_start_service_ctrl_dispatcher: 'Registers the script with the SCM, so that it can act as the service with the given name (string name): mixed',
	win32_start_service: 'Starts a service (string servicename, [string machine]): int',
	win32_stop_service: 'Stops a service (string servicename, [string machine]): int',
	wincache_fcache_fileinfo: 'Retrieves information about files cached in the file cache ([bool summaryonly]): array',
	wincache_fcache_meminfo: 'Retrieves information about file cache memory usage (): array',
	wincache_ocache_fileinfo: 'Retrieves information about files cached in the opcode cache ([bool summaryonly]): array',
	wincache_ocache_meminfo: 'Retrieves information about opcode cache memory usage (): array',
	wincache_refresh_if_changed: 'Refreshes the cache entries for the cached files ([array files]): bool',
	wincache_rplist_fileinfo: 'Retrieves information about resolve file path cache (): array',
	wincache_rplist_meminfo: 'Retrieves information about memory usage by the resolve file path cache (): array',
	wincache_scache_info: 'Retrieves information about files cached in the session cache ([bool summaryonly]): array',
	wincache_ucache_add: 'Adds a variable in user cache only if variable does not already exist in the cache (mixed key, mixed value, [int ttl]): bool',
	wincache_ucache_cas: 'Compares the variable with old value and assigns new value to it (string key, long old_value, long new_value): mixed',
	wincache_ucache_clear: 'Deletes entire content of the user cache (): bool',
	wincache_ucache_dec: 'Decrements the value associated with the key (string key, [long dec_by, [bool &success]]): mixed',
	wincache_ucache_delete: 'Deletes variables from the user cache (mixed key): bool',
	wincache_ucache_exists: 'Checks if a variable exists in the user cache (string key): bool',
	wincache_ucache_get: 'Gets a variable stored in the user cache (mixed key, [bool &success]): mixed',
	wincache_ucache_inc: 'Increments the value associated with the key (string key, [long inc_by, [bool &success]]): mixed',
	wincache_ucache_info: 'Retrieves information about data stored in the user cache ([bool summaryonly, [string key]]): array',
	wincache_ucache_set: 'Adds a variable in user cache and overwrites a variable if it already exists in the cache (mixed key, mixed value, [int ttl]): bool',
	wincache_lock: 'Acquires an exclusive lock on a given key (string key, [bool isglobal]): bool',
	wincache_ucache_meminfo: 'Retrieves information about user cache memory usage (): array',
	wincache_unlock: 'Releases an exclusive lock on a given key (string key): bool',
	xattr_get: 'Get an extended attribute (string filename, string name, [int flags]): string',
	xattr_list: 'Get a list of extended attributes (string filename, [int flags]): array',
	xattr_remove: 'Remove an extended attribute (string filename, string name, [int flags]): bool',
	xattr_set: 'Set an extended attribute (string filename, string name, string value, [int flags]): bool',
	xattr_supported: 'Check if filesystem supports extended attributes (string filename, [int flags]): bool',
	xdiff_file_bdiff_size: 'Read a size of file created by applying a binary diff (string file): int',
	xdiff_file_bdiff: 'Make binary diff of two files (string old_file, string new_file, string dest): bool',
	xdiff_file_bpatch: 'Patch a file with a binary diff (string file, string patch, string dest): bool',
	xdiff_file_diff_binary: 'Alias of xdiff_file_bdiff (string old_file, string new_file, string dest): bool',
	xdiff_file_diff: 'Make unified diff of two files (string old_file, string new_file, string dest, [int context, [bool minimal]]): bool',
	xdiff_file_merge3: 'Merge 3 files into one (string old_file, string new_file1, string new_file2, string dest): mixed',
	xdiff_file_patch_binary: 'Alias of xdiff_file_bpatch (string file, string patch, string dest): bool',
	xdiff_file_patch: 'Patch a file with an unified diff (string file, string patch, string dest, [int flags]): mixed',
	xdiff_file_rabdiff: 'Make binary diff of two files using the Rabin\'s polynomial fingerprinting algorithm (string old_file, string new_file, string dest): bool',
	xdiff_string_bdiff_size: 'Read a size of file created by applying a binary diff (string patch): int',
	xdiff_string_bdiff: 'Make binary diff of two strings (string old_data, string new_data): string',
	xdiff_string_bpatch: 'Patch a string with a binary diff (string str, string patch): string',
	xdiff_string_bdiff: 'Alias of xdiff_string_bdiff (string old_data, string new_data): string',
	xdiff_string_diff: 'Make unified diff of two strings (string old_data, string new_data, [int context, [bool minimal]]): string',
	xdiff_string_merge3: 'Merge 3 strings into one (string old_data, string new_data1, string new_data2, [string &error]): mixed',
	xdiff_string_patch_binary: 'Alias of xdiff_string_bpatch (string str, string patch): string',
	xdiff_string_patch: 'Patch a string with an unified diff (string str, string patch, [int flags, [string &error]]): string',
	xdiff_string_bdiff: 'Make binary diff of two strings using the Rabin\'s polynomial fingerprinting algorithm (string old_data, string new_data): string',
	utf8_decode: 'Converts a string with ISO-8859-1 characters encoded with UTF-8 to single-byte ISO-8859-1 (string data): string',
	utf8_encode: 'Encodes an ISO-8859-1 string to UTF-8 (string data): string',
	xml_error_string: 'Get XML parser error string (int code): string',
	xml_get_current_byte_index: 'Get current byte index for an XML parser (resource parser): int',
	xml_get_current_column_number: 'Get current column number for an XML parser (resource parser): int',
	xml_get_current_line_number: 'Get current line number for an XML parser (resource parser): int',
	xml_get_error_code: 'Get XML parser error code (resource parser): int',
	xml_parse_into_struct: 'Parse XML data into an array structure (resource parser, string data, array &values, [array &index]): int',
	xml_parse: 'Start parsing an XML document (resource parser, string data, [bool is_final]): int',
	xml_parser_create_ns: 'Create an XML parser with namespace support ([string encoding, [string separator]]): resource',
	xml_parser_create: 'Create an XML parser ([string encoding]): resource',
	xml_parser_free: 'Free an XML parser (resource parser): bool',
	xml_parser_get_option: 'Get options from an XML parser (resource parser, int option): mixed',
	xml_parser_set_option: 'Set options in an XML parser (resource parser, int option, mixed value): bool',
	xml_set_character_data_handler: 'Set up character data handler (resource parser, callback handler): bool',
	xml_set_default_handler: 'Set up default handler (resource parser, callback handler): bool',
	xml_set_element_handler: 'Set up start and end element handlers (resource parser, callback start_element_handler, callback end_element_handler): bool',
	xml_set_end_namespace_decl_handler: 'Set up end namespace declaration handler (resource parser, callback handler): bool',
	xml_set_external_entity_ref_handler: 'Set up external entity reference handler (resource parser, callback handler): bool',
	xml_set_notation_decl_handler: 'Set up notation declaration handler (resource parser, callback handler): bool',
	xml_set_object: 'Use XML Parser within an object (resource parser, object &object): bool',
	xml_set_processing_instruction_handler: 'Set up processing instruction (PI) handler (resource parser, callback handler): bool',
	xml_set_start_namespace_decl_handler: 'Set up start namespace declaration handler (resource parser, callback handler): bool',
	xml_set_unparsed_entity_decl_handler: 'Set up unparsed entity declaration handler (resource parser, callback handler): bool',
	xmlrpc_decode_request: 'Decodes XML into native PHP types (string xml, string &method, [string encoding]): mixed',
	xmlrpc_decode: 'Decodes XML into native PHP types (string xml, [string encoding]): mixed',
	xmlrpc_encode_request: 'Generates XML for a method request (string method, mixed params, [array output_options]): string',
	xmlrpc_encode: 'Generates XML for a PHP value (mixed value): string',
	xmlrpc_get_type: 'Gets xmlrpc type for a PHP value (mixed value): string',
	xmlrpc_is_fault: 'Determines if an array value represents an XMLRPC fault (array arg): bool',
	xmlrpc_parse_method_descriptions: 'Decodes XML into a list of method descriptions (string xml): array',
	xmlrpc_server_add_introspection_data: 'Adds introspection documentation (resource server, array desc): int',
	xmlrpc_server_call_method: 'Parses XML requests and call methods (resource server, string xml, mixed user_data, [array output_options]): string',
	xmlrpc_server_create: 'Creates an xmlrpc server (): resource',
	xmlrpc_server_destroy: 'Destroys server resources (resource server): int',
	xmlrpc_server_register_introspection_callback: 'Register a PHP function to generate documentation (resource server, string function): bool',
	xmlrpc_server_register_method: 'Register a PHP function to resource method matching method_name (resource server, string method_name, string function): bool',
	xmlrpc_set_type: 'Sets xmlrpc type, base64 or datetime, for a PHP string value (string &value, string type): bool',
	xmlwriter_end_attribute: 'End attribute (resource xmlwriter): bool',
	xmlwriter_end_cdata: 'End current CDATA (resource xmlwriter): bool',
	xmlwriter_end_comment: 'Create end comment (resource xmlwriter): bool',
	xmlwriter_end_document: 'End current document (resource xmlwriter): bool',
	xmlwriter_end_dtd_attlist: 'End current DTD AttList (resource xmlwriter): bool',
	xmlwriter_end_dtd_element: 'End current DTD element (resource xmlwriter): bool',
	xmlwriter_end_dtd_entity: 'End current DTD Entity (resource xmlwriter): bool',
	xmlwriter_end_dtd: 'End current DTD (resource xmlwriter): bool',
	xmlwriter_end_element: 'End current element (resource xmlwriter): bool',
	xmlwriter_end_pi: 'End current PI (resource xmlwriter): bool',
	xmlwriter_flush: 'Flush current buffer (resource xmlwriter, [bool empty]): mixed',
	xmlwriter_full_end_element: 'End current element (resource xmlwriter): bool',
	xmlwriter_open_memory: 'Create new xmlwriter using memory for string output (): resource',
	xmlwriter_open_uri: 'Create new xmlwriter using source uri for output (string uri): resource',
	xmlwriter_output_memory: 'Returns current buffer (resource xmlwriter, [bool flush]): string',
	xmlwriter_set_indent_string: 'Set string used for indenting (resource xmlwriter, string indentString): bool',
	xmlwriter_set_indent: 'Toggle indentation on/off (resource xmlwriter, bool indent): bool',
	xmlwriter_start_attribute_ns: 'Create start namespaced attribute (resource xmlwriter, string prefix, string name, string uri): bool',
	xmlwriter_start_attribute: 'Create start attribute (resource xmlwriter, string name): bool',
	xmlwriter_start_cdata: 'Create start CDATA tag (resource xmlwriter): bool',
	xmlwriter_start_comment: 'Create start comment (resource xmlwriter): bool',
	xmlwriter_start_document: 'Create document tag (resource xmlwriter, [string version, [string encoding, [string standalone]]]): bool',
	xmlwriter_start_dtd_attlist: 'Create start DTD AttList (resource xmlwriter, string name): bool',
	xmlwriter_start_dtd_element: 'Create start DTD element (resource xmlwriter, string qualifiedName): bool',
	xmlwriter_start_dtd_entity: 'Create start DTD Entity (resource xmlwriter, string name, bool isparam): bool',
	xmlwriter_start_dtd: 'Create start DTD tag (resource xmlwriter, string qualifiedName, [string publicId, [string systemId]]): bool',
	xmlwriter_start_element_ns: 'Create start namespaced element tag (resource xmlwriter, string prefix, string name, string uri): bool',
	xmlwriter_start_element: 'Create start element tag (resource xmlwriter, string name): bool',
	xmlwriter_start_pi: 'Create start PI tag (resource xmlwriter, string target): bool',
	xmlwriter_text: 'Write text (resource xmlwriter, string content): bool',
	xmlwriter_write_attribute_ns: 'Write full namespaced attribute (resource xmlwriter, string prefix, string name, string uri, string content): bool',
	xmlwriter_write_attribute: 'Write full attribute (resource xmlwriter, string name, string value): bool',
	xmlwriter_write_cdata: 'Write full CDATA tag (resource xmlwriter, string content): bool',
	xmlwriter_write_comment: 'Write full comment tag (resource xmlwriter, string content): bool',
	xmlwriter_write_dtd_attlist: 'Write full DTD AttList tag (resource xmlwriter, string name, string content): bool',
	xmlwriter_write_dtd_element: 'Write full DTD element tag (resource xmlwriter, string name, string content): bool',
	xmlwriter_write_dtd_entity: 'Write full DTD Entity tag (resource xmlwriter, string name, string content, bool pe, string pubid, string sysid, string ndataid): bool',
	xmlwriter_write_dtd: 'Write full DTD tag (resource xmlwriter, string name, [string publicId, [string systemId, [string subset]]]): bool',
	xmlwriter_write_element_ns: 'Write full namespaced element tag (resource xmlwriter, string prefix, string name, string uri, [string content]): bool',
	xmlwriter_write_element: 'Write full element tag (resource xmlwriter, string name, [string content]): bool',
	xmlwriter_write_pi: 'Writes a PI (resource xmlwriter, string target, string content): bool',
	xmlwriter_write_raw: 'Write a raw XML text (resource xmlwriter, string content): bool',
	xslt_backend_info: 'Returns the information on the compilation settings of the backend (): string',
	xslt_backend_name: 'Returns the name of the backend (): string',
	xslt_backend_version: 'Returns the version number of Sablotron (): string',
	xslt_create: 'Create a new XSLT processor (): resource',
	xslt_errno: 'Returns an error number (resource xh): int',
	xslt_error: 'Returns an error string (resource xh): string',
	xslt_free: 'Free XSLT processor (resource xh): null',
	xslt_getopt: 'Get options on a given xsl processor (resource processor): int',
	xslt_process: 'Perform an XSLT transformation (resource xh, string xmlcontainer, string xslcontainer, [string resultcontainer, [array arguments, [array parameters]]]): mixed',
	xslt_set_base: 'Set the base URI for all XSLT transformations (resource xh, string uri): null',
	xslt_set_encoding: 'Set the encoding for the parsing of XML documents (resource xh, string encoding): null',
	xslt_set_error_handler: 'Set an error handler for a XSLT processor (resource xh, mixed handler): null',
	xslt_set_log: 'Set the log file to write log messages to (resource xh, [mixed log]): null',
	xslt_set_object: 'Sets the object in which to resolve callback functions (resource processor, object &obj): bool',
	xslt_set_sax_handler: 'Set SAX handlers for a XSLT processor (resource xh, array handlers): null',
	xslt_set_sax_handlers: 'Set the SAX handlers to be called when the XML document gets processed (resource processor, array handlers): null',
	xslt_set_scheme_handler: 'Set Scheme handlers for a XSLT processor (resource xh, array handlers): null',
	xslt_set_scheme_handlers: 'Set the scheme handlers for the XSLT processor (resource xh, array handlers): null',
	xslt_setopt: 'Set options on a given xsl processor (resource processor, int newmask): mixed',
	yaml_emit_file: 'Send the YAML representation of a value to a file (string filename, mixed data, [int encoding, [int linebreak]]): bool',
	yaml_emit: 'Returns the YAML representation of a value (mixed data, [int encoding, [int linebreak]]): string',
	yaml_parse_file: 'Parse a YAML stream from a file (string filename, [int pos, [int &ndocs, [array callbacks]]]): mixed',
	yaml_parse_url: 'Parse a Yaml stream from a URL (string url, [int pos, [int &ndocs, [array callbacks]]]): mixed',
	yaml_parse: 'Parse a YAML stream (string input, [int pos, [int &ndocs, [array callbacks]]]): mixed',
	yaz_addinfo: 'Returns additional error information (resource id): string',
	yaz_ccl_conf: 'Configure CCL parser (resource id, array config): null',
	yaz_ccl_parse: 'Invoke CCL Parser (resource id, string query, array &result): bool',
	yaz_close: 'Close YAZ connection (resource id): bool',
	yaz_connect: 'Prepares for a connection to a Z39.50 server (string zurl, [mixed options]): mixed',
	yaz_database: 'Specifies the databases within a session (resource id, string databases): bool',
	yaz_element: 'Specifies Element-Set Name for retrieval (resource id, string elementset): bool',
	yaz_errno: 'Returns error number (resource id): int',
	yaz_error: 'Returns error description (resource id): string',
	yaz_es_result: 'Inspects Extended Services Result (resource id): array',
	yaz_es: 'Prepares for an Extended Service Request (resource id, string type, array args): null',
	yaz_get_option: 'Returns value of option for connection (resource id, string name): string',
	yaz_hits: 'Returns number of hits for last search (resource id, [array &searchresult]): int',
	yaz_itemorder: 'Prepares for Z39.50 Item Order with an ILL-Request package (resource id, array args): null',
	yaz_present: 'Prepares for retrieval (Z39.50 present) (resource id): bool',
	yaz_range: 'Specifies a range of records to retrieve (resource id, int start, int number): null',
	yaz_record: 'Returns a record (resource id, int pos, string type): string',
	yaz_scan_result: 'Returns Scan Response result (resource id, [array &result]): array',
	yaz_scan: 'Prepares for a scan (resource id, string type, string startterm, [array flags]): null',
	yaz_schema: 'Specifies schema for retrieval (resource id, string schema): null',
	yaz_search: 'Prepares for a search (resource id, string type, string query): bool',
	yaz_set_option: 'Sets one or more options for connection (resource id, string name, string value): null',
	yaz_set_option: 'Sets one or more options for connection (resource id, array options): null',
	yaz_sort: 'Sets sorting criteria (resource id, string criteria): null',
	yaz_syntax: 'Specifies the preferred record syntax for retrieval (resource id, string syntax): null',
	yaz_wait: 'Wait for Z39.50 requests to complete ([array &options]): mixed',
	zip_close: 'Close a ZIP file archive (resource zip): null',
	zip_entry_close: 'Close a directory entry (resource zip_entry): bool',
	zip_entry_compressedsize: 'Retrieve the compressed size of a directory entry (resource zip_entry): int',
	zip_entry_compressionmethod: 'Retrieve the compression method of a directory entry (resource zip_entry): string',
	zip_entry_filesize: 'Retrieve the actual file size of a directory entry (resource zip_entry): int',
	zip_entry_name: 'Retrieve the name of a directory entry (resource zip_entry): string',
	zip_entry_open: 'Open a directory entry for reading (resource zip, resource zip_entry, [string mode]): bool',
	zip_entry_read: 'Read from an open directory entry (resource zip_entry, [int length]): string',
	zip_open: 'Open a ZIP file archive (string filename): mixed',
	zip_read: 'Read next entry in a ZIP file archive (resource zip): mixed',
	gzclose: 'Close an open gz-file pointer (resource zp): bool',
	gzcompress: 'Compress a string (string data, [int level]): string',
	gzdecode: 'Decodes a gzip compressed string (string data, [int length]): string',
	gzdeflate: 'Deflate a string (string data, [int level]): string',
	gzencode: 'Create a gzip compressed string (string data, [int level, [int encoding_mode]]): string',
	gzeof: 'Test for EOF on a gz-file pointer (resource zp): int',
	gzfile: 'Read entire gz-file into an array (string filename, [int use_include_path]): array',
	gzgetc: 'Get character from gz-file pointer (resource zp): string',
	gzgets: 'Get line from file pointer (resource zp, int length): string',
	gzgetss: 'Get line from gz-file pointer and strip HTML tags (resource zp, int length, [string allowable_tags]): string',
	gzinflate: 'Inflate a deflated string (string data, [int length]): string',
	gzopen: 'Open gz-file (string filename, string mode, [int use_include_path]): resource',
	gzpassthru: 'Output all remaining data on a gz-file pointer (resource zp): int',
	gzputs: 'Alias of gzwrite',
	gzread: 'Binary-safe gz-file read (resource zp, int length): string',
	gzrewind: 'Rewind the position of a gz-file pointer (resource zp): bool',
	gzseek: 'Seek on a gz-file pointer (resource zp, int offset, [int whence]): int',
	gztell: 'Tell gz-file pointer read/write position (resource zp): int',
	gzuncompress: 'Uncompress a compressed string (string data, [int length]): string',
	gzwrite: 'Binary-safe gz-file write (resource zp, string string, [int length]): int',
	readgzfile: 'Output a gz-file (string filename, [int use_include_path]): int',
	zlib_get_coding_type: 'Returns the coding type used for output compression (): string'
};

jush.api.php_fun = {
	__autoload: 'Attempt to load undefined class (string class_name): null',
	__construct: 'Object constructor ([mixed ...]): null',
	__destruct: 'Object destructor (): null',
	__call: 'Triggered when invoking inaccessible methods in an object context (string name, array arguments): mixed',
	__callstatic: 'Triggered when invoking inaccessible methods in a static context (string name, array arguments): mixed',
	__get: 'Utilized for reading data from inaccessible properties (string name): mixed',
	__set: 'Run when writing data to inaccessible properties (string name, mixed value): null',
	__isset: 'Triggered by calling isset() or empty()  on inaccessible properties (string name): bool',
	__unset: 'Invoked when unset() is used on inaccessible properties (string name): null',
	__sleep: 'Called by serialize() (): array',
	__wakeup: 'Called by unserialize() (): null',
	__tostring: 'Decide how to react when object is converted to a string (): string',
	__invoke: 'Called when a script tries to call an object as a function ([mixed ...]): mixed',
	__set_state: 'Called by var_export() result (array properties): object',
	__clone: 'Called after cloning (): null'
};

jush.api.php_new = {
	dateinterval: 'Creates new DateInterval object (string interval_spec)',
	dateperiod: 'Creates new DatePeriod object (DateTime start, DateInterval interval, int recurrences, [int options])',
	dateperiod: 'Creates new DatePeriod object (DateTime start, DateInterval interval, DateTime end, [int options])',
	dateperiod: 'Creates new DatePeriod object (string isostr, [int options])',
	datetime: 'Returns new DateTime object ([string time, [DateTimeZone timezone]])',
	datetimezone: 'Creates new DateTimeZone object (string timezone)',
	datetimezone: 'Returns new DateTimeZone object (string timezone)',
	domattr: 'Creates a new DOMAttr object (string name, [string value])',
	domcomment: 'Creates a new DOMComment object ([string value])',
	domdocument: 'Creates a new DOMDocument object ([string version, [string encoding]])',
	domelement: 'Creates a new DOMElement object (string name, [string value, [string namespaceURI]])',
	domentityreference: 'Creates a new DOMEntityReference object (string name)',
	domimplementation: 'Creates a new DOMImplementation object ()',
	domprocessinginstruction: 'Creates a new DOMProcessingInstruction object (string name, [string value])',
	domtext: 'Creates a new DOMText object ([string value])',
	domxpath: 'Creates a new DOMXPath object (DOMDocument doc)',
	finfo: 'Create a new fileinfo resource ([int options, [string magic_file]])',
	gmagick: 'The Gmagick constructor ([string filename])',
	gmagickpixel: 'The GmagickPixel constructor ([string color])',
	harudoc: 'Construct new HaruDoc instance ()',
	httpdeflatestream: 'HttpDeflateStream class constructor ([int flags])',
	httpinflatestream: 'HttpInflateStream class constructor ([int flags])',
	httpmessage: 'HttpMessage constructor ([string message])',
	httpquerystring: 'HttpQueryString constructor ([bool global, [mixed add]])',
	httprequest: 'HttpRequest constructor ([string url, [int request_method, [array options]]])',
	httprequestpool: 'HttpRequestPool constructor ([HttpRequest request])',
	imagick: 'The Imagick constructor ([mixed files])',
	imagickdraw: 'The ImagickDraw constructor ()',
	imagickpixel: 'The ImagickPixel constructor ([string color])',
	imagickpixeliterator: 'The ImagickPixelIterator constructor (Imagick wand)',
	collator: 'Create a collator (string locale)',
	intldateformatter: 'Create a date formatter (string locale, int datetype, int timetype, [string timezone, [int calendar, [string pattern]]])',
	messageformatter: 'Constructs a new Message Formatter (string locale, string pattern)',
	numberformatter: 'Create a number formatter (string locale, int style, [string pattern])',
	ktaglib_mpeg_file: 'Opens a new file (string filename)',
	maxdb: 'Open a new connection to the MaxDB server ([string host, [string username, [string passwd, [string dbname, [int port, [string socket]]]]]])',
	memcached: 'Create a Memcached instance ([string persistent_id])',
	swfaction: 'Creates a new SWFAction (string script)',
	swfbitmap: 'Loads Bitmap object (mixed file, [mixed alphafile])',
	swfbutton: 'Creates a new Button ()',
	swffont: 'Loads a font definition (string filename)',
	swfgradient: 'Creates a gradient object ()',
	swfmorph: 'Creates a new SWFMorph object ()',
	swfmovie: 'Creates a new movie object, representing an SWF version 4 movie ([int version])',
	swfprebuiltclip: 'Returns a SWFPrebuiltClip object (mixed file)',
	swfshape: 'Creates a new shape object ()',
	swfsound: 'Returns a new SWFSound object from given file (string filename, [int flags])',
	swfsprite: 'Creates a movie clip (): a sprite',
	swftext: 'Creates a new SWFText object ()',
	swftextfield: 'Creates a text field object ([int flags])',
	swfvideostream: 'Returns a SWFVideoStream object ([string file])',
	mongo: 'Creates a new database connection object ([string server, [boolean connect, [boolean persistent, [boolean paired]]]])',
	mongobindata: 'Creates a new binary data object. (string data, [int type])',
	mongocode: 'Creates a new code object (string code, [array scope])',
	mongocollection: 'Creates a new collection (MongoDB db, string name)',
	mongocursor: 'Create a new cursor (resource connection, string ns, [array query, [array fields]])',
	mongodate: 'Creates a new date. ([long sec, [long usec]])',
	mongodb: 'Creates a new database (Mongo conn, string name)',
	mongogridfs: 'Creates new file collections (MongoDB db, [string files, [string chunks]])',
	mongogridfscursor: 'Create a new cursor (MongoGridFS gridfs, resource connection, string ns, [array query, [array fields]])',
	mongogridfsfile: 'Create a new GridFS file (MongoGridFS gridfs, array file)',
	mongoid: 'Creates a new id ([string id])',
	mongoregex: 'Creates a new regular expression (string regex)',
	mysqli: 'Open a new connection to the MySQL server ([string host, [string username, [string passwd, [string dbname, [int port, [string socket]]]]]])',
	oauth: 'Create a new OAuth object (string consumer_key, string consumer_secret, [string signature_method, [string auth_type]])',
	pdo: 'Creates a PDO instance representing a connection to a database (string dsn, [string username, [string password, [array driver_options]]])',
	phar: 'Construct a Phar archive object (string fname, [int flags, [string alias]])',
	phardata: 'Construct a non-executable tar or zip archive object (string fname, [int flags])',
	pharfileinfo: 'Construct a Phar entry object (string entry)',
	reflectionclass: 'Constructs a ReflectionClass (string argument)',
	reflectionextension: 'Constructs a ReflectionExtension (string name)',
	reflectionfunction: 'Constructs a ReflectionFunction object (string name)',
	reflectionmethod: 'Constructs a ReflectionMethod (string class_or_method, [string name])',
	reflectionobject: 'Constructs a ReflectionObject (string argument)',
	reflectionparameter: 'Construct (string function, string parameter)',
	reflectionproperty: 'Construct a ReflectionProperty object (mixed class, string name)',
	samconnection: 'Creates a new connection to a Messaging Server ()',
	sammessage: 'Creates a new Message object ([mixed body])',
	sdo_model_reflectiondataobject: 'Construct an SDO_Model_ReflectionDataObject (SDO_DataObject data_object)',
	sdo_das_relational: 'Creates an instance of a Relational Data Access Service (array database_metadata, [string application_root_type, [array SDO_containment_references_metadata]])',
	simplexmlelement: 'Creates a new SimpleXMLElement object (string data, [int options, [bool data_is_url, [string ns, [bool is_prefix]]]])',
	soapclient: 'SoapClient constructor (mixed wsdl, [array options])',
	soapclient: 'SoapClient constructor (mixed wsdl, [array options])',
	soapfault: 'SoapFault constructor (string faultcode, string faultstring, [string faultactor, [string detail, [string faultname, [string headerfault]]]])',
	soapfault: 'SoapFault constructor (string faultcode, string faultstring, [string faultactor, [string detail, [string faultname, [string headerfault]]]])',
	soapheader: 'SoapHeader constructor (string namespace, string name, [mixed data, [bool mustunderstand, [string actor]]])',
	soapheader: 'SoapHeader constructor (string namespace, string name, [mixed data, [bool mustunderstand, [string actor]]])',
	soapparam: 'SoapParam constructor (mixed data, string name)',
	soapparam: 'SoapParam constructor (mixed data, string name)',
	soapserver: 'SoapServer constructor (mixed wsdl, [array options])',
	soapserver: 'SoapServer constructor (mixed wsdl, [array options])',
	soapvar: 'SoapVar constructor (string data, string encoding, [string type_name, [string type_namespace, [string node_name, [string node_namespace]]]])',
	soapvar: 'SoapVar constructor (string data, string encoding, [string type_name, [string type_namespace, [string node_name, [string node_namespace]]]])',
	sphinxclient: 'Create a new SphinxClient object ()',
	appenditerator: 'Constructs an AppendIterator ()',
	arrayobject: 'Construct a new array object ([mixed input, [int flags, [string iterator_class]]])',
	cachingiterator: 'Construct a new CachingIterator object for the iterator. (Iterator iterator, [string flags])',
	directoryiterator: 'Constructs a new directory iterator from a path (string path)',
	filesystemiterator: 'Constructs a new filesystem iterator (string path, [int flags])',
	globiterator: 'Construct a directory using glob (string path, [integer flags])',
	infiniteiterator: 'Constructs an infiniteIterator (Iterator iterator)',
	iteratoriterator: 'Create an iterator from anything that is traversable (Traversable iterator)',
	multipleiterator: 'Constructs a new MultipleIterator (integer flags)',
	recursivefilteriterator: 'Create a RecursiveFilterIterator from a RecursiveIterator (RecursiveIterator iterator)',
	recursiveregexiterator: 'Creates a new RecursiveRegexIterator. (RecursiveIterator iterator, string regex, [int mode, [int flags, [int preg_flags]]])',
	regexiterator: 'Creates a new RegexIterator. (Iterator iterator, string regex, [int mode, [int flags, [int preg_flags]]])',
	spldoublylinkedlist: 'Constructs a new doubly linked list ()',
	splfileinfo: 'Construct a new SplFileInfo object (string file_name)',
	splfileobject: 'Construct a new file object. (string filename, [string open_mode, [bool use_include_path, [resource context]]])',
	splfixedarray: 'Constructs a new fixed array (int size)',
	splheap: 'Constructs a new empty heap ()',
	splpriorityqueue: 'Constructs a new empty queue ()',
	splqueue: 'Constructs a new queue implemented using a doubly linked list ()',
	splstack: 'Constructs a new stack implemented using a doubly linked list ()',
	spltempfileobject: 'Construct a new temporary file object ([integer max_memory])',
	splbool: 'Constructs a bool object type ()',
	splenum: 'Constructs an enumeger object type ()',
	splfloat: 'Constructs a float object type (float input)',
	splint: 'Constructs an integer object type (integer input)',
	splstring: 'Constructs a string object type (string input)',
	sqlitedatabase: 'Opens a SQLite database and create the database if it does not exist (string filename, [int mode, [string &error_message]])',
	sqlite3: 'Instantiates an SQLite3 object and opens an SQLite 3 database (string filename, [int flags, [string encryption_key]])',
	streamwrapper: 'Constructs a new stream wrapper ()',
	swish: 'Construct a Swish object (string index_names)',
	tidy: 'Constructs a new tidy object ([string filename, [mixed config, [string encoding, [bool use_include_path]]]])',
	tokyotyrant: 'Construct a new TokyoTyrant object ([string host, [string port, [string persistent]]])',
	tokyotyrantquery: 'Construct a new query (TokyoTyrantTable table)',
	xsltprocessor: 'Creates a new XSLTProcessor object ()',
	exception: 'Construct the exception ([string message, [int code, [Exception previous]]])'
};
