/* ----- encode/953x6343, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_953x6343_checksums[] = {
  "48d66a44f8ff7a1467ce2d060028f1e50fdb82270a4e07c91afc8982c4d6229c",
  "f7cff68a1aeda002a4c4af92e4d33284bb29ab2344d097357b23522a14ebb07e",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_953x6343_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_953x6343_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_953x6343_ITEMBYTES

static void *storage_encode_953x6343_s;
static unsigned char *test_encode_953x6343_s;
static void *storage_encode_953x6343_x;
static unsigned char *test_encode_953x6343_x;
static void *storage_encode_953x6343_s2;
static unsigned char *test_encode_953x6343_s2;
static void *storage_encode_953x6343_x2;
static unsigned char *test_encode_953x6343_x2;

#define precomputed_encode_953x6343_NUM 4

static const unsigned char precomputed_encode_953x6343_s[precomputed_encode_953x6343_NUM][crypto_encode_STRBYTES] = {
  {152,148,82,17,45,178,188,116,204,130,236,9,13,29,28,138,118,6,154,219,14,50,127,25,233,247,39,9,63,47,156,40,221,218,182,17,144,239,228,126,3,42,216,29,5,154,228,238,12,17,187,11,157,35,191,16,94,119,162,114,204,194,8,118,45,17,251,26,107,205,243,15,19,168,211,153,111,25,136,168,168,245,230,20,81,159,131,130,63,185,161,140,35,28,116,214,243,70,158,239,130,214,226,127,9,33,52,92,92,52,118,14,249,207,149,57,5,84,26,210,84,180,142,58,7,58,210,164,14,219,140,253,211,200,139,222,173,48,51,96,109,168,197,240,75,194,70,184,80,154,112,240,210,245,197,101,167,180,180,54,152,51,32,192,1,2,95,38,9,72,254,191,160,130,8,240,201,171,207,164,243,229,68,150,149,209,84,144,227,13,235,133,114,22,120,194,87,202,42,82,248,166,20,122,221,96,95,131,143,27,79,65,24,62,190,150,228,55,167,79,247,217,235,233,244,88,151,75,248,75,185,161,210,187,171,83,178,11,181,117,235,21,122,107,163,13,65,198,223,114,231,178,63,6,166,253,37,165,112,155,161,74,237,231,114,225,205,212,157,0,91,108,91,254,168,107,139,26,68,227,59,228,248,79,136,189,72,9,83,55,169,78,151,215,204,39,199,137,196,29,26,18,239,71,243,84,99,56,161,246,150,24,38,105,170,174,148,77,78,236,250,9,192,237,31,88,129,214,35,170,83,166,106,218,222,193,78,144,27,213,32,94,99,5,130,168,173,97,121,199,27,135,165,24,223,103,33,197,84,143,143,130,194,39,9,174,245,126,36,167,229,3,84,144,135,187,209,224,59,47,142,112,108,63,121,12,147,233,207,196,145,161,50,166,154,49,113,212,152,69,242,187,105,49,227,40,88,185,105,29,24,3,118,242,127,228,213,111,47,90,109,25,23,72,99,236,111,28,38,188,134,29,236,114,69,155,219,250,88,146,175,147,124,145,194,90,72,137,233,97,174,30,137,92,169,119,168,150,70,230,208,249,154,252,213,93,227,192,193,176,234,133,63,179,115,41,7,228,209,209,171,247,253,243,81,239,210,190,104,46,46,82,79,107,19,113,129,187,37,224,117,13,110,226,117,226,105,208,92,154,8,170,233,226,3,141,5,85,33,131,37,240,126,241,175,21,248,14,133,87,227,244,115,78,6,125,35,245,206,5,78,9,247,68,4,178,168,9,246,143,212,193,32,60,42,171,12,54,45,137,179,234,151,75,141,228,151,203,59,97,243,157,76,140,23,25,28,248,186,46,59,91,16,147,186,49,86,71,111,238,21,40,3,217,95,236,196,105,10,163,251,213,170,171,22,93,228,170,85,231,235,1,251,181,137,124,165,227,64,73,21,224,108,216,91,2,71,111,202,124,7,94,45,244,22,99,2,22,44,18,54,43,112,137,237,102,6,59,30,153,186,198,105,171,34,187,53,236,212,17,99,10,224,30,61,123,117,125,33,230,95,96,155,75,20,209,144,48,128,184,96,32,221,214,192,213,195,236,136,183,91,26,148,81,23,45,131,9,235,4,159,185,97,168,53,145,72,217,52,15,181,185,83,28,40,15,83,29,169,89,162,199,49,132,220,73,232,3,112,209,124,43,177,10,69,133,184,132,115,170,217,128,75,199,124,59,46,223,3,70,164,116,114,32,173,46,151,255,218,37,193,200,208,65,83,29,65,45,135,28,199,80,176,178,41,12,237,100,147,55,84,12,199,122,160,152,45,244,119,158,40,219,164,2,221,21,101,39,118,88,212,20,227,239,61,4,17,11,150,118,90,36,214,124,51,172,6,75,150,62,201,52,133,254,172,140,192,61,191,69,56,57,227,249,163,81,151,188,82,224,71,69,71,71,184,4,87,183,193,164,252,134,223,65,189,137,160,91,85,10,40,119,178,43,210,86,24,196,50,174,21,83,82,25,49,39,253,141,27,39,92,168,189,107,18,188,38,14,115,231,215,72,112,111,188,112,176,31,237,220,233,26,198,195,170,79,1,154,179,214,219,98,177,92,214,21,123,3,23,226,117,186,165,195,244,183,49,128,50,22,128,100,79,63,251,143,107,95,223,119,32,43,171,232,182,157,23,176,132,118,83,136,173,1,56,43,151,216,49,200,60,82,163,140,21,235,122,152,46,135,218,81,117,215,144,129,200,86,187,185,21,200,128,184,114,204,187,37,58,185,163,161,185,243,195,165,255,15,234,55,245,109,68,51,109,95,197,176,192,3,184,132,45,65,194,163,165,116,253,26,189,229,3,80,135,44,96,194,58,188,238,238,185,42,189,252,32,218,173,132,102,226,11,55,72,11,205,219,53,151,26,216,229,204,128,164,82,92,173,147,26,8,77,101,80,103,39,231,120,232,105,207,238,187,142,141,20,13,199,159,112,151,61,114,206,217,149,187,104,191,172,35,226,153,173,14,129,18,2,9,148,114,119,99,244,163,226,216,23,221,208,77,164,93,224,83,252,182,98,115,243,252,52,156,222,250,187,208,196,221,89,240,170,175,109,244,120,5,57,182,7,1,62,183,95,172,180,184,244,5,56,21,29,89,1,79,110,20,39,219,137,91,23,64,77,56,82,127,173,69,172,121,38,191,71,76,196,34,141,56,208,28,169,11,80,107,62,59,66,139,167,60,131,212,115,217,107,130,152,151,184,151,185,175,96,252,79,110,181,239,196,207,93,252,74,19,5,103,198,29,220,225,13,113,121,118,89,183,204,225,196,15,175,119,79,29,107,225,48,16,17,157,111,154,28,147,61,46,237,51,88,130,236,132,240,150,24,145,47,224,106,163,31,168,130,192,161,128,107,23,183,168,50,117,172,210,241,254,127,142,93,37,232,115,156,3,195,230,89,157,73,167,79,33,106,170,196,187,14,86,250,144,122,37,186,218,246,26,55,243,167,116,26,10,223,139,182,74,174,7,59,185,136,197,29,169,20,100,255,247,224,39,122,47,95,214,60,231,147,171,25,36,16,73,213,187,98,207,108,18,226,129,170,74,195,54,32,177,194,236,174,108,16,201,206,101,247,46,202,160,68,241,175,213,93,197,174,101,101,158,244,226,11,218,103,32,64,216,150,43,1,115,129,31,71,156,91,85,117,47,4,81,101,50,230,138,204,2,139,183,25,170,69,234,225,105,253,126,216,67,82,223,140,187,83,235,232,227,234,69,115,84,81,219,29,219,231,20,135,21,172,7,82,123,163,239,184,97,14,112,136,62,115,54,146,214,155,226,43,150,122,179,12,198,238,58,155,147,73,89,17,250,138,34,220,243,131,47,170,153,92,62,158,56,193,103,11,158,23,248,51,71,58,122,223,111,58,193,115,11,219,232,189,205,29},
  {249,44,46,44,144,190,79,217,159,251,54,189,70,58,73,226,49,121,99,44,163,74,155,19,223,32,104,189,21,35,68,162,248,225,222,107,167,108,254,50,196,154,124,231,95,206,60,58,107,156,111,79,70,251,194,118,163,229,193,140,40,22,92,83,198,255,78,50,18,216,228,151,120,102,137,16,196,120,222,99,247,169,40,116,214,36,28,12,243,98,149,30,135,70,199,41,178,243,25,107,30,33,6,227,212,95,141,2,202,169,56,30,107,1,117,186,137,135,140,157,133,219,204,75,140,223,36,85,201,210,70,208,13,253,119,100,254,120,46,102,82,141,158,103,131,84,44,22,251,103,79,195,214,10,135,6,75,248,221,249,167,61,87,55,177,114,44,33,251,139,162,31,171,187,176,57,94,71,123,67,109,234,142,107,51,69,249,75,84,146,180,36,197,234,234,134,230,175,68,228,55,179,90,82,137,32,56,97,196,251,226,220,13,42,69,40,192,174,49,170,228,232,142,118,5,24,177,107,114,76,67,227,215,135,57,151,233,122,67,187,33,21,206,151,116,52,245,125,65,245,234,153,131,183,201,236,223,51,233,236,109,203,8,133,52,118,187,82,239,241,47,127,147,56,91,170,68,157,225,34,58,119,125,148,233,200,206,172,180,168,252,89,93,241,42,146,247,56,131,101,80,229,240,67,133,207,105,157,84,219,105,147,55,168,81,132,93,240,29,52,61,95,184,175,158,172,87,48,133,17,168,202,61,228,132,22,55,239,109,224,186,170,80,67,62,155,102,39,74,43,146,63,76,38,14,205,37,60,184,168,127,51,22,67,158,74,47,35,138,123,201,247,144,237,182,88,122,164,195,210,202,82,221,34,35,66,68,4,181,163,172,18,20,205,113,196,108,195,225,7,134,200,201,123,194,169,94,64,27,203,168,149,38,141,112,20,8,30,90,85,141,32,187,103,64,235,183,123,21,202,239,212,113,27,216,252,8,77,131,112,44,61,126,56,119,213,207,145,231,63,97,156,146,50,190,137,114,245,209,155,22,252,168,113,166,147,165,43,167,100,190,198,253,219,112,103,143,239,142,55,90,68,246,211,226,159,72,42,81,17,9,185,124,191,0,33,182,127,86,77,208,166,7,243,15,180,1,118,134,230,39,59,6,244,239,161,7,237,190,13,197,101,57,71,127,71,129,171,201,117,80,113,116,184,184,176,64,176,187,200,198,92,217,250,245,109,55,232,65,233,101,52,223,5,57,102,204,147,175,103,156,53,150,76,128,122,4,254,87,108,44,13,141,114,15,135,79,25,185,98,241,225,193,79,174,170,99,92,29,226,100,109,166,119,100,122,173,198,150,20,87,116,39,136,99,43,58,94,114,154,187,146,51,212,162,101,21,110,210,187,112,119,174,146,24,170,163,4,119,151,148,19,159,116,18,219,217,246,142,147,195,110,174,40,7,94,63,55,199,163,101,173,156,116,207,66,35,15,19,226,5,61,29,104,123,157,252,71,158,81,162,93,24,251,81,163,236,53,132,52,21,212,31,51,94,130,146,234,55,52,20,234,93,13,67,58,56,116,78,202,223,190,219,17,20,240,169,192,165,151,210,116,252,136,32,123,120,98,109,107,108,35,93,155,19,42,127,254,29,0,150,87,23,45,210,6,76,1,124,216,20,85,239,110,167,171,176,30,150,253,116,178,197,247,246,222,245,140,201,133,17,69,146,57,142,250,99,37,78,86,109,121,20,56,227,166,179,184,69,132,241,192,54,100,47,177,128,237,63,250,21,201,229,11,157,34,113,106,181,93,166,96,121,218,255,155,104,200,207,45,23,65,157,60,120,182,223,128,194,118,122,20,15,84,99,254,123,39,140,28,125,237,80,15,251,133,158,90,214,150,120,149,200,38,201,40,206,49,0,244,169,49,23,42,41,126,104,154,138,144,181,194,53,46,40,252,126,172,4,39,159,255,235,171,223,30,198,157,194,170,83,94,36,210,90,2,233,28,5,125,149,249,213,191,147,240,78,188,18,11,67,244,36,4,66,82,240,133,143,219,72,4,253,196,212,62,164,91,67,44,9,16,199,67,160,25,152,208,40,16,104,32,164,58,119,159,106,109,65,53,70,45,246,137,21,62,224,68,168,80,89,223,135,95,81,141,7,187,25,31,166,31,219,112,141,45,57,88,250,29,240,1,149,122,109,130,254,43,144,153,250,24,43,87,17,83,156,163,139,182,247,177,127,147,38,20,201,176,59,153,137,18,112,116,109,56,32,59,172,94,5,131,117,189,131,103,93,82,3,242,235,201,14,119,116,161,210,175,68,153,250,222,159,79,226,99,102,255,160,200,81,15,177,235,8,37,101,113,152,138,0,176,52,211,58,161,73,237,102,112,240,136,28,12,228,7,166,66,4,30,105,192,167,48,52,55,232,31,212,19,124,153,115,243,80,184,164,108,105,219,51,199,87,147,32,144,69,47,0,77,148,255,159,233,79,249,20,111,137,187,73,66,35,154,186,96,68,61,73,149,85,129,238,235,208,140,51,49,55,136,63,136,7,133,121,165,79,192,235,15,20,108,108,79,250,112,222,126,100,141,176,170,25,96,135,161,73,34,29,62,44,212,70,233,113,168,98,226,250,145,180,129,83,215,26,217,16,162,46,221,25,36,174,171,16,233,204,3,98,49,166,191,34,14,30,73,22,123,54,169,52,244,98,204,207,56,91,141,204,40,171,132,188,244,173,175,92,31,111,82,142,225,94,201,200,58,107,33,214,246,82,91,88,9,87,236,195,91,54,72,125,103,214,80,186,232,176,213,52,22,114,222,18,16,62,37,16,188,203,220,166,249,8,32,12,224,47,206,118,46,156,205,204,184,164,225,150,94,222,122,128,128,68,185,117,31,119,199,29,165,222,54,66,80,64,150,188,115,96,68,240,224,205,55,108,216,171,144,194,19,134,77,103,122,12,24,5,235,99,48,151,116,22,79,58,72,144,96,105,14,234,24,235,118,8,159,148,152,58,240,192,75,87,38,129,255,144,84,15,131,239,147,65,206,180,147,13,36,50,32,8,7,3,58,108,140,96,209,142,32,212,42,194,237,225,60,81,22,131,20,50,87,231,20,20,236,20,71,48,246,196,1,249,131,7,220,61,149,3,66,172,179,24,92,32,248,170,76,239,70,139,49,1,122,77,164,140,82,34,34,78,197,232,189,154,212,139,199,246,166,53,26,6,176,65,229,41,148,29,120,86,92,92,88,20,196,50,241,220,27,212,98,163,75,234,154,255,38,137,170,175,88,9,112,66,212,146,108,185,33,232,127,196,118,237,183,226,28,96,10,244,201,50,77,3,232,97,201,96,221,113,68,76,124,52,239,79,79,191,32,50,16,30,231,79},
  {228,252,195,36,151,197,191,230,228,244,16,52,129,120,185,180,137,232,89,141,164,213,111,213,144,243,32,206,147,94,25,74,187,56,92,33,105,210,126,1,237,245,160,146,227,123,80,213,126,66,131,37,94,113,177,53,7,140,223,193,21,107,26,18,186,68,139,69,134,32,236,123,112,175,26,246,194,65,1,166,90,225,209,237,103,230,40,180,167,98,23,89,233,4,172,10,127,106,193,169,52,147,248,163,253,248,235,191,81,73,190,190,252,29,220,222,134,149,157,85,215,61,104,99,4,50,147,92,88,173,186,114,38,32,42,124,180,65,206,101,52,244,211,43,71,179,230,191,161,79,77,3,94,84,26,201,221,129,248,105,68,219,27,136,112,11,99,38,17,125,249,182,97,24,48,147,63,122,27,183,254,1,26,195,91,49,32,165,182,183,26,88,102,27,204,202,116,156,230,209,32,31,72,97,147,16,196,237,87,36,111,161,133,87,48,104,240,120,199,250,19,250,75,122,167,199,203,18,98,76,159,75,84,96,144,104,231,130,191,106,251,103,18,37,238,250,209,221,93,76,116,97,206,211,10,34,82,99,190,219,153,114,171,85,42,253,68,104,56,169,134,130,103,41,146,241,13,95,132,161,125,7,4,57,178,75,57,214,76,122,140,226,49,215,87,14,255,228,32,104,145,191,5,182,228,127,223,111,55,186,26,167,9,187,156,155,152,139,59,255,52,223,49,11,167,148,179,172,86,207,136,159,115,194,31,200,192,207,250,171,101,229,121,180,105,46,70,48,142,150,40,181,175,54,44,251,133,159,141,146,167,76,54,96,42,34,151,64,172,224,243,39,82,252,39,248,81,137,27,130,183,84,165,70,101,42,203,187,202,13,29,87,110,237,77,149,183,228,93,37,5,5,208,149,123,27,25,44,29,210,255,30,207,158,176,244,192,51,12,163,184,51,130,230,223,103,168,171,5,207,54,238,72,165,35,72,125,243,49,202,127,132,105,194,65,100,148,223,4,31,141,30,44,116,62,174,208,167,36,121,89,25,112,112,105,8,93,105,137,61,149,80,177,255,201,80,164,70,252,34,201,69,24,154,112,66,133,160,205,105,49,99,62,180,206,193,40,198,82,77,193,26,48,15,43,136,182,94,75,124,246,101,186,125,80,27,204,137,169,148,167,28,129,199,255,6,88,10,191,195,188,244,198,6,228,113,40,26,61,100,5,170,183,120,129,56,209,238,138,27,251,255,115,34,16,56,171,128,88,94,155,87,249,129,181,59,23,206,18,184,176,112,67,219,57,20,36,87,198,209,16,99,158,164,242,39,194,47,214,227,148,68,44,231,72,73,173,67,19,4,204,103,11,217,99,206,218,130,120,127,118,235,165,27,148,105,179,123,134,186,221,161,168,10,38,84,243,163,96,253,15,134,218,116,148,12,219,108,242,61,120,38,110,4,192,72,39,227,230,12,86,244,79,69,103,163,195,221,101,171,250,200,120,35,81,42,122,142,86,145,12,95,56,124,133,210,233,119,84,92,125,148,213,71,65,155,235,60,143,51,218,85,63,246,152,67,89,191,22,44,13,193,2,58,28,181,172,19,110,134,19,96,172,109,204,199,7,223,179,166,81,3,57,185,193,128,123,182,97,182,139,207,177,36,221,211,78,104,37,34,142,198,4,175,225,84,122,27,49,234,110,206,186,14,145,69,70,123,145,217,252,40,125,242,5,113,0,94,236,116,59,243,199,170,152,92,243,239,34,35,49,23,202,47,29,80,250,8,181,215,3,43,11,217,100,146,189,234,51,1,49,191,179,200,183,58,181,79,171,203,57,215,143,163,230,222,28,38,236,78,96,112,195,181,180,73,198,181,2,184,84,90,218,138,48,8,58,78,148,212,131,240,214,246,47,116,33,185,97,94,182,164,89,92,180,216,177,188,53,98,110,113,241,213,11,42,59,29,127,154,65,16,208,242,233,118,199,178,231,44,231,19,50,178,147,181,226,40,48,139,168,19,209,50,212,15,48,248,193,87,215,219,23,139,32,248,167,69,203,178,155,249,103,59,72,54,94,169,98,113,137,232,119,226,43,159,93,49,171,162,254,30,231,45,223,96,233,222,152,179,245,248,69,95,199,244,61,157,18,111,221,173,30,178,47,59,177,173,213,156,113,103,69,15,92,30,230,43,245,145,91,226,130,21,157,210,253,228,198,198,104,48,28,203,3,163,235,100,83,241,198,255,43,44,176,42,13,18,213,29,2,61,244,122,159,131,231,184,60,46,205,82,201,133,157,230,4,253,134,69,134,58,244,208,162,46,18,13,32,62,142,200,118,12,55,10,127,151,237,229,30,46,130,36,235,220,49,108,142,142,15,158,160,229,220,92,123,167,122,126,61,74,3,156,68,217,145,178,41,51,25,155,79,42,106,30,226,27,246,232,35,175,28,151,64,116,54,55,85,235,179,59,20,144,115,121,192,175,244,27,181,78,164,167,49,62,139,145,198,185,75,57,52,176,184,145,132,229,199,104,160,32,46,95,29,193,103,13,243,183,176,196,232,173,230,241,154,57,221,202,61,108,215,31,217,210,214,212,246,95,157,234,32,47,68,96,96,62,215,62,83,228,205,35,102,31,122,160,18,121,149,31,252,2,62,184,184,25,224,198,131,208,175,10,162,58,18,164,115,225,34,51,193,118,97,167,68,132,10,250,159,6,47,78,182,170,209,101,13,237,11,86,148,33,19,76,155,66,67,192,143,151,253,234,214,125,253,108,221,140,97,77,51,160,63,87,198,123,141,179,249,19,35,143,18,229,89,125,123,171,24,32,242,128,209,222,54,14,141,18,43,38,126,157,100,170,155,21,209,105,11,86,98,214,50,240,25,127,48,13,139,116,108,94,13,67,116,242,187,127,77,220,204,213,50,57,154,121,193,249,138,146,53,31,92,8,2,107,82,104,90,218,79,132,249,177,147,208,169,159,180,60,195,227,60,186,135,144,120,168,30,41,98,3,231,210,241,115,40,73,17,147,7,91,143,129,198,90,239,111,202,135,247,8,209,248,229,96,165,68,91,255,22,230,41,194,98,160,27,223,238,106,34,7,98,243,125,23,2,68,182,114,103,89,205,17,210,0,228,229,131,114,215,216,57,194,73,194,65,192,230,242,153,75,44,96,208,2,218,144,231,36,190,50,222,48,211,6,159,252,226,118,113,188,231,86,103,76,3,63,27,114,0,85,160,48,109,61,241,121,70,197,122,173,185,189,207,158,222,88,118,193,68,160,181,218,58,13,129,182,242,251,233,109,221,98,240,0,251,1,20,106,35,13,235,105,4,82,153,57,139,238,10,184,0,88,186,206,86,166,145,127,80,211,18,50,72,215,162,193,155,200,51,207,82},
  {27,144,75,208,247,239,222,152,27,206,48,120,164,61,186,168,214,39,156,97,42,147,198,122,8,168,176,163,231,239,42,24,0,212,129,235,68,224,242,6,161,51,69,106,74,78,7,9,131,228,35,81,161,168,8,114,66,110,38,200,211,6,223,44,53,99,183,31,11,17,103,173,231,47,226,60,27,15,82,11,51,233,109,18,199,76,87,70,8,213,130,115,19,242,208,97,87,244,246,28,201,44,76,60,124,184,87,174,158,195,99,103,132,176,72,14,177,185,123,9,13,142,101,150,64,51,247,31,136,58,17,2,166,168,129,153,17,71,172,94,187,8,178,85,221,200,73,216,248,44,94,111,52,33,1,49,85,123,71,109,170,77,177,117,170,134,126,240,224,159,233,49,54,173,74,179,186,76,48,96,99,68,175,201,238,41,203,66,124,240,81,1,242,238,41,171,123,182,119,98,178,220,11,202,38,172,212,200,122,128,218,8,166,30,74,181,83,28,44,187,65,23,115,41,121,190,120,115,172,212,182,103,189,6,98,97,63,65,22,207,32,127,16,115,51,181,1,82,74,243,72,192,13,181,248,187,120,166,208,202,95,128,71,211,38,169,182,74,64,166,200,112,177,32,50,96,254,229,76,12,72,125,141,132,205,61,175,133,152,75,0,80,22,252,234,255,205,243,223,70,18,121,58,93,99,175,107,121,160,136,142,28,223,9,195,119,232,61,226,48,96,71,25,204,96,192,175,1,181,215,164,235,171,234,148,250,205,131,29,247,144,11,153,113,227,161,150,81,166,60,96,226,94,98,104,20,35,45,6,43,243,112,230,183,2,229,179,50,156,189,59,197,142,221,55,244,158,134,212,55,52,195,13,89,217,157,151,61,13,250,195,147,117,79,131,101,251,165,118,236,1,11,217,229,70,47,100,49,199,204,221,22,46,99,216,129,185,60,94,232,246,112,248,128,20,86,126,187,195,169,208,61,50,203,227,143,133,27,123,73,177,15,105,253,161,206,87,18,37,210,64,148,6,71,11,152,41,169,212,221,110,13,141,80,233,138,23,25,64,178,29,191,164,254,130,226,51,9,141,42,213,253,166,82,112,146,76,139,251,193,92,188,0,14,121,110,54,170,229,137,167,229,182,83,128,236,184,121,223,144,141,156,173,6,111,79,189,142,236,236,138,1,191,171,171,254,239,155,65,111,36,151,105,27,143,249,187,89,252,248,89,37,250,25,114,117,217,166,172,1,95,66,220,106,238,181,174,222,2,47,196,232,14,249,57,45,243,178,254,114,168,76,99,158,251,26,171,98,111,89,14,226,69,35,122,67,228,199,60,239,186,171,43,56,151,150,98,161,215,118,212,99,192,75,181,218,108,136,57,242,54,202,80,117,227,181,174,111,186,137,149,57,146,50,2,198,139,210,77,245,238,205,62,66,6,254,95,158,73,102,83,185,185,132,45,242,191,165,238,26,237,112,54,182,155,189,30,241,227,233,16,150,197,86,235,76,141,74,241,199,159,255,138,186,193,90,44,98,127,56,202,138,238,14,76,236,141,49,250,164,27,70,79,89,60,172,22,86,205,69,69,131,234,213,112,67,213,87,148,241,153,13,185,181,48,68,66,127,133,176,22,228,129,9,165,184,149,83,38,36,222,53,11,47,239,71,212,5,251,168,201,106,155,101,190,140,112,101,101,140,19,213,223,201,103,218,84,118,16,74,76,149,241,53,114,60,144,236,245,132,150,123,192,211,108,39,197,214,76,178,91,48,104,95,117,209,164,24,49,63,71,233,215,241,167,201,252,243,220,187,213,150,52,248,176,109,16,237,211,224,170,182,138,223,156,193,24,70,224,14,224,108,74,237,38,68,161,56,80,167,138,17,71,117,38,243,163,131,130,90,242,179,41,181,195,166,99,147,26,19,25,94,20,233,249,190,153,25,115,66,52,197,192,173,193,185,6,221,205,27,86,18,25,111,178,180,252,134,63,252,151,227,179,47,118,2,171,88,28,79,186,122,234,96,211,8,63,49,203,209,226,68,178,129,54,174,102,168,55,221,38,215,46,5,41,122,140,21,67,220,101,30,104,21,215,207,239,125,51,224,147,42,5,143,12,151,236,15,124,47,98,200,173,146,41,6,189,152,102,248,111,15,186,170,203,232,107,153,40,31,216,173,96,176,228,168,84,250,118,60,99,228,13,175,11,19,242,197,96,102,203,27,243,199,69,104,216,240,78,186,31,229,14,210,149,216,84,231,166,70,177,232,176,76,50,240,94,124,96,191,199,40,176,142,75,142,98,205,30,55,189,52,68,251,114,18,244,106,30,59,231,75,230,186,20,241,206,233,90,226,217,213,175,177,88,147,129,101,199,188,77,239,43,212,229,129,146,255,207,180,211,147,241,187,18,127,207,191,238,231,169,99,31,225,8,201,208,40,80,62,76,139,208,100,246,73,235,142,198,94,14,74,26,147,133,169,17,193,166,217,142,185,247,201,27,162,63,27,87,165,172,90,64,32,247,165,212,237,20,89,105,69,227,217,46,50,36,40,229,167,56,213,130,153,80,120,163,203,164,171,3,107,22,228,120,61,155,184,6,145,80,239,1,145,208,145,39,64,147,214,194,245,147,206,65,35,170,32,209,243,25,219,6,140,74,162,36,204,139,16,17,8,72,178,132,52,29,58,200,35,184,249,93,5,106,130,38,24,106,102,156,230,16,104,179,243,229,12,240,12,3,232,244,36,39,151,103,16,197,24,214,51,60,155,131,68,13,224,26,62,230,76,209,182,191,225,10,166,45,94,83,224,39,55,95,248,25,246,179,31,243,61,200,60,155,153,55,0,239,203,156,141,34,57,209,255,238,73,184,185,38,221,120,151,108,233,153,118,235,37,240,105,137,0,31,209,35,10,156,103,152,137,94,109,229,127,227,191,46,57,141,133,247,194,208,161,53,70,170,173,207,3,79,81,195,242,107,20,0,219,186,232,127,114,3,114,145,125,246,21,238,64,38,96,142,231,22,219,44,71,196,1,114,153,78,149,131,184,182,125,57,130,54,222,84,79,219,196,219,243,75,220,47,204,23,242,184,188,155,113,175,80,22,65,75,114,102,85,68,76,23,0,63,101,191,133,16,210,61,11,67,139,155,178,252,192,191,182,31,166,50,62,235,245,18,90,79,199,12,130,27,203,27,111,90,216,23,63,18,4,115,187,138,246,72,167,36,77,229,203,14,251,73,203,148,143,190,69,72,165,183,224,248,117,47,28,79,135,186,230,226,26,60,107,57,174,145,160,192,158,152,234,148,236,133,198,56,127,180,88,173,92,69,0,161,125,240,172,29,125,44,121,222,40,65,216,188,127,0,210,24,121,174,213,193,243,59,117,57,111,114,65,163,36,71},
} ;

static const int16_t precomputed_encode_953x6343_x[precomputed_encode_953x6343_NUM][crypto_encode_ITEMS] = {
  {-2102,-32038,156,-10318,-11539,-20776,-32197,10895,-16974,17454,11004,25000,-27472,25043,-27637,-9601,-937,25601,18130,21776,650,-32652,10717,3430,-16352,17159,2884,-2531,8679,-6144,29899,-20801,-5865,-478,-11797,-13067,24990,-29546,29771,-22089,-11425,84,-7672,15816,26070,-18063,2815,-3573,-19859,-21631,27152,-17387,9714,21,30171,6676,-6245,-2755,19848,25646,31933,-18287,28092,-5780,11193,19204,2154,-26113,17598,-20733,26625,-23914,9627,-22048,18657,-20074,15568,-17023,15911,-27729,60,13132,24356,-2490,1448,-19929,6829,-6254,24702,21071,-6864,32287,-10210,-3861,19268,21352,-19528,-12795,-3060,20982,-21340,-25270,28452,8042,13452,15539,24330,23454,25004,-12312,-30244,18606,30881,-12800,5889,-15132,26603,-6866,-17701,-12831,2885,15761,27802,7812,25049,-29574,31057,-5745,14228,4814,-13747,-28191,-20762,21443,15640,1549,-28972,-26505,13267,22712,-30569,-20590,-5800,-17853,29192,28861,29196,6670,-20689,19695,619,30443,-12182,-8336,-7282,809,3936,6041,26847,-5989,-7291,-32147,-1170,-24618,6934,3285,-12395,-27394,10633,13720,13518,21352,14687,-25137,-2191,31177,-29340,9099,-30994,-31697,31176,23957,-2856,-22708,-17641,27562,30998,25834,10114,30639,-22710,-657,-9817,-22539,13210,4170,19286,14863,-1160,32214,28497,-28103,20680,108,24242,-10347,-26075,-24818,-11632,3617,16439,-27072,-27206,10954,32296,28882,13222,-28694,-32353,20944,-27229,21796,-24463,31950,18880,21316,-20369,-17488,11971,15931,-11095,-23928,-32327,-16841,26588,-23343,-22778,18956,-18294,17557,22885,23906,689,18951,32068,-21567,-2044,-29453,-6484,-15027,31207,-14568,19473,6778,15079,-31135,32084,-9537,-22288,16792,13425,12392,26941,-31768,-28901,-11767,-2445,24814,1060,2263,28459,-28312,9699,-23584,8821,-24499,-17473,-8468,7882,27086,-10535,422,24423,-29697,2679,-19073,-2277,-9853,-3674,-13821,8273,32512,-17484,-6115,-31689,9435,-9856,-19303,-26857,-32509,-6592,-22674,4269,10438,11526,-27197,-791,-17714,7203,1962,23643,7429,-23952,29106,-25509,-30127,29690,-13394,17657,795,19766,-14028,23432,-9184,-3339,29598,21400,-16665,12180,8209,-8586,9811,29705,-2129,-22381,-22667,-12666,-32752,23998,-17709,27297,-28767,-14283,16250,31764,5690,17682,6565,-30920,28367,-5198,-7577,-2293,-15442,-709,-13228,-12379,17084,-15528,30780,-17167,9098,31332,32202,-470,20545,9438,-29623,-6208,-28268,24690,-19443,-31600,-15820,-29034,-29537,24552,-28441,19766,25323,19666,25212,-16449,3,-15275,17108,-14130,-20949,-29920,-30735,-22026,-6491,-32339,19563,30102,4084,11468,20555,-30548,12236,21137,-25425,509,-22196,-27172,15321,6143,-25353,-23867,-940,-22199,-31023,-27901,-26611,-1214,23027,2203,-20210,-10392,-29159,23658,-25091,-18792,-15967,-2256,21581,-12821,-5772,-17210,28088,17264,-7342,29221,-8167,-7309,-3146,8416,-11963,-23010,17422,30745,5586,202,-19498,16836,-10966,-3772,-11276,-29117,-21182,10657,16291,22246,-20387,-29029,-11110,-1400,11000,-26778,8760,-950,21602,-2342,-27560,-15808,-21285,1375,-27532,18366,20989,29807,-25147,11088,-14415,13083,-2304,-24690,16599,-22860,-5869,-1124,21137,20368,13635,28852,-1645,-22,14832,28505,-2159,24539,-29139,30026,28395,-7475,15778,-31527,17456,-8319,-31148,-20871,19772,32318,-19864,5576,19203,-30694,9297,-20246,21782,-29532,916,-16541,32354,-16246,-18217,-15282,169,19884,9211,27819,29390,4269,22975,26493,-21930,29342,-3346,-27758,-12403,-1273,31580,-31167,16470,-17077,15749,-21160,-15115,882,-4388,-10881,-9007,-32345,14920,-29475,30905,-5998,-23470,9072,28002,20237,7705,-21897,14887,-6272,-24290,26236,19464,30724,16039,-12597,-2832,3155,-3404,13760,-2077,-10856,14625,15324,11969,11566,24107,23019,-29777,-28936,9217,-27123,15505,-28065,23525,-8281,9188,-5268,26452,-27697,-25131,-13424,9250,-18604,-5339,-6933,-6754,9950,29131,29123,29852,-21206,4270,-22579,-2061,3094,23563,13488,-7346,-2864,5026,19321,4181,-1387,-2728,22065,-30578,-9977,-26748,14159,25358,-22189,-8906,-14239,-2239,-11322,81,13162,-29434,24820,-25991,17964,-22235,-28304,-5138,8251,2028,-17140,24815,17537,4571,-26313,-22539,2674,-29554,-25246,32676,-31090,-24538,12229,-80,8714,-15556,-13810,-12152,8976,16670,-6328,-21521,3896,14046,-18792,2707,-29463,-299,23420,8441,14273,7937,-9361,-22566,24832,-31493,-24771,3604,783,20552,-13068,-11463,20591,-20661,27662,12678,20231,-3113,27356,-30092,-1123,-27944,10815,-22129,29852,-12871,12210,1938,-1100,-3271,18873,-11163,-1222,11347,30762,-4873,9561,3574,-30204,-20827,27202,20481,13664,-5477,14011,9763,-10545,-1653,19914,8149,32547,-3736,-26005,12915,-3938,-19781,827,7226,-30634,14956,10559,-26730,-18246,8166,22567,-22705,13465,-19575,11348,-18512,-7401,-12882,13104,-15781,-2379,17661,-25182,19903,3229,19964,15874,9607,-26655,-25947,25064,-10590,-7882,4579,27011,-4881,31216,-16506,-441,-21886,7860,-1251,1638,-32508,23460,-10477,-13307,26357,21457,-31610,14605,-31164,-9391,-7374,-6564,27989,-2054,23986,30528,-25369,7349,-18912,11305,7006,-29047,24309,-25012,15045,8429,-16947,29021,-312,-30031,-29662,-6622,-24350,5953,7325,31175,4434,15161,-14708,28678,19496,25594,14958,-27122,-869,13623,14050,18213,28876,15098,-21604,5984,23886,11088,-8094,9034,2279,-10242,-15152,-4821,-29099,5804,-25069,-7442,-16695,32443,9119,-29118,-13654,-26097,28392,32127,3991,-27044,-22695,-639,-31514,2494,16247,-5424,14470,-9838,-1093,-32010,-26049,-31338,486,26601,-9414,-8494,-26191,27746,17070,-19509,-17052,19208,-28485,28326,32078,13557,-6216,3910,4902,-9251,22171,-25743,15023,13120,18560,-7558,5792,1568,20603,-6818,18564,-24619,-32292,21234,-18507,19317,-23230,22272,-22564,-30068,30303,-22902,-12720,7631,17417,-25852,-24783,14117,27350,2678,-31410,16512,-3588,29173,24453,31722,23037,-10999,13112,-30366,-364,-22289,-24955,6645,29612,-3445,-5456,10924,21873,4272,1295,-8136,-19574,-16209,6892,28259,2756,-3562,-19519,581,7096,13143,-15469,32223,-10954,30122,-21680,-22304,-28808,14802,7091,27518,-15181,-8490,-24613,10355,-14004,-28093,19795,10616,31309,6450,884,14509,3934,30002,-8650,8473,-20210,630},
  {26782,-19483,12844,-28666,17264,-11272,1903,-14536,21921,-8150,9308,4718,16744,5706,732,25155,15415,27982,-18560,-30947,28688,9197,4235,-17272,9393,-14214,-19356,-25868,-7306,641,-6200,5564,-5572,-20868,-24499,-9985,31970,26411,31721,-2725,23367,4531,25628,-13896,-21123,-11738,-518,31686,-26081,-24724,15100,31501,-9474,-21104,-28972,-16710,2459,5072,-20561,-7050,-24100,7532,-5108,30280,32457,-31693,-17458,23960,12541,-31397,-7118,-1834,-11840,-31328,10466,-7623,-6962,-1422,-3851,-28953,14072,21537,-21965,-21637,30484,-16826,21793,19525,130,-21729,6969,-6692,22375,16376,31273,10634,22548,7562,6998,30013,-17602,21304,-23867,11983,-4223,24621,-13454,-21723,2617,-6913,-27085,3307,28517,-9246,8940,25927,13907,21298,13007,19571,32287,21890,-1322,-10894,-32687,-7675,6195,-17249,20191,24286,-27704,-10838,-14824,5755,29675,32556,-22951,3403,6682,3940,18344,-28898,23747,-18075,6677,-10182,-30282,15858,-15165,-31968,9876,-18299,12826,1404,-29970,-3913,17976,-12179,25915,102,-6123,-6154,-27004,27565,16070,-26667,-4383,18037,4935,-8764,-4834,-6796,276,10185,30760,-15792,-22332,-24914,23113,-10410,14820,-31673,10970,5572,-17251,16594,-3020,-16597,-25471,28333,-10822,-13490,-26183,23212,-23874,-12660,21078,19976,-28716,-16344,19039,-20352,-32055,-19201,20204,20115,-22475,509,-24713,-8605,-3849,-24619,6456,19867,7631,-28686,18565,8965,27809,28168,25276,30896,13118,31304,2771,4950,-3711,-5016,-8247,18215,25228,4265,15298,14427,-3290,3693,-23654,23889,-14637,8232,-12390,-19111,20797,17919,-12959,-19603,19848,-14013,-28935,30608,-26515,16307,-30374,-1625,-24910,30793,13455,24136,21073,12480,-5374,-30891,-24056,-13032,-16349,23167,-1916,27433,-8883,102,26192,8001,13154,12895,-26038,28799,-2194,31122,13207,-1922,-11738,-4508,-267,-12720,20544,-9433,11588,-22978,27660,-12752,12859,19279,7823,-25382,21133,-20333,-16096,16521,-17098,-3485,-9008,-17512,-16450,9302,-18831,6756,-1477,27002,18185,-11147,-5016,-28145,15149,-13122,-32045,-5974,21514,21549,5489,-32756,15133,25336,14976,-7904,-17136,-26086,-23658,-16817,4807,-16022,28752,13056,-29329,30938,-21390,28534,17820,9381,10086,-23079,-18813,16681,-2444,4188,12911,16337,-253,14237,22857,3855,16382,-16412,-4252,16880,-8770,-20920,-16357,-14914,331,6723,20271,4424,-30352,22338,19540,-3714,18664,31385,-32616,14230,14522,-18543,-13239,-1127,-690,-18064,-14801,31349,-23668,-4567,19846,-17228,-24128,-23789,-5693,19640,-1261,3679,-8930,-17463,2295,11707,-13575,-30683,-15774,-25455,-763,-12935,12418,11457,936,-5558,7945,1368,-20466,5316,22373,30807,-14737,-22004,-4823,12961,-24071,-18301,-25702,3730,8604,-2996,19220,-24158,24383,-17830,-12723,314,-760,8224,-19137,-14880,-9199,-29196,2108,-32563,-20266,-25691,-568,-8056,-1287,-13167,-31978,-23485,-3921,-25421,29374,-11176,-594,-7417,-13732,28685,-10996,-9883,6321,-10520,-8191,-9729,-15427,-1265,-28811,14131,9676,-20757,-1931,-20369,-23910,-16742,-9429,32453,-6639,-30236,27525,-2074,-15766,5412,-27586,22881,-15510,-17950,23770,-9029,15655,-18055,26048,24238,-22523,-10849,-3242,-7380,4302,11470,-7605,22242,-11445,25194,-21154,-19702,30957,-5523,-6285,-5955,-4188,32470,30180,-9268,-16472,-20287,-26878,6051,-18199,14912,9022,12944,1298,-16805,23789,-18121,-5954,-24993,8482,18955,-21786,9856,26836,31903,26015,942,-7689,-432,4313,16432,-8019,1564,15279,-20881,22011,-3369,-21415,-26687,-47,23345,-29953,-18308,15327,24313,-223,-6496,-24577,-20366,-18746,-7137,18750,-23811,-20077,20662,8843,-476,15959,4902,-11466,-14126,1761,7898,25955,-26857,13290,30220,-17680,-9208,-25599,20733,-11599,-18622,-22232,-6156,532,13527,-8072,-25655,-24118,-24213,-11119,-20304,13792,-2945,-2308,-2517,32583,121,14372,22753,13572,-3273,28142,-3342,15752,-13558,-19874,30178,-567,-1004,17251,-26547,27690,-19581,-19989,23548,10104,18389,-17893,14849,801,-20673,-24092,16265,3076,-31375,-3899,-11949,23039,-9902,18024,8542,-5016,-21296,-26455,2795,-10508,8148,18842,9671,14536,31473,27760,27604,-28126,-26957,29511,-23307,2521,-3304,26221,-17681,-28357,1616,-27051,-7177,2476,-23579,-15406,28227,-23103,20450,23731,-3114,-3846,22886,-26717,-28788,20105,11438,-20735,-24970,-6909,16902,2496,-9261,30691,3520,24997,24073,4555,21677,-4134,13328,-21923,-23419,4798,-16915,-15688,20292,7185,5901,-3239,-644,29242,27915,-14204,26990,-23984,-28730,-20386,26231,27048,-12212,-28594,18833,10718,-7797,10270,1326,15783,-27335,-26685,25628,-3898,-17573,25578,-11106,-21484,-21541,-30840,23571,13017,22359,12105,3021,-7583,-16287,-20662,6522,3526,31801,-3683,28369,27045,-32608,-17909,8144,-24488,-2119,-30006,-19667,-279,7939,23343,20208,14940,-16910,-7038,24318,12546,28366,-11037,8031,-13854,-28765,22909,24222,23949,22749,-427,-18481,-21689,31875,-9958,-26859,30875,-15899,-32607,3364,-30512,-15273,19970,16273,18739,-29759,-26423,9515,-4186,-5773,4761,9147,5260,-15057,-19273,3795,-28144,-10323,14169,-6674,15302,-11615,12400,7311,7202,13156,18288,26465,14606,-3562,-18997,29700,29325,17744,9379,-1850,-32459,17264,-10042,-29675,10725,-14904,-1740,-6378,2620,15091,-1901,5452,10624,-26128,-31175,-5678,28176,15321,-15306,-29831,-11364,-30116,20088,-16007,-10626,18868,-12370,2284,-13604,-8115,-21223,-14722,-25471,-4274,-13547,-1559,30244,-26889,-4168,960,28514,32183,16732,-2362,5377,-11109,21655,-30417,-8665,17263,11543,-20266,-24415,8835,-2738,-10794,-1426,18949,21050,5715,-16418,-9611,24081,22537,20874,-12008,28536,24563,-5683,2160,14871,28287,-18317,30389,28000,1364,-30493,-18564,29662,-7005,26089,-4750,12327,-23423,29280,-346,13956,2257,-7749,9575,-26745,-28243,23401,31384,10436,-17713,17900,18471,20708,-1377,23849,4958,28609,11299,-14640,13254,-284,-24895,-11903,-9379,10587,-26887,-24105,-31689,-6588,11125,7755,-18637,8825,13684,-15564,-12424,8615,-31949,-24452,-743,16718,-18811,-26101,11388,20872,-26816,9052,3324,-24555,8813,15752,28216,17507,-30513,18390,-913,-13043,-13869,-11035,-7972,16016,2482,10299,-13435,8215,26666,10711,17863,-15937,4839,-15466,2365,-9234},
  {-26550,10414,-11351,22574,27124,-21923,20446,-31953,30715,29927,31544,8320,-14779,-8196,29430,13117,14692,-13109,22144,23415,19753,11973,-12748,31237,-11610,-26146,-28997,-1397,-17680,25181,-11785,16614,32540,-1919,9374,4970,-14878,-2471,23736,-19678,23101,-280,-1725,2259,-23497,32524,386,5082,9375,12865,-13778,28443,-10662,30964,5192,11367,-25664,29849,-7976,-551,-30649,19674,2119,-1363,2655,-12827,21491,-7744,15614,20560,-11147,29673,-24117,-17845,18653,-18957,11925,-28541,25501,-2412,28288,-22418,25361,10072,18751,10672,-11332,12364,23607,-472,15834,22515,24449,-8336,-12768,-27860,-17284,-23299,13337,19760,7972,904,25273,5089,24853,22768,25104,-12699,3043,15674,15685,-25641,-25501,15031,24364,-1304,-18342,-12916,-26378,25913,-9505,-15008,9522,-16846,-19176,-20532,-14042,-12733,-12719,20441,-24212,27226,24473,-26589,9061,13867,12548,-7704,30449,-14509,-28967,-13595,-27208,5157,9434,-17597,31047,897,20087,-18530,-21621,-15290,9215,3009,-25496,14294,19992,811,10658,-13550,-19392,-29452,11105,3982,17246,-7818,-16535,-19634,17489,2392,25007,25214,15085,-27900,-30469,-5829,17811,-17908,23141,27570,15166,2904,-6818,-10116,24716,22481,19082,-24878,11850,16204,-20916,3546,-21077,8069,7186,28046,-19105,-15013,7849,-13,-21166,17882,-25978,7494,19592,-22859,-28353,-11157,-28480,1737,5191,-1616,-23759,-6876,-23548,-20852,-4187,30581,20987,17644,-17835,-18326,-2242,-15965,-27193,-6344,21354,22191,8164,9642,30633,-17806,-24897,22235,-5523,29661,17545,-23350,-14733,11628,8992,-20635,25865,30919,27094,1600,-15033,-31426,-5100,-10617,10265,22245,-29668,1238,3536,-25586,22215,6709,13861,-2377,13446,-23443,32735,28652,28672,19358,-19342,6070,-13494,6330,18461,-29849,-14075,-26970,-16225,14989,-5915,18608,4167,-3597,26590,8833,5100,21056,-15313,16253,163,-29742,13242,12022,-17191,8141,-10662,-4215,-21864,7521,5670,-31881,-25513,3847,11430,-16171,2998,12881,-1903,-28371,-12871,-21822,5904,19129,-29139,23747,27622,-25891,-11735,-25075,29163,-10749,31,-13284,7261,-25207,17140,-32013,12305,17618,-25706,-11501,-20608,28562,19175,-10385,-1419,11818,-4439,18674,-15197,-30445,24536,3302,-1984,-24885,27755,15770,17857,16944,2356,-30090,21908,-14002,25705,2145,24986,10075,15619,10663,-11083,-2360,-23508,12207,27779,-5420,22737,-3445,-23450,52,30820,-22195,-16489,15195,-22700,31105,-13193,-21403,-182,11603,-26347,12796,22953,7702,-11242,-29841,25542,17729,-3897,-12406,-6158,-27017,-9520,18254,-21932,9735,-1939,5135,-2415,20348,-5293,-14444,-23888,9475,9874,24845,2522,-32142,-23981,11696,-15379,10892,-11862,-20723,-23249,-28728,-6998,10699,-16558,13770,-27323,-22331,-28389,32671,-31498,13638,-31524,28482,23418,-31349,-8739,-12555,-11909,-18370,-9162,-23016,-17052,25876,-28922,-21741,-14423,29092,-8653,10794,21766,32215,-7776,-11769,31702,16213,-28067,8233,-19258,14826,31299,23422,-32434,3146,23248,14138,11042,-31750,14541,13321,-26914,-23355,-24403,-19139,-14534,-15247,5359,28218,4314,-783,10565,-2488,12991,-10858,30211,3362,7888,5540,-10018,15114,-30561,7070,-8479,-15831,-10309,-31557,-2761,16474,-7063,23444,-11398,18857,6794,-19260,941,-7697,31074,-29918,-9311,-24097,-24767,-20328,28737,30897,30153,-27482,3901,-8745,32087,-23164,3195,-27195,15976,-20426,25797,24629,-26017,-11709,14836,-27461,1869,12782,9194,-2359,2438,32727,30145,-16951,-28998,-18453,-31249,-18461,29624,-25958,10448,-21916,-156,31540,4860,21967,-28985,-32534,21436,11845,27603,29690,-6607,-9608,18750,-12436,-18474,-21557,4485,-29254,4669,16045,-12158,-6233,27816,14568,1301,-26782,6841,-6440,-20511,-11868,-27357,7044,3799,2053,11266,15354,-22217,12716,-1932,23339,-1630,4230,-7418,-23720,-31159,-7143,-14484,17238,-18441,2885,27819,23369,2586,-900,-22402,-28334,-21611,24265,-19162,-15130,27588,16871,14830,6603,-1278,20222,28562,-3113,-18346,22179,-17517,-23143,13019,15251,31819,17045,-18447,6852,6064,-5356,16376,-7803,9158,31576,9950,-13279,32205,-6299,-11749,-18251,-30564,-32503,-24732,-27076,-25049,18672,24716,-12454,16407,-25421,9878,-9045,-24062,31912,-26186,26438,16440,18482,-16293,-22133,22987,-4132,23351,-28687,-27458,17344,9547,-13324,31295,15792,15914,27831,-2689,14594,-18331,4059,-9676,-10060,-30943,-17560,-14785,28933,10999,-23103,-10303,-13963,-17784,26856,11888,-8101,-17499,19892,-20790,2110,-28260,30511,-24825,5850,-32560,-19681,-17628,-10471,9177,-8014,-12739,26771,-24219,-18834,24586,17946,-2962,-14123,-19137,-13943,-9493,8934,3554,-9480,5272,1908,4032,28876,-31634,30232,-22669,-21896,-4622,-27506,1938,4110,-12811,-12170,17667,-30488,-32135,-26496,-25969,28190,-18760,7879,-15736,-8307,1584,28511,-26622,-15033,-1541,-4686,-26604,-24825,11676,31190,-811,18504,-23811,-32513,22746,15006,-9913,22958,2688,14670,-30987,9980,-29614,28956,-2626,828,-10595,-19068,18299,14581,-12016,9359,20361,-29171,-32668,1591,4201,24220,26440,21408,5812,-4064,-3845,-3112,-2472,14129,-13443,16677,7217,26694,-25234,26820,-15737,-30690,3982,16892,-24449,10634,-15546,10436,-13286,12965,17130,-24521,1347,7696,-20174,-24746,21236,25351,-27672,-19595,-24428,-26221,27770,-5353,20881,27586,-30677,-25026,2317,-374,-21032,-25425,3935,616,30290,3812,4785,-17323,-21473,25571,29295,-19553,31876,-25631,-16555,8641,-9155,-27833,22873,-31449,-7305,-173,5433,-4497,11672,-3904,4550,-1020,-20227,30409,-26675,-12366,-1962,5528,10754,-24189,14485,-4308,-9830,-17383,-21490,-3536,31434,-32495,5841,21021,-22318,-13247,-19305,-1142,-2893,6277,25930,-11975,17695,-30772,-27907,23018,28848,-2351,27640,-3449,23947,21931,-10868,211,-17259,8790,12447,-3696,29306,4163,-4565,-15655,-13687,7870,-9964,14298,-1942,-27358,27712,3440,-23437,5322,21002,-2562,-29797,-11301,-25104,-1857,-24274,-30425,21341,-25458,-13067,-6507,-30076,20189,-14749,-8080,26473,-22954,3168,-16423,12437,32717,-1659,23159,-13571,-9333,15792,18295,22299,7644,-4380,13465,7041,32604,-28780,-13495,27095,-5959,-4368,8297,-22295,-2446,26189,-14692,-30028,-9196,-14035,8720,11419,-17890,-30114,-25753,22750,-26687,-25628,14714,680,-16325,7576},
  {-5374,31543,-6484,-14207,1647,-26032,-1521,-26159,-22335,-24082,-10416,-32712,4497,1645,-26154,-14828,-9932,-2458,5675,-17889,-4516,15066,-23070,4116,-8680,-8536,17970,-4950,944,-14039,1014,-6588,4131,19027,20826,7097,7720,28956,-4492,22954,29273,1168,4636,16295,-27302,30632,4857,8090,31245,-4110,7206,-4045,-12582,16153,-27164,-28972,-15565,-21615,11627,2693,7786,28007,28723,29196,15343,7330,-25271,20538,-27514,13419,-8217,20120,22813,5374,27480,-15298,18242,17015,26890,-9328,4740,-32015,29851,-8778,12509,1758,-19421,14404,-23636,-14372,32025,28519,-5579,-12470,-31041,19839,-30951,24298,-28788,-30370,-11403,22564,10277,20921,16664,6548,-12527,-7006,2092,-19690,-7656,7029,-13350,-2018,10745,10321,20079,-27450,-23558,-24689,-13825,24986,5196,-18889,-3986,4278,-19583,-8718,11012,-24460,-16296,22935,13031,31585,-28076,-17277,-22103,10096,15294,27578,-12822,12223,26157,-5781,11654,-32503,-19155,-14308,-19555,-26907,30135,-32711,-13380,-16672,18420,27555,4536,30355,8968,17121,-832,-22050,27424,25087,-8998,8136,-99,-9937,-2757,13643,18602,-21535,-18021,2725,-15909,4657,-12056,20406,-20827,19765,9299,14216,-20698,19015,32569,-15173,8572,-15535,-7149,26983,-25779,-27148,25581,-19989,-27762,1701,18470,1051,3493,-20810,-17351,-15145,-15327,-13090,-32615,-27357,16249,-14619,4321,-25417,24989,-5133,10399,16601,-7798,22104,-22533,18688,-13447,1485,-17421,-12198,-27959,-2530,11075,306,21868,9644,31084,-27944,5006,-17744,-9688,21467,12478,22100,-1754,-16329,23588,-16490,-28343,6793,14709,5285,9675,9584,27513,13648,17826,21808,24572,20844,-13309,-3906,-340,19564,18945,5865,-24377,32455,7962,27051,5195,27964,-17530,-29320,-30512,-13054,-14073,25111,-11212,-1308,15869,25540,31268,-20582,11699,-12171,-32735,32149,-2059,-7379,-31379,28664,9706,19485,8816,-24095,10912,5984,6635,32347,-9184,20082,331,19329,-13798,-17459,-10061,13452,12880,-8890,-23879,25231,20278,-9341,10239,-2228,26790,-19890,27684,20062,-8648,-455,-23947,18010,6102,-11402,30531,14465,-21955,23773,23647,25742,23765,2869,32346,18203,-13423,-24876,-2590,-2490,17150,6147,-13520,24980,20287,27930,-13213,20878,-19339,-29915,7018,-14479,-28487,26526,-18218,10584,25301,6335,-25132,-13524,-11741,26885,-741,-29853,1752,29301,-21077,13029,14686,-3877,31954,-6044,-10862,27944,-10214,6583,3861,1113,-9647,-34,-19642,5008,5778,-5557,-10916,7878,16455,-22237,1356,-32016,15361,-4436,-27084,28747,-13888,-7031,-2095,-28676,26636,-12887,9433,-31588,-12316,15489,-10773,-14456,-14028,23750,21098,31177,-12778,11581,-30599,16355,-4637,-28273,18841,-13958,-17078,27885,30276,-21026,22487,-18673,681,3464,-19013,23389,13415,3601,-14949,-10541,28812,-432,7675,-1667,-5706,-9053,-13605,14971,-28073,-9371,-5055,14694,16252,-17209,2278,-8229,5226,-28263,12195,546,1012,23811,24850,22955,-14559,-30476,5146,-25406,16408,26554,24857,-25706,4825,20296,1429,-31519,5016,1426,20085,3392,11916,28115,22229,-14906,7340,31204,10289,17868,3017,4453,-15670,-7520,17067,-27312,14144,-28829,17994,22325,-17096,-6854,-11721,-22761,27150,-13590,-6037,29192,-24809,3499,-7936,13080,11517,-10564,-2486,16588,22722,-22307,-13946,21487,31079,16977,4603,-6549,10952,-20056,-32262,12043,4597,-32576,-30994,-7839,5789,10934,24962,-23547,-30057,-20453,878,21788,-11709,32444,-9516,13449,13404,-20755,-31,15800,5799,-14157,19417,-29688,26968,17705,9613,4218,28971,15039,29053,-20132,-28453,27905,27743,16749,1665,15616,-2269,23111,8601,-10462,-31593,-17237,1008,-3030,-28453,-26963,12512,2790,32579,15247,17428,-19122,-32437,-25926,-2943,-10218,-21569,7649,31398,-2042,-30389,-7616,-3513,11716,-18019,21658,-22206,-29821,-12823,32715,-16033,-21246,6991,405,22520,-23348,-11668,-11064,-30961,24853,-20098,16643,-27766,-32349,10727,1989,-10436,16037,31011,-24353,-2978,-6234,-32676,23543,-7561,-20613,-27256,-24865,-17921,-15063,9468,-22236,26211,31896,18842,-6812,31070,-3876,8926,-13655,-32155,2947,-19939,-15861,26629,-158,20910,-383,-5995,-1801,-20050,776,13581,-10153,27615,408,23531,14538,2976,6093,-16588,-23701,17609,-3180,6088,-9879,-30146,-7704,-12444,2887,-12061,813,-21546,-19157,-14661,9629,-15761,-1788,28825,-14871,15002,-21099,27054,-12301,-25748,10479,3881,20752,-9698,8079,-16703,-24825,-1118,26369,-2381,25047,25488,4785,25020,-27494,11636,-6962,26648,-18876,-11189,-27962,-20377,14829,26735,2316,-15790,15923,-20550,31110,27751,-10255,-10105,9890,10305,14580,-3720,-32234,4625,-32063,-28191,26244,23488,-2140,20168,-29761,16814,-2379,-24214,-15070,21225,-17929,-15600,11259,-32669,12749,-21452,21859,-19481,2922,8152,-17549,23553,-5173,7838,-18728,-23810,-3933,-4578,-10049,-19395,-26423,16470,-14517,28601,-31608,5635,21440,-26269,-29467,-9555,8765,-28476,-1937,22214,-21405,-20362,29799,-2623,-27582,-24946,-6110,23355,16283,22842,-29322,-9059,-10204,17787,-22423,3364,31052,-25881,-29798,-26824,-12598,-19273,-7737,27373,32417,-23022,-17203,-7164,3984,16773,26770,27032,-19512,13695,-19854,-22589,-26321,32318,-5491,4947,-10620,13349,-8490,-26999,-30198,28147,711,22528,-32420,5264,16555,27758,5154,-21789,-31773,7741,19885,-18982,26199,5033,30223,-25889,-32491,15526,-32398,-17022,16594,-25445,-28501,-31777,16399,13884,-26982,-18151,14755,32376,19879,-4121,26215,21496,32758,-10218,23135,20414,29040,27089,-15946,-13333,-19511,8974,29716,-26977,-12482,1417,-6386,9243,-6512,12242,-28016,-29618,-5387,-30590,1270,-14856,-20465,20721,-7632,-165,17472,11698,1670,15866,20514,-3075,14388,-8593,-31799,-4403,-3304,-28153,-21423,25267,-4478,-31995,32259,17784,7796,23350,-12345,-27796,-9835,-28329,-19748,-2698,-11496,15245,4106,13798,2866,-1369,21101,222,-27732,6017,28214,-32694,-29573,-23878,-9857,-26748,-16950,6745,-6409,1787,6661,1917,-3865,18193,-10558,16765,22055,20893,12543,-14054,30097,-24125,9991,-17868,-17263,-15762,-9367,22985,-6527,-15061,-3060,20266,-20437,25107,-18184,-5570,25115,-19164,10287,-15177,16411,-5875,-7871,-12186,-2478,6162,-23224,-17928,-6469,-21945,-218,16693,15440,-8779,28895,24518,-5081,22380},
} ;

static void test_encode_953x6343_impl(long long impl)
{
  unsigned char *s = test_encode_953x6343_s;
  unsigned char *x = test_encode_953x6343_x;
  unsigned char *s2 = test_encode_953x6343_s2;
  unsigned char *x2 = test_encode_953x6343_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_953x6343_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_953x6343(impl);
    printf("encode_953x6343 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_953x6343_implementation(impl),ntruprime_dispatch_encode_953x6343_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_953x6343;
    printf("encode_953x6343 selected implementation %s compiler %s\n",ntruprime_encode_953x6343_implementation(),ntruprime_encode_953x6343_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_953x6343_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_953x6343_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_953x6343_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_953x6343_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_953x6343_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_953x6343_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_953x6343(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"953x6343")) return;
  storage_encode_953x6343_s = callocplus(crypto_encode_STRBYTES);
  test_encode_953x6343_s = aligned(storage_encode_953x6343_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_953x6343_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_953x6343_x = aligned(storage_encode_953x6343_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_953x6343_s2 = callocplus(maxalloc);
  test_encode_953x6343_s2 = aligned(storage_encode_953x6343_s2,crypto_encode_STRBYTES);
  storage_encode_953x6343_x2 = callocplus(maxalloc);
  test_encode_953x6343_x2 = aligned(storage_encode_953x6343_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_953x6343 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_953x6343();++impl)
      forked(test_encode_953x6343_impl,impl);
    ++test_encode_953x6343_s;
    ++test_encode_953x6343_x;
    ++test_encode_953x6343_s2;
    ++test_encode_953x6343_x2;
  }
  free(storage_encode_953x6343_x2);
  free(storage_encode_953x6343_s2);
  free(storage_encode_953x6343_x);
  free(storage_encode_953x6343_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

