# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::MN;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20250323211832;

my $formatters = [
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[12]1',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '[5-9]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '[12]2[1-3]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [12](?:
              27|
              3[2-8]|
              4[2-68]|
              5[1-4689]
            )[0-3]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '[12]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{4,5})'
                }
              ];

my $validators = {
                'fixed_line' => '
          [12]2[1-3]\\d{5,6}|
          (?:
            (?:
              [12](?:
                1|
                27
              )|
              5[368]
            )\\d\\d|
            7(?:
              0(?:
                [0-5]\\d|
                7[078]|
                80
              )|
              128
            )
          )\\d{4}|
          [12](?:
            3[2-8]|
            4[2-68]|
            5[1-4689]
          )\\d{6,7}
        ',
                'geographic' => '
          [12]2[1-3]\\d{5,6}|
          (?:
            (?:
              [12](?:
                1|
                27
              )|
              5[368]
            )\\d\\d|
            7(?:
              0(?:
                [0-5]\\d|
                7[078]|
                80
              )|
              128
            )
          )\\d{4}|
          [12](?:
            3[2-8]|
            4[2-68]|
            5[1-4689]
          )\\d{6,7}
        ',
                'mobile' => '
          (?:
            83[01]|
            92[039]
          )\\d{5}|
          (?:
            5[05]|
            6[069]|
            72|
            8[015689]|
            9[013-9]
          )\\d{6}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '',
                'toll_free' => '',
                'voip' => '
          712[0-79]\\d{4}|
          7(?:
            1[013-9]|
            [5-9]\\d
          )\\d{5}
        '
              };
my %areanames = ();
$areanames{en} = {"97623353", "Khashaat\,\ Arkhangai",
"97624353", "Uench\,\ Khovd",
"97624459", "Shjnejinst\,\ Bayankhongor",
"97615349", "Savrai\,\ Umnugovi",
"97615242", "Altanshiree\,\ Dornogovi",
"97622766", "Tseel\,\ Tuv",
"97623846", "Jargalant\,\ Khuvsgul",
"97624846", "Delger\,\ Govi\-Altai",
"97615355", "Tsogttsetsii\,\ Umnugovi",
"9762372", "Darkhan\ city\,\ Darkhan\-Uul",
"97624647", "Zavkhanmandal\,\ Zavkhan",
"97623244", "Bayan\-Undur\,\ Uvurkhangai",
"97624244", "Bugat\,\ Bayan\-Ulgii",
"97623647", "Mandal\,\ Selenge",
"97624651", "Numrug\,\ Zavkhan",
"97613448", "Orkhon\,\ Bulgan",
"97623651", "Saikhan\,\ Selenge",
"97614448", "Bogd\,\ Bayankhongor",
"976222", "Bagakhangai",
"97615143", "Dariganga\,\ Sukhbaatar",
"97623445", "Gurvanbulag\,\ Bulgan",
"97624445", "Bayan\-Ovoo\,\ Bayankhongor",
"97614659", "Tsegeenkhairkhan\,\ Zavkhan",
"97614543", "Davst\,\ Uvs",
"9762482", "Altai\ city\,\ Govi\-Altai",
"9762382", "Murun\ city\,\ Khuvsgul",
"97625643", "Bayan\-Adarga\,\ Khentii",
"97625943", "Govi\-Ugtaal\,\ Dundgovi",
"97624852", "Khaluun\,\ Govi\-Altai",
"97613864", "Shine\-Ider\,\ Khuvsgul",
"97623852", "Tosontsengel\,\ Khuvsgul",
"97612744", "Batsumber\,\ Tuv",
"97625341", "Bayandalai\,\ Umnugovi",
"97613645", "Javkhlant\,\ Selenge",
"97615854", "Chuluunkhoroot\,\ Dornod",
"97614645", "Bulnai\,\ Zavkhan",
"97614451", "Buutsagaan\,\ Bayankhongor",
"97623648", "Orkhon\,\ Selenge",
"97624648", "Ider\,\ Zavkhan",
"97613451", "Saikhan\,\ Bulgan",
"97614447", "Bayantsagaan\,\ Bayankhongor",
"97613447", "Mogod\,\ Bulgan",
"97624557", "Khovd\,\ Uvs",
"97624345", "Durgun\,\ Khovd",
"97624541", "Baruunturuun\,\ Uvs",
"97623541", "Jargalant\,\ Orkhon",
"97623345", "Ugii\-Nuur\,\ Arkhangai",
"97615149", "Tumentsogt\,\ Sukhbaatar",
"97614348", "Mankhan\,\ Khovd",
"97613348", "Tariat\,\ Arkhangai",
"97615254", "Erdene\,\ Dornogovi",
"97615657", "Tsenkhermandal\,\ Khentii",
"97612746", "Bayandelger\,\ Tuv",
"97615641", "Batnorov\,\ Khentii",
"97615941", "Adaatsag\,\ Dundgovi",
"97615343", "Bulgan\,\ Umnugovi",
"9762322", "Arvaikheer\ city\,\ Uvurkhangai",
"9762422", "Ulgii\,\ Bayan\-Ulgii",
"97623359", "Erdenemandal\,\ Arkhangai",
"97624453", "Gurvanbulag\,\ Bayankhongor",
"97623453", "Teshig\,\ Bulgan",
"97623252", "Ulziit\,\ Uvurkhangai",
"97624252", "Ulaankhus\,\ Bayan\-Ulgii",
"97624246", "Buyant\,\ Bayan\-Ulgii",
"97613351", "Khairkhan\,\ Arkhangai",
"97614351", "Must\,\ Khovd",
"97623246", "Burd\,\ Uvurkhangai",
"97614555", "Turgen\,\ Uvs",
"97613347", "Undur\-Ulaan\,\ Arkhangai",
"97614347", "Zereg\,\ Khovd",
"97624558", "Khyargas\,\ Uvs",
"97625655", "Norovlin\,\ Khentii",
"97624844", "Bugant\,\ Govi\-Altai",
"97623844", "Burentogtokh\,\ Khuvsgul",
"97625441", "Bayantal\,\ Govisumber",
"97625955", "Erdenedalai\,\ Dundgovi",
"9761272", "Zuunmod\ city\,\ Tuv",
"97625649", "Dadal\,\ Khentii",
"97612752", "Bayantsogt\,\ Tuv",
"97625949", "Ulziit\,\ Dundgovi",
"97622764", "Sergelen\,\ Tuv",
"97614549", "Ulgii\,\ Uvs",
"97614653", "Santmargad\,\ Zavkhan",
"97613653", "Tushig\,\ Selenge",
"97625141", "Asgat\,\ Sukhbaatar",
"97624665", "Yaruu\,\ Zavkhan",
"97615842", "Bayantumen\,\ Dornod",
"97623442", "Bayannuur\,\ Bulgan",
"97624442", "Bayanbulag\,\ Bayankhongor",
"97624243", "Bayannuur\,\ Bayan\-Ulgii",
"97623243", "Bayangol\,\ Uvurkhangai",
"97615144", "Munkhkhaan\,\ Sukhbaatar",
"9761532", "Dalanzadgad\,\ Umnugovi",
"97612761", "Mungunmorit\,\ Tuv",
"97615352", "Khankhongor\,\ Umnugovi",
"97613857", "Khatgal\,\ Khuvsgul",
"97615245", "Zamiin\-Uud\,\ Dornogovi",
"97614857", "Sharga\,\ Govi\-Altai",
"97613841", "Alag\-Erdene\,\ Khuvsgul",
"97614841", "Altai\,\ Govi\-Altai",
"97625248", "Urgun\,\ Dornogovi",
"97614656", "Telmen\,\ Zavkhan",
"97613656", "Tsagaannuur\,\ Selenge",
"97624354", "Khovd\,\ Khovd",
"97623354", "Khotont\,\ Arkhangai",
"97615853", "Choibalsan\,\ Dornod",
"97613642", "Baruunburen\,\ Selenge",
"97614642", "Asgat\,\ Zavkhan",
"97623849", "Renchinlkhumbe\,\ Khuvsgul",
"97624849", "Tonkhil\,\ Govi\-Altai",
"97612743", "Arhust\,\ Tuv",
"97613741", "Orkhon\,\ Darkhan\-Uul",
"97625644", "Bayanmunkh\,\ Khentii",
"97624855", "Tseel\,\ Govi\-Altai",
"97625247", "Mandakh\,\ Dornogovi",
"97623855", "Ulaan\-Uul\,\ Khuvsgul",
"97615346", "Manlai\,\ Umnugovi",
"97625251", "Ulaanbadrakh\,\ Dornogovi",
"97614858", "Erdene\,\ Govi\-Altai",
"97613863", "Chaandmani\-Undur\,\ Khuvsgul",
"97613858", "Tsagaannuur\,\ Khuvsgul",
"97625944", "Gurvansaikhan\,\ Dundgovi",
"97614544", "Zavkhan\,\ Uvs",
"97624456", "Zag\,\ Bayankhongor",
"97623456", "Khutag\-Undur\,\ Bulgan",
"97614546", "Zuunkhangai\,\ Uvs",
"97625847", "Matad\,\ Dornod",
"97623255", "Tugrug\,\ Uvurkhangai",
"97615152", "Halzan\,\ Sukhbaatar",
"97625851", "Khulunbuyir\,\ Dornod",
"97613258", "Kharkhorin\,\ Uvurkhangai",
"97623454", "Khangal\,\ Bulgan",
"97624454", "Jargalant\,\ Bayankhongor",
"9761512", "Baruun\-Urt\ city\,\ Sukhbaatar",
"97625646", "Bayankhutagt\,\ Khentii",
"97622757", "Jargalant\,\ Tuv",
"97622741", "Altaanbulag\,\ Tuv",
"97615344", "Gurvan\ tes\,\ Umnugovi",
"97623743", "Sharingol\,\ Darkhan\-Uul",
"97625946", "Delgertsogt\,\ Dundgovi",
"97615253", "Huvsgul\,\ Dornogovi",
"97623861", "Tsagaan\-Uur\,\ Khuvsgul",
"9761542", "Choir\,\ Govisumber",
"97624249", "Sagsai\,\ Bayan\-Ulgii",
"97623249", "Zuunbayan\-Ulaan\,\ Uvurkhangai",
"97624342", "Bulgan\,\ Khovd",
"97623342", "Bulgan\,\ Arkhangai",
"97613654", "Khuder\,\ Selenge",
"97613257", "Hairkhandulaan\,\ Uvurkhangai",
"97624662", "Tsetsen\-Uul\,\ Zavkhan",
"97615845", "Gurvanzagal\,\ Dornod",
"97614654", "Songino\,\ Zavkhan",
"97614241", "Altai\,\ Bayan\-Ulgii",
"97623356", "Tsenkher\,\ Arkhangai",
"97613241", "Baruun\ Bayan\-Ulaan\,\ Uvurkhangai",
"97624356", "Chandmani\,\ Khovd",
"97625848", "Sereglen\,\ Dornod",
"97612755", "Buren\,\ Tuv",
"97622758", "Zaamar\,\ Tuv",
"97622763", "Sumber\,\ Tuv",
"9762562", "Undurkhaan\ city\,\ Khentii",
"97612749", "Bayankhangai\,\ Tuv",
"97625952", "Saikhan\-Ovoo\,\ Dundgovi",
"97623843", "Bayanzurkh\,\ Khuvsgul",
"97624843", "Biger\,\ Govi\-Altai",
"97625652", "Delgerkhaan\,\ Khentii",
"9762592", "Mandalgovi\ city\,\ Dundgovi",
"9761352", "Erdenet\ city\,\ Orkhon",
"9761452", "Ulaangom\ city\,\ Uvs",
"97615146", "Ongon\,\ Sukhbaatar",
"97614552", "Undurkhangai\,\ Uvs",
"97623859", "Tsagaan\-Uul\,\ Khuvsgul",
"97612768", "Erdenesant\,\ Tuv",
"97612753", "Bayanchandmani\,\ Tuv",
"97622765", "Ugtaal\,\ Tuv",
"9761362", "Sukhbaatar\ city\,\ Selenge",
"9761462", "Uliastal\ city\,\ Zavkhan",
"97615843", "Bayan\-Uul\,\ Dornod",
"97613652", "Sant\,\ Selenge",
"97614652", "Otgon\,\ Zavkhan",
"97624664", "Erdenekhaijkhan\,\ Zavkhan",
"97614554", "Tarialan\,\ Uvs",
"97624446", "Bayan\-Undur\,\ Bayankhongor",
"97623446", "Dashinchilen\,\ Bulgan",
"97624845", "Darvi\,\ Govi\-Altai",
"97625654", "Murun\,\ Khentii",
"97623845", "Galt\,\ Khuvsgul",
"97625241", "Airag\,\ Dornogovi",
"97614848", "Taishir\,\ Govi\-Altai",
"97613848", "Rashaant\,\ Khuvsgul",
"97625954", "Tsagaandelger\,\ Dundgovi",
"97615249", "Saikhandulaan\,\ Dornogovi",
"97615342", "Bayan\-Ovoo\,\ Umnugovi",
"97612767", "Erdene\,\ Tuv",
"97623452", "Selenge\,\ Bulgan",
"97624452", "Galuut\,\ Bayankhongor",
"97624253", "Tsengel\,\ Bayan\-Ulgii",
"97623253", "Sant\,\ Uvurkhangai",
"9762342", "Bulgan\ city\,\ Bulgan",
"9762442", "Bayankhongor\ city\,\ Bayankhongor",
"97614646", "Durvuljin\,\ Zavkhan",
"976223", "Nalaikh",
"97613646", "Zuunburen\,\ Selenge",
"97624344", "Darvi\,\ Khovd",
"97623344", "Ikh\-Tamir\,\ Arkhangai",
"97613847", "Ikh\-Uul\,\ Khuvsgul",
"97614847", "Jargalan\,\ Govi\-Altai",
"97613851", "Tarialan\,\ Khuvsgul",
"97614851", "Tugrug\,\ Govi\-Altai",
"97612745", "Bayan\,\ Tuv",
"97622748", "Bayan\-Unjuul\,\ Tuv",
"97613644", "Yereu\,\ Selenge",
"97614247", "Deluun\,\ Bayan\-Ulgii",
"97614644", "Bayankhairkhan\,\ Zavkhan",
"97613247", "Guchin\-Us\,\ Uvurkhangai",
"97623346", "Ulziit\,\ Arkhangai",
"97614251", "Tolbo\,\ Bayan\-Ulgii",
"97624346", "Duut\,\ Khovd",
"97613251", "Naariinteel\,\ Uvurkhangai",
"97615849", "Khalkh\,\ Dornod",
"97614542", "Bukhmurun\,\ Uvs",
"97612759", "Lun\,\ Tuv",
"97625942", "Bayanjargalan\,\ Dundgovi",
"97623853", "Tumurbulag\,\ Khuvsgul",
"97624853", "Khukhmorit\,\ Govi\-Altai",
"97625642", "Batshireet\,\ Khentii",
"97613865", "Erdenebulgan\,\ Khuvsgul",
"97625656", "Umnudelger\,\ Khentii",
"97622747", "Bayanjargal\,\ Tuv",
"97622751", "Bayantsagaan\,\ Tuv",
"97615354", "Tsogt\-Ovoo\,\ Umnugovi",
"97614556", "Tes\,\ Uvs",
"97623245", "Bogd\,\ Uvurkhangai",
"97624245", "Bulgan\,\ Bayan\-Ulgii",
"97615142", "Bayandelger\,\ Sukhbaatar",
"97625841", "Bayandun\,\ Dornod",
"97613248", "Zuil\,\ Uvurkhangai",
"97614248", "Nogoonnnuur\,\ Bayan\-Ulgii",
"97623444", "Buregkhangai\,\ Bulgan",
"97624444", "Bayanlig\,\ Bayankhongor",
"97623259", "Khujirt\,\ Uvurkhangai",
"9762432", "Khovd\ city\,\ Khovd",
"9762332", "Tsetserleg\ city\,\ Arkhangai",
"97624352", "Myangad\,\ Khovd",
"97623352", "Khahgai\,\ Arkhangai",
"97615442", "Shivee\-Govi\,\ Govisumber",
"97615243", "Dalanjargalan\,\ Dornogovi",
"976221", "Baganuur",
"97625653", "Jargaltkhaan\,\ Khentii",
"97625953", "Khuld\,\ Dundgovi",
"97624842", "Bayan\-Uul\,\ Govi\-Altai",
"97623842", "Arbulag\,\ Khuvsgul",
"97614649", "Ikh\-Uul\,\ Zavkhan",
"97613649", "Orkhontuul\,\ Selenge",
"97614553", "Sagili\,\ Uvs",
"97613655", "Hushaat\,\ Selenge",
"97614655", "Tudevtei\,\ Zavkhan",
"97615844", "Bulgan\,\ Dornod",
"97614441", "Baatsagaan\,\ Bayankhongor",
"97624663", "Shiluustei\,\ Zavkhan",
"97624658", "Urgamal\,\ Zavkhan",
"97613441", "Bayanagt\,\ Bulgan",
"97614457", "Ulziit\,\ Bayankhongor",
"97625351", "Khanbogd\,\ Umnugovi",
"97622762", "Undurshereet\,\ Tuv",
"97612754", "Bornuur\,\ Tuv",
"97615246", "Ikh\-Khet\,\ Dornogovi",
"97625347", "Noyon\,\ Umnugovi",
"9761522", "Sainshand\ city\,\ Dornogovi",
"97615252", "Khatanbulag\,\ Dornogovi",
"97623343", "Jargalant\,\ Arkhangai",
"97624343", "Buyant\,\ Khovd",
"97624449", "Bumbugur\,\ Bayankhongor",
"97623449", "Rashaant\,\ Bulgan",
"97624657", "Tes\,\ Zavkhan",
"97623254", "Taragt\,\ Uvurkhangai",
"97623657", "Shaamar\,\ Selenge",
"97624641", "Aldarkhaan\,\ Zavkhan",
"97623641", "Altanbulag\,\ Selenge",
"97614458", "Khureemaral\,\ Bayankhongor",
"97615153", "Erdenetsagaan\,\ Sukhbaatar",
"97623455", "Khishig\-Undur\,\ Bulgan",
"97624455", "Jinst\,\ Bayankhongor",
"97623856", "Khankh\,\ Khuvsgul",
"97624856", "Chandmani\,\ Govi\-Altai",
"97623742", "Khongor\,\ Darkhan\-Uul",
"97615345", "Mandal\-Ovoo\,\ Umnugovi",
"97625348", "Nomgon\,\ Umnugovi",
"97625645", "Bayan\-Ovoo\,\ Khentii",
"97624854", "Tsogt\,\ Govi\-Altai",
"97623854", "Tunel\,\ Khuvsgul",
"97613862", "Tsetserleg\,\ Khuvsgul",
"97615948", "Luus\,\ Dundgovi",
"97615648", "Galshir\,\ Khentii",
"97625945", "Delgerkhangai\,\ Dundgovi",
"97613341", "Battsengel\,\ Arkhangai",
"97614545", "Zuungovi\,\ Uvs",
"97623256", "Uyanga\,\ Uvurkhangai",
"97614341", "Altai\,\ Khovd",
"97613357", "Tsetserleg\,\ Arkhangai",
"97614357", "Erdeneburen\,\ Khovd",
"97624548", "Naranbulag\,\ Uvs",
"97614559", "Tsagaankhairkhan\,\ Uvs",
"9761582", "Choibalsan\ city\,\ Dornod",
"97624461", "Erdenetsogt\,\ Bayankhongor",
"97614643", "Bayantest\,\ Zavkhan",
"97613643", "Bayangol\,\ Selenge",
"97625151", "Uulbayan\,\ Sukhbaatar",
"97625147", "Sukhbaatar\,\ Sukhbaatar",
"97615852", "Tsagaan\-Ovoo\,\ Dornod",
"97612742", "Argalant\,\ Tuv",
"97621", "Ulaanbaatar",
"97615244", "Delgerekh\,\ Dornogovi",
"97615647", "Binder\,\ Khentii",
"97612756", "Delgerkhaan\,\ Tuv",
"97615651", "Darkhan\,\ Khentii",
"97615951", "Undurshil\,\ Dundgovi",
"97615947", "Deren\,\ Dundgovi",
"97624547", "Malchin\,\ Uvs",
"97615846", "Dashbalbar\,\ Dornod",
"97624355", "Tsetseg\,\ Khovd",
"97624551", "Umnugovi\,\ Uvs",
"97623355", "Tsakhirt\,\ Arkhangai",
"97613358", "Chuluut\,\ Arkhangai",
"97623349", "Tuvshruulekh\,\ Arkhangai",
"97625148", "Tuvshin\-Shiree\,\ Sukhbaatar",
"97624349", "Munkhkhairkhan\,\ Khovd",
"97614661", "Tsagaanchuluut\,\ Zavkhan",
"97624443", "Bayangovi\,\ Bayankhongor",
"97623443", "Bugat\,\ Bulgan",
"97623242", "Batulzii\,\ Uvurkhangai",
"97615145", "Naran\,\ Sukhbaatar",
"97624242", "Altantsugts\,\ Bayan\-Ulgii",
"97615353", "Khurmen\,\ Umnugovi",
"97613456", "Khutag\-Undur\,\ Bulgan",
"97614456", "Zag\,\ Bayankhongor",
"97624544", "Zavkhan\,\ Uvs",
"97623858", "Tsagaannuur\,\ Khuvsgul",
"97623863", "Chaandmani\-Undur\,\ Khuvsgul",
"97624858", "Erdene\,\ Govi\-Altai",
"97615944", "Gurvansaikhan\,\ Dundgovi",
"97615247", "Mandakh\,\ Dornogovi",
"97613855", "Ulaan\-Uul\,\ Khuvsgul",
"97615644", "Bayanmunkh\,\ Khentii",
"97614855", "Tseel\,\ Govi\-Altai",
"97615251", "Ulaanbadrakh\,\ Dornogovi",
"97625346", "Manlai\,\ Umnugovi",
"97623741", "Orkhon\,\ Darkhan\-Uul",
"97614849", "Tonkhil\,\ Govi\-Altai",
"97613849", "Renchinlkhumbe\,\ Khuvsgul",
"97622743", "Arhust\,\ Tuv",
"97624642", "Asgat\,\ Zavkhan",
"97623642", "Baruunburen\,\ Selenge",
"97625853", "Choibalsan\,\ Dornod",
"97623656", "Tsagaannuur\,\ Selenge",
"97624656", "Telmen\,\ Zavkhan",
"97613354", "Khotont\,\ Arkhangai",
"97614354", "Khovd\,\ Khovd",
"97615248", "Urgun\,\ Dornogovi",
"97624857", "Sharga\,\ Govi\-Altai",
"97623857", "Khatgal\,\ Khuvsgul",
"97625245", "Zamiin\-Uud\,\ Dornogovi",
"97624841", "Altai\,\ Govi\-Altai",
"97623841", "Alag\-Erdene\,\ Khuvsgul",
"97622761", "Mungunmorit\,\ Tuv",
"97625352", "Khankhongor\,\ Umnugovi",
"9762532", "Dalanzadgad\,\ Umnugovi",
"97625144", "Munkhkhaan\,\ Sukhbaatar",
"97614442", "Bayanbulag\,\ Bayankhongor",
"97613442", "Bayannuur\,\ Bulgan",
"97613243", "Bayangol\,\ Uvurkhangai",
"97614243", "Bayannuur\,\ Bayan\-Ulgii",
"97624552", "Undurkhangai\,\ Uvs",
"97625146", "Ongon\,\ Sukhbaatar",
"9762452", "Ulaangom\ city\,\ Uvs",
"9762352", "Erdenet\ city\,\ Orkhon",
"9761592", "Mandalgovi\ city\,\ Dundgovi",
"97615652", "Delgerkhaan\,\ Khentii",
"97615952", "Saikhan\-Ovoo\,\ Dundgovi",
"97622749", "Bayankhangai\,\ Tuv",
"9761562", "Undurkhaan\ city\,\ Khentii",
"97614843", "Biger\,\ Govi\-Altai",
"97613843", "Bayanzurkh\,\ Khuvsgul",
"97612763", "Sumber\,\ Tuv",
"97612758", "Zaamar\,\ Tuv",
"97622755", "Buren\,\ Tuv",
"97615848", "Sereglen\,\ Dornod",
"97625845", "Gurvanzagal\,\ Dornod",
"97614662", "Tsetsen\-Uul\,\ Zavkhan",
"97624654", "Songino\,\ Zavkhan",
"97623257", "Hairkhandulaan\,\ Uvurkhangai",
"97623654", "Khuder\,\ Selenge",
"97614356", "Chandmani\,\ Khovd",
"97623241", "Baruun\ Bayan\-Ulaan\,\ Uvurkhangai",
"97624241", "Altai\,\ Bayan\-Ulgii",
"97613356", "Tsenkher\,\ Arkhangai",
"97613342", "Bulgan\,\ Arkhangai",
"97614342", "Bulgan\,\ Khovd",
"97613249", "Zuunbayan\-Ulaan\,\ Uvurkhangai",
"97614249", "Sagsai\,\ Bayan\-Ulgii",
"97613861", "Tsagaan\-Uur\,\ Khuvsgul",
"9762542", "Choir\,\ Govisumber",
"97625253", "Huvsgul\,\ Dornogovi",
"97615946", "Delgertsogt\,\ Dundgovi",
"97613743", "Sharingol\,\ Darkhan\-Uul",
"97612757", "Jargalant\,\ Tuv",
"97615646", "Bayankhutagt\,\ Khentii",
"97625344", "Gurvan\ tes\,\ Umnugovi",
"97612741", "Altaanbulag\,\ Tuv",
"97623258", "Kharkhorin\,\ Uvurkhangai",
"9762512", "Baruun\-Urt\ city\,\ Sukhbaatar",
"97614454", "Jargalant\,\ Bayankhongor",
"97613454", "Khangal\,\ Bulgan",
"97625152", "Halzan\,\ Sukhbaatar",
"97615847", "Matad\,\ Dornod",
"97624546", "Zuunkhangai\,\ Uvs",
"97613255", "Tugrug\,\ Uvurkhangai",
"97615851", "Khulunbuyir\,\ Dornod",
"97614648", "Ider\,\ Zavkhan",
"97623451", "Saikhan\,\ Bulgan",
"97624451", "Buutsagaan\,\ Bayankhongor",
"97613648", "Orkhon\,\ Selenge",
"97623447", "Mogod\,\ Bulgan",
"97624447", "Bayantsagaan\,\ Bayankhongor",
"97624645", "Bulnai\,\ Zavkhan",
"97625854", "Chuluunkhoroot\,\ Dornod",
"97623645", "Javkhlant\,\ Selenge",
"97615341", "Bayandalai\,\ Umnugovi",
"97622744", "Batsumber\,\ Tuv",
"97615943", "Govi\-Ugtaal\,\ Dundgovi",
"97613852", "Tosontsengel\,\ Khuvsgul",
"97623864", "Shine\-Ider\,\ Khuvsgul",
"97614852", "Khaluun\,\ Govi\-Altai",
"9761382", "Murun\ city\,\ Khuvsgul",
"9761482", "Altai\ city\,\ Govi\-Altai",
"97615643", "Bayan\-Adraga\,\ Khentii",
"97624659", "Tsegeenkhairkhan\,\ Zavkhan",
"97624543", "Davst\,\ Uvs",
"97625143", "Dariganga\,\ Sukhbaatar",
"97614445", "Bayan\-Ovoo\,\ Bayankhongor",
"97613445", "Gurvanbulag\,\ Bulgan",
"97614244", "Bugat\,\ Bayan\-Ulgii",
"97613647", "Mandal\,\ Selenge",
"97613244", "Bayan\-Undur\,\ Uvurkhangai",
"97614647", "Zavkhanmandal\,\ Zavkhan",
"97624448", "Bogd\,\ Bayankhongor",
"976122", "Bagakhangai",
"97613651", "Saikhan\,\ Selenge",
"97614651", "Numrug\,\ Zavkhan",
"97623448", "Orkhon\,\ Bulgan",
"9761372", "Darkhan\ city\,\ Darkhan\-Uul",
"97614846", "Delger\,\ Govi\-Altai",
"97613846", "Jargalant\,\ Khuvsgul",
"97625355", "Tsogt\-Tsetsii\,\ Umnugovi",
"97612766", "Tseel\,\ Tuv",
"97625242", "Altanshiree\,\ Dornogovi",
"97625349", "Savrai\,\ Umnugovi",
"97614459", "Shjnejinst\,\ Bayankhongor",
"97614353", "Uench\,\ Khovd",
"97613353", "Khashaat\,\ Arkhangai",
"97615141", "Asgat\,\ Sukhbaatar",
"97625842", "Bayantumen\,\ Dornod",
"97614665", "Yaruu\,\ Zavkhan",
"97624549", "Ulgii\,\ Uvs",
"97623653", "Tushig\,\ Selenge",
"97624653", "Santmargad\,\ Zavkhan",
"97612764", "Sergelen\,\ Tuv",
"97622752", "Bayantsogt\,\ Tuv",
"97615949", "Ulziit\,\ Dundgovi",
"97615649", "Dadal\,\ Khentii",
"9762272", "Zuunmod\ city\,\ Tuv",
"97615441", "Bayantal\,\ Govisumber",
"97615955", "Erdenedalai\,\ Dundgovi",
"97613844", "Burentogtokh\,\ Khuvsgul",
"97614844", "Bugant\,\ Govi\-Altai",
"97615655", "Norovlin\,\ Khentii",
"97614558", "Khyargas\,\ Uvs",
"97624351", "Must\,\ Khovd",
"97624555", "Turgen\,\ Uvs",
"97613246", "Burd\,\ Uvurkhangai",
"97614246", "Buyant\,\ Bayan\-Ulgii",
"97623351", "Khairkhan\,\ Arkhangai",
"97624347", "Zereg\,\ Khovd",
"97623347", "Undur\-Ulaan\,\ Arkhangai",
"97613453", "Teshig\,\ Bulgan",
"97614453", "Gurvanbulag\,\ Bayankhongor",
"97614252", "Ulaankhus\,\ Bayan\-Ulgii",
"97613252", "Ulziit\,\ Uvurkhangai",
"9761422", "Ulgii\,\ Bayan\-Ulgii",
"9761322", "Arvaikheer\ city\,\ Uvurkhangai",
"97613359", "Erdenemandal\,\ Arkhangai",
"97625343", "Bulgan\,\ Umnugovi",
"97625941", "Adaatsag\,\ Dundgovi",
"97625657", "Tsenkhermandal\,\ Khentii",
"97622746", "Bayandelger\,\ Tuv",
"97625254", "Erdene\,\ Dornogovi",
"97625641", "Batnorov\,\ Khentii",
"97623348", "Tariat\,\ Arkhangai",
"97625149", "Tumentsogt\,\ Sukhbaatar",
"97624348", "Mankhan\,\ Khovd",
"97614557", "Khovd\,\ Uvs",
"97613541", "Jargalant\,\ Orkhon",
"97613345", "Ugii\-Nuur\,\ Arkhangai",
"97614345", "Durgun\,\ Khovd",
"97614541", "Baruunturuun\,\ Uvs",
"97615348", "Nomgon\,\ Umnugovi",
"97614856", "Chandmani\,\ Govi\-Altai",
"97613856", "Khankh\,\ Khuvsgul",
"97613742", "Khongor\,\ Darkhan\-Uul",
"97625345", "Mandal\-Ovoo\,\ Umnugovi",
"97625153", "Erdenetsagaan\,\ Sukhbaatar",
"97614455", "Jinst\,\ Bayankhongor",
"97613455", "Khishig\-Undur\,\ Bulgan",
"97613657", "Shaamar\,\ Selenge",
"97613254", "Taragt\,\ Uvurkhangai",
"97614657", "Tes\,\ Zavkhan",
"97613641", "Altanbulag\,\ Selenge",
"97624458", "Khureemaral\,\ Bayankhongor",
"97614641", "Aldarkhaan\,\ Zavkhan",
"97613449", "Rashaant\,\ Bulgan",
"97614449", "Bumbugur\,\ Bayankhongor",
"97614343", "Buyant\,\ Khovd",
"97613343", "Jargalant\,\ Arkhangai",
"97625252", "Khatanbulag\,\ Dornogovi",
"9762522", "Sainshand\ city\,\ Dornogovi",
"97625246", "Ikh\-Khet\,\ Dornogovi",
"97622754", "Bornuur\,\ Tuv",
"97615351", "Khanbogd\,\ Umnugovi",
"97612762", "Undurshereet\,\ Tuv",
"97615347", "Noyon\,\ Umnugovi",
"97623441", "Bayanagt\,\ Bulgan",
"97614658", "Urgamal\,\ Zavkhan",
"97614663", "Shiluustei\,\ Zavkhan",
"97624441", "Baatsagaan\,\ Bayankhongor",
"97624457", "Ulziit\,\ Bayankhongor",
"97624655", "Tudevtei\,\ Zavkhan",
"97625844", "Bulgan\,\ Dornod",
"97623655", "Hushaat\,\ Selenge",
"97623649", "Orkhontuul\,\ Selenge",
"97624649", "Ikh\-Uul\,\ Zavkhan",
"97624553", "Sagili\,\ Uvs",
"97615953", "Khuld\,\ Dundgovi",
"97613842", "Arbulag\,\ Khuvsgul",
"97614842", "Bayan\-Uul\,\ Govi\-Altai",
"97615653", "Jargaltkhaan\,\ Khentii",
"97625353", "Khurmen\,\ Umnugovi",
"97613443", "Bugat\,\ Bulgan",
"97624661", "Tsagaanchuluut\,\ Zavkhan",
"97614443", "Bayangovi\,\ Bayankhongor",
"97625145", "Naran\,\ Sukhbaatar",
"97614242", "Altantsugts\,\ Bayan\-Ulgii",
"97613242", "Bat\-Ulzii\,\ Uvurkhangai",
"97614349", "Munkhkhairkhan\,\ Khovd",
"97615148", "Tuvshin\-Shiree\,\ Sukhbaatar",
"97613349", "Tuvshruulekh\,\ Arkhangai",
"97623358", "Chuluut\,\ Arkhangai",
"97614547", "Malchin\,\ Uvs",
"97625846", "Dashbalbar\,\ Dornod",
"97613355", "Tsakhirt\,\ Arkhangai",
"97614551", "Umnugovi\,\ Uvs",
"97614355", "Tsetseg\,\ Khovd",
"97625951", "Undurshil\,\ Dundgovi",
"97625947", "Deren\,\ Dundgovi",
"97625647", "Binder\,\ Khentii",
"97622756", "Delgerkhaan\,\ Tuv",
"97625244", "Delgerekh\,\ Dornogovi",
"97625651", "Darkhan\,\ Khentii",
"97611", "Ulaanbaatar",
"97622742", "Argalant\,\ Tuv",
"97615151", "Uulbayan\,\ Sukhbaatar",
"97625852", "Tsagaan\-Ovoo\,\ Dornod",
"97615147", "Sukhbaatar\,\ Sukhbaatar",
"9762582", "Choibalsan\ city\,\ Dornod",
"97624559", "Tsagaankhairkhan\,\ Uvs",
"97623643", "Bayangol\,\ Selenge",
"97624643", "Bayantest\,\ Zavkhan",
"97614461", "Erdenetsogt\,\ Bayankhongor",
"97614548", "Naranbulag\,\ Uvs",
"97613256", "Uyanga\,\ Uvurkhangai",
"97624545", "Zuungovi\,\ Uvs",
"97624341", "Altai\,\ Khovd",
"97623341", "Battsengel\,\ Arkhangai",
"97624357", "Erdeneburen\,\ Khovd",
"97623357", "Tsetserleg\,\ Arkhangai",
"97625648", "Galshir\,\ Khentii",
"97615945", "Delgerkhangai\,\ Dundgovi",
"97623862", "Tsetserleg\,\ Khuvsgul",
"97613854", "Tunel\,\ Khuvsgul",
"97615645", "Bayan\-Ovoo\,\ Khentii",
"97614854", "Tsogt\,\ Govi\-Altai",
"97625948", "Luus\,\ Dundgovi",
"97624847", "Jargalan\,\ Govi\-Altai",
"97623847", "Ikh\-Uul\,\ Khuvsgul",
"97624851", "Tugrug\,\ Govi\-Altai",
"97623851", "Tarialan\,\ Khuvsgul",
"97623646", "Zuunburen\,\ Selenge",
"976123", "Nalaikh",
"97624646", "Durvuljin\,\ Zavkhan",
"97613344", "Ikh\-Tamir\,\ Arkhangai",
"97614344", "Darvi\,\ Khovd",
"9761442", "Bayankhongor\ city\,\ Bayankhongor",
"9761342", "Bulgan\ city\,\ Bulgan",
"97614452", "Galuut\,\ Bayankhongor",
"97613452", "Selenge\,\ Bulgan",
"97613253", "Sant\,\ Uvurkhangai",
"97614253", "Tsengel\,\ Bayan\-Ulgii",
"97625342", "Bayan\-Ovoo\,\ Umnugovi",
"97622767", "Erdene\,\ Tuv",
"97625249", "Saikhandulaan\,\ Dornogovi",
"97623848", "Rashaant\,\ Khuvsgul",
"97624848", "Taishir\,\ Govi\-Altai",
"97615954", "Tsagaandelger\,\ Dundgovi",
"97613845", "Galt\,\ Khuvsgul",
"97615654", "Murun\,\ Khentii",
"97614845", "Darvi\,\ Govi\-Altai",
"97615241", "Airag\,\ Dornogovi",
"97613446", "Dashinchilen\,\ Bulgan",
"97614446", "Bayan\-Undur\,\ Bayankhongor",
"97624554", "Tarialan\,\ Uvs",
"97624652", "Otgon\,\ Zavkhan",
"97614664", "Erdenekhaijkhan\,\ Zavkhan",
"97623652", "Sant\,\ Selenge",
"9762462", "Uliastal\ city\,\ Zavkhan",
"9762362", "Sukhbaatar\ city\,\ Selenge",
"97625843", "Bayan\-Uul\,\ Dornod",
"97612765", "Ugtaal\,\ Tuv",
"97613859", "Tsagaan\-Uul\,\ Khuvsgul",
"97622753", "Bayanchandmani\,\ Tuv",
"97622768", "Erdenesant\,\ Tuv",
"976121", "Baganuur",
"97625442", "Shivee\-Govi\,\ Govisumber",
"97625243", "Dalanjargalan\,\ Dornogovi",
"97613352", "Khahgai\,\ Arkhangai",
"97614352", "Myangad\,\ Khovd",
"97613259", "Khujirt\,\ Uvurkhangai",
"9761332", "Tsetserleg\ city\,\ Arkhangai",
"9761432", "Khovd\ city\,\ Khovd",
"97624248", "Nogoonnnuur\,\ Bayan\-Ulgii",
"97623248", "Zuil\,\ Uvurkhangai",
"97614444", "Bayanlig\,\ Bayankhongor",
"97613444", "Buregkhangai\,\ Bulgan",
"97625142", "Bayandelger\,\ Sukhbaatar",
"97614245", "Bulgan\,\ Bayan\-Ulgii",
"97624556", "Tes\,\ Uvs",
"97613245", "Bogd\,\ Uvurkhangai",
"97615841", "Bayandun\,\ Dornod",
"97615656", "Umnudelger\,\ Khentii",
"97612747", "Bayanjargal\,\ Tuv",
"97612751", "Bayantsagaan\,\ Tuv",
"97625354", "Tsogt\-Ovoo\,\ Umnugovi",
"97623865", "Erdenebulgan\,\ Khuvsgul",
"97615642", "Batshireet\,\ Khentii",
"97622759", "Lun\,\ Tuv",
"97615942", "Bayanjargalan\,\ Dundgovi",
"97614853", "Khukhmorit\,\ Govi\-Altai",
"97613853", "Tumurbulag\,\ Khuvsgul",
"97624542", "Bukhmurun\,\ Uvs",
"97625849", "Khalkhgol\,\ Dornod",
"97624644", "Bayankhairkhan\,\ Zavkhan",
"97623247", "Guchin\-Us\,\ Uvurkhangai",
"97623644", "Yereu\,\ Selenge",
"97624247", "Deluun\,\ Bayan\-Ulgii",
"97623251", "Naariinteel\,\ Uvurkhangai",
"97614346", "Duut\,\ Khovd",
"97624251", "Tolbo\,\ Bayan\-Ulgii",
"97613346", "Ulziit\,\ Arkhangai",
"97612748", "Bayan\-Unjuul\,\ Tuv",
"97622745", "Bayan\,\ Tuv",};
my $timezones = {
               '' => [
                       'Asia/Choibalsan',
                       'Asia/Hovd',
                       'Asia/Ulaanbaatar'
                     ],
               '11' => [
                         'Asia/Ulaanbaatar'
                       ],
               '12' => [
                         'Asia/Ulaanbaatar'
                       ],
               '13' => [
                         'Asia/Ulaanbaatar'
                       ],
               '1362' => [
                           'Asia/Choibalsan',
                           'Asia/Ulaanbaatar'
                         ],
               '14' => [
                         'Asia/Hovd'
                       ],
               '15' => [
                         'Asia/Ulaanbaatar'
                       ],
               '158' => [
                          'Asia/Choibalsan'
                        ],
               '21' => [
                         'Asia/Ulaanbaatar'
                       ],
               '22' => [
                         'Asia/Ulaanbaatar'
                       ],
               '23' => [
                         'Asia/Ulaanbaatar'
                       ],
               '2362' => [
                           'Asia/Choibalsan',
                           'Asia/Ulaanbaatar'
                         ],
               '24' => [
                         'Asia/Hovd'
                       ],
               '25' => [
                         'Asia/Ulaanbaatar'
                       ],
               '258' => [
                          'Asia/Choibalsan'
                        ],
               '5' => [
                        'Asia/Ulaanbaatar'
                      ],
               '6' => [
                        'Asia/Ulaanbaatar'
                      ],
               '7' => [
                        'Asia/Ulaanbaatar'
                      ],
               '8' => [
                        'Asia/Ulaanbaatar'
                      ],
               '9' => [
                        'Asia/Ulaanbaatar'
                      ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+976|\D)//g;
      my $self = bless({ country_code => '976', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '976', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;