#
# @file    TestModifierSpeciesReference.py
# @brief   ModifierSpeciesReference unit tests
#
# @author  Akiya Jouraku (Python conversion)
# @author  Ben Bornstein 
# 
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestModifierSpeciesReference.c
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------

import sys
import unittest
import libsbml


class TestModifierSpeciesReference(unittest.TestCase):

  global MSR
  MSR = None

  def setUp(self):
    self.MSR = libsbml.ModifierSpeciesReference(2,4)
    if (self.MSR == None):
      pass    
    pass  

  def tearDown(self):
    _dummyList = [ self.MSR ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ModifierSpeciesReference_create(self):
    self.assertTrue( self.MSR.getTypeCode() == libsbml.SBML_MODIFIER_SPECIES_REFERENCE )
    self.assertTrue( self.MSR.getMetaId() == "" )
    self.assertTrue( self.MSR.getNotes() == None )
    self.assertTrue( self.MSR.getAnnotation() == None )
    self.assertTrue( self.MSR.getSpecies() == "" )
    self.assertEqual( False, self.MSR.isSetSpecies() )
    self.assertEqual( True, self.MSR.isModifier() )
    pass  

  def test_ModifierSpeciesReference_createWithNS(self):
    xmlns = libsbml.XMLNamespaces()
    xmlns.add( "http://www.sbml.org", "testsbml")
    sbmlns = libsbml.SBMLNamespaces(2,1)
    sbmlns.addNamespaces(xmlns)
    object = libsbml.ModifierSpeciesReference(sbmlns)
    self.assertTrue( object.getTypeCode() == libsbml.SBML_MODIFIER_SPECIES_REFERENCE )
    self.assertTrue( object.getMetaId() == "" )
    self.assertTrue( object.getNotes() == None )
    self.assertTrue( object.getAnnotation() == None )
    self.assertTrue( object.getLevel() == 2 )
    self.assertTrue( object.getVersion() == 1 )
    self.assertTrue( object.getNamespaces() != None )
    n = object.getNamespaces()
    self.assertTrue( n.getLength() == 2 )
    _dummyList = [ object ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ModifierSpeciesReference_free_NULL(self):
    _dummyList = [ None ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_ModifierSpeciesReference_setSpecies(self):
    species =  "s1";
    self.MSR.setSpecies(species)
    s = self.MSR.getSpecies()
    self.assertTrue(( species == s ))
    self.assertEqual( True, self.MSR.isSetSpecies() )
    if (self.MSR.getSpecies() == species):
      pass    
    s = self.MSR.getSpecies()
    self.MSR.setSpecies(s)
    s = self.MSR.getSpecies()
    self.assertTrue(( species == s ))
    self.MSR.setSpecies("")
    self.assertEqual( False, self.MSR.isSetSpecies() )
    if (self.MSR.getSpecies() != None):
      pass    
    pass  

def suite():
  suite = unittest.TestSuite()
  suite.addTest(unittest.TestLoader.loadTestsFromTestCase(TestModifierSpeciesReference))

  return suite

if __name__ == "__main__":
  if unittest.TextTestRunner(verbosity=1).run(suite()).wasSuccessful() :
    sys.exit(0)
  else:
    sys.exit(1)

