/*
 * Decompiled with CFR 0.152.
 */
package com.vldocking.swing.docking;

import com.vldocking.swing.docking.BorderSplitter;
import com.vldocking.swing.docking.DockDropReceiver;
import com.vldocking.swing.docking.DockGroup;
import com.vldocking.swing.docking.DockViewTitleBar;
import com.vldocking.swing.docking.Dockable;
import com.vldocking.swing.docking.DockableContainerFactory;
import com.vldocking.swing.docking.DockableState;
import com.vldocking.swing.docking.DockingDesktop;
import com.vldocking.swing.docking.SingleDockableContainer;
import com.vldocking.swing.docking.TabbedDockableContainer;
import com.vldocking.swing.docking.event.DockDragEvent;
import com.vldocking.swing.docking.event.DockDropEvent;
import com.vldocking.swing.docking.event.DockEvent;
import com.vldocking.swing.docking.event.DockingActionCreateTabEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class DockView
extends JPanel
implements DockDropReceiver,
SingleDockableContainer {
    private static final long serialVersionUID = 1L;
    private static final String uiClassID = "DockViewUI";
    protected DockViewTitleBar title = this.getTitleBar();
    protected DockingDesktop desktop;
    protected Dockable dockable;
    protected Shape lastDropShape;
    protected Shape lastDropGeneralPath;
    private PropertyChangeListener listener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("DockTitle.AUTOHIDE")) {
                if (!e.getOldValue().equals(Boolean.TRUE)) {
                    DockView.this.desktop.setAutoHide(DockView.this.dockable, true);
                }
            } else if (e.getPropertyName().equals("DockTitle.CLOSED")) {
                DockView.this.desktop.close(DockView.this.dockable);
            } else if (e.getPropertyName().equals("DockTitle.MAXIMIZED")) {
                if (e.getNewValue().equals(Boolean.TRUE)) {
                    DockView.this.desktop.maximize(DockView.this.dockable);
                } else {
                    DockView.this.desktop.restore(DockView.this.dockable);
                }
            } else if (e.getPropertyName().equals("DockTitle.FLOAT")) {
                DockView.this.desktop.setFloating(DockView.this.dockable, (Boolean)e.getNewValue());
            }
        }
    };

    public DockView() {
        super(new BorderLayout());
        this.add((Component)this.title, "North");
    }

    public DockView(Dockable dockable) {
        this();
        this.setDockable(dockable);
    }

    public DockView(Dockable dockable, boolean showTitle) {
        super(new BorderLayout());
        this.add((Component)this.title, "North");
        if (!showTitle) {
            this.title.setVisible(false);
        }
        this.setDockable(dockable);
    }

    @Override
    public Dockable getDockable() {
        return this.dockable;
    }

    public void setDockable(Dockable dockable) {
        this.dockable = dockable;
        this.add(dockable.getComponent(), "Center");
        if (this.title != null) {
            this.title.setDockable(dockable);
        }
        this.setMinimumSize(new Dimension(30, 30));
    }

    @Override
    public String toString() {
        return "DockView of " + this.dockable.getDockKey();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void processDockableDrag(DockDragEvent event) {
        this.scanDrop(event, false);
    }

    @Override
    public void processDockableDrop(DockDropEvent event) {
        this.scanDrop(event, true);
    }

    protected void scanDrop(DockEvent event, boolean drop) {
        boolean accepted;
        if (event.getDragSource().getDockableContainer().isAncestorOf(this)) {
            if (drop) {
                ((DockDropEvent)event).rejectDrop();
            } else {
                ((DockDragEvent)event).delegateDrag();
            }
            return;
        }
        if (this.getParent() instanceof TabbedDockableContainer) {
            if (drop) {
                ((DockDropEvent)event).rejectDrop();
            } else {
                ((DockDragEvent)event).delegateDrag();
            }
            return;
        }
        if (event.getDragSource().getDockable() == this.dockable) {
            if (drop) {
                ((DockDropEvent)event).rejectDrop();
            } else {
                ((DockDragEvent)event).rejectDrag();
            }
            return;
        }
        Rectangle bounds = this.getBounds();
        BorderSplitter splitter = new BorderSplitter(this);
        if (drop) {
            splitter.processDockableDrop((DockDropEvent)event);
            accepted = ((DockDropEvent)event).isDropAccepted();
        } else {
            splitter.processDockableDrag((DockDragEvent)event);
            accepted = ((DockDragEvent)event).isDragAccepted();
        }
        if (!accepted) {
            DockGroup dragGroup;
            if (event.getDragSource().getDockableContainer() instanceof TabbedDockableContainer) {
                if (drop) {
                    ((DockDropEvent)event).rejectDrop();
                } else {
                    ((DockDragEvent)event).rejectDrag();
                }
                return;
            }
            DockGroup thisGroup = this.dockable.getDockKey().getDockGroup();
            if (!DockGroup.areGroupsCompatible(thisGroup, dragGroup = event.getDragSource().getDockable().getDockKey().getDockGroup())) {
                if (drop) {
                    ((DockDropEvent)event).rejectDrop();
                } else {
                    ((DockDragEvent)event).rejectDrag();
                }
                return;
            }
            Dockable d = event.getDragSource().getDockable();
            DockableState.Location dockableLocation = d.getDockKey().getLocation();
            DockableState.Location viewLocation = this.dockable.getDockKey().getLocation();
            if (drop) {
                event.setDockingAction(new DockingActionCreateTabEvent(event.getDesktop(), d, dockableLocation, viewLocation, this.dockable, 0));
                ((DockDropEvent)event).acceptDrop();
                this.desktop.createTab(this.dockable, event.getDragSource().getDockable(), 0, true);
            } else {
                event.setDockingAction(new DockingActionCreateTabEvent(event.getDesktop(), d, dockableLocation, viewLocation, this.dockable, 0));
                Rectangle2D.Float r2d = new Rectangle2D.Float(bounds.x, bounds.y, bounds.width, bounds.height);
                if (r2d.equals(this.lastDropShape)) {
                    ((DockDragEvent)event).acceptDrag(this.lastDropGeneralPath);
                } else {
                    GeneralPath path = this.buildPathForTab(bounds);
                    this.lastDropShape = r2d;
                    this.lastDropGeneralPath = path;
                    ((DockDragEvent)event).acceptDrag(this.lastDropGeneralPath);
                }
            }
        }
    }

    protected GeneralPath buildPathForTab(Rectangle bounds) {
        GeneralPath path = new GeneralPath();
        int tabPlacement = UIManager.getInt("TabbedDockableContainer.tabPlacement");
        if (tabPlacement == 3) {
            Rectangle tabRect = new Rectangle(0, 0, bounds.width - 5, bounds.height - 5);
            path.moveTo(tabRect.x, tabRect.y);
            path.lineTo(tabRect.x + tabRect.width, tabRect.y);
            path.lineTo(tabRect.x + tabRect.width, tabRect.y + tabRect.height - 15);
            path.lineTo(tabRect.x + 30, tabRect.y + tabRect.height - 15);
            path.lineTo(tabRect.x + 25, tabRect.y + tabRect.height);
            path.lineTo(tabRect.x + 10, tabRect.y + tabRect.height);
            path.lineTo(tabRect.x + 10, tabRect.y + tabRect.height - 15);
            path.lineTo(tabRect.x, tabRect.y + tabRect.height - 15);
            path.closePath();
        } else {
            Rectangle tabRect = new Rectangle(0, 20, bounds.width - 5, bounds.height - 20 - 5);
            path.moveTo(tabRect.x, tabRect.y);
            path.lineTo(tabRect.x + 10, tabRect.y);
            path.lineTo(tabRect.x + 10, tabRect.y - 15);
            path.lineTo(tabRect.x + 25, tabRect.y - 15);
            path.lineTo(tabRect.x + 30, tabRect.y);
            path.lineTo(tabRect.x + tabRect.width, tabRect.y);
            path.lineTo(tabRect.x + tabRect.width, tabRect.y + tabRect.height);
            path.lineTo(tabRect.x, tabRect.y + tabRect.height);
            path.closePath();
        }
        return path;
    }

    @Override
    public void installDocking(DockingDesktop desktop) {
        this.desktop = desktop;
        desktop.installDockableDragSource(this.title);
        this.title.addPropertyChangeListener("DockTitle.AUTOHIDE", this.listener);
        this.title.addPropertyChangeListener("DockTitle.CLOSED", this.listener);
        this.title.addPropertyChangeListener("DockTitle.MAXIMIZED", this.listener);
        this.title.addPropertyChangeListener("DockTitle.FLOAT", this.listener);
        this.title.installDocking(desktop);
    }

    @Override
    public void uninstallDocking(DockingDesktop desktop) {
        if (this.title != null) {
            desktop.uninstallDockableDragSource(this.title);
            this.title.removePropertyChangeListener("DockTitle.AUTOHIDE", this.listener);
            this.title.removePropertyChangeListener("DockTitle.CLOSED", this.listener);
            this.title.removePropertyChangeListener("DockTitle.MAXIMIZED", this.listener);
            this.title.removePropertyChangeListener("DockTitle.FLOAT", this.listener);
            this.title.uninstallDocking(desktop);
        }
        this.title = null;
        this.desktop = null;
    }

    public DockViewTitleBar getTitleBar() {
        if (this.title == null) {
            this.title = DockableContainerFactory.getFactory().createTitleBar();
        }
        return this.title;
    }
}

