package org.apache.maven.shared.dependency.graph.filter;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.maven.shared.dependency.graph.DependencyNode;

/**
 * Defines a filter for dependency nodes.
 * 
 * @author <a href="mailto:markhobson@gmail.com">Mark Hobson</a>
 * @version $Id: DependencyNodeFilter.java 1351166 2012-06-17 21:15:54Z hboutemy $
 * @since 1.1
 */
public interface DependencyNodeFilter
{
    /**
     * Gets whether this filter accepts the specified dependency node.
     * 
     * @param node
     *            the dependency node to check
     * @return <code>true</code> if this filter accepts the specified dependency node
     */
    boolean accept( DependencyNode node );
}
