_G.core = {}
dofile("builtin/common/misc_helpers.lua")

describe("string", function()
	it("trim()", function()
		assert.equal("foo bar", string.trim("\n \t\tfoo bar\t "))
	end)

	describe("split()", function()
		it("removes empty", function()
			assert.same({ "hello" }, string.split("hello"))
			assert.same({ "hello", "world" }, string.split("hello,world"))
			assert.same({ "hello", "world" }, string.split("hello,world,,,"))
			assert.same({ "hello", "world" }, string.split(",,,hello,world"))
			assert.same({ "hello", "world", "2" }, string.split("hello,,,world,2"))
			assert.same({ "hello ", " world" }, string.split("hello :| world", ":|"))
		end)

		it("keeps empty", function()
			assert.same({ "hello" }, string.split("hello", ",", true))
			assert.same({ "hello", "world" }, string.split("hello,world", ",", true))
			assert.same({ "hello", "world", "" }, string.split("hello,world,", ",", true))
			assert.same({ "hello", "", "", "world", "2" }, string.split("hello,,,world,2", ",", true))
			assert.same({ "", "", "hello", "world", "2" }, string.split(",,hello,world,2", ",", true))
			assert.same({ "hello ", " world | :" }, string.split("hello :| world | :", ":|"))
		end)

		it("max_splits", function()
			assert.same({ "one" }, string.split("one", ",", true, 2))
			assert.same({ "one,two,three,four" }, string.split("one,two,three,four", ",", true, 0))
			assert.same({ "one", "two", "three,four" }, string.split("one,two,three,four", ",", true, 2))
			assert.same({ "one", "", "two,three,four" }, string.split("one,,two,three,four", ",", true, 2))
			assert.same({ "one", "two", "three,four" }, string.split("one,,,,,,two,three,four", ",", false, 2))
		end)

		it("pattern", function()
			assert.same({ "one", "two" }, string.split("one,two", ",", false, -1, true))
			assert.same({ "one", "two", "three" }, string.split("one2two3three", "%d", false, -1, true))
		end)
	end)
end)

describe("privs", function()
	it("from string", function()
		assert.same({ a = true, b = true }, core.string_to_privs("a,b"))
	end)

	it("to string", function()
		assert.equal("one", core.privs_to_string({ one=true }))

		local ret = core.privs_to_string({ a=true, b=true })
		assert(ret == "a,b" or ret == "b,a")
	end)
end)

describe("pos", function()
	it("from string", function()
		assert.same({ x = 10, y = 5.1, z = -2}, core.string_to_pos("10.0, 5.1, -2"))
		assert.same({ x = 10, y = 5.1, z = -2}, core.string_to_pos("( 10.0, 5.1, -2)"))
		assert.is_nil(core.string_to_pos("asd, 5, -2)"))
	end)

	it("to string", function()
		assert.equal("(10.1,5.2,-2.3)", core.pos_to_string({ x = 10.1, y = 5.2, z = -2.3}))
	end)
end)

describe("table", function()
	it("indexof()", function()
		assert.equal(1, table.indexof({"foo", "bar"}, "foo"))
		assert.equal(-1, table.indexof({"foo", "bar"}, "baz"))
	end)
end)
