/*

	strmiids.c - DirectShow GUIDs

	Written by Filip Navara <xnavara@volny.cz>

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

*/

#if defined(__LCC__) || defined(__GNUC__)
#define INITGUID 1
#include <windows.h>
#else
#include <basetyps.h>
#endif 

DEFINE_GUID(CLSID_AMAudioData,0xf2468580,0xaf8a,0x11d0,0x82,0x12,0x00,0xc0,0x4f,0xc3,0x2c,0x45);
DEFINE_GUID(CLSID_AMAudioStream,0x8496e040,0xaf4c,0x11d0,0x82,0x12,0x00,0xc0,0x4f,0xc3,0x2c,0x45);
DEFINE_GUID(CLSID_AMDirectDrawStream,0x49c47ce4,0x9ba4,0x11d0,0x82,0x12,0x00,0xc0,0x4f,0xc3,0x2c,0x45);
DEFINE_GUID(CLSID_AMMediaTypeStream,0xcf0f2f7c,0xf7bf,0x11d0,0x90,0xd,0x0,0xc0,0x4f,0xd9,0x18,0x9d);
DEFINE_GUID(MSPID_PrimaryAudio,0xa35ff56b,0x9fda,0x11d0,0x8f,0xdf,0x0,0xc0,0x4f,0xd9,0x18,0x9d);
DEFINE_GUID(MSPID_PrimaryVideo,0xa35ff56a,0x9fda,0x11d0,0x8f,0xdf,0x0,0xc0,0x4f,0xd9,0x18,0x9d);
DEFINE_GUID(AM_INTERFACESETID_Standard,0x1a8766a0l,0x62ce,0x11cf,0xa5,0xd6,0x28,0xdb,0x04,0xc1,0x00,0x00);
DEFINE_GUID(AM_KSCATEGORY_AUDIO,0x6994ad04,0x93ef,0x11d0,0xa3,0xcc,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(AM_KSCATEGORY_CAPTURE,0x65e8773d,0x8f56,0x11d0,0xa3,0xb9,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(AM_KSCATEGORY_CROSSBAR,0xa799a801,0xa46d,0x11d0,0xa1,0x8c,0x00,0xa0,0x24,0x01,0xdc,0xd4);
DEFINE_GUID(AM_KSCATEGORY_DATACOMPRESSOR,0x1e84c900,0x7e70,0x11d0,0xa5,0xd6,0x28,0xdb,0x04,0xc1,0x00,0x00);
DEFINE_GUID(AM_KSCATEGORY_RENDER,0x65e8773e,0x8f56,0x11d0,0xa3,0xb9,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(AM_KSCATEGORY_SPLITTER,0x0a4252a0,0x7e70,0x11d0,0xa5,0xd6,0x28,0xdb,0x04,0xc1,0x00,0x00);
DEFINE_GUID(AM_KSCATEGORY_TVAUDIO,0xa799a802,0xa46d,0x11d0,0xa1,0x8c,0x00,0xa0,0x24,0x01,0xdc,0xd4);
DEFINE_GUID(AM_KSCATEGORY_TVTUNER,0xa799a800,0xa46d,0x11d0,0xa1,0x8c,0x00,0xa0,0x24,0x01,0xdc,0xd4);
DEFINE_GUID(AM_KSCATEGORY_VBICODEC,0x07dad660,0x22f1,0x11d1,0xa9,0xf4,0x00,0xc0,0x4f,0xbb,0xde,0x8f);
DEFINE_GUID(AM_KSCATEGORY_VIDEO,0x6994ad05,0x93ef,0x11d0,0xa3,0xcc,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(AM_KSPROPSETID_AC3,0xbfabe720,0x6e1f,0x11d0,0xbc,0xf2,0x44,0x45,0x53,0x54,0x00,0x00);
DEFINE_GUID(AM_KSPROPSETID_CopyProt,0x0e8a0a40,0x6aef,0x11d0,0x9e,0xd0,0x00,0xa0,0x24,0xca,0x19,0xb3);
DEFINE_GUID(AM_KSPROPSETID_DVD_RateChange,0x3577eb09,0x9582,0x477f,0xb2,0x9c,0xb0,0xc4,0x52,0xa4,0xff,0x9a);
DEFINE_GUID(AM_KSPROPSETID_DvdKaraoke,0xae4720ae,0xaa71,0x42d8,0xb8,0x2a,0xff,0xfd,0xf5,0x8b,0x76,0xfd);
DEFINE_GUID(AM_KSPROPSETID_DvdSubPic,0xac390460,0x43af,0x11d0,0xbd,0x6a,0x00,0x35,0x05,0xc1,0x03,0xa9);
DEFINE_GUID(AM_KSPROPSETID_FrameStep,0xc830acbd,0xab07,0x492f,0x88,0x52,0x45,0xb6,0x98,0x7c,0x29,0x79);
DEFINE_GUID(AM_KSPROPSETID_TSRateChange,0xa503c5c0,0x1d1d,0x11d1,0xad,0x80,0x44,0x45,0x53,0x54,0x0,0x0);
DEFINE_GUID(AMPROPSETID_Pin,0x9b00f101,0x1567,0x11d1,0xb3,0xf1,0x0,0xaa,0x0,0x37,0x61,0xc5);
DEFINE_GUID(CLSID_ACMWrapper,0x6a08cf80,0x0e18,0x11cf,0xa2,0x4d,0x0,0x20,0xaf,0xd7,0x97,0x67);
DEFINE_GUID(CLSID_ActiveMovieCategories,0xda4e3da0,0xd07d,0x11d0,0xbd,0x50,0x0,0xa0,0xc9,0x11,0xce,0x86);
DEFINE_GUID(CLSID_AllocPresenter,0x99d54f63,0x1a69,0x41ae,0xaa,0x4d,0xc9,0x76,0xeb,0x3f,0x07,0x13);
DEFINE_GUID(CLSID_AllocPresenterDDXclMode,0x4444ac9e,0x242e,0x471b,0xa3,0xc7,0x45,0xdc,0xd4,0x63,0x52,0xbc);
DEFINE_GUID(CLSID_AMMultiMediaStream,0x49c47ce5,0x9ba4,0x11d0,0x82,0x12,0x00,0xc0,0x4f,0xc3,0x2c,0x45);
DEFINE_GUID(CLSID_AMovie,0x5f2759c0,0x7685,0x11cf,0x8b,0x23,0x00,0x80,0x5f,0x6c,0xef,0x60);
DEFINE_GUID(CLSID_AMTimeline,0x78530b75,0x61f9,0x11d2,0x8c,0xad,0x00,0xa0,0x24,0x58,0x09,0x02);
DEFINE_GUID(CLSID_AMTimelineComp,0x74d2ec80,0x6233,0x11d2,0x8c,0xad,0x00,0xa0,0x24,0x58,0x09,0x02);
DEFINE_GUID(CLSID_AMTimelineEffect,0x74d2ec82,0x6233,0x11d2,0x8c,0xad,0x00,0xa0,0x24,0x58,0x09,0x02);
DEFINE_GUID(CLSID_AMTimelineGroup,0xf6d371e1,0xb8a6,0x11d2,0x80,0x23,0x00,0xc0,0xdf,0x10,0xd4,0x34);
DEFINE_GUID(CLSID_AMTimelineObj,0x78530b78,0x61f9,0x11d2,0x8c,0xad,0x00,0xa0,0x24,0x58,0x09,0x02);
DEFINE_GUID(CLSID_AMTimelineSrc,0x78530b7a,0x61f9,0x11d2,0x8c,0xad,0x00,0xa0,0x24,0x58,0x09,0x02);
DEFINE_GUID(CLSID_AMTimelineTrack,0x8f6c3c50,0x897b,0x11d2,0x8c,0xfb,0x00,0xa0,0xc9,0x44,0x1e,0x20);
DEFINE_GUID(CLSID_AMTimelineTrans,0x74d2ec81,0x6233,0x11d2,0x8c,0xad,0x00,0xa0,0x24,0x58,0x09,0x02);
DEFINE_GUID(CLSID_AnalogRadioTuningSpace,0x8a674b4c,0x1f63,0x11d3,0xb6,0x4c,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(CLSID_AnalogTVTuningSpace,0x8a674b4d,0x1f63,0x11d3,0xb6,0x4c,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(CLSID_AnalogVideoDecoderPropertyPage,0x71f96466,0x78f3,0x11d0,0xa1,0x8c,0x0,0xa0,0xc9,0x11,0x89,0x56);
DEFINE_GUID(CLSID_AsyncReader,0xe436ebb5,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(CLSID_ATSCComponentType,0xa8dcf3d5,0x0780,0x4ef4,0x8a,0x83,0x2c,0xff,0xaa,0xcb,0x8a,0xce);
DEFINE_GUID(CLSID_ATSCChannelTuneRequest,0x0369b4e6,0x45b6,0x11d3,0xb6,0x50,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(CLSID_ATSCLocator,0x8872ff1b,0x98fa,0x4d7a,0x8d,0x93,0xc9,0xf1,0x05,0x5f,0x85,0xbb);
DEFINE_GUID(CLSID_ATSCNetworkPropertyPage,0xe3444d16,0x5ac4,0x4386,0x88,0xdf,0x13,0xfd,0x23,0x0e,0x1d,0xda);
DEFINE_GUID(CLSID_ATSCNetworkProvider,0x0dad2fdd,0x5fd7,0x11d3,0x8f,0x50,0x00,0xc0,0x4f,0x79,0x71,0xe2);
DEFINE_GUID(CLSID_ATSCTuningSpace,0xa2e30750,0x6c3d,0x11d3,0xb6,0x53,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(CLSID_AudioCompressorCategory,0x33d9a761,0x90c8,0x11d0,0xbd,0x43,0x00,0xa0,0xc9,0x11,0xce,0x86);
DEFINE_GUID(CLSID_AudioInputDeviceCategory,0x33d9a762,0x90c8,0x11d0,0xbd,0x43,0x00,0xa0,0xc9,0x11,0xce,0x86);
DEFINE_GUID(CLSID_AudioInputMixerProperties,0x2ca8ca52,0x3c3f,0x11d2,0xb7,0x3d,0x00,0xc0,0x4f,0xb6,0xbd,0x3d);
DEFINE_GUID(CLSID_AudioProperties,0x05589faf,0xc356,0x11ce,0xbf,0x01,0x00,0xaa,0x00,0x55,0x59,0x5a);
DEFINE_GUID(CLSID_AudioRecord,0xe30629d2,0x27e5,0x11ce,0x87,0x5d,0x00,0x60,0x8c,0xb7,0x80,0x66);
DEFINE_GUID(CLSID_AudioRender,0xe30629d1,0x27e5,0x11ce,0x87,0x5d,0x00,0x60,0x8c,0xb7,0x80,0x66);
DEFINE_GUID(CLSID_AudioRendererAdvancedProperties,0x37e92a92,0xd9aa,0x11d2,0xbf,0x84,0x8e,0xf2,0xb1,0x55,0x5a,0xed);
DEFINE_GUID(CLSID_AudioRendererCategory,0xe0f158e1,0xcb04,0x11d0,0xbd,0x4e,0x00,0xa0,0xc9,0x11,0xce,0x86);
DEFINE_GUID(CLSID_AudMixer,0x036a9790,0xc153,0x11d2,0x9e,0xf7,0x00,0x60,0x08,0x03,0x9e,0x37);
DEFINE_GUID(CLSID_AuxInTuningSpace,0xf9769a06,0x7aca,0x4e39,0x9c,0xfb,0x97,0xbb,0x35,0xf0,0xe7,0x7e);
DEFINE_GUID(CLSID_AVICo,0xd76e2820,0x1563,0x11cf,0xac,0x98,0x00,0xaa,0x00,0x4c,0x0f,0xa9);
DEFINE_GUID(CLSID_AVIDec,0xcf49d4e0,0x1115,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(CLSID_AviDest,0xe2510970,0xf137,0x11ce,0x8b,0x67,0x00,0xaa,0x00,0xa3,0xf1,0xa6);
DEFINE_GUID(CLSID_AVIDoc,0xd3588ab0,0x0781,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(CLSID_AVIDraw,0xa888df60,0x1e90,0x11cf,0xac,0x98,0x00,0xaa,0x00,0x4c,0x0f,0xa9);
DEFINE_GUID(CLSID_AVIMIDIRender,0x07b65360,0xc445,0x11ce,0xaf,0xde,0x00,0xaa,0x00,0x6c,0x14,0xf4);
DEFINE_GUID(CLSID_AviMuxProptyPage,0xc647b5c0,0x157c,0x11d0,0xbd,0x23,0x00,0xa0,0xc9,0x11,0xce,0x86);
DEFINE_GUID(CLSID_AviMuxProptyPage1,0xc647b5c0,0x157c,0x11d0,0xbd,0x23,0x00,0xa0,0xc9,0x11,0xce,0x86);
DEFINE_GUID(CLSID_AviReader,0x1b544c21,0xfd0b,0x11ce,0x8c,0x63,0x00,0xaa,0x00,0x44,0xb5,0x1e);
DEFINE_GUID(CLSID_AviSplitter,0x1b544c20,0xfd0b,0x11ce,0x8c,0x63,0x00,0xaa,0x00,0x44,0xb5,0x1e);
DEFINE_GUID(CLSID_BroadcastEventService,0x0b3ffb92,0x0919,0x4934,0x9d,0x5b,0x61,0x9c,0x71,0x9d,0x02,0x02);
DEFINE_GUID(CLSID_CAcmCoClassManager,0x33d9a761,0x90c8,0x11d0,0xbd,0x43,0x00,0xa0,0xc9,0x11,0xce,0x86);
DEFINE_GUID(CLSID_CADefaultDlg,0x11166990,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(CLSID_CADenials,0x11166540,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(CLSID_CAManager,0x11166100,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(CLSID_CAManagerProxy,0x11166101,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(CLSID_CameraControlPropertyPage,0x71f96465,0x78f3,0x11d0,0xa1,0x8c,0x00,0xa0,0xc9,0x11,0x89,0x56);
DEFINE_GUID(CLSID_CAOffer,0x11166550,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(CLSID_CaptureGraphBuilder,0xbf87b6e0,0x8c27,0x11d0,0xb3,0xf0,0x00,0xaa,0x00,0x37,0x61,0xc5);
DEFINE_GUID(CLSID_CaptureGraphBuilder2,0xbf87b6e1,0x8c27,0x11d0,0xb3,0xf0,0x00,0xaa,0x00,0x37,0x61,0xc5);
DEFINE_GUID(CLSID_CaptureProperties,0x1b544c22,0xfd0b,0x11ce,0x8c,0x63,0x00,0xaa,0x00,0x44,0xb5,0x1f);
DEFINE_GUID(CLSID_CAResDenialTree,0x11166998,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(CLSID_CDeviceMoniker,0x4315d437,0x5b8c,0x11d0,0xbd,0x3b,0x00,0xa0,0xc9,0x11,0xce,0x86);
DEFINE_GUID(CLSID_CIcmCoClassManager,0x33d9a760,0x90c8,0x11d0,0xbd,0x43,0x00,0xa0,0xc9,0x11,0xce,0x86);
DEFINE_GUID(CLSID_CMidiOutClassManager,0x4efe2452,0x168a,0x11d1,0xbc,0x76,0x00,0xc0,0x4f,0xb9,0x45,0x3b);
DEFINE_GUID(CLSID_CMpegAudioCodec,0x4a2286e0,0x7bef,0x11ce,0x9b,0xd9,0x00,0x00,0xe2,0x02,0x59,0x9c);
DEFINE_GUID(CLSID_CMpegVideoCodec,0xfeb50740,0x7bef,0x11ce,0x9b,0xd9,0x00,0x00,0xe2,0x02,0x59,0x9c);
DEFINE_GUID(CLSID_ColorSource,0x0cfdd070,0x581a,0x11d2,0x9e,0xe6,0x00,0x60,0x08,0x03,0x9e,0x37);
DEFINE_GUID(CLSID_Colour,0x1643e180,0x90f5,0x11ce,0x97,0xd5,0x00,0xaa,0x00,0x55,0x59,0x5a);
DEFINE_GUID(CLSID_Component,0x59dc47a8,0x116c,0x11d3,0x9d,0x8e,0x00,0xc0,0x4f,0x72,0xd9,0x80);
DEFINE_GUID(CLSID_Components,0x809b6661,0x94c4,0x49e6,0xb6,0xec,0x3f,0x0f,0x86,0x22,0x15,0xaa);
DEFINE_GUID(CLSID_ComponentType,0x823535a0,0x0318,0x11d3,0x9d,0x8e,0x00,0xc0,0x4f,0x72,0xd9,0x80);
DEFINE_GUID(CLSID_ComponentTypes,0xa1a2b1c4,0x0e3a,0x11d3,0x9d,0x8e,0x00,0xc0,0x4f,0x72,0xd9,0x80);
DEFINE_GUID(CLSID_CQzFilterClassManager,0x083863f1,0x70de,0x11d0,0xbd,0x40,0x00,0xa0,0xc9,0x11,0xce,0x86);
DEFINE_GUID(CLSID_CreatePropBagOnRegKey,0x8a674b49,0x1f63,0x11d3,0xb6,0x4c,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(CLSID_CrossbarFilterPropertyPage,0x71f96461,0x78f3,0x11d0,0xa1,0x8c,0x00,0xa0,0xc9,0x11,0x89,0x56);
DEFINE_GUID(CLSID_CVidCapClassManager,0x860bb310,0x5d01,0x11d0,0xbd,0x3b,0x00,0xa0,0xc9,0x11,0xce,0x86);
DEFINE_GUID(CLSID_CWaveinClassManager,0x33d9a762,0x90c8,0x11d0,0xbd,0x43,0x00,0xa0,0xc9,0x11,0xce,0x86);
DEFINE_GUID(CLSID_CWaveOutClassManager,0xe0f158e1,0xcb04,0x11d0,0xbd,0x4e,0x00,0xa0,0xc9,0x11,0xce,0x86);
DEFINE_GUID(CLSID_DeviceControlCategory,0xcc7bfb46,0xf175,0x11d1,0xa3,0x92,0x00,0xe0,0x29,0x1f,0x39,0x59);
DEFINE_GUID(CLSID_DirectDraw,0xd7b70ee0,0x4340,0x11cf,0xb0,0x63,0x00,0x20,0xaf,0xc2,0xcd,0x35);
DEFINE_GUID(CLSID_DirectDrawClipper,0x593817a0,0x7db3,0x11cf,0xa2,0xde,0x00,0xaa,0x00,0xb9,0x33,0x56);
DEFINE_GUID(CLSID_DirectDrawProperties,0x944d4c00,0xdd52,0x11ce,0xbf,0x0e,0x00,0xaa,0x00,0x55,0x59,0x5a);
DEFINE_GUID(CLSID_Dither,0x1da08500,0x9edc,0x11cf,0xbc,0x10,0x00,0xaa,0x00,0xac,0x74,0xf6);
DEFINE_GUID(CLSID_DShowTVEFilter,0x05500280,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(CLSID_DSoundRender,0x79376820,0x07d0,0x11cf,0xa2,0x4d,0x00,0x20,0xaf,0xd7,0x97,0x67);
DEFINE_GUID(CLSID_DTFilter,0xc4c4c4f2,0x49,0x4e2b,0x98,0xfb,0x95,0x37,0xf6,0xce,0x51,0x6d);
DEFINE_GUID(CLSID_DVBCLocator,0xc531d9fd,0x9685,0x4028,0x8b,0x68,0x6e,0x12,0x32,0x07,0x9f,0x1e);
DEFINE_GUID(CLSID_DVBCNetworkProvider,0xdc0c0fe7,0x485,0x4266,0xb9,0x3f,0x68,0xfb,0xf8,0xe,0xd8,0x34);
DEFINE_GUID(CLSID_DVBSLocator,0x1df7d126,0x4050,0x47f0,0xa7,0xcf,0x4c,0x4c,0xa9,0x24,0x13,0x33);
DEFINE_GUID(CLSID_DVBSNetworkProvider,0xfa4b375a,0x45b4,0x4d45,0x84,0x40,0x26,0x39,0x57,0xb1,0x16,0x23);
DEFINE_GUID(CLSID_DVBSTuningSpace,0xb64016f3,0xc9a2,0x4066,0x96,0xf0,0xbd,0x95,0x63,0x31,0x47,0x26);
DEFINE_GUID(CLSID_DVBTLocator,0x9cd64701,0xbdf3,0x4d14,0x8e,0x03,0xf1,0x29,0x83,0xd8,0x66,0x64);
DEFINE_GUID(CLSID_DVBTNetworkProvider,0x216c62df,0x6d7f,0x4e9a,0x85,0x71,0x5,0xf1,0x4e,0xdb,0x76,0x6a);
DEFINE_GUID(CLSID_DVBTuneRequest,0x15d6504a,0x5494,0x499c,0x88,0x6c,0x97,0x3c,0x9e,0x53,0xb9,0xf1);
DEFINE_GUID(CLSID_DVBTuningSpace,0xc6b14b32,0x76aa,0x4a86,0xa7,0xac,0x5c,0x79,0xaa,0xf5,0x8d,0xa7);
DEFINE_GUID(CLSID_DVDecPropertiesPage,0x101193c0,0x0bfe,0x11d0,0xaf,0x91,0x00,0xaa,0x00,0xb6,0x7a,0x42);
DEFINE_GUID(CLSID_DvdGraphBuilder,0xfcc152b7,0xf372,0x11d0,0x8e,0x00,0x00,0xc0,0x4f,0xd7,0xc0,0x8b);
DEFINE_GUID(CLSID_DVDHWDecodersCategory,0x2721ae20,0x7e70,0x11d0,0xa5,0xd6,0x28,0xdb,0x04,0xc1,0x00,0x00);
DEFINE_GUID(CLSID_DVDNavigator,0x9b8c4620,0x2c1a,0x11d0,0x84,0x93,0x00,0xa0,0x24,0x38,0xad,0x48);
DEFINE_GUID(CLSID_DVDState,0xf963c5cf,0xa659,0x4a93,0x96,0x38,0xca,0xf3,0xcd,0x27,0x7d,0x13);
DEFINE_GUID(CLSID_DVEncPropertiesPage,0x4150f050,0xbb6f,0x11d0,0xaf,0xb9,0x00,0xaa,0x00,0xb6,0x7a,0x42);
DEFINE_GUID(CLSID_DVMux,0x129d7e40,0xc10d,0x11d0,0xaf,0xb9,0x00,0xaa,0x00,0xb6,0x7a,0x42);
DEFINE_GUID(CLSID_DVMuxPropertyPage,0x4db880e0,0xc10d,0x11d0,0xaf,0xb9,0x00,0xaa,0x00,0xb6,0x7a,0x42);
DEFINE_GUID(CLSID_DVSplitter,0x4eb31670,0x9fc6,0x11cf,0xaf,0x6e,0x00,0xaa,0x00,0xb6,0x7a,0x42);
DEFINE_GUID(CLSID_DVVideoCodec,0xb1b77c00,0xc3e4,0x11cf,0xaf,0x79,0x00,0xaa,0x00,0xb6,0x7a,0x42);
DEFINE_GUID(CLSID_DVVideoEnc,0x13aa3650,0xbb6f,0x11d0,0xaf,0xb9,0x00,0xaa,0x00,0xb6,0x7a,0x42);
DEFINE_GUID(CLSID_DxtAlphaSetter,0x506d89ae,0x909a,0x44f7,0x94,0x44,0xab,0xd5,0x75,0x89,0x6e,0x35);
DEFINE_GUID(CLSID_DxtCompositor,0xbb44391d,0x6abd,0x422f,0x9e,0x2e,0x38,0x5c,0x9d,0xff,0x51,0xfc);
DEFINE_GUID(CLSID_DxtJpeg,0xde75d012,0x7a65,0x11d2,0x8c,0xea,0x00,0xa0,0xc9,0x44,0x1e,0x20);
DEFINE_GUID(CLSID_DxtKey,0xc5b19592,0x145e,0x11d3,0x9f,0x04,0x00,0x60,0x08,0x03,0x9e,0x37);
DEFINE_GUID(CLSID_ETFilter,0xc4c4c4f1,0x49,0x4e2b,0x98,0xfb,0x95,0x37,0xf6,0xce,0x51,0x6d);
DEFINE_GUID(CLSID_EvalRat,0xc5c5c5f1,0x3abc,0x11d6,0xb2,0x5b,0,0xc0,0x4f,0xa0,0xc0,0x26);
DEFINE_GUID(CLSID_FGControl,0xe436ebb4,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(CLSID_FileSource,0x701722e0,0x8ae3,0x11ce,0xa8,0x5c,0x00,0xaa,0x00,0x2f,0xea,0xb5);
DEFINE_GUID(CLSID_FileWriter,0x8596e5f0,0x0da5,0x11d0,0xbd,0x21,0x00,0xa0,0xc9,0x11,0xce,0x86);
DEFINE_GUID(CLSID_FilgraphManager,0xe436ebb3,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(CLSID_FilterGraph,0xe436ebb3,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(CLSID_FilterGraphNoThread,0xe436ebb8,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(CLSID_FilterMapper,0xe436ebb2,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(CLSID_FilterMapper2,0xcda42200,0xbd88,0x11d0,0xbd,0x4e,0x00,0xa0,0xc9,0x11,0xce,0x86);
DEFINE_GUID(CLSID_ChannelTuneRequest,0x0369b4e5,0x45b6,0x11d3,0xb6,0x50,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(CLSID_ICodecAPIProxy,0x7ff0997a,0x1999,0x4286,0xa7,0x3c,0x62,0x2b,0x88,0x14,0xe7,0xeb);
DEFINE_GUID(CLSID_InfTee,0xf8388a40,0xd5bb,0x11d0,0xbe,0x5a,0x00,0x80,0xc7,0x06,0x56,0x8e);
DEFINE_GUID(CLSID_IVideoEncoderCodecAPIProxy,0xb05dabd9,0x56e5,0x4fdc,0xaf,0xa4,0x8a,0x47,0xe9,0x1f,0x1c,0x9c);
DEFINE_GUID(CLSID_IVideoEncoderProxy,0xb43c4eec,0x8c32,0x4791,0x91,0x2,0x50,0x8a,0xda,0x5e,0xe8,0xe7);
DEFINE_GUID(CLSID_LanguageComponentType,0x1be49f30,0x0e1b,0x11d3,0x9d,0x8e,0x00,0xc0,0x4f,0x72,0xd9,0x80);
DEFINE_GUID(CLSID_LegacyAmFilterCategory,0x083863f1,0x70de,0x11d0,0xbd,0x40,0x00,0xa0,0xc9,0x11,0xce,0x86);
DEFINE_GUID(CLSID_Line21Decoder,0x6e8d4a20,0x310c,0x11d0,0xb7,0x9a,0x00,0xaa,0x00,0x37,0x67,0xa7);
DEFINE_GUID(CLSID_Line21Decoder2,0xe4206432,0x01a1,0x4bee,0xb3,0xe1,0x37,0x02,0xc8,0xed,0xc5,0x74);
DEFINE_GUID(CLSID_Locator,0x0888c883,0xac4f,0x4943,0xb5,0x16,0x2c,0x38,0xd9,0xb3,0x45,0x62);
DEFINE_GUID(CLSID_MediaDet,0x65bd0711,0x24d2,0x4ff7,0x93,0x24,0xed,0x2e,0x5d,0x3a,0xba,0xfa);
DEFINE_GUID(CLSID_MediaEncoderCategory,0x7d22e920,0x5ca9,0x4787,0x8c,0x2b,0xa6,0x77,0x9b,0xd1,0x17,0x81);
DEFINE_GUID(CLSID_MediaLocator,0xcc1101f2,0x79dc,0x11d2,0x8c,0xe6,0x00,0xa0,0xc9,0x44,0x1e,0x20);
DEFINE_GUID(CLSID_MediaMultiplexerCategory,0x236c9559,0xadce,0x4736,0xbf,0x72,0xba,0xb3,0x4e,0x39,0x21,0x96);
DEFINE_GUID(CLSID_MediaPropertyBag,0xcdbd8d00,0xc193,0x11d0,0xbd,0x4e,0x00,0xa0,0xc9,0x11,0xce,0x86);
DEFINE_GUID(CLSID_MemoryAllocator,0x1e651cc0,0xb199,0x11d0,0x82,0x12,0x00,0xc0,0x4f,0xc3,0x2c,0x45);
DEFINE_GUID(CLSID_MidiRendererCategory,0x4efe2452,0x168a,0x11d1,0xbc,0x76,0x00,0xc0,0x4f,0xb9,0x45,0x3b);
DEFINE_GUID(CLSID_MjpegDec,0x301056d0,0x6dff,0x11d2,0x9e,0xeb,0x00,0x60,0x08,0x03,0x9e,0x37);
DEFINE_GUID(CLSID_MJPGEnc,0xb80ab0a0,0x7416,0x11d2,0x9e,0xeb,0x00,0x60,0x08,0x03,0x9e,0x37);
DEFINE_GUID(CLSID_MMSPLITTER,0x3ae86b20,0x7be8,0x11d1,0xab,0xe6,0x00,0xa0,0xc9,0x05,0xf3,0x75);
DEFINE_GUID(CLSID_ModexProperties,0x0618aa30,0x6bc4,0x11cf,0xbf,0x36,0x00,0xaa,0x00,0x55,0x59,0x5a);
DEFINE_GUID(CLSID_ModexRenderer,0x07167665,0x5011,0x11cf,0xbf,0x33,0x00,0xaa,0x00,0x55,0x59,0x5a);
DEFINE_GUID(CLSID_MOVReader,0x44584800,0xf8ee,0x11ce,0xb2,0xd4,0x00,0xdd,0x01,0x10,0x1b,0x85);
DEFINE_GUID(CLSID_MPEG1Doc,0xe4bbd160,0x4269,0x11ce,0x83,0x8d,0x00,0xaa,0x00,0x55,0x59,0x5a);
DEFINE_GUID(CLSID_MPEG1PacketPlayer,0x26c25940,0x4ca9,0x11ce,0xa8,0x28,0x00,0xaa,0x00,0x2f,0xea,0xb5);
DEFINE_GUID(CLSID_MPEG1Splitter,0x336475d0,0x942a,0x11ce,0xa8,0x70,0x00,0xaa,0x00,0x2f,0xea,0xb5);
DEFINE_GUID(CLSID_MPEG2Component,0x055cb2d7,0x2969,0x45cd,0x91,0x4b,0x76,0x89,0x07,0x22,0xf1,0x12);
DEFINE_GUID(CLSID_MPEG2ComponentType,0x418008f3,0xcf67,0x4668,0x96,0x28,0x10,0xdc,0x52,0xbe,0x1d,0x08);
DEFINE_GUID(CLSID_MPEG2Demultiplexer,0xafb6c280,0x2c41,0x11d3,0x8a,0x60,0x00,0x00,0xf8,0x1e,0x0e,0x4a);
DEFINE_GUID(CLSID_MPEG2TuneRequest,0x0955ac62,0xbf2e,0x4cba,0xa2,0xb9,0xa6,0x3f,0x77,0x2d,0x46,0xcf);
DEFINE_GUID(CLSID_MPEG2TuneRequestFactory,0x2c63e4eb,0x4cea,0x41b8,0x91,0x9c,0xe9,0x47,0xea,0x19,0xa7,0x7c);
DEFINE_GUID(CLSID_Mpeg2VideoStreamAnalyzer,0x6cfad761,0x735d,0x4aa5,0x8a,0xfc,0xaf,0x91,0xa7,0xd6,0x1e,0xba);
DEFINE_GUID(CLSID_MSEventBinder,0x577faa18,0x4518,0x445e,0x8f,0x70,0x14,0x73,0xf8,0xcf,0x4b,0xa4);
DEFINE_GUID(CLSID_MSVidAnalogCaptureToDataServices,0xc5702cd6,0x9b79,0x11d3,0xb6,0x54,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(CLSID_MSVidAnalogCaptureToOverlayMixer,0xe18af75a,0x08af,0x11d3,0xb6,0x4a,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(CLSID_MSVidAnalogCaptureToStreamBufferSink,0x9f50e8b1,0x9530,0x4ddc,0x82,0x5e,0x1a,0xf8,0x1d,0x47,0xae,0xd6);
DEFINE_GUID(CLSID_MSVidAnalogCaptureToXDS,0x3540d440,0x5b1d,0x49cb,0x82,0x1a,0xe8,0x4b,0x8c,0xf0,0x65,0xa7);
DEFINE_GUID(CLSID_MSVidAnalogTunerDevice,0x1c15d484,0x911d,0x11d2,0xb6,0x32,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(CLSID_MSVidAnalogTVToEncoder,0x28953661,0x231,0x41db,0x89,0x86,0x21,0xff,0x43,0x88,0xee,0x9b);
DEFINE_GUID(CLSID_MSVidAudioRenderer,0x37b03544,0xa4c8,0x11d2,0xb6,0x34,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(CLSID_MSVidAudioRendererDevices,0xc5702ccf,0x9b79,0x11d3,0xb6,0x54,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(CLSID_MSVidBDATunerDevice,0xa2e3074e,0x6c3d,0x11d3,0xb6,0x53,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(CLSID_MSVidCAGSeg,0x1600f101,0x6666,0x4f66,0xb1,0xe2,0xbf,0x3c,0x9f,0xbb,0x9b,0xa6);
DEFINE_GUID(CLSID_MSVidClosedCaptioning,0x7f9cb14d,0x48e4,0x43b6,0x93,0x46,0x1a,0xeb,0xc3,0x9c,0x64,0xd3);
DEFINE_GUID(CLSID_MSVidCtl,0xb0edf163,0x910a,0x11d2,0xb6,0x32,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(CLSID_MSVidDataServices,0x334125c0,0x77e5,0x11d3,0xb6,0x53,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(CLSID_MSVidDataServicesToStreamBufferSink,0x38f03426,0xe83b,0x4e68,0xb6,0x5b,0xdc,0xae,0x73,0x30,0x48,0x38);
DEFINE_GUID(CLSID_MSVidDataServicesToXDS,0x429ec6e,0x1144,0x4bed,0xb8,0x8b,0x2f,0xb9,0x89,0x9a,0x4a,0x3d);
DEFINE_GUID(CLSID_MSVidDevice,0x6e40476f,0x9c49,0x4c3e,0x8b,0xb9,0x85,0x87,0x95,0x8e,0xff,0x74);
DEFINE_GUID(CLSID_MSVidDigitalCaptureToStreamBufferSink,0xabe40035,0x27c3,0x4a2f,0x81,0x53,0x66,0x24,0x47,0x16,0x8,0xaf);
DEFINE_GUID(CLSID_MSVidEncoder,0xbb530c63,0xd9df,0x4b49,0x94,0x39,0x63,0x45,0x39,0x62,0xe5,0x98);
DEFINE_GUID(CLSID_MSVidEncoderToStreamBufferSink,0xa0b9b497,0xafbc,0x45ad,0xa8,0xa6,0x9b,0x7,0x7c,0x40,0xd4,0xf2);
DEFINE_GUID(CLSID_MSVidFeature,0x7748530b,0xc08a,0x47ea,0xb2,0x4c,0xbe,0x86,0x95,0xff,0x40,0x5f);
DEFINE_GUID(CLSID_MSVidFeatures,0xc5702cd0,0x9b79,0x11d3,0xb6,0x54,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(CLSID_MSVidFilePlaybackDevice,0x37b0353c,0xa4c8,0x11d2,0xb6,0x34,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(CLSID_MSVidFilePlaybackToAudioRenderer,0xcc23f537,0x18d4,0x4ece,0x93,0xbd,0x20,0x7a,0x84,0x72,0x69,0x79);
DEFINE_GUID(CLSID_MSVidFilePlaybackToVideoRenderer,0xb401c5eb,0x8457,0x427f,0x84,0xea,0xa4,0xd2,0x36,0x33,0x64,0xb0);
DEFINE_GUID(CLSID_MSVidGenericComposite,0x2764bce5,0xcc39,0x11d2,0xb6,0x39,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(CLSID_MSVidInputDevice,0xac1972f2,0x138a,0x4ca3,0x90,0xda,0xae,0x51,0x11,0x2e,0xda,0x28);
DEFINE_GUID(CLSID_MSVidInputDevices,0xc5702ccc,0x9b79,0x11d3,0xb6,0x54,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(CLSID_MSVidMPEG2DecoderToClosedCaptioning,0x6ad28ee1,0x5002,0x4e71,0xaa,0xf7,0xbd,0x07,0x79,0x07,0xb1,0xa4);
DEFINE_GUID(CLSID_MSVidOutput,0x87eb890d,0x03ad,0x4e9d,0x98,0x66,0x37,0x6e,0x5e,0xc5,0x72,0xed);
DEFINE_GUID(CLSID_MSVidOutputDevices,0xc5702ccd,0x9b79,0x11d3,0xb6,0x54,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(CLSID_MSVidRect,0xcb4276e6,0x7d5f,0x4cf1,0x97,0x27,0x62,0x9c,0x5e,0x6d,0xb6,0xae);
DEFINE_GUID(CLSID_MSVidRenderFactory,0x11973c25,0x3529,0x40e4,0x9a,0xb1,0xdd,0xc1,0x64,0xcb,0xef,0x49);
DEFINE_GUID(CLSID_MSVidSBESourceToCC,0x9193a8f9,0xcba,0x400e,0xaa,0x97,0xeb,0x47,0x9,0x16,0x45,0x76);
DEFINE_GUID(CLSID_MSVidStreamBufferRecordingControl,0xcaafdd83,0xcefc,0x4e3d,0xba,0x3,0x17,0x5f,0x17,0xa2,0x4f,0x91);
DEFINE_GUID(CLSID_MSVidStreamBufferSink,0x9e77aac4,0x35e5,0x42a1,0xbd,0xc2,0x8f,0x3f,0xf3,0x99,0x84,0x7c);
DEFINE_GUID(CLSID_MSVidStreamBufferSource,0xad8e510d,0x217f,0x409b,0x80,0x76,0x29,0xc5,0xe7,0x3b,0x98,0xe8);
DEFINE_GUID(CLSID_MSVidStreamBufferSourceToVideoRenderer,0x3c4708dc,0xb181,0x46a8,0x8d,0xa8,0x4a,0xb0,0x37,0x17,0x58,0xcd);
DEFINE_GUID(CLSID_MSVidTVEGSeg,0x1600f001,0x6666,0x4f66,0xb1,0xe2,0xbf,0x3c,0x9f,0xbb,0x9b,0xa6);
DEFINE_GUID(CLSID_MSVidVideoInputDevice,0x95f4820b,0xbb3a,0x4e2d,0xbc,0x64,0x5b,0x81,0x7b,0xc2,0xc3,0x0e);
DEFINE_GUID(CLSID_MSVidVideoPlaybackDevice,0x1990d634,0x1a5e,0x4071,0xa3,0x4a,0x53,0xaa,0xff,0xce,0x9f,0x36);
DEFINE_GUID(CLSID_MSVidVideoRenderer,0x37b03543,0xa4c8,0x11d2,0xb6,0x34,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(CLSID_MSVidVideoRendererDevices,0xc5702cce,0x9b79,0x11d3,0xb6,0x54,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(CLSID_MSVidWebDVD,0x011b3619,0xfe63,0x4814,0x8a,0x84,0x15,0xa1,0x94,0xce,0x9c,0xe3);
DEFINE_GUID(CLSID_MSVidWebDVDAdm,0xfa7c375b,0x66a7,0x4280,0x87,0x9d,0xfd,0x45,0x9c,0x84,0xbb,0x02);
DEFINE_GUID(CLSID_MSVidWebDVDToAudioRenderer,0x8d04238e,0x9fd1,0x41c6,0x8d,0xe3,0x9e,0x1e,0xe3,0x9,0xe9,0x35);
DEFINE_GUID(CLSID_MSVidWebDVDToVideoRenderer,0x267db0b3,0x55e3,0x4902,0x94,0x9b,0xdf,0x8f,0x5c,0xec,0x01,0x91);
DEFINE_GUID(CLSID_MSVidXDS,0x149eedf,0xd08f,0x4142,0x8d,0x73,0xd2,0x39,0x3,0xd2,0x1e,0x90);
DEFINE_GUID(CLSID_NullRenderer,0xc1f400a4,0x3f08,0x11d3,0x9f,0x0b,0x00,0x60,0x08,0x03,0x9e,0x37);
DEFINE_GUID(CLSID_OverlayMixer,0xcd8743a1,0x3736,0x11d0,0x9e,0x69,0x00,0xc0,0x4f,0xd7,0xc1,0x5b);
DEFINE_GUID(CLSID_PerformanceProperties,0x59ce6880,0xacf8,0x11cf,0xb5,0x6e,0x00,0x80,0xc7,0xc4,0xb6,0x8a);
DEFINE_GUID(CLSID_PersistMonikerPID,0xe436ebb7,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(CLSID_PropertySetter,0xadf95821,0xded7,0x11d2,0xac,0xbe,0x00,0x80,0xc7,0x5e,0x24,0x6e);
DEFINE_GUID(CLSID_ProtoFilterGraph,0xe436ebb0,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(CLSID_QTDec,0xfdfe9681,0x74a3,0x11d0,0xaf,0xa7,0x00,0xaa,0x00,0xb6,0x7a,0x42);
DEFINE_GUID(CLSID_QualityProperties,0x418afb70,0xf8b8,0x11ce,0xaa,0xc6,0x00,0x20,0xaf,0x0b,0x99,0xa3);
DEFINE_GUID(CLSID_QuickTimeParser,0xd51bd5a0,0x7548,0x11cf,0xa5,0x20,0x00,0x80,0xc7,0x7e,0xf5,0x8a);
DEFINE_GUID(CLSID_RenderEngine,0x64d8a8e0,0x80a2,0x11d2,0x8c,0xf3,0x00,0xa0,0xc9,0x44,0x1e,0x20);
DEFINE_GUID(CLSID_SampleGrabber,0xc1f400a0,0x3f08,0x11d3,0x9f,0x0b,0x00,0x60,0x08,0x03,0x9e,0x37);
DEFINE_GUID(CLSID_SeekingPassThru,0x060af76c,0x68dd,0x11d0,0x8f,0xc1,0x00,0xc0,0x4f,0xd9,0x18,0x9d);
DEFINE_GUID(CLSID_SmartRenderEngine,0x498b0949,0xbbe9,0x4072,0x98,0xbe,0x6c,0xca,0xeb,0x79,0xdc,0x6f);
DEFINE_GUID(CLSID_SmartTee,0xcc58e280,0x8aa1,0x11d1,0xb3,0xf1,0x00,0xaa,0x00,0x37,0x61,0xc5);
DEFINE_GUID(CLSID_StreamBufferComposeRecording,0xd682c4ba,0xa90a,0x42fe,0xb9,0xe1,0x3,0x10,0x98,0x49,0xc4,0x23);
DEFINE_GUID(CLSID_StreamBufferConfig,0xfa8a68b2,0xc864,0x4ba2,0xad,0x53,0xd3,0x87,0x6a,0x87,0x49,0x4b);
DEFINE_GUID(CLSID_StreamBufferRecordingAttributes,0xccaa63ac,0x1057,0x4778,0xae,0x92,0x12,0x6,0xab,0x9a,0xce,0xe6);
DEFINE_GUID(CLSID_StreamBufferSink,0x2db47ae5,0xcf39,0x43c2,0xb4,0xd6,0xc,0xd8,0xd9,0x9,0x46,0xf4);
DEFINE_GUID(CLSID_StreamBufferSource,0xc9f5fe02,0xf851,0x4eb5,0x99,0xee,0xad,0x60,0x2a,0xf1,0xe6,0x19);
DEFINE_GUID(CLSID_SystemClock,0xe436ebb1,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(CLSID_SystemDeviceEnum,0x62be5d10,0x60eb,0x11d0,0xbd,0x3b,0x00,0xa0,0xc9,0x11,0xce,0x86);
DEFINE_GUID(CLSID_SystemTuningSpaces,0xd02aac50,0x027e,0x11d3,0x9d,0x8e,0x00,0xc0,0x4f,0x72,0xd9,0x80);
DEFINE_GUID(CLSID_TextRender,0xe30629d3,0x27e5,0x11ce,0x87,0x5d,0x00,0x60,0x8c,0xb7,0x80,0x66);
DEFINE_GUID(CLSID_TIFLoad,0x14eb8748,0x1753,0x4393,0x95,0xae,0x4f,0x7e,0x7a,0x87,0xaa,0xd6);
DEFINE_GUID(CLSID_TransmitCategory,0xcc7bfb41,0xf175,0x11d1,0xa3,0x92,0x00,0xe0,0x29,0x1f,0x39,0x59);
DEFINE_GUID(CLSID_TuneRequest,0xb46e0d38,0xab35,0x4a06,0xa1,0x37,0x70,0x57,0x6b,0x01,0xb3,0x9f);
DEFINE_GUID(CLSID_TuningSpace,0x5ffdc5e6,0xb83a,0x4b55,0xb6,0xe8,0xc6,0x9e,0x76,0x5f,0xe9,0xdb);
DEFINE_GUID(CLSID_TVAudioFilterPropertyPage,0x71f96463,0x78f3,0x11d0,0xa1,0x8c,0x00,0xa0,0xc9,0x11,0x89,0x56);
DEFINE_GUID(CLSID_TVEAttrMap,0x05500021,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(CLSID_TVEAttrTimeQ,0x05500022,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(CLSID_TVECBAnnc,0x05500041,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(CLSID_TVECBDummy,0x05500049,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(CLSID_TVECBFile,0x05500043,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(CLSID_TVECBTrig,0x05500042,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(CLSID_TVEEnhancement,0x05500004,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(CLSID_TVEEnhancements,0x05500014,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(CLSID_TVEFeature,0x05500025,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(CLSID_TVEFile,0x05500050,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(CLSID_TVEFilter,0x05500080,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(CLSID_TVEFilterCCProperties,0x05500282,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(CLSID_TVEFilterStatsProperties,0x05500283,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(CLSID_TVEFilterTuneProperties,0x05500281,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(CLSID_TVEMCast,0x05500030,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(CLSID_TVEMCastCallback,0x05500040,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(CLSID_TVEMCastManager,0x05500032,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(CLSID_TVEMCasts,0x05500031,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(CLSID_TVENavAid,0x05500070,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(CLSID_TVEService,0x05500005,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(CLSID_TVEServices,0x05500015,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(CLSID_TVESupervisor,0x05500006,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(CLSID_TVETrack,0x05500002,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(CLSID_TVETrigger,0x05500001,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(CLSID_TVETriggerCtrl,0x05500090,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(CLSID_TVEVariation,0x05500003,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(CLSID_TVTunerFilterPropertyPage,0x266eee41,0x6c63,0x11cf,0x8a,0x03,0x00,0xaa,0x00,0x6e,0xcb,0x65);
DEFINE_GUID(CLSID_URLReader,0xe436ebb6,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(CLSID_VBISurfaces,0x814b9800,0x1c88,0x11d1,0xba,0xd9,0x00,0x60,0x97,0x44,0x11,0x1a);
DEFINE_GUID(CLSID_VfwCapture,0x1b544c22,0xfd0b,0x11ce,0x8c,0x63,0x00,0xaa,0x00,0x44,0xb5,0x1e);
DEFINE_GUID(CLSID_VideoCompressorCategory,0x33d9a760,0x90c8,0x11d0,0xbd,0x43,0x00,0xa0,0xc9,0x11,0xce,0x86);
DEFINE_GUID(CLSID_VideoInputDeviceCategory,0x860bb310,0x5d01,0x11d0,0xbd,0x3b,0x00,0xa0,0xc9,0x11,0xce,0x86);
DEFINE_GUID(CLSID_VideoMixingRenderer,0xb87beb7b,0x8d29,0x423f,0xae,0x4d,0x65,0x82,0xc1,0x01,0x75,0xac);
DEFINE_GUID(CLSID_VideoMixingRenderer9,0x51b4abf3,0x748f,0x4e3b,0xa2,0x76,0xc8,0x28,0x33,0xe,0x92,0x6a);
DEFINE_GUID(CLSID_VideoPortManager,0x6f26a6cd,0x967b,0x47fd,0x87,0x4a,0x7a,0xed,0x2c,0x9d,0x25,0xa2);
DEFINE_GUID(CLSID_VideoProcAmpPropertyPage,0x71f96464,0x78f3,0x11d0,0xa1,0x8c,0x00,0xa0,0xc9,0x11,0x89,0x56);
DEFINE_GUID(CLSID_VideoRenderer,0x70e102b0,0x5556,0x11ce,0x97,0xc0,0x00,0xaa,0x00,0x55,0x59,0x5a);
DEFINE_GUID(CLSID_VideoRendererDefault,0x6bc1cffa,0x8fc1,0x4261,0xac,0x22,0xcf,0xb4,0xcc,0x38,0xdb,0x50);
DEFINE_GUID(CLSID_VideoStreamConfigPropertyPage,0x71f96467,0x78f3,0x11d0,0xa1,0x8c,0x00,0xa0,0xc9,0x11,0x89,0x56);
DEFINE_GUID(CLSID_VPObject,0xce292861,0xfc88,0x11d0,0x9e,0x69,0x00,0xc0,0x4f,0xd7,0xc1,0x5b);
DEFINE_GUID(CLSID_VPVBIObject,0x814b9801,0x1c88,0x11d1,0xba,0xd9,0x00,0x60,0x97,0x44,0x11,0x1a);
DEFINE_GUID(CLSID_WMAsfReader,0x187463a0,0x5bb7,0x11d3,0xac,0xbe,0x00,0x80,0xc7,0x5e,0x24,0x6e);
DEFINE_GUID(CLSID_WMAsfWriter,0x7c23220e,0x55bb,0x11d3,0x8b,0x16,0x00,0xc0,0x4f,0xb6,0xbd,0x3d);
DEFINE_GUID(CLSID_WSTDecoder,0x70bc06e0,0x5666,0x11d3,0xa1,0x84,0x00,0x10,0x5a,0xef,0x9f,0x33);
DEFINE_GUID(CLSID_WstDecoderPropertyPage,0x04e27f80,0x91e4,0x11d3,0xa1,0x84,0x00,0x10,0x5a,0xef,0x9f,0x33);
DEFINE_GUID(CLSID_XDSCodec,0xc4c4c4f3,0x49,0x4e2b,0x98,0xfb,0x95,0x37,0xf6,0xce,0x51,0x6d);
DEFINE_GUID(CLSID_XDSToRat,0xc5c5c5f0,0x3abc,0x11d6,0xb2,0x5b,0,0xc0,0x4f,0xa0,0xc0,0x26);
DEFINE_GUID(CLSID_Xml2Dex,0x18c628ee,0x962a,0x11d2,0x8d,0x08,0x00,0xa0,0xc9,0x44,0x1e,0x20);
DEFINE_GUID(CODECAPI_ALLSETTINGS,0x6a577e92,0x83e1,0x4113,0xad,0xc2,0x4f,0xce,0xc3,0x2f,0x83,0xa1);
DEFINE_GUID(CODECAPI_AUDIO_ENCODER,0xb9d19a3e,0xf897,0x429c,0xbc,0x46,0x81,0x38,0xb7,0x27,0x2b,0x2d);
DEFINE_GUID(CODECAPI_CURRENTCHANGELIST,0x1cb14e83,0x7d72,0x4657,0x83,0xfd,0x47,0xa2,0xc5,0xb9,0xd1,0x3d);
DEFINE_GUID(CODECAPI_CHANGELISTS,0x62b12acf,0xf6b0,0x47d9,0x94,0x56,0x96,0xf2,0x2c,0x4e,0xb,0x9d);
DEFINE_GUID(CODECAPI_SETALLDEFAULTS,0x6c5e6a7c,0xacf8,0x4f55,0xa9,0x99,0x1a,0x62,0x81,0x9,0x5,0x1b);
DEFINE_GUID(CODECAPI_SUPPORTSEVENTS,0x581af97,0x7693,0x4dbd,0x9d,0xca,0x3f,0x9e,0xbd,0x65,0x85,0xa1);
DEFINE_GUID(CODECAPI_VIDEO_ENCODER,0x7112e8e1,0x3d03,0x47ef,0x8e,0x60,0x3,0xf1,0xcf,0x53,0x73,0x1);
DEFINE_GUID(DIID__ICAComponentsEvents,0x11166260,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(DIID__ICADefaultDlgEvents,0x11166991,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(DIID__ICADenialsEvents,0x11166240,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(DIID__ICAManagerEvents,0x11166200,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(DIID__ICAOffersEvents,0x11166250,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(DIID__ICAPoliciesEvents,0x11166220,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(DIID__ICARequestEvents,0x11166210,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(DIID__ICAResDenialTreeEvents,0x11166298,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(DIID__ICATollsEvents,0x11166230,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(DIID__IMSVidCtlEvents,0xb0edf164,0x910a,0x11d2,0xb6,0x32,0,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(DIID__ITVEEvents,0x05500000,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(DIID__ITVETriggerCtrlEvents,0x05500091,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(DIID_IDTFilterEvents,0xc4c4c4c2,0x49,0x4e2b,0x98,0xfb,0x95,0x37,0xf6,0xce,0x51,0x6d);
DEFINE_GUID(DIID_IETFilterEvents,0xc4c4c4c1,0x49,0x4e2b,0x98,0xfb,0x95,0x37,0xf6,0xce,0x51,0x6d);
DEFINE_GUID(DIID_IXDSCodecEvents,0xc4c4c4c3,0x49,0x4e2b,0x98,0xfb,0x95,0x37,0xf6,0xce,0x51,0x6d);
DEFINE_GUID(ENCAPIPARAM_BITRATE,0x49cc4c43,0xca83,0x4ad4,0xa9,0xaf,0xf3,0x69,0x6a,0xf6,0x66,0xdf);
DEFINE_GUID(ENCAPIPARAM_BITRATE_MODE,0xee5fb25c,0xc713,0x40d1,0x9d,0x58,0xc0,0xd7,0x24,0x1e,0x25,0xf);
DEFINE_GUID(ENCAPIPARAM_PEAK_BITRATE,0x703f16a9,0x3d48,0x44a1,0xb0,0x77,0x1,0x8d,0xff,0x91,0x5d,0x19);
DEFINE_GUID(FORMAT_AnalogVideo,0x0482dde0,0x7817,0x11cf,0x8a,0x03,0x00,0xaa,0x00,0x6e,0xcb,0x65);
DEFINE_GUID(FORMAT_DolbyAC3,0xe06d80e4,0xdb46,0x11cf,0xb4,0xd1,0x00,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(FORMAT_DVD_LPCMAudio,0xe06d80e6,0xdb46,0x11cf,0xb4,0xd1,0x00,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(FORMAT_DvInfo,0x05589f84,0xc356,0x11ce,0xbf,0x01,0x00,0xaa,0x00,0x55,0x59,0x5a);
DEFINE_GUID(FORMAT_MPEG2_VIDEO,0xe06d80e3,0xdb46,0x11cf,0xb4,0xd1,0x00,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(FORMAT_MPEG2Audio,0xe06d80e5,0xdb46,0x11cf,0xb4,0xd1,0x00,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(FORMAT_MPEG2Video,0xe06d80e3,0xdb46,0x11cf,0xb4,0xd1,0x00,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(FORMAT_MPEGStreams,0x05589f83,0xc356,0x11ce,0xbf,0x01,0x00,0xaa,0x00,0x55,0x59,0x5a);
DEFINE_GUID(FORMAT_MPEGVideo,0x05589f82,0xc356,0x11ce,0xbf,0x01,0x00,0xaa,0x00,0x55,0x59,0x5a);
DEFINE_GUID(FORMAT_None,0x0f6417d6,0xc318,0x11d0,0xa4,0x3f,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(FORMAT_VideoInfo,0x05589f80,0xc356,0x11ce,0xbf,0x01,0x00,0xaa,0x00,0x55,0x59,0x5a);
DEFINE_GUID(FORMAT_VideoInfo2,0xf72a76a0,0xeb0a,0x11d0,0xac,0xe4,0x00,0x00,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(FORMAT_VIDEOINFO2,0xf72a76a0,0xeb0a,0x11d0,0xac,0xe4,0x00,0x00,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(FORMAT_WaveFormatEx,0x05589f81,0xc356,0x11ce,0xbf,0x01,0x00,0xaa,0x00,0x55,0x59,0x5a);
DEFINE_GUID(IID_IAMAnalogVideoDecoder,0xc6e13350,0x30ac,0x11d0,0xa1,0x8c,0x00,0xa0,0xc9,0x11,0x89,0x56);
DEFINE_GUID(IID_IAMAnalogVideoEncoder,0xc6e133b0,0x30ac,0x11d0,0xa1,0x8c,0x00,0xa0,0xc9,0x11,0x89,0x56);
DEFINE_GUID(IID_IAMAudioInputMixer,0x54c39221,0x8380,0x11d0,0xb3,0xf0,0x00,0xaa,0x00,0x37,0x61,0xc5);
DEFINE_GUID(IID_IAMAudioRendererStats,0x22320cb2,0xd41a,0x11d2,0xbf,0x7c,0xd7,0xcb,0x9d,0xf0,0xbf,0x93);
DEFINE_GUID(IID_IAMBufferNegotiation,0x56ed71a0,0xaf5f,0x11d0,0xb3,0xf0,0x00,0xaa,0x00,0x37,0x61,0xc5);
DEFINE_GUID(IID_IAMCameraControl,0xc6e13370,0x30ac,0x11d0,0xa1,0x8c,0x00,0xa0,0xc9,0x11,0x89,0x56);
DEFINE_GUID(IID_IAMClockAdjust,0x4d5466b0,0xa49c,0x11d1,0xab,0xe8,0x00,0xa0,0xc9,0x05,0xf3,0x75);
DEFINE_GUID(IID_IAMClockSlave,0x9fd52741,0x176d,0x4b36,0x8f,0x51,0xca,0x8f,0x93,0x32,0x23,0xbe);
DEFINE_GUID(IID_IAMCollection,0x56a868b9,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IAMCopyCaptureFileProgress,0x670d1d20,0xa068,0x11d0,0xb3,0xf0,0x00,0xaa,0x00,0x37,0x61,0xc5);
DEFINE_GUID(IID_IAMCrossbar,0xc6e13380,0x30ac,0x11d0,0xa1,0x8c,0x00,0xa0,0xc9,0x11,0x89,0x56);
DEFINE_GUID(IID_IAMDecoderCaps,0xc0dff467,0xd499,0x4986,0x97,0x2b,0xe1,0xd9,0x09,0x0f,0xa9,0x41);
DEFINE_GUID(IID_IAMDeviceRemoval,0xf90a6130,0xb658,0x11d2,0xae,0x49,0x00,0x00,0xf8,0x75,0x4b,0x99);
DEFINE_GUID(IID_IAMDevMemoryAllocator,0xc6545bf0,0xe76b,0x11d0,0xbd,0x52,0x00,0xa0,0xc9,0x11,0xce,0x86);
DEFINE_GUID(IID_IAMDevMemoryControl,0xc6545bf1,0xe76b,0x11d0,0xbd,0x52,0x00,0xa0,0xc9,0x11,0xce,0x86);
DEFINE_GUID(IID_IAMDirectSound,0x546f4260,0xd53e,0x11cf,0xb3,0xf0,0x00,0xaa,0x00,0x37,0x61,0xc5);
DEFINE_GUID(IID_IAMDroppedFrames,0xc6e13344,0x30ac,0x11d0,0xa1,0x8c,0x00,0xa0,0xc9,0x11,0x89,0x56);
DEFINE_GUID(IID_IAMErrorLog,0xe43e73a2,0x0efa,0x11d3,0x96,0x01,0x00,0xa0,0xc9,0x44,0x1e,0x20);
DEFINE_GUID(IID_IAMExtDevice,0xb5730a90,0x1a2c,0x11cf,0x8c,0x23,0x00,0xaa,0x00,0x6b,0x68,0x14);
DEFINE_GUID(IID_IAMExtTransport,0xa03cd5f0,0x3045,0x11cf,0x8c,0x44,0x00,0xaa,0x00,0x6b,0x68,0x14);
DEFINE_GUID(IID_IAMFilterMiscFlags,0x2dd74950,0xa890,0x11d1,0xab,0xe8,0x00,0xa0,0xc9,0x05,0xf3,0x75);
DEFINE_GUID(IID_IAMGraphBuilderCallback,0x4995f511,0x9ddb,0x4f12,0xbd,0x3b,0xf0,0x46,0x11,0x80,0x7b,0x79);
DEFINE_GUID(IID_IAMGraphStreams,0x632105fa,0x072e,0x11d3,0x8a,0xf9,0x00,0xc0,0x4f,0xb6,0xbd,0x3d);
DEFINE_GUID(IID_IAMLatency,0x62ea93ba,0xec62,0x11d2,0xb7,0x70,0x00,0xc0,0x4f,0xb6,0xbd,0x3d);
DEFINE_GUID(IID_IAMLine21Decoder,0x6e8d4a21,0x310c,0x11d0,0xb7,0x9a,0x00,0xaa,0x00,0x37,0x67,0xa7);
DEFINE_GUID(IID_IAMMediaStream,0xbebe595d,0x9a6f,0x11d0,0x8f,0xde,0x00,0xc0,0x4f,0xd9,0x18,0x9d);
DEFINE_GUID(IID_IAMMediaTypeSample,0xab6b4afb,0xf6e4,0x11d0,0x90,0x0d,0x00,0xc0,0x4f,0xd9,0x18,0x9d);
DEFINE_GUID(IID_IAMMediaTypeStream,0xab6b4afa,0xf6e4,0x11d0,0x90,0x0d,0x00,0xc0,0x4f,0xd9,0x18,0x9d);
DEFINE_GUID(IID_IAMMultiMediaStream,0xbebe595c,0x9a6f,0x11d0,0x8f,0xde,0x00,0xc0,0x4f,0xd9,0x18,0x9d);
DEFINE_GUID(IID_IAMOpenProgress,0x8e1c39a1,0xde53,0x11cf,0xaa,0x63,0x00,0x80,0xc7,0x44,0x52,0x8d);
DEFINE_GUID(IID_IAMOverlayFX,0x62fae250,0x7e65,0x4460,0xbf,0xc9,0x63,0x98,0xb3,0x22,0x07,0x3c);
DEFINE_GUID(IID_IAMovie,0x359ace10,0x7688,0x11cf,0x8b,0x23,0x00,0x80,0x5f,0x6c,0xef,0x60);
DEFINE_GUID(IID_IAMovieSetup,0xa3d8cec0,0x7e5a,0x11cf,0xbb,0xc5,0x00,0x80,0x5f,0x6c,0xef,0x20);
DEFINE_GUID(IID_IAMPhysicalPinInfo,0xf938c991,0x3029,0x11cf,0x8c,0x44,0x00,0xaa,0x00,0x6b,0x68,0x14);
DEFINE_GUID(IID_IAMPushSource,0xf185fe76,0xe64e,0x11d2,0xb7,0x6e,0x00,0xc0,0x4f,0xb6,0xbd,0x3d);
DEFINE_GUID(IID_IAMResourceControl,0x8389d2d0,0x77d7,0x11d1,0xab,0xe6,0x00,0xa0,0xc9,0x05,0xf3,0x75);
DEFINE_GUID(IID_IAMSetErrorLog,0x963566da,0xbe21,0x4eaf,0x88,0xe9,0x35,0x70,0x4f,0x8f,0x52,0xa1);
DEFINE_GUID(IID_IAMStats,0xbc9bcf80,0xdcd2,0x11d2,0xab,0xf6,0x00,0xa0,0xc9,0x05,0xf3,0x75);
DEFINE_GUID(IID_IAMStreamConfig,0xc6e13340,0x30ac,0x11d0,0xa1,0x8c,0x00,0xa0,0xc9,0x11,0x89,0x56);
DEFINE_GUID(IID_IAMStreamControl,0x36b73881,0xc2c8,0x11cf,0x8b,0x46,0x00,0x80,0x5f,0x6c,0xef,0x60);
DEFINE_GUID(IID_IAMStreamSelect,0xc1960960,0x17f5,0x11d1,0xab,0xe1,0x00,0xa0,0xc9,0x05,0xf3,0x75);
DEFINE_GUID(IID_IAMTimecodeDisplay,0x9b496ce2,0x811b,0x11cf,0x8c,0x77,0x00,0xaa,0x00,0x6b,0x68,0x14);
DEFINE_GUID(IID_IAMTimecodeGenerator,0x9b496ce0,0x811b,0x11cf,0x8c,0x77,0x00,0xaa,0x00,0x6b,0x68,0x14);
DEFINE_GUID(IID_IAMTimecodeReader,0x9b496ce1,0x811b,0x11cf,0x8c,0x77,0x00,0xaa,0x00,0x6b,0x68,0x14);
DEFINE_GUID(IID_IAMTimeline,0x78530b74,0x61f9,0x11d2,0x8c,0xad,0x00,0xa0,0x24,0x58,0x09,0x02);
DEFINE_GUID(IID_IAMTimelineComp,0xeae58536,0x622e,0x11d2,0x8c,0xad,0x00,0xa0,0x24,0x58,0x09,0x02);
DEFINE_GUID(IID_IAMTimelineEffect,0xbce0c264,0x622d,0x11d2,0x8c,0xad,0x00,0xa0,0x24,0x58,0x09,0x02);
DEFINE_GUID(IID_IAMTimelineEffectable,0xeae58537,0x622e,0x11d2,0x8c,0xad,0x00,0xa0,0x24,0x58,0x09,0x02);
DEFINE_GUID(IID_IAMTimelineGroup,0x9eed4f00,0xb8a6,0x11d2,0x80,0x23,0x00,0xc0,0xdf,0x10,0xd4,0x34);
DEFINE_GUID(IID_IAMTimelineObj,0x78530b77,0x61f9,0x11d2,0x8c,0xad,0x00,0xa0,0x24,0x58,0x09,0x02);
DEFINE_GUID(IID_IAMTimelineSplittable,0xa0f840a0,0xd590,0x11d2,0x8d,0x55,0x00,0xa0,0xc9,0x44,0x1e,0x20);
DEFINE_GUID(IID_IAMTimelineSrc,0x78530b79,0x61f9,0x11d2,0x8c,0xad,0x00,0xa0,0x24,0x58,0x09,0x02);
DEFINE_GUID(IID_IAMTimelineTrack,0xeae58538,0x622e,0x11d2,0x8c,0xad,0x00,0xa0,0x24,0x58,0x09,0x02);
DEFINE_GUID(IID_IAMTimelineTrans,0xbce0c265,0x622d,0x11d2,0x8c,0xad,0x00,0xa0,0x24,0x58,0x09,0x02);
DEFINE_GUID(IID_IAMTimelineTransable,0x378fa386,0x622e,0x11d2,0x8c,0xad,0x00,0xa0,0x24,0x58,0x09,0x02);
DEFINE_GUID(IID_IAMTimelineVirtualTrack,0xa8ed5f80,0xc2c7,0x11d2,0x8d,0x39,0x00,0xa0,0xc9,0x44,0x1e,0x20);
DEFINE_GUID(IID_IAMTuner,0x211a8761,0x03ac,0x11d1,0x8d,0x13,0x00,0xaa,0x00,0xbd,0x83,0x39);
DEFINE_GUID(IID_IAMTunerNotification,0x211a8760,0x03ac,0x11d1,0x8d,0x13,0x00,0xaa,0x00,0xbd,0x83,0x39);
DEFINE_GUID(IID_IAMTVAudio,0x83ec1c30,0x23d1,0x11d1,0x99,0xe6,0x00,0xa0,0xc9,0x56,0x02,0x66);
DEFINE_GUID(IID_IAMTVAudioNotification,0x83ec1c33,0x23d1,0x11d1,0x99,0xe6,0x00,0xa0,0xc9,0x56,0x02,0x66);
DEFINE_GUID(IID_IAMTVTuner,0x211a8766,0x03ac,0x11d1,0x8d,0x13,0x00,0xaa,0x00,0xbd,0x83,0x39);
DEFINE_GUID(IID_IAMVfwCaptureDialogs,0xd8d715a0,0x6e5e,0x11d0,0xb3,0xf0,0x00,0xaa,0x00,0x37,0x61,0xc5);
DEFINE_GUID(IID_IAMVfwCompressDialogs,0xd8d715a3,0x6e5e,0x11d0,0xb3,0xf0,0x00,0xaa,0x00,0x37,0x61,0xc5);
DEFINE_GUID(IID_IAMVideoAccelerator,0x256a6a22,0xfbad,0x11d1,0x82,0xbf,0x00,0xa0,0xc9,0x69,0x6c,0x8f);
DEFINE_GUID(IID_IAMVideoAcceleratorNotify,0x256a6a21,0xfbad,0x11d1,0x82,0xbf,0x00,0xa0,0xc9,0x69,0x6c,0x8f);
DEFINE_GUID(IID_IAMVideoCompression,0xc6e13343,0x30ac,0x11d0,0xa1,0x8c,0x00,0xa0,0xc9,0x11,0x89,0x56);
DEFINE_GUID(IID_IAMVideoControl,0x6a2e0670,0x28e4,0x11d0,0xa1,0x8c,0x00,0xa0,0xc9,0x11,0x89,0x56);
DEFINE_GUID(IID_IAMVideoDecimationProperties,0x60d32930,0x13da,0x11d3,0x9e,0xc6,0xc4,0xfc,0xae,0xf5,0xc7,0xbe);
DEFINE_GUID(IID_IAMVideoProcAmp,0xc6e13360,0x30ac,0x11d0,0xa1,0x8c,0x00,0xa0,0xc9,0x11,0x89,0x56);
DEFINE_GUID(IID_IAMWstDecoder,0xc056de21,0x75c2,0x11d3,0xa1,0x84,0x00,0x10,0x5a,0xef,0x9f,0x33);
DEFINE_GUID(IID_IAnalogRadioTuningSpace,0x2a6e293b,0x2595,0x11d3,0xb6,0x4c,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IAnalogTVTuningSpace,0x2a6e293c,0x2595,0x11d3,0xb6,0x4c,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IAsyncReader,0x56a868aa,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IATSCComponentType,0xfc189e4d,0x7bd4,0x4125,0xb3,0xb3,0x3a,0x76,0xa3,0x32,0xcc,0x96);
DEFINE_GUID(IID_IATSCChannelTuneRequest,0x0369b4e1,0x45b6,0x11d3,0xb6,0x50,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IATSCLocator,0xbf8d986f,0x8c2b,0x4131,0x94,0xd7,0x4d,0x3d,0x9f,0xcc,0x21,0xef);
DEFINE_GUID(IID_IATSCTuningSpace,0x0369b4e2,0x45b6,0x11d3,0xb6,0x50,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IAudioData,0x54c719c0,0xaf60,0x11d0,0x82,0x12,0x00,0xc0,0x4f,0xc3,0x2c,0x45);
DEFINE_GUID(IID_IAudioMediaStream,0xf7537560,0xa3be,0x11d0,0x82,0x12,0x00,0xc0,0x4f,0xc3,0x2c,0x45);
DEFINE_GUID(IID_IAudioStreamSample,0x345fee00,0xaba5,0x11d0,0x82,0x12,0x00,0xc0,0x4f,0xc3,0x2c,0x45);
DEFINE_GUID(IID_IAuxInTuningSpace,0xe48244b8,0x7e17,0x4f76,0xa7,0x63,0x50,0x90,0xff,0x1e,0x2f,0x30);
DEFINE_GUID(IID_IBaseFilter,0x56a86895,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IBaseVideoMixer,0x61ded640,0xe912,0x11ce,0xa0,0x99,0x00,0xaa,0x00,0x47,0x9a,0x58);
DEFINE_GUID(IID_IBasicAudio,0x56a868b3,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IBasicVideo,0x56a868b5,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IBasicVideo2,0x329bb360,0xf6ea,0x11d1,0x90,0x38,0x00,0xa0,0xc9,0x69,0x72,0x98);
DEFINE_GUID(IID_IBDA_AutoDemodulate,0xddf15b12,0xbd25,0x11d2,0x9c,0xa0,0x00,0xc0,0x4f,0x79,0x71,0xe0);
DEFINE_GUID(IID_IBDA_DeviceControl,0xfd0a5af3,0xb41d,0x11d2,0x9c,0x95,0x00,0xc0,0x4f,0x79,0x71,0xe0);
DEFINE_GUID(IID_IBDA_DigitalDemodulator,0xef30f379,0x985b,0x4d10,0xb6,0x40,0xa7,0x9d,0x5e,0x04,0xe1,0xe0);
DEFINE_GUID(IID_IBDA_EthernetFilter,0x71985f43,0x1ca1,0x11d3,0x9c,0xc8,0x00,0xc0,0x4f,0x79,0x71,0xe0);
DEFINE_GUID(IID_IBDA_FrequencyFilter,0x71985f47,0x1ca1,0x11d3,0x9c,0xc8,0x00,0xc0,0x4f,0x79,0x71,0xe0);
DEFINE_GUID(IID_IBDA_IPSinkControl,0x3f4dc8e2,0x4050,0x11d3,0x8f,0x4b,0x00,0xc0,0x4f,0x79,0x71,0xe2);
DEFINE_GUID(IID_IBDA_IPSinkInfo,0xa750108f,0x492e,0x4d51,0x95,0xf7,0x64,0x9b,0x23,0xff,0x7a,0xd7);
DEFINE_GUID(IID_IBDA_IPV4Filter,0x71985f44,0x1ca1,0x11d3,0x9c,0xc8,0x00,0xc0,0x4f,0x79,0x71,0xe0);
DEFINE_GUID(IID_IBDA_IPV6Filter,0xe1785a74,0x2a23,0x4fb3,0x92,0x45,0xa8,0xf8,0x80,0x17,0xef,0x33);
DEFINE_GUID(IID_IBDA_LNBInfo,0x992cf102,0x49f9,0x4719,0xa6,0x64,0xc4,0xf2,0x3e,0x24,0x08,0xf4);
DEFINE_GUID(IID_IBDA_NetworkProvider,0xfd501041,0x8ebe,0x11ce,0x81,0x83,0x00,0xaa,0x00,0x57,0x7d,0xa2);
DEFINE_GUID(IID_IBDA_NullTransform,0xddf15b0d,0xbd25,0x11d2,0x9c,0xa0,0x00,0xc0,0x4f,0x79,0x71,0xe0);
DEFINE_GUID(IID_IBDA_PinControl,0x0ded49d5,0xa8b7,0x4d5d,0x97,0xa1,0x12,0xb0,0xc1,0x95,0x87,0x4d);
DEFINE_GUID(IID_IBDA_SignalProperties,0xd2f1644b,0xb409,0x11d2,0xbc,0x69,0x00,0xa0,0xc9,0xee,0x9e,0x16);
DEFINE_GUID(IID_IBDA_SignalStatistics,0x1347d106,0xcf3a,0x428a,0xa5,0xcb,0xac,0x0d,0x9a,0x2a,0x43,0x38);
DEFINE_GUID(IID_IBDA_TIF_REGISTRATION,0xdfef4a68,0xee61,0x415f,0x9c,0xcb,0xcd,0x95,0xf2,0xf9,0x8a,0x3a);
DEFINE_GUID(IID_IBDA_Topology,0xa14ee835,0x0a23,0x11d3,0x9c,0xc7,0x00,0xc0,0x4f,0x79,0x71,0xe0);
DEFINE_GUID(IID_IBDA_VoidTransform,0x71985f46,0x1ca1,0x11d3,0x9c,0xc8,0x00,0xc0,0x4f,0x79,0x71,0xe0);
DEFINE_GUID(IID_IBPCSatelliteTuner,0x211a8765,0x03ac,0x11d1,0x8d,0x13,0x00,0xaa,0x00,0xbd,0x83,0x39);
DEFINE_GUID(IID_IBroadcastEvent,0x3b21263f,0x26e8,0x489d,0xaa,0xc4,0x92,0x4f,0x7e,0xfd,0x95,0x11);
DEFINE_GUID(IID_ICAComponent,0x11166360,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(IID_ICAComponentInternal,0x11166361,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(IID_ICAComponents,0x11166470,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(IID_ICADefaultDlg,0x860a3fe2,0xded1,0x40e2,0x89,0x6c,0x05,0x76,0x81,0xa8,0xa1,0xa8);
DEFINE_GUID(IID_ICADenial,0x11166340,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(IID_ICADenials,0x11166440,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(IID_ICADenialsInternal,0x11166441,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(IID_ICAManager,0x11166300,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(IID_ICAManagerInternal,0x11166301,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(IID_ICAOffer,0x11166350,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(IID_ICAOffers,0x11166450,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(IID_ICAPolicies,0x11166420,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(IID_ICAPoliciesInternal,0x11166421,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(IID_ICAPolicy,0x11166320,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(IID_ICaptureGraphBuilder,0xbf87b6e0,0x8c27,0x11d0,0xb3,0xf0,0x00,0xaa,0x00,0x37,0x61,0xc5);
DEFINE_GUID(IID_ICaptureGraphBuilder2,0x93e5a4e0,0x2d50,0x11d2,0xab,0xfa,0x00,0xa0,0xc9,0xc6,0xe3,0x8d);
DEFINE_GUID(IID_ICARequest,0x11166310,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(IID_ICAResDenialTree,0x11166898,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(IID_ICAToll,0x11166330,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(IID_ICATolls,0x11166430,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(IID_ICATollsInternal,0x11166431,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(IID_ICodecAPI,0x901db4c7,0x31ce,0x41a2,0x85,0xdc,0x8f,0xa0,0xbf,0x41,0xb8,0xda);
DEFINE_GUID(IID_IComponent,0x1a5576fc,0x0e19,0x11d3,0x9d,0x8e,0x00,0xc0,0x4f,0x72,0xd9,0x80);
DEFINE_GUID(IID_IComponents,0xfcd01846,0x0e19,0x11d3,0x9d,0x8e,0x00,0xc0,0x4f,0x72,0xd9,0x80);
DEFINE_GUID(IID_IComponentType,0x6a340dc0,0x0311,0x11d3,0x9d,0x8e,0x00,0xc0,0x4f,0x72,0xd9,0x80);
DEFINE_GUID(IID_IComponentTypes,0x0dc13d4a,0x0313,0x11d3,0x9d,0x8e,0x00,0xc0,0x4f,0x72,0xd9,0x80);
DEFINE_GUID(IID_IConfigAviMux,0x5acd6aa0,0xf482,0x11ce,0x8b,0x67,0x00,0xaa,0x00,0xa3,0xf1,0xa6);
DEFINE_GUID(IID_IConfigInterleaving,0xbee3d220,0x157b,0x11d0,0xbd,0x23,0x00,0xa0,0xc9,0x11,0xce,0x86);
DEFINE_GUID(IID_ICreateDevEnum,0x29840822,0x5b84,0x11d0,0xbd,0x3b,0x00,0xa0,0xc9,0x11,0xce,0x86);
DEFINE_GUID(IID_ICreatePropBagOnRegKey,0x8a674b48,0x1f63,0x11d3,0xb6,0x4c,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IDDrawExclModeVideo,0x153acc21,0xd83b,0x11d1,0x82,0xbf,0x00,0xa0,0xc9,0x69,0x6c,0x8f);
DEFINE_GUID(IID_IDDrawExclModeVideoCallback,0x913c24a0,0x20ab,0x11d2,0x90,0x38,0x00,0xa0,0xc9,0x69,0x72,0x98);
DEFINE_GUID(IID_IDDVideoPortContainer,0x6c142760,0xa733,0x11ce,0xa5,0x21,0x00,0x20,0xaf,0x0b,0xe5,0x60);
DEFINE_GUID(IID_IDecimateVideoImage,0x2e5ea3e0,0xe924,0x11d2,0xb6,0xda,0x00,0xa0,0xc9,0x95,0xe8,0xdf);
DEFINE_GUID(IID_IDeferredCommand,0x56a868b8,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IDirectDraw,0x6c14db80,0xa733,0x11ce,0xa5,0x21,0x00,0x20,0xaf,0x0b,0xe5,0x60);
DEFINE_GUID(IID_IDirectDraw2,0xb3a6f3e0,0x2b43,0x11cf,0xa2,0xde,0x00,0xaa,0x00,0xb9,0x33,0x56);
DEFINE_GUID(IID_IDirectDrawClipper,0x6c14db85,0xa733,0x11ce,0xa5,0x21,0x00,0x20,0xaf,0x0b,0xe5,0x60);
DEFINE_GUID(IID_IDirectDrawColorControl,0x4b9f0ee0,0x0d7e,0x11d0,0x9b,0x06,0x00,0xa0,0xc9,0x03,0xa3,0xb8);
DEFINE_GUID(IID_IDirectDrawKernel,0x8d56c120,0x6a08,0x11d0,0x9b,0x06,0x00,0xa0,0xc9,0x03,0xa3,0xb8);
DEFINE_GUID(IID_IDirectDrawMediaSample,0xab6b4afe,0xf6e4,0x11d0,0x90,0x0d,0x00,0xc0,0x4f,0xd9,0x18,0x9d);
DEFINE_GUID(IID_IDirectDrawMediaSampleAllocator,0xab6b4afc,0xf6e4,0x11d0,0x90,0x0d,0x00,0xc0,0x4f,0xd9,0x18,0x9d);
DEFINE_GUID(IID_IDirectDrawMediaStream,0xf4104fce,0x9a70,0x11d0,0x8f,0xde,0x00,0xc0,0x4f,0xd9,0x18,0x9d);
DEFINE_GUID(IID_IDirectDrawPalette,0x6c14db84,0xa733,0x11ce,0xa5,0x21,0x00,0x20,0xaf,0x0b,0xe5,0x60);
DEFINE_GUID(IID_IDirectDrawStreamSample,0xf4104fcf,0x9a70,0x11d0,0x8f,0xde,0x00,0xc0,0x4f,0xd9,0x18,0x9d);
DEFINE_GUID(IID_IDirectDrawSurface,0x6c14db81,0xa733,0x11ce,0xa5,0x21,0x00,0x20,0xaf,0x0b,0xe5,0x60);
DEFINE_GUID(IID_IDirectDrawSurface2,0x57805885,0x6eec,0x11cf,0x94,0x41,0xa8,0x23,0x03,0xc1,0x0e,0x27);
DEFINE_GUID(IID_IDirectDrawSurface3,0xda044e00,0x69b2,0x11d0,0xa1,0xd5,0x00,0xaa,0x00,0xb8,0xdf,0xbb);
DEFINE_GUID(IID_IDirectDrawSurface4,0x0b2b8630,0xad35,0x11d0,0x8e,0xa6,0x00,0x60,0x97,0x97,0xea,0x5b);
DEFINE_GUID(IID_IDirectDrawSurface7,0x06675a80,0x3b9b,0x11d2,0xb9,0x2f,0x00,0x60,0x97,0x97,0xea,0x5b);
DEFINE_GUID(IID_IDirectDrawSurfaceKernel,0x60755da0,0x6a40,0x11d0,0x9b,0x06,0x00,0xa0,0xc9,0x03,0xa3,0xb8);
DEFINE_GUID(IID_IDirectDrawVideo,0x36d39eb0,0xdd75,0x11ce,0xbf,0x0e,0x00,0xaa,0x00,0x55,0x59,0x5a);
DEFINE_GUID(IID_IDirectShowStream,0x7db01c96,0xc0c3,0x11d0,0x8f,0xf1,0x00,0xc0,0x4f,0xd9,0x18,0x9d);
DEFINE_GUID(IID_IDistributorNotify,0x56a868af,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IDrawVideoImage,0x48efb120,0xab49,0x11d2,0xae,0xd2,0x00,0xa0,0xc9,0x95,0xe8,0xd5);
DEFINE_GUID(IID_IDTFilter,0xc4c4c4b2,0x49,0x4e2b,0x98,0xfb,0x95,0x37,0xf6,0xce,0x51,0x6d);
DEFINE_GUID(IID_IDTFilterConfig,0xc4c4c4d2,0x49,0x4e2b,0x98,0xfb,0x95,0x37,0xf6,0xce,0x51,0x6d);
DEFINE_GUID(IID_IDVBCLocator,0x6e42f36e,0x1dd2,0x43c4,0x9f,0x78,0x69,0xd2,0x5a,0xe3,0x90,0x34);
DEFINE_GUID(IID_IDVBSLocator,0x3d7c353c,0x0d04,0x45f1,0xa7,0x42,0xf9,0x7c,0xc1,0x18,0x8d,0xc8);
DEFINE_GUID(IID_IDVBSTuningSpace,0xcdf7be60,0xd954,0x42fd,0xa9,0x72,0x78,0x97,0x19,0x58,0xe4,0x70);
DEFINE_GUID(IID_IDVBTLocator,0x8664da16,0xdda2,0x42ac,0x92,0x6a,0xc1,0x8f,0x91,0x27,0xc3,0x02);
DEFINE_GUID(IID_IDVBTuneRequest,0x0d6f567e,0xa636,0x42bb,0x83,0xba,0xce,0x4c,0x17,0x04,0xaf,0xa2);
DEFINE_GUID(IID_IDVBTuningSpace,0xada0b268,0x3b19,0x4e5b,0xac,0xc4,0x49,0xf8,0x52,0xbe,0x13,0xba);
DEFINE_GUID(IID_IDVBTuningSpace2,0x843188b4,0xce62,0x43db,0x96,0x6b,0x81,0x45,0xa0,0x94,0xe0,0x40);
DEFINE_GUID(IID_IDvdCmd,0x5a4a97e4,0x94ee,0x4a55,0x97,0x51,0x74,0xb5,0x64,0x3a,0xa2,0x7d);
DEFINE_GUID(IID_IDvdControl,0xa70efe61,0xe2a3,0x11d0,0xa9,0xbe,0x00,0xaa,0x00,0x61,0xbe,0x93);
DEFINE_GUID(IID_IDvdControl2,0x33bc7430,0xeec0,0x11d2,0x82,0x01,0x00,0xa0,0xc9,0xd7,0x48,0x42);
DEFINE_GUID(IID_IDvdGraphBuilder,0xfcc152b6,0xf372,0x11d0,0x8e,0x00,0x00,0xc0,0x4f,0xd7,0xc0,0x8b);
DEFINE_GUID(IID_IDvdInfo,0xa70efe60,0xe2a3,0x11d0,0xa9,0xbe,0x00,0xaa,0x00,0x61,0xbe,0x93);
DEFINE_GUID(IID_IDvdInfo2,0x34151510,0xeec0,0x11d2,0x82,0x01,0x00,0xa0,0xc9,0xd7,0x48,0x42);
DEFINE_GUID(IID_IDvdState,0x86303d6d,0x1c4a,0x4087,0xab,0x42,0xf7,0x11,0x16,0x70,0x48,0xef);
DEFINE_GUID(IID_IDVEnc,0xd18e17a0,0xaacb,0x11d0,0xaf,0xb0,0x00,0xaa,0x00,0xb6,0x7a,0x42);
DEFINE_GUID(IID_IDVRGB219,0x58473a19,0x2bc8,0x4663,0x80,0x12,0x25,0xf8,0x1b,0xab,0xdd,0xd1);
DEFINE_GUID(IID_IDVSplitter,0x92a3a302,0xda7c,0x4a1f,0xba,0x7e,0x18,0x02,0xbb,0x5d,0x2d,0x02);
DEFINE_GUID(IID_IDxtAlphaSetter,0x4ee9ead9,0xda4d,0x43d0,0x93,0x83,0x06,0xb9,0x0c,0x08,0xb1,0x2b);
DEFINE_GUID(IID_IDxtCompositor,0xbb44391e,0x6abd,0x422f,0x9e,0x2e,0x38,0x5c,0x9d,0xff,0x51,0xfc);
DEFINE_GUID(IID_IDxtJpeg,0xde75d011,0x7a65,0x11d2,0x8c,0xea,0x00,0xa0,0xc9,0x44,0x1e,0x20);
DEFINE_GUID(IID_IDxtKey,0x3255de56,0x38fb,0x4901,0xb9,0x80,0x94,0xb4,0x38,0x01,0x0d,0x7b);
DEFINE_GUID(IID_IEncoderAPI,0x70423839,0x6acc,0x4b23,0xb0,0x79,0x21,0xdb,0xf0,0x81,0x56,0xa5);
DEFINE_GUID(IID_IEnumComponents,0x2a6e2939,0x2595,0x11d3,0xb6,0x4c,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IEnumComponentTypes,0x8a674b4a,0x1f63,0x11d3,0xb6,0x4c,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IEnumFilters,0x56a86893,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IEnumGuideDataProperties,0xae44423b,0x4571,0x475c,0xad,0x2c,0xf4,0xa,0x77,0x1d,0x80,0xef);
DEFINE_GUID(IID_IEnumMediaTypes,0x89c31040,0x846b,0x11ce,0x97,0xd3,0x00,0xaa,0x00,0x55,0x59,0x5a);
DEFINE_GUID(IID_IEnumMSVidGraphSegment,0x3dd2903e,0xe0aa,0x11d2,0xb6,0x3a,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IEnumPIDMap,0xafb6c2a2,0x2c41,0x11d3,0x8a,0x60,0x00,0x00,0xf8,0x1e,0x0e,0x4a);
DEFINE_GUID(IID_IEnumPins,0x56a86892,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IEnumRegFilters,0x56a868a4,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IEnumStreamBufferRecordingAttrib,0xc18a9162,0x1e82,0x4142,0x8c,0x73,0x56,0x90,0xfa,0x62,0xfe,0x33);
DEFINE_GUID(IID_IEnumStreamIdMap,0x945c1566,0x6202,0x46fc,0x96,0xc7,0xd8,0x7f,0x28,0x9c,0x65,0x34);
DEFINE_GUID(IID_IEnumTuneRequests,0x1993299c,0xced6,0x4788,0x87,0xa3,0x42,0,0x67,0xdc,0xe0,0xc7);
DEFINE_GUID(IID_IEnumTuningSpaces,0x8b8eb248,0xfc2b,0x11d2,0x9d,0x8c,0x00,0xc0,0x4f,0x72,0xd9,0x80);
DEFINE_GUID(IID_IETFilter,0xc4c4c4b1,0x49,0x4e2b,0x98,0xfb,0x95,0x37,0xf6,0xce,0x51,0x6d);
DEFINE_GUID(IID_IETFilterConfig,0xc4c4c4d1,0x49,0x4e2b,0x98,0xfb,0x95,0x37,0xf6,0xce,0x51,0x6d);
DEFINE_GUID(IID_IEvalRat,0xc5c5c5b1,0x3abc,0x11d6,0xb2,0x5b,0,0xc0,0x4f,0xa0,0xc0,0x26);
DEFINE_GUID(IID_IFileSinkFilter,0xa2104830,0x7c70,0x11cf,0x8b,0xce,0x00,0xaa,0x00,0xa3,0xf1,0xa6);
DEFINE_GUID(IID_IFileSinkFilter2,0x00855b90,0xce1b,0x11d0,0xbd,0x4f,0x00,0xa0,0xc9,0x11,0xce,0x86);
DEFINE_GUID(IID_IFileSourceFilter,0x56a868a6,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IFilterGraph,0x56a8689f,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IFilterGraph2,0x36b73882,0xc2c8,0x11cf,0x8b,0x46,0x00,0x80,0x5f,0x6c,0xef,0x60);
DEFINE_GUID(IID_IFilterChain,0xdcfbdcf6,0x0dc2,0x45f5,0x9a,0xb2,0x7c,0x33,0x0e,0xa0,0x9c,0x29);
DEFINE_GUID(IID_IFilterInfo,0x56a868ba,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IFilterMapper,0x56a868a3,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IFilterMapper2,0xb79bb0b0,0x33c1,0x11d1,0xab,0xe1,0x00,0xa0,0xc9,0x05,0xf3,0x75);
DEFINE_GUID(IID_IFilterMapper3,0xb79bb0b1,0x33c1,0x11d1,0xab,0xe1,0x00,0xa0,0xc9,0x05,0xf3,0x75);
DEFINE_GUID(IID_IFindCompressorCB,0xf03fa8de,0x879a,0x4d59,0x9b,0x2c,0x26,0xbb,0x1c,0xf8,0x34,0x61);
DEFINE_GUID(IID_IFrequencyMap,0x6fb45c1,0x693c,0x4ea7,0xb7,0x9f,0x7a,0x6a,0x54,0xd8,0xde,0xf2);
DEFINE_GUID(IID_IFullScreenVideo,0xdd1d7110,0x7836,0x11cf,0xbf,0x47,0x00,0xaa,0x00,0x55,0x59,0x5a);
DEFINE_GUID(IID_IFullScreenVideoEx,0x53479470,0xf1dd,0x11cf,0xbc,0x42,0x00,0xaa,0x00,0xac,0x74,0xf6);
DEFINE_GUID(IID_IGetCapabilitiesKey,0xa8809222,0x7bb,0x48ea,0x95,0x1c,0x33,0x15,0x81,0,0x62,0x5b);
DEFINE_GUID(IID_IGraphBuilder,0x56a868a9,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IGraphConfig,0x03a1eb8e,0x32bf,0x4245,0x85,0x02,0x11,0x4d,0x08,0xa9,0xcb,0x88);
DEFINE_GUID(IID_IGraphConfigCallback,0xade0fd60,0xd19d,0x11d2,0xab,0xf6,0x00,0xa0,0xc9,0x05,0xf3,0x75);
DEFINE_GUID(IID_IGraphVersion,0x56a868ab,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IGrfCache,0xae9472be,0xb0c3,0x11d2,0x8d,0x24,0x00,0xa0,0xc9,0x44,0x1e,0x20);
DEFINE_GUID(IID_IGuideData,0x61571138,0x5b01,0x43cd,0xae,0xaf,0x60,0xb7,0x84,0xa0,0xbf,0x93);
DEFINE_GUID(IID_IGuideDataEvent,0xefda0c80,0xf395,0x42c3,0x9b,0x3c,0x56,0xb3,0x7d,0xec,0x7b,0xb7);
DEFINE_GUID(IID_IGuideDataLoader,0x4764ff7c,0xfa95,0x4525,0xaf,0x4d,0xd3,0x22,0x36,0xdb,0x9e,0x38);
DEFINE_GUID(IID_IGuideDataProperty,0x88ec5e58,0xbb73,0x41d6,0x99,0xce,0x66,0xc5,0x24,0xb8,0xb5,0x91);
DEFINE_GUID(IID_IChannelTuneRequest,0x0369b4e0,0x45b6,0x11d3,0xb6,0x50,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IIPDVDec,0xb8e8bd60,0x0bfe,0x11d0,0xaf,0x91,0x00,0xaa,0x00,0xb6,0x7a,0x42);
DEFINE_GUID(IID_IKsControl,0x28f54685,0x06fd,0x11d2,0xb2,0x7a,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(IID_IKsDataTypeHandler,0x5ffbaa02,0x49a3,0x11d0,0x9f,0x36,0x00,0xaa,0x00,0xa2,0x16,0xa1);
DEFINE_GUID(IID_IKsInterfaceHandler,0xd3abc7e0,0x9a61,0x11d0,0xa4,0x0d,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(IID_IKsPin,0xb61178d1,0xa2d9,0x11cf,0x9e,0x53,0x00,0xaa,0x00,0xa2,0x16,0xa1);
DEFINE_GUID(IID_IKsPinFactory,0xcd5ebe6b,0x8b6e,0x11d1,0x8a,0xe0,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(IID_IKsPropertySet,0x31efac30,0x515c,0x11d0,0xa9,0xaa,0x0,0xaa,0x0,0x61,0xbe,0x93);
DEFINE_GUID(IID_ILanguageComponentType,0xb874c8ba,0x0fa2,0x11d3,0x9d,0x8e,0x00,0xc0,0x4f,0x72,0xd9,0x80);
DEFINE_GUID(IID_ILocator,0x286d7f89,0x760c,0x4f89,0x80,0xc4,0x66,0x84,0x1d,0x25,0x07,0xaa);
DEFINE_GUID(IID_IMediaControl,0x56a868b1,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IMediaDet,0x65bd0710,0x24d2,0x4ff7,0x93,0x24,0xed,0x2e,0x5d,0x3a,0xba,0xfa);
DEFINE_GUID(IID_IMediaEvent,0x56a868b6,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IMediaEventEx,0x56a868c0,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IMediaEventSink,0x56a868a2,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IMediaFilter,0x56a86899,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IMediaLocator,0x288581e0,0x66ce,0x11d2,0x91,0x8f,0x00,0xc0,0xdf,0x10,0xd4,0x34);
DEFINE_GUID(IID_IMediaPosition,0x56a868b2,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IMediaPropertyBag,0x6025a880,0xc0d5,0x11d0,0xbd,0x4e,0x00,0xa0,0xc9,0x11,0xce,0x86);
DEFINE_GUID(IID_IMediaSample,0x56a8689a,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IMediaSample2,0x36b73884,0xc2c8,0x11cf,0x8b,0x46,0x00,0x80,0x5f,0x6c,0xef,0x60);
DEFINE_GUID(IID_IMediaSeeking,0x36b73880,0xc2c8,0x11cf,0x8b,0x46,0x00,0x80,0x5f,0x6c,0xef,0x60);
DEFINE_GUID(IID_IMediaStream,0xb502d1bd,0x9a57,0x11d0,0x8f,0xde,0x00,0xc0,0x4f,0xd9,0x18,0x9d);
DEFINE_GUID(IID_IMediaStreamFilter,0xbebe595e,0x9a6f,0x11d0,0x8f,0xde,0x00,0xc0,0x4f,0xd9,0x18,0x9d);
DEFINE_GUID(IID_IMediaTypeInfo,0x56a868bc,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IMemAllocator,0x56a8689c,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IMemAllocatorCallbackTemp,0x379a0cf0,0xc1de,0x11d2,0xab,0xf5,0x00,0xa0,0xc9,0x05,0xf3,0x75);
DEFINE_GUID(IID_IMemAllocatorNotifyCallbackTemp,0x92980b30,0xc1de,0x11d2,0xab,0xf5,0x00,0xa0,0xc9,0x05,0xf3,0x75);
DEFINE_GUID(IID_IMemInputPin,0x56a8689d,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IMemoryData,0x327fc560,0xaf60,0x11d0,0x82,0x12,0x00,0xc0,0x4f,0xc3,0x2c,0x45);
DEFINE_GUID(IID_IMixerOCX,0x81a3bd32,0xdee1,0x11d1,0x85,0x8,0,0xa0,0xc9,0x1f,0x9c,0xa0);
DEFINE_GUID(IID_IMixerOCXNotify,0x81a3bd31,0xdee1,0x11d1,0x85,0x8,0,0xa0,0xc9,0x1f,0x9c,0xa0);
DEFINE_GUID(IID_IMixerPinConfig,0x593cdde1,0x0759,0x11d1,0x9e,0x69,0x00,0xc0,0x4f,0xd7,0xc1,0x5b);
DEFINE_GUID(IID_IMixerPinConfig2,0xebf47182,0x8764,0x11d1,0x9e,0x69,0x00,0xc0,0x4f,0xd7,0xc1,0x5b);
DEFINE_GUID(IID_IMPEG2_TIF_CONTROL,0xf9bac2f9,0x4149,0x4916,0xb2,0xef,0xfa,0xa2,0x2,0x32,0x68,0x62);
DEFINE_GUID(IID_IMPEG2Component,0x1493e353,0x1eb6,0x473c,0x80,0x2d,0x8e,0x6b,0x8e,0xc9,0xd2,0xa9);
DEFINE_GUID(IID_IMPEG2ComponentType,0x2c073d84,0xb51c,0x48c9,0xaa,0x9f,0x68,0x97,0x1e,0x1f,0x6e,0x38);
DEFINE_GUID(IID_IMpeg2Demultiplexer,0x436eee9c,0x264f,0x4242,0x90,0xe1,0x4e,0x33,0x0c,0x10,0x75,0x12);
DEFINE_GUID(IID_IMPEG2PIDMap,0xafb6c2a1,0x2c41,0x11d3,0x8a,0x60,0x00,0x00,0xf8,0x1e,0x0e,0x4a);
DEFINE_GUID(IID_IMPEG2StreamIdMap,0xd0e04c47,0x25b8,0x4369,0x92,0x5a,0x36,0x2a,0x01,0xd9,0x54,0x44);
DEFINE_GUID(IID_IMPEG2TuneRequest,0xeb7d987f,0x8a01,0x42ad,0xb8,0xae,0x57,0x4d,0xee,0xe4,0x4d,0x1a);
DEFINE_GUID(IID_IMPEG2TuneRequestFactory,0x14e11abd,0xee37,0x4893,0x9e,0xa1,0x69,0x64,0xde,0x93,0x3e,0x39);
DEFINE_GUID(IID_IMPEG2TuneRequestSupport,0x1b9d5fc3,0x5bbc,0x4b6c,0xbb,0x18,0xb9,0xd1,0x0e,0x3e,0xee,0xbf);
DEFINE_GUID(IID_IMpegAudioDecoder,0xb45dd570,0x3c77,0x11d1,0xab,0xe1,0x00,0xa0,0xc9,0x05,0xf3,0x75);
DEFINE_GUID(IID_IMSEventBinder,0xc3a9f406,0x2222,0x436d,0x86,0xd5,0xba,0x32,0x29,0x27,0x9e,0xfb);
DEFINE_GUID(IID_IMSVidAnalogTuner,0x1c15d47e,0x911d,0x11d2,0xb6,0x32,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidAnalogTunerEvent,0x1c15d486,0x911d,0x11d2,0xb6,0x32,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidAudioRenderer,0x37b0353f,0xa4c8,0x11d2,0xb6,0x34,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidAudioRendererDevices,0xc5702cd4,0x9b79,0x11d3,0xb6,0x54,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidAudioRendererEvent,0x37b03541,0xa4c8,0x11d2,0xb6,0x34,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidCAGSeg,0x1600d101,0x6666,0x4f66,0xb1,0xe2,0xbf,0x3c,0x9f,0xbb,0x9b,0xa6);
DEFINE_GUID(IID_IMSVidClosedCaptioning,0x99652ea1,0xc1f7,0x414f,0xbb,0x7b,0x1c,0x96,0x7d,0xe7,0x59,0x83);
DEFINE_GUID(IID_IMSVidClosedCaptioning2,0xe00cb864,0xa029,0x4310,0x99,0x87,0xa8,0x73,0xf5,0x88,0x7d,0x97);
DEFINE_GUID(IID_IMSVidCompositionSegment,0x1c15d483,0x911d,0x11d2,0xb6,0x32,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidCtl,0xb0edf162,0x910a,0x11d2,0xb6,0x32,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidDataServices,0x334125c1,0x77e5,0x11d3,0xb6,0x53,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidDataServicesEvent,0x334125c2,0x77e5,0x11d3,0xb6,0x53,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidDevice,0x1c15d47c,0x911d,0x11d2,0xb6,0x32,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidDeviceEvent,0x1c15d480,0x911d,0x11d2,0xb6,0x32,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidEncoder,0xc0020fd4,0xbee7,0x43d9,0xa4,0x95,0x9f,0x21,0x31,0x17,0x10,0x3d);
DEFINE_GUID(IID_IMSVidFeature,0x37b03547,0xa4c8,0x11d2,0xb6,0x34,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidFeatureEvent,0x3dd2903c,0xe0aa,0x11d2,0xb6,0x3a,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidFeatures,0xc5702cd5,0x9b79,0x11d3,0xb6,0x54,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidFilePlayback,0x37b03539,0xa4c8,0x11d2,0xb6,0x34,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidFilePlaybackEvent,0x37b0353a,0xa4c8,0x11d2,0xb6,0x34,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidGraphSegment,0x1c15d482,0x911d,0x11d2,0xb6,0x32,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidGraphSegmentContainer,0x3dd2903d,0xe0aa,0x11d2,0xb6,0x3a,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidGraphSegmentUserInput,0x301c060e,0x20d9,0x4587,0x9b,0x03,0xf8,0x2e,0xd9,0xa9,0x94,0x3c);
DEFINE_GUID(IID_IMSVidInputDevice,0x37b0353d,0xa4c8,0x11d2,0xb6,0x34,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidInputDeviceEvent,0x37b0353e,0xa4c8,0x11d2,0xb6,0x34,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidInputDevices,0xc5702cd1,0x9b79,0x11d3,0xb6,0x54,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidOutputDevice,0x37b03546,0xa4c8,0x11d2,0xb6,0x34,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidOutputDeviceEvent,0x2e6a14e2,0x571c,0x11d3,0xb6,0x52,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidOutputDevices,0xc5702cd2,0x9b79,0x11d3,0xb6,0x54,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidPlayback,0x37b03538,0xa4c8,0x11d2,0xb6,0x34,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidPlaybackEvent,0x37b0353b,0xa4c8,0x11d2,0xb6,0x34,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidRect,0x7f5000a6,0xa440,0x47ca,0x8a,0xcc,0xc0,0xe7,0x55,0x31,0xa2,0xc2);
DEFINE_GUID(IID_IMSVidStreamBufferRecordingControl,0x160621aa,0xbbbc,0x4326,0xa8,0x24,0xc3,0x95,0xae,0xbc,0x6e,0x74);
DEFINE_GUID(IID_IMSVidStreamBufferSink,0x159dbb45,0xcd1b,0x4dab,0x83,0xea,0x5c,0xb1,0xf4,0xf2,0x1d,0x7);
DEFINE_GUID(IID_IMSVidStreamBufferSinkEvent,0xf798a36b,0xb05b,0x4bbe,0x97,0x3,0xea,0xea,0x7d,0x61,0xcd,0x51);
DEFINE_GUID(IID_IMSVidStreamBufferSource,0xeb0c8cf9,0x6950,0x4772,0x87,0xb1,0x47,0xd1,0x1c,0xf3,0xa0,0x2f);
DEFINE_GUID(IID_IMSVidStreamBufferSourceEvent,0x50ce8a7d,0x9c28,0x4da8,0x90,0x42,0xcd,0xfa,0x71,0x16,0xf9,0x79);
DEFINE_GUID(IID_IMSVidTuner,0x1c15d47d,0x911d,0x11d2,0xb6,0x32,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidTunerEvent,0x1c15d485,0x911d,0x11d2,0xb6,0x32,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidTVEGSeg,0x1600d001,0x6666,0x4f66,0xb1,0xe2,0xbf,0x3c,0x9f,0xbb,0x9b,0xa6);
DEFINE_GUID(IID_IMSVidVideoInputDevice,0x1c15d47f,0x911d,0x11d2,0xb6,0x32,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidVideoRenderer,0x37b03540,0xa4c8,0x11d2,0xb6,0x34,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidVideoRenderer2,0x6bdd5c1e,0x2810,0x4159,0x94,0xbc,0x5,0x51,0x1a,0xe8,0x54,0x9b);
DEFINE_GUID(IID_IMSVidVideoRendererDevices,0xc5702cd3,0x9b79,0x11d3,0xb6,0x54,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidVideoRendererEvent,0x37b03545,0xa4c8,0x11d2,0xb6,0x34,0x00,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(IID_IMSVidVideoRendererEvent2,0x7145ed66,0x4730,0x4fdb,0x8a,0x53,0xfd,0xe7,0x50,0x8d,0x3e,0x5e);
DEFINE_GUID(IID_IMSVidVRGraphSegment,0xdd47de3f,0x9874,0x4f7b,0x8b,0x22,0x7c,0xb2,0x68,0x84,0x61,0xe7);
DEFINE_GUID(IID_IMSVidWebDVD,0xcf45f88b,0xac56,0x4ee2,0xa7,0x3a,0xed,0x04,0xe2,0x88,0x5d,0x3c);
DEFINE_GUID(IID_IMSVidWebDVDAdm,0xb8be681a,0xeb2c,0x47f0,0xb4,0x15,0x94,0xd5,0x45,0x2f,0x0e,0x05);
DEFINE_GUID(IID_IMSVidWebDVDEvent,0xb4f7a674,0x9b83,0x49cb,0xa3,0x57,0xc6,0x3b,0x87,0x1b,0xe9,0x58);
DEFINE_GUID(IID_IMSVidXDS,0x11ebc158,0xe712,0x4d1f,0x8b,0xb3,0x1,0xed,0x52,0x74,0xc4,0xce);
DEFINE_GUID(IID_IMultiMediaStream,0xb502d1bc,0x9a57,0x11d0,0x8f,0xde,0x00,0xc0,0x4f,0xd9,0x18,0x9d);
DEFINE_GUID(IID_IOverlay,0x56a868a1,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IOverlayNotify,0x56a868a0,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IOverlayNotify2,0x680efa10,0xd535,0x11d1,0x87,0xc8,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(IID_IPersistMediaPropertyBag,0x5738e040,0xb67f,0x11d0,0xbd,0x4d,0x00,0xa0,0xc9,0x11,0xce,0x86);
DEFINE_GUID(IID_IPin,0x56a86891,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IPinConnection,0x4a9a62d3,0x27d4,0x403d,0x91,0xe9,0x89,0xf5,0x40,0xe5,0x55,0x34);
DEFINE_GUID(IID_IPinFlowControl,0xc56e9858,0xdbf3,0x4f6b,0x81,0x19,0x38,0x4a,0xf2,0x06,0x0d,0xeb);
DEFINE_GUID(IID_IPinInfo,0x56a868bd,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IPropertySetter,0xae9472bd,0xb0c3,0x11d2,0x8d,0x24,0x00,0xa0,0xc9,0x44,0x1e,0x20);
DEFINE_GUID(IID_IQualityControl,0x56a868a5,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IQualProp,0x1bd0ecb0,0xf8e2,0x11ce,0xaa,0xc6,0x00,0x20,0xaf,0x0b,0x99,0xa3);
DEFINE_GUID(IID_IQueueCommand,0x56a868b7,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IReferenceClock,0x56a86897,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IReferenceClock2,0x36b73885,0xc2c8,0x11cf,0x8b,0x46,0x00,0x80,0x5f,0x6c,0xef,0x60);
DEFINE_GUID(IID_IRegFilterInfo,0x56a868bb,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IRegisterServiceProvider,0x7b3a2f01,0x0751,0x48dd,0xb5,0x56,0x00,0x47,0x85,0x17,0x1c,0x54);
DEFINE_GUID(IID_IRenderEngine,0x6bee3a81,0x66c9,0x11d2,0x91,0x8f,0x00,0xc0,0xdf,0x10,0xd4,0x34);
DEFINE_GUID(IID_IRenderEngine2,0x6bee3a82,0x66c9,0x11d2,0x91,0x8f,0,0xc0,0xdf,0x10,0xd4,0x34);
DEFINE_GUID(IID_IResize,0x4ada63a0,0x72d5,0x11d2,0x95,0x2a,0,0x60,0x8,0x18,0x40,0xbc);
DEFINE_GUID(IID_IResourceConsumer,0x56a868ad,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IResourceManager,0x56a868ac,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_ISampleGrabber,0x6b652fff,0x11fe,0x4fce,0x92,0xad,0x02,0x66,0xb5,0xd7,0xc7,0x8f);
DEFINE_GUID(IID_ISampleGrabberCB,0x0579154a,0x2b53,0x4994,0xb0,0xd0,0xe7,0x73,0x14,0x8e,0xff,0x85);
DEFINE_GUID(IID_IScanningTuner,0x1dfd0a5c,0x0284,0x11d3,0x9d,0x8e,0x00,0xc0,0x4f,0x72,0xd9,0x80);
DEFINE_GUID(IID_ISeekingPassThru,0x36b73883,0xc2c8,0x11cf,0x8b,0x46,0x00,0x80,0x5f,0x6c,0xef,0x60);
DEFINE_GUID(IID_ISignalEvents,0x85e2439e,0x0e23,0x11d3,0x9d,0x8e,0x00,0xc0,0x4f,0x72,0xd9,0x80);
DEFINE_GUID(IID_ISmartRenderEngine,0xf03fa8ce,0x879a,0x4d59,0x9b,0x2c,0x26,0xbb,0x1c,0xf8,0x34,0x61);
DEFINE_GUID(IID_IStreamBufferConfigure,0xce14dfae,0x4098,0x4af7,0xbb,0xf7,0xd6,0x51,0x1f,0x83,0x54,0x14);
DEFINE_GUID(IID_IStreamBufferInitialize,0x9ce50f2d,0x6ba7,0x40fb,0xa0,0x34,0x50,0xb1,0xa6,0x74,0xec,0x78);
DEFINE_GUID(IID_IStreamBufferMediaSeeking,0xf61f5c26,0x863d,0x4afa,0xb0,0xba,0x2f,0x81,0xdc,0x97,0x85,0x96);
DEFINE_GUID(IID_IStreamBufferRecComp,0x9e259a9b,0x8815,0x42ae,0xb0,0x9f,0x22,0x19,0x70,0xb1,0x54,0xfd);
DEFINE_GUID(IID_IStreamBufferRecordControl,0xba9b6c99,0xf3c7,0x4ff2,0x92,0xdb,0xcf,0xdd,0x48,0x51,0xbf,0x31);
DEFINE_GUID(IID_IStreamBufferRecordingAttribute,0x16ca4e03,0xfe69,0x4705,0xbd,0x41,0x5b,0x7d,0xfc,0xc,0x95,0xf3);
DEFINE_GUID(IID_IStreamBufferSink,0xafd1f242,0x7efd,0x45ee,0xba,0x4e,0x40,0x7a,0x25,0xc9,0xa7,0x7a);
DEFINE_GUID(IID_IStreamBufferSource,0x1c5bd776,0x6ced,0x4f44,0x81,0x64,0x5e,0xab,0xe,0x98,0xdb,0x12);
DEFINE_GUID(IID_IStreamBuilder,0x56a868bf,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IStreamSample,0xb502d1be,0x9a57,0x11d0,0x8f,0xde,0x00,0xc0,0x4f,0xd9,0x18,0x9d);
DEFINE_GUID(IID_ITuner,0x28c52640,0x018a,0x11d3,0x9d,0x8e,0x00,0xc0,0x4f,0x72,0xd9,0x80);
DEFINE_GUID(IID_ITuneRequest,0x07ddc146,0xfc3d,0x11d2,0x9d,0x8c,0x00,0xc0,0x4f,0x72,0xd9,0x80);
DEFINE_GUID(IID_ITuneRequestInfo,0xa3b152df,0x7a90,0x4218,0xac,0x54,0x98,0x30,0xbe,0xe8,0xc0,0xb6);
DEFINE_GUID(IID_ITunerEvents,0x68481420,0x0280,0x11d3,0x9d,0x8e,0x00,0xc0,0x4f,0x72,0xd9,0x80);
DEFINE_GUID(IID_ITuningSpace,0x061c6e30,0xe622,0x11d2,0x94,0x93,0x00,0xc0,0x4f,0x72,0xd9,0x80);
DEFINE_GUID(IID_ITuningSpaceContainer,0x5b692e84,0xe2f1,0x11d2,0x94,0x93,0x00,0xc0,0x4f,0x72,0xd9,0x80);
DEFINE_GUID(IID_ITuningSpaces,0x901284e4,0x33fe,0x4b69,0x8d,0x63,0x63,0x4a,0x59,0x6f,0x37,0x56);
DEFINE_GUID(IID_ITVEAttrMap,0x05500121,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVEAttrTimeQ,0x05500122,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVECBAnnc,0x05500141,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVECBDummy,0x05500144,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVECBFile,0x05500143,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVECBTrig,0x05500142,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVEEnhancement,0x05500104,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVEEnhancement_Helper,0x05500204,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVEEnhancements,0x05500114,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVEFeature,0x05500305,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVEFile,0x05500151,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVEFilter,0x05500180,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVEFilter_Helper,0x05500280,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVEMCast,0x05500130,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVEMCastCallback,0x05500133,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVEMCastManager,0x05500132,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVEMCastManager_Helper,0x05500232,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVEMCasts,0x05500131,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVENavAid,0x05500160,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVENavAid_Helper,0x05500260,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVENavAid_NoVidCtl,0x05500360,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVEService,0x05500105,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVEService_Helper,0x05500205,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVEServices,0x05500115,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVESupervisor,0x05500106,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVESupervisor_Helper,0x05500206,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVESupervisorGITProxy,0x05500306,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVETrack,0x05500102,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVETrack_Helper,0x05500202,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVETracks,0x05500112,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVETrigger,0x05500101,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVETrigger_Helper,0x05500201,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVETriggerCtrl,0x05500190,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVETriggerCtrl_Helper,0x05500191,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVEVariation,0x05500103,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVEVariation_Helper,0x05500203,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_ITVEVariations,0x05500113,0xfaa5,0x4df9,0x82,0x46,0xbf,0xc2,0x3a,0xc5,0xce,0xa8);
DEFINE_GUID(IID_IVideoEncoder,0x2997c3b,0x8e1b,0x460e,0x92,0x70,0x54,0x5e,0xd,0xe9,0x56,0x3e);
DEFINE_GUID(IID_IVideoFrameStep,0xe46a9787,0x2b71,0x444d,0xa4,0xb5,0x1f,0xab,0x7b,0x70,0x8d,0x6a);
DEFINE_GUID(IID_IVideoWindow,0x56a868b4,0x0ad4,0x11ce,0xb0,0x3a,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(IID_IVMRAspectRatioControl,0xede80b5c,0xbad6,0x4623,0xb5,0x37,0x65,0x58,0x6c,0x9f,0x8d,0xfd);
DEFINE_GUID(IID_IVMRAspectRatioControl9,0xd96c29,0xbbde,0x4efc,0x99,0x1,0xbb,0x50,0x36,0x39,0x21,0x46);
DEFINE_GUID(IID_IVMRDeinterlaceControl,0xbb057577,0xdb8,0x4e6a,0x87,0xa7,0x1a,0x8c,0x9a,0x50,0x5a,0xf);
DEFINE_GUID(IID_IVMRDeinterlaceControl9,0xa215fb8d,0x13c2,0x4f7f,0x99,0x3c,0,0x3d,0x62,0x71,0xa4,0x59);
DEFINE_GUID(IID_IVMRFilterConfig,0x9e5530c5,0x7034,0x48b4,0xbb,0x46,0x0b,0x8a,0x6e,0xfc,0x8e,0x36);
DEFINE_GUID(IID_IVMRFilterConfig9,0x5a804648,0x4f66,0x4867,0x9c,0x43,0x4f,0x5c,0x82,0x2c,0xf1,0xb8);
DEFINE_GUID(IID_IVMRImageCompositor,0x7a4fb5af,0x479f,0x4074,0xbb,0x40,0xce,0x67,0x22,0xe4,0x3c,0x82);
DEFINE_GUID(IID_IVMRImageCompositor9,0x4a5c89eb,0xdf51,0x4654,0xac,0x2a,0xe4,0x8e,0x2,0xbb,0xab,0xf6);
DEFINE_GUID(IID_IVMRImagePresenter,0xce704fe7,0xe71e,0x41fb,0xba,0xa2,0xc4,0x40,0x3e,0x11,0x82,0xf5);
DEFINE_GUID(IID_IVMRImagePresenter9,0x69188c61,0x12a3,0x40f0,0x8f,0xfc,0x34,0x2e,0x7b,0x43,0x3f,0xd7);
DEFINE_GUID(IID_IVMRImagePresenterConfig,0x9f3a1c85,0x8555,0x49ba,0x93,0x5f,0xbe,0x5b,0x5b,0x29,0xd1,0x78);
DEFINE_GUID(IID_IVMRImagePresenterConfig9,0x45c15cab,0x6e22,0x420a,0x80,0x43,0xae,0x1f,0xa,0xc0,0x2c,0x7d);
DEFINE_GUID(IID_IVMRImagePresenterExclModeConfig,0xe6f7ce40,0x4673,0x44f1,0x8f,0x77,0x54,0x99,0xd6,0x8c,0xb4,0xea);
DEFINE_GUID(IID_IVMRMixerBitmap,0x1e673275,0x0257,0x40aa,0xaf,0x20,0x7c,0x60,0x8d,0x4a,0x04,0x28);
DEFINE_GUID(IID_IVMRMixerBitmap9,0xced175e5,0x1935,0x4820,0x81,0xbd,0xff,0x6a,0xd0,0xc,0x91,0x8);
DEFINE_GUID(IID_IVMRMixerControl,0x1c1a17b0,0xbed0,0x415d,0x97,0x4b,0xdc,0x66,0x96,0x13,0x15,0x99);
DEFINE_GUID(IID_IVMRMixerControl9,0x1a777eaa,0x47c8,0x4930,0xb2,0xc9,0x8f,0xee,0x1c,0x1b,0xf,0x3b);
DEFINE_GUID(IID_IVMRMonitorConfig,0x9cf0b1b6,0xfbaa,0x4b7f,0x88,0xcf,0xcf,0x1f,0x13,0x0a,0x0d,0xce);
DEFINE_GUID(IID_IVMRMonitorConfig9,0x46c2e457,0x8ba0,0x4eef,0xb8,0xb,0x6,0x80,0xf0,0x97,0x87,0x49);
DEFINE_GUID(IID_IVMRSurface,0xa9849bbe,0x9ec8,0x4263,0xb7,0x64,0x62,0x73,0x0f,0x0d,0x15,0xd0);
DEFINE_GUID(IID_IVMRSurface9,0xdfc581a1,0x6e1f,0x4c3a,0x8d,0xa,0x5e,0x97,0x92,0xea,0x2a,0xfc);
DEFINE_GUID(IID_IVMRSurfaceAllocator,0x31ce832e,0x4484,0x458b,0x8c,0xca,0xf4,0xd7,0xe3,0xdb,0x0b,0x52);
DEFINE_GUID(IID_IVMRSurfaceAllocator9,0x8d5148ea,0x3f5d,0x46cf,0x9d,0xf1,0xd1,0xb8,0x96,0xee,0xdb,0x1f);
DEFINE_GUID(IID_IVMRSurfaceAllocatorNotify,0xaada05a8,0x5a4e,0x4729,0xaf,0x0b,0xce,0xa2,0x7a,0xed,0x51,0xe2);
DEFINE_GUID(IID_IVMRSurfaceAllocatorNotify9,0xdca3f5df,0xbb3a,0x4d03,0xbd,0x81,0x84,0x61,0x4b,0xfb,0xfa,0xc);
DEFINE_GUID(IID_IVMRVideoStreamControl,0x058d1f11,0x2a54,0x4bef,0xbd,0x54,0xdf,0x70,0x66,0x26,0xb7,0x27);
DEFINE_GUID(IID_IVMRVideoStreamControl9,0xd0cfe38b,0x93e7,0x4772,0x89,0x57,0x4,0,0xc4,0x9a,0x44,0x85);
DEFINE_GUID(IID_IVMRWindowlessControl,0x0eb1088c,0x4dcd,0x46f0,0x87,0x8f,0x39,0xda,0xe8,0x6a,0x51,0xb7);
DEFINE_GUID(IID_IVMRWindowlessControl9,0x8f537d09,0xf85e,0x4414,0xb2,0x3b,0x50,0x2e,0x54,0xc7,0x99,0x27);
DEFINE_GUID(IID_IVPConfig,0xbc29a660,0x30e3,0x11d0,0x9e,0x69,0x00,0xc0,0x4f,0xd7,0xc1,0x5b);
DEFINE_GUID(IID_IVPManager,0xaac18c18,0xe186,0x46d2,0x82,0x5d,0xa1,0xf8,0xdc,0x8e,0x39,0x5a);
DEFINE_GUID(IID_IVPControl,0x25df12c1,0x3de0,0x11d1,0x9e,0x69,0x00,0xc0,0x4f,0xd7,0xc1,0x5b);
DEFINE_GUID(IID_IVPNotify,0xc76794a1,0xd6c5,0x11d0,0x9e,0x69,0x00,0xc0,0x4f,0xd7,0xc1,0x5b);
DEFINE_GUID(IID_IVPNotify2,0xebf47183,0x8764,0x11d1,0x9e,0x69,0x00,0xc0,0x4f,0xd7,0xc1,0x5b);
DEFINE_GUID(IID_IVPObject,0xce292862,0xfc88,0x11d0,0x9e,0x69,0x00,0xc0,0x4f,0xd7,0xc1,0x5b);
DEFINE_GUID(IID_IVPVBIConfig,0xec529b00,0x1a1f,0x11d1,0xba,0xd9,0x00,0x60,0x97,0x44,0x11,0x1a);
DEFINE_GUID(IID_IVPVBINotify,0xec529b01,0x1a1f,0x11d1,0xba,0xd9,0x00,0x60,0x97,0x44,0x11,0x1a);
DEFINE_GUID(IID_IVPVBIObject,0x814b9802,0x1c88,0x11d1,0xba,0xd9,0x00,0x60,0x97,0x44,0x11,0x1a);
DEFINE_GUID(IID_IXDSCodec,0xc4c4c4b3,0x49,0x4e2b,0x98,0xfb,0x95,0x37,0xf6,0xce,0x51,0x6d);
DEFINE_GUID(IID_IXDSCodecConfig,0xc4c4c4d3,0x49,0x4e2b,0x98,0xfb,0x95,0x37,0xf6,0xce,0x51,0x6d);
DEFINE_GUID(IID_IXDSToRat,0xc5c5c5b0,0x3abc,0x11d6,0xb2,0x5b,0,0xc0,0x4f,0xa0,0xc0,0x26);
DEFINE_GUID(IID_IXml2Dex,0x18c628ed,0x962a,0x11d2,0x8d,0x08,0x00,0xa0,0xc9,0x44,0x1e,0x20);
DEFINE_GUID(LIBID_DexterLib,0x78530b68,0x61f9,0x11d2,0x8c,0xad,0,0xa0,0x24,0x58,0x9,0x2);
DEFINE_GUID(LIBID_DirectShowStreamLib,0x4e6cde29,0xc0c4,0x11d0,0x8f,0xf1,0,0xc0,0x4f,0xd9,0x18,0x9d);
DEFINE_GUID(LIBID_EncDec,0xc4c4c400,0x49,0x4e2b,0x98,0xfb,0x95,0x37,0xf6,0xce,0x51,0x6d);
DEFINE_GUID(LIBID_MSTvCALib,0x11166000,0xdf8a,0x463a,0xb6,0x20,0x7b,0xec,0x23,0x54,0x20,0x10);
DEFINE_GUID(LIBID_MSTvELib,0x1700c001,0x6666,0x4f66,0xb1,0xe2,0xbf,0x3c,0x9f,0xbb,0x9b,0xa6);
DEFINE_GUID(LIBID_MSVidCtlLib,0xb0edf154,0x910a,0x11d2,0xb6,0x32,0,0xc0,0x4f,0x79,0x49,0x8e);
DEFINE_GUID(LIBID_PSISLOADLib,0x8224a083,0x7f8c,0x432d,0xb8,0x3e,0x3c,0x5e,0x9b,0xde,0x35,0x28);
DEFINE_GUID(LIBID_QuartzTypeLib,0x56a868b0,0xad4,0x11ce,0xb0,0x3a,0,0x20,0xaf,0xb,0xa7,0x70);
DEFINE_GUID(LIBID_TunerLib,0x9b085638,0x18e,0x11d3,0x9d,0x8e,0,0xc0,0x4f,0x72,0xd9,0x80);
DEFINE_GUID(LIBID_TVRATINGSLib,0xc5c5c500,0x3abc,0x11d6,0xb2,0x5b,0,0xc0,0x4f,0xa0,0xc0,0x26);
DEFINE_GUID(LOOK_DOWNSTREAM_ONLY,0xac798be1,0x98e3,0x11d1,0xb3,0xf1,0x00,0xaa,0x00,0x37,0x61,0xc5);
DEFINE_GUID(LOOK_UPSTREAM_ONLY,0xac798be0,0x98e3,0x11d1,0xb3,0xf1,0x00,0xaa,0x00,0x37,0x61,0xc5);
DEFINE_GUID(MEDIASUBTYPE_A2B10G10R10,0x576f7893,0xbdf6,0x48c4,0x87,0x5f,0xae,0x7b,0x81,0x83,0x45,0x67);
DEFINE_GUID(MEDIASUBTYPE_A2R10G10B10,0x2f8bb76d,0xb644,0x4550,0xac,0xf3,0xd3,0xc,0xaa,0x65,0xd5,0xc5);
DEFINE_GUID(MEDIASUBTYPE_AI44,0x34344941,0,0x10,0x80,0,0,0xaa,0,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_AIFF,0xe436eb8d,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(MEDIASUBTYPE_AnalogVideo_NTSC_M,0x0482dde2,0x7817,0x11cf,0x8a,0x03,0x00,0xaa,0x00,0x6e,0xcb,0x65);
DEFINE_GUID(MEDIASUBTYPE_AnalogVideo_PAL_B,0x0482dde5,0x7817,0x11cf,0x8a,0x03,0x00,0xaa,0x00,0x6e,0xcb,0x65);
DEFINE_GUID(MEDIASUBTYPE_AnalogVideo_PAL_D,0x0482dde6,0x7817,0x11cf,0x8a,0x03,0x00,0xaa,0x00,0x6e,0xcb,0x65);
DEFINE_GUID(MEDIASUBTYPE_AnalogVideo_PAL_G,0x0482dde7,0x7817,0x11cf,0x8a,0x03,0x00,0xaa,0x00,0x6e,0xcb,0x65);
DEFINE_GUID(MEDIASUBTYPE_AnalogVideo_PAL_H,0x0482dde8,0x7817,0x11cf,0x8a,0x03,0x00,0xaa,0x00,0x6e,0xcb,0x65);
DEFINE_GUID(MEDIASUBTYPE_AnalogVideo_PAL_I,0x0482dde9,0x7817,0x11cf,0x8a,0x03,0x00,0xaa,0x00,0x6e,0xcb,0x65);
DEFINE_GUID(MEDIASUBTYPE_AnalogVideo_PAL_M,0x0482ddea,0x7817,0x11cf,0x8a,0x03,0x00,0xaa,0x00,0x6e,0xcb,0x65);
DEFINE_GUID(MEDIASUBTYPE_AnalogVideo_PAL_N,0x0482ddeb,0x7817,0x11cf,0x8a,0x03,0x00,0xaa,0x00,0x6e,0xcb,0x65);
DEFINE_GUID(MEDIASUBTYPE_AnalogVideo_PAL_N_COMBO,0x0482ddec,0x7817,0x11cf,0x8a,0x03,0x00,0xaa,0x00,0x6e,0xcb,0x65);
DEFINE_GUID(MEDIASUBTYPE_AnalogVideo_SECAM_B,0x0482ddf0,0x7817,0x11cf,0x8a,0x03,0x00,0xaa,0x00,0x6e,0xcb,0x65);
DEFINE_GUID(MEDIASUBTYPE_AnalogVideo_SECAM_D,0x0482ddf1,0x7817,0x11cf,0x8a,0x03,0x00,0xaa,0x00,0x6e,0xcb,0x65);
DEFINE_GUID(MEDIASUBTYPE_AnalogVideo_SECAM_G,0x0482ddf2,0x7817,0x11cf,0x8a,0x03,0x00,0xaa,0x00,0x6e,0xcb,0x65);
DEFINE_GUID(MEDIASUBTYPE_AnalogVideo_SECAM_H,0x0482ddf3,0x7817,0x11cf,0x8a,0x03,0x00,0xaa,0x00,0x6e,0xcb,0x65);
DEFINE_GUID(MEDIASUBTYPE_AnalogVideo_SECAM_K,0x0482ddf4,0x7817,0x11cf,0x8a,0x03,0x00,0xaa,0x00,0x6e,0xcb,0x65);
DEFINE_GUID(MEDIASUBTYPE_AnalogVideo_SECAM_K1,0x0482ddf5,0x7817,0x11cf,0x8a,0x03,0x00,0xaa,0x00,0x6e,0xcb,0x65);
DEFINE_GUID(MEDIASUBTYPE_AnalogVideo_SECAM_L,0x0482ddf6,0x7817,0x11cf,0x8a,0x03,0x00,0xaa,0x00,0x6e,0xcb,0x65);
DEFINE_GUID(MEDIASUBTYPE_ARGB1555,0x297c55af,0xe209,0x4cb3,0xb7,0x57,0xc7,0x6d,0x6b,0x9c,0x88,0xa8);
DEFINE_GUID(MEDIASUBTYPE_ARGB1555_D3D_DX7_RT,0x35314137,0,0x10,0x80,0,0,0xaa,0,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_ARGB1555_D3D_DX9_RT,0x35314139,0,0x10,0x80,0,0,0xaa,0,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_ARGB32,0x773c9ac0,0x3274,0x11d0,0xb7,0x24,0x00,0xaa,0x00,0x6c,0x1a,0x01);
DEFINE_GUID(MEDIASUBTYPE_ARGB32_D3D_DX7_RT,0x38384137,0,0x10,0x80,0,0,0xaa,0,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_ARGB32_D3D_DX9_RT,0x38384139,0,0x10,0x80,0,0,0xaa,0,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_ARGB4444,0x6e6415e6,0x5c24,0x425f,0x93,0xcd,0x80,0x10,0x2b,0x3d,0x1c,0xca);
DEFINE_GUID(MEDIASUBTYPE_ARGB4444_D3D_DX7_RT,0x34344137,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_ARGB4444_D3D_DX9_RT,0x34344139,0,0x10,0x80,0,0,0xaa,0,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_Asf,0x3db80f90,0x9412,0x11d1,0xad,0xed,0x00,0x00,0xf8,0x75,0x4b,0x99);
DEFINE_GUID(MEDIASUBTYPE_ATSC_SI,0xb3c7397c,0xd303,0x414d,0xb3,0x3c,0x4e,0xd2,0xc9,0xd2,0x97,0x33);
DEFINE_GUID(MEDIASUBTYPE_AU,0xe436eb8c,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(MEDIASUBTYPE_Avi,0xe436eb88,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(MEDIASUBTYPE_AYUV,0x56555941,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_CFCC,0x43434643,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_CLJR,0x524a4c43,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_CLPL,0x4c504c43,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_CPLA,0x414c5043,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_DOLBY_AC3,0xe06d802c,0xdb46,0x11cf,0xb4,0xd1,0x00,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(MEDIASUBTYPE_DOLBY_AC3_SPDIF,0x00000092,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_DRM_Audio,0x00000009,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_DssAudio,0xa0af4f82,0xe163,0x11d0,0xba,0xd9,0x00,0x60,0x97,0x44,0x11,0x1a);
DEFINE_GUID(MEDIASUBTYPE_DssVideo,0xa0af4f81,0xe163,0x11d0,0xba,0xd9,0x00,0x60,0x97,0x44,0x11,0x1a);
DEFINE_GUID(MEDIASUBTYPE_DTS,0xe06d8033,0xdb46,0x11cf,0xb4,0xd1,0x00,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(MEDIASUBTYPE_dv25,0x35327664,0,0x10,0x80,0,0,0xaa,0,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_dv50,0x30357664,0,0x10,0x80,0,0,0xaa,0,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_DVB_SI,0xe9dd31a3,0x221d,0x4adb,0x85,0x32,0x9a,0xf3,0x9,0xc1,0xa4,0x8);
DEFINE_GUID(MEDIASUBTYPE_DVCS,0x53435644,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_DVD_LPCM_AUDIO,0xe06d8032,0xdb46,0x11cf,0xb4,0xd1,0x00,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(MEDIASUBTYPE_DVD_NAVIGATION_DSI,0xe06d8030,0xdb46,0x11cf,0xb4,0xd1,0x00,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(MEDIASUBTYPE_DVD_NAVIGATION_PCI,0xe06d802f,0xdb46,0x11cf,0xb4,0xd1,0x00,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(MEDIASUBTYPE_DVD_NAVIGATION_PROVIDER,0xe06d8031,0xdb46,0x11cf,0xb4,0xd1,0x00,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(MEDIASUBTYPE_DVD_SUBPICTURE,0xe06d802d,0xdb46,0x11cf,0xb4,0xd1,0x00,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(MEDIASUBTYPE_dvh1,0x31687664,0,0x10,0x80,0,0,0xaa,0,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_dvhd,0x64687664,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_dvsd,0x64737664,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_DVSD,0x44535644,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_dvsl,0x6c737664,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_IA44,0x34344149,0,0x10,0x80,0,0,0xaa,0,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_IEEE_FLOAT,0x00000003,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_IF09,0x39304649,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_IJPG,0x47504a49,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_IYUV,0x56555949,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_IMC1,0x31434d49,0,0x10,0x80,0,0,0xaa,0,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_IMC2,0x32434d49,0,0x10,0x80,0,0,0xaa,0,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_IMC3,0x33434d49,0,0x10,0x80,0,0,0xaa,0,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_IMC4,0x34434d49,0,0x10,0x80,0,0,0xaa,0,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_Line21_BytePair,0x6e8d4a22,0x310c,0x11d0,0xb7,0x9a,0x00,0xaa,0x00,0x37,0x67,0xa7);
DEFINE_GUID(MEDIASUBTYPE_Line21_GOPPacket,0x6e8d4a23,0x310c,0x11d0,0xb7,0x9a,0x00,0xaa,0x00,0x37,0x67,0xa7);
DEFINE_GUID(MEDIASUBTYPE_Line21_VBIRawData,0x6e8d4a24,0x310c,0x11d0,0xb7,0x9a,0x00,0xaa,0x00,0x37,0x67,0xa7);
DEFINE_GUID(MEDIASUBTYPE_MDVF,0x4656444d,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_MJPG,0x47504a4d,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_MPEG1Audio,0xe436eb87,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(MEDIASUBTYPE_MPEG1AudioPayload,0x00000050,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_MPEG1Packet,0xe436eb80,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(MEDIASUBTYPE_MPEG1Payload,0xe436eb81,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(MEDIASUBTYPE_MPEG1System,0xe436eb84,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(MEDIASUBTYPE_MPEG1Video,0xe436eb86,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(MEDIASUBTYPE_MPEG1VideoCD,0xe436eb85,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(MEDIASUBTYPE_MPEG2_AUDIO,0xe06d802b,0xdb46,0x11cf,0xb4,0xd1,0x00,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(MEDIASUBTYPE_MPEG2_PROGRAM,0xe06d8022,0xdb46,0x11cf,0xb4,0xd1,0x00,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(MEDIASUBTYPE_MPEG2_TRANSPORT,0xe06d8023,0xdb46,0x11cf,0xb4,0xd1,0x00,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(MEDIASUBTYPE_MPEG2_TRANSPORT_STRIDE,0x138aa9a4,0x1ee2,0x4c5b,0x98,0x8e,0x19,0xab,0xfd,0xbc,0x8a,0x11);
DEFINE_GUID(MEDIASUBTYPE_MPEG2_VIDEO,0xe06d8026,0xdb46,0x11cf,0xb4,0xd1,0x00,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(MEDIASUBTYPE_MPEG2DATA,0xc892e55b,0x252d,0x42b5,0xa3,0x16,0xd9,0x97,0xe7,0xa5,0xd9,0x95);
DEFINE_GUID(MEDIASUBTYPE_None,0xe436eb8e,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(MEDIASUBTYPE_NV12,0x3231564e,0,0x10,0x80,0,0,0xaa,0,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_Overlay,0xe436eb7f,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(MEDIASUBTYPE_PCM,0x00000001,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_PCMAudio_Obsolete,0xe436eb8a,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(MEDIASUBTYPE_Plum,0x6d756c50,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_QTJpeg,0x6765706a,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_QTMovie,0xe436eb89,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(MEDIASUBTYPE_QTRle,0x20656c72,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_QTRpza,0x617a7072,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_QTSmc,0x20636d73,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_RAW_SPORT,0x00000240,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_RGB1,0xe436eb78,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(MEDIASUBTYPE_RGB16_D3D_DX7_RT,0x36315237,0,0x10,0x80,0,0,0xaa,0,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_RGB16_D3D_DX9_RT,0x36315239,0,0x10,0x80,0,0,0xaa,0,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_RGB24,0xe436eb7d,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(MEDIASUBTYPE_RGB32,0xe436eb7e,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(MEDIASUBTYPE_RGB32_D3D_DX7_RT,0x32335237,0,0x10,0x80,0,0,0xaa,0,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_RGB32_D3D_DX9_RT,0x32335239,0,0x10,0x80,0,0,0xaa,0,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_RGB4,0xe436eb79,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(MEDIASUBTYPE_RGB555,0xe436eb7c,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(MEDIASUBTYPE_RGB565,0xe436eb7b,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(MEDIASUBTYPE_RGB8,0xe436eb7a,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(MEDIASUBTYPE_S340,0x30343353,0,0x10,0x80,0,0,0xaa,0,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_S342,0x32343353,0,0x10,0x80,0,0,0xaa,0,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_SDDS,0xe06d8034,0xdb46,0x11cf,0xb4,0xd1,0x00,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(MEDIASUBTYPE_SPDIF_TAG_241h,0x00000241,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_TELETEXT,0xf72a76e3,0xeb0a,0x11d0,0xac,0xe4,0x00,0x00,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(MEDIASUBTYPE_TVMJ,0x4a4d5654,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_UYVY,0x59565955,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_VPVBI,0x5a9b6a41,0x1a22,0x11d1,0xba,0xd9,0x00,0x60,0x97,0x44,0x11,0x1a);
DEFINE_GUID(MEDIASUBTYPE_VPVideo,0x5a9b6a40,0x1a22,0x11d1,0xba,0xd9,0x00,0x60,0x97,0x44,0x11,0x1a);
DEFINE_GUID(MEDIASUBTYPE_WAKE,0x454b4157,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_WAVE,0xe436eb8b,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(MEDIASUBTYPE_Y211,0x31313259,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_Y411,0x31313459,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_Y41P,0x50313459,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_YUY2,0x32595559,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_YUYV,0x56595559,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_YV12,0x32315659,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_YVU9,0x39555659,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIASUBTYPE_YVYU,0x55595659,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIATYPE_AnalogAudio,0x0482dee1,0x7817,0x11cf,0x8a,0x03,0x00,0xaa,0x00,0x6e,0xcb,0x65);
DEFINE_GUID(MEDIATYPE_AnalogVideo,0x0482dde1,0x7817,0x11cf,0x8a,0x03,0x00,0xaa,0x00,0x6e,0xcb,0x65);
DEFINE_GUID(MEDIATYPE_Audio,0x73647561,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIATYPE_AUXLine21Data,0x670aea80,0x3a82,0x11d0,0xb7,0x9b,0x00,0xaa,0x00,0x37,0x67,0xa7);
DEFINE_GUID(MEDIATYPE_DVD_ENCRYPTED_PACK,0xed0b916a,0x044d,0x11d1,0xaa,0x78,0x00,0xc0,0x4f,0xc3,0x1d,0x60);
DEFINE_GUID(MEDIATYPE_DVD_NAVIGATION,0xe06d802e,0xdb46,0x11cf,0xb4,0xd1,0x00,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(MEDIATYPE_File,0x656c6966,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIATYPE_Interleaved,0x73766169,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIATYPE_LMRT,0x74726c6d,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIATYPE_Midi,0x7364696d,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIATYPE_MPEG1SystemStream,0xe436eb82,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(MEDIATYPE_MPEG2_PACK,0x36523b13,0x8ee5,0x11d1,0x8c,0xa3,0x00,0x60,0xb0,0x57,0x66,0x4a);
DEFINE_GUID(MEDIATYPE_MPEG2_PES,0xe06d8020,0xdb46,0x11cf,0xb4,0xd1,0x00,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(MEDIATYPE_MPEG2_SECTIONS,0x455f176c,0x4b06,0x47ce,0x9a,0xef,0x8c,0xae,0xf7,0x3d,0xf7,0xb5);
DEFINE_GUID(MEDIATYPE_ScriptCommand,0x73636d64,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIATYPE_Stream,0xe436eb83,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(MEDIATYPE_Text,0x73747874,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIATYPE_Timecode,0x0482dee3,0x7817,0x11cf,0x8a,0x03,0x00,0xaa,0x00,0x6e,0xcb,0x65);
DEFINE_GUID(MEDIATYPE_URL_STREAM,0x74726c6d,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(MEDIATYPE_VBI,0xf72a76e1,0xeb0a,0x11d0,0xac,0xe4,0x00,0x00,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(MEDIATYPE_Video,0x73646976,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(PIN_CATEGORY_ANALOGVIDEOIN,0xfb6c4283,0x0353,0x11d1,0x90,0x5f,0x00,0x00,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(PIN_CATEGORY_CAPTURE,0xfb6c4281,0x0353,0x11d1,0x90,0x5f,0x00,0x00,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(PIN_CATEGORY_CC,0xfb6c4289,0x0353,0x11d1,0x90,0x5f,0x00,0x00,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(PIN_CATEGORY_EDS,0xfb6c4287,0x0353,0x11d1,0x90,0x5f,0x00,0x00,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(PIN_CATEGORY_NABTS,0xfb6c4286,0x0353,0x11d1,0x90,0x5f,0x00,0x00,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(PIN_CATEGORY_PREVIEW,0xfb6c4282,0x0353,0x11d1,0x90,0x5f,0x00,0x00,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(PIN_CATEGORY_STILL,0xfb6c428a,0x0353,0x11d1,0x90,0x5f,0x00,0x00,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(PIN_CATEGORY_TELETEXT,0xfb6c4288,0x0353,0x11d1,0x90,0x5f,0x00,0x00,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(PIN_CATEGORY_TIMECODE,0xfb6c428b,0x0353,0x11d1,0x90,0x5f,0x00,0x00,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(PIN_CATEGORY_VBI,0xfb6c4284,0x0353,0x11d1,0x90,0x5f,0x00,0x00,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(PIN_CATEGORY_VIDEOPORT,0xfb6c4285,0x0353,0x11d1,0x90,0x5f,0x00,0x00,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(PIN_CATEGORY_VIDEOPORT_VBI,0xfb6c428c,0x0353,0x11d1,0x90,0x5f,0x00,0x00,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(TIME_FORMAT_BYTE,0x7b785571,0x8c82,0x11cf,0xbc,0x0c,0x00,0xaa,0x00,0xac,0x74,0xf6);
DEFINE_GUID(TIME_FORMAT_FIELD,0x7b785573,0x8c82,0x11cf,0xbc,0x0c,0x00,0xaa,0x00,0xac,0x74,0xf6);
DEFINE_GUID(TIME_FORMAT_FRAME,0x7b785570,0x8c82,0x11cf,0xbc,0x0c,0x00,0xaa,0x00,0xac,0x74,0xf6);
DEFINE_GUID(TIME_FORMAT_MEDIA_TIME,0x7b785574,0x8c82,0x11cf,0xbc,0x0c,0x00,0xaa,0x00,0xac,0x74,0xf6);
DEFINE_GUID(TIME_FORMAT_NONE,0x00000000,0x0000,0x0000,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00);
DEFINE_GUID(TIME_FORMAT_SAMPLE,0x7b785572,0x8c82,0x11cf,0xbc,0x0c,0x00,0xaa,0x00,0xac,0x74,0xf6);
