/*
 *
 * European Centre for Medium-Range Weather Forecasts: Reading
 * Differences between first guess and analysis
 *
 * Center: 98
 * Subcenter: 0
 * Parameter table version: 200
 */

TBLE2 ecmwf_200_params[] = {
{1, "Stream function difference", "m**2 s**-1", "STRFDIFF"},
{2, "Velocity potential difference", "m**2 s**-1", "VPOTDIFF"},
{3, "Potential temperature difference", "K", "PTDIFF"},
{4, "Equivalent potential temperature difference", "K", "EQPTDIFF"},
{5, "Saturated equivalent potential temperature difference", "K", "SEPTDIFF"},
{11, "U component of divergent wind difference", "m s**-1", "UDVWDIFF"},
{12, "V component of divergent wind difference", "m s**-1", "VDVWDIFF"},
{13, "U component of rotational wind difference", "m s**-1", "URTWDIFF"},
{14, "V component of rotational wind difference", "m s**-1", "VRTWDIFF"},
{21, "Unbalanced component of temperature difference", "K", "UCTPDIFF"},
{22, "Unbalanced component of logarithm of surface pressure difference", "-", "UCLNDIFF"},
{23, "Unbalanced component of divergence difference", "s**-1", "UCDVDIFF"},
{26, "Lake cover difference", "(0 - 1)", "CLDIFF"},
{27, "Low vegetation cover difference", "(0 - 1)", "CVLDIFF"},
{28, "High vegetation cover difference", "(0 - 1)", "CVHDIFF"},
{29, "Type of low vegetation difference", "-", "TVLDIFF"},
{30, "Type of high vegetation difference", "-", "TVHDIFF"},
{31, "Sea-ice cover difference", "(0 - 1)", "SICDIFF"},
{32, "Snow albedo difference", "(0 - 1)", "ASNDIFF"},
{33, "Snow density difference", "kg m**-3", "RSNDIFF"},
{34, "Sea surface temperature difference", "K", "SSTDIFF"},
{35, "Ice surface temperature layer 1 difference", "K", "ISTL1DIFF"},
{36, "Ice surface temperature layer 2 difference", "K", "ISTL2DIFF"},
{37, "Ice surface temperature layer 3 difference", "K", "ISTL3DIFF"},
{38, "Ice surface temperature layer 4 difference", "K", "ISTL4DIFF"},
{39, "Volumetric soil water layer 1 difference", "m**3 m**-3", "SWVL1DIFF"},
{40, "Volumetric soil water layer 2 difference", "m**3 m**-3", "SWVL2DIFF"},
{41, "Volumetric soil water layer 3 difference", "m**3 m**-3", "SWVL3DIFF"},
{42, "Volumetric soil water layer 4 difference", "m**3 m**-3", "SWVL4DIFF"},
{43, "Soil type difference", "-", "SLTDIFF"},
{44, "Snow evaporation difference", "kg m**-2", "ESDIFF"},
{45, "Snowmelt difference", "kg m**-2", "SMLTDIFF"},
{46, "Solar duration difference", "s", "SDURDIFF"},
{47, "Direct solar radiation difference", "J m**-2", "DSRPDIFF"},
{48, "Magnitude of surface stress difference", "N m**-2 s", "MAGSSDIFF"},
{49, "10 metre wind gust difference", "m s**-1", "10FGDIFF"},
{50, "Large-scale precipitation fraction difference", "s", "LSPFDIFF"},
{51, "Maximum 2 metre temperature difference", "K", "MX2T24DIFF"},
{52, "Minimum 2 metre temperature difference", "K", "MN2T24DIFF"},
{53, "Montgomery potential difference", "m**2 s**-2", "MONTDIFF"},
{54, "Pressure difference", "Pa", "PRESDIFF"},
{55, "Mean 2 metre temperature in the last 24 hours difference", "K", "MEAN2T24DIFF"},
{56, "Mean 2 metre dewpoint temperature in the last 24 hours difference", "K", "MN2D24DIFF"},
{57, "Downward UV radiation at the surface difference", "J m**-2", "UVBDIFF"},
{58, "Photosynthetically active radiation at the surface difference", "J m**-2", "PARDIFF"},
{59, "Convective available potential energy difference", "J kg**-1", "CAPEDIFF"},
{60, "Potential vorticity difference", "K m**2 kg**-1 s**-1", "PVDIFF"},
{61, "Total precipitation from observations difference", "Millimetres*100 + number of stations", "TPODIFF"},
{62, "Observation count difference", "-", "OBCTDIFF"},
{63, "Start time for skin temperature difference", "s", ""},
{64, "Finish time for skin temperature difference", "s", ""},
{65, "Skin temperature difference", "K", ""},
{66, "Leaf area index", "m**2 m**-2", ""},
{67, "Leaf area index", "m**2 m**-2", ""},
{68, "Minimum stomatal resistance", "s m**-1", ""},
{69, "Minimum stomatal resistance", "s m**-1", ""},
{70, "Biome cover, low vegetation", "(0 - 1)", ""},
{71, "Biome cover, high vegetation", "(0 - 1)", ""},
{78, "Total column liquid water", "kg m**-2", ""},
{79, "Total column ice water", "kg m**-2", ""},
{121, "Maximum temperature at 2 metres difference", "K", "MX2T6DIFF"},
{122, "Minimum temperature at 2 metres difference", "K", "MN2T6DIFF"},
{123, "10 metre wind gust in the last 6 hours difference", "m s**-1", "10FG6DIFF"},
{125, "Vertically integrated total energy", "J m**-2", ""},
{126, "Generic parameter for sensitive area prediction", "Various", ""},
{127, "Atmospheric tide difference", "-", "ATDIFF"},
{128, "Budget values difference", "-", "BVDIFF"},
{129, "Geopotential difference", "m**2 s**-2", "ZDIFF"},
{130, "Temperature difference", "K", "TDIFF"},
{131, "U component of wind difference", "m s**-1", "UDIFF"},
{132, "V component of wind difference", "m s**-1", "VDIFF"},
{133, "Specific humidity difference", "kg kg**-1", "QDIFF"},
{134, "Surface pressure difference", "Pa", "SPDIFF"},
{135, "Vertical velocity", "Pa s**-1", "WDIFF"},
{136, "Total column water difference", "kg m**-2", "TCWDIFF"},
{137, "Total column water vapour difference", "kg m**-2", "TCWVDIFF"},
{138, "Vorticity", "s**-1", "VODIFF"},
{139, "Soil temperature level 1 difference", "K", "STL1DIFF"},
{140, "Soil wetness level 1 difference", "kg m**-2", "SWL1DIFF"},
{141, "Snow depth difference", "m of water equivalent", "SDDIFF"},
{142, "Stratiform precipitation", "m", "LSPDIFF"},
{143, "Convective precipitation difference", "m", "CPDIFF"},
{144, "Snowfall", "m of water equivalent", "SFDIFF"},
{145, "Boundary layer dissipation difference", "J m**-2", "BLDDIFF"},
{146, "Surface sensible heat flux difference", "J m**-2", "SSHFDIFF"},
{147, "Surface latent heat flux difference", "J m**-2", "SLHFDIFF"},
{148, "Charnock difference", "-", "CHNKDIFF"},
{149, "Surface net radiation difference", "J m**-2", "SNRDIFF"},
{150, "Top net radiation difference", "-", "TNRDIFF"},
{151, "Mean sea level pressure difference", "Pa", "MSLDIFF"},
{152, "Logarithm of surface pressure difference", "kg m**-2", "LNSPDIFF"},
{153, "Short-wave heating rate difference", "K", "SWHRDIFF"},
{154, "Long-wave heating rate difference", "K", "LWHRDIFF"},
{155, "Divergence difference", "s**-1", "DDIFF"},
{156, "Height difference", "m", "GHDIFF"},
{157, "Relative humidity difference", "%", "RDIFF"},
{158, "Tendency of surface pressure difference", "Pa s**-1", "TSPDIFF"},
{159, "Boundary layer height difference", "m", "BLHDIFF"},
{160, "Standard deviation of orography difference", "-", "SDORDIFF"},
{161, "Anisotropy of sub-gridscale orography difference", "-", "ISORDIFF"},
{162, "Angle of sub-gridscale orography difference", "radians", "ANORDIFF"},
{163, "Slope of sub-gridscale orography difference", "-", "SLORDIFF"},
{164, "Total cloud cover difference", "(0 - 1)", "TCCDIFF"},
{165, "10 metre U wind component difference", "m s**-1", "10UDIFF"},
{166, "10 metre V wind component difference", "m s**-1", "10VDIFF"},
{167, "2 metre temperature difference", "K", "2TDIFF"},
{168, "2 metre dewpoint temperature difference", "K", "2DDIFF"},
{169, "Surface solar radiation downwards difference", "J m**-2", "SSRDDIFF"},
{170, "Soil temperature level 2 difference", "K", "STL2DIFF"},
{171, "Soil wetness level 2 difference", "kg m**-2", "SWL2DIFF"},
{172, "Land-sea mask difference", "(0 - 1)", "LSMDIFF"},
{173, "Surface roughness difference", "m", "SRDIFF"},
{174, "Albedo difference", "(0 - 1)", "ALDIFF"},
{175, "Surface thermal radiation downwards difference", "J m**-2", "STRDDIFF"},
{176, "Surface net solar radiation difference", "J m**-2", "SSRDIFF"},
{177, "Surface net thermal radiation difference", "J m**-2", "STRDIFF"},
{178, "Top net solar radiation difference", "J m**-2", "TSRDIFF"},
{179, "Top net thermal radiation difference", "J m**-2", "TTRDIFF"},
{180, "East-West surface stress difference", "N m**-2 s", "EWSSDIFF"},
{181, "North-South surface stress difference", "N m**-2 s", "NSSSDIFF"},
{182, "Evaporation difference", "kg m**-2", "EDIFF"},
{183, "Soil temperature level 3 difference", "K", "STL3DIFF"},
{184, "Soil wetness level 3 difference", "kg m**-2", "SWL3DIFF"},
{185, "Convective cloud cover difference", "(0 - 1)", "CCCDIFF"},
{186, "Low cloud cover difference", "(0 - 1)", "LCCDIFF"},
{187, "Medium cloud cover difference", "(0 - 1)", "MCCDIFF"},
{188, "High cloud cover difference", "(0 - 1)", "HCCDIFF"},
{189, "Sunshine duration difference", "s", "SUNDDIFF"},
{190, "East-West component of sub-gridscale orographic variance difference", "m**2", "EWOVDIFF"},
{191, "North-South component of sub-gridscale orographic variance difference", "m**2", "NSOVDIFF"},
{192, "North-West", "m**2", "NWOVDIFF"},
{193, "North-East", "m**2", "NEOVDIFF"},
{194, "Brightness temperature difference", "K", "BTMPDIFF"},
{195, "Longitudinal component of gravity wave stress difference", "N m**-2 s", "LGWSDIFF"},
{196, "Meridional component of gravity wave stress difference", "N m**-2 s", "MGWSDIFF"},
{197, "Gravity wave dissipation difference", "J m**-2", "GWDDIFF"},
{198, "Skin reservoir content difference", "kg m**-2", "SRCDIFF"},
{199, "Vegetation fraction difference", "(0 - 1)", "VEGDIFF"},
{200, "Variance of sub-gridscale orography difference", "m**2", "VSODIFF"},
{201, "Maximum temperature at 2 metres since previous post-processing difference", "K", "MX2TDIFF"},
{202, "Minimum temperature at 2 metres since previous post-processing difference", "K", "MN2TDIFF"},
{203, "Ozone mass mixing ratio difference", "kg kg**-1", "O3DIFF"},
{204, "Precipitation analysis weights difference", "-", "PAWDIFF"},
{205, "Runoff difference", "m", "RODIFF"},
{206, "Total column ozone difference", "kg m**-2", "TCO3DIFF"},
{207, "10 metre wind speed difference", "m s**-1", "10SIDIFF"},
{208, "Top net solar radiation", "J m**-2", "TSRCDIFF"},
{209, "Top net thermal radiation", "J m**-2", "TTRCDIFF"},
{210, "Surface net solar radiation", "J m**-2", "SSRCDIFF"},
{211, "Surface net thermal radiation", "J m**-2", "STRCDIFF"},
{212, "TOA incident solar radiation difference", "J m**-2", "TISRDIFF"},
{214, "Diabatic heating by radiation difference", "K", "DHRDIFF"},
{215, "Diabatic heating by vertical diffusion difference", "K", "DHVDDIFF"},
{216, "Diabatic heating by cumulus convection difference", "K", "DHCCDIFF"},
{217, "Diabatic heating large-scale condensation difference", "K", "DHLCDIFF"},
{218, "Vertical diffusion of zonal wind difference", "m s**-1", "VDZWDIFF"},
{219, "Vertical diffusion of meridional wind difference", "m s**-1", "VDMWDIFF"},
{220, "East-West gravity wave drag tendency difference", "m s**-1", "EWGDDIFF"},
{221, "North-South gravity wave drag tendency difference", "m s**-1", "NSGDDIFF"},
{222, "Convective tendency of zonal wind difference", "m s**-1", "CTZWDIFF"},
{223, "Convective tendency of meridional wind difference", "m s**-1", "CTMWDIFF"},
{224, "Vertical diffusion of humidity difference", "kg kg**-1", "VDHDIFF"},
{225, "Humidity tendency by cumulus convection difference", "kg kg**-1", "HTCCDIFF"},
{226, "Humidity tendency by large-scale condensation difference", "kg kg**-1", "HTLCDIFF"},
{227, "Change from removal of negative humidity difference", "kg kg**-1", "CRNHDIFF"},
{228, "Total precipitation difference", "m", "TPDIFF"},
{229, "Instantaneous X surface stress difference", "N m**-2", "IEWSDIFF"},
{230, "Instantaneous Y surface stress difference", "N m**-2", "INSSDIFF"},
{231, "Instantaneous surface heat flux difference", "J m**-2", "ISHFDIFF"},
{232, "Instantaneous moisture flux difference", "kg m**-2 s", "IEDIFF"},
{233, "Apparent surface humidity difference", "kg kg**-1", "ASQDIFF"},
{234, "Logarithm of surface roughness length for heat difference", "-", "LSRHDIFF"},
{235, "Skin temperature difference", "K", "SKTDIFF"},
{236, "Soil temperature level 4 difference", "K", "STL4DIFF"},
{237, "Soil wetness level 4 difference", "m", "SWL4DIFF"},
{238, "Temperature of snow layer difference", "K", "TSNDIFF"},
{239, "Convective snowfall difference", "m of water equivalent", "CSFDIFF"},
{240, "Large scale snowfall difference", "m of water equivalent", "LSFDIFF"},
{241, "Accumulated cloud fraction tendency difference", "(-1 to 1)", "ACFDIFF"},
{242, "Accumulated liquid water tendency difference", "(-1 to 1)", "ALWDIFF"},
{243, "Forecast albedo difference", "(0 - 1)", "FALDIFF"},
{244, "Forecast surface roughness difference", "m", "FSRDIFF"},
{245, "Forecast logarithm of surface roughness for heat difference", "-", "FLSRDIFF"},
{246, "Specific cloud liquid water content difference", "kg kg**-1", "CLWCDIFF"},
{247, "Specific cloud ice water content difference", "kg kg**-1", "CIWCDIFF"},
{248, "Cloud cover difference", "(0 - 1)", "CCDIFF"},
{249, "Accumulated ice water tendency difference", "(-1 to 1)", "AIWDIFF"},
{250, "Ice age difference", "(0 - 1)", "ICEDIFF"},
{251, "Adiabatic tendency of temperature difference", "K", "ATTEDIFF"},
{252, "Adiabatic tendency of humidity difference", "kg kg**-1", "ATHEDIFF"},
{253, "Adiabatic tendency of zonal wind difference", "m s**-1", "ATZEDIFF"},
{254, "Adiabatic tendency of meridional wind difference", "m s**-1", "ATMWDIFF"},
};
